  ;
; NAME:
;       ConcatenateUserInput
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
; CATEGORY:
;
;       Widgets
;
; CALLING SEQUENCE:
;
;      DaveDataConcatenate_define
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUICancel,event
widget_control,event.top,get_uvalue = pState
Concatenate_Structure=create_struct('success',0)
*(*pState).Concatenate_Structure=Concatenate_Structure
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUIAccept,event
widget_control,event.top,get_uvalue = pState

x=(*pState).x
if (size((*pState).yorig))[0] eq 1 then begin
y=(*pState).y
dy=(*pState).dy
endif else begin
y=(*pState).yorig
dy=(*pState).dyorig
endelse

for i = 0, (*pState).nplots-1 do begin
newx=x[(*pState).pointer[i]:(*pState).pointer[i+1]-1]
newy=y[(*pState).pointer[i]:(*pState).pointer[i+1]-1,*]
newdy=dy[(*pState).pointer[i]:(*pState).pointer[i+1]-1,*]
mask=(newx ge (*pState).CUIlimits[0,i]) and (newx le (*pState).CUIlimits[1,i])
indices=where(mask ne 0,count)

if (count eq 0) then begin
msg=strarr(2)
msg[0]='Error encountered in the cull of data subset number '+strtrim(string(i+1),2)
msg[1]='No data points found within the specified range'
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif 
newx=newx[indices]
newy=newy[indices,*]
newdy=newdy[indices,*]
if i eq 0 then begin
data=newy
error=newdy
vout=newx
endif else begin
data=[data,newy]
error=[error,newdy]
vout=[vout,newx]
endelse
endfor
 order=sort(vout)
 data=data[order,*]
 error=error[order,*]
 vout=vout[order]
Concatenate_Structure=create_struct('success',1,'data',data,'error',error,'vout',vout)
*(*pState).Concatenate_Structure=Concatenate_Structure
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUIdraw,event
widget_control,event.top,get_uvalue = pState

case event.type of
0:  begin       ; button press
      (*pState).mouse = event.press
      if (*pState).mouse eq 4 then begin
        (*pState).autoscale = 1
        CUIPlot,event
      endif
      if (*pState).mouse eq 1 then begin
        (*pState).xbox[0] = event.x
        (*pState).ybox[0] = event.y
        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
        empty
        (*pState).autoscale = 0
        widget_control,(*pState).win,/draw_motion_events
      endif
    end
1:  begin    ; button release
     if (*pState).mouse eq 1 then begin
      xll = (*pState).xbox[0] < (*pState).xbox[1]
      yll = (*pState).ybox[0] < (*pState).ybox[1]
      w = abs((*pState).xbox[1] - (*pState).xbox[0])
      h = abs((*pState).ybox[1] - (*pState).ybox[0])
      xur = xll + w
      yur = yll + h
      ll = convert_coord(xll,yll,/device,/to_data)
      ur = convert_coord(xur,yur,/device,/to_data)
      (*pState).xrange = [ll[0],ur[0]]
      (*pState).yrange = [ll[1],ur[1]]
      CUIplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
     if (*pState).mouse eq 4 then begin
      CUIplot,event
      (*pState).mouse = 0B
      widget_control,(*pState).win,draw_motion_events = 0
     endif
    end
2:  begin    ; mouse motion
      if (*pState).mouse eq 1 then begin
       (*pState).xbox[1] = event.x
       (*pState).ybox[1] = event.y
       xc = [(*pState).xbox[0],event.x,event.x,$
             (*pState).xbox[0],$
             (*pState).xbox[0]]
       yc = [(*pState).ybox[0],(*pState).ybox[0],$
             event.y,event.y,$
             (*pState).ybox[0]]
       wset,(*pState).winVis
       device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]
       plots,xc,yc,/device,color=4
       empty
      endif
    end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUIPlot,event
widget_control,event.top,get_uvalue = pState

if (*pState).autoscale eq 1 then begin
  xlo = min((*pState).x, max=xhi) 
  ylo = min((*pState).y, max=yhi) 
  (*pState).xrange = [xlo,xhi]
  (*pState).yrange = [ylo,yhi]
endif

 
widget_control,(*pState).PlotSlider,get_value=PS
PS-=1
        wset,(*pState).winPix

plot,(*pState).x[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1],(*pState).y[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1], $
      xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = 'X Axis', $
     ytitle = 'Y Axis', title = '',linestyle = 0, $
     thick = 3.0, psym=-4, symsize=1.0,color=fsc_color('red'),background=fsc_color('white')
errplot,(*pState).x[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1], $
        (*pState).y[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1]-(*pState).dy[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1], $
        (*pState).y[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1]+(*pState).dy[(*pState).pointer[PS]:(*pState).pointer[PS+1]-1], $
        width = 0.0,thick=3,color=fsc_color('red')

;print,'(*pState).CUIlimits ',(*pState).CUIlimits
    plots,[(*pState).CUIlimits[0,PS],(*pState).CUIlimits[0,PS]],!y.crange,linestyle = 2,thick=3,color=fsc_color('red')
    plots,[(*pState).CUIlimits[1,PS],(*pState).CUIlimits[1,PS]],!y.crange,linestyle = 2,thick=3,color=fsc_color('red')

widget_control,(*pState).LowerLimit_Value,set_value=(*pState).CUIlimits[0,PS]
widget_control,(*pState).UpperLimit_Value,set_value=(*pState).CUIlimits[1,PS]

for i=0,(*pState).nplots-1 do begin
if i ne PS then begin
oplot,(*pState).x[(*pState).pointer[i]:(*pState).pointer[i+1]-1], $
      (*pState).y[(*pState).pointer[i]:(*pState).pointer[i+1]-1], $
      linestyle = 0, thick = 3.0, psym=-4, symsize=1.0,color=fsc_color('blue')
errplot,(*pState).x[(*pState).pointer[i]:(*pState).pointer[i+1]-1], $
        (*pState).y[(*pState).pointer[i]:(*pState).pointer[i+1]-1]-(*pState).dy[(*pState).pointer[i]:(*pState).pointer[i+1]-1], $
        (*pState).y[(*pState).pointer[i]:(*pState).pointer[i+1]-1]+(*pState).dy[(*pState).pointer[i]:(*pState).pointer[i+1]-1], $
        width = 0.0,thick=3,color=fsc_color('blue')
    plots,[(*pState).CUIlimits[0,i],(*pState).CUIlimits[0,i]],!y.crange,linestyle = 2,thick=3,color=fsc_color('blue')
    plots,[(*pState).CUIlimits[1,i],(*pState).CUIlimits[1,i]],!y.crange,linestyle = 2,thick=3,color=fsc_color('blue')
endif
endfor

        wset,(*pState).winVis
        device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUIUpdate,event
widget_control,event.top,get_uvalue = pState
widget_control,(*pState).PlotSlider,get_value=PS
PS-=1
widget_control,(*pState).LowerLimit_Value,get_value=LowerLimit
LowerLimit=(float(LowerLimit))[0]
widget_control,(*pState).UpperLimit_Value,get_value=UpperLimit
UpperLimit=(float(UpperLimit))[0]

if LowerLimit gt UpperLimit then begin
msg=strarr(1)
msg[0]='Lower Limit is Greater than Upper Limit'
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif

if (((*pState).OriginalCUILimits[0,PS] gt LowerLimit) and $
     (abs((*pState).OriginalCUILimits[0,PS]-LowerLimit) gt 1e-5)) then begin
msg=strarr(1)
msg[0]='Requested Lower Limit is Outside Data Limits'
    void=dialog_message(dialog_parent=event.top,/error,msg)
widget_control,(*pState).LowerLimit_Value,set_value=(*pState).OriginalCUILimits[0,PS]
return
endif

if (((*pState).OriginalCUILimits[1,PS] lt UpperLimit) and $
     (abs((*pState).OriginalCUILimits[1,PS]-UpperLimit) gt 1e-5)) then begin
msg=strarr(1)
msg[0]='Requested Upper Limit is Outside Data Limits'
    void=dialog_message(dialog_parent=event.top,/error,msg)
widget_control,(*pState).UpperLimit_Value,set_value=(*pState).OriginalCUILimits[1,PS]
return
endif

(*pState).CUIlimits[0,PS]=LowerLimit
(*pState).CUIlimits[1,PS]=UpperLimit
CUIPlot,event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro CUIEvents,event

   CATCH, Error_status
if Error_status ne 0 then begin
catch, /cancel
msg=strarr(1)
msg[0]='Error Message from IDL: '+!ERROR_STATE.MSG
    void=dialog_message(dialog_parent=event.top,/error,msg)
return
endif


widget_control,event.top,get_uvalue = pState
uname=widget_info(event.id,/uname)
case uname of
'Plot_Select':    $
begin
CUIPlot,event
end
'CUICancel':    $
begin
CUICancel,event
end
'CUIAccept':    $
begin
CUIAccept,event
end
'CUIUpdate':    $
begin
CUIUpdate,event
end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function WD_ConcatenateUserInput,yorig,dyorig,x,pointer;,group_leader=group_leader

SY=size(yorig)

if SY[0] eq 1 then begin
 tlb = widget_base(/col,title = 'Concatenate User Input Utility')
 y=yorig
 dy=dyorig
endif else begin
  tlb = widget_base(/col,title = 'Concatenate User Input Utility.  Second Dimension Has Been Summed for Visualisation')
 y=total(yorig,2)
 dy=sqrt(total(dyorig^2,2))
endelse

xlo=min(x, max=xhi)
ylo=min(y, max=yhi)
Concatenate_Structure=create_struct('success',0)
nplots=n_elements(pointer)-1
CUIlimits=fltarr(2,nplots)
for i=0,nplots-1 do begin
CUIlimits[*,i]=[x[pointer[i]],x[pointer[i+1]-1]]
endfor
OriginalCUILimits=CUIlimits

BaseUpper = widget_base(tlb,/row)
GoldenRatio=0.5*(1.0+sqrt(5.0))
;xsize = 500 & ysize = 400
xsize = 700 & ysize = xsize/GoldenRatio
win = widget_draw(BaseUpper,xsize = xsize,ysize = ysize,/button_events, $
      event_pro = 'CUIdraw')

geom = widget_info(BaseUpper,/geometry)
newysize = geom.ysize
widget_control,win,draw_ysize = newysize

courier_hugefont = get_font_name(/huge, /courier)
courier_largefont = get_font_name(/large, /courier)

BaseLower = widget_base(tlb,/col)
BaseLower_Upper = widget_base(tlb,/col,/align_center)


msg1 = 'Enter new values in fields and press carriage return to update display'
msg2 = 'Vertical lines show lower and upper limits of desired range'
void = widget_label(BaseLower_Upper,value=msg1,font=courier_largefont)
void = widget_label(BaseLower_Upper,value=msg2,font=courier_largefont)


BaseLower_Lower = widget_base(tlb,/row,/align_center)


PlotSlider=widget_slider(BaseLower_Lower,$
              value=1,min=1,max=nplots,title='Select Sub-plot',xsize=180, $
              uname='Plot_Select',font=courier_hugefont)

LowerLimit_Value=cw_field(BaseLower_Lower,/col,title='Lower Limit',xsize=20, $
       value=strtrim(string(CUIlimits[0,0]),2),font=courier_hugefont,uname='CUIUpdate',/return_events)

UpperLimit_Value=cw_field(BaseLower_Lower,/col,title='Upper Limit',xsize=20, $
       value=strtrim(string(CUIlimits[1,0]),2),font=courier_hugefont,uname='CUIUpdate',/return_events)

void = widget_button(BaseLower_Lower,value = 'Cancel',uname = 'CUICancel',font=courier_hugefont)
void = widget_button(BaseLower_Lower,value = 'Accept',uname = 'CUIAccept',font=courier_hugefont)

centertlb,tlb
widget_control,tlb,/realize

widget_control,win,get_value = winVis
window,/free,/pixmap,xsize = xsize,ysize = newysize
winPix = !d.window

state = {winVis:winVis, $
         winPix:winPix, $
         autoscale:1, $
         xrange:[xlo,xhi], $
         yrange:[ylo,yhi], $
         xbox:[xlo,xhi], $
         ybox:[ylo,yhi], $
         mouse:0B, $
         win:win, $
         xlo:xlo, $
         xhi:xhi, $
         ylo:ylo, $
         yhi:yhi, $
         x:x, $
         y:y, $
         dy:dy, $
         yorig:yorig, $
         dyorig:dyorig, $
         nplots:nplots, $
         pointer:pointer, $
         PlotSlider:PlotSlider, $
         CUIlimits:CUIlimits, $
         LowerLimit_Value:LowerLimit_Value, $
         UpperLimit_Value:UpperLimit_Value, $
         OriginalCUILimits:OriginalCUILimits, $
         Concatenate_Structure:ptr_new(/allocate_heap)}

pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState
plot,x[pointer[0]:pointer[1]-1],y[pointer[0]:pointer[1]-1],xrange = (*pState).xrange,yrange = (*pState).yrange, $
     xstyle = 1,ystyle = 1,xtitle = 'X Axis', $
     ytitle = 'Y Axis', title = '',linestyle = 0, $
     thick = 3.0, psym=-4, symsize=1.0,color=fsc_color('red'),background=fsc_color('white')
errplot,x[pointer[0]:pointer[1]-1], $
        y[pointer[0]:pointer[1]-1]-dy[pointer[0]:pointer[1]-1], $
        y[pointer[0]:pointer[1]-1]+dy[pointer[0]:pointer[1]-1],width = 0.0,thick=3,color=fsc_color('red')

    plots,[CUIlimits[0,0],CUIlimits[0,0]],!y.crange,linestyle = 2,thick=3,color=fsc_color('red')
    plots,[CUIlimits[1,0],CUIlimits[1,0]],!y.crange,linestyle = 2,thick=3,color=fsc_color('red')


for i=1,nplots-1 do begin
oplot,x[pointer[i]:pointer[i+1]-1],y[pointer[i]:pointer[i+1]-1], $
      linestyle = 0, thick = 3.0, psym=-4, symsize=1.0,color=fsc_color('blue')
errplot,x[pointer[i]:pointer[i+1]-1], $
        y[pointer[i]:pointer[i+1]-1]-dy[pointer[i]:pointer[i+1]-1], $
        y[pointer[i]:pointer[i+1]-1]+dy[pointer[i]:pointer[i+1]-1],width = 0.0,thick=3,color=fsc_color('blue')

    plots,[CUIlimits[0,i],CUIlimits[0,i]],!y.crange,linestyle = 2,thick=3,color=fsc_color('blue')
    plots,[CUIlimits[1,i],CUIlimits[1,i]],!y.crange,linestyle = 2,thick=3,color=fsc_color('blue')
endfor

wset,(*pState).winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,(*pState).winPix]

xmanager,'WD_ConcatenateUserInput',tlb,event_handler = 'CUIEvents'

wdelete,(*pState).winPix
Concatenate_Structure=*(*pState).Concatenate_Structure
heap_free,pState
return,Concatenate_Structure
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;