;###############################################################################
; Adapted from HFBSDETSF written by R. M. Dimeo
; A simple widget interface routine to specify scale factors for detectors
; to be used in HFBS data reduction
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro wd_hfbstool_setDetSF_event,Event
  Widget_control,Event.top,get_uvalue = pState
  uname = Widget_info(Event.id,/uname)
  case Strupcase(uname) of
    'COPY': begin
      Widget_control,(*pState).f,get_value = val
      (*pState).sf = Float(val[0])+Fltarr((*pState).n)
      for i = 0,(*pState).n-1 do begin
        Widget_control,(*pState).f1[i],set_value = val
      endfor
    end
    'CANCEL': begin
      ;(*pState).sf = 1+Fltarr((*pState).n)
      (*pState).status = 0
      Widget_control,Event.top,/destroy
    end
    'ACCEPT': begin
      for i = 0,(*pState).n-1 do begin
        Widget_control,(*pState).f1[i],get_value = val
        (*pState).sf[i] = Float(val[0])
      endfor
      (*pState).status = 1
      Widget_control,Event.top,/destroy
    end
    else:
  endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function wd_hfbstool_setDetSF,group_leader = group_leader,sf = sf
  tlb = Widget_base(group_leader = group_leader,title = 'HFBS Detector scale factors', $
    /row,/modal)
  colBase1 = Widget_base(tlb,/col,/grid_layout,/base_align_right)
  n = 16
  f1 = Lonarr(n)
  if N_elements(sf) eq 0 then sf = 1+Fltarr(n)
  for i = 0,n/2-1 do begin
    strout = 'Detector #'+Strtrim(String(i+1),2)
    f1[i] = Cw_field(colBase1,xsize = 5,/row,value = Strtrim(String(sf[i]),2), $
      title = strout)
  endfor

  void = Widget_button(colBase1,value = 'Accept',uname = 'accept')
  colBase2 = Widget_base(tlb,/col,/grid_layout,/base_align_right)
  for i = n/2,n-1 do begin
    strout = 'Detector #'+Strtrim(String(i+1),2)
    f1[i] = Cw_field(colBase2,xsize = 5,/row,value = Strtrim(String(sf[i]),2), $
      title = strout)
  endfor
  void = Widget_button(colBase2,value = 'Cancel',uname = 'cancel')
  colBase3 = Widget_base(tlb,/col,/grid_layout,/base_align_right)
  f = Cw_field(colBase3,xsize = 5,/row,value = '1.0', $
    title = 'All Detectors')
  void = Widget_button(colBase3,value = 'Copy above to all',uname = 'copy')

  Widget_control,tlb,/realize

  state = {f1:f1,n:n,sf:sf,f:f,status:0}
  pState = Ptr_new(state)
  Widget_control,tlb,set_uvalue = pState

  Xmanager,'wd_hfbstool_setDetSF',tlb
  if ((*pState).status) then sf = (*pState).sf
  Ptr_free,pState
  Return,sf
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;