; $Id$
;###############################################################################
;+
; NAME:
;   wd_aboutHFBSFWS
;
; PURPOSE:
;   Implements the About HFBS Reduction dialog. Based on IDLitwdAbout.
;
; CATEGORY:
;   DAVE Widgets
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Sep 2012
;-
;###############################################################################

;===============================================================================
; wd_aboutHFBSFWS__event
;
; Purpose:
;   Event handler
pro wd_aboutHFBSFWS_event, event
  compile_opt idl2
  
  widget_control, event.id, get_uvalue=uval
  if(n_elements(uval) gt 0)then begin
     if(uval eq 'close')then  $
        widget_control, event.top, /destroy
  endif
  
end


;===============================================================================
function wd_aboutHFBSFWSGetText, type=type
  compile_opt idl2
  text = ''

  catch, iErr
  if (iErr ne 0) then begin
     catch, /cancel
     if (n_elements(lun) gt 0) then free_lun, lun, /force
     return, text
  endif

  case strupcase(type) of
     'VERSION': filename = !DAVE_AUXILIARY_DIR+'version.txt'
     'LICENSE': filename = !DAVE_AUXILIARY_DIR+'license.txt'
     'ABOUT': filename = !DAVE_AUXILIARY_DIR+'abouthfbsfws.txt'
     'BUILDDATE': filename=!DAVE_AUXILIARY_DIR+'builddate.txt'
     else: return, text
  endcase 

  ;; open file and read contents
  nlines = file_lines(filename)
  if (nlines le 0) then return, ''
  openr, lun, filename, /get_lun
  text = strarr(nlines)
  readf,lun,text
  free_lun, lun, /force

  return, text
end


;===============================================================================
;; See file header for API
;;
function  wd_aboutHFBSFWS,  group_leader=group_leader
  compile_opt idl2

  dave_version = wd_aboutHFBSFWSGetText(type='version')
  license = wd_aboutHFBSFWSGetText(type='license')
  builddate = wd_aboutHFBSFWSGetText(type='builddate')
  strAbout = wd_aboutHFBSFWSGetText(type='about')
  print,builddate

  license = [license,'']
  nlines = n_elements(strAbout)
  strAbout = [strAbout[0],dave_version,'Built on: '+builddate,strAbout[1:nlines-1]]

  license += ''

  title = 'About DAVE'

  ;; Okay, create our modal TLB
  wTLB = Widget_Base(/modal,/col,group_leader=group_leader,tlb_frame_attr=1,title=title $
                     ,/base_align_right $
                     ,SPACE=2 $
                    )

  wTAB = widget_tab(wTLB)
  
  ;; Cannot guarantee the existence of fonts on Motif, but can on Windoze

  font = (!version.os_family eq 'Windows')? 'Courier New*24*Bold' : $
         '-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1'
  font1 = (!version.os_family eq 'Windows')? 'Courier New*18*Bold' : $
         '-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1'
  font2 = (!version.os_family eq 'Windows')? 'Courier New*14' : $
         '-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1'

  ;; Get the image
;  bHaveImg = IDLitGetResource("itools_about", img)
;bHaveImg = IDLitGetResource(!dave_auxiliary_dir+'dave_logo_90.png', img)
;bHaveImg = IDLitGetResource(!dave_auxiliary_dir+'dave_logo_90.bmp', img)
read_png,!dave_auxiliary_dir+'dave_logo_90.png',img
bHaveImg = (n_elements(img) gt 0)? 1 : 0

  ;; first tab
  wCB1 = Widget_Base(wTAB, /row,title='About')
  
  if (bHaveImg) then begin
     szImage = size(img)
     ;wDraw1 = widget_draw(wCB1, xsize=szImage[1], ysize=szImage[2], retain=2)
     wDraw1 = widget_draw(wCB1, xsize=100, ysize=300, retain=2)
  endif
  
  wCB11 = widget_base(wCB1,/col)
  
  void = widget_label(wCB11, /align_center, value=strAbout[0], font=font)
  for i=1, n_elements(strAbout)-1 do $
     void = widget_label(wCB11, /align_center, value=strAbout[i],font=font1)
 
  ;; Second tab
  wCB2 = Widget_Base(wTAB, /row,title='Disclaimer')
  
  if (bHaveImg) then begin
     szImage = size(img)
     ;wDraw2 = widget_draw(wCB2, xsize=szImage[1], ysize=szImage[2], retain=2)
     wDraw2 = widget_draw(wCB2, xsize=100, ysize=300, retain=2)
  endif
  
  wCB21 = widget_base(wCB2,/col)
  
  for i=0, n_elements(license)-1 do $
     void = widget_label(wCB21, /align_center, value=license[i],font=font1);font2)



  ;; Add a Close button.
  wCB3 = Widget_base(wTLB, /align_center,/row,  space=3)
  wOK = Widget_Button(wCB3, value='OK',uvalue='close')
  
  widget_control, wTLB, /realize
  
  if(bHaveImg)then begin
     device, get_decomposed=old_dc ; play nice!

     Widget_Control, wDraw1, get_value=idxDraw
     wset,idxDraw
     device,decompose=1
     ;tv,img, true=3
     tvimage, img
     Widget_Control, wDraw2, get_value=idxDraw
     wset,idxDraw
     device,decompose=1
     ;tv,img, true=3
     tvimage, img

     device, decomposed=old_dc  ; play nice!
  endif
  
  xmanager, 'wd_aboutHFBSFWS', wTLB
  
  return, 1
end
