; $Id$
;
; Copyright (c) 2000-2004, Research Systems, Inc.  All rights reserved.
;   Unauthorized reproduction prohibited.
;----------------------------------------------------------------------------
;+
; CLASS_NAME:
;   IDLitToolbase
;
; PURPOSE:
;   This file implements the SPINS PSD Tool object
;
; CATEGORY:
;   
;
; SUPERCLASSES:
;   IDLitTool
;
; SUBCLASSES:
;
; CREATION:
;   See IDLitToolbase::Init
;
; METHODS:
;   This class has the following methods:
;
;   IDLitToolbase::Init
;
; INTERFACES:
; IIDLProperty
;-



;===============================================================================
; SPINSpsdTool::GetSystem
; 
; PURPOSE:
;   Return the IDLitSystem object
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::GetSystem
compile_opt idl2

return, self->_GetSystem()

end


;===============================================================================
; SPINSpsdTool::GetUI
; 
; PURPOSE:
;   Return the IDLitUI object for this tool
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::GetUI
compile_opt idl2

return, self._oUIConnection

end


;-------------------------------------------------------------------------------
pro SPINSpsdTool::Cleanup
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::Cleanup: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle)

        catch, /cancel
        ptr_free, Self.prefsPtr
        ptr_free, Self.historyPtr
        Self->IDLitTool::Cleanup
        Self->EnableUpdates
        return
    endif
endif

Self->DisableUpdates

; save session preferences
status = Self->SavePreferences()

ptr_free, Self.prefsPtr
ptr_free, Self.historyPtr

; Clean up samp container
oItems = Self.sampContRef->Get(/all, count=n)
if (n gt 0) then begin
   for i=0,n-1 do begin
      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
   endfor
endif

; Clean up samp container
oItems = Self.bkgdContRef->Get(/all, count=n)
if (n gt 0) then begin
   for i=0,n-1 do begin
      void = oItems[i]->GetMetaData('DATAPTRREF',dataPtr)
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
   endfor
endif


obj_destroy, [Self.sampContRef,Self.bkgdContRef]

; Call base class cleanup
self->IDLitTool::Cleanup

Self->EnableUpdates

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSpsdTool::savePreferences
;
; PURPOSE:
;   Update and save current user preferences
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function SPINSpsdTool::SavePreferences, skip_filesave=skip_filesave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::savePreferences: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; Save current user graphic customizations and preferences
if (Self->HasVisualizations()) then begin
   oWin = Self->GetCurrentWindow()
   oView = oWin->GetCurrentView()
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
   
   for j=nVis-1,0,-1 do begin
      oVis[j]->Select
      Self->saveVisProps, oVis[j]
   endfor
endif

Self->GetProperty, preferences=preferences

if keyword_set(skip_filesave) then return, 1

if (n_elements(preferences) gt 0) then $
   status = SPINSPSDReducPreferences(preferences, /save)

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::Exit
;+
; PURPOSE:
;   Exit handler
;
; PARAMETERS:
;
; RETURN VALUE:
;-
function SPINSpsdTool::Exit
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::Exit: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wd_SPINSpsdTool_event, { WIDGET_KILL_REQUEST, ID:wTLB, TOP:wTLB, HANDLER:wTLB }

return, 1
end


;-------------------------------------------------------------------------------
pro SPINSpsdTool::GetProperty, nameTag=nameTag, prompt=prompt, prmptTitle=prmptTitle, prmptDesc=prmptDesc $
 ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue,multipleMsliceWinFlag=multipleMsliceWinFlag $
 ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag,calibParamsisSet=calibParamsisSet $
 ,fastFlag=fastFlag,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,effNormFlag=effNormFlag,logFlag=logFlag $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag, chDelA4isSet=chDelA4isSet, curMaxDataLen=curMaxDataLen $
 ,sampContRef=sampContRef,bkgdContRef=bkgdContRef,fastContRef=fastContRef,phiOffset=phiOffset $
 ,data_directory=dataDir,mev2wnos=mev2wnos,fastparams=fastparams, daveTool=daveTool $
 ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ,preferences=preferences,history=history,oplotFastFitFlag=oplotFastFitFlag $
 ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex, oneOverKfFlag=oneOverKfFlag $
 ,oplotBkgdFlag=oplotBkgdFlag, modifiedStatus=modifiedStatus, ftpObject=ftpObject $
 ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
 ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
 ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,exportIndex=exportIndex,minBinWidth=minBinWidth,binwidths=binWidths $
 ,indepVar1List=indepVar1List,indepVar2List=indepVar2List,indepVar3List=indepVar3List $
 ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ,monCorFlag=monCorFlag, normalizeTo=normalizeTo, scanType=scanType,mergePixelsFlag=mergePixelsFlag $
 ,selectedIDs=selectedIDs,nSelectedIDs=nSelectedIDs,selectedNames=selectedNames  $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color  $
 ,ff_transparency=ff_transparency $
 ,ff_antialias=ff_antialias $
 ,ff_color=ff_color $
 ,ff_use_default_color=ff_use_default_color $
 ,ff_sym_index=ff_sym_index $
 ,ff_linestyle=ff_linestyle $
 ,ff_thick=ff_thick $
 ,sb_transparency=sb_transparency $
 ,sb_antialias=sb_antialias $
 ,sb_color=sb_color $
 ,sb_use_default_color=sb_use_default_color $
 ,sb_sym_index=sb_sym_index $
 ,sb_linestyle=sb_linestyle $
 ,sb_thick=sb_thick $
 ,_REF_EXTRA=etc

compile_opt idl2

; daveTool
if (arg_present(daveTool)) then $
  daveTool = self.daveTool

if (arg_present(s_errorbar_capsize)) then s_errorbar_capsize=Self.s_errorbar_capsize
if (arg_present(s_transparency)) then s_transparency=Self.s_transparency
if (arg_present(s_antialias)) then s_antialias=Self.s_antialias
if (arg_present(s_color)) then s_color=Self.s_color
if (arg_present(s_errorbar_color)) then s_errorbar_color=Self.s_errorbar_color
if (arg_present(s_use_default_color)) then s_use_default_color=Self.s_use_default_color 
if (arg_present(s_sym_increment)) then s_sym_increment=Self.s_sym_increment 
if (arg_present(s_sym_index)) then s_sym_index=Self.s_sym_index 
if (arg_present(s_sym_size)) then s_sym_size=Self.s_sym_size 
if (arg_present(s_sym_color)) then s_sym_color=Self.s_sym_color 
if (arg_present(s_sym_thick)) then s_sym_thick=Self.s_sym_thick 
if (arg_present(s_y_errorbars)) then s_y_errorbars=Self.s_y_errorbars
if (arg_present(s_linestyle)) then s_linestyle=Self.s_linestyle
if (arg_present(s_thick)) then s_thick=Self.s_thick
if (arg_present(s_sym_filled)) then s_sym_filled=Self.s_sym_filled
if (arg_present(s_sym_fill_color)) then s_sym_fill_color=Self.s_sym_fill_color
if (arg_present(s_font_name)) then s_font_name=Self.s_font_name
if (arg_present(s_font_size)) then s_font_size=Self.s_font_size
if (arg_present(s_text_color)) then s_text_color=Self.s_text_color
if (arg_present(b_errorbar_capsize)) then b_errorbar_capsize=Self.b_errorbar_capsize
if (arg_present(b_transparency)) then b_transparency=Self.b_transparency
if (arg_present(b_antialias)) then b_antialias=Self.b_antialias
if (arg_present(b_color)) then b_color=Self.b_color
if (arg_present(b_errorbar_color)) then b_errorbar_color=Self.b_errorbar_color
if (arg_present(b_use_default_color)) then b_use_default_color=Self.b_use_default_color
if (arg_present(b_sym_increment)) then b_sym_increment=Self.b_sym_increment
if (arg_present(b_sym_index)) then b_sym_index=Self.b_sym_index
if (arg_present(b_sym_size)) then b_sym_size=Self.b_sym_size
if (arg_present(b_sym_color)) then b_sym_color=Self.b_sym_color
if (arg_present(b_sym_thick)) then b_sym_thick=Self.b_sym_thick
if (arg_present(b_y_errorbars)) then b_y_errorbars=Self.b_y_errorbars
if (arg_present(b_linestyle)) then b_linestyle=Self.b_linestyle
if (arg_present(b_thick)) then b_thick=Self.b_thick
if (arg_present(b_sym_filled)) then b_sym_filled=Self.b_sym_filled
if (arg_present(b_sym_fill_color)) then b_sym_fill_color=Self.b_sym_fill_color
if (arg_present(b_sym_fill_color)) then b_errorbar_capsize=Self.b_errorbar_capsize
if (arg_present(b_font_name)) then b_font_name=Self.b_font_name
if (arg_present(b_font_size)) then b_font_size=Self.b_font_size
if (arg_present(b_text_color)) then b_text_color=Self.b_text_color
if (arg_present(f_transparency)) then f_transparency=Self.f_transparency
if (arg_present(f_antialias)) then f_antialias=Self.f_antialias
if (arg_present(f_color)) then f_color=Self.f_color
if (arg_present(f_errorbar_color)) then f_errorbar_color=Self.f_errorbar_color
if (arg_present(f_use_default_color)) then f_use_default_color=Self.f_use_default_color
if (arg_present(f_sym_increment)) then f_sym_increment=Self.f_sym_increment
if (arg_present(f_sym_index)) then f_sym_index=Self.f_sym_index
if (arg_present(f_sym_size)) then f_sym_size=Self.f_sym_size
if (arg_present(f_sym_color)) then f_sym_color=Self.f_sym_color
if (arg_present(f_sym_thick)) then f_sym_thick=Self.f_sym_thick
if (arg_present(f_y_errorbars)) then f_y_errorbars=Self.f_y_errorbars
if (arg_present(f_linestyle)) then f_linestyle=Self.f_linestyle
if (arg_present(f_thick)) then f_thick=Self.f_thick
if (arg_present(f_sym_filled)) then f_sym_filled=Self.f_sym_filled
if (arg_present(f_sym_fill_color)) then f_sym_fill_color=Self.f_sym_fill_color
if (arg_present(f_font_name)) then f_font_name=Self.f_font_name
if (arg_present(f_font_size)) then f_font_size=Self.f_font_size
if (arg_present(f_text_color)) then f_text_color=Self.f_text_color
if (arg_present(ff_transparency)) then ff_transparency=Self.ff_transparency
if (arg_present(ff_antialias)) then ff_antialias=Self.ff_antialias
if (arg_present(ff_color)) then ff_color=Self.ff_color
if (arg_present(ff_use_default_color)) then ff_use_default_color=Self.ff_use_default_color
if (arg_present(ff_sym_index)) then ff_sym_index=Self.ff_sym_index
if (arg_present(ff_linestyle)) then ff_linestyle=Self.ff_linestyle
if (arg_present(ff_thick)) then ff_thick=Self.ff_thick
if (arg_present(sb_transparency)) then sb_transparency=Self.sb_transparency
if (arg_present(sb_antialias)) then sb_antialias=Self.sb_antialias
if (arg_present(sb_color)) then sb_color=Self.sb_color
if (arg_present(sb_use_default_color)) then sb_use_default_color=Self.sb_use_default_color
if (arg_present(sb_sym_index)) then sb_sym_index=Self.sb_sym_index
if (arg_present(sb_linestyle)) then sb_linestyle=Self.sb_linestyle
if (arg_present(sb_thick)) then sb_thick=Self.sb_thick


; Preferences structure
if (arg_present(preferences)) then begin
   if (ptr_valid(Self.prefsPtr)) then begin
      preferences = (*self.prefsPtr)

      ; update the preferences structure
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      for i=0,ntags-1 do begin
         status = Self->GetPropertyByIdentifier(tags[i], value)
         if (status) then preferences.(i) = strjoin(strtrim(string(value),2),',')
;         if (~status) then continue
;         if (strmatch(tags[i],'*color*',/fold_case)) then begin
;            ; for colors, first convert byte vector to a string eg [0,128,0] to '0,128,0'
;            preference.(i) = strjoin(value,',')
;         endif else $
;            preferences.(i) = value
      endfor
   endif
endif

; modifiedStatus
if (arg_present(modifiedStatus)) then modifiedStatus = self.modifiedFlag
; nameTag
if (arg_present(nameTag)) then nameTag = self.nameTag
; nameTag
if (arg_present(history)) then history = (*Self.historyPtr)
; prompt
if (arg_present(prompt)) then prompt = self.prompt
; prompt Title
if (arg_present(prmptTitle)) then prmptTitle = self.promptTitle
; prompt Desc
if (arg_present(prmptDesc)) then prmptDesc = self.promptDesc
;
if (arg_present(nSamp)) then nSamp = Self.nSamp
;
if (arg_present(nBkgd)) then nBkgd = Self.nBkgd
;
if (arg_present(nFast)) then nFast = Self.nFast
;
if (arg_present(sampSelected)) then sampSelected = Self.sampSelected
;
if (arg_present(bkgdSelected)) then bkgdSelected = Self.bkgdSelected
;
if (arg_present(fastSelected)) then fastSelected = Self.fastSelected
;
if (arg_present(sampContRef)) then sampContRef = Self.sampContRef
;
if (arg_present(bkgdContRef)) then bkgdContRef = Self.bkgdContRef
;
if (arg_present(fastContRef)) then fastContRef = Self.fastContRef
;
if (arg_present(nActiveDetectors)) then nActiveDetectors = Self.nActiveDetectors
;
if (arg_present(energyUnitFlag)) then energyUnitFlag = Self.energyUnitFlag
;
if (arg_present(maskedDets)) then maskedDets = Self.maskedDets
;
if (arg_present(fastparams)) then fastparams = Self.fastparams
;
if (arg_present(fastfunc)) then fastfunc = Self.fastfunc
;
if (arg_present(funcs)) then funcs = Self.fastfuncs
;
if (arg_present(monScaleValue)) then monScaleValue = Self.monScaleValue
;
if (arg_present(monScaleFlag)) then monScaleFlag = Self.monScaleFlag
;
if (arg_present(sumSampFlag)) then sumSampFlag = Self.sumSampFlag
;
if (arg_present(sumBkgdFlag)) then sumBkgdFlag = Self.sumBkgdFlag
;
if (arg_present(maskFlag)) then maskFlag = Self.maskFlag
;
if (arg_present(bkgdFlag)) then bkgdFlag = Self.bkgdFlag
;
if (arg_present(fastFlag)) then fastFlag = Self.fastFlag
;
if (arg_present(dataDir)) then dataDir = Self.dataDir
;
if (arg_present(mev2wnos)) then mev2wnos = Self.mev2wnos
;
if (arg_present(oplotFastFitFlag)) then oplotFastFitFlag = Self.oplotFastFitFlag
;
if (arg_present(oplotBkgdFlag)) then oplotBkgdFlag = Self.oplotBkgdFlag
;
if (arg_present(ftpObject)) then ftpObject = Self.ftpObject
;
if (arg_present(latParamFlag)) then latParamFlag = Self.latParamFlag
;
if (arg_present(latticeParameters)) then latticeParameters = Self.latticeParameters
;
if (arg_present(detailedBalanceFlag)) then detailedBalanceFlag = Self.detailedBalanceFlag
;
if (arg_present(fastValue)) then fastValue = Self.fastValue
;
if (arg_present(resCorFlag)) then resCorFlag = Self.resCorFlag
;
if (arg_present(monCorFlag)) then monCorFlag = Self.monCorFlag
;
if (arg_present(normalizeTo)) then normalizeTo = Self.normalizeTo
;
if (arg_present(scanType)) then scanType = Self.scanType
;
if (arg_present(qUnits)) then qUnits = Self.qUnits
;
if (arg_present(xAxisVar)) then xAxisVar = Self.xAxisVar
;
if (arg_present(yAxisVar)) then yAxisVar = Self.yAxisVar
;
if (arg_present(indepVar1List)) then indepVar1List = (*Self.indepVars1Ptr)
;
if (arg_present(indepVar12List)) then indepVar2List = (*Self.indepVars2Ptr)
;
if (arg_present(indepVar2List)) then indepVar2List = (*Self.indepVars2Ptr)
;
if (arg_present(indepVar3List)) then indepVar3List = (*Self.indepVars3Ptr)
;
if (arg_present(exportIndex)) then exportIndex = (*Self.exportIndexPtr)
;
if (arg_present(calibParamsisSet)) then calibParamsisSet = Self.calibParamsisSet
;
if (ARG_PRESENT(multipleMsliceWinFlag)) then multipleMsliceWinFlag = Self.multipleMsliceWinFlag
;
if (arg_present(effNormFlag)) then effNormFlag = Self.effNormFlag
;
if (ARG_PRESENT(mergePixelsFlag)) then mergePixelsFlag = Self.mergePixelsFlag
;
if (ARG_PRESENT(minBinWidth)) then minBinWidth = Self.minBinWidth
;
if (ARG_PRESENT(binWidths)) then binWidths = Self.binWidths
;
if (ARG_PRESENT(defaultIntensityFlag)) then defaultIntensityFlag = Self.defaultIntensityFlag
;
if (ARG_PRESENT(maxIntensity)) then maxIntensity = Self.maxIntensity
;
if (ARG_PRESENT(minIntensity)) then minIntensity = Self.minIntensity
;
if (ARG_PRESENT(phiOffset)) then phiOffset = Self.phiOffset
;
if (ARG_PRESENT(logFlag)) then logFlag = Self.logFlag
;
if (ARG_PRESENT(minChan)) then minChan = Self.minChan
;
if (ARG_PRESENT(maxChan)) then maxChan = Self.maxChan
;
if (ARG_PRESENT(minDPnt)) then minDPnt = Self.minDPnt
;
if (ARG_PRESENT(maxDPnt)) then maxDPnt = Self.maxDPnt
;
if (ARG_PRESENT(sharedSettingsFlag)) then sharedSettingsFlag = Self.sharedSettingsFlag
;
if (ARG_PRESENT(settingIndex)) then settingIndex = Self.settingIndex
;
if (ARG_PRESENT(dpntIndex)) then dpntIndex = Self.dpntIndex
;
if (arg_present(oneOverKfFlag)) then oneOverKfFlag = Self.oneOverKfFlag
;
if (arg_present(selectedIDs) || arg_present(nSelectedIDs) || arg_present(selectedNames)) then begin
   oUI = Self->GetUI()
   oUI->GetProperty, group_leader = wTLB
   wChild = WIDGET_INFO(wTLB, /CHILD)
   WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
   ; retrieve list of all _selected_ datasets from the data manager
   wDM = (*sPtr).wDM ; the data manager widget ID
   widget_control, wDM, get_uvalue=sPtrDM ; the data manager state ptr
   
   oSampCont = Self.sampContRef
   if (oSampCont->Count() eq 0) then begin
      ; no data currently loaded
      (*(*sPtrDM).pdataids) = ''
      selectedIDs = ''
      selectedNames = ''
      nSelectedIDs = 0
   endif else begin
      selectedIDs = (*(*sPtrDM).pdataids)  ; currently selected identifiers
      nSelectedIDs = n_elements(selectedIDs)
      if (selectedIDs[0] eq '') then nSelectedIDs = 0
      selectedNames = (nSelectedIDs eq 0)? '' :  strarr(nSelectedIDs)
      for i=0,nSelectedIDs-1 do begin
         (Self->GetByIdentifier(selectedIDs[i]))->GetProperty, name=name
         selectedNames[i] = name
      endfor
   endelse
endif

if (arg_present(curMaxDataLen)) then begin
   oSampCont = Self.sampContRef
   curMaxDataLen = 1
   if (obj_valid(oSampCont) && (oSampCont->Count() gt 0)) then begin
      nSamp = oSampCont->Count()
      for i = 0, nSamp-1 do begin
         oI = oSampCont->Get(position=i)
         status = oI->GetMetaData('NPTS',npts)
         if (status) then curMaxDataLen = curMaxDataLen > npts
      endfor
   endif 

endif

; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::GetProperty, _EXTRA=etc

end


;-------------------------------------------------------------------------------
pro SPINSpsdTool::SetProperty, nameTag=nameTag, prompt=prompt,preferences=preferences, _EXTRA=etc $
 ,nActiveDetectors=nActiveDetectors,energyUnitFlag=energyUnitFlag $
 ,maskedDets=maskedDets,fastFunc=fastFunc,monScaleValue=monScaleValue $
 ,monScaleFlag=monScaleFlag,maskFlag=maskFlag,bkgdFlag=bkgdFlag $
 ,sumSampFlag=sumSampFlag,sumBkgdFlag=sumBkgdFlag,effNormFlag=effNormFlag $
 ,fastFlag=fastFlag, data_directory=dataDir, daveTool=daveTool, oneOverKfFlag=oneOverKfFlag $
 ,minChan=minChan,maxChan=maxChan,minDPnt=minDPnt,maxDPnt=maxDPnt,dpntIndex=dpntIndex $
 ,sharedSettingsFlag=sharedSettingsFlag,settingIndex=settingIndex $
 ,nSamp=nSamp,nBkgd=nBkgd,nFast=nFast,fastparams=fastparams,phiOffset=phiOffset,logFlag=logFlag $
 ,defaultIntensityFlag=defaultIntensityFlag, maxIntensity=maxIntensity, minIntensity=minIntensity $
 ,sampSelected=sampSelected, bkgdSelected=bkgdSelected, fastSelected=fastSelected $
 ,oplotFastFitFlag=oplotFastFitFlag,oplotBkgdFlag=oplotBkgdFlag, typeCheck=typeCheck $
 ,modifiedStatus=modifiedStatus,exportIndex=exportIndex,minBinWidth=minBinWidth,binWidths=binWidths $
 ,latParamFlag=latParamFlag, latticeParameters=latticeParameters, qUnits=qUnits $
 ,xAxisVar=xAxisVar,yAxisVar=yAxisVar,multipleMsliceWinFlag=multipleMsliceWinFlag $
 ,detailedBalanceFlag=detailedBalanceFlag,fastValue=fastValue, resCorFlag=resCorFlag $
 ,monCorFlag=monCorFlag, normalizeTo=normalizeTo, scanType=scanType,mergePixelsFlag=mergePixelsFlag $
 ,s_errorbar_capsize=s_errorbar_capsize $
 ,s_transparency=s_transparency $
 ,s_antialias=s_antialias $
 ,s_color=s_color $
 ,s_errorbar_color=s_errorbar_color $
 ,s_use_default_color=s_use_default_color $
 ,s_sym_increment=s_sym_increment $
 ,s_sym_index=s_sym_index $
 ,s_sym_size=s_sym_size $
 ,s_sym_color=s_sym_color $
 ,s_sym_thick=s_sym_thick $
 ,s_y_errorbars=s_y_errorbars $
 ,s_linestyle=s_linestyle $
 ,s_thick=s_thick $
 ,s_sym_filled=s_sym_filled $
 ,s_sym_fill_color=s_sym_fill_color $
 ,s_font_name=s_font_name  $
 ,s_font_size=s_font_size $
 ,s_text_color=s_text_color  $
 ,b_errorbar_capsize=b_errorbar_capsize $
 ,b_transparency=b_transparency $
 ,b_antialias=b_antialias $
 ,b_color=b_color $
 ,b_errorbar_color=b_errorbar_color $
 ,b_use_default_color=b_use_default_color $
 ,b_sym_increment=b_sym_increment $
 ,b_sym_index=b_sym_index $
 ,b_sym_size=b_sym_size $
 ,b_sym_color=b_sym_color $
 ,b_sym_thick=b_sym_thick $
 ,b_y_errorbars=b_y_errorbars $
 ,b_linestyle=b_linestyle $
 ,b_thick=b_thick $
 ,b_sym_filled=b_sym_filled $
 ,b_sym_fill_color=b_sym_fill_color $
 ,b_font_name=b_font_name  $
 ,b_font_size=b_font_size $
 ,b_text_color=b_text_color  $
 ,f_errorbar_capsize=f_errorbar_capsize $
 ,f_transparency=f_transparency $
 ,f_antialias=f_antialias $
 ,f_color=f_color $
 ,f_errorbar_color=f_errorbar_color $
 ,f_use_default_color=f_use_default_color $
 ,f_sym_increment=f_sym_increment $
 ,f_sym_index=f_sym_index $
 ,f_sym_size=f_sym_size $
 ,f_sym_color=f_sym_color $
 ,f_sym_thick=f_sym_thick $
 ,f_y_errorbars=f_y_errorbars $
 ,f_linestyle=f_linestyle $
 ,f_thick=f_thick $
 ,f_sym_filled=f_sym_filled $
 ,f_sym_fill_color=f_sym_fill_color $
 ,f_font_name=f_font_name  $
 ,f_font_size=f_font_size $
 ,f_text_color=f_text_color  $
 ,ff_transparency=ff_transparency $
 ,ff_antialias=ff_antialias $
 ,ff_color=ff_color $
 ,ff_use_default_color=ff_use_default_color $
 ,ff_sym_index=ff_sym_index $
 ,ff_linestyle=ff_linestyle $
 ,ff_thick=ff_thick $
 ,sb_transparency=sb_transparency $
 ,sb_antialias=sb_antialias $
 ,sb_color=sb_color $
 ,sb_use_default_color=sb_use_default_color $
 ,sb_sym_index=sb_sym_index $
 ,sb_linestyle=sb_linestyle $
 ,sb_thick=sb_thick

compile_opt idl2

if n_elements(s_errorbar_capsize) then Self.s_errorbar_capsize=s_errorbar_capsize
if n_elements(s_transparency) then Self.s_transparency=s_transparency
if n_elements(s_antialias) then Self.s_antialias=s_antialias
if n_elements(s_color) then Self.s_color=s_color
if n_elements(s_errorbar_color) then Self.s_errorbar_color=s_errorbar_color
if n_elements(s_use_default_color) then Self.s_use_default_color=s_use_default_color 
if n_elements(s_sym_increment) then Self.s_sym_increment=s_sym_increment 
if n_elements(s_sym_index) then Self.s_sym_index=s_sym_index 
if n_elements(s_sym_size) then Self.s_sym_size=s_sym_size 
if n_elements(s_sym_color) then Self.s_sym_color=s_sym_color 
if n_elements(s_sym_thick) then Self.s_sym_thick=s_sym_thick 
if n_elements(s_y_errorbars) then Self.s_y_errorbars=s_y_errorbars
if n_elements(s_linestyle) then Self.s_linestyle=s_linestyle
if n_elements(s_thick) then Self.s_thick=s_thick
if n_elements(s_sym_filled) then Self.s_sym_filled=s_sym_filled
if n_elements(s_sym_fill_color) then Self.s_sym_fill_color=s_sym_fill_color
if n_elements(s_font_name) then Self.s_font_name=s_font_name
if n_elements(s_font_size) then Self.s_font_size=s_font_size
if n_elements(s_text_color) then Self.s_text_color=s_text_color
if n_elements(b_errorbar_capsize) then Self.b_errorbar_capsize=b_errorbar_capsize
if n_elements(b_transparency) then Self.b_transparency=b_transparency
if n_elements(b_antialias) then Self.b_antialias=b_antialias
if n_elements(b_color) then Self.b_color=b_color
if n_elements(b_use_default_color) then Self.b_use_default_color=b_use_default_color
if n_elements(b_errorbar_color) then Self.b_errorbar_color=b_errorbar_color
if n_elements(b_sym_increment) then Self.b_sym_increment=b_sym_increment
if n_elements(b_sym_index) then Self.b_sym_index=b_sym_index
if n_elements(b_sym_size) then Self.b_sym_size=b_sym_size
if n_elements(b_sym_color) then Self.b_sym_color=b_sym_color
if n_elements(b_sym_thick) then Self.b_sym_thick=b_sym_thick
if n_elements(b_y_errorbars) then Self.b_y_errorbars=b_y_errorbars
if n_elements(b_linestyle) then Self.b_linestyle=b_linestyle
if n_elements(b_thick) then Self.b_thick=b_thick
if n_elements(b_sym_filled) then Self.b_sym_filled=b_sym_filled
if n_elements(b_sym_fill_color) then Self.b_sym_fill_color=b_sym_fill_color
if n_elements(b_font_name) then Self.b_font_name=b_font_name
if n_elements(b_font_size) then Self.b_font_size=b_font_size
if n_elements(b_text_color) then Self.b_text_color=b_text_color
if n_elements(f_errorbar_capsize) then Self.f_errorbar_capsize=f_errorbar_capsize
if n_elements(f_transparency) then Self.f_transparency=f_transparency
if n_elements(f_antialias) then Self.f_antialias=f_antialias
if n_elements(f_color) then Self.f_color=f_color
if n_elements(f_errorbar_color) then Self.f_errorbar_color=f_errorbar_color
if n_elements(f_use_default_color) then Self.f_use_default_color=f_use_default_color
if n_elements(f_sym_increment) then Self.f_sym_increment=f_sym_increment
if n_elements(f_sym_index) then Self.f_sym_index=f_sym_index
if n_elements(f_sym_size) then Self.f_sym_size=f_sym_size
if n_elements(f_sym_color) then Self.f_sym_color=f_sym_color
if n_elements(f_sym_thick) then Self.f_sym_thick=f_sym_thick
if n_elements(f_y_errorbars) then Self.f_y_errorbars=f_y_errorbars
if n_elements(f_linestyle) then Self.f_linestyle=f_linestyle
if n_elements(f_thick) then Self.f_thick=f_thick
if n_elements(f_sym_filled) then Self.f_sym_filled=f_sym_filled
if n_elements(f_sym_fill_color) then Self.f_sym_fill_color=f_sym_fill_color
if n_elements(f_font_name) then Self.f_font_name=f_font_name
if n_elements(f_font_size) then Self.f_font_size=f_font_size
if n_elements(f_text_color) then Self.f_text_color=f_text_color
if n_elements(ff_transparency) then Self.ff_transparency=ff_transparency
if n_elements(ff_antialias) then Self.ff_antialias=ff_antialias
if n_elements(ff_color) then Self.ff_color=ff_color
if n_elements(ff_use_default_color) then Self.ff_use_default_color=ff_use_default_color
if n_elements(ff_sym_index) then Self.ff_sym_index=ff_sym_index
if n_elements(ff_linestyle) then Self.ff_linestyle=ff_linestyle
if n_elements(ff_thick) then Self.ff_thick=ff_thick
if n_elements(sb_transparency) then Self.sb_transparency=sb_transparency
if n_elements(sb_antialias) then Self.sb_antialias=sb_antialias
if n_elements(sb_color) then Self.sb_color=sb_color
if n_elements(sb_use_default_color) then Self.sb_use_default_color=sb_use_default_color
if n_elements(sb_sym_index) then Self.sb_sym_index=sb_sym_index
if n_elements(sb_linestyle) then Self.sb_linestyle=sb_linestyle
if n_elements(sb_thick) then Self.sb_thick=sb_thick

; DAVETool
if (n_elements(daveTool) && obj_valid(daveTool) && obj_isa(daveTool,'DAVETool')) then $
  Self.daveTool = daveTool

; Preferences
if (n_elements(preferences)) then begin
   if (strcmp(size(preferences,/tname),'STRUCT')) then begin
      ntags = n_tags(preferences)
      tags = tag_names(preferences)
      index = indgen(ntags)
      
      ; handle color tags - convert string to byte array, eg '0,128,255' to [0,128,255]
      spIndex = where(strmatch(tags,'*color*',/fold) eq 1, spCnt, complement=index, ncomplement=theRest)
      if (spCnt gt 0) then begin
         for i=0,spCnt-1 do begin
            strColor = preferences.(spIndex[i])
            bytColor = fix(strsplit(strColor,',',/extract))
            Self->SetPropertyByIdentifier, tags[spIndex[i]], bytColor
         endfor
      endif

      ; all other tags
      for i=0,theRest-1 do begin
         if (strcmp(tags[index[i]],'binWidths',/fold)) then begin
            ; another special case (binwidths) - convert string to 7 element float array
            strBW = preferences.(index[i])
            fltBW = float(strsplit(strBW,',',/extract))
            Self->SetPropertyByIdentifier, tags[index[i]], fltBW
         endif else $
            Self->SetPropertyByIdentifier, tags[index[i]], preferences.(index[i])
      endfor
      
      ; Need further to assign some userdef attribute for user-defined properties
      ; in order for property sheet to reflect updated value
      uProps = ['MASKEDDETS']
      n = n_elements(uProps)
      for i = 0,n-1 do begin
         index = where(strcmp(tags,uProps[i]), found)
         if (found) then $
            Self->SetPropertyAttribute, uProps[i],userdef=preferences.(index)
      endfor
      
      ; Finally, store the preferences structure
      if (ptr_valid(Self.prefsPtr)) then (*Self.prefsPtr) = preferences $
      else Self.prefsPtr = ptr_new(preferences)
   endif
endif

; modifiedStatus
if (n_elements(modifiedStatus)) then Self.modifiedFlag = (fix(modifiedStatus) gt 0)? 1 : 0
; nameTag
if (n_elements(nameTag)) then Self.nameTag = strtrim(nameTag,2)
; prompt
if (n_elements(prompt)) then begin
   Self.prompt = prompt
   if (prompt eq 0) then Self._bDirty = 0
endif
;
if (n_elements(nActiveDetectors)) then Self.nActiveDetectors = nActiveDetectors
;
if (n_elements(energyUnitFlag)) then Self.energyUnitFlag = energyUnitFlag
;
if (n_elements(oneOverKfFlag)) then Self.oneOverKfFlag = oneOverKfFlag
;
if (n_elements(maskedDets)) then Self.maskedDets = maskedDets
;
if (n_elements(fastfunc)) then Self.fastfunc = fastfunc
;
if (n_elements(fastparams)) then Self.fastparams = fastparams
;
if (n_elements(monScaleValue)) then Self.monScaleValue = (monScaleValue eq 0.0)? 1.0 : monScaleValue
;
if (n_elements(monScaleFlag)) then Self.monScaleFlag = monScaleFlag
;
if (n_elements(sumSampFlag)) then Self.sumSampFlag = sumSampFlag
;
if (n_elements(sumBkgdFlag)) then Self.sumBkgdFlag = sumBkgdFlag
;
if (n_elements(maskFlag)) then Self.maskFlag = maskFlag
;
if (n_elements(bkgdFlag)) then Self.bkgdFlag = bkgdFlag
;
if (n_elements(fastFlag)) then Self.fastFlag = fastFlag
;
if (n_elements(dataDir)) then Self.dataDir = dataDir
;
if (n_elements(nSamp)) then Self.nSamp = nSamp
;
if (n_elements(nBkgd)) then Self.nBkgd = nBkgd
;
if (n_elements(nFast)) then Self.nFast = nFast
;
if (n_elements(sampSelected)) then Self.sampSelected = sampSelected
;
if (n_elements(bkgdSelected)) then Self.bkgdSelected = bkgdSelected
;
if (n_elements(fastSelected)) then Self.fastSelected = fastSelected
;
if (n_elements(oplotFastFitFlag)) then Self.oplotFastFitFlag = oplotFastFitFlag
;
if (n_elements(oplotBkgdFlag)) then Self.oplotBkgdFlag = oplotBkgdFlag
;
if (n_elements(latParamFlag)) then  Self.latParamFlag = latParamFlag
;
if (n_elements(latticeParameters)) then  Self.latticeParameters = latticeParameters
;
if (n_elements(detailedBalanceFlag)) then Self.detailedBalanceFlag = detailedBalanceFlag
;
if (n_elements(fastValue)) then Self.fastValue = fastValue
;
if (n_elements(resCorFlag)) then Self.resCorFlag = resCorFlag
;
if (n_elements(monCorFlag)) then Self.monCorFlag = monCorFlag
;
if (n_elements(normalizeTo)) then Self.normalizeTo = normalizeTo
;
if (n_elements(minbinWidth)) then Self.minbinWidth = minbinWidth
;
if (n_elements(binWidths)) then Self.binWidths = binWidths
;
if (n_elements(minChan)) then Self.minChan = minChan > 1
;
if (n_elements(maxChan)) then Self.maxChan = maxChan
;
if (n_elements(minDPnt)) then Self.minDPnt = minDPnt > 1
;
if (n_elements(maxDPnt)) then Self.maxDPnt = maxDPnt
;
if (n_elements(dpntIndex)) then Self.dpntIndex = dpntIndex > 1
;
if (n_elements(sharedSettingsFlag)) then Self.sharedSettingsFlag = sharedSettingsFlag
;
if (n_elements(settingIndex)) then Self.settingIndex = settingIndex
;
if (n_elements(scanType)) then begin
   Self.scanType = scanType
   if (n_elements(typeCheck) eq 0) then typeCheck = 1 ; ==> default typeCheck is set to 1
   Self->UpdatePropertySheet, typeCheck = typeCheck
endif
;
if (n_elements(qUnits)) then Self.qUnits = qUnits
;
if (n_elements(xAxisVar)) then Self.xAxisVar = xAxisVar
;
if (n_elements(yAxisVar)) then Self.yAxisVar = yAxisVar
;
if (n_elements(exportIndex) gt 0) then (*Self.exportIndexPtr) = exportIndex 
;
if (n_elements(effNormFlag) gt 0) then Self.effNormFlag = effNormFlag 
;
if (N_ELEMENTS(multipleMsliceWinFlag) gt 0) then Self.multipleMsliceWinFlag = multipleMsliceWinFlag
;
if (N_ELEMENTS(mergePixelsFlag) gt 0) then Self.mergePixelsFlag = mergePixelsFlag
;
if (N_ELEMENTS(defaultIntensityFlag) gt 0) then Self.defaultIntensityFlag = defaultIntensityFlag
;
if (N_ELEMENTS(maxIntensity) gt 0) then begin
   if (maxIntensity gt Self.minIntensity) then Self.maxIntensity = maxIntensity
endif
;
if (N_ELEMENTS(minIntensity) gt 0) then begin
   if (minIntensity lt Self.maxIntensity) then Self.minIntensity = minIntensity
endif
;
if (N_ELEMENTS(phiOffset) gt 0) then Self.phiOffset = phiOffset
;
if (N_ELEMENTS(logFlag) gt 0) then Self.logFlag = logFlag





; Call base class method
if (n_elements(etc) gt 0) then $
  self->IDLitTool::SetProperty, _EXTRA=etc

end


;===============================================================================
; SPINSpsdTool::deleteAllDatasets
;
; PURPOSE:
;   Delete all datasets currently loaded
;
; PARAMETERS:
;
; RETURN VALUE:
;
function SPINSpsdTool::deleteAllDatasets, _EXTRA=etc
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

wDM = (*sPtr).wDM
widget_control, wDM, get_uvalue=sPtrDM

cw_SPINSPSDDataManager_DeleteData, sPtrDM, wDM, /delall, _EXTRA=etc

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::subtractBkgd
;
; PURPOSE:
;   Subtract bkgd data
;
; PARAMETERS:
;
; RETURN VALUE:
;
pro SPINSpsdTool::subtractBkgd
compile_opt idl2


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::GetFileList, title, count, fromFTP=fromFTP, filter=filter $
                                ,multiple_files=multiple_files, path=path, newPath=newPath

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

if (keyword_set(fromFTP)) then begin
  Self->GetProperty, ftpObject=oFTP
  if (n_elements(filter) eq 0) then filter = ['*.ng5','*.*']
  files = Dialog_NCNRpublicData(oFTP,title=title,filter=filter,group_leader=wTLB,count=count)
endif else begin
  if (n_elements(filter) eq 0) then filter = '*.ng5'
  if (n_elements(multiple_files) eq 0) then multiple_files=1
  if (n_elements(path) eq 0) then Self->GetProperty, data_directory=path
  if (n_elements(title) eq 0) then title='Specify files to load'
  
  files = dialog_pickfile(title=title,multiple_files=multiple_files,/must_exist, dialog_parent=wTLB $
                         ,filter=filter,path=path, get_path=newPath)
  
  if (files[0] eq '') then begin
     count = 0
     return, ''
  endif
  
  count = n_elements(files)
  ;Self->SetProperty, data_directory=newPath
endelse

return, files

end
;-------------------------------------------------------------------------------



;===============================================================================
; SPINSpsdTool::refreshPropertySheet
;
; PURPOSE:
;   Refresh the propertysheet UI
;
; PARAMETERS:
;
; KEYWORDS:
;
pro SPINSpsdTool::RefreshPropertySheet

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

widget_control, (*sPtr).wPS, /refresh_property

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::loadFastFtp
;
; PURPOSE:
;   Specify and load fast bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::loadFastFtp

return, Self->LoadFast(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::loadBkgdFtp
;
; PURPOSE:
;   Specify and load bkgd data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::loadBkgdFtp

return, Self->LoadBkgd(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSpsdTool::loadBkgd
;
; PURPOSE:
;   Select and load Bkgd data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function SPINSpsdTool::loadBkgd, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::loadBkgd: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        Self->EnableUpdates
        return, 0
    endif
endif

reloading = keyword_set(reload)
if (reloading) then begin
   if (~obj_valid(oItem)) then return, 0
   oItem->GetProperty, description=files
   count = 1
   void = oItem->GetMetaData('FROMFTP',fromFtp)
   ;if (~Self->ReadData(filename, dataPtr)) then return, 0
endif else begin
   ; Let user specify files to load
   title = 'Select Background Files to Load'
   
   files = Self->GetFileList(title,count,fromFTP=fromFTP,newPath=newPath)
   if (count eq 0) then return, 0
   if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

Self->DisableUpdates
; Read the contents of the data files and make entries in the 'Bkgd' tab of the data manager
Self->GetProperty, bkgdContRef=oCont, nBkgd=nData
oItems = []
A2s = []
for i=0, count-1 do begin

   filename = files[i]
   if (~Self->readData(filename, dataPtr, fromFTP=fromFTP)) then begin
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
      continue
   endif

   basename = file_basename(filename,'.ng5',/fold_case)

   if (~reloading) then begin
      ;; create new object and attach dataPtr
      oItem = obj_new('IDLitParameterSet',name=basename,description=filename,type='bkgd')   
      oItem->AddMetaData,'DATAPTRREF',dataPtr
      oItem->AddMetaData,'FROMFTP',keyword_set(fromFTP)
      
      ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
      ; replace all '_' with '-'
      oItem->GetProperty, identifier=idd
      hasChanged = 0
      while ((pos = stregex(idd,'_[0-9]')) ne -1) do begin
         strput, idd,'-',pos
         hasChanged = 1
      endwhile
      if (strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
         idd = 'id'+idd
         hasChanged = 1
      endif
      if (hasChanged) then oItem->SetProperty,identifier=idd 
      
;      ; this may be I-Scan specific
;      A2 = (*(*dataPtr).a2)[0]
;      oItem->AddMetaData,'A2VALUE',A2
;      oItems = [oItems,oItem]
;      A2s = [A2s,A2]

      if ((*dataPtr).scanType eq 'I') then begin
        ; I-Scan specific
        A2 = (*(*dataPtr).a2)[0]
        oItem->AddMetaData,'A2VALUE',A2
        oItems = [oItems,oItem]
        A2s = [A2s,A2]
      endif else begin
        ; Add to the data manager
        Self->AddByIdentifier, 'Bkgd Data Manager', oItem, position=0
      endelse


;      ; Add to the data manager
;      Self->AddByIdentifier, 'Bkgd Data Manager', oItem, position=0
   endif else begin
      ;; simply replace previous dataPtr with updated one
      void = oItem->GetMetaData('DATAPTRREF',tempPtr)
      if (ptr_valid(tempPtr)) then heap_free, tempPtr
      oItem->AddMetaData,'DATAPTRREF',dataPtr
   endelse
   
   ; Update calculations (q,e,intensity) for data
   Self->UpdateCalculation, oItem
   
   if (~reloading) then begin
      oCont->Add, oItem
      Self.nBkgd++
   endif

   dataPtr = !NULL   ; make dataPtr invalid before it is used again when looping
endfor

if (n_elements(oItems) gt 0) then begin
  ; Sort by A2 value and add to the data manager
  n = n_elements(oItems)
  index = sort(A2s)
  for i=0,n-1 do begin
      Self->AddByIdentifier, 'Bkgd Data Manager', oItems[index[i]]   
  endfor
endif

Self.modifiedFlag = 1
Self->EnableUpdates

Self->SetPropertyAttribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)

Self->UpdatePropertySheet
Self->RefreshPropertySheet

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::ViewCalibParams
;
; PURPOSE:
;   View raw contents of loaded PSD detector calibration parameter file
;   (Pixel efficiencies and delta A4, Ef).
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::ViewCalibParams

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

status = file_test(Self.calibParamsFilename,/read)
if (~status) then begin
  msg = ['The following calibration file could not be located',Self.calibParamsFilename]
  Self->ErrorMessage, msg,title='Calibration not found',severity=0
  Self->StatusMessage, Self.calibParamsFilename+' could not be located'
  return, 0
endif

font = (!version.os_family eq 'Windows')? 'Courier New*24*Bold' : $
  '-adobe-courier-bold-o-normal--24-240-75-75-m-150-iso8859-1'
font1 = (!version.os_family eq 'Windows')? 'Courier New*18*Bold' : $
  '-adobe-courier-bold-o-normal--18-180-75-75-m-110-iso8859-1'
font2 = (!version.os_family eq 'Windows')? 'Courier New*16' : $
  '-adobe-courier-medium-o-normal--14-140-75-75-m-90-iso8859-1'

doneTxt = "Close "+Self.calibParamsBaseFilename

xdisplayfile, Self.calibParamsFilename, done_button=doneTxt, /grow_to_screen, group=wTLB, font=font2

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::loadCalibParams
;
; PURPOSE:
;   Specify calibration file and load PSD detector calibration parameters 
;   (Pixel efficiencies and delta A4, Ef) values from it
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::loadCalibParams

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::loadCalibParams: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        if (n_elements(lun) gt 0) then free_lun, lun, /force
        return, 0
    endif
endif

; Let user specify file to load
title = 'Select PSD Calibration Parameter file to load'
etc = {filter:'*.txt',multiple_files:0}
calidFileNameExists = (strlen(Self.calibParamsFilename) gt 0) && $
                       file_test(Self.calibParamsFilename)
if (calidFileNameExists) then $
  etc = create_struct(etc,'path',file_dirname(Self.calibParamsFilename))
filename = Self->GetFileList(title,count,newPath=newPath,_EXTRA=etc)
if (count eq 0) then return, 0
if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath

lines = ''
openr, lun, filename, /get_lun
readf, lun, lines
isCalib = stregex(lines[0],'SPINS PSD Calibration',/fold,/bool)
if (~isCalib) then begin
   msg = [Filename, 'is not a proper SPINS calibration parameter file']
   Self->ErrorMessage, msg,title='Invalid file',severity=1
   free_lun, lun, /force
   return, 0
endif
nlines = 1
while (~EOF(lun)) do begin
  readf, lun, lines
  if (~strcmp(lines,'#',1)) then break
  nlines++
endwhile
point_lun, lun, 0 ; rewind to beginning of file

lines = strarr(nlines)
nPixel = 0
readf, lun, lines,nPixel

buf1 = fltarr(nPixel)
buf2 = fltarr(nPixel)
buf3 = fltarr(nPixel)
readf, lun, buf1,buf2,buf3
free_lun, lun, /force

Self.chEff = buf2
Self.chDelA4 = buf3
Self.chEf = buf1
Self.calibParamsIsSet = 1
Self.calibParamsFilename = filename
Self.calibParamsBaseFilename = file_basename(filename)
 
; parse efficiencies for Pixels to be masked by default - will have negative efficiencies
maskIndex = where(stregex(lines,'Pixels to be masked',/fold,/bool) eq 1, maskFound)
index = where(Self.chEff lt 0.0, nMask)
if (nMask gt 0) then begin
   status = intVector2CompactString(index+1,sIndex)   ; index+1 converts indices to Pixel number
   Self->SetProperty, MASKEDDETS=sIndex
   Self->SetPropertyAttribute, 'MASKEDDETS', userdef=sIndex, sensitive=1
   Self->SetProperty, MASKFLAG=1
endif else if (maskFound) then begin
   ; check if there are channels to be masked in header section
   ; this is the new way of specifying channels for masking
   toks = strsplit(lines[maskIndex[0]],':',/extract,count=ntoks)
   if (ntoks eq 2 && strtrim(toks[1]) ne '') then begin
     Self->SetProperty, MASKEDDETS=strtrim(toks[1])
     Self->SetPropertyAttribute, 'MASKEDDETS', userdef=strtrim(toks[1]), sensitive=1
     Self->SetProperty, MASKFLAG=1
   endif
endif

 
Self->SetPropertyAttribute, 'calibParamsBaseFilename', userdef=Self.calibParamsBaseFilename
Self->SetPropertyAttribute, 'effNormFlag', sensitive=1
 
Self->refreshPropertySheet

; re-evaluate calculated quantities for already loaded datasets
Self->GetProperty, sampContRef=oCont
oData = oCont->Get(/all,count=nData)
for i = 0, nData-1 do Self->UpdateCalculation, oData[i]

; initiate a plot event to update any plotted data
wd_SPINSpsdTool_sendPlotEvent, Self->GetUI()

return, 1

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::loadSampFtp
;
; PURPOSE:
;   Specify and load sample data file(s) from NCNR ftp server
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::loadSampFtp

return, Self->LoadSamp(/fromFtp)

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSpsdTool::loadSamp
;
; PURPOSE:
;   Specify and load sample data file(s)
;
; PARAMETERS:
;
; KEYWORDS:
; 
;   dataObject - specifies the data object whose data is to be reloaded
;   
;   reload  - set if the data specified by the dataObject keyword is to be reloaded
;   
;   fromFTP - set if the source of the datafile to be loaded is the FTP server
;-
function SPINSpsdTool::loadSamp, reload=reload, dataObject=oItem, fromFTP=fromFTP

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::loadSamp: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle, dialog_parent=wTLB)
        catch, /cancel
        Self->EnableUpdates
        return, 0
    endif
endif

reloading = keyword_set(reload)
if (reloading) then begin
   if (~obj_valid(oItem)) then return, 0
   oItem->GetProperty, description=files
   count = 1
   void = oItem->GetMetaData('FROMFTP',fromFtp)
   ;if (~Self->ReadData(filename, dataPtr)) then return, 0
endif else begin
   ; Let user specify files to load
   title = 'Select Sample Files to Load'
   
   files = Self->GetFileList(title,count,fromFTP=fromFTP,newPath=newPath)
   if (count eq 0) then return, 0
   if (n_elements(newPath) gt 0) then Self->SetProperty, data_directory=newPath
endelse

; switch on the busy symbol for cursor
widget_control, /HOURGLASS

Self->DisableUpdates
; Read the contents of the data files and make entries in the 'Sample' tree of the data manager
Self->GetProperty, sampContRef=oCont, nSamp=nData
oItems = []
A2s = []
for i=0, count-1 do begin

   filename = files[i]
   if (~Self->readData(filename, dataPtr, fromFTP=fromFTP)) then begin
      if (ptr_valid(dataPtr)) then heap_free, dataPtr
      continue
   endif

   basename = file_basename(filename,'.ng5',/fold_case)

   if (~reloading) then begin
      ;; create new object and attach dataPtr
      oItem = obj_new('IDLitParameterSet',name=basename,description=filename,type='samp')   
      oItem->AddMetaData,'DATAPTRREF',dataPtr
      oItem->AddMetaData,'FROMFTP',keyword_set(fromFTP)
      
      ; iTools does not handle '_[0-9]' characters in identifiers well eg _0, _1, etc
      ; replace all '_' with '-'
      oItem->GetProperty, identifier=idd
      hasChanged = 0
      while ((pos = stregex(idd,'_[0-9]')) ne -1) do begin
         strput, idd,'-',pos
         hasChanged = 1
      endwhile
      if (strmatch(idd,'[0-9]*')) then begin   ; if first char is a number
         idd = 'id'+idd
         hasChanged = 1
      endif
      if (hasChanged) then oItem->SetProperty,identifier=idd 
      
      if ((*dataPtr).scanType eq 'I') then begin
        ; I-Scan specific
        A2 = (*(*dataPtr).a2)[0]
        oItem->AddMetaData,'A2VALUE',A2
        oItems = [oItems,oItem]
        A2s = [A2s,A2]
      endif else begin
        ; Add to the data manager
        Self->AddByIdentifier, 'Sample Data Manager', oItem, position=0
      endelse
   endif else begin
      ;; simply replace previous dataPtr with updated one
      void = oItem->GetMetaData('DATAPTRREF',tempPtr)
      if (ptr_valid(tempPtr)) then heap_free, tempPtr
      oItem->AddMetaData,'DATAPTRREF',dataPtr
   endelse
   
   ; Update calculations (q,e,intensity) for data
   Self->UpdateCalculation, oItem
   
   if (~reloading) then begin
      oCont->Add, oItem
      Self.nSamp++
   endif

   dataPtr = 0   ; make dataPtr invalid before it is used again when looping
endfor

if (n_elements(oItems) gt 0) then begin
  ; Sort by A2 value and add to the data manager
  n = n_elements(oItems)
  index = sort(A2s)
  for i=0,n-1 do begin
      Self->AddByIdentifier, 'Sample Data Manager', oItems[index[i]]   
  endfor
endif
; TODO
;if ((Self.nSamp gt 1) && sumFlag) then Self->MergeData, 'samp'
;
;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
;Self->refreshPropertySheet   ; force prop sheet to update

Self.modifiedFlag = 1
Self->EnableUpdates

nSamp = oCont->Count()
wChild = WIDGET_INFO(wTLB, /CHILD)
WIDGET_CONTROL, wChild, GET_UVALUE=sPtr
widget_control, (*sPtr).wMslice, sensitive=(nSamp gt 0) 
;widget_control, (*sPtr).wDaveDM, sensitive=(nSamp gt 0)
;widget_control, (*sPtr).wPAN, sensitive=(nSamp gt 0)

Self->UpdatePropertySheet
Self->RefreshPropertySheet

return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdateCalculation
;
; PURPOSE:
;   Update the PSD wavevector and energy transfer for the dataset
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;
pro SPINSpsdTool::UpdateCalculation, oPSet
compile_opt idl2

void = oPSet->GetMetaData('DATAPTRREF',dataPtr)
if (~ptr_valid(dataPtr)) then return
dataStr = *dataPtr
dSpaceA = dataStr.dSpaceA
dSpaceM = dataStr.dSpaceM
nPix = dataStr.nPix
nPts = datastr.nPts
unitVecnPts = Fltarr(nPts) + 1.0
unitVecnPix = Fltarr(nPix) + 1.0
scanType = dataStr.scanType

Self->GetProperty, QUNITS=rlu ;  rlu = 0 => 1/A, 1 => r.l.u.
ekFac = Self.ekFac  ; E = ekFac * k^2

; calibration stuff
chEff = abs(Self.chEff) ; some values may be negative, signfying Pixels intended to be masked
chEf = Self.chEf  ; final energies for each pixel
chDelA4 = Self.chDelA4  ; A4 for each pixel relative to the cental one (at index 127)

oPSet->AddMetaData,'scanType',scanType
Self.scanType=scanType

case scanType of   
   'I': begin    ;; powder

      ; norminal values for ei, ef, a3, a4
      eio = (*dataStr.ei)
      efo = (*dataStr.ef)
      eo = (*dataStr.e)

      ;a4o = (*dataStr.a4)

      ; initialize a few variables
      A4 = []
      qtot = []
      omega = []
      counts = []

      ; calculate 2theta for individual pixels relative to the central pixel from the final energies
      ; the central pixel is assummed to be pixel 127 out of 256
      rtod = 1.0/!dtor
      dtthetap = chDelA4  ;rtod*(Asin(!pi/(dSpaceA*Sqrt(chEf/ekFac))) - Asin(!pi/(dSpaceA*Sqrt(chEf[127]/ekFac))))
      
      ;t0 = systime(/seconds)

      ;Loop through data points in dataset:
      ; - calculate q, e and dspace
;      for i = 0, nPts-1 do begin
;        omega = [[omega],[eio[i] - chEf]]
;        a4p = (*dataStr.a4)[i] + dtthetap
;        Qp = Sqrt((Eio[i] + chEf - 2*sqrt(Eio[i]*chEf)*Cos(!dtor*a4p))/ekFac)
;
;        a4 = [[a4],[a4p]]
;        qTot = [[qTot],[Qp]]
;        counts = [[counts],[(*dataStr.PSDDETS)[*,i]]]
;      endfor
      
      Ei = unitVecnPix # Eio
      Ef = chEf # unitVecnPts
      omega = Ei - Ef
      A4 = (unitVecnPix # (*dataStr.a4)) + (dtthetap # unitVecnPts)
      qTot = Sqrt((Ei + Ef - 2*Sqrt(Ei*Ef)*Cos(!dtor*A4))/ekFac)
      counts = (*dataStr.PSDDETS)
      
      ;print,'########## Calculation time = ',systime(/seconds) - t0

      qType = partype(qTot)
      ; A4
      oA4 = IDLitData(A4,name='2Theta',/no_copy,type=qtype)
      oA4->AddMetaData,'Long_name','$2\theta$'
      oA4->AddMetaData,'Units','$\deg$'
      ; d-space
      odsp = IDLitData(2*!pi/qTot,name='dspace',type=qtype)
      odsp->AddMetaData,'Long_name','d'
      odsp->AddMetaData,'Units','$\AA$'
      ; Q
      oQTot = IDLitData(qTot, name='|Q|',/no_copy,type=qtype)
      oQTot->AddMetaData,'Long_name','|Q|'
      oQTot->AddMetaData,'Units','$\AA^{-1}$'
      ; E
      oE = IDLitData(omega, name='E',/no_copy,type=qtype)
      oE->AddMetaData,'Long_name','E'
      oE->AddMetaData,'Units','meV'
      ; Data point index
      dPt = indgen(nPts) + 1
      dPt = unitVecnPix # dPt
      odPt = IDLitData(name='Data_Index',dpt,/no_copy,type=partype(dpt))
      odPt->AddMetaData,'Long_name','Data Index'
      odPt->AddMetaData,'Units',''
      
;      ; Monitor
      mon = unitVecnPix # (*dataStr.mon)  ; replicate mon at each datapoint to all 256 Pixels of PSD
;      ; TIME
      time = unitVecnPix # (*dataStr.time)
      ; TEMP
      temp = unitVecnPix # (*dataStr.temp)
      oTemp = IDLitData(temp,name='TEMP',/no_copy,type=qtype)
      oTemp->AddMetaData,'Long_name','Temperature'
      oTemp->AddMetaData,'Units','K'
      ; magfield
      magfield = unitVecnPix # (*dataStr.magfield)
      oMagfield = IDLitData(magfield,name='MAGFIELD',/no_copy,type=qtype)
      oMagfield->AddMetaData,'Long_name','Magnetic-field'
      oMagfield->AddMetaData,'Units','T'

      ; Pixel Effieciencies
      chEff = chEff # unitVecnPts       ; creates a array of dims [nCh,nPts]
      ;oChEff = IDLitData(name='PSDPixelEff',chEff,/no_copy,type=qType)

      ; Error
      zType = partype(counts)
      oErr = IDLitData(name='Error',type=ztype) ; NULL data to start
      oErr->AddMetaData,'Long_name','Error'
      oErr->AddMetaData,'Units',''
      ; Counts
      oZ = IDLitData(name='Counts',type=ztype)  ; NULL data to start
      oZ->AddMetaData,'Long_name','Counts'
      oZ->AddMetaData,'Units',''
      oZ->AddMetaData,'Signal', 1
      oZ->AddMetaData,'OriginalCounts',counts
      oZ->AddMetaData,'CHEFF',ChEff
      oZ->AddMetaData,'CHDELA4',dtthetap
      oZ->AddMetaData,'TIME',time
      oZ->AddMetaData,'MON',mon
      oZ->AddMetaData,'NPTS',nPts
      oZ->AddMetaData,'NPIX',nPix
      oZ->AddMetaData,'KF',sqrt(Ef/ekFac)
      
      ;PSD Pixel Nos
      ch = indgen(nPix) + 1
      ch = ch # unitVecnPts ; creates a array of dims [nPix,nPts], same as counts variable
      oChNos = IDLitData(name='PSDPixel',ch,/no_copy,type=partype(ch))
      oChNos->AddMetaData,'Long_name','PSD Pixel Nos'
      oChNos->AddMetaData,'Units',''
      
      
      oPSet->Add, [oA4,oDsp,oE,oQTot,oTemp,oMagfield,oZ,oErr,oDPt,oChNos], $
                  parameter_name=['2Theta','d-space','E','|Q|','TEMP','MAGFIELD','Counts','Error','Data_Index','PSDPixel']
 
      Self->UpdatePowderVariables, oPSet
   
   end 
   
   'Q': begin    ;; single crystal

      ; norminal values for ei, ef, a3, a4
      Eio = (*dataStr.ei)
      Ei = unitVecnPix # Eio
      Ef = chEf # unitVecnPts
      omega = Ei - Ef

      ; initialize a few variables
      qTot = []
      qx = []
      qy = []
      counts = []
      Temp = []
      magfield = []
      mon = []

;      ; calculate 2theta for individual pixels relative to the central pixel from the final energies
;      ; the central pixel is assummed to be pixel 127 out of 256
;      rtod = 1.0/!dtor
;      dtthetap = rtod*(Asin(!pi/(dSpaceA*Sqrt(chEf/ekFac))) - Asin(!pi/(dSpaceA*Sqrt(chEf[127]/ekFac))))

      qType = partype(omega)
      
      ; Q
      ;qType = partype(qTot)
      oQTot = IDLitData(qTot,name='|Q|',/no_copy,type=qtype)
      oQTot->AddMetaData,'Long_name','|Q|'
      oQTot->AddMetaData,'Units','$\AA^{-1}$'
      ; E
      oE = IDLitData(omega,name='E',/no_copy,type=qtype)
      oE->AddMetaData,'Long_name','E'
      oE->AddMetaData,'Units','meV'
      ; Qx
      oQx = IDLitData(qx,name='QX',/no_copy,type=qtype)
      oQx->AddMetaData,'Long_name',''
      oQx->AddMetaData,'Units',''
      oQx->AddMetaData,'RLU',rlu
      oQx->AddMetaData,'AA2RLU',1            ; will be updated later in UpdateQxQy method
      ; Qy
      oQy = IDLitData(qy,name='QY',/no_copy,type=qtype)
      oQy->AddMetaData,'Long_name',''
      oQy->AddMetaData,'Units',''
      oQy->AddMetaData,'RLU',rlu
      oQy->AddMetaData,'AA2RLU',1            ; will be updated later in UpdateQxQy method
      
      unitVec = fltarr(nPix) + 1.0 
      
      ; Data point index
      dPt = indgen(nPts) + 1
      dPt = unitVec # dPt
      odPt = IDLitData(name='Data_Index',dpt,/no_copy,type=partype(dpt))
      odPt->AddMetaData,'Long_name','Data Index'
      odPt->AddMetaData,'Units',''
      ; Monitor
      mon = unitVec # (*dataStr.mon)  ; replicate mon at each datapoint to all 256 Pixels of PSD
      ;oMon = IDLitData(mon,name='MON',/no_copy,type=qtype)
      ;oMon->AddMetaData,'Long_name','Monitor'
      ;oMon->AddMetaData,'Units',''
      ; TIME
      time = unitVec # (*dataStr.time)
      ;oTime = IDLitData(time,name='TIME',/no_copy,type=qtype)
      ;oTime->AddMetaData,'Long_name','Time'
      ;oTime->AddMetaData,'Units','seconds'
      ; TEMP
      temp = unitVec # (*dataStr.temp)
      oTemp = IDLitData(temp,name='TEMP',/no_copy,type=qtype)
      oTemp->AddMetaData,'Long_name','Temperature'
      oTemp->AddMetaData,'Units','K'
      ; magfield
      magfield = unitVec # (*dataStr.magfield)
      oMagfield = IDLitData(magfield,name='MAGFIELD',/no_copy,type=qtype)
      oMagfield->AddMetaData,'Long_name','Magnetic-field'
      oMagfield->AddMetaData,'Units','T'

      ;PSD Pixel Nos
      unitVec = intarr(nPts) + 1
      pix = indgen(nPix) + 1
      pix = pix # unitVec ; creates a array of dims [nPix,nPts], same as counts variable
      oPixNos = IDLitData(name='PSDPixel',pix,/no_copy,type=partype(pix))
      oPixNos->AddMetaData,'Long_name','PSD Pixel Nos'
      oPixNos->AddMetaData,'Units',''
      
      ; Pixel Effieciencies
      chEff = chEff # unitVec
      ;oChEff = IDLitData(name='PSDPixelEff',chEff,/no_copy,type=qType)


      ; Error
      counts = (*dataStr.PSDDETS)
      zType = partype(counts)
      oErr = IDLitData(name='Error',type=ztype) ; NULL data to start
      oErr->AddMetaData,'Long_name','Error'
      oErr->AddMetaData,'Units',''
      ; Counts
      oZ = IDLitData(name='Counts',type=ztype)  ; NULL data to start
      oZ->AddMetaData,'Long_name','Counts'
      oZ->AddMetaData,'Units',''
      oZ->AddMetaData,'Signal', 1
      oZ->AddMetaData,'OriginalCounts',counts
      oZ->AddMetaData,'CHEFF',ChEff
      oZ->AddMetaData,'CHEF',Ef
      oZ->AddMetaData,'CHEI',Ei
      oZ->AddMetaData,'KF',sqrt(Ef/ekFac)
      oZ->AddMetaData,'TIME',time
      oZ->AddMetaData,'MON',mon     
      ;oZ->AddMetaData,'dttp',dtthetap 
      
      oPSet->Add, [oQx,oQy,oE,oQTot,oTemp,oMagfield,oZ,oErr,oDPt,oPixNos], $
                  parameter_name=['QX','QY','E','|Q|','TEMP','MAGFIELD','Counts','Error','Data_Index','PSDPixel']

      ;
      Self->UpdateIndependentVariables, oPSet
      Self->UpdateCounts, oPSet
   
   end
endcase
   


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdatePowderVariables
;+
; PURPOSE:
;   Update all variables (dependent and independent) to reflect current user settings
;   Only applicable to powder samples
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdatePowderVariables, oPSet
compile_opt idl2

if ((n_elements(oPSet) eq 0) || ~obj_valid(oPSet[0])) then begin
   ; retrieve all loaded datasets
   Self->GetProperty, sampContRef=oCont
   oPSet = oCont->Get(/all,count=nData)
endif else begin
   nData = n_elements(oPSet)
endelse

if (nData eq 0) then return

Self->GetProperty, MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, MONCORFLAG=monCorFlag $
                 ,RESCORFLAG=resCorFlag, FASTFLAG=fastFlag, FASTVALUE=fastVal,logFlag=logFlag $
                 ,DETAILEDBALANCEFLAG=detBalFlag,effNormFlag=effFlag, scanType=scanType $
                 ,nBkgd=nBkgdData, bkgdFlag=bkgdFlag, oneOverKfFlag=oneOverKfFlag

if (bkgdFlag && (nBkgdData gt 0)) then begin
  ; retrieve all loaded bkgd datasets
  Self->GetProperty, bkgdContRef=oBkgdCont
  oBkgdPSet = oBkgdCont->Get(/all,count=nBkgdData)
  A2s = []
  for i=0,nBkgdData-1 do begin
    status = oBkgdPSet[i]->GetMetaData('A2Value',A2)
    A2s = [A2s,A2]
  endfor
endif

maxVals = []
minVals = []

for i=0,nData-1 do begin
   oData = oPSet[i]
   oZ = oData->GetByName('Counts')
   if (~obj_valid(oZ)) then return
   status = oData->GetMetaData('SCANTYPE',scanType)
   if (scanType ne 'I') then continue  ; only proceed if dataset was an increment or 'I' scan
   
   oErr = oData->GetByName('Error')
   if (~obj_valid(oErr)) then return
   if (~oZ->GetMetaData('OriginalCounts',counts)) then return
   error = counts
   index = where(error le 0.0,cnt)
   if (cnt gt 0) then error[index] = 1.0
   error = sqrt(error)
   
   oData->GetProperty, type=dataType  ; either 'samp' or 'bkgd'
   isSamp = strcmp(dataType,'samp',/fold)
   if (bkgdFlag && (nBkgdData gt 0) && isSamp) then begin
      ; Perform Bkgd subtraction for sample datasets
      ; Can only subtract a bkgd data that has the same A2 as the sample
      status = oData->GetMetaData('A2Value',A2)
      index = where(A2s eq A2,found)
      if (found) then oBkgdZ = oBkgdPSet[index[0]]->GetByName('Counts')
      if (obj_valid(oBkgdZ)) then begin
        status = oBkgdZ->GetMetaData('OriginalCounts',bkgdCounts)
        status = oBkgdZ->GetMetaData('MON',monBkgd)
        oBkgdZ = !NULL
        if (status && (n_elements(counts) eq n_elements(bkgdCounts))) then begin
          status = oZ->GetMetaData('MON',monSamp)
          bkgdScale = float(monSamp[0]/monBkgd[0])
          counts = temporary(counts) - bkgdCounts*bkgdScale
          error = sqrt(temporary(error)^2 + bkgdCounts*bkgdScale)
        endif
      endif
   endif
   
   if (effFlag) then begin
      if (~oZ->GetMetaData('CHEFF',chEff)) then return
      counts = temporary(counts)/chEff
      error = temporary(error)/chEff
   endif

   if (fastFlag) then begin   ; perform corrections that depend on first applying fast bkgd correction
      ;; Apply fast Correction
      if (fastVal ne 0.0) then begin
         status = oZ->GetMetaData('TIME',time)
         counts = temporary(counts) - (time/60.0)*fastVal ; time is measured in secs and fastVal is fast bkgd in cnts/min
      endif
      
      ;; Apply monitor correction
      if (monCorFlag) then begin
         ;; Constraints are:
         ;; 1 - PG monochromator is in use (d spacing = 3.354)
         ;; 2 - 5 <= Ei <= 34; For Ei < 5, flag an error, for Ei > 34, correction = 1
         ;; CF(Ei) = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
         status = oData->GetMetaData('DATAPTRREF',dataPtr)
         if (~ptr_valid(dataPtr)) then return
         dspacem = (*dataPtr).dspacem  ; d spacing of monochromator
         diff = abs(dspacem - 3.354)
         PGMON = diff lt 0.001
         status = oData->GetMetaData('EI',Ei)
         index = where(Ei lt 5.0,Eilt5)  ; correction not aloowed if Ei < 5.0 meV
         if (Eilt5) then begin
            msg = ['Ei is lower than 5.0 meV.','Monitor correction was not applied']
            title = 'Monitor Correction'
            Self->ErrorMessage,msg,title=title,severity=0
         endif else if (PGMON) then begin
            M0 =  6.1230
            M1 = -5.9630e-1
            M2 =  2.6244e-2
            M3 = -4.8430e-4
            M4 =  2.8810e-6
            index = where(Ei gt 34.0,Eigt34)
            CFEi = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
            if (Eigt34) then CFEi[index] = 1.0  ; for Ei > 34, CF = 1
            counts = TEMPORARY(counts)*CFEi
            error  = TEMPORARY(error)*CFEi 
         endif
      endif 
      
;      if (resCorFlag) then begin
;         ; apply resolution correction
;      endif
;      
;      if (detBalFlag) rhen begin
;         ; apply detailed balance correction
;      endif
   endif
   
   if (oneOverKfFlag) then begin
     status = oZ->GetMetaData('KF',kf)
     counts = TEMPORARY(counts)/kf
     error  = TEMPORARY(error)/kf      
   endif
   
   
   ;; Apply monitor normalization
   case normTo of
   
      0: begin
         ;oMon = oData->GetByName('MON')
         ;status = oMon->GetData(mon)
         status = oZ->GetMetaData('MON',mon)
         monScale = monScaleVal/mon
      end
      
      1: begin
         if (~isa(time)) then begin    ; may have retrieve time already
            ;oTime = oData->GetByName('TIME')
            ;status = oTime->GetData(time)
            status = oZ->GetMetaData('TIME',time)
         endif
         monScale = monScaleVal/time
      end
      
      else: monScale = monScaleVal
   endcase
   counts = TEMPORARY(counts)*monScale
   error = TEMPORARY(error)*monscale
   
   ;; Mask bad Pixels
   Self->GetProperty, maskFlag=maskFlag
   sBadChans = Self.maskedDets
   maskedChansExist = ~strcmp(sBadChans,'')
   if (maskFlag && maskedChansExist) then begin
      status = compactstring2intvector(sBadChans, badChans)
      badChanIndex = badChans - 1   ; convert Pixel nos to 0-based Pixel index
      ; Apply mask by simple replacing the counts in the masked Pixels by NaNs
      ; Set corresponding error to 0.0
      counts[badChanIndex,*] = !values.F_NAN
      error[badChanIndex,*] = 0.0
   endif
   
   maxVal = max(counts, min=minVal,/NAN)
   maxVals = [maxVals,maxVal]
   minVals = [minVals,minVal]
   
   ; Save copy of counts in linearCount metadata 
   oZ->AddMetaData, 'linearCounts',counts
   
   ; take a log of the data if necessary
   if (logFlag) then begin
      index = where(counts le 0.0, nBad)
      if (nBad gt 0) then counts[index] = !values.F_NAN
      counts = alog10(temporary(counts))
   endif
   
   status = oZ->SetData(counts,/no_copy);,/no_notify)
   status = oErr->SetData(error,/no_copy,/no_notify)
endfor

; If max and min intensity properties are undefined,
; use the current max and min values to define them
if ((Self.minIntensity eq 0.0) && (Self.maxIntensity eq 0.0)) then begin
   ; NB: This should run at most once during a session!

   minVal = min(minVals)   ; these are linear values!
   maxVal = max(maxVals)
   
   ; take a log of the intensity limits if necessary
   case logFlag of
     0:
     
     1: begin ; log scale is active
        minVal = (minVal gt 0.0)? alog10(minVal) : 0.0
        maxVal = (maxVal gt 0.0)? alog10(maxVal) : 0.0
     end
   endcase

   Self.maxIntensity = maxVal
   Self.minIntensity = minVal
endif


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::MergePowderPixels
;+
; PURPOSE:
;   Merge the PSD Pixels together for powder samples so that overlapping data 
;   determined with respect to the specified xvalues (x) are combined such 
;   that the corresponding errors are added in quadrature. NaNs are appropriately handled 
;
; PARAMETERS:
;   x [in|out] - the xvalues controlling how the data are to be merged
;   
;   counts [in|out] - the data to be merged
;   
;   error [in|out] - the error are to be added in quadrature where there is overlap
;
; KEYWORDS:
;      
;   tolerance - any two values seperated by less than or equal to tolerance are treated 
;               as the same and hence added in quadrature. 
;   
;   sumPixels - Set this keyword to simply sum counts and error wrt to the Pixel dimension 
;                 to have counts at each data point
;-
pro SPINSpsdTool::MergePowderPixels, x, counts, error, tolerance=tol, sumPixels=sumPixels
;pro MergePowderPixels, x, counts, error, tolerance=tol, sumPixels=sumPixels
compile_opt idl2

; Note: if xvals, counts and error are 2D then they are of the form 
; counts[n_ch, n_pts] where 
;     n_ch are the nos of PSD Pixels and 
;     n_pts are the number of data points

dimC = size(counts,/N_DIMENSIONS)
if (keyword_set(sumPixels) && (dimC eq 2)) then begin
   ;; simply sum counts and error wrt to the Pixel dimension to have counts at each data point
   counts = total(temporary(counts),1,/NAN)
   error = sqrt(total(temporary(error)^2,1,/NAN))
   return
endif

; if x is not varying then simply sum everthing and return scalars
xmax = max(x,min=xmin)
if (xmax eq xmin) then begin
   x = x[0]
   counts = total(counts,/NAN)
   error = total(error,/NAN)
   return
endif

dimX = size(x,/N_DIMENSIONS)
if (dimX eq 2) then x = reform(x,n_elements(x),/OVERWRITE)
if (dimC eq 2) then begin
   counts = reform(counts,n_elements(counts),/OVERWRITE)
   error = reform(error,n_elements(error),/OVERWRITE)
endif
;if (n_elements(tol) eq 0) then tol = 0.001
Self->GetProperty, minbinWidth=tol

; sort data in ascending x order
sindex = sort(x)
x = x[sindex]
counts = counts[sindex]
error = error[sindex]

; Get rid of data points that are NaNs
nanIndex = where(finite(counts,/NAN),nanPresent, complement=validIndex)
if (nanPresent gt 0) then begin
   x = x[validIndex]
   counts = counts[validIndex]
   error = error[validIndex]
endif

;;----------------------------------------------------
;; append a dummy point at the end which is necessary for the 
;; algorithm to work properly but otherwise does not affect the results
;counts = [counts,!values.F_NAN]
;x = [x,2*tol]
;error = [error,0.0]
;
;nElmts = n_elements(counts)
;sf = fltarr(nElmts) + 1.0   ; each pt has a default weight of 1
;
;; if there are NaN's in counts, note the locations by setting their sf to 0.0
;nanIndex = where(finite(counts,/NAN),nanPresent)
;if (nanPresent gt 0) then sf[nanIndex] = 0.0
;
;; locate all duplicate x values within the specified tolerance
;diff = abs(x[0:nElmts-2] - x[1:nElmts-1])
;dupIndex = where(diff lt tol, complement=uniqIndex, nDup)
;
;; sum all points sharing the same x value (the duplicates)
;i = 0
;while (i lt ndup) do begin
;   index = [dupIndex[i], dupIndex[i]+1]   ; each entry in dupIndex ==> a dup pair in x
;   for j=i, nDup-1 do begin
;      gap = 2  ; the default gap
;      if (j lt nDup-1) then gap = abs(dupIndex[j] - dupIndex[j+1])
;      if (gap eq 1) then $ ;==> more than two consecutive x values are the same 
;         index = [index,dupIndex[j]+2] $
;      else $
;         break
;   endfor
;   i = j + 1
;   
;   ; sum the duplicates found so far
;   counts[dupIndex[j]+1] = total(counts[index],/NAN)
;   error[dupIndex[j]+1] = sqrt(total(error[index]^2,/NAN))
;   sf[dupIndex[j]+1] = total(sf[index],/NAN)
;   
;   ; a sf of 0.0 => the corresponding count should be undefined. This explicit 
;   ; assignment is necessary b/c total(counts[index],/NAN)will return 0.0 instead of
;   ; a NaN if counts[index] contains all NaNs
;   if (sf[dupIndex[j]+1] eq 0.0) then counts[dupIndex[j]+1] = !values.F_NAN
;endwhile
;
;if (nDup gt 0) then begin
;   counts = temporary(counts[uniqIndex])/sf[uniqIndex]
;   error = temporary(error[uniqIndex])/sf[uniqIndex]
;   x = x[uniqIndex]
;endif else begin
;   ;; remove that last dummy point that was added
;   x = x[0:nElmts-2]
;   counts = counts[0:nElmts-2]
;   error = error[0:nElmts-2]
;endelse
;;-------------------------------------------------------

;; Locate duplicate x values
;nElmts = n_elements(counts)
;i = 0
;uniqIndex = []
;dupIndex = []
;while (i lt nElmts-1) do begin
;   uniqIndex = [uniqIndex,i]
;   for j = i, nElmts-2 do begin
;      diff = abs(x[i] - x[j+1])
;      if (diff gt tol) then break
;      dupIndex = [dupIndex,i]
;   endfor
;   i = j + 1
;endwhile 
;nDup = n_elements(dupIndex)
;
;xout = x[uniqIndex]
;zin =counts
;ein = error
;drebin,x,counts,error,xout,zout,zeout,/points,/to_points,err=err,emsg=emsg
;if (err ne 0) then return
;x = xout
;counts = zout
;error = zeout


; Locate duplicate x values
nElmts = n_elements(counts)
i = 0
newx = []
newc = []
newe = []
while (i lt nElmts-1) do begin
   index = i
   for j = i, nElmts-2 do begin
      diff = abs(x[i] - x[j+1])
      if (diff le tol) then begin
         index = [index,j+1]
      endif else begin
         break
      endelse
   endfor
   i = j + 1
   xmean = (moment(x[index],maxmoment=1))[0]
   newx = [newx,xmean]
   c1 = total(counts[index],/NAN)/float(n_elements(index))
   e1 = sqrt(total(error[index]^2,/NAN))/float(n_elements(index))
   newc = [newc,c1]
   newe = [newe,e1]
;   if (i gt 6189) then begin
;      print,i
;   endif
endwhile
lastIndex = index[n_elements(index)-1]
if (lastIndex eq nElmts-2) then begin
   newx = [newx,x[nElmts-1]]
   newc = [newc,counts[nElmts-1]]
   newe = [newe,error[nElmts-1]]
endif 
x = newx
counts = newc
error = newe

end
;-------------------------------------------------------------------------------

;===============================================================================
; SPINSpsdTool::MergeDupGroups
;+
; PURPOSE:
;   For the specified 2D dataset, merge groups that have overlapping values. Use the
;   specified tolerance to determine if group values are the same or not. Groups are combined such 
;   that the corresponding errors are added in quadrature. NaNs are appropriately handled 
;
; PARAMETERS:
;   y [in|out] - the y or group values that determine how the data are to be merged
;   
;   counts [in|out] - the data to be merged
;   
;   error [in|out] - the error are to be added in quadrature where there is overlap
;
; KEYWORDS:
;      
;   tolerance - any two values seperated by less than or equal to tolerance are treated 
;               as the same and hence added in quadrature. 
;   
;-
pro SPINSpsdTool::MergeDupGroups, y, z, dz, tolerance=tol
compile_opt idl2

; y must be a vector
; z and dz are 2D of dimension 
; z[n_x, n_y] where 
;     n_x are nos of x values 
;     n_y are the number of y values or groups
if (size(z,/n_dimensions) ne 2) then return
if (size(dz,/n_dimensions) ne 2) then return
if (size(y,/n_dimensions) ne 1) then return

dims = size(z,/dimensions)
n_x = dims[0]
n_y = dims[1]
if (size(y,/dimensions) ne n_y) then return

; Locate duplicate y values
i = 0
while (i lt n_y-1) do begin
   index = i
   for j = i, n_y-2 do begin
      diff = abs(y[i] - y[j+1])
      if (diff le tol) then begin
         index = [index,j+1]
      endif else begin
         break
      endelse
   endfor
   i = j + 1
   ymean = (moment(y[index],maxmoment=1))[0]
   nIndex = n_elements(index)
   if (nIndex gt 1) then begin
     c1 = total(z[*,index],2,/NAN)/float(nIndex)
     e1 = sqrt(total(dz[*,index]^2,2,/NAN))/float(nIndex)
   endif else begin
     c1 = z[*,index]
     e1 = dz[*,index]
   endelse
   if (size(c1,/n_dimensions) eq 1) then begin
     c1 = reform(c1,n_x,1)
     e1 = reform(e1,n_x,1)
   endif
   if (n_elements(newy) eq 0) then begin
     newy = ymean
     newc = c1
     newe = e1
   endif else begin
     newy = [newy,ymean]
     newc = transpose([transpose(newc),transpose(c1)])
     newe = transpose([transpose(newe),transpose(e1)])
   endelse
;   if (i gt 6189) then begin
;      print,i
;   endif
endwhile
lastIndex = index[n_elements(index)-1]
if (lastIndex eq n_y-2) then begin
  ; the last group was not processed so include it.
   newy = [newy,y[n_y-1]]
   c1 = reform(z[*,n_y-1],n_x,1)
   e1 = reform(dz[*,n_y-1],n_x,1)
   newc = transpose([transpose(newc),transpose(c1)])
   newe = transpose([transpose(newe),transpose(e1)])
endif 
y = newy
z = newc
dz = newe



;
;
;
;; Look for duplicate y values and merge the corresponding groups in z and dz
;diff = abs(y[0:n_y-2] - y[1:n_y-1])
;dupIndex = where(diff lt tol, complement=uniqIndex, nDup)
;if (nDup le 0) then return
;
;i = 0
;mon = fltarr(n_x,n_y) + 1.0
;nanIndex = where(finite(z,/NAN),nanPresent);, complement=validIndex)
;if (nanPresent gt 0) then mon[nanIndex] = 0.0 ; set mon eq 0 for undefined counts
;
;while (i lt nDup) do begin
;   index = [dupIndex[i], dupIndex[i] + 1]   ; each entry in dupIndex implies a dup pair in y
;   for j = i, nDup-1 do begin
;      gap = 2
;      if (j lt nDup-1) then gap = abs(dupIndex[j] - dupIndex[j+1])
;      if (gap eq 1) then $ => more than two consecutive values are the same in y
;         index = [index, dupIndex[j] + 2] $
;      else $
;         break
;   endfor
;   ;print,index
;   i = j + 1
;   
;   ; add up duplicate entries
;   z[*,dupIndex[j]+1] = total(z[*,index], 2, /NAN) 
;   dz[*,dupIndex[j]+1] = sqrt(total(dz[*,index]^2, 2, /NAN)) 
;   mon[*,dupIndex[j]+1] = total(mon[*,index], 2, /NAN)
;   zeroMonIndex = where(mon[*,dupIndex[j]+1] eq 0.0,zeroMonCnt)
;   if (zeroMonCnt gt 0) then begin
;      ;a mon value of 0.0 signifies that the corresponding count should be undefined
;      ;so make sure those values are replaced with NaNs. This step is necessary b/c 
;      ;total(z[],/NAN) will return a 0.0 instead of a NaN if z[] contains all NaNs
;      z[zeroMonIndex,dupIndex[j]+1] = !values.D_NAN
;      dz[zeroMonIndex,dupIndex[j]+1] = !values.D_NAN
;   endif
;endwhile
;
;
;if (nDup gt 0) then begin
;   z = temporary(z[*,uniqIndex])
;   dz = temporary(dz[*,uniqIndex])
;   mon = temporary(mon[*,uniqIndex])
;   y = y[uniqIndex] 
;endif
;
;; normalize so duplicate groups are smoothed out
;z = z/mon
;dz = dz/mon

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdateCounts
;+
; PURPOSE:
;   Update Counts/Error for the specified dataset according to current settings
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated. If not specified, then 
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdateCounts, oPSet
compile_opt idl2

if ((n_elements(oPSet) eq 0) || ~obj_valid(oPSet[0])) then begin
   ; retrieve all loaded datasets
   Self->GetProperty, sampContRef=oCont
   oPSet = oCont->Get(/all,count=nData)
endif else begin
   nData = n_elements(oPSet)
endelse

if (nData eq 0) then return

Self->GetProperty, MONSCALEVALUE=monScaleVal, NORMALIZETO=normTo, MONCORFLAG=monCorFlag $
                 ,RESCORFLAG=resCorFlag, FASTFLAG=fastFlag, FASTVALUE=fastVal $
                 ,DETAILEDBALANCEFLAG=detBalFlag,effNormFlag=effFlag, scanType=scanType $
                 ,logFlag=logFlag, oneOverKfFlag=oneOverKfFlag

case scanType of
   'I': Self->UpdatePowderVariables, oPSet
   
   'Q': begin
      ;; single xtal
      
      maxVals = []
      minVals = []
      for i=0,nData-1 do begin
         oData = oPSet[i]
         oZ = oData->GetByName('Counts')
         if (~obj_valid(oZ)) then return
         oErr = oData->GetByName('Error')
         if (~obj_valid(oErr)) then return
         if (~oZ->GetMetaData('OriginalCounts',counts)) then return
         error = counts
         index = where(error le 0.0,cnt)
         if (cnt gt 0) then error[index] = 1.0
         error = sqrt(error)
         
         if (effFlag) then begin
            status = oZ->GetMetaData('CHEFF',chEff)
            counts = temporary(counts)/chEff
            error = temporary(error)/sqrt(chEff)
            ;oChEff = oData->GetByName('ChEff')
            ;if (obj_valid(ochEff)) then begin
            ;   status = oChEff->GetData(chEff)
            ;   counts = temporary(counts)/chEff
            ;   error = temporary(error)/sqrt(chEff)
            ;endif
         endif
         
         if (fastFlag) then begin   ; perform corrections that depend on first applying fast bkgd correction
            ;; Apply fast Correction
            if (fastVal ne 0.0) then begin
               ;oTime = oData->GetByName('TIME')
               ;status = oTime->GetData(time)
               status = oZ->GetMetaData('TIME',time)
               counts = temporary(counts) - (time/60.0)*fastVal ; time is measured in secs and fastVal is fast bkgd in cnts/min
            endif
            
            ;; Apply monitor correction
            if (monCorFlag) then begin
               ;; Constraints are:
               ;; 1 - PG monochromator is in use (d spacing = 3.354)
               ;; 2 - 5 <= Ei <= 34; For Ei < 5, flag an error, for Ei > 34, correction = 1
               ;; CF(Ei) = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
               status = oData->GetMetaData('DATAPTRREF',dataPtr)
               if (~ptr_valid(dataPtr)) then return
               dspacem = (*dataPtr).dspacem  ; d spacing of monochromator
               diff = abs(dspacem - 3.354)
               PGMON = diff lt 0.001
               Ei = (*(*dataPtr).Ei)
               index = where(Ei lt 5.0,Eilt5)  ; correction not aloowed if Ei < 5.0 meV
               if (Eilt5) then begin
                  msg = ['Ei is lower than 5.0 meV.','Monitor correction was not applied']
                  title = 'Monitor Correction'
                  Self->ErrorMessage,msg,title=title,severity=0
               endif else if (PGMON) then begin
                  M0 =  6.1230
                  M1 = -5.9630e-1
                  M2 =  2.6244e-2
                  M3 = -4.8430e-4
                  M4 =  2.8810e-6
                  index = where(Ei gt 34.0,Eigt34)
                  CFEi = M0 + M1*Ei + M2*Ei^2 + M3*Ei^3 + M4*Ei^4
                  if (Eigt34) then CFEi[index] = 1.0  ; for Ei > 34, CF = 1
                  counts = TEMPORARY(counts)*CFEi
                  error  = TEMPORARY(error)*CFEi 
               endif
            endif 
            
      ;      if (resCorFlag) then begin
      ;         ; apply resolution correction
      ;      endif
      ;      
      ;      if (detBalFlag) rhen begin
      ;         ; apply detailed balance correction
      ;      endif
         endif
         
         if (oneOverKfFlag) then begin
           status = oZ->GetMetaData('KF',kf)
           counts = TEMPORARY(counts)/kf
           error  = TEMPORARY(error)/kf
         endif


         ;; Apply monitor normalization
         case normTo of
         
            0: begin
               ;oMon = oData->GetByName('MON')
               ;status = oMon->GetData(mon)
               status = oZ->GetMetaData('MON',mon)
               monScale = monScaleVal/mon
            end
            
            1: begin
               if (~isa(time)) then begin    ; may have retrieve time already
                  ;oTime = oData->GetByName('TIME')
                  ;status = oTime->GetData(time)
                  status = oZ->GetMetaData('TIME',time)
               endif
               monScale = monScaleVal/time
            end
            
            else: monScale = monScaleVal
         endcase
         counts = TEMPORARY(counts)*monScale
         error = TEMPORARY(error)*monscale
         
         ;; Mask bad Pixels
         Self->GetProperty, maskFlag=maskFlag
         sBadChans = Self.maskedDets
         maskedChansExist = ~strcmp(sBadChans,'')
         if (maskFlag && maskedChansExist) then begin
            status = compactstring2intvector(sBadChans, badChans)
            badChanIndex = badChans - 1   ; convert Pixel nos to 0-based Pixel index
            ; Apply mask by simple replacing the counts in the masked Pixels by NaNs
            ; Leave error variable untouched
            counts[badChanIndex,*] = !values.F_NAN
         endif   
         
         maxVal = max(counts, min=minVal,/NAN)
         maxVals = [maxVals,maxVal]
         minVals = [minVals,minVal]
         
         ; Save copy of counts in linearCount metadata 
         oZ->AddMetaData, 'linearCounts',counts
         
         ; take a log of the data if necessary
         if (logFlag) then begin
            index = where(counts le 0.0, nBad)
            if (nBad gt 0) then counts[index] = !values.F_NAN
            counts = alog10(temporary(counts))
         endif
         
         status = oZ->SetData(counts,/no_copy);,/no_notify)
         status = oErr->SetData(error,/no_copy,/no_notify)
      endfor
      
      ; If max and min intensity properties are undefined,
      ; use the current max and min values to define them
      if ((Self.minIntensity eq 0.0) && (Self.maxIntensity eq 0.0)) then begin
         ; NB: This should run at most once during a session!

         minVal = min(minVals)   ; these are linear values!
         maxVal = max(maxVals)
         
         ; take a log of the intensity limits if necessary
         case logFlag of
           0:
           
           1: begin ; log scale is active
              minVal = (minVal gt 0.0)? alog10(minVal) : 0.0
              maxVal = (maxVal gt 0.0)? alog10(maxVal) : 0.0
           end
         endcase

         Self.maxIntensity = maxVal
         Self.minIntensity = minVal
      endif

   end
   
   else:
endcase


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdateIntensityScale
;+
; PURPOSE:
;   Update the intensity scale - switch between linear/logbase10 scales
;
; PARAMETERS:
;   
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdateIntensityScale
compile_opt idl2

Self->GetProperty, logFlag=logFlag, sampContRef=oCont, minIntensity=minval, maxIntensity=maxval

nData = oCont->Count()
if (nData eq 0) then return
 
oData = oCont->Get(/all)

case logFlag of
   0: begin ; switch to linear scale
      minVal = 10.0^(minVal)  ; update max and min intensity to the same scale as the intensity
      maxVal = 10.0^(maxVal)
      for i = 0,nData-1 do begin
         oZ = oData[i]->GetByName('Counts')
         if (~obj_valid(oZ)) then continue
         if (~oZ->GetMetaData('LinearCounts',counts)) then continue
         status = oZ->SetData(counts,/no_copy);,/no_notify)      
      endfor
   end
   
   1: begin ; switch to log scale
       minVal = (minVal gt 0.0)? alog10(minVal) : 0.0 ; update max and min intensity to the same scale as the intensity
       maxVal = (maxVal gt 0.0)? alog10(maxVal) : 0.0 
       for i = 0,nData-1 do begin
         oZ = oData[i]->GetByName('Counts')
         if (~obj_valid(oZ)) then continue
         if (~oZ->GetMetaData('LinearCounts',counts)) then begin
            ; probably data from an older session so create the metadata
            status = oZ->Getdata(counts)
            oZ->AddMetaData, 'linearCounts',counts
         endif

         index = where(counts le 0.0, nBad)
         if (nBad gt 0) then counts[index] = !values.F_NAN
         counts = alog10(temporary(counts))
         status = oZ->SetData(counts,/no_copy);,/no_notify)      
      endfor
   
   end
   
   else:
endcase
Self->SetProperty, minIntensity=minVal, maxIntensity=maxVal

; Update the intensity range
Self->UpdatePlotIntensityRange

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdatePlotIntensityRange
;+
; PURPOSE:
;   Update the max and min intensity of the existing plot
;
; PARAMETERS:
;   
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdatePlotIntensityRange, oVis
compile_opt idl2

Self->GetProperty, defaultIntensityFlag=defIntFlag, scanType=scanType, maxIntensity=maxVal, minIntensity=minVal

if (Self.defaultIntensityFlag eq 1) then begin  ;using default intensity range
   Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel
   if (nSel eq 0) then return   ; exit if no dataset is currently selected
   ; Retrieve intensity of selected data
   intensity = []
   for i=0,nSel - 1 do begin
      oTest = Self->GetByIdentifier(selIDs[i])
      if (~isa(oTest,'IDLitParameterSet')) then continue
      oZ = oTest->GetByName('Counts')
      status = oZ->GetData(counts)
      intensity = [intensity,reform(counts,n_elements(counts))]
   endfor
   if (~isa(intensity)) then return
   maxVal = max(intensity,min=minVal,/NAN)
endif else begin
   maxVal = Self.maxIntensity
   minVal = Self.minIntensity
endelse

if (maxVal eq minVal) then return

if (maxVal lt minVal) then begin
   tempVal = maxVal
   maxVal = minVal
   minVal = tempVal
endif

if (obj_valid(oVis) && isa(oVis,'IDLitVisualization')) then begin
   oVis->SetProperty, min_value=minVal, max_value=maxVal
endif else begin
   if (Self->HasVisualizations()) then begin
      oWin = Self->GetCurrentWindow()
      oView = oWin->GetCurrentView()
      oLayer = oView->GetCurrentLayer()
      oWorld = oLayer->GetWorld()
      oDataSpace = oWorld->GetDataSpaces()
      oVis = oDataSpace->GetVisualizations(count = nVis)
   
      for i=0, nVis-1 do oVis[i]->SetProperty, min_value=minVal, max_value=maxVal
   endif
endelse
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdateIndependentVariables
;+
; PURPOSE:
;   Update the Qx and Qy variables due to changes in the lattice parameter
;
; PARAMETERS:
;   oPSet [in|out] - object whose data is to be updated
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdateIndependentVariables, oPSet, updateObservers=updateObservers
compile_opt idl2

Self->GetProperty, LATPARAMFLAG=lpFlag, LATTICEPARAMETERS=latParm_str, indepVar1List=varList
status = oPSet->GetMetaData('SCANTYPE',scanType)
if (scanType ne 'Q') then return  ; Only process 'Q' scans here

void = oPSet->GetMetaData('DATAPTRREF',dataPtr)
if (~ptr_valid(dataPtr)) then return
dataStr = *dataPtr
dSpaceA = dataStr.dSpaceA
dSpaceM = dataStr.dSpaceM
nPix = dataStr.nPix
nPts = datastr.nPts

unitVecnPts = Fltarr(nPts) + 1.0
unitVecnPix = Fltarr(nPix) + 1.0

ekFac = Self.ekFac
Ei0 = (*dataStr.ei)
Ef0 = (*dataStr.ef)
chEf = Self.chEf  ; final energies for each pixel
kf = sqrt(chEf/ekfac)
rtod = 1.0/!dtor

lpLen = strlen(strtrim(latParm_str))
if (lpFlag) then begin             ; 0 = from data, 1 = user specified
   ; if using user specified lat params
   toks = strsplit(latParm_str,/extract,count=nToks)
   if (nToks eq 6) then latParm = float(toks)
endif
if ((lpFlag eq 0) || (n_elements(latParm) eq 0)) then begin
   ; if lat params is undefined or not using user specified lat params
   ; use the dataset's lattice parameters
   latparm = (*dataStr.LATTICE_PTR)
   if (lpLen eq 0) then begin
      ; if the Tool's lattice Parameter property is blank, initialize it with the current dataset's
      latParm_str = strjoin(strtrim(string(float(latParm)),2),' ',/single)
      Self->SetProperty, latticeParameters = latParm_str
      Self->RefreshPropertysheet
   endif
endif

orient = *dataStr.ORIENTATION_PTR ; retrieve crystal orientation vectors u,v in rec. space coordinates
u = orient[0:2]            ; the crystal orientation vectors specified in multiples of a*, b* and c*
v = orient[3:5]

; In case v is not perpendicular to u, w is obtained so that
; u & w are orthogonal and equal in length.
auv = getangle2hkl(u,v,latparm=latparm,/degree)
qu = HKLnorm(u,latparm=latparm)
qv = HKLnorm(v,latparm=latparm)
w = chop(v - u/qu*qv*sin((90.-auv)*!dtor))
qw = HKLnorm(w,latparm=latparm)
w = w/qw*qu
M = [ [u] $
     ,[w] $
     ,[crossp(u,w)]]
MPrime = invert(M)

; Inverse angstroms to r.l.u. conversion factors
xAA2RLU = qu                 ; e.g. ~ 2*pi/a  if u = [1,0,0]
yAA2RLU = qw                 ; e.g. ~ 2*pi/c  if v = [0,0,1]

; the norminal khl values
h = (*dataStr.h)
k = (*dataStr.k)
l = (*dataStr.l)

; calculate 2theta for individual pixels relative to the central pixel from the final energies
; the central pixel is assummed to be pixel 127 out of 256
dttp = Self.chDelA4    ; in degrees
 
; loop through data points and calculate q values
qp = fltarr(nPix,nPts)
qxp = fltarr(nPix,nPts)
qyp = fltarr(nPix,nPts)

;;;;::::::::::::::::::::::::::::::
; Method 1 by Jae-Ho Chung
; - Norminal hkl values for data point gives |Qo| and hence 2thetao
; - Calibration info gives Delta 2theta at each pixel
; - See Ja-Hoe's notes
;:::::::::::::::::::::::::::::::::
;calcQUnitFlag = 1 ; => Q calculations comes out in r.l.u units
;for i = 0,nPts-1 do begin
;  hkl0 = [h[i],k[i],l[i]] ; norminal hkl for data point
;  q0 = HKLNorm(hkl0,latparm=latparm) ; norminal q magnitude given hkl0 and lattice params
;  tt0 = acos((ei0[i]+ef0[i]-ekFac*q0^2)/(2.0*sqrt(ei0[i]*ef0[i])))  ; the norminal ttheta or A40 in radians
;  ttp = tt0 + dttp*!dtor      ; ttheta at each pixel in radians
;  qp[*,i] =  Sqrt( ( ei0[i]+chEf-2*sqrt(ei0[i]*chEf)*Cos(ttp)) / ekFac) ; Q at each pixel
;  
;  ; Need to decompose Q into its hkl components
;  
;  ;Below solves for a0,b0 such that hkl0 = a0 u + b0 w
;  ;since u and w are orthogonal vectors, they serve as basis vectors for cartesian coordinate.
;  ;Then we can use a rotational matrix to rotate [a0,b0] by known angles, which are dttp to determine
;  ;[ap,bp] thus enabling the evaluation of hklp at any pixel through 
;  ;hklp = ap u + bp w
;  tmp = chop(hkl0##MPrime) ; M = [[u],[w],[crossp(u,w)]]; MPrime = inverse(M)
;  a0 = tmp[0]
;  b0 = tmp[1]
;  ;Determine ap, bp and hence [Qh,Qk,Ql]
;  for j=0,nPix-1 do begin
;    sdttp = sin(dttp[j]*!dtor)
;    cdttp = cos(dttp[j]*!dtor)
;    rotmat = [[ cdttp,sdttp] $
;             ,[-sdttp,cdttp]]
;    tmp = rotmat##transpose([a0,b0]) ; [ap,bp]=rotmat(dttp)[a0,b0]
;    hklp = tmp[0]*u + tmp[1]*w ; hklp = ap u + bp w
;    hklp = hklp/HKLnorm(hklp,latparm=latparm) * qp[j,i] ; scale the vector length to be same as qp
;;    apbp = hklp##MPrime
;;    qxp[j,i] = apbp[0]
;;    qyp[j,i] = apbp[1]
;    qxp[j,i] = hklp[0]
;    qyp[j,i] = hklp[1]
;  endfor
;endfor
;;;;;;;;;;; End of Method 1
;----------------------------------------------------------------

;;;;::::::::::::::::::::::::::::::
; Method 2 by Laland Harriger
; - Norminal hkl values for data point gives |Qo| and hence 2thetao
; - Calibration info gives Delta 2theta at each pixel
; - See Leland's notes
;:::::::::::::::::::::::::::::::::
calcQUnitFlag = 0 ; Q calculations comes out in inverse angstroms units 
for i=0, nPts-1 do begin
  ki0 = sqrt(ei0[i]/ekFac)
  kf0 = sqrt(ef0[i]/ekFac)
  
  ; For central pixel, Project Qhkl along orthogonal orientation vectors u, w
  hkl0 = [h[i],k[i],l[i]] ; norminal hkl for data point
  qproj0 = chop(hkl0##MPrime) ; M = [[u],[w],[crossp(u,w)]]; MPrime = inverse(M)
  quVec0 = Qproj0[0] * u
  qwVec0 = Qproj0[1] * w
  
  ; Magnitude of Qhkl, ttheta, omega and a3 for central pixel
  modQ0 = HKLnorm(hkl0, latparm=latparm)                               ; the norminal magnitude of Q
  a40 = acos((ei0[i]+ef0[i]-ekFac*modQ0^2)/(2.0*sqrt(ei0[i]*ef0[i])))  ; the norminal ttheta or A40 in radians
  
  Psi0 = asin((kf0*sin(a40))/modQ0)                                     ; psi is the angle between Q and ki in radians
  omega0 = getangle2hkl(quVec0, hkl0, latparm=latparm)                 ; omega is the angle between Q and the component of Q along u
  
  ; calculate A3 taking into account its sign dependent in the quadrant it is located in
  if (qProj0[0] ge 0 && qProj0[1] ge 0) then begin              ; Quadrant 1
    omega0 = -omega0
    A3offset = 0
  endif else if (qProj0[0] le 0 && qProj0[1] ge 0) then begin   ; Quadrant 2
    omega0 = omega0
    A3offset = !pi
  endif else if (qProj0[0] le 0 && qProj0[1] le 0) then begin   ; Quadrant 3
    omega0 = -omega0
    A3offset = -!pi
  endif else begin                                              ; Quadrant 4
    omega0 = omega0
    A3offset = 0 
  endelse  

  ; if u and w are orthogonal then
  ; A3 + Psi + omega is equal to 90 degrees
  A3 = !pi/2.0 - omega0 - Psi0 + A3offset
  
  ; now calculate (q,qx,qy), given ki, kf, a3 and a4 for each channel
  A4 = A40 * rtod + dttp   ; dttp is ttheta for individual pixels relative to the central pixel - determine by calibration
  angle2q, ki0, kf, A3*rtod, A4, chq, chqx, chqy, phiOffset=Self.phiOffset
  
  qp[*,i] = chq       ; in 1/AA units
  qxp[*,i] = chqx     ; in 1/AA units
  qyp[*,i] = chqy     ; in 1/AA units
endfor
;;;;;;;;;;; End of Method 2
;----------------------------------------------------------------

Self->GetProperty, QUNITS=qUnits       ;  rlu = 0 => 1/A, 1 => r.l.u.

oQX = oPSet->GetByName(varList[0],count=count)
if (count ne 1) then return
oQY = oPSet->GetByName(varList[1],count=count)
if (count ne 1) then return
oQTot = oPSet->GetByName('|Q|',count=count)

; determine appropriate labels to use for qx and qy
xlabrlu = (u[0] eq 0)? '0' : 'H'
xlabrlu += (u[1] eq 0)? '0' : 'K'
xlabrlu += (u[2] eq 0)? '0' : 'L'
ylabrlu = (w[0] eq 0)? '0' : 'H'
ylabrlu += (w[1] eq 0)? '0' : 'K'
ylabrlu += (w[2] eq 0)? '0' : 'L'
xunitrlu = 'r.l.u.'
yunitrlu = 'r.l.u.'

xlab = 'qx'
ylab = 'qy'
xunit = '$\AA^{-1}$'
yunit = '$\AA^{-1}$'
if (qUnits eq 1) then begin
  xlab = xlabrlu
  ylab = ylabrlu
  xunit = xunitrlu
  yunit = yunitrlu
endif
oQx->AddMetaData,'Long_name',xlab
oQx->AddMetaData,'Units',xunit
oQy->AddMetaData,'Long_name',ylab
oQy->AddMetaData,'Units',yunit

status = oQx->GetMetaData('RLU',unitFlag)    ; unitFlag eq 0 => 1/A, 1 => rlu 
status = oQx->GetMetaData('AA2RLU',oldxAA2RLU)
status = oQy->GetMetaData('AA2RLU',oldyAA2RLU)

; Only need to rescale data if the active units for qx,qy is in inverse angstroms
if (qUnits eq 0) then begin                     ; qUnits is equivalent to unitFlag, just stored at different locations
   if (calcQUnitFlag eq 0) then begin
     status = oQX->SetData(qxp,/no_copy,/no_notify)
     status = oQY->SetData(qyp,/no_copy,/no_notify)
   endif else begin
     status = oQX->SetData(qxp*(xAA2RLU/oldxAA2RLU),/no_copy,/no_notify)
     status = oQY->SetData(qyp*(xAA2RLU/oldxAA2RLU),/no_copy,/no_notify)    
   endelse
endif else begin
  if (calcQUnitFlag eq 1) then begin
     status = oQX->SetData(qxp,/no_copy,/no_notify)
     status = oQY->SetData(qyp,/no_copy,/no_notify)
  endif else begin
    status = oQX->SetData(qxp*(oldxAA2RLU/xAA2RLU),/no_copy,/no_notify)
    status = oQY->SetData(qyp*(oldyAA2RLU/yAA2RLU),/no_copy,/no_notify)    
  endelse
endelse
status = oQTot->SetData(qp,/no_copy,/no_notify)
  
; update the stored conversion factors
oQx->AddMetaData,'AA2RLU', xAA2RLU
oQy->AddMetaData,'AA2RLU', yAA2RLU   


if (keyword_set(updateObservers)) then begin
   oQX->NotifyDataChange
   oQX->NotifyDataComplete
   oQY->NotifyDataChange
   oQY->NotifyDataComplete
endif

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdateQxQyUnit
;+
; PURPOSE:
;   Update the units for the Qx and Qy variables for all loaded datasets. User can 
;   swtich between inverse angstroms and relative lattice units
;
; PARAMETERS:
;
; KEYWORDS:
;-
pro SPINSpsdTool::UpdateQxQyUnit
compile_opt idl2

; Get the QX and QY parameters for all loaded datasets
; and change the units accordingly
Self->GetProperty, sampContRef=oCont, indepVar1List=varList, qUnits=newUnitFlag
nData = oCont->Count()
if (nData eq 0) then return
 
newUnit = (newUnitFlag eq 0)? '$\AA^{-1}$' : 'r.l.u.'
oData = oCont->Get(/all)
for i = 0,nData-1 do begin
   oQX = oData[i]->GetByName(varList[0],count=count)
   if (count ne 1) then continue
   oQY = oData[i]->GetByName(varList[1],count=count)
   if (count ne 1) then continue
   status = oQx->GetMetaData('RLU',oldUnitFlag)
   status = oQx->GetMetaData('AA2RLU',xAA2RLU)
   status = oQy->GetMetaData('AA2RLU',yAA2RLU)
   changed = 0
   if (oldUnitFlag eq 0 and newUnitFlag eq 1) then begin
     status = oQX->GetData(data)
     data = data/xAA2RLU
     status = oQX->SetData(data,/no_copy,/no_notify)
     status = oQY->GetData(data)
     data = data/yAA2RLU
     status = oQY->SetData(data,/no_copy,/no_notify)
     changed = 1
   endif else if (oldUnitFlag eq 1 and newUnitFlag eq 0) then begin
     status = oQX->GetData(data)
     data = data*xAA2RLU
     status = oQX->SetData(data,/no_copy,/no_notify)
     status = oQY->GetData(data)
     data = data*yAA2RLU
     status = oQY->SetData(data,/no_copy,/no_notify)
     changed = 1
   endif
   if (changed) then begin
     oQX->AddMetaData,'UNITS', newUnit
     oQX->AddMetaData,'RLU', newUnitFlag
     oQY->AddMetaData,'UNITS', newUnit
     oQY->AddMetaData,'RLU', newUnitFlag
     oQX->NotifyDataChange
     oQX->NotifyDataComplete
     oQY->NotifyDataChange
     oQY->NotifyDataComplete
   endif
endfor


end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::Mslice
;+
; PURPOSE:
;   Launch Mslice tool with a copy of the currently selected data for further analysis. 
;   If Mslice is already launched, update its data with the currently selected data.
;
; PARAMETERS:
;
; KEYWORDS:
;-
function SPINSpsdTool::Mslice
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        if (widget_info(wB,/valid)) then widget_control, wB, /destroy
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; display dialog to let user select variables to be exported to Mslice 
Self->GetProperty, daveTool=daveTool ,selectedIDs=selIDs,nSelectedIDs=nSel
if (nSel eq 0) then return, 0  ; exit if no dataset is currently selected


oFirst = Self->GetByIdentifier(selIDs[0])
if (~isa(oFirst,'IDLitParameterSet')) then return, 0
status = oFirst->GetMetaData('SCANTYPE',scanType)
if (scanType eq 'I') then Self->GetProperty, INDEPVAR2LIST=exportList, exportIndex=exportIndex
if (scanType eq 'Q') then Self->GetProperty, INDEPVAR1LIST=exportList, exportIndex=exportIndex
if (n_elements(exportList) eq 0) then return, 0

; construct basic dialog
title = 'Select Variables to Export'
wB = widget_base(/col,title=title,/modal,group_leader=wTLB)
wB1 = widget_base(wB,/col,grid=2,/frame,/nonexclusive,scr_xsize=200)
wB2 = widget_base(wB,/row,/frame)

n = n_elements(exportList)
wButtons = lindgen(n)
for i=0,n-1 do begin
   wButtons[i] = widget_button(wB1,value=exportList[i],uname=exportList[i])
   widget_control, wButtons[i], set_button=exportIndex[i]
endfor
wOK = widget_button(wB2,value='OK',uname='APPLY',/align_center)
wCancel = widget_button(wB2,value='Cancel',uname='CANCEL',/align_center)

statePtr = ptr_new({wButtons:wButtons,exportIndex:exportIndex,cancel:0})
widget_control, wB, /realize, set_uvalue=statePtr

xmanager, 'SPINSPSDToolExport2Mslice', wB, event_handler='SPINSPSDToolExport2Mslice_event'

exportIndex = (*statePtr).exportIndex
cancel = (*statePtr).cancel
ptr_free, statePtr

if (cancel) then return, 0

Self->SetProperty, exportIndex=exportIndex

index = where(exportIndex eq 1,nVar)
if (nVar lt 1) then return, 0

exportList = exportList[index]

; Counts and Error
z = []
Err = []
label = ['Intensity','Error']
unit = ['','']
unique = [0,0]

oData = []
for i=0,nSel - 1 do begin
   oTest = Self->GetByIdentifier(selIDs[i])
   if (~isa(oTest,'IDLitParameterSet')) then continue   
   status = oTest->GetMetaData('SCANTYPE',scanType)
   if (scanType ne 'I' && scanType ne 'Q') then continue
   oZ = oTest->GetByName('Counts')
   if (~oZ->GetMetaData('LinearCounts',counts)) then status = oZ->GetData(counts)
   Z = [Z,reform(counts,n_elements(counts))]
   oErr = oTest->GetByName('Error')
   status = oErr->GetData(error)
   Err = [Err,reform(error,n_elements(error))]
   oData = [oData,oTest]
endfor
nSel = n_elements(oData)
npts = n_elements(Z)
if (npts eq 0) then return, 0
data = fltarr(npts,2+nVar)
;index = where(finite(Z,/NAN),nanCnt)
;if (nanCnt gt 0) then Z[index] = -1.0e20
data[*,0] = Z
data[*,1] = Err

; Get the independent vars
for i=0,nVar-1 do begin
   varName = exportList[i]
   varData = []
   for j=0,nSel-1 do begin
      oVar = oData[j]->GetByName(varName)
      if (~obj_valid(oVar)) then continue
      if (j eq 0) then begin
         status = oVar->GetMetaData('Long_name',varLab)
         status = oVar->GetMetaData('Units',varUnit)
         label = [label,varLab]
         unit = [unit,varUnit]
         unique = strcmp(varName,'E',/fold_case)? [unique,1] : [unique,0]
      endif
      status = oVar->GetData(iVarData)
      varData = [vardata,reform(iVarData,n_elements(iVarData))]
   endfor
   data[*,i+2] = varData
endfor

;; discriminate for any masked data
;void = where(finite(data),complement=mskIndex,ncomplement=nMsk)
;if (nMsk gt 0) then data[mskIndex] = -1.0e20


if (obj_valid(Self.objMslice) && (Self.multipleMsliceWinFlag eq 0)) then begin
   Self.objMslice->Reset_data, data=data, label=tex2idl(label), instrument='SPINS' $
                             ,is_uniq=unique, unit=tex2idl(unit), /no_copy
endif else begin
   dataPtr = ptr_new({data:temporary(data),label:tex2idl(label),unit:tex2idl(unit),instrument:'SPINS',is_uniq:unique},/no_copy)
   Self->GetProperty, DAVETOOL=daveTool, DATA_DIRECTORY=dataDir, working_directory=workDir
   dcs_mslice, dataPtr=dataPtr, obj_mslice=objMslice, group_leader=wTLB $
             ,DAVETool=daveTool, workDir=workDir, dataDir=dataDir
   Self.objMslice = objMslice
endelse

return, 0
end
;-------------------------------------------------------------------------------


;===============================================================================
pro SPINSPSDToolExport2Mslice_event, event
compile_opt idl2
uname = widget_info(event.id,/uname)
widget_control, event.top, get_uvalue=statePtr

case uname of
   'APPLY': begin
      exportIndex = widget_info((*statePtr).wButtons,/button_set)
      (*statePtr).exportIndex = exportIndex
      widget_control, event.top, /destroy  
   end
   
   'CANCEL': begin
      (*statePtr).cancel = 1
      widget_control, event.top, /destroy  
   end
   
   else:
   
endcase
if (strcmp(uname,'APPLY')) then begin
endif

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::restoreDataVersion
;
; PURPOSE:
;   Restore the specified object to the latest version
;
; PARAMETERS:
;   oData [in|out] - object to be restored to the latest version
;
; KEYWORDS:
;
pro SPINSpsdTool::restoreDataVersion, oData
compile_opt idl2

; restore to latest IDLitData version
oData->Restore

; Pull the data pointer structure and ensure it is up to data
currentVersion = Self.dataVersion

void = oData->GetMetaData('DATAPTRREF',tempPtr)
oldDataVersion = (*tempPtr).dataVersion

if (currentVersion gt oldDataVersion) then begin
   ; Update the data as necessary
endif

end




;===============================================================================
; SPINSpsdTool::readData
;
; PURPOSE:
;   Read the contents of a .bt4 file
;
; PARAMETERS:
;   file [in] - filename to be read.
;
;   dataPtr [out] - data structure to read file contents into
;
; KEYWORDS:
;
function SPINSpsdTool::isNG5Dataset, filename, errmsg=errmsg, oFTP=oFTP, scanType=scantype

errmsg = 'Not a valid NG5 data file'
catch,the_error
if the_error ne 0 then begin
   catch,/cancel
   if n_elements(lun) ne 0 then free_lun,lun,/force
   errmsg = !error_state.msg
   return,0B
endif

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (fromFTP) then begin
  if (~obj_valid(oFTP)) then return, 0
  ; retrieve file contents from ftp server and store into dstring array
  buffer = oFTP->GetFileContent(filename,/string)
  if (strcmp(buffer[0],'')) then return, 0
  nlines = n_elements(buffer)
endif else begin
  if ~file_test(filename) then begin
     errmsg = 'File '+filename+' not found'
     return,0B
  endif
  nlines = file_lines(filename)
  buffer = strarr(nlines)
  
  ; B/c of unusual error resulting from running out of available logical units
  ; (probably a bug in get_lun); add the following 4 lines to force the use of 
  ; the same first available file unit every time
  lun = 100
  while ((fstat(lun)).open && (lun lt 129)) do begin
    lun++
  endwhile
  
  openr,lun,filename;,/get_lun
  readf,lun,buffer
  free_lun,lun,/force
endelse

; It must be an ICP Q-buffer or I-buffer file: line 1, col 37 should be letter Q or I
scanType = strmid(buffer[0],36,1)
if (~strcmp(scanType,'Q') && ~strcmp(scanType,'I')) then begin
  errmsg = "Unrecognised file format: Must be 'Q' or 'I' scan"
  return, 0
endif

; Is there a '#ASD' entry on line twelve? If so, this is a+ mode SPINS data file
asd = (scanType eq 'Q')? strmid(strtrim(buffer[11],2),0,4) : strmid(strtrim(buffer[12],2),0,4)
if (~strcmp(asd,'#ASD')) then begin
  errmsg = '#ASD tag missing: Unknown file format'
  return, 0
endif

;; Measurement must have been performed in fixed-final energy mode
;if (~strcmp(strmid(buffer[8],27,8),'EA fixed')) then return, 0

return, 1B
end


;===============================================================================
; SPINSpsdTool::readData
;
; PURPOSE:
;   Read the contents of a .bt4 file
;
; PARAMETERS:
;   file [in] - filename to be read.
;
;   dataPtr [out] - data structure to read file contents into
;
; KEYWORDS:
;
function SPINSpsdTool::ReadData, file, dataPtr, fromFTP=fromFTP
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::readData: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        if (ptr_valid(dataPtr)) then heap_free, dataPtr
        if (n_elements(lun) gt 0) then free_lun, lun, /force
        return, 0
    endif
endif


; check parameter count
if (n_params() ne 2) then return, 0

; check file parameter is defined
if (n_elements(file) le 0) then return, 0

filename=file

fromFtp = (stregex(filename,'/pub/ncnrdata/',/fold,/bool))? 1 : 0
if (~fromFTP && ~file_test(filename)) then return, 0

if (keyword_set(fromFTP)) then Self->GetProperty, ftpObject=oFTP

; filename must be an NG5 file
if ~Self->isNG5Dataset(filename, errmsg=errmsg, scanType=scanType, oFTP=oFtp) then begin
  Self->StatusMessage, errmsg
  return, 0
endif

if (keyword_set(fromFTP)) then begin
  Self->GetProperty, ftpObject=oFTP
  
  ; locate a suitable temporal directory
;  tmpDir = (!version.OS_FAMILY eq 'Windows')? GETENV('TMP') : GETENV('TMPDIR')
;  if (tmpDir eq '') then return, 0
  tmpDir = !home_dir
  ; and copy file from the server into tmpfile on the host
  ; use this tmpfile below to load the data from
  tmpfile = tmpDir + path_sep() + 'NG5ftpData.txt' 
  filename = oFTP->GetFileContent(filename,localfilename=tmpfile)
  if (~file_test(filename,/read)) then return, 0  ; check local file exists and is readable
endif

; B/c of unusual error resulting from running out of available logical units
; (probably a bug in get_lun); add the following 4 lines to force the use of 
; the same first available file unit every time
lun = 100
while ((fstat(lun)).open && (lun lt 129)) do begin
  lun++
endwhile

; open input file
openr, lun, filename, error=err ;, /get_lun
if (err ne 0) then begin
   free_lun, lun, /force
   return, 0
endif

;nlines = file_lines(filename)
buffer = (scanType eq 'Q')? strarr(13) : strarr(14)
readf, lun, buffer

if (ptr_valid(dataPtr)) then heap_free, dataPtr
dataPtr =  { filename:'' $
;            ,data_ptr:ptr_new()           $
            ,dataVersion:0                $
            ,indep_var_tag:''             $
            ,scanType:''                      $
            ,prefactor:0L                 $
            ,base:''                      $
;            ,tot_mon:0L                   $
            ,npts:0                    $
            ,nPix:0                    $
            ,type:''                      $
            ,date:''                      $
            ,monave:0L                       $
;            ,signal_type:''               $
            ,title:''                    $
            ,collim_ptr:ptr_new(fltarr(4))         $
            ,mosaic_ptr:ptr_new(fltarr(3))         $
            ,lattice_ptr:ptr_new(fltarr(6))        $
;            ,treatment_ptr:ptr_new()      $
            ,orientation_ptr:ptr_new(fltarr(6)) $
            ,fixedEType:'' $
            ,fixedEValue:0.0 $
            ,dSpaceM:3.354 $
            ,dSpaceA:3.354 $
            ,psddets:ptr_new() $
            ,A1:ptr_new() $
            ,A2:ptr_new() $
            ,A3:ptr_new() $
            ,A4:ptr_new() $
            ,A5:ptr_new() $
            ,A6:ptr_new() $
            ,e:ptr_new() $
            ,ei:ptr_new() $
            ,ef:ptr_new() $
            ,h:ptr_new() $
            ,k:ptr_new() $
            ,l:ptr_new() $
            ,ep:ptr_new() $
            ,eip:ptr_new() $
            ,efp:ptr_new() $
            ,qp:ptr_new() $
            ,hp:ptr_new() $
            ,kp:ptr_new() $
            ,lp:ptr_new() $
            ,mon:ptr_new() $
            ,time:ptr_new() $
            ,temp:ptr_new() $
            ,magfield:ptr_new() $
         }

dataPtr.dataVersion = Self.dataVersion
dataPtr.filename = strmid(buffer[0],1,12)
dataPtr.date = strmid(buffer[0],16,17)
dataPtr.scanType = strmid(buffer[0],36,1)
dataPtr.monave = long(strmid(buffer[0],39,12))
dataPtr.prefactor = long(strmid(buffer[0],52,4))
dataPtr.base = strmid(buffer[0],58,4)
npts = fix(strmid(buffer[0],64,6))
dataPtr.type = strmid(buffer[0],71,3)

dataPtr.title = strtrim(buffer[2],2)


if (dataPtr.scanType eq 'Q') then begin
  toks = strsplit(buffer[3],' ',/extract, count=ntok)  
  (*dataPtr.collim_ptr) = float(toks[0:3]) ;float(strsplit(strmid(buffer[3],1,11),' ',/extract, count=ntok))
  (*dataPtr.mosaic_ptr) = float(toks[4:6]) ;float(strsplit(strmid(buffer[3],18,8),' ',/extract, count=ntok))
  (*dataPtr.orientation_ptr) = float(toks[[7,8,9,11,12,13]]) ;(float(strsplit(strmid(buffer[3],36,23),' ',/extract, count=ntok)))[[0,1,2,4,5,6]]

  (*(dataPtr).lattice_ptr) = float(strsplit(buffer[5],' ',/extract, count=ntok))

  toks = float(strsplit(buffer[7],' ',/extract, count=ntok))
  Ecenter = toks[0]
  Edelta = toks[1]
  dataPtr.fixedEValue = toks[2]
  dataPtr.dSpaceM = toks[3]
  dataPtr.dSpaceA = toks[4]   
  dataPtr.fixedEType = (stregex(buffer[8],'EM fixed',/fold,/bool))? 'Ei' : 'Ef'
  temp = toks[5]+fltarr(npts)*toks[6]
  
  toks = float(strsplit(buffer[9],' ',/extract, count=ntok))
  magfield = toks[6]+fltarr(npts)
  
  toks = strsplit(buffer[11],' ',/extract, count=ntok)
  dataPtr.nPix = fix(toks[2])
  
  ; now the data section.
  toks = strupcase(strsplit(buffer[12],' ',/extract, count=ntok))
  tempIndex = where(toks eq 'TEMP' or toks eq 'T-ACT',tempExist)
  timeIndex = where(toks eq 'MIN',timeExist)
  fieldIndex = where(toks eq 'HFIELD',fieldExist)
  
  hbuf = fltarr(ntok)
  dbuf = lonarr(dataPtr.nPix)
  
  npts = (npts gt 0)? npts : 2000
  time = (totErrs = (totCnts =  (omega = (qx = (qy = (qz = fltarr(npts)))))))
  detCnts = fltarr(dataPtr.nPix,npts)
  
  i = -1
  while (not eof(lun)) do begin
    readf, lun, hbuf,dbuf       ; read data point from file
    i = i + 1
    qx[i] = hbuf[0]
    qy[i] = hbuf[1]
    qz[i] = hbuf[2]
    omega[i] = hbuf[3]
    if (timeExist) then time[i] = hbuf[timeIndex]
    if (tempExist) then temp[i] = hbuf[tempIndex]
    if (fieldExist) then magfield[i] = hbuf[fieldIndex]
    totCnts[i] = hbuf[ntok-1]
    detCnts[*,i] = dbuf
  endwhile

  npts = i
  dataPtr.npts = npts
  
  ; identify scan variable
  void = where(abs(qx[1:npts-1] - qx[0:npts-2]) gt 0.0001, isVarying)
  if (isVarying gt 0) then dataPtr.indep_var_tag = 'H'
  void = where(abs(qy[1:npts-1] - qy[0:npts-2]) gt 0.0001, isVarying)
  if (isVarying gt 0) then dataPtr.indep_var_tag = 'K'
  void = where(abs(qz[1:npts-1] - qz[0:npts-2]) gt 0.0001, isVarying)
  if (isVarying gt 0) then dataPtr.indep_var_tag = 'L'
  void = where(abs(omega[1:npts-1] - omega[0:npts-2]) gt 0.0001, isVarying)
  if (isVarying gt 0) then dataPtr.indep_var_tag = 'E'  

  dataPtr.h = ptr_new(qx[0:npts-1],/no_copy)
  dataPtr.k = ptr_new(qy[0:npts-1],/no_copy)
  dataPtr.l = ptr_new(qz[0:npts-1],/no_copy)
  dataPtr.time = ptr_new(time[0:npts-1],/no_copy)
  dataPtr.psddets = ptr_new(detCnts[*,0:npts-1],/no_copy)

  dataPtr.magfield = ptr_new(magfield[0:npts-1],/no_copy)
  dataPtr.temp = ptr_new(temp[0:npts-1],/no_copy)
  dataPtr.mon = ptr_new( dataPtr.monave*dataPtr.prefactor + fltarr(npts) )

  
  omega = omega[0:npts-1]
  case dataPtr.fixedEType of
    'Ei': begin
      ei = dataPtr.fixedEValue + fltarr(npts)
      ef = ei - omega
      dataPtr.e = ptr_new(omega,/no_copy)
      dataPtr.ei = ptr_new(ei,/no_copy)
      dataPtr.ef = ptr_new(ef,/no_copy)
    end
    
    'Ef': begin
      ef = dataPtr.fixedEValue + fltarr(npts)
      ei = ef + omega
      dataPtr.e = ptr_new(omega,/no_copy)
      dataPtr.ei = ptr_new(ei,/no_copy)
      dataPtr.ef = ptr_new(ef,/no_copy)
    end
    
    else:
  endcase

endif else if (dataPtr.scanType eq 'I') then begin
  toks = strsplit(buffer[3],' ',/extract, count=ntok)  
  (*dataPtr.collim_ptr) = float(toks[0:3])
  (*dataPtr.mosaic_ptr) = float(toks[4:6])
  magfield = float(toks[10])+fltarr(npts)
  
  toks = float(strsplit(buffer[5],' ',/extract, count=ntok))
  A1 = toks[1] + findgen(npts)*toks[2]
  toks = float(strsplit(buffer[6],' ',/extract, count=ntok))
  A2 = toks[1] + findgen(npts)*toks[2]
  toks = float(strsplit(buffer[7],' ',/extract, count=ntok))
  A3 = toks[1] + findgen(npts)*toks[2]
  toks = float(strsplit(buffer[8],' ',/extract, count=ntok))
  A4 = toks[1] + findgen(npts)*toks[2]
  toks = float(strsplit(buffer[9],' ',/extract, count=ntok))
  A5 = toks[1] + findgen(npts)*toks[2]
  toks = float(strsplit(buffer[10],' ',/extract, count=ntok))
  A6 = toks[1] + findgen(npts)*toks[2]


  toks = strsplit(buffer[12],' ',/extract, count=ntok)
  dataPtr.nPix = fix(toks[2])

  toks = strupcase(strsplit(buffer[13],' ',/extract, count=ntok))
  motorLabel = strtrim(toks[0],2)  
  hbuf = fltarr(ntok)
  tempIndex = where(toks eq 'TEMP',tempExist)
  timeIndex = where(toks eq 'MIN',timeExist)
  
;  tempExist = strtrim(toks[1],2) eq 'TEMP'
;  if (tempExist) then $
;    hbuf = fltarr(5) else $
;    hbuf = fltarr(4)

  ; now the data section.
  dbuf = lonarr(dataPtr.nPix)
  
  npts = (npts gt 0)? npts : 2000
  time = (temp = (motor = fltarr(npts)))
  detCnts = fltarr(dataPtr.nPix,npts)
  
  i = -1
  while (not eof(lun)) do begin
    readf, lun, hbuf,dbuf       ; read data point from file
    i = i + 1
    motor[i] = hbuf[0]
;    if (tempExist) then begin
;      temp[i] = hbuf[1]
;      time[i] = hbuf[2]
;    endif else begin
;      temp[i] = 0.0
;      time[i] = hbuf[1]
;    endelse
    if (tempExist) then temp[i] = hbuf[tempIndex]
    if (timeExist) then time[i] = hbuf[timeIndex]
    detCnts[*,i] = dbuf
  endwhile

  npts = i + 1
  dataPtr.npts = npts

  dataPtr.A1 = ptr_new(A1[0:npts-1],/no_copy)
  dataPtr.A2 = ptr_new(A2[0:npts-1],/no_copy)
  dataPtr.A3 = ptr_new(A3[0:npts-1],/no_copy)
  dataPtr.A4 = ptr_new(A4[0:npts-1],/no_copy)
  dataPtr.A5 = ptr_new(A5[0:npts-1],/no_copy)
  dataPtr.A6 = ptr_new(A6[0:npts-1],/no_copy)
  dataPtr.magfield = ptr_new(magfield[0:npts-1],/no_copy)
  dataPtr.mon = ptr_new( dataPtr.monave*dataPtr.prefactor + fltarr(npts) )  
  
  ; locate 'motorLabel' in dataPtr and replace its values with that read from data section
  tags = tag_names(dataPtr)
  index = where(tags eq motorLabel, found)
  if (found) then (*dataPtr.(index)) = motor[0:npts-1]
  dataPtr.indep_var_tag = motorLabel
  
  dataPtr.temp = ptr_new(temp[0:npts-1],/no_copy)
  dataPtr.time = ptr_new(time[0:npts-1],/no_copy)
  dataPtr.psddets = ptr_new(detCnts[*,0:npts-1],/no_copy)
  
  ei = Self.ekFac * (2*!pi/(2*dataPtr.dSpaceM*sin(0.5*(*dataPtr.a2)*!dtor)))^2
  ef = Self.ekFac * (2*!pi/(2*dataPtr.dSpaceA*sin(0.5*(*dataPtr.a6)*!dtor)))^2
  omega = ei - ef
  dataPtr.e = ptr_new(omega,/no_copy)
  dataPtr.ei = ptr_new(ei,/no_copy)
  dataPtr.ef = ptr_new(ef,/no_copy)
endif

free_lun, lun, /force
if (keyword_set(fromFTP)) then FILE_DELETE, filename  ;  delete temp data file

dataPtr = ptr_new(dataPtr,/no_copy)
return, 1
end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::UpdatePropertySheet
;
; PURPOSE:
;   Update the propertysheet to reflect the current sample type
;
; PARAMETERS:
;
; KEYWORDS:
;    typeCheck - if datasets already loaded use dialog to warn about possibility of samplt type change
;
pro SPINSpsdTool::UpdatePropertySheet, typeCheck=typeCheck
compile_opt idl2

Self->GetProperty, SAMPCONTREF=oSamp
nSamp = oSamp->Count()
if (nSamp gt 0 && keyword_set(typeCheck)) then begin
   msg = 'Not advisable to change Sample Type with data already loaded!'
   msg = [msg,'Do you wish to delete all loaded datasets first?']
   title = 'Change Sample Type: Delete data?'
   status = Self->PromptUserYesNo(msg,answer,title=title)
   if (status && answer) then $
      void = Self->DeleteAllDatasets(/noPrompt)
endif

sxProps = ptr_valid(Self.sxtalOnlyPropsPtr)? (*Self.sxtalOnlyPropsPtr) : []
nsxProps = n_elements(sxProps)
pdProps = ptr_valid(Self.powderOnlyPropsPtr)? (*Self.powderOnlyPropsPtr) : []
npdProps = n_elements(pdProps)
;sxPdProps = ptr_valid(Self.sxtalPowderPropsPtr)? (*Self.sxtalPowderPropsPtr) : []
;nSxPdProps = n_elements(sxPdProps)
;rwProps = ptr_valid(Self.rawOnlyPropsPtr)? (*Self.rawOnlyPropsPtr) : []
;nrwProps = n_elements(rwProps)

oUI = Self->GetUI()
uiPresent = obj_valid(oUI)
if (uiPresent) then begin
   oUI->GetProperty, group_leader = wTLB
   wChild = widget_info(wTLB, /child)
   widget_control, wChild, get_uvalue=sPtr
endif

Self->SetPropertyAttribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)
case Self.scanType of

   'I': begin ; powder
      for i = 0, nsxProps-1 do Self->SetPropertyAttribute, sxProps[i], hide=1
      ;for i = 0, nrwProps-1 do Self->SetPropertyAttribute, rwProps[i], hide=1

      for i = 0, npdProps-1 do Self->SetPropertyAttribute, pdProps[i], hide=0
      ;for i = 0, nSxPdProps-1 do Self->SetPropertyAttribute, sxPdProps[i], hide=0

      ; fix label for x-axis variable
      Self->SetPropertyAttribute,'xAxisVar', name='Horizontal Axis Variable', enumlist=(*Self.indepVars2Ptr)

      ; fix label for y-axis variable
      Self->SetPropertyAttribute,'yAxisVar', name='Vertical Axis Variable', enumlist=(*Self.indepVars2Ptr)
      Self->GetProperty, yAxisVar=yAxisVar
      if (yAxisVar ge n_elements((*Self.indepVars2Ptr)) ) then begin
         Self->SetProperty, yAxisVar = 1
      endif

   end
   
   'Q': begin ; single crystal
      for i = 0, npdProps-1 do Self->SetPropertyAttribute, pdProps[i], hide=1
      ;for i = 0, nrwProps-1 do Self->SetPropertyAttribute, rwProps[i], hide=1

      for i = 0, nsxProps-1 do Self->SetPropertyAttribute, sxProps[i], hide=0
      ;for i = 0, nSxPdProps-1 do Self->SetPropertyAttribute, sxPdProps[i], hide=0

      ; fix label for x-axis variable
      Self->SetPropertyAttribute,'xAxisVar', name='Horizontal Axis Variable', enumlist=(*Self.indepVars1Ptr)

      ; fix label for y-axis variable
      Self->SetPropertyAttribute,'yAxisVar', name='Vertical Axis Variable', enumlist=(*Self.indepVars1Ptr)
      Self->GetProperty, yAxisVar=yAxisVar
      if (yAxisVar ge n_elements((*Self.indepVars1Ptr)) ) then begin
         Self->SetProperty, yAxisVar = 1
      endif
      
   end   
   
   else:
endcase
Self->SetPropertyAttribute, 'maxIntensity', hide=(Self.defaultIntensityFlag eq 1)
Self->SetPropertyAttribute, 'minIntensity', hide=(Self.defaultIntensityFlag eq 1)
if (uiPresent) then begin
  widget_control, (*sPtr).wMslice, sensitive=1
  ;; unmap the sxtalbase and map the powderbase
  ;widget_control, (*sPtr).wSxtalBase, map=0
  ;widget_control, (*sPtr).wPowderBase, map=1
endif

end
;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSpsdTool::Plot
;
; PURPOSE:
;   Generates a plot of the specified dataset
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro SPINSpsdTool::Plot, oItem, sPtr, overPlotFlag, lastPlotFlag, position=pos
compile_opt idl2

status = oItem->GetMetaData('SCANTYPE',scanType)
Self->SetProperty, scanType=scanType, typeCheck=0 ; this also triggers a call to UpdatePropertysheet()
if (scanType eq 'I') then Self->PlotSinglecrystal, oItem, sPtr, overPlotFlag, lastPlotFlag
if (scanType eq 'Q') then Self->PlotSinglecrystal, oItem, sPtr, overPlotFlag, lastPlotFlag

end
;-------------------------------------------------------------------------------



;;===============================================================================
;;+
;; SPINSpsdTool::PlotPowder
;;
;; PURPOSE:
;;   Generates a line or contour plot of the specified dataset for the case of a powder sample
;;
;; PARAMETERS:
;;   oItem   - dataset to be plotted
;;   sPtr    - heap variable containing useful widget related info
;;   overPlotFlag  - is overplotting on (1) or off (0)
;;   lastPltFlag   - if overplotting, is this the last plot to be included
;;
;; KEYWORDS:
;;-
;pro SPINSpsdTool::PlotPowder, oItem, sPtr, overPlotFlag, lastPlotFlag
;compile_opt idl2
;
;if (~obj_isa(oItem, 'IDLitParameterSet')) then return
;if (oItem->GetMetaDataCount() eq 0) then return
;
;; Ensure dataset was processed as 'Powder' sample
;status = oItem->GetMetaData('sampTypeFlag',sTypeFlag) 
;if (sTypeFlag ne 0) then begin
;  stypes = ['Powder','Single Crystal','Raw Data']
;  msg = 'Cannot plot dataset; It is of Sample Type: "'+stypes[sTypeFlag]+'" which does not match current setting!'
;  Self->StatusMessage, msg
;  return
;endif
;
;;; Plot the data
;Self->GetProperty, xAxisVar=xAxisVar, indepVar2List=varList, calibParamsisSet=calibParamsisSet
;xvar = varList[xAxisVar]
;
;axisHasChanged = 0
;msg = []
;
;; Default to Data_Index for x-axis if one of the calculated 
;; quantities ['2Theta','d-space','|Q|','E'] was selected by the user
;; and the calibration parameters are not yet loaded
;calculatedVarList = ['2Theta','d-space','|Q|','E']
;void = where(calculatedVarList eq xvar, xvarIsCalculated)
;if (calibParamsisSet) then begin
;  ; if calibration is loaded, use the user selected axes
;  oX = oItem->GetByName(xvar,count=count)
;  if (count ne 1) then return
;endif else begin
;   msg = 'PSD Calibration parameters file is not yet loaded!'
;   if (xvarIsCalculated) then begin
;      oX = oItem->GetByName('Data_Index',count=count)
;      if (count ne 1) then return
;      xAxisVar = where(varList eq 'Data_Index')
;      Self->SetProperty, xAxisVar=xAxisVar
;      msg = [msg,xvar+' cannot be evaluated hence switching Scan Variable axis to Data_Index']
;      axisHasChanged = 1
;      xvar = 'Data_Index'
;   endif else $
;      oX = oItem->GetByName(xvar,count=count)
;endelse
;
;;; If the x data values are constant default to the Data_Index as the axis value
;status = oX->GetData(vdata)
;vmax = max(vdata,min=vmin)
;if (vmax eq vmin) then begin
;  oX = oItem->GetByName('Data_Index',count=count)
;  if (count ne 1) then return
;  xAxisVar = where(varList eq 'Data_Index')
;  Self->SetProperty, xAxisVar=xAxisVar
;  axisHasChanged = 1
;  msg = [msg,xvar+' does not vary hence switching Scan Variable axis to Data_Index']
;  xvar = 'Data_Index'
;endif          
;
;if (axisHasChanged) then Self->ErrorMessage, msg,severity=0,title='SPINS PSD Reduction - Axes selection' 
;
;; retrieve counts and error which are stored as metadata with the independent variable.
;; Store these with the dependent and error variables
;status = oX->GetMetaData('Counts',counts)
;ctype = partype(counts)
;
;if (ctype ne 'IDLVECTOR') then return  ; can't crate a plot from non-vector data
;
;oZ = oItem->GetByName('Counts')
;status = oZ->SetData(counts,/no_copy,/no_notify)
;status = oX->GetMetaData('Error',error)
;oErr = oItem->GetByName('Error')
;status = oErr->SetData(error,/no_copy,/no_notify)
;
;
;oZ->SetProperty, type=ctype
;oX->SetProperty, type=ctype
;oErr->SetProperty, type=ctype
; 
;;; create color Palette using IDL color table colors
;;oTempPalette = IDLgrPalette()
;;oTempPalette->LoadCT, 13
;;oTempPalette->GetProperty, red_values=red, green_values=green, blue_values=blue
;;obj_destroy, oTempPalette
;;oDataRGB = IDLitDataIDLPalette(transpose([[red],[green],[blue]]),name='RGB Table')
;
;strparms = ['Y','X','Y ERROR','X ERROR','VERTICES','PALETTE','VERTEX_COLORS']
;idparms = [oZ->GetFullIdentifier() $
;          ,oX->GetFullIdentifier() $
;          ,oErr->GetFullIdentifier() $
;          ,'','','','']
;visID = 'PLOT'
;opID = 'Operations/Insert Visualization'
;oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
;oRequester->_setTool, Self
;oRequester->GetProperty, show_execution_ui = orig_showUI
;oRequester->SetProperty, show_execution_ui = 0
;
;oItem->GetProperty, name=plotName   ; retrieve the dataset name as shown in the data manager and set it as plotname
;oRequester->SetProperty, name=plotName, parameter_names=strParms, data_ids=idParms, visualization_id=visID
;
;oWin = Self->GetCurrentWindow()
;oView = oWin->GetCurrentView()
;activateManip = 0
;rangeChange = 0
;
;noOverplot = overplotFlag eq 0
;if (Self->HasVisualizations() && noOverplot) then begin
;   ;; store the active manipulator
;   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
;   activateManip = 1
;
;   ;; ensure the existing visualization is selected
;   oLayer = oView->GetCurrentLayer()
;   oWorld = oLayer->GetWorld()
;   oDataSpace = oWorld->GetDataSpaces()
;   oVis = oDataSpace->GetVisualizations(count = nVis)
;    
;   ; retrieve current xrange and yrange to determine if user has zoomed plot
;   oDataSpace->GetProperty, xrange=xr, yrange=yr
;   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
;   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
;   rangeChange = xChange && yChange
;   
;   delID = 'Operations/Edit/Delete'
;   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
;   
;   oDataSpace->Select
;   void = oDelete->DoAction(Self)
;
;   obj_destroy, [oVis,oDataSpace]
;endif
;
;; create the new vis
;oCmd = oRequester->DoAction(Self)
;
;;; Get the newly created vis
;oLayer = oView->GetCurrentLayer()
;oWorld = oLayer->GetWorld()
;oDataSpace = oWorld->GetDataSpaces()
;oVis = oDataSpace->GetVisualizations(count = nVis)
;
;; TODO - fix vis cuztomization
;; Customize it
;Self->CustomizeVis, oVis[nVis-1], plotName, 'SAMPPLOT'
;;oVis[nVis-1]->SetProperty, /fill $
;;                 ,aspect_ratio=aspect_ratio $
;;                 ,transparency = 5 $
;;                 ,n_levels=15 $
;;                 ,pal_color=1  ; => use palette for level colors
;;status = oVis[nVis-1]->SetData(oDataRGB, parameter_name='PALETTE',/by_value)
;
;
;;if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
;;  ; if a multiplot and this is the last entry group all the plots together
;;  ; to form a single entity in the property sheet view
;;  ; And change the new group's name property to 'Contour'
;;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
;;  grpID = 'Operations/Edit/Grouping/Group'
;;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
;;  oGrpCmdSet = oGrpOI->DoAction(Self)
;;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
;;  if (isa(oGrpCmd,'IDLitCommand')) then begin
;;    oGrpCmd->GetProperty, target_identifier=targID
;;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour'
;;  endif
;;endif
;;oDataSpace->SetProperty, aspect_ratio=aspect_ratio
;;if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only
;
;;; customize axes
;;oAxes = oDataSpace->GetAxes(/container)
;;oAxes->SetProperty,axis_style=2  $    ; draw box axes
;;                  ;,yTitle=ylabel, xTitle=xlabel $
;;                  ,zTitle=zlabel
;                  
;
;if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
;Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh
;
;
;
;
;end
;;-------------------------------------------------------------------------------


;===============================================================================
;+
; SPINSpsdTool::PlotSinglecrystal
;
; PURPOSE:
;   Generates a contour plot of the specified dataset for the case of a sngle crystal sample
;
; PARAMETERS:
;   oItem   - dataset to be plotted
;   sPtr    - heap variable containing useful widget related info
;   overPlotFlag  - is overplotting on (1) or off (0)
;   lastPltFlag   - if overplotting, is this the last plot to be included
;
; KEYWORDS:
;-
pro SPINSpsdTool::PlotSinglecrystal, oItem, sPtr, overPlotFlag, lastPlotFlag
compile_opt idl2

if (~obj_isa(oItem, 'IDLitParameterSet')) then return
if (oItem->GetMetaDataCount() eq 0) then return

; Ensure dataset was processed as 'Single Crystal' sample
status = oItem->GetMetaData('SCANTYPE',scanType)
case (scanType) of
  'I': begin
    Self->GetProperty, xAxisVar=xAxisVar,yAxisVar=yAxisVar, indepVar2List=varList $
      ,calibParamsisSet=calibParamsisSet, qUnits=qUnitsFlag

    calculatedVarList = ['2Theta','d-space','|Q|','E']
  end

  'Q': begin
    Self->GetProperty, xAxisVar=xAxisVar,yAxisVar=yAxisVar, indepVar1List=varList $
      ,calibParamsisSet=calibParamsisSet, qUnits=qUnitsFlag
      
    calculatedVarList = ['QX','QY','|Q|','E']
  end
  
  else:
endcase

;; Plot the data
xvar = varList[xAxisVar]
yvar = varList[yAxisVar]

axisHasChanged = 0
msg = []
if (calibParamsisSet) then begin
  ; if calibration is loaded, use the user selected axes
  oX = oItem->GetByName(xvar,count=count)
  if (count ne 1) then return
  oY = oItem->GetByName(yvar,count=count)
  if (count ne 1) then return
endif else begin
  ; else default to PSDPixel for x and 'TEMP' for y axis
  ; if one of the calculated quantities ['QX','QY','|Q|','E'] was selected by the user
  void = where(calculatedVarList eq xvar, xvarIsCalculated)
  void = where(calculatedVarList eq yvar, yvarIsCalculated)
  msg = 'PSD Calibration parameters file is not yet loaded!'
  
  if (xvarIsCalculated) then begin
     oX = oItem->GetByName('PSDPixel',count=count)
     if (count ne 1) then return
     xAxisVar = where(varList eq 'PSDPixel')
     Self->SetProperty, xAxisVar=xAxisVar
     msg = [msg,xvar+' cannot be evaluated hence switching horizontal axis to PSDPixel']
     axisHasChanged = 1
     xvar = 'PSDPixel'
  endif else $
     oX = oItem->GetByName(xvar,count=count)
  
  if (yvarIsCalculated) then begin
     oY = oItem->GetByName('TEMP',count=count)
     if (count ne 1) then return
     yAxisVar = where(varList eq 'TEMP')
     Self->SetProperty, yaxisVar=yAxisVar
     msg = [msg,yvar+' cannot be evaluated hence switching vertical axis to Temperature']
     axisHasChanged = 1
     yvar = 'TEMP'
  endif else $
     oY = oItem->GetByName(yvar,count=count)
endelse

;; If the x or ydata values are constant default to the PSDPixel or Data_Index as the axis value
status = oX->GetData(vdata)
vmax = max(vdata,min=vmin)
if (vmax eq vmin) then begin
  oX = oItem->GetByName('PSDPixel',count=count)
  if (count ne 1) then return
  xAxisVar = where(varList eq 'PSDPixel')
  Self->SetProperty, xAxisVar=xAxisVar
  axisHasChanged = 1
  msg = [msg,xvar+' does not vary hence switching Horizontal axis to PSDPixel']
  xvar = 'PSDPixel'
endif          
status = oY->GetData(vdata)
vmax = max(vdata,min=vmin)
if (vmax eq vmin) then begin
  oY = oItem->GetByName('Data_Index',count=count)
  if (count ne 1) then return
  yAxisVar = where(varList eq 'Data_Index')
  Self->SetProperty, yAxisVar=yAxisVar
  axisHasChanged = 1
  msg = [msg,yvar+' does not vary hence switching Vertical axis to Data_Index']
  yvar = 'Data_Index'
endif

if (axisHasChanged) then Self->ErrorMessage, msg,severity=0,title='SPINS PSD Reduction - Axes selection' 

; determine aspect ratio of plot
; It should be set to 1 (isotropic) if both x and y axis variables are
; wavevector ('QX' or 'QY')
xIsQ = (xvar eq varList[0]) || (xvar eq varList[1])
yIsQ = (yvar eq varList[0]) || (yvar eq varList[1])
if ((scanType eq 'Q') && xIsQ && yIsQ) then begin
  ; If both x and y are in Q then if the units is in 1/A then the aspect_ratio of the
  ; plot is 1. However when it is r.l.u. then the x and y scales will be different.
  ; In this case, reset the aspect ration to be the same as the ratio of the y and x
  ; relative lattice units so that the aspect ratio will still appear to be 1.
  status = oY->GetMetaData('AA2RLU',yAA2RLU)
  status = oX->GetMetaData('AA2RLU',xAA2RLU)
  aspect_ratio = (qUnitsFlag eq 0)? 1.0 : yAA2RLU/xAA2RLU
  help,'aspect_ratio = ',aspect_ratio
endif


oZ = oItem->GetByName('Counts',count=count)
if (count ne 1) then return
status = oZ->GetData(counts)
CTYPE = partype(counts)
if (ctype ne 'IDLARRAY2D') then return  ; can't crate a plot from non-array (2D) data
zLabel = ''
if (oZ->GetMetaData('LONG_NAME',label)) then zLabel += label
if (oZ->GetMetaData('UNITS',units)) then $
  zLabel = (strlen(units) gt 0)? zLabel+' ('+units+')' : zLabel
 
; create color Palette using IDL color table colors
oTempPalette = IDLgrPalette()
oTempPalette->LoadCT, 13
oTempPalette->GetProperty, red_values=red, green_values=green, blue_values=blue
obj_destroy, oTempPalette
oDataRGB = IDLitDataIDLPalette(transpose([[red],[green],[blue]]),name='RGB Table')

strparms = ['Z','X','Y','PALETTE','RGB_INDICES']
idparms = [oZ->GetFullIdentifier() $
          ,oX->GetFullIdentifier() $
          ,oY->GetFullIdentifier() $
          ,'' $ ;oDataRGB->GetFullIdentifier() $
          ,'']
visID = 'CONTOUR'
opID = 'Operations/Insert Visualization'
oRequester = (Self->GetByIdentifier(opID))->GetObjectInstance()
oRequester->_setTool, Self
oRequester->GetProperty, show_execution_ui = orig_showUI
oRequester->SetProperty, show_execution_ui = 0

oRequester->SetProperty, parameter_names=strParms, data_ids=idParms, visualization_id=visID
 
;Self->DisableUpdates
oWin = Self->GetCurrentWindow()
oView = oWin->GetCurrentView()
activateManip = 0
rangeChange = 0

noOverplot = overplotFlag eq 0
if (Self->HasVisualizations() && noOverplot) then begin
   print, 'Vis deleted...'
   ;; store the active manipulator
   (*sPtr).manipID = (Self->GetCurrentManipulator())->GetFullIdentifier()
   activateManip = 1

   ;; ensure the existing visualization is selected
   oLayer = oView->GetCurrentLayer()
   oWorld = oLayer->GetWorld()
   oDataSpace = oWorld->GetDataSpaces()
   oVis = oDataSpace->GetVisualizations(count = nVis)
    
   ; retrieve current xrange and yrange to determine if user has zoomed plot
   oDataSpace->GetProperty, xrange=xr, yrange=yr
   xChange = ((*sPtr).xrange[0] ne xr[0]) || ((*sPtr).xrange[1] ne xr[1]) 
   yChange = ((*sPtr).yrange[0] ne yr[0]) || ((*sPtr).yrange[1] ne yr[1]) 
   rangeChange = xChange && yChange
   
   delID = 'Operations/Edit/Delete'
   oDelete = (Self->GetByIdentifier(delID))->GetObjectInstance()
   
    ;for i=0,nVis-1 do begin
    ;  oVis[i]->Select ; make it current selection in Tool window
    ; TODO - save vis props
    ;  ;Self->saveVisProps, oVis  ; save vis properties before deleting it
    ;  void = oDelete->DoAction(Self)   ; delete selected item ie the vis
    ;endfor
   oDataSpace->Select
   void = oDelete->DoAction(Self)

   obj_destroy, [oVis,oDataSpace]
   
   ; delete any residual annotations that may have been added
   annID = oView->FindIdentifiers('*ANNOTATION LAYER*',count=nAnn)
   if (nAnn gt 2) then begin
     oVoid = []
     for i=2, nAnn-1 do begin
       oTmp = Self->GetByIdentifier(annID[i])
       oTmp->Select
       oVoid = [oVoid,oTmp]
     endfor
     void = oDelete->DoAction(Self) ; delete selected anootations
     obj_destroy, oVoid
   endif

endif

; create the new vis
oCmd = oRequester->DoAction(Self)

;; Get the newly created vis
oLayer = oView->GetCurrentLayer()
oWorld = oLayer->GetWorld()
oDataSpace = oWorld->GetDataSpaces()
oVis = oDataSpace->GetVisualizations(count = nVis)

; TODO - fix vis cuztomization
; Customize it
;Self->CustomizeVis, oVis, plotname
oItem->Getproperty, name=visname
oVis[nVis-1]->SetProperty, /fill $
                 ,aspect_ratio=aspect_ratio $
                 ,transparency = 5 $
                 ,n_levels=15 $
                 ,name = visname $
                 ,description = visname $
                 ,pal_color=1  ; => use palette for level colors

status = oVis[nVis-1]->SetData(oDataRGB, parameter_name='PALETTE',/by_value)

Self->UpdatePlotIntensityRange, oVis[nVis-1]

if ((nVis gt 1) && overplotFlag && lastplotFlag) then begin
  ; if a multiplot and this is the last entry group all the plots together
  ; to form a single entity in the property sheet view
  ; And change the new group's name property to 'Contour'
;  for i=0,nVis-1 do oVis[i]->Select, additive=(i gt 0)
;  grpID = 'Operations/Edit/Grouping/Group'
;  oGrpOI = (Self->GetByIdentifier(grpID))->GetObjectInstance()
;  oGrpCmdSet = oGrpOI->DoAction(Self)
;  oGrpCmd = (oGrpCmdSet->Get(/all,count=nGrpCmd))[0]
;  if (isa(oGrpCmd,'IDLitCommand')) then begin
;    oGrpCmd->GetProperty, target_identifier=targID
;    (Self->GetByIdentifier(targID))->SetProperty, name='Contour';, manipulator_target=1
;  endif
   oVis[0]->Group,oVis[1:nVis-1]
endif
oDataSpace->SetProperty, aspect_ratio=aspect_ratio
if (noOverplot) then oDataSpace->Translate, 0.20, 0.0, 0.0 ; shift dataspace a bit to left for first plot only

; customize axes
oAxes = oDataSpace->GetAxes(/container)
oAxes->SetProperty,axis_style=2  $    ; draw box axes
                  ;,yTitle=ylabel, xTitle=xlabel $
                  ,zTitle=zlabel

; Update Plot Title text to reflect name of dataset being plotted
; The plot title annotation was automatically created when visualization was first created so
; all we need to do is change the text string
annID = oView->FindIdentifiers('*ANNOTATION LAYER*',count=nAnn)
if (nAnn gt 0) then begin
  oText = Self->GetByIdentifier(annID[1])
  if (isa(oText,'IDLitvisText')) then oText->SetProperty, string=visname
endif

                  

if (activateManip) then Self->ActivateManipulator, (*sPtr).manipID
Self->RefreshCurrentWindow   ;oWin->Draw   ; force window to refresh

end
;-------------------------------------------------------------------------------


;===============================================================================
; SPINSpsdTool::saveAsASCII
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::SaveAsASCII
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB


if (~Self->ExportSelection(asciiPtr, nameTag=nametag, /useTexlabels,/ascii)) then return, 0
if (ptr_valid(asciiPtr)) then begin

   Self->GetProperty, working_directory=workDir
   title = "Specify filename to store ASCII format data"
   ext = 'txt'
   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                          ,/overwrite_prompt, file=nameTag+'.txt',path=workDir, get_path=new_workDir)
                          
   if (~strcmp(filename,'')) then begin
      xvals = (*asciiPtr).xvals
      yvals = (*asciiPtr).yvals
      evals = (*asciiPtr).evals
      nd = n_elements(xvals)
      openw, lun, filename, /get_lun
      for i = 0,nd-1 do printf, lun, format='(3(F11.4,2X))',xvals[i],yvals[i],evals[i]
      
      free_lun, lun, /force
      
      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
   
      msg = 'Output stored in: '+filename
      Self->StatusMessage, msg
   endif
   
   ptr_free, asciiPtr
endif

return, 1
end


;===============================================================================
; SPINSpsdTool::saveAsDave
;
; PURPOSE:
;   Save output to file using DAVE format
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::SaveAsDave
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB


if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels,/dave)) then return, 0
if (ptr_valid(davePtr)) then begin

   Self->GetProperty, working_directory=workDir
   title = "Specify filename to store DAVE format data"
   ext = 'dave'
   filename = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
                          ,/overwrite_prompt, file=nameTag+'.dave',path=workDir, get_path=new_workDir)
                          
   if (~strcmp(filename,'')) then begin
      save, davePtr, filename=filename
      if (file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir
   
      msg = 'Output stored in: '+filename
      Self->StatusMessage, msg
   endif
   
   heap_free, davePtr
endif

return, 1
end


;===============================================================================
; SPINSpsdTool::exportToDaveDM
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::exportToDaveDM
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

;oUI = Self->GetUI()
;oUI->GetProperty, group_leader = wTLB
;
;; display dialog to let user select variables to be exported to Mslice 
;Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel, xAxisVar=xAxisVar, indepVar2List=varList
;if (nSel eq 0) then begin
;   Self->StatusMessage, 'No dataset selected!'
;   return, 0  ; exit if no dataset is currently selected
;endif
;xvar = varList[xAxisVar]

if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then return, 0

if (ptr_valid(davePtr)) then begin
   if ((n_elements(nameTag) le 0) || (strtrim(nameTag,2) eq '')) then nameTag='Untitled'
      
   ; Send data to DAVE Data Manager Folder
   Self.DAVETool->AddDavePtrToDataManager, davePtr, nameTag
   
   msg = "New extry '"+nameTag+"' created in DAVE Data Manager"
   Self->StatusMessage, msg

   heap_free, davePtr
endif

return, 1
end




;===============================================================================
; SPINSpsdTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::ExportSelection, davePtr, nameTag=nameTag, useTexLabels=useTexLabels $
                                    ,dave=dave, ascii=ascii
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

; Check the sample type flag setting
scanType = Self.scanType
if (scanType eq 'Q') then begin
   Self->StatusMessage, 'Cannot export single crystal data to ASCII or DAVE data Format!'
   return, 0 ; can only export powder sample (type=0) or raw (type=2) data
endif

; determine the independent variable required
if (scanType eq 'I') then begin
   ; expect increment scan data
   Self->GetProperty, selectedIDs=selIDs,nSelectedIDs=nSel, xAxisVar=xAxisVar, indepVar2List=varList
   xvar = varList[xAxisVar]
endif else begin
   ; raw data
   Self->GetProperty, xAxisVar=mode, yAxisVar=xAxisVar, indepVar3List=varList, nSelectedIDs=nSel, selectedIDs=selIDs
   ;if ((mode eq 0) || (mode eq 1)) then xvar = 'PSDPixel' ; Cts vs Pixel || Integrated Cts (data points) vs Pixel
   if (mode eq 0) then xvar = 'PSDPixelA4' ; Cts vs Pixel
   if (mode eq 1) then xvar = 'PSDPixel' ; Integrated Cts (data points) vs Pixel
   if (mode eq 2) then xvar = varList[xAxisVar] ; Integrated Cts (detector Pixels) vs ScanVariable
endelse

; Are there any datasets selected?
if (nSel eq 0) then begin
   Self->StatusMessage, 'No dataset selected!'
   return, 0  ; exit if no dataset is currently selected
endif

; Retrieve the selected datasets
oData = []
for i=0,nSel - 1 do begin
   oTmp = Self->GetByIdentifier(selIDs[i])
   status = oTmp->GetMetaData('scanType',sType)
   if (sType ne scanType) then continue ; dataset's scan type must match current that of the app
   oData = [oData,oTmp]
endfor
nSel = n_elements(oData)
if (nSel eq 0) then begin
   Self->StatusMessage, 'No valid dataset selected!'
   return, 0  ; exit if no dataset is currently selected
endif

; Convert selected datasets to ASCII or davePtr structure as necessary 
if (~obj_valid(oData[0])) then return, 0
if (~Self->retrieveDavePtr(oData, xVar, davePtr, scanType=scanType, mode=mode, useTexLabels=useTexLabels, ascii=ascii, dave=dave)) then return, 0

oData[0]->GetProperty, name = nameTag

return, 1

end


;===============================================================================
; SPINSpsdTool::exportToPAN
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::ExportToPAN
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
notifyIDs = [wTLB,wTLB]
Self->GetProperty, working_directory=workDir, data_directory=dataDir

;status = Self->ExportSelectionToDavePtr(davePtr)
if (~Self->ExportSelection(davePtr, nameTag=nametag, /useTexlabels, /dave)) then return, 0

if (ptr_valid(davePtr)) then  begin
   oVoid = obj_new('OPAN',notifyID=[wTLB,wTLB],group_leader=wTLB $
                ,davePtr=davePtr,workDir=workDir,daveTool=Self.DAVETool,dataDir=dataDir)

   heap_free, davePtr
endif

return, 1
end


;===============================================================================
; SPINSpsdTool::saveProperties
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::SaveProperties
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::saveProperties: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

print, 'properties saved...'

return, 1
end


;===============================================================================
; SPINSpsdTool::RetrieveDavePtr
;
; PURPOSE:
;   create a davePtr structure from the data in the specified dataset object
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::RetrieveDavePtr, oData, xVar, davePtr, scanType=scanType, mode=mode, useTexLabels=useTexLabels $
                                     ,dave=dave, ascii=ascii
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        Self->StatusMessage, !ERROR_STATE.msg
        catch, /cancel
        if (ptr_valid(davePtr)) then heap_free, davePtr
        return, 0
    endif
endif

if (~obj_valid(oData[0])) then return, 0
if (xVar eq '') then return, 0

davePtr = ptr_new()

n = n_elements(oData)
xvals = []
yvals = []
evals = []
for i = 0,n-1 do begin
   oX = oData[i]->GetByName(xVar)
   status = oX->GetData(x1)
   oZ = oData[i]->GetByName('Counts')
   status = oZ->GetData(y1)
   oErr = oData[i]->GetByName('Error')
   status = oErr->GetData(e1)
   xvals = [xvals,x1]
   yvals = [yvals,y1]
   evals = [evals,e1]
endfor

index = sort(xvals)
xvals = xvals[index]
yvals = yvals[index]
evals = evals[index]

xLabel = ''
if (oX->GetMetaData('LONG_NAME',label)) then xLabel += label
xUnits = ''
if (oX->GetMetaData('UNITS',units)) then xUnits += units
yLabel = 'Counts'

if (~keyword_set(useTexLabels)) then begin
   xLabel = tex2idl(xLabel)
   xUnits = tex2idl(xunits)
   yLabel = tex2idl(yLabel)
endif

; convert to ASCII struct if required
if (keyword_set(ascii)) then begin
   struct = {xvals:xvals,yvals:yvals,evals:evals,xlabel:xlabel,xunits:xunits,ylabel:ylabel}
   davePtr = ptr_new(struct)
endif

; convert to davePtr struct if required
if (keyword_set(dave)) then begin
   status = oData[0]->GetMetaData('DATAPTRREF',dataPtr)

   status = create_dave_pointer(davePtr, qty=yvals, xvals=xvals, err=evals)
   if (~status) then begin
      msg = "Unable to allocate memory!"
      Self->StatusMessage, msg
      if (ptr_valid(davePtr)) then heap_free, davePtr
      return, 0
   endif
      
   (*(*davePtr).dataStrPtr).commonStr.instrument = 'SPINS'
   (*(*davePtr).dataStrPtr).commonStr.xlabel = xLabel
   (*(*davePtr).dataStrPtr).commonStr.xunits = xunits
   (*(*davePtr).dataStrPtr).commonStr.xtype = 'points'
   (*(*davePtr).dataStrPtr).commonStr.ylabel = ''
   (*(*davePtr).dataStrPtr).commonStr.yunits = ''
   (*(*davePtr).dataStrPtr).commonStr.ytype = 'points'
   
   (*(*davePtr).dataStrPtr).commonStr.histlabel = yLabel
   (*(*davePtr).dataStrPtr).commonStr.histunits = ''
   (*(*(*davePtr).dataStrPtr).commonStr.treatmentPtr) = ''
   
   if (ptr_valid(dataPtr)) then begin
      specificStr = { $
                  filename:(*dataPtr).filename, $
                  monitor:(*dataPtr).monave, $
                  orientation:(*(*dataPtr).orientation_ptr), $
                  latticeParams:(*(*dataPtr).lattice_ptr), $
                  monDSpace:(*dataPtr).dspacem, $
                  anaDSpace:(*dataPtr).dspacea, $
                  pan_filler:!VALUES.F_NAN, $
                  pan_mask:ptr_new(bits2bytes(finite(yvals))) $
                 }
      
      (*(*davePtr).dataStrPtr).specificPtr = ptr_new(specificStr)
   endif
endif

return, 1
end


;===============================================================================
;+
; SPINSpsdTool::WriteProjectAs
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function SPINSpsdTool::WriteProjectAs
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::writeProjectAs: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

Self->GetProperty, nSamp=_nSamp, working_directory=workDir
if (_nSamp le 0) then begin
   msg = 'No data in current session so cannot proceed with save action!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif


projName = file_basename(Self.projName,/fold_case,'.tisv')
oSamp = Self.sampContRef->Get(position = 0)
if (strcmp(projName,'Untitled',/fold_case) && obj_valid(oSamp)) then begin
   oSamp->GetProperty, description=desc
   projName = file_basename(desc,/fold_case,'.ng5')
   ; replace spaces in filename with _
   while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos
endif
title = "Specify filename to store session"
ext = 'tisv'
filter = ['*.tisv']
projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                          ,dialog_parent=wTLB, /write $
                          ,/overwrite_prompt, file=projName+'.tisv' $
                          ,path=workDir, get_path=new_workDir)

if (strcmp(projName,'')) then return, 0 

return, Self->writeProject(/noPrompt, new_workDir=file_dirname(projName,/mark_dir), new_projName=file_basename(projName,/fold_case,'.tisv'))

end


;===============================================================================
;+
; SPINSpsdTool::WriteProject
;
; PURPOSE:
;   save project (data plus state) to file
;
; PARAMETERS:
;
; KEYWORDS:
;-
function SPINSpsdTool::WriteProject, noPrompt=noPrompt, new_workDir=new_workDir,new_projName=new_projName 
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::writeProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return, 0
    endif
endif

; save session preferences
status = Self->SavePreferences(/skip_filesave)

Self->GetProperty, nSamp=_nSamp,nBkgd=_nBkgd $;,nFast=_nFast $
                 , minIntensity=_minIntensity, maxIntensity=_maxIntensity $
                 , preferences=_prefStr, working_directory=workDir
noData = (_nSamp le 0) && (_nBkgd le 0) ;&& (_nFast le 0)
if (noData) then begin
   msg = 'No data in current session so cannot proceed with save action!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=0, title='Save Unnecessary!'
   return, 0
endif

projName = (keyword_set(new_projName))? new_projName : Self.projName
if (keyword_set(new_workDir)) then workDir = new_workDir

if (keyword_set(noPrompt)) then begin
   projName = workDir+projName+'.tisv'
endif else begin
   projName = Self.projName
   oSamp = Self.sampContRef->Get(position = 0)
   if (strcmp(projName,'Untitled',/fold_case) || strcmp(projName,'')) then begin
      oSamp->GetProperty, description=desc
      projName = file_basename(desc,/fold_case,'.ng5')
      ; replace spaces in filename with _
      while ((pos = stregex(projName,' ')) ne -1) do strput, projName,'_',pos

      title = "Specify filename to store session"
      ext = 'tisv'
      filter = ['*.tisv']
      projName = dialog_pickfile(title=title,filter=filter,default_extension=ext $
                                ,dialog_parent=wTLB, /write $
                                ,/overwrite_prompt, file=projName+'.tisv' $
                                ,path=workDir, get_path=new_workDir)
      ;projName = dialog_pickfile(title=title,default_extension=ext, dialog_parent=wTLB $
      ;                       ,/overwrite_prompt, file=projName+'.tisv',path=workDir, get_path=new_workDir)

   endif else projName = workDir+projName+'.tisv'
endelse
                       
if (~strcmp(projName,'')) then begin
   if (_nSamp gt 0) then _datasets = (Self.sampContRef->Get(/all))[0:_nSamp-1]
   if (_nBkgd gt 0) then _datasets = (n_elements(_datasets) gt 0)? $
                                     [_datasets,(Self.bkgdContRef->Get(/all))[0:_nBkgd-1]] : $
                                     (Self.bkgdContRef->Get(/all))[0:_nBkgd-1]
;   if (_nFast gt 0) then _datasets = (n_elements(_datasets) gt 0)? $
;                                     [_datasets,(Self.fastContRef->Get(/all))[0:_nFast-1]] : $
;                                     (Self.fastContRef->Get(/all))[0:_nFast-1]
   nd = n_elements(_datasets)
   _dataPtrs = ptrarr(nd)
   for i=0,nd-1 do begin
      void = _datasets[i]->GetMetaData('DATAPTRREF',dataPtr)
      _dataPtrs[i] = dataPtr
   endfor
   
   ; Get PSD calibration info
   if (Self.calibParamsIsSet) then begin
      _calibInfo = {calibParamsIsSet:Self.calibParamsIsSet $
                   ,calibParamsFilename:Self.calibParamsFilename $
                   ,calibParamsBaseFilename:Self.calibParamsBaseFilename $
                   ,chDelA4:Self.chDelA4 $
                   ,chEf:Self.chEf $
                   ,chEff:Self.chEff $
                   }
   endif else _calibInfo = {calibParamsIsSet:Self.calibParamsIsSet}

   ; Get masking details
   Self->GetProperty, maskedDets=_maskedDets, maskFlag=_maskFlag

   save, _datasets, _dataPtrs, _nSamp, _nBkgd, _prefStr, _calibInfo  $ ;, _nFast
       , _minIntensity, _maxIntensity, _maskedDets, _maskFlag $
       , description = 'SPINSPSD Data Reduction Session' $
       , filename=projName, /compress
   if (isa(new_workDir) && file_test(new_workDir,/directory)) then Self->SetProperty, working_directory=new_workDir

   msg = 'Session stored in: '+projName
   Self->StatusMessage, msg
   
   projName = file_basename(projName,/fold_case,'.tisv')
   Self.projName = projName
   Self->SetProperty, tool_filename=projName
   
   Self.modifiedFlag = 0
endif

return, 1
end


;===============================================================================
; SPINSpsdTool::readProject
;
; PURPOSE:
;   export dataset to DAVE Data Manager
;
; PARAMETERS:
;
; KEYWORDS:
;
function SPINSpsdTool::ReadProject
compile_opt idl2

oUI = Self->GetUI()
oUI->GetProperty, group_leader = wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::ReadProject: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        if (obj_valid(oSave)) then obj_destroy, oSave
        Self->EnableUpdates
        return, 0
    endif
endif

filter = '*.tisv'
Self->GetProperty, working_directory=workDir
if (n_elements(title) eq 0) then title='Specify session to load'

filename = dialog_pickfile(title=title,/must_exist, dialog_parent=wTLB $
                       ,filter=filter,path=workDir, get_path=newWorkDir)

if (filename eq '') then return, 0
Self->SetProperty, work_directory=newWorkDir

oSave = obj_new('IDL_Savefile', filename)
contents = oSave->Contents()
obj_destroy, oSave
expectedDesc='SPINSPSD Data Reduction Session'
if (~strcmp(contents.description,expectedDesc,/fold_case)) then begin
   msg = 'Not a valid SPINS PSD Reduction session file!'
   Self->StatusMessage, msg
   Self->ErrorMessage, msg, severity=1, title='Invalid file type!'   
   return, 0
endif

restore, filename, restored_objects=oObj, /relaxed_structure_assignment
nObj = n_elements(oObj)
if (nObj le 0) then return, 0

; Check whether or not to save current session before closing it
if (Self.modifiedFlag) then begin
   ; If our current state is dirty, prompt to save first.
   Self->GetProperty, working_directory=workDir
   outfile = workDir+Self.projName+'.tisv'
   status = self->PromptUserYesNo( $
       "Save changes to " + outfile + "?", $
       answer, $
       DEFAULT_NO=0, $
       TITLE='Save', $
       /CANCEL)

   if (status && (answer eq 1)) then begin
      void = Self->writeProject(/noPrompt)
   endif

endif

Self->DisableUpdates

; delete all datasets in current session
void = Self->DeleteAllDatasets(/noPrompt)

projName = file_basename(filename,/fold_case,'.tisv')
Self.projName = projName

; update preferences structure to most current definition
status = SPINSPSDReducPreferences(_prefStr,/updateVersion) 

Self->SetProperty, preferences=_prefStr, tool_filename=projName $
                 , maxIntensity=_maxIntensity, minIntensity=_minIntensity, maskedDets=_maskedDets, maskFlag=_maskFlag
Self->SetPropertyAttribute, 'MASKEDDETS', userdef=_maskedDets, sensitive=(_maskFlag eq 1)

; PSD calibration stuff
; Only alter current calib info if one was saved with the project file!
if (_calibInfo.calibParamsIsSet) then begin
   Self.calibParamsIsSet = _calibInfo.calibParamsIsSet
   Self.calibParamsBaseFilename = _calibInfo.calibParamsBaseFilename
   Self.calibParamsFilename = _calibInfo.calibParamsFilename
   Self.chDelA4 = _calibInfo.chDelA4
   Self.chEf = _calibInfo.chEf
   Self.chEff = _calibInfo.chEff
   Self->SetPropertyAttribute, 'calibParamsBaseFilename', userdef=Self.calibParamsBaseFilename
endif
Self->SetPropertyAttribute, 'effNormFlag', sensitive=_calibInfo.calibParamsIsSet


; restore datasets
nd = n_elements(_datasets)
for i=0, nd-1 do begin
   oData = _datasets[i]
   Self->restoreDataVersion, oData
   oData->GetProperty, type=dataType
   case dataType of
      'samp': begin
         Self->AddByIdentifier, 'Sample Data Manager', oData, position=0
         Self.sampContRef->Add, oData
      end
      
      'bkgd': begin
         Self->AddByIdentifier, 'Bkgd Data Manager', oData, position=0
         Self.bkgdContRef->Add, oData
      end
      
      else:
   
   endcase

endfor


Self.nSamp = _nSamp
if (n_elements(_nBkgd) gt 0) then Self.nBkgd = _nBkgd


;Self->SetPropertyAttribute, 'SUMSAMPFLAG', sensitive=(Self.nSamp gt 0)
;
;Self->SetPropertyAttribute, 'SUMBKGDFLAG', sensitive=(Self.nBkgd gt 0)
Self->SetPropertyAttribute, 'BKGDFLAG', sensitive=(Self.nBkgd gt 0)

;; Select a dataset and plot it
if (_nSamp gt 0) then begin
   oItem = Self.sampContRef->Get(position = 0)
   dataType='samp'
endif else if (_nBkgd gt 0) then begin
   oItem = Self.sampContRef->Get(position = 0)
   dataType='bkgd'
endif 

if (obj_valid(oItem)) then begin
   (*sPtr).itemID = oItem->GetFullIdentifier()
   cw_spinspsddatamanager_setselect, (*sPtr).wDM, (*sPtr).itemID, /clear, dataType=dataType ; select it

   wd_SPINSpsdTool_sendPlotEvent, oUI, oItem  ; plot it
                                              ; Plotting will also cause an update of propsheet to reflect selected data
;   status = oItem->GetMetaData('SCANTYPE',scanType)
;   Self->GetProperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
;     , defaultIntensityFlag=defIntFlag
;   noHide = (defIntFlag eq 0) && (scanType eq 'Q')  ; don't hide if not using default intensity and Q-buffer data
;   Self->SetPropertyAttribute, 'maxIntensity', hide=~noHide
;   Self->SetPropertyAttribute, 'minIntensity', hide=~noHide
;   Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
;   Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
;   Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;
;   Self->SetProperty, scanType=scanType, typeCheck = 0
endif

Self.modifiedFlag = 0
Self->refreshPropertySheet
Self->EnableUpdates
return, 1
end


;---------------------------------------------------------------------------
; Lifecycle Routines
;---------------------------------------------------------------------------
; SPINSpsdTool::Init
;
; Purpose:
; The constructor of the SPINSpsdTool object.
;
; Parameters:
; None.
;
function SPINSpsdTool::Init, _REF_EXTRA=_EXTRA
compile_opt idl2

;; Call our super class
if (~self->IDLitTool::Init(_EXTRA=_extra)) then $
  return, 0

oSystem = self->_GetSystem()

; Specify current data version number
; Essentially, whevever the data structure used to store 
; datasets changes the version number should be incremented to reflect
; this. When the version number changes, restoreDataVersion() must also
; be modified to handle restoring older version datasets to the
; current version.
Self.dataVersion = 1

; Add a 'DAVEDATA_MANAGER' service
;self->AddService, OBJ_NEW("DAVEsrvDatamanager", name="DAVEDATA_MANAGER")

; Create the data manager folders
oSampFolder = Obj_New("IDLitDataManagerFolder", identifier='Sample Data Manager' $
                      ,name='Sample', description='Sample Data Manager Container',tool=self)
oBkgdFolder = Obj_New("IDLitDataManagerFolder", identifier='Bkgd Data Manager' $
                      ,name='Background', description='Bkgd Data Manager Container',tool=self)
self->Add, [oSampFolder,oBkgdFolder]


self->createfolders,'Operations/       ',NAME='', description='Horizontal Space'
;;---------------------------------------------------------------------
;;*** File Menu

;; create folders
self->createfolders,'Operations/File',NAME=IDLitLangCatQuery('Menu:File')
;   self->createfolders,'Operations/File/New', $
;                       NAME=IDLitLangCatQuery('Menu:File:New')

;     self->RegisterOperation, 'iPlot', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Plot'

;     self->RegisterOperation, 'iSurface', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Surface'

;     self->RegisterOperation, 'iContour', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Contour'

;     self->RegisterOperation, 'iImage', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Image'

;     self->RegisterOperation, 'iVolume', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Volume'

;     self->RegisterOperation, 'iMap', 'IDLitOpNewTool', $
;         IDENTIFIER='File/New/Map'

;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Open'), $
;  'IDLitopFileOpen', $
;  ACCELERATOR='Ctrl+O', $
;  DESCRIPTION='Open an existing data or image file', $
;  IDENTIFIER='File/Open', ICON='open'


                                ;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Import'), $
;  'IDLitopImportData', $
;  IDENTIFIER='File/Import', $
;  /SEPARATOR
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Export'), $
;  'IDLitopExportData',icon='camera', $
;  IDENTIFIER='File/Export',/separator



self->RegisterOperation, 'Open Session', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='File/readProject'

self->RegisterOperation, 'Save Session', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/writeProject'
self->RegisterOperation, 'Save Session As', $
  'DAVEopMenuItem',icon='Save_24', IDENTIFIER='File/writeProjectAs'

                                ;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Save'), $
;  'IDLitopFileSave', $
;  ACCELERATOR='Ctrl+S', $
;  IDENTIFIER='File/Save', ICON='save', /SEPARATOR

;self->RegisterOperation, IDLitLangCatQuery('Menu:File:SaveAs'), $
;  'IDLitopFileSaveAs', $
;  IDENTIFIER='File/SaveAs', ICON='save'

                                ;-----------------
Self->RegisterOperation,'Export Graphics...' $
  ,'DAVEopExportGraphics' $
  ,identifier='File/Export' $
  ,ACCELERATOR='Ctrl+E' $
  ,writertypes=['IDLDEST','IDLIMAGE'] $
  ,icon='export',/separator

self->RegisterOperation, IDLitLangCatQuery('Menu:File:PrintPreview'), $
  'IDLitopPrintPreview', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/PrintPreview', ICON='print'

self->RegisterOperation, IDLitLangCatQuery('Menu:File:Print'), $
  'IDLitopFilePrint', $
  ACCELERATOR='Ctrl+P', $
  DESCRIPTION='Print the contents of the active window', $
  IDENTIFIER='File/Print', ICON='print_24'


self->RegisterOperation, 'Save Preferences', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/savePreferences',/separator

self->RegisterOperation, 'Reset Preferences (Default Values)', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='File/resetPreferences'

;self->RegisterOperation, IDLitLangCatQuery('Menu:File:Preferences'), $
;  'IDLitopBrowserPrefs', $
;  IDENTIFIER='File/Preferences', /SEPARATOR

                                ;-----------------
self->RegisterOperation, 'Exit', 'DAVEopMenuItem', ACCELERATOR='Ctrl+Q', $
  IDENTIFIER='File/Exit', /SEPARATOR

self->RegisterOperation, 'ExitOp', 'DAVEopFileExit', IDENTIFIER='ExitOp'


;-----------
; Data Input Menu
self->createfolders,'Operations/Input',NAME='Data Input'

self->RegisterOperation, 'Load PSD Calibration Parameters file', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadCalibParams'
self->RegisterOperation, 'View Loaded PSD Calibration Parameters', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/ViewCalibParams'
;self->RegisterOperation, 'Pixel Efficiency', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChEfficiency'
;self->RegisterOperation, 'Pixel A4 Spacing', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChA4'
;self->RegisterOperation, 'Pixel Ef Spacing', $
;  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/PSD Calibration/loadChEf'

self->RegisterOperation, 'Load Sample Data', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSamp', /separator

self->RegisterOperation, 'Load Sample Data (NCNR ftp server)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadSampFtp'

self->RegisterOperation, 'Load Background Data', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgd', /separator

self->RegisterOperation, 'Load Background Data (NCNR ftp server)', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/loadBkgdFtp'

self->RegisterOperation, 'Delete All Loaded Data', $
  'DAVEopMenuItem',icon='open', IDENTIFIER='Input/deleteAllDatasets',/separator



;-----------
; Data Output Menu
self->createfolders,'Operations/Output',NAME='Data Output'
;
;self->RegisterOperation, 'Save output as DAVE file', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsDave', sensitive=0
;
;self->RegisterOperation, 'Save output as ASCII file', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/saveAsAscii', sensitive=0
;
;self->RegisterOperation, 'Export output to DAVE Data Maneger', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToDaveDM', sensitive=0
;
;self->RegisterOperation, 'Fit output in PAN', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator, sensitive=0
  
self->RegisterOperation, 'Export Selection to Mslice', $
  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/Mslice'
;self->RegisterOperation, 'Export Selection to Data Manager (Powder, Raw only)', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/ExportToDaveDM',/separator
;self->RegisterOperation, 'Save Selection as DAVE file (Powder, Raw only)', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsDave'
;self->RegisterOperation, 'Save Selection as ASCII file (Powder, Raw only)', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/SaveAsASCII'
;self->RegisterOperation, 'Fit Selection in PAN (Powder, Raw only)', $
;  'DAVEopMenuItem',icon='save', IDENTIFIER='Output/exportToPAN',/separator




;;---------------------------------------------------------------------
;; Create our File toolbar container.
;;
;self->Register, IDLitLangCatQuery('Menu:File:New'), 'IDLitOpNewTool', $
;                IDENTIFIER='Toolbar/File/NewTool', ICON='new'
;self->Register, IDLitLangCatQuery('Menu:File:Open'), $
;                PROXY='Operations/File/Open', $
;                IDENTIFIER='Toolbar/File/Open'
;self->Register, IDLitLangCatQuery('Menu:File:Save'), $
;                PROXY='Operations/File/Save', $
;                IDENTIFIER='Toolbar/File/Save'
self->Register, "Open Session", $
                PROXY='Operations/File/ReadProject', $
                IDENTIFIER='Toolbar/File/ReadProject'
self->Register, "Save Session", $
                PROXY='Operations/File/WriteProject', $
                IDENTIFIER='Toolbar/File/WriteProject'
self->Register, "Save Session As", $
                PROXY='Operations/File/WriteProjectAs', $
                IDENTIFIER='Toolbar/File/WriteProjectAs'
self->Register, IDLitLangCatQuery('Menu:File:Print'), $
                PROXY='Operations/File/Print', $
                IDENTIFIER='Toolbar/File/Print'
self->Register, IDLitLangCatQuery('Menu:File:PrintPreview'), $
                PROXY='Operations/File/PrintPreview', $
                IDENTIFIER='Toolbar/File/PrintPreview'
self->Register, IDLitLangCatQuery('Menu:File:Export'), $
                PROXY='Operations/File/Export', $
                IDENTIFIER='Toolbar/File/Export'


;;---------------------------------------------------------------------
;;*** Edit Menu

self->createfolders,'Operations/Edit',NAME=IDLitLangCatQuery('Menu:Edit')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Undo'), $
  'IDLitopUndo', $
  ACCELERATOR='Ctrl+Z', $
  IDENTIFIER='Edit/Undo', ICON='undo', /disable, $
  /IGNORE_AVAILABILITY

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Redo'), $
  'IDLitopRedo', $
  ACCELERATOR='Ctrl+Y', $
  IDENTIFIER='Edit/Redo', ICON='redo',/disable, $
  /IGNORE_AVAILABILITY

;; Clipboard...note these are proxied from the system registry!

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Cut'), $
  PROXY="/REGISTRY/OPERATIONS/CUT",$
  IDENTIFIER='Edit/Cut'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Copy') , $
  PROXY='/REGISTRY/OPERATIONS/COPY', $
  IDENTIFIER='Edit/Copy'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Paste') , $
  PROXY='/REGISTRY/OPERATIONS/Paste', $
  IDENTIFIER='Edit/Paste'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:PasteSpecial') , $
  PROXY='/REGISTRY/OPERATIONS/PASTESPECIAL', $
  IDENTIFIER='Edit/PasteSpecial'

                                ;-----------------
self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Delete') , $
  PROXY='/REGISTRY/OPERATIONS/Delete', $
  IDENTIFIER='Edit/Delete'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SelectAll') , $
  'IDLitopSelectAll', $
  DESCRIPTION="Select all visualizations in the current view.", $
  IDENTIFIER='Edit/SelectAll', $
  ICON='select'


                                ;-----------------
self->createfolders,'Operations/Edit/Grouping', $
                    NAME=IDLitLangCatQuery('Menu:Edit:Grouping')

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Group'), $
  'IDLitopGroup', $
  IDENTIFIER='Edit/Grouping/Group', $
  ICON='group', $
  /SEPARATOR

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Ungroup'), $
  'IDLitopUngroup', $
  IDENTIFIER='Edit/Grouping/Ungroup', $
  ICON='ungroup'

;self->createfolders,'Operations/Edit/Order', $
;                    NAME=IDLitLangCatQuery('Menu:Edit:Order')
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringToFront'), $
;  'IDLitopBringToFront', $
;  IDENTIFIER='Edit/Order/BringToFront', $
;  ICON='front'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendToBack'), $
;  'IDLitopSendToBack', $
;  IDENTIFIER='Edit/Order/SendToBack', $
;  ICON='back'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:BringForward'), $
;  'IDLitopBringForward', $
;  IDENTIFIER='Edit/Order/BringForward', $
;  ICON='front'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:SendBackward'), $
;  'IDLitopSendBackward', $
;  IDENTIFIER='Edit/Order/SendBackward', $
;  ICON='back'


;;---------------------------------------------------------------------
;;*** Format Menu

self->createfolders,'Operations/Edit/Style', $
                    NAME=IDLitLangCatQuery('Menu:Style')

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:ApplyStyle') , $
  PROXY='/REGISTRY/OPERATIONS/Apply Style', $
  IDENTIFIER='Edit/Style/Apply Style'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Style:CreateStylefromSelection'), $
  'IDLitopStyleCreate', $
  IDENTIFIER='Edit/Style/Create Style', $
  ICON='style'

self->RegisterOperation, IDLitLangCatQuery('Menu:Style:StyleEditor'), $
  'IDLitopStyleEditor', $
  IDENTIFIER='Edit/Style/StyleEditor', $
  ICON='style'


;;-----------------
;; Register here but make private. We only expose this operation
;; in the context menu, but we want it to be (de)sensitized along with
;; the rest of the Edit menu.
;self->RegisterOperation, 'Export to IDL...', 'IDLitopclExport', $
;  /PRIVATE, $
;  DESCRIPTION='Export Visualization Parameters to IDL Variables. ', $
;  IDENTIFIER='Edit/CLExport', $
;  /separator


;;-----------------
;self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Parameters'), $
;  'IDLitopEditParameters', $
;  IDENTIFIER='Edit/EditParameters', $
;  ICON='binary', $
;  /separator
self->RegisterOperation, 'Edit Parameters','IDLitopEditParameters'

Self->RegisterOperation, 'SaveProperties','DAVEopMenuItem',identifier='Edit/SaveProperties'

self->RegisterOperation, IDLitLangCatQuery('Menu:Edit:Properties'), $
  'IDLitopPropertySheet', $
  DESCRIPTION='Display the Property Sheet for the item', $
  IDENTIFIER='Edit/Properties', $
  ICON='propsheet'


;;---------------------------------------------------------------------
;; Create our Edit toolbar container.
;;
self->Register, IDLitLangCatQuery('Menu:Edit:Undo'), $
                PROXY='Operations/Edit/Undo', $
                IDENTIFIER='Toolbar/Edit/Undo'
self->Register, IDLitLangCatQuery('Menu:Edit:Redo'), $
                PROXY='Operations/Edit/Redo', $
                IDENTIFIER='Toolbar/Edit/Redo'
self->Register, IDLitLangCatQuery('Menu:Edit:Cut'), $
                PROXY="/REGISTRY/OPERATIONS/CUT",$
                IDENTIFIER='Toolbar/Edit/Cut'
self->Register, IDLitLangCatQuery('Menu:Edit:Copy'), $
                PROXY='/REGISTRY/OPERATIONS/COPY', $
                IDENTIFIER='Toolbar/Edit/Copy'
self->Register, IDLitLangCatQuery('Menu:Edit:Paste'), $
                PROXY='/REGISTRY/OPERATIONS/Paste', $
                IDENTIFIER='Toolbar/Edit/Paste'


;;---------------------------------------------------------------------
;;*** Insert menu

self->createfolders,'Operations/Insert', $
                    NAME=IDLitLangCatQuery('Menu:Insert')

;self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:Visualization'), 'IDLitopInsertVis', $
;;  IDENTIFIER='Insert/Visualization', ICON='view'

self->RegisterOperation, 'Insert Visualization','IDLitopInsertVis';, $
;  IDENTIFIER='Insert/Visualization', ICON='view'


self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:View'), $
  'IDLitopInsertView', $
  IDENTIFIER='Insert/View', ICON='view'

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:DataSpace'), $
  'IDLitopInsertDataSpace';, $
  ;IDENTIFIER='Insert/Data Space', ICON='mcr'

;self->createfolders,'Operations/Insert/Axis', NAME=IDLitLangCatQuery('Menu:Insert:Axis')

self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:XAxis'), $
  'IDLitOpInsertAxisX';, IDENTIFIER='Insert/Axis/X Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:YAxis'), $
  'IDLitOpInsertAxisY';, IDENTIFIER='Insert/Axis/Y Axis', ICON='mcr'
self->RegisterOperation, IDLitLangCatQuery('Menu:Insert:ZAxis'), $
  'IDLitOpInsertAxisZ';, IDENTIFIER='Insert/Axis/Z Axis', ICON='mcr'


;;---------------------------------------------------------------------
;;*** Operations Menu
self->createfolders,'Operations/Operations', $
                    NAME=IDLitLangCatQuery('Menu:Operations')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:OperationsBrowser'), $
;  'IDLitopBrowserOperation', $
;  IDENTIFIER='Operations/Operations Browser' ; ,ICON='mcr'

self->createfolders,'Operations/Operations/Macros', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Macros')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RunMacro'), $
  PROXY='/Registry/MacroTools/Run Macro', $
  IDENTIFIER='Operations/Macros/Run Macro'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StartRecording'), $
  PROXY='/Registry/MacroTools/Start Recording', $
  IDENTIFIER='Operations/Macros/Start Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:StopRecording'), $
  PROXY='/Registry/MacroTools/Stop Recording', $
  IDENTIFIER='Operations/Macros/Stop Recording'
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:MacroEditor'), $
  PROXY='/Registry/MacroTools/Macro Editor', $
  IDENTIFIER='Operations/Macros/Macro Editor'

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:Statistics'), $
;  'IDLitopStatistics', $
;  DESCRIPTION='Display statistics for the selected item', $
;  IDENTIFIER='Operations/Statistics', ICON='sum', /SEPARATOR
;
;;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Histogram'), $
;;  'IDLitopHistogram', $
;;  DESCRIPTION='Perform the histogram operation on the selected item', $
;;  IDENTIFIER='Operations/Histogram', ICON='hist'
;
self->createfolders,'Operations/Operations/Filter', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Filter')

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:Convolution'), $
;  'IDLitopConvolution', $
;  DESCRIPTION='Perform the convolution operation on the selected item', $
;  IDENTIFIER='Operations/Filter/Convolution', ICON='sum'
;
self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:Median'), $
  'IDLitopMedianFilter', $
  DESCRIPTION='Perform the median filter operation on the selected item', $
  IDENTIFIER='Operations/Filter/Median', ICON='sum'

self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Smooth'), $
  'IDLitopSmooth', $
  DESCRIPTION='Perform the smooth operation on the selected item', $
  IDENTIFIER='Operations/Filter/Smooth', ICON='sum'

self->createfolders,'Operations/Operations/Rotate', $
                    NAME=IDLitLangCatQuery('Menu:Operations:Rotate')

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateLeft'), $
  'IDLitopRotateLeft', $
  DESCRIPTION='Rotate left by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateLeft', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateRight'), $
  'IDLitopRotateRight', $
  DESCRIPTION='Rotate right by 90 degrees', $
  IDENTIFIER='Operations/Rotate/RotateRight', $
  ICON='rotate'

self->RegisterOperation, $
  IDLitLangCatQuery('Menu:Operations:RotateByAngle'), $
  'IDLitopRotateByAngle', $
  DESCRIPTION='Rotate by a specified angle', $
  IDENTIFIER='Operations/Rotate/RotateByAngle', $
  ICON='rotate'

;self->createfolders,'Operations/Operations/Transform', $
;                    NAME=IDLitLangCatQuery('Menu:Operations:Transform')
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:Resample'), $
;  'IDLitopResample', $
;  IDENTIFIER='Operations/Transform/Resample', ICON='sum'
;
;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Operations:RotateData'), $
;  'IDLitopRotateData', $
;  DESCRIPTION='Rotate the data by a specified angle', $
;  IDENTIFIER='Operations/Transform/RotateData', $
;  ICON='sum'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:ScaleData'), $
;  'IDLitopScaleFactor', $
;  DESCRIPTION='Scale the data by a given factor', $
;  IDENTIFIER='Operations/Transform/ScaleFactor', ICON='sum'
;

;self->RegisterOperation, IDLitLangCatQuery('Menu:Operations:MapProjection'), $
;  'IDLitopMapProjection', $
;  IDENTIFIER='Operations/Map Projection', ICON='surface'


;;---------------------------------------------------------------------
;;*** Window Menu

self->createfolders,'Operations/Window', $
                    NAME=IDLitLangCatQuery('Menu:Window')

;;  Note: temporarily disabling ICON settings for browsers.
;self->RegisterOperation, IDLitLangCatQuery('Menu:Window:DataManager'), $
;  'IDLitopDataManager', $
;  IDENTIFIER='Window/Data Manager', $
;  ICON='prop'                   ; , ICON='mcr'

;     self->RegisterOperation,'Manipulator Browser','IDLitopBrowserManip', $
;         IDENTIFIER='Window/Manipulator Browser'; , ICON='mcr'

;     self->RegisterOperation, 'Tool Browser', 'IDLitopBrowserTool', $
;         IDENTIFIER='Window/Tool Browser'; , ICON='mcr'

;self->RegisterOperation, $
;  IDLitLangCatQuery('Menu:Window:VisualizationBrowser'), $
;  'IDLitopBrowserVis', $
;  IDENTIFIER='Window/Visualization Browser' ; , ICON='mcr'

;;-----------------
Self->RegisterOperation, 'Reset to Default Data Range', 'IDLitopRangeReset' $
   ,description='Reset to default data range', identifier='Window/Resetrange' $
   ,icon='range_reset'

;;--
self->createfolders,'Operations/Toolbar/Dataspace',name='Dataspace'
self->Register, 'Reset to Default Data Range', $
                PROXY='Operations/Window/Resetrange', $
                IDENTIFIER='Toolbar/Dataspace/Resetrange'

self->createfolders,'Operations/Window/Canvas Zoom', $
                    NAME=IDLitLangCatQuery('Menu:Window:CanvasZoom')

self->RegisterOperation, '800%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/800%', $
  ICON='zoom', /CHECKED;, /SEPARATOR
self->RegisterOperation, '400%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/400%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '200%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/200%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '100%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/100%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '75%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/75%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '50%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/50%', $
  ICON='zoom', /CHECKED
self->RegisterOperation, '25%', 'IDLitopCanvasZoom', $
  IDENTIFIER='Window/Canvas Zoom/25%', $
  ICON='zoom', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:ZoomonResize'), $
  'IDLitopZoomResize', $
  ICON='zoom', $
  IDENTIFIER='Window/ZoomResize', /CHECKED

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:Layout'), $
  'IDLitopWindowLayout', $
  IDENTIFIER='Window/Layout'

                                ;-----------------

self->RegisterOperation, IDLitLangCatQuery('Menu:Window:FittoView'), $
  'IDLitopFitToView', $
  IDENTIFIER='Window/FitToView', $
  ICON='fitwindow', /SEPARATOR

;;---------------------------------------------------------------------
;;*** Help Menu
self->createfolders,'Operations/Help', $
                    NAME=IDLitLangCatQuery('Menu:Help')


self->RegisterOperation, "User's Manual", 'DAVEopHelp', $
  IDENTIFIER='Help/SPINSPSDReductionManual',helptopic='SPINSPSD_REDUCTION'
;-----------------

self->RegisterOperation, 'About SPINSPSD Data Reduction', 'SPINSPSDopHelpAbout', $
  IDENTIFIER='Help/About SPINSPSD',/separator

self->RegisterOperation, 'About DAVE', 'DAVEopHelpAbout', $
  IDENTIFIER='Help/About DAVE',/separator




; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponiTools'), $
;   'IDLitopHelpiTools', $
;   ACCELERATOR='F1', $
;   IDENTIFIER='Help/HelpiTools'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsDataManager'), $
;   'IDLitopHelpDataManager', IDENTIFIER='Help/HelpDataManager'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelpontheiToolsParameterEditor'), $
;   'IDLitopHelpParamEditor', IDENTIFIER='Help/HelpParamEditor'
;
; self->RegisterOperation, $
;   IDLitLangCatQuery('Menu:Help:HelponSelectedItem'), $
;   'IDLitopHelpSelection', $
;   IDENTIFIER='Help/HelpSelection', /SEPARATOR
;
; self->RegisterOperation, IDLitLangCatQuery('Menu:Help:HelponthisiTool'), $
;   'IDLitopHelpTool', $
;   IDENTIFIER='Help/HelpTool'
;
;self->RegisterOperation, IDLitLangCatQuery('Menu:Help:AboutiTools'), $
;  'IDLitopHelpAbout', $
;  IDENTIFIER='Help/About iTools'


;;---------------------------------------------------------------------
;;*** Manipulators
self->RegisterManipulator, 'Arrow', 'IDLitManipArrow', $
  ICON='arrow', /DEFAULT, IDENTIFIER="ARROW", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Select')

self->RegisterManipulator, 'Rotate', 'IDLitManipRotate', $
  ICON='rotate', IDENTIFIER="ROTATE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Rotate')

self->RegisterManipulator, 'View Pan', 'IDLitManipViewPan', $
  ICON='hand', IDENTIFIER="VIEWPAN", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:Pan')


;;---------------------------------------------------------------------
;;*** View Zoom Manipulator
self->RegisterManipulator, 'View Zoom', 'IDLitManipViewZoom', $
  IDENTIFIER='View/ViewZoom', ICON='zoom', $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:ViewZoom')

;;---------------------------------------------------------------------
;; *** View Zoom Combobox

                                ; Combobox is not available on True64 (OSF Alpha)
useCombobox = ~(!VERSION.os eq 'OSF')
self->Register, 'View Zoom', 'IDLitopViewZoom', $
                IDENTIFIER='Toolbar/View/ViewZoom', $
                DROPLIST_EDIT=useCombobox, $
                DROPLIST_ITEMS=['800%', $
                                '400%', $
                                '200%', $
                                '150%', $
                                '130%', $
                                '100%', $
                                '75%',  $
                                '50%',  $
                                '25%'], $
                DROPLIST_INDEX=4, $
                /SINGLETON

;;---------------------------------------------------------------------
;;*** Annotation Manipulators
self->RegisterManipulator, 'Text', 'IDLitAnnotateText', $
  ICON='text', IDENTIFIER="ANNOTATION/TEXT", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateText')

self->RegisterManipulator, 'Line', 'IDLitAnnotateLine', $
  ICON='line', IDENTIFIER="ANNOTATION/LINE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateLine')

self->RegisterManipulator, 'Rectangle', 'IDLitAnnotateRectangle', $
  ICON='rectangl', IDENTIFIER="ANNOTATION/RECTANGLE", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateRectangle')

self->RegisterManipulator, 'Oval', 'IDLitAnnotateOval', $
  ICON='ellipse', IDENTIFIER="ANNOTATION/OVAL", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotateOval')

self->RegisterManipulator, 'Polygon', 'IDLitAnnotatePolygon', $
  ICON='segpoly', IDENTIFIER="ANNOTATION/POLYGON", $
  DESCRIPTION=IDLitLangCatQuery('Status:Framework:AnnotatePolygon')

self->RegisterManipulator, 'Freehand', 'IDLitAnnotateFreehand', $
  ICON='freehand', IDENTIFIER="ANNOTATION/FREEHAND", $
  DESCRIPTION='Click & drag to draw'



;;---------------------------------------------------------------------
;;*** DrawContext
;self->Register, 'Cut', $
;                PROXY="/REGISTRY/OPERATIONS/CUT",$
;                IDENTIFIER='ContextMenu/DrawContext/Cut'
;
;self->Register, 'Copy', $
;                PROXY='/REGISTRY/OPERATIONS/COPY', $
;                IDENTIFIER='ContextMenu/DrawContext/Copy'
;
;self->Register, 'Paste', $
;                PROXY='/REGISTRY/OPERATIONS/Paste', $
;                IDENTIFIER='ContextMenu/DrawContext/Paste'
;
;                                ;-----------------
self->Register, 'Delete', $
                PROXY='/REGISTRY/OPERATIONS/Delete', $
                IDENTIFIER='ContextMenu/DrawContext/Delete'

                                ;-----------------
self->Register, 'Group', $
                PROXY='Operations/Edit/Grouping/Group', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Group'

self->Register, 'Ungroup', $
                PROXY='Operations/Edit/Grouping/Ungroup', $
                IDENTIFIER='ContextMenu/DrawContext/Grouping/Ungroup'
;
;self->Register, 'Bring To Front', $
;                PROXY='Operations/Edit/Order/BringToFront', $
;                IDENTIFIER='ContextMenu/DrawContext/Order/BringToFront'
;
;self->Register, 'Send To Back', $
;                PROXY='Operations/Edit/Order/SendToBack', $
;                IDENTIFIER='ContextMenu/DrawContext/Order/SendToBack'
;
;self->Register, 'Bring Forward', $
;                PROXY='Operations/Edit/Order/BringForward', $
;                IDENTIFIER='ContextMenu/DrawContext/Order/BringForward'
;
;self->Register, 'Send Backward', $
;                PROXY='Operations/Edit/Order/SendBackward', $
;                IDENTIFIER='ContextMenu/DrawContext/Order/SendBackward'
;
;                                ;-----------------
;self->Register, 'Export to IDL...', $
;                PROXY='Operations/Edit/CLExport', $
;                IDENTIFIER='ContextMenu/DrawContext/CLExport'

                                ;-----------------
;self->Register, 'Parameters...', $
;                PROXY='Operations/Edit/EditParameters', $
;                IDENTIFIER='ContextMenu/DrawContext/EditParameters'

;self->Register, 'Save Graph Properties...', $
;                PROXY='Operations/Edit/SaveProperties', $
;                IDENTIFIER='ContextMenu/DrawContext/SaveProperties'

self->Register, 'Modify Properties...', $
                PROXY='Operations/Edit/Properties', $
                IDENTIFIER='ContextMenu/DrawContext/Properties'

;;---------------------------------------------------------------------
;;*** CropContext
;self->Register, 'Crop...', 'IDLitopCropImage', $
;                DESCRIPTION='Crop the selected image', $
;                IDENTIFIER='ContextMenu/CropDrawContext/Crop', $
;                ICON='crop', $
;                /SINGLETON

Self.sampContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='SampContainer')
Self.bkgdContRef = obj_new('IDL_Container') ;obj_new('IDLitContainer',name='BkgdContainer')

;; Initialise data and Register Properties

Self.scanType = 'Q'
;Self->RegisterProperty, 'scanType', enumlist=['I-Scan','Q-Scan'], name='Scan Type' $
;                      ,description='Scan Type';, sensitive=0
;hideIfPowder = (Self.scanType eq 'I')? 1 : 0
;;hideIfNotPowder = (Self.scanType eq 'I')? 1 : 0

Self.calibParamsBaseFilename = ''
Self->RegisterProperty, 'calibParamsBaseFilename', userdef='', name='PSD Calib Parameter file' $
                      ,description='Pixel effieciency file'

Self.effNormFlag = 1
Self->RegisterProperty, 'effNormFlag', enumlist=['No','Yes'], name='Apply Pixel Eff Corr?' $
                      ,description='Should Pixel effieciency correction be applied?', sensitive=0


Self.nSamp = 0
Self.nBkgd = 0

Self.sumSampFlag = 0
Self->RegisterProperty, 'sumSampFlag', enumlist=['No','Yes'], name='Sum Sample Data?' $
                      ,description='Sum all loaded Sample data?', sensitive=Self.nSamp, hide=1

Self.indepVars1Ptr = ptr_new(['QX','QY','E','|Q|','TEMP','MAGFIELD','Data_Index','PSDPixel'])
Self.exportIndexPtr = ptr_new([1,1,0,0,0,0,0,0]) 
Self.indepVars2Ptr = ptr_new(['2Theta','d-space','|Q|','E','TEMP','MAGFIELD','Data_Index','PSDPixel'])
Self.indepVars3Ptr = ptr_new(['Data_Index','A1','A2','A3','A4','A5','A6','H','K','L','E','TEMP','MAGFIELD'])
Self.rawModesPtr = ptr_new(['Counts vs Pixel','Integrated Cts vs Pixel','Integrated Cts vs ScanVariable'])

if (Self.scanType eq 'Q') then begin
   ; Q-buffer
   xindVars = (*Self.indepVars1Ptr)
   yindVars = xindVars
   xAxisVar = 0
   yAxisVar = 1
endif else begin
   ; I-buffer
   xindVars = (*Self.indepVars2Ptr)
   yindVars = xindVars
   xAxisVar = 2
   yAxisVar = 3
endelse
xname = 'Horizontal Axis Variable'
yname = 'Vertical Axis Variable'

Self.yAxisVar = yAxisVar
Self->RegisterProperty, 'yAxisVar', enumlist=yindVars, name=yname, description='Y-Axis Variable' $
  ,hide=hideifpowder

Self.xAxisVar = xAxisVar
Self->RegisterProperty, 'xAxisVar', enumlist=xindVars, name=xname, description='X-Axis Variable'

;Self.sharedSettingsFlag = 1
;Self->RegisterProperty, 'sharedSettingsFlag', enumlist=['No','Yes'], name='Datasets share same settings?'
;Self.settingIndex = 0
;Self->RegisterProperty, 'settingIndex', enumlist=[''], name='Dataset name'
;
;Self.dpntIndex=1
;Self->RegisterProperty, 'dpntIndex', /integer, name='Data Point to view';, valid_range[1,1,1]
;Self.minChan=1
;Self->RegisterProperty, 'minChan', /integer, name='Min Pixel (to sum)';, valid_range[1,256,1]
;Self.maxChan=256
;Self->RegisterProperty, 'maxChan', /integer, name='Max Pixel (to sum)';, valid_range[1,256,1]
;Self.minDPnt=1
;Self->RegisterProperty, 'minDPnt', /integer, name='Min Data Point (to sum)';, valid_range[1,1,1]
;Self.maxDPnt=1
;Self->RegisterProperty, 'maxDPnt', /integer, name='Max Data Point (to sum)';, valid_range[1,1,1]

;Self.minBinWidth=0.01   ; no longer relevant so simply hide it
;Self->RegisterProperty, 'minBinWidth', /float, name='Min Bin Width (scan var)' $
;                      ,description='Min Bin Width (scan var)',/hide

Self.qUnits = 1
Self->RegisterProperty, 'qUnits', enumlist=['Inverse Angstroms','Relative lattice units'], name='Units of QX, QY' $
                      ,description='Units to use for QX, QY';,hide=hideifpowder

Self.logFlag = 0
Self->RegisterProperty, 'logFlag', enumlist=['Linear','Logbase10'], name='Intensity Scale' $
                      ,description='Intensity Scale' ;,hide=hideifpowder

Self.defaultIntensityFlag = 1
Self->RegisterProperty, 'defaultIntensityFlag', enumlist=['No','Yes'], name='Use Default Intensity Range?' $
                      ,description='Use Default Intensity Range?' ;,hide=hideifpowder
Self.minIntensity = 0.0
Self->RegisterProperty, 'minIntensity', /float, name='Min Intensity Value' $
                      ,description='Min Intensity Value' ;,hide=hideifpowder
Self.maxIntensity = 0.0
Self->RegisterProperty, 'maxIntensity', /float, name='Max Intensity Value' $
                      ,description='Max Intensity Value' ;,hide=hideifpowder

Self.latParamFlag = 0
Self->RegisterProperty, 'latParamFlag', enumlist=['From Data','User Specified'], name='Latt Param source' $
                      ,description='Lattice Parameter flag' ;,hide=hideifpowder
Self.latticeParameters = ''
Self->RegisterProperty, 'latticeParameters', /string,name='Latt Param: a b c al be ga' $
                      ,description='Lattice Parameters' $
                      ,sensitive=Self.latParamFlag;,hide=hideifpowder

Self.phiOffset = 0.0
Self->RegisterProperty, 'phiOffset', /float, name='A3 Correction (Phi Offset)' $
                      ,description='A3 Correction (Phi Offset)' ;,hide=hideifpowder

Self.maskFlag = 0
Self->RegisterProperty, 'maskFlag', enumlist=['No','Yes'], name='Remove Masked Pixels?' $
                      ,description='Remove Masked Pixels' 
Self.maskedDets = ''
Self->RegisterProperty, 'maskedDets', userdef='',name='Pixels to Mask' $
                      ,description='Pixels to be masked' ;,sensitive=Self.maskFlag

;Self.mergePixelsFlag = 0
;Self->RegisterProperty, 'mergePixelsFlag', enumlist=['No','Yes'], name='Merge PSD Pixels?' $
;                      ,description='Should PSD Pixels be combined?' $
;                      ,hide=~hideIfPowder

Self.normalizeTo = 0
Self->RegisterProperty, 'normalizeTo', enumlist=['Monitor','Counting Time','No Normalization'], name='Normalize To' $
                      ,description='Normalize Counts To'

Self.monScaleValue = 1.0
Self->RegisterProperty, 'monScaleValue', /float, name='Overall Scale Factor' $
                      ,description='Overall Scale Factor'

Self.bkgdFlag = 0
Self->RegisterProperty, 'bkgdFlag', enumlist=['No','Yes'], name='Subtract Bkgd data?' $
                      ,description='Should bkgd data be subtracted' $
                      ,sensitive=(Self.nBkgd gt 0)? 1 : 0

Self.oneOverKfFlag = 0
Self->RegisterProperty, 'oneOverKfFlag', enumlist=['No','Yes'], name='Apply 1/kf correction?' $
                      ,description='Should 1/kf correction be applied'

Self.fastFlag = 0
Self->RegisterProperty, 'fastFlag', enumlist=['No','Yes'], name='Fast Bkgd Corr.?' $
                      ,description='Should fast bkgd correction be applied?'
Self.fastValue = 0.0
Self->RegisterProperty, 'fastValue', /float, name='Fast Bkgd (cts/min)' $
                      ,description='Fast Background Level';, sensitive=Self.fastFlag

Self.monCorFlag = 0
Self->RegisterProperty, 'monCorFlag', enumlist=['No','Yes'], name='Monitor Correction?' $
                      ,description='Should monitor correction be applied?' ;,sensitive=Self.fastFlag

Self.resCorFlag = 0
Self->RegisterProperty, 'resCorFlag', enumlist=['No','Yes'], name='Resolution Correction?' $
                      ,description='Should resolution volume correction be applied?', sensitive=0

Self.detailedBalanceFlag = 0
Self->RegisterProperty, 'detailedBalanceFlag', enumlist=['No','Yes'], name='Det. balance Correction?' $
                      ,description='Should detailed balance correction be applied?',sensitive=Self.fastFlag,hide=1
                      
Self.multipleMsliceWinFlag = 0
Self->RegisterProperty, 'multipleMsliceWinFlag', enumlist=['No','Yes'], name='Allow multiple Mslice?' $
                      ,description='Should multiple Mslice be allowed?'

Self->SetPropertyAttribute, 'NAME', /hide
Self->SetPropertyAttribute, 'DESCRIPTION', /hide
Self.projName = 'Untitled'

;; Finally, set the prompt property to 1 meaning display a warning dialog 
;; before deleting this tool
Self.prompt = 1
Self.promptDesc = 'SPINSPSD Reduction Window'
Self.promptTitle = 'Delete Reduction Window?'

IDLge90 = (float(!version.release) ge 9.0)? 1 : 0
Self.ftpObject =  (IDLge90)? DAVEHttpRequest() :  DAVEftpURL()
Self.ftpObject->SetProperty, currentDir = '/pub/ncnrdata/ng5/'

Self.historyPtr = ptr_new('')

sxtalOnlyProps = ['latticeParameters','latParamFlag','qUnits','phiOffset','yAxisVar'];,'multipleMsliceWinFlag']
Self.sxtalOnlyPropsPtr = ptr_new(sxtalOnlyProps)
Self.powderOnlyPropsPtr = ptr_new(['yAxisVar'])
;Self.sxtalPowderPropsPtr = ptr_new(['fastFlag','fastValue','monCorFlag','resCorFlag','logFlag','maxIntensity','minIntensity','defaultIntensityFlag','multipleMsliceWinFlag']) ;'maskFlag','maskedDets',
;Self.rawOnlyPropsPtr = ptr_new(['minChan','maxChan','minDPnt','maxDPnt','dpntIndex','sharedSettingsFlag','settingIndex'])

; PSD detector calibration init
Self.chDelA4 = 0.0  ; all Pixel a4 delta to 0
Self.chEf = 0.0  ; all Pixel Ef to 0
Self.chEff = 1.0    ; all Pixel efficiency to 1.0

Self.ekFac = 2.072194

return, 1

end


;-------------------------------------------------------------------------
; SPINSpsdTool::SaveVisProps
;+
; Purpose:
;    Retrieve the curent vis properties and save them
;
; Parameters:
;    oVis     - The visualization whose properties are to be saved
;    
;-
pro SPINSpsdTool::SaveVisProps, oVis
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'SPINSpsdTool::SaveVisProps: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

oVis->GetProperty, description=plotDesc
case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; store the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
;      vTags = ['errorbar_capsize','transparency','antialias','color','use_default_color' $
;              ,'sym_increment','sym_index','sym_size','sym_color','sym_thick','y_errorbars' $
;              ,'linestyle','nsum','thick','sym_filled','sym_fill_color']
      tTags = prefix + vTags

      nTags = n_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oVis->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc

      ;; store the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = oAxes[0]->GetPropertyByIdentifier(vTags[i], value)
         if (status) then etc = create_struct(etc,tTags[i],value)
      endfor
      Self->SetProperty, _EXTRA=etc   
   
      break
   end
   
;   'SAMPBKGDPLOT':
;   'FASTFITPLOT': begin
;      ;; Set the vis props
;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
;              ,'linestyle','thick']
;      tTags = prefix + vTags
;
;      nTags = n_elements(vTags)
;      etc = {dummy:''}
;      for i=0, nTags-1 do begin
;         status = oVis->GetPropertyByIdentifier(vTags[i], value)
;         if (status) then etc = create_struct(etc,tTags[i],value)
;      endfor
;      Self->SetProperty, _EXTRA=etc
;   
;      break
;   end
   
   else:
endswitch

end




;-------------------------------------------------------------------------
; SPINSpsdTool::customizeVis
;+
; Purpose:
;    Customize a newly created visualization using attributes obtained from the tool
;
; Parameters:
;    oVis     - The visualization to be customized
;    
;    plotname - a string name to be used to identify the visualization
;-
pro SPINSpsdTool::CustomizeVis, oVis, plotName, plotDesc
compile_opt idl2

if (~obj_valid(oVis)) then return
if (~obj_isa(oVis,'IDLitVisualization')) then return

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'wd_SPINSpsdTool_customizeVis: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=wTLB)
        catch, /cancel
        return
    endif
endif

case strupcase(plotDesc) of
   'SAMPPLOT': prefix = 's_'
   'BKGDPLOT': prefix = 'b_'
;   'FASTPLOT': prefix = 'f_'
;   'SAMPBKGDPLOT': prefix = 'sb_'
;   'FASTFITPLOT': prefix = 'ff_'
   else: return
endcase

switch strupcase(plotDesc) of
   'SAMPPLOT':
   'BKGDPLOT':
   'FASTPLOT': begin
      ;; Set the vis props
      vTags = ['use_default_color','color','errorbar_color','sym_color','errorbar_capsize' $
              ,'sym_increment','sym_index','sym_size','sym_thick','y_errorbars','antialias' $
              ,'linestyle','nsum','thick','sym_filled','sym_fill_color','transparency']
      tTags = prefix + vTags

      nTags = n_elements(vTags)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor

      if (float((strtok(!version.release,/extract))[0]) lt 8.0) then begin
         ; workaround for bug in IDL 7.1 or lower; use_default_color is not honoured for errorbar_color
         if (etc.use_default_color eq 1) then etc.errorbar_color = etc.color
      endif

      oVis->SetProperty, name=strupcase(plotName)
      oVis->SetProperty, name=strupcase(plotName), description=plotDesc, _EXTRA=etc
      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account

      ;; Set the axes props
      vTags = ['font_name','font_size','text_color']
      tTags = prefix + vTags
      nTags = n_elements(vTags)
      oDataSpace = oVis->GetDataSpace()
      oAxes = oDataSpace->GetAxes(count=naxes)
      etc = {dummy:''}
      for i=0, nTags-1 do begin
         status = Self->GetPropertyByIdentifier(tTags[i], value)
         if (status) then etc = create_struct(etc,vTags[i],value)
      endfor
      for i=0,naxes-1 do oAxes[i]->SetProperty, _EXTRA=etc   
   
      break
   end
   
;   'SAMPBKGDPLOT':
;   'FASTFITPLOT': begin
;      ;; Set the vis props
;      vTags = ['transparency','antialias','color','use_default_color','sym_index' $
;              ,'linestyle','thick']
;      tTags = prefix + vTags
;
;      nTags = n_elements(vTags)
;      etc = {dummy:''}
;      for i=0, nTags-1 do begin
;         status = Self->GetPropertyByIdentifier(tTags[i], value)
;         if (status) then etc = create_struct(etc,vTags[i],value)
;      endfor
;      oVis->SetProperty, name=strupcase(plotname), _EXTRA=etc
;      oVis->SetPropertyAttribute, 'NSUM', sensitive=0   ; disable point averaging/smoothing b/c errors are not taken into account
;   
;      break
;   end
   
   else:
endswitch



end



;---------------------------------------------------------------------------
; SPINSpsdTool::InitPreferences
;
; Purpose:
;   This method
;
pro SPINSpsdTool::InitPreferences
compile_opt idl2

; Init working and data directory from the DAVETool values
;daveTool = Self.daveTool
;if (obj_valid(daveTool) and obj_isa(daveTool,'DAVETool')) then begin
;   daveTool->GetProperty, data_directory=datDir, working_directory=workDir
;   Self->SetProperty, data_directory=datDir, working_directory=workDir
;endif


; Retrieve user settings on disk and initialise current session
status = SPINSPSDReducPreferences(preferences)
if (status) then Self->SetProperty, preferences=preferences

Self->GetProperty, maskFlag=mF, fastFlag=fF, xAxisVar=xAxisVar $
                 , defaultIntensityFlag=defIntFlag
;Self->SetProperty, minBinWidth = binwidths[xAxisVar]
noHide = (defIntFlag eq 0)   ; don't hide if not using default intensity and single crystal sample
Self->SetPropertyAttribute, 'maxIntensity', hide=~noHide
Self->SetPropertyAttribute, 'minIntensity', hide=~noHide
Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

; For safety, always initialise phiOffset to 0.0 b/c a user may not be fully aware
; about this setting. A value of 0.0 is harmless
Self->SetProperty, phiOffset = 0.0

Self->refreshPropertySheet

; Update title to reflect session name
; setting tool_filename generates a callback on the registered UI callback
Self->SetProperty, tool_filename=Self.projName

; Retrieve the graphics window
; and set auto-resize and zoom-on-resize to 1 so the graphics window behaves properly when its size is changed
oWin = Self->GetCurrentWindow()
oWin->SetProperty, auto_resize=1, zoom_on_resize=1


;if (float((strtok(!version.release,/extract))[0]) ge 8.0) then begin
;   ; For IDL 8.0 and newer, a title text is added to the graphics by default
;   ; Hide it!
;
;   idText = iGetID('*title*',tool=Self)
;   oText = Self->GetByIdentifier(idText[0])
;   if (isa(oText,'IDLitvisText')) then oText->setProperty, hide=1
;
;   Self->RefreshCurrentWindow
;endif

end


;---------------------------------------------------------------------------
; SPINSpsdTool::resetPreferences
;
; Purpose:
;   This method
;
function SPINSpsdTool::ResetPreferences
compile_opt idl2


; Retrieve user settings on disk and initialise current session
status = SPINSPSDReducPreferences(preferences,/reset)
if (status) then Self->SetProperty, preferences=preferences

Self->GetProperty, maskFlag=mF, fastFlag=fF

Self->SetPropertyAttribute, 'MASKEDDETS', sensitive=mF
Self->SetPropertyAttribute, 'FASTVALUE', sensitive=fF
Self->SetPropertyAttribute, 'MONCORFLAG', sensitive=fF
;Self->SetPropertyAttribute, 'RESCORFLAG', sensitive=mF
;Self->SetPropertyAttribute, 'DETAILEDBALANCEFLAG', sensitive=mF

Self->refreshPropertySheet

end


;---------------------------------------------------------------------------
; SPINSpsdTool::EditUserDefProperty
;
; Purpose:
;   This method
;
function SPINSpsdTool::EditUserDefProperty, oTool, PropID
compile_opt idl2

;; The API requires the oTool arg. It is redundant here since it is Self!

oUI = Self->GetUI()
oUI->GetProperty, group_leader=wTLB
wChild = widget_info(wTLB, /child)
widget_control, wChild, get_uvalue=sPtr

case PropID of
  'CALIBPARAMSBASEFILENAME': begin
    status = Self->loadCalibParams()
  end

;  'chEfBASEFILENAME': begin
;    status = Self->loadChEf()
;    break
;  end
;
;  'CHEFFBASEFILENAME': begin
;    status = Self->loadChEfficiency()
;    break
;  end

  'MASKEDDETS': begin
     ; The currently selected dataset is registered as (*sPtr).itemID
     noSelection = strcmp(strtrim((*sPtr).itemID),'')
     if (noselection) then begin
       ; retrieve the first loaded dataset, if any
       Self->GetProperty, sampContRef=oCont
       oItem = oCont->Get(position=0,count=nItem)
     endif else begin
       oItem = Self->GetByIdentifier((*sPtr).itemID)
       nItem = 1
     endelse
     if (nItem ne 1) then return, 0
     
     wd_SPINSPSDMaskPixels, oUI, oItem, Self.calibParamsIsSet, Self.chEff
  end
  
   
  else:
endcase

Self->refreshPropertySheet

return, 1
end


;---------------------------------------------------------------------------
; SPINSpsdTool__Define
;
; Purpose:
;   This method defines the SPINSpsdTool class.
;
pro SPINSpsdTool__Define
compile_opt idl2

void = { SPINSpsdTool,                 $
         inherits IDLitTool        $   ; Provides iTool interface
         ,dataDir:''               $   ; data directory (Note: working_directory is defined by the base class
         ,nSamp:0                  $   ; nos of valid Sample datasets
         ,nBkgd:0                  $   ; nos of valid bkgd datasets
         ,sampContRef:obj_new()    $   ; container for Sample datasets
         ,bkgdContRef:obj_new()    $   ; container for bkgd datasets
         ,sampSelected:obj_new()   $   ; most recent selection from samp datasets
         ,bkgdSelected:obj_new()   $   ; most recent selection from bkgd datasets
         ,oPlotBkgdFlag:0          $
         ,DAVETool:obj_new()       $   ; DAVETool object
         ,projName:''              $   ; name of current project
         ,nameTag:''               $   ; Tag to be used for identification purposes
         ,prompt:1                 $
         ,promptTitle:''           $
         ,promptDesc:''            $
         ,sumSampFlag:0            $   ; sum multiple sample files? 0=no, 1=yes
         ,sumBkgdFlag:0            $   ; sum multiple bkgd files? 0=no, 1=yes
         ,maskFlag:0               $
         ,maskedDets:''            $   ; masked detectors (stored as a string)
         ,latParamFlag:0           $   ; Use lattice parameter from: 0:raw data file 1:user specified
         ,qUnits:0                 $   ; Units for QX, QY variables: 0->1/A, 1->r.l.u
         ,xAxisVar:0               $   ; Variable to plotted as the x-axis
         ,yAxisVar:0               $   ; variable to be plotted as the y-axis
         ,indepVars1Ptr:ptr_new()  $   ; list of valid sxtal independent variables ('QX','QY','E','|Q|','TEMP','MAGFIELD')
         ,indepVars2Ptr:ptr_new()  $   ; list of valid powder x-axis independent variables ('2THETA','Q','DSPACE','TEMP','MAGFIELD','DATAPOINT')
         ,indepVars3Ptr:ptr_new()  $   ; list of valid powder y-axis independent variables ('2THETA','Q','DSPACE')
         ,rawModesPtr:ptr_new()    $   ; list of possible viewing modes when Samp type is set to 'Raw Data'
         ,exportIndexPtr:ptr_new() $   ; index specifying items in indepVarsPtr to be exported
         ,latticeParameters:''     $   ; lattice parameters
         ,monScaleValue:1.0        $   ; user specified mon scale factor
         ,detailedBalanceFlag:0    $   ; apply detailed balance correction 1=yes, 0=no
         ,bkgdFlag:0               $   ; subtract bkgd data  1=yes, 0=no
         ,fastFlag:0               $   ; apply fast bkgd correction? 1=yes, 0=no
         ,fastValue:0.0            $   ; fast bkgd level in cnts/min
         ,resCorFlag:0             $   ; apply resolution volume correction ? 1=yes, 0=no
         ,monCorFlag:0             $   ; apply monitor correction (due to energy dependent change to incident flux)? 1=yes, 0=no
         ,normalizeTo:0            $   ; normalize counts to: 0: Monitor, 1:Counting Time, 2: Nothing
         ,scanType:''              $   ; scan type of dataset: 'Q': Q-buffer, 'I':increment buffer
         ,prefsPtr:ptr_new()       $   ; points to preference structure
         ,historyPtr:ptr_new()     $
         ,modifiedFlag:0B          $   ; determines modification state of tool - unsufficient control over _bDirty property!
         ,dataVersion:0            $   ; current version number for dataset structure
         ,ftpObject:obj_new()      $   ; DAVEftpURL() object used to access data on ftp://ftp.ncnr.nist.gov/pub/ncnrdata/
         ,calibParamsFilename:''   $
         ,calibParamsBaseFilename:'' $
         ,calibParamsIsSet:0       $
         ,chDelA4:fltarr(256)      $   ; Pixel A4 deltas
         ,chEf:fltarr(256)      $   ; Pixel Ef deltas (or maybe just Pixel Ef)
         ,chEff:fltarr(256)        $   ; Pixel efficiencies
         ,effNormFlag:0            $
         ,minBinWidth:0.01         $   ; user specified current bin width
         ,binWidths:fltarr(7)      $   ; initial bin widths for various powder scan variables
         ,defaultIntensityFlag:0   $   ; use default intensity range 1 = yes, 0 = no
         ,maxIntensity:0.0         $
         ,minIntensity:0.0         $
         ,phiOffset:0.0            $   ; A3 Correction or Phi Offset
         ,logFlag:0                $   ; use linear (0) or log (1) intensity scale
         ,oneOverKfFlag:0          $   ; should 1/kf correction be applied
;         ,lolim:0                  $   ; low limit of range to sum (raw mode)
;         ,hilim:0                  $   ; high limit of range to sum (raw mode)
         ,minChan:0                $
         ,maxChan:0                $
         ,minDPnt:0                $
         ,maxDPnt:0                $
         ,dpntIndex:0              $
         ,pMinDPnt:ptr_new()       $
         ,pMaxDPnt:ptr_new()       $
         ,pDpntIndex:ptr_new()     $      
         ,sharedSettingsFlag:0     $
         ,settingIndex:0           $
;         ,rawPlotType:0            $
;         ,chDelA4isSet:0           $
;         ,chDelA4baseFilename:''   $
;         ,chDelA4fullFilename:''   $
;         ,chEfisSet:0           $
;         ,chEfbaseFilename:''   $
;         ,chEffullFilename:''   $
;         ,chEffisSet:0             $
;         ,chEffbaseFilename:''     $
;         ,chEfffullFilename:''     $
         ,ekFac:2.072194           $   ; Energy = ekFac * k^2
         ,objMslice:obj_new()      $   ; place holder for Mslice object
         ,multipleMsliceWinFlag:0  $   ; should multiple mslice windows be created?
         ,mergePixelsFlag:0      $   ; (powder) whether (1) or not (0) to combine PSD Pixels
         ,sxtalOnlyPropsPtr:ptr_new() $   ;
         ,powderOnlyPropsPtr:ptr_new() $  ;
         ,sxtalPowderPropsPtr:ptr_new() $
         ,rawOnlyPropsPtr:ptr_new()    $
         ,s_errorbar_capsize:    0.1 $
         ,s_transparency:        50 $
         ,s_antialias:           3 $
         ,s_color:               [0,0,255] $
         ,s_errorbar_color:      [0,0,255] $
         ,s_use_default_color:   1   $
         ,s_sym_increment:       1   $
         ,s_sym_index:           4   $
         ,s_sym_size:            1.0   $          ; 
         ,s_sym_color:           [0,0,255] $   ;
         ,s_sym_thick:           1.0 $            ;
         ,s_y_errorbars:         1 $              ; show y errors
         ,s_linestyle:           0 $              ; 
         ,s_nsum:                1 $              ; no point everaging
         ,s_thick:               2.0 $            ; line thickness
         ,s_sym_filled:          1   $            ; use filled symbols
         ,s_sym_fill_color:      [0,0,255] $   ; symbol fill color
         ,s_font_name:           'Helvetica'  $   ;
         ,s_font_size:           13 $             ;
         ,s_text_color:          [0,0,0]  $    ;
;
         ,b_errorbar_capsize:    0.1 $
         ,b_transparency:        50 $
         ,b_antialias:           3 $
         ,b_color:               [0,255,255] $
         ,b_errorbar_color:      [0,255,255] $
         ,b_use_default_color:   1   $
         ,b_sym_increment:       1   $
         ,b_sym_index:           4   $
         ,b_sym_size:            1.0   $          ; 
         ,b_sym_color:           [0,255,255] $   ;
         ,b_sym_thick:           1.0 $            ;
         ,b_y_errorbars:         1 $              ; show y errors
         ,b_linestyle:           6 $              ; no line
         ,b_nsum:                1 $              ; no point everaging
         ,b_thick:               1.0 $            ; line thickness
         ,b_sym_filled:          1   $            ; use filled symbols
         ,b_sym_fill_color:      [0,255,255] $   ; symbol fill color
         ,b_font_name:           'Helvetica'  $   ;
         ,b_font_size:           13 $             ;
         ,b_text_color:          [0,0,0]  $    ;
;
;         ,f_errorbar_capsize:    0.1 $
;         ,f_transparency:        50 $
;         ,f_antialias:           3 $
;         ,f_color:               [0,0,255] $
;         ,f_errorbar_color:      [0,0,255] $
;         ,f_use_default_color:   1   $
;         ,f_sym_increment:       1   $
;         ,f_sym_index:           4   $
;         ,f_sym_size:            1.0   $          ; 
;         ,f_sym_color:           [0,0,255] $   ;
;         ,f_sym_thick:           1.0 $            ;
;         ,f_y_errorbars:         1 $              ; show y errors
;         ,f_linestyle:           6 $              ; no line
;         ,f_nsum:                1 $              ; no point everaging
;         ,f_thick:               1.0 $            ; line thickness
;         ,f_sym_filled:          1   $            ; use filled symbols
;         ,f_sym_fill_color:      [0,0,255] $   ; symbol fill color
;         ,f_font_name:           'Helvetica'  $   ;
;         ,f_font_size:           13 $             ;
;         ,f_text_color:          [0,0,0]  $    ;
;
;         ,sb_transparency:        60 $
;         ,sb_antialias:           3 $
;         ,sb_color:               [0,128,0] $
;         ,sb_use_default_color:   1   $
;         ,sb_sym_index:           0   $            ; no symbol
;         ,sb_linestyle:           0 $              ;
;         ,sb_thick:               5.0 $            ; line thickness
;
;         ,ff_transparency:        60 $
;         ,ff_antialias:           3 $
;         ,ff_color:               [0,128,0] $
;         ,ff_use_default_color:   1   $
;         ,ff_sym_index:           0   $            ; no symbol
;         ,ff_linestyle:           0 $              ;
;         ,ff_thick:               5.0 $            ; line thickness


       }
end
