; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for SPINS PSD Reduction.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2004
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the SPINSPSDTool.
;
; CATEGORY:
;   BT7 PSD Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of SPINSPSDTool object
;
pro SPINSPSD,  identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "SPINS PSD Data Reduction"
identifier = IDLITSYS_CREATETOOL("SPINSPSDMain", name="Preferences" $
                                 ,title=title $ ;  ,/debug
                                 ,dimensions=[650,550] $
                                 ,USER_INTERFACE="SPINSPSD Main Interface" $
                                )

oSystem = oDaveTool->GetSystem()
oSPINSPSDTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oSPINSPSDUI = oSPINSPSDTool->GetUI()
oSPINSPSDUI->GetProperty, group_leader=wSPINSPSDTLB
widget_control, wSPINSPSDTLB, group_leader=gl

; Set system preferences
oSPINSPSDTool->SetProperty, DAVETool=oDAVETool $
                      ,data_directory=dataDir $
                      ,working_directory=workDir $
                      ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oSPINSPSDTool)) then  oSPINSPSDTool->InitPreferences

end
