; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the DAVETool.
;
; CATEGORY:
;   DAVE Main Tool

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of the DAVETool object
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; May 2004
;-
;###############################################################################





;===============================================================================
; NAME:
;   DAVE
;
; PURPOSE:
;   Launch procedure for the GenQFTool.
;
; CATEGORY:
;   BT7 PSD Reduction

; PARAMETERS
;
; KEYWORDS:
;   identifier (out)   - The string identifier of GenQFTool object
;
pro GenQF, identifier=identifier, group_leader=gl, workDir=workDir, dataDir=dataDir, DAVETool=oDAVETool, _EXTRA=etc
compile_opt idl2

;Okay, launch the Main Tool
title = "Evalute QF Functions"
identifier = IDLITSYS_CREATETOOL("GenQFMain", name="Preferences" $
                                 ,title=title $ ;  ,/debug
                                 ,dimensions=[550,450] $
                                 ,USER_INTERFACE="GenQF Main Interface" $
                                )

oSystem = oDaveTool->GetSystem()
oGenQFTool = oSystem->GetByIdentifier(identifier)

; Make widget hierarchy with this tool a child of the DAVETool
oGenQFUI = oGenQFTool->GetUI()
oGenQFUI->GetProperty, group_leader=wGenQFTLB
widget_control, wGenQFTLB, group_leader=gl

; Set system preferences
oGenQFTool->SetProperty, DAVETool=oDAVETool $
                      ,data_directory=dataDir $
                      ,working_directory=workDir $
                      ,name = 'Preferences'  ; b/c want the property sheet in main window to have this label
if (obj_valid(oGenQFTool)) then  oGenQFTool->InitPreferences

; Additional necessary defaults:
; - Set the Automatic Window Resize property of the graphics window to true
; - Set the Stretch to Fit property of the view to true also
; Those two are handy for proper functioning of the generated plots when the user modifies
; the window dimensions or the graphics itself.
oWin = oGenQFTool->GetCurrentWindow()
oWin->SetProperty, auto_resize = 1
oView = oWin->GetCurrentView()
oView->SetProperty, stretch = 1
end
