; $Id$
;###############################################################################
;+
; NAME:
;   DAVE
;
; PURPOSE:
;   Retrieve or save user preferences for FANS Data Reduction module
;
; CATEGORY:
;   FANS Data Reduction

; PARAMETERS
;
; KEYWORDS:
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; April 2010
;-
;###############################################################################




;===============================================================================
; NAME:
;   fansReducPreferences
;
; PURPOSE:
;   Main function
;
; PARAMETERS
;
; KEYWORDS:
;
function fansReducPreferences, preferences, save=save, reset=reset
compile_opt idl2

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        print,'fansReducPreferences: Error Encountered'
        print,!ERROR_STATE.MSG
        catch, /cancel
        return, 0
    endif
endif

; ** Version number **
; ** Increment by 1 whenever the preferences structure content changes **
versionNumber = 2

; Retrieve the app directory
appDir = getDAVEConfigDir()
if (n_elements(appDir) le 0) then return, 0
if (~file_test(appDir,/write,/read)) then return, 0
prefFile = appDir+path_sep()+'fansreducpreferences.txt'

if (keyword_set(save) && strcmp(size(preferences,/tname),'STRUCT')) then begin
   ntags = n_tags(preferences)
   tags = tag_names(preferences)
   if (ntags lt 1) then return, 0

   openw, lun, prefFile, /get_lun
   printf, lun, 'PreferenceVersion : ',strtrim(string(versionNumber),2)
   for i=0,ntags-1 do printf, lun, tags[i] + ' : '+preferences.(i)
   
   close, lun, /force
   
   return, 1
endif

; Check version number
fileVersionNumber = 0
if (file_test(prefFile,/read)) then begin
   buffer = ''
   openr, lun, prefFile, /get_lun
   readf, lun, buffer
   close, lun, /force

   toks = strtrim(strsplit(buffer[0],':',count=ntok,/extract), 2)
   if (ntok eq 2) then fileVersionNumber = fix(toks[1])
endif
if (versionNumber ne fileVersionNumber) then reset = 1   ; force a reset of the preference file

if (keyword_set(reset) || ~file_test(prefFile,/read)) then begin
   ; Set preferences to their default values and save to file
   preferences = {FANSREDUCPREFS $
                  ,nActiveDetectors:      '50' $
                  ,mev2wnos:              '8.065541' $
                  ,energyUnitFlag:        '0' $
                  ,sumSampFlag:           '0' $
                  ,sumBkgdFlag:           '0' $
                  ,sumFastFlag:           '1' $
                  ,maskFlag:              '0' $
                  ,maskedDets:            '' $
                  ,fastFunc:              '0' $
                  ,fastParams:            '' $
                  ,bkgdFlag:              '0' $
                  ,fastFlag:              '0' $
                  ,monScaleFlag:          '0' $
                  ,monScaleValue:         '1' $
                  ,oplotFastFitFlag:      '1' $
                  ,oplotBkgdFlag:         '0' $
                  ,s_errorbar_capsize:    '0.1' $
                  ,s_transparency:        '50' $
                  ,s_antialias:           '3' $
                  ,s_color:               '0,0,255' $
                  ,s_errorbar_color:      '0,0,255' $
                  ,s_use_default_color:   '1'   $
                  ,s_sym_increment:       '1'   $
                  ,s_sym_index:           '4'   $
                  ,s_sym_size:            '1.0'   $          ; 
                  ,s_sym_color:           '0,0,255' $   ;
                  ,s_sym_thick:           '1.0' $            ;
                  ,s_y_errorbars:         '1' $              ; show y errors
                  ,s_linestyle:           '6' $              ; no line
                  ,s_nsum:                '1' $              ; no point everaging
                  ,s_thick:               '1.0' $            ; line thickness
                  ,s_sym_filled:          '1'   $            ; use filled symbols
                  ,s_sym_fill_color:      '0,0,255' $   ; symbol fill color
                  ,s_font_name:           'Helvetica'  $   ;
                  ,s_font_size:           '13' $             ;
                  ,s_text_color:          '0,0,0'  $    ;
                  ,b_errorbar_capsize:    '0.1' $
                  ,b_transparency:        '50' $
                  ,b_antialias:           '3' $
                  ,b_color:               '255,0,0' $
                  ,b_errorbar_color:      '255,0,0' $
                  ,b_use_default_color:   '1'   $
                  ,b_sym_increment:       '1'   $
                  ,b_sym_index:           '4'   $
                  ,b_sym_size:            '1.0'   $          ; 
                  ,b_sym_color:           '255,0,0' $   ;
                  ,b_sym_thick:           '1.0' $            ;
                  ,b_y_errorbars:         '1' $              ; show y errors
                  ,b_linestyle:           '6' $              ; no line
                  ,b_nsum:                '1' $              ; no point everaging
                  ,b_thick:               '1.0' $            ; line thickness
                  ,b_sym_filled:          '1'   $            ; use filled symbols
                  ,b_sym_fill_color:      '255,0,0' $   ; symbol fill color
                  ,b_font_name:           'Helvetica'  $   ;
                  ,b_font_size:           '13' $             ;
                  ,b_text_color:          '0,0,0'  $    ;
                  ,f_errorbar_capsize:    '0.1' $
                  ,f_transparency:        '50' $
                  ,f_antialias:           '3' $
                  ,f_color:               '0,128,0' $
                  ,f_errorbar_color:      '0,128,0' $
                  ,f_use_default_color:   '1'   $
                  ,f_sym_increment:       '1'   $
                  ,f_sym_index:           '4'   $
                  ,f_sym_size:            '1.0'   $          ; 
                  ,f_sym_color:           '0,128,0' $   ;
                  ,f_sym_thick:           '1.0' $            ;
                  ,f_y_errorbars:         '1' $              ; show y errors
                  ,f_linestyle:           '6' $              ; no line
                  ,f_nsum:                '1' $              ; no point everaging
                  ,f_thick:               '1.0' $            ; line thickness
                  ,f_sym_filled:          '1'   $            ; use filled symbols
                  ,f_sym_fill_color:      '0,128,0' $   ; symbol fill color
                  ,f_font_name:           'Helvetica'  $   ;
                  ,f_font_size:           '13' $             ;
                  ,f_text_color:          '0,0,0'  $    ;
                  ,sb_transparency:       '60' $
                  ,sb_antialias:          '3' $
                  ,sb_color:              '255,0,0' $
                  ,sb_use_default_color:  '1'   $
                  ,sb_sym_index:          '0'   $            ; no symbol
                  ,sb_linestyle:          '0' $              ;
                  ,sb_thick:              '3.0' $            ; line thickness
                  ,ff_transparency:       '60' $
                  ,ff_antialias:          '3' $
                  ,ff_color:              '0,128,0' $
                  ,ff_use_default_color:  '1'   $
                  ,ff_sym_index:          '0'   $            ; no symbol
                  ,ff_linestyle:          '0' $              ;
                  ,ff_thick:              '5.0' $            ; line thickness
                 }

   ntags = n_tags(preferences)
   tags = tag_names(preferences)

   openw, lun, prefFile, /get_lun
   printf, lun, 'PreferenceVersion : ',strtrim(string(versionNumber),2)
   for i=0,ntags-1 do printf, lun, tags[i] + ' : '+preferences.(i)
   
   close, lun, /force
endif else begin
   ; Retrieve the current preferences from file
   lines = file_lines(prefFile)
   buffer = strarr(lines)
   openr, lun, prefFile, /get_lun
   readf, lun, buffer
   close, lun, /force
   
   for i=1,lines-1 do begin
      toks = strtrim(strsplit(buffer[i],':',count=ntok,/extract), 2)
      ;toks = strsplit(buffer[i],':',count=ntok,/extract)
      if (ntok gt 1) then begin
         value = (ntok eq 2)? toks[1] : ''
         preferences = (i eq 1)? create_struct(toks[0],value) : $
            create_struct(preferences,toks[0],value)
      endif
   endfor
endelse

return, 1

end

