; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DAVEsrvDataManager
;
; PURPOSE:
;   This file contains the implementation of the DAVEsrvDataManager
;   which essentially extends IDLitsrvDataManager.
;   This service implements operations that are performed on the Dave
;   data manager.
;
; CATEGORY:
;   DAVE Main Tool
;
; SUPERCLASSES:
;   IDLitsrvDataManager
;
; METHODS:
;   CopyData
;
; INTERFACES:
;
;
; Richard Tumanjong Azuah
; NIST Center for Neutron Research
; azuah@nist.gov; (301) 9755604
; Jan 2006
;-
;###############################################################################


;===============================================================================
; DAVEsrvDataManager::CopyData
; 
; PURPOSE:
;   This method is called to make a duplicate of an item in the DAVE
;   data manager folder.
;
; PARAMETERS:
;   idData - The data item to be copied
;
; KEYWORDS:
;   name - The new name for the data item. If not provided, a unique
;          name is generated
;
;   parent - the explicit location within the DAVE data manager to add
;            the data to. If not set, the data's parent is used.
;
;   copyid - the full identifier of the copy
;
; RETURN VALUE:
;   1 - Success
;   0 - Failure
;
function DAVEsrvDataManager::CopyData, idData, parent=idparent, name=name, copyid=copyid
compile_opt idl2

oTool = self->GetTool()

oData = oTool->GetbyIdentifier(idData)

;; no data, no dice
if(~obj_isa(oData, "IDLitData"))then return, 0

;; Get the parent of this data item:
if(keyword_set(idparent))then $
  oParent = oTool->GetByIdentifier(idParent) $
else $
  oData->GetProperty, _PARENT=oparent
if(~obj_valid(oparent))then $
  return, 0

;; Get a copy and set the name on the new data
oCopy = (obj_hasmethod(oData,'Clone'))? oData->Clone() : oData->Copy()

if(not keyword_set(name))then begin
    oCopy->GetProperty, name=name
    ;; make the name unique for all items in the parent
    ;; container. Get a list of the items in the container.
    oItems = oParent->Get(/all, count=count)
    strItems = strarr(count)
    for i=0, count-1 do begin
        oItems[i]->GetProperty, name=itemName
        strItems[i]=itemName
    endfor
    oCopy->SetProperty, name=IDLitGetUniqueName(strItems, name)
endif else $
  oCopy->SetProperty, name=name

if (keyword_set(copyid)) then $
  oCopy->SetProperty, identifier=copyid

oTool->AddDatasetToDataManager, oCopy

; Get final id and name
copyid = oCopy->GetFullIdentifier()
oCopy->GetProperty, name=name

return,1

end
;-------------------------------------------------------------------------------


;===============================================================================
; DAVEsrvDataManager__define
; 
; PURPOSE:
;   DAVEsrvDataManager class structure definition
;
pro DAVEsrvDataManager__define
compile_opt idl2

struc = {DAVEsrvDataManager, $
         inherits IDLitsrvDataManager}

end
