; $Id$

function DAVEopFileSaveAs::DoAction, oTool, SUCCESS=success
compile_opt idl2


;; We always want to show the dialog.
self->SetProperty, /SHOW_EXECUTION_UI

success = self->_Save(oTool)

;if (success eq 1) then begin
;    ;; Be sure our File/Save and File/SaveAs are in sync.
;    oDesc = oTool->GetByIdentifier('Operations/File/Save')
;    if (OBJ_VALID(oDesc)) then $
;      oDesc->SetProperty, FILENAME=self._filename
;endif

;; No undo/redo
return, obj_new()

end


;===============================================================================
; DAVEtool::Init
; 
; PURPOSE:
;   Initialization method for objects of DAVEtool class
;
; PARAMETERS
;
; KEYWORDS:
;
function DAVEopFileSaveAs::Init, _REF_EXTRA=etc
compile_opt idl2

on_error, 2
catch, theError
if (theError ne 0) then begin
    catch, /cancel
    message, /reissue_last
    return, 0
endif

; Default is to show the File Selection dialog,
; so set SHOW_EXECUTION_UI to true.
success = self->IDLitopFileSave::Init(/SHOW_EXECUTION_UI, _EXTRA=etc)

; We always want the File Selection dialog to be shown,
; so don't allow the property to be turned on/off.
self->SetPropertyAttribute, 'SHOW_EXECUTION_UI', /HIDE

return, success

end


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; Purpose:
;   Class definition.
;
pro DAVEopFileSaveAs__define
compile_opt idl2

struc = {DAVEopFileSaveAs $
         ,inherits DAVEopFileSave $
        }

end
