; $Id$
;###############################################################################
;
; NAME:
;  REF_GAUSSIAN
;
; PURPOSE:
;  Implementation of the Gaussian distribution for use in fitting
;  data in RAINS.
;
; CATEGORY:
;  DAVE, Data Analysis, RAINS, surface fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function ref_gaussian,xvals,parms,								$
                    	parmnames = parmnames,					$
                    	init_guess = init_guess,				$
                    	qty = qty,								$
                    	single_parmnames = single_parmnames,	$
                    	multi_parmnames = multi_parmnames,		$
                    	all_y = all_y,							$
                    	res_ptr = res_ptr,						$
                    	step = step,							$
                    	_Extra = extra
nx = extra.nx & ny = extra.ny
x = xvals[0:nx-1] & y = xvals[nx:nx+ny-1]
ux = 1+bytarr(nx) & uy = 1+bytarr(ny)

if (n_params() eq 0) or (n_params() eq 1) then begin
	areastr = 'area:'+strtrim(string(indgen(extra.ny)),2)
	centerstr = 'center:'+strtrim(string(indgen(extra.ny)),2)
	fwhmstr = 'fwhm:'+strtrim(string(indgen(extra.ny)),2)
	parmnames = [areastr,centerstr,fwhmstr]
	single_parmnames = ''
	multi_parmnames = ['area:','center:','fwhm:']
	step = dblarr(3*ny)
	if arg_present(init_guess) then begin
		intensity = max(qty,dimension = 1,index)
		qty_size = size(qty)
		for i = 0,qty_size[2]-1 do begin
			qty_max = max(qty[*,i],index)
			if i eq 0 then index_array = index else $
				index_array = [index_array,index]
		endfor
		center = x[index_array]
		; Guess the 1/2 width at the highest y-value
		; Get the low value first
		amp = max(qty[*,qty_size[2]-2])
		ht = 0.5*amp
		wh_lo = where(abs(amp-ht) le min(abs(amp-ht)) and (x lt 0.0),count_lo)
		x_lo_lim = x[wh_lo[0]]
 		wh_hi = where(abs(amp-ht) le min(abs(amp-ht)) and (x gt 0.0),count_hi)
		x_hi_lim = x[wh_hi[0]]
		fwhm = (x_hi_lim - x_lo_lim)
		sig = fwhm/2.354
		init_guess = [sqrt(2.0*!dpi)*sig*intensity,center,transpose(fwhm#uy)]
	endif

	return,-1
endif

area = parms[0:ny-1]
center = parms[ny:2*ny-1]
sig = (parms[2*ny:3*ny-1])/2.354

dx = (moment(x[1:nx-1]-x[0:nx-2]))[0]
dy = (moment(y[1:ny-1]-y[0:ny-2]))[0]
gauss = (ux#(area/(sig*sqrt(2.0*!dpi))))*exp(-0.5*((x#uy-ux#center)/(ux#sig))^2)
;yout = scat_convolve(x,y,gauss,*res_ptr) 
yout = scat_convolute(x,y,gauss,*res_ptr) ;RTA - scat_convolve->scat_convolute
return,yout
end
