; $Id$



;LRK - 07/30/09  
;
;THIS WAS AN ATTEMPT TO BETTER PROTECT THE NAMES OF VARIABLES PLACED AT THE MAIN LEVEL BY ENCASING THEM
;IN AN IDLitDataContainer THAT WAS STORED AT THE MAIN LEVEL.  IT IS MUCH SLOWER, AND THE REASON FOR
;PROTECTING THE VARIABLES NO LONGER APPEARS TO BE AN ISSUE (i.e. SOME USERS NOTICED THAT SOME OF THE VARIABLES
;IN THEIR MACRO WERE BEING IGNORED, BUT THAT APPEARS TO HAVE BEEN DUE TO SOME INTEGER ARITHMETIC ZEROING
;OUT PARTS OF THEIR FUNCTION.  e.g. (1/2) = 0 AND NOT 0.5!).






;THE GOAL HERE IS TO USE AN OBJECT THAT CAN BE FOUND AT RUN TIME TO GET 
;THE DATA THAT ARE SHUTTLED BACK AND FORTH BETWEEN THE MAIN LEVEL AND
;THE FUNCTION CALL IN THE FIT PROCESS.
;
;THIS WAY THE DATA CAN BE CONTROLLED IN ONE PLACE RATHER THAN RISK OVERWRITING AT THE MAIN LEVEL AND OTHER
;SUCH HAZARDS.
;


function the_one_and_only_pan_macrofunction_object::testScript

    testScript = [ $
                    "parmnames = ['radius','L_hwhm1','center','bgoffset','bgslope','area','L_hwhm2']",$
                    "radius = parms[0] & L_hwhm1 = parms[1]",$
                    "Q=qgroup",$
                    "center = parms[2] & bgoffset = parms[3] & bgslope = parms[4] & area = parms[5]",$
                    "L_hwhm2 = parms[6]",$
                    "ylor1 = (1/!dpi)*L_hwhm1/(L_hwhm1^2+(x-center)^2)",$
                    "ylor2 = (1/!dpi)*L_hwhm2/(L_hwhm2^2+(x-center)^2)",$
                    "ybg = bgoffset + bgslope*x",$
                    "delta_params = [[area*1/4*(1+2*sin(1.414*Q*radius)/(1.414*Q*radius)+sin(2*Q*radius)/(2*Q*radius)),center]]",$
                    "ymodel = area*1/4*((1+2*sin(1.414*Q*radius)/(1.414*Q*radius)+sin(2*Q*radius)/(2*Q*radius))*ylor1+(1/2)*(sin(2*Q*radius)/(2*Q*radius))*ylor2) + ybg" $
                    ]

  return,testScript
end;the_one_and_only_pan_macrofunction_object::testScript

function the_one_and_only_pan_macrofunction_object::pan_do_the_macro,macro_lines,$
                                                                     qgroup=qgroup

;print,'the_one_and_only_pan_macrofunction_object::pan_do_the_macro'
   n_lines = n_elements(macro_lines)
   if macro_lines[0] eq '' then return,0
   nlines = n_elements(macro_lines)

   ;
   ;NOW self IS STORED AT THE MAIN LEVEL.  
   ;
   ;FIRST I WANT TO GET ALL THE DATA IN self.
   ;
   ;WHEN execute RUNS, IT IS PUTTING ALL IT'S STUFF AT THIS LEVEL
   ;
   ;SO I JUST HAVE TO CHECK TO SEE WHAT IS HERE BEFORE AND AFTER.
   ;
   ;IF THERE IS SOMETHING NEW, I DO:
   ;
   ;   success = self->add(data,varname)

 
   ;GET ALL THE VARIABLE NAMES FOR THIS LEVEL
   this_level = routine_names(/level)

if n_lines eq 1 then begin
;JUST GETTING THE PARMNAMES!!!!!   ----> I ASSUME THAT user_function USES A DIFFERENT SET OF CODE TO UPDATE.

   old_current = routine_names(variables=this_level)
   r = execute(macro_lines[0],1)                         ;<----- WHAT IF THE MACRO HAS A VARIABLE NAMED "this_level"??????? 
   after_execute = routine_names(variables = this_level)

   ret = self->setData(parmnames,'PARMNAMES')
  return,ret
endif;n_lines eq 1



;   ; What are the variable names in the current level?
   old_current = routine_names(variables=this_level)


   ids = self->getIdentifiers()
   old_main = ids

;THE NEXT SEVERAL LINES ARE INCLUDED IN THE _i LOOP BELOW.
;;GET THE DATA VALUES THAT ARE LIKELY NEEDED IN THE MACRO EXECUTION.
       dum = self->getData(x,'x')
       dum = self->getData(parms,'parms')
       dum = self->getData(parmnames,'parmnames')
       dum = self->getData(Qgroup,'Qgroup')
       dum = self->getData(resptr,'resptr')      ;<-------- WHEN IS resptr SET?  WILL THERE BE A MEMORY LEAK ALONG THE WAY?

   
;;   ; What are the variable names in the main level?
   n_old_main = n_elements(old_main)


   if old_main[0] eq "" then begin
     n_old_main = 0
   endif else begin
     ; put the main level variables in the current level          ;<------- HERE I WANT TO GET ALL THE EXISTING VARIABLES IN self

  
     ;FIRST GET ALL VARIABLES AT THIS LEVEL
     for _i = 0,n_old_main-1 do begin

            ;OLD CODE DOES:
            ;
            ;CHECKS IF THE VARIABLE AT THE MAIN LEVEL HAS ELEMENTS
            ;
            ;IF IT HAS ELEMENTS, THEN IT STORES A COPY AT THIS LEVEL
            ;
            
            ;CREATE THE VARIABLE FOR THE IDENTIFIER AT THIS LEVEL

            dum = self->getData(value,ids[_i])    ;<------ THIS STORES A COPY OF THE DATA AT THIS LEVEL, HOWEVER, IT STORES
                                                  ;        IT IN THE VARIABLE NAMED value!!!!!!
                                                  ;HOW DO I CREATE A VARIABLE WITH THE RIGHT NAME????????
                                                  ;USE THE EXECUTE TRICK HERE TO GET THE VARIABLES THAT I CAN THEN RESET TO ANYTHING I WANT.
                                                  ;
                                                  ; 
            
            before_execute = routine_names(variables = this_level)
            r = execute(ids[_i]+'=value') 
            after_execute = routine_names(variables = this_level)
            nbefore = n_elements(before_execute)
            nafter  = n_elements(after_execute)
     endfor;_i
   endelse
;
;
;NOW THAT WE HAVE ALL THE DATA FROM main AT THIS LEVEL, 
;WE CAN 
;    1) EXECUTE EACH LINE OF THE SCRIPT
;    2) SEE WHAT VARIABLES EACH LINE INTRODUCES
;    3) THEN WE COPY EACH NEW VARIABLE TO THE MAIN LEVEL 
;
for _i = 0,nlines-1 do begin


     before_execute = routine_names(variables = this_level)
     r = execute(macro_lines[_i],1)                         ;<----- WHAT IF THE MACRO HAS A VARIABLE NAMED "this_level"??????? 
     after_execute = routine_names(variables = this_level)


;
    if r ne 1 then begin
      ;void = dialog_message(['User macro failed to execute properly.',!error_state.msg],/error)
      print,['User macro failed to execute properly.',!error_state.msg]
      return,0
    endif
;
;  ; are there any new variables introduced due to execute at this level?
    n_before = n_elements(before_execute)
    n_after = n_elements(after_execute)

    counter = 0L
    if n_before ne n_after then begin
      for _ii = 0,n_after-1 do begin
        whereok = where(before_execute eq after_execute[_ii],count)   ;<----- FIGURE OUT WHICH VARIABLES ARE NEW AND ADD 
                                                                      ;       THEM TO self.  ;i.e.   CREATE A NEW idlitdata OBJECT WITH THE
                                                                      ;                              IDENTIFIER AND ADD IT TO self IN THE LOOP BELOW

        if count eq 0 then begin
          if counter eq 0L then new_var = after_execute[_ii] else $
            new_var = [new_var,after_execute[_ii]]
            counter = counter+1L
        endif
      endfor;_ii

      ; Promote new variables from this level to the $MAIN$ level   ;<---- INSTEAD I WANT TO PUT THE NEW VARIABLES INTO self
      for _ii = 0,counter-1 do begin
           if n_elements(routine_names(new_var[_ii],fetch = this_level)) gt 0 then begin
             value  = routine_names(new_var[_ii], fetch = this_level)
             datObj = obj_new('idlitdata',value,identifier=new_var[_ii])
             self->add,datObj
             ;dummyVoidETC  = routine_names(new_var[_ii], value, store = main_level)
           endif
      endfor;_ii
    endif;n_before ne n_after
;  
;  ; are there any of the same variables in the $MAIN$ level and in the
;  ; current level?  If so then replace $MAIN$ level variables with
;  ; those from the current level.                                  ;<------ INSTEAD I WANT TO UPDATE THE VALUES IN self


;       new_main = routine_names(variables = main_level)   
       ids = self->getIdentifiers()
       new_main = ids
       new_current = routine_names(variables = this_level)
;
;
    counter = 0L
    for _ii = 0,n_elements(new_main)-1 do begin
      whereok = where(new_current eq new_main[_ii],count)
      if count ne 0 then begin
        if counter eq 0L then new_var = new_current[whereok[0]] else $
          new_var = [new_var,new_current[whereok[0]]]
        counter = counter+1L
      endif
    endfor;_ii
    for _ii = 0,counter-1 do begin
  ; get the value from this level
         if n_elements(routine_names(new_var[_ii],fetch = this_level)) gt 0 then begin
           value  = routine_names(new_var[_ii], fetch=this_level)
;           ; put the value and variable name into the $MAIN$ level
            dum = self->setData(value,new_var[_ii])      ;<------- DOES THIS GET THE PARMS IF THEIR VALUES ARE RESET?
         endif
    endfor;_ii
endfor;_i
;

return,1
end;the_one_and_only_pan_macrofunction_object::pan_do_the_macro




function the_one_and_only_pan_macrofunction_object::pan_macrofunction,x,parms,Qgroup=Qgroup, $
                                                                      parmnames = parmnames,  $
                                                                      canDraw = canDraw,     $
                                                                      resptr=resptr,$;LRK 01/29/09
                                                                      eval = eval,      $
                                                                      _Extra = extra


;NOW PAN_MACROFUNCTION WILL GET THIS OBJECT AND CALL THIS FUNCTION WITH ITS ARGUMENTS, AND THAT SHOULD BE ALL THERE IS TO IT.

;NOTE: IF THERE IS NO resptr, Qgroup, ETC, THEN MAKE SURE THEY ARE NOT RETRIEVED FROM THE on_and_only OBJECT FOR
;      EXECUTION/CALCULATION

      release = 6.1
      fit_fun = extra.fit_fun_filename
      
      
      
     this_level = routine_names(/level) ;else $
      main_level = 1
      
      
      ; First determine if the call is for the parameter names only...
      if (n_params() eq 0) or (n_elements(x) eq 0) then begin
            
            ;HOW ABOUT WE REPLACE ALL THIS WITH AN IDLitDataContainer????
;              print,'pan_macrofunction---n_params eq 0'
              str = ''
              openr,lun,fit_fun,/get_lun
              readf,lun,str
              free_lun,lun,/force
          
          
          
             ;pan_do_the_macro RUNS THE MACRO VIA EXECUTE, CREATING THE parmnames VARIABLE AT THE MAIN LEVEL.
             ret = self->pan_do_the_macro(str[0]) ;--> THIS SHOULD STORE parmnames IN self
             ret = self->getData(parmnames,'PARMNAMES')   
            
               return,0
      endif
      
      ; Send the x and parms values to the main level
      ; 
      ; LRK - 07/23/09
      ; NO!!!!! STICK THEM INTO THE x AND parm DATA OBJECTS IN THIS CONTAINER.
      ; SO WE SHOULD PUT x,qgroup,resptr AND parms INTO THE DATACONTAINER.
      ; 

;FIRST CHECK TO SEE IF x,parms,resptr,qgroup EXIST IN self. 
         value  = routine_names('x', fetch = this_level) ; get x from this level
         dum = self->setData(value,'x')

         value = routine_names('parms',fetch = this_level)
         dum = self->setData(double(value),'parms')
         
         
        ;NOW DO THE SAME THING FOR Q VALUES, WHICH NEED TO BE PASSED INTO THIS ROUTINE.
          ;SET UP Q AS A SCALAR.
          ;THIS IS CALLED ONLY ONCE.  Qgroup MUST BE PULLED FROM THE CURVES ELSEWHERE.
          if n_elements(QGroup) ne 0 then begin;eq 1 then begin
      
              value  = routine_names('Qgroup', fetch = this_level) ; get qgroup from this level
              dum = self->setData(value,'Qgroup')
          endif

      
      ; Read in the macro
      counter = 0L
      str = ''
      openr,lun,fit_fun,/get_lun
      while not(eof(lun)) do begin
         readf,lun,str
         if counter eq 0L then macro_text = str else $
           macro_text = [macro_text,str]
         counter = counter+1L
      endwhile
      free_lun,lun,/force
      
                                                 ;????????????????????????????????????????????????????????????????????????????
       dum = self->getData(resptr,'resptr')      ;<-------- WHEN IS resptr SET?  WILL THERE BE A MEMORY LEAK ALONG THE WAY
                                                 ;          IF I DON'T CLEAR THIS FROM THE OBJECT?
                                                 ;          WILL I HARM THE EXISTING resptr BY STUFFING IT INTO self?
                                                 ;
                                                 ;????????????????????????????????????????????????????????????????????????????


      
      ; Now execute the macro
      ret = self->pan_do_the_macro(macro_text,QGroup=QGroup)    ;<----- WHY NOT PASS THE OTHER VALUES INTO THE DATA SE
      eval = 1
      if ret eq 0 then begin
         eval = 0
         return,ret
      endif

      
       dum = self->getData(ymodel,'ymodel')      

       dum = self->getData(delta_params,'delta_params')      

       dum = self->getData(parmnames,'parmnames')      

      canDraw = 0

      ; If resolution function is present then perform the convolution here
      if n_elements(resptr) ne 0 and ptr_valid(resptr) gt 0 then begin  ;LRK 01/27/09
         if n_elements(ymodel) ne 0 then begin
            yout = pan_convolute(x,resPtr,ymodel,pseudo_delta = delta_params)
         endif else begin
            yout = pan_convolute(x,resPtr,pseudo_delta = delta_params)
         endelse
      endif else begin
         yout = 0
         if (n_elements(pseudo_delta) ne 0) and (n_elements(ymodel) eq 0) then begin
           yout = 0
         endif
         if (n_elements(ymodel) ne 0) then begin
           yout = ymodel
         endif
      endelse

return,yout
end;the_one_and_only_pan_macrofunction_object::pan_macrofunction
function the_one_and_only_pan_macrofunction_object::setParms,fitfun
  
;      fit_fun = extra.fit_fun_filename
;      ; First determine if the call is for the parameter names only...
;      if n_params() eq 0 then begin
;
;      print,'pan_macrofunction---n_params eq 0'
;      str = ''
;      openr,lun,fit_fun,/get_lun
;      readf,lun,str
;      free_lun,lun,/force
;      ret = pan_do_the_macro(str[0])
      parmnames = ['Q','radius','L_hwhm1','center','bgoffset','bgslope','area','L_hwhm2']
      
      
      ;HOW ABOUT WE REPLACE ALL THIS WITH AN IDLitDataContainer????
      

  n = self->count()
  names = self->getIdentifiers(/leaf);'NAMES'
  
  if n gt 0 then begin
    print,'THERE ARE PARAMETERS.'
  endif;n
  return,1
end;the_one_and_only_pan_macrofunction_object::cleanup,_extra=extra

function the_one_and_only_pan_macrofunction_object::getParmNames,parmnames
  
  dum = self->getData(parmnames,'parmnames') 

  if dum gt 0 then begin
    print,'THERE MAY BE PARAMETER NAMES.'
    help,parmnames
    print,'parmnames=',parmnames
  endif;dum

  return,1
end;the_one_and_only_pan_macrofunction_object::cleanup,_extra=extra

function the_one_and_only_pan_macrofunction_object::getParms,parms


  dum = self->getData(parms,'parms') 
  if dum gt 0 then begin
    print,'THERE MAY BE PARAMETERS.'
    help,parms
    print,'parms=',parms
  endif;dum
  
  return,1
end; the_one_and_only_pan_macrofunction_object::getParms


function the_one_and_only_pan_macrofunction_object::cleanup,_extra=extra
  self->idliddatacontainer::cleanup,_Extra=extra
end;the_one_and_only_pan_macrofunction_object::cleanup,_extra=extra

function the_one_and_only_pan_macrofunction_object::init,_extra=extra
  
  ;CREATE GENERALLY NEEDED DATA OBJECTS WITH SOME RANDOM DATA THAT WILL BE REPLACED AT RUNTIME.
  x = obj_new('idlitdata',dindgen(101),identifier='x')
  resptr = obj_new('idlitdata',ptr_new(/allocate),identifier='resptr')
  qgroup = obj_new('idlitdata',0.0d,identifier='qgroup')
  parms = obj_new('idlitdata',dindgen(10),identifier='parms')
  parmnames = obj_new('idlitdata',strarr(10),identifier='parmnames')

  
  
  ret = self->idlitdatacontainer::init(_Extra=extra)

  self->add,x
  self->add,resptr
  self->add,qgroup
  self->add,parms
  self->add,parmnames

  return,1
end;function the_one_and_only_pan_macrofunction_object::init



pro the_one_and_only_pan_macrofunction_object__define,class

  class = {the_one_and_only_pan_macrofunction_object,$
            inherits IDLitDataContainer, $
              hasdata:0, $
              hasparmnames:0, $
              hasparmvalues:0 $
            }

end;the_one_and_only_pan_macrofunction_object__define


pro test_the_one_and_only_pan_macrofunction_object

      fn = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS\crs_combine\Data\Mike\comon.mf'
      fn = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS\crs_combine\Data\Mike\comon2.mf'
      fn = 'C:\Users\kneller\Desktop\Data\HFBS\test7.mf'
      fit_fun_filename=fn
      this_level = routine_names(/level)
      print,'this_level=',this_level
      main_level = 1
      print,'main_level=',main_level


;________________________________________________________________________________________________________
;
;PUT THIS NEXT BLOCK OF CODE INTO PAN SOMEWHERE SO IT CAN INITIALIZE THE OBJECT AND KEEP TRACK OF IT.
;
;PAN WILL HAVE TO PUT IT AT THE MAIN LEVEL, AND pan_macrofunction WILL HAVE TO RETRIEVE IT AS NEEDED
;
;PUT INTO PAN:
      the_one_and_only_pan_macrofunction_object = obj_new('the_one_and_only_pan_macrofunction_object')

      ;if n_elements(routine_names('the_one_and_only_pan_macrofunction_object',fetch = main_level)) ne 0 then begin

      ;IF THIS WORKS, WE'LL HAVE TO DO THIS IN PAN AT STARTUP SO THAT pan_macrofunction CAN GET DATA FROM IT'S OWN SECURE SPACE
      value  = routine_names('the_one_and_only_pan_macrofunction_object', fetch = this_level)
      print,'#obj=',checkforobjinstance('the_one_and_only_pan_macrofunction_object')
      dummyVoidETC  = routine_names('the_one_and_only_pan_macrofunction_object', value, store = main_level)
      print,'#obj=',checkforobjinstance('the_one_and_only_pan_macrofunction_object')

;PUT INTO PAN_MACROFUNCTION
      obj = routine_names('the_one_and_only_pan_macrofunction_object', fetch = main_level)
      print,'#obj=',checkforobjinstance('the_one_and_only_pan_macrofunction_object')
;________________________________________________________________________________________________________
      help,obj
      help,the_one_and_only_pan_macrofunction_object
      print,obj->getParmNames(names)
help,names
      print,obj->getParms(parms)
help,parms
      macro_lines = obj->testScript()
      x = findgen(100)
      
      parmnames = ['radius','L_hwhm1','center','bgoffset','bgslope','area','L_hwhm2']
      parms = fltarr(n_elements(parmnames))
      duh = obj->setdata(parms,'parms')
      duh = obj->setdata(parmnames,'parmnames')
      dum = obj->pan_macrofunction(x,parms,Qgroup=Qgroup,parmnames = parmnames,fit_fun_filename=fn)
      ;print,obj->pan_do_the_macro(macro_lines,qgroup=1.0)      

      obj_destroy,obj;the_one_and_only_pan_macrofunction_object

end;test_the_one_and_only_pan_macrofunction_object
