; $Id$
;###############################################################################
;
; NAME:
;  OPAN__DEFINE
;
; PURPOSE:
;  Object implementation of the analysis program called PAN
;  (Peak ANalysis).
;
; CATEGORY:
;  DAVE, Data Analysis, objects, widgets, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################

pro opan::extractPanMask,davestr,pan_mask,resolution=resolution

    if n_elements(resolution) eq 0 then resolution = 0
    if n_elements(davestr) eq 0 then begin

        if ptr_valid(self.daveptr) gt 0 then begin
            davestr = *self.daveptr
        endif else begin
            bitmask = byte(0*(*self.dataPtr) + 1)
            pan_mask = bitmask
            if ptr_valid(self.maskPtr) then ptr_free,self.maskPtr
            self.maskPtr = ptr_new(bitmask)

            return
        endelse
    endif;n_elements(davestr) eq 0

;THIS SEEMS LIKE A BUG WAITING TO HAPPEN. WHAT IF QTY IS 1d???????????????????????????????
;    nc = (size(((*(((*(davestr).datastrptr).commonstr).histptr)).qty)))[1]
;    nr = (size(((*(((*(davestr).datastrptr).commonstr).histptr)).qty)))[2]

    szqty = (size(((*(((*(davestr).datastrptr).commonstr).histptr)).qty)))
    if szqty[0] eq 1 then begin
      nc = szqty[1]
      nr = 1
    endif else begin
      nc = szqty[1]
      nr = szqty[2]
    endelse


    if ptr_valid((*(davestr.datastrptr)).specificptr) eq 0 then begin

            ;NO SPECIFICSTR, CREATE A MASK
            bitmask = bytarr(nc,nr) + 1b
            pan_mask = bitmask

    endif else begin


            ;VALID SPECIFIC STRUCTURE, ATTEMPT TO EXTRACT MASK IF AVAILABLE.
            ;IF NOT AVAILABLE THEN CREATE A MASK

            ;NOW WHAT HAPPENS IF specificPtr IS A VALID POINTER BUT IT POINTS TO AN
            ;UNDEFINED VALUE?  USE HELP:
            help,(*(*(davestr).datastrptr).specificptr),output=out,struct=0

            undefinedflag = 0
            for i=0,n_elements(out)-1 do begin
                if stregex(strupcase(out[i]),'UNDEFINED',/boolean) ne 0 then undefinedflag = 1
            endfor;i

            if undefinedflag eq 1 then begin
                ;SPECIFIC POINTER IS VALID BUT POINTS TO NOTHING.
                bitmask = bytarr(nc,nr) + 1b
                pan_mask = bitmask
            endif else begin

                sp_tag_names = tag_names((*(*(davestr).datastrptr).specificptr))
                if n_elements(sp_tag_names) gt 0 then begin
                    wh = where(strupcase(sp_tag_names) eq 'PAN_MASK',count)
                    if count gt 0 then begin

                            ;063008
                            ;ADD THE NEXT CHECK IN CASE THE PAN_MASK FIELD EXISTS BUT IS A NULL POINTER
                            if ptr_valid((*(*(davestr).datastrptr).specificptr).pan_mask) eq 0 then begin
                              maskundefinedflag = 1
                            endif else begin
                              help,(*(*(*(davestr).datastrptr).specificptr).pan_mask),output=out,struct=0
                              maskundefinedflag = 0
                              for i=0,n_elements(out)-1 do begin
                                  if stregex(strupcase(out[i]),'UNDEFINED',/boolean) ne 0 then maskundefinedflag = 1
                              endfor;i
                            endelse

                            if maskundefinedflag eq 0 then begin

;063008
;SHOULD I PUT SOMETHING INTO THE DAVE_PTR MASK FIELD NOW??????
;WOULD IT AFFECT ANYTHING???
                                ;WHEN IT IS HERE THERE IS NO CRASH.
                                bytemask = (*(*(*(davestr).datastrptr).specificptr).pan_mask)

                                bitmask = bytes2bits(bytemask,nc,nr)
                            endif else begin
                                bitmask = bytarr(nc,nr) + 1b
                            endelse


                    endif else begin

                        ;IF MASK EXISTS IN SPECIFIC POINTER, BUT THE PAN_MASK DOES NOT, WE GET HERE.
                        wh = where(strupcase(sp_tag_names) eq 'MASK',count)
                        if count gt 0 then begin
                                help,(*(*(*(davestr).datastrptr).specificptr).mask),output=out,struct=0
                                maskundefinedflag = 0
                                for i=0,n_elements(out)-1 do begin
                                    if stregex(strupcase(out[i]),'UNDEFINED',/boolean) ne 0 then maskundefinedflag = 1
                                endfor;i
                                if maskundefinedflag eq 0 then begin
                                    bytemask = (*(*(*(davestr).datastrptr).specificptr).mask)
                                    bitmask = bytes2bits(bytemask,nc,nr)
                                endif else begin
                                    bitmask = bytarr(nc,nr) + 1b
                                endelse
                        endif else begin
                            ;NO MASK, NO PAN_MASK, BUT SPECIFIC POINTER IS AVAILABLE AND VALID.
                            bitmask = bytarr(nc,nr) + 1b
                        endelse
                    endelse
                endif else begin
                        bitmask = bytarr(nc,nr) + 1b
                endelse
                pan_mask = bitmask
            endelse
    endelse

    if resolution eq 0 then begin
      if ptr_valid(self.maskPtr) then ptr_free,self.maskPtr
      self.maskPtr = ptr_new(bitmask)
    endif

end;opan::extractPanMask
pro opan::retrievePanMask,panMask

        ;LRK 101708
        if n_elements(*self.dataPtr) eq 0 then return

        if ptr_valid(self.maskPtr) eq 0 then begin
            panmask = byte(0*(*self.dataPtr) + 1)
        endif else begin
            help,*self.maskPtr,output=maskoutput,struct=0

            maskundefinedflag = 0
            for i=0,n_elements(maskoutput)-1 do begin
                if stregex(strupcase(maskoutput[i]),'UNDEFINED',/boolean) ne 0 then maskundefinedflag = 1
            endfor;i

            if maskundefinedflag eq 0 then begin
                    panmask = *self.maskPtr
            endif else begin;maskundefinedflag eq 0

                    panmask = byte(0*(*self.dataPtr)) + 1b
            endelse

        endelse


end;opan::retrievePanMask
pro opan::clearOneRes_Ptr

;NEED UNDERSCORE IN NAME BECAUSE PAN AND MAYBE OTHER ROUTINES
;LOOK GLOBALLY FOR THINGS WITH "ResPtr" IN THEIR NAMES!!!!!!!!!
;
;THIS IS ESPECIALLY A PROBLEM WITH USER DEFINED FUNCTIONS WITH NO
;RESOLUTION WHICH FIND A ROUTINE WITH resPtr IN THE NAME AND THINK
;THEY HAVE A RESOUTION FILE WHICH TURNS OUT TO BE UNAVAILABLE!!!!! 

    ;020708
    ;EMPTY THE CONTENTS OF self.oneResPtr
    ;THIS IS ESPECIALLY USEFUL WHEN ALL THE POINTS IN THE RES DATA 
    ;ARE MASKED FOR THE CURRENT GROUP.
    if ptr_valid(self.oneResPtr) ne 0 then begin
        ptr_free,self.oneResPtr
        self.oneResPtr = ptr_new(/allocate_heap)
    endif
end;opan::clearOneRes_ptr

function opan::extractOneResStr,val,OneResStr,contentsMasked=contentsMasked,resSize=resSize
;GET oneResStr AND RETURN IT VIA THE ARGUMENT
;
;IF NO resStr FOR val THEN LEAVE IT EMPTY SO THAT CALLING ROUTINE CAN TEST
;FOR n_elements(OneResStr) eq 0
;
;
;NOTE:   y VARIABLE SHOULD NOT NEED MASKING!!!
;        PROBABLY ONLY y[val] SHOULD BE PASSED, BUT SELECTING THAT
;        COULD BE PROBLEMATIC IF THE y VARIABLE IS 2d FOR SOME REASON.
;
;        IN ALL CASES IN PAN IT APPEARS THAT THE y ARRAY IS PASSED IN ITS ENTIRETY, SO CONTINUE TO DO SO.
;
;RETURN 1 IF THERE IS res DATA AND 0 IF THERE IS NOT.

contentsMasked = 0

if (N_elements(*self.resptr) eq 0) then begin
  OneResStr = {x:[0.,1.],$
    y:[-1.],$
    data:[0.,0.],$
    rlimit:[0.,0.], $
    xdat_equals_xres:0}
  Return,0
endif

resStr = (*self.resPtr)
if (Self.twodimflag) then begin
  ; if we are currently using a 2D function then simply return a 
  ; copy of the current resStr. 
  ; NOTE: masking is not taken into account
  oneResStr = resStr
  return, 1
endif


resSize = Size((*self.resptr).data)

if n_elements(val) eq 0 then val = 0
tags = tag_names(resStr)
whmask = where(stregex(tags,'MASK',/boolean,/fold_case) eq 1)

resSize = size((*self.resPtr).data)

if whmask ne -1 then begin
  if resSize[0] eq 2 then begin 
    mask = (*self.resptr).mask[*,val]
    whnotmasked = where(mask ne 0,notmaskcount)
  endif else begin
    mask = (*self.resptr).mask
    whnotmasked = where(mask ne 0,notmaskcount)
  endelse
  if n_elements(mask) gt notmaskcount then contentsMasked = 1
  if notMaskCount eq 0 then begin
    contentsMasked = 1
    OneResStr = {x:[0.,1.],$
                 y:[-1.],$
                 data:[0.,0.],$
                 rlimit:[0.,0.], $
                 xDat_equals_xRes:0}
    return,0
  endif else begin
    if resSize[0] eq 2 then begin
      xOneRes = (*self.resPtr).x[whnotmasked]
      yOneRes = (*self.resPtr).y;[whnotmasked]
      dataOneRes = reform((*self.resPtr).data[whnotmasked,val])
    endif else begin
      xOneRes = (*self.resPtr).x[whnotmasked]
      yOneRes = (*self.resPtr).y;[whnotmasked]
      dataOneRes = reform((*self.resPtr).data[whnotmasked])
    endelse
    rlimitOneRes = (*self.resPtr).rlimit
    OneResStr = {x:xOneRes,$
                 y:yOneRes,$
                 data:dataOneRes,$
                 rlimit:rlimitOneRes, $
                 xDat_equals_xRes:(*Self.resPtr).xDat_equals_xRes}
    return,1
  endelse
endif else begin
  ;print,'opan::extractOneResStr NO MASK, SO SET ALL OF THE DATA IN THE ONE RES STR!!!!'          
  contentsMasked = 0
  if resSize[0] eq 2 then begin
    xOneRes = (*self.resPtr).x
    yOneRes = (*self.resPtr).y
    dataOneRes = reform((*self.resPtr).data[*,val]) 
  endif else begin
    xOneRes = (*self.resPtr).x
    yOneRes = (*self.resPtr).y
    dataOneRes = reform((*self.resPtr).data)
  endelse
  rlimitOneRes = (*self.resPtr).rlimit
  OneResStr = {x:xOneRes,$
               y:yOneRes,$
               data:dataOneRes,$
               rlimit:rlimitOneRes, $
               xDat_equals_xRes:(*Self.resPtr).xDat_equals_xRes}
  return,1
endelse

end;opan::extractOneResStr


function opan::checkDataMasked

  self->retrievePanMask,panMask
  npts = n_elements(panMask)

  ;LRK 101708
  if npts gt 0 then begin
    wh = where(panMask eq 1,count)
    if count eq npts then ret = 0 else ret = 1 
  endif else begin
    ret = 0 ;NO DATA SO NO DATA MASKED, CONSISTENT WITH opan::checkResMasked
  endelse
  return,ret
end;opan::checkDataMasked

function opan::checkResMasked

    ;TELL CALLER WHETHER THERE ARE MASKED POINTS IN THE RESOLUTION STRUCTURE.
    if n_elements(*self.resPtr) ne 0 then begin
              resStr = (*self.resPtr)
              resSize = size(resStr.data)
              nMasked = 0
              if resSize[0] eq 1 then begin
                dum = self->extractOneResStr(0,OneResStr,contentsMasked=contentsMasked)
                nmasked += contentsMasked
              endif else begin
                for i=0,resSize[2]-1 do begin
                  dum = self->extractOneResStr(i,OneResStr,contentsMasked=contentsMasked)
                  ;print,contentsMasked
                  nmasked += contentsMasked
                endfor;i
              endelse
              return,nMasked
    endif else begin
      return,0
    endelse
              
end;opan::checkResMasked


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::extractDataForPAN,dat=dat,derr=derr,x=x,y=y,erry=erry,val=val,dSize=dSize,$
                            allData=allData,allx=allx,ally=ally,panmask=panmask,group=group,$
                            allError=allError,nodata=nodata, qvals=qvals, fitFlag=fitFlag, $
                            _Extra=extra


;101708
;CHECK FOR DATA
datSize = size(*self.dataPtr)
if datsize[0] eq 0 then begin
  nodata = 1
  return 
endif else nodata = 0

;if (Self.twodimflag && n_elements(fitFlag) eq 1) then begin
;  ; retrieve data for all groups
;  
;endif


;GETS DATA FOR THE CURRENT DATA GROUP.
if n_elements(group) eq 0 then begin
  widget_control,self.groupSlider,get_value = val
  val = fix(val[0])-1
  dSize = size(*self.dataPtr)
  if dSize[0] eq 1 then begin
    dat = reform(*self.dataPtr)
    derr = reform(*self.errorPtr)
    allx = reform(*self.xvalsPtr)
    ally = reform(*self.yvalsPtr)
    y = (*self.yvalsPtr)
    erry = reform(*self.errorPtr)
    alldata = reform(*self.dataPtr)          
    allError = reform(*self.errorPtr)
    self->retrievePanMask,panMask
    whnotmasked = where(panmask eq 1,npts)
    if npts gt 0 then begin
      dat = dat[whnotmasked]
      derr = derr[whnotmasked]
      x = allx[whnotmasked]
      y = y[whnotmasked]
      erry = erry[whnotmasked]
    endif
    val = 0
  endif else begin
    if n_elements(group) ne 0 then begin
      val = group[0]-1 > 0
    endif else begin
      widget_control,self.groupSlider,get_value = val
      val = fix(val[0])-1
    endelse
    dat = reform((*self.dataPtr)[*,val])
    derr = reform((*self.errorPtr)[*,val])
    allx = reform((*self.xvalsPtr)[*,val])
    ally = reform((*self.yvalsPtr)[0,*])
    y = reform((*self.yvalsPtr)[*,val])
    erry = reform((*self.errorPtr)[*,val])
    alldata = reform(*self.dataPtr)
    allError  = reform(*self.errorPtr)
    self->retrievePanMask,panMask
    whnotmasked = where(panmask[*,val] eq 1,npts)
    if npts gt 0 then begin
      dat = dat[whnotmasked]
      derr = derr[whnotmasked]
      x = allx[whnotmasked]
      y = y[whnotmasked]
      erry = erry[whnotmasked]
    endif
  endelse
  datSize = size(*self.dataPtr)
  if datSize[0] eq 1 then val = 0
  xrange = self.xrange

  ;APPLY THE MASK BELOW WHEN READY

  ;020408
  ;UNCOMMENTING THE NEXT BLOCK AND WORKING WITH THE MASK!
  ;WORK WITH THE MASK IN THE SAME MANNER AS WITH THE DATA
  ;FOR  opan::rebinRes APPLY A WARNING MESSAGE TO MASKED DATA
  ;SO THE USER CAN DECIDE IF THE REBINNING IS APPROPRIATE.
  ;PERHAPS THE TEST WOULD BE:  IF ALL MASK VALUES ARE (0 or 1???)THEN ALLOW REBIN
  ;                            IF NOT THEN SAY REBIN WILL CAUSE PROBLEMS  
  ;
  
  ;#################################################################################################
  ;RESOLUTION DATA:
  ; If resolution is loaded then check if nos of groups is the same for
  ; resolution and signal datasets
  if (n_elements(*self.resPtr) gt 0) then begin
    dSize = size(*self.dataPtr)
    nd = (dSize[0] eq 2)? dSize[2] : 1
    rSize = size((*self.resPtr).data)
    nr = (rSize[0] eq 2)? rSize[2] : 1
    if (nr ne nd) then begin
      msg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Consider changing the signal OR the resolution data' $
             ,'Fits will not be performed!' ]
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,msg,/error)
      return                    ; exit
    endif
    ;;    
    ;;    ;THIS EXTRACTION OF RESOLUTION DATA WILL ALSO NEED TO ACCOUNT FOR MASKING.
    ;;    ;RESOLUTION MASK IS SEPARATE FROM THE PAN MASK, SO IT MUST BE STORED
    ;;    ;SEPARATELY WHEN RESOLUTION DATA ARE READ IN.
    ;;    ;
    ;;    ;THE OTHER ASPECT TO THIS IS THAT THE DATA USED WITH
    ;;    ;RESOLUTION CALCULATIONS MUST EXTRACT THE DATA FOR EACH GROUP
    ;;    ;AND CONSIDER ITS MASK, THEREFORE I WILL PROBABLY HAVE TO WRITE 
    ;;    ;A METHOD TO EXTRACT RESOLUTION DATA FROM self.resPtr EACH TIME THE 
    ;;    ;oneResPtr IS FORMED.
    resExists = self->extractOneResStr(val,OneResStr)
    if resExists ne 0 then begin
      (*self.oneResPtr) = OneResStr
    endif else begin
      self->clearOneRes_ptr
    endelse
  endif;(n_elements(*self.resPtr) gt 0)
  ;#################################################################################################
endif else begin
  ;n_elements(group) ne 0
  val = group-1
  dSize = size(*self.dataPtr)
  if ptr_valid(self.maskPtr) eq 0 then begin
    panmask = byte(0*(*self.dataPtr) + 1)
  endif else begin
    panmask = *self.maskPtr
  endelse
  if dSize[0] eq 1 then begin
    dat = reform(*self.dataPtr)
    derr = reform(*self.errorPtr)
    allx = reform(*self.xvalsPtr)
    ally = reform(*self.yvalsPtr)
    y = (*self.yvalsPtr)
    erry = (*self.errorPtr)[*,val]
    alldata = reform(*self.dataPtr)
    allError  = reform(*self.errorPtr)
    whnotmasked = where(panmask eq 1,npts)
    if npts gt 0 then begin
        dat = dat[whnotmasked]
        derr = derr[whnotmasked]
        x = allx[whnotmasked]
        y = y[whnotmasked]
        erry = erry[whnotmasked]
    endif
    val = 0
  endif else begin
    dat = reform((*self.dataPtr)[*,val])
    derr = reform((*self.errorPtr)[*,val])
    allx = reform((*self.xvalsPtr)[*,val])
    ally = reform((*self.yvalsPtr)[0,*])
    y = reform((*self.yvalsPtr)[*,val])
    erry = reform(*self.errorPtr)
    alldata = reform(*self.dataPtr)
    allError  = reform(*self.errorPtr)
    whnotmasked = where(panmask[*,val] eq 1,npts)
    if npts gt 0 then begin
        dat = dat[whnotmasked]
        derr = derr[whnotmasked]
        x = allx[whnotmasked]
        y = y[whnotmasked]
        erry = erry[whnotmasked]
    endif
  endelse
  datSize = size(*self.dataPtr)
  if datSize[0] eq 1 then val = 0
  xrange = self.xrange

  ;APPLY THE MASK BELOW WHEN READY

  ;020408
  ;UNCOMMENTING THE NEXT BLOCK AND WORKING WITH THE MASK!
  ;WORK WITH THE MASK IN THE SAME MANNER AS WITH THE DATA
  ;FOR  opan::rebinRes APPLY A WARNING MESSAGE TO MASKED DATA
  ;SO THE USER CAN DECIDE IF THE REBINNING IS APPROPRIATE.
  ;PERHAPS THE TEST WOULD BE:  IF ALL MASK VALUES ARE (0 or 1???)THEN ALLOW REBIN
  ;                            IF NOT THEN SAY REBIN WILL CAUSE PROBLEMS  
  ;
  ;
  ;;;;;
  ;;;;;;#################################################################################################
  ;RESOLUTION DATA:
  ; If resolution is loaded then check if nos of groups is the same for
  ; resolution and signal datasets
  if (n_elements(*self.resPtr) gt 0) then begin
    dSize = size(*self.dataPtr)
    nd = (dSize[0] eq 2)? dSize[2] : 1
    rSize = size((*self.resPtr).data)
    nr = (rSize[0] eq 2)? rSize[2] : 1
    if (nr ne nd) then begin
      msg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Consider changing the signal OR the resolution data' $
             ,'Fits will not be performed!' ]
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,msg,/error)
      return                    ; exit
    endif
  ;endif
  ;THIS EXTRACTION OF RESOLUTION DATA WILL ALSO NEED TO ACCOUNT FOR MASKING.
  ;if n_elements(*self.resPtr) gt 0 then begin
    resExists = self->ExtractOneResStr(val,OneResStr)
    if resExists ne 0 then begin
      (*self.oneResPtr) = OneResStr
    endif else begin
      self->clearOneRes_ptr
    endelse
  endif
endelse;n_elements(group) ne 0
qvals = ally
end;opan::extractDataForPAN


pro opanCleanup,tlb
widget_control,tlb,get_uvalue = self
if obj_valid(self) then begin
  obj_destroy,self
endif
return
end


function opan::getExt,s,iext=iext,len=len,base=base
if n_elements(s) eq 0 then return,''
iext = strpos(s,'.',/reverse_search)
if (iext ne -1) and (iext-strlen(s) lt 10) then begin
    len  = strlen(s)
    ext  = strmid(s,iext+1,len-iext)
    base  = strmid(s,0,iext)
endif else begin
    ext = ''
    base=s
endelse
return,ext
end;opan::getExt


pro opan::addDotEXT,ofn,newext
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+newext
end;opan::addDotEXT


pro opan::addDotSav,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.sav'
end;opan::addDotSav


pro opan::addDotDAVE,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.dave'
end;opan::addDotSav

pro opan::addDotTXT,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.txt'
end;opan::addDotTXT


pro opan::addDotPS,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.ps'
end;opan::addDotPS

pro opan::addDotFIT,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.fit'
end;opan::addDotFIT

pro opan::addDotEPS,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.eps'
end;opan::addDotEPS


pro opan::addDotjpg,ofn
ext = self->getExt(ofn,iext=iext,len=len,base=base)
ofn = base+'.jpg'
end;opan::addDotJPG


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::aboutPAN,event = event
strout = ['PAN: Peak Analysis','Written by R.M.Dimeo, October 11, 2002',$
          'Modified extensively by Larry Kneller, et al. in years since.', $
          '','NIST Center for Neutron Research']
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
void = dialog_message(strout,/information,dialog_parent = dparent)
return
end;opan::aboutPAN


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::quit,event = event
if n_elements(*self.logStringPtr) ne 0 then begin
  self->closeHTMLFile,event = event
endif
widget_control,self.tlb,/destroy
return
end;opan::quit


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::cleanup
tvlct,*self.rPtr,*self.gPtr,*self.bPtr
self.ob_reg->remove,self
if self.reg_present eq 0 then obj_destroy,self.ob_reg
obj_destroy,self.otable
obj_destroy, Self.oEPSDE
;obj_destroy,self.macrofunctionobject
ptr_free,self.xtabPtr,self.btabPtr,self.ttabPtr,self.ytabPtr
ptr_free,self.resPtr,self.oneResPtr
ptr_free,self.tasPathPtr
ptr_free,self.rPtr,self.gPtr,self.bPtr
ptr_free,self.curvenamesPtr, self.headerPtr
ptr_free,self.davePtr,self.ktablePtr
ptr_free,self.dataPtr,self.errorPtr
ptr_free,self.xvalsPtr,self.yvalsPtr
ptr_free,self.datxPtr,self.datyPtr
ptr_free,self.resxPtr,self.resyPtr,self.color_ptr
ptr_free,self.ocurrentPtr,self.prefs
ptr_free,self.grpArrayPtr,self.goodParmPtr
ptr_free,self.notifyIdPtr,self.tasFilePtr,self.logStringPtr
ptr_free,self.oxvalsPtr,self.oyvalsPtr,self.oresPtr
ptr_free,self.odataPtr,self.oerrorPtr
if ptr_valid(self.maskPtr) then ptr_free,self.maskPtr
if ptr_valid(self.omaskPtr) then ptr_free,self.omaskPtr
wdelete,self.resPix,self.datPix
; Since we have a pointer to an array of object containers, destroy
; the object container array first, then free the pointer.
if total(obj_valid(*self.ocurveGroup) ge 1) then obj_destroy,*self.ocurveGroup
ptr_free,self.ocurveGroup
return
end;opan::cleanup


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::flashMessage_create,msg,base
; This method simply flashes a widget with a message that remains present
; until the flashMessage_destroy method is invoked.
;
; Center it.


geom = widget_info(self.tlb, /geometry)
xpos = geom.xoffset + geom.xsize/2 - 100
ypos = geom.yoffset + geom.ysize/2 - 50

base = widget_base(title='Please wait:',/row,xoffset=xpos,yoffset=ypos, $
      tlb_frame_attr = 3)
void = widget_text(base,value = msg,xsize = strlen(msg),/editable)
widget_control,base,/realize
return
end;opan::flashMessage_create


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::flashMessage_destroy,base
widget_control,base,/destroy
return
end;opan::flashMessage_destroy


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fitfunction,xlim,parms,yfit,_Extra = extra
;THIS IS A WRAPPER FOR ALL THE FITTING FUNCTIONS. THIS WAY THE SELECTED
;FIT FUNCTION CAN BE MANAGED BY the ocurvegroup  AND mpcurvefit CAN
;SIMPLY CALL fitfunction TO ACCESS ALL OF THEM!

; This is the function that can be used in curve fitting (using Markwardt's
; routines for instance).
;x = *extra.xPtr
oc = extra.oc
oc->setparms,parms
resIndex = where(tag_names(extra) eq 'RESPTR',count)
if count gt 0 then begin
  rlimit = extra.rlimit
  oc->evaluate,xlim,resPtr = extra.resPtr,yout = yout,rlimit = rlimit, _Extra = extra
endif else begin
  oc->evaluate,xlim,yout = yout,_Extra = extra
endelse
;wherevalid = where(x ge min(xlim) and x le max(xlim),newpts)
;yfit = (yout.ndim eq 1)? yout[wherevalid] : yout[wherevalid,*]

if (yout.ndim eq 2) then begin
  ; this is a 2D global fit so 
  ; - reform the data into 1D and
  ; - apply the panmask to remove masked data
  panmask = extra.panmask
  panmask = reform(panmask, n_elements(panmask), /overwrite)
  yout = Reform(yout, N_elements(yout), /overwrite)
  index = where(panmask eq 1, count)
  if (count gt 0) then yout = yout[index]
endif
yfit = yout
return
end;fitfunction


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::initCleanup, event = event
self->clearAllCurves, event=event
if n_elements(*self.dataPtr) gt 0 then begin
  if n_elements(*self.ocurveGroup) gt 0 then begin
     obj_destroy,(*self.ocurveGroup)
  endif
endif
return
end;opan::initCleanup


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::initNewDataObjects, event = event, err=err,emsg=emsg
err = 0
emsg=''
if n_elements(*self.dataPtr) eq 0 then return
datSize = size(*self.dataPtr)
if datSize[0] eq 2 then begin
  nq = (size(*self.dataPtr))[2]
  widget_control,self.groupSlider,set_slider_min = 1,set_slider_max = nq, sensitive = 1
endif else begin
  nq = 1
  widget_control,self.groupSlider,set_value = 1
  widget_control,self.groupSlider,set_slider_min = 1,set_slider_max = 2,sensitive = 0
endelse

;CREATE ONE CURVE GROUP (func_cont) PER GROUP
;
;THIS ALLOWS EACH GROUP TO DO THE FITTING WITH ITS OWN x,y,data,sdata VALUES
*self.ocurveGroup = objarr(nq)
for i = 0,nq-1 do begin
 (*self.ocurveGroup)[i] = obj_new("FUNC_CONT")
endfor
grpString = strtrim(string(1),2)+'-'+strtrim(string(nq),2)
widget_control,self.groupField,set_value = grpString

xmin = min((*self.xvalsPtr),max=xmax)
(*self.prefs).xfitlo = xmin
(*self.prefs).xfithi = xmax
if ((*self.prefs).xmin eq 0.0) then (*self.prefs).xmin = xmin
if ((*self.prefs).xmax eq 1.0) then (*self.prefs).xmax = xmax

ymin = min((*self.dataPtr),max=ymax)
if ((*self.prefs).ymin eq 0.0) then (*self.prefs).ymin = ymin
if ((*self.prefs).ymax eq 1.0) then (*self.prefs).ymax = ymax

*self.odataPtr = *self.dataPtr
if n_elements(*self.maskPtr) eq 0 then begin
    *self.omaskPtr = byte(0*(*self.dataptr)) + 1b
endif else begin
    *self.omaskPtr = *self.maskPtr
endelse
*self.oxvalsPtr = *self.xvalsPtr
*self.oyvalsPtr = *self.yvalsPtr
*self.oerrorPtr = *self.errorPtr

; If resolution is loaded, is the no. of groups the same for resolution and the dataset being loaded?
if (n_elements(*self.resPtr) gt 0) then begin
   rsize = size((*self.resPtr).data)
   nr = (rsize[0] eq 2)? rsize[2] : 1
   if (nr ne nq) then begin
      emsg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nq),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Fits cannot be performed!' $
             ,'Consider changing the signal OR the resolution data']
      err = 1
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,emsg)
   endif
endif

;UPDATE THE AUTOSCALING STATE WHEN DATA ARE LOADED.
self.autoscale = 1
return
end;opan::initNewDataObjects


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::clearAllCurves, event = event
; We can't just remove the objects from the container.  We actually have to
; free up each of the objects here...
ngroups = n_elements(*self.ocurveGroup)
if total(obj_valid(*self.ocurveGroup)) eq 0 then return
for j = 0,ngroups-1 do begin
  ncurves = (*self.ocurveGroup)[j]->count()
  if ncurves ne 0 then begin
    oall = (*self.ocurveGroup)[j]->get(/all)
    obj_destroy,oall
    (*self.ocurveGroup)[j]->remove,/all
  endif
endfor
wset,self.resPix
erase
wset,self.resVis
erase
Self.twoDimFlag = 0 ; default to 1D functions/model
self->refresh, event=event
widget_control,self.curveSlider,set_slider_max = 2
return
end;opan::clearAllCurves


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::clearCurrentCurves, event = event
; Clears the curves from those in the current slider position

widget_control,self.groupSlider,get_value = val
val = fix(val[0]) - 1
if n_elements(*self.dataPtr) eq 0 then return
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0
oc = (*self.ocurveGroup)[val]


;CHECK THAT oc IS A VALID OBJECT!!!!!
;
;IS THERE A REASON THAT THIS SHOULD BE UNDEFINED???
;YES: self.oCurveGroup IS INITIALIZED AS A POINTER BUT MAY NOT YET POINT TO AN OBJECT.
;
;NOTE ALSO THAT THE CHECK IS DONE ABOVE IN opan::clearAllGroups!!!
if obj_valid(oc) gt 0 then begin
  ncurves = oc->count()
endif else begin
  ncurves = 0
endelse
if ncurves eq 0 then return

; We can't just remove the objects from the container.  We actually have to
; free up each of the objects here...
oall = oc->get(/all)
obj_destroy,oall
oc->remove,/all
wset,self.resVis
erase
self->refresh
widget_control,self.curveSlider,set_slider_max = 2
return
end;opan::clearCurrentCurves


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan::FT_KWW_disclaimer
msg = []
;msg[0] = 'DISCLAIMER:'
;msg[1] = ''
;msg[2] = 'WARNING: This model function uses a numerical'
;msg[3] = 'Fourier Transform to treat data.'
;msg[4] = 'There are numerous sources of systematic error'
;msg[5] = 'associated with performing the Fourier Transformation'
;msg[6] = 'on data.  By clicking "YES" below you are accepting'
;msg[7] = 'complete responsibility for knowing all of the'
;msg[8] = 'pitfalls and error sources associated with this model function,'
;msg[9] = 'and you are responsible for all results that come from'
;msg[10] = 'using it to model your data.'
;msg[11] = ''
;
msg = [msg,'DISCLAIMER:']
msg = [msg,'Fourier transform of the Kohlrausch-Wlliams-Watts function in Peak Fitting']
msg = [msg,'']
msg = [msg,'WARNING: This model function uses a numerical Fourier Transform to treat data.']
msg = [msg,'There are numerous sources of systematic error associated with performing the ']
msg = [msg,'Fourier Transformation on data. Testing of this function was limited to specific ']
msg = [msg,'cases. Especially, if the energy window of the data is large compared to the ']
msg = [msg,'resolution function, the tau values are large, or the Beta values are low spurious ']
msg = [msg,'effect might be present. By clicking "YES" below you are accepting complete ']
msg = [msg,'responsibility for knowing all of the pitfalls and error sources associated with ']
msg = [msg,'this model function, and you are responsible for all results that come from using ']
msg = [msg,'it to model your data.']
msg = [msg,'']
msg = [msg,'Do you accept this disclaimer?']

title = 'FT KWW Disclaimer'
void = dialog_message(dialog_parent = self.tlb,msg,/question,  $
   title = title)
if strupcase(void) eq 'NO' then ret = 0B else ret = 1B
return,ret
end;opan::FT_KWW_disclaimer


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::selectCurve, event = event

; no need to proceed if there is no data
if N_elements(*self.dataptr) eq 0 then Return

; Here I have used an unsatisfactory solution and implemented a modal
; widget dialog for parameter entry when the preferences are set
; such that the user can input only via a dialog or the type of
; curve demands it (i.e. it cannot be drawn with two clicks of the
; mouse or it is a user function).

widget_control, event.id, get_uvalue=uvalue
func_names = uvalue.func_names
func_name = (func_names[event.value]).ToLower()
;ncurvetypes = n_elements(*self.curvenamesPtr)

;if N_elements(event) ne 0 then dparent = Event.top else dparent = 0L
dparent = (n_elements(event.top) eq 0)? 0L : event.top

; Reset or undefine certain variables that are not always defined for every function. Unfortunately
; in the case of user/macro functions these can be retrieved from the $main$ level and may be inconsistent
; with the function being defined
main_level = 1
if N_elements(routine_names('twoDimFlag', fetch = main_level)) ne 0 then begin
  dummy  = routine_names('twoDimFlag', 0, store = main_level) ; set default value to 0
endif
Self->Clearoneres_ptr
if n_elements(routine_names('resptr',fetch = main_level)) ne 0 then begin
   dummy  = routine_names('resptr', ptr_new(), store = main_level) ; If a resolution function is present at the $main$ level then void it
endif
if N_elements(routine_names('initParms',fetch = main_level)) ne 0 then begin
  dummy  = routine_names('initParms', !null, store = main_level) ; void any defns of initParms also
endif
if N_elements(routine_names('delta_params',fetch = main_level)) ne 0 then begin
  dummy  = routine_names('delta_params', !null, store = main_level) ; void any defns of initParms also
endif


;GET THE DATA FOR THE CURRENT GROUP
self->Extractdataforpan,dat=dat,derr=daterr,x=x,y=y,val=val,qvals=qvals,dSize=datSize $
                       ,allx=allx,allData=allData
xunits = Self.xunits
Qgroup = y[0]
groupNumber = val+1

;#############  USER FUNCTION  ###################
; We begin by considering a user-defined function
if (func_name.Matches('userfunction',/fold)) then begin    ;USERFUNCTION
  out = enterfunction(group_leader = event.top,directory = self.workDir)
  if out.cancel eq 1 then return

  parmStr = getparmsfromexpr(out.expr)
  help,parmStr,output = output
  test = strpos(output,'STRING')
  if test[0] eq (-1L) then return

  nparms = n_elements(parmStr)
  parms = replicate(1d,nparms)
  func_name = 'pan_userfunction'

  test = pan_userfunction(x,parms,QGroup=Qgroup, parmNames=parmNames, twoDimFlag=twoDimFlag, $
                         groupNumber=groupNumber,initParms=initParms,$
                         qvals=qvals, xunits=xunits, $
                         expr = out.expr, $
                         eval = eval)
  if eval ne 1 then begin
    msg = ['Definition of UserFunction definition is invalid.','Please check your input and try again.']
    void = dialog_message(msg,title='Invalid userfunction definition:',/information,dialog_parent=self.tlb)
    return
  endif
  if (N_elements(twodimflag) eq 0) then twodimflag = 0
  funcClassName = (twoDimFlag eq 0)? "func" : "func_2d"

  obj = obj_new(funcClassName,name = func_name, $
                xvalues = x, $
                xunits=xunits, $
                Qgroup=QGroup,$
                groupNumber=groupNumber,$
                twoDimFlag=twoDimFlag, $
                qvals=qvals, $
                expr = out.expr, $
                parms = parms,$
                resPtr = (twoDimFlag)? self.resptr : self.oneresptr, $
                xtabPtr = self.xtabPtr, $
                ytabPtr = self.ytabPtr, $
                btabPtr = self.btabPtr, $
                ttabPtr = self.ttabPtr)
  if (~obj_valid(obj)) then return
  if Ptr_valid(self.ocurrentptr) then Ptr_free, Self.ocurrentptr
  self.ocurrentptr = ptr_new(obj)
  
  modelIndex = (twoDimFlag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
  oc = (*self.ocurvegroup)[modelIndex]

  ncurves = oc->Count()
  if (nCurves gt 0) then begin
    ; model already contains a function so the model's 2D flag was previously set therefore
    ; retrieve it and make sure it matches the 2D flag of the function to be added
    model2DFlag = oc->Get2dflag()
    if (model2DFlag ne twoDimFlag) then begin
      msg = 'Cannot add this userfunction to existing model'
      msg = [msg,'because it already contains an incompartible function']
      msg = [msg,'Functions in a model must share the same dimensionality!']
      msg = [msg,'New function not created...']
      void = Dialog_message(dialog_parent = Self.tlb, msg)
      Return
    endif
  endif else begin
    Self.twoDimFlag = twoDimFlag  ; record this in the main program so we know what we are dealing with
                                  ; Assume we can't mix 1D and 2D functions so it is which are are using at all times
  endelse

  if (twoDimFlag) then begin
    oc->Add,*self.ocurrentptr
    widget_control,self.groupSlider,set_value = 1 ; temporarily set group slider to 1
    parmInfo = self->Packageparminfo()            ; so that this call targets the model for first group for 2D functions
    Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    dummy = self->Updateparminfo(parmInfoOut)
    Widget_control,self.groupslider,set_value = val+1 ; revert to prev slider value
    Widget_control,self.curveslider,set_slider_max = (ncurves > 1)
  endif else begin
    oc->Add,*self.ocurrentptr
    parmInfo = self->Packageparminfo()
    Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    dummy = self->Updateparminfo(parmInfoOut)
    Widget_control,self.curveslider,set_slider_max = (ncurves > 1)
  endelse
  void = oc->UpdateModTime()
  self->Refresh
  Return
endif else if (func_name.Matches('macrofunction',/fold)) then begin ; user macro
  ;ENTER THE MACRO DEFINITION HERE:
  workDir = self.workdir
  if (Strcmp(workDir,'')) then workDir = !home_dir
  ;out = Entermacro(group_leader = Event.top,directory = workdir,type = func_name.Matches('macrofunction2D',/fold))
  macroEditor,group_leader=event.top,workDir=workDir,output=out,/block,type=func_name.Matches('macrofunction2D',/fold)
  if out.cancel eq 1 then return
  macro = out.macro
  ;macro = *out.pexpr

  ; can't proceed id macro is empty text
  temp_macro = (n_elements(macro) gt 0)? strjoin(macro,/single) : strtrim(macro,2)
  if (temp_macro eq '') then return
  
  ;; RTA May, 2017
  ;; Makes no sense to be using macro defn from a file when it is faster to use a text array!
  ;; Use macro defn (macro variable) instead of using a temp file.
  
  ;CALL pan_macrofunction TO CREATE THE parmnames AND parms ARRAYS.
  ; Get the parameter names and generate a vector that is the same length as
  ; the parameter vector with ones in it.
  func_name = 'pan_macrofunction'
  ret = call_function(func_name,parmnames = parmnames, twoDimFlag=twoDimFlag, initParms=initParms, expr=macro,eval = eval, $
                      qvals=qvals,xvals=allx,yvals=allData,groupNumber=groupNumber, qGroup=y[0], xunits=xunits,$
                      resolutionRequiredFlag=resolutionRequiredFlag,extConvolFlag=extConvolFlag)   ; fit_fun_filename = self.macro_file

  ; Does this macro require a resolution function to be defined?
  ; set the default to no if the macro definition does not define it.
  if (~isa(resolutionRequiredFlag)) then resolutionRequiredFlag = 0   

  ; Flag the function as ether one that will require an external (to function) numerical convolution or not
  ; this information is used in Func_cont::Evaluation()
  ; By default, set to 0 if the macro definition does not define it.
  ; This is because a convolution is performed within pan_macrofunction() 
  ; so requiring an external convolution may lead to double convolution
  if (~isa(extConvolFlag)) then extConvolFlag = 0
  
  ; Does this macro define a 2D function?
  ; If the macro does not define one then assume it is a 1D function
  if (~isa(twodimflag)) then twodimflag = 0

  resdata_Notpresent = N_elements(*self.resptr) eq 0
  if (resolutionRequiredFlag && resdata_Notpresent) then begin
    msg = 'To use function: '+func_name.Toupper()
    msg = [msg,'You must load a resolution function first!']
    void = Dialog_message(dialog_parent = dparent,msg,/error)
    Return
  endif

  nparms = n_elements(parmnames)
  ;parms = (N_elements(initParms) gt 0)? initparms : Replicate(1d,nparms)
  parms = replicate(1d,nparms)  ; iitialize parms array elements to 1.0
  if (n_elements(initParms) gt 0) then begin
    ; copy any defined initial parameter values to parms array
    ; assuming that they are defined in order but without necessarily
    ; in full.
    maxp = n_elements(initParms) < n_elements(parms)
    for j = 0, maxp-1 do parms[j] = initParms[j]
  endif
  

  ;CHECK pan_macrofunction
  test = pan_macrofunction(x,parms,Qgroup=y[0],resPtr=(twoDimFlag)? self.resptr : self.oneresptr, $
                           groupNumber=groupNumber,$
                           qvals=qvals, xunits=xunits,$
                           expr = macro, $    ;fit_fun_filename = self.macro_file,$
                           eval = eval, group_leader=Self.tlb);,macroobject=self.macrofunctionobject)

  if eval ne 1 then return

  funcClassName = (twoDimFlag eq 0)? "func" : "func_2d"

  oFunc = obj_new(funcClassName,name = func_name, $
                    xvalues = x, $
                    xunits=xunits, $
                    qgroup = y[0],$
                    groupNumber = groupNumber,$
                    qvals=qvals, $
                    twoDimFlag=twoDimFlag, $
                    expr = macro, $;fit_fun_filename = self.macro_file,   $
                    parms = parms,$
                    resPtr = (twoDimFlag)? self.resptr : self.oneresptr, $
                    xtabPtr = self.xtabPtr, $
                    ytabPtr = self.ytabPtr, $
                    btabPtr = self.btabPtr, $
                    resolutionRequiredFlag = resolutionRequiredFlag, $    ; is the function defined with a built-in resolution function
                    extConvolFlag = extConvolFlag, $                    ; will external convolution be needed
                    ttabPtr = self.ttabPtr)
  if (~Obj_valid(oFunc)) then Return
  if Ptr_valid(self.ocurrentptr) then Ptr_free, Self.ocurrentptr
  self.ocurrentPtr = ptr_new(oFunc)

  modelIndex = (twoDimFlag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
  oc = (*self.ocurvegroup)[modelIndex]
  ncurves = oc->Count()
  if (nCurves gt 0) then begin
    ; model already contains a function so the model's 2D flag was previously set therefore
    ; retrieve it and make sure it matches the 2D flag of the function to be added
    model2DFlag = oc->Get2dflag()
    if (model2DFlag ne twoDimFlag) then begin
      msg = 'Cannot add macro function to existing model'
      msg = [msg,'because the model already contains an incompartible function.']
      msg = [msg,'You cannot combine 1D and 2D functions in the same model!']
      msg = [msg,'New function not created...']
      void = Dialog_message(dialog_parent = Self.tlb, msg)
      Return
    endif
  endif 

  oc->Add,*self.ocurrentptr
  Self.twodimflag = twoDimFlag  ; record this in the main program so we know what we are dealing with
                                ; Can't mix 1D and 2D functions - check is done below
  
  if (twoDimFlag) then begin
    Modifyparms2d, oFunc, group_leader = Event.top, notifyids=[Self.modify,Event.top]
    ;Widget_control,self.groupslider,set_value = 1 ; temporarily set group slider to 1
    ;parmInfo = self->Packageparminfo()            ; so that this call targets the model for first group for 2D functions
    ;Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    ;dummy = self->Updateparminfo(parmInfoOut)
    ;Widget_control,self.groupslider,set_value = val+1 ; revert to prev slider value
    ;Widget_control,self.curveslider,set_slider_max = (ncurves > 1)
  endif else begin
    parmInfo = self->Packageparminfo()
    Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    dummy = self->Updateparminfo(parmInfoOut)
    Widget_control,self.curveslider,set_slider_max = (ncurves > 1)
  endelse
  void = oc->Updatemodtime()
  self->Refresh
  Return
endif else begin
  ; Now consider any of the library of functions
  ;realname = (*self.curvenamesPtr)[event.value]
  name = func_name

;  ; certain functions require a resolution to be evaluated. Check for that and exit if resolution data is not present
;  funcs_eq_res = ['delta','qens_kohlrausch','qens','qens1_2D','Delta_SharedArea_2D','Delta_SharedCen_2D']
;  funcs_eq_res = [funcs_eq_res,'Delta_SharedAreaCen_2D','Delta_2D']
;
;  func_req_res = total(funcs_eq_res.Matches(func_name,/fold)) ge 1
;  resdata_Notpresent = n_elements(*self.resPtr) eq 0
;  if (func_req_res && resdata_Notpresent) then begin
;    msg = 'To use function: '+func_name.Toupper()
;    msg = [msg,'You must load a resolution function first!']
;    void = dialog_message(dialog_parent = dparent,msg,/error)
;    return
;  endif
  
  ; remove all spaces in function name and prepend with pan_
  func_name = strtrim('pan_'+strjoin(strsplit(func_name,/extract)),2)


  if (func_name.Matches('PAN_KOHLRAUSCH',/fold) or func_name.Matches('PAN_QENS_KOHLRAUSCH',/fold)) then begin
    step = [0.0d,0.01d,0.01d]
    ; Now load in the Kohlrausch table (only if necessary) and scale the table
    ret = self.otable->is_ktable_loaded(loaded = loaded)
    if not loaded then begin
      msg = 'Reading in lookup tables'
      self->flashMessage_create,msg,base
    endif
    ret = self.otable->get_ktable(ktable_ptr = ktable_ptr)
    if not loaded then self->flashMessage_destroy,base
    *self.ktablePtr = *ktable_ptr
    self->scaleKtable
  endif 

  ; call function to retirieve twoDimFlag property
  ret = Call_function(func_name,parmnames = parmnames, twoDimFlag=twoDimFlag, initParms=initParms, $
                      qvals=qvals,xvals=allx,yvals=allData,groupNumber=groupNumber,qgroup=y[0], $
                      wTLB = Self.tlb, resolutionRequiredFlag=resolutionRequiredFlag, xunits=xunits,$
                      extConvolFlag=extConvolFlag)   ; fit_fun_filename = self.macro_file

  ; Does this function require a resolution function to be defined?
  ; set the default to no if the function definition does not define it.
  if (~Isa(resolutionRequiredFlag)) then resolutionRequiredFlag = 0

  ; Flag the function as ether one that will require an external (to function) numerical convolution or not
  ; this information is used in Func_cont::Evaluation()
  ; By default, set to 1 if the function definition does not define it.
  if (~Isa(extConvolFlag)) then extConvolFlag = 1

  ; Is this a 2D function?
  ; If the function does not define one then assume it is 1D
  if (~Isa(twodimflag)) then twodimflag = 0

  resdata_Notpresent = N_elements(*self.resptr) eq 0
  if (resolutionRequiredFlag && resdata_Notpresent) then begin
    msg = 'To use function: '+func_name.Toupper()
    msg = [msg,'You must load a resolution function first!']
    void = Dialog_message(dialog_parent = dparent,msg,/error)
    Return
  endif

  nparms = N_elements(parmnames)
  ;parms = (N_elements(initParms) gt 0)? initparms : Replicate(1d,nparms)
  parms = replicate(1d,nparms)  ; iitialize parms array elements to 1.0
  if (n_elements(initParms) gt 0) then begin
    ; copy any defined initial parameter values to parms array
    ; assuming that they are defined in order but without necessarily
    ; in full.
    maxp = n_elements(initParms) < n_elements(parms)
    for j = 0, maxp-1 do parms[j] = initParms[j]
  endif

  if (N_elements(twodimflag) eq 0) then twodimflag = 0
  
  funcClassName = (twoDimFlag eq 0)? "func" : "func_2d"

  oFunc = Obj_new(funcClassName,name = func_name, $
    xvalues = x,$
    xunits=xunits, $
    xtabPtr = self.xtabptr, $
    ytabPtr = self.ytabptr, $
    ttabPtr = self.ttabptr, $
    btabPtr = self.btabptr, $
    datSize = datSize, $
    workDir = Self.workdir, $
    twoDimFlag = twodimflag, $
    wTLB = Self.tlb, $
    resPtr = (twoDimFlag)? self.resPtr : self.oneresptr, $
    parms = parms,$
    step = step, $
    rlimit = rlimit,$
    qvals=qvals,xvals=allx,yvals=allData,qgroup=y[0], $
    resolutionRequiredFlag = resolutionRequiredFlag, $    ; is the function defined with a built-in resolution function
    extConvolFlag = extConvolFlag, $                ; will external convolution be needed
    groupNumber=groupNumber)
  if (~Obj_valid(oFunc)) then Return

  modelIndex = (twoDimFlag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
  oc = (*self.ocurvegroup)[modelIndex]
  ncurves = oc->Count()
  if (nCurves gt 0) then begin
    ; model already contains a function so the model's 2D flag was previously set therefore
    ; retrieve it and make sure it matches the 2D flag of the function to be added
    model2DFlag = oc->Get2dflag()
    if (model2DFlag ne twoDimFlag) then begin
      msg = 'Cannot add "'+func_name+'" function to existing model'
        msg = [msg,'because the model already contains an incompartible function.']
        msg = [msg,'You cannot combine 1D and 2D functions in the same model!']
      msg = [msg,'New function not created...']
      void = Dialog_message(dialog_parent = Self.tlb, msg)
      
      ;Obj_destroy, oFunc
      Return
    endif
  endif else begin
    ; if the existing model for the current group doesn't have any curves then search for curves from
    ; the models in other groups
    nModels = n_elements((*self.ocurvegroup))
    for i=0,nModels-1 do begin
      nCurves = ((*self.ocurvegroup)[i])->Count()
      if (nCurves eq 0) then continue

      ; model already contains a function so the model's 2D flag was previously set therefore
      ; retrieve it and make sure it matches the 2D flag of the function to be added
      model2DFlag = ((*self.ocurvegroup)[i])->Get2dflag()
      if (model2DFlag ne twoDimFlag) then begin
        msg = 'Cannot add "'+func_name+'" function to existing model'
        msg = [msg,'because the model already contains an incompartible function.']
        msg = [msg,'You cannot combine 1D and 2D functions in the same model!']
        msg = [msg,'New function not created...']
        void = Dialog_message(dialog_parent = Self.tlb, msg)

        Obj_destroy, oFunc
        Return
      endif
      break
    endfor
  endelse
  
  *self.ocurrentptr = oFunc
  Self.twodimflag = twoDimFlag  ; record this in the main program so we know what we are dealing with
  ; Can't mix 1D and 2D functions - check is done below
endelse


; Now check if we are adding the AUTOGAUSSIAN or AUTOLORENTZIAN function...
; Note: autogaussian and autolorentzian are NOT 2D functions!!
if (func_name.Matches('PAN_AUTOGAUSSIAN',/fold) or func_name.Matches('PAN_AUTOLORENTZIAN',/fold)) then begin
  ; Estimate the background
  ymin = dat[sort(dat)]
  bg = (n_elements(ymin) gt 5)? mean(ymin[0:4]) : ymin[0]
  xpeaks = get_peak_pos(x,dat-bg,1,fwhm = fwhm)
  case strupcase(func_name) of
    'PAN_AUTOGAUSSIAN': begin
      sig = fwhm/2.354
      area = sqrt(2.0*!pi)*sig*(max(dat)-bg)
      parms = [area,xpeaks[0],fwhm,bg]
    end

    'PAN_AUTOLORENTZIAN': begin
      gam = 0.5*fwhm
      area = (max(dat)-bg)*!pi*gam
      parms = [area,xpeaks[0],fwhm,bg]
    end

    else:
  endcase
  ; Remove all of the function objects in the current object container
  self->clearCurrentCurves, event = event
  ;AT THIS STAGE, OC NEEDS TO BE A VALID OBJECT!!!!
  oc = (*self.ocurvegroup)[val]
  oc -> add,*self.ocurrentPtr
  void = oc->UpdateModTime()
  parmInfo = self->packageParmInfo()
  oc->setparms,parms
  ; Now use least squares to fit it
  self->fitOneGroup,event = event 
  return
endif;strupcase(name) eq 'PAN_AUTOGAUSSIAN' or strupcase(name) eq 'PAN_AUTOLORENTZIAN'then begin

; Ok...now do we initialize the curve  using a mouse or using a dialog?
initGuesses = (*self.prefs).initGuesses
*self.ocurrentptr->Getproperty,canDraw = canDraw
if ((initGuesses eq 1) || (canDraw eq 0)) then begin
  ; Use dialog input
  oc->Add,*self.ocurrentptr
  void = oc->UpdateModTime()
  if (twoDimFlag) then begin
    modifyParms2D, ofunc, group_leader = Event.top, notifyids=[Self.modify,event.top]
    
    ;Widget_control,self.groupslider,set_value = 1 ; temporarily set group slider to 1
    ;parmInfo = self->Packageparminfo()            ; so that this call targets the model for first group
    ;Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    ;dummy = self->Updateparminfo(parmInfoOut)
    ;Widget_control,self.groupslider,set_value = val+1 ; revert to prev slider value
  endif else begin
    parmInfo = self->Packageparminfo()
    Enterparminfo,parmInfo,group_leader=Event.top,notifyIds=[Event.id,Event.top],/modal,parmInfoOut=parmInfoOut
    dummy = self->Updateparminfo(parmInfoOut)
  endelse
  self->refresh
  return
endif else begin
  ; Use mouse input
  ; Note: - very unlikely that mouse input will be used for any 2D function!
  ;       - The function obj is added to the model later when it is placed graphically by the user
  self.addcurve = 1
  drawMessage = *self.ocurrentptr->Getdrawmessage()
  Widget_control,self.info,set_value = drawMessage[0:1]
  Return  
endelse

end;opan::selectCurve


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::zoomEvents, event = event

    case event.type of
    0: begin    ; button press
      ;print,'In button press case...'
         self.mouse = event.press
         if self.mouse eq 4 then begin
           self.autoscale = 1

           !x = *self.datxPtr
           !y = *self.datyPtr
           self->refresh
         endif
         if self.mouse eq 1 then begin
           self.xbox[0] = event.x           
           self.ybox[0] = event.y
           !x = *self.datxPtr
           !y = *self.datyPtr
           ;self->refresh
           ;empty
           self.autoscale = 0
           ;widget_control,self.datWin,/draw_motion_events
         endif
       end
    1: begin ; button release
      ;print,'In button release case...'
        if self.mouse eq 1 then begin
         xll = self.xbox[0] < self.xbox[1]
         yll = self.ybox[0] < self.ybox[1]
         w = abs(self.xbox[1] - self.xbox[0])
         h = abs(self.ybox[1] - self.ybox[0])
         xur = xll + w
         yur = yll + h
         !x = *self.datxPtr & !y = *self.datyPtr
         ll = convert_coord(xll,yll,/device,/to_data)
         ur = convert_coord(xur,yur,/device,/to_data)
         self.xrange = [ll[0],ur[0]]
         self.yrange = [ll[1],ur[1]]

         !x = *self.datxPtr
         !y = *self.datyPtr

         self->refresh

         self.mouse = 0B
         ;widget_control,self.datWin,draw_motion_events = 0
        endif
        if self.mouse eq 4 then begin
           self->refresh
         self.mouse = 0B
         ;widget_control,self.datWin,draw_motion_events = 0
        endif
       end
    2: begin ; mouse motion
         ;print,'In mouse motion case...'
         if self.mouse eq 1 then begin
            self.xbox[1] = event.x
            self.ybox[1] = event.y
            xc = [self.xbox[0],event.x,event.x,$
                  self.xbox[0],$
                  self.xbox[0]]
            yc = [self.ybox[0],self.ybox[0],$
                  event.y,event.y,$
                  self.ybox[0]]
         !x = *self.datxPtr & !y = *self.datyPtr
            wset,self.datVis
            device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix] ;THE datPix IMAGE IS SAVED, SO NO MODS NEEDED HERE.
            device,get_decomposed=dc
            device,decomposed=1
            plots,xc,yc,/device,color=(*self.color_ptr).green
            device, decomposed=dc
            ;print,'xc = ',xc,'yc = ',yc
            
            empty
         endif
       end
    else:
    endcase
    return
end;opan::zoomEvents
pro opan::togglePlotXLog,event=event
  state = self.plotXlog
  self.plotXlog = state eq 1 ? 0 : 1
  if self.plotXlog eq 1 then label = 'XLog: Yes' else label = 'Xlog:  No'
  widget_control,event.id,set_value=label 
  self->refresh
end;opan::togglePlotXLog
pro opan::togglePlotYLog,event=event
  state = self.plotYlog
  self.plotYlog = state eq 1 ? 0 : 1
  if self.plotYlog eq 1 then label = 'YLog: Yes' else label = 'Ylog:  No'
  widget_control,event.id,set_value=label 
  self->refresh
end;opan::togglePlotYLog
pro opan::toggleHotKeys,event=event
  state = self.hotKeys
  self.HotKeys = state eq 1 ? 0 : 1
  if self.hotKeys eq 1 then label = 'Hot Keys (b,g,l,d,D,f,F,u): On  ' else label = 'Hot Keys (b,g,l,d,D,f,F,u): Off  '
  widget_control,event.id,set_value=label 
  ;self->refresh

end;opan::toggleHotKeys
pro opan::unzoomMenu,event=event
  ;if n_elements(*self.dataptr) gt 0 then begin
  if n_elements(*self.datxPtr) gt 0 then begin
    self->zoomEvents,event = {type:0,press:4}
    self->zoomEvents,event = {type:1,press:4}
  endif
end;opan::unzoomMenu
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::drawCurveEvents, event = event
widget_control,self.groupSlider,get_value = val
val = fix(val[0])-1
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0
modelIndex = (Self.twoDimFlag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oc = (*self.ocurvegroup)[modelIndex]


xrange = self.xrange

if (self->ExtractOneResStr(val,OneResStr)) then begin
  (*self.oneresptr) = OneResStr
endif else begin
  self->Clearoneres_ptr
endelse


;LRK - 061311
device,get_decomposed=dc
device,decomposed=1

fg_color=(*self.color_ptr).black

case event.type of
  0: begin    ; button press
    self.mouse = event.press
    if self.mouse eq 1 then begin
      dcoords = convert_coord(event.x,event.y,/device,/to_data)
      if self.addcurve eq 1 then begin
        oc -> add,*self.ocurrentPtr
        void = oc->UpdateModTime()
        *self.ocurrentPtr->changefirst,dcoords[0],dcoords[1],xrange
        ;widget_control,self.datWin,/draw_motion_events
      endif
      if self.addcurve eq 2 then begin
        *self.ocurrentPtr->changesecond,dcoords[0],dcoords[1],xrange
        ;widget_control,self.datWin,/draw_motion_events
      endif
      wset,self.datVis
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
      oc->draw,overplot = 1,resPtr = self.oneResPtr,color=fg_color
    endif
  end

  1: begin ; button release
    dcoords = convert_coord(event.x,event.y,/device,/to_data)
    if self.mouse eq 1 then begin
      if self.addcurve eq 1 then begin
        *self.ocurrentPtr->changefirst,dcoords[0],dcoords[1],xrange
        ;widget_control,self.datWin,draw_motion_events = 0
        drawMessage = *self.ocurrentPtr->getDrawMessage()
        widget_control,self.info,set_value = drawMessage[2:3]
      endif
      if self.addcurve eq 2 then begin
        *self.ocurrentPtr->changesecond,dcoords[0],dcoords[1],xrange
        ;widget_control,self.datWin,draw_motion_events = 0
        widget_control,self.info,set_value = ''
      endif
    endif
    wset,self.datVis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    oc->draw,overplot = 1,resPtr = self.oneResPtr,color=fg_color  

    self.mouse = 0B
    self.addcurve = self.addcurve + 1
    if self.addcurve eq 3 then begin
      self.addcurve = 0
      wset,self.datPix
      self->displaydata
      wset,self.datVis
      device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
      ncurves = oc->count()
      widget_control,self.curveSlider,set_slider_max = (ncurves > 2)
    endif
  end

  2: begin ; mouse motion
    dcoords = convert_coord(event.x,event.y,/device,/to_data)
    if self.mouse eq 1 then begin
      if self.addcurve eq 1 then begin
        *self.ocurrentPtr->changefirst,dcoords[0],dcoords[1],xrange
      endif
      if self.addcurve eq 2 then begin
        *self.ocurrentPtr->changesecond,dcoords[0],dcoords[1],xrange
      endif
    endif
    wset,self.datVis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    oc->draw,overplot = 1,resPtr = self.oneResPtr,color=fg_color  
  end

  else:
endcase

device,decomposed=dc

    return
end;opan::drawCurveEvents


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::drawEvents, event = event

  ;print,'Draw events...'

    etype = tag_names(event,/structure_name)
    ;help,event
    case strupcase(etype) of
    'WIDGET_TRACKING':begin
      ;print,'WIDGET_TRACKING',event.enter
      if event.enter eq 1 then begin
        if self.hotkeys ne 0 then begin
          widget_control,self.datWin,/input_Focus 
        endif else begin
          widget_control,self.datWin,input_focus = 0L
        endelse 
      endif
      self.insidePlot = event.enter
    end;WIDGET_TRACKING
    'WIDGET_DRAW':begin
      
      ; Display the cursor location in th cursor text field
      curID = widget_info(event.top, find_by_uname = 'PAN_CURSOR_LOC')
      if (curID gt 0L) then begin
        curWinID = !d.window  ; too many graphics wins. Take note of current one
        wset, self.datvis     ; make sure we switch to the data visualization graphics
        ;print, 'x,y = ',event.x,event.y
        curLoc = Convert_coord(Event.x,Event.y, 0.0,/device,/to_data,/double)
        fmt1 = '(G12.3)'
        curLocTxt = 'X: '+strtrim(string(curLoc[0],format=fmt1),2)+'  Y: '+strtrim(string(curLoc[1],format=fmt1),2)
        widget_control, curID, set_value=curLocTxt
        wset, curWinID        ; revert to prev graphics
        
        ; Print,'(X : Y) = (',Strtrim(String(Event.x),2),',',Strtrim(String(Event.y),2),')'        
      endif

      if n_elements(*self.dataPtr) eq 0 then return
      
      
      !x = *self.datxPtr
      !y = *self.datyPtr
      
      ;help,event,/struct
      ;print,event.ch
      ;print,'hotkeys = ',self.hotkeys
      if self.hotkeys ne 0 then begin
            if event.ch ge 48 and event.ch le 122 then begin 
              sendvalue = -1
              if event.release eq 1 then begin
                case event.ch of 
                103:sendvalue = 5  ;g gaussian
                108:sendvalue = 6  ;l lorentzian       
                98: sendvalue = 10 ;b backbround
                100:sendvalue = 4  ;d delta
                68: sendvalue = 11 ;D Decay 
                102:begin
                  self->fitOneGroup, event = event
                  ;print,'fit group'
                  widget_control,self.datWin,/input_Focus
                  return
                end;102 f 
                70:begin
                  self->fitAllGroups, event = event
                  ;print,'Fit All'
                  widget_control,self.datWin,/input_Focus
                  return
                end;102 f
                117:begin
                  ;print,event.type
                  self->zoomEvents,event = {type:0,press:4}
                  self->zoomEvents,event = {type:1,press:4}
                end;117 u 
                else:begin
                  help,event,/struct
                  return;sendvalue=-1
                endelse
                endcase
                if sendvalue ne -1 then self->selectCurve, event = {id:self.tlb,top:self.tlb,handler:self.tlb,value:sendvalue}
              endif;release
              return
            endif;event.ch 
      endif;self.hotkeys
      case self.addcurve of
      0: begin
           ;print,'Zoom events...'
           self->zoomEvents,event = event
         end
      1: begin
           self->drawCurveEvents, event = event
           ;print,'drawcurve events1 ...'
         end
      2: begin
           self->drawCurveEvents, event = event
           ;print,'drawcurve events2 ...'
         end
      else:begin
      endelse
      endcase
    end;WIDGET_DRAW
    else:begin  
    endelse
    endcase
    return
    
end;opan::drawEvents


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::resize,event = event
    ctrlgeom = widget_info(self.ctrlbase,/geometry)
    infogeom = widget_info(self.infobase,/geometry)
    widget_control, Self.ctrlbase, get_uvalue=origTLBDim 
    xsize = event.x
    ysize = event.y

    if !version.os eq 'Win32' then begin
        xpad = 16 & ypad = 13
    endif else begin
        xpad = 18 & ypad = 47
    endelse



    if xsize lt ctrlgeom.xsize+infogeom.xsize then xsize = ctrlgeom.xsize+infogeom.xsize + 50
    if ysize lt ctrlgeom.ysize then ysize = ctrlgeom.ysize

    xsize = xsize-xpad
    ysize = ysize-ypad

    ; New data window dimensions
    newxsize = xsize-ctrlgeom.xsize-infogeom.xsize
    newysize = fix(ysize*(self.winRatio/(1.0+self.winRatio)))


    widget_control,self.datWin,draw_xsize = newxsize, $
                   draw_ysize = newysize
    wdelete,self.datPix
    window,/free,/pixmap,xsize = newxsize,ysize = newysize
    self.datPix = !d.window

    ; New residual window dimensions
    newysize = fix(ysize/(1.0+self.winRatio))

    widget_control,self.resWin,draw_xsize = newxsize, $
                   draw_ysize = newysize
    wdelete,self.resPix
    window,/free,/pixmap,xsize = newxsize,ysize = newysize
    self.resPix = !d.window

    ; Resize the fit output area
    deltay = event.y - origTLBDim[1]
    deltay = Self.origInfoYsize > (Self.origInfoYsize + deltay) 
    widget_control, Self.info, scr_ysize = deltay


    self->refresh

    return
end;opan::resize
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opanEvents,event



    ;CHECK FOR !debug IN CASE THIS WAS NOT STARTED FROM DAVE.

    ; RTA - Insert Basic error Handler
      defsysv,'!debug',exists=debugging
    if debugging eq 1 then begin
        if (n_elements(!debug) && (!debug eq 0)) then begin
            catch, catchError
            if (catchError ne 0) then begin
                ;;print, 'Error handled!'
                eTitle = 'PAN: Error encountered'
                eMsg = 'An error or unusual condition was encountered!'
                eMsg = [eMsg,'Please, report the following to the DAVE team:']
                eMsg = [eMsg,!error_state.msg]
                print,eMsg
                if n_elements(event) ne 0 then dparent = event.top else dparent = 0L                
                void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=dparent)
                catch, /cancel
                return
            endif
        endif
    endif ;else begin
;            catch, catchError
;            if (catchError ne 0) then begin
;                ;;print, 'Error handled!'
;                eTitle = 'PAN: Error encountered'
;                eMsg = 'An error or unusual condition was encountered!'
;                eMsg = [eMsg,'Please, report the following to the DAVE team:']
;                eMsg = [eMsg,!error_state.msg]
;                if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
;                void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=dparent)
;                catch, /cancel
;                return
;            endif
;    endelse

    ;if (strcmp(widget_info(event.id,/uname),'PAN_EPSDE_PS',/fold)) then begin
    ;  
    ;endif

    
;    print,'Opan_events called... :',tag_names(event,/structure_name)

    if dave_set_focus(event) then return
    if tag_names(event,/structure_name) eq 'WIDGET_BASE' then begin
      widget_control,event.top,get_uvalue = self
      self->resize,event = event
      return
    endif
    if tag_names(event,/structure_name) eq 'CORREL_EVENT' then return
    widget_control,event.id,get_uvalue = cmd
    if tag_names(event,/structure_name) eq 'CW_COLOR_BUTTON_EVENT' then begin
       ;print,cmd.method
       ;print,cmd.object
    endif
    if (strcmp(tag_names(event,/structure_name),'WIDGET_PROPSHEET',16,/fold)) then begin
      call_method,cmd.method,cmd.object,event
      return
    endif
    
;    help,event
;    print,'cmd.method=',cmd.method
    void = where((tag_names(cmd)).matches('etc',/fold),etcPresent)
    if (etcPresent) then begin
      call_method, cmd.method,cmd.object,event = event,_EXTRA=cmd.etc
    endif else begin
      call_method,cmd.method,cmd.object,event = event
    endelse
    return
end;opanEvents


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::displayFitParameters, event = event

widget_control,self.groupSlider,get_value = val
val = fix(val[0])-1
if n_elements(*self.dataPtr) eq 0 then return
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0

modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oModel = (*self.ocurvegroup)[modelIndex]
oModel->displayparms,output = output
if n_elements(output) ne 0 then begin
   widget_control,self.info,set_value = output
endif else begin
   widget_control,self.info,set_value = 'No Curves/functions available'
endelse
return

end;opan::displayFitParameters


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::displaydata,_Extra = extra,ps_out = ps_out

t0 = systime(/seconds)

; If resolution is loaded then check if nos of groups is the same for
; resolution and signal datasets
if (n_elements(*self.resPtr) gt 0) then begin
   dSize = size(*self.dataPtr)
   nd = (dSize[0] eq 2)? dSize[2] : 1
   rSize = size((*self.resPtr).data)
   nr = (rSize[0] eq 2)? rSize[2] : 1
   if (nr ne nd) then begin
      msg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Consider changing the signal OR the resolution data before proceeding' ]
      dparent = 0L
      if (n_elements(extra) gt 0 && tag_names(extra) eq 'EVENT') then dparent = extra.(0).top
      void = dialog_message(dialog_parent=dparent,msg,/error)
      return                    ; exit
   endif
endif

if n_elements(ps_out) eq 0 then ps_out = 0

if n_elements(*self.dataPtr) eq 0 then return
self->extractDataForPAN,dat=dat,derr=daterr,x=x,y=y,val=val,dsize=datSize
;NOTE:  val = group# - 1 

;LRK 102008 - ADD THE NEXT LINE TO TEST FOR PRESENCE OF X DATA
;  THIS CHECK MUST BE DONE ELSEWHERE AS WELL, BUT ERROR HANDLING CATCHES IT ANYWAY.
if n_elements(x) eq 0 then begin
  void = dialog_message('No data for group '+strtrim(string(val+1),2))
  return
endif

self.title = self.ytitle+'='+strtrim(string(y[0],format = '(f10.5)'),2)

if self.autoscale eq 1 then begin
  dx = 0.1*(max(x)-min(x))
  self.xrange = [min(x)-dx,max(x)+dx]
  dy = 0.1*(max(dat)-min(dat))
  self.yrange = [min(dat-daterr)-dy,max(dat+daterr)+dy]
endif


if (*self.prefs).xenforce eq 1 then begin
  self.xrange = [(*self.prefs).xmin,(*self.prefs).xmax]
endif
if (*self.prefs).yenforce eq 1 then begin
  self.yrange = [(*self.prefs).ymin,(*self.prefs).ymax]
endif

psym = (*self.prefs).psym

device,get_decomposed=dc
device,decomposed=1

;if ps_out then begin
;  color_1 = (*self.color_ptr).black
;  color_2 = color_1;
;  color_3 = color_1;(*self.color_ptr).sky
;  color_4 = color_1
;  color_5 = color_1
;  fg_color = color_1
;  bg_color = (*self.color_ptr).white
;endif else begin
;  color_1 = (*self.color_ptr).black
;  color_2 = (*self.color_ptr).white
;  color_3 = (*self.color_ptr).sky
;  color_4 = (*self.color_ptr).red
;  color_5 = (*self.color_ptr).blue
;  fg_color = color_1
;  bg_color = color_2
;endelse
  color_1 = (*self.color_ptr).black
  color_2 = (*self.color_ptr).white
  color_3 = (*self.color_ptr).sky
  color_4 = (*self.color_ptr).red
  color_5 = (*self.color_ptr).blue
  fg_color = color_1
  bg_color = color_2


; ** 
; First, display the data
plot,x,dat,psym=psym,$;4,$
     symsize=1.0,xtitle=self.xtitle,ytitle=self.ztitle,title=self.title,$
     subtitle=self.subtitle,$
     xrange=self.xrange,yrange=self.yrange,xstyle=1,ystyle=1,_Extra=extra,$
     color=fg_color,background=bg_color,charsize=1.25,xlog=self.plotxlog,ylog=self.plotylog
      ;    plot,x,dat,psym=4,symsize=1.5,xtitle=self.xtitle,ytitle=self.ztitle,title=self.title $
      ;         ,xrange=self.xrange,yrange=self.yrange,xstyle=1,ystyle=1,_Extra=extra $
      ;         ,color=fg_color,background=bg_color,charsize=1.25;,/nodata
          ;oplot,x,dat,psym = 4,color = color_2
errplot,x,dat-daterr,dat+daterr,width=0.0,color=fg_color

xfitLo = (*self.prefs).xfitlo
xfitHi = (*self.prefs).xfithi
xdispLo = (!x.crange)[0]
xdispHi = (!x.crange)[1]

if xfitLo gt xdispLo then $
  plots,[xfitLo,xfitLo],!y.crange,linestyle = 2,color = color_3, thick=2

if xfitHi lt xdispHi then $
  plots,[xfitHi,xfitHi],!y.crange,linestyle = 2,color = color_3, thick=2
  
modelIndex = (Self.twoDimFlag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oModel = (*self.ocurvegroup)[modelIndex]

if obj_valid(oModel) then begin

  ;ocurves = (*self.ocurveGroup)[val]
  
  ; When evaluating the functions, make sure the number of points is at least 51
  ; to ensure it appears smooth. When zooming below a small x-range, ensure nos 
  ; of points is at least 51
  validIndex = where(x ge self.xrange[0] and x le self.xrange[1],count)
  
  xlo = min(x) & xhi = max(x)
  xrangelo = self.xrange[0] & xrangehi = self.xrange[1]
  nx = n_elements(x)
  xValidLen = 51 > nx
  xBin = x[1]-x[0]
  if ((xrangehi-xrangelo) lt 5.0*xBin) then xValidLen = 51 > nx
  xValid = (xValidLen eq nx)? x :  xlo + findgen(xValidLen)*(xhi-xlo)/(float(xValidLen) - 1.0)
  
  xIsModified = xValidLen ne nx
  
  oFuncs = oModel->get(/all,count=nFuncs)

  ; **
  ; Evaluate and display individual functions in the model without resolution
  ; Note: if a function includes a delta function, then the resolution will be included regardless
  ;if (count gt 2 && nFuncs gt 0) then begin
    for i = 0,nFuncs-1 do begin
       oFuncs[i]->setproperty,xvalues = xValid, /calculate
    endfor
    oModel->Drawcomponents, grpIndex=val, linestyle = 2,thick = 2.5,color = color_4     ;RED
  ;endif


  ; **
  ; Next evaluate the full model, including resolution if present and display that
  if n_elements(*self.resPtr) gt 0 then begin
    resExists = self->Extractoneresstr(val,OneResStr)
;    if (Self.twoDimFlag eq 0) then begin
;      resExists = self->Extractoneresstr(val,OneResStr)
;      (*self.oneresptr) = OneResStr
;      resPtr = Self.oneresptr
;    endif else resPtr = Self.resptr
    if (resExists) then begin
      oModel->evaluate,xvalid,yout = yout,resPtr = self.oneResPtr    
    endif else begin
      self->clearOneRes_ptr 
      ;void_message = 'No Resolution Data for Group #'+strtrim(string(val+1),2)
      ;void = dialog_message(void_message,dialog_parent=self.tlb,title='No Resolution for Group')
      oModel->evaluate,xValid,yout = yout
    endelse
  endif else begin
    ;NO RESOLUTION
    oModel->evaluate,xValid,yout = yout
  endelse

  if (n_elements(yout) gt 1) then begin
    if (Self.twodimflag) then yout = yout[*,val]
    oplot,xValid,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
  endif else begin
    if (!d.name ne 'PS') and (!d.name ne 'PRINTER') and (self.jpeg ne 1) then wset,self.resVis
    if self.jpeg eq 0 then erase
  endelse

  ;; if the x values of the model function was altered for display purposes, revert to the original x.
  if (xIsModified) then begin
     for i = 0,nFuncs-1 do begin
        oFuncs[i]->setproperty,xvalues = x, /calculate
     endfor
  endif

  *self.datxPtr = !x
  *self.datyPtr = !y

endif

;if ((!d.name ne 'PS') and (!d.name ne 'PRINTER') and (self.jpeg ne 1)) then begin
;   device, decomposed=old_dc
;endif

device,decomposed=dc

print,'Display time=',systime(/seconds)-t0
return
end;opan::displaydata



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::plotResiduals, event = event,_Extra = extra,ps_out = ps_out,noerase = noerase
if n_elements(*self.dataPtr) eq 0 then return
if n_elements(ps_out) eq 0 then ps_out = 0
widget_control,self.groupSlider,get_value = val
val = fix(val[0])-1
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0

modelIndex = (Self.twodimflag)? 0 : val
oModel = (*self.ocurvegroup)[modelIndex]

if not obj_valid(oModel) then return

ncurves = oModel->count()
if ncurves eq 0 then begin
  erase
  noerase = 0
  return
endif

self->extractDataForPAN,dat=dat,derr=daterr,x=x,y=y,val=val,dsize=datSize

if N_elements(*self.resptr) gt 0 then begin
  resPtr = (Self.twodimflag)? Self.resptr : Self.oneresptr
  oModel->Evaluate,xvalid,yout = yout,resPtr=resPtr, rlimit=(*resPtr).rlimit
endif else begin
  oModel->Evaluate,xValid,yout = yout
endelse
if (Self.twodimflag) then yout=yout[*,val]

device,get_decomposed=dc
device,decomposed=1
;    if ps_out then begin
;      color_1 = (*self.color_ptr).black
;      color_2 = (*self.color_ptr).black
;      fg_color = 0L;(*self.color_ptr).black
;      bg_color = (2L)^24 - 1;(*self.color_ptr).white
;    endif else begin
;      color_1 = (*self.color_ptr).white
;      color_2 = (*self.color_ptr).yellow
;      fg_color = 0L;(*self.color_ptr).black
;      bg_color = (2L)^24 - 1;(*self.color_ptr).white
;    endelse
      color_1 = (*self.color_ptr).white
      color_2 = (*self.color_ptr).yellow
      fg_color = 0L;(*self.color_ptr).black
      bg_color = (2L)^24 - 1;(*self.color_ptr).white
    residuals = (yout-dat)/daterr
    plot,x,residuals,psym = 0,xrange = self.xrange,xstyle = 1,xtitle = self.xtitle $
         ,ytitle = '!6Residuals',_Extra = extra,color = fg_color,background=bg_color $
         ,charsize=1.25              ;,/nodata
    ;oplot,x,residuals,psym = 0,color = color_2
    plots,!x.crange,[1.0,1.0],/data,linestyle = 2,thick = 1.5,color = fg_color
    plots,!x.crange,[-1.0,-1.0],/data,linestyle = 2,thick = 1.5,color = fg_color
device,decomposed=dc
    return
end;opan::plotResiduals


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::rebinRestore,event = event

    ;LRK 101708
    if n_elements(*self.odataPtr) eq 0 then begin
      void = dialog_message('No data to restore')
      return
    endif

    ; Restore the original binning
    *self.xvalsPtr = *self.oxvalsPtr
    *self.yvalsPtr = *self.oyvalsPtr


    *self.dataPtr = *self.odataPtr

    *self.maskPtr = *self.omaskPtr
    *self.errorPtr = *self.oerrorPtr
    ;if n_elements(*self.resPtr) ne 0 then begin
    ;   *self.resPtr = *self.oresPtr
    ;   resStr = *self.resPtr
    ;   self->interpSigRes, resStr, rlimit = resStr.rlimit, event = event
    ;endif


    ; Recalculate the functions
    data = *self.dataPtr
    datSize = size(data)
    if datSize[0] eq 1 then begin ; a single group

       x = *self.xvalsPtr
       oc = (*self.ocurveGroup)[0]
       ncurves = oc->count()
       if ncurves gt 0 then begin
         if n_elements(*self.resPtr) gt 0 then begin
           resPtr = ptr_new((*self.resPtr).data[*,0])
          oc->setxvalues,x,resPtr = resPtr,yout = yout
          ptr_free,resPtr
         endif else begin
          oc->setxvalues,x,yout = yout
         endelse
       endif
    endif else begin
       ngrps = datSize[2]
       for i = 0,ngrps-1 do begin
         oc = (*self.ocurveGroup)[i]
         ncurves = oc->count()
         if ncurves gt 0 then begin
           x = reform((*self.xvalsPtr)[*,i])
           if n_elements(*self.resPtr) gt 0 then begin
             resPtr = ptr_new((*self.resPtr).data[*,i])
            oc->setxvalues,x,resPtr = resPtr,yout = yout
            ptr_free,resPtr
              endif else begin
            oc->setxvalues,x,yout = yout
           endelse
         endif
       endfor
    endelse

    if n_elements(*self.xtabPtr) ne 0 then $
       self->scaleKtable   ; added 04/09/03

    ; Display the data
    ;wset,self.resPix
    ;self->plotResiduals
    ;wset,self.resVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]
    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::rebinRestore
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::rebinData,event = event

    ;void = dialog_message('opan::rebinData --- THIS DOES NOT YET ACCOUNT FOR MASKING OF DATA OR RESOLUTION!!!!!')

    datamasked = self->checkDataMasked()
    if dataMasked gt 0 then begin
      msg = ['There are masked data points.',$
             'This will likely have adverse affects your binning results.',$
             'Continue with rebin?']
      yn = dialog_message(msg,/question)
      if yn eq 'No' then return
    endif

;101508
;GET THE DATA USING SAME APPROACH AS IN THE NEW CONVOL ROUTINE:



    widget_control,self.groupSlider,get_value = val
    val = fix(val[0])-1
    if n_elements(*self.dataPtr) eq 0 then return
    datSize = size(*self.dataPtr)
    if datSize[0] eq 2 then begin
        dat = (*self.dataPtr)[*,val]
        daterr = (*self.errorPtr)[*,val]
        x = (*self.xvalsPtr)[*,val]
        y = (*self.yvalsPtr)[0,val]
    endif else begin
        dat = reform(*self.dataPtr)
        daterr = reform(*self.errorPtr)
        x = reform(*self.xvalsPtr)
        y = (*self.yvalsPtr)
        val = 0
    endelse
    nx = n_elements(x)
    result = widget_rebin(x,group_leader = event.top,title='Rebin Signal Data')
    if result.cancel then return

    xlo = min(float(x), max=xhi)
    xlo = result.min > xlo
    xhi = result.max < xhi
    dx = result.binw

    nbins = fix((xhi - xlo)/dx) + 1

    if nbins gt nx then begin
      strout = 'Number of desired bins cannot exceed the number of input bins'

      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L      
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif
    ; Ok, we've done the error checking...now do the rebinning
    ;xlo = result.xlo & xhi = result.xhi
    ;nbins = result.nbins
    ;dx = (xhi-xlo)/(nbins-1.0)
    x_out = xlo+dx*findgen(nbins)

    (*self.prefs).xfitlo = (*self.prefs).xfitlo > xlo
    (*self.prefs).xfithi = (*self.prefs).xfithi < xhi

    ; Consider single group first
    if datSize[0] eq 1 then begin
      x_in = x
      z_in = dat
      dz_in = daterr
      if (n_elements(x_in) eq n_elements(z_in)) then begin
          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
          /points,/to_points,err=err,emsg=emsg
      endif else begin
          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
          /hist,/to_hist,err=err,emsg=emsg
      endelse
      ;print,'Error message: ',emsg
    ;  drebin_points_wrapper,x_in,z_in,dz_in,x_out,z_out,dz_out
      *self.dataPtr = z_out
      *self.errorPtr = dz_out
      *self.xvalsPtr = x_out

;070108
      *self.maskPtr = byte(0*(*self.dataptr)) + 1b



    ;  ; Do we need to do this with a resolution function?
    ;  if n_elements(*self.resPtr) gt 0 then begin
    ;      ores = *self.resPtr
    ;      resStr = *self.resPtr
    ;      z_in = resStr.data
    ;      dz_in = 1.0+0.0*findgen(n_elements(z_in))
    ;      if (n_elements(x_in) eq n_elements(z_in)) then begin
    ;          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
    ;                 /points,/to_points,err=err,emsg=emsg
    ;      endif else begin
    ;          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
    ;                 /hist,/to_hist,err=err,emsg=emsg
    ;      endelse
    ;                                ;drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
    ;                                ;   /points,/to_points,err=err,emsg=emsg
    ;                                ;drebin_points_wrapper,x_in,z_in,dz_in,x_out,z_out,dz_out
    ;     outStr = {x:x_out,y:resStr.y,data:z_out,rlimit:resStr.rlimit}
    ;     *self.resPtr = outStr
    ;   endif
    endif else begin
    ; Ok, now consider the general case of multiple groups
       ngrps = datSize[2]
       old = *self.dataPtr
       errold = *self.errorPtr
       newerr = dblarr(nbins,ngrps)
       new = dblarr(nbins,ngrps)
       xnew = dblarr(nbins,ngrps)
       if n_elements(*self.resPtr) gt 0 then begin
         res = dblarr(nbins,ngrps)
         resStr = *self.resPtr
       endif

       for i = 0,ngrps-1 do begin

          z_in = old[*,i]
          dz_in = errold[*,i]

          ok = where(finite(z_in),count_ok)
          z_in = z_in[ok]
          dz_in = dz_in[ok]


          x_in = reform((*self.xvalsPtr)[ok,i])
          xin = x_in & zin = z_in & dzin = dz_in
          xout = x_out
            if (n_elements(xin) eq n_elements(zin[*,0])) then begin
                drebin,xin,zin,dzin,xout,z_out,dz_out,$
          /points,/to_points,err=err,emsg=emsg
            endif else begin
                drebin,xin,zin,dzin,xout,z_out,dz_out,$
          /hist,/to_hist,err=err,emsg=emsg
            endelse
       ; drebin,xin,zin,dzin,xout,z_out,dz_out,$
       ;    /points,/to_points,err=err,emsg=emsg
          ;drebin_points_wrapper,x_in,z_in,dz_in,x_out,z_out,dz_out
         new[*,i] = z_out[*]
         newerr[*,i] = dz_out[*]
         xnew[*,i] = x_out[*]

    ;  ; Do we need to do this with a resolution function?
    ;     if n_elements(*self.resPtr) gt 0 then begin
    ;          zr_in = reform(resStr.data[*,i])
    ;          resInterp = interpol(reform(resStr.data[*,i]),reform(resStr.x[*,i]),x_out)
    ;          res[*,i] = resInterp
    ;     endif
       endfor
    ;   if n_elements(*self.resPtr) gt 0 then begin
    ;     newResStr = {x:xnew,y:resStr,data:res,rlimit:resStr.rLimit}
    ;     *self.resPtr = newResStr
    ;   endif
       *self.dataPtr = new
       *self.errorPtr = newerr
       *self.xvalsPtr = xnew
       ;070108
       *self.maskPtr = byte(0*(*self.dataptr)) + 1b
    endelse

    if datSize[0] eq 2 then begin
      for i = 0,ngrps-1 do begin
       oc = (*self.ocurveGroup)[i]
       x_out = reform((*self.xvalsPtr)[*,i])
    ;   if n_elements(*self.resPtr) gt 0 then begin
    ;;       oneResPtr = ptr_new(res[*,i])
    ;      oneResPtr = {x:(*self.resPtr).x $
    ;                   ,y:(*self.resPtr).y $
    ;                   ,data:reform((*self.resPtr).data[*,i]) $
    ;                   ,rlimit:(*self.resPtr).rlimit $
    ;                  }
    ;      oc->setxvalues,x_out,resPtr = oneResPtr,yout = yout
    ;      ptr_free,oneResPtr
    ;   endif else begin
    ;      oc->setxvalues,x_out,yout = yout
    ;   endelse
       oc->setxvalues,x_out,yout = yout
      endfor
    endif
    if n_elements(*self.xtabPtr) ne 0 then $
       self->scaleKtable   ; added 04/09/03

    ; refresh display
    self->refresh

    return
end;opan::rebinData
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::rebinData_NEW,event = event

    ;void = dialog_message('opan::rebinData_NEW --- THIS DOES NOT YET ACCOUNT FOR MASKING OF DATA OR RESOLUTION!!!!!')
    if n_elements(*self.dataPtr) eq 0 then return

;LRK 103008 UPDATED THIS METHOD TO HANDLE THE MASKED DATA
;    datamasked = self->checkDataMasked()
;    if dataMasked gt 0 then begin
;      msg = ['There are masked data points.',$
;             'This may have adverse affects your binning results.',$
;             'Continue with rebin?']
;      yn = dialog_message(msg,/question)
;      if yn eq 'No' then return
;    endif

;101508
;GET THE DATA USING SAME APPROACH AS IN THE NEW CONVOL ROUTINE:

;GET THE DATA
   
    ;RIGHT NOW, val DOES NOT MATTER, I WILL GET THE MAXIMUM UNMASKED X RANGE
          widget_control,self.groupSlider,get_value = val
   
   
      self->extractDataForPAN,dSize=datSize,$
                              panmask=panmask,$
                              x = xdat,$
                              allx=x,$
                              ally=ally,$
                              y=y,$
                              alldata=dat,$
                              allError=daterr,$
                              val=val

;pro opan::extractDataForPAN,dat=dat,derr=derr,x=x,y=y,erry=erry,val=val,dSize=dSize,$
;                            allData=allData,allx=allx,ally=ally,panmask=panmask,group=group,$
;                            allError=allError,nodata=nodata,_Extra=extra


      help,datSize,panmask,x,y,dat,daterr,val,ally

    val = fix(val[0])-1
    nx = n_elements(x)


;GET THE BINNING INFO (ASSUME ALL DATA WILL BE REBINNED EVENLY OVER THE SAME X RANGE)
;GET THE LARGEST RANGE GROUP TO INPUT THESE STARTING VALUES
    result = widget_rebin(x,group_leader = event.top,title='Rebin Signal Data')
    if result.cancel then return



;GET THE REBIN PARAMETERS
    xlo = min(float(x), max=xhi)
    xlo = result.min > xlo
    xhi = result.max < xhi
    dx = result.binw

;THE NUMBER OF BINS WILL HAVE TO BE EXAMINED TO DECIDE WHAT MASKED DATA WILL BE INCLUDED IN THE
;FINAL RESULT
    nbins = fix((xhi - xlo)/dx) + 1

    if nbins gt nx then begin
      strout = 'Number of desired bins cannot exceed the number of input bins'

      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif
    ; Ok, we've done the error checking...now do the rebinning
    ;xlo = result.xlo & xhi = result.xhi
    ;nbins = result.nbins
    ;dx = (xhi-xlo)/(nbins-1.0)
    x_out = xlo+dx*findgen(nbins)

    (*self.prefs).xfitlo = (*self.prefs).xfitlo > xlo
    (*self.prefs).xfithi = (*self.prefs).xfithi < xhi




;NOW I HAVE TO GET THE DATA FOR EACH GROUP AND REBIN IT SEPARATELY
;EACH RESULTING GROUP WILL HAVE THE SAME XDATA.  ANYTHING OUTSIDE THE 
;NON-MASKED RANGE WILL BE SET TO THE MASKED VALUE, AND A NEW MASK WILL BE SET THERE.
;THIS IS WHERE THE MAX VALUES ARE NEEDED FOR EACH GROUP'S DATA 


            ;(NOTE: THE SAME PROCESS CAN BE DONE SEPARATELY FOR THE RESOLUTION,
            ;       HOWEVER THAT IS NOT REQUIRED SINCE THE NEW CONVOLUTION IS MUCH MORE FLEXIBLE.
            ;


;NOW THAT I HAVE THE NEW X RANGE, I CAN GET EACH GROUP'S DATA AND drebin IT:

help,x,dat,daterr    
help,x_out,z_out,dz_out
    ; Consider single group first
    if datSize[0] eq 1 then begin

      self->extractDataForPAN,x = x_in,$
                              dat=z_in,$
                              derr=dz_in,$
                              group=1

;      x_in = x
;      z_in = dat
;      dz_in = daterr
      if (n_elements(x_in) eq n_elements(z_in)) then begin
          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
          /points,/to_points,err=err,emsg=emsg
      endif else begin
          drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,$
          /hist,/to_hist,err=err,emsg=emsg
      endelse
      ;print,'Error message: ',emsg
    ;  drebin_points_wrapper,x_in,z_in,dz_in,x_out,z_out,dz_out
      *self.dataPtr = z_out
      *self.errorPtr = dz_out
      *self.xvalsPtr = x_out


;SET UP THE NEW MASK BASED ON THE TOTAL RANGE
;WHICH DATA SHOULD BE MASKED?????

;070108
      *self.maskPtr = byte(0*(*self.dataptr)) + 1b

    endif else begin
    ; Ok, now consider the general case of multiple groups
       ngrps = datSize[2]
       old = *self.dataPtr
       errold = *self.errorPtr
       newerr = dblarr(nbins,ngrps)
       new = dblarr(nbins,ngrps)
       xnew = dblarr(nbins,ngrps)
       newmask = byte(0*(new)) + 1b ;EVERYTHING UNMASKED

       if n_elements(*self.resPtr) gt 0 then begin
         res = dblarr(nbins,ngrps)
         resStr = *self.resPtr
       endif

       for i = 0,ngrps-1 do begin

          self->extractDataForPAN,x = x_in,$
                                  dat=z_in,$
                                  derr=dz_in,$
                                  group=i+1

          
          ;z_in = old[*,i]
          ;dz_in = errold[*,i]
;help,x_in,z_in,dz_in
          ok = where(finite(z_in),count_ok)
          z_in = z_in[ok]
          dz_in = dz_in[ok]
          x_in = x_in[ok]
          ;x_in = reform((*self.xvalsPtr)[ok,i])


          ;NOW STORE THE INPUT DATA RANGE SO THAT I CAN MASK OUT THE 
          ;STUFF OUTSIDE OF THIS AFTER THE REBIN
          x_in_max = max(x_in)
          x_in_min = min(x_in)
;          print,'* ',i,'*********************************'
;          print,'i,x_in_min,x_in_max=',i,x_in_min,x_in_max
;          help,x_in,z_in,dz_in

          xin = x_in & zin = z_in & dzin = dz_in
          xout = x_out


;DOES ANYTHING IN PAN DEAL WITH HISTOGRAMMED DATA ANY MORE??????
;            if (n_elements(xin) eq n_elements(zin[*,0])) then begin
            if (n_elements(xin) eq n_elements(zin)) then begin
                drebin,xin,zin,dzin,xout,z_out,dz_out,$
          /points,/to_points,err=err,emsg=emsg
            endif else begin
                drebin,xin,zin,dzin,xout,z_out,dz_out,$
          /hist,/to_hist,err=err,emsg=emsg
            endelse

         new[*,i] = z_out[*]
         newerr[*,i] = dz_out[*]
         xnew[*,i] = x_out[*]
         
        ;ADJUST MASK WHERE NECESSARY
         whminmasked = where(xout lt x_in_min,mincount) 
         whmaxmasked = where(xout gt x_in_max,maxcount)
         ;print,'mincount,maxcount=',mincount,maxcount
         if mincount ne 0 then newmask[whminmasked,i] = 0b
         if maxcount ne 0 then newmask[whmaxmasked,i] = 0b
       endfor
       *self.dataPtr = new
       *self.errorPtr = newerr
       *self.xvalsPtr = xnew
       ;070108
       *self.maskPtr = newmask;byte(0*(*self.dataptr)) + 1b
    endelse





    if datSize[0] eq 2 then begin
      for i = 0,ngrps-1 do begin
       oc = (*self.ocurveGroup)[i]
       x_out = reform((*self.xvalsPtr)[*,i])
       oc->setxvalues,x_out,yout = yout
      endfor
    endif


;THIS IS FOR KWW FIT FUNCTION
    if n_elements(*self.xtabPtr) ne 0 then $
       self->scaleKtable   ; added 04/09/03

    ; refresh display
    self->refresh

    return
end;opan::rebinData_NEW
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;



;###########################################################


;
;
;SET UP THE CROPPING STUFF.  THIS REQUIRES MODIFICATIONS.
;
;JUST SET UP CROPPING AS IS WITH THE INPUT MASK ACCOUNTED FOR.
;
;THEN UPDATE THE CROPPING APPLICATION TO EDIT THE MASK.
;
;



;###########################################################

pro opan::editPanMask,event = event


    qty = reform(*self.dataPtr)
    ;help,qty
    err = reform(*self.errorPtr)
    ;help,err

    self->retrievePanMask,panMask
    ;help,panmask

    allx = reform(*self.xvalsPtr)

    ally = (*self.yvalsPtr)

	sz = size(allx)

;print,'sz=',sz
	if sz[0] eq 2 then begin
		;MULTIPLE GROUPS
		x = reform(allx[*,0],n_elements(allx[*,0]))
		y = reform(ally[0,*],n_elements(ally[0,*]))
	endif else begin
		;ONE GROUP
		x = allx
		y = ally[0]
	endelse


;IS THERE A WAY TO GET THE FILLER VALUE FOR THE DATA??????????

	newmask = panmaskeditor(qty=qty,err=err,x=x,pan_mask=panmask,group_leader=self.tlb)

	;print,'pan_mask=',panmask
	;print,'newmask=',newmask

	*self.maskPtr = newmask
    self->refresh


    ;result = opan_crop_widget(x,xcur,group_leader = event.top)
    ;if result.cancel then return

;    self->applyCrop, result.limits[0],result.limits[1],event.top

    ; refresh display
;    self->refresh

    return

end;opan::editPanMask
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


pro opan::cropData,event = event



    self->extractDataForPAN,val=val,dSize=datSize,alldata=data,allx=x,panmask=panmask,nodata=nodata
    if nodata eq 1 then begin
      void = dialog_message('No data currently loaded.')
    endif else begin    
              widget_control,self.groupSlider,get_value = val
          
              val = fix(val[0])-1
              if n_elements(*self.dataPtr) eq 0 then return
              datSize = size(*self.dataPtr)
              if datSize[0] eq 2 then begin
                 x = (*self.xvalsPtr)[*,val]
                 data = (*self.dataPtr)
              endif else begin
                 x = reform(*self.xvalsPtr)
                 data = reform(*self.dataPtr)
              endelse
          wh = where(panmask ne 1,count)
          if count ne 0 then begin
              data[wh] = 0.0;!values.d_nan
          endif
          
          
          ;CHECK FOR nSec FOR NSE
          ;THIS IS NEEDED BECAUSE CROPXDATA DOES NOT HANDLE SMALL X VALUES.
          nanosecondFlag = 0
          if abs(max(x)) le 1.0e-6 then begin
              nanosecondFlag = 1
              ;print,'NANOSECONDS!!!!!!  IS THIS NSE I(Q,t) DATA? ;-)'
              x = x*1.0e9 ;CONVERT FROM SEC TO NS FOR NSE DATA.
              ;if n_elements(inlimits) ne 0 then inLimits = inLimits*10.0^9
          endif
          
              result = cropXData(x,data,mask=panMask,group_leader = event.top,title='Crop Signal data')
              if (result.cancel eq 1) then return
          
          
          ;UNDO THE NANOSECOND CONVERSION
          if nanosecondFlag ne 0 then result.limits = 1.0e-9*result.limits
          
              ;result = opan_crop_widget(x,xcur,group_leader = event.top)
              ;if result.cancel then return
          
              self->applyCrop, result.limits[0],result.limits[1],event.top
          
              ; refresh display
              self->refresh
    endelse
    return

end;opan::cropData
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::applyCrop, xlo,xhi,wTLB


;THIS MUST BE MODIFIED TO HANDLE MASK.
;SINCE DAVEPTR IS AVAILABLE, MASK SHOULD BE MODIFIED IN PLACE
;AND LATER RESTORED IF IT IS NECESSARY.


    datSize = size(*self.dataPtr)
    x = (datSize[0] eq 2)? (*self.xvalsPtr)[*,0] : (*self.xvalsPtr)

    limits = where((x ge xlo) and (x le xhi),count)
    nx = n_elements(x)
    if (count ge nx) then begin
      msg = 'New range is the same or larger than original'
      msg = [msg,'Data will not be modified']
      void = dialog_message(dialog_parent = wTLB,msg)
      return
    endif
    if (count le 5) then begin
      msg = 'New range has fewer than 5 data points'
      msg = [msg,'Data will not be modified']
      void = dialog_message(dialog_parent = wTLB,msg)
      return
    endif

    datSize = size(*self.dataPtr)
    if datSize[0] eq 2 then begin


       ;LRK
       ;I DON'T BELIEVE THE NEXT LINE WILL WORK PROPERLY, ALTHOUGH IT
       ;IS USED CONSISTENTLY THROUGHOUT PAN.
       ;I REPLACED IT WITH THE THREE LINES THAT FOLLOW AND DID THE SAME
       ;IN THIS ENTIRE SECTION.  THIS REPLACEMENT SEEMS TO HAVE
       ;FIXED A BUG THAT WAS OCCURRING WHEN THE CROP WAS APPLIED.

       ;(*self.dataPtr) = (*self.dataPtr)[limits,*]
       temp = (*self.dataPtr)
       if ptr_valid(self.dataPtr) gt 0 then ptr_free,self.dataPtr
       self.dataPtr = ptr_new(temp[limits,*])

       ;(*self.maskPtr) = (*self.maskPtr)[limits,*]
       temp = (*self.maskPtr)
       if ptr_valid(self.maskPtr) gt 0 then ptr_free,self.maskPtr
       self.maskPtr = ptr_new(temp[limits,*])



       ;(*self.errorPtr) = (*self.errorPtr)[limits,*]
       temp = (*self.errorPtr)
       if ptr_valid(self.errorPtr) gt 0 then ptr_free,self.errorPtr
       self.errorPtr = ptr_new(temp[limits,*])



       ;(*self.xvalsPtr) = (*self.xvalsPtr)[limits,*]
       temp = (*self.xvalsPtr)
       if ptr_valid(self.xvalsPtr) gt 0 then ptr_free,self.xvalsPtr
       self.xvalsPtr = ptr_new(temp[limits,*])


       ;x = (*self.xvalsPtr)[*,0]

       ngrps = datSize[2]
       for i = 0,ngrps-1 do begin

           self->extractDataForPAN,x=x,group=i+1 ;NOTE: GROUP IS 1-BASED LIST

          ;EACH ocurveGroup HAS ITS OWN X VALUES.  THIS MAKES THE ALTERATION HERE SLIGHTLY EASIER.
          oc = (*self.ocurveGroup)[i]


          if (obj_valid(oc)) then oc->setxvalues,x
       endfor
    endif else begin



       ;(*self.dataPtr) = (*self.dataPtr)[limits]
       temp = (*self.dataPtr)
       if ptr_valid(self.dataPtr) gt 0 then ptr_free,self.dataPtr
       self.dataPtr = ptr_new(temp[limits])

       ;(*self.maskPtr) = (*self.maskPtr)[limits]
       temp = (*self.maskPtr)
       if ptr_valid(self.maskPtr) gt 0 then ptr_free,self.maskPtr
       self.maskPtr = ptr_new(temp[limits])



       ;(*self.errorPtr) = (*self.errorPtr)[limits]
       temp = (*self.errorPtr)
       if ptr_valid(self.errorPtr) gt 0 then ptr_free,self.errorPtr
       self.errorPtr = ptr_new(temp[limits])



       ;(*self.xvalsPtr) = (*self.xvalsPtr)[limits]
       temp = (*self.xvalsPtr)
       if ptr_valid(self.xvalsPtr) gt 0 then ptr_free,self.xvalsPtr
       self.xvalsPtr = ptr_new(temp[limits])




       ;x = (*self.xvalsPtr)
       self->extractDataForPAN,x=x,group=1  ;THIS USES CURRENT VARIABLES JUST SET.

       oc = (*self.ocurveGroup)[0]
       if (obj_valid(oc)) then oc->setxvalues,x
    endelse


    ;(*self.prefs).xmin = xlo > (*self.prefs).xmin
    ;(*self.prefs).xmax = xhi < (*self.prefs).xmax
    (*self.prefs).xmin = xlo
    (*self.prefs).xmax = xhi

;LRK 06/24/09
;These limits should only be modified via Preferences.
;Since the data range will be restricted there is no need to
;modify the fit range  
;    (*self.prefs).xfitlo = (*self.prefs).xfitlo > xlo
;    (*self.prefs).xfithi = (*self.prefs).xfithi < xhi


    if n_elements(*self.xtabPtr) ne 0 then $
       self->scaleKtable   ; added 04/09/03

    return
end;opan::applyCrop
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::excludeData,event = event

void = dialog_message('opan::excludeData --- THIS DOES NOT YET ACCOUNT FOR MASKING OF DATA OR RESOLUTION!!!!!')


    widget_control,self.groupSlider,get_value = val
    grp = fix(val[0])-1

    if n_elements(*self.dataPtr) eq 0 then return
    datSize = size(*self.dataPtr)

    ;if datSize[0] eq 2 then begin
    ;    dat = (*self.dataPtr)[*,val]
    ;    daterr = (*self.errorPtr)[*,val]
    ;    x = (*self.xvalsPtr)[*,val]
    ;    y = (*self.yvalsPtr)[0,val]
    ;endif else begin
    ;    dat = reform(*self.dataPtr)
    ;    daterr = reform(*self.errorPtr)
    ;    x = reform(*self.xvalsPtr)
    ;    y = (*self.yvalsPtr)
    ;    val = 0
    ;endelse

    x = (datSize[0] eq 2)? (*self.xvalsPtr)[*,grp] : (*self.xvalsPtr)
    result = opan_removexrange_widget(x,group_leader = event.top)
    if result.cancel then return
    oxlo = min(x,max=oxhi)
    xlo = result.xlo
    xhi = result.xhi
    ; if xlo = xhi then exit
    if (xlo eq xhi) then return

    ; ensure xlo < xhi, if not, swap them
    if (xhi lt xlo) then begin
        tmp = xlo
        xlo = xhi
        xhi = tmp
    endif

    ; ensure range xlo->xhi intersects data
    if ((xhi lt oxlo) || (xlo gt oxhi)) then begin
      strout = 'Specified range does not intersect data!'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif


    xv = (*self.xvalsPtr)
    dat = (*self.dataPtr)
    daterr = (*self.errorPtr)

    exInd = where((x ge xlo) and (x le xhi), complement=inInd, found)
    if (~found) then begin
        strout = 'No data points were excluded!'
        if n_elements(event) ne 0 then dparent = event.top else dparent = 0L        
        void = dialog_message(dialog_parent = dparent,strout)
        return
    endif

    (*self.xvalsPtr) = (datSize[0] eq 1)? xv[inInd] : xv[inInd,*]
    (*self.dataPtr) = (datSize[0] eq 1)? dat[inInd] : dat[inInd,*]
    (*self.errorPtr) = (datSize[0] eq 1)? daterr[inInd] : daterr[inInd,*]


    ; Consider single group first
    ;if (datSize[0] eq 1) then begin
    ;    exInd = where((x ge xlo) && (x le xhi), complement=inInd, found)
    ;    if (~found) then begin
    ;        strout = 'No data points were excluded!'
    ;        void = dialog_message(dialog_parent = event.top,strout)
    ;        return
    ;    endif
    ;
    ;    (*self.xvalsPtr) = x[inInd]
    ;    (*self.dataPtr) = dat[inInd]
    ;    (*self.errorPtr) = daterr[inInd];
    ;
    ;endif else begin
    ; Ok, now consider the general case of multiple groups
    ;    exInd = where((x ge xlo) && (x le xhi), complement=inInd, found)
    ;    if (~found) then begin
    ;        strout = 'No data points were excluded!'
    ;        void = dialog_message(dialog_parent = event.top,strout)
    ;        return
    ;    endif;
    ;
    ;    (*self.xvalsPtr) = x[inInd]
    ;    (*self.dataPtr) = dat[inInd,*]
    ;    (*self.errorPtr) = daterr[inInd,*]
    ;
    ;endelse

    if datSize[0] eq 2 then begin
        for i = 0,datSize[2]-1 do begin
            oc = (*self.ocurveGroup)[i]
            x_out = reform((*self.xvalsPtr)[*,i])
    ;        if n_elements(*self.resPtr) gt 0 then begin
    ;            oneResPtr = ptr_new(res[*,i])
    ;            oc->setxvalues,x_out,resPtr = oneResPtr,yout = yout
    ;            ptr_free,oneResPtr
    ;        endif else begin
                oc->setxvalues,x_out,yout = yout
    ;        endelse
        endfor
    endif
    if n_elements(*self.xtabPtr) ne 0 then $
      self->scaleKtable             ; added 04/09/03

    ;wset,self.resPix
    ;self->plotResiduals
    ;wset,self.resVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]
    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]

    self->refresh

    return
end;opan::excludeData
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::updateFitParmDisplay,val

;NOTE: THIS DIFFERS SLIGHTLY FROM  opan::displayFitParameters
if n_elements(val) eq 0 then begin
    widget_control,self.groupSlider,get_value = val
    val = fix(val[0])-1
    if n_elements(*self.dataPtr) eq 0 then begin
      output = 'No data present'
      widget_control,self.info,set_value = output
      return
    endif
    datSize = size(*self.dataPtr)
    if datSize[0] eq 1 then val = 0
endif;n_elements(val)

modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oModel = (*self.ocurvegroup)[modelIndex]

oModel->displayparms,output = output
ncurves = oModel->count()
if ncurves gt 0 then begin
  widget_control,self.curveSlider,set_slider_max = (ncurves > 2)
endif
if n_elements(output) eq 0 then begin
  output = 'No Curves/Functions present'
endif
widget_control,self.info,set_value = output

end;opan::updateFitParmDisplay

pro opan::selectGroup, event = event
    self->refresh
    return
end;opan::selectGroup


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan_replaceSymbol,inText

    outText = inText
    invAngstromSym = '!3!sA!r!u!9 %!3!n!E-1!N'
    omegaSym = '!4x!3'
    if strpos(inText,'A-1') ne -1 then outText = invAngstromSym
    if strpos(inText,'ueV') ne -1 then outText = '!4l!6eV'
    if strpos(inText,'omega') ne -1 then outText = omegaSym
    return,outText
end;opan_replaceSymbol


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::stuffDave, event = event,inFromDave = inFromDave

    ; This method stuffs the DAVE pointer into the PAN data format
    if n_elements(inFromDave) eq 0 then inFromDave = 0
    if inFromDave eq 0 then begin
      restore,self.filename ; Restores DAVEPTR
      state = *davePtr
      ok = where(strupcase(tag_names(state)) eq 'EXTRAPTR',count)
      if count gt 0 then begin
        obj_destroy,(*state.extraPtr).paninfo.panContainer
        ptr_free,state.extraPtr
      endif
    endif else begin
      state = *self.davePtr
    endelse

    self->extractPanMask,state,pan_mask

    instrument = (*state.dataStrPtr).commonStr.instrument


    energy = (*(*state.dataStrPtr).commonStr.histPtr).x
    xtype = (*state.dataStrPtr).commonStr.xtype
    q = (*(*state.dataStrPtr).commonStr.histPtr).y

    ;RTA - This check no longer required------------------
    ;; Check if the data are binned equally
    ;dx = deriv(energy)
    ;dx_moment = moment(dx)
    ;if sqrt(dx_moment[1]) gt (machar()).eps then begin
    ;   strout = strarr(4)
    ;   strout[0] = 'The binwidths for this data vary quite a bit.'
    ;   strout[1] = 'If you intend to use convolution in your analysis,'
    ;   strout[2] = 'please use the rebin tool within PAN or the '
    ;   strout[3] = 'general DAVE rebin tool.'
    ;   if (n_elements(event) ne 0) then $
    ;      void = dialog_message(dialog_parent = event.top,strout) $
    ;      else void = dialog_message(strout)
    ;endif
    ;------------------------------------------------------

    commonStr = (*state.dataStrPtr).commonStr

    data = (*commonStr.histPtr).qty
    error = (*commonStr.histPtr).err


    ytype = commonStr.ytype
    sx = size(energy)
    sy = size(q)
    if (sx[0] eq 1) and (sy[0] eq 1) then begin
      if strupcase(xtype[0]) eq 'HISTOGRAM' then begin
          nx = n_elements(energy)
          ;xaverage = fltarr(nx-1)
          xaverage = 0.5*(energy[1:nx-1]+energy[0:nx-2])
          energy = xaverage
      endif
      if strupcase(ytype[0]) eq 'HISTOGRAM' then begin
        ny = n_elements(q)
        ;qaverage = fltarr(ny-1)
        qaverage = 0.5*(q[1:ny-1]+q[0:ny-2])
        q = qaverage
      endif
      ; sort x - thus no need to do this later during fitting
      xsort = sort(energy)
      energy = energy[xsort]
      data = data[xsort,*]
      error = error[xsort,*]
      pan_mask = pan_mask[xsort,*]

      nx = n_elements(energy)
      nq = n_elements(q)

      uq = 1+bytarr(nq)
      ux = 1+bytarr(nx)
      xmat = energy#uq
      if n_elements(q) eq 1 then ymat = q else ymat = ux#q
    endif else begin
      ; sort x - thus no need to do this later during fitting
      xsort = sort(energy)
      energy = energy[xsort]
      data = data[xsort]
      error = error[xsort]
      pan_mask = pan_mask[xsort]
      xmat = energy
      ymat = q
    endelse

    *self.xvalsPtr = xmat

    *self.yvalsPtr = ymat

    self.ztitle = commonStr.histLabel

    dataSize = size(data)
    *self.dataPtr = data


    *self.maskPtr = pan_mask


    if n_elements(*commonStr.treatmentPtr) ne 0 then begin
      *self.headerPtr = *commonStr.treatmentPtr
    endif else begin
      *self.headerPtr = 'No information available'
    endelse

    ;rta - reset -ve or zero error values to 1
    invalidIndex = where(error le 0.0, invalidCnt)
    if (invalidCnt gt 0) then error[invalidIndex] = 1.0
    *self.errorPtr = error

    ;treatment = *(*state.dataStrPtr).commonStr.treatmentPtr
    xlabel = commonStr.xlabel
    xunits = commonStr.xunits
    yunits = commonStr.yunits
    ylabel = commonStr.ylabel

    self.xunits = xunits
    self.yunits = yunits

    xxunits = strtrim(strmid(xunits,strpos(xunits,':')+1))
    yyunits = strtrim(strmid(yunits,strpos(yunits,':')+1))
    
    ; RTA - Jun 2022
    ; use units with label stripped out: so 'ueV' instead of 'energy:ueV'
    ; no sense in including the label in the unit!
    self.xunits = xxunits
    self.yunits = yyunits

    xunits = opan_replaceSymbol(xxunits)
    yunits = opan_replaceSymbol(yyunits)

    xlabelDisp = xlabel+'('+xunits+')'
    ylabelDisp = ylabel+'('+yunits+')'

    self.xtitle = xlabelDisp
    self.ytitle = ylabelDisp
    self.title = ylabel

    (*self.prefs).xlabel = self.xtitle
    (*self.prefs).ylabel = self.ztitle
    (*self.prefs).subtitle = self.subtitle


    if inFromDave eq 0 then $
       heap_free, davePtr
       ;dave_beast_ops,"rem",davePtr,show_commands = 0,show_analysis = 0

    return
end;opan::stuffDave
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::scaleKtable, event = event
    ktable = *self.ktablePtr
    xmax = max(*self.xvalsPtr)
    xmin = min(*self.xvalsPtr)
    bigx = max([abs(xmax),abs(xmin)]) ; the maximum value in the dynamic range;
    ksize = size(ktable)
    npts = ksize[1]-1
    nb = ksize[2]-1
    nt = ksize[3]-1
    ytab = dblarr(npts,nb,nt)
    xtab = dblarr(npts)
    btab = dblarr(nb)
    ttab = dblarr(nt)
    ytab[0:npts-1,0:nb-1,0:nt-1] = ktable[0:npts-1,0:nb-1,0:nt-1]
    xtab[0:npts-1] = ktable[0:npts-1,nb,nt]
    btab[0:nb-1] = ktable[npts,0:nb-1,nt]
    ttab[0:nt-1] = ktable[npts,nb,0:nt-1]

    xtabmax = max([abs(min(xtab)),abs(max(xtab))])
    ; calculate the scaling factor
    lambda = xtabmax/bigx  ; scaling factor
    ; scale the tabulated values
    xtab[0:npts-1] = (xtab[0:npts-1]/lambda)
    ytab[0:npts-1,0:nb-1,0:nt-1] = lambda*ktable[0:npts-1,0:nb-1,0:nt-1]
    ttab[0:nt-1] = lambda*ktable[npts,nb,0:nt-1]
    *self.xtabPtr = xtab
    *self.btabPtr = btab
    *self.ttabPtr = ttab
    *self.ytabPtr = ytab
    return
end;opan::scaleKtable
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro opan::clearDaveRes, event = event
    ; Free the resolution function pointer
    if n_elements(*self.resPtr) eq 0 then return
    ptr_free,self.resPtr,self.oneResPtr
    self.resPtr = ptr_new(/allocate_heap)
    self.oneResPtr = ptr_new(/allocate_heap)
    ; Now remove all of the delta functions from the function
    ; container
    ngroups = n_elements(*self.ocurveGroup)
    for i = 0,ngroups-1 do begin
      oc = (*self.ocurveGroup)[i]
      names = oc->getnames()
      isDelta = where(names eq 'pan_delta',countDelta)
      if countDelta gt 0 then begin
        oall = oc->get(/all)
        for j = 0,countDelta-1 do begin
          oDelta = oall[isDelta[j]]
          oc->remove,oDelta
          obj_destroy,oDelta
         ncurves = oc->count()
         widget_control,self.curveSlider,set_slider_max = (ncurves > 2)
        endfor
      endif
    endfor

    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::clearDaveRes


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function OPAN::FitResults2DavePtr, event

    ; First test if there are fits present...
    if n_elements(*self.dataPtr) eq 0 then return, ptr_new()
    datSize = size(*self.dataPtr)
    if datSize[0] eq 2 then begin
      ngroups = datSize[2]
      nchan = datSize[1]
    endif else begin
      ngroups = 1
      nchan = datSize[1]
    endelse
    sum = 0
    for i = 0,n_elements(*self.ocurveGroup)-1 do begin
      sum = sum + (*self.ocurveGroup)[i]->count()
    endfor

    if sum lt ngroups then begin
      strout = 'You must fit all groups!'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return, ptr_new()
    endif


  ;NOW, IF THE FITS ARE COMPLETE, WE CAN GO ON, OTHERWISE THE PROGRAM RETURNED ALREADY.
  

;LOOP THIS NEXT PART OVER ALL GROUPS, SINCE EACH GROUP CAN HAVE A DIFFERENT X VALUE 
    ;FIRST, GET THE DATA FOR THE FULL RANGE
;    self->extractDataForPAN,dat=dat,derr=derr,x=x,y=y,erry=erry,val=val,dSize=dSize,$
;                             allData=allData,allx=allx,panmask=panmask,group=group

;(group = index+1)
if ngroups gt 1 then begin
    qty = fltarr(nchan,ngroups)
    for i=0,ngroups-1 do begin

      self->extractDataForPAN,dat=dat,derr=derr,x=origx,y=y,erry=erry,val=val,dSize=dSize,$
                               allData=allData,allx=allx,panmask=panmask,group=i+1

       ocurves = (*self.ocurveGroup)[i]
    ;SECOND GET THE CURRENT XVALUES IN EACH OF THE FIT CONTAINERS
         ;THESE ARE THE x VALUES EXTRACTED IN THE STATEMENT ABOVE.
    
    ;THIRD REPLACE THE X DATA IN EACH OF THE FIT CONTAINERS
         ocurves->setxvalues,allx
            
    ;FOURTH GET THE FIT DATA FOR THE FULL X RANGES
         ocurves->evaluate,allx,yout = yout
    
    ;FIFTH SAVE THE DATA
         x = reform((*self.xvalsPtr)[*,i])
         y[i] = (*self.yvalsPtr)[0,i]
         qty[*,i] = yout[*]
    
    ;SIXTH RESTORE THE X VALUES TO THE FIT CONTAINERS                            
         ocurves->setxvalues,origx
      
    endfor;i
endif else begin;ngroups
      ocurves = (*self.ocurveGroup)[0]
      self->extractDataForPAN,dat=dat,derr=derr,x=origx,y=y,erry=erry,val=val,dSize=dSize,$
                               allData=allData,allx=allx,panmask=panmask,group=0+1
      ocurves->setxvalues,allx
      x = reform(allx)
      y = (*self.yvalsPtr)[0]
      ocurves->evaluate,allx,yout = yout
      qty[*,i] = yout[*]
      ocurves->setxvalues,origx

endelse
;print,'________________________________________________________'
;help,dsize,panmask,dat,derr,origx,y,erry,val,alldata,allx,group


;ORIGINALLY:
;
;;;    if ngroups gt 1 then begin
;;;       qty = fltarr(nchan,ngroups,/nozero)
;;;       for i = 0,ngroups-1 do begin
;;;         y = fltarr(ngroups)
;;;         ocurves = (*self.ocurveGroup)[i]
;;;         x = reform((*self.xvalsPtr)[*,i])
;;;         y[i] = (*self.yvalsPtr)[0,i]
;;;
;;;;THIS NEXT COMMAND ASSUMES THAT THE ocurves HAVE EXACTLY THE SAME x VALUES AS THE 
;;;;INPUT X VALUES.  THIS CAN BE AN INCORRECT ASSUMPTION.  SO DO I NEED TO CHANGE ocurves::evaluate
;;;;SO THAT IT ACTUALLY USES THE INPUT x VALUES?  
;;;         ocurves->evaluate,x,yout = yout
;;;         qty[*,i] = yout[*]
;;;       endfor
;;;    endif else begin
;;;       ocurves = (*self.ocurveGroup)[0]
;;;       x = reform((*self.xvalsPtr)[*,0])
;;;       y = (*self.yvalsPtr)[0]
;;;       ocurves->evaluate,x,yout = yout
;;;       qty = yout
;;;    endelse

;UNCHANGED
    orig_data = *self.dataPtr
    orig_err = *self.errorPtr;0.005*qty
    rel_err = orig_err/orig_data
    err = qty*rel_err

    ; Create the davePtr
    treatment = ["Data generated by PAN","Results of fit to data"]
    commonStr = {instrument:'',$
                 histPtr:ptr_new(/allocate_heap),$
                 xlabel:'',$
                 ylabel:'',$
                 xtype:'',$
                 ytype:'',$
                 xunits:self.xunits,$
                 yunits:self.yunits,$
                 histLabel:'',$
                 histUnits:'',$
                 treatmentPtr:ptr_new(treatment),$
                 commonStrPtr:ptr_new()}

    *commonStr.histPtr = {  qty:qty,err:err,x:(*self.xvalsptr)[*,0],y:reform((*self.yvalsptr)[0,*])}

    ;ADD SPECIFIC PTR WITH PAN_MASK POINTER
    specificPtr = ptr_new(/allocate_heap)
    *specificPtr = {pan_mask:ptr_new(bits2bytes(panmask))}
    
    dataStr = {commonStr:commonStr,$
               specificPtr:specificPtr}

    dataStrPtr = ptr_new(dataStr,/no_copy)

    daveStr =    {davePtrStr, $     ; RTA - make davePtr structure a named structure
                  dataStrPtr:dataStrPtr, $
                  descriPtr:ptr_new()} ; remove /allocate_heap flag

    davePtr = ptr_new(daveStr,/no_copy)

return, davePtr

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::saveDaveFits, event = event,export=export,davePtr=davePtr

; First test if there are fits present...
if n_elements(*self.dataPtr) eq 0 then return
if n_elements(export) eq 0 then export = 0


;NOTING JOHN'S DREBIN APPROACH TO SIZE CHECKING USE THE NEXT BLOCK TO REPLACE THE
;IF STATEMENT -- IT'S CLEANER:
datSize = size(*self.dataPtr)
;print,'n_elements(*self.dataPtr)=', $
(nv=n_elements(*self.dataPtr))
;print,'ngroups=', $
(ngroups=nv/datSize[1])
;print,'nx=', $
(nchan=nv/ngroups)
    
; Are there unfitted groups present?
; If so, let the user decide whther to proceed
fitObject = (*self.ocurveGroup)
for i = 0,n_elements(*self.ocurveGroup)-1 do begin
  oModel = (Self.twodimflag)? fitObject[0] : fitObject[i]
  if (oModel->getchisq() eq -1.0) then begin
    msg = 'It appears at least one group is not yet fitted!'
    msg = [msg,'Are you sure you want to proceed']
    title = 'PAN: Export fitted results'
    status = Dialog_message(dialog_parent=event.top,title=title,msg,/DEFAULT_NO,/QUESTION)
    if (status.Matches('No',/fold)) then return
    break
  endif
endfor

; Retrieve the curve names in the model and let the user select the ones to be exported
oModel = fitObject[0]                     ; get model for first group
oFuncs = oModel->Get(/all, count=nFunc)   ; the funcs in the model, assumme they are the same for all groups
if (nFunc le 0) then Return
funcNames = oModel->getnames()            ; names of funcs in the model

; Prepare a dialog displaying the functions in the model and give
; user the choise to select which ones to be included in the export.
; However, no need to do this if only one function is present
activeFlag = intarr(nFunc) + 1
if (nFunc gt 1) then begin
  title = 'PAN: Export fitted results'
  wTlb = Widget_base(group_leader=Event.top, /modal,/column,title=title);,scr_xsize=300)
  void = Widget_label(wTLB,value='Please select the functions you wish to include in the')
  void = Widget_label(wTLB,value='exported fit results. Only the checked ones will be used.')
  base1 = widget_base(wTLB, /nonexclusive,/col,/grid,/align_center)
  sHash = Orderedhash(/FOLD_CASE)
  for i=0,nFunc-1 do begin
    name= funcNames[i].Substring(4)  ; leave out the 'pan_' part
    idname = name+strtrim(string(i),2)
    wID = widget_button(base1,value=name,uname=idname)
    Widget_control, wID, set_button = 1
    sHash[idname] = 1
  endfor
  base2 = widget_base(wTLB,/row,/grid,/align_center)
  wID = widget_button(base2,value='PROCEED',uname='ACCEPT')
  wID = widget_button(base2,value='CANCEL',uname='CANCEL')
  sHash['accept'] = 0
  sHash['cancel'] = 0
  widget_control, wTLB, set_uvalue=sHash
  widget_control, wTLB, /realize
  Xmanager, 'PAN_ExportFitResults',wTLB, NO_BLOCK=0, event_handler='PAN_ExportFitResults_event'
  help, sHash
  values = (sHash->Values())->toArray()
  cancel = values[nFunc+1]
  if (cancel) then return
  activeFlag = values[0:nFunc-1]
  status = where(activeFlag eq 1, cnt)
  if (cnt le 0) then return   ; ==> no functions were selected by user. This makes no sense so exit now!
endif


; 
qty = (ngroups eq 1)? fltarr(nchan) : fltarr(nchan,ngroups)
Self->extractDataForPAN,dat=dat,derr=derr,x=origx,erry=erry,val=val,dSize=dSize $
                       ,allData=allData,allx=allx,group=1,allerror=allerror,panmask=panmask
                       
; When evaluating the functions, make sure the number of points is at least 51
; to ensure it appears smooth. When zooming below a small x-range, ensure nos
; of points is at least 51
xlo = Min(allx) & xhi = Max(allx)
xrangelo = self.xrange[0] & xrangehi = self.xrange[1]
nx = N_elements(allx)
xValidLen = 51 > nx
allx = (xValidLen eq nx)? allx :  xlo + Findgen(xValidLen)*(xhi-xlo)/(Float(xValidLen) - 1.0)

for i=0, ngroups-1 do begin
  oModel = (Self.twodimflag)? fitObject[0] : fitObject[i]   ; retrieve model for current group
  oModel->setxvalues,allx           ; make sure the full x range is in place before evaluating functions
  
  ;Self->Extractdataforpan, val=val,group=i+1
  val = i
  oFuncs = oModel->Get(/all)
  for j = 0,nFunc-1 do begin
    oFuncs[j]->Setproperty, active = activeFlag[j]    ; if active is 0 then function becomes inactive when model is being evaluated
  endfor
   

  if (Self.twodimflag) then begin
    if (i eq 0) then begin
      ; need to evaluate once since all grps are caculated together
      if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
        (*self.oneresptr) = OneResStr
        rlimit=OneResStr.rlimit
      endif else self->Clearoneres_ptr
      oModel->Evaluate,allx,yout = yfit2D,resPtr = self.oneresptr,rlimit = rlimit
    endif
    yfit = yfit2D[*,i]
  endif else begin
    if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
      (*self.oneresptr) = OneResStr
      rlimit=OneResStr.rlimit
    endif else self->Clearoneres_ptr
    oModel->Evaluate,allx,yout = yfit,resPtr = self.oneresptr,rlimit = rlimit
  endelse
 
  for j = 0,nFunc-1 do begin
    oFuncs[j]->Setproperty, active = 1    ; reset all functions back to active state
  endfor
  
  if (ngroups eq 1) then begin
    qty = yfit
  endif else begin
    qty[*,i] = yfit
  endelse

  oModel->setxvalues,origx    ; reset to the potentially modified x values
  
endfor
x = Reform(allx)
y = reform((*self.yvalsPtr))
if (y.ndim eq 2) then y = reform(y[0,*])  ; if 2D then extarct the grp values out 

;orig_data = *self.dataPtr
;orig_err = *self.errorPtr;0.005*qty
;rel_err = orig_err/orig_data
;rel_err = allerror/alldata
;err = qty*rel_err
err = qty*0.05

; Create the davePtr
treatment = ['Pan Fit Results' + Systime()]
commonStr = {instrument:'',$
  histPtr:Ptr_new(/allocate_heap),$
  xlabel:'',$
  ylabel:'',$
  xtype:'',$
  ytype:'',$
  xunits:self.xunits,$
  yunits:self.yunits,$
  histLabel:'',$
  histUnits:'',$
  treatmentPtr:Ptr_new(treatment),$;/allocate_heap),$
  commonStrPtr:Ptr_new()}

*commonStr.histPtr = {  qty:qty,err:err,x:x,y:y}
;WITHOUT DEFINING TREATMENT, DAVE CANNOT READ THE "DAVE" FILE
;I BELIEVE THIS IS A BUG IN DAVE  AT davedataset__define.pro LINE 925.

;ADD SPECIFIC PTR WITH PAN_MASK POINTER
specificPtr = Ptr_new({pan_mask:Ptr_new(Bits2bytes(Bytarr(n_elements(qty)) + 1B))})

dataStr = {commonStr:commonStr,$
  specificPtr:specificPtr}

dataStrPtr = Ptr_new(dataStr,/no_copy)

daveStr =    {Daveptrstr, $     ; RTA - make davePtr structure a named structure
  dataStrPtr:dataStrPtr, $
  descriPtr:Ptr_new()} ; remove /allocate_heap flag

davePtr = Ptr_new(daveStr,/no_copy)

if export eq 0 then begin
  thisPath = self.workDir
  if N_elements(event) ne 0 then dparent = Event.top else dparent = 0L
  filename = Dialog_pickfile(dialog_parent = dparent,$
    file = 'fitResults.dave', $
    title = 'DAVE Fit Results File Name',$
    /write,filter = '*.dave',/overwrite_prompt,$
    path = thisPath)
  if filename[0] eq '' then Return
  filename = filename[0]
  self.workdir = File_dirname(filename)

  self->Adddotdave,filename

  Save, davePtr, filename = filename
  msg = 'Output saved in: '+filename
  if N_elements(event) ne 0 then dparent = Event.top else dparent = 0L
  ok = Dialog_message(/info,msg,dialog_parent=dparent)
  ; Now clean up the pointers we just made
  Ptr_free,(*(*davePtr).dataStrPtr).commonStr.histPtr
  Ptr_free,(*(*davePtr).dataStrPtr).commonStr.treatmentPtr
  Ptr_free,(*(*davePtr).dataStrPtr).commonStr.commonStrPtr
  Ptr_free,(*(*davePtr).dataStrPtr).specificPtr
  Ptr_free,(*davePtr).dataStrPtr
  Ptr_free,(*davePtr).descriPtr
  Ptr_free,davePtr
endif;NOT FOR EXPORT





;;LOOP THIS NEXT PART OVER ALL GROUPS, SINCE EACH GROUP CAN HAVE A DIFFERENT X VALUE 
;;FIRST, GET THE DATA FOR THE FULL RANGE
;;    self->extractDataForPAN,dat=dat,derr=derr,x=x,y=y,erry=erry,val=val,dSize=dSize,$
;;                             allData=allData,allx=allx,panmask=panmask,group=group
;
;;(group = index+1)
;if ngroups gt 1 then begin
;    qty = fltarr(nchan,ngroups)
;    y = fltarr(ngroups)
;    for i=0,ngroups-1 do begin
;
;      self->extractDataForPAN,dat=dat,derr=derr,x=origx,$
;                               ;y=y,$ ;THIS Y IS NOT NEEDED HERE BECAUSE IT IS CALCULATED BY oCurves!!!
;                               erry=erry,val=val,dSize=dSize,$
;                               allData=allData,allx=allx,panmask=panmask,group=i+1
;
;
;;063008
;;
;;WHY IS THERE NO CHECK FOR A RESOLUTION FUNCTION HERE??????????????
;;E.G. LOOK AT opan::displayData
;;LOOKING AT THE ORIGINAL CODE BELOW, I DON'T SEE WHERE IT WAS DONE 
;;ORIGINALLY EITHER.  WAS THAT AN OVERSIGHT THAT WAS NEVER CAUGHT?
;;I BELIEVE SO AND I AM ADDING CODE TO CORRECT THAT NOW.
;
;
;       ocurves = (*self.ocurveGroup)[i]
;    ;SECOND GET THE CURRENT XVALUES IN EACH OF THE FIT CONTAINERS
;         ;THESE ARE THE x VALUES EXTRACTED IN THE STATEMENT ABOVE.
;    
;    ;THIRD REPLACE THE X DATA IN EACH OF THE FIT CONTAINERS
;         ocurves->setxvalues,allx
;            
;    ;FOURTH GET THE FIT DATA FOR THE FULL X RANGES
;
;;063008
;;COMMENT THIS LINE AND REPLACE WITH THE BLOCK BELOW IT.
;;         ocurves->evaluate,allx,yout = yout
;
;
;        ;063008
;        ;ADDING THE NEXT BLOCK TO HANDLE THE RESOLUTION DATA BEFORE 
;        ;SAVING TO FILE.
;        if n_elements(*self.resPtr) gt 0 then begin
;        
;        
;             ;020508 THE NEXT BLOCK OF CODE SUPERCEDES THE ONE BELOW IT.
;             resExists = self->ExtractOneResStr(val,OneResStr)
;             if resExists ne 0 then begin
;               ;(*self.oneResPtr) = OneResStr
;               (*self.oneResPtr) = OneResStr
;               ocurves->evaluate,allx,yout = yout,resPtr = self.oneResPtr
;             endif else begin
;               self->clearOneRes_ptr
;               void = dialog_message('No Resolution Data for Group #'+strtrim(string(val+1),2))
;               ocurves->evaluate,allx,yout = yout             
;             endelse
;        endif else begin
;        
;          ;NO RESOLUTION
;          ocurves->evaluate,allx,yout = yout
;        endelse
;
;
;;help,y,(*self.yvalsPtr),(*self.yvalsPtr)[0,i]
;    ;FIFTH SAVE THE DATA
;         x = reform((*self.xvalsPtr)[*,i])
;         y[i] = (*self.yvalsPtr)[0,i]
;         qty[*,i] = yout[*]
;    
;    ;SIXTH RESTORE THE X VALUES TO THE FIT CONTAINERS                            
;         ocurves->setxvalues,origx
;      
;    endfor;i
;endif else begin;ngroups
;;       ocurves = (*self.ocurveGroup)[0]
;;       x = reform((*self.xvalsPtr)[*,0])
;;       y = (*self.yvalsPtr)[0]
;;       ocurves->evaluate,x,yout = yout
;;       qty = yout
;
;      ocurves = (*self.ocurveGroup)[0]
;      self->extractDataForPAN,dat=dat,derr=derr,x=origx,y=y,erry=erry,val=val,dSize=dSize,$
;                               allData=allData,allx=allx,panmask=panmask,group=0+1
;      ocurves->setxvalues,allx
;
;      ;063008
;      ;REPLACE THE FOLLOWING LINE WITH THE FOLLOWING BLOCK OF CODE
;      ;JUST AS FOR MULTIPLE GROUPS ABOVE
;;      ocurves->evaluate,allx,yout = yout
;
;      ;063008
;      ;ADDING THE NEXT BLOCK TO HANDLE THE RESOLUTION DATA BEFORE 
;      ;SAVING TO FILE.
;      if n_elements(*self.resPtr) gt 0 then begin
;           resExists = self->ExtractOneResStr(0,OneResStr)
;           if resExists ne 0 then begin
;             (*self.oneResPtr) = OneResStr
;             ocurves->evaluate,allx,yout = yout,resPtr = self.oneResPtr
;           endif else begin
;             self->clearOneRes_ptr
;             void = dialog_message('No Resolution Data for Group #'+strtrim(string(val+1),2))
;             ocurves->evaluate,allx,yout = yout             
;           endelse
;      endif else begin
;        ;NO RESOLUTION
;        ocurves->evaluate,allx,yout = yout
;      endelse
;
;
;      x = reform(allx)
;      y = (*self.yvalsPtr)[0]
;      
;      ;073108
;      ;Terry Noted that the next line causes an error when there is just one 
;      ;group in the data.  Replace with the one below it. (Note: yout and allx have same numbers of elements.)  
;      ;qty[*,i] = yout[*]
;      qty = yout[*]
;
;
;      ocurves->setxvalues,origx
;
;endelse
;;print,'________________________________________________________'
;;help,dsize,panmask,dat,derr,origx,y,erry,val,alldata,allx,group
;
;
;;ORIGINALLY:
;;
;;;;    if ngroups gt 1 then begin
;;;;       qty = fltarr(nchan,ngroups,/nozero)
;;;;       for i = 0,ngroups-1 do begin
;;;;         y = fltarr(ngroups)
;;;;         ocurves = (*self.ocurveGroup)[i]
;;;;         x = reform((*self.xvalsPtr)[*,i])
;;;;         y[i] = (*self.yvalsPtr)[0,i]
;;;;
;;;;;THIS NEXT COMMAND ASSUMES THAT THE ocurves HAVE EXACTLY THE SAME x VALUES AS THE 
;;;;;INPUT X VALUES.  THIS CAN BE AN INCORRECT ASSUMPTION.  SO DO I NEED TO CHANGE ocurves::evaluate
;;;;;SO THAT IT ACTUALLY USES THE INPUT x VALUES?  
;;;;         ocurves->evaluate,x,yout = yout
;;;;         qty[*,i] = yout[*]
;;;;       endfor
;;;;    endif else begin
;;;;       ocurves = (*self.ocurveGroup)[0]
;;;;       x = reform((*self.xvalsPtr)[*,0])
;;;;       y = (*self.yvalsPtr)[0]
;;;;       ocurves->evaluate,x,yout = yout
;;;;       qty = yout
;;;;    endelse
;
;;UNCHANGED
;    orig_data = *self.dataPtr
;    orig_err = *self.errorPtr;0.005*qty
;    rel_err = orig_err/orig_data
;    err = qty*rel_err
;
;    ; Create the davePtr
;    treatment = ['Pan Fit Results' + systime()]
;    commonStr = {instrument:'',$
;                 histPtr:ptr_new(/allocate_heap),$
;                 xlabel:'',$
;                 ylabel:'',$
;                 xtype:'',$
;                 ytype:'',$
;                 xunits:self.xunits,$
;                 yunits:self.yunits,$
;                 histLabel:'',$
;                 histUnits:'',$
;                 treatmentPtr:ptr_new(treatment),$;/allocate_heap),$
;                 commonStrPtr:ptr_new()}
;
;    *commonStr.histPtr = {  qty:qty,err:err,x:(*self.xvalsptr)[*,0],y:reform((*self.yvalsptr)[0,*])}
;                                           ;WITHOUT DEFINING TREATMENT, DAVE CANNOT READ THE "DAVE" FILE 
;                                           ;I BELIEVE THIS IS A BUG IN DAVE  AT davedataset__define.pro LINE 925.
;
;    ;ADD SPECIFIC PTR WITH PAN_MASK POINTER
;    specificPtr = ptr_new(/allocate_heap)
;    *specificPtr = {pan_mask:ptr_new(bits2bytes(panmask))}
;    
;    dataStr = {commonStr:commonStr,$
;               specificPtr:specificPtr}
;
;    dataStrPtr = ptr_new(dataStr,/no_copy)
;
;    daveStr =    {davePtrStr, $     ; RTA - make davePtr structure a named structure
;                  dataStrPtr:dataStrPtr, $
;                  descriPtr:ptr_new()} ; remove /allocate_heap flag
;
;    davePtr = ptr_new(daveStr,/no_copy)
;
;    if export eq 0 then begin
;        thisPath = self.workDir
;        if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
;        filename = DIALOG_PICKFILE(dialog_parent = dparent,$
;                       file = 'fitResults.dave', $
;                                   title = 'DAVE Fit Results File Name',$
;                                   /write,filter = '*.dave',$
;                                   path = thisPath)
;        if filename[0] eq '' then return
;        filename = filename[0]
;        self.workdir = file_dirname(filename)
;
;        self->addDotdave,filename
;
;        save, davePtr, filename = filename
;        msg = 'Output saved in: '+filename
;        if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
;        ok = dialog_message(/info,msg,dialog_parent=dparent)
;        ; Now clean up the pointers we just made
;        ptr_free,(*(*davePtr).dataStrPtr).commonStr.histPtr
;        ptr_free,(*(*davePtr).dataStrPtr).commonStr.treatmentPtr
;        ptr_free,(*(*davePtr).dataStrPtr).commonStr.commonStrPtr
;        ptr_free,(*(*davePtr).dataStrPtr).specificPtr
;        ptr_free,(*davePtr).dataStrPtr
;        ptr_free,(*davePtr).descriPtr
;        ptr_free,davePtr
;    endif;NOT FOR EXPORT
    
end;opan::saveDaveFits


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::exportDaveFits, event = event

;LRK - 07/13/11
;I'M NOT SURE THAT THE METHOD IN THE NEXT CALL WILL WORK PROPERLY, ESP. WRT. RESOLUTION    
;davePtr = self->FitResults2DavePtr(event)
self->saveDaveFits,event=event,davePtr=davePtr,/export

if (~ptr_valid(davePtr)) then return

nameTag = "PANFitResults"

; Send data to DAVE Data Manager Folder
(self.DAVETool)->AddDavePtrToDataManager, davePtr, nameTag

heap_free, davePtr

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadDaveRes, event = event

    thisPath = self.dataDir
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                               title = 'Select DAVE resolution file to restore',$
                               /read,filter = '*.dave',$
                               path = thisPath)
    if filename eq '' or filename eq ' ' then begin
      strout = 'No resolution file selected'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif
    self.datadir = file_dirname(filename)

    restore,filename  ; Restores DAVEPTR
    state = *davePtr
    
    
    
    ok = where(strupcase(tag_names(state)) eq 'EXTRAPTR',count)
    if count gt 0 then begin
 
        ;print,'ExtraPtr BEING REPLACED: Look at PanContainer------------------------'
 
        obj_destroy,(*state.extraPtr).paninfo.panContainer
        ptr_free,state.extraPtr
    endif



    x = (*(*state.dataStrPtr).commonStr.histPtr).x
    xtype = (*state.dataStrPtr).commonStr.xtype
    y = (*(*state.dataStrPtr).commonStr.histPtr).y
    ytype = (*state.dataStrPtr).commonStr.ytype

    resdata = (*(*state.dataStrPtr).commonStr.histPtr).qty

    self->extractPanMask,state,pan_mask,/resolution
      

;print,'In opan::loadDaveRes'
;print,'ResData[*,0] ='
;print,resdata[*,0]



;How would mask affect this section????
    sx = size(x)
    sy = size(y)
    if (sx[0] eq 1) and (sy[0] eq 1) then begin
          ;BOTH 1 FOR HISTOGRAM DATA ONLY.

                if strupcase(xtype[0]) eq 'HISTOGRAM' then begin
;print,'GET FEEDBACK TO VERIFY THAT HISTOGRAM DATA IS BEING HANDLED PROPERLY'
                    nx = n_elements(x)
                    xaverage = 0.5*(x[1:nx-1]+x[0:nx-2])
                    x = xaverage
                endif
                if strupcase(ytype[0]) eq 'HISTOGRAM' then begin
;print,'GET FEEDBACK TO VERIFY THAT HISTOGRAM DATA IS BEING HANDLED PROPERLY'
                  ny = n_elements(y)
                  yaverage = 0.5*(y[1:ny-1]+y[0:ny-2])
                  y = yaverage
                endif
                nx = n_elements(x)
                ny = n_elements(y)
          
              ;  uy = 1+bytarr(ny)
              ;  ux = 1+bytarr(nx)
              ;  xmat = x#uy
              ;  ymat = ux#y
          
              ;sort x
                xsort = sort(x)
;063008
;SIMPLE SORTING OF x SHOULD SOLVE THE PROBLEM HERE SINCE THE pan_mask IS REFERENCED
;BY THE SAME SORTED x BELOW. 
                x = x[xsort]
                resdata = resData[xsort,*]          
          
                ;pan_mask SHOULD HAVE SAME DIMENSIONS AS DATA.  
                ;x,y MAY CHANGE DUE TO HISTOGRAMMING 

                pan_mask = pan_mask[xsort,*]


                 whmasked = where(pan_mask eq 0,maskcount)
                 whnotmasked = where(pan_mask ne 0,notmaskcount)

                 ;020408
                 ;ZERO DATA THAT IS MASKED TO FACILITATE PLOTTING
                 if maskcount ne 0 then begin
                   resdata[whmasked] = 0.0
                 endif



          ;print,'After sort: ResData[*,0] ='
          ;print,ResData[*,0]

          ;020408
          ;REPLACE THE NEXT BLOCK WITH THE ONE BELOW IT THAT INCLUDES THE PAN_MASK
          ;      for i=0,ny-1 do begin
          ;         ;; normalize the res function
          ;         scale = int_tabulated(x,resData[*,i])
          ;         resData[*,i] = resData[*,i]/scale
          ;      endfor



                for i=0,ny-1 do begin
                   ;; normalize the res function one group at a time                   
                   whmasked = where(pan_mask[*,i] eq 0,maskcount)
                   whnotmasked = where(pan_mask[*,i] ne 0,notmaskcount)
                   if notmaskcount eq 0 then begin
                      ;ALL DATA ARE MASKED FOR THIS GROUP
                      ;DO NOTHING TO THE DATA
                   endif else begin
                     ;LRK 06/25/09
                     ;int_tabulated FAILS IF THERE IS JUST ONE DATA POINT, SO SET SCALE TO 1.0 IF THERE IS ONLY ONE POINT.
                     if notmaskcount eq 1 then begin
                       scale = 1.0
                     endif else begin
                       scale = int_tabulated(x[whnotmasked],resData[whnotmasked,i])
                     endelse
                     resData[whnotmasked,i] = resData[whnotmasked,i]/scale
                   endelse
                endfor

          ;print,'After scale: ResData[*,0] ='
          ;print,ResData[*,0]
            
    endif else begin
    
              ;x AND y ARE probably 2D ARRAYS

              ;  xmat = x
              ;  ymat = y

                 whmasked = where(pan_mask eq 0,maskcount)
                 whnotmasked = where(pan_mask ne 0,notmaskcount)
          
                 ;020408
                 ;ZERO DATA THAT IS MASKED TO FACILITATE PLOTTING
                 if maskcount ne 0 then begin
                   resdata[whmasked] = 0
                 endif
          
          
                 if notmaskcount eq 0 then begin
                   ;ALL DATA ARE MASKED.  DO NOTHING.
                 endif else begin

                   ;063008
                   ;THIS NEEDS TO BE HANDLED DIFFERENTLY FOR 1D AND 2D DATA SETS:
                   if sx[0] eq 1 then begin
                       ;;sort x
                       xsort = sort(x)
                       ;x = x[xsort]


                       szres = size(resdata)

                       if szres[0] eq 1 then begin
                         resdata = resData[xsort]
                         pan_mask = pan_mask[xsort]
                         whnotmasked = where(pan_mask ne 0,notmaskcount)
      
                         ;; normalize the res function
                         scale = int_tabulated(x[whnotmasked],resData[whnotmasked])
                         resData = resData/scale
                       endif else begin
                          
                           ny = szres[2]
                           for ii = 0,ny - 1 do begin
                             resdata = resData[xsort,ii]
                             pan_mask = pan_mask[xsort,ii]
                             whnotmasked = where(pan_mask[*,ii] ne 0,notmaskcount)
          
                             ;; normalize the res function
                             scale = int_tabulated(x[whnotmasked],resData[whnotmasked,ii])
                             resData[*,ii] = resData[*,ii]/scale
                           endfor;ii
                       endelse
                   endif else begin
                       ny = sx[2]
                       for ii = 0,ny - 1 do begin
                          xsort = sort(x[*,ii])
                          x[*,ii] = x[xsort,ii]
                          resdata[*,ii] = resData[xsort,ii]
                          pan_mask[*,ii] = pan_mask[xsort,ii]
                          whnotmaskedii = where(pan_mask[*,ii] ne 0,notmaskcountii)

                          if notmaskcountii ne 0 then begin
                            scaleii = int_tabulated(x[whnotmaskedii,ii],resData[whnotmaskedii,ii])
                            resData[*,ii] = resData[*,ii]/scaleii
                          endif
                       endfor;ii 

                   endelse
  
                 endelse
    endelse

    ;resStr = {x:xmat,y:ymat,data:resdata,rlimit:max(xmat)}
    resStr = {x:x,y:y,data:resdata,rlimit:[min(x),max(x)],mask:pan_mask,xDat_equals_xRes:0}

    ; Is there a data file present?
    ;if n_elements(*self.dataPtr) gt 0 then begin
    ;  ; Yes, stuff the resolution function contents into a structure
    ;  *self.resPtr = resStr
    ;  *self.oresPtr = resStr
    ;endif

    self->interpSigRes, resStr, event = event

;DETERMINE WHETHER davePtr IS A POINTER OR A STRUCTURE
    dave_beast_ops,"rem",davePtr,show_commands = 0,show_analysis = 0
;print,'After dave_beast_ops'

    ;LRK 02/02/09
    self->refresh
    return
end;opan::loadDaveRes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::load_3col_ascii_res, event = event
    thisPath = self.dataDir;self.workDir
    if n_elements(*self.dataptr) eq 0 then begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(dialog_parent = dparent,'Load signal data file first')
       return
    endif
    filename = DIALOG_PICKFILE(dialog_parent = event.top,$
                               title = 'Select 3-column ascii file',$
                               /read,filter = '*.txt',$
                               path = thisPath)
    if filename eq '' or filename eq ' ' then begin
      strout = 'No resolution file selected'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L      
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif

    ; Read in the ascii file
    if file_test(filename) then begin
    ; Ok it is a valid filename, but can we read it in here?
       self.dataDir = file_dirname(filename)
       o = obj_new('ascii_data',filename = filename)
       ret = o->read_three_column_ascii(err = err,emsg = emsg)
       if err eq 1 then begin
          obj_destroy,o
          if n_elements(event) ne 0 then dparent = event.top else dparent = 0L          
          void = dialog_message(dialog_parent = dparent,emsg)
          return
       endif
    endif else begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(dialog_parent = dparent,'Resolution file not found')
       return
    endelse

    ret = o->get_property(xvals = xvals, $
       filename = filename,zvals = zvals,dzvals = dzvals)
    obj_destroy,o

    xsort = sort(xvals)
    x = xvals[xsort]
    y = 0.0
    ;nx = n_elements(x) & ny = n_elements(y)
    ;xmat = rebin(x,nx,ny,/sample)
    ;ymat = (1+bytarr(nx))#y
    zvals = zvals[xsort]
    factor = int_tabulated(xvals,zvals)
    zvals = zvals/factor

    ;resStr = {x:xmat,y:ymat,data:zvals,rlimit:max(xmat)}
;020408
;ADD mask FIELD TO THE resStr
    resStr = {x:x,y:y,data:zvals,rlimit:[min(x),max(x)],mask:byte(0*zvals)+1b,xDat_equals_xRes:0}

    ; Is there a data file present?
    ;if n_elements(*self.dataPtr) gt 0 then begin
    ;  ; Yes, stuff the resolution function contents into a structure
    ;  *self.resPtr = resStr
    ;  *self.oresPtr = resStr
    ;endif

    self->interpSigRes, resStr, event = event

    ;LRK 02/02/09
    self->refresh

end;opan::load_3col_ascii_res
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::load_group_ascii_res, event = event

    catch,theError
    if theError ne 0 then begin
      catch,/cancel
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent, $
             !error_state.msg+' Returning...')
      return
    endif

    ;thisPath = self.workDir
    thisPath = self.dataDir
    if n_elements(*self.dataptr) eq 0 then begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(dialog_parent = dparent,'Load signal data file first')
       return
    endif
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                               title = 'Select grouped ascii file',$
                               /read,filter = '*.txt',$
                               path = thisPath)
    if filename eq '' or filename eq ' ' then begin
      strout = 'No resolution file selected'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif

    if file_test(filename) then begin
    ; Ok it is a valid filename, but can we read it in here?
       self.dataDir = file_dirname(filename) 
       o = obj_new('ascii_data',filename = filename)
       ret = o->read_group_ascii(err = err,emsg = emsg)
       if err eq 1 then begin
          obj_destroy,o
          if n_elements(event) ne 0 then dparent = event.top else dparent = 0L          
          void = dialog_message(dialog_parent = dparent,emsg)
          return
       endif
    endif

    ret = o->get_property(xvals = xvals,yvals = yvals, $
       filename = filename,zvals = zvals,dzvals = dzvals)
    obj_destroy,o
    delimiter = path_sep()
    dpos = strpos(filename,delimiter,/reverse_search)
    display_name = strmid(filename,dpos+1)

    ;nx = n_elements(xvals)
    ny = n_elements(yvals)
    ;ux = 1+bytarr(nx) & uy = 1+bytarr(ny)


    x = xvals
    y = yvals
    ;xmat = x#uy
    ;ymat = ux#y

;020408
;FOR ASCII FILES THERE WILL BE NO MASK, SO IT DOES NOT NEED TO BE USED HERE,
;BUT IT WILL BE ADDED FOR CONSISTENCY BELOW 

    ;11/24/09
    tempmask = byte(0*zvals);+1b  ;DEFAULT IS TO MASK EVERYTHING UNLESS IT TURNS OUT NOT TO BE NaN:
    totnans = 0
    for i = 0,ny-1 do begin
       ;LRK - 11/24/09
       ;CHECK FOR NANs AND REMOVE THEM. ---- WILL THIS BE A PROBLEM IN CONVOLUTION LATER??????????
       tempzvals = zvals[*,i]
       temptempmask = tempmask[*,i]
       whnotnan = where(finite(tempzvals,/nan) eq 0,whcount)
       totnans += (n_elements(tempzvals) - whcount)
       if whcount gt 0 and whcount le n_elements(tempzvals) then begin
         tempzvals = tempzvals[whnotnan]
         tempx = x[whnotnan]
         temptempmask[whnotnan] = 1B
       endif
       factor = int_tabulated(tempx,tempzvals)
       ;factor = int_tabulated(x,zvals[*,i])
       zvals[*,i] = zvals[*,i]/factor
       tempmask[*,i] = temptempmask
    endfor
    ;resdata = zvals
    ;resStr = {x:xmat,y:ymat,data:resdata,rlimit:max(xmat)}
;020408
;ADD mask FIELD TO THE resStr
    
    
    resStr = {x:x,y:y,data:zvals,rlimit:[min(x),max(x)],mask:tempmask,xDat_equals_xRes:0}
    if totnans ne 0 then begin
      void = dialog_message('Your resolution file contains NaN values.  These have been masked, but carefully examine your results.',$
                            title='WARNING: NaN Values Present:',$
                            dialog_parent=self.tlb)
    endif
    ; Is there a data file present?
    ;if n_elements(*self.dataPtr) gt 0 then begin
    ;  ; Yes, stuff the resolution function contents into a structure
    ;  *self.resPtr = resStr
    ;  *self.oresPtr = resStr
    ;endif

    self->interpSigRes, resStr, event = event
    ;LRK 02/02/09
    self->refresh

end;opan::load_group_ascii_res
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::interpSigRes, resStr, rlimit = rlimit, noCrop=noCrop, event = event
    ; This method interpolates the signal and resolution data to the same
    ; x-axis.
    ; RTA - interpolation to the same grid is no longer performed but
    ;       other checks are made.
    ;

    xres = resStr.x
    resData = resStr.data
    
    ;020408
    ;GET THE MASK TOO
    pan_mask = resStr.mask

    rsize = size(resData)
    nrgroups = (rsize[0] eq 2)? rsize[2] : 1

    ;***** Perform this when loading datasets as well!***************
    ; If data is loaded,
    ; Are there the same number of yvalues in the data file and the
    ; resolution function?
    if (n_elements(*self.dataPtr) ne 0) then begin
    ;   data = *self.dataPtr
       dsize = size(*self.dataPtr)
       ndgroups = (dsize[0] eq 2)? dsize[2] : 1
       if nrgroups ne ndgroups then begin
                                    ; They have different sizes so tell user and get out

          msg = ['Signal and resolution dataset groups do not match' $
                 ,'There are '+strtrim(string(ndgroups),2)+' groups in signal dataset' $
                 ,'There are '+strtrim(string(nrgroups),2)+' groups in resolution dataset' $
                 ,'Fits cannot be performed!' $
                 ,'Consider changing the signal OR the resolution data']
          if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
          void = dialog_message(dialog_parent = dparent,msg)
       endif
    endif

    ; make backup copy of resPtr
    (*self.oresPtr) = resStr

    if (keyword_set(noCrop)) then begin
      (*self.resPtr) = resStr
      return
    endif

;print,'ResData[*,0] ='
;print,'resdata[where(resStr.mask[*,0] ne 0),0]='
;print,resdata[where(resStr.mask[*,0] ne 0),0]
    
    ; Restrict resolution data to within the allowed limits specified by
    ; user
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    res = cropXData(xres,resData,rlimit,group_leader = dparent,mask=pan_mask)
    resLimit = res.limits
    i1 = where(xres ge resLimit[0] and xres le reslimit[1],count)
    if count gt 5 then begin
       xres = xres[i1]
       resData = (nrgroups eq 1)? resData[i1] : $
                 resData[i1,*]

       ;020408
       ;UPDATE THE mask BASED ON THE SELECTED RANGE
       pan_mask = (nrgroups eq 1)? pan_mask[i1] : $
                   pan_mask[i1,*]


;print,'THE MASK MUST BE CONSIDERED FOR THE RENORMALIZATION AFTER THE TRUCTATION IN opan::interpSigRes'
;       for i=0,nrgroups-1 do begin
;          ;; B/c of truncation, normalize the res function again
;          resData[*,i] = resData[*,i]/int_tabulated(xres,resData[*,i])
;       endfor;i

        ;020408
        for i=0,nrgroups-1 do begin
           ;; normalize the res function
           whmasked = where(pan_mask[*,i] eq 0,maskcount)
           whnotmasked = where(pan_mask[*,i] ne 0,notmaskcount)

           if notmaskcount eq 0 then begin
              ;ALL DATA ARE MASKED FOR THIS GROUP
              ;DO NOTHING TO THE DATA
           endif else begin
             ;021308
             ;THE ISSUE SEEMS TO BE TAKEN CARE OF HERE.  REGARDLESS OF THE NUMBER OF POINTS
             ;THE WORST THAT SHOULD HAPPEN IN THE NEXT STEP IS THAT SCALE IS 0, WHICH SHOULD
             ;RESULT IN AN INFINITY, BUT NO OTHER PROBLEMS.
             ;print,'opan::interpSigRes --- WHAT HAPPENS IF ALL OF THE POINTS ARE MASKED?????????'
             scale = int_tabulated(xres[whnotmasked],resData[whnotmasked,i])
             resData[whnotmasked,i] = resData[whnotmasked,i]/scale
           endelse
        endfor;i

       (*self.resPtr) = {x:xres,y:resStr.y,data:resdata,rlimit:reslimit,mask:pan_mask,xDat_equals_xRes:0}
    endif else begin
       (*self.resPtr) = resStr
    endelse

    if n_elements(rlimit) eq 0 then begin
       self->refresh
    endif
    return
end;opan::interpSigRes


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::cropRes, event = event
    ; handler used to alter the useful limits of the resolution function
    ; (domain)

    if (n_elements(*self.oresPtr) eq 0 || $
        n_elements(*self.resPtr) eq 0) then begin
       msg = 'Resolution data is not available.'
       msg = [msg,'Please, load one first']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       okay = dialog_message(msg,/info,dialog_parent=dparent)
       return
    endif

    ; get info from original copy of resPtr
    xres = (*self.resPtr).x
    yres = (*self.resPtr).y
    resData = (*self.resPtr).data
    mask = (*Self.resPtr).mask
    rsize = size(resData)
    nrgroups = (rsize[0] eq 2)? rsize[2] : 1

    ; get limit from current copy of resptr
    resLimit = (*self.resPtr).rLimit

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    res = cropXData(xres,resData,reslimit,group_leader = dparent)
    resLimit = res.limits
    xr = (xres.ndim eq 1)? xres : reform(xres[*,0])
    i1 = where(xr ge resLimit[0] and xr le reslimit[1],count)
    if count gt 5 then begin  ;021308  WHY DID THEY CHOOSE 5?
       xres = (nrgroups eq 1)? xres[i1] : xres[i1,*]
       resData = (nrgroups eq 1)? resData[i1] : $
                 resData[i1,*]
       mask = (nrgroups eq 1)? mask[i1] : mask[i1,*]

       for i=0,nrgroups-1 do begin
          ;; B/c of truncation, normalize the res function again
          resData[*,i] = resData[*,i]/int_tabulated(xres[*,i],resData[*,i])
       endfor

       (*self.resPtr) = {x:xres,y:yres,data:resData,rlimit:reslimit,mask:mask,xdat_equals_xres:0}
    endif

    ; refresh display
    ;self->refresh

end;opan::cropRes


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::rebinRes, event = event
    ; handler used to alter the useful limits of the resolution function
    ; (domain)

   

;REBINNING RESOLUTION ELIMINATES THE res MASK, BUT THE USER MUST KNOW
;THAT THEY HAVE TO BE CAREFUL OF THE DATA IF THERE ARE INCOMPLETE RESOLUTION SETS!!!
;

    if (n_elements(*self.oresPtr) eq 0 || $
        n_elements(*self.resPtr) eq 0) then begin
       msg = 'Resolution data is not available.'
       msg = [msg,'Please, load one first']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       okay = dialog_message(msg,/info,dialog_parent=dparent)
       return
    endif

    ; get info from resPtr
    x = (*self.resPtr).x
    ;yres = (*self.oresPtr).y
    qty = (*self.resPtr).data
    ;rsize = size(resData)
    ;nrgroups = (rsize[0] eq 2)? rsize[2] : 1
    err=0.1*qty


;063008
    contentsMasked = self->checkResMasked()

    if contentsMasked gt 0 then begin
      msg = ['There are masked resolution points.',$
             'This may adversely affect your results.',$
             'Continue with rebin?']
      yn = dialog_message(msg,/question)
      if yn eq 'No' then return
    endif



    res = widget_rebin(x,group_leader=event.top,title='Rebin Resolution Data')
    if (res.cancel eq 1) then return


;063008
;FOR MASKED DATA I WILL HAVE TO INTERVENE HERE.  IF NOTHING IS MASKED IT CAN PROCEED AS
;BEFORE.  IF THERE ARE THINGS MASKED, I NEED TO WORK WITH THE CORRECT MASKED x VALUES FOR
;EACH GROUP.
;
;USE function opan::extractOneResStr,val,OneResStr TO GET THE INFORMATION FOR EACH GROUP.
;ZERO OUT ALL THE MASKED STUFF.
;RUN THE CALCULATION OVER THE NEW X VALUES USING DREBIN.

    xmin = min(float(x), max=xmax)
    xmin = res.min > xmin
    xmax = res.max < xmax
    xbin = res.binw

    nx1 = fix((xmax - xmin)/xbin) + 1
    if (nx1 le 5) then begin
       msg = ['New bin settings contains less than 5 points!','Rebinning not performed']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(/info,msg,dialog_parent=dparent)
       return
    endif
    x1 = xmin + findgen(nx1)*xbin

    ; rebin the data
    drebin,x,qty,err,x1,qty1,err1,/points,/to_points,err=ierr,emsg=msg
    if (ierr ne 0) then begin
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(/error,msg,dialog_parent=dparent)
       return
    endif

    ;(*self.resPtr) = {x:x1,y:(*self.resPtr).y,data:qty1,rlimit:[xmin,xmax]}
    (*Self.resPtr).x = x1
    (*Self.resPtr).data = qty1 
    (*Self.resPtr).rlimit = [xmin,xmax]

    ; refresh display
    ;self->refresh

end;opan::rebinRes
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::rebinRes_NEW, event = event
    ; handler used to alter the useful limits of the resolution function
    ; (domain)

   

;REBINNING RESOLUTION ELIMINATES THE res MASK, BUT THE USER MUST KNOW
;THAT THEY HAVE TO BE CAREFUL OF THE DATA IF THERE ARE INCOMPLETE RESOLUTION SETS!!!
;

    if (n_elements(*self.oresPtr) eq 0 || $
        n_elements(*self.resPtr) eq 0) then begin
       msg = 'Resolution data is not available.'
       msg = [msg,'Please, load one first']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       okay = dialog_message(msg,/info,dialog_parent=dparent)
       return
    endif

    

    ; get info from resPtr
    x = (*self.resPtr).x
    ;yres = (*self.oresPtr).y
    qty = (*self.resPtr).data
    ;rsize = size(resData)
    ;nrgroups = (rsize[0] eq 2)? rsize[2] : 1
    err=0.1*qty

;UPDATED THIS METHOD TO HANDLE THE MASKED DATA
;063008
;    contentsMasked = self->checkResMasked()
;
;    if contentsMasked gt 0 then begin
;      msg = ['There are masked resolution points.',$
;             'This may adversely affect your results.',$
;             'Continue with rebin?']
;      yn = dialog_message(msg,/question)
;      if yn eq 'No' then return
;    endif

    xr = (x.ndim eq 1)? x : x[*,0]

    res = widget_rebin(xr,group_leader=event.top,title='Rebin Resolution Data')
    if (res.cancel eq 1) then return


;063008
;FOR MASKED DATA I WILL HAVE TO INTERVENE HERE.  IF NOTHING IS MASKED IT CAN PROCEED AS
;BEFORE.  IF THERE ARE THINGS MASKED, I NEED TO WORK WITH THE CORRECT MASKED x VALUES FOR
;EACH GROUP.
;
;USE function opan::extractOneResStr,val,OneResStr TO GET THE INFORMATION FOR EACH GROUP.
;ZERO OUT ALL THE MASKED STUFF.
;RUN THE CALCULATION OVER THE NEW X VALUES USING DREBIN.

    xmin = min(float(xr), max=xmax)
    xmin = res.min > xmin
    xmax = res.max < xmax
    xbin = res.binw
    
    nx1 = fix((xmax - xmin)/xbin) + 1
    if (nx1 le 5) then begin
       msg = ['New bin settings contains less than 5 points!','Rebinning not performed']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(/info,msg,dialog_parent=dparent)
       return
    endif
    



;102908
;NOW HERE IS THE FIRST REAL CHANGE.  I HAVE TO GET THE DATA GROUP-BY-GROUP AND REBIN IT.
;    ; rebin the data
;    drebin,x,qty,err,x1,qty1,err1,/points,/to_points,err=ierr,emsg=msg
;    if (ierr ne 0) then begin
;       void = dialog_message(/error,msg,dialog_parent=event.top)
;       return
;    endif


;NOTE:  ALL RESOLUTION DATA THIS IS MASKED IS ZEROED AND THE RESMASK IS DISCARDED!!!!!!!!!!!!
;       THEREFORE THE drebin CALL WILL WORK AS IS SINCE drebin HANDLES 2D qty DATA SETS!
    succ = self->extractOneResStr(resSize=resSize)
    if resSize[0] eq 0 then begin
      void = dialog_message('No resolution data loaded.')
      return
    endif
    x1 = xmin + findgen(nx1)*xbin
    drebin,xr,qty,err,x1,qty1,err1,/points,/to_points,err=ierr,emsg=msg
    if (ierr ne 0) then begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       void = dialog_message(/error,msg,dialog_parent=dparent)
       return
    endif

    if (x.ndim eq 2) then begin
      ; expand x to 2D if necessary
      ng = (x.dim)[1]
      x1 = x1#(fltarr(ng)+1)
      
      y1 = ((*Self.resPtr).y)[0:nx1-1,*]
    endif else begin
      y1 = (*Self.resPtr).y
    endelse

    ; store modified data
    ;(*self.resPtr) = {x:x1,y:(*self.resPtr).y,data:qty1,rlimit:[xmin,xmax]}
;    (*Self.resPtr).x = x1
;    (*Self.resPtr).data = qty1 
;    (*Self.resPtr).mask = byte(qty1*0.0 + 1.0)
;    (*Self.resPtr).rlimit = [xmin,xmax]
    (*self.resPtr) = {x:x1 $
                     ,y:y1 $
                     ,data:qty1 $
                     ,rlimit:[xmin,xmax] $
                     ,mask:byte(qty1*0.0 + 1.0) $         ; redo the mask
                     ,xDat_equals_xRes:0}
    ; refresh display
    self->refresh

end;opan::rebinRes_NEW


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Opan::UpdateResInModelFuncs
; whenever the resolution function is modified in any way then
; use this pro to update the resolution info in model function containers as well
; as any functions they may contain

resPtr = self.resptr 
oneresPtr = self.oneresptr

ngroups = N_elements(*self.ocurvegroup)
for i = 0,ngroups-1 do begin
  oc = (*self.ocurvegroup)[i]
  oc->SetResPtr, resPtr, /noCheck
  nFuncs = oc->Count()
  if (nFuncs gt 0) then begin
    oFuncs = oc->Get(/all)
    for j = 0,nFuncs -1 do begin
      oFuncs->GetProperty, twoDimFlag = f2DFlag
      oFuncs[i]->SetProperty, resPtr=(f2DFlag)? resPtr : oneResPtr
    endfor
  endif
endfor

end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::restoreRes, event = event
    ; handler used to alter the useful limits of the resolution function
    ; (domain)

    if (n_elements(*self.oresPtr) eq 0 || $
        n_elements(*self.resPtr) eq 0) then begin
       msg = 'Resolution data is not available.'
       msg = [msg,'Please, load one first']
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       okay = dialog_message(msg,/info,dialog_parent=dparent)
       return
    endif

    ; get info from original copy of resPtr
    (*self.resPtr) = (*self.oresPtr)

    ; refresh display
    ;self->refresh

end;opan::restoreRes


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadDave, event = event

    ;self->initCleanup
    thisPath = self.dataDir;workDir
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                                                  title = 'Select data file to restore',$
                                                  /read,filter = '*.dave',$
                                                  path = thisPath, $
                                                  get_path = myPath)
    if filename eq '' then return

    self->initCleanup

    self.filename = filename
    self.datadir = file_dirname(filename)
    length = strlen(myPath)
    self.printFileName = strmid(filename, length)
    self->stuffDave,event = event

    self->initNewDataObjects, event=event


    ;self->scaleKtable
    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh


    return
end;opan::loadDave
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadgroupdata, event = event
    ;self->initCleanup

    catch,theError
    if theError ne 0 then begin
      catch,/cancel
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent, $
             !error_state.msg+' Returning...')
      return
    endif

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L    
    filename = dialog_pickfile(path = self.dataDir,$;self.workDir,$
               /read, $
               dialog_parent = dparent,filter = '*.txt', $
               get_path = thisPath)

    if filename eq '' then return

    self->initCleanup


    if file_test(filename) then begin
    ; Ok it is a valid filename, but can we read it in here?
       self.dataDir = file_dirname(filename)
       o = obj_new('ascii_data',filename = filename)
       ret = o->read_group_ascii(err = err,emsg = emsg)
       if err eq 1 then obj_destroy,o
    endif else begin
        void = dialog_message('Could not read file:   '+file_basename(filename)+', file not accessible.')
        return
    endelse

    if err eq 1 then begin
        void = dialog_message('Could not read file:   '+file_basename(filename)+', check file format.')
        return
    endif else begin

        ret = o->get_property(xvals = xvals,yvals = yvals, $
           filename = filename,zvals = zvals,dzvals = dzvals)
        obj_destroy,o
        delimiter = path_sep()
        dpos = strpos(filename,delimiter,/reverse_search)
        display_name = strmid(filename,dpos+1)

        nx = n_elements(xvals)
        ny = n_elements(yvals)
        ux = 1+bytarr(nx) & uy = 1+bytarr(ny)

        ;d = opan_readTextGroup(filename)
        ;ux = 1+bytarr(n_elements(d.x))
        ;uy = 1+bytarr(n_elements(d.y))
        ;length = strlen(thisPath)
        self.printFileName = display_name;strmid(filename, length)

        *self.dataPtr = zvals;d.z
        ;CREATE THE MASK POINTER
        ;LRK - 11/24/09
        ;WHAT HAPPENS WHEN THE DATA HAVE NaN's?  MASK THOSE POINTS AND WARN USER.
        tempmask =  byte(0*zvals); + 1b
        whnotnan = where(finite(zvals,/nan) ne 1,whnotnancount)
        if whnotnancount gt 0 then tempmask[whnotnan] = 1b
        if whnotnancount ne n_elements(zvals) then begin
          void = dialog_message('Your data file contains NaN values.  These have been masked, but carefully examine your results.',$
                                title='WARNING: NaN Values Present:',$
                                dialog_parent=self.tlb)
        endif
        
        *self.maskPtr = tempmask
        *self.omaskPtr = tempmask

        *self.errorPtr = dzvals;d.zerr
        *self.xvalsPtr = xvals#uy;(d.x)#uy
        *self.yvalsPtr = ux#yvals;(d.y)
        *self.headerPtr = filename
        self.xtitle = 'x';d.xlabel
        self.ytitle = 'y';d.ylabel
        self.subtitle = ''

        self->initNewDataObjects, event=event

        ;wset,self.datPix
        ;self->displaydata
        ;wset,self.datVis
        ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
        self->refresh
    endelse

    return
end;opan::loadgroupdata
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadgroupdata_old, event = event
    self->initCleanup

    catch,theError
    if theError ne 0 then begin
      catch,/cancel
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent, $
             !error_state.msg+' Returning...')
      return
    endif

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = dialog_pickfile(path = self.workDir,/read, $
               dialog_parent = dparent,filter = '*.txt', $
               get_path = thisPath)

    if filename eq '' then return

    d = opan_readTextGroup(filename)
    ux = 1+bytarr(n_elements(d.x))
    uy = 1+bytarr(n_elements(d.y))
    length = strlen(thisPath)
    self.printFileName = strmid(filename, length)

    *self.dataPtr = d.z
    ;CREATE THE MASK POINTER
    *self.maskPtr = byte(0*d.z) + 1b
    *self.omaskPtr = byte(0*d.z) + 1b

    *self.errorPtr = d.zerr
    *self.xvalsPtr = (d.x)#uy
    *self.yvalsPtr = ux#(d.y)
    *self.headerPtr = filename
    self.xtitle = d.xlabel
    self.ytitle = d.ylabel
    self.subtitle = ''
    self->initNewDataObjects, event=event

    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::loadgroupdata_old
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;pro opan::loadfcsdata, event = event
;    self->initCleanup
;
;    catch,theError
;    if theError ne 0 then begin
;      catch,/cancel
;      void = dialog_message(dialog_parent = event.top, $
;             !error_state.msg+' Returning...')
;      return
;    endif
;
;    filename = dialog_pickfile(path = self.workDir,/read, $
;               dialog_parent = event.top,filter = '*.xy', $
;               get_path = thisPath)
;
;    if filename eq '' then return
;
;    read_fcs_xy,filename,e,q,qty,err
;    nx = n_elements(e)
;    ny = n_elements(q)
;    ux = 1+bytarr(nx)
;    uy = 1+bytarr(ny)
;
;    ;d = opan_readTextGroup(filename)
;    length = strlen(thisPath)
;    self.printFileName = strmid(filename, length)
;
;    *self.dataPtr = qty
;    ;CREATE THE MASK POINTER
;    *self.maskPtr = byte(0*qty) + 1b
;    *self.omaskPtr = byte(0*qty) + 1b
;
;    *self.errorPtr = 0.1*qty;err
;    *self.xvalsPtr = e
;    *self.yvalsPtr = ux#q
;    *self.headerPtr = filename
;    self.xtitle = 'E (meV)'
;    self.ytitle = 'Intensity (arb units)'
;    self->initNewDataObjects, event=event
;
;    ;wset,self.datPix
;    ;self->displaydata
;    ;wset,self.datVis
;    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
;    self->refresh
;
;    return
;end;opan::loadfcsdata
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadasciidata, event = event

    ;self->initCleanup

    catch,theError
    if theError ne 0 then begin
      catch,/cancel
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent, $
             !error_state.msg+' Returning...')
      return
    endif

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L    
    filename = dialog_pickfile(path = self.dataDir,$;workDir,$
               /read, $
               dialog_parent = dparent,filter = '*.txt', $
               get_path = thisPath)
    if filename eq '' then return

    self->initCleanup

    if file_test(filename) then begin
    ; Ok it is a valid filename, but can we read it in here?
       self.dataDir = file_dirname(filename)
       o = obj_new('ascii_data',filename = filename)
       ret = o->read_three_column_ascii(err = err,emsg = emsg)
       if err eq 1 then obj_destroy,o
    endif else begin
        void = dialog_message('Could not read file:   '+file_basename(filename)+', file not accessible.')
        return
    endelse

    if err eq 1 then begin
        void = dialog_message('Could not read file:   '+file_basename(filename)+', check file format.')
        return
    endif else begin
        ret = o->get_property(xvals = xvals, $
           filename = filename,zvals = zvals,dzvals = dzvals)
        obj_destroy,o
        delimiter = path_sep()
        dpos = strpos(filename,delimiter,/reverse_search)
        display_name = strmid(filename,dpos+1)

        nx = n_elements(xvals)
        ux = 1+bytarr(nx)
        self.printFileName = display_name
        *self.dataPtr = zvals
        ;CREATE THE MASK POINTER
        *self.maskPtr = byte(0*zvals) + 1b
        *self.omaskPtr = byte(0*zvals) + 1b

        *self.errorPtr = dzvals
        *self.xvalsPtr = xvals
        *self.yvalsPtr = 0.0
        *self.headerPtr = filename

        self.xtitle = 'x'
        self.ytitle = 'y'
        self.subtitle = ''
        self->initNewDataObjects, event=event
        ;wset,self.datPix
        ;self->displaydata
        ;wset,self.datVis
        ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
        self->refresh
    endelse

    return
end;opan::loadasciidata
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadtasdata, event = event
    self->initCleanup
    ; Which browser should we run?
    if (!version).release lt 5.6 then begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       filenames = dialog_pickfile(path = self.workDir,/read, $
               dialog_parent = dparent,/multiple_files,get_path = thisPath)
       if filenames[0] eq '' then return
       self.dataPath = thisPath
       nfiles = n_elements(filenames)
       if nfiles ge 21 then begin
       strout = ["Maximum number of files to open at once is 20.", $
                   "Opening the first 20 files you have selected..."]
        void = dialog_message(dialog_parent = dparent,strout)
       filenames = filenames[0:19]
       endif

       *self.tasfilePtr = filenames
       *self.tasPathPtr = thisPath
       dout = panReadMultTAS(*self.tasPathPtr,filenames,group_leader = dparent)
    endif else begin
       if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
       dout = tas_viewer(group_leader = dparent)
    endelse

    help,dout,output = output
    if (strpos(output,'LONG'))[0] ne (-1) then return
    x = dout.x
    if n_elements(x) eq 1 then begin
      output = 'Data must contain more than one point!'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      
      void = dialog_message(dialog_parent = dparent,output)
      return
    endif

    ; ok...now pull out the single filename
    length = strlen(self.dataPath)
    self.printFileName = strmid(dout.filesel, length)

    y = 0.0
    data = dout.y
    if (!version).release ge 5.6 then error = dout.yerr $
       else    $
       error = sqrt(dout.y)
    self.filename = dout.filesel
    ; For zero counts, force the error to 1
    zeros = where(error eq 0.,countZ)
    if countZ gt 0 then error[zeros] = 1.0

    self.autoscale = 1
    *self.dataPtr = data
    ;CREATE THE MASK POINTER
    *self.maskPtr = byte(0*data) + 1b
    *self.omaskPtr = byte(0*data) + 1b
    *self.errorPtr = error
    *self.xvalsPtr = x
    *self.yvalsPtr = y
    *self.headerPtr = dout.header
    self.xtitle = dout.xlabel
    self.ytitle = dout.ylabel
    self.ztitle = self.ytitle
    self.subtitle = ''

    (*self.prefs).xlabel = self.xtitle
    (*self.prefs).ylabel = self.ztitle
    (*self.prefs).subtitle = self.subtitle

    self->initNewDataObjects, event=event

    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::loadtasdata
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadtasdatafromprevious, event = event
    self->initCleanup

    if n_elements(*self.tasfileptr) ne 0 then begin
      filenames = *self.tasfilePtr
    endif else begin
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      filenames = dialog_pickfile(path = self.workDir,/read, $
                  dialog_parent = dparent,/multiple_files,get_path = thisPath)
      if filenames[0] eq '' then return
      *self.taspathptr = thispath
      self.dataPath = thisPath
    endelse

    nfiles = n_elements(filenames)
    if nfiles ge 21 then begin
      strout = ["Hello Jeff Lynn....", $
                "Please don't load so many files.", $
                "My limit is 20 files at once.", $
                "Are you trying to crash me?"]
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif

    *self.tasFilePtr = filenames
    
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    dout = panReadMultTAS(*self.tasPathPtr,filenames,group_leader = dparent)
    help,dout,output = output
    if (strpos(output,'LONG'))[0] ne (-1) then return

    x = dout.x
    if n_elements(x) eq 1 then begin
      output = 'Data must contain more than one point!'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,output)
      return
    endif

    ; ok...now pull out the single filename
    length = strlen(self.dataPath)
    self.printFileName = strmid(dout.filesel, length)

    y = 0.0
    data = dout.y
    error = sqrt(dout.y)
    self.filename = dout.filesel
    ; For zero counts, force the error to 1
    zeros = where(error eq 0.,countZ)
    if countZ gt 0 then error[zeros] = 1.0

    self.autoscale = 1
    *self.dataPtr = data
    ;CREATE THE MASK POINTER
    *self.maskPtr = byte(0*data) + 1b
    *self.omaskPtr = byte(0*data) + 1b

    *self.errorPtr = error
    *self.xvalsPtr = x
    *self.yvalsPtr = y
    *self.headerPtr = dout.header
    self.xtitle = dout.xlabel
    self.ytitle = dout.ylabel
    self.subtitle = ''
    self->initNewDataObjects, event=event

    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::loadtasdatafromprevious
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadtestdata, event = event
    self->initCleanup, event=event
    ; Create some fake data
    nchan = 170
    x = rmd_makepoints(xlo = -12d,xhi = 12d,npts = nchan)
    ux = 1+bytarr(nchan)

    nq = 20

    q = rmd_makepoints(xlo = 0.25,xhi = 1.75,npts = nq)
    ro = 1.73
    ;ao = (5.0+4.0*beselj(q*ro,0))/9.0
    ;ao = (5.0+4.0*Beselj(q*ro,0))/9.0
    ao = (5.0+4.0*Sph_bessel(q*ro*sqrt(3),0))/9.0
    uq = 1+bytarr(nq)

    ; NB - the large value of the area is significant because the
    ; poisson keyword to randomu works better when the value is large!
    ; A small value does not produce good poisson statistics!
    area = 4500.0 & bg = 0.05*area
    yy = bg   + (pan_gaussian(x,[area,0d,1.0]))#ao + $
            0.5*(pan_lorentzian(x,[5.0*area,-3d,2d]))#(1.0-ao) + $
            0.5*(pan_lorentzian(x,[5.0*area,3d,2d]))#(1.0-ao)
    datmat = yy
    y = dblarr(nchan,nq)
    for j = 0,nq-1 do begin
      for i = 0,nchan-1 do begin
        y[i,j] = randomn(s,1,poisson = datmat[i,j])
      endfor
    endfor
    yerr = sqrt(y)
    

    ; Now create a matrix out of all of the data variables
    xmat = x#uq
    ymat = ux#q
    data = y
    error = yerr
    bigNum = 1.e7
    self.printFileName = 'testdata.txt'
    self.filename = 'testdata.txt'

    *self.dataPtr = data/area
    *self.errorPtr = error/area
    *self.xvalsPtr = xmat
    *self.yvalsPtr = ymat
    *self.maskptr = bytarr(nchan,nq) + 1b
    *self.omaskptr = bytarr(nchan,nq) + 1b

    *self.headerPtr = ['Test data for demonstration purposes',$
                       'Simulated rotational tunneling for a methyl group molecule', $
                       'Consisting of a Gaussian and two Lorentzian satellite peaks', $
                       'S(Q,E) = EISF*d(E) + 0.5*(1-EISF)( d(E-Et) + d(E+Et) )', $
                       'So the peak intensities are modulated by the elastic incoherent structure factor (EISF)', $
                        'which is defined as', $
                       'EISF = (5.0+4.0*jo(Q*ro*sqrt(3),0))/9.0 ', $
                       'where:',$
                       'jo is the zeroth-order spherical Bessel function of the first kind', $ 
                       'They are sometimes also called cylinder functions or cylindrical harmonics', $
                       'They are defined as the solutions to the Bessel differential equation: x^2dy^2/dx^2 + xdy/dx + (x2-n2)y = 0', $
                       'Q is momentum transfer', $
                       'ro is molecular radius set to 1.73 Angstrom here', $
                       'Et is the magnitude of the tunneling energy set to 3 ueV here']
    self.xtitle = '!6E (!4l!6eV)'
    self.ytitle = 'Q'
    self.ztitle = '!6Intensity (arb units)'
    self.title = '!6Neutron Spectrum'
    Self.xunits = 'ueV'
    self.subtitle = ''
    (*self.prefs).xlabel = self.xtitle
    (*self.prefs).ylabel = self.ztitle
    (*self.prefs).subtitle = self.subtitle
    self->initNewDataObjects, event=event
    ;;self->scaleKtable
    ;wset,self.datPix
    ;self->displaydata
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh, event=event

    return
end;opan::loadtestdata

pro Opan::loadtestdata2, event = event
  self->Initcleanup, event=event
  ; Create some fake data
  nchan = 301
  x = Rmd_makepoints(xlo = 0.0,xhi = 600.0,npts = nchan)
  ux = 1+Bytarr(nchan)
  nq = 20
  q = Rmd_makepoints(xlo = 10.0,xhi = 30.0,npts = nq)
  uq = 1+Bytarr(nq)

  ; NB - the large value of the area is significant because the
  ; poisson keyword to randomn works better when the value is large!
  ; A small value does not produce good poisson statistics!
  area = 45000.0 & bg = 0.005*area
  xmat = x#uq
  ymat = ux#q
  fwhm0 = 1.5
  data = fltarr(nchan,nq)
  error = data
  for j = 0, nq-1 do begin
    data[*,j] = bg*randomu(seed1) + pan_gaussian(x,[area,0.522*q[j]^2,fwhm0*q[j]])
    for i = 0,nchan-1 do begin
      data[i,j] = randomn(s,1,poisson = data[i,j])
    endfor
  endfor
  ;index = where(error le 0.0, cnt)
  ;if (cnt gt 0) then error[index] = 1.0
  error = Sqrt(data)

  ; Now create a matrix out of all of the data variables
  bigNum = 1.e7
  self.printfilename = 'testdata2.txt'
  self.filename = 'testdata2.txt'

  *self.dataPtr = data/area
  *self.errorPtr = error/area
  *self.xvalsPtr = xmat
  *self.yvalsPtr = ymat
  *self.maskptr = bytarr(nchan,nq) + 1b
  *self.omaskptr = bytarr(nchan,nq) + 1b


  *self.headerptr = ['Test data for demonstration purposes',$
    'Simulated recoil scattering in the Impulse Approximation', $
    'Essentially a Gaussian with Q-dep width', $
    'and peak position proportional to Q^2']
  self.xtitle = 'E (meV)'
  self.ytitle = 'Q'
  self.ztitle = '!6Intensity (arb units)'
  self.title = '!6Neutron Spectrum'
  Self.xunits = 'meV'
  self.subtitle = ''
  (*self.prefs).xlabel = self.xtitle
  (*self.prefs).ylabel = self.ztitle
  (*self.prefs).subtitle = self.subtitle
  self->Initnewdataobjects, event=event
  self->Refresh, event=event

  Return
end;opan::loadtestdata


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::loadtestres, event = event
    ; Create some fake data
    nchan = 170
    x = rmd_makepoints(xlo = -12d,xhi = 12d,npts = nchan)
    ux = 1+bytarr(nchan)

    nq = 20

    q = rmd_makepoints(xlo = 0.25,xhi = 1.75,npts = nq)
    ro = 1.73
    ao = 0.5*(1.0+beselj(q*ro,0))
    uq = 1+bytarr(nq)

    ;area = 4500.0 & bg = 0.05*area
    ;res = rmd_gaussian(x,area = 1d,center = 0d,width = 1d)
    ;resPtr = ptr_new(res,/no_copy)
    area = 1.0 & bg = 0.0
    yy = bg   + (pan_gaussian(x,[area,0d,1.0]))#ao

;    datmat = yy
;
;    y = dblarr(nchan,nq)
;    for j = 0,nq-1 do begin
;      for i = 0,nchan-1 do begin
;        y[i,j] = randomn(s,1,poisson = datmat[i,j])
;      endfor
;    endfor
    yerr = sqrt(yy)
    index = where(yerr le 0.0, cnt)
    if (cnt gt 0) then yerr[index] = 1.0

    ; Now create a matrix out of all of the data variables
    ;xmat = x#uq
    ;ymat = ux#q
    ;data = yy
    yerror = yerr


    ;resStr = {x:xmat,y:ymat,data:data}
    resStr = {x:x,y:q,data:yy,rlimit:[min(x),max(x)],mask:byte(0*yy)+1b,xDat_equals_xRes:0}

    ;*self.resPtr = resStr

    self->interpSigRes, resStr, event = event

    return
end;opan::loadtestres
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro pan_iterproc,fnc,p,iter,fnorm,dof = dof, stopBut = stopBut,_Extra = extra
    if n_elements(stopBut) eq 0 then return
    if widget_info(stopBut,/valid_id) eq 0 then return
    event = widget_event(/nowait,stopBut)
    evname = tag_names(event,/structure_name)
    if evname eq '' or event.id eq 0 then return

    if evname eq 'WIDGET_BUTTON' and event.select then begin
      event1 = widget_event(/nowait,stopBut)
      common mpfit_error,mperr
      mperr = -1
    endif

    return
end;pan_iterproc
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro pan_iterproc_epsde, stopBut = stopBut, interrupt=interrupt, _Extra = extra
    interrupt = 0
    if n_elements(stopBut) eq 0 then return
    if widget_info(stopBut,/valid_id) eq 0 then return
    event = widget_event(/nowait,stopBut)
    evname = tag_names(event,/structure_name)
    if evname eq '' or event.id eq 0 then return

    if evname eq 'WIDGET_BUTTON' and event.select then begin
      event1 = widget_event(/nowait,stopBut)
      interrupt=1
      print,'Interupt button pressed!'
    endif

    return
end;pan_iterproc


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::fitOneGroup, event = event, noprogressbar=noprogressbar
; This method uses Craig Markwardt's suggestion for a curve-fit interrupt.
; This method is for single group fitting only.

if n_elements(noprogressbar) eq 0 then noprogressbar = 0

; If resolution is loaded then check if nos of groups is the same for
; resolution and signal datasets
if (n_elements(*self.resPtr) gt 0) then begin
   dSize = size(*self.dataPtr)
   nd = (dSize[0] eq 2)? dSize[2] : 1
   rSize = size((*self.resPtr).data)
   nr = (rSize[0] eq 2)? rSize[2] : 1
   if (nr ne nd) then begin
      msg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Consider changing the signal OR the resolution data' $
             ,'Fits will not be performed!' ]
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,msg,/error)
      return                    ; exit
   endif
endif

; Current group selection
widget_control,self.groupSlider,get_value = val
val = fix(val[0])-1
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0

; Groups to fit Selection
Widget_control,self.groupfield,get_value = groupString
groupString = groupString[0]
groupsToBeFitted = Opan_selectgroups(groupString)
*self.grparrayptr = groupsToBeFitted

;; if 1D function => fitting each group at a time,
;; ensure the current group selection is amongst the groups to be fitted
;if (Self.twodimflag eq 0) then begin
;  if (~groupsToBeFitted.hasValue(val)) then begin
;    
;  endif
;endif

modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oc = (*self.ocurvegroup)[modelIndex]
if oc->count() eq 0 then return

;NOTE:  NAMES y AND yerr ARE GOING TO CONFLICT WRT KWD NAMES.
;       PERHAPS I SHOULD HAVE INDIVIDUAL METHODS FOR X,Y,YERR,DAT, DATSIZE, ETC. THAT CALL
;       THE MAIN extractDataForPAN METHOD WITH THE MORE CRYPTIC KEYWORDS.
parms = oc->getparms()
parinfo = oc->createParInfo()

self->extractDataForPAN,dat=y,derr=yerr, panmask=panmask, $
                        x=x,$;,y=y,erry=yerr,
                        val=val,dSize=datSize
widget_control,self.fitstatfield,set_value = self.fitstatus[1]
widget_control,self.interrupt,sensitive = 1
widget_control,self.interrupt,/clear_events

; Try to fit it...
w = 1.0/yerr^2
limits = where((x ge (*self.prefs).xfitlo) and (x le (*self.prefs).xfithi))
xlim = x[limits]
ylim = y[limits]
wlim = w[limits]
; 12/20/2005 - EAB
; Problem: when given an error of 0 (most likely due to zero counts at a given point),
; the resulting weight comes out as infinity (1 divided by zero = "oh noes")
; Solution: As referenced by "Numerical Recipes in Fortran 77", 2nd Edition, Volume 1,
; Chapter 15 (page 658) - we are setting the weight to unity (1)
; thereby eliminating the problems with our curve fitter being given a non-number
fixers = Where(Finite(wlim) ne 1,fixerscount)
if fixerscount gt 0 then wlim[fixers] = 1

;;RTA- Restrict the domain of the funtions to the x fit range only!
xptr = ptr_new(xlim)
oc->setXValues,xlim

if (Self.twodimflag) then begin
  self->Extractdataforpan,allData=allData,allx=allx,ally=ally,panmask=panmask,allError=allError
  limits = where((allx ge (*self.prefs).xfitlo) and (allx le (*self.prefs).xfithi))
  xlim = allx[limits]
  xptr = Ptr_new(xlim)
  oc->Setxvalues,xlim ;- Restrict the domain of the funtions to the x fit range only!
  ylim = allData[limits,*]
  wlim = allError[limits,*]
  panmask = panmask[limits,*]
  wlim = 1.0/wlim^2
  fixers = Where(Finite(wlim) ne 1,fixerscount)
  if fixerscount ne 0 then wlim[fixers] = 1
  
  ; convert to a vector and elliminate masked points for the
  ; data and errors (weights) only but NOT the independent var
  voidMask = Reform(panmask, N_elements(panmask))
  ylim = Reform(ylim, N_elements(ylim), /overwrite)
  index = Where(voidMask eq 1, count)
  if (count gt 0) then begin
    ylim = ylim[index]
    wlim = wlim[index]
  endif

endif 


; If there is a resolution function present then use it!
resExists = self->Extractoneresstr(val,OneResStr)
eps = 0.001
if (resExists) then begin
  xDat_equals_xRes = Array_equal(xlim,OneResStr.x) ; is x the same for data and res?
  if (xDat_equals_xRes) then begin
    n = N_elements(xlim)
    binW1 = Abs(xlim[0] - xlim[1])
    tol = eps*binW1
    xDat_equals_xRes = (Abs(xlim[0] + xlim[n-1]) le tol)? 1 : 0 ; is xrange symmetric about 0.0 within tol
    xbins = (xlim[1:n-1] - xlim[0:n-2])/binW1
    void = Where(Abs(xbins - 1.0) le eps, cnt)
    if (xDat_equals_xRes) then xDat_equals_xRes = (cnt eq N_elements(xbins))? 1 : 0  ; are the bins uniform?
  endif

  xDat_equals_xRes = xDat_equals_xRes && (*self.prefs).allowApproxConv ; Allow for user setting for using approximate convolution
  OneResStr.xDat_equals_xRes = xDat_equals_xRes
  (*self.oneResPtr) = OneResStr
  (*Self.resPtr).xDat_equals_xRes = xDat_equals_xRes
  rlimit=OneResStr.rlimit
  ;Print, 'Approx convolution used? (1=yes, 0=no): ',xDat_equals_xRes

endif else begin
  self->Clearoneres_ptr
endelse

iterargs = {stopBut:self.interrupt}
iterProc = 'pan_iterproc'
iterProc_epsde = 'pan_iterproc_epsde'

if noprogressbar eq 0 then begin
  ;LRK - 060910
  prog = nse_cwo_progress(labels=['Fit:'],$
                         startvalues=[1L],$
                         endvalues=[1L],$
                         values=[1L],$
                         steps=[1L],$
                         obj=progobj,$
                         title='PAN Fit Progress:   ',$
                         /nostop,$
                         dialog_parent=self.tlb)
  self.progressBar = prog

endif

;Jason Simmons noticed that the eb in some fit parameters will end up as zero.  Is this a float v. double issue in the calculation????
;quiet = 0
;print,'(*self.prefs).maxIter=',(*self.prefs).maxIter
;020708
;UPDATE THE NEXT LINE:
; 
;if n_elements(*self.resPtr) eq 0 then begin
to = systime(/seconds)
functargs = (n_elements(*self.resPtr) eq 0)? {oc:oc,xPtr:xPtr,panmask:panmask,groupsToBeFitted:groupsToBeFitted} : $
                                             {oc:oc,xPtr:xPtr,resPtr:self.oneResPtr,rlimit:rlimit,panmask:panmask,groupsToBeFitted:groupsToBeFitted}
Self.oepsde->Getproperty, enableFlag=performDEfit

if (performDEfit) then begin
  ; Perform Diff Evo fit
  yError = sqrt(1/wlim) ; use data errors instead of weights
  
  parmInfo = self->PackageParmInfo()
  pMin = parmInfo.lovalues
  pMax = parmInfo.hivalues
  pIni = parmInfo.parms
  low = parmInfo.low
  high = parmInfo.high
  pfixed = parminfo.FIXED
  
  minIndex = where((low eq 0 ) and (pMin eq 0.0 or pIni le pMin), badminCnt)   
  if (badminCnt gt 0) then begin
    pdelta = abs(pIni[minIndex])* 0.75
    pMin[minIndex] = pIni[minIndex] - pdelta
    oc->SetLowValues,pMin
    parmInfo.low = 1
    oc->SetLow,parmInfo.low
  endif
  
  maxIndex = where((high eq 0) and (pMax eq 0.0 or pIni ge pMax), badmaxCnt)    
  if (badmaxCnt gt 0) then begin
    pdelta = abs(pIni[maxIndex])* 0.75
    pMax[maxIndex] = pIni[maxIndex] + pdelta
    oc->Sethighvalues,pMax
    parmInfo.high = 1
    oc->SetHigh, parmInfo.high
  endif
  
  fixedIndex = where(pFixed eq 1,nFixed)
  if (nFixed gt 0) then begin
    pMin[fixedIndex] = pIni[fixedIndex]
    pMax[fixedIndex] = pIni[fixedIndex]
  endif
      
  Self.oEPSDE->SetProperty, xData=xlim, yData=ylim, yError=yError $
                          , pMin=pMin, pMax=pMax, pTied=parmInfo.tied $
                          , fitFuncName='fitfunction', fitFuncArgs=functargs $
                          , iterProc=iterProc_epsde, iterArgs=iterArgs
  
  status = Self.oEPSDE->Fit()
  
  Self.oEPSDE->GetProperty, initparam=p0, bestparam=bestP, bestfvalue=chisq, generationCnt=genCnt, bestParError=bestParError
  
  oc->setparms,bestP
  oc->setparmError,bestParError
  oc->Setchisq,chisq
  void = oc->Updatemodtime()
endif else begin
  yf = Mpcurvefit(xlim, ylim, wlim, parms, sigma, $
    FUNCTION_NAME='fitfunction', $
    status = status, $
    quiet = 1,$
    itmax = (*self.prefs).maxiter, $
    chisq = chisq, $
    parinfo = parinfo, $
    functargs = functargs,$
    iterargs = iterargs, $
    iterProc = iterProc, $
    /autoderivative, $
    covar = covar,   $
    ERRMSG=errmsg)

  if N_elements(sigma) gt 0 then oc->Setparmerror,sigma
  dof = N_elements(xlim)-N_elements(parms)
  chi_reduced = chisq/dof
  oc->Setchisq,chi_reduced
  ; calculate the correlation matrix
  PCOR = COVAR * 0
  FOR i = 0, N_elements(parms)-1 DO FOR j = 0, N_elements(parms)-1 DO $
    PCOR(i,j) = COVAR(i,j)/Sqrt(COVAR(i,i)*COVAR(j,j))
  oc->Set_pcor,pcor
  void = oc->UpdateModTime()

endelse

print,'Fit time=',systime(/seconds)-to

oc->setXValues,x ; undo the restricted domain



;help,self.oneResPtr,/traceback
ptr_free,xPtr
widget_control,self.interrupt,sensitive = 0
widget_control,self.fitstatfield,set_value = self.fitstatus[0]
widget_control,self.interrupt,/clear_events
if status le 0 then begin
  self.status = 0
  strout = 'Fit cancelled'
  widget_control,self.fitStatField,set_value = strout
  ;LRK 060910
  if widget_info(self.progressBar,/valid) gt 0 then widget_control,self.progressBar,/destroy
  self.progressBar = 0L
    
  return
endif else begin
  self.status = 1
endelse


;;;;;;;;;;;;;;;;;;;;;;
; 7/1/2015  RTA
; By setting xDat_equals_xRes to 0, we are ensuring that convolute() is used instead of rmd_colvol()
; when functions are being evaluated for display purposes. This is because rmd_convol() is an approximation
; that has strict requirements on the x values of the model and resolution. when data is being plotted,
; the x values are increased in order to generate a smooth function and this will result in a problem if
; such a smooth function is convoluted with a resolution because the x values of the function and resolution 
; will be different!
if (n_elements(*Self.resPtr) gt 0) then (*Self.resPtr).xDat_equals_xRes = 0


; Plot the new fit with the data and plot the residuals
self->refresh

; Display the parameters
self->displayFitParameters

if noprogressbar eq 0 then begin

  ;UPDATE COUNTER AND PROGRESS WIDGET
  if obj_valid(progobj) gt 0 then begin
    progobj->set,0,1
  endif
  ;LRK - 060910
  if widget_info(self.progressBar,/valid) gt 0 then widget_control,self.progressBar,/destroy
  self.progressBar = 0L

endif;noprogressbar eq 0

return

end;opan::fitOneGroup


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro PAN_QuickOverplot_event,event
  widget_control,event.handler,get_uvalue=pstate
  
  ;print,'PAN_QuickOverplot_event'
  ;help,event,/struct
  
  if event.id eq (*pstate).quit then widget_control,event.handler,/destroy

end;PAN_QuickOverplot_event
pro PAN_QuickOverplot_cleanup,id
  ;print,'PAN_QuickOverplot_cleanup'
  widget_control,id,get_uvalue=pstate
  if ptr_valid(pstate) gt 0 then ptr_free,pstate

end;PAN_QuickOverplot_event

pro opan::quickOverplot,plotwid,plotobj,_extra=extra  

  help,extra,/struct

  if n_elements(*self.dataPtr) eq 0 then begin
    void = dialog_message('No data loaded.',dialog_parent=self.tlb,title='PAN_QuickOverplot:',/info)
    return    
  endif

  if obj_valid(self.quickPlotObj) le 0 then begin

    ;CREATE THE WIDGET
    tlb = widget_base(xoffset=1600,group_leader=self.tlb,mbar=bar,title='PAN: Quick Overplot')
    file = widget_button(bar,value='File',/menu)
    quit = widget_button(file,value='Quit')
    widget_control,tlb,/realize
    state = {tlb:tlb,quit:quit}
    pstate = ptr_new(state)
    widget_control,tlb,set_uvalue=pstate
    
    d=cwo_drawplot(tlb,xsize=600,ysize=400,obj=o,title='PAN Groups')
    if obj_valid(o) then self.quickPlotObj = o
   
    xmanager,'PAN_QuickOverplot',tlb,/no_block,event_handler='PAN_QuickOverplot_event'
    ;self.plotwid = p
    
    
  endif;self.quickPlotObj
  o = self.quickPlotObj
  o->clearData
  

  ;LOAD THE DATA
        fitObject = *self.ocurveGroup
        ngroups = n_elements(fitObject)

        for i = 0L,ngroups-1 do begin
          oc = fitObject[i]
          oall = oc->get(/all)
          ncurves = oc->count()

          self->extractDataForPAN,dat=dat,derr=daterr,x=x,group=i+1,val=val
          nx = n_elements(x)
          otemp = obj_new('cwo_drawplot_data',x,dat,daterr,color=i*1200L,$;linestyle=-1,$
                          legend='Group '+strtrim(string(i+1),2),/showlegend,$
                          psym = 2)
          o->add,otemp,/rescale

          if ncurves gt 0 then begin

           ;020708
           ;ADD THE NEXT BLOCK TO REPLACE THE ONE BELOW IT (TO HANDLE RES MASKING)
           resExists = self->ExtractOneResStr(val,OneResStr)

           if resExists ne 0 then begin
             (*self.oneResPtr) = OneResStr
             rlimit=OneResStr.rlimit

              ;081908
              ;FIRST RESET THE X VALUES
              oc->setxvalues,x,resPtr = self.oneResPtr,rlimit = rlimit
              oc->evaluate,x,yout = yfit,resPtr = self.oneResPtr,rlimit = rlimit
           endif else begin
             self->clearOneRes_ptr

            ;081908
            ;FIRST RESET THE X VALUES
            oc->setxvalues,x

            ;ORIGINAL
            oc->evaluate,x,yout = yfit
           endelse

           if n_elements(yfit) gt 0 then begin
             o->add,x=x,y=yfit,color=i*532L,linestyle=1
           endif
        endif;ncurves
      endfor;i
      o->defaultDraw
    ;endif;self.dataptr
    return


end;opan::quickOverplot


pro opan::fitAllGroups, event = event

if (Self.twodimflag) then begin
  ; For 2D functions, only one global fit is performed to take care of all groups.
  Self->Fitonegroup, event=event
  return
endif
 
; If resolution is loaded then check if nos of groups is the same for
; resolution and signal datasets
if (n_elements(*self.resPtr) gt 0) then begin
   dSize = size(*self.dataPtr)
   nd = (dSize[0] eq 2)? dSize[2] : 1
   rSize = size((*self.resPtr).data)
   nr = (rSize[0] eq 2)? rSize[2] : 1
   if (nr ne nd) then begin
      msg = ['Signal and resolution dataset groups do not match' $
             ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
             ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
             ,'Consider changing the signal OR the resolution data' $
             ,'Fits will not be performed!' ]
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,msg,/error)
      return                    ; exit
   endif
endif


; Which groups do we want to fit?
if n_elements(*self.dataPtr) eq 0 then return
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then nq = 1 else nq = datSize[2]

widget_control,self.groupField,get_value = groupString
groupString = groupString[0]
groupsToBeFitted = opan_selectgroups(groupString)
*self.grpArrayPtr = groupsToBeFitted

; Will we be using the same parameters for all of the groups?
if (*self.prefs).same eq 1 then begin
  ; Which of the current groups has the most recently modified model?
  goodindex = 0
  oModels = (*self.ocurveGroup)
  modTime0 = oModels[0]->GetModTime()
  for i=0,nq-1 do begin
    if (oModels[i]->GetModTime() gt modTime0) then begin
      modTime0 = oModels[i]->GetModTime()
      goodIndex=i
    endif
  endfor
  oRefModel = oModels[goodIndex]

  nindex = n_elements(groupsToBeFitted)
  prog = nse_cwo_progress(labels=['Fit:'],$
                         startvalues=[1L],$
                         endvalues=[long(nindex)],$
                         values=[1L],$
                         steps=[1L],$
                         obj=progobj,$
                         title='PAN Fit Progress:   ',$
                         /nostop,$
                         dialog_parent=self.tlb)
  self.progressBar = prog

  for i = 0,nindex-1 do begin
    ind = groupsToBeFitted[i]-1
    if (ind ne goodIndex) then begin
      ;oRefModel IS THE FIRST GROUP AMONG THOSE TO BE FITTED THAT is to be used as the base for the rest
      ;(DETERMINED ABOVE)    
      ;oall IS THE ARRAY OF ALL THE CURVES IN THE GROUP.  (ONE CURVE IS A "FUNC" OBJECT)
      oFuncs = oRefModel->get(/all) ; oRefModel is an instance of the FUNC_CONT object class.
                  ; oFuncs is an array of FUNC object references.
      nCurves = oRefModel->count()
      
      ; Remove any existing objects in oc and destroy them
      curModel = (*self.ocurveGroup)[ind]
      expiredFuncs = curModel->get(/all)
      nold = curModel->count()
      if nold gt 0 then begin
        curModel->remove,/all         ; remove the expired functions from the model container
        obj_destroy, expiredFuncs     ; and destroy them
        ;for k = 0,nold-1 do begin
        ;  obj_destroy,expiredFuncs[k]
        ;endfor;k
      endif;nold gt 0

      ;040607
      ;LRK
      ;THIS IS WHERE THE Qvalue IS RETRIEVED AND INPUT INTO THE CURVE GROUPS FOR opan::fitAllGroups
      ;ALSO, SAVE EACH GROUP'S XVALUES SINCE THEY MAY BE UNIQUE FOR EACH GROUP WITH THE ADDITION OF MASKING. 042507 - LRK
      self->extractDataForPAN,y=qvalues,group=ind+1,x=xvaluestemp ;group is a 1 based index
      qvalue=qvalues[0]
      groupNumber = ind+1 ;LRK - 06/10/10

      for j = 0,nCurves-1 do begin  
        ;DON'T GET qvalue FROM (*self.ocurveGroup)[goodIndex],
        ;GET THEM FROM THE CURRENT GROUP.

        ; Now extract the curve information
        func_dataHash = !null
        oFuncs[j]->getproperty,name = name, $
                            xvalues = xvalues, $
                            func_dataHash = func_dataHash, $
                            step = step, $
                            parms = parms, $
                            fixed = fixed, $
                            fixvalues = fixvalues, $
                            fit_fun_filename = fit_fun_filename,    $
                            low = low, $
                            lovalues = lovalues, $
                            high = high, $
                            hivalues = hivalues, $
                            tied = tied, $
                            parmError = parmError, $
                            expr = expr, $
                            resolutionRequiredFlag=resolutionRequiredFlag, $ ; is instrumental resolution part of the function definition?
                            extConvolFlag=extConvolFlag, $                   ; external numerical convolution with resolution necessary
                            twoDimFlag=twoDimFlag

        resExists = self->ExtractOneResStr(ind,OneResStr)
        if resExists ne 0 then begin
          xDat_equals_xRes = array_equal(xvalues,OneResStr.x)
          xDat_equals_xRes = xDat_equals_xRes && (*self.prefs).allowApproxConv ; Allow for user setting for using approximate convolution
          OneResStr.xDat_equals_xRes = xDat_equals_xRes
          (*self.oneResPtr) = OneResStr
          resPtr = ptr_new(OneResStr)
          (*Self.resPtr).xDat_equals_xRes = xDat_equals_xRes
          rlimit=OneResStr.rlimit
        endif else begin
          self->clearOneRes_ptr
        endelse

        ; ...and make a copy of the object
        curveCopy = obj_new('FUNC',name = name, $                  ;042507 - LRK
                            xvalues = xvaluestemp,$;xvalues, $    :USE THE STORED XVALUES
                            $                                     ;FOR EACH GROUP.
                            qgroup=qvalue,$
                            qvals = qvalues, $
                            groupNumber=groupNumber,$
                            func_dataHash=func_dataHash, $
                            step = step, $
                            parms = parms, $
                            fixed = fixed, $
                            fixvalues = fixvalues, $
                            low = low, $
                            lovalues = lovalues, $
                            high = high, $
                            tied = tied, $
                            hivalues = hivalues, $
                            fit_fun_filename = fit_fun_filename,    $
                            expr = expr,$
                            ;rlimit = rlimit,   $
                            xtabPtr = self.xtabPtr, $
                            ytabPtr = self.ytabPtr, $
                            ttabPtr = self.ttabPtr, $
                            btabPtr = self.btabPtr, $
                            resolutionRequiredFlag=resolutionRequiredFlag, $ ; is instrumental resolution part of the function definition?
                            extConvolFlag=extConvolFlag, $                   ; external numerical convolution with resolution necessary
                            twoDimFlag=twoDimFlag)

        curveCopy->setproperty,resPtr = resPtr,rLimit = rLimit, $
                               parmError = parmError,/calculate
        if ptr_valid(resptr) then ptr_free,resptr
        curModel->add,curveCopy

      endfor;j = 0,ncurves-1
      
      
      if i gt 0 then begin
        ind1 = groupsToBeFitted[i-1]-1
        curModel->setparms,((*self.ocurveGroup)[ind1])->getparms()    ; use the previous group's fitted 
                                                                      ; parameters as the initial parameters 
                                                                      ; of the current one
      endif;i gt 0
      
    endif;(index ne goodindex)

  endfor;i
endif;(*self.prefs).same eq 1

; Cycle through and fit all the groups selected by the user
self.curIndex = 0
widget_control,self.groupSlider, set_value = (*self.grpArrayPtr)[self.curIndex]

tempcounter = 1
self.status = 1
while (self.status eq 1) and (self.curIndex le n_elements(*self.grpArrayPtr)-1) do begin
  ; for subsequent groups other than the first,
  ; use the previous group's fitted parameters as the initial parameters of the current one
  if (self.curIndex gt 0) then begin
    curIndex = groupsToBeFitted[self.curIndex]-1
    curModel = (*self.ocurveGroup)[curIndex]
    prevIndex = groupsToBeFitted[self.curIndex-1]-1
    curModel->Setparms,((*self.ocurvegroup)[prevIndex])->Getparms()
    print, ((*self.ocurvegroup)[prevIndex])->Getparms()
  endif

  ; fit the current group
  self->fitOneGroup,event = event,/noprogressbar
  self.curIndex = self.curIndex + 1
  if (self.curIndex le n_elements(*self.grpArrayPtr)-1) then begin
    widget_control,self.groupSlider, set_value = (*self.grpArrayPtr)[self.curIndex]
  endif

  ;UPDATE COUNTER AND PROGRESS WIDGET
  tempcounter++
  if obj_valid(progobj) gt 0 then begin
    progobj->set,0,tempcounter
    ;stopped = progobj->checkstop()
  endif
endwhile

; Ok, now go through and clear any fits that have a chi-squared of -1.0
for i = 0,nq-1 do begin
  ncurves = (*self.ocurveGroup)[i]->count()
  if ncurves gt 0 then begin
    oModel = (*self.ocurveGroup)[i]
    chisq = oModel->getchisq()
    if chisq eq (-1.0) then begin   ; remove it
      oall = oModel->get(/all)
      oModel->Remove,/all
      obj_destroy,oall
    endif
  endif
endfor

;LRK - 060910
if widget_info(self.progressBar,/valid) gt 0 then widget_control,self.progressBar,/destroy
self.progressBar = 0L

return
end;opan::fitAllGroups


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::sliderCurveSel,event = event
    return
end;opan::sliderCurveSel


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::remSelCurve,event = event
    widget_control,self.groupSlider,get_value = val
    val = fix(val[0])-1
    modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
    oc = (*self.ocurvegroup)[modelIndex]
    ncurves = oc->count()
    if ncurves eq 0 then return
    oall = oc->get(/all)

    widget_control,self.curveSlider,get_value = cval
    cval = fix(cval[0])
    cval = cval - 1   ; now it goes from 0 to ncurves-1
    if cval eq ncurves then begin
      return ; too big!
    endif
    oc->remove,oall[cval]
    void = oc->UpdateModTime()
    obj_destroy,oall[cval]
    ncurves = oc->count()
    widget_control,self.curveSlider,set_slider_max = (ncurves > 2)

    ;wset,self.resPix
    ;self->plotResiduals
    ;wset,self.resVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]
    ;
    ;wset,self.datPix
    ;self->displayData
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::remSelCurve



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::plotEISF, event = event
    ; No data?->Get out.
    if n_elements(*self.dataPtr) eq 0 then return

    ; Count how many groups of curves there are.  If there are less than two
    ; then get out.
    fitObject = *self.ocurveGroup
    ngroups = n_elements(fitObject)
    totalFits = 0
    for i = 0,ngroups-1 do begin
      oc = fitObject[i]
      ncurves = oc->count()
      if ncurves gt 0 then begin
        totalFits = totalFits + 1
        if (n_elements(okIndex) eq 0) then $
           okIndex = i else okIndex = [okIndex,i]
      endif
    endfor
    if totalFits lt 2 then return

    thisEvent = tag_names(event,/structure_name)
    case thisEvent of

    'WIDGET_BUTTON': $
      begin
        widget_control,self.logBase,sensitive = 0
        opan_plotEISF,   fitObject, $
                        *self.yvalsPtr, $
               group_leader = event.top, $
                         notifyIds = [event.id,event.top], $
                         xtitle = self.ytitle, $
                         ytitle = 'Value', $
                         title = '', $
                         workDir = self.workDir, $
                         logDirectory = self.logDirectory, $
                         stringPtr = self.logStringPtr

      end
    else:    widget_control,self.logBase,sensitive = 1
    endcase

    return
end;opan::plotEISF



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::plotFitParameter, event = event
; No data?->Get out.
if n_elements(*self.dataPtr) eq 0 then return

;  if (Self.twodimflag eq 0) then begin
;    ; handle 1D fits
;
;    ; Count how many groups of curves there are.  If there are less than two then return.
;    fitObject = *self.ocurveGroup
;    ngroups = n_elements(fitObject)
;    totalFits = 0
;    for i = 0,ngroups-1 do begin
;      oc = fitObject[i]
;      ncurves = oc->count()
;      if ncurves gt 0 then begin
;        totalFits = totalFits + 1
;        if n_elements(okIndex) eq 0 then okIndex = i else okIndex = [okIndex,i]
;      endif
;    endfor
;    if totalFits lt 2 then return

thisEvent = tag_names(event,/structure_name)

case thisEvent of

'WIDGET_BUTTON': begin
  widget_control,self.logBase,sensitive = 0
  opan_plotParms,  *self.ocurvegroup, $
       *self.yvalsPtr, $
       group_leader = event.top, $
       notifyIds = [event.id,event.top], $
       daveTool = self.daveTool, $
       filename = self.filename, $
       xtitle = self.ytitle, $
       ytitle = 'Value', $
       title = '', $
       workDir = self.workDir, $
       logDirectory = self.logDirectory, $
       groupsIncludedInFit = *self.grpArrayPtr, $
       stringPtr = self.logStringPtr
end

;'PLOTPARMSEVENT': begin
;end

else: widget_control,self.logBase,sensitive = 1

endcase
;  endif else begin
;    ; handle 2D fits
;  endelse

return
end;opan::plotFitParameter



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::saveParmsAsText,event = event,writeDataAndRes=writeDataAndRes    

fitVersionNos = '2'

if n_elements(*self.dataPtr) eq 0 then return
thisPath = self.workDir
fitObject = *self.ocurveGroup
ngroups = n_elements(fitObject)
ncurves = 0
for i = 0,ngroups-1 do begin
  oc = fitObject[i]
  ncurves = ncurves + (oc->count())
endfor
if ncurves eq 0 then return

if n_elements(event) ne 0 then dparent = event.top else dparent = 0L

filename = Self.filename
if (Strlen(filename) gt 0) then begin
  ; locate ext portion of filename
  i = Strpos(filename,'.',/reverse_search)
  ext = (i lt 0)? '' : Strmid(filename,i)
  ; strip dir path and ext from filename
  filename = File_basename(filename,ext,/fold_case)
endif
filename = filename+'_fitModel.fit'

filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                                              title = 'Filename to store fit Model details',$
                                              file = filename, $
                                              /write,filter = '*.fit',$
                                              default_ext='fit', $
                                              path = thisPath,/overwrite_prompt)
if filename eq '' then return
self.workdir = file_dirname(filename)

;openw,lun,filename,/get_lun
;macroHash = hash()
;for i = 0,ngroups-1 do begin
;  oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
;  if (Self.twodimflag && (i ne 0)) then continue          ; for 2D functions, only the first group model is required
;  chisq = oc->getchisq()
;  if chisq ne (-1.0) then begin
;    ncurves = oc->count()
;    if ncurves ne 0 then begin
;      printf,lun,'###############################'
;      if (i eq 0) then $
;        printf,lun,'Group: ',strtrim(string(i+1),2), ' : ',strtrim(string(Self.twodimflag),2) else $
;        printf,lun,'Group: ',strtrim(string(i+1),2)
;      printf,lun,'###############################'
;      oc->displayParmsAndConstraints,output = output, macroHash=macroHash
;      nlines = n_elements(output)
;      for j = 0,nlines-1 do begin
;        printf,lun,output[j]
;      endfor
;      printf,lun,'###############################'
;    endif
;  endif
;endfor

macroHash = Hash()
output = []
ally = Reform(*self.yvalsptr)
if (ally.ndim eq 2) then ally = Reform(ally[0,*])   ; use only the first column
nValidGroups = 0
groupValues = []

for i = 0,ngroups-1 do begin
  oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
  if (Self.Twodimflag && (i ne 0)) then continue          ; for 2D functions, only the first group model is required
  chisq = oc->Getchisq()
  if chisq ne (-1.0) then begin
    nValidGroups++
    groupValues = [groupValues,ally[i]]
    ncurves = oc->Count()
    if ncurves ne 0 then begin
      output = [output,'###############################']
      output = [output,'Group: '+Strtrim(String(i+1),2)]
      output = [output,'###############################']
      oc->Displayparmsandconstraints,output = output, macroHash=macroHash
      output = [output,'###############################']
    endif
  endif
endfor

; TODO: Review this to ensure no logical error for 2D fits especially when the fitted groups have a restricted range!!!
if (Self.twodimflag) then begin
  nValidGroups = ngroups
  groupValues = ally
endif

formatCode = (nValidGroups eq 1)? '(e12.3)' : '('+strtrim(string(nValidGroups-1),2)+'(e12.3,","),e12.3)'
Openw,lun,filename,/get_lun

; insert a 3-line header at the top
; this is a change to the .fit format as of April, 2024
; include a version nos and initialize to version 2 (thus implying prev version is 1)
printf,lun,'DAVE Peak Analysis (PAN) Fit (.fit) output'
printf,lun,'Version '+fitVersionNos
printf,lun,'TwoDimFlag='+strtrim(string(Self.twodimflag),2)+' : '+ $
                 'nGroups='+strtrim(string(nValidGroups),2)+' : '+ $
                 'GroupValues='+strtrim(string(groupValues,format=formatCode),2)

; continue with rest of contents as in prev .fit file format
nlines = N_elements(output)
for j = 0,nlines-1 do begin
  Printf,lun,output[j]
endfor


;; RTA - Mar, 2024
;; Also write out contents of macro function, if present
nMacro = macroHash.Count()
if (nMacro gt 0) then begin
  macroLen = 0
  macroOutput = []
  keyList = macroHash.Keys()
  for i=0,nMacro-1 do begin
    key = keyList[i]
    macroExpr = macroHash[key]
    macroOutput = [macroOutput,'MacroKey: '+strtrim(string(key),2)+' '+strtrim(string(macroExpr.length),2)]
    macroOutput = [macroOutput,macroExpr]
    macroLen = macroLen + 1 + macroExpr.length
  endfor
  line = 'MacroFunctionDefinition: nMacro='+ strtrim(string(nMacro),2)+' macroLength='+strtrim(string(macroLen),2)
  printf,lun,line
  printf,lun,macroOutput,format='(A)'
endif

;; RTA - May, 2013
;; Also write out data and resolution to file if requested
dataPresent = n_elements(*self.dataPtr) gt 0
if (keyword_set(writeDataAndRes) && dataPresent) then begin
  ; retrieve the data to write
  dat = (*Self.dataPtr)
  derr = reform(*self.errorPtr)
  allx = reform(*self.xvalsPtr)
  ally = reform(*self.yvalsPtr)
  dsize = size(dat)
  nv=n_elements(dat)
  ngrps = nv/dsize[1]
  nchan = nv/ngrps
  
;  if (ngrps gt 1) then begin
;    allx = allx[*,0]  ; use only the first row
;    ally = ally[0,*]  ; use only the first column
;  endif
  if (allx.ndim eq 2) then allx = reform(allx[*,0])   ; use only the first row
  if (ally.ndim eq 2) then ally = reform(ally[0,*])   ; use only the first column
  
  bitmask = *Self.maskPtr
  bytMask = bits2bytes(bitMask)
  nMask = n_elements(bytMask)
    
  resPresent = n_elements(*self.resPtr) gt 0

  fmt = '(6(E13.5,1X))'
  line = "Data Section: nGroups="+strtrim(string(ngrps),2)+ $
    " nChan="+strtrim(string(nchan),2)+ $
    " nMask="+strtrim(string(nMask),2)+ $
    " ResolutionPresent="+strtrim(string(fix(resPresent)),2)
  printf, lun, line
  printf, lun, Self.xtitle
  printf, lun, Self.ytitle
  printf, lun, Self.xunits
  printf, lun, Self.yunits
  printf, lun, Self.title
  printf, lun, strjoin(*Self.headerPtr,';;')
  printf, lun, 'X values:'
  printf, lun, allx, format=fmt
  printf, lun, 'Group values:'
  printf, lun, ally, format=fmt
  printf, lun, 'Data values:'
  printf, lun, dat, format=fmt
  printf, lun, 'Error values:'
  printf, lun, derr, format=fmt
  printf, lun, 'Byte mask values:'
  printf, lun, bytMask
  if (resPresent) then begin
    dat = (*Self.resPtr).data
    allx = (*Self.resPtr).x
    ally = (*Self.resPtr).y
    if (allx.ndim eq 2) then allx = Reform(allx[*,0])   ; use only the first row
    if (ally.ndim eq 2) then ally = Reform(ally[0,*])   ; use only the first column
    rlimit = (*Self.resPtr).rlimit
    bitMask = (*Self.resPtr).mask
    bytMask = bits2bytes(bitMask)
    nMask = n_elements(bytMask)
    dsize = size(dat)
    nv=n_elements(dat)
    ngrps = nv/dsize[1]
    nchan = nv/ngrps
    line = "Resolution Section: nGroups="+strtrim(string(ngrps),2)+ $
      " nChan="+strtrim(string(nchan),2)+ $
      " nMask="+strtrim(string(nMask),2)+ $
      " xlimits="+strjoin(strtrim(string(rlimit),2),',')
    printf, lun, line
    printf, lun, 'Res X values:'
    printf, lun, allx, format=fmt
    printf, lun, 'Res Group values:'
    printf, lun, ally, format=fmt
    printf, lun, 'Data values:'
    printf, lun, dat, format=fmt
    printf, lun, 'Byte mask values:'
    printf, lun, bytMask
  endif

endif
  
free_lun,lun,/force

msg = 'Output saved in: '+filename
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
ok = dialog_message(/info,msg,dialog_parent=dparent)

return
end;opan::saveParmsAsText


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::readParmsAsText,event = event
thisPath = self.workDir

if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                                              title = 'Filename to read fit Model information',$
                                              /read,filter = '*.fit',$
                                              path = thisPath)
if filename eq '' or filename eq ' ' then return

; RMD 07/01/03
; Replaced the following procedure with one that reads in ASCII fit parameter
; files and constraints.

;opanReadFitParms,filename,fitArray = fitArray,groups = groups, error = error
opanReadFitParmsAndConstraints,filename,fitArray = fitArray, $
   groups = groups, dataStr=dataStr, resStr=resStr, macroHash=macroHash, $
   error = error,ermsg = ermsg
if error eq 1 then begin
   if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
   void = dialog_message(dialog_parent = dparent,ermsg,/error)
   return
endif

;; RTA - Maay, 2013    
;; if data was read from the file then replace PANS's current data with it
if (n_elements(resStr) gt 0) then begin
  ;; first, clear out any existing resolution now otherwise there may be an incompatibilty when loading the data next
  self.resptr = Ptr_new(/allocate_heap)
  self.oresptr = Ptr_new(/allocate_heap)
endif
if (n_elements(dataStr) gt 0) then begin      
  (*Self.dataPtr) = dataStr.data
  (*Self.errorPtr) = dataStr.derr
  (*Self.xvalsPtr) = dataStr.x 
  (*Self.yvalsPtr) = dataStr.y
  (*Self.maskPtr) = dataStr.mask           
  Self.xtitle = dataStr.xtitle
  Self.ytitle = dataStr.ytitle
  Self.xunits = dataStr.xunits
  Self.yunits = dataStr.yunits
  Self.title = dataStr.title
  (*Self.headerPtr) = dataStr.history
  self.filename = filename
  self.datadir = file_dirname(filename)
  Self.printFileName = file_basename(filename)
  
  Self->initNewDataObjects,err=err,emsg=emsg
  if (err eq 1) then return
endif

; If no data at this stage then exit
if n_elements(*self.dataPtr) eq 0 then return

;; RTA - Maay, 2013
;; if resolution data was read from the file then replace PANS's current resolution with it
if (n_elements(resStr) gt 0) then begin
  Self->interpSigRes, resStr, /noCrop
endif

; How many groups are there in the current data set?
ngrps = n_elements(fitArray)
dat = *self.dataPtr
dsize = size(dat)
nv=n_elements(dat)
ny = nv/dsize[1]
nx = nv/ny

; if twiDimFlag was previously defined at the main level, we need to make it undefined
if N_elements(routine_names('twoDimFlag', fetch = 1)) ne 0 then begin
  value  = !null
  dummy  = routine_names('twoDimFlag', value, store = 1)
endif
    
; func_data is a hash variable used to store misc info for a function. It is created by the function but may
; sometimes be useful to shared it between several instances of the function. An example is the baseline function
; which contains data read from a data file. When there are mupltiple groups the source of the baseline data
; is still a single file hence it is only necessary to read the data once, store in the data_hash and copy to 
; other groups so there is no need to read the same file subsequently.
func_data = []

; Ok, now let's start building the fit objects
for i = 0,ngrps-1 do begin
  thisGroup = groups[i] - 1

  if (i eq 0) then begin
    oc = (*self.ocurvegroup)[thisGroup]
  endif else begin
    if (Self.twodimflag) then begin
      ; If any 2D function was registered for the first grp then only the
      ; the model defined for the first group is relevant so no need to proceed
      self->refresh
      return
    endif else begin
      oc = (*self.ocurvegroup)[thisGroup]
    endelse
  endelse

  ; First, if necessary, free up any existing curves in the current group
  ncurves = oc->count()
  if ncurves ne 0 then begin
   oall = oc->get(/all)
   obj_destroy,oall
   oc->remove,/all
  endif
  ;twoDimFlagFromFit = (fitArray[i]).twoDimFlag
  chi_value = *(fitArray[i]).chisqPtr
  names = *(fitArray[i]).namePtr
  parmnames = *(fitArray[i]).parmNamesPtr        ;LRK 01/26/09 
  parms = *(fitArray[i]).parmPtr
  sigma = *(fitArray[i]).parmErrPtr
  fixed_parms = *(fitArray[i]).fixPtr
  lowCheck = *(fitArray[i]).lowCheckPtr
  lowValues = *(fitArray[i]).lowValuePtr
  highCheck = *(fitArray[i]).highCheckPtr
  highValues = *(fitArray[i]).highValuePtr
  tied = *(fitArray[i]).tiePtr
  nparms = *(fitArray[i]).nparmPtr
  exprArray = *(fitArray[i]).exprPtr
  ncurves = n_elements(names)
  parmcount = 0

  self->extractDataForPAN,dat=dat,derr=daterr,x=x,y=y,group=thisGroup+1,val=val,dSize=datSize,qvals=qvals, allData=allData
  y = y[0]
  qgroup = y[0]
  groupnumber = val+1
  xunits=Self.xunits
  
  resExists = self->Extractoneresstr(val,OneResStr)
  if resExists ne 0 then begin
    (*self.oneresptr) = OneResStr
    rlimit=OneResStr.rlimit
  endif else begin
    self->Clearoneres_ptr
  endelse

  for j = 0,ncurves-1 do begin
    funcDataHash = (i eq 0 || j ge n_elements(func_data))? obj_new() : func_data[j]  ; for first grp these will be null but will be defined
                                                       ; for susequent grps after the funcs are created for first grp

    ; curParms contains the parameters for the current curve
    curParms = parms[parmCount:parmCount+nparms[j]-1]
    curParmNames = parmnames[parmCount:parmCount+nparms[j]-1]          ;LRK 01/26/09
    parmCount = parmCount + nparms[j]
    name = strlowcase(names[j])
    extConvolFlag = !null
    resolutionRequiredFlag = !null
    twoDimFlag = !null

    if (strupcase(name) eq 'PAN_USERFUNCTION') then begin
      expr = exprArray[j]
      parmStr = Getparmsfromexpr(expr)
      void = Pan_userfunction(expr=expr,eval=eval,twoDimFlag=twoDimFlag,qvals=qvals,xvals=x,yvals=allData) ;Pan_userfunction(x,curparms,expr = expr,eval = eval, twoDimFlag=twoDimFlag)
      if (N_elements(twoDimFlag) eq 0) then twoDimFlag = 0
      if (N_elements(extConvolFlag) eq 0) then extConvolFlag = 1    ; Require external (to function) convolution by default
      if (N_elements(resolutionRequiredFlag) eq 0) then resolutionRequiredFlag = 0    ; Resolution function is NOT required by default to define the function
    endif else if (Strupcase(name) eq 'PAN_MACROFUNCTION') then begin
      if (n_elements(macro_text) eq 0) then begin
        ; do we have a macro text (will definitely not have one when i=0 and j=0)
        ; NOTE: for now we are only assuming theat we have 1 macro definition in a model.
        ; TODO: modify to handle more than one macro per model
        
        ; Option 1: Look for macro definition embedded in fit file
        if (Isa(macroHash,'HASH') && (macroHash.Count() gt 0)) then begin
          macroID = Strjoin(Strtrim(curParmNames,2),':')                ; unique key is from a combination of all parameters in the macrofunction
          key = Long(Total(Fix(Byte(macroID))))    ; convert the unique string ID into a long integer key
          macro_text = (macroHash.Haskey(key))? macroHash[key] : ''
        endif
        
        ; Option 2: Ask the user to load in a macro definition from a file
        if (n_elements(macro_text) eq 0) then begin
          ; if no macro definition yet then ask user to load one
          parmText = Strtrim(String(curParmNames, format='(4A)'),2) ; the '(4A)' format code simply writes up to 4 parameters per line only
          parmText = parmText.Replace(' ',', ')                     ; so that we don't end up with really long lines in the pop-up dialog

          void = Dialog_message(['Please select the macro definition file with the following parameter names:',$
            parmText],$
            dialog_parent = dparent,/information,$
            title='Macro detected:')
          fit_fun_filename = Dialog_pickfile(title='Load matching macro definition file:',$
            path=thispath,filter='*.mf',/read,$
            dialog_parent=self.tlb)
          if fit_fun_filename eq '' then Return
          macro_text = Strarr(File_lines(fit_fun_filename))
          Openr,lun,fit_fun_filename,/get_lun
          Readf, lun, macro_text
          Free_lun,lun,/force
          
          ; TODO: Check to ensure the macro_text is consistent with what was expected with regards to the parameter names.
        endif
      endif
      
      ; Option 3: If still no macro then Exit because don't know what else to do!
      if (n_elements(macro_text) eq 0) then Return 
      
      ; If we get here then we have a macro
      if (Strjoin(macro_text,/single) eq '') then Return  ; can't proceed if macro_text empty text
      void = Pan_macrofunction(expr=macro_text,eval=eval,twoDimFlag=twoDimFlag,qvals=qvals,xvals=x,yvals=allData,groupNumber=groupNumber,qgroup=y[0], $
                               wTLB = Self.tlb, resolutionRequiredFlag=resolutionRequiredFlag, xunits=xunits,extConvolFlag=extConvolFlag)

      ; Does this macro require a resolution function to be defined?
      ; set the default to no if the macro definition does not define it.
      if (~Isa(resolutionRequiredFlag)) then resolutionRequiredFlag = 0

      ; Flag the function as ether one that will require an external (to function) numerical convolution or not
      ; this information is used in Func_cont::Evaluation()
      ; By default, set to 0 if the macro definition does not define it.
      ; This is because a convolution is performed within pan_macrofunction()
      ; so requiring an external convolution may lead to double convolution
      if (~Isa(extConvolFlag)) then extConvolFlag = 0

      ; Does this macro define a 2D function?
      ; If the macro does not define one then assume it is a 1D function
      if (~Isa(twodimflag)) then twodimflag = 0

      expr = macro_text

;      if (i eq 0) then begin
;        ; NOTE - This logic assumes that we can only have one user macro function in the model
;        if N_elements(event) ne 0 then dparent = Event.top else dparent = 0L
;        
;        ; was a macro definition text found in the fit file?
;        macro_text = ''
;        if (isa(macroHash,'HASH') && (macroHash.count() gt 0)) then begin
;          macroID = Strjoin(strtrim(curParmNames,2),':')                ; unique key is from a combination of all parameters in the macrofunction
;          key = Long(Total(Fix(Byte(macroID))))    ; convert the unique string ID into a long integer key
;          macro_text = (macroHash.Haskey(key))? macroHash[key] : ''
;        endif
;        if (Strjoin(macro_text,/single) eq '') then begin
;          ; if no macro definition yet then ask user to load one
;          parmText = Strtrim(String(curParmNames, format='(4A)'),2) ; the '(4A)' format code simply writes up to 4 parameters per line only
;          parmText = parmText.Replace(' ',', ')                     ; so that we don't end up with really long lines in the pop-up dialog
;
;          void = Dialog_message(['Please select the macro definition file with the following parameter names:',$
;            parmText],$
;            dialog_parent = dparent,/information,$
;            title='Macro detected:')
;          fit_fun_filename = Dialog_pickfile(title='Load matching macro definition file:',$
;            path=thispath,filter='*.mf',/read,$
;            dialog_parent=self.tlb)
;          if fit_fun_filename eq '' then Return
;          macro_text = Strarr(File_lines(fit_fun_filename))
;          Openr,lun,fit_fun_filename,/get_lun
;          Readf, lun, macro_text
;          Free_lun,lun,/force
;        endif
;        
;        if (Strjoin(macro_text,/single) eq '') then Return  ; can't proceed if macro_text is still empty text
;        void = Pan_macrofunction(expr=macro_text,eval=eval,twoDimFlag=twoDimFlag,qvals=qvals,xvals=x,yvals=allData,groupNumber=groupNumber,qgroup=y[0], $
;                                 wTLB = Self.tlb, resolutionRequiredFlag=resolutionRequiredFlag, xunits=xunits,extConvolFlag=extConvolFlag)
;
;        ; Does this macro require a resolution function to be defined?
;        ; set the default to no if the macro definition does not define it.
;        if (~Isa(resolutionRequiredFlag)) then resolutionRequiredFlag = 0
;
;        ; Flag the function as ether one that will require an external (to function) numerical convolution or not
;        ; this information is used in Func_cont::Evaluation()
;        ; By default, set to 0 if the macro definition does not define it.
;        ; This is because a convolution is performed within pan_macrofunction()
;        ; so requiring an external convolution may lead to double convolution
;        if (~Isa(extConvolFlag)) then extConvolFlag = 0
;
;        ; Does this macro define a 2D function?
;        ; If the macro does not define one then assume it is a 1D function
;        if (~Isa(twodimflag)) then twodimflag = 0
;
;        expr = macro_text
;
;      endif
    endif else begin
      ; Case for built-in functions
      ; call function to retirieve twoDimFlag property
      ret = Call_function(name, twoDimFlag=twoDimFlag,qvals=qvals,xvals=x,yvals=allData,groupNumber=groupNumber,qgroup=y[0], $
        wTLB = Self.tlb, resolutionRequiredFlag=resolutionRequiredFlag, xunits=xunits,extConvolFlag=extConvolFlag)
      if (N_elements(twoDimFlag) eq 0) then twoDimFlag = 0
      if (N_elements(extConvolFlag) eq 0) then extConvolFlag = 1    ; Require external (to function) convolution by default
      if (N_elements(resolutionRequiredFlag) eq 0) then resolutionRequiredFlag = 0    ; Resolution function is NOT required by default to define the function
    endelse
    if (j gt 0) then begin
      ; model already contains a function so the model's 2D flag was previously set therefore
      ; retrieve it and make sure it matches the 2D flag of the function to be added
      model2DFlag = oc->Get2dflag()
      if (model2DFlag ne twoDimFlag) then begin
        msg = 'Cannot add this user function to existing model'
        msg = [msg,'because it already contains an incompartible function']
        msg = [msg,'Functions in a model must share the same dimensionality!']
        msg = [msg,'Cannot proceed...']
        void = Dialog_message(dialog_parent = Self.tlb, msg)
        Return
      endif
    endif else begin
      ; when both i and j equal 0 then assign the function 2DFlag to the main PAN 2DFlag
      if (i eq 0) then Self.twodimflag = twoDimFlag  ; record this in the main program so we know what we are dealing with
                                    ; Assume we can't mix 1D and 2D functions so it is which are are using at all times
    endelse

    resdata_Notpresent = N_elements(*self.resptr) eq 0
    if (resolutionRequiredFlag && resdata_Notpresent) then begin
      msg = 'To use function: '+name.Toupper()
      msg = [msg,'You must load a resolution function first!']
      void = Dialog_message(dialog_parent = dparent,msg,/error)
      Return
    endif
    
    funcClassName = (twoDimFlag eq 0)? "func" : "func_2d"

    obj = Obj_new(funcClassName,name = name, $
      xvalues = x, $
      expr = expr, $
      parms = curparms,$
      xtabPtr = self.xtabptr, $
      ytabPtr = self.ytabptr, $
      btabPtr = self.btabptr, $
      ttabPtr = self.ttabptr,$
      datSize = datSize,$         ; dimensions of the expr't data to be fitted
      workDir = Self.workdir, $
      wTLB = Self.tlb, $
      func_dataHash = funcDataHash, $
      twoDimFlag = twoDimFlag, xunits=xunits,  $
      resPtr = (twoDimFlag)? self.resptr : self.oneresptr, $
      qvals=qvals, xvals=x,yvals=allData,qgroup=y[0], $
      resolutionRequiredFlag = resolutionRequiredFlag, $    ; is the function defined with a built-in resolution function
      extConvolFlag = extConvolFlag, $                ; will external convolution be needed
      groupNumber=groupNumber) 

    if (~Obj_valid(obj)) then Return
    *self.ocurrentptr = obj
    oc->Add,*self.ocurrentptr
    ; For first group, record func_data hash variable for all functions
    ; For subsequent groups, these will be copied over when the functions are being created/init
    if (i eq 0 || j ge n_elements(func_data)) then begin
      (*Self.ocurrentptr)->Getproperty, func_datahash=hashVar
      func_data = [func_data,hashVar]
    endif
  endfor
  oc->Setparms,parms
  oc->Setparmerror,sigma
  oc->Setfixed,fixed_parms
  oc->Setlow,lowCheck
  oc->Sethigh,highCheck
  oc->Setlowvalues,lowValues
  oc->Sethighvalues,highValues
  oc->Settied,tied
  oc->Setchisq,chi_value
endfor

self->refresh

; Clean up the pointers
for j = 0,ngrps-1 do begin
  ptr_free,(fitArray[j]).namePtr
  ptr_free,(fitArray[j]).parmPtr
  ptr_free,(fitArray[j]).parmErrPtr
  ptr_free,(fitArray[j]).fixPtr
  ptr_free,(fitArray[j]).tiePtr
  ptr_free,(fitArray[j]).lowCheckPtr
  ptr_free,(fitArray[j]).lowValuePtr
  ptr_free,(fitArray[j]).highCheckPtr
  ptr_free,(fitArray[j]).highValuePtr
  ptr_free,(fitArray[j]).nparmPtr
  ptr_free,(fitArray[j]).exprPtr
  ptr_free,(fitArray[j]).chisqPtr
endfor

return
end;opan::readParmsAsText


function opan::copyModelContainer,oc,group=group,curvenumber=curvenumber,use_res=use_res

  if n_elements(curvenumber) eq 0 then curvenumber = -1
  tempCont = obj_new('func_cont')
  for jj = 0,oc->count()-1 do begin
    ;FOR INDIVIDUAL RESOLUTION-CONVOLVED CURVE, ONLY A SINGLE jj SHOULD 
    ;BE NEEDED HERE, AND THEN I HAVE TO ADD THE RESPTR TO THE func_cont/func(???)
    
    if curvenumber eq jj or curvenumber eq -1 then begin
    
        ;ocgcn = oc->getCurveName(jj) & help,ocgcn
        ;print,ocgcn
        ;tempCont->setCurveName,ocgcn
        ocFunc = oc->get(position=jj)
        ocfunc->getproperty, $
                  name = name,  $
                  xvalues = xvalues, $
                  qgroup=qgroup,$
                  groupNumber=groupNumber,$
                  yvalues = yvalues,  $
                  step = step, $
                  parms = parms, $
                  fixed = fixed, $
                  fixvalues = fixvalues, $
                  low = low, $
                  lovalues = lovalues, $
                  high = high, $
                  hivalues = hivalues,$
                  ;parmnames = parmnames,$
                  parmError = parmError, $
                  tied = tied, $
                  canDraw = canDraw, $
                  fit_fun_filename = fit_fun_filename,  $
                  expr = expr
    
                  
              tempFunc = obj_new('func',name = name, $
                       xvalues = xvalues,$
                       qgroup = qgroup,$           ;THIS MAKES func AWARE OF THE Q-VALUE FOR ITS GROUP
                       groupNumber = groupNumber,$ ;THIS MAKES func AWARE OF THE NUMBER OF THE GROUP IT BELONGS TO
                       fit_fun_filename = fit_fun_filename, $
                       step = step, $
                       parms = parms, $
                       fixed = fixed, $
                       fixvalues = fixvalues, $
                       low = low, $
                       lovalues = lovalues, $
                       high = high, $
                       hivalues = hivalues, $
                       tied = tied, $
                       resPtr = resPtr, $
                       rlimit = rlimit, $
                       expr = expr, $
                       _Extra = extra)
              ;tempCont->add,tempfunc,position=jj
              tempCont->add,tempfunc ;,position=jj

    endif;curvenumber       
   
  endfor;jj
  
  return,tempCont

end;opan::copyModelContainer

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::print2text,event = event,group=group,curvenumber=curvenumber,use_res=use_res

  
if n_elements(*self.dataPtr) eq 0 then return

if n_elements(group) eq 0 then begin      
  group = -1      
endif else begin
  if group le 0 then begin
    void = dialog_message('The variable "group" must be greater than 0.',dialog_parent=self.tlb)
  endif
endelse
if n_elements(curvenumber) eq 0 then curvenumber = -1
if n_elements(use_res) eq 0 then use_res = 0

thisPath = self.workDir
filters = ['*.txt','*.dat']
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                                              title = 'Filename to store Data and Lineshape(s)',$
                                              /write,filter = filters,$
                                              default_ext = 'txt', $
                                              path = thisPath,/overwrite_prompt)

if filename eq '' then return

self.workdir = file_dirname(filename)

fitObject = *self.ocurveGroup
ngroups = n_elements(fitObject)

; If a resolution function is being used, ask the user whether he wishes to 
; convolute the component lineshapes with the resolution before saving
convFlag = 0
if (self->ExtractOneResStr(0,OneResStr)) then begin
  msg = 'A resolution function was used in the fitting'
  msg = [msg,'If the model function consists of more than one function,']
  msg = [msg,'then the individual components of the model can be saved']
  msg = [msg,'with or without the instrumental convolution. Note that the']
  msg = [msg,'overall model fit always includes the instrumental convolution','']
  msg = [msg,'Do you wish to convolute the saved function component lineshapes']
  msg = [msg,'with the instrumental resolution?']
  
  title = 'Resolution Convolution'
  convAns = dialog_message(msg,/question,title=title,dialog_parent=dparent)
  convFlag = (convAns eq 'Yes')? 1 : 0
endif

openw,lun,filename,/get_lun

;print,'NOTE: group IS A 1-based ARRAY INDEX'
for i = 0L,ngroups-1 do begin
  yfit = []
  if (i eq group-1) or (group eq -1) then begin
    oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
    oall = oc->get(/all)
    ncurves = oc->count()
    self->extractDataForPAN,dat=dat,derr=daterr,x=x,group=i+1,val=val
    nx = n_elements(x)
    strout1 = '# Group '+string(i+1)
    strout2 = '# x y yerr'
    str = ['#','x','yerr']
    if ncurves gt 0 then begin
      if (Self.twodimflag) then begin
        if (i eq 0) then begin
          ; need to evaluate once since all grps are caculated together
          resExists = n_elements(*self.resPtr) ne 0
          if (convFlag && resExists) then begin
            oc->Evaluateexcel,x,yout = yfit2D,resPtr = Self.resPtr
          endif else begin
            self->Clearoneres_ptr
            oc->Evaluateexcel,x,yout = yfit2D
          endelse
        endif
        yfit = yfit2D[*,i]
      endif else begin
        if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
          (*self.oneresptr) = OneResStr
          rlimit=OneResStr.rlimit
        endif else self->Clearoneres_ptr
        oc->Evaluateexcel,x,yout = yfit,resPtr = self.oneresptr,rlimit = rlimit
      endelse
      txt = replicate('  Func',ncurves)
      txt = txt + strtrim(string(indgen(ncurves)+1),2)
      strout2 = strout2 + ' ModelFit '
      str = [str,'total fit']
      ;EVALUATE INDIVIDUAL COMPONENT CURVES
      if curvenumber eq -1 then begin
        ;COMPUTE ALL COMPONENT CURVES
        ycomp = fltarr(nx,ncurves)
  
        for j = 0,ncurves-1 do begin
          if (Self.twodimflag) then begin
            if (i eq 0) then begin
              oall[j]->Getproperty,xvalues=xtempsave, extConvolFlag=extConvolFlag
              oall[j]->Setproperty,xvalues = x,/calculate
              oall[j]->Getproperty,yvalues = yvalues2D
              oall[j]->Setproperty,xvalues = xtempsave,/calculate
              ;resExists = n_elements(*self.resPtr) ne 0
              if (convFlag && resExists && extConvolFlag) then begin
                ;; perform convolution as needed
                yvalues2D = Pan_convolute(x,Self.resPtr,yvalues2D)
              endif
            endif
            yvalues = yvalues2D[*,i]
          endif else begin
            oall[j]->Getproperty,name = name, extConvolFlag=extConvolFlag
            oall[j]->Getproperty,xvalues=xtempsave
            oall[j]->Setproperty,xvalues = x,/calculate
            oall[j]->Getproperty,yvalues = yvalues
            oall[j]->Setproperty,xvalues = xtempsave,/calculate
            if (convFlag && resExists && extConvolFlag) then begin
              ;; perform convolution as needed
              yvalues = Pan_convolute(x,Self.oneresptr,yvalues)
            endif
          endelse
          
          ;SET THE COMPONENT j VALUE
          ycomp[*,j] = yvalues
          if j eq 0 then begin
            out = txt[j]
          endif else begin
            out = out + txt[j]
          endelse
          str = [str,txt[j]]
        endfor;j
        strout2 = strout2 + out
        printf,lun,strout1
        outFormat = '(A1,'+strtrim(string(4+ncurves),2)+'A15)'
        printf,lun,strsplit(strout2,/extract),format=outFormat
        thisFormat = '(1X,'+strtrim(string(4+ncurves),2)+'f15.5)'
        dataOut = fltarr(4+ncurves)
        for j = 0L,nx-1 do begin
          dataOut[0:4+ncurves-1] = [x[j],dat[j],daterr[j],yfit[j],transpose(ycomp[j,0:ncurves-1])]
          printf,lun,dataOut[0:4+ncurves-1],format = thisFormat
        endfor;j
      endif else begin
        ;COMPUTE ONLY THE jth CURVE 
        ycomp = fltarr(nx,1);,ncurves)
        j = curvenumber-1

        if (Self.twodimflag) then begin
          if (i eq 0) then begin
            oall[j]->Getproperty,xvalues=xtempsave, extConvolFlag=extConvolFlag
            oall[j]->Setproperty,xvalues = x,/calculate
            oall[j]->Getproperty,yvalues = yvalues2D
            oall[j]->Setproperty,xvalues = xtempsave,/calculate
            ;resExists = n_elements(*self.resPtr) ne 0
            if (convFlag && resExists && extConvolFlag) then begin
              ;; perform convolution as needed
              yvalues2D = Pan_convolute(x,Self.resptr,yvalues2D)
            endif
          endif
          yvalues = yvalues2D[*,i]
        endif else begin
;          oall[j]->Getproperty,name = name
;          if (Strupcase(name) eq 'PAN_DELTA') then begin
;            oall[j]->Getproperty,parms = theseparms
;            yvalues = Pan_delta(x,theseparms,resPtr = self.oneresptr,rlimit = rlimit)
;          endif else if (Strupcase(name) eq 'PAN_QENS') then begin
;            oall[j]->Getproperty,parms = theseparms
;            yvalues = Pan_qens(x,theseparms,resPtr = self.oneresptr,rlimit = rlimit)
;          endif else begin
;            oall[j]->Getproperty,xvalues=xtempsave
;            oall[j]->Setproperty,xvalues = x,/calculate
;            oall[j]->Getproperty,yvalues = yvalues
;            oall[j]->Setproperty,xvalues = xtempsave,/calculate
;            if (convFlag && resExists) then begin
;              ;; perform convolution if needed
;              yvalues = Pan_convolute(x,Self.oneresptr,yvalues)
;            endif
;          endelse

          oall[j]->Getproperty,name = name, extConvolFlag=extConvolFlag
          oall[j]->Getproperty,xvalues=xtempsave
          oall[j]->Setproperty,xvalues = x,/calculate
          oall[j]->Getproperty,yvalues = yvalues
          oall[j]->Setproperty,xvalues = xtempsave,/calculate
          if (convFlag && resExists && extConvolFlag) then begin
            ;; perform convolution as needed
            yvalues = Pan_convolute(x,Self.oneresptr,yvalues)
          endif

        endelse
  
        ;NOW SET THE DATA AND PRINT IT OUT
        ycomp[*,0] = yvalues
        out = txt[j]+'Convolved'
        strout2 = strout2 + out
        printf,lun,strout1
        outFormat = '(A1,5A15)'
        printf,lun,strsplit(strout2,/extract),format = outFormat
        thisFormat = '(1X,'+strtrim(string(4+ncurves),2)+'f15.5)'
        dataOut = fltarr(4+1);ncurves)
        for j = 0L,nx-1 do begin
          dataOut[0:4+1-1] = [x[j],dat[j],daterr[j],yfit[j],transpose(ycomp[j,0:1-1])]
          printf,lun,dataOut[0:4+1-1],format = thisFormat
        endfor;j
      endelse 
    endif else begin
      printf,lun,strout1
      outFormat = '(A1,3A15)'
      printf,lun,strsplit(strout2,/extract),format = outFormat
      thisFormat = '('+strtrim(string(3),2)+'f15.5)'
      dataOut = fltarr(3)
      for j = 0L,nx-1 do begin
        dataOut[0:2] = [x[j],dat[j],daterr[j]]
        printf,lun,dataOut[0:2],format = thisFormat
      endfor
    endelse
    printf,lun,''
  endif;i eq group or group eq -1        
endfor;i

free_lun,lun,/force
msg = 'Output saved in: '+filename
ok = dialog_message(/info,msg,dialog_parent=dparent)

return

end;opan::print2text



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::print2textSelect,event=event,_Extra=extra
  widget_control,self.curveSlider,get_value=curvenumber
  widget_control,self.groupSlider,get_value=groupnumber
  self->print2Text,event=event,$;group=group,
                                curvenumber=curvenumber,$
                                 /use_res
end;opan::print2textSelect



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::flushAndCloseOpenedFiles,event,_Extra=extra
;; sometimes open files are not close. So use this action to explicitly close them
close,/force,/all
;print,'### All files flushed and closed...'
end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::print2text_as_excel,event = event
if n_elements(*self.dataPtr) eq 0 then return
thisPath = self.workDir
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
filters = ['*.txt','*.dat']
filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                                              title = 'Filename to store Data and Lineshape(s)',$
                                              /write,filter = filters,$
                                              default_ext = 'txt', $
                                             path = thisPath,/overwrite_prompt)
if filename eq '' then return
self.workdir = file_dirname(filename)
        
fitObject = *self.ocurveGroup
ngroups = n_elements(fitObject)

; If a resolution function is being used, ask the user whether he wishes to
; convolute the component lineshapes with the resolution before saving
convFlag = 0
if (self->Extractoneresstr(0,OneResStr)) then begin
  msg = 'A resolution function was used in the fitting'
  msg = [msg,'If the model function consists of more than one function,']
  msg = [msg,'then the individual components of the model can be saved']
  msg = [msg,'with or without the instrumental convolution. Note that the']
  msg = [msg,'overall model fit always includes the instrumental convolution','']
  msg = [msg,'Do you wish to convolute the saved function component lineshapes']
  msg = [msg,'with the instrumental resolution?']

  title = 'Resolution Convolution'
  convAns = Dialog_message(msg,/question,title=title,dialog_parent=dparent)
  convFlag = (convAns eq 'Yes')? 1 : 0
endif


; How many columns do we need?
ncols = 1   ; the independent variable
for i = 0,ngroups-1 do begin
  oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
  ncurves = oc->count()
  ncols =  ncols  +    $  ;
                2 +         $  ; the intensity, and the error bars
                ncurves +   $  ; the number of curves
                1              ; the overall fit
endfor

; How many rows do we need?
x = Reform((*self.xvalsptr)[*,0]) ;HERE WE USE ALL X VALUES, NOT JUST THE UNMASKED ONES.
nx = N_elements(x)

format_statement = '('+strtrim(string(ncols),2)+'G12.5)'
nrows = nx

; Create a data array with the required number of rows and columns
; Ultimately this will be the array that is written out to a file
for i = 0,ngroups - 1 do begin
   oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
   oall = oc->get(/all)
   ncurves = oc->count()
   yfit = []
  self->extractDataForPAN,allData=alldat,allx=x,group=i+1,val=val,allError=allerr
  dat = reform(alldat[*,i])
  daterr = reform(allerr[*,i])
  nx = n_elements(x)
  num_string = strtrim(string(i+1),2)
  if n_elements(d) eq 0 then begin
    d = [transpose(x),transpose(dat),transpose(daterr)]
    titles = ['x','y'+num_string,'yerr'+num_string]
  endif else begin
    d = [d,Transpose(dat),Transpose(daterr)]
    titles = [titles,'y'+num_string,'yerr'+num_string]
  endelse

  if ncurves gt 0 then begin
    if (Self.twodimflag) then begin
      if (i eq 0) then begin
        ; need to evaluate once since all grps are caculated together
        if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
          (*self.oneresptr) = OneResStr
          rlimit=OneResStr.rlimit
        endif else self->Clearoneres_ptr
        oc->Evaluateexcel,x,yout = yfit2D,resPtr = self.oneresptr,rlimit = rlimit
      endif
      yfit = yfit2D[*,i]
    endif else begin
      if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
        (*self.oneresptr) = OneResStr
        rlimit=OneResStr.rlimit
      endif else self->Clearoneres_ptr
      oc->Evaluateexcel,x,yout = yfit,resPtr = self.oneresptr,rlimit = rlimit
    endelse
    titles = [titles,'ftotal'+num_string]
    d = [d,transpose(yfit)]
    for j = 0,ncurves-1 do begin
        if (Self.twodimflag) then begin
          if (i eq 0) then begin
            oall[j]->Getproperty,xvalues=xtempsave
            oall[j]->Setproperty,xvalues = x,/calculate
            oall[j]->Getproperty,yvalues = yvalues2D
            oall[j]->Setproperty,xvalues = xtempsave,/calculate
            if (convFlag && resExists) then begin
              ;; perform convolution if needed
              yvalues2D = Pan_convolute(x,Self.oneresptr,yvalues2D)
            endif
          endif 
          yvalues = yvalues2D[*,i]
        endif else begin
          oall[j]->getProperty,name = name
          if (strupcase(name) eq 'PAN_DELTA') then begin
            oall[j]->getproperty,parms = theseparms
            xvalues = x
            yvalues = pan_delta(xvalues,theseparms,resPtr = self.oneResPtr,rlimit = rlimit)
          endif else if (strupcase(name) eq 'PAN_QENS') then begin
            oall[j]->Getproperty,parms = theseparms
            xvalues = x
            yvalues = pan_qens(xvalues,theseparms,resPtr = self.oneresptr,rlimit = rlimit)
          endif else begin
            oall[j]->getproperty,xvalues=xtempsave
            oall[j]->Setproperty,xvalues = x,/calculate
            oall[j]->Getproperty,yvalues = yvalues
            oall[j]->Setproperty,xvalues = xtempsave,/calculate
    
            if (convFlag && resExists) then begin
              ;; perform convolution if needed
              yvalues = pan_convolute(x,Self.oneresptr,yvalues)
            endif
          endelse
        endelse
        num_string = Strtrim(String(j+1),2)
        titles = [titles,+'fcomp'+num_string]
        d = [d,Transpose(Reform(yvalues))]
    endfor
  endif
endfor
text_format = '('+strtrim(string(ncols),2)+'(A10,3X))'
number_format = '('+strtrim(string(ncols),2)+'(g12.5,1X))'

openw,lun,filename,/get_lun,width = ncols
printf,lun,titles,format = text_format
for i = 0,nrows-1 do printf,lun,d[*,i],format = number_format
free_lun,lun,/force

msg = 'Output saved in: '+filename
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
ok = dialog_message(/info,msg,dialog_parent=dparent)

return
end;opan::print2text_as_excel


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Opan::printFitParameters2text_as_excel,event = event
if N_elements(*self.dataPtr) eq 0 then Return
thisPath = self.workDir
if N_elements(event) ne 0 then dparent = Event.top else dparent = 0L


filename = Self.filename
if (Strlen(filename) gt 0) then begin
  ; locate ext portion of filename
  i = Strpos(filename,'.',/reverse_search)
  ext = (i lt 0)? '' : Strmid(filename,i)
  ; strip dir path and ext from filename
  filename = File_basename(filename,ext,/fold_case)
endif
filename = filename+'_fitParameters.txt'
filters = ['*.txt','*.dat']
filename = Dialog_pickfile(dialog_parent = dparent,$
  title = 'Filename to store Fit Parameters/Errors',$
  file=filename, $
  /write,filter = filters,$
  default_ext = 'txt', $
  path = thisPath,/overwrite_prompt)
if filename eq '' then return

fitObject = *self.ocurvegroup
if (Self.twodimflag) then begin
  ; only the first model is relevant for 2D
  ngroups = N_elements(fitObject)
  okIndex = Indgen(ngroups)       ; TODO: assumes all groups are included in fit, but what if this is not the case
  oc = fitObject[0]
  ncurves = oc->Count()
  chisq = oc->Getchisq()
  if ((ncurves eq 0) or (chisq eq -1.0)) then Return    ; no functions in model or fit not yet performed

  parmNames = oc->Getparmnames()
  nparmsTotal = N_elements(parmNames)
  parms = oc->Getparms()
  parmErr = oc->Getparmerror()

  ; try to retrieve the multi-parameters - these are parameters that have a group-dependence
  ;counter = 0
  nValidParms = 0
  nMulti = n_elements(oc->getmultiparmnames())    ;Fix(nparmsTotal/ngroups)
  nSingle = n_elements(oc->getsingleparmnames())   ;nparmsTotal - nMulti*nGroups
  p = Dblarr(nSingle+nMulti,ngroups)
  perr = p
  parmNames = Strarr(nSingle+nMulti)
  index = Indgen(ngroups)
  for i=0,ncurves-1 do begin
    func = oc->Get(position=i)
    func->Getproperty, single_parmnames=singleParms, multi_parmnames=multiParms, name=funcName
    funcName = Strupcase(Strmid(funcName,4))        ; strip off the pan_ prefix
    if (singleParms[0] eq '') then nSingle = 0 else nSingle = n_elements(singleParms)
    if (nSingle gt 0) then begin
      for j=0, nSingle-1 do begin
        p[nValidParms,*] = replicate(parms[index[0]], nGroups)      ; same single parameter to all groups
        perr[nValidParms,*] = replicate(parmErr[index[0]], nGroups)
        parmNames[nValidParms] = singleParms[j]
        nValidParms++
        index = index + 1
      endfor
    endif
    nMulti = N_elements(multiParms)
    if (nMulti gt 0) then begin
      for j=0,nMulti-1 do begin
        p[nValidParms,*] = parms[index]
        perr[nValidParms,*] = parmErr[index]
        parmNames[nValidParms] = multiParms[j]
        nValidParms++
        index = index + ngroups
      endfor
    endif
  endfor

  nParms = nValidParms
  totalFits = nGroups
endif else begin
  ngroups = N_elements(fitObject)
  totalFits = 0
  goodparmnum = 0
  for i = 0,ngroups-1 do begin
    oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
    if (Self.Twodimflag && (i ne 0)) then continue          ; for 2D functions, only the first group model is required
    ncurves = oc->Count()
    chisq = oc->Getchisq()
    if (ncurves gt 0) then begin
      totalFits = totalFits + 1
      if N_elements(okIndex) eq 0 then okIndex = i else okIndex = [okIndex,i]
    endif
  endfor
  
  oc = fitObject[okIndex[0]]
  nparms = N_elements(oc->Getparms())
  p = Dblarr(nparms,totalFits)
  perr = Dblarr(nparms,totalFits)
  curveNames = Strarr(nparms)
  for i=0,nparms-1 do curveNames[i] = oc->Getcurvename(i)  ; Get the curve/function names for each parameter
  curveNames = curveNames.Uniq()  ; remove duplicates
  title = 'Functions in fit: '+Strjoin(curveNames,', ')
  
  for i = 0,totalFits-1 do begin
    oc = (Self.twodimflag)? fitObject[0] : fitObject[okIndex[i]]
    p[*,i] = oc->Getparms()
    perr[*,i] = oc->Getparmerror()
    if (i eq 0) then parmNames = oc->Getparmnames()
  endfor
  
endelse


for i=0,nparms-1 do parmNames[i] = Strjoin(Strsplit(parmNames[i],/extract))  ; remove any white space in parameter names
headers = Strarr(2*nparms)
headers[Indgen(nparms)*2] = parmNames
headers[Indgen(nparms)*2 + 1] = 'Error'
headers = ['GroupValue',headers]

qvals = (*self.yvalsptr)[0,*]
qVals = qVals[okIndex]

Openw,lun,filename,/get_lun
nstr = Strtrim(String(nparms*2 +1),2)
itemWidth = strtrim(string((max(strlen(headers))+2)  > 15),2)   ; determine a width spacing to write each item in a column
                                                                ; use the strlen of the longest name
                                                                ; Or 15 characters of that is greater
aformat = '('+nstr+'A'+itemWidth+')'
nformat = '('+nstr+'G'+itemWidth+'.7)'
Printf, lun ,headers,format=aformat
line = Dblarr(2*nparms+1)
for i=0,totalFits-1 do begin
  line[0] = qvals[i]
  line[Indgen(nparms)*2+1] = p[*,i]
  line[Indgen(nparms)*2+2] = perr[*,i]
  Printf, lun, line, format=nformat
endfor

Free_lun,lun
msg = 'Output saved in: '+filename
ok = Dialog_message(/info,msg,dialog_parent=dparent)

end


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::printFitsOnly2text_as_excel,event = event
if n_elements(*self.dataPtr) eq 0 then return
thisPath = self.workDir
if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
filters = ['*.txt','*.dat']
filename = DIALOG_PICKFILE(dialog_parent = dparent,$
  title = 'Filename to store Fitted Lineshape(s)',$
  /write,filter = filters,$
  default_ext = 'txt', $
  path = thisPath,/overwrite_prompt)
if filename ne '' then begin
  self.workdir = file_dirname(filename)
  fitObject = *self.ocurveGroup
  ngroups = n_elements(fitObject)
  ncols = 0
  for i = 0,ngroups-1 do begin
    oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
    ncurves = oc->count()
    ncols =  ncols  +    $  ;
      1 +         $  ; the independent variable
      ncurves +   $  ; the number of curves
      1              ; the overall fit
    ;HERE WE USE ALL X VALUES, NOT JUST THE UNMASKED ONES.
    ; How many rows do we need?
    x = reform((*self.xvalsPtr)[*,i])
    nx = n_elements(x)
    xSmooth = x
  endfor
  smoothing = 0
  daveTool = Self.daveTool
  msg = "Do you wish to smooth the fit results?"
  status = daveTool->PromptUserYesNo(msg,answer,title='PAN: Fit Results Output')
  if (status ne 0 && answer eq 1) then begin
    smoothing = 1
  endif
  if (smoothing) then begin
    msg = ["Data has "+strtrim(string(nx),2)+" points.","To smooth fits, enter desired points that is larger:"]
    status = daveTool->PromptUserText(msg,answer,title='PAN: Fit Results Output')
    answer = fix(answer)
    if (status ne 0 && answer ne 0) then begin
      nx = answer
      xSmooth = min(x) + findgen(nx)*(max(x) - min(x))/(nx-1.0)
    endif
  endif
  format_statement = '('+strtrim(string(ncols),2)+'f14.5)'
  nrows = nx

  ; Create a data array with the required number of rows and columns
  ; Ultimately this will be the array that is written out to a file
  for i = 0,ngroups - 1 do begin
    oc = (Self.twodimflag)? fitObject[0] : fitObject[i]
    oall = oc->get(/all)
    ncurves = oc->count()
    self->extractDataForPAN,allData=alldat,allx=x,group=i+1,val=val,allError=allerr
    nx = n_elements(xSmooth)
    grp_string = strtrim(string(i+1),2)
    if n_elements(d) eq 0 then begin
      d = [transpose(xSmooth)]
      titles = ['x'];['x'+grp_string]
    endif ;else begin
    if ncurves gt 0 then begin
      if (Self.twodimflag) then begin
        if (i eq 0) then begin
          ; need to evaluate once since all grps are caculated together
          if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
            (*self.oneresptr) = OneResStr
            rlimit=OneResStr.rlimit
          endif else self->Clearoneres_ptr
          oc->Evaluateexcel,xSmooth,yout = yfit2D,resPtr = self.oneresptr,rlimit = rlimit
        endif
        yfit = yfit2D[*,i]
      endif else begin
        if ((resExists = self->Extractoneresstr(val,OneResStr)) eq 1) then begin
          (*self.oneresptr) = OneResStr
          rlimit=OneResStr.rlimit
        endif else self->Clearoneres_ptr
          oc->Evaluateexcel,xSmooth,yout = yfit,resPtr = self.oneresptr,rlimit = rlimit
      endelse

      
      titles = [titles,'ftotal,Grp'+grp_string]
      d = [d,transpose(yfit)]
      for j = 0,ncurves-1 do begin
        if (Self.twodimflag) then begin
          if (i eq 0) then begin
            oall[j]->Getproperty,xvalues=xtempsave
            oall[j]->Setproperty,xvalues = xSmooth,/calculate
            oall[j]->Getproperty,yvalues = yvalues2D
            oall[j]->Setproperty,xvalues = xSmooth,/calculate
          endif 
          yvalues = yvalues2D[*,i]
        endif else begin
          oall[j]->Getproperty,name = name
          if Strupcase(name) eq 'PAN_DELTA' then begin
            oall[j]->Getproperty,parms = theseparms
            xvalues = xSmooth
            yvalues = Pan_delta(xvalues,theseparms,resPtr = self.oneresptr,rlimit = rlimit)
          endif else begin
            oall[j]->Getproperty,xvalues=xtempsave
            oall[j]->Setproperty,xvalues = xSmooth,/calculate
            oall[j]->Getproperty,yvalues = yvalues
            oall[j]->Setproperty,xvalues = xSmooth,/calculate
          endelse
        endelse
        num_string = Strtrim(String(j+1),2)
        titles = [titles,+'fcomp'+num_string+',Grp'+grp_string]
        d = [d,Transpose(Reform(yvalues))]
      endfor
    endif
  endfor
  text_format = '('+strtrim(string(ncols),2)+'(A12,1X))'
  number_format = '('+strtrim(string(ncols),2)+'(g12.5,1X))'

  openw,lun,filename,/get_lun,width = ncols
  printf,lun,titles,format = text_format
  for i = 0,nrows-1 do printf,lun,d[*,i],format = number_format
  free_lun,lun,/force

  msg = 'Output saved in: '+filename
  if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
  ok = dialog_message(/info,msg,dialog_parent=dparent)
endif;filename ne ''

return
end;opan::printFitsOnly2text_as_excel 


function opan::packageParmInfo
    ; Get parameter information
    widget_control,self.groupSlider,get_value = val
    val = fix(val[0]) - 1
    datSize = size(*self.dataPtr)
    if datSize[0] eq 1 then val = 0

    modelIndex = (Self.twoDimFlag)? 0 : val  
    oc = (*self.ocurvegroup)[modelIndex]

    ncurves = oc->count()
    if ncurves eq 0 then return,(-1L)
    names = oc->getnames()
    ncurves = n_elements(names)
    step = oc->getstep()
    fixed = oc->getfixed()
    lovalues = oc->getlowvalues()
    hivalues = oc->gethighvalues()
    parms = oc->getparms()
    parmnames = oc->getparmnames()
    high = oc->gethigh()
    low = oc->getlow()
    tied = oc->gettied()
    expr = oc->getExpr()

    oall = oc->get(/all)
    for i = 0,ncurves-1 do begin
       oall[i]->getproperty,parmnames = parmnames, name = name
       np = n_elements(parmnames)
       if i eq 0 then begin
            pn = parmnames
            nparms = np
       endif else begin
            nparms = [nparms,np]
            pn = [pn,parmnames]
       endelse
    endfor
    parmInfo = {  $
            nparms:nparms,names:names, step:step, fixed:fixed, $
                lovalues:lovalues, hivalues:hivalues, high:high, $
               low:low, parms:parms, parmnames:pn,tied:tied,expr:expr  $
               }
    return,parmInfo
end;opan::packageParmInfo


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan::updateParmInfo,newParmInfo
    
case newParmInfo.apply2AllGrps of

  0: begin
    widget_control,self.groupSlider,get_value = val
    val = fix(val[0]) - 1
    datSize = size(*self.dataPtr)
    if datSize[0] eq 1 then val = 0
    modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
    oc = (*self.ocurvegroup)[modelIndex]
    oc->setparms,newParmInfo.parms
    oc->setlow,newParmInfo.low
    oc->sethigh,newParmInfo.high
    oc->setlowvalues,newParmInfo.lovalues
    oc->sethighvalues,newParmInfo.hivalues
    oc->setfixed,newParmInfo.fixed
    oc->settied,newParmInfo.tied
    nparms = n_elements(oc->getparmnames())
    
    ;LRK --- ADDING THE NEXT TWO LINES TO MAKE THINGS CLEARER TO THE USER. 
    ;
    oc->setParmerror,dblarr(nparms)        ;MAKING CHANGES TO INDICATE TO USER THAT NO FIT HAS BEEN DONE.
    oc->setchisq,-1.0d   
    void = oc->UpdateModTime()
  end
  
  1: begin
    ocs = (*self.ocurveGroup)
    for i = 0, n_elements(ocs)-1 do begin
      oc = ocs[i]
      oc->setparms,newParmInfo.parms
      oc->setlow,newParmInfo.low
      oc->sethigh,newParmInfo.high
      oc->setlowvalues,newParmInfo.lovalues
      oc->sethighvalues,newParmInfo.hivalues
      oc->setfixed,newParmInfo.fixed
      oc->settied,newParmInfo.tied
      nparms = n_elements(oc->getparmnames())
      
      ;LRK --- ADDING THE NEXT TWO LINES TO MAKE THINGS CLEARER TO THE USER. 
      ;
      oc->setParmerror,dblarr(nparms)        ;MAKING CHANGES TO INDICATE TO USER THAT NO FIT HAS BEEN DONE.
      oc->setchisq,-1.0d       
      void = oc->Updatemodtime()
    endfor
  end
  
  else:

endcase
    
    
    
    return,1
end;opan::updateParmInfo


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::parameterInfo, event = event
if n_elements(*self.dataPtr) eq 0 then return
; Is there a curve present here?
widget_control,self.groupSlider,get_value = val
val = fix(val[0]) - 1
datSize = size(*self.dataPtr)
if datSize[0] eq 1 then val = 0

modelIndex = (Self.twodimflag)? 0 : val  ; if 2D flag is set use the first group model otherwise use current group's model
oModel = (*self.ocurvegroup)[modelIndex]

ncurves = oModel->count()
if ncurves eq 0 then return
; Get parameter information

thisEvent = tag_names(event,/structure_name)
case thisEvent of

  '': begin
      widget_control,event.top,sensitive = 0
      parmInfo = self->packageParmInfo()
      widget_control,self.modify,sensitive = 0
      enterparminfo,parmInfo, $
                    group_leader = event.top, $
                    notifyIds = [event.id,event.top]
    end
  
    'MODIFYPARMS2D_EVENT': begin
      if (Event.cancel ne 1) then self->refresh   ; update the display
    end
  
  'WIDGET_BUTTON': begin
      if (Self.twodimflag eq 1) then begin
        ; for 2D functions, can only modify function parameters for a single function at a time unlike for 1D
        ; so retrieve the currently selected function in the model
        oc = (*self.ocurvegroup)[modelIndex]  ; the model defined for the first group
        nCurves = oc->count()
        if (nCurves gt 1) then begin
          ; if there are more than one functions in the model
          ; then use the one currently selected by the user
          Widget_control,self.curveslider,get_value = cval
          iSel = Fix(cval[0]) - 1   ; convert to 0-based index
          if (iSel lt 0) then iSel = 0
          if (iSel ge nCurves) then iSel = nCurves - 1
        endif else iSel = 0
        oFunc = oc->Get(position = iSel)
        
        ; now launch widget to modify fit parameters for selected function
        Modifyparms2d, oFunc, group_leader = Event.top, notifyids=[self.modify,event.top]
      endif else begin
        Widget_control,Event.top,sensitive = 0
        parmInfo = self->Packageparminfo()
        Widget_control,self.modify,sensitive = 0
        Enterparminfo,parmInfo, $
          group_leader = Event.top, $
          notifyIds = [Event.id,Event.top]
      endelse
    end

  'PARMSEVENT': $
    begin
      if (Self.twodimflag eq 0) then dummy = self->updateParmInfo(*event.parmInfo)
      self->refresh
    end

  'PARMSQUITEVENT': $
    begin
     widget_control,self.modify,sensitive = 1
     widget_control,event.top,sensitive = 1
     ; Empty placeholder.  We don't want to update any of the
     ; parameter information.
     
    end
  else:
endcase

;self->displayFitParameters;, event = event
self->updateFitParmDisplay,val ;UPDATE THE FIT PARM DISPLAY
return
end;opan::parameterInfo


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::showFileInfo,event = event
    thisEvent = tag_names(event,/structure_name)
    if n_elements(*self.headerPtr) eq 0 then begin
      output = ['No data currently loaded']
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,output)
      return
    endif
    case thisEvent of
    'WIDGET_BUTTON': $
      begin

        opan_FileInfo,*self.headerPtr,group_leader = event.top, $
                  notifyIds = [event.id,event.top]

      end
    'FILEINFOEVENT': $   ; This case not really necessary
      begin
      end
    else:
    endcase

    return
end;opan::showFileInfo
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::preferences, event = event
    thisEvent = tag_names(event,/structure_name)
    case thisEvent of
    'WIDGET_BUTTON': $
      begin
        enterPref,group_leader = event.top, $
                  notifyIds = [event.id,event.top], $
                  prefs = *self.prefs

      end
    'PREFSEVENT': $
      begin
        *self.prefs = (*event.prefs)
        self.xtitle = (*self.prefs).xlabel
        self.ztitle = (*self.prefs).ylabel
        self.subtitle = (*self.prefs).subtitle

        if (n_elements(*self.odataPtr) ne 0 && $
           (*event.prefs).xenforce) then $
           self->applyCrop, (*self.prefs).xmin, (*self.prefs).xmax, event.top

        self->refresh
    ;     wset,self.resPix
    ;     self->plotResiduals
    ;     wset,self.resVis
    ;     device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix];
    ;
    ;     wset,self.datPix
    ;     self->displayData
    ;     wset,self.datVis
    ;     device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
      end
    else:
    endcase

    return
end;opan::preferences
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function html_header,title = title,username = username
    if n_elements(title) eq 0 then title = 'PAN Log Output'
    if n_elements(username) eq 0 then username = 'PAN User'

    strout = ['<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"']
    strout = [strout,'<html>']
    strout = [strout,'<body>']
    strout = [strout,'<meta http-equiv="content-type" content="text/html; charset=ISO-8859-1">']
    strout = [strout,'<meta name="author" content="PAN">']
    strout = [strout,'<title>'+title+'</title>']
    strout = [strout,'</head>']
    strout = [strout,'<body>']
    strout = [strout,'<big><big><b>PAN Data Analysis Log</b></big></big><br>']
    strout = [strout,'<br>']

    strout = [strout,'User name:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+username+'<br>']
    time = systime()
    strout = [strout,'Creation date:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'+time+'<br>']
    strout = [strout,'<br>']

    strout = [strout,'']
    return,strout
end;html_header
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function html_comments,comments = comments,str_in
    if n_elements(comments) eq 0 then return,''
    strout = [str_in,'<p>',comments,'<p>']
    return,strout
end;html_comments
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function html_finish,str_in
    strout = [str_in,'</body>','</html>']
    return,strout
end;html_finish
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function html_open,filename = filename
    if n_elements(filename) eq 0 then return,''
    openr,lun,filename,/get_lun
    dummy = ''
    count = 0
    while not(eof(lun)) do begin
      readf,lun,dummy
      if count eq 0 then strout = dummy else strout = [strout,dummy]
      count = count + 1L
    endwhile
    free_lun,lun,/force
    return,strout
end;html_open
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function html_write,filename = filename,strout = strout
    nstr = n_elements(strout)
    openw,lun,filename,/get_lun
    for i = 0,nstr-1 do begin
      printf,lun,strout[i]
    endfor
    free_lun,lun,/force
    return,0
end;html_write
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::logComment,event = event
    if n_elements(*self.logStringPtr) eq 0 then return
    strout = *self.logStringPtr
    comments = opan_getcomments(group_leader = event.top,cancelled = cancel)
    if cancel eq 1 then return

    nc = n_elements(comments)

    end_of_html = where(strout eq '</body>')
    index = end_of_html[0] - 1
    nstr = n_elements(strout)
    strout1 = [strout[0:index],'<p>',comments[0:nc-1],'<p>',strout[index:nstr-1]]
    *self.logStringPtr = strout1
    return
end;opan::logComment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::logAddPlot,event = event
    if n_elements(*self.dataPtr) eq 0 then return
    if n_elements(*self.logStringPtr) eq 0 then return
    self.jpeg = 1
    thisDevice = !d.name
    h = 11.0 & w = 8.0 & aspect1 = h/w
    xsize = 600 & ysize = fix(aspect1*xsize)
    window,/free,/pixmap,xsize = xsize,ysize = ysize
    winPix = !d.window
    wset,winPix
    self->niceOutput,event = event

    device,get_visual_depth = thisDepth
    if thisDepth eq 8 then begin
      tvlct,r,g,b,/get
      image2d = tvrd()
      s = size(image2d,/dimensions)
      image24 = bytarr(3,s[0],s[1])
      tvlct,r,g,b,/get
      image24[0,*,*] = r[image2d]
      image24[1,*,*] = g[image2d]
      image24[2,*,*] = b[image2d]
    endif
    if thisDepth gt 8 then begin
      device,decomposed = 1
      image24=tvrd(true = 1)
    endif
    wdelete,winPix
    thisPath = self.workDir
    ; Create the filename
    counter = 0
    res = 1
    while res eq 1 do begin
      filename = 'panplot_'+strtrim(string(counter),2)+'.jpg'
      testFile = filepath(filename, ROOT_DIR=self.logDirectory)
      res = file_test(testFile)
      counter = counter + 1
    endwhile

    s = Size(image24, /Dimensions)
    newx = Round(150.0 * s[1] / 72)
    newy = Round(150.0 * s[2] / 72)
    highResImage = Congrid(image24, 3, newx, newy, /Interp)

    imgFile = filename

    write_jpeg,testFile,255-highResImage,true = 1,quality = 100
    ;write_jpeg,testFile,highResImage,true = 1,quality = 100
    Set_Plot, thisDevice

    ; Ok, the file has been written.  Now we must add the plot to the HTML file.
    strout = *self.logStringPtr
    end_of_html = where(strout eq '</body>')
    index = end_of_html[0] - 1
    nstr = n_elements(strout)

    read_jpeg,testFile,img
    imgSize = size(img)
    sx = imgSize[2] & sy = imgSize[3]
    aspect2 = 1.0*sy/(1.0*sx)
    outSx = 500 & outSy = fix(1.0*outSx*aspect2)
    imgLine = '<img src="'+imgFile+'" width="'+ $
              strtrim(string(outSx),2)+ $
              '" height="'+strtrim(string(outSy),2)+'"><br>'

    strout1 = [strout[0:index],'<p>',imgLine,strout[index:nstr-1],'<p>']
    *self.logStringPtr = strout1
    self.jpeg = 0

    ;wset,self.resPix
    ;self->plotResiduals
    ;wset,self.resVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]
    ;
    ;wset,self.datPix
    ;self->displayData
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
    self->refresh

    return
end;opan::logAddPlot
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::newHTMLFile,event = event
    ; This method asks the user to provide a new directory
    ; Change directories to the user's working directory
    cd,current = currentDir
    cd,self.workDir
    ; Get the user to enter a directory name
    result = opan_getdirectory(group_leader = event.top,cancelled = cancel)
    if cancel then return
    thisDir = result[0]
    user = result[1]
    title = result[2]
    if thisDir eq '' or thisDir eq ' ' then return
    ; Create the directory
    file_mkdir,thisDir
    cd,currentDir
    ;self.logDirectory = thisDir
    self.logDirectory = filepath('',root_dir = self.workDir,subdir = [thisDir])
    ; Create the log file name with a fully-qualified path
    *self.logStringPtr = html_header(title = title,username = user)
    *self.logStringPtr = html_finish(*self.logStringPtr)
    self.logFile =filepath('index.html',ROOT_DIR=self.workDir,subdir=[thisDir])
    widget_control,self.logFileDisplay,set_value = self.logFile
    widget_control,self.logFileStatus,set_value = 'open'

    ; Sensitize or desensitize the appropriate buttons
    widget_control,self.newHTML,sensitive = 0
    widget_control,self.existingHTML,sensitive = 0
    widget_control,self.closeHTML,sensitive = 1
    widget_control,self.plotHTML,sensitive = 1
    widget_control,self.commentHTML,sensitive = 1

    return
end;opan::newHTMLFile
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::existingHTMLFile,event = event
    ; This method reads in an existing log file and allows the user to append
    ; more information to it.
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = dialog_pickfile(dialog_parent = dparent,file = 'index.html', $
               title = 'Select the HTML log file',filter = '*.html', $
               path = self.workDir,get_path = logDirectory)
    self.logDirectory = logDirectory
    if filename eq '' or filename eq ' ' or not(file_test(filename)) then begin
      strout = 'Not a valid file selection'
      if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
      void = dialog_message(dialog_parent = dparent,strout)
      return
    endif
    self.logFile = filename
    *self.logStringPtr = html_open(filename = filename)
    widget_control,self.logFileDisplay,set_value = self.logFile
    widget_control,self.logFileStatus,set_value = 'open'

    ; Sensitize or desensitize the appropriate buttons
    widget_control,self.newHTML,sensitive = 0
    widget_control,self.existingHTML,sensitive = 0
    widget_control,self.closeHTML,sensitive = 1
    widget_control,self.plotHTML,sensitive = 1
    widget_control,self.commentHTML,sensitive = 1

    return
end;opan::existingHTMLFile
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::closeHTMLFile,event = event
    if n_elements(*self.logStringPtr) eq 0 then return
    ; Write the html file
    dummy = html_write(filename = self.logFile,strout = *self.logStringPtr)
    ptr_free,self.logStringPtr
    self.logStringPtr = ptr_new(/allocate_heap)
    widget_control,self.logFileDisplay,set_value = ''
    widget_control,self.logFileStatus,set_value = 'closed'

    ; Sensitize or desensitize the appropriate buttons
    widget_control,self.newHTML,sensitive = 1
    widget_control,self.existingHTML,sensitive = 1
    widget_control,self.closeHTML,sensitive = 0
    widget_control,self.plotHTML,sensitive = 0
    widget_control,self.commentHTML,sensitive = 0
    return
end;opan::closeHTMLFile
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::refresh,wintitle=wintitle,_Extra = extra
    device, get_decomposed=old_dc
    device, decomposed=1

    wset,self.datPix
    if n_elements(wintitle) eq 0 then wintitle = file_basename(self.filename)
    widget_control,self.tlb,tlb_set_title='PAN: Peak Analysis - '+wintitle

    self->displayData, _Extra=extra

    wset,self.datVis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]


    wset,self.resPix
    self->plotResiduals, _Extra=extra
    wset,self.resVis
    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]



    device, decomposed=old_dc

    self->updateFitParmDisplay,val ;UPDATE THE FIT PARM DISPLAY

end;opan::refresh
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::pan_help,event = event
;    pdf_file = !DAVE_PDFHELP_DIR+'pandoc.pdf'
    pdf_file = !DAVE_PDFHELP_DIR+'pandoc_DAVE.pdf'
    if strupcase(!version.os_family) eq 'WINDOWS' then pdf_file = '"'+pdf_file+'"' 
    ;pdf_file = file_which('pandoc.pdf',/include_current_dir)
    void = launch_help(pdf_file,tlb = event.top)
end;opan::pan_help
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::pan_user_macros_help,event = event
    pdf_file = !DAVE_PDFHELP_DIR+'pan_user_macros.pdf'
    if strupcase(!version.os_family) eq 'WINDOWS' then pdf_file = '"'+pdf_file+'"' 
    ;pdf_file = file_which('pan_user_macros.pdf',/include_current_dir)
    void = launch_help(pdf_file,tlb = event.top)
end;opan::pan_user_macros_help
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::view_corr_matrix,event = event
    thisEvent = tag_names(event,/structure_name)
    case thisEvent of
    'WIDGET_BUTTON':  $
       begin
    ; Which detector/fit is currently selected?
         widget_control,self.groupSlider,get_value = val
         val = fix(val[0])-1
         if n_elements(*self.dataPtr) eq 0 then return
         datSize = size(*self.dataPtr)
         if datSize[0] eq 1 then val = 0
         oc = (*self.ocurveGroup)[val]
         oc->displayparms,output = output
         ncurves = oc->count()
         if ncurves gt 0 then begin
          widget_control,self.curveSlider,set_slider_max = (ncurves > 2)
         endif
         if n_elements(output) eq 0 then begin
           output = 'No curves present'
         endif
         oc->get_pcor,pcor
         if n_elements(pcor) eq 1 then return
         parmnames = oc->getparmnames()
         nparms = n_elements(parmnames)
         new_parmnames = strarr(nparms)
         for i = 0,nparms-1 do begin
          new_parmnames[i] = '#'+strtrim(string(i),2)+': '+parmnames[i]
         endfor
         bad_index = where(finite(pcor) ne 1, count_bad)
         if count_bad gt 0 then pcor[bad_index] = -1.e6

         rains_display_correlation,  pcor,            $
                      new_parmnames,       $
                      group_leader = event.top,  $
                      notify_ids = [event.id,event.top]
       end
    else:
    endcase
end;opan::view_corr_matrix
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;pro opan::mc_estimate,event = event
;    widget_control,self.ndata_field,get_value = val
;    self.ndata = fix(val) > 2
;    ; Get the current data set
;    widget_control,self.groupSlider,get_value = val
;    val = fix(val[0])-1
;    if n_elements(*self.ocurvegroup) eq 0 then return
;    oc = (*self.ocurveGroup)[val]
;    parms = oc->getparms()
;    parinfo = oc->createparinfo()
;
;    if oc->count() eq 0 then return
;    datSize = size(*self.dataPtr)
;    if datSize[0] eq 2 then begin
;      y = (*self.dataPtr)[*,val]
;      yerr = (*self.errorPtr)[*,val]
;      x = (*self.xvalsPtr)[*,val]
;    endif else begin
;      y = reform(*self.dataPtr)
;      yerr = reform(*self.errorPtr)
;      x = reform(*self.xvalsPtr)
;    endelse
;    xptr = ptr_new(x)
;    ; Get the current fitting range for the data
;    limits = where((x ge (*self.prefs).xfitlo) and (x le (*self.prefs).xfithi))
;    xlim = x[limits]
;    ylim = y[limits]
;    dylim = yerr[limits]
;    nx = n_elements(xlim)
;
;    msg = 'Estimating errors using the "bootstrap" Monte-Carlo method'
;    title = 'Progress'
;    progressBar = Obj_New("SHOWPROGRESS",message = msg,title = title, $
;       event.top,/cancelbutton)
;    progressBar->Start
;    dy = dylim
;    w = 1./dy^2
;
;    iterargs = {stopBut:self.interrupt}
;    iterproc = 'pan_iterproc'
;    widget_control,self.fitstatfield,set_value = self.fitstatus[1]
;    ;widget_control,self.interrupt,sensitive = 1
;    ;widget_control,self.interrupt,/clear_events
;    np = n_elements(parms)
;    mc_parms = fltarr(np,self.ndata)
;
;    for i = 0L,self.ndata-1 do begin
;       r_normal = randomn(s,nx)
;       derr = dylim*r_normal
;       y = ylim+derr
;       widget_control,self.interrupt,sensitive = 1
;       widget_control,self.interrupt,/clear_events
;       yf = mpcurvefit(xlim,y,w,parms,sigma,                                $
;             function_name = 'fitfunction', status = status,                $
;             parinfo = parinfo, itmax = (*self.prefs).maxiter,              $
;             /quiet,chisq = chisq,iterargs = iterargs,iterproc = iterproc,  $
;             functargs = {oc:oc,xptr:xptr}, covar = covar,/autoderivative,  $
;             errmsg = errmsg                                                )
;       widget_control,self.interrupt,sensitive = 0
;       widget_control,self.fitstatfield,set_value = self.fitstatus[0]
;
;       if n_elements(parms) eq np then begin     
;         mc_parms[*,i] = parms
;       endif else begin
;        print,'parms=',parms
;       endelse
;       
;       progressBar->update,(i+1)*100/self.ndata
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;I THINK FROM HERE TO MY NEXT NOTE SHOULD BE IN THIS LOOP OVER i 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;    widget_control,self.interrupt,/clear_events
;    if status le 0 then begin
;       self.status = 0
;       strout = 'Fit cancelled'
;       widget_control,self.fitstatfield,set_value = strout
;    endif else begin
;       self.status = 1
;    endelse
;    ptr_free,xptr
;
;;    if obj_valid(progressBar) then progressBar->Destroy
;;    obj_destroy, progressBar
;
;
;
;
;
;
;
;
;       cancelled = progressBar->CheckCancel()
;       if cancelled then begin
;          progressBar->Destroy
;          i = self.ndata-1
;       endif
;    endfor;i
;
;
;    ; Do the statistics on the parameters
;    presult = fltarr(np)
;    dpresult = fltarr(np)
;
;    for ii = 0,np-1 do begin
;       p = mc_parms[ii,*]
;       pstats = moment(p)
;       presult[ii] = pstats[0]
;       dpresult[ii] = sqrt(pstats[1])
;    endfor
;
;    ; Put these results into the parameter
;    oc->setparmerror,dpresult
;
;
;    oc->setparms,parms
;    oc->evaluate,x,yout = yfit
;    ; Calculate the residuals
;    yfit = yfit[limits]
;    dof = n_elements(yfit) - np
;    chi_sq = (total(((yfit-ylim)/dy)^2))/dof
;    oc->setchisq,chi_sq
;
;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;I THINK FROM HERE TO MY NEXT NOTE SHOULD BE IN THE MAIN LOOP OVER i ABOVE
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;    ; Do the statistics on the parameters
;;    presult = fltarr(np)
;;    dpresult = fltarr(np)
;;
;;    for i = 0,np-1 do begin
;;       p = mc_parms[i,*]
;;       pstats = moment(p)
;;       presult[i] = pstats[0]
;;       dpresult[i] = sqrt(pstats[1])
;;    endfor
;;
;;    ; Put these results into the parameter
;;    oc->setparmerror,dpresult
;;
;;    widget_control,self.interrupt,/clear_events
;;    if status le 0 then begin
;;       self.status = 0
;;       strout = 'Fit cancelled'
;;       widget_control,self.fitstatfield,set_value = strout
;;    endif else begin
;;       self.status = 1
;;    endelse
;;    ptr_free,xptr
;;
;;    if obj_valid(progressBar) then progressBar->Destroy
;;    obj_destroy, progressBar
;;
;;    oc->setparms,parms
;;    oc->evaluate,x,yout = yfit
;;    ; Calculate the residuals
;;    yfit = yfit[limits]
;;    dof = n_elements(yfit) - np
;;    chi_sq = (total(((yfit-ylim)/dy)^2))/dof
;;    oc->setchisq,chi_sq
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;END OF STUFF I THINK SHOULD BE IN THE MAIN LOOP
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;    wset,self.resPix
;    self->plotresiduals
;    wset,self.resVis
;    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]
;
;    wset,self.datPix
;    self->displaydata
;    wset,self.datVis
;    device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
;
;    ; Display the parameters
;    self->displayFitParameters
;
;end;opan::mc_estimate

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::mc_estimate,event = event

widget_control,self.ndata_field,get_value = val
self.ndata = fix(val) > 2

; Get the current data set
widget_control,self.groupSlider,get_value = val
val = fix(val[0])-1
if n_elements(*self.ocurvegroup) eq 0 then return
oc = (*self.ocurveGroup)[val]
parms = oc->getparms()
parinfo = oc->createparinfo()

self->extractDataForPAN,dat=y,derr=yerr,x=x,val=val,dSize=datSize

; apply user specified limits in x
limits = where((x ge (*self.prefs).xfitlo) and (x le (*self.prefs).xfithi))
xlim = x[limits]
ylim = y[limits]
dylim = yerr[limits]
wlim = yerr[limits]
w = 1.0/dylim^2
      
nx = n_elements(xlim)                         
xPtr = ptr_new(x)

; If there is a resolution function present then use it!
resExists = self->ExtractOneResStr(val,OneResStr)
if resExists ne 0 then begin
  (*self.oneResPtr) = OneResStr
  rlimit=OneResStr.rlimit
endif else begin
  self->clearOneRes_ptr
endelse

msg = 'Estimating errors using the "bootstrap" Monte-Carlo method'
title = 'Progress'
progressBar = Obj_New("SHOWPROGRESS",message = msg,title = title, $
   event.top,/cancelbutton)
progressBar->Start

iterargs = {stopBut:self.interrupt}
iterproc = 'pan_iterproc'
widget_control,self.fitstatfield,set_value = self.fitstatus[1]
np = n_elements(parms)
mc_parms = fltarr(np,self.ndata)

for i = 0L,self.ndata-1 do begin
  r_normal = randomn(s,nx)
  derr = dylim*r_normal
  y = ylim+derr  ; new data to be fitted
  widget_control,self.interrupt,sensitive = 1
  widget_control,self.interrupt,/clear_events
  if (n_elements(*self.resPtr) eq 0)  or (resExists eq 0) then begin
    yf = mpcurvefit(xlim, y, w, parms, sigma, $
                    FUNCTION_NAME='fitfunction', $
                    status = status, $
                    quiet = 0,$;1,$
                    itmax = (*self.prefs).maxIter, $
                    chisq = chisq, $
                    parinfo = parinfo, $
                    functargs = {oc:oc,xPtr:xPtr},$
                    iterargs = iterargs, $
                    iterProc = iterProc, $
                    /autoderivative, $
                    covar = covar,   $
                    ERRMSG=errmsg)
  endif else begin
    yf = mpcurvefit(xlim, y, w, parms, sigma, $
                    FUNCTION_NAME='fitfunction', $
                    status = status, $
                    quiet = quiet, $
                    itmax = (*self.prefs).maxIter, $
                    chisq = chisq, $
                    parinfo = parinfo, $
                    iterargs = iterargs, $
                    iterProc = iterProc, $
                    functargs = {oc:oc,xPtr:xPtr,resPtr:self.oneResPtr, rlimit:rlimit}, $
                    /autoderivative, $
                    covar = covar,   $
                    ERRMSG=errmsg)
  endelse
  oc->setXValues,x 

   widget_control,self.interrupt,sensitive = 0
   widget_control,self.fitstatfield,set_value = self.fitstatus[0]
   mc_parms[*,i] = parms

   progressBar->update,(i+1)*100/self.ndata

   cancelled = progressBar->CheckCancel()
   if cancelled then begin
      progressBar->Destroy
      i = self.ndata-1
   endif
endfor;i

; Do statistics on the parameters
presult = fltarr(np)
dpresult = fltarr(np)

for i = 0,np-1 do begin
   p = mc_parms[i,*]
   pstats = moment(p)
   presult[i] = pstats[0]         ;<-- mean
   dpresult[i] = sqrt(pstats[1])  ; <-- standard deviation
endfor

; Save as the parameter errors
oc->setparmerror,dpresult

widget_control,self.interrupt,/clear_events
if status le 0 then begin
   self.status = 0
   strout = 'Fit cancelled'
   widget_control,self.fitstatfield,set_value = strout
endif else begin
   self.status = 1
endelse
ptr_free,xptr

if obj_valid(progressBar) then progressBar->Destroy
obj_destroy, progressBar

oc->setparms,parms
oc->evaluate,x,yout = yfit

; Calculate the residuals
yfit = yfit[limits]
dof = n_elements(yfit) - np
chi_sq = (total(((yfit-ylim)/dylim)^2))/dof
oc->setchisq,chi_sq


wset,self.resPix
self->plotresiduals
wset,self.resVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]

wset,self.datPix
self->displaydata
wset,self.datVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]

; Display the parameters
self->displayFitParameters

end;opan::mc_estimate


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::createWidgets,wintitle=wintitle

if n_elements(wintitle) eq 0 then wintitle = ''

; Widget creation module
if self.group_leader eq (-1L) then begin
  tlb = widget_base(/row, $
        title = 'PAN: Peak Analysis - '+wintitle,mbar = bar,/tlb_size_events)
endif else begin
  tlb = widget_base(group_leader = self.group_leader,/row, $
        title = 'PAN: Peak Analysis - '+wintitle,mbar = bar,/tlb_size_events);, $
;        /kbrd_focus_events)
endelse
self.tlb = tlb

font = (!version.os_family eq 'Windows')? 'Courier New*16' : $
       '-adobe-courier-bold-r-normal--18-180-75-75-m-110-iso8859-1'

filemenu = widget_button(bar,value = 'File',/menu,font=font)
datmenu = widget_button(bar,value = 'Data',/menu,font=font)
resmenu = widget_button(bar,value = 'Resolution',/menu,font=font)
plotmenu = widget_button(bar,value = 'Plot_Options',/menu,font=font)
hot_keymenu = widget_button(bar,value = 'Hot_Keys',/menu,font=font)


printmenu = widget_button(bar,value = 'Print',/menu,font=font)
helpmenu = widget_button(bar,value = 'Help',/menu,font=font)
;miscmenu = widget_button(bar,value = 'Miscellaneous',/menu)
void = widget_button(helpmenu,value = 'PAN Help', $
   uvalue = {object:self,method:'pan_help'})
void = widget_button(helpmenu,value = 'PAN User Macros Help', $
   uvalue = {object:self,method:'pan_user_macros_help'},uname = 'PAN_HELP')
void = widget_button(helpmenu,value = 'About PAN',$
       uvalue = {object:self,method:'aboutPAN'})

; File Menu
void = Widget_button(filemenu,value = 'Save Fitted Lineshape as DAVE data file', $
  uvalue = {object:self,method:'saveDaveFits'})
void = Widget_button(filemenu,value = 'Export Fitted Lineshape to DAVE Data Browser', $
  uvalue = {object:self,method:'exportDaveFits'})

void = Widget_button(filemenu,value = 'Save Data, Fitted Lineshape(s) to ASCII', $
  uvalue = {object:self,method:'print2text'},/separator)

void = Widget_button(filemenu,value = 'Save Data, Selected Fitted Lineshape to ASCII', $
  uvalue = {object:self,method:'print2textSelect'})

void = Widget_button(filemenu,value = 'Save Data, Fitted Lineshape(s) to ASCII columns', $
  uvalue = {object:self,method:'print2text_as_excel'})
    
void = Widget_button(filemenu,value = 'Save Fitted Parameters/Errors to ASCII columns', $
  uvalue = {object:self,method:'printFitParameters2text_as_excel'},/separator)

void = Widget_button(filemenu,value = 'Save Fit Model as ASCII',$
  uvalue = {object:self,method:'saveParmsAsText'},/separator)
void = Widget_button(filemenu,value = 'Save Fit Model plus Data/Res as ASCII',$
  uvalue = {object:self,method:'saveParmsAsText',etc:{writedataandres:1}})
void = Widget_button(filemenu,value = 'Read in Fit Model from file',$
  uvalue = {object:self,method:'readParmsAsText'})

void = widget_button(filemenu,value = 'Preferences',$
       uvalue = {object:self,method:'preferences'},/separator)
void = widget_button(filemenu,value = 'Quit',/separator,$
       uvalue = {object:self,method:'quit'})

; Data Menu
void = widget_button(datmenu,value = 'Load DAVE file', $
       uvalue = {object:self,method:'loadDave'})
asciiMenu = widget_button(datmenu,value = 'Load ASCII Data File',/menu)
void = widget_button(asciimenu,value = '3-Column ASCII format', $
       uvalue = {object:self,method:'loadasciidata'})
void = widget_button(asciimenu,value = 'Grouped ASCII format (2D)', $
       uvalue = {object:self,method:'loadgroupdata'})

void = widget_button(datmenu,value = 'Load Test Data (Rotational Tunneling)', $
       uvalue = {object:self,method:'loadtestdata'})
void = Widget_button(datmenu,value = 'Load Test Data (Recoil - Impulse Approx)', $
uvalue = {object:self,method:'loadtestdata2'})
void = widget_button(datmenu,value = 'Display Info about Loaded Data',$
       uvalue = {object:self,method:'showFileInfo'},/separator)

;LRK - 103008
;SWAPPING IN THE NEW REBINNING METHOD
;    void = widget_button(datmenu,value = 'Rebin data', $
;           uvalue = {object:self,method:'rebinData'},/separator)
void = widget_button(datmenu,value = 'Rebin Data', $
       uvalue = {object:self,method:'rebinData_NEW'},/separator)
void = widget_button(datmenu,value = 'Crop Data', $
       uvalue = {object:self,method:'cropData'})

void = widget_button(datmenu,value = 'Edit Mask', $
       uvalue = {object:self,method:'editPanMask'})

;void = widget_button(datmenu,value = 'Exclude data', $
;       uvalue = {object:self,method:'excludeData'})
void = widget_button(datmenu,value = 'Restore Original Data', $
       uvalue = {object:self,method:'rebinRestore'})

void = widget_button(datmenu,value = 'Save Data, Fitted Lineshape(s) to ASCII File', $
       uvalue = {object:self,method:'print2text'},/separator)

void = widget_button(datmenu,value = 'Save Data, Selected Fitted Lineshape(s) to ASCII', $
       uvalue = {object:self,method:'print2textSelect'})

void = widget_button(datmenu,value = 'Save Data. Fitted Lineshapes(s) to ASCII column', $
       uvalue = {object:self,method:'print2text_as_excel'})

void = widget_button(datmenu,value = 'Save Fitted Parameters/Errors to ASCII column', $
       uvalue = {object:self,method:'printFitsOnly2text_as_excel'},/separator)

;void = widget_button(datmenu,value = 'Flush and close all open files', $
;       uvalue = {object:self,method:'flushAndCloseOpenedFiles'},/separator)


; Resolution Menu
void = widget_button(resmenu,value = 'Load DAVE Data as Resolution Function', $
       uvalue = {object:self,method:'loadDaveRes'})
resasciiMenu = widget_button(resmenu,value = 'Load ASCII Resolution File',/menu)
void = widget_button(resasciimenu,value = '3-Column ASCII format', $
       uvalue = {object:self,method:'load_3col_ascii_res'})
void = widget_button(resasciimenu,value = 'Group ASCII format (2D)', $
       uvalue = {object:self,method:'load_group_ascii_res'})
void = widget_button(resmenu,value = 'Load Test Resolution Function(Rot Tunneling)', $
   uvalue = {object:self,method:'loadtestres'})
void = widget_button(resmenu,value = 'Change Resolution Domain (Crop)', $
       uvalue = {object:self,method:'cropRes'},/separator)

;LRK - 103008
;SWAPPING IN THE NEW REBINNING METHOD
;    void = widget_button(resmenu,value = 'Rebin Resolution data', $
;           uvalue = {object:self,method:'rebinRes'})
void = widget_button(resmenu,value = 'Rebin Resolution Function', $
       uvalue = {object:self,method:'rebinRes_NEW'})
void = widget_button(resmenu,value = 'Restore Resolution Function', $
       uvalue = {object:self,method:'restoreRes'})
void = widget_button(resmenu,value = 'Clear Resolution Function', $
       uvalue = {object:self,method:'clearDaveRes'},/separator)


; Print menu
void = widget_button(printmenu,value = 'Printer', $
       uvalue = {object:self,method:'print2Printer'})
void = widget_button(printmenu,value = 'Print Plot to .JPEG file', $
       uvalue = {object:self,method:'print2jpeg'})
void = widget_button(printmenu,value = 'Print Plot to PS file', $
       uvalue = {object:self,method:'print2ps'})
;void = widget_button(printmenu,value = 'Print data and fits to text file', $
;       uvalue = {object:self,method:'print2text'})
;
;void = widget_button(printmenu,value = 'Print data, fits and selected curve to text file', $
;       uvalue = {object:self,method:'print2textSelect'})
;
;void = widget_button(printmenu,value = 'Print data and fits to EXCEL-readable ASCII', $
;       uvalue = {object:self,method:'print2text_as_excel'})

void = widget_button(printmenu,value = 'Quick Overplot', $
       uvalue = {object:self,method:'quickOverplot'})

void = widget_button(plotmenu,value = 'XLog  No', $
       uvalue = {object:self,method:'TogglePlotXLog',state:0},$
       uname='PLOTXLOGBUTTON')
void = widget_button(plotmenu,value = 'YLog  No', $
       uvalue = {object:self,method:'TogglePlotYLog',state:0},$
       uname='PLOTYLOGBUTTON')
void = widget_button(plotmenu,value = 'Unzoom', $
       uvalue = {object:self,method:'UnzoomMenu',state:0},$
       uname='UNZOOMMENUBUTTON')

void = widget_button(hot_keymenu,value = 'Hot Keys (b,g,l,d,D,f,F) - On', $
       uvalue = {object:self,method:'ToggleHotKeys',state:1},$
       uname='HOTKEYBUTTON')

ctrlBase = widget_base(tlb,/col,/base_align_center);,uvalue = {object:self,method:'fitCurrent'})
self.ctrlBase = ctrlBase
self.timerID = ctrlBase

if (!ftkwwFlag) then begin
  desc1D = ['1\Add Function to 1D Model' $
    ,'1\Background' $
    ,'0\Linear' $
    ,'0\Polynomial Deg5' $
    ,'2\Baseline (empirical)' $
    ,'1\Exponential' $
    ,'0\Kohlrausch-Williams-Watts' $
    ,'0\FT Kohlrausch-Williams-Watts' $
    ,'0\Exponential Decay' $
    ,'2\Exponential Growth' $
;    ,'2\Exponential GrowthDecay' $
    ,'1\Momentum Dist' $
    ,'0\Hydrogen Rotation+Recoil' $
    ;,'0\J(Q,y) - Additive Approach' $
    ,'2\J(Q,y) - Convolution Function' $
    ;,'0\J(Q,y) - CF + Model n(k)' $
    ;,'0\Calculated Np' $
    ;,'2\Calculated FSE' $
    ,'1\Quasielastic' $
    ,'2\QENS' $
    ,'1\Peak' $
    ,'0\Delta (resolution)' $
    ,'0\DHO' $
    ,'0\Gaussian' $
    ,'0\Lorentzian' $
    ,'0\Gaussian+Bkgd (auto)' $
    ,'0\Lorentzian+Bkgd (auto)' $
    ,'0\Log-Normal' $
    ,'0\Bi Gaussian' $
    ,'2\Voigt' $
    ,'1\Phase Transition' $
    ,'0\Order Parameter' $
    ,'2\Meanfield Order Parameter' $
    ,'1\User Defined' $
    ,'0\User Function' $
    ,'2\User Macro' $
    ,'1\Other' $
    ,'0\Rouse_scaled' $
    ,'2\IkedaCarpenter' $
    ]

  func_names1D = ['Add 1D Curve/Function' $
    ,'Background' $
    ,'Linearbkgd' $
    ,'Polynomial5Bkgd' $
    ,'Baseline' $
    ,'Exponential' $
    ,'KWW' $
    ,'FT_KWW' $
    ,'ExponentialDecay' $
    ,'ExponentialGrowth' $
;    ,'ExponentialGrowthDecay' $
    ,'Momentum Dist' $
    ,'HydrogenRotRecoil' $
    ;,'QFluidAA' $
    ,'QFluidJqyCF' $
    ;,'QFluidJqyNp' $
    ;,'QFluidCalcNp' $
    ;,'QFluidCalcFSE' $
    ,'Quasielastic' $
    ,'QENS' $
    ,'Peak' $
    ,'Delta' $
    ,'DHO' $
    ,'Gaussian' $
    ,'Lorentzian' $
    ,'AutoGaussian' $
    ,'AutoLorentzian' $
    ,'LogNormal' $
    ,'BiGaussian' $
    ,'Voigt' $
    ,'Phase Transition' $
    ,'OrderParameter' $
    ,'MeanfieldOrderParameter' $
    ,'User Defined' $
    ,'Userfunction' $
    ,'Macrofunction' $
    ,'Other' $
    ,'Rouse_scaled' $
    ,'IkedaCarpenter' $
    ]
                  ;  
                  ;  curveNames =   [  'Select function',   $
                  ;    'AutoGaussian',      $
                  ;    'AutoLorentzian',    $
                  ;    'Background',        $
                  ;    'Baseline',          $
                  ;    'Decay',             $
                  ;    'Delta',             $
                  ;    'DHO',               $
                  ;    'FT_KWW', $
                  ;    ;'FT_KWW_NEW', $
                  ;    ;'FT_KWW_AAC', $
                  ;    ;'FT_KWW_RAJAGOPAL', $
                  ;    ;'FT_KWW_NEW_FFT', $
                  ;    ;'FourthOrder',$
                  ;    ;'NSE_Deformation',$
                  ;    'Gaussian',          $
                  ;    'Ikeda Carpenter',   $
                  ;    'KWW',               $
                  ;    ;                  'kohlrausch',        $
                  ;    'Lognormal',         $
                  ;    'Lorentzian',        $
                  ;    'MeanfieldOrderParameter', $
                  ;    'OrderParameter', $
                  ;    'Qens',              $
                  ;    'QFluidJqyCF', $
                  ;    'Recoil2D', $
                  ;    ;'RouseApprox', $
                  ;    'Rouse_scaled', $
                  ;    'Step',              $
                  ;    'Voigt',             $
                  ;    'Userfunction',      $
                  ;    'User macro function']      
endif else begin
  desc1D = ['1\Add Function to 1D Model' $
    ,'1\Background' $
    ,'0\Linear' $
    ,'0\Polynomial Deg5' $
    ,'2\Baseline (empirical)' $
    ,'1\Exponential' $
    ,'0\Kohlrausch-Williams-Watts' $
;    ,'0\FT Kohlrausch-Williams-Watts' $
    ,'0\Exponential Decay' $
    ,'2\Exponential Growth' $
;    ,'2\Exponential GrowthDecay' $
    ,'1\Momentum Dist' $
    ,'0\Hydrogen Rotation+Recoil' $
    ;,'0\J(Q,y) - Additive Approach' $
    ,'2\J(Q,y) - Convolution Function' $
    ;,'0\J(Q,y) - CF + Model n(k)' $
    ;,'0\Calculated Np' $
    ;,'2\Calculated FSE' $
    ,'1\Quasielastic' $
    ,'2\QENS' $
    ,'1\Peak' $
    ,'0\Delta (resolution)' $
    ,'0\DHO' $
    ,'0\Gaussian' $
    ,'0\Lorentzian' $
    ,'0\Gaussian+Bkgd (auto)' $
    ,'0\Lorentzian+Bkgd (auto)' $
    ,'0\Log-Normal' $
    ,'0\Bi Gaussian' $
    ,'2\Voigt' $
    ,'1\Phase Transition' $
    ,'0\Order Parameter' $
    ,'2\Meanfield Order Parameter' $
    ,'1\User Defined' $
    ,'0\User Function' $
    ,'2\User Macro' $
    ,'1\Other' $
    ,'0\Rouse_scaled' $
    ,'2\IkedaCarpenter' $
    ]

  func_names1D = ['Add 1D Curve/Function' $
    ,'Background' $
    ,'Linearbkgd' $
    ,'Polynomial5Bkgd' $
    ,'Baseline' $
    ,'Exponential' $
    ,'KWW' $
;    ,'FT_KWW' $
    ,'ExponentialDecay' $
    ,'ExponentialGrowth' $
;    ,'ExponentialGrowthDecay' $
    ,'Momentum Dist' $
    ,'HydrogenRotRecoil' $
    ;,'QFluidAA' $
    ,'QFluidJqyCF' $
    ;,'QFluidJqyNp' $
    ;,'QFluidCalcNp' $
    ;,'QFluidCalcFSE' $
    ,'Quasielastic' $
    ,'QENS' $
    ,'Peak' $
    ,'Delta' $
    ,'DHO' $
    ,'Gaussian' $
    ,'Lorentzian' $
    ,'AutoGaussian' $
    ,'AutoLorentzian' $
    ,'LogNormal' $
    ,'BiGaussian' $
    ,'Voigt' $
    ,'Phase Transition' $
    ,'OrderParameter' $
    ,'MeanfieldOrderParameter' $
    ,'User Defined' $
    ,'Userfunction' $
    ,'Macrofunction' $
    ,'Other' $
    ,'Rouse_scaled' $
    ,'IkedaCarpenter' $
    ]
          ;
          ;  curveNames =   [  'Select function',   $
          ;    'AutoGaussian',      $
          ;    'AutoLorentzian',    $
          ;    'Background',        $
          ;    'Baseline',          $
          ;    'Decay',             $
          ;    'Delta',             $
          ;    'DHO',               $
          ;    ;'FT_KWW_NEW', $
          ;    ;'FT_KWW_AAC', $
          ;    ;'FT_KWW_RAJAGOPAL', $
          ;    ;'FT_KWW_NEW_FFT', $
          ;    ;'FourthOrder',$
          ;    ;'NSE_Deformation',$
          ;    'Gaussian',          $
          ;    'Ikeda Carpenter',   $
          ;    'KWW',               $
          ;    ;                  'kohlrausch',        $
          ;    'Lognormal',         $
          ;    'Lorentzian',        $
          ;    'MeanfieldOrderParameter', $
          ;    'OrderParameter', $
          ;    'Qens',              $
          ;    'QFluidJqyCF', $
          ;    'Recoil2D', $
          ;    ;'RouseApprox', $
          ;    'Rouse_scaled', $
          ;    'Step',              $
          ;    'Voigt',             $
          ;    'Userfunction',      $
          ;    'User macro function']      
endelse
desc2D = ['1\Add Function to 2D Model' $
  ,'1\Background' $
  ,'0\Constant 2D' $
  ,'0\Linear 2D' $
  ,'2\Empirical 2D' $
  ,'1\Peak' $
  ,'1\Delta 2D (resolution)' $
  ,'0\Global Area' $
  ,'0\Global Center' $
  ,'0\Global Area/Center' $
  ,'2\Independent Area/Center' $
  ,'1\Gaussian 2D' $
  ,'0\Independent Area+Width+Center' $
  ,'0\Global Area+Width+Center' $
  ,'0\Global Area and Width' $
  ,'0\Global Area' $
  ,'0\Global Width' $
  ,'0\Global Width Q dep' $
  ,'2\Global Width Q^2 dep' $
  ,'1\Lorentzian 2D' $
  ,'0\Independent Area+Width+Center' $
  ,'0\Global Area+Width+Center' $
  ,'0\Global Area and Width' $
  ,'0\Global Area' $
  ,'0\Global Width' $
  ,'0\Global Width Q dep' $
  ,'2\Global Width Q^2 dep' $
  ,'2\Recoil 2D' $
  ,'1\Diffusion' $
  ,'1\Jump' $
  ,'0\Chudley-Elliot' $
  ,'0\Hall-Ross' $
  ,'2\Singwi-Sjolander' $
  ,'1\Decoupled Translation Rotation' $
  ,'2\Hall-Ross' $  ;-------------
  ,'0\Translational Diffusion' $
  ,'0\2-Fold Jump on a Circle' $
  ,'0\3-Fold Jump on a Circle' $
  ,'0\N-Fold Jump on a Circle' $
  ,'0\Bounded Jump Diffusion' $
  ,'0\Random Jump Diffusion' $
  ,'0\Diffusion in a Sphere' $
  ,'2\Isotropic Rotational Diffusion' $
  ,'1\Tunneling' $
  ,'0\3-Fold Tunneling' $
  ,'2\Broadened 3-Fold Tunneling' $
  ,'1\User Defined' $
  ,'2\User Macro' $
  ]
func_names2D = ['Add 2D Curve/Function' $
    ,'BackgroundOptions' $
    ,'Constant_2D' $
    ,'Linear_2D' $
    ,'Empirical_2D' $
    ,'Peak' $
    ,'DeltaOptions' $
    ,'Delta_SharedArea_2D' $
    ,'Delta_SharedCen_2D' $
    ,'Delta_SharedAreaCen_2D' $
    ,'Delta_2D' $
    ,'GaussianOptions' $
    ,'GaussIndepAreaWidthCenter_2D' $
    ,'GaussGlobalAreaWidthCenter_2D' $
    ,'GaussGlobalAreaWidth_2D' $
    ,'GaussGlobalAreaOnly_2D' $
    ,'GaussGlobalWidthOnly_2D' $
    ,'GaussGlobalWidthQDep_2D' $
    ,'GaussGlobalWidthQ2Dep_2D' $
    ,'LorentzianOptions' $
    ,'LorIndepAreaWidthCenter_2D' $
    ,'LorGlobalAreaWidthCenter_2D' $
    ,'LorGlobalAreaWidth_2D' $
    ,'LorGlobalAreaOnly_2D' $
    ,'LorGlobalWidthOnly_2D' $
    ,'LorGlobalWidthQDep_2D' $
    ,'LorGlobalWidthQ2Dep_2D' $
    ,'Recoil_2D' $
    ,'Diffusion' $
    ,'JumpDiffusionOptions' $
    ,'JumpDiffusion_ChudleyElliot_2D' $
    ,'JumpDiffusion_HallRoss_2D' $
    ,'JumpDiffusion_SingwiSjolander_2D' $
    ,'DecoupledTranslationRotation' $
    ,'DecoupledTransRot_HallRoss_2D' $  ;-------------
    ,'TranslationalDiffusion_2D' $
    ,'TwoFoldJumpDiffusion_2D' $
    ,'ThreeFoldJumpDiffusion_2D' $
    ,'NFoldJumpDiffusion_2D' $
    ,'BoundedJumpDiffusion_2D' $
    ,'RandomJumpDiffusion_2D' $
    ,'DiffusionInASphere_2D' $
    ,'IsotropicRotDiffusion_2D' $
    ,'TunnelingOptions' $
    ,'ThreeFoldTunneling_2D' $
    ,'BroadenedThreeFoldTunneling_2D' $
    ,'User Defined' $
    ,'Macrofunction2D' $
    ]

;ncurves = n_elements(curveNames)
;*self.curvenamesPtr = curveNames
;
;desc = replicate({ flags:0, name:'' }, ncurves)
;desc.flags = [1,0*indgen(ncurves-1)]
;desc.name = curveNames

*self.curvenamesPtr = func_names1D
butBase = widget_base(ctrlbase,/col,/frame,/base_align_center)

if (Float(!version.release) ge 9.1) then begin
  void = Widget_label(butBase,value='Available Fit Functions', foreground_color=[0,128,0])
endif else begin
  void = Widget_label(butBase,value='Available Fit Functions')
endelse


drop1D = cw_pdmenu(butbase,desc1D,/return_index, $
       uvalue = {object:self,method:'selectCurve',func_names:func_names1D})
drop2D = Cw_pdmenu(butbase,desc2D,/return_index, $
       uvalue = {object:self,method:'selectCurve',func_names:func_names2D})

void = widget_label(butBase,value = '')
groupSlider = widget_slider(butbase,value = 1,min = 1,max = 100, $
              title = 'Group selection', $
              uvalue = {object:self,method:'selectGroup'})

self.modify = widget_button(butbase,value = 'Modify Fit Parameters', $
              uvalue = {object:self,method:'parameterInfo'})
bsize = 20
void = widget_label(butbase,value = '')
void = widget_button(butbase,value = 'Remove Curves (this group)', $
       uvalue = {object:self,method:'clearCurrentCurves'})
void = widget_button(butbase,value = 'Remove Curves (all groups)', $
       uvalue = {object:self,method:'clearAllCurves'})
void = widget_button(butbase,value = 'Remove Selected Curve', $
       uvalue = {object:self,method:'remSelCurve'})

self.curveSlider = widget_slider(butbase,value = 1, $
                   min = 1,max = 2,title = 'Curve Selection', $
                   uvalue = {object:self,method:'sliderCurveSel'})

;void = widget_label(ctrlbaseFit,value = '')
base_color = [150,170,150]
if (Float(!version.release) ge 9.1) then begin
  void = widget_label(ctrlbase,value = '',background_color=base_color,scr_xsize=(widget_info(butbase,/geometry)).scr_xsize)
endif else begin
  void = widget_label(ctrlbase,value = '')
endelse
void = widget_label(ctrlbase,value = '')

ctrlbaseFit = widget_base(ctrlbase,/col,/frame)
void = widget_button(ctrlbaseFit,value = 'Fit Current Group', $
       uvalue = {object:self,method:'fitOneGroup'})
void = widget_button(ctrlbaseFit,value = 'Fit All Groups', $
       uvalue = {object:self,method:'fitAllGroups'})
self.interrupt = widget_button(ctrlbaseFit,value = 'Interrupt Fit',sensitive = 0)

self.groupSlider = groupSlider
if (Float(!version.release) ge 9.1) then begin
  self.groupfield = Dave_cw_field(ctrlbaseFit,/col,value = 1,/string, $
    title = 'Groups To Fit',text_bg_color=[230,230,255],text_fg_color=[128,0,0])
endif else begin
  self.groupfield = Dave_cw_field(ctrlbaseFit,/col,value = 1,/string, $
    title = 'Groups To Fit')
endelse

if (Float(!version.release) ge 9.1) then begin
  self.fitstatfield = Dave_cw_field(ctrlbaseFit,/col,value = self.fitstatus[0],$
    title = 'Fitting Status',/string,/noedit,text_bg_color=[230,230,255],text_fg_color=[128,0,0])
endif else begin
  self.fitstatfield = Dave_cw_field(ctrlbaseFit,/col,value = self.fitstatus[0],$
    title = 'Fitting Status',/string,/noedit)
endelse


if (Float(!version.release) ge 9.1) then begin
  void = widget_label(ctrlbase,value = '',background_color=base_color,scr_xsize=(widget_info(ctrlbaseFit,/geometry)).scr_xsize)
endif else begin
  void = widget_label(ctrlbase,value = '')
endelse
void = widget_label(ctrlbase,value = '')
geom = widget_info(ctrlbaseFit,/geometry)
ctrlbaseFitInfo = widget_base(ctrlbase,/col,/frame,scr_xsize = geom.scr_xsize)
void = widget_button(ctrlbaseFitInfo,value = 'View CORR Matrix', $
       uvalue = {object:self,method:'view_corr_matrix'})
void = widget_button(ctrlbaseFitInfo,value = 'Refresh Fit Results', $
       uvalue = {object:self,method:'displayFitParameters'})

void = widget_button(ctrlbaseFitInfo,value = 'Analyze Fit Parameters', $
       uvalue = {object:self,method:'plotFitParameter'})
void = widget_button(ctrlbaseFitInfo,value = 'Plot EISF', $
       uvalue = {object:self,method:'plotEISF'})

if (Float(!version.release) ge 9.1) then begin
  void = widget_label(ctrlbase,value = '',background_color=base_color,scr_xsize=(widget_info(ctrlbaseFitInfo,/geometry)).scr_xsize)
endif else begin
  void = widget_label(ctrlbase,value = '')
endelse
void = widget_label(ctrlbase,value = '')
mc_base = widget_base(ctrlbase,/frame,/col)
if (Float(!version.release) ge 9.1) then begin
  self.ndata_field = Dave_cw_field(mc_base,/col,value = Strtrim(String(self.ndata),2), $
    title = '# of MC data sets',text_bg_color=[230,230,255],text_fg_color=[128,0,0])
endif else begin
  self.ndata_field = Dave_cw_field(mc_base,/col,value = strtrim(string(self.ndata),2), $
   title = '# of MC data sets')
endelse
if !version.release gt 6.0 then begin
   tooltip = 'Perform Bootstrap Monte-Carlo Error Estimate'
   void = widget_button(mc_base,value = 'Monte-Carlo error estimate', $
          uvalue = {object:self,method:'mc_estimate'},tooltip = tooltip)
endif else begin
   void = widget_button(mc_base,value = 'Monte-Carlo error estimate', $
          uvalue = {object:self,method:'mc_estimate'})
endelse

; hack to extend the controlbase vertically
if (Float(!version.release) ge 9.1) then begin
  void = widget_label(ctrlbase,value = '',background_color=base_color,scr_xsize=(widget_info(mc_base,/geometry)).scr_xsize)
endif else begin
  void = widget_label(ctrlbase,value = '')
endelse

;void = widget_label(ctrlbase,value=' ')
dispBase = widget_base(tlb,/col)
self.dispBase = dispBase

ctrlGeom = widget_info(self.ctrlbase,/geom)
datxsize = 800 ;& datysize = 400
resxsize = 800 ;& resysize = 200
datysize = (2.0 / 3.0) * ctrlGeom.scr_ysize
resysize = (1.0 / 3.0) * ctrlGeom.scr_ysize
self.winratio = float(datysize/resysize)
self.datwin = widget_draw(dispBase,xsize = datxsize,ysize = datysize, retain=2, $
              /button_events,$
              /motion_events,$
              /tracking_events,$
              /keyboard_events,$
              uvalue = {object:self,method:'drawEvents'})
self.reswin = widget_draw(dispBase,xsize = resxsize,ysize = resysize, retain=2)

self.infoBase = widget_base(tlb,/col)
if (float(!version.release) ge 9.1) then begin
  if !d.name eq 'WIN' then begin
    thisFont = "Arial Narrow Bold*22"
    self.info = Widget_text(self.infobase,font = thisFont, value = '', xsize = 45,ysize = 17 $
      ,background_color=[240,255,240],foreground_color=[0,0,255],/scroll)
  endif else begin
    self.info = Widget_text(self.infobase,font=font, value = '',  xsize = 45,ysize = 20 $
      ,background_color=[240,255,240],foreground_color=[0,0,255],/scroll)
  endelse 
endif else begin
  if !d.name eq 'WIN' then begin
    thisFont = "Arial Narrow Bold*22"
    self.info = Widget_text(self.infobase,font = thisFont, value = '', xsize = 45,ysize = 17,/scroll)
  endif else begin
    self.info = Widget_text(self.infobase,font=font, value = '', xsize = 45,ysize = 20,/scroll)
  endelse
endelse
infogeom = widget_info(self.info,/geom)
Self.origInfoYsize = infogeom.scr_ysize

; Now create a base for the HTML log controls
logBase = widget_base(self.infoBase,/frame,/col)
void = widget_label(logBase,value = 'HTML Log Controls')
self.logBase = logBase
wRow = widget_base(logBase,/row)
self.newHTML = widget_button(wRow,value = 'Create new HTML log file', $
       uvalue = {object:self,method:'newHTMLFile'})
self.existingHTML = widget_button(wRow,value = 'Open existing HTML log file', $
       uvalue = {object:self,method:'existingHTMLFile'})
       
geom = widget_info(Self.newHTML,/geom)

wRow = widget_base(logBase,/row)
self.commentHTML = widget_button(wRow,value = 'Enter comment', scr_xsize=geom.scr_xsize, $
       uvalue = {object:self,method:'logComment'},sensitive = 0)
self.plotHTML = widget_button(wRow,value = 'Add plot to log', scr_xsize=geom.scr_xsize, $
       uvalue = {object:self,method:'logAddPlot'},sensitive = 0)
self.closeHTML = widget_button(logBase,value = 'Close HTML log file', scr_xsize=geom.scr_xsize, $
       uvalue = {object:self,method:'closeHTMLFile'},sensitive = 0)

wRow = widget_base(logBase,/row)
void = widget_label(wRow,value = 'Log file status:', scr_xsize=geom.scr_xsize)
void = widget_label(wRow,value = 'Log file name', scr_xsize=geom.scr_xsize)

wRow = widget_base(logBase,/row)
self.logFileStatus = widget_text(wRow,value = 'closed', scr_xsize=geom.scr_xsize)
self.logFileDisplay = widget_text(wRow,value = self.logFile, scr_xsize=geom.scr_xsize)

; Add controls for Differential Evo Genetic Algorithm
infoGeom = widget_info(Self.info,/geom)
logGeom = widget_info(Self.logbase,/geom)
scr_ysize = ctrlGeom.scr_ysize - $
           (infoGeom.scr_ysize + logGeom.scr_ysize + $
            2*infoGeom.ypad + 2*logGeom.ypad )
scr_xsize = infoGeom.scr_xsize
wPS = widget_propertysheet(self.infoBase $
                     ,value=Self.oEPSDE $
                     ,uname='PAN_EPSDE_PS' $
                     ,scr_xsize=scr_xsize $
                     ,scr_ysize=scr_ysize $
                     ,event_pro='opanEvents' $
                     ,/frame $
                     ,uvalue={object:Self.oEPSDE,method:'PropSheet_Events'} $
                    )
Self.oEPSDE->SetProperty, wPS=wPS

; Add field to display cursor location on graphics window
curWID = widget_text(self.infobase $
                  ,uname='PAN_CURSOR_LOC' $
                  ,scr_xsize=scr_xsize $
                  ,/frame $
                  ,font=font $
                  )
curGeom = widget_info(curWID,/geom)

; resize the Diff Evo ysize to accomodate the Cursor field.
scr_ysize = ctrlGeom.scr_ysize - $
  (infoGeom.scr_ysize + logGeom.scr_ysize + curGeom.scr_ysize + $
  2*infoGeom.ypad + 2*logGeom.ypad )
widget_control, wPS, scr_ysize=scr_ysize

centertlb,self.tlb
widget_control,tlb,/realize

widget_control,self.datwin,get_value = datVis
self.datVis = datVis
widget_control,self.reswin,get_value = resVis
self.resVis = resVis

window,/free,/pixmap,xsize = datxsize,ysize = datysize
self.datPix = !d.window
window,/free,/pixmap,xsize = resxsize,ysize = resysize
self.resPix = !d.window

widget_control,tlb,set_uvalue = self
geom = widget_info(self.tlb,/geometry)
origTLBDim = [geom.xsize,geom.ysize]
widget_control, Self.ctrlbase, set_uvalue=origTLBDim 

;LRK 032907
defsysv,'!dave_e_window',exists=runningdave ;USED IN dave_set_focus
if runningdave ne 0 then begin
    ret = dave_set_focus(self.tlb)
endif;runningdave

xmanager,'opan::createWidgets',self.tlb,event_handler = 'opanEvents',$
         cleanup = 'opanCleanup', /no_block

return
end;opan::createWidgets


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;pro Opan::createWidgets_Sept2019,wintitle=wintitle
;
;  if N_elements(wintitle) eq 0 then wintitle = ''
;
;  ; Widget creation module
;  if self.group_leader eq (-1L) then begin
;    tlb = Widget_base(/row, $
;      title = 'PAN: Peak Analysis - '+wintitle,mbar = bar,/tlb_size_events)
;  endif else begin
;    tlb = Widget_base(group_leader = self.group_leader,/row, $
;      title = 'PAN: Peak Analysis - '+wintitle,mbar = bar,/tlb_size_events);, $
;    ;        /kbrd_focus_events)
;  endelse
;  self.tlb = tlb
;
;  font = (!version.os_family eq 'Windows')? 'Courier New*16' : $
;    '-adobe-courier-bold-r-normal--18-180-75-75-m-110-iso8859-1'
;
;  filemenu = Widget_button(bar,value = 'File',/menu,font=font)
;  datmenu = Widget_button(bar,value = 'Data',/menu,font=font)
;  resmenu = Widget_button(bar,value = 'Resolution',/menu,font=font)
;  plotmenu = Widget_button(bar,value = 'Plot_Options',/menu,font=font)
;  hot_keymenu = Widget_button(bar,value = 'Hot_Keys',/menu,font=font)
;
;
;  printmenu = Widget_button(bar,value = 'Print',/menu,font=font)
;  helpmenu = Widget_button(bar,value = 'Help',/menu,font=font)
;  ;miscmenu = widget_button(bar,value = 'Miscellaneous',/menu)
;  void = Widget_button(helpmenu,value = 'PAN Help', $
;    uvalue = {object:self,method:'pan_help'})
;  void = Widget_button(helpmenu,value = 'PAN User Macros Help', $
;    uvalue = {object:self,method:'pan_user_macros_help'},uname = 'PAN_HELP')
;  void = Widget_button(helpmenu,value = 'About PAN',$
;    uvalue = {object:self,method:'aboutPAN'})
;
;  ; File Menu
;  void = Widget_button(filemenu,value = 'Save Fitted Lineshape as DAVE data file', $
;    uvalue = {object:self,method:'saveDaveFits'})
;  void = Widget_button(filemenu,value = 'Export Fitted Lineshape to DAVE Data Manager', $
;    uvalue = {object:self,method:'exportDaveFits'})
;  ;    void = widget_button(filemenu,value = 'Save fit function as DAVE data file', $
;  ;           uvalue = {object:self,method:'saveDaveFits'})
;  ;    void = widget_button(filemenu,value = 'Export fit function to DAVE Data Manager', $
;  ;           uvalue = {object:self,method:'exportDaveFits'})
;
;
;  void = Widget_button(filemenu,value = 'Save Data, fitted Lineshape(s) to ASCII', $
;    uvalue = {object:self,method:'print2text'},/separator)
;
;  void = Widget_button(filemenu,value = 'Save Data, selected fitted Lineshape to ASCII', $
;    uvalue = {object:self,method:'print2textSelect'})
;
;  void = Widget_button(filemenu,value = 'Save Data, fitted lineshape(s) to ASCII columns', $
;    uvalue = {object:self,method:'print2text_as_excel'})
;
;  ;    void = Widget_button(filemenu,value = 'Save fitted Lineshape(s) only to ASCII columns', $
;  ;      uvalue = {object:self,method:'printFitsOnly2text_as_excel'})
;
;  void = Widget_button(filemenu,value = 'Save fitted Parameters/Errors to ASCII columns', $
;    uvalue = {object:self,method:'printFitParameters2text_as_excel'})
;  ;    void = widget_button(filemenu,value = 'Save data and fits to text file', $
;  ;           uvalue = {object:self,method:'print2text'},/separator)
;  ;
;  ;    void = widget_button(filemenu,value = 'Save data, fits, and selected curve to text file', $
;  ;           uvalue = {object:self,method:'print2textSelect'})
;  ;
;  ;    void = widget_button(filemenu,value = 'Save data and fits to EXCEL-readable ASCII', $
;  ;           uvalue = {object:self,method:'print2text_as_excel'})
;  ;
;  ;    void = widget_button(filemenu,value = 'Save fits only to EXCEL-readable ASCII', $
;  ;       uvalue = {object:self,method:'printFitsOnly2text_as_excel'})
;  ;
;  ;    void = Widget_button(filemenu,value = 'Save Fitted Parameters as ASCII (columns)', $
;  ;       uvalue = {object:self,method:'printFitParameters2text_as_excel'})
;
;
;  void = Widget_button(filemenu,value = 'Save Fit Model as ASCII',$
;    uvalue = {object:self,method:'saveParmsAsText'},/separator)
;  void = Widget_button(filemenu,value = 'Save Fit Model plus data/res as ASCII',$
;    uvalue = {object:self,method:'saveParmsAsText',etc:{writedataandres:1}})
;  void = Widget_button(filemenu,value = 'Read in Fit Model from file',$
;    uvalue = {object:self,method:'readParmsAsText'})
;  ;    void = widget_button(filemenu,value = 'Save fit parameters only as text file',$
;  ;           uvalue = {object:self,method:'saveParmsAsText'},/separator)
;  ;    void = widget_button(filemenu,value = 'Save fit parameters plus data/res as text file',$
;  ;           uvalue = {object:self,method:'saveParmsAsText',etc:{writeDataAndRes:1}})
;  ;    void = widget_button(filemenu,value = 'Read in fit parameters file',$
;  ;           uvalue = {object:self,method:'readParmsAsText'})
;
;
;  void = Widget_button(filemenu,value = 'Preferences',$
;    uvalue = {object:self,method:'preferences'},/separator)
;  void = Widget_button(filemenu,value = 'Quit',/separator,$
;    uvalue = {object:self,method:'quit'})
;
;  ; Data Menu
;  void = Widget_button(datmenu,value = 'Load DAVE file', $
;    uvalue = {object:self,method:'loadDave'})
;
;  ;031607
;  ;ELIMINATING THIS BUTTON WHICH ALLOWS USER TO READ IN TAS DATA FILES.
;  ;IT SEEMS TO CAUSE DAVE CRASHES, SO IT IS HIGHLY UNLIKELY TO BE USED
;  ;BY ANYONE CURRENTLY.  THE NEW ICE FILES WILL ALSO MAKE THIS OBSOLETE.
;  ;
;
;  ;    tasMenu = widget_button(datmenu,value = 'TAS (ICP) files',/menu)
;  ;
;  ;    if (!version).release ge 5.6 then begin
;  ;       tas_title = 'Browse and Load TAS data file'
;  ;    endif else begin
;  ;       tas_title = 'Load TAS data file'
;  ;    endelse
;  ;    void = widget_button(tasmenu,value = tas_title, $
;  ;           uvalue = {object:self,method:'loadtasdata'})
;  ;    if (!version).release lt 5.6 then begin
;  ;       void = widget_button(tasmenu,value = 'Load TAS data file from previous list', $
;  ;             uvalue = {object:self,method:'loadtasdatafromprevious'})
;  ;    endif
;
;  asciiMenu = Widget_button(datmenu,value = 'Load ASCII Data File',/menu)
;  void = Widget_button(asciimenu,value = '3-col ascii data', $
;    uvalue = {object:self,method:'loadasciidata'})
;  void = Widget_button(asciimenu,value = 'Grouped ascii data', $
;    uvalue = {object:self,method:'loadgroupdata'})
;  ;    void = widget_button(asciimenu,value = 'Load FCS data (SQW.XY)', $
;  ;           uvalue = {object:self,method:'loadfcsdata'})
;
;  void = Widget_button(datmenu,value = 'Load test data', $
;    uvalue = {object:self,method:'loadtestdata'})
;  void = Widget_button(datmenu,value = 'Load 2nd test data', $
;    uvalue = {object:self,method:'loadtestdata2'})
;  void = Widget_button(datmenu,value = 'Display current file information',$
;    uvalue = {object:self,method:'showFileInfo'},/separator)
;
;  ;LRK - 103008
;  ;SWAPPING IN THE NEW REBINNING METHOD
;  ;    void = widget_button(datmenu,value = 'Rebin data', $
;  ;           uvalue = {object:self,method:'rebinData'},/separator)
;  void = Widget_button(datmenu,value = 'Rebin data', $
;    uvalue = {object:self,method:'rebinData_NEW'},/separator)
;  void = Widget_button(datmenu,value = 'Crop data', $
;    uvalue = {object:self,method:'cropData'})
;
;  void = Widget_button(datmenu,value = 'Edit Pan Mask', $
;    uvalue = {object:self,method:'editPanMask'})
;
;  ;void = widget_button(datmenu,value = 'Exclude data', $
;  ;       uvalue = {object:self,method:'excludeData'})
;  void = Widget_button(datmenu,value = 'Restore Original data', $
;    uvalue = {object:self,method:'rebinRestore'})
;
;  void = Widget_button(datmenu,value = 'Save data and fits to text file', $
;    uvalue = {object:self,method:'print2text'},/separator)
;
;  void = Widget_button(datmenu,value = 'Save data, fits, and selected curve to text file', $
;    uvalue = {object:self,method:'print2textSelect'})
;
;  void = Widget_button(datmenu,value = 'Save data and fits to EXCEL-readable ASCII', $
;    uvalue = {object:self,method:'print2text_as_excel'})
;
;  void = Widget_button(datmenu,value = 'Save fits only to EXCEL-readable ASCII', $
;    uvalue = {object:self,method:'printFitsOnly2text_as_excel'})
;
;  void = Widget_button(datmenu,value = 'Flush and close all open files', $
;    uvalue = {object:self,method:'flushAndCloseOpenedFiles'},/separator)
;
;
;  ; Resolution Menu
;  void = Widget_button(resmenu,value = 'Load DAVE data as resolution function', $
;    uvalue = {object:self,method:'loadDaveRes'})
;  resasciiMenu = Widget_button(resmenu,value = 'Load ASCII Resolution File',/menu)
;  void = Widget_button(resasciimenu,value = 'Load 3-col ascii resolution function', $
;    uvalue = {object:self,method:'load_3col_ascii_res'})
;  void = Widget_button(resasciimenu,value = 'Load grouped ascii resolution function', $
;    uvalue = {object:self,method:'load_group_ascii_res'})
;  void = Widget_button(resmenu,value = 'Load test resolution function', $
;    uvalue = {object:self,method:'loadtestres'})
;  void = Widget_button(resmenu,value = 'Change resolution domain (crop)', $
;    uvalue = {object:self,method:'cropRes'},/separator)
;
;  ;LRK - 103008
;  ;SWAPPING IN THE NEW REBINNING METHOD
;  ;    void = widget_button(resmenu,value = 'Rebin Resolution data', $
;  ;           uvalue = {object:self,method:'rebinRes'})
;  void = Widget_button(resmenu,value = 'Rebin Resolution data', $
;    uvalue = {object:self,method:'rebinRes_NEW'})
;  void = Widget_button(resmenu,value = 'Restore Resolution data', $
;    uvalue = {object:self,method:'restoreRes'})
;  void = Widget_button(resmenu,value = 'Clear resolution function', $
;    uvalue = {object:self,method:'clearDaveRes'},/separator)
;
;
;  ; Print menu
;  void = Widget_button(printmenu,value = 'Printer', $
;    uvalue = {object:self,method:'print2Printer'})
;  void = Widget_button(printmenu,value = 'Print screen to .JPEG file', $
;    uvalue = {object:self,method:'print2jpeg'})
;  void = Widget_button(printmenu,value = 'Print to PS file', $
;    uvalue = {object:self,method:'print2ps'})
;  void = Widget_button(printmenu,value = 'Print data and fits to text file', $
;    uvalue = {object:self,method:'print2text'})
;
;  void = Widget_button(printmenu,value = 'Print data, fits and selected curve to text file', $
;    uvalue = {object:self,method:'print2textSelect'})
;
;  void = Widget_button(printmenu,value = 'Print data and fits to EXCEL-readable ASCII', $
;    uvalue = {object:self,method:'print2text_as_excel'})
;
;  void = Widget_button(printmenu,value = 'Quick Overplot', $
;    uvalue = {object:self,method:'quickOverplot'})
;
;  void = Widget_button(plotmenu,value = 'XLog  No', $
;    uvalue = {object:self,method:'TogglePlotXLog',state:0},$
;    uname='PLOTXLOGBUTTON')
;  void = Widget_button(plotmenu,value = 'YLog  No', $
;    uvalue = {object:self,method:'TogglePlotYLog',state:0},$
;    uname='PLOTYLOGBUTTON')
;  void = Widget_button(plotmenu,value = 'Unzoom', $
;    uvalue = {object:self,method:'UnzoomMenu',state:0},$
;    uname='UNZOOMMENUBUTTON')
;
;  void = Widget_button(hot_keymenu,value = 'Hot Keys (b,g,l,d,D,f,F) - On', $
;    uvalue = {object:self,method:'ToggleHotKeys',state:1},$
;    uname='HOTKEYBUTTON')
;
;  ctrlBase = Widget_base(tlb,/col,/base_align_center);,uvalue = {object:self,method:'fitCurrent'})
;  self.ctrlbase = ctrlBase
;  self.timerid = ctrlBase
;
;  if (!ftkwwFlag) then begin
;    curveNames =   [  'Select function',   $
;      'AutoGaussian',      $
;      'AutoLorentzian',    $
;      'Background',        $
;      'Baseline',          $
;      'Decay',             $
;      'Delta',             $
;      'DHO',               $
;      'FT_KWW', $
;      ;'FT_KWW_NEW', $
;      ;'FT_KWW_AAC', $
;      ;'FT_KWW_RAJAGOPAL', $
;      ;'FT_KWW_NEW_FFT', $
;      ;'FourthOrder',$
;      ;'NSE_Deformation',$
;      'Gaussian',          $
;      'Ikeda Carpenter',   $
;      'KWW',               $
;      ;                  'kohlrausch',        $
;      'Lognormal',         $
;      'Lorentzian',        $
;      'MeanfieldOrderParameter', $
;      'OrderParameter', $
;      'Qens',              $
;      'QFluidJqyCF', $
;      'Recoil2D', $
;      ;'RouseApprox', $
;      'Rouse_scaled', $
;      'Step',              $
;      'Voigt',             $
;      'Userfunction',      $
;      'User macro function']
;  endif else begin
;    curveNames =   [  'Select function',   $
;      'AutoGaussian',      $
;      'AutoLorentzian',    $
;      'Background',        $
;      'Baseline',          $
;      'Decay',             $
;      'Delta',             $
;      'DHO',               $
;      ;'FT_KWW_NEW', $
;      ;'FT_KWW_AAC', $
;      ;'FT_KWW_RAJAGOPAL', $
;      ;'FT_KWW_NEW_FFT', $
;      ;'FourthOrder',$
;      ;'NSE_Deformation',$
;      'Gaussian',          $
;      'Ikeda Carpenter',   $
;      'KWW',               $
;      ;                  'kohlrausch',        $
;      'Lognormal',         $
;      'Lorentzian',        $
;      'MeanfieldOrderParameter', $
;      'OrderParameter', $
;      'Qens',              $
;      'QFluidJqyCF', $
;      'Recoil2D', $
;      ;'RouseApprox', $
;      'Rouse_scaled', $
;      'Step',              $
;      'Voigt',             $
;      'Userfunction',      $
;      'User macro function']
;  endelse
;
;  ncurves = N_elements(curveNames)
;  *self.curvenamesptr = curveNames
;
;  desc = Replicate({ flags:0, name:'' }, ncurves)
;  desc.flags = [1,0*Indgen(ncurves-1)]
;  desc.name = curveNames
;
;  butBase = Widget_base(ctrlbase,/col,/frame,/base_align_center)
;
;  drop = Cw_pdmenu(butbase,desc,/return_index, $
;    uvalue = {object:self,method:'selectCurve'})
;  void = Widget_label(butBase,value = '')
;  groupSlider = Widget_slider(butbase,value = 1,min = 1,max = 100, $
;    title = 'Group selection', $
;    uvalue = {object:self,method:'selectGroup'})
;
;  self.modify = Widget_button(butbase,value = 'Modify fit parameters', $
;    uvalue = {object:self,method:'parameterInfo'})
;  bsize = 20
;  ;self.modify = cw_color_button(ctrlbase,/row,value = 'Modify fit parameters', $
;  ;              uvalue = {object:self,method:'parameterInfo'},/green,button_size = bsize)
;  ;void = cw_color_button(butbase,/row,value = 'Clear current curves', $
;  ;       uvalue = {object:self,method:'clearCurrentCurves'},/red,button_size = bsize)
;  void = Widget_button(butbase,value = 'Clear current curves', $
;    uvalue = {object:self,method:'clearCurrentCurves'})
;  ;void = cw_color_button(butbase,/row,value = 'Clear all curves', $
;  ;       uvalue = {object:self,method:'clearAllCurves'},/red,button_size = bsize)
;  void = Widget_button(butbase,value = 'Clear all curves', $
;    uvalue = {object:self,method:'clearAllCurves'})
;  ;void = cw_color_button(butbase,/row,value = 'Remove selected curve', $
;  ;       uvalue = {object:self,method:'remSelCurve'},/red,button_size = bsize)
;  void = Widget_button(butbase,value = 'Remove selected curve', $
;    uvalue = {object:self,method:'remSelCurve'})
;
;  self.curveslider = Widget_slider(butbase,value = 1, $
;    min = 1,max = 2,title = 'Curve selection', $
;    uvalue = {object:self,method:'sliderCurveSel'})
;
;  ;void = widget_label(ctrlbaseFit,value = '')
;
;  ctrlbaseFit = Widget_base(ctrlbase,/col,/frame)
;  void = Widget_button(ctrlbaseFit,value = 'Fit current group', $
;    uvalue = {object:self,method:'fitOneGroup'})
;  ;void = cw_color_button(ctrlbase,/row,value = 'Fit current group', $
;  ;       uvalue = {object:self,method:'fitOneGroup'},/green,button_size = bsize)
;  void = Widget_button(ctrlbaseFit,value = 'Fit all groups', $
;    uvalue = {object:self,method:'fitAllGroups'})
;  ;void = cw_color_button(ctrlbase,/row,value = 'Fit all groups', $
;  ;       uvalue = {object:self,method:'fitAllGroups'},/green,button_size = bsize)
;  self.interrupt = Widget_button(ctrlbaseFit,value = 'Interrupt fit',sensitive = 0)
;
;  self.groupslider = groupSlider
;  self.groupfield = Cw_field(ctrlbaseFit,/col,value = 1,/string, $
;    title = 'Groups to fit')
;  self.fitstatfield = Cw_field(ctrlbaseFit,/col,value = self.fitstatus[0],$
;    title = 'Fitting status',/string,/noedit)
;
;  geom = Widget_info(ctrlbaseFit,/geometry)
;  ctrlbaseFitInfo = Widget_base(ctrlbase,/col,/frame,scr_xsize = geom.scr_xsize)
;  void = Widget_button(ctrlbaseFitInfo,value = 'View CORR matrix', $
;    uvalue = {object:self,method:'view_corr_matrix'})
;  void = Widget_button(ctrlbaseFitInfo,value = 'Refresh Fit Results', $
;    uvalue = {object:self,method:'displayFitParameters'})
;
;  void = Widget_button(ctrlbaseFitInfo,value = 'Analyze Fit Parameters', $
;    uvalue = {object:self,method:'plotFitParameter'})
;  void = Widget_button(ctrlbaseFitInfo,value = 'Plot EISF', $
;    uvalue = {object:self,method:'plotEISF'})
;
;  mc_base = Widget_base(ctrlbase,/frame,/col)
;  self.ndata_field = Cw_field(mc_base,/col,value = Strtrim(String(self.ndata),2), $
;    title = '# of MC data sets')
;  if !version.release gt 6.0 then begin
;    tooltip = 'Perform Bootstrap Monte-Carlo Error Estimate'
;    void = Widget_button(mc_base,value = 'Monte-Carlo error estimate', $
;      uvalue = {object:self,method:'mc_estimate'},tooltip = tooltip)
;  endif else begin
;    void = Widget_button(mc_base,value = 'Monte-Carlo error estimate', $
;      uvalue = {object:self,method:'mc_estimate'})
;  endelse
;  ;void = widget_label(ctrlbase,value=' ')
;  dispBase = Widget_base(tlb,/col)
;  self.dispbase = dispBase
;
;  ctrlGeom = Widget_info(self.ctrlbase,/geom)
;  datxsize = 500 ;& datysize = 400
;  resxsize = 500 ;& resysize = 200
;  datysize = (2.0 / 3.0) * ctrlGeom.scr_ysize
;  resysize = (1.0 / 3.0) * ctrlGeom.scr_ysize
;  self.winratio = Float(datysize/resysize)
;  self.datwin = Widget_draw(dispBase,xsize = datxsize,ysize = datysize, retain=2, $
;    /button_events,$
;    /motion_events,$
;    /tracking_events,$
;    /keyboard_events,$
;    uvalue = {object:self,method:'drawEvents'})
;  self.reswin = Widget_draw(dispBase,xsize = resxsize,ysize = resysize, retain=2)
;
;  self.infobase = Widget_base(tlb,/col)
;  if !d.name eq 'WIN' then begin
;    thisFont = "Comic Sans MS*16"
;    self.info = Widget_text(self.infobase,font = thisFont, value = '', $
;      xsize = 45,ysize = 17,/scroll)
;  endif else begin
;    self.info = Widget_text(self.infobase,value = '', $
;      xsize = 65,ysize = 17,/scroll)
;  endelse
;  infogeom = Widget_info(self.info,/geom)
;  Self.originfoysize = infogeom.scr_ysize
;
;  ; Now create a base for the HTML log controls
;  logBase = Widget_base(self.infobase,/frame,/col)
;  void = Widget_label(logBase,value = 'HTML Log Controls')
;  self.logbase = logBase
;  wRow = Widget_base(logBase,/row)
;  self.newhtml = Widget_button(wRow,value = 'Create new HTML log file', $
;    uvalue = {object:self,method:'newHTMLFile'})
;  self.existinghtml = Widget_button(wRow,value = 'Open existing HTML log file', $
;    uvalue = {object:self,method:'existingHTMLFile'})
;
;  geom = Widget_info(Self.newhtml,/geom)
;
;  wRow = Widget_base(logBase,/row)
;  self.commenthtml = Widget_button(wRow,value = 'Enter comment', scr_xsize=geom.scr_xsize, $
;    uvalue = {object:self,method:'logComment'},sensitive = 0)
;  self.plothtml = Widget_button(wRow,value = 'Add plot to log', scr_xsize=geom.scr_xsize, $
;    uvalue = {object:self,method:'logAddPlot'},sensitive = 0)
;  self.closehtml = Widget_button(logBase,value = 'Close HTML log file', scr_xsize=geom.scr_xsize, $
;    uvalue = {object:self,method:'closeHTMLFile'},sensitive = 0)
;
;  wRow = Widget_base(logBase,/row)
;  void = Widget_label(wRow,value = 'Log file status:', scr_xsize=geom.scr_xsize)
;  void = Widget_label(wRow,value = 'Log file name', scr_xsize=geom.scr_xsize)
;
;  wRow = Widget_base(logBase,/row)
;  self.logfilestatus = Widget_text(wRow,value = 'closed', scr_xsize=geom.scr_xsize)
;  self.logfiledisplay = Widget_text(wRow,value = self.logfile, scr_xsize=geom.scr_xsize)
;
;  ; Add controls for Differential Evo Genetic Algorithm
;  infoGeom = Widget_info(Self.info,/geom)
;  logGeom = Widget_info(Self.logbase,/geom)
;  scr_ysize = ctrlGeom.scr_ysize - $
;    (infoGeom.scr_ysize + logGeom.scr_ysize + $
;    2*infoGeom.ypad + 2*logGeom.ypad )
;  scr_xsize = infoGeom.scr_xsize
;  wPS = Widget_propertysheet(self.infobase $
;    ,value=Self.oepsde $
;    ,uname='PAN_EPSDE_PS' $
;    ,scr_xsize=scr_xsize $
;    ,scr_ysize=scr_ysize $
;    ,event_pro='opanEvents' $
;    ,/frame $
;    ,uvalue={object:Self.oepsde,method:'PropSheet_Events'} $
;    )
;  Self.oepsde->Setproperty, wPS=wPS
;  ; Center the interface in the screen
;  ;geom = widget_info(self.tlb,/geometry)
;  ;device,get_screen_size = sz
;  ;sx = sz[0] & sy = sz[1]
;  ;xoff = fix(0.5*(sx-geom.xsize))
;  ;yoff = fix(0.5*(sy-geom.ysize))
;  ;widget_control,self.tlb,xoffset = xoff,yoffset = yoff
;  Centertlb,self.tlb
;  Widget_control,tlb,/realize
;
;  Widget_control,self.datwin,get_value = datVis
;  self.datvis = datVis
;  Widget_control,self.reswin,get_value = resVis
;  self.resvis = resVis
;
;  Window,/free,/pixmap,xsize = datxsize,ysize = datysize
;  self.datpix = !d.window
;  Window,/free,/pixmap,xsize = resxsize,ysize = resysize
;  self.respix = !d.window
;
;  Widget_control,tlb,set_uvalue = self
;  geom = Widget_info(self.tlb,/geometry)
;  origTLBDim = [geom.xsize,geom.ysize]
;  Widget_control, Self.ctrlbase, set_uvalue=origTLBDim
;
;  ;LRK 032907
;  Defsysv,'!dave_e_window',exists=runningdave ;USED IN dave_set_focus
;  if runningdave ne 0 then begin
;    ret = Dave_set_focus(self.tlb)
;  endif;runningdave
;
;  Xmanager,'opan::createWidgets',self.tlb,event_handler = 'opanEvents',$
;    cleanup = 'opanCleanup', /no_block
;
;  Return
;end;opan::createWidgets_Sept2019



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::niceOutput,event = event,ps_out = ps_out
    ; First let's position the plot at the top of the page
    ;ysize = 700
    ;xsize = fix(8.5*ysize/11.0)
    ;window,/free,xsize = xsize,ysize = ysize
    if n_elements(ps_out) eq 0 then ps_out = 0
    deltay = 0.20
    yreso = 0.20 & yresf = 0.42
    ydato = 0.47 & ydatf = 0.87
    pres = [0.13,yreso,0.92,yresf]
    pdat = [0.13,ydato,0.92,ydatf]
    ;deltay = 0.20
    ;yreso = 0.25 & yresf = 0.40
    ;ydato = 0.45 & ydatf = 0.75
    ;pres = [0.15,yreso+deltay,0.9,yresf+deltay]
    ;pdat = [0.15,ydato+deltay,0.9,ydatf+deltay]


  ;LRK 101408
  ;ADDING THE noerase KEYWORD SO PLOT WILL STILL WORK IF NO FIT COMPLETE
    self->plotresiduals,position = pres,ps_out = ps_out,noerase=noerase
    if n_elements(noerase) eq 0 then noerase = 1
;    self->displaydata,position = pdat,/noerase,ps_out = ps_out
    self->displaydata,position = pdat,noerase=noerase,ps_out = ps_out

    ; Now annotate with the fit results
    widget_control,self.groupSlider,get_value = val
    val = fix(val[0])-1
    datSize = size(*self.dataPtr)
    if datSize[0] eq 1 then val = 0
    oc = (*self.ocurveGroup)[val]
    oc->displayparms,output = output
    chsize = 0.75
    nlines = n_elements(output)
    if nlines eq 0 then return
    if nlines lt 30 then begin
      ystart = 0.05 & yend = ydato-ystart
      dy = yend-ystart
      step = dy/30.0
      xstart = 0.05
      ypos = ystart+step*findgen(nlines)
      for i = 0,nlines-1 do begin
        xyouts,xstart,yend-ypos[i],output[i],/normal,charsize = chsize
      endfor
    endif
    if (nlines gt 29) and (nlines lt 59) then begin
      ; Print the first 30 lines
      ystart = 0.05 & yend = ydato-ystart
      dy = yend-ystart
      step = dy/30.0
      xstart = 0.05
      ypos = ystart+step*findgen(30)
      for i = 0,29 do begin
        xyouts,xstart,yend-ypos[i],output[i],/normal,charsize = chsize
      endfor
      ; Print the remainder
      ypos = ystart+step*findgen(30)
      ystart = 0.05 & yend = ydato-ystart
      xstart = 0.50
      ypos = ystart+step*findgen(30)
      count = 0
      for i = 30,nlines-1 do begin
        xyouts,xstart,yend-ypos[count],output[i],/normal,charsize = chsize
        count = count + 1
      endfor
    endif
    return
end;opan::niceOutput
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::print2jpeg,event = event
    if n_elements(*self.dataPtr) eq 0 then return
    self.jpeg = 1
    thisDevice = !d.name
    h = 11.0 & w = 8.0 & aspect = h/w
    xsize = 1200
    ysize = fix(aspect*xsize)
    window,/free,/pixmap,xsize = xsize,ysize = ysize
    winPix = !d.window
    self->niceOutput,event = event

    device,get_visual_depth = thisDepth
    if thisDepth eq 8 then begin
      tvlct,r,g,b,/get
      image2d = tvrd()
      s = size(image2d,/dimensions)
      image24 = bytarr(3,s[0],s[1])
      tvlct,r,g,b,/get
      image24[0,*,*] = r[image2d]
      image24[1,*,*] = g[image2d]
      image24[2,*,*] = b[image2d]
    endif
    if thisDepth gt 8 then begin
      device,decomposed = 1
      image24=tvrd(true = 1)
    endif
    wdelete,winPix

    myFileName = self.printFilename
    myfile = myFileName

;LRK 06/03/10
;updated extension adder - pre file dialog   
    self->addDotjpg,myFile

;    ppos = strpos(myFileName,'.')
;    filename = strmid(myFileName,0,ppos)
;    myFile = filename+'.jpg'

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    thisPath = self.workDir
    filename = DIALOG_PICKFILE(dialog_parent = dparent,$
                               title = 'Enter output jpeg file name',$
                               /write,filter = '*.jpg',$
                               path = thisPath, $
                               file = myFile,/overwrite_prompt)

    if (filename eq '') or (filename eq ' ') then return


;LRK 06/03/10
;updated extension adder - post file dialog    
    self->addDotjpg,filename

    s = Size(image24, /Dimensions)
    newx = Round(300.0 * s[1] / 72)
    newy = Round(300.0 * s[2] / 72)

    highResImage = Congrid(image24, 3, newx, newy, /Interp)

;    write_jpeg,filename,255-highResImage,true = 1,quality = 100
    Write_jpeg,filename,image24,true = 1,quality = 100
    fn = "C:\Users\azuah\prog\idlwork\projects\devel_git\programs\help\dave_online_help_mathjax\daveimages\testdata.png"
    fn1 = "C:\Users\azuah\prog\idlwork\projects\devel_git\programs\help\dave_online_help_mathjax\daveimages\testdata1.png"
    write_png, fn, image24
    Set_Plot, thisDevice
    self.jpeg = 0

    self->refresh
    ;wset,self.resPix
    ;self->plotResiduals
    ;wset,self.resVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.resPix]

    ;wset,self.datPix
    ;self->displayData
    ;wset,self.datVis
    ;device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    msg = 'Output saved in: '+filename
    ok = dialog_message(/info,msg,dialog_parent=dparent)

    return
end;opan::print2jpeg
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan::print2ps,event = event
    if n_elements(*self.dataPtr) eq 0 then return

    myFileName = self.printFilename
;LRK 06/03/10
;updated extension adder - pre file dialog   
    myfile = myFileName
    self->addDotps,myFile

;
;    ppos = strpos(myFileName,'.')
;    filename = strmid(myFileName,0,ppos)
;
;    myFile = filename+'.ps'
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    filename = dialog_pickfile(dialog_parent = dparent, filter = '*.ps', $
                           title = 'Type in name of output postscript file', $
                           path = self.workDir, get_path = outPath,         $
                           file = myFile,/write,/overwrite_prompt)

    if n_elements(filename) eq 0 or filename eq '' then return
    self->addDotps,filename

    file = file_basename(filename)

    keywords = PSConfig(Cancel=cancelled,group_leader = event.top,$
               filename = file,color = 0,xsize = 8.0,ysize = 11.0, $
               directory = outPath,xoff = 0.0,yoff = 0.0)

    IF cancelled THEN RETURN
    self.workDir = outPath

    thisDevice = !D.Name
    Set_Plot, 'PS', /copy
    Device, _Extra=keywords

    self->niceOutput,event = event,ps_out = 1

    Device, /Close_File
    Set_Plot, thisDevice
    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    msg = 'Output saved in: '+filename
    ok = dialog_message(/info,msg,dialog_parent=dparent)

    return
end;opan::print2ps


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Added: R Tumanjong Azuah. Jan 13, 06
pro opan::print2Printer, event=event

    if n_elements(*self.dataPtr) eq 0 then return

    if n_elements(event) ne 0 then dparent = event.top else dparent = 0L
    okay = dialog_printersetup(dialog_parent=dparent)
    if (~okay) then return

    keywords = PSWindow(/printer,fudge=0.25)
    if (keywords.yoffset gt keywords.ysize) then begin
        tmp = keywords.ysize
        keywords.ysize = keywords.yoffset
        keywords.yoffset = tmp
    endif

    oldDevice = !D.name
    set_plot, 'PRINTER'
    device, _Extra=keywords

    self->niceOutput,event = event, ps_out = 0

    device, /close_document

    set_plot, oldDevice

    return
end;opan::print2Printer

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;function opan::getNotifyIds
;return,*self.notifyIdPtr
;end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan::getNotifyIds
    return,*self.notifyIdPtr
end;opan::getNotifyIds
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function opan::init, group_leader = group_leader, $
            notifyId = notifyId, $
            davePtr = davePtr, $
            mydata = data, $
            mymask = mask,$ ;ALLOW USER TO ENTER A MASK HERE.
            error = error, $
            xvalues = xvalues, $
            yvalues = yvalues, $
            xtitle = xtitle, $
            ytitle = ytitle, $
            ztitle = ztitle, $
            subtitle=subtitle,$
            header = header, $
            title = title, $
            workDir = workDir, $
            dataDir = dataDir, $
            davetool = davetool, $
            ob_reg = ob_reg,$
            wintitle=wintitle

   tvlct,r,g,b,/get
    self.macro_file = ''
    self.rPtr = ptr_new(r)
    self.gPtr = ptr_new(g)
    self.bPtr = ptr_new(b)
    self.color_ptr = ptr_new(/allocate_heap)
    device,get_decomposed=old_dc,decomposed = 1
    colors = hfbs_GetColor(/Load);, Start=1)
    *self.color_ptr = colors
    device, decomposed=old_dc

    self.ndata = 100
    
    Self.twoDimFlag = 0

    if n_elements(ob_reg) ne 0 then begin
       self.ob_reg = ob_reg
       self.reg_present = 1
       self.ob_reg->add,self
    endif else begin
       self.ob_reg = obj_new('object_registry')
       self.reg_present = 0
       self.ob_reg->add,self
    endelse
    if n_elements(group_leader) eq 0 then group_leader = (-1L)
    cd,current = curDir
    if n_elements(workDir) eq 0 then self.workDir = curDir else self.workDir = workDir
    if n_elements(dataDir) eq 0 then self.dataDir = '' else self.dataDir = dataDir
    
    if (obj_valid(daveTool)) then self.daveTool = daveTool
    help,wintitle
    if n_elements(wintitle) eq 0 then wintitle = ''
    help,wintitle


;LRK - 07/30/09
;
;THIS WAS AN ATTEMPT TO PROTECT VARIABLES BETTER IN MACRO FUNCTIONS, BUT IT IS 
;SIGNIFICANTLY SLOWER, SO IT WILL BE OMITTED.
; 
;CREATE AN OBJECT TO HANDLE MACRO FUNCTION VARIABLES AND STORE A COPY AT THE MAIN LEVEL. 
;    self.macrofunctionobject = obj_new('the_one_and_only_pan_macrofunction_object')
;    the_one_and_only_pan_macrofunction_object = self.macrofunctionobject 
;    this_level = routine_names(/level)
;    main_level = 1
;    value  = routine_names('the_one_and_only_pan_macrofunction_object', fetch = this_level)
;    dummy  = routine_names('the_one_and_only_pan_macrofunction_object', value, store = main_level)


    self.otable = obj_new('table_lookup')
    self.jpeg = 0
    self.iteration = 0L
    self.resPtr = ptr_new(/allocate_heap)
    self.oneResPtr = ptr_new(/allocate_heap)
    self.xtabPtr = ptr_new(/allocate_heap)
    self.ytabPtr = ptr_new(/allocate_heap)
    self.btabPtr = ptr_new(/allocate_heap)
    self.ttabPtr = ptr_new(/allocate_heap)
    self.ktablePtr = ptr_new(/allocate_heap)
    self.davePtr = ptr_new(/allocate_heap)
    self.notifyIdPtr = ptr_new(/allocate_heap)
    self.headerPtr = ptr_new(/allocate_heap)

    self.maskPtr = ptr_new(/allocate_heap)
    self.dataPtr = ptr_new(/allocate_heap)
    self.errorPtr = ptr_new(/allocate_heap)
    self.xvalsPtr = ptr_new(/allocate_heap)
    self.yvalsPtr = ptr_new(/allocate_heap)

    self.omaskPtr = ptr_new(/allocate_heap)
    self.odataPtr = ptr_new(/allocate_heap)
    self.oresPtr = ptr_new(/allocate_heap)
    self.oerrorPtr = ptr_new(/allocate_heap)
    self.oxvalsPtr = ptr_new(/allocate_heap)
    self.oyvalsPtr = ptr_new(/allocate_heap)

    self.resxPtr = ptr_new(/allocate_heap)
    self.resyPtr = ptr_new(/allocate_heap)
    self.datxPtr = ptr_new(/allocate_heap)
    self.datyPtr = ptr_new(/allocate_heap)
    self.goodParmPtr = ptr_new(/allocate_heap)
    self.curvenamesPtr = ptr_new(/allocate_heap)
    self.ocurveGroup = ptr_new(/allocate_heap)
    self.grpArrayPtr = ptr_new(/allocate_heap)
    self.status = 5
    self.fitloop = 0
    self.duration = 1.e-3
    self.curIndex = 0
    self.info = 0L
    self.groupField = 0L
    self.fitStatus = ['Resting', 'Fitting', 'Paused']
    self.fitStatField = 0L
    self.dataPath = ''

    self.printFileName = ''
    self.logStringPtr = ptr_new(/allocate_heap)
    self.logFile = ''
    self.logDirectory = ''
    self.tasFilePtr = ptr_new(/allocate_heap)

    self.xtitle = 'x'
    self.ytitle = 'y'
    self.ztitle = 'z'
    self.subtitle = ''
	self.title = 'Data'
    self.usealttitle = 0
    self.alttitle = ''

;    self.prefs = ptr_new({preferences, $
;                          same:1, xenforce:0,yenforce:0, $
;                          xmin:0.0,xmax:1.0,ymin:0.0,ymax:1.0, $
;                          xfitlo:0.0,xfithi:1.0,initGuesses:0,tied:0, $
;                          xlabel:self.xtitle,ylabel:self.ytitle, $
;                          subtitle:self.subtitle,$
;                          maxIter:200})

;    self.prefs = ptr_new({pan_preferences, $  ;MUST BE NAMED AND IT MUST MATCH THE DEFINITION IN enterpref.pro
;                          same:1, xenforce:0,yenforce:0, $
;                          xmin:0.0,xmax:1.0,ymin:0.0,ymax:1.0, $
;                          xfitlo:0.0,xfithi:1.0,initGuesses:0,tied:0, $
;                          xlabel:self.xtitle,ylabel:self.ytitle, $
;                          subtitle:self.subtitle,$
;                          maxIter:200,$
;                          psym:4,$
;                          psymlist:['line (no symbol)','plus (+)','asterisk (*)','period (.)','diamond','triangle','square','X']});,$
;                          ;minimizeEvents:0 $  ;IN CASE OF FUNCTIONS REQUIRING LONG EVALUATION TIMES (e.g. FT_KWW), minimize the number of redraws
;                          ;})

self.prefs = ptr_new({same:1, xenforce:0,yenforce:0, $
  xmin:0.0,xmax:1.0,ymin:0.0,ymax:1.0, $
  xfitlo:0.0,xfithi:1.0,initGuesses:0,tied:0, $
  xlabel:self.xtitle,ylabel:self.ytitle, $
  subtitle:self.subtitle,$
  maxIter:200,$
  psym:4,$
  psymlist:['line (no symbol)','plus (+)','asterisk (*)','period (.)','diamond','triangle','square','X'], $
  allowApproxConv:1 $
  });,$



    self.fitgroup = 0
    self.addcurve = 0
    self.firstPoint = [0,0]
    self.secondPoint = [0,0]
    self.ocurrentPtr = ptr_new(/allocate_heap)
    self.taspathptr = ptr_new(/allocate_heap)
    self.autoscale = 1
    self.xbox = [0.0,1.0]
    self.xrange = [0.0,1.0]
    self.ybox = [0.0,1.0]
    self.yrange = [0.0,1.0]

    self.plotxlog = 0
    self.plotylog = 0
    self.hotkeys = 1

    self.title = 'Data'
    self.filename = wintitle

    if n_elements(notifyId) ne 0 then *self.notifyIdPtr = notifyId
    self.group_leader = group_leader

    ;help,wintitle

    Self.oEPSDE = PAN_EPSDE()

    self->createWidgets,wintitle=wintitle
    ; Commented out the following lines to eliminated table loading upon
    ; program initialization.  Only done on an "as-needed" basis now with
    ; a new object class instantiation (TABLE_LOOKUP__DEFINE).
    ;
    ;msg = 'Reading in lookup tables'
    ;self->flashMessage_create,msg,base;,event = event
    ;pan_readKTable,ktablePtr
    ;self->flashMessage_destroy,base;,event = event
    ;widget_control,self.info,set_value = 'Lookup tables loaded'
    ;*self.ktablePtr = *ktablePtr
    ;ptr_free,ktablePtr


    if n_elements(data) ne 0 then begin
      datasize = size(data)

      *self.dataPtr = data


      ;STORE MASK IF ENTERED.  IF NOT CREATE ONE.
      if n_elements(mask) ne 0 then begin
          if n_elements(mask) ne n_elements(data) then begin
              ;ASSUMED TO BE IN COMPRESSED bytes FORMAT
              nc = (size(data))[1]
              nr = (size(data))[2]

              *self.maskPtr = bytes2bits(mask,nc,nr)
              *self.omaskPtr = bytes2bits(mask,nc,nr)
          endif else begin
              ;IN ARRAY OF 1/0 FORMAT.
              *self.maskPtr = mask
              *self.omaskPtr = mask
          endelse
      endif else begin
          ;NO MASK ENTERED SO CREATE ONE.
          *self.maskPtr = byte(0*data + 1)
          *self.omaskPtr = byte(0*data + 1)
      endelse

      if n_elements(error) ne 0 then *self.errorPtr = error
      if n_elements(header) ne 0 then *self.headerPtr = header
      if n_elements(xvalues) ne 0 then begin
        *self.xvalsPtr = xvalues
      endif else begin
        if datasize[0] eq 1 then begin
            *self.xvalsPtr = dindgen(datasize)
        endif else begin
            *self.xvalsPtr = dindgen(datasize[1])#(1+fltarr(datasize[2]))
        endelse
      endelse


      ;EDIT THE NEXT LINE SO THAT VALUES ARE APPLIED TO THE DATA.
      if n_elements(yvalues) ne 0 then begin
        *self.yvalsPtr = yvalues
      endif else begin
        if datasize[0] eq 1 then begin
            *self.yvalsPtr = dblarr(datasize)
        endif else begin
            *self.yvalsPtr = (1+fltarr(datasize[0]))#dindgen(datasize[2])
        endelse
      endelse

      if n_elements(ztitle) ne 0 then begin
        self.ztitle = ztitle
        (*self.prefs).ylabel = ztitle
      endif
      if n_elements(xtitle) ne 0 then begin
        self.xtitle = xtitle
        (*self.prefs).xlabel = xtitle
      endif
      if n_elements(ytitle) ne 0 then begin
        self.ytitle = ytitle

        (*self.prefs).ylabel = ytitle
      endif
      if n_elements(title) ne 0 then self.title = title
      if n_elements(subtitle) ne 0 then self.subtitle = subtitle
      self->initNewDataObjects, event=event
    ;  self->scaleKtable
    ;  wset,self.datPix
    ;  self->displayData
    ;  wset,self.datVis
    ;  device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]
      self->refresh
    endif

    if n_elements(davePtr) ne 0 then begin
      *self.davePtr = *davePtr
      self->stuffDave,inFromDave = 1
      self->initNewDataObjects, event=event

    ;  self->scaleKtable
    ;  wset,self.datPix
    ;  self->displayData
    ;  wset,self.datVis
    ;  device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.datPix]

      self->refresh,wintitle=wintitle
    endif
    

    return,1
end;opan::init
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro opan__define

    define =    {opan, $
           ob_reg:obj_new(),   $
           reg_present:0,     $
           dataDir:'', $
           workDir:'', $
           daveTool:obj_new(), $
           printFileName:'', $
           macro_file:'',   $
           progressBar:0L,$
           insidePlot:0,$
           quickPlotObj:obj_new(),$
           ;macrofunctionobject:obj_new(),$ ;LRK USED TO AVOID NAMESPACE CONFLICTS AT MAIN LEVEL DURING MACRO FUNCTION EXECUTION.
           color_ptr:ptr_new(), $
           dataPath:'', $
           jpeg:0, $
           davePtr:ptr_new(), $
           tasFilePtr:ptr_new(), $
           notifyIdPtr:ptr_new(), $
           headerPtr:ptr_new(), $
           prefs:ptr_new(), $
           fitgroup:0, $
           grpArrayPtr:ptr_new(), $
           curIndex:0, $
           goodParmPtr:ptr_new(), $
           ndata:0L,              $
           ndata_field:0L,        $
           iteration:0L, $
           filename:'', $
           xtitle:'', $
           ytitle:'', $
           ztitle:'', $
           title:'', $
           alttitle:'',$
           usealttitle:0,$
           subtitle:'',$
           xunits:'', $
           yunits:'', $
           plotxlog:0,$
           plotylog:0,$
           hotkeys:0,$
           group_leader:0L, $
           fitStatus:strarr(3), $
           fitStatField:0L, $
           modify:0L, $
           groupField:0L, $
           interrupt:0L, $
           info:0L, $
           origInfoYsize:0L, $
           curveSlider:0L, $
           ocurveGroup:ptr_new(), $
           ocurrentPtr:ptr_new(), $
           addcurve:0, $
           curvenamesPtr:ptr_new(), $

           maskPtr:ptr_new(),$ ;SHOULD THERE BE AN ORIGINAL MASK AND A CURRENT MASK OR SHOULD WE
                               ;RELY ON THE DAVE PTR FOR THE ORIGINAL, SINCE WE STORE THE WHOLE DAVE PTR HERE????????
                               ;::stuffDave IS THE ENTRY POINT.

           twoDimFlag:0, $     ; Indicates dimensionality of model/function we are current using: 1=2D, 0=1D (default)
           dataPtr:ptr_new(), $
           errorPtr:ptr_new(), $
           xvalsPtr:ptr_new(), $
           yvalsPtr:ptr_new(), $
           resPtr:ptr_new(), $

           omaskPtr:ptr_new(),$
           odataPtr:ptr_new(), $
           oerrorPtr:ptr_new(), $
           oxvalsPtr:ptr_new(), $
           oyvalsPtr:ptr_new(), $
           oresPtr:ptr_new(), $

           oneResPtr:ptr_new(), $
           ktablePtr:ptr_new(), $
           xtabPtr:ptr_new(), $
           ytabPtr:ptr_new(), $
           btabPtr:ptr_new(), $
           ttabPtr:ptr_new(), $

           autoscale:0, $
           mouse:0B, $
           xrange:fltarr(2), $
           yrange:fltarr(2), $
           xbox:fltarr(2), $
           ybox:fltarr(2), $
           firstPoint:intarr(2), $
           secondPoint:intarr(2), $

           datWin:0L, $
           datVis:0L, $
           datPix:0L, $
           datxPtr:ptr_new(), $
           datyPtr:ptr_new(), $

           newHTML:0L, $
           existingHTML:0L, $
           commentHTML:0L, $
           plotHTML:0L, $
           closeHTML:0L, $
           logStringPtr:ptr_new(), $
           logDirectory:'', $
           logFile:'', $
           logBase:0L, $
           logFileStatus:0L, $
           logFileDisplay:0L, $

           resWin:0L, $
           resVis:0L, $
           resPix:0L, $
           resxPtr:ptr_new(), $
           resyPtr:ptr_new(), $

           winratio:0., $
           groupSlider:0L, $
           tlb:0L, $
           ctrlbase:0L, $
           dispBase:0L, $
           infoBase:0L, $
           duration:0.0, $
           status:0, $
           fitloop:0, $
           rPtr:ptr_new(), $
           gPtr:ptr_new(), $
           bPtr:ptr_new(), $
           tasPathPtr:ptr_new(),  $
           otable:obj_new(),   $
           
           oEPSDE:obj_new(), $
           
           timerID:0L}

end;opan__define
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro pan
    o = obj_new('opan')
end;pan


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Copy made on 7/1/2015 from OPAN::displaydata
;; Don't understand the code at all. Needs to be completely revamped
;pro opan::LRK_displaydata,_Extra = extra,ps_out = ps_out
;
;  ; If resolution is loaded then check if nos of groups is the same for
;  ; resolution and signal datasets
;  if (n_elements(*self.resPtr) gt 0) then begin
;    dSize = size(*self.dataPtr)
;    nd = (dSize[0] eq 2)? dSize[2] : 1
;    rSize = size((*self.resPtr).data)
;    nr = (rSize[0] eq 2)? rSize[2] : 1
;    if (nr ne nd) then begin
;      msg = ['Signal and resolution dataset groups do not match' $
;        ,'There are '+strtrim(string(nd),2)+' groups in signal dataset' $
;        ,'There are '+strtrim(string(nr),2)+' groups in resolution dataset' $
;        ,'Consider changing the signal OR the resolution data before proceeding' ]
;      void = dialog_message(msg,/error)
;      return                    ; exit
;    endif
;  endif
;
;  if n_elements(ps_out) eq 0 then ps_out = 0
;
;  if n_elements(*self.dataPtr) eq 0 then return
;  self->extractDataForPAN,dat=dat,derr=daterr,x=x,y=y,val=val,dsize=datSize
;  ;NOTE:  val = group# - 1
;
;  ;LRK 102008 - ADD THE NEXT LINE TO TEST FOR PRESENCE OF X DATA
;  ;  THIS CHECK MUST BE DONE ELSEWHERE AS WELL, BUT ERROR HANDLING CATCHES IT ANYWAY.
;  if n_elements(x) eq 0 then begin
;    void = dialog_message('No data for group '+strtrim(string(val+1),2))
;    return
;  endif
;
;  thisFormat = '(f10.5)'
;  this = self.ytitle+'='
;  ;self.title = '!6Q='+strtrim(string(y,format = thisformat),2)
;
;  ;030807
;  ;REPLACE THE NEXT LINE WITH THE ONE THAT FOLLOWS IT
;  ;    self.title = this+strtrim(string(y,format = thisformat),2)
;  self.title = this+strtrim(string(y[0],format = thisformat),2)
;
;  if self.autoscale eq 1 then begin
;    dx = 0.1*(max(x)-min(x))
;    self.xrange = [min(x)-dx,max(x)+dx]
;    dy = 0.1*(max(dat)-min(dat))
;    self.yrange = [min(dat-daterr)-dy,max(dat+daterr)+dy]
;  endif
;
;
;  if (*self.prefs).xenforce eq 1 then begin
;    self.xrange = [(*self.prefs).xmin,(*self.prefs).xmax]
;  endif
;  if (*self.prefs).yenforce eq 1 then begin
;    self.yrange = [(*self.prefs).ymin,(*self.prefs).ymax]
;  endif
;
;  psym = (*self.prefs).psym
;
;  ;LRK - 061311
;  device,get_decomposed=dc
;  device,decomposed=1
;
;  if ps_out then begin
;    color_1 = (*self.color_ptr).black
;    color_2 = color_1;
;    color_3 = color_1;(*self.color_ptr).sky
;    color_4 = color_1
;    color_5 = color_1
;    fg_color = color_1
;    bg_color = (*self.color_ptr).white
;  endif else begin
;    color_1 = (*self.color_ptr).black
;    color_2 = (*self.color_ptr).white
;    color_3 = (*self.color_ptr).sky
;    color_4 = (*self.color_ptr).red
;    color_5 = (*self.color_ptr).blue
;    fg_color = color_1
;    bg_color = color_2
;  endelse
;
;  plot,x,dat,psym=psym,$;4,$
;    symsize=1.5,xtitle=self.xtitle,ytitle=self.ztitle,title=self.title,$
;    subtitle=self.subtitle,$
;    xrange=self.xrange,yrange=self.yrange,xstyle=1,ystyle=1,_Extra=extra,$
;    color=fg_color,background=bg_color,charsize=1.25,xlog=self.plotxlog,ylog=self.plotylog
;  ;    plot,x,dat,psym=4,symsize=1.5,xtitle=self.xtitle,ytitle=self.ztitle,title=self.title $
;  ;         ,xrange=self.xrange,yrange=self.yrange,xstyle=1,ystyle=1,_Extra=extra $
;  ;         ,color=fg_color,background=bg_color,charsize=1.25;,/nodata
;  ;oplot,x,dat,psym = 4,color = color_2
;  errplot,x,dat-daterr,dat+daterr,width=0.0,color=fg_color
;  ;hfbs_cerrplot,x,dat-daterr,dat+daterr,width = 0.0,errcolors = {thisColor:color_2}
;  ; Draw the fit range if in the viewable window
;  xfitLo = (*self.prefs).xfitlo
;  xfitHi = (*self.prefs).xfithi
;  xdispLo = (!x.crange)[0]
;  xdispHi = (!x.crange)[1]
;
;  if xfitLo gt xdispLo then $
;    plots,[xfitLo,xfitLo],!y.crange,linestyle = 2;,color = color_3
;
;  if xfitHi lt xdispHi then $
;    plots,[xfitHi,xfitHi],!y.crange,linestyle = 2;,color = color_3
;
;  if obj_valid((*self.ocurveGroup)[val]) then begin
;
;    ncurves = (*self.ocurveGroup)[val]->count()
;    ocurves = (*self.ocurveGroup)[val]
;
;    ;; If the nos of data points within the display range is less than
;    ;; xLen, then increase the x values to xLen before evaluating the
;    ;; model function for display.
;    xIsModified = 0
;    xLen = 100;20
;
;    validIndex = where(x ge self.xrange[0] and x le self.xrange[1],count)
;
;    ;LRK - 08/14/09
;    ;USING xvalid CAN CREATE PROBLEMS WITH THE DISPLAY
;    ;WHEN THERE IS A RESOLUTION FUNCTION.  USE FULL x RANGE.
;    ;DATA WILL ONLY B PLOTTED OVER THE RANGE OF THE PLOT ANYWAY,
;    ;AND MODERN COMPUTERS SHOULD NOTICE NO SPEED LAG.
;
;    ;xvalid = x
;    ;---------------------
;    xlo = min(x) & xhi = max(x)
;    xrangelo = self.xrange[0] & xrangehi = self.xrange[1]
;    xValidLen = (5)*n_elements(x)
;    xValid = xlo + findgen(xValidLen)*(xhi-xlo)/(float(xValidLen) - 1.0)
;    ;NOW CHECK FOR THE CASE WHERE THE USER HAS ZOOMED IN TO SMALLER THAN ONE DATA STEP
;    xValidStep = xValid[1]-xValid[0]
;    if (xrangehi-xrangelo) lt xValidStep then begin
;      xValidStep = xValidStep/10.0
;      xValidLen = ceil((xhi-xlo)/xValidStep)
;      xValid = xlo + findgen(xValidLen)*(xhi-xlo)/(float(xValidLen) - 1.0)
;    endif
;
;    xIsModified = 1
;    ;_--------------------
;
;    oFuncs = ocurves->get(/all,count=nFuncs)
;
;    ;FIRST DRAW THE COMPONENTS WITHOUT THE RESOLUTION CONVOLUTION USING FULL,
;    ;FINELY SPACED X-RANGE
;    if (count gt 2 && $
;      ;count lt xLen && $
;      nFuncs gt 0) then begin
;
;      ;LRK - 08/14/09 ELIMINATE THE NEXT LINES IN FAVOR OF THE ABOVE
;      ;         ;xlo = self.xrange[0] & xhi = self.xrange[1]
;      ;
;      ;         ;013008
;      ;         ;ORIGINAL SETS THE NUMBER OF x VALUES TO 100; I WILL SIMPLY
;      ;         ;SET xValid TO BE x BEFORE DOING IT FOR THE oFuncs
;      ;         xValid = xlo + findgen(xLen)*(xhi-xlo)/(xLen -1)
;
;      for i = 0,nFuncs-1 do begin
;        oFuncs[i]->setproperty,xvalues = xValid, /calculate
;      endfor
;
;      xIsModified = 1
;    endif
;
;    ocurves->drawcomponents,linestyle = 2,thick = 2.5,color = color_4     ;RED
;
;    ;012908
;    ;
;    ;resPtr:  Does resPtr cause Tim's problem with plotting and large eb?
;    if n_elements(*self.resPtr) gt 0 then begin
;      ;print,'EVALUATE oCurves WITH RESOLUTION'
;
;      ;020508
;      ;IF func_cont AND func ARE TO BE UNCHANGED, I HAVE TO GET THE MASKED RES DATA AT THIS POINT
;      ;AND PASS THAT TO THE OCURVES HERE.
;      ;
;      ;NOTE: THERE IS ONE CURVE GROUP (func_cont) PER DATA GROUP, SO EACH CURVE GROUP HAS ITS OWN
;      ;      X, etc. VALUES FOR BOTH DATA AND RES!!!
;      ;
;
;      ;    *self.oneResPtr = reform((*self.resPtr).data[*,val])
;      ;020508
;      ;REPLACE THE NEXT STATEMENT WITH THE COLLECTION IMMEDIATELY BELOW IT:
;      ;         (*self.oneResPtr) = {x:(*self.resPtr).x $
;      ;                              ,y:(*self.resPtr).y $
;      ;                              ,data:reform((*self.resPtr).data[*,val]) $
;      ;                              ,rlimit:(*self.resPtr).rlimit $
;      ;                             }
;
;
;      ;020508 THE NEXT BLOCK OF CODE SUPERCEDES THE ONE BELOW IT.
;      resExists = self->ExtractOneResStr(val,OneResStr)
;      if resExists ne 0 then begin
;        ;(*self.oneResPtr) = OneResStr
;        (*self.oneResPtr) = OneResStr
;
;        ;LRK - 08/14/09
;        ;
;        ;HERE USE EXACT X-RANGE BECAUSE CONVOLUTION OF RES WITH DIFFERENT RANGE OFTEN CAUSES TRUNCATION RIPPLES.
;
;        ;             ocurves->evaluate,xValid,yout = yout,resPtr = self.oneResPtr
;        ;---------------------
;        for i = 0,nFuncs-1 do begin
;          oFuncs[i]->setproperty,xvalues = x, /calculate
;        endfor
;
;        ocurves->evaluate,x,yout = yout,resPtr = self.oneResPtr
;
;        for i = 0,nFuncs-1 do begin
;          oFuncs[i]->setproperty,xvalues = xvalid, /calculate
;        endfor
;        ;---------------------
;
;      endif else begin
;        ;void = dialog_message('opan::drawCurveEvents NO resData For Group#'+strtrim(string(val),2))
;        ;void = dialog_message('opan::drawCurveEvents What do I do???????')
;        self->clearOneRes_ptr
;
;        ;LRK 02/02/09
;        ;void = dialog_message('No Resolution Data for Group #'+strtrim(string(val+1),2))
;        void_message = 'No Resolution Data for Group #'+strtrim(string(val+1),2)
;
;        void = dialog_message(void_message,dialog_parent=self.tlb,title='No Resolution for Group')
;
;        ocurves->evaluate,xValid,yout = yout
;      endelse
;      ;020508 COMMENT OUT THE NEXT LONG BLOCK OF CODE.  IT IS SUPERCEDED BY THE BLOCK JUST ABOVE THIS LINE
;      ;         mask = (*self.resptr).mask[*,val]
;      ;         whnotmasked = where(mask ne 0,notmaskcount)
;      ;
;      ;;print,'notmaskcount=',notmaskcount
;      ;         if notMaskCount eq 0 then begin
;      ;             void = dialog_message('No Resolution Data for Group #'+strtrim(string(val),2))
;      ;         endif else begin
;      ;             xOneRes = (*self.resPtr).x[whnotmasked]
;      ;             yOneRes = (*self.resPtr).y[whnotmasked]
;      ;             dataOneRes = reform((*self.resPtr).data[whnotmasked,val])
;      ;             rlimitOneRes = (*self.resPtr).rlimit
;      ;             (*self.oneResPtr) = {x:xOneRes,$
;      ;                                  y:yOneRes,$
;      ;                                  data:dataOneRes,$
;      ;                                  rlimit:rlimitOneRes}
;      ;
;      ;
;      ;
;      ;
;      ;    ;help,xvalid
;      ;    ;help,(*self.resPtr).x,(*self.resPtr).y,(*self.resPtr).data[*,val],(*self.resPtr).rlimit
;      ;    ;help,ocurves
;      ;            ocurves->evaluate,xValid,yout = yout,resPtr = self.oneResPtr
;      ;         endelse
;    endif else begin
;
;      ;NO RESOLUTION
;      ;print,'EVALUATE oCurves WITH NO RESOLUTION'
;      ocurves->evaluate,xValid,yout = yout
;    endelse
;
;
;    if n_elements(yout) gt 1 then begin
;      ; Is there a resolution function present?  Yes -> do the convolution!
;      fitcolor = (*self.color_ptr).red
;
;      ;020608
;      ;REPLACE THE NEXT if-thenelse WITH THE ONE BELOW IT
;      ;        if n_elements(*self.resPtr) gt 0 then begin
;      ;    ;      *self.oneResPtr = (reform((*self.resPtr).data[*,val]))
;      ;           (*self.oneResPtr) = {x:(*self.resPtr).x $
;      ;                                ,y:(*self.resPtr).y $
;      ;                                ,data:reform((*self.resPtr).data[*,val]) $
;      ;                                ,rlimit:(*self.resPtr).rlimit $
;      ;                               }
;      ;          rlimit = (*self.resPtr).rlimit
;      ;          ocurves->evaluate,xValid,yout = yout,resPtr = self.oneResPtr,rlimit = rlimit
;      ;          oplot,xValid,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
;      ;
;      ;        endif else begin
;      ;          oplot,xValid,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
;      ;        endelse
;
;      resExists = self->ExtractOneResStr(val,OneResStr)
;      if resExists ne 0 then begin
;        (*self.oneResPtr) = OneResStr
;        rlimit=OneResStr.rlimit
;        ;LRK - 08/14/09
;        ;
;        ;HERE USE EXACT X-RANGE BECAUSE CONVOLUTION OF RES WITH DIFFERENT RANGE OFTEN CAUSES TRUNCATION RIPPLES.
;        ;ocurves->evaluate,xValid,yout = yout,resPtr = self.oneResPtr
;        ;---------------------
;        ;          ocurves->evaluate,xValid,yout = yout,resPtr = self.oneResPtr,rlimit = rlimit
;        ;          oplot,xValid,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
;        ;---------------------
;        for i = 0,nFuncs-1 do begin
;          oFuncs[i]->setproperty,xvalues = x, /calculate
;        endfor
;
;        ocurves->evaluate,x,yout = yout,resPtr = self.oneResPtr
;
;        for i = 0,nFuncs-1 do begin
;          oFuncs[i]->setproperty,xvalues = xvalid, /calculate
;        endfor
;        ;---------------------
;        oplot,x,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
;
;      endif else begin
;        if resExists eq 0 then self->clearOneRes_ptr
;        ;AT THIS POINT I AM ASSUMING THAT yout CONTAINS THE DATA CALCULATED ABOVE.
;        oplot,xValid,yout,linestyle = 0,thick = 3.0,color = color_5       ;BLUE
;      endelse
;
;    endif else begin
;      if (!d.name ne 'PS') and (!d.name ne 'PRINTER') and (self.jpeg ne 1) then wset,self.resVis
;      if self.jpeg eq 0 then erase
;    endelse
;
;    ;; if the x values of the model function was altered for display
;    ;; purposes, revert to the original x.
;    if (xIsModified) then begin
;      for i = 0,nFuncs-1 do begin
;        oFuncs[i]->setproperty,xvalues = x, /calculate
;      endfor
;    endif
;  endif
;  *self.datxPtr = !x
;  *self.datyPtr = !y
;
;  ;if ((!d.name ne 'PS') and (!d.name ne 'PRINTER') and (self.jpeg ne 1)) then begin
;  ;   device, decomposed=old_dc
;  ;endif
;
;  device,decomposed=dc
;
;  return
;end;opan::displaydata


pro PAN_ExportFitResults_event, event

uname = widget_info(event.id, /uname)
widget_control, event.top, get_uvalue=sHash
case uname of
  'ACCEPT': begin
    sHash['accept'] = 1
    sHash['cancel'] = 0
    widget_control, event.top, /destroy
  end
  
  'CANCEL': begin
    sHash['accept'] = 0
    sHash['cancel'] = 1
    Widget_control, Event.top, /destroy    
  end
  
  else: begin
    sHash[uname] = widget_info(event.id, /button_set)
  end
endcase

end



pro pulldown_event, event
print, widget_info(event.id, /uname)

widget_control, event.id, get_uvalue=uvalue
help,uvalue
print,'Event.value = ',event.value
end

pro pulldown

tlb = widget_base()

desc = REPLICATE({ flags:0, name:'' }, 6)
desc.flags = [ 1, 0, 1, 0, 2, 2 ]
desc.name = [ 'Operations', 'Predefined', 'Interpolate','Linear', 'Spline', 'Quit' ]

base = Widget_base(/column)
menu = Cw_pdmenu(base, desc, /return_index)
void = widget_label(base, value="Basic widget label to create visible canvas")
void = Widget_label(base, value="Basic widget label to create visible canvas")
void = Widget_button(base, value="Quit",/align_center, uname="QUIT")

Widget_control, base, /REALIZE

Xmanager,'pulldown', base, /no_block
  

end


PRO PD_EXAMPLE

   desc = ['1\Select 1D Function' $
          ,'1\Background' $
          ,'0\Linear' $
          ,'0\Quadratic' $
          ,'2\Empirical' $
          ,'1\Exponential' $
          ,'0\Kohlrausch-Williams-Watts' $
          ,'0\FT Kohlrausch-Williams-Watts' $
          ,'0\Exp Decay' $
          ,'0\Exp Growth' $
          ,'2\Exp GrowthDecay' $
          ,'1\Momentum Dist' $
          ,'0\Additive' $
          ,'0\Convolution' $
          ,'0\Conv Model Np' $
          ,'0\Calculated Np' $
          ,'2\Calculated FSE' $
          ,'1\Quasielastic' $
          ,'2\QENS' $
          ,'1\Peak' $
          ,'0\Delta (resolution)' $
          ,'0\DHO' $
          ,'0\Gaussian' $
          ,'0\Lorentzian' $
          ,'0\Gaussian+Bkgd (auto)' $
          ,'0\Lorentzian+Bkgd (auto)' $
          ,'0\Log-Normal' $
          ,'2\Voigt' $
          ,'1\Phase Transition' $
          ,'0\Order Parameter' $
          ,'2\Meanfield Order Parameter' $
          ,'1\User Defined' $
          ,'0\User Function' $
          ,'2\User Macro' $
          ,'1\Other' $
          ,'0\Rouse_scaled' $
          ,'2\IkedaCarpenter' $
          ,'2\Quit' $
          ]

   func = ['Select 1D Function' $
          ,'Background' $
          ,'Linear' $
          ,'Quadratic' $
          ,'Baseline' $
          ,'Exponential' $
          ,'KWW' $
          ,'FT_KWW' $
          ,'Decay' $
          ,'ExpGrowth' $
          ,'ExpGrowthDecay' $
          ,'Momentum Dist' $
          ,'QFluidAA' $
          ,'QFluidJqyCF' $
          ,'QFluidJqyNp' $
          ,'QFluidCalcNp' $
          ,'QFluidCalcFSE' $
          ,'Quasielastic' $
          ,'QENS' $
          ,'Peak' $
          ,'Delta' $
          ,'DHO' $
          ,'Gaussian' $
          ,'Lorentzian' $
          ,'AutoGaussian' $
          ,'AutoLorentzian' $
          ,'LogNormal' $
          ,'Voigt' $
          ,'Phase Transition' $
          ,'OrderParameter' $
          ,'MeanfieldOrderParameter' $
          ,'User Defined' $
          ,'Userfunction' $
          ,'Macrofunction' $
          ,'Other' $
          ,'Rouse_scaled' $
          ,'IkedaCarpenter' $
          ,'Quit' $
          ]
          
   ; Create the widget:
   base = WIDGET_BASE()
   menu = CW_PDMENU(base, desc, /RETURN_INDEX)
  void = Widget_label(base, value="Basic widget label to create visible canvas")
  void = Widget_label(base, value="Basic widget label to create visible canvas")
  widget_control, menu, set_uvalue=func
  Widget_control, /REALIZE, base

  ;Provide a simple event handler:

  REPEAT BEGIN
    ev = Widget_event(base)
    Print, ev.value
    ;toks = strsplit(desc[ev.value],'\',/extract)
    widget_control, ev.id, get_uvalue=func_names
    print,'Function name = ',func_names[ev.value]
  END UNTIL desc[ev.value] eq '2\Quit'; ev.value EQ 'Quit'

   WIDGET_CONTROL, /DESTROY, base


END

pro widtext_ex_change, ev
  common _widtext, w1, w2
  Widget_control, w1, foreground_color=Bytscl(Randomu(s,3)), background_color=Bytscl(Randomu(s,3))
  Widget_control, w2, foreground_color=Bytscl(Randomu(s,3)), background_color=Bytscl(Randomu(s,3))
end

pro widtext_ex
  common _widtext, w1, w2
  w = Widget_base(xsize = 200, /column)
  w0 = Widget_base(w, /row)
  f = 'Segoe*24'
  w1 = Widget_label(w0, value='Label', foreground_color=[0,200,0], background_color=[255,255,0], font=f, scr_xsize=100)
  w2 = Widget_text(w0, value='My Text', /editable, foreground_color=[0,0,255], background_color=[235,255,235], font=f)
  w0 = Widget_base(w, /row)
  wbutton = Widget_button(w0, value='Change', event_pro = 'widtext_ex_change', font=f)
  Widget_control, w, /realize
  Xmanager,'widtext_ex', w, /no_block

end

