; $Id$
;###############################################################################
;+
; CLASS NAME:
;   OBJECT_REGISTRY
;
; PURPOSE:
;   This class definition allows the user to register widget object
;   programs with it and, whenever anything changes to the data, a
;   REFRESH method is invoked and all such widget object programs
;   registered are updated simultaneously.
;
; CATEGORY:
;   Data Browser
;
; SUPERCLASSES:
;   IDL_CONTAINER
;
; PUBLIC METHODS:
;   refresh
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;   Feb, 2003
;
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################



;===============================================================================
; object_registry::cleanup
;
; PURPOSE:
;   Cleanup method for the object_registry class
;
; PARAMETERS:
;
; KEYWORDS:
;
pro object_registry::cleanup
self->IDL_CONTAINER::cleanup
end
pro object_registry::refresh,_Extra = extra
nobj = self->count()
if nobj eq 0 then return
oall = self->get(/all)
for i = 0,nobj-1 do begin
;  r = execute('oall[i]->refresh,_Extra = extra',1)
    oall[i]->refresh,_Extra = extra
endfor
end
;-------------------------------------------------------------------------------



;===============================================================================
; object_registry::init
; 
; PURPOSE:
;   Initialization method for the object_registry class
;
; PARAMETERS:
;
; KEYWORDS:
;
; RETURN VALUE
;   1 - if sucessful
;   0 - failure
;
function object_registry::init
retval = self->IDL_CONTAINER::init()
return,retval
end
;-------------------------------------------------------------------------------



;===============================================================================
; object_registry__define
;
; PURPOSE:
;   Definition of the class structure for the object_registry class
;
; PARAMETERS:
;
; KEYWORDS:
;
pro object_registry__define
define =	{	object_registry,		$
				inherits IDL_CONTAINER	$
			}

end
