; $Id$
;###############################################################################
;
; NAME:
;  PAN_MACROFUNCTION
;
; PURPOSE:
;  User-defined macro-function for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function pan_macrofunction,x,parms,fit_fun_filename=fit_fun,expr = expr,eval = eval,$
  parmnames=parmnames, single_parmnames=single_parmnames, multi_parmnames=multi_parmnames,    $
  canDraw=canDraw, drawMessage=drawMessage, xrange=xrange, xunits=xunits, $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, initParms=initParms, $
  qvals=qvals,xVals=xVals,yVals=yVals,groupNumber=groupNumber,qGroup=qGroup, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, $
  resPtr=resPtr, resLimit=rLimit,resolutionRequiredFlag=resolutionRequiredFlag, extConvolFlag=extConvolFlag, $
  _Extra = extra

release = 6.1
;fit_fun = extra.fit_fun_filename
this_level = routine_names(/level) 
main_level = 1
canDraw = 0

; use the previously read macro function. If not available then read it from file
if (n_elements(expr) ne 0) then begin
  macro_text = expr
endif else begin
  if (n_elements(fit_fun) ne 0) then begin
    nlines = 0L
    str = ''
    nlines = File_lines(fit_fun)
    macro_text = Strarr(nlines)
    Openr,lun,fit_fun,/get_lun
    Readf, lun, macro_text
    Free_lun,lun,/force
  endif
endelse

; can't continue without a macro fuction defn
eval = 0
if (n_elements(macro_text) eq 0) then return, 0

; First determine if the call is for the parameter names only...
if n_params() eq 0 then begin
  ; then only process the first portion of the macro before any reference
  ; to the parms variable is made. We need to extract key variables such
  ; as parmnames, twoDimFlag, delta_params and initParms. These are considered
  ; the header section of the macro. Previously, these were all limited to the 
  ; first line of the macro but not any longer
;  ; D/c a search for 'parms' also returns 'initParms', we must allow for that possibility
;  parmsLoc = Where(Stregex(macro_text,'parms',/fold,/bool) eq 1, parmsFound)
;  initParmsLoc = Where(Stregex(macro_text,'initParms',/fold,/bool) eq 1, initParmsFound)
;  if (initParmsFound gt 0) then begin
;    ;; header should include the lines containing initParms
;    nheader = parmsLoc[where(parmsLoc eq initParmsLoc[initParmsFound-1],fd)+1]
;  endif else nheader = parmsloc[0]
  nHeader = max(where(Stregex(macro_text,'initParms',/fold,/bool))) > $
            max(where(Stregex(macro_text,'parmnames',/fold,/bool))) > $
            max(where(Stregex(macro_text,'twoDimFlag',/fold,/bool))) > $
            ;max(where(Stregex(macro_text,'delta_params',/fold,/bool))) > $
            max(where(Stregex(macro_text,'single_parmnames',/fold,/bool))) > $
            max(where(Stregex(macro_text,'multi_parmnames',/fold,/bool)))
  macro_header = macro_text[0:nheader]
  
  ; need to supply qVals and xVals because they may be needed as input before 
  ; executing/processing the macro_header especially for 2D macros
  if N_elements(xVals) ne 0 then begin
    value  = routine_names('xVals', fetch = this_level)
    dummy  = routine_names('xVals', value, store = main_level)
  endif
  if N_elements(qVals) ne 0 then begin
    value  = routine_names('qVals', fetch = this_level)
    dummy  = routine_names('qVals', value, store = main_level)
  endif

  ;pan_do_the_macro RUNS THE MACRO VIA EXECUTE, thus evaluating/determining various
  ;key variables defined by the macro such as parmnames, twoDimFlag, etc AT THE MAIN LEVEL.
  ret = pan_do_the_macro(macro_header)

  value  = routine_names('parmnames', fetch = main_level)
  dummy  = routine_names('parmnames', value, store = this_level)
  if N_elements(routine_names('twoDimFlag', fetch = main_level)) ne 0 then begin
    value  = routine_names('twoDimFlag', fetch = main_level)
    dummy  = routine_names('twoDimFlag', value, store = this_level)
  endif
  if N_elements(routine_names('single_parmnames', fetch = main_level)) ne 0 then begin
    value  = routine_names('single_parmnames', fetch = main_level)
    dummy  = routine_names('single_parmnames', value, store = this_level)
  endif
  if N_elements(routine_names('multi_parmnames', fetch = main_level)) ne 0 then begin
    value  = routine_names('multi_parmnames', fetch = main_level)
    dummy  = routine_names('multi_parmnames', value, store = this_level)
  endif
  if N_elements(routine_names('initParms', fetch = main_level)) ne 0 then begin
    value  = routine_names('initParms', fetch = main_level)
    dummy  = routine_names('initParms', value, store = this_level)
  endif
  if N_elements(routine_names('resolutionRequiredFlag', fetch = main_level)) ne 0 then begin
    value  = routine_names('resolutionRequiredFlag', fetch = main_level)
    dummy  = routine_names('resolutionRequiredFlag', value, store = this_level)
  endif
  if (where(Stregex(macro_text,'delta_params',/fold,/bool)) ge 0) then begin
    ; if delta_params is referenced in macro then switch on resolutionRequiredFlag since a delta-function requires it
    resolutionRequiredFlag = 1
  endif
  if N_elements(routine_names('extConvolFlag', fetch = main_level)) ne 0 then begin
    value  = routine_names('extConvolFlag', fetch = main_level)
    dummy  = routine_names('extConvolFlag', value, store = this_level)
  endif
  
  return,0
endif

; Send the x and parms values to the main level
value  = routine_names('x', fetch = this_level) ; get x from this level
dummy  = routine_names('x', value, store = main_level) ; and store it in the main level
value = routine_names('parms',fetch = this_level)
dummy = routine_names('parms',value,store = main_level)
if n_elements(QGroup) ne 0 then begin;eq 1 then begin
  value  = routine_names('Qgroup', fetch = this_level) ; get qgroup from this level
  dummy  = routine_names('Qgroup', value, store = main_level) ; and store it in the main level
endif
if n_elements(groupNumber) ne 0 then begin;eq 1 then begin
  value  = routine_names('groupNumber', fetch = this_level) ; get qgroup from this level
  dummy  = routine_names('groupNumber', value, store = main_level) ; and store it in the main level
endif
if N_elements(qVals) ne 0 then begin
  value  = routine_names('qVals', fetch = this_level) 
  dummy  = routine_names('qVals', value, store = main_level) 
endif


;TODO: this commented code need to be examined!
;; If a resolution function is present, retrieve it from the $main$ level
;if n_elements(routine_names('resptr',fetch = main_level)) ne 0 then begin
;   value  = routine_names('resptr', fetch = main_level)
;   dummy  = routine_names('resptr', value, store = this_level)
;endif

; Now execute the macro
eval = pan_do_the_macro(macro_text,QGroup=QGroup,groupNumber=groupNumber,qvals=qvals)
;eval = 1
if (eval eq 0) then return, eval
;  eval = 0
;  return,ret
;endif

; Retrieve ymodel, ydelta, and parmnames from the main level
if n_elements(routine_names('ymodel', fetch = main_level)) ne 0 then begin
  value  = routine_names('ymodel', fetch = main_level)
  dummy  = routine_names('ymodel', value, store = this_level)
endif
if n_elements(routine_names('delta_params', fetch = main_level)) ne 0 then begin
  value  = routine_names('delta_params', fetch = main_level)
  dummy  = routine_names('delta_params', value, store = this_level)
endif
value  = routine_names('parmnames', fetch = main_level)
dummy  = routine_names('parmnames', value, store = this_level)

canDraw = 0


;LRK - 01/27/09
;
;THE PROBLEM WITH THE NEXT BLOCK IS THAT resptr MAY HAVE BEEN CREATED AT THE MAIN
;LEVEL FOR SOME OTHER PURPOSE IN DAVE AND BE EITHER NO LONGER VALID OR 
;INAPPROPRIATE FOR THE CURRENT USE.  FIRST AT LEAST CHECK THAT THE POINTER IS
;VALID.  IF NOT, GO DIRECTLY TO THE SECOND BLOCK??????
;
;BUT, THIS MAY PRODUCE AN UNEXPECTED RESULT.

; If resolution function is present then perform the convolution here
if ((n_elements(resPtr) gt 0) && ptr_valid(resPtr) && (n_elements(*resPtr) gt 0)) then begin  ;LRK 01/27/09
  if n_elements(ymodel) ne 0 then begin
    yout = pan_convolute(x,resPtr,ymodel,pseudo_delta = delta_params)
  endif else begin
    yout = pan_convolute(x,resPtr,pseudo_delta = delta_params)
  endelse
endif else begin
  yout = 0
  if (n_elements(pseudo_delta) ne 0) and (n_elements(ymodel) eq 0) then begin
    yout = 0
  endif
  if (n_elements(ymodel) ne 0) then begin
    yout = ymodel
  endif
endelse
; Delete all the main level variables
;if (!version).release ge release then begin
;   varnames = scope_varname(level = main_level)
;   for jj = 0,n_elements(varnames)-1 do $
;      if (varnames[jj] ne 'jj') and (varnames[jj] ne 'r') and $
;         (n_elements((scope_varfetch(varnames[jj],/enter,level = main_level))) ne 0) then $
;         r = temporary((scope_varfetch(varnames[jj],/enter,level = main_level)))
;endif
return,yout
end;pan_macrofunction
