; $Id$
;###############################################################################
;
; NAME:
;  Pan_ExponentialDecay
;
; PURPOSE:
;  Exponential decay for use in fitting data in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN
;
; AUTHOR:
;   Richard Tumanjong Azuah, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; Exponential Decay with offset
function Pan_ExponentialGrowth,  x,parms,$
  parmnames = parmnames, $
  canDraw = canDraw, $
  drawMessage = drawMessage, $
  func_dataHash=func_dataHash,twoDimFlag=twoDimFlag, $
  changesecond=changesecond, changefirst=changefirst, xMouseClick=xMouseClick, yMouseClick=yMouseClick, xrange=xrange, $
  _Extra = extra


canDraw = 1
twoDimFlag = 0

if N_params() eq 0 then begin
  parmnames = ['Amax','Time constant', 'Toffset']
  Return,-1
endif
drawMessage = Strarr(4)
drawMessage[0:1] = ['Hold left mouse button down','and drag function max value and time/x offset']
drawMessage[2:3] = ['Hold left mouse button down','and drag to change the time constant']

if (Keyword_set(changefirst)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is first release at the location for the function centroid
  ; translate the position into suitable parameters.
  ;Print,'###Changefirst called within function...'
  parms[0] = yMouseClick
  parms[1] = 0.1*abs(xrange[1] - xrange[0])  ;
  parms[2] = xMouseClick 
endif

if (Keyword_set(changesecond)) then begin
  ; user is initializing the function graphically
  ; this block of code is executed when the mouse is move to define the function width
  ; translate the position into suitable parameters.
  ;Print,'###Changesecond called within function...'
  A0 = parms[0]
  toffset = parms[2]
  parms[1] = Abs((xMouseclick - toffset)/(Alog(yMouseclick) - Alog(A0)))  ; solve for the decay constant, assuming the mouse click is on the decay curve
endif


yout = parms[0]*Exp((x - parms[2])/parms[1])
index = Where((x - parms[2]) gt 0.,count_GTzero)
if (count_GTzero gt 0) then yout[index] = 0.0

Return,yout

end
