; $Id$
;###############################################################################
;
; NAME:
;  ENTERPARMINFO
;
; PURPOSE:
;  This widget dialog allows the user to type in parameter info for the fit.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
function getParmInfo,pState
; Ok, now pull all of the information out

ncurves = n_elements((*(*pState).parmInfoPtr).names)
nparms = total((*(*pState).parmInfoPtr).nparms)

; First pull out values from text fields

for i = 0,nparms-1 do begin
  widget_control,(*pState).valIds[i],get_value = valIds
  if i eq 0 then outValid = valIds[0] else outValid = [outValid,valIds[0]]
endfor
(*(*pState).parmInfoPtr).parms = outValid

for i = 0,nparms-1 do begin
  widget_control,(*pState).lowvalIds[i],get_value = lovalIds
  if i eq 0 then outlowvals = lovalIds[0] else outlowvals = [outlowvals,lovalids[0]]
endfor
(*(*pState).parmInfoPtr).lovalues = outlowvals

for i = 0,nparms-1 do begin
  widget_control,(*pState).hivalIds[i],get_value = hivalIds
  if i eq 0 then outhighvals = hivalIds[0] else outhighvals = [outhighvals,hivalids[0]]
endfor
(*(*pState).parmInfoPtr).hivalues = outhighvals

; Now pull out the checkbox settings
for i = 0,nparms-1 do begin
  widget_control,(*pState).fixIds[i],get_value = fixed
  if i eq 0 then outfixed = fixed else outfixed = [outfixed,fixed]
endfor
(*(*pState).parmInfoPtr).fixed = outfixed

for i = 0,nparms-1 do begin
  widget_control,(*pState).lowIds[i],get_value = low
  if i eq 0 then outlow = low else outlow = [outlow,low]
endfor
(*(*pState).parmInfoPtr).low = outlow

for i = 0,nparms-1 do begin
  widget_control,(*pState).highIds[i],get_value = high
  if i eq 0 then outhigh = high else outhigh = [outhigh,high]
endfor
(*(*pState).parmInfoPtr).high = outhigh

for i = 0,nparms-1 do begin
  widget_control,(*pState).tieIds[i],get_value = tied
  if i eq 0 then outtied = tied else outtied = [outtied,tied]
endfor
(*(*pState).parmInfoPtr).tied = outtied

return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parmInfoCleanup,tlb
widget_control,tlb,get_uvalue = pState
if ((*pState).notifyIds)[0] ne (-1L) then begin
  s = size((*pState).notifyIDs)
  if s[0] eq 1 then count = 0 else count = s[2]-1
  for j = 0,count do begin
    parmsInfo = {parmsQuitEvent,$
                        ID:(*pState).notifyIDs[0,j],$
                        Top:(*pState).notifyIDs[1,j],$
                        Handler:0l}
    if widget_info((*pState).notifyIDs[0,j],/valid_id) then begin $
      widget_control,(*pState).notifyIDs[0,j],send_event = parmsInfo
    endif
  endfor
endif
ptr_free,(*pState).parmInfoPtr
ptr_free,pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parmInfoQuit,event
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parmInfoQuitModal,event
widget_control,event.top,get_uvalue = pState
dummy = getParmInfo(pState)
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro parmInfoAccept,event
widget_control,event.top,get_uvalue = pState
dummy = getParmInfo(pState)
widget_control, event.id, get_uvalue=button_type
(*(*pState).parmInfoPtr).apply2AllGrps = button_type  ; if button_type eq 1 ==> apply parmInfo to all data groups
                                                      ; this is done in OPAN::updateParmInfo() triggerred by the send_event 
                                                      ; message below
if ((*pState).notifyIds)[0] ne (-1L) then begin
  s = size((*pState).notifyIDs)
  if s[0] eq 1 then count = 0 else count = s[2]-1
  for j = 0,count do begin
    parmsInfo = {parmsEvent,$
                        ID:(*pState).notifyIDs[0,j],$
                        Top:(*pState).notifyIDs[1,j],$
                        Handler:0l,$
                        parmInfo:(*pState).parmInfoPtr}
    if widget_info((*pState).notifyIDs[0,j],/valid_id) then begin $
      widget_control,(*pState).notifyIDs[0,j],send_event = parmsInfo
    endif
  endfor
endif
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro enterparminfo_event,event

widget_control,event.top,get_uvalue = pState
nparms = total((*(*pState).parmInfoPtr).nparms)

print, 'enterparminfo_event called...'

uname = widget_info(event.id,/uname)

lowids = (*pstate).lowids
highids = (*pstate).highids

case uname of
  'SETLIMITS': begin
    for i=0,n_elements(lowids)-1 do begin
      widget_control, lowids[i], get_value=vals
      vals[*] = 1
      widget_control, lowids[i], set_value=vals
;      widget_control, highids[i], get_value=vals
;      vals[*] = 1
      widget_control, highids[i], set_value=vals
    endfor
  end
  
  'UNSETLIMITS': begin
    for i=0,n_elements(lowids)-1 do begin
      widget_control, lowids[i], get_value=vals
      vals[*] = 0
      widget_control, lowids[i], set_value=vals
;      widget_control, highids[i], get_value=vals
;      vals[*] = 1
      widget_control, highids[i], set_value=vals
    endfor
  end
  
  'CALCLIMITS': begin
    valIds = (*pstate).valIds
    nIds = n_elements(valIds)
    vals = fltarr(nIds)
    loVals = vals
    hiVals = loVals
    for i=0,nIds-1 do begin
      widget_control, valIds[i], get_value=val
      vals[i] = float(val)
    endfor
    zeroIndex = where(vals eq 0.0, zeroCnt, complement=nonZeroIndex, ncomplement=nonZeroCnt)
    
    if (zeroCnt gt 0) then begin
      loVals[zeroIndex] = -1.0
      hiVals[zeroIndex] = 1.0
    endif
    if (nonZeroCnt gt 0) then begin
      lopctage = float(widget_info(widget_info(event.top, FIND_BY_UNAME='LOPCTAGE'),/combobox_gettext))
      hipctage = float(widget_info(widget_info(event.top, FIND_BY_UNAME='HIPCTAGE'),/combobox_gettext))
      loVals[nonZeroIndex] = vals[nonZeroIndex] - 0.01*lopctage*abs(vals[nonZeroIndex])
      hiVals[nonZeroIndex] = vals[nonZeroIndex] + 0.01*hipctage*abs(vals[nonZeroIndex])
    endif
    for i=0,nIds-1 do begin
      widget_control, (*pstate).lowvalIds[i], set_value=loVals[i]
      widget_control, (*pstate).hivalIds[i], set_value=hiVals[i]
    endfor

  end
  
  else:
endcase

return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro enterparminfo,inInfo, $
                  group_leader = group_leader, $
                  notifyIds = notifyIds, $
                  modal = modal, $
                  parmInfoOut = parmInfoOut
if n_elements(modal) eq 0 then modal = 0
if n_elements(notifyIds) eq 0 then notifyIds = (-1L)
; Widget definition module
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'PAN Parameter Information', $
        /tlb_frame_attr,/base_align_center)
endif else begin
  tlb = widget_base(group_leader = group_leader, /col, $
        title = 'PAN Parameter Information',/tlb_frame_attr, $
        /base_align_center,modal = modal)
endelse

xsize = 10

if n_params() eq 0 then begin
  ncurves = 2
  nparms = [3,2]
  totparms = total(nparms)
  names = ['pan_gaussian','pan_background']
  expr = replicate('',totparms)
  tied = replicate(0d,totparms)
  step = replicate(0d,totparms)
  fixed = replicate(0,totparms)
  lovalues = replicate(0d,totparms)
  low = replicate(0,totparms)
  high = replicate(0,totparms)
  hivalues = replicate(1d,totparms)
  parms = [1.0,0.0,1.0,0.0,0.0]
  parmnames = ['area','center','width','offset','slope']
  inInfo =   {names:names, nparms:nparms,step:step, fixed:fixed, $
              lovalues:lovalues, hivalues:hivalues, high:high, $
              low:low, parms:parms, parmnames:parmnames, $
              tied:tied,expr:expr}
endif

parminfo = {       names:inInfo.names, $
                   nparms:inInfo.nparms,$
                   step:inInfo.step, $
                   fixed:inInfo.fixed, $
                   lovalues:inInfo.lovalues, $
                   hivalues:inInfo.hivalues, $
                   high:inInfo.high, $
                   low:inInfo.low, $
                   parms:inInfo.parms, $
                   parmnames:inInfo.parmnames, $
                   tied:inInfo.tied, $
                   expr:inInfo.expr, $
                   apply2AllGrps:0 }


nparms = parminfo.nparms
ncurves = n_elements(parminfo.names)
totparms = total(nparms)

dispNames = strarr(ncurves)
for i = 0,ncurves-1 do begin
  pos = strpos((parminfo.names)[i],'_')
  dispNames[i] = strmid(strupcase((parminfo.names)[i]),pos+1)
endfor

button_labels = dispNames
base = cw_tabbase(tlb,button_labels,/droplist,bases = coltab,/frame,/col)
tab = lonarr(ncurves)
for i = 0,ncurves-1 do begin
  tab[i] = (max(parminfo.nparms) lt 11)? widget_base(coltab[i],/row) : $
           widget_base(coltab[i],/row,X_SCROLL_SIZE=820,Y_SCROLL_SIZE=600)
           ; RTA - make this modification to handle cases where there are two many
           ; fit paramters. If more than 10 for any function in the model then
           ; introduce scrollbars in the dialog.
endfor

;bases = lonarr(ncurves)
;subBases = lonarr(ncurves)
;for i = 0,ncurves-1 do begin
;  bases[i] = widget_base(tab[i],/row)
;endfor

ctrlBase0 = widget_base(tlb,/col,/frame)
ctrlBase0a = widget_base(ctrlBase0,/row,/align_center)
ctrlBase0b = widget_base(ctrlBase0,/row,/align_center)
ctrlBase = widget_base(tlb,/row,/frame)
if modal eq 0 then begin
  label0 = 'to calculate Lower limits as -'
  label1 = '% and Upper Limits as +'
  label2 = '% of current Values'
  pctages = ['30','50','70','100','150','200']
  void = widget_button(ctrlBase0a,value = 'Set All Upper/Lower limits',uname = 'SETLIMITS')
  void = widget_button(ctrlBase0a,value = 'Unset All Upper/Lower limits',uname = 'UNSETLIMITS')
  void = widget_button(ctrlBase0b,value = 'Click Here',uname = 'CALCLIMITS')
  void = widget_label(ctrlBase0b,value = label0)
  void = widget_combobox(ctrlBase0b,value=pctages,/editable,uname='LOPCTAGE')
  widget_control, void, set_combobox_select=1
  void = widget_label(ctrlBase0b,value = label1)
  void = widget_combobox(ctrlBase0b,value=pctages,/editable,uname='HIPCTAGE')
  widget_control, void, set_combobox_select=1
  void = widget_label(ctrlBase0b,value = label2)
  
  void = widget_button(ctrlBase,value = 'Apply',event_pro = 'parmInfoAccept',uvalue=0)
  void = widget_button(ctrlBase,value = 'Apply to All Groups',event_pro = 'parmInfoAccept',uvalue=1)
  void = widget_button(ctrlBase,value = 'Dismiss',event_pro = 'parmInfoQuit')
endif else begin
  void = widget_button(ctrlBase,value = 'Apply and Dismiss', $
         event_pro = 'parmInfoQuitModal')
endelse


;--------------------------------------------------------------
; define variables to accumulate widget IDs for all the 7 fit
; attributes (value, fix, low, lowValue, high, highValue, tie)
; These variables are arrays of length <nparams> - the total
; number of parameters in the model across all curves/functions
valIds    = lonarr(totparms)
fixIds    = lonarr(totparms)
lowIds    = lonarr(totparms)
lowValIds = lonarr(totparms)
highIds   = lonarr(totparms)
hiValIds  = lonarr(totparms)
tieIds    = lonarr(totparms)

count = 0
xsizesTextField = []
for k = 0, ncurves-1 do begin
  ; loop through the curves/functions of the Model
  
  ; Create a column header for each of the 7 fit attributes
  ; (value, fix, low, lowValue, high, highValue, tie)
  curveBase = Widget_base(tab[k],/col)
  headerBase = widget_base(curveBase,/row,/base_align_center)
  
  slen= max(strlen(parminfo.parmnames))       ; find the length of the longest parameter name
  lab_fmt = '(A'+strtrim(string(slen),2)+')'
  for i = 0, nparms[k]-1 do begin
    lab_buf = string(' ',format=lab_fmt)      ; create an empty buffer of same length as longest parameter name
    strput,lab_buf,parminfo.parmnames[count]  ; copy the current parameer name to the buffer without changing the buffer length
    ; then loop through the parameters in the current curve/function
    ; and create a row base for each parameter 
    ; and for each parameter define a row of the 7 fit attributes
    ; (value, fix, low, lowValue, high, highValue, tie) 
    parBase = widget_base(curveBase,/row,/base_align_right)
    void             = widget_label(parBase,/align_left,value=lab_buf)
    ;valIds[count]    = Cw_field(parBase,value=float(parminfo.parms[count]),title=parminfo.parmnames[count],xsize=xsize)
    valIds[count]    = Cw_field(parBase,value=Float(parminfo.parms[count]),title='',xsize=xsize)
    fixIds[count]    = cw_bgroup(parBase,'',/nonexclusive,set_value = byte(parminfo.fixed[count]))
    lowIds[count]    = Cw_bgroup(parBase,'',/nonexclusive,set_value = Byte(parminfo.low[count]))
    void             = Widget_label(parBase,/align_left,value=lab_buf)
    ;lowvalIds[count] = Cw_field(parBase,value=parminfo.lovalues[count],title=parminfo.parmnames[count],xsize=xsize)
    lowvalIds[count] = Cw_field(parBase,value=parminfo.lovalues[count],title='',xsize=xsize)
    highIds[count]   = Cw_bgroup(parBase,'',/nonexclusive,set_value = Byte(parminfo.high[count]))
    void             = Widget_label(parBase,/align_left,value=lab_buf)
    ;hivalIds[count]  = Cw_field(parBase,value=parminfo.hivalues[count],title=parminfo.parmnames[count],xsize=xsize)
    hivalIds[count]  = Cw_field(parBase,value=parminfo.hivalues[count],title='',xsize=xsize)
    tieIds[count]    = Cw_bgroup(parBase,'',/nonexclusive,set_value = Byte(parminfo.tied[count]))
    geom = widget_info(valIds[count],/geometry)
    xsizesTextField = [xsizesTextField,geom.scr_xsize]
    count++
    if (i eq 0) then labgeom = widget_info(void,/geometry)
  endfor
  pxsize = max(xsizesTextField)
  for i = 0, nparms[k]-1 do begin
    ; loop over parameters but this time, resize the widgets created in the previous loop
    j = count - nparms[k] + i
    widget_control,valIds[j],    scr_xsize=pxsize
    Widget_control,fixIds[j],    xsize=pxsize/2
    Widget_control,lowIds[j],    xsize=pxsize/2
    Widget_control,lowvalIds[j], scr_xsize=pxsize
    Widget_control,highIds[j],   xsize=pxsize/2
    Widget_control,hivalIds[j],  scr_xsize=pxsize
    Widget_control,tieIds[j],    xsize=pxsize/2
  endfor
  
  voidLabel = Widget_label(headerBase,value = ' ' ,xsize=labgeom.scr_xsize)
  voidLabel = Widget_label(headerBase,value = 'Values',xsize=pxsize) ; ,xsize=geom1.xsize
  voidLabel = Widget_label(headerBase,value = 'Fixed',xsize=pxsize/2)
  voidLabel = Widget_label(headerBase,value = 'Set Low',xsize=pxsize/2)
  voidLabel = Widget_label(headerBase,value = ' ',xsize=labgeom.scr_xsize)
  voidLabel = Widget_label(headerBase,value = 'Lower Limit',xsize=pxsize)
  voidLabel = Widget_label(headerBase,value = 'Set High',xsize=0.6*pxsize)
  voidLabel = Widget_label(headerBase,value = ' ',xsize=labgeom.scr_xsize)
  voidLabel = Widget_label(headerBase,value = 'Upper Limit',xsize=pxsize)
  voidLabel = Widget_label(headerBase,value = 'Tie',xsize=pxsize/2)
endfor

;--------------------------------------------------------------

;valbase = lonarr(ncurves)
;valIds = lonarr(totparms)
;count = 0
;for k = 0,ncurves-1 do begin
;  valbase[k] = widget_base(bases[k],/col,/base_align_center)
;  if (parminfo.expr)[k] ne '' then begin
;    void = widget_label(coltab[k],value = (parmInfo.expr)[k])
;  endif
;  void = widget_label(valbase[k],value = 'Values')
;  for j = 0,nparms[k]-1 do begin
;      valIds[count] = cw_field(valbase[k],value = parminfo.parms[count],$
;                        title = parminfo.parmnames[count],xsize = xsize)
;      count = count + 1
;  endfor
;endfor
;
;
;fixbase = lonarr(ncurves)
;fixIds = lonarr(totparms)
;count = 0
;for k = 0,ncurves-1 do begin
;  fixbase[k] = Widget_base(bases[k],/col,/base_align_center)
;  if (parminfo.expr)[k] ne '' then begin
;    void = Widget_label(coltab[k],value = (parmInfo.expr)[k])
;  endif
;  void = Widget_label(fixbase[k],value = 'Fixed')
;  for j = 0,nparms[k]-1 do begin
;    fixIds[count] = cw_bgroup(fixbase[k],'',/col,/nonexclusive,set_value = byte(parminfo.fixed[count]))
;    count = count + 1
;  endfor
;endfor
;
;
;lowbase = lonarr(ncurves)
;lowIds = lonarr(totparms)
;count = 0
;for k = 0,ncurves-1 do begin
;  lowbase[k] = Widget_base(bases[k],/col,/base_align_center)
;  if (parminfo.expr)[k] ne '' then begin
;    void = Widget_label(coltab[k],value = (parmInfo.expr)[k])
;  endif
;  void = Widget_label(lowbase[k],value = 'Set Low')
;  for j = 0,nparms[k]-1 do begin
;    lowIds[count] = Cw_bgroup(lowbase[k],'',/col,/nonexclusive,set_value = Byte(parminfo.low[count]))
;    count = count + 1
;  endfor
;endfor
;
;lovalbase = lonarr(ncurves)
;lowvalIds = lonarr(totparms)
;count = 0
;for i = 0,ncurves-1 do begin
;
;  lovalbase[i] = widget_base(bases[i],/col,/base_align_center)
;  void = widget_label(lovalbase[i],value = 'Lower Limit')
;  for j = 0,nparms[i]-1 do begin
;    lowvalIds[count] = cw_field(lovalbase[i],value = parminfo.lovalues[count],$
;                       title = parminfo.parmnames[count],xsize = xsize)
;    count = count + 1
;  endfor
;endfor
;
;highbase = lonarr(ncurves)
;highIds = lonarr(totparms)
;count = 0
;for k = 0,ncurves-1 do begin
;  highbase[k] = Widget_base(bases[k],/col,/base_align_center)
;  if (parminfo.expr)[k] ne '' then begin
;    void = Widget_label(coltab[k],value = (parmInfo.expr)[k])
;  endif
;  void = Widget_label(highbase[k],value = 'Set High')
;  for j = 0,nparms[k]-1 do begin
;    highIds[count] = Cw_bgroup(highbase[k],'',/col,/nonexclusive,set_value = Byte(parminfo.high[count]))
;    count = count + 1
;  endfor
;endfor
;
;hivalbase = lonarr(ncurves)
;hivalIds = lonarr(totparms)
;count = 0
;for i = 0,ncurves-1 do begin
;  hivalbase[i] = widget_base(bases[i],/col,/base_align_center)
;  void = widget_label(hivalbase[i],value = 'Upper Limit')
;  for j = 0,nparms[i]-1 do begin
;    hivalIds[count] = cw_field(hivalbase[i],value = parminfo.hivalues[count],$
;                      title = parminfo.parmnames[count],xsize = xsize)
;    count = count + 1
;  endfor
;endfor
;
;tiedbase = lonarr(ncurves)
;tieIds = lonarr(totparms)
;count = 0
;for k = 0,ncurves-1 do begin
;  tiedbase[k] = Widget_base(bases[k],/col,/base_align_center)
;  if (parminfo.expr)[k] ne '' then begin
;    void = Widget_label(coltab[k],value = (parmInfo.expr)[k])
;  endif
;  void = Widget_label(tiedbase[k],value = 'Tie')
;  for j = 0,nparms[k]-1 do begin
;    tieIds[count] = Cw_bgroup(tiedbase[k],'',/col,/nonexclusive,set_value = Byte(parminfo.tied[count]))
;    count = count + 1
;  endfor
;endfor


;-----------------------------------




parmInfoOut = (-1L)

widget_control,tlb,/realize
state = {parminfoPtr:ptr_new(parmInfo,/no_copy),$
         lowvalIds:lowvalIds, $
         hivalIds:hivalIds, $
         lowIds:lowIds, $
         highIds:highIds, $
         fixIds:fixIds, $
         valIds:valIds, $
         tieIds:tieIds, $
         notifyIds:notifyIds}
pState = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pState

if modal eq 0 then begin
  xmanager,'enterparminfo',tlb,/no_block,cleanup = 'parmInfoCleanup'
endif else begin
  xmanager,'enterparminfo',tlb
  parmInfoOut = *(*pState).parmInfoPtr
  ptr_free,(*pState).parmInfoPtr
  ptr_free,pState
endelse

return
end

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;pro Enterparminfo,inInfo, $
;  group_leader = group_leader, $
;  notifyIds = notifyIds, $
;  modal = modal, $
;  parmInfoOut = parmInfoOut
;  if N_elements(modal) eq 0 then modal = 0
;  if N_elements(notifyIds) eq 0 then notifyIds = (-1L)
;  ; Widget definition module
;  if N_elements(group_leader) eq 0 then begin
;    tlb = Widget_base(/col,title = 'PAN Parameter Information', $
;      /tlb_frame_attr,/base_align_center)
;  endif else begin
;    tlb = Widget_base(group_leader = group_leader, /col, $
;      title = 'PAN Parameter Information',/tlb_frame_attr, $
;      /base_align_center,modal = modal)
;  endelse
;
;  xsize = 10
;
;  if N_params() eq 0 then begin
;    ncurves = 2
;    nparms = [3,2]
;    totparms = Total(nparms)
;    names = ['pan_gaussian','pan_background']
;    expr = Replicate('',totparms)
;    tied = Replicate(0d,totparms)
;    step = Replicate(0d,totparms)
;    fixed = Replicate(0,totparms)
;    lovalues = Replicate(0d,totparms)
;    low = Replicate(0,totparms)
;    high = Replicate(0,totparms)
;    hivalues = Replicate(1d,totparms)
;    parms = [1.0,0.0,1.0,0.0,0.0]
;    parmnames = ['area','center','width','offset','slope']
;    inInfo =   {names:names, nparms:nparms,step:step, fixed:fixed, $
;      lovalues:lovalues, hivalues:hivalues, high:high, $
;      low:low, parms:parms, parmnames:parmnames, $
;      tied:tied,expr:expr}
;  endif
;
;  parminfo = {       names:inInfo.names, $
;    nparms:inInfo.nparms,$
;    step:inInfo.step, $
;    fixed:inInfo.fixed, $
;    lovalues:inInfo.lovalues, $
;    hivalues:inInfo.hivalues, $
;    high:inInfo.high, $
;    low:inInfo.low, $
;    parms:inInfo.parms, $
;    parmnames:inInfo.parmnames, $
;    tied:inInfo.tied, $
;    expr:inInfo.expr, $
;    apply2AllGrps:0 }
;
;
;  nparms = parminfo.nparms
;  ncurves = N_elements(parminfo.names)
;  totparms = Total(nparms)
;
;  dispNames = Strarr(ncurves)
;  for i = 0,ncurves-1 do begin
;    pos = Strpos((parminfo.names)[i],'_')
;    dispNames[i] = Strmid(Strupcase((parminfo.names)[i]),pos+1)
;  endfor
;
;  button_labels = dispNames
;  base = Cw_tabbase(tlb,button_labels,/droplist,bases = coltab,/frame,/col)
;  tab = Lonarr(ncurves)
;  for i = 0,ncurves-1 do begin
;    tab[i] = (Max(parminfo.nparms) lt 11)? Widget_base(coltab[i],/row) : $
;      Widget_base(coltab[i],/row,X_SCROLL_SIZE=750,Y_SCROLL_SIZE=600)
;    ; RTA - make this modification to handle cases where there are two many
;    ; fit paramters. If more than 10 for any function in the model then
;    ; introduce scrollbars in the dialog.
;  endfor
;
;  bases = Lonarr(ncurves)
;  subBases = Lonarr(ncurves)
;  for i = 0,ncurves-1 do begin
;    bases[i] = Widget_base(tab[i],/row)
;  endfor
;
;  ctrlBase0 = Widget_base(tlb,/col,/frame)
;  ctrlBase0a = Widget_base(ctrlBase0,/row,/align_center)
;  ctrlBase0b = Widget_base(ctrlBase0,/row,/align_center)
;  ctrlBase = Widget_base(tlb,/row,/frame)
;  if modal eq 0 then begin
;    label0 = 'to calculate Lower limits as -'
;    label1 = '% and Upper Limits as +'
;    label2 = '% of current Values'
;    pctages = ['30','50','70','100','150','200']
;    void = Widget_button(ctrlBase0a,value = 'Set All Upper/Lower limits',uname = 'SETLIMITS')
;    void = Widget_button(ctrlBase0a,value = 'Unset All Upper/Lower limits',uname = 'UNSETLIMITS')
;    void = Widget_button(ctrlBase0b,value = 'Click Here',uname = 'CALCLIMITS')
;    void = Widget_label(ctrlBase0b,value = label0)
;    void = Widget_combobox(ctrlBase0b,value=pctages,/editable,uname='LOPCTAGE')
;    Widget_control, void, set_combobox_select=1
;    void = Widget_label(ctrlBase0b,value = label1)
;    void = Widget_combobox(ctrlBase0b,value=pctages,/editable,uname='HIPCTAGE')
;    Widget_control, void, set_combobox_select=1
;    void = Widget_label(ctrlBase0b,value = label2)
;
;    void = Widget_button(ctrlBase,value = 'Apply',event_pro = 'parmInfoAccept',uvalue=0)
;    void = Widget_button(ctrlBase,value = 'Apply to All Groups',event_pro = 'parmInfoAccept',uvalue=1)
;    void = Widget_button(ctrlBase,value = 'Dismiss',event_pro = 'parmInfoQuit')
;  endif else begin
;    void = Widget_button(ctrlBase,value = 'Apply and Dismiss', $
;      event_pro = 'parmInfoQuitModal')
;  endelse
;  valbase = Lonarr(ncurves)
;  valIds = Lonarr(totparms)
;  count = 0
;  for k = 0,ncurves-1 do begin
;    valbase[k] = Widget_base(bases[k],/col,/base_align_right)
;    if (parminfo.expr)[k] ne '' then begin
;      void = Widget_label(coltab[k],value = (parmInfo.expr)[k])
;    endif
;    void = Widget_label(valbase[k],value = 'Values')
;    for j = 0,nparms[k]-1 do begin
;      valIds[count] = Cw_field(valbase[k],value = parminfo.parms[count],$
;        title = parminfo.parmnames[count],xsize = xsize)
;      count = count + 1
;    endfor
;  endfor
;
;  fixbase = Lonarr(ncurves)
;  start = 0
;  finish = parminfo.nparms[0] - 1
;  for k = 1,ncurves-1 do begin
;    start = [start,Total(parminfo.nparms[0:k-1])]
;    finish = [finish,Total(parminfo.nparms[0:k])-1]
;  endfor
;
;  count = 0
;  fixIds = Lonarr(ncurves)
;  for k = 0,ncurves-1 do begin
;    ;;;;;;;;;
;    fixbase[k] = Widget_base(bases[k],/col)
;    ;;;;;;;;;
;    void = Widget_label(fixbase[k],value = 'Fixed')
;    fixIds[k] = Cw_bgroup(fixbase[k],parminfo.parmnames[start[k]:finish[k]],$
;      /col,/nonexclusive, $
;      set_value = Byte(parminfo.fixed[start[k]:finish[k]]))
;  endfor
;
;  lowbase = Lonarr(ncurves)
;  lowIds = Lonarr(ncurves)
;  for k = 0,ncurves-1 do begin
;    lowbase[k] = Widget_base(bases[k],/col)
;
;    void = Widget_label(lowbase[k],value = 'Set Low')
;    lowIds[k] = Cw_bgroup(lowbase[k],parminfo.parmnames[start[k]:finish[k]], $
;      /col,/nonexclusive, $
;      set_value = Byte(parminfo.low[start[k]:finish[k]]))
;  endfor
;
;  lovalbase = Lonarr(ncurves)
;  lowvalIds = Lonarr(totparms)
;  count = 0
;  for i = 0,ncurves-1 do begin
;
;    lovalbase[i] = Widget_base(bases[i],/col,/base_align_right)
;    void = Widget_label(lovalbase[i],value = 'Lower Limit')
;    for j = 0,nparms[i]-1 do begin
;      lowvalIds[count] = Cw_field(lovalbase[i],value = parminfo.lovalues[count],$
;        title = parminfo.parmnames[count],xsize = xsize)
;      count = count + 1
;    endfor
;  endfor
;
;  highbase = Lonarr(ncurves)
;  highIds = Lonarr(ncurves)
;
;  for i = 0,ncurves-1 do begin
;    highbase[i] = Widget_base(bases[i],/col)
;    void = Widget_label(highbase[i],value = 'Set High')
;    highIds[i] = Cw_bgroup(highbase[i],parminfo.parmnames[start[i]:finish[i]], $
;      /col,/nonexclusive, $
;      set_value = Byte(parminfo.high[start[i]:finish[i]]))
;  endfor
;
;  hivalbase = Lonarr(ncurves)
;  hivalIds = Lonarr(totparms)
;  count = 0
;  for i = 0,ncurves-1 do begin
;    hivalbase[i] = Widget_base(bases[i],/col,/base_align_right)
;    void = Widget_label(hivalbase[i],value = 'Upper Limit')
;    for j = 0,nparms[i]-1 do begin
;      hivalIds[count] = Cw_field(hivalbase[i],value = parminfo.hivalues[count],$
;        title = parminfo.parmnames[count],xsize = xsize)
;      count = count + 1
;    endfor
;  endfor
;
;  tiedbase = Lonarr(ncurves)
;  tieIds = Lonarr(ncurves)
;
;  for i = 0,ncurves-1 do begin
;    tiedbase[i] = Widget_base(bases[i],/col)
;    void = Widget_label(tiedbase[i],value = 'Tie')
;    tieIds[i] = Cw_bgroup(tiedbase[i],parminfo.parmnames[start[i]:finish[i]], $
;      /col,/nonexclusive, $
;      set_value = Byte(parminfo.tied[start[i]:finish[i]]))
;  endfor
;
;
;  parmInfoOut = (-1L)
;
;  Widget_control,tlb,/realize
;  state = {parminfoPtr:Ptr_new(parmInfo,/no_copy),$
;    lowvalIds:lowvalIds, $
;    hivalIds:hivalIds, $
;    lowIds:lowIds, $
;    highIds:highIds, $
;    fixIds:fixIds, $
;    valIds:valIds, $
;    tieIds:tieIds, $
;    notifyIds:notifyIds}
;  pState = Ptr_new(state,/no_copy)
;  Widget_control,tlb,set_uvalue = pState
;
;  if modal eq 0 then begin
;    Xmanager,'enterparminfo',tlb,/no_block,cleanup = 'parmInfoCleanup'
;  endif else begin
;    Xmanager,'enterparminfo',tlb
;    parmInfoOut = *(*pState).parmInfoPtr
;    Ptr_free,(*pState).parmInfoPtr
;    Ptr_free,pState
;  endelse
;
;  Return
;end