; $Id$
;###############################################################################
;
; NAME:
;  OPANREADFITPARMSANDCONSTRAINTS
;
; PURPOSE:
;  Reads in parameter file with constraints saved in PAN.
;
; CATEGORY:
;  DAVE, Data Analysis, PAN, curve fitting
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
pro opanReadFitParmsAndConstraints,filename,fitArray = fitArray, twoDimFlag=twoDimFlag,groups=groups,groupValues=groupValues, $
   dataStr=dataStr, resStr=resStr, macroFlag=macroFlag, macroHash=macroHash, ignoreDataSection=ignoreDataSection, $
   fitVersionNos=fitVersionNos, $
   error = error,ermsg = ermsg
; This routine reads in a parameter file that was generated in
; OPAN.PRO.
;
error = 0
if n_params() eq 0 then begin
  fitArray = (-1)
  error = 1
  ermsg = 'No arguments supplied with function call'
  return
endif

catch,theError
if theError ne 0 then begin
  catch,/cancel
  error = 1
  ermsg = !error_state.MSG
  fitArray = (-1)
  return
endif

openr,lun,filename,/get_lun

; modification due to change in .fit file format, April 2024
buf = strarr(3)
readf,lun,buf
if (buf[0].Matches('DAVE Peak Analysis',/fold)) then begin
  if (buf[1].Matches('Version 2',/fold)) then begin
    ; process version 2 format
    fitVersionNos = fix((strsplit(buf[1],' ',/extract))[1])
    toks = strsplit(buf[2],':',/extract,count=ntoks)
    index = where(toks.matches('TwoDimFlag',/fold),found)
    if (found) then twoDimFlag = fix((strsplit(toks[index],'=',/extract))[1])
    index = Where(toks.Matches('nGroups',/fold),found)
    if (found) then nGroups = Fix((Strsplit(toks[index],'=',/extract))[1])
    index = Where(toks.Matches('groupValues',/fold),found)
    if (found) then groupValues = float(strtrim(strsplit((strsplit(toks[index],'=',/extract))[1],',',/extract),2))
    ;twoDimFlag = fix((strsplit(toks[0],'=',/extract))[1])
    ;nGoups = fix((strsplit(toks[1],'=',/extract))[1])
    ;groupValues = float(strtrim(strsplit((strsplit(toks[2],'=',/extract))[1],',',/extract),2))
  endif
endif else begin
  ; rewind to beginning of file as this is the original format file
  fitVersionNos = 1
  point_lun, lun, 0
  nGroups = []
  groupValues = []
endelse


s = ''
;readf,lun,s
nFitGrps = 0
nlines = 0
macoFlag = 0
repeat begin
  nlines = 0
  ;while strpos(s,'Chi-squared:') ne 0 do begin
  while (~s.Matches('Chi-squared:',/fold)) do begin
    readf,lun,s

    if (s.Matches('Data Section:',/fold)) then goto, DataSection

    if (s.Matches('MacroFunctionDefinition:',/fold)) then begin
      ;'MacroFunctionDefinition:  nMacros=1 nLines=10'
      macroFlag = 1
      toks = strsplit(s,' ',/extract,count=ntoks)
      nMacro = fix((strsplit(toks[1],'=',/extract))[1])
      nMacroLines = fix((strsplit(toks[2],'=',/extract))[1])
      buffer = strarr(nMacroLines)
      readf,lun,buffer
      macroHash = hash()
      mline = 0
      for i=0,nMacro-1 do begin
        s1 = buffer[mline]
        toks = strsplit(s1,':',/extract,count=ntoks)
        key = long((strsplit(toks[1],' ',/extract))[0])
        len = fix((Strsplit(toks[1],' ',/extract))[1])
        macroHash[key] = buffer[mline+1:mline+len]
        mline = mline+len+1
      endfor
      if (Eof(lun)) then begin
        ; this will occur if there is no data stored in the fit file!
        Free_lun,lun, /force
        goto, FitResultsSection
      endif
    endif else begin
      nlines = nlines + 1
      if (nlines eq 1) and (nFitGrps eq 0) then begin
        strout = s
      endif else begin
        strout = [strout,s]
      endelse      
    endelse

  endwhile

  if nFitGrps eq 0 then grpArray = nlines else grpArray = [grpArray,nlines]
  nFitGrps = nFitGrps + 1
  readf,lun,s
endrep until eof(lun)
free_lun,lun, /force
goto, FitResultsSection

;; RTA
;; Add section to read data pls resolution from the file, if present
;; Should only get to this label if there is a data section stored in the file
DataSection:
if (keyword_set(ignoreDataSection)) then goto, FitResultsSection
toks = strsplit(s,' ',/extract,count=ntoks)
nGrps = strsplit(toks[2],'=',/extract) & nGrps = fix(nGrps[1])
nChan = strsplit(toks[3],'=',/extract) & nChan = fix(nChan[1])
nMask = strsplit(toks[4],'=',/extract) & nMask = fix(nMask[1])
resPresent = strsplit(toks[5],'=',/extract) & resPresent = fix(resPresent[1])
xtitle = '' & ytitle='' & xunits = '' & yunits='' & title=''
readf,lun,xtitle
readf,lun,ytitle
readf,lun,xunits
readf,lun,yunits
readf,lun,title
readf,lun,s
history = strsplit(s,';;',/extract)
xVals = fltarr(nChan)
yVals = fltarr(nGrps)
readf,lun,s
readf,lun,xVals
readf,lun,s
readf,lun,yVals
dat = (nGrps eq 1)? fltarr(nChan) : fltarr(nChan,nGrps)
derr = dat
mask = bytarr(nMask)
readf,lun,s
readf,lun,dat
readf,lun,s
readf,lun,derr
readf,lun,s
readf,lun,mask
if (nGrps gt 1) then begin
  xVals = xVals # (fltarr(ngrps)+1)
  yVals = (fltarr(nchan)+1) # yVals
endif
mask = reform(bytes2bits(mask,nChan,nGrps))
dataStr = {x:xVals,y:yVals,data:dat,derr:derr,mask:mask, $
  xtitle:xtitle,ytitle:ytitle,xunits:xunits,yunits:yunits,title:title,history:history}
if (resPresent) then begin
  readf,lun,s
  toks = strsplit(s,' ',/extract,count=ntoks)
  nGrps = strsplit(toks[2],'=',/extract) & nGrps = fix(nGrps[1])
  nChan = strsplit(toks[3],'=',/extract) & nChan = fix(nChan[1])
  nMask = strsplit(toks[4],'=',/extract) & nMask = fix(nMask[1])
  slimit = strsplit(toks[5],'=',/extract) & slimit = slimit[1]
  rlimit = strsplit(slimit,',',/extract) & rlimit = float(rlimit)
  rxVals = fltarr(nChan)
  ryVals = fltarr(nGrps)
  readf,lun,s
  readf,lun,rxVals
  readf,lun,s
  readf,lun,ryVals
  rdat = (nGrps eq 1)? fltarr(nChan) : fltarr(nChan,nGrps)
  mask = bytarr(nMask)
  readf,lun,s
  readf,lun,rdat
  readf,lun,s
  readf,lun,mask
  mask = reform(bytes2bits(mask,nChan,nGrps))
;  if (nGrps gt 1) then begin
;    rxVals = rxVals # (fltarr(ngrps)+1)
;    ryVals = (fltarr(nchan)+1) # ryVals
;  endif
  resStr = {x:rxVals,y:ryVals,data:rdat,rlimit:rlimit,mask:mask,xDat_equals_xRes:0}
endif
free_lun,lun, /force

FitResultsSection:
; Here GRPARRAY is correct!
; print,grpArray
; Ok we now have all of the fit information in the form of strings
; Sort it all out

; Add some testing code here
;help,strout
;for j = 0,nFitGrps-1 do begin
;  group = j
;  case group of
;  0:     begin
;            start = 0
;            finish = start+grpArray[0]-1
;            next_start = finish+2
;         end
;  else:  begin
;            start = next_start
;            finish = start+grpArray[group]-2
;            next_start = finish+2
;         end
;  endcase
;endfor
;
;return
; End testing code

for j = 0,nFitGrps-1 do begin

  fitStr = {namePtr:ptr_new(/allocate_heap),    $
    parmNamesPtr:ptr_new(/allocate_heap),$        ;LRK 01/26/09
    parmPtr:ptr_new(/allocate_heap),    $
    parmErrPtr:ptr_new(/allocate_heap), $
    fixPtr:ptr_new(/allocate_heap),   $
    lowcheckPtr:ptr_new(/allocate_heap),   $
    highcheckPtr:ptr_new(/allocate_heap),  $
    lowvaluePtr:ptr_new(/allocate_heap),   $
    highvaluePtr:ptr_new(/allocate_heap),  $
    tiePtr:ptr_new(/allocate_heap),   $
    nparmPtr:ptr_new(/allocate_heap),   $
    chisqPtr:ptr_new(/allocate_heap),   $
    exprPtr:ptr_new(/allocate_heap) }
    
  if j eq 0 then fitArray = fitStr else fitArray = [fitArray,fitStr]
  parmFlag = 0
  group = j
  
  case group of
    0:     begin
      start = 0
      finish = start+grpArray[0]-1
      next_start = finish+2
    end
    else:  begin
      start = next_start
      finish = start+grpArray[group]-2
      next_start = finish+2
    end
  endcase
  
  ;   print,start,finish
  ;  start = group*grpArray[group]
  ;  finish = (group+1)*grpArray[group]-1
  
  ;  print,start,finish
  chi_string = strout[finish]
  ;  print,chi_string
  
  chi_col_pos = strpos(chi_string,':')
  chi_value = float(strmid(chi_string,chi_col_pos+1))
  *fitStr.chisqPtr = chi_value
  thisStrout = strout[start:finish]
  if j eq 0 then test_string = thisStrout[1] else test_string = thisStrout[0]
  toks = strsplit(test_string,':',/extract,count=ntoks)
  grpId = fix(strtrim(string(toks[1]),2))
  ;colPos = strpos(test_string,':')
  ;grpId = fix(strmid(test_string,colPos+1))
;  if (j eq 0) then begin
;    ; only required when parsing first group
;    ; the default 2D Flag is 0 if the info was not present in .fit file. Fit files created prior to Apr 2024 will not have it
;    twoDimFlag = (ntoks eq 3)? fix(strtrim(string(toks[2]),2)) : 0
;  endif
  
  ; Determine how many curves there are...
  cI = where(thisStrout eq '-----------------',ncurves)
  fitFileStrings = thisStrout
  nameIndex = cI+1
  names = strarr(ncurves)
  nparms = intarr(ncurves)
  exprArray = strarr(ncurves)
  ; What are the names of the individual curves?  What are the parameters
  ; in each of the curves?
  for inames = 0,ncurves-1 do begin
  
    ;nPos = strpos(thisStrout[nameIndex[inames]],':')
    ;names[inames] = strtrim('PAN_'+strtrim(strmid(thisStrout[nameIndex[inames]],nPos+1),2),2)
    toks = strsplit(thisStrout[nameIndex[inames]],':',count=ntoks,/extract)
    names[inames] = 'PAN_'+strtrim(toks[1],2)
    ;if (ntoks eq 3) then begin
    ;  macroID[inames] = strtrim(toks[2],2)
    ;endif
    if strupcase(names[inames]) eq 'PAN_USERFUNCTION' then begin
      exprArray[inames] = thisStrout[nameIndex[inames]+1]
      n1 = nameIndex[inames]+2
    endif else begin
      n1 = nameIndex[inames]+1     ; where the parameters begin
    endelse
    if inames ne ncurves-1 then begin
      n2 = nameIndex[inames+1]-2  ; where the parameters end
    endif else begin
      n2 = (finish-start) - 2   ; where the parameters end
    endelse
    nparms[inames] = n2-n1+1
    for jp = 0,nparms[inames]-1 do begin
      len = strlen(thisStrout[n1+jp])
      col1Pos = strpos(thisStrout[n1+jp],': ')
      col2Pos = col1Pos + strpos(thisStrout[n1+jp],': ',col1Pos+1)
      
      ;LRK 01/26/09
      curParmSegs = strsplit(thisStrout[n1+jp],':',/extract)
      curParmName = curParmSegs[1]
      
      addPos = strpos(thisStrout[n1+jp],'+/-')
      curParms = float(strmid(thisStrout[n1+jp],col2Pos-1,addPos-col2Pos))
      
      comma1pos = strpos(thisStrout[n1+jp],',')
      sigmaParms = float(strmid(thisStrout[n1+jp],addPos+4,-(addPos+4)+comma1pos))
      
      comma2pos = strpos(thisStrout[n1+jp],',',comma1pos+1)
      curFixed = fix(strmid(thisStrout[n1+jp],comma1pos+1,comma2pos-1))
      comma3pos = strpos(thisStrout[n1+jp],',',comma2pos+1)
      curLowCheck = fix(strmid(thisStrout[n1+jp],comma2pos+1,comma3pos-1))
      comma4pos = strpos(thisStrout[n1+jp],',',comma3pos+1)
      curLowValue = float(strmid(thisStrout[n1+jp],comma3pos+1,comma4pos-1))
      comma5pos = strpos(thisStrout[n1+jp],',',comma4pos+1)
      curHighCheck = fix(strmid(thisStrout[n1+jp],comma4pos+1,comma5pos-1))
      comma6pos = strpos(thisStrout[n1+jp],',',comma5pos+1)
      curHighValue = float(strmid(thisStrout[n1+jp],comma5pos+1,comma6pos-1))
      curTie = fix(strmid(thisStrout[n1+jp],comma6pos+1))
      if (parmFlag eq 0) then begin
        outSigma = sigmaParms
        outParmNames = curParmName        ;LRK 01/26/09
        outParms = curParms
        outFixed = curFixed
        outLowCheck = curLowCheck
        outLowValue = curLowValue
        outHighCheck = curHighCheck
        outHighValue = curHighValue
        outTie = curTie
        parmFlag = 1
      endif else begin
        outSigma = [outSigma,sigmaParms]
        outParmNames = [outParmNames,curParmName]        ;LRK 01/26/09
        outParms = [outParms,curParms]
        outFixed = [outFixed,curFixed]
        outLowCheck = [outLowCheck,curLowCheck]
        outLowValue = [outLowValue,curLowValue]
        outHighCheck = [outHighCheck,curHighCheck]
        outHighValue = [outHighValue,curHighValue]
        outTie = [outTie,curTie]
      endelse
    endfor;jp
  endfor;inames
  
  *(fitArray[j]).namePtr = names
  *(fitArray[j]).parmNamesPtr = outParmNames        ;LRK 01/26/09
  *(fitArray[j]).parmPtr = outParms
  *(fitArray[j]).parmErrPtr = outSigma
  *(fitArray[j]).fixPtr = outFixed
  *(fitArray[j]).lowcheckPtr = outLowCheck
  *(fitArray[j]).highcheckPtr = outHighCheck
  *(fitArray[j]).lowvaluePtr = outLowValue
  *(fitArray[j]).highvaluePtr = outHighValue
  *(fitArray[j]).tiePtr = outTie
  ; *(fitArray[j]).chisqPtr = chi_value
  *(fitArray[j]).nparmPtr = nparms
  *(fitArray[j]).exprPtr = exprArray
  if j eq 0 then groups = grpId else groups = [groups,grpId]
endfor;j

return
end