; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; Written by J.R.D. Copley.
;************************************************************************************************
pro xsecsdb,xsecs,xslabels,database=database
;************************************************************************************************
;
; This routine generates and/or accesses the cross section database.
; If database ge 0 the database is generated.
; If database gt 0 it is saved in an IDL save file.
; If database lt 0 it is restored.
; Default is database=0.
;
compile_opt strictarr

; Basic error Handler
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'xsecsdb: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle);,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif

;
if (n_elements(database) eq 0) then database=0
do_save=database gt 0
do_restore=database lt 0
;
if (do_restore) then begin
	if (lmgr(/vm)) then begin
		filename=sourcepath()+path_sep()+"xsecsdb.dat"
	endif else begin
		filename=!DAVE_AUXILIARY_DIR+'xsecsdb.dat'
	endelse
  restore,filename=filename
	return
endif
;
t0=systime(1)
readCrossSecs,xsecs,xslabels,getfromWeb=0,flagspecial=0
;print,string(systime(1)-t0,format='(f6.1)')+' s.'
;
t0=systime(1)
readAtWeights,atwts,atlabels,getfromWeb=0
;print,string(systime(1)-t0,format='(f6.1)')+' s.'
;
t0=systime(1)
n=n_elements(xsecs.(0))
for k=0,n-1 do begin
	atsym=xsecs.atsym[k]
	j=where(atsym eq atwts.isosym,count)
	if (count ne 1) then begin
		res=dialog_message('We have a problem in xsecsdb.pro')
	endif
	if (count eq 1) then begin
		xsecs.atwt[k]=atwts.isomass[j]
		xsecs.atno[k]=atwts.atno[j]
	endif
endfor
print,string(systime(1)-t0,format='(f6.1)')+' s.'
;
if (do_save)then begin
	save,filename='xsecsdb.dat',xsecs,xslabels
	print,'Cross sections database saved.'
endif
;
end
