; $Id$
;###############################################################################
;
; NAME:
;  DHTML_SHOW_GRAPHICS
;
; PURPOSE:
;  Graphics display dialog for electronic notebook
;
; CATEGORY:
;  DAVE, electronic notebook
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dss_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'CANCEL':   $
   begin
      (*pstate).cancel = 1
      widget_control,event.top,/destroy
   end
'COMMIT_GRAPHIC': $
   begin
      (*pstate).cancel = 0
      widget_control,event.top,/destroy
   end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function dhtml_show_graphics, image,   $
                              group_leader = group_leader
reg_name = 'DHTML_SHOW_GRAPHICS'

imsize = size(image,/dimensions)
if n_elements(imsize) eq 2 then begin
   xsize = imsize[0] & ysize = imsize[1]
endif else begin  ; must be 3
   ; Find the smallest entry
   smallest_size = where(imsize eq min(imsize),complement = size_index)
   xsize = imsize[size_index[0]]
   ysize = imsize[size_index[1]]
endelse
size_sort = sort(imsize)
tlb = widget_base(group_leader = group_leader,/tlb_frame_attr, $
   title = 'E-Notebook Graphics Display',/modal,/col)
wdraw = widget_draw(tlb,xsize = xsize,ysize = ysize)
row_base = widget_base(tlb,/row,/base_align_center)
void = widget_button(row_base,value = 'Commit graphic',uname = 'COMMIT_GRAPHIC')
void = widget_button(row_base,value = 'Cancel',uname = 'CANCEL')
widget_control,tlb,/realize

widget_control,wdraw,get_value = win
wset,win
tvimage,image
state = {cancel:1}
pstate = ptr_new(state)
widget_control,tlb,set_uvalue = pstate
xmanager,reg_name,tlb,event_handler = 'dss_event'
cancel = (*pstate).cancel
ptr_free,pstate

return,cancel
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;