
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro detsInSum_sendInfo, sPtr

notify_ids = (*sPtr).notify_ids
if (~widget_info(notify_ids[0],/valid)) then return

widget_control,notify_ids[0], send_event = {detsInSum_event $
                                            ,id:notify_ids[0] $
                                            ,top:notify_ids[1] $
                                            ,handler:0L $
                                            ,update:(*sPtr).update $
                                            ,DDFlags:ptr_new((*sPtr).DDFlags) $
                                            ,SDFlags:ptr_new((*sPtr).SDFlags) $
                                            ,TDFlags:ptr_new((*sPtr).TDFlags) $
                                            ,PSDFlags:ptr_new((*sPtr).PSDFlags) $
                                            ,show_TD:(*sPtr).show_TD $
                                            ,ocontainer:(*sPtr).oContainer $
                                           }

end
;-------------------------------------------------------------------------------


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro detsInSum_event, event
;begin error handler------------------------------------------------------------
; Handler to catch misc. errors and provide a graceful exit so
; that main app does not crash.
if (n_elements(!debug) && (!debug eq 0)) then begin
    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'Error encountered'
        eMsg = 'detsInSum_event: An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif
endif
;end error handler-------------------------------------------------------------

widget_control, event.top, get_uvalue=sPtr
uname = widget_info(event.id,/uname)
widget_control, event.id, get_uvalue=uval

case uname of
    'SD': begin
        (*sPtr).SDFlags[uval] = 1 - (*sPtr).SDFlags[uval] ; toggle it
        detsInSum_sendInfo, sPtr
    end

    'TD': begin
        (*sPtr).TDFlags[uval] = 1 - (*sPtr).TDFlags[uval] ; toggle it
        detsInSum_sendInfo, sPtr
    end

    'DD': begin
        (*sPtr).DDFlags[uval] = 1 - (*sPtr).DDFlags[uval] ; toggle it
        detsInSum_sendInfo, sPtr
    end

    'SHOW_TD': begin
        (*sPtr).show_TD = 1 - (*sPtr).show_TD
        detsInSum_sendInfo, sPtr
    end

    'PSD': begin
        (*sPtr).PSDFlags[uval] = 1 - (*sPtr).PSDFlags[uval] ; toggle it
        detsInSum_sendInfo, sPtr
    end

    'DISMISS': widget_control, event.top, /destroy

    else:
endcase

end
;-------------------------------------------------------------------------------


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro detsInSum_cleanup, wTLB

widget_control, wTLB, get_uvalue=sPtr

notify_ids = (*sPtr).notify_ids
if (widget_info(notify_ids[0],/valid)) then begin
   widget_control,notify_ids[0], send_event = {detsInSum_event $
                                            ,id:notify_ids[0] $
                                            ,top:notify_ids[1] $
                                            ,handler:0L $
                                            ,update:(*sPtr).update $
                                            ,DDFlags:ptr_new((*sPtr).DDFlags) $
                                            ,SDFlags:ptr_new((*sPtr).SDFlags) $
                                            ,TDFlags:ptr_new((*sPtr).TDFlags) $
                                            ,PSDFlags:ptr_new((*sPtr).PSDFlags) $
                                            ,show_TD:(*sPtr).show_TD $
                                            ,ocontainer:(*sPtr).oContainer $
                                           }
endif


grpl = (*sPtr).notify_ids[1]
if (widget_info(grpl,/valid)) then widget_control, grpl, /sensitive

ptr_free, sPtr

end
;-------------------------------------------------------------------------------


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro dtas_change_detsInSum, ocontainer,group_leader=grpl   $
   ,notify_ids = notify_ids,register_name = register_name $
   ,no_update = no_update,num_elements = num_elements,title=title,dependent=dependent

catch, catchError
if (catchError ne 0) then begin
    catch, /cancel
    if (widget_info(wTLB,/valid)) then widget_control, wTLB, /destroy
    if (widget_info(grpl,/valid)) then widget_control, grpl, /sensitive
    return
endif


if n_elements(num_elements) eq 0 then num_elements = 4
if n_elements(no_update) eq 0 then no_update = 0
if no_update eq 1 then update = 0 else update = 1

if n_elements(notify_ids) eq 0 then return
if n_params() eq 0 then return
if not obj_valid(ocontainer) then return
if n_elements(grpl) eq 0 then return

n = ocontainer->count()
if n eq 0 then return
o = ocontainer->get(/all)
ret = o[0]->get_property(display_name = display_name, $ ;var_names=titles,filename=filename $
   plot_str = plot_str,anaPkgStr=anaPkgStr)
if n_elements(register_name) eq 0 then register_name = display_name
if xregistered(register_name) then return


; Create the widgets
if (n_elements(title) eq 0) then title='Select Detectors to Include in Sum'
wTLB = widget_base(group_leader=grpl,/col,/tlb_frame_attr,title=title)

show_TD = plot_str.show_TD
maxColumns = 4
xs = 300
switch anaPkgStr.mode of
    1: begin
        label = 'Diffraction Detectors'
        wCB1 = widget_base(wTLB,/frame,/col,xsize=xs)
        void = widget_label(wCB1,value=label)
        names = anaPkgStr.DDDets

        detsInSum = strsplit(anaPkgStr.sigDetsInSum,';',/extract,count=cnt0)
        nDets = n_elements(names)
        DDFlags = bytarr(nDets)
        if (cnt0 gt 0) then begin
            for i=0,cnt0-1 do begin
                ind = where(names eq detsInSum[i],cnt1)
                if (cnt1) then DDFlags[ind] = 1
            endfor
        endif

        for i=0,nDets-1 do begin
            if ((i mod maxColumns) eq 0) then $
              wCB11 = widget_base(wCB1,/grid,col=maxColumns,/nonexclusive)
            void = widget_button(wCB11,value=names[i],uname='DD',uvalue=i)
            if (DDFlags[i]) then widget_control, void, /set_button
        endfor
        
        break
    end

    2:
    3: begin
        ;; Primary Detectors
        label = 'Primary Detectors'
        wCB1 = widget_base(wTLB,/frame,/col,xsize=xs,/base_align_center)
        void = widget_label(wCB1,value=label)

        names = anaPkgStr.SDDets

        detsInSum = strsplit(anaPkgStr.sigDetsInSum,';',/extract,count=cnt0)
        nDets = n_elements(names)
        SDFlags = bytarr(nDets)
        if (cnt0 gt 0) then begin
            for i=0,cnt0-1 do begin
                ind = where(names eq detsInSum[i],cnt1)
                if (cnt1) then SDFlags[ind] = 1
            endfor
        endif

        for i=0,nDets-1 do begin
            if ((i mod maxColumns) eq 0) then $
              wCB11 = widget_base(wCB1,/grid,col=maxColumns,/nonexclusive)
            void = widget_button(wCB11,value=names[i],uname='SD',uvalue=i)
            if (SDFlags[i]) then widget_control, void, /set_button
        endfor

        ;; Door Detectors
        label = 'Door Detectors'
        wCB2 = widget_base(wTLB,/frame,/col,xsize=xs,/base_align_center)
        void = widget_label(wCB2,value=label)
        void = widget_base(wCB2,/col,/base_align_center,/nonexclusive)
        void = widget_button(void,value='Display Door Detectors',uname='SHOW_TD')
        if (show_TD) then widget_control, void, /set_button

        names = anaPkgStr.TDDets

        detsInSum = strsplit(anaPkgStr.TDDetsInSum,';',/extract,count=cnt0)
        nDets = n_elements(names)
        TDFlags = bytarr(nDets)
        if (cnt0 gt 0) then begin
            for i=0,cnt0-1 do begin
                ind = where(names eq detsInSum[i],cnt1)
                if (cnt1) then TDFlags[ind] = 1
            endfor
        endif

        for i=0,n_elements(names)-1 do begin
            if ((i mod maxColumns) eq 0) then $
              wCB21 = widget_base(wCB2,/grid,col=maxColumns,/nonexclusive)
            void = widget_button(wCB21,value=names[i],uname='TD',uvalue=i)
            if (TDFlags[i]) then widget_control, void, /set_button
        endfor
        break
    end

    4: begin
        label = 'PSD Detectors'
        wCB1 = widget_base(wTLB,/frame,/col,xsize=xs)
        void = widget_label(wCB1,value=label)
        names = anaPkgStr.PSDDets

        detsInSum = strsplit(anaPkgStr.sigDetsInSum,';',/extract,count=cnt0)
        nDets = n_elements(names)
        PSDFlags = bytarr(nDets)
        if (cnt0 gt 0) then begin
            for i=0,cnt0-1 do begin
                ind = where(names eq detsInSum[i],cnt1)
                if (cnt1) then PSDFlags[ind] = 1
            endfor
        endif

        for i=0,nDets-1 do begin
            if ((i mod maxColumns) eq 0) then $
              wCB11 = widget_base(wCB1,/grid,col=maxColumns,/nonexclusive)
            void = widget_button(wCB11,value=names[i],uname='PSD',uvalue=i)
            if (PSDFlags[i]) then widget_control, void, /set_button
        endfor
        
        break
    end

    else: begin
        if (widget_info(wTLB,/valid)) then widget_control, wTLB, /destroy
        if (widget_info(grpl,/valid)) then widget_control, grpl, /sensitive
        return
    end
endswitch

void = widget_button(wTLB,value='DISMISS',uname='DISMISS')

; n = n_elements(titles)
; if ~is_ice(filename) then titles = titles[0:n-3]


; names = titles
; row_base1 = widget_base(tlb,/row)
; ncols = dtas_ci_ncols(n_elements(names),num_elements)
; group_name = strarr(ncols)
; for i = 0,ncols-1 do begin
;    uname = 'VAR_CHOICE_'+strtrim(string(i),2)
;    group_name[i] = uname
;    if i lt ncols-1 then begin
;       titles_id = cw_bgroup(row_base1,names[i*num_elements:((i+1)*num_elements)-1], $
;          /nonexclusive,uname = uname,/col, xsize = 200)
;    endif else begin
;       titles_id = cw_bgroup(row_base1,names[i*num_elements:n_elements(names)-1], $
;          /nonexclusive,uname = uname,/col, xsize = 200)
;    endelse
; endfor
; row_base2 = widget_base(tlb,/row)
; void = widget_button(row_base2,value = 'DISMISS',uname = 'DISMISS')


; De-sensitize parent window
widget_control,grpl,sensitive = 0

; centertlb,tlb
widget_control,wTLB,/realize


;state = {titles_id:titles_id,ocontainer:ocontainer,notify_ids:notify_ids, $
;select:index,update:update,group_name:group_name,n:num_elements}
index = 0
state = {ocontainer:ocontainer,notify_ids:notify_ids $
         ,DDFlags:(n_elements(DDFlags) gt 0)? DDFlags : 0 $
         ,SDFlags:(n_elements(SDFlags) gt 0)? SDFlags : 0 $
         ,TDFlags:(n_elements(TDFlags) gt 0)? TDFlags : 0 $
         ,PSDFlags:(n_elements(PSDFlags) gt 0)? PSDFlags : 0 $
         ,show_TD:show_TD,select:index,update:update}

pstate = ptr_new(state,/no_copy)
widget_control,wTLB,set_uvalue = pstate,/no_copy
xmanager,register_name,wTLB,/no_block,event_handler = 'detsInSum_event', $
   cleanup = 'detsInSum_cleanup'

end
