; $Id$


function crs_TASCombiner_sortit,x,i1,i2,i3,sorted,unique,xunique=xunique
compile_opt IDL2
  tol = 1000.0
  spread = (10.0d)^5

  htemp = (floor(x[i1,*]*tol))*(spread^3)/tol
  ktemp = (floor(x[i2,*]*tol))*(spread^2)/tol
  ltemp = (floor(x[i3,*]*tol))*spread/tol
  
  tot = htemp + ktemp + ltemp
  
  sorted = sort(tot)
  unique = uniq(tot[sorted])

  xnew = x[*,sorted]
  xunique = xnew[*,unique]

  return,xnew
end;crs_TASCombiner_sortit


function cwo_TASCombiner::readOneFile,fn,s,result=result,fitinput=fitinput
 compile_opt IDL2
  if fn ne '' then begin
    result = obj_new('crs_dtas_data_new',filename=fn)
    if obj_valid(result) gt 0 then begin

          void = result->auto_gauss_fit(fit_text=fit_text,fitinput=fitinput)

          s = fit_text
          print,'cwo_TASCombiner::readOneFile'
          ;print,transpose(fit_text)
          if n_elements(fit_text) gt 2 then begin
            ;print,fit_text[n_elements(fit_text)-2]
            segs = strsplit(fit_text[n_elements(fit_text)-2],/extract)
            chisq = double(segs[1])
            if chisq gt 100.0 then begin
              void = result->auto_gauss_fit(fit_text=fit_text,n=2,fitinput=fitinput)
              s = fit_text
              ;if n_elements(fit_text) gt 2 then print,fit_text[n_elements(fit_text)-2]
            endif
          endif
          ;help,result
          duh = result->get_property(fitinputptr=fitinputptr)
          if ptr_valid(fitinputptr) gt 0 then fitinput = *fitinputptr
          
          return,1
    endif else begin
          return,0
    endelse  
  endif else begin
    return,0
  endelse

end;cwo_TASCombiner::readOneFile
pro cwo_TASCombiner::openfiles
 compile_opt IDL2

  mytlb = self.tlb  
  ;print,'crs_panes_openfiles'
  fn = dialog_pickfile( filter=['*.bt7','*.bt9','*.spins','*.ice'],/multi,$
                        path=self.datadir,dialog_parent=mytlb)  
  
  if n_elements(fn) ge 1 and fn[0] ne '' then begin
            self.datadir = file_dirname(fn[0]) 
            nfiles = n_elements(fn)
          
          ;  print,file_basename(fn)  
            q = fltarr(3,nfiles)
          
            for i=0,n_elements(fn)-1 do begin
              
              sucs = self->readOneFile(fn[i],str,result=data,fitinput=fitinput)
              if sucs ne 0 then begin

                if obj_valid(data) gt 0 then begin
                  dum = data->get_property(hkl=hkl,fitinputptr=fitinputptr)
                  if ptr_valid(fitinputptr) gt 0 then fitinput = *fitinputptr else fitinput = [0.,0,0,0]
                  
                  q[*,i] = hkl
                  self.datacontainer->add,data
                endif;obj_valid
              endif;sucs
            endfor;i
  endif;files  
    
end;cwo_TASCombiner::openfiles


pro cwo_TASCombiner::writeOutputFile
 compile_opt IDL2
  ;widget_control,self.status,set_value='Write Output File'
  ;print,'WRITE OUT THE FINAL INFORMATION FILE WITH ALL THE STUFF THAT WAS REQUESTED'
  if self.outputcontainer->count() eq 0 then begin
    void = dialog_message(['No data added to output.','Select files in tree and press "Add to Output"'],dialog_parent=self.tlb)
  endif else begin
    fn = dialog_pickfile(path = self.workdir,title='Output File Selection:',dialog_parent=self.tlb,/write)
    if fn ne '' then begin
        ;self->addDotExt,fn,'txt'
        ;self->addDotTxt,fn
        fn = lrk_adddotext(fn,'txt')
        self.workdir = file_dirname(fn)
        ;print,'fn = ',file_basename(fn)
        ref = self.outputcontainer->get(/all)

        openw,lun,fn,/get_lun
        ;widget_control,self.status,set_value='Eventually I will say: Wrote data to file: '+fn;file_basename(fn)
        ;ref = self.sumupcontainer->get(/all)
        ;help,ref
        print,'h','k','   l','Itot','sItot','groupMonitor','OverallMonitor','CorrectionApplied',$
              'th','tth','MonitorCorrection','thCorrection','tthCorrection',$
              format = '(A10,A10,A10,A15,A15,A15,A15,1A20,A5,A5,1A20,A15,A15)'

        printf,lun,'h','k','   l','Itot','sItot','groupMonitor','OverallMonitor','CorrectionApplied',$
              'th','tth','MonitorCorrection','thCorrection','tthCorrection',$
              format = '(A10,A10,A10,A15,A15,A15,A15,1A20,A5,A5,1A20,A15,A15)'

widget_control,self.sortorder,get_value=val
;print,val
        allq = fltarr(3,n_elements(ref))
        for i=0,n_elements(ref)-1 do begin          
          if obj_valid(ref[i]) ne 0 then begin
             duh = ref[i]->getQ(hkl)
             allQ[*,i] = hkl
             ;print,allQ
          endif;ref
        endfor;i

case val of
0:duh=self->sortit(allQ,0,1,2,sorted);,unique,xunique=xunique
1:duh=self->sortit(allQ,1,0,2,sorted);,unique,xunique=xunique
2:duh=self->sortit(allQ,2,0,1,sorted);,unique,xunique=xunique
else:duh=self->sortit(allQ,0,1,2,sorted);,unique,xunique=xunique
endcase;val
ref=ref[sorted]

        monitorset = 0

        for i=0,n_elements(ref)-1 do begin          
          if obj_valid(ref[i]) ne 0 then begin
             
            duh = ref[i]->getString(s=outputString,numbers=outputNumbers)
            duh = ref[i]->scantype(th=thscan,tth=tthscan,align=alignscan,_Extra=extra)
            ;print,'thscan,tthscan,alignscan=',thscan,tthscan,alignscan
            if monitorset eq 0 then begin  
              overallmonitor = outputnumbers.monitor[0]
              yn = dialog_message('Would you like to set a custom monitor for the output file? ',$
                                    /question,$
                                    dialog_parent=self.tlb,$
                                    title='CRS_COMBINE:')
              if strupcase(yn) eq 'YES' then begin
                ;print,'cwo_TASCombiner::writeOutputFile overallmonitor=',overallmonitor
                newval = MACSScanManager_inputDialog(group_leader = self.tlb,$
                                                     title='Enter new overall monitor value:',$
                                                     value=strtrim(string(overallmonitor),2))
                                                     
                newval = double(newval);CHECK THIS VALUE SOMEHOW:
                ;print,finite(newval)
                
                if newval le 0.0 or $
                    finite(newval) ne 1 or $
                      finite(newval,/nan) eq 1 then begin
                  void = dialog_message('Invalid value, setting overall monitor to original value = '+strtrim(string(overallMonitor),2),$
                                        dialog_parent=self.tlb,title='CRS_COMBINE:')
                  newval = overallmonitor                  
                endif;newval
                
                overallmonitor = newval
                
                ;print,newval  
              endif;strupcase(yn)      
              monitorset = 1
            endif;monitorset


;print,'cwo_TASCombiner::writeOutputFile  CALCULATE OVERALL MONITOR AND SCALE ---- NEED TO ACCEPT USER INPUT'
            ;FIRST CALCULATE THE MONITOR SCALE FACTOR AS THE OVERALL MONITOR (THE MONITOR OF THE FIRST ITEM) DIVIDED BY THE CURRENT MONITOR
            scalefactor = float(overallmonitor)/float(outputnumbers.monitor[0])
            
            ;note: should there be a propagation of the error in the sItot below, or should we just assume
            ;      
            
                    

;THIS SHOULD APPLY ALL CORRECTIONS APPLIED BY SCAN TYPE.
            ;NOW CALCULATE THE CORRECTION FACTOR DETERMINED BY THE MOTOR MOVED IN THE EXPERIMENT.
            anglecorrection = 1.0

;LRK - 11/16/09
;
;CORRECTIONS ARE FOR THETA SCAN OR THETA-TWOTheta SCAN.  SO THIS IS _NOT_ A MULTIPLICATIVE SITUATION.
            if thscan eq 1 then anglecorrection = 1.0/outputnumbers.thcorrection;anglecorrection/outputnumbers.thcorrection 

            ;IF A4 IS MOVING THEN IT IS THETA-2THETA.   THERE IS NO A4-ONLY SCAN!!!!
            if tthscan eq 1 then anglecorrection = 1.0/outputnumbers.tthcorrection;anglecorrection/outputnumbers.tthcorrection
            
            ;CALCULATE THE TOTAL CORRECTION THAT WILL BE APPLIED TO THE DATA AND ERROR BAR
            correction = scalefactor*anglecorrection
        
        
            
            ;CALCULATE THE TOTAL CORRECTION THAT WILL BE APPLIED TO THE DATA AND ERROR BAR
            correction = scalefactor*anglecorrection

            ;help,outputNumbers,/struct
            print,outputnumbers.hkl[0],$
                  outputnumbers.hkl[1],$
                  outputnumbers.hkl[2],$
                  outputnumbers.itot*correction,$
                  outputnumbers.sitot*correction,$
                  outputnumbers.monitor[0],$
                  overallmonitor,$
                  correction,$
                  thscan,$
                  tthscan,$
                  scalefactor,$
                  outputnumbers.thcorrection,$
                  outputnumbers.tthcorrection,$
                  format='(3g10.4,4g15.8,1g20.8,2i5,1g20.8,2g15.8)'
            printf,lun,$
                  outputnumbers.hkl[0],$
                  outputnumbers.hkl[1],$
                  outputnumbers.hkl[2],$
                  outputnumbers.itot*correction,$
                  outputnumbers.sitot*correction,$
                  outputnumbers.monitor[0],$
                  overallmonitor,$
                  correction,$
                  thscan,$
                  tthscan,$
                  scalefactor,$
                  outputnumbers.thcorrection,$
                  outputnumbers.tthcorrection,$
                  format='(3g10.4,4g15.8,1g20.8,2i5,1g20.8,2g15.8)'
;            ;print,outputString
;            printf,lun,outputString+' '+strtrim(string(scalefactor),2)
          endif
        endfor;i
        free_lun,lun
    endif else begin
      print,'No file selected.'
    endelse
  endelse
end;cwo_TASCombiner::writeOutputFile

pro cwo_TASCombiner::writeFullProfFile
 compile_opt IDL2
  ;widget_control,self.status,set_value='Write FullProf File'
  ;print,'WRITE OUT THE FINAL INFORMATION FILE WITH ALL THE STUFF THAT WAS REQUESTED'
  if self.outputcontainer->count() eq 0 then begin
    void = dialog_message(['No data added to output.','Select files in tree and press "Add to Output"'],dialog_parent=self.tlb)
  endif else begin
    fn = dialog_pickfile(path = self.workdir,title='Output File Selection:',dialog_parent=self.tlb,/write)
    if fn ne '' then begin
        ;self->addDotExt,fn,'txt'
        
        ;self->addDotTxt,fn
        fn = lrk_adddotext(fn,'dat')
        self.workdir = file_dirname(fn)
        ;print,'fn = ',file_basename(fn)
        ref = self.outputcontainer->get(/all)

        openw,lun,fn,/get_lun
        ;widget_control,self.status,set_value='Eventually I will say: Wrote data to file: '+fn;file_basename(fn)
        ;ref = self.sumupcontainer->get(/all)
        ;help,ref


;OMIT HEADER FOR FULLPROF DATA
;        
;        print,'h','k','   l','Itot','sItot','groupMonitor','OverallMonitor','CorrectionApplied',$
;              'th','tth','MonitorCorrection','thCorrection','tthCorrection',$
;              format = '(A10,A10,A10,A15,A15,A15,A15,1A20,A5,A5,1A20,A15,A15)'
;
;        printf,lun,'h','k','   l','Itot','sItot','groupMonitor','OverallMonitor','CorrectionApplied',$
;              'th','tth','MonitorCorrection','thCorrection','tthCorrection',$
;              format = '(A10,A10,A10,A15,A15,A15,A15,1A20,A5,A5,1A20,A15,A15)'

widget_control,self.sortorder,get_value=val
;print,val
        allq = fltarr(3,n_elements(ref))
        for i=0,n_elements(ref)-1 do begin          
          if obj_valid(ref[i]) ne 0 then begin
             duh = ref[i]->getQ(hkl)
             allQ[*,i] = hkl
             ;print,allQ
          endif;ref
        endfor;i

case val of
0:duh=self->sortit(allQ,0,1,2,sorted);,unique,xunique=xunique
1:duh=self->sortit(allQ,1,0,2,sorted);,unique,xunique=xunique
2:duh=self->sortit(allQ,2,0,1,sorted);,unique,xunique=xunique
else:duh=self->sortit(allQ,0,1,2,sorted);,unique,xunique=xunique
endcase;val
ref=ref[sorted]

        monitorset = 0
        for i=0,n_elements(ref)-1 do begin          
          if obj_valid(ref[i]) ne 0 then begin
             
            duh = ref[i]->getString(s=outputString,numbers=outputNumbers)
            duh = ref[i]->scantype(th=thscan,tth=tthscan,align=alignscan,_Extra=extra)
            ;print,'thscan,tthscan,alignscan=',thscan,tthscan,alignscan
;            if monitorset eq 0 then begin  
;              overallmonitor = outputnumbers.monitor[0]
;              monitorset = 1
;            endif

            if monitorset eq 0 then begin  
              overallmonitor = outputnumbers.monitor[0]
              yn = dialog_message('Would you like to set a custom monitor for the output file? ',$
                                    /question,$
                                    dialog_parent=self.tlb,$
                                    title='CRS_COMBINE:')
                                    
              if strupcase(yn) eq 'YES' then begin
                ;print,'cwo_TASCombiner::writeOutputFile overallmonitor=',overallmonitor
                newval = MACSScanManager_inputDialog(group_leader = self.tlb,$
                                                     title='Enter new overall monitor value:',$
                                                     value=strtrim(string(overallmonitor),2))
                newval = double(newval);CHECK THIS VALUE SOMEHOW:
                ;print,finite(newval)
                
                if newval le 0.0 or $
                    finite(newval) ne 1 or $
                      finite(newval,/nan) eq 1 then begin
                  void = dialog_message('Invalid value, setting overall monitor to original value = '+strtrim(string(overallMonitor),2),$
                                        dialog_parent=self.tlb,title='CRS_COMBINE:')
                  newval = overallmonitor                  
                endif;newval
                
                overallmonitor = newval
                
                ;print,newval  
              endif;strupcase(yn)      
              monitorset = 1
            endif;monitorset




;print,'cwo_TASCombiner::writeFullProfFile  CALCULATE OVERALL MONITOR AND SCALE ---- NEED TO ACCEPT USER INPUT'

            ;FIRST CALCULATE THE MONITOR SCALE FACTOR AS THE OVERALL MONITOR (THE MONITOR OF THE FIRST ITEM) DIVIDED BY THE CURRENT MONITOR
            scalefactor = float(overallmonitor)/float(outputnumbers.monitor[0])
            
            ;note: should there be a propagation of the error in the sItot below, or should we just assume
            ;      
            
            

;THIS SHOULD APPLY ALL CORRECTIONS APPLIED BY SCAN TYPE.
            ;NOW CALCULATE THE CORRECTION FACTOR DETERMINED BY THE MOTOR MOVED IN THE EXPERIMENT.
            anglecorrection = 1.0

;LRK - 11/16/09
;
;CORRECTIONS ARE FOR THETA SCAN OR THETA-TWOTheta SCAN.  SO THIS IS _NOT_ A MULTIPLICATIVE SITUATION.
            if thscan eq 1 then anglecorrection = 1.0/outputnumbers.thcorrection;anglecorrection/outputnumbers.thcorrection 

            ;IF A4 IS MOVING THEN IT IS THETA-2THETA.   THERE IS NO A4-ONLY SCAN!!!!
            if tthscan eq 1 then anglecorrection = 1.0/outputnumbers.tthcorrection;anglecorrection/outputnumbers.tthcorrection
            
            ;CALCULATE THE TOTAL CORRECTION THAT WILL BE APPLIED TO THE DATA AND ERROR BAR
            correction = scalefactor*anglecorrection

            print,outputnumbers.hkl[0],$
                  outputnumbers.hkl[1],$
                  outputnumbers.hkl[2],$
                  outputnumbers.itot*correction,$
                  outputnumbers.sitot*correction,$
                  format='(5g15.8)'
            printf,lun,$
                  outputnumbers.hkl[0],$
                  outputnumbers.hkl[1],$
                  outputnumbers.hkl[2],$
                  outputnumbers.itot*correction,$
                  outputnumbers.sitot*correction,$
                  format='(5g15.8)'
          endif
        endfor;i
        free_lun,lun
    endif else begin
      print,'No file selected.'
    endelse
  endelse
end;cwo_TASCombiner::writeFullProfFile



pro cwo_TASCombiner::updateLatParms,obj
      print,'self.latparmsUpdate'
      values = self.latparms->get_values()
      ;help,values,/struct

      ;USE 0th OBJECT INITIALLY FOR TESTING.
      if n_elements(obj) eq 0 then obj = self.datacontainer->get(position=0)
      ;latvals = obj->getResVals()
      ;help,latvals,/struct
      obj->setLatVals,values;latvals
end;cwo_TASCombiner::updateLatParms

pro cwo_TASCombiner::updateResParms,obj,noqupdate=noqupdate

;      print,'self.reswidget'
      if n_elements(noqupdate) eq 0 then noqupdate = 0
      values = self.resparms->get_values()
      ;help,values,/struct
      ;USE 0th OBJECT INITIALLY FOR TESTING.
      if n_elements(obj) eq 0 then obj = self.datacontainer->get(position=0)
      ;resvals = obj->getResVals()
      ;help,resvals,/struct
      obj->setresVals,values,noqupdate=noqupdate
end;cwo_TASCombiner::updateResParms

function cwo_TASCombiner::sortit,x,i1,i2,i3,sorted,unique,xunique=xunique
compile_opt IDL2
  tol = 1000.0
  spread = (10.0d)^5

  htemp = (floor(x[i1,*]*tol))*(spread^3)/tol
  ktemp = (floor(x[i2,*]*tol))*(spread^2)/tol
  ltemp = (floor(x[i3,*]*tol))*spread/tol
  
  tot = htemp + ktemp + ltemp
  
  sorted = sort(tot)
  unique = uniq(tot[sorted])

  xnew = x[*,sorted]
  xunique = xnew[*,unique]

  return,xnew
end;cwo_TASCombiner::sortit

pro cwo_TASCombiner::uniqueQs,qs,order
;help,/traceback
;  print,'________  crs_panes_uniqueQs  _________'
compile_opt IDL2
  dc = self.datacontainer
  ctemp = obj_new('idl_container')

  for i=0,dc->count()-1 do begin
    o = dc->get(position=i)
    ;help,o
    ctemp->add,o,position=i
  endfor;i
  dc->remove,/all
;print,'---'

  
  ;GET qs AND SORT THEM.
  if ctemp->count() gt 0 then begin
    allqs = fltarr(3,ctemp->count())
  
    for i=0,ctemp->count()-1 do begin    
      o = ctemp->get(position=i)
      dum = o->get_Property(hkl=hkl)
      ;help,o
  
      if n_elements(hkl) eq 0 then begin
        hkl = fltarr(3)
        duh = o->set_property(hkl = hkl)
      endif
      allqs[*,i] = hkl
    endfor;i
    case order of
    0:allqs = self->sortit(allqs,0,1,2,sorted,unique,xunique=qunique)
    1:allqs = self->sortit(allqs,1,0,2,sorted,unique,xunique=qunique)
    2:allqs = self->sortit(allqs,2,0,1,sorted,unique,xunique=qunique)
    else:
    endcase
    qs = qunique
  
    for i=0,ctemp->count()-1 do begin    
      o = ctemp->get(position=sorted[i])
      ;help,o
      dc->add,o,position=i
    endfor;i
    ctemp->remove,/all
  endif
  obj_destroy,ctemp

end;cwo_TASCombiner::uniqueQs


pro cwo_TASCombiner::defineLeaves,leaves
 compile_opt IDL2
  dc = self.datacontainer
  ;self.currentleaf = -1L
  currentleaf = -1L
  
  widget_control,self.sortorder,get_value=order
  self->uniqueQs,qs,order
  leaf1 = {leaf:0,parent:-1,folder:1,wid:0L,name:'Top Folder',expanded:1,obj:obj_new(),h:0.0,k:0.0,l:0.0,th:0,tth:0,sum:0}
  qfolder = {leaf:1,parent:0,folder:1,wid:0L,name:'h k l',expanded:1,obj:obj_new(),h:0.0,k:0.0,l:0.0,th:0,tth:0,sum:0}
  dfolder = {leaf:2,parent:1,folder:0,wid:0L,name:'file1',expanded:0,obj:obj_new(),h:0.0,k:0.0,l:0.0,th:0,tth:0,sum:0}

  ;SPECIFY THE ICON TO USE FOR THE TREE LEAF BASED ON A3,A4,A3/A4 
  ;PLUS THESE GUYS WILL WANT TO DRAG AND DROP LEAVES.  --- HOW HARD WILL THAT BE????????

  ;CREATE Q FOLDERS
  sz = size(qs)
  if sz[0] eq 1 then begin
    nhkl = 1
  endif else begin
    nhkl = sz[2]
  endelse
  qfolders = replicate(qfolder,nhkl+1)
  fmt = '(g6.3)'
  for i=0,nhkl-1 do begin
    qfolders[i].leaf = i
    qfolders[i].name = '['+string(qs[0,i],format=fmt)+','+string(qs[1,i],format=fmt)+','+string(qs[2,i],format=fmt)+']'
    qfolders[i].h = qs[0,i]
    qfolders[i].k = qs[1,i]
    qfolders[i].l = qs[2,i]
  endfor;i
  qfolders[nhkl].name = 'Unknown'
  qfolders[nhkl].leaf = nhkl

  if dc->count() gt 0 then begin
      ;CREATE DATA FOLDERS
      dfolders = replicate(dfolder,dc->count())
      for i=0,dc->count()-1 do begin

        ;IF A DATA SET IS REPARENTED, THEN RESET THE hkl VALUE IN THE DATA SET SHOULD BE RESET.
        o = dc->get(position=i)
        duh = o->get_property(hkl=hkl,filename=filename)
  
        insum = self.outputcontainer->iscontained(o)
        ;print,'insum=',insum
        duh = o->scantype(th=thscan,tth=tthscan,align=align)
        
        ;print,hkl,qs
        dfolders[i].name = file_basename(filename)
        dfolders[i].h = hkl[0]
        dfolders[i].k = hkl[1]
        dfolders[i].l = hkl[2]

        for j = 0,n_elements(qfolders)-1 do begin        
          if abs(dfolders[i].h - qfolders[j].h) lt 0.0001 and  $
             abs(dfolders[i].k - qfolders[j].k) lt 0.0001 and  $
             abs(dfolders[i].l - qfolders[j].l) lt 0.0001 then begin

                myparent = qfolders[j].leaf
                ;CHANGE PARENT IF Q=[0,0,0]
                if abs(dfolders[i].h - 0.0) lt 0.0001 and  $
                   abs(dfolders[i].k - 0.0) lt 0.0001 and  $
                   abs(dfolders[i].l - 0.0) lt 0.0001 then begin
                    
                    myparent = qfolders[nhkl].leaf
                endif
                break

          endif else begin
            myparent = qfolders[nhkl].leaf
          endelse
        endfor;j
        dfolders[i].parent = myparent
        dfolders[i].obj = o
        dfolders[i].sum = insum
        dfolders[i].th = thscan
        dfolders[i].tth = tthscan
        
        
        ;STORE leafinfo IN THE OBJECT --- I THINK THIS WILL BE USEFUL IN RETRIEVING REPARENTED LEAVES LATER ON 
        duh = o->set_property(leafinfo=dfolders[i])
      endfor;i
      leaves = [leaf1,qfolders,dfolders]
  endif else begin
      leaves = [leaf1,qfolders]
  endelse
end;cwo_TASCombiner::defineLeaves

pro cwo_TASCombiner::updateTree,dx=dx,dy=dy,treedestroy=treedestroy
  print,'cwo_TASCombiner::updateTree'

  treegeom = widget_info(self.tree,/geometry)
  ;widget_control,self.tree,ysize=(treegeom.ysize+dy) > 400
  if n_elements(dx) eq 0 then dx = 0
  if n_elements(dy) eq 0 then dy = 0
  if n_elements(treedestroy) eq 0 then treedestroy = 1

  xsize = treegeom.xsize+dx
  ysize = treegeom.ysize+dy

;  print,'Update Tree'
;  help,self.dataContainer
;  help,self.tree
if treedestroy eq 1 then begin
  self->defineLeaves,leaves
  widget_control,self.tree,/destroy
  self.tree = tascombiner_treepane(self.treeTop,leaves=leaves,xsize=xsize,ysize=ysize);,base=self.tree);,xsize=xsize,ysize=ysize  
endif else begin
  if xsize le 1 then xsize = 200
  if ysize le 1 then ysize = 200
  widget_control,self.tree,xsize=xsize,ysize=ysize
endelse


end;cwo_TASCombiner::updateTree


function cwo_TASCombiner::getTreeSelection,allobj=allobj,folders=folders

      widget_control,self.tree,get_uvalue=uval
      leaf=widget_info((*uval).tree,/tree_select) 
      ;help,leaf     
;      if n_elements(leaf) gt 1 then begin
;        print,'cwo_TASCombiner::getTreeSelection   MULTIPLE SELECTION!!!'
;      endif
      if leaf[0] ne -1L then begin

          for i=0,n_elements(leaf)-1 do begin
              ;print,'NOTE: ONLY GETTING THE ZEROTH OBJECT FROM THE TREE SELECTION'
              widget_control,leaf[i],get_uvalue=luval,get_value=val
              ;help,luval,val
              ;help,luval,/struct
              if i eq 0 or n_elements(allobj) eq 0 then begin
                obj = luval.obj
                if obj_valid(obj) gt 0 then begin
                  allobj = [obj]
                endif else begin
                  if luval.folder eq 1 then begin
                    folder_str = {name:luval.name,h:luval.h,k:luval.k,l:luval.l}
                    folders=[folder_str]
                  endif 
                endelse
              endif else begin                
                obj = luval.obj
                if obj_valid(obj) gt 0 then begin
                  allobj = [allobj,obj]
                endif else begin
                  if luval.folder eq 1 then begin
                    folder_str = {name:luval.name,h:luval.h,k:luval.k,l:luval.l}
                    if n_elements(folders) eq 0 then begin
                      folders=[folder_str]
                    endif else begin
                      folders=[folders,folder_str]
                    endelse
                  endif
                endelse               
              endelse
          endfor;i

          if obj_valid(obj) gt 0 then begin
            return,obj
          endif else begin
            return,obj_new()
          endelse

      endif else begin
        return,obj_new()
      endelse
      
end;getTreeSelection


function cwo_TASCombiner::getExt,s,iext=iext,len=len,base=base
        if n_elements(s) eq 0 then return,''
        iext = strpos(s,'.',/reverse_search)
;print,iext
        if (iext ne -1) and (iext-strlen(s) lt 10) then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
            base  = strmid(s,0,iext)
            ;print,ext
            ;print,base
        endif else begin
            ext = ''
            base=s
        endelse
        return,ext

end;cwo_TASCombiner::getExt

;pro cwo_TASCombiner::addDotEXT,ofn,newext
;        ext = self->getExt(ofn,iext=iext,len=len,base=base)
;        ofn = base+newext
;end;cwo_TASCombiner::addDotEXT

;function cwo_TASCombiner::getExt,s,iext=iext,len=len
;        iext = strpos(s,'.',/reverse_search)
;
;        if iext ne -1 then begin
;            len  = strlen(s)
;            ext  = strmid(s,iext+1,len-iext)
;        endif else begin
;            ext = ''
;        endelse
;        return,ext
;
;end;cwo_TASCombiner::getExt


pro cwo_TASCombiner::addDotTXT,ofn

        ext = self->getExt(ofn,iext=iext,len=len)
        if ext ne 'txt' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'txt',sublen)
            endif else begin
                ofn = ofn+'.txt'
            endelse
        endif

end;cwo_TASCombiner::addDotTXT

pro cwo_TASCombiner::addDotSav,ofn

        ext = self->getExt(ofn,iext=iext,len=len)
        if ext ne 'sav' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ofn = strendsub(ofn,'sav',sublen)
            endif else begin
                ofn = ofn+'.sav'
            endelse
        endif

end;cwo_TASCombiner::addDotSav

pro cwo_TASCombiner::addDotExt,ofn,newext
        if n_elements(newext) eq 0 then newext = 'sav'

        ext = self->getExt(ofn,iext=iext,len=len)
        if ext ne 'dave' then begin
            if iext gt 0 then begin
                sublen=len-iext
                ;print,'ofn before=',ofn
                ;void = dialog_message('BEFORE strendsub call cwo_ConvertBT1ToDave::addDotDave')
                ofn = strendsub(ofn,newext,sublen)
                ;void = dialog_message('AFTER strendsub call')

                ;print,'ofn after=',ofn
            endif else begin
                ofn = ofn+'.'+newext
            endelse
        endif

end;cwo_TASCombiner::addDotExt


pro cwo_TASCombiner::update,obj
;        duh = obj->getFitText(fittext)
;        widget_control,self.fittext,set_value=fittext
;  
;        duh = obj->getParmNames(parmnames)
;        duh = obj->getChiSq(chiSq)
;        duh = obj->getData(x,y,dy,xtitle,ytitle,title)
;        fitret = obj->getDataFit(xfit,yfit)
;        self.drawplot->cleardata
;
;        ;ELIMINATE NAN'S
;        whnan = where(finite(y,/nan))
;        if whnan[0] ne -1 then y[whnan] = 0.0
;        whnan = where(finite(yfit,/nan))
;        if whnan[0] ne -1 then yfit[whnan] = 0.0
;
;        self.drawplot->add,x=x,y=y,sy=dy,xtitle=xtitle,ytitle=ytitle,title=title,legend='Data',psym=4,/ebshow;,legend=legend
;        self.drawplot->add,x=xfit,y=yfit,legend='Fit',color=255L
;        ;if fitret eq 1 then  self.drawplot->add,xfit,yfit,legend='Fit'
;        self.drawplot->setProperty,xtitle=xtitle,ytitle=ytitle,title=title
;        self.drawplot->defaultdraw


              duh = obj->getLatvals(latVals)
              duh = obj->getResvals(resVals)
              duh =  obj->getHeader(header)
              duh = obj->getFitText(fittext)
              self.latparms->set_values,latvals
              self.resparms->set_values,resvals
              widget_control,self.headertext,set_value=header
              widget_control,self.fittext,set_value=fittext
              duh = obj->getQ(q)
              ;print,'hkl=',q
              duh = obj->getParmNames(parmnames)
              duh = obj->getChiSq(chiSq)
              duh = obj->getData(x,y,dy,xtitle,ytitle,title)

              fitret = 0
              if duh ne 0 then begin
                xsort = sort(x)
                x = x[xsort]
                y = y[xsort]
                dy = dy[xsort]
                fitret = obj->getDataFit(xfit,yfit)
              endif else begin
                self.drawplot->cleardata
                self.drawplot->defaultdraw
                return
              endelse;duh

              ;IF A FIT IS AVAILABLE THEN PROVIDE IT, OTHERWISE, PLOT AND USE ZERO HERE.
              if fitret ne 0 then begin              
                  xfitsort = sort(xfit)
                  xfit = xfit[xfitsort]
                  yfit = yfit[xfitsort]
              endif else begin
                  xfit = x
                  yfit = 0.0*x
              endelse

              whnan = where(finite(y,/nan))
              if whnan[0] ne -1 then y[whnan] = 0.0
              whnan = where(finite(yfit,/nan))
              if whnan[0] ne -1 then yfit[whnan] = 0.0

              self.drawplot->cleardata
;              if n_elements(x) ne 0 an n_
              self.drawplot->add,x=x,y=y,sy=dy,xtitle=xtitle,ytitle=ytitle,title=title,legend='Data',psym=4,/ebshow;,legend=legend
              self.drawplot->add,x=xfit,y=yfit,legend='Fit',color=255L
              ;if fitret eq 1 then  self.drawplot->add,xfit,yfit,legend='Fit'
              self.drawplot->setProperty,xtitle=xtitle,ytitle=ytitle,title=title

;print,finite(dy,/nan)
;print,finite(y,/nan)
;print,min([x,xfit]),max([x,xfit]),min([y-dy,yfit-dy]),max([y+dy,yfit+dy])              
              self.drawplot->defaultdraw;,xmin=min([x,xfit]),$
                                         ;xmax=max([x,xfit]),$
                                         ;ymin=min([y-dy,yfit-dy]),$
                                         ;ymax=max([y+dy,yfit+dy])







end;cwo_TASCombiner::update
pro cwo_TASCombiner::event,event
  ;print,'cwo_TASCombiner::event'

  donotupdatetree = 0
  treedestroy = 0
;  print,'event'
  case event.id of
    ;TOP LEVEL ITEMS
    self.tlb:begin
      
      case strupcase(!version.os_family) of
      'WINDOWS':begin
        ytweek = 56
        xtweek = 12
      end;windows
      else:begin
        ytweek = 100
        xtweek = 20
      endelse
      endcase
      widget_control,self.status,set_value='self.tlb'
      dx = (event.x > 400) - self.tlbxsize + xtweek
      treedx = 0
      dy = (event.y > 400) - self.tlbysize + ytweek
      treedy = dy - ytweek
      self.drawplot->adjustsize,dx,dy,xsize=oldxsize,ysize=oldysize
      newgeom = widget_info(self.tlb,/geom)
      self.tlbxsize = newgeom.scr_xsize
      self.tlbysize = newgeom.scr_ysize
    end;tlb
    self.dragwin:begin
      if event.press eq 1 then self.dragwinpressed = 1
      if event.release eq 1 then self.dragwinpressed = 0

      if self.dragwinpressed eq 1 then begin

;          geom = widget_info(self.dragwin,/geom)
;          ;SNAP POSITION OF DRAGWIN TO MOUSE LOCATION BY ADJUSTING PLOT AND TREE ON PRESS
;          print,event.x,geom.xsize/2.0
;          diff = fix(geom.xsize/2 - event.x)
;
;          tgeom = widget_info(self.tree,/geometry)
;          ;IF MOTION MOVES TO LEFT, SNAP THE 
;          
;          widget_control,self.tree,xsize=tgeom.xsize-diff
;          tgeom = widget_info(self.treetop,/geometry)
;          widget_control,self.treetop,xsize=tgeom.xsize-diff
;
;          self.drawplot->adjustsize,diff

      endif;self.dragwinpressed
      
    end;dragwin
    self.quit:begin
      widget_control,self.status,set_value='self.tlb'
      widget_control,self.tlb,/destroy
      return
    end;quit
    ;
    ;FITTING
    self.addGaussButton:begin
      widget_control,self.status,set_value='self.addgaussbutton'
      obj = self->getTreeSelection()
      if obj_valid(obj) gt 0 then begin
        obj->addGaussian;,x,parms
        duh = obj->getFitText(fittext)
        widget_control,self.fittext,set_value=fittext
      endif

    end;addGaussButton
    self.modifyparametersbutton:begin
      widget_control,self.status,set_value='self.modifyparametersbutton'
      obj = self->getTreeSelection()
      if obj_valid(obj) gt 0 then begin
        obj->modifyfitparms;,x,parms

        self->update,obj
  
;        duh = obj->getFitText(fittext)
;        widget_control,self.fittext,set_value=fittext
;  
;        duh = obj->getParmNames(parmnames)
;        duh = obj->getChiSq(chiSq)
;        duh = obj->getData(x,y,dy,xtitle,ytitle,title)
;        fitret = obj->getDataFit(xfit,yfit)
;        self.drawplot->cleardata
;whnan = where(finite(y,/nan))
;if whnan[0] ne -1 then y[whnan] = 0.0
;whnan = where(finite(yfit,/nan))
;if whnan[0] ne -1 then yfit[whnan] = 0.0
;
;        self.drawplot->add,x=x,y=y,sy=dy,xtitle=xtitle,ytitle=ytitle,title=title,legend='Data',psym=4,/ebshow;,legend=legend
;        self.drawplot->add,x=xfit,y=yfit,legend='Fit',color=255L
;        ;if fitret eq 1 then  self.drawplot->add,xfit,yfit,legend='Fit'
;        self.drawplot->setProperty,xtitle=xtitle,ytitle=ytitle,title=title
;        self.drawplot->defaultdraw
      endif
    end;modifyparametersbutton
    self.refitbutton:begin
      widget_control,self.status,set_value='self.refitbutton'
      obj = self->getTreeSelection()
      if obj_valid(obj) gt 0 then begin
          duh = obj->refit(xfit,yfit,x=x,y=y,dy=dy)
    self->update,obj
;          duh = obj->getFitText(fittext)
;          widget_control,self.fittext,set_value=fittext
;    
;    ;      fitret = obj->getDataFit(xfit,yfit)
;    ;      dataret = obj->getData(x,y,dy)
;          self.drawplot->cleardata
;whnan = where(finite(y,/nan))
;if whnan[0] ne -1 then y[whnan] = 0.0
;whnan = where(finite(yfit,/nan))
;if whnan[0] ne -1 then yfit[whnan] = 0.0
;
;          self.drawplot->add,x=x,y=y,sy=dy,xtitle=xtitle,ytitle=ytitle,title=title,legend='Data',psym=4,/ebshow;,legend=legend
;          self.drawplot->add,x=xfit,y=yfit,legend='Fit',color=255L
;          ;if fitret eq 1 then  self.drawplot->add,xfit,yfit,legend='Fit'
;          self.drawplot->setProperty,xtitle=xtitle,ytitle=ytitle,title=title
;          self.drawplot->defaultdraw      
      endif;obj_valid
    end;refitbutton
    ;
    ;FILE ITEMS
    self.savestate:begin
      widget_control,self.status,set_value='self.savestate'
      fn = dialog_pickfile(title='Select output file: ',filter='*.sav',/write,/overwrite_prompt)

      if fn ne '' then begin
        ;self->addDotExt,fn,'sav'
        self->addDotSav,fn
        datacontainer = self.datacontainer
        outputcontainer = self.outputcontainer
        save,datacontainer,outputcontainer,filename=fn
      endif
    end;savestate
    self.restorestate:begin
      widget_control,self.status,set_value='self.restorestate'
      fn = dialog_pickfile(title='Select file to restore: ',filter='*.sav',/read)
;print,fn
      restore,fn
;      help,datacontainer,outputcontainer
      if n_elements(datacontainer) gt 0 and n_elements(outputcontainer) gt 0 then begin
        if self.datacontainer->count() gt 0 then begin
          dump = self.datacontainer->get(/all)
          self.datacontainer->remove,/all          
          obj_destroy,dump
        endif
        
        if self.outputcontainer->count() gt 0 then begin
          dump = self.outputcontainer->get(/all)
          self.outputcontainer->remove,/all
          obj_destroy,dump
        endif
        self.datacontainer->add,datacontainer->get(/all)
        self.outputcontainer->add,outputcontainer->get(/all)
        
      endif else begin
        void = dialog_message('No data to restore in that file.',dialog_parent=self.tlb)
      endelse
      
      treedestroy=1
    end;restorestate
    self.openbutton:begin
      widget_control,self.status,set_value='self.openbutton'
      mytlb = self.tlb
      fn = dialog_pickfile(filter=['*.bt7','*.bt9','*.ng5'],/multi,path=self.datadir,dialog_parent=mytlb)
      if fn[0] ne '' then begin
        self.datadir = file_dirname(fn[0])
        for i = 0,n_elements(fn)-1 do begin
          dat = obj_new('crs_dtas_data_new',  filename = fn[i])
          if obj_valid(dat) ne 0 then begin
            self.datacontainer->add,dat
            treedestroy=1            
          endif
        endfor;i
      endif
    end;openbutton
    ;
    ;DRAW WIDGET
    self.draw:begin
      widget_control,self.status,set_value='self.draw'
    end;draw
    ;
    ;DATA MODIFICATION/INSERTION
    self.latparmsUpdate:begin
      widget_control,self.status,set_value='self.latparmsupdate'
      obj = self->getTreeSelection()    
      if obj_valid(obj) then begin  
        self->updateLatParms,obj
      endif
    end;latparmsupdate
    self.latwidget:begin
      widget_control,self.status,set_value='self.latwidget'    
      obj = self->getTreeSelection() 
      if obj_valid(obj) then begin     
        self->updateLatParms,obj
      endif
    end;latwidget    
    self.reswidget:begin
      widget_control,self.status,set_value='self.reswidget'

      obj = self->getTreeSelection(allobj=allobj)      
      if obj_valid(obj) then begin
        if n_elements(allobj) eq 1 then begin
          self->updateResParms,obj
        endif else begin  
          for i=0,n_elements(allobj)-1 do begin
            self->updateResParms,allobj[i],/noqupdate            
          endfor;i
        endelse
      endif
    end;reswidget
    self.sortorder:begin
      widget_control,self.status,set_value='self.sortorder'

      treedestroy=1
    end;sortorder
    self.tree:begin
      widget_control,self.status,set_value='self.tree'

      obj = self->getTreeSelection(allobj=allobj,folders=folders)
      eventtype = tag_names(event,/structure_name)
      case strupcase(eventtype) of
      'TASCOMBINER_TREEPANE':begin
        case strlowcase(event.string) of
        'delete_selected':begin
          widget_control,self.status,set_value='self.tree:delete'
          if n_elements(folders) gt 0 then begin
            print,folders
            treedestroy=1
          endif
          if n_elements(allobj) gt 0 then begin
            self.datacontainer->remove,allobj
            obj_destroy,allobj
            self.drawplot->cleardata
            self.drawplot->defaultdraw          
            
            treedestroy=1
        endif
        end;delete_selected
        'clone_selected':begin

          ;AS WITH delete_selected, NEED OPTION TO sum ENTIRE FOLDER TOGETHER.

          treedestroy=1
          if n_elements(allobj) lt 1 then begin
            void = dialog_message('Must select object for clone.',dialog_parent=self.tlb)
          endif else begin
                print,'clone_selected'
                print,'n_elements(allobj)=',n_elements(allobj)
                for i=0,n_elements(allobj)-1 do begin
                  clone = allobj[i]->crsclone()
                  self.datacontainer->add,clone
                endfor;i
          endelse
        end;clone_selected        
        'sum_selected':begin

          ;AS WITH delete_selected, NEED OPTION TO sum ENTIRE FOLDER TOGETHER.

          treedestroy=1
          if n_elements(allobj) le 1 then begin
            void = dialog_message('More than one data object required for sum.',dialog_parent=self.tlb)
          endif else begin
                print,'sum_selected'
                print,'n_elements(allobj)=',n_elements(allobj)
                clone = allobj[0]->crsclone()

                self.datacontainer->add,clone
                clone->combine,allobj[1:*]
                duh = clone->refit()
          endelse


        end;sum_selected
        'add_to_output':begin
          print,'add to output'
          if n_elements(allobj) gt 0 then self.outputcontainer->add,allobj
          treedestroy=1
          
        end;add_to_output
        'remove_all_from_output':begin
          self.outputcontainer->remove,/all
          treedestroy=1

        end;remove_all_from_output
        'remove_selected_from_output':begin
          ;help,allobj
          self.outputcontainer->remove,allobj
          treedestroy=1
        end;remove_selected_from_output
        'write_output_file':begin
          widget_control,self.status,set_value='write output'
          self->writeOutputFile          

        end;write_output_file
        'write_fullprof_file':begin
          widget_control,self.status,set_value='write fullprof output'
          self->writeFullprofFile          

        end;write_fullprof_file
        else:begin
          print,'event.string=',event.string
        endelse
        endcase
        
        
      end;TASCOMBINER_TREEPANE
      'WIDGET_CONTEXT':begin
        print,'CONTEXT'
        ;help,event,/struct
      end;WIDGET_CONTEXT
      'WIDGET_TREE_SEL':begin
          ;print,'self.tree'
          ;print,'NOTE: ONLY GETTING THE ZEROTH OBJECT FROM THE TREE SELECTION'
          ;obj = self->getTreeSelection()
          ;help,obj
          ;help,obj
          ;help,event,/struct
          if obj_valid(obj) ne 0 then begin
            self->update,obj          
;              duh = obj->getLatvals(latVals)
;              duh = obj->getResvals(resVals)
;              duh =  obj->getHeader(header)
;              duh = obj->getFitText(fittext)
;              self.latparms->set_values,latvals
;              self.resparms->set_values,resvals
;              widget_control,self.headertext,set_value=header
;              widget_control,self.fittext,set_value=fittext
;              duh = obj->getQ(q)
;              ;print,'hkl=',q
;              duh = obj->getParmNames(parmnames)
;              duh = obj->getChiSq(chiSq)
;              duh = obj->getData(x,y,dy,xtitle,ytitle,title)
;xsort = sort(x)
;x = x[xsort]
;y = y[xsort]
;dy = dy[xsort]
;              fitret = obj->getDataFit(xfit,yfit)
;xfitsort = sort(xfit)
;xfit = xfit[xfitsort]
;yfit = yfit[xfitsort]
;
;whnan = where(finite(y,/nan))
;if whnan[0] ne -1 then y[whnan] = 0.0
;whnan = where(finite(yfit,/nan))
;if whnan[0] ne -1 then yfit[whnan] = 0.0
;
;              self.drawplot->cleardata
;              self.drawplot->add,x=x,y=y,sy=dy,xtitle=xtitle,ytitle=ytitle,title=title,legend='Data',psym=4,/ebshow;,legend=legend
;              self.drawplot->add,x=xfit,y=yfit,legend='Fit',color=255L
;              ;if fitret eq 1 then  self.drawplot->add,xfit,yfit,legend='Fit'
;              self.drawplot->setProperty,xtitle=xtitle,ytitle=ytitle,title=title
;
;;print,finite(dy,/nan)
;;print,finite(y,/nan)
;;print,min([x,xfit]),max([x,xfit]),min([y-dy,yfit-dy]),max([y+dy,yfit+dy])              
;              self.drawplot->defaultdraw;,xmin=min([x,xfit]),$
;                                         ;xmax=max([x,xfit]),$
;                                         ;ymin=min([y-dy,yfit-dy]),$
;                                         ;ymax=max([y+dy,yfit+dy])


          endif else begin ;obj_valid
              self.drawplot->cleardata
              self.drawplot->defaultdraw          
          endelse
      end;WIDGET_TREE_SEL
      else:begin
        print,'TREE ELSE??'
      endelse
      endcase
    end;tree
  else:begin
    ;print,'ELSE?????'
  endelse
  endcase  

  self->updateTree,dx=treedx,dy=treedy,treedestroy=treedestroy
  
end;cwo_TASCombiner::event
pro cwo_TASCombiner::cleanup
  print,'cwo_TASCombiner::cleanup'

  obj_destroy,self.datacontainer
  obj_destroy,self.outputcontainer
  if obj_valid(self.dragwinobj) then obj_destroy,self.dragwinobj
end;cwo_TASCombiner::cleanup


pro cwo_TASCombiner_event,event
  widget_control,event.handler,get_uvalue=obj
  
  obj->event,event


end;cwo_TASCombiner_event

pro cwo_TASCombiner::getproperty,tlb=tlb,_Extra=extra

  tlb = self.tlb

end;cwo_TASCombiner::getproperty

pro cwo_tasCombiner::prepareTest
;TO FACILITATE INITIAL TESTING
;  filename = 'C:\Documents and Settings\kneller\Desktop\DAVECode061808\dave_devel\programs\modules\TAS\crs_combine\Data\Cris\magsc023.bt9'
  filename='C:\Documents and Settings\kneller\Desktop\Data\Cris\magsc023.bt9'
  if file_test(filename) ne 0 then begin
    self.workdir = file_dirname(filename)
    self.datadir = file_dirname(filename)
    odata=obj_new('crs_dtas_data_new',filename = filename)

    self.dataContainer->add,odata
  endif;file_test
end;prepareTest
function cwo_TASCombiner::init,daveTool=daveTool,$
                                group_leader=group_leader,$
                                workdir=workdir,datadir=datadir,$
                                _Extra=extra

  if n_elements(daveTool) eq 1 then if obj_valid(davetool) ne 0 then self.daveTool = daveTool else self.daveTool = obj_new()
  if n_elements(workdir) eq 0 then workdir = '.'
  if n_elements(datadir) eq 0 then datadir = '.'

  self.workDir = workdir
  self.workDir = datadir

  self.tlb = widget_base(title='CRS_COMBINE',mbar=bar,/col,group_leader=group_leader,/tlb_size_events)

  file = widget_button(bar,/menu,value='File')

  self.openbutton = widget_button(file,value='Open')
  self.savestate = widget_button(file,value='Save State')
  self.restorestate = widget_button(file,value='Restore State')
  self.quit = widget_button(file,value='Quit')

  self.datacontainer = obj_new('IDL_CONTAINER')
  self.outputcontainer = obj_new('IDL_CONTAINER')

;TO FACILITATE TESTING
  self->prepareTest

  ;NOW LAY OUT THE WIDGET
  self.sortorder = cw_bgroup(self.tlb,['[h,k,l]','[k,h,l]','[l,h,k]'],/exclusive,set_value=0,$
                                      label_left='Sort Precedence',/row,/no_release)
  llb1 = widget_base(self.tlb,/row)
  tabs = widget_tab(llb1)
  tb1 = widget_base(tabs,title='Header',/col)
  ;tb2 = widget_base(tabs,title='Resolution',/col)
  tb3 = widget_base(tabs,title='Resolution',/col)
  tb3a = widget_base(tabs,title='Lattice',/row)
  tb4 = widget_base(tabs,title='Fitting',/col)

  llb2 = widget_base(self.tlb,/row)
  llb2a = widget_base(llb2,/col)
  llb2a1 = widget_base(llb2,/col)

  llb2b = widget_base(llb2,/col)

  llb3 = widget_base(self.tlb,/row);

  self.headertext = widget_text(tb1,xsize=80,ysize=10)

  self.reswidget = crs_resparms(tb3,obj=o_r);cwo_resparms(tb3,obj=o)
  self.resparms = o_r
  self.latwidget = crs_latparms(tb3a,obj=o_l);cwo_resparms(tb3,obj=o)
  self.latparms = o_l
  self.latparmsUpdate = widget_button(tb3a,value='Update')
  ;self.restext = widget_text(tb3,xsize=80,ysize=6,/scroll)

  self.fittext = widget_text(tb4,xsize=80,ysize=10,/scroll)
  self.addGaussButton = widget_button(tb4,value='Add a Gaussian') 
  self.modifyparametersbutton = widget_button(tb4,value='Modify Fit Parameters')
  self.refitbutton = widget_button(tb4,value='Refit Data')

  self.treeTop = widget_base(llb2a);,/context_events);tree(llb2a)
  treexsize = 350
  treeysize = 400
  self.tree = tascombiner_treepane(self.treeTop,xsize=treexsize+10,ysize=treeysize);llb2a,xsize=250,ysize=400)
  
  self.dragwin = widget_draw(llb2a1,xsize=7,ysize=treeysize,/motion_events,/button_events);,graphics_level=2)
 
  ;CONTEXT MENU 1
  self.contextMenu = widget_base(self.tree,uname='CRSTreeContext',/col,/context_Menu)
  self.deletebutton = widget_button(self.contextmenu,value='Delete Selected')
  self.sumbutton = widget_button(self.contextmenu,value='Sum Selected')
  self.addtooutputButton = widget_button(self.contextmenu,value='Add to Output')
  self.clearOutputButton = widget_button(self.contextmenu,value='Clear Output Data')
  self.removeOneFromOutputButton = widget_button(self.contextmenu,value='Remove Selected from Output')
  self.writeoutputfileButtonContext = widget_button(self.contextmenu,value='Write Output to File')

;DEFINE REST OF CONTEXT MENUS LATER
;  singleFileContextMenu:0L,$
;  singleFolderContextMenu:0L,$
;  mixedSelectContextMenu:0L,$


;  self.sortorder = cw_bgroup(llb2a,['[h,k,l]','[k,h,l]','[l,h,k]'],/exclusive,set_value=0,label_left='Sort Precedence',/row)
  self.draw = cwo_drawplot(llb2b,xsize=400,ysize=treeysize,obj=drawplot)
  self.drawplot = drawplot

;  self.status = widget_label(self.tlb,/sunken,xsize=400)
  self.status = widget_label(llb2a,/sunken,xsize=treexsize+30)

  widget_control,self.tlb,set_uvalue=self
  widget_control,self.tlb,/realize
  tlbgeom = widget_info(self.tlb,/geometry)
  self.tlbxsize = tlbgeom.scr_xsize
  self.tlbysize = tlbgeom.scr_ysize

  ;help,tlbgeom,/struct 
  self->updateTree;,treedestroy=0
  widget_control,self.dragwin,get_VALUE=wid
  self.dragwinid = wid
  device,get_decomposed=dc
  device,decomposed=0
  wset,self.dragwinid
  erase,200L+200L*256L+200L*256L*256L
  device,decomposed=dc

  xmanager,'cwo_TASCombiner',self.tlb,event_handler='cwo_TAScombiner_event',/no_block

  return,1
end;cwo_TASCombiner::init




pro cwo_TASCombiner__define,class
  class = {cwo_TASCombiner,$
            tlb:0L,$
            tlbxsize:0,$
            tlbysize:0,$
            daveTool:obj_new(),$
            drawplot:obj_new(),$
            draw:0l,$
            headertext:0L,$
            Restext:0L,$      ;RES DISPLAY
            fittext:0L,$      ;FIT CONTROLS
            addGaussButton:0L,$
            modifyparametersbutton:0L,$
            refitbutton:0L,$
            sortorder:0L,$
            openbutton:0L,$  ;FILE MENU
            workdir:'',$
            datadir:'',$
            quit:0L,$
            savestate:0L,$
            restorestate:0L,$
            contextMenu:0L,$
            singleFileContextMenu:0L,$
            singleFolderContextMenu:0L,$
            mixedSelectContextMenu:0L,$
            deletebutton:0L,$  ;CONTEXT MENU ITEMS
            sumbutton:0L,$
            addtooutputButton:0L,$
            clearOutputButton:0L,$
            removeOneFromOutputButton:0L,$
            writeoutputfileButtonContext:0l,$
            status:0L,$
            tree:0L,$
            treetop:0L,$
            reswidget:0L,$
            latwidget:0L,$
            dragwin:0L,$
            dragwinobj:obj_new(),$
            dragwinid:0L,$
            dragwinpressed:0,$
            resparms:obj_new(),$  ;RESINPUT
            latparms:obj_new(),$  ;RESINPUT
            latparmsUpdate:0L,$            
            datacontainer:obj_new(),$
            outputcontainer:obj_new()}

end;cwo_TASCombiner__define

function cwo_TASCombiner,parent,obj=obj,daveTool=daveTool,$
                         group_leader=group_leader,$
                         workdir=workdir,datadir=datadir,$
                         _Extra=extra

    obj = obj_new('cwo_TASCombiner',daveTool=daveTool,$
                                    group_leader=group_leader,$
                                    workdir=workdir,datadir=datadir,$
                                    _Extra=extra)
    obj->getproperty,tlb=tlb


    return,tlb

end;cwo_TASCombiner

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro launch_crs_combine,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra

if n_elements(event) eq  0 then begin
;            crs_panes,group_leader=group_leader,$
;                            workDir=workDir,$
;                            dataDir=dataDir,$
;                            DAVETool=DAVETool,$
;                            _Extra=extra

            duh = cwo_TASCombiner(parent,obj=obj,daveTool=daveTool,$
                                     group_leader=group_leader,$
                                     workdir=workdir,datadir=datadir,$
                                     _Extra=extra)

endif else begin
        thisEvent = tag_names(event,/structure_name)
        case thisEvent of
        'WIDGET_BUTTON': $
          begin
            print,'Opening crs_combine from DAVE Classic Menu!'
            ;run_lattice,group_leader=event.top;notifyIDs = [event.id,event.top]
;            crs_panes,group_leader=group_leader,$
;                            workDir=workDir,$
;                            dataDir=dataDir,$
;                            DAVETool=DAVETool,$
;                            _Extra=extra
            duh = cwo_TASCombiner(parent,obj=obj,daveTool=daveTool,$
                                     group_leader=group_leader,$
                                     workdir=workdir,datadir=datadir,$
                                     _Extra=extra)
          end
        'WIDGET_TREE_SEL': $
          begin
            print,'Opening crs_combine from DAVE Tree Menu!'
            ;run_lattice,group_leader=event.top;[event.id,event.top]
;            crs_panes,group_leader=group_leader,$
;                            workDir=workDir,$
;                            dataDir=dataDir,$
;                            DAVETool=DAVETool,$
;                            _Extra=extra
            duh = cwo_TASCombiner(parent,obj=obj,daveTool=daveTool,$
                                     group_leader=group_leader,$
                                     workdir=workdir,datadir=datadir,$
                                     _Extra=extra)

          end
        else:print,'Doing nothing.'
        endcase
        return
endelse
end;launch_crs_combine


