; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    crs_resparms
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;
;METHODS:
;    crs_resparms_test_event
;    crs_resparms_test
;    crs_resparms_event
;    crs_resparms::event
;    crs_resparms::check_values
;    crs_resparms::checkEFixed
;    crs_resparms::checkQClosed
;    crs_resparms::get_values
;    crs_resparms_set_value
;    crs_resparms_get_value
;    crs_resparms::get_q
;    crs_resparms::set_Q
;    crs_resparms::getproperty
;    crs_resparms::setproperty
;    crs_resparms_cleanup
;    crs_resparms::cleanup
;    crs_resparms::init
;    crs_resparms__define
;    crs_resParms
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
;THIS IS A STATELESS HOLDER OF THE VALUES NEEDED TO DEFINE A RESOLUTION FUNCTION


;###############################################################################
;
;NAME:
;        crs_resparms_test_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms_test_event,event
    print,tag_names(event)
    print,event
end;crs_resparms_test_event
;###############################################################################
;
;NAME:
;        crs_resparms_test
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms_test,obj=obj

    b=widget_base(xoffset=300,yoffset=300,title='RESOLUTION INPUTS')
    p = crs_resparms(b,$
                        horizontal=0,$
                        collimatorh=[60,60,60,60],$
                        collimatorv=[60,60,60,60],$
                        mosaic=[60,60,60,60],$
                        dspacing=[5,5],$
                        qetrans = [2,3,0,14.7,6],$
                        orient = [1,1],$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj)

    widget_control,b,/realize
    xmanager,'crs_resparms_test',b,/no_block
end;test


;###############################################################################
;
;NAME:
;        crs_resparms_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms_event,event
    widget_control,widget_info(event.handler,/child),get_uvalue=self
    event = self->event(event)
    return,event
end;crs_resparms_event


;###############################################################################
;
;NAME:
;        crs_resparms::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::event,event


    ;print,'crs_resparms::event',event.id


    case event.id of
    self.monocombo:begin
        widget_control,self.monocombo,get_uvalue=info
        index = nse_comboindex(self.monocombo)
        widget_control,self.bDM1R,set_value=info.dspacing[index]
    end;monocombo
    self.anacombo:begin
        widget_control,self.anacombo,get_uvalue=info
        index = nse_comboindex(self.anacombo)
        widget_control,self.bDa2R,set_value=info.dspacing[index]
    end;anacombo
    self.bDm1R:begin
        ;SET MONO
        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.monocombo,set_combobox_select=index
    end;monofield
    self.bDa2R:begin

        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.anacombo,set_combobox_select=index

    end;anafield
    else:
    endcase


    self.resvals = self->get_values()

    ;CHANGE EVENT.id TO THE crs's TLB
    event.id = self.tlb
    event.handler = self.parent
    return,event

end;crs_resparms::event


;###############################################################################
;
;NAME:
;        crs_resparms::check_values
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms::check_values

    changesMade = 0

    changesMade += self->checkEFixed()
    ;changesMade += self->checkQClosed()

    if changesMade ne 0 then void = dialog_message('Changed bad values in resolution parameters')

end;check_values


;###############################################################################
;
;NAME:
;        crs_resparms::checkEFixed
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::checkEFixed


    changesMade = 0
    ;CHECK Efixed
    widget_control,self.bEtran4R,get_value=Etrans
    widget_control,self.bEin5R,get_value=Efixed
    widget_control,self.EFixedChoice,get_uvalue=sign
    choice = nse_comboindex(self.EFixedChoice)
;print,'crs_resparms::checkEFixed'
;print,'Etrans=',Etrans
;print,'Efixed=',Efixed
;print,'sign=',sign
    if Efixed eq 0 then begin
        Efixed = 14.7
        changesMade += 1
    endif


    if Efixed lt 0 then begin
        Efixed = abs(Efixed)
        widget_control,self.bEin5R,set_value=Efixed
        changesMade = 1
    endif


    if choice eq 0 then begin
        Ei = Efixed    ;EA
        Ef = Ei - Etrans
        if Ef le 0 then begin
            Etrans = Ei - 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif

    endif else begin
        Ef = Efixed    ;EM
        Ei = Etrans + Ef
        if Ei le 0 then begin
            Etrans = Ef + 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif
    endelse

    return,changesMade
end;checkEFixed

;###############################################################################
;
;NAME:
;        crs_resparms::checkQClosed
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::checkQClosed


    changesMade = 0

;;;;;;    ;************************************************
;;;;;;    ;* definition of constants         *
;;;;;;    ;* E = 2.072 k^2 (E:meV, k:AA^-1)     *
;;;;;;    ;************************************************
;;;;;;    f   = 1./2.072
;;;;;;
;;;;;;
;;;;;;    widget_control,self.bEtran4R,get_value=Etrans
;;;;;;    widget_control,self.bEin5R,get_value=Efixed
;;;;;;    widget_control,self.EFixedChoice,get_value=choice,get_uvalue=sign
;;;;;;
;;;;;;
;;;;;;    ;*************************
;;;;;;    ;* calculate ei,ef,ki,kf *
;;;;;;    ;* based on efix & feief *
;;;;;;    ;*************************
;;;;;;    aom =   f*etran     ; energy transfer in units AA^-2
;;;;;;
;;;;;;    if choice eq 0 then begin
;;;;;;        ;   *************************
;;;;;;        ;   * fixed incident energy *
;;;;;;        ;   *************************
;;;;;;        ei =   efix
;;;;;;        ef =   efix-etran
;;;;;;    endif   else  begin
;;;;;;        ;   **********************
;;;;;;        ;   * fixed final energy *
;;;;;;        ;   **********************
;;;;;;        ei =   efix+etran
;;;;;;        ef =   efix
;;;;;;    endelse
;;;;;;
;;;;;;    ki  =    sqrt(f*ei)
;;;;;;    kf  =    sqrt(f*ef)
;;;;;;    alam    =  ki/kf
;;;;;;
;;;;;;
;;;;;;    ;****************************************************************
;;;;;;    ;* various trigonometric expressions from        *
;;;;;;    ;* scattering triangle  :    ki=kf-Q              *
;;;;;;    ;* (34) be = cos(2theta_s)  ;   al = sin(2theta_s)    *
;;;;;;    ;*  sints = sin(theta_s)               *
;;;;;;    ;* (29) psi=angle between ki and -Q ;   aom=ki^2-kf^2     *
;;;;;;    ;*  sa = sin(psi)       ; sb = cos(psi)     *
;;;;;;    ;*      b  = cos(2theta_s+psi)  ;    aa = sin(2theta_s+psi)     *
;;;;;;    ;****************************************************************
;;;;;;    be  =    (ki^2+kf^2-q^2)/(2*ki*kf)  ; q^2=ki^2+kf^2-2ki*kf*be
;;;;;;
;;;;;;
;;;;;;    if be^2 gt 1 then begin
;;;;;;        ;------------------------------------
;;;;;;        ;| Scattering triangle cannot close |
;;;;;;        ;------------------------------------
;;;;;;
;;;;;;         closed = 0
;;;;;;         r0 =   0
;;;;;;         changesMade = 1
;;;;;;    endif
;;;;;;
;;;;;;

    return,changesMade
end;checkQClose





;###############################################################################
;
;NAME:
;        crs_resparms::get_values
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::get_values

    self->check_values

    ;GET THE VALUES FROM ALL THE WIDGETS WITH VALUES AND
    ;RETURN THEM IN A STRUCTURE.
    widget_control,self.bColh1R,get_value=bColh1R
    widget_control,self.bColh2R,get_value=bColh2R
    widget_control,self.bColh3R,get_value=bColh3R
    widget_control,self.bColh4R,get_value=bColh4R

    widget_control,self.bColv1R,get_value=bColv1R
    widget_control,self.bColv2R,get_value=bColv2R
    widget_control,self.bColv3R,get_value=bColv3R
    widget_control,self.bColv4R,get_value=bColv4R

    widget_control,self.bEtash1R,get_value=bEtash1R
    widget_control,self.bEtasv2R,get_value=bEtasv2R
    widget_control,self.bEtam3R,get_value=bEtam3R
    widget_control,self.bEtaa4R,get_value=bEtaa4R


    widget_control,self.bDm1R,get_value=bDm1R
    widget_control,self.bDa2R,get_value=bDa2R


;INSTRUMENT ORIENTATIONS SHOULD BE +/- 1:
    widget_control,self.bEpm1R,get_value=bEpm1Rvals
    bEpm1RIndex = nse_comboindex(self.bEpm1R)
    bEpm1R = fix(bEpm1Rvals[bEpm1RIndex])

    widget_control,self.bEp2R,get_value=bEp2Rvals
    bEp2RIndex = nse_comboindex(self.bEp2R)
    bEp2R = fix(bEp2Rvals[bEp2RIndex])

    widget_control,self.bQh1R,get_value=bQh1R
    widget_control,self.bQk2R,get_value=bQk2R
    widget_control,self.bQl3R,get_value=bQl3R

    widget_control,self.bEtran4R,get_value=bEtran4R
    widget_control,self.bEin5R,get_value=bEin5R

    widget_control,self.EFixedChoice,get_uvalue=uval
    val = nse_comboindex(self.EFixedChoice)
;print,'uval=',uval
;print,'val=',val
    sign = uval[val]

    if sign gt 0 then begin
      monofixed = 1
      anafixed = 0
      eifixed = 1
      effixed = 0
      feief = 1
    endif else begin
      monofixed = 0
      anafixed = 1
      eifixed = 0
      effixed = 1
      feief = 0
    endelse 


    ;SET ENERGY SIGN BASED ON CHECKBOX CHOICE.  reselps REQUIRES NEGATIVE ENERGY VALUE IF Ef Fixed, Pos for Ei
    bEin5R = sign*abs(bEin5R)





    widget_control,self.sourceCombo,get_value=val,get_uvalue=uval
    bSource1R = uval[nse_comboindex(self.SourceCombo)]
;    print,'bSourceR from combo=',bSource1R

;    widget_control,self.bSource1R,get_value=bSource1R
;    print,'bSourceR from field=',bSource1R


;                    geomchoice:0L,$     ;RLR/RLL
;                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

    widget_control,self.horizontalFocusCheckbox,get_value=bSourceHFocus
    ;print,'HorizontalFocus =',bSourceHFocus

;    widget_control,self.bSourceHFocus,get_value=bSourceHFocus
;    print,'HorizontalFocus =',bSourceHFocus



    ret = self.resvals

    ret.bColh1R=bColh1R
    ret.bColh2R=bColh2R
    ret.bColh3R=bColh3R
    ret.bColh4R=bColh4R
    ret.bColv1R=bColv1R
    ret.bColv2R=bColv2R
    ret.bColv3R=bColv3R
    ret.bColv4R=bColv4R
    ret.bEtash1R=bEtash1R
    ret.bEtasv2R=bEtasv2R
    ret.bEtam3R=bEtam3R
    ret.bEtaa4R=bEtaa4R
    ret.bDm1R=bDm1R
    ret.bDa2R=bDa2R
    ret.bEpm1R=bEpm1R
    ret.bEp2R=bEp2R
    ret.bQh1R=bQh1R
    ret.bQk2R=bQk2R
    ret.bQl3R=bQl3R
    ret.bEtran4R=bEtran4R
    ret.bEin5R=bEin5R
    ret.bSource1R=bSource1R
    ret.bSourceHFocus=bSourceHFocus
    ;MORE FAMILIAR NAMES AND GROUPINGS:
    ret.horizontal=bSourceHFocus
    ret.collimatorh=[bColh1R,bColh2R,bColh3R,bColh4R]
    ret.collimatorv=[bColv1R,bColv2R,bColv3R,bColv4R]
    ret.mosaic=[bEtash1R,bEtasv2R,bEtam3R,bEtaa4R]
    ret.dspacing=[bDm1R,bDa2R]
    ret.instrument_orient=[bEpm1R,bEp2R]
    ret.qetrans=[bQh1R,bQk2R,bQl3R,bEtran4R,bEin5R]
    ret.monofixed = monofixed 
    ret.anafixed = anafixed
    ret.eifixed = eifixed
    ret.effixed = effixed
    ret.feief = feief

    self.resvals = ret
    return,ret


;    ret = { $
;            bColh1R:bColh1R,$
;            bColh2R:bColh2R,$
;            bColh3R:bColh3R,$
;            bColh4R:bColh4R,$
;            bColv1R:bColv1R,$
;            bColv2R:bColv2R,$
;            bColv3R:bColv3R,$
;            bColv4R:bColv4R,$
;            bEtash1R:bEtash1R,$
;            bEtasv2R:bEtasv2R,$
;            bEtam3R:bEtam3R,$
;            bEtaa4R:bEtaa4R,$
;            bDm1R:bDm1R,$
;            bDa2R:bDa2R,$
;            bEpm1R:bEpm1R,$
;            bEp2R:bEp2R,$
;            bQh1R:bQh1R,$
;            bQk2R:bQk2R,$
;            bQl3R:bQl3R,$
;            bEtran4R:bEtran4R,$
;            bEin5R:bEin5R,$
;            bSource1R:bSource1R,$
;            bSourceHFocus:bSourceHFocus,$
;            ;MORE FAMILIAR NAMES AND GROUPINGS:
;            horizontal:bSourceHFocus,$
;            collimatorh:[bColh1R,bColh2R,bColh3R,bColh4R],$
;            collimatorv:[bColv1R,bColv2R,bColv3R,bColv4R],$
;            mosaic:[bEtash1R,bEtasv2R,bEtam3R,bEtaa4R],$
;            dspacing:[bDm1R,bDa2R],$
;            instrument_orient:[bEpm1R,bEp2R],$
;            qetrans:[bQh1R,bQk2R,bQl3R,bEtran4R,bEin5R]}
;
;    return,ret

end;get_values
;###############################################################################
;
;NAME:
;        crs_resparms::set_values
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
pro crs_resparms::set_values,resvals

  ;print,'crs_resparms::set_values'
    if n_elements(resvals) eq 0 then begin
      print,'crs_resparms::set_values  ------ no resvals received'
    endif else begin
;    self->check_values

    ;GET THE VALUES FROM ALL THE WIDGETS WITH VALUES AND
    ;RETURN THEM IN A STRUCTURE.
    widget_control,self.bColh1R,set_value=resvals.bColh1R
    widget_control,self.bColh2R,set_value=resvals.bColh2R
    widget_control,self.bColh3R,set_value=resvals.bColh3R
    widget_control,self.bColh4R,set_value=resvals.bColh4R

    widget_control,self.bColv1R,set_value=resvals.bColv1R
    widget_control,self.bColv2R,set_value=resvals.bColv2R
    widget_control,self.bColv3R,set_value=resvals.bColv3R
    widget_control,self.bColv4R,set_value=resvals.bColv4R

    widget_control,self.bEtash1R,set_value=resvals.bEtash1R
    widget_control,self.bEtasv2R,set_value=resvals.bEtasv2R
    widget_control,self.bEtam3R,set_value=resvals.bEtam3R
    widget_control,self.bEtaa4R,set_value=resvals.bEtaa4R


    widget_control,self.bDm1R,set_value=resvals.bDm1R
    widget_control,self.bDm1R,get_uvalue=monoinfo
    diffs = abs(monoinfo.dspacing - resvals.bDm1R)
    mindiff = min(diffs,minindex)
    widget_control,self.monocombo,set_combobox_select=minindex
    


    widget_control,self.bDa2R,set_value=resvals.bDa2R
    widget_control,self.bDa2R,get_uvalue=anainfo
    diffs = abs(anainfo.dspacing - resvals.bDa2R)
    mindiff = min(diffs,minindex)
    widget_control,self.anacombo,set_combobox_select=minindex

;INSTRUMENT ORIENTATIONS SHOULD BE +/- 1:
    if resvals.bEpm1R eq 1 then newindex = 0 else newindex = 1
    
    widget_control,self.bEpm1R,combobox_index=newindex

    if resvals.bEp2R eq 1 then newindex = 0 else newindex = 1
    widget_control,self.bEp2R,combobox_index=newindex

    widget_control,self.bQh1R,set_value=resvals.bQh1R
    widget_control,self.bQk2R,set_value=resvals.bQk2R
    widget_control,self.bQl3R,set_value=resvals.bQl3R

    widget_control,self.bEtran4R,set_value=resvals.bEtran4R


;-----------------------------------------------------------------------------------------

    widget_control,self.bEin5R,set_value=abs(resvals.bEin5R)

    if resvals.feief eq 1 then comboindex = 0 else comboindex = 1
    widget_control,self.EFixedChoice,combobox_index=comboindex
    val = nse_comboindex(self.EFixedChoice)

    widget_control,self.bEin5R,set_value=abs(resvals.bEin5R)
    
    if resvals.bsource1R eq 0 then newindex = 0 else newindex = 1
    widget_control,self.sourceCombo,combobox_index = newindex

    widget_control,self.horizontalFocusCheckbox,set_value=resvals.bSourceHFocus

;    self->check_values


  endelse
end;set_values


;###############################################################################
;
;NAME:
;        crs_resparms_set_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms_set_value,id,value
    print,'set_value'
end;crs_resparms_set_value
;###############################################################################
;
;NAME:
;        crs_resparms_get_value
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms_get_value,id,val=val
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj

    val = obj->get_values()

end;crs_resparms_get_value
;###############################################################################
;
;NAME:
;        crs_resparms::get_q
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::get_q

    return,self.resvals.qetrans[0:2]
end;get_qe

;###############################################################################
;
;NAME:
;        crs_resparms::set_Q
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms::set_Q,q,qh=qh,qk=qk,ql=ql

    ;USE THIS METHOD WHEN Q IS CHANGED IN SOME OTHER FIELD, SUCH AS crs_latparms OR OTHERS.

    if n_elements(Q) ge 3 then begin
        qh = q[0]
        qk = q[1]
        ql = q[2]
    endif

    if n_elements(qh) ne 0 then widget_control,self.bQh1R,set_value=qh
    if n_elements(qk) ne 0 then widget_control,self.bQk2R,set_value=qk
    if n_elements(ql) ne 0 then widget_control,self.bQl3R,set_value=ql

    self.resvals = self->get_values()

end;




;###############################################################################
;
;NAME:
;        crs_resparms::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms::getproperty,  parent =  parent,$
                                tlb =  tlb,$
                                bColh1R =  bColh1R,$
                                bColh2R =  bColh2R,$
                                bColh3R =  bColh3R,$
                                bColh4R =  bColh4R,$
                                bColv1R =  bColv1R,$
                                bColv2R =  bColv2R,$
                                bColv3R =  bColv3R,$
                                bColv4R =  bColv4R,$
                                bEtash1R =  bEtash1R,$
                                bEtasv2R =  bEtasv2R,$
                                bEtam3R =  bEtam3R,$
                                bEtaa4R =  bEtaa4R,$
                                bDm1R =  bDm1R,$
                                bDa2R =  bDa2R,$
                                bEpm1R =  bEpm1R,$
                                bEp2R =  bEp2R,$
                                bQh1R =  bQh1R,$
                                bQk2R =  bQk2R,$
                                bQl3R =  bQl3R,$
                                bEtran4R =  bEtran4R,$
                                bEin5R =  bEin5R,$
                                bSource1R =  bSource1R,$
                                bSourceHFocus =  bSourceHFocus,$
                                buttcalculate1 =  buttcalculate1,$
                                _ref_extra=extra


    if arg_present(parent) ne 0 then parent = self.parent
    if arg_present(tlb) gt 0 then tlb = self.tlb

    if arg_present(bColh1R) ne 0 then bColh1R = self.bColh1R
    if arg_present(bColh2R) ne 0 then bColh2R = self.bColh2R
    if arg_present(bColh3R) ne 0 then bColh3R = self.bColh3R
    if arg_present(bColh4R) ne 0 then bColh4R = self.bColh4R

    if arg_present(bColv1R) ne 0 then bColv1R = self.bColv1R
    if arg_present(bColv2R) ne 0 then bColv2R = self.bColv2R
    if arg_present(bColv3R) ne 0 then bColv3R = self.bColv3R
    if arg_present(bColv4R) ne 0 then bColv4R = self.bColv4R

    if arg_present(bEtash1R) ne 0 then bEtash1R = self.bEtash1R
    if arg_present(bEtasv2R) ne 0 then bEtasv2R = self.bEtasv2R
    if arg_present(bEtam3R) ne 0 then bEtam3R = self.bEtam3R
    if arg_present(bEtaa4R) ne 0 then bEtaa4R = self.bEtaa4R


    if arg_present(bDm1R) ne 0 then bDm1R = self.bDm1R
    if arg_present(bDa2R) ne 0 then bDa2R = self.bDa2R


    if arg_present(bEpm1R) ne 0 then bEpm1R = self.bEpm1R
    if arg_present(bEp2R) ne 0 then bEp2R = self.bEp2R


    if arg_present(bQh1R) ne 0 then bQh1R = self.bQh1R
    if arg_present(bQk2R) ne 0 then bQk2R = self.bQk2R
    if arg_present(bQl3R) ne 0 then bQl3R = self.bQl3R

    if arg_present(bEtran4R) ne 0 then bEtran4R = self.bEtran4R
    if arg_present(bEin5R) ne 0 then bEin5R = self.bEin5R


    if arg_present(bSource1R) ne 0 then bSource1R = self.bSource1R

    if arg_present(bSourceHFocus) ne 0 then bSourceHFocus = self.bSourceHFocus
    if arg_present(buttcalculate1) ne 0 then begin
        buttcalculate1 = self.buttcalculate1
    endif



end;crs_resparms

;###############################################################################
;
;NAME:
;        crs_resparms::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms::setproperty,parent=parent,_ref_extra=extra

    if n_elements(resvals) ne 0 then begin
                    ;resvals = {crs_resparms_values 
                    bColh1R=resvals.bColh1R 
                    bColh2R=resvals.bColh2R 
                    bColh3R=resvals.bColh3R 
                    bColh4R=resvals.bColh4R 
                    bColv1R=resvals.bColv1R 
                    bColv2R=resvals.bColv2R 
                    bColv3R=resvals.bColv3R 
                    bColv4R=resvals.bColv4R 
                    bEtash1R=resvals.bEtash1R 
                    bEtasv2R=resvals.bEtasv2R 
                    bEtam3R=resvals.bEtam3R 
                    bEtaa4R=resvals.bEtaa4R 
                    bDm1R=resvals.bDm1R 
                    bDa2R=resvals.bDa2R 
                    bEpm1R=resvals.bEpm1R 
                    bEp2R=resvals.bEp2R 
                    bQh1R=resvals.bQh1R 
                    bQk2R=resvals.bQk2R 
                    bQl3R=resvals.bQl3R 
                    bEtran4R=resvals.bEtran4R
                    bEin5R=resvals.bEin5R
                    bSource1R=resvals.bSource1R
                    bSourceHFocus=resvals.bSourceHFocus
                    horizontal=resvals.horizontal
                    collimatorh=resvals.collimatorh
                    collimatorv=resvals.collimatorv
                    mosaic=resvals.mosaic
                    dspacing=resvals.dspacing
                    instrument_orient=resvals.instrument_orient
                    qetrans=resvals.qetrans
    
    endif;resvals

    if n_elements(parent) ne 0 then self.parent=parent
    if n_elements(tlb) ne 0 then self.tlb = tlb

    if n_elements(bColh1R) ne 0 then self.bColh1R = bColh1R
    if n_elements(bColh2R) ne 0 then self.bColh2R = bColh2R
    if n_elements(bColh3R) ne 0 then self.bColh3R = bColh3R
    if n_elements(bColh4R) ne 0 then self.bColh4R = bColh4R

    if n_elements(bColv1R) ne 0 then self.bColv1R = bColv1R
    if n_elements(bColv2R) ne 0 then self.bColv2R = bColv2R
    if n_elements(bColv3R) ne 0 then self.bColv3R = bColv3R
    if n_elements(bColv4R) ne 0 then self.bColv4R = bColv4R

    if n_elements(bEtash1R) ne 0 then self.bEtash1R = bEtash1R
    if n_elements(bEtasv2R) ne 0 then self.bEtasv2R = bEtasv2R
    if n_elements(bEtam3R) ne 0 then self.bEtam3R = bEtam3R
    if n_elements(bEtaa4R) ne 0 then self.bEtaa4R = bEtaa4R


    if n_elements(bDm1R) ne 0 then self.bDm1R = bDm1R
    if n_elements(bDa2R) ne 0 then self.bDa2R = bDa2R


    if n_elements(bEpm1R) ne 0 then self.bEpm1R = bEpm1R
    if n_elements(bEp2R) ne 0 then self.bEp2R = bEp2R


    if n_elements(bQh1R) ne 0 then self.bQh1R = bQh1R
    if n_elements(bQk2R) ne 0 then self.bQk2R = bQk2R
    if n_elements(bQl3R) ne 0 then self.bQl3R = bQl3R

    if n_elements(bEtran4R) ne 0 then self.bEtran4R = bEtran4R
    if n_elements(bEin5R) ne 0 then self.bEin5R = bEin5R


    if n_elements(bSource1R) ne 0 then self.bSource1R = bSource1R

    if n_elements(bSourceHFocus) ne 0 then self.bSourceHFocus = bSourceHFocus

    if n_elements(buttcalculate1) ne 0 then self.buttcalculate1 = buttcalculate1

end;setproperty


;###############################################################################
;
;NAME:
;        crs_resparms_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms_cleanup,id

    widget_control,id,get_uvalue=obj
    obj_destroy,obj

end;crs_resparms_cleanup

;###############################################################################
;
;NAME:
;        crs_resparms::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms::cleanup
    print,'crs_resparms::cleanup'
end;cleanup

;###############################################################################
;
;NAME:
;        crs_resparms::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resparms::init,parent,$
                                    horizontal=horizontal,$
                                    collimatorh=collimatorh,$
                                    collimatorv=collimatorv,$
                                    mosaic=mosaic,$
                                    dspacing=dspacing,$
                                    qetrans = qetrans,$
                                    orient = orient,$
                                    ;
                                    tlb=tlb,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
                                    _ref_extra=extra



    if n_elements(horizontal) ne 1 then horizontal=0



    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)','Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,   3.26627,  2.00013,  1.70576 , 1.79160,  1.14280,  3.35420]


    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}



    if n_elements(collimatorh) ne 4 then collimatorh = [120,60,60,60]

    if n_elements(collimatorv) ne 4 then collimatorv = [120,120,120,120]

    if n_elements(mosaic) ne 4 then mosaic = [10,10,30,30]

    if n_elements(dspacing) ne 2 then dspacing = [3.35416,3.35416]


    if n_elements(instrument_orient) ne 2 then orient=[1,1]

    if n_elements(qetrans) ne 5 then qetrans = [1.0,2.0,0,0,14.7]






    self.parent = parent
    self.tlb = widget_base(parent,/col,$;/row,$
                                title='Resolution/Instrument',$
                                event_func='crs_resparms_event',$
                                pro_set_value='crs_resparms_set_value',$
                                func_get_value='crs_resparms_get_value',$
                                uvalue=uvalue,uname=uname,kill_notify=kill_notify)
    tlb = self.tlb
    wTab=widget_base(tlb,/row,uvalue=self)
    wtab2 = widget_base(tlb,/row,uvalue=self)
    wtab3 = widget_base(tlb,/row,uvalue=self)


    ;THIS IS THE STASH
    tExperiment = widget_base( wTab, title = 'Experiment', /row,$;/column ,$
                                kill_notify='crs_resparms_cleanup',$
                                uvalue=self)

    ;label = widget_label(tExperiment,value='Experiment')



    ;Q/E VALUES
    ;wQetransfer = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
    wQetransfer = widget_base( tExperiment, frame = 3, /base_align_right, /row, xpad = 3 )
    void = widget_label( wQetransfer, value = 'Q/E', /align_center )


    self.bQh1R = cw_field( wQetransfer, /return_events, title = 'H',$
                            value = qetrans[0], /floating, uname = 'Qetransfer_qh', $
                            uvalue = 'qetransfer_qh',xsize=8 )
    self.bQk2R = cw_field( wQetransfer, /return_events, title = 'K',$
                            value = qetrans[1], /floating, uname = 'Qetransfer_qk', $
                            uvalue = 'qetransfer_qk',xsize=8 )
    self.bQl3R = cw_field( wQetransfer, /return_events, title = 'L',$
                            value = qetrans[2], /floating, uname = 'Qetransfer_ql', $
                            uvalue = 'qetransfer_ql',xsize=8 )

    self.bEtran4R = cw_field( wQetransfer, /return_events, title = 'E',$
                            value = qetrans[3], /floating, uname = 'Qetransfer_etran',$
                            uvalue = 'qetransfer_etran',xsize=8 )
    self.bEin5R = cw_field( wQetransfer, /return_events, title = 'Eo',$
                            value = qetrans[4], /floating, uname = 'Qetransfer_ein', $
                            uvalue = 'qetransfer_ein',xsize=8 )


;    self.EFixedChoice = cw_bgroup(wQetransfer,['Ei','Ef'],/exclusive,$
;                                    set_value=0,label_left='Fix',/col,uvalue=[1.0,-1.0])

    EfixedLabel = widget_label(wQetransfer,value='Fix')
    self.EFixedChoice = widget_combobox(wQetransfer,value=['Ei','Ef'],$
                                        editable=0,uvalue=[1.0,-1.0])
                                        ;GT 0 => Ei fixed
                                        ;LT 0 => Ef fixed


;    rightcolumn = widget_base(wTab,/column)



    ;HORIZONTAL COLLIMATORS

;    collimatorbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )
    collimatorbase = widget_base(wtab2, title = 'Horizontal Collimators', /row);column )


    horcol = widget_base(collimatorbase,/col)
    vercol = widget_base(collimatorbase,/col)
    label = widget_label(horcol,value='Horizontal')
    label = widget_label(horcol,value='Collimators (Min)')
    wColh = widget_base( horcol, frame = 3, /base_align_right, /column, xpad = 3 )
    ;void = widget_label( wColh, value = 'Horizontal Collimators', /align_center )
    self.bColh1R = cw_field( wColh, /return_events, title = 'R->M',$;'ALZ',$;tooltip = 'Horizontal Collimation After Source' $
                            value = collimatorh[0], /integer, uname='Colh_alz', $
                            uvalue = 'colh_alz', xsize=4)
    self.bColh2R = cw_field( wColh, /return_events, title = 'M->S',$;'ALM',$
                            value = collimatorh[1], /integer, uname='Colh_alm', $
                            uvalue = 'colh_alm', xsize=4 )
    self.bColh3R = cw_field( wColh, /return_events, title = 'S->A',$;'ALA',$
                            value = collimatorh[2], /integer, uname='Colh_ala', $
                            uvalue = 'colh_ala', xsize=4 )
    self.bColh4R = cw_field( wColh, /return_events, title = 'A->D',$;'AL3',$
                            value = collimatorh[3], /integer, uname='Colh_al3', $
                            uvalue = 'colh_al3', xsize=4 )


    label = widget_label(vercol,value='Vertical')
    label = widget_label(vercol,value='Collimators (Min)')
    wColv = widget_base( vercol, frame = 3, /base_align_right, /column, xpad = 3 )

    ;VERTICAL COLLIMATION

    self.bColv1R = cw_field( wColv, /return_events, title = 'R->M',$;'VBETZ', 
                            xsize=4,$
                            value = collimatorv[0], /integer, uname = 'Colv_vbetz', $
                            uvalue = 'colv_vbetz' )

    self.bColv2R = cw_field( wColv, /return_events, title = 'M->S',$;'VBET1', 
                            xsize=4,$
                            value = collimatorv[1], /integer, uname = 'Colv_vbet1', $
                            uvalue = 'colv_vbet1' )

    self.bColv3R = cw_field( wColv, /return_events, title = 'S->A',$;'VBET2', 
                            xsize=4,$
                            value = collimatorv[2], /integer, uname = 'Colv_vbet2', $
                            uvalue = 'colv_vbet2' )

    self.bColv4R = cw_field( wColv, /return_events, title = 'A->D',$;'VBET3', 
                             xsize=4,$
                             value = collimatorv[3], /integer, uname = 'Colv_vbet3', $
                             uvalue = 'colv_vbet3' )




;    monoandmosaicbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )

    ;SAMPLE AND MONO MOSAICS

;    tMosaic = widget_base(monoandmosaicbase, title = 'Mosaics', /column )
    tMosaic = widget_base(collimatorbase, title = 'Mosaics', /column )
    label = widget_label(tMosaic,value='Mosaics')
    label = widget_label(tMosaic,value='(Min)')
    wMosaic = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )

    ;SAMPLE MOSAICS
    self.bEtash1R = cw_field( wMosaic, /return_events, title = 'SampH',$;'ETASH', 
                            xsize=4,$
                            value = mosaic[0], /integer, uname = 'Mosaic_etash', $
                            uvalue = 'mosaic_etash' )
    self.bEtasv2R = cw_field( wMosaic, /return_events, title = 'SampV',$;'ETASV', 
                            xsize=4,$
                            value = mosaic[1], /integer, uname = 'Mosaic_etasv', $
                            uvalue = 'mosaic_etasv' )
    ;MONO MOSAIC
    self.bEtam3R = cw_field( wMosaic, /return_events, title = 'Mon',$;'ETAM', 
                            xsize=4,$
                            value = mosaic[2], /integer, uname = 'Mosaic_etam', $
                            uvalue = 'mosaic_etam' )
    ;ANALYZER MOSAIC
    self.bEtaa4R = cw_field( wMosaic, /return_events, title = 'Ana',$;'ETAA' , 
                            xsize=4,$
                            value = mosaic[3], /integer, uname = 'Mosaic_etaa', $
                            uvalue = 'mosaic_etaa' )



;    monobase = widget_base(monoandmosaicbase, title = 'Mono/Ana D spacings', /column )
    monobase = widget_base(collimatorbase, title = 'Mono/Ana D spacings', /column )
    label = widget_label(monobase,value='Mono/Ana')
    label = widget_label(monobase,value='D spacings (Ang)')

    wDspacings = widget_base(monobase, frame = 3, /base_align_right, /column, xpad = 3 )

    ;void = widget_label( wDspacings, value = 'Dspacings', /align_center )

    wMDspacings = widget_base(wDspacings, /row)
    self.monoCombo = widget_combobox(wMDspacings,value=monoChoices,editable=0,uvalue=mono_info)
    self.bDm1R = cw_field(   wMDspacings, /return_events, title = 'dm', xsize=6,$
                        value = dspacingchoices[0], /floating, uname = 'Dspacings_dm', $
                        uvalue = mono_info);'Dspacings_dm')

    wADspacings = widget_base(wDspacings, /row)
    self.anaCombo = widget_combobox(wADspacings,value=monoChoices,editable=0,uvalue=mono_info)
    self.bDa2R = cw_field(   wADspacings, /return_events, title = 'da', xsize=6, $
                        value = dspacingchoices[0], /floating, uname = 'Dspacings_da', $
                        uvalue = mono_info);'dspacings_da' )

    self.buttcalculate1=widget_button(monobase, value='Update',uvalue=self,uname='CALCULATE',$
                                      xsize = 100,ysize = 30)
                        ;crs_lk_multibutton(wtab2, value='Calculate',color=256L*255L,uvalue=self,uname='CALCULATE')

    ;tInstrument_orientation = widget_base(wtab2, title = 'Instrument Orientation', /column )
;    label = widget_label(tMosaic,value='Instrument')
;    label = widget_label(tMosaic,value='Orientation')



;MAKE AN UNREALIZED BASE TO HOLD AND HIDE THE RLR/RLL DROPLIST FOR NOW UNTIL
;THE POSSIBLE CHOICES CAN BE PROPERLY DESCRIBED.
dumbase = widget_base()
    ;instrumentorientationbase = widget_base(wtab3,/col)
    instrumentorientationbase = widget_base(dumbase,/col)
    label = widget_label(instrumentorientationbase,value='Instrument Orientation')
    wInstrument_orientation = widget_base(InstrumentOrientationBase, frame = 3,$
                                                /base_align_right,$
                                                /row,$;/column,$
                                                 xpad = 3 )

;-----------------------------------
;HIDE THE NEXT ITEMS
    self.geomchoice = widget_combobox(dumbase,value=['RLR','RLL'],editable=0)
;    self.geomchoice = widget_combobox(wInstrument_orientation,value=['RLR','RLL'],editable=0)


    label = widget_label(wInstrument_orientation,value='epm')
    self.bEpm1R = widget_combobox(wInstrument_orientation,$
                            value = ['1','-1'], uname = 'Instrument_orientation_epm',$
                            uvalue = 'Instrument_orientation_epm' )
    widget_control,self.bEpm1R,set_combobox_select=0

    label = widget_label(wInstrument_orientation,value='ep')
    self.bEp2R = widget_combobox(wInstrument_orientation,$
                            value = ['1','-1'], uname = 'Instrument_orientation_ep',$
                            uvalue = 'Instrument_orientation_ep' )
    widget_control,self.bEp2R,set_combobox_select=0

    ;THE NEXT ITEM SHOULD BE A COMBOBOX

;    tExperiment = widget_base( wtab3, frame = 3, /base_align_right, /row, xpad = 3 )
    tExperiment = widget_base( dumbase, frame = 3, /base_align_right, /row, xpad = 3 )
    
    wSource_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;    void = widget_label( wSource_value, value = 'Source (Thermal(0)/Cold(1))', /align_center )

    subbase = widget_base(wsource_value,/row)
    void = widget_label(subbase, value = 'Source', /align_center )
    self.sourceCombo = widget_combobox(subbase,value=['Thermal','Cold'],uvalue=[0,1]);,title='Source')

    source = 0
;    self.bSource1R = cw_field( wSource_value, /return_events, title = 'Source', xsize=2,$
;                                value = source, /integer, uname = 'Source', uvalue = 'source' )

    wHorizontal_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;    void = widget_label( wHorizontal_value, value = 'Horizontal focusing', /align_center )

    horizontal = 0
;    self.bSourceHFocus = cw_field( wHorizontal_value, /return_events, title = 'Horizontal focus', xsize=2,$
;                    value = horizontal, /integer, uname = 'Horizontal_focusing', uvalue = 'horizontal_focusing' )

    self.horizontalFocusCheckbox = cw_bgroup(wHorizontal_value,['Horizontal Focus'],set_value=0,$
                                                /nonexclusive)

;DESENSITIZE HORIZONTAL FOCUSING UNTIL IT IS IMPLEMENTED.
    widget_control,self.horizontalFocusCheckbox,sensitive=0
;------------------------------------------------------



;    self.bEpm1R = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2,$
;                            value = orient[0], /integer, uname = 'Instrument_orientation_epm',$
;                            uvalue = 'Instrument_orientation_epm' )

;    self.bEp2R = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2,$
;                            value = orient[1], /integer, uname = 'Instrument_orientation_ep',$
;                            uvalue = 'Instrument_orientation_ep' )


    ;buttbase=widget_base(tlb, row=1)
;    buttsize =70
;    self.buttcalculate1=widget_button(wtab2, value='Calculate',$; RM',$
;                                        uname='Calculate',uvalue='calculate',$; xsize=buttsize)
;                                        scr_ysize = 25)

;    self.buttcalculate1=widget_button(wtab3, value='Calculate',uvalue=self,uname='CALCULATE')
;                        ;crs_lk_multibutton(wtab2, value='Calculate',color=256L*255L,uvalue=self,uname='CALCULATE')
    return,1
end;init

;###############################################################################
;
;NAME:
;        crs_resparms__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro crs_resparms__define,class

    resvals = {crs_resparms_values,$
                    bColh1R:0.0,$
                    bColh2R:0.0,$
                    bColh3R:0.0,$
                    bColh4R:0.0,$
                    bColv1R:0.0,$
                    bColv2R:0.0,$
                    bColv3R:0.0,$
                    bColv4R:0.0,$
                    bEtash1R:0.0,$
                    bEtasv2R:0.0,$
                    bEtam3R:0.0,$
                    bEtaa4R:0.0,$
                    bDm1R:0.0,$
                    bDa2R:0.0,$
                    bEpm1R:0.0,$
                    bEp2R:0.0,$
                    bQh1R:0.0,$
                    bQk2R:0.0,$
                    bQl3R:0.0,$
                    bEtran4R:0.0,$
                    bEin5R:0.0,$
                    bSource1R:0,$
                    bSourceHFocus:0,$
                    horizontal:0,$
                    collimatorh:dblarr(4),$
                    collimatorv:dblarr(4),$
                    mosaic:dblarr(4),$
                    dspacing:dblarr(2),$
                    instrument_orient:intarr(2),$
                    qetrans:dblarr(5),$
                    monofixed:0,$
                    anafixed:0,$
                    eifixed:0,$
                    effixed:0,$
                    feief:0}




    class = { crs_resparms,$
                    parent:0L,$
                    tlb:0L,$
                    wTab:0L,$
                    tExperiment:0L,$        ;TAB
                    collimatorbase:0L,$  ; = widget_base(wTab, title = 'Horizontal Collimators', /column )
                    wColh:0L,$
                    bColh1R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALZ' $
                                                    ;tooltip = 'Horizontal Collimation After Source' $
                    bColh2R:0L,$
                    bColh3R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALA' $
                    bColh4R:0L,$    ; = cw_field( wColh, /return_events, title = 'AL3' $
                    tVerticalParams:0L,$    ; = widget_base(wTab, title = 'Vertical Collimators', /column )
                    wColv:0L,$    ; = widget_base( tVerticalParams, frame = 3, /base_align_right, /column, xpad = 3 )
                    bColv1R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4 $
                    bColv2R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET1', xsize=4 $
                    bColv3R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET2', xsize=4 $
                    bColv4R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET3', xsize=4 $

                    tMosaic:0L,$    ; = widget_base(wTab, title = 'Mosaics', /column )
                    wMosaic:0L,$    ; = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEtash1R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4 $

                    bEtasv2R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4 $

                    bEtam3R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4 $

                    bEtaa4R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4$

                    monobase:0L,$    ; = widget_base(wTab, title = 'Monochormator D spacings', /column )
                    wDspacings:0L,$    ; = widget_base( monobase, frame = 3, /base_align_right, /column, xpad = 3 )

                    monoCombo:0L,$      ;MONO
                    anaCombo:0L,$       ;ANALYZER
                    sourceCombo:0L,$    ;THERMAL/COLD

                    EFixedChoice:0L,$   ;i/f
                    geomchoice:0L,$     ;RLR/RLL
                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

                    bDm1R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'dm', xsize=4 $

                    bDa2R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'da', xsize=4 $

                    tInstrument_orientation:0L,$    ; = widget_base(wTab, title = 'Instrument Orientation', /column )
                    wInstrument_orientation:0L,$    ; = widget_base( tInstrument_orientation, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEpm1R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2 $

                    bEp2R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2 $


                    wQetransfer:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bQh1R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qh' $
                    bQk2R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qk' $
                    bQl3R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ql' $

                    bEtran4R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'etran' $
                    bEin5R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ein' $

                    wSource_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSource1R:0L,$    ; = cw_field( wSource_value, /return_events, title = 'Source', xsize=2 $

                    wHorizontal_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSourceHFocus:0L,$    ; = cw_field( wHorizontal_value, /return_events, title = 'Horizontal focus', xsize=2 $


                    buttbase:0L,$    ;=widget_base(tlb, row=1)
                    buttcalculate1:0L, $    ;=widget_button(buttbase, value='Calculate RM' $

                    resvals:resvals}


end;crs_resparms__define



;###############################################################################
;
;NAME:
;        crs_resParms
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function crs_resParms,parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _ref_extra=extra


    obj = obj_new('crs_resparms',parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _extra=extra)

    obj->getproperty,tlb=tlb
    return,tlb


end;crs_resparms
