; $Id$



;THIS IS A STATELESS HOLDER OF THE VALUES NEEDED TO DEFINE A SCAN



pro spurion2_scanparms_test_event,event
    print,tag_names(event)
    print,event
end;spurion2_scanparms_test_event
pro spurion2_scanparms_test,obj=obj

    b=widget_base(xoffset=300,yoffset=300,title='RESOLUTION INPUTS')
    p = spurion2_scanparms(b,$
                        horizontal=0,$
                        collimatorh=[60,60,60,60],$
                        collimatorv=[60,60,60,60],$
                        mosaic=[60,60,60,60],$
                        dspacing=[5,5],$
                        npts = 1,$
                        qerange =dblarr(5),$
                        qetrans = [2.0,3.0,0.0,14.7,6.0],$
                        orient = [1,1],$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj)

    widget_control,b,/realize
    xmanager,'spurion2_scanparms_test',b,/no_block
end;test


function spurion2_scanparms_event,event
;    print,'HEY!!!  spurion2_scanparms_event'
    widget_control,widget_info(event.handler,/child),get_uvalue=self


    event = self->event(event)


    return,event
end;spurion2_scanparms_event


function spurion2_scanparms::event,event


;    print,'spurion2_scanparms::event',event.id

    case event.id of
    self.tab:return,-1
    self.monocombo:begin
        widget_control,self.monocombo,get_uvalue=info
        index = nse_comboindex(self.monocombo)
        widget_control,self.bDM1R,set_value=info.dspacing[index]
        return,-1
    end;monocombo
    self.anacombo:begin
        widget_control,self.anacombo,get_uvalue=info
        index = nse_comboindex(self.anacombo)
        widget_control,self.bDa2R,set_value=info.dspacing[index]
        return,-1
    end;anacombo
    self.bDm1R:begin
        ;SET MONO
        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.anacombo,set_combobox_select=index
        return,-1
    end;monofield
    self.bDa2R:begin
        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.anacombo,set_combobox_select=index
        return,-1
    end;anafield
    self.scantypechooser:begin

        ;EVENT.select = 1
        ;EVENT.value  = INDEX OF THE SELCTED ITEM
        self->setSensitivity,event.value
        self->set_scan_values
        self.scanvals = self->get_values()

        ;SWALLOW EVENT?
        return,-1

    end;scantypechooser
    ;NOW HANDLE THE INDIVIDUAL TEXT BOXES FOR DATA RANGES
    self.nptsfield:begin
        widget_control,self.nptsfield,get_value=npts
;        print,'npts=',npts

        self->set_scan_values
        self->check_scattering_plane,check
        return,-1

    end;.nptsfield
    ;INIT
    self.bQh1RINIT:begin
        ;print,'self.bQh1RINIT'
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQh1RINIT
    self.bQk2RINIT:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQk2RINIT
    self.bQl3RINIT:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQl3RINIT
    self.bEtran4RINIT:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQetran4RINIT
    ;FINAL
    self.bQh1RFINAL:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQh1RFINAL
    self.bQk2RFINAL:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQk2RFINAL
    self.bQl3RFINAL:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQl3RFINAL
    self.bEtran4RFINAL:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQEtrn4RFINAL
    ;STEP
    self.bQh1RSTEP:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQh1RSTEP
    self.bQk2RSTEP:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQk2RSTEP
    self.bQl3RSTEP:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQl3RSTEP
    self.bEtran4RSTEP:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQEtran4RSTEP
    ;CEN
    self.bQh1RCEN:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQh1RCEN
    self.bQk2RCEN:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQk2RCEN
    self.bQl3RCEN:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQl3RCEN
    self.bEtran4RCEN:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;.bQEtran4RCEN
    self.efixedchoice:begin
        self->set_scan_values
        self->check_scattering_plane
        return,-1
    end;efixedchoice
    self.afield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.bfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.cfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.alphafield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.betafield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.gammafield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o1hfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o1kfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o1lfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o2hfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o2kfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    self.o2lfield:begin
        self->check_scattering_plane
        return,-1
    end;afield
    else:
    endcase


    ;CHANGE EVENT.id TO THE cwo's TLB
    event.id = self.tlb
    event.handler = self.parent
    return,event

end;spurion2_scanparms::event
pro spurion2_scanparms::set_scan_values;,cen=cen,step=step,npts=npts


;    if n_elements()

    ;NOW ASSUME THAT OTHER VALUES MIGHT HAVE CHANGED WITHOUT THE
    ;USER HITTING RETURN, SO THE CURRENT VALUES IN THE self.scanvals
    ;MIGHT NOT BE UP TO DATE.
    ;UPDATE NOW!
    ret = self->get_values()
    npts = ret.npts

    ;RESET THESE RANGES IN TERMS OF CEN,STEP,INIT, FINAL

    ;NOW GET THE VALUES FROM scanvals
    qetrans = ret.qetrans
    qerange = ret.qerange

    cen = ret.cen
    step = ret.step
    init = ret.init
    final = ret.final
;print,cen,step




    ;NOW CALCULATE THE VALUES FOR EACH OF THE FIELDS BASED ON THE
    ;VALUES IN scanvals.

    ;NOW GET THE TYPE OF SCAN
    widget_control,self.scantypechooser,get_value=index


    case index of
    0:begin
        ;GET THE INIT AND FINAL VALUES

            init=init
            final=final

        ;print,'in Spurion2::set_Scan_Values'
        ;CALCULATE THE CEN AND STEP VALUES
            cen = (final+init)/2.0
            ;print,'cen=',cen
            if npts eq 1 then step = 0.0*cen else step = (final - init)/(npts-1)
            ;print,'step=',step

        ;UPDATE THE CEN AND STEP WIDGETS
            ;STEP
            widget_control,self.bQh1RSTEP,set_value=step[0]
            widget_control,self.bQk2RSTEP,set_value=step[1]
            widget_control,self.bQl3RSTEP,set_value=step[2]
            widget_control,self.bEtran4RSTEP,set_value=step[3]
            ;CEN
            widget_control,self.bQh1RCEN,set_value=cen[0]
            widget_control,self.bQk2RCEN,set_value=cen[1]
            widget_control,self.bQl3RCEN,set_value=cen[2]
            widget_control,self.bEtran4RCEN,set_value=cen[3]



    end;INIT/FINAL
    1:begin
        ;GET THE INIT AND STEP VALUES
        init = init
        step = step

        ;CALCULATE THE CEN AND FINAL VALUES
        final = init + (npts-1)*step
        cen = (final + init)/2.0

        ;UPDATE THE CEN AND FINAL WIDGETS
            ;CEN
            widget_control,self.bQh1Rcen,set_value=cen[0]
            widget_control,self.bQk2Rcen,set_value=cen[1]
            widget_control,self.bQl3Rcen,set_value=cen[2]
            widget_control,self.bEtran4Rcen,set_value=cen[3]
            ;final
            widget_control,self.bQh1Rfinal,set_value=final[0]
            widget_control,self.bQk2Rfinal,set_value=final[1]
            widget_control,self.bQl3Rfinal,set_value=final[2]
            widget_control,self.bEtran4Rfinal,set_value=final[3]

    end;INIT/STEP
    2:begin

        ;GET THE CEN AND STEP VALUES
        cen = cen
        step = step

        ;CALCULATE THE INIT AND FINAL VALUES
        range = (npts-1)*step
        init = cen - range/2.0
        final = cen + range/2.0


        ;UPDATE THE INIT AND FINAL WIDGETS
        ;UPDATE THE CEN AND FINAL WIDGETS
            ;init
            widget_control,self.bQh1Rinit,set_value=init[0]
            widget_control,self.bQk2Rinit,set_value=init[1]
            widget_control,self.bQl3Rinit,set_value=init[2]
            widget_control,self.bEtran4Rinit,set_value=init[3]
            ;final
            widget_control,self.bQh1Rfinal,set_value=final[0]
            widget_control,self.bQk2Rfinal,set_value=final[1]
            widget_control,self.bQl3Rfinal,set_value=final[2]
            widget_control,self.bEtran4Rfinal,set_value=final[3]

    end;CEN/STEP
    else:
    endcase


    ;FINALLY UPDATE THE ORIGINAL WIDGETS, WHICH ARE INVISIBLE HERE, BUT
    ;ARE USED FOR THE SCAN DEFINITION CURRENTLY.

    ;ORIG CEN WIDGETS
    widget_control,self.bQh1R,set_value=cen[0]
    widget_control,self.bQk2R,set_value=cen[1]
    widget_control,self.bQl3R,set_value=cen[2]
    widget_control,self.bEtran4R,set_value=cen[3]

    range = final - init
    ;ORIG RANGE WIDGETS
    widget_control,self.bQh1RRange,set_value=range[0]
    widget_control,self.bQk2RRange,set_value=range[1]
    widget_control,self.bQl3RRange,set_value=range[2]
    widget_control,self.bEtran4RRange,set_value=range[3]


    ;UPDATE THE scanvals STRUCTURE
    ret = self->get_values()

    ;NOW ASSUMING THIS WORKS, THE scanpoints CLASS WILL HAVE TO BE MODIFIED
    ;TO HANDLE THE NEW PARAMETERIZATION OF THE SCANS.

end;set_scan_values
pro spurion2_scanparms::setMonAna,str
    ;print,'spurion2_scanparms::SETMONANA'
    if n_elements(str) eq 0 then begin
        ;print,'NO  STR'
        dm = 3.35420
        da = 3.35420

        widget_control,self.monocombo,set_combobox_select=0
        widget_control,self.anacombo,set_combobox_select=0

    endif else begin
        ;print,'USING STR'
        dm = str.dm
        da = str.da

        widget_control,self.monocombo,get_uvalue=info
;        print,tag_names(info)
;        print,info
        diffm = abs(info.dspacing - dm)
        diffa = abs(info.dspacing - da)
;print,diffm
;print,diffa
        mindex = where(diffm lt 0.05,mcount)
        aindex = where(diffa lt 0.05,acount)
;        print,acount
;        print,mcount
        if mcount le 2 then begin
            widget_control,self.monocombo,set_combobox_select=mindex[0]
        endif else begin
            widget_control,self.monocombo,set_combobox_select=n_elements(info.mono)-1
        endelse

        if acount le 2 then begin
            widget_control,self.anacombo,set_combobox_select=aindex[0]
        endif else begin
            widget_control,self.anacombo,set_combobox_select=n_elements(info.mono)-1
        endelse


    endelse
;print,'dm=',dm
;print,'da=',da
    widget_control,self.bDm1R,set_value=dm
    widget_control,self.bDa2R,set_value=da

end;setMonAna

pro spurion2_scanparms::set_values,str=str
;help,/traceback
;print,str.da
;print,str.dm
            widget_control,self.scantypechooser,get_value=scantypeorig

            ;SET SCAN TYPE TO CEN-STEP BEFORE MOVING FURTHER
            widget_control,self.scantypechooser,set_value=2

    ;str = {abc:abc,abg:abg,cen:cen,step:step,eif:eif,o1:o1,o2:o2,npts:npts,efix:efix}
            ;STEP
            widget_control,self.bQh1RSTEP,set_value=str.step[0]
            widget_control,self.bQk2RSTEP,set_value=str.step[1]
            widget_control,self.bQl3RSTEP,set_value=str.step[2]
            widget_control,self.bEtran4RSTEP,set_value=str.step[3]
            ;CEN
            widget_control,self.bQh1RCEN,set_value=str.cen[0]
            widget_control,self.bQk2RCEN,set_value=str.cen[1]
            widget_control,self.bQl3RCEN,set_value=str.cen[2]
            widget_control,self.bEtran4RCEN,set_value=str.cen[3]
            ;abc
            widget_control,self.afield,set_value=str.abc[0]
            widget_control,self.bfield,set_value=str.abc[1]
            widget_control,self.cfield,set_value=str.abc[2]
            ;abg
            widget_control,self.alphafield,set_value=str.abg[0]
            widget_control,self.betafield,set_value=str.abg[1]
            widget_control,self.gammafield,set_value=str.abg[2]

            ;eif
            ;help,str.eif
            widget_control,self.efixedchoice,set_value=str.eif
            ;efix
            widget_control,self.bein5r,set_value=str.efix
            ;o1
            widget_control,self.o1hfield,set_value=str.o1[0]
            widget_control,self.o1kfield,set_value=str.o1[1]
            widget_control,self.o1lfield,set_value=str.o1[2]
            ;o2
            widget_control,self.o2hfield,set_value=str.o2[0]
            widget_control,self.o2kfield,set_value=str.o2[1]
            widget_control,self.o2lfield,set_value=str.o2[2]
            ;npts
            widget_control,self.nptsfield,set_value=fix(str.npts)

            self->setMonAna,str


            ;SEND TIMER EVENT TO UPDATE SCAN PARAMETERS
            ;widget_control,self.bQh1RCEN,timer=0

    self->set_scan_values
    ;self->set_sensitivity,2
    widget_control,self.scantypechooser,set_value=scantypeorig

end;set_values

pro spurion2_scanparms::setSensitivity,position



        if n_elements(position) eq 0 then position = 1000
        case position of
        0:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=1
            widget_control,self.bQk2RINIT,sensitive=1
            widget_control,self.bQl3RINIT,sensitive=1
            widget_control,self.bEtran4RINIT,sensitive=1
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=1
            widget_control,self.bQk2RFINAL,sensitive=1
            widget_control,self.bQl3RFINAL,sensitive=1
            widget_control,self.bEtran4RFINAL,sensitive=1
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=0
            widget_control,self.bQk2RSTEP,sensitive=0
            widget_control,self.bQl3RSTEP,sensitive=0
            widget_control,self.bEtran4RSTEP,sensitive=0
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=0
            widget_control,self.bQk2RCEN,sensitive=0
            widget_control,self.bQl3RCEN,sensitive=0
            widget_control,self.bEtran4RCEN,sensitive=0

        end;init/final
        1:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=1
            widget_control,self.bQk2RINIT,sensitive=1
            widget_control,self.bQl3RINIT,sensitive=1
            widget_control,self.bEtran4RINIT,sensitive=1
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=0
            widget_control,self.bQk2RFINAL,sensitive=0
            widget_control,self.bQl3RFINAL,sensitive=0
            widget_control,self.bEtran4RFINAL,sensitive=0
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=1
            widget_control,self.bQk2RSTEP,sensitive=1
            widget_control,self.bQl3RSTEP,sensitive=1
            widget_control,self.bEtran4RSTEP,sensitive=1
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=0
            widget_control,self.bQk2RCEN,sensitive=0
            widget_control,self.bQl3RCEN,sensitive=0
            widget_control,self.bEtran4RCEN,sensitive=0
        end;init/step
        2:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=0
            widget_control,self.bQk2RINIT,sensitive=0
            widget_control,self.bQl3RINIT,sensitive=0
            widget_control,self.bEtran4RINIT,sensitive=0
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=0
            widget_control,self.bQk2RFINAL,sensitive=0
            widget_control,self.bQl3RFINAL,sensitive=0
            widget_control,self.bEtran4RFINAL,sensitive=0
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=1
            widget_control,self.bQk2RSTEP,sensitive=1
            widget_control,self.bQl3RSTEP,sensitive=1
            widget_control,self.bEtran4RSTEP,sensitive=1
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=1
            widget_control,self.bQk2RCEN,sensitive=1
            widget_control,self.bQl3RCEN,sensitive=1
            widget_control,self.bEtran4RCEN,sensitive=1
        end;cen/step
        else:
        endcase
end;spurion2_scanparms::setSensitivity
;#######################################################
pro spurion2_scanparms::check_scattering_plane,check
    ;print,'TEST'
    ;help,/traceback
            widget_control,self.bQh1RINIT,get_value=h
            widget_control,self.bQk2RINIT,get_value=k
            widget_control,self.bQl3RINIT,get_value=l
            widget_control,self.bEtran4RINIT,get_value=e
            widget_control,self.bQh1RSTEP,get_value=hs
            widget_control,self.bQk2RSTEP,get_value=ks
            widget_control,self.bQl3RSTEP,get_value=ls
            widget_control,self.bEtran4RSTEP,get_value=es
            widget_control,self.nptsfield,get_value=npts

if npts eq 0 then npts = 1
    h = findgen(npts)*hs + h
    k = findgen(npts)*ks + k
    l = findgen(npts)*ls + l
    e = findgen(npts)*es + e

    widget_control,self.o1hfield,get_value=o1h
    widget_control,self.o1kfield,get_value=o1k
    widget_control,self.o1lfield,get_value=o1l
    widget_control,self.o2hfield,get_value=o2h
    widget_control,self.o2kfield,get_value=o2k
    widget_control,self.o2lfield,get_value=o2l
    o1 = [o1h,o1k,o1l]
    o2 = [o2h,o2k,o2l]


    check = 1   ;1 is ok 0 is bad.
    for i=0,npts-1 do begin
        q = [h[i],k[i],l[i]]
        v = dotp(q,crossp(o1,o2))
        ;print,q,o1,o2,v
        if v ne 0 then check--
    endfor;i

    if check lt 1 then check= 0;void = dialog_message('Q not in Scattering Plane.')

    ;if check lt 1 then void = dialog_message('Unphysical value, Q not in scattering plane.')

end;check_scattering_plane

pro spurion2_scanparms::check_values

    changesMade = 0

    changesMade += self->checkEFixed()
    ;changesMade += self->checkQClosed()

    if changesMade ne 0 then void = dialog_message('Changed bad values in resolution parameters')

end;check_values


function spurion2_scanparms::checkEFixed
    changesMade = 0
    ;CHECK Efixed
    widget_control,self.bEtran4R,get_value=Etrans
    widget_control,self.bEin5R,get_value=Efixed
    widget_control,self.EFixedChoice,get_value=choice,get_uvalue=sign
;print,'spurion2_scanparms::checkEFixed'
;print,'Etrans=',Etrans
;print,'Efixed=',Efixed
;print,'sign=',sign
    if Efixed eq 0 then begin
        Efixed = 14.7
        changesMade += 1
    endif


    if Efixed lt 0 then begin
        Efixed = abs(Efixed)
        widget_control,self.bEin5R,set_value=Efixed
        changesMade = 1
    endif


    if choice eq 0 then begin
        Ei = Efixed    ;EA
        Ef = Ei - Etrans
        if Ef le 0 then begin
            Etrans = Ei - 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif

    endif else begin
        Ef = Efixed    ;EM
        Ei = Etrans + Ef
        if Ei le 0 then begin
            Etrans = Ef + 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif
    endelse

    return,changesMade
end;checkEFixed

;function spurion2_scanparms::checkQClosed,check
pro spurion2_scanparms::checkQClosed,check
    vals = self->get_values()

    a = vals.a
    b = vals.b
    c = vals.c
    alpha = vals.alpha
    beta = vals.beta
    gamma = vals.gamma
    h = vals.CEN[0]
    k = vals.CEN[1]
    l = vals.CEN[2]
    E = vals.CEN[3]
    npts = vals.npts

    o1h = vals.o1h
    o1k = vals.o1k
    o1l = vals.o1l
    o2h = vals.o2h
    o2k = vals.o2k
    o2l = vals.o2l
    Eifselect = vals.eif
    Efix = vals.efix

    eif = vals.eif
    Q = [h,k,l]
    ei = vals.ei
    ef = vals.ef

    o1 = [o1h,o1k,o1l]
    o2 = [o2h,o2k,o2l]

    Qxy = hkl_to_Qxy(h,k,l,a,b,c,alpha,beta,gamma,o1,o2,$
                     invang=invang,hklunits=hklunits,zhat_hkl=zhat_hkl)


    check = closed_scat_triangle(Ei,Ef,Qxy)
    ;if check lt 1 then void = dialog_message('Unphysical value: Scattering triangle does not close.')


    changesMade = 0

;;;;;;    ;************************************************
;;;;;;    ;* definition of constants         *
;;;;;;    ;* E = 2.072 k^2 (E:meV, k:AA^-1)     *
;;;;;;    ;************************************************
;;;;;;    f   = 1./2.072
;;;;;;
;;;;;;
;;;;;;    widget_control,self.bEtran4R,get_value=Etrans
;;;;;;    widget_control,self.bEin5R,get_value=Efixed
;;;;;;    widget_control,self.EFixedChoice,get_value=choice,get_uvalue=sign
;;;;;;
;;;;;;
;;;;;;    ;*************************
;;;;;;    ;* calculate ei,ef,ki,kf *
;;;;;;    ;* based on efix & feief *
;;;;;;    ;*************************
;;;;;;    aom =   f*etran     ; energy transfer in units AA^-2
;;;;;;
;;;;;;    if choice eq 0 then begin
;;;;;;        ;   *************************
;;;;;;        ;   * fixed incident energy *
;;;;;;        ;   *************************
;;;;;;        ei =   efix
;;;;;;        ef =   efix-etran
;;;;;;    endif   else  begin
;;;;;;        ;   **********************
;;;;;;        ;   * fixed final energy *
;;;;;;        ;   **********************
;;;;;;        ei =   efix+etran
;;;;;;        ef =   efix
;;;;;;    endelse
;;;;;;
;;;;;;    ki  =    sqrt(f*ei)
;;;;;;    kf  =    sqrt(f*ef)
;;;;;;    alam    =  ki/kf
;;;;;;
;;;;;;
;;;;;;    ;****************************************************************
;;;;;;    ;* various trigonometric expressions from        *
;;;;;;    ;* scattering triangle  :    ki=kf-Q              *
;;;;;;    ;* (34) be = cos(2theta_s)  ;   al = sin(2theta_s)    *
;;;;;;    ;*  sints = sin(theta_s)               *
;;;;;;    ;* (29) psi=angle between ki and -Q ;   aom=ki^2-kf^2     *
;;;;;;    ;*  sa = sin(psi)       ; sb = cos(psi)     *
;;;;;;    ;*      b  = cos(2theta_s+psi)  ;    aa = sin(2theta_s+psi)     *
;;;;;;    ;****************************************************************
;;;;;;    be  =    (ki^2+kf^2-q^2)/(2*ki*kf)  ; q^2=ki^2+kf^2-2ki*kf*be
;;;;;;
;;;;;;
;;;;;;    if be^2 gt 1 then begin
;;;;;;        ;------------------------------------
;;;;;;        ;| Scattering triangle cannot close |
;;;;;;        ;------------------------------------
;;;;;;
;;;;;;         closed = 0
;;;;;;         r0 =   0
;;;;;;         changesMade = 1
;;;;;;    endif
;;;;;;
;;;;;;

;    return,check;changesMade
end;checkQClose





function spurion2_scanparms::get_values,reselps=reselps,str=str

    if n_elements(reselps) eq 0 then reselps = 0
    self->check_values

    ;GET THE VALUES FROM ALL THE WIDGETS WITH VALUES AND
    ;RETURN THEM IN A STRUCTURE.
    widget_control,self.bColh1R,get_value=bColh1R
    widget_control,self.bColh2R,get_value=bColh2R
    widget_control,self.bColh3R,get_value=bColh3R
    widget_control,self.bColh4R,get_value=bColh4R

    widget_control,self.bColv1R,get_value=bColv1R
    widget_control,self.bColv2R,get_value=bColv2R
    widget_control,self.bColv3R,get_value=bColv3R
    widget_control,self.bColv4R,get_value=bColv4R

    widget_control,self.bEtash1R,get_value=bEtash1R
    widget_control,self.bEtasv2R,get_value=bEtasv2R
    widget_control,self.bEtam3R,get_value=bEtam3R
    widget_control,self.bEtaa4R,get_value=bEtaa4R

    widget_control,self.bDm1R,get_value=bDm1R
    widget_control,self.bDa2R,get_value=bDa2R

    widget_control,self.bEpm1R,get_value=bEpm1R
    widget_control,self.bEp2R,get_value=bEp2R

    ;THESE SHOULD BE SET ELSEWHERE.
    widget_control,self.bQh1R,get_value=bQh1R
    widget_control,self.bQk2R,get_value=bQk2R
    widget_control,self.bQl3R,get_value=bQl3R

    widget_control,self.bEtran4R,get_value=bEtran4R
    widget_control,self.bEin5R,get_value=bEin5R

    widget_control,self.bQh1RRange,get_value=bQh1RRange
    widget_control,self.bQk2RRange,get_value=bQk2RRange
    widget_control,self.bQl3RRange,get_value=bQl3RRange
    widget_control,self.bEtran4RRange,get_value=bEtran4RRange

    widget_control,self.nptsfield,get_value=npts
    if npts le 0 then npts = 1

    ;CEN
    widget_control,self.bQh1RCEN,get_value=bQh1RCEN
    widget_control,self.bQk2RCEN,get_value=bQk2RCEN
    widget_control,self.bQl3RCEN,get_value=bQl3RCEN
    widget_control,self.bEtran4RCEN,get_value=bEtran4RCEN

    ;STEP
    widget_control,self.bQh1RSTEP,get_value=bQh1RSTEP
    widget_control,self.bQk2RSTEP,get_value=bQk2RSTEP
    widget_control,self.bQl3RSTEP,get_value=bQl3RSTEP
    widget_control,self.bEtran4RSTEP,get_value=bEtran4RSTEP

    ;INIT
    widget_control,self.bQh1RINIT,get_value=bQh1RINIT
    widget_control,self.bQk2RINIT,get_value=bQk2RINIT
    widget_control,self.bQl3RINIT,get_value=bQl3RINIT
    widget_control,self.bEtran4RINIT,get_value=bEtran4RINIT

    ;FINAL
    widget_control,self.bQh1RFINAL,get_value=bQh1RFINAL
    widget_control,self.bQk2RFINAL,get_value=bQk2RFINAL
    widget_control,self.bQl3RFINAL,get_value=bQl3RFINAL
    widget_control,self.bEtran4RFINAL,get_value=bEtran4RFINAL



;    print,'cwo_resparms::getvalues'
;    print,'bQh1RRange=',bQh1RRange
;    print,'bQk2RRange=',bQk2RRange
;    print,'bQl3RRange=',bQl3RRange
;    print,'bEtran4RRange=',bEtran4RRange
;    print,'npts=',npts

    widget_control,self.EFixedChoice,get_value=val,get_uvalue=uval
    sign = uval[val]

    ;SET ENERGY SIGN BASED ON CHECKBOX CHOICE.  reselps REQUIRES NEGATIVE ENERGY VALUE IF Ef Fixed, Pos for Ei
    bEin5R = sign*abs(bEin5R)

    widget_control,self.sourceCombo,get_value=val,get_uvalue=uval
    bSource1R = uval[nse_comboindex(self.SourceCombo)]
;    print,'bSourceR from combo=',bSource1R

;    widget_control,self.bSource1R,get_value=bSource1R
;    print,'bSourceR from field=',bSource1R


;                    geomchoice:0L,$     ;RLR/RLL
;                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

    widget_control,self.horizontalFocusCheckbox,get_value=bSourceHFocus
    ;print,'HorizontalFocus =',bSourceHFocus

;    widget_control,self.bSourceHFocus,get_value=bSourceHFocus
;    print,'HorizontalFocus =',bSourceHFocus



    ret = self.scanvals

    ret.bColh1R=bColh1R
    ret.bColh2R=bColh2R
    ret.bColh3R=bColh3R
    ret.bColh4R=bColh4R
    ret.bColv1R=bColv1R
    ret.bColv2R=bColv2R
    ret.bColv3R=bColv3R
    ret.bColv4R=bColv4R
    ret.bEtash1R=bEtash1R
    ret.bEtasv2R=bEtasv2R
    ret.bEtam3R=bEtam3R
    ret.bEtaa4R=bEtaa4R
    ret.bDm1R=bDm1R
    ret.bDa2R=bDa2R
    ret.bEpm1R=bEpm1R
    ret.bEp2R=bEp2R
    ret.bQh1R=bQh1R
    ret.bQk2R=bQk2R
    ret.bQl3R=bQl3R
    ret.bEtran4R=bEtran4R
    ret.bEin5R=bEin5R



    ret.bSource1R=bSource1R
    ret.bSourceHFocus=bSourceHFocus

    ret.bQh1RRange=bQh1RRange
    ret.bQk2RRange=bQk2RRange
    ret.bQl3RRange=bQl3RRange
    ret.bEtran4RRange=bEtran4RRange
    ret.npts=npts

    ;CEN
    ret.bQh1RCEN=bQh1RCEN
    ret.bQk2RCEN=bQk2RCEN
    ret.bQl3RCEN=bQl3RCEN
    ret.bEtran4RCEN=bEtran4RCEN

    ;STEP
    ret.bQh1RSTEP=bQh1RSTEP
    ret.bQk2RSTEP=bQk2RSTEP
    ret.bQl3RSTEP=bQl3RSTEP
    ret.bEtran4RSTEP=bEtran4RSTEP

    ;INIT
    ret.bQh1RINIT=bQh1RINIT
    ret.bQk2RINIT=bQk2RINIT
    ret.bQl3RINIT=bQl3RINIT
    ret.bEtran4RINIT=bEtran4RINIT

    ;FINAL
    ret.bQh1RFINAL=bQh1RFINAL
    ret.bQk2RFINAL=bQk2RFINAL
    ret.bQl3RFINAL=bQl3RFINAL
    ret.bEtran4RFINAL=bEtran4RFINAL



;    print,'cwo_resparms::getvalues'
;    print,'ret.bQh1RRange=',ret.bQh1RRange
;    print,'ret.bQk2RRange=',ret.bQk2RRange
;    print,'ret.bQl3RRange=',ret.bQl3RRange
;    print,'ret.bEtran4RRange=',ret.bEtran4RRange
;    print,'ret.npts=',ret.npts



    ;MORE FAMILIAR NAMES AND GROUPINGS:
    ret.horizontal=bSourceHFocus
    ret.collimatorh=[bColh1R,bColh2R,bColh3R,bColh4R]
    ret.collimatorv=[bColv1R,bColv2R,bColv3R,bColv4R]
    ret.mosaic=[bEtash1R,bEtasv2R,bEtam3R,bEtaa4R]
    ret.dspacing=[bDm1R,bDa2R]
    ret.instrument_orient=[bEpm1R,bEp2R]
    ret.qetrans=[bQh1R,bQk2R,bQl3R,bEtran4R,bEin5R]

    ;RESET THESE RANGES IN TERMS OF CEN,STEP,INIT, FINAL
    ret.qetrans=[bQh1RCEN,bQk2RCEN,bQl3RCEN,bEtran4RCEN,bEin5R]

    ret.qerange=[bQh1RRange,bQk2RRange,bQl3RRange,bEtran4RRange,0.0]
    ret.cen     = [bQh1RCEN,bQk2RCEN,bQl3RCEN,bEtran4RCEN,0.0]
    ret.step    = [bQh1RSTEP,bQk2RSTEP,bQl3RSTEP,bEtran4RSTEP,0.0]
    ret.init = [bQh1RINIT,bQk2RINIT,bQl3RINIT,bEtran4RINIT,0.0]
    ret.final   = [bQh1RFINAL,bQk2RFINAL,bQl3RFINAL,bEtran4RFINAL,0.0]


    widget_control,self.afield,get_value=a
    widget_control,self.bfield,get_value=b
    widget_control,self.cfield,get_value=c

    widget_control,self.alphafield,get_value=alpha
    widget_control,self.betafield,get_value=beta
    widget_control,self.gammafield,get_value=gamma

    widget_control,self.o1hfield,get_value=o1h
    widget_control,self.o1kfield,get_value=o1k
    widget_control,self.o1lfield,get_value=o1l

    widget_control,self.o2hfield,get_value=o2h
    widget_control,self.o2kfield,get_value=o2k
    widget_control,self.o2lfield,get_value=o2l

    widget_control,self.EfixedChoice,get_value=Eif
;    print,'IN spurion2_scanparms:'
;    print,'Eif=',Eif


    if reselps eq 0 then ret.Efix = abs(bEin5R) else ret.Efix = bEin5R
;    ret.Efix_reselps = bEin5R
    ret.E = bEtran4RCEN
    ret.Eif = Eif

    if eif eq 0 then begin
        ret.Ei = ret.Efix
        ret.Ef = ret.Ei - ret.E
    endif else begin
        ret.Ef = ret.Efix
        ret.Ei = ret.E + ret.Ef
    endelse

;    print,ret.ei
;    print,ret.ef


;    ret.Ei = Ei
;    ret.Ef = Ef

    ret.a = a
    ret.b = b
    ret.c = c
    ret.alpha = alpha
    ret.beta  = beta
    ret.gamma = gamma
    ret.o1h = o1h
    ret.o1k = o1k
    ret.o1l = o1l
    ret.o2h = o2h
    ret.o2k = o2k
    ret.o2l = o2l
    ret.abc = [a,b,c]
    ret.abg = [alpha,beta,gamma]
    ret.o1  = [o1h,o1k,o1l]
    ret.o2  = [o2h,o2k,o2l]

;help,/traceback
;print,ret.dspacing
    str = {abc:ret.abc,$
           abg:ret.abg,$
           cen:ret.cen[0:3],$
           step:ret.step[0:3],$
           eif:ret.eif,$
           dm:ret.bDm1R,$
           da:ret.bDa2R,$
           o1:ret.o1,$
           o2:ret.o2,$
           npts:ret.npts,$
           efix:ret.efix,$
           fn:'USER-DEFINED SCAN',$
           data:fltarr(ret.npts),$
           newbt7:0,$
           initfinal:0,$
           censtep:1,$  ;str ALWAYS DEFINES SCANS IN TERMS OF cen/step, BUT
                                    ;THESE FLAGS TELL HOW A FILE DEFINED IT ORIGINALLY
                                    ;HERE THERE IS NO FILE.
           initstep:0,$
           complete:1,$
           noscan:1}


    if reselps eq 0 then self.scanvals = ret

    return,ret

end;get_values


pro spurion2_scanparms_set_value,id,value
    print,'set_value'
end;spurion2_scanparms_set_value
pro spurion2_scanparms_get_value,id,val=val
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj

    val = obj->get_values()

end;spurion2_scanparms_get_value
function spurion2_scanparms::get_q

    return,self.scanvals.qetrans[0:2]
end;get_qe

pro spurion2_scanparms::set_Q,q,qh=qh,qk=qk,ql=ql

    ;USE THIS METHOD WHEN Q IS CHANGED IN SOME OTHER FIELD, SUCH AS cwo_latparms OR OTHERS.

    if n_elements(Q) ge 3 then begin
        qh = q[0]
        qk = q[1]
        ql = q[2]
    endif

    if n_elements(qh) ne 0 then widget_control,self.bQh1R,set_value=qh
    if n_elements(qk) ne 0 then widget_control,self.bQk2R,set_value=qk
    if n_elements(ql) ne 0 then widget_control,self.bQl3R,set_value=ql

    self.scanvals = self->get_values()

end;




pro spurion2_scanparms::getproperty,  parent =  parent,$
                                tlb =  tlb,$
                                bColh1R =  bColh1R,$
                                bColh2R =  bColh2R,$
                                bColh3R =  bColh3R,$
                                bColh4R =  bColh4R,$
                                bColv1R =  bColv1R,$
                                bColv2R =  bColv2R,$
                                bColv3R =  bColv3R,$
                                bColv4R =  bColv4R,$
                                bEtash1R =  bEtash1R,$
                                bEtasv2R =  bEtasv2R,$
                                bEtam3R =  bEtam3R,$
                                bEtaa4R =  bEtaa4R,$
                                bDm1R =  bDm1R,$
                                bDa2R =  bDa2R,$
                                bEpm1R =  bEpm1R,$
                                bEp2R =  bEp2R,$
                                bQh1R =  bQh1R,$
                                bQk2R =  bQk2R,$
                                bQl3R =  bQl3R,$
                                bEtran4R =  bEtran4R,$
                                bEin5R =  bEin5R,$
                                bSource1R =  bSource1R,$
                                bSourceHFocus =  bSourceHFocus,$
                                buttcalculate1 =  buttcalculate1,$
                                _ref_extra=extra


    if arg_present(parent) ne 0 then parent = self.parent
    if arg_present(tlb) gt 0 then tlb = self.tlb

    if arg_present(bColh1R) ne 0 then bColh1R = self.bColh1R
    if arg_present(bColh2R) ne 0 then bColh2R = self.bColh2R
    if arg_present(bColh3R) ne 0 then bColh3R = self.bColh3R
    if arg_present(bColh4R) ne 0 then bColh4R = self.bColh4R

    if arg_present(bColv1R) ne 0 then bColv1R = self.bColv1R
    if arg_present(bColv2R) ne 0 then bColv2R = self.bColv2R
    if arg_present(bColv3R) ne 0 then bColv3R = self.bColv3R
    if arg_present(bColv4R) ne 0 then bColv4R = self.bColv4R

    if arg_present(bEtash1R) ne 0 then bEtash1R = self.bEtash1R
    if arg_present(bEtasv2R) ne 0 then bEtasv2R = self.bEtasv2R
    if arg_present(bEtam3R) ne 0 then bEtam3R = self.bEtam3R
    if arg_present(bEtaa4R) ne 0 then bEtaa4R = self.bEtaa4R


    if arg_present(bDm1R) ne 0 then bDm1R = self.bDm1R
    if arg_present(bDa2R) ne 0 then bDa2R = self.bDa2R


    if arg_present(bEpm1R) ne 0 then bEpm1R = self.bEpm1R
    if arg_present(bEp2R) ne 0 then bEp2R = self.bEp2R


    if arg_present(bQh1R) ne 0 then bQh1R = self.bQh1R
    if arg_present(bQk2R) ne 0 then bQk2R = self.bQk2R
    if arg_present(bQl3R) ne 0 then bQl3R = self.bQl3R

    if arg_present(bEtran4R) ne 0 then bEtran4R = self.bEtran4R
    if arg_present(bEin5R) ne 0 then bEin5R = self.bEin5R


    if arg_present(bSource1R) ne 0 then bSource1R = self.bSource1R

    if arg_present(bSourceHFocus) ne 0 then bSourceHFocus = self.bSourceHFocus
    if arg_present(buttcalculate1) ne 0 then begin
        buttcalculate1 = self.buttcalculate1
    endif



end;spurion2_scanparms

pro spurion2_scanparms::setproperty,parent=parent,_ref_extra=extra

    if n_elements(parent) ne 0 then self.parent=parent
    if n_elements(tlb) ne 0 then self.tlb = tlb

    if n_elements(bColh1R) ne 0 then self.bColh1R = bColh1R
    if n_elements(bColh2R) ne 0 then self.bColh2R = bColh2R
    if n_elements(bColh3R) ne 0 then self.bColh3R = bColh3R
    if n_elements(bColh4R) ne 0 then self.bColh4R = bColh4R

    if n_elements(bColv1R) ne 0 then self.bColv1R = bColv1R
    if n_elements(bColv2R) ne 0 then self.bColv2R = bColv2R
    if n_elements(bColv3R) ne 0 then self.bColv3R = bColv3R
    if n_elements(bColv4R) ne 0 then self.bColv4R = bColv4R

    if n_elements(bEtash1R) ne 0 then self.bEtash1R = bEtash1R
    if n_elements(bEtasv2R) ne 0 then self.bEtasv2R = bEtasv2R
    if n_elements(bEtam3R) ne 0 then self.bEtam3R = bEtam3R
    if n_elements(bEtaa4R) ne 0 then self.bEtaa4R = bEtaa4R


    if n_elements(bDm1R) ne 0 then self.bDm1R = bDm1R
    if n_elements(bDa2R) ne 0 then self.bDa2R = bDa2R


    if n_elements(bEpm1R) ne 0 then self.bEpm1R = bEpm1R
    if n_elements(bEp2R) ne 0 then self.bEp2R = bEp2R


    if n_elements(bQh1R) ne 0 then self.bQh1R = bQh1R
    if n_elements(bQk2R) ne 0 then self.bQk2R = bQk2R
    if n_elements(bQl3R) ne 0 then self.bQl3R = bQl3R

    if n_elements(bEtran4R) ne 0 then self.bEtran4R = bEtran4R
    if n_elements(bEin5R) ne 0 then self.bEin5R = bEin5R


    if n_elements(bSource1R) ne 0 then self.bSource1R = bSource1R

    if n_elements(bSourceHFocus) ne 0 then self.bSourceHFocus = bSourceHFocus

    if n_elements(buttcalculate1) ne 0 then self.buttcalculate1 = buttcalculate1

end;setproperty


pro spurion2_scanparms_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;spurion2_scanparms_cleanup

pro spurion2_scanparms::cleanup
    print,'spurion2_scanparms::cleanup'
end;cleanup



pro spurion2_scanparms::createScanWidgets,fronttab,qetrans,qerange,npts


    if n_elements(npts) eq 0 then npts = 1

    if n_elements(qerange) eq 4 then qerange = [qerange,0.0]
    if n_elements(qerange) lt 4 then qerange = dblarr(5)

    if n_elements(qetrans) ne 5 then qetrans = [2.0,1.0,0.0,0.0,14.7]


    tExperiment = widget_base( fronttab, title = 'Experiment', /column ,$
                                uvalue=self)

    label = widget_label(tExperiment,value='Experiment')

    ;Q/E VALUES
    wQetransfer = widget_base( tExperiment, frame = 3, /base_align_right, /row);/column, xpad = 3 )

    wQetransfercol = widget_base(wQetransfer,/col)
    row1 = widget_base(wQetransfercol,/row)
    row2 = widget_base(wQetransfercol,/row)
    row3 = widget_base(wQetransfercol,/row)
    row4 = widget_base(wQetransfercol,/row)
    self.scantypechooser = cw_bgroup(row1,['Initial/Final','Initial/Step','Center/Step'],$
                                       set_value=0,/exclusive,/row,frame=1)

    col0 = widget_base(row2);,/col)
    col3 = widget_base(row2,/col)
    col4 = widget_base(row2,/col)
    col1 = widget_base(row2,/col)
    col2 = widget_base(row2,/col)

    ;Invisiblebase
    invisible = widget_base()   ;DON'T REALIZE THIS ONE.  IT JUST ALLOWS THE WIDGETS TO BE
                                ;ACCESSIBLE BY PROGRAM FOR NOW WITHOUT BEING SEEN UNTIL
                                ;THEIR FUNCTIONALITY CAN BE REMOVED.
    col5 = widget_base(invisible,/col,sensitive=0 )
    col6 = widget_base(invisible,/col,sensitive=0 )

    texperimentBottom = widget_base(tExperiment,/row)
    qefixbase = widget_base(tExperimentBottom,/col)

    label = widget_label(col0,value='Options')
    label = widget_label(col0,value='qh [rlu]',yoffset=27)
    label = widget_label(col0,value='qk [rlu]',yoffset=54)
    label = widget_label(col0,value='ql [rlu]',yoffset=81)
    label = widget_label(col0,value='E  [meV]',yoffset=108)


    ;CEN    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
        cenlabel = widget_label(col1,value='CEN')
        self.bQh1RCen = cw_field( col1, /all_events,$;/return_events,$
                                title = 'qh',$
                                value = qetrans[0], /floating, $
                                uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qhcen',xsize=7 )
        self.bQk2RCen = cw_field( col1, /all_events,$;/return_events,$
                                title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qkcen',xsize=7)

        self.bQl3RCen = cw_field( col1, /all_events,$;/return_events,$
                                title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qlcen',xsize=7 )

        self.bEtran4RCen = cw_field( col1, /all_events,$;/return_events,$
                                title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_etrancen',xsize=7 )

    ;STEP
        steplabel = widget_label(col2,value='STEP')
        self.bQh1RStep = cw_field( col2, /all_events,$;/return_events,$
                                title = 'qh',$
                                value = 0.0, /floating, uname = 'Qetransfer_qhstep', $
                                uvalue = 'qetransfer_qhstep',xsize=7 )
        self.bQk2RStep = cw_field( col2, /all_events,$;/return_events,$
                                title = 'qk',$
                                value = 0.0, /floating, uname = 'Qetransfer_qkstep', $
                                uvalue = 'qetransfer_qkstep',xsize=7 )
        self.bQl3RStep = cw_field( col2, /all_events,$;/return_events,$
                                title = 'ql',$
                                value = 0.0, /floating, uname = 'Qetransfer_qlstep', $
                                uvalue = 'qetransfer_qlstep',xsize=7 )
        self.bEtran4RStep = cw_field( col2, /all_events,$;/return_events,$
                                title = 'et',$
                                value = 0.0, /floating, uname = 'Qetransfer_etranstep', $
                                uvalue = 'qetransfer_etranstep',xsize=7 )
    ;INIT
        initlabel = widget_label(col3,value='INIT')
        self.bQh1RInit = cw_field( col3, /all_events,$;/return_events,$
                                title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qhInit', $
                                uvalue = 'qetransfer_qhInit',xsize=7 )
        self.bQk2RInit = cw_field( col3, /all_events,$;/return_events,$
                                title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qkInit', $
                                uvalue = 'qetransfer_qkInit',xsize=7 )
        self.bQl3RInit = cw_field( col3, /all_events,$;/return_events,$
                                title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qlInit', $
                                uvalue = 'qetransfer_qlInit',xsize=7 )
        self.bEtran4RInit = cw_field( col3, /all_events,$;/return_events,$
                                title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etranInit', $
                                uvalue = 'qetransfer_etranInit',xsize=7 )

    ;FINAL
        finallabel = widget_label(col4,value='FINAL')
        self.bQh1RFinal = cw_field( col4, /all_events,$;/return_events,$
                                title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qhFinal', $
                                uvalue = 'qetransfer_qhFinal',xsize=7 )
        self.bQk2RFinal = cw_field( col4, /all_events,$;/return_events,$
                                title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qkFinal', $
                                uvalue = 'qetransfer_qkFinal',xsize=7 )
        self.bQl3RFinal = cw_field( col4, /all_events,$;/return_events,$
                                title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qlFinal', $
                                uvalue = 'qetransfer_qlFinal',xsize=7 )
        self.bEtran4RFinal = cw_field( col4, /all_events,$;/return_events,$
                                title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etranFinal', $
                                uvalue = 'qetransfer_etranFinal',xsize=7 )



    ;ORIGINAL, SAME AS CEN (ON HIDDEN BASE)
        origlabel = widget_label(col5,value='ORIG')
        self.bQh1R = cw_field( col5, /return_events, title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qh', $
                                uvalue = 'qetransfer_qh',xsize=7 )
        self.bQk2R = cw_field( col5, /return_events, title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qk', $
                                uvalue = 'qetransfer_qk',xsize=7 )
        self.bQl3R = cw_field( col5, /return_events, title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_ql', $
                                uvalue = 'qetransfer_ql',xsize=7 )

        self.bEtran4R = cw_field( col5, /return_events, title = 'etran',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etran',$
                                uvalue = 'qetransfer_etran',xsize=7 )

;print,'SetupScanWidgets:    Efixed Creation'
    ;FIXED ENERGY AND NPTS
        self.bEin5R = cw_field( row3, /return_events, title = 'Efixed',$
                                value = qetrans[4], /floating, uname = 'Qetransfer_ein', $
                                uvalue = 'qetransfer_ein',xsize=7 )

        self.EFixedChoice = cw_bgroup(row3,['Ei','Ef'],/exclusive,$
                                        set_value=0,label_left='Fix',$
                                        /row,uvalue=[1.0,-1.0],$
                                        /no_release,$
                                        frame = 1)

;print,'self.EFixedChoice=',self.EFixedChoice
                                        ;GT 0 => Ei fixed
                                        ;LT 0 => Ef fixed

        self.nptsfield = cw_field(row3,/all_events,$;/return_events,$
                                title='npts',$
                                value = npts, /integer, uname = 'SCAN_NPTS',$
                                uvalue = 'SCAN_NPTS',xsize=4)



    ;RANGES    (ON HIDDEN BASE)
        rangelabel = widget_label(col6,value='RANGE')
        self.bQh1RRange = cw_field( col6, /all_events,$;/return_events,$
                                title = 'qh',$;Range',$
                                value = float(qerange[0]), /floating, uname = 'Qetransfer_qhRange', $
                                uvalue = 'qetransfer_qhRange',xsize=7 )
        self.bQk2RRange = cw_field( col6, /all_events,$;/return_events,$
                                title = 'qk',$;Range',$
                                value = float(qerange[1]), /floating, uname = 'Qetransfer_qkRange', $
                                uvalue = 'qetransfer_qkRange',xsize=7 )
        self.bQl3RRange = cw_field( col6, /all_events,$;/return_events,$
                                title = 'ql',$;Range',$
                                value = float(qerange[2]), /floating, uname = 'Qetransfer_qlRange', $
                                uvalue = 'qetransfer_qlRange',xsize=7 )

        self.bEtran4RRange = cw_field( col6, /all_events,$;/return_events,$
                                title = 'et',$;_Range',$
                                value = float(qerange[3]), /floating, uname = 'Qetransfer_etranRange',$
                                uvalue = 'qetransfer_etranRange',xsize=8 )

        ;ADD CRYSTAL PARAMETERS HERE
        controlbase  = widget_base(row4,xoffset = 20, yoffset = 420,frame=1)
        ;self.controlbase = controlbase
        yoffset = 0
            abcrow = widget_base(controlbase,xoffset=10,yoffset=yoffset,/row)
            self.afield = better_cw_field(abcrow,value=2*!PI,/all_events,$
                                        /floating,title='abc',xsize=8);,xoffset=10,yoffset=25)
            self.bfield = better_cw_field(abcrow,value=2*!PI,/all_events,$
                                        /floating,title='',xsize=8);,xoffset=10,yoffset=50)
            self.cfield = better_cw_field(abcrow,value=2*!PI,/all_events,$
                                        /floating,title='',xsize=8);,xoffset=10,yoffset=75)
            unitslabel = widget_label(abcrow,value=angstrom())

        yoffset += 30
            abcrow = widget_base(controlbase,xoffset=10,yoffset=yoffset,/row)
            self.alphafield = better_cw_field(abcrow,value=90,/all_events,$
                                        /floating,title='abg',xsize=8);,xoffset=10,yoffset=105)
             self.betafield = better_cw_field(abcrow,value=90,/all_events,$
                                        /floating,title='',xsize=8);,xoffset=10,yoffset=130)
            self.gammafield = better_cw_field(abcrow,value=90,/all_events,$
                                        /floating,title='',xsize=8);,xoffset=10,yoffset=155)
            unitslabel = widget_label(abcrow,value='deg')


        ;O1 VALUES
        yoffset += 35
            o1row = widget_base(controlbase,xoffset=16,yoffset=yoffset,/row)
            self.o1hfield = better_cw_field(o1row,value=1,/all_events,$
                                        /integer,title='o1',xsize=4);,xoffset=10,yoffset=350)
            self.o1kfield = better_cw_field(o1row,value=0,/all_events,$
                                        /integer,title='',xsize=4);,xoffset=10,yoffset=375)
            self.o1lfield = better_cw_field(o1row,value=0,/all_events,$
                                        /integer,title='',xsize=4);,xoffset=10,yoffset=400)

        ;O2 VALUES
        ;yoffset += 35
        ;    o2row = widget_base(controlbase,xoffset=16,yoffset=yoffset,/row)
            self.o2hfield = better_cw_field(o1row,value=0,/all_events,$
                                        /integer,title='o2',xsize=4);,xoffset=10,yoffset=430)
            self.o2kfield = better_cw_field(o1row,value=1,/all_events,$
                                        /integer,title='',xsize=4);,xoffset=10,yoffset=455)
            self.o2lfield = better_cw_field(o1row,value=0,/all_events,$
                                        /integer,title='',xsize=4);,xoffset=10,yoffset=480)


            geom = widget_info(controlbase,/geometry)
;            controlbackground = widget_draw(controlbase,$
;                                            xsize=geom.xsize,ysize=geom.ysize)
;            widget_control,controlbackground,get_value=ctrlbkgdvis
;            wset,ctrlbkgdvis
;            erase,200L+200L*256L+200L*256L^2

    widget_control,self.scantypechooser,set_value=2
    widget_control,self.scantypechooser,get_value=val
 ;   print,'val=',val
    self->setSensitivity,val

end;createScanWidgets
pro spurion2_scanparms::createSetupWidgets,backtab,$
                                      horizontal=horizontal,$
                                      collimatorh=collimatorh,$
                                      collimatorv=collimatorv,$
                                      mosaic=mosaic,$
                                      instrument_orient=instrument_orient,$
                                      dspacing=dspacing,$
                                      ressensitive=ressensitive

    if n_elements(ressensitive) eq 0 then ressensitive = 1

    ;RENAME THE BASE FOR THE BACK TAB
    rightcolumn = backtab

    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)',$
                       'Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,  3.26627,  2.00013,  1.70576 ,$
                       1.79160,  1.14280,  3.35420]
    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}

    if n_elements(horizontal) ne 1 then horizontal=0
    if n_elements(collimatorh) ne 4 then collimatorh = [60,60,60,60]
    if n_elements(collimatorv) ne 4 then collimatorv = [120,120,120,120]
    if n_elements(mosaic) ne 4 then mosaic = [10,10,30,30]
    if n_elements(instrument_orient) ne 2 then orient=[1,1]
    if n_elements(dspacing) ne 2 then dspacing = [3.35416,3.35416]

    ;SET UP LAYOUT FOR MONO/ANA AND COLLIMATORS
    collimatorbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )
    monocol = widget_base(collimatorbase, title = 'Mono/Ana D spacings', /col)
    horcol = widget_base(collimatorbase, title = 'Horizontal Collimators',/col)
    vercol = widget_base(collimatorbase, title = 'Vertical Collimators',/col)

    ;MONO AND ANA
        monobase = monocol
        label = widget_label(monobase,value='Mono/Ana')
        label = widget_label(monobase,value='D spacings')
        wDspacings = widget_base(monobase, frame = 3, /base_align_right, /column, xpad = 3 )
        self.monoCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
        self.bDm1R = cw_field(   wDspacings, /return_events, title = 'dm', xsize=4,$
                            value = dspacingchoices[0], /floating, uname = 'Dspacings_dm', $
                            uvalue = mono_info);'Dspacings_dm')
        self.anaCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
        self.bDa2R = cw_field(   wDspacings, /return_events, title = 'da', xsize=4, $
                            value = dspacingchoices[0], /floating, uname = 'Dspacings_da', $
                            uvalue = mono_info);'dspacings_da' )

    ;HORIZONTAL COLLIMATORS
        label = widget_label(horcol,value='Horizontal')
        label = widget_label(horcol,value='Collimators')
        wColh = widget_base( horcol, frame = 3, /base_align_right, /column, xpad = 3 ,$
                                sensitive=ressensitive)
        self.bColh1R = cw_field( wColh, /return_events, title = 'ALZ',$;tooltip = 'Horizontal Collimation After Source' $
                                value = collimatorh[0], /integer, uname='Colh_alz', $
                                uvalue = 'colh_alz', xsize=4)
        self.bColh2R = cw_field( wColh, /return_events, title = 'ALM',$
                                value = collimatorh[1], /integer, uname='Colh_alm', $
                                uvalue = 'colh_alm', xsize=4 )
        self.bColh3R = cw_field( wColh, /return_events, title = 'ALA',$
                                value = collimatorh[2], /integer, uname='Colh_ala', $
                                uvalue = 'colh_ala', xsize=4 )
        self.bColh4R = cw_field( wColh, /return_events, title = 'AL3',$
                                value = collimatorh[3], /integer, uname='Colh_al3', $
                                uvalue = 'colh_al3', xsize=4 )

    ;VERTICAL COLLIMATORS
        label = widget_label(vercol,value='Vertical')
        label = widget_label(vercol,value='Collimators')
        wColv = widget_base( vercol, frame = 3, /base_align_right, /column, xpad = 3 ,$
                                sensitive=ressensitive)
        self.bColv1R = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4,$
                                value = collimatorv[0], /integer, uname = 'Colv_vbetz', $
                                uvalue = 'colv_vbetz' )

        self.bColv2R = cw_field( wColv, /return_events, title = 'VBET1', xsize=4,$
                                value = collimatorv[1], /integer, uname = 'Colv_vbet1', $
                                uvalue = 'colv_vbet1' )

        self.bColv3R = cw_field( wColv, /return_events, title = 'VBET2', xsize=4,$
                                value = collimatorv[2], /integer, uname = 'Colv_vbet2', $
                                uvalue = 'colv_vbet2' )

        self.bColv4R = cw_field( wColv, /return_events, title = 'VBET3', xsize=4,$
                                value = collimatorv[3], /integer, uname = 'Colv_vbet3', $
                                uvalue = 'colv_vbet3' )

    monoandmosaicbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row,$
                                sensitive=ressensitive);column )

    ;SAMPLE AND MONO MOSAICS

    tMosaic = widget_base(monoandmosaicbase, title = 'Mosaics', /column ,$
                                sensitive=ressensitive)
    label = widget_label(tMosaic,value='Mosaics')
    wMosaic = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 ,$
                                sensitive=ressensitive)

    ;SAMPLE MOSAICS
    self.bEtash1R = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4,$
                            value = mosaic[0], /integer, uname = 'Mosaic_etash', $
                            uvalue = 'mosaic_etash' )
    self.bEtasv2R = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4,$
                            value = mosaic[1], /integer, uname = 'Mosaic_etasv', $
                            uvalue = 'mosaic_etasv' )
    ;MONO MOSAIC
    self.bEtam3R = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4,$
                            value = mosaic[2], /integer, uname = 'Mosaic_etam', $
                            uvalue = 'mosaic_etam' )
    ;ANALYZER MOSAIC
    self.bEtaa4R = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4,$
                            value = mosaic[3], /integer, uname = 'Mosaic_etaa', $
                            uvalue = 'mosaic_etaa' )




    ;THE NEXT ITEM SHOULD BE A COMBOBOX


;    wSource_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;    void = widget_label( wSource_value, value = 'Source (Thermal(0)/Cold(1))', /align_center )
    wSource_value = widget_base(monoandmosaicbase, frame = 3, /base_align_right, /column, xpad = 3 ,$
                                sensitive=ressensitive)

    subbase = widget_base(wsource_value,/row)
    void = widget_label(subbase, value = 'Source', /align_center )
    self.sourceCombo = widget_combobox(subbase,value=['Thermal','Cold'],uvalue=[0,1]);,title='Source')

    source = 0

    horizontal = 0

    self.horizontalFocusCheckbox = cw_bgroup(wsource_value,['Horizontal Focus'],set_value=0,$
                                                /nonexclusive,frame=3)


    ;instrumentorientationbase = widget_base(backtab,/col)
    instrumentorientationbase = widget_base(monoandmosaicbase,/col,$
                                sensitive=ressensitive)
    label = widget_label(instrumentorientationbase,value='Instrument')
    label = widget_label(instrumentorientationbase,value='Orientation')
    wInstrument_orientation = widget_base(InstrumentOrientationBase, frame = 3,$
                                                /base_align_right,$
                                                /col,$
                                                 xpad = 3 ,$
                                sensitive=ressensitive)

;HIDE THIS FOR NOW.
dumbase = widget_base(sensitive=ressensitive)
    self.geomchoice = widget_combobox(dumbase,value=['RLR','RLL'],editable=0)
;    self.geomchoice = widget_combobox(wInstrument_orientation,value=['RLR','RLL'],editable=0)

    self.bEpm1R = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2,$
                            value = orient[0], /integer, uname = 'Instrument_orientation_epm',$
                            uvalue = 'Instrument_orientation_epm' )

    self.bEp2R = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2,$
                            value = orient[1], /integer, uname = 'Instrument_orientation_ep',$
                            uvalue = 'Instrument_orientation_ep' )

end;createSetupWidgets



function spurion2_scanparms::init,parent,$
                                    horizontal=horizontal,$
                                    collimatorh=collimatorh,$
                                    collimatorv=collimatorv,$
                                    mosaic=mosaic,$
                                    npts = npts,$
                                    qerange = qerange,$
                                    dspacing=dspacing,$
                                    qetrans = qetrans,$
                                    orient = orient,$
                                    ;
                                    tlb=tlb,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
                                    ressensitive=ressensitive,$
                                    _ref_extra=extra



    if n_elements(horizontal) ne 1 then horizontal=0
    if n_elements(ressensitive) eq 0 then ressensitive = 0


    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)','Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,   3.26627,  2.00013,  1.70576 , 1.79160,  1.14280,  3.35420]


    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}


    if n_elements(collimatorh) ne 4 then collimatorh = [60,60,60,60]

    if n_elements(collimatorv) ne 4 then collimatorv = [120,120,120,120]

    if n_elements(mosaic) ne 4 then mosaic = [10,10,30,30]


    if n_elements(instrument_orient) ne 2 then orient=[1,1]

    if n_elements(dspacing) ne 2 then dspacing = [3.35416,3.35416]
    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)','Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,   3.26627,  2.00013,  1.70576 , 1.79160,  1.14280,  3.35420]


    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}


    if n_elements(npts) eq 0 then npts = 1

    if n_elements(qerange) eq 4 then qerange = [qerange,0.0]
    if n_elements(qerange) lt 4 then qerange = dblarr(5)

    if n_elements(qetrans) ne 5 then qetrans = [1.0,2.0,0.0,0.0,14.7]





    self.parent = parent
    self.tlb = widget_base(parent,/col,$;/row,$
                                title='Resolution/Instrument',$
                                event_func='spurion2_scanparms_event',$
                                pro_set_value='spurion2_scanparms_set_value',$
                                func_get_value='spurion2_scanparms_get_value',$
                                uvalue=uvalue,uname=uname,kill_notify=kill_notify)
    tlb = self.tlb



    ;SET UP THE FRONT AND BACK SCAN TABS
    tab = widget_tab(tlb,$
                     kill_notify='spurion2_scanparms_cleanup',$
                     uvalue=self)
    self.tab = tab

    fronttab = widget_base(tab,title='Scan Definition',/col,uvalue=self)
    backtab = widget_base(tab,title='Setup Info',/col,uvalue=self);,sensitive=ressensitive)


    wTab=widget_base(tlb,/row,uvalue=self)
    wtab2 = widget_base(tlb,/row,uvalue=self)
    buttsize =70

    self.buttcalculate1=widget_button(wtab2, value='Calculate',$
                                           uvalue=self,$
                                           uname='CALCULATE')

;    self.buttcalculate1=cwo_lk_multibutton(wtab2, value='Calculate',$
;                                           color=256L*255L,uvalue=self,$
;                                           uname='CALCULATE')


    self->createScanWidgets,fronttab,qetrans,qerange


    self->createSetupWidgets,backtab,$
                          horizontal=horizontal,$
                          collimatorh=collimatorh,$
                          collimatorv=collimatorv,$
                          mosaic=mosaic,$
                          instrument_orient=instrument_orient,$
                          dspacing=dspacing,$
                          ressensitive=ressensitive



    return,1
end;init
pro spurion2_scanparms_values_define,struct

        struct = {spurion2_scanparms_values,$
                    bColh1R:0.0,$
                    bColh2R:0.0,$
                    bColh3R:0.0,$
                    bColh4R:0.0,$
                    bColv1R:0.0,$
                    bColv2R:0.0,$
                    bColv3R:0.0,$
                    bColv4R:0.0,$
                    bEtash1R:0.0,$
                    bEtasv2R:0.0,$
                    bEtam3R:0.0,$
                    bEtaa4R:0.0,$
                    bDm1R:0.0,$
                    bDa2R:0.0,$
                    bEpm1R:0.0,$
                    bEp2R:0.0,$
                    ;cen
                    bQh1R:0.0,$
                    bQk2R:0.0,$
                    bQl3R:0.0,$
                    bEtran4R:0.0,$
                    bEin5R:0.0,$
                    ;range
                    bQh1RRange:0.0,$
                    bQk2RRange:0.0,$
                    bQl3RRange:0.0,$
                    bEtran4RRange:0.0,$
                    ;cen    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
                    bQh1RCen:0.0,$
                    bQk2RCen:0.0,$
                    bQl3RCen:0.0,$
                    bEtran4RCen:0.0,$
                    ;step
                    bQh1RStep:0.0,$
                    bQk2RStep:0.0,$
                    bQl3RStep:0.0,$
                    bEtran4RStep:0.0,$
                    ;init
                    bQh1RInit:0.0,$
                    bQk2RInit:0.0,$
                    bQl3RInit:0.0,$
                    bEtran4RInit:0.0,$
                    ;final
                    bQh1RFinal:0.0,$
                    bQk2RFinal:0.0,$
                    bQl3RFinal:0.0,$
                    bEtran4RFinal:0.0,$
                    ;
                    npts:0,$
                    bSource1R:0,$
                    bSourceHFocus:0,$
                    horizontal:0,$
                    collimatorh:dblarr(4),$
                    collimatorv:dblarr(4),$
                    mosaic:dblarr(4),$
                    dspacing:dblarr(2),$
                    instrument_orient:intarr(2),$
                    qetrans:dblarr(5),$
                    qerange:dblarr(5),$
                    cen:dblarr(5),$
                    step:dblarr(5),$
                    init:dblarr(5),$
                    final:dblarr(5),$
                    a:0.0,b:0.0,c:0.0,$
                    alpha:0.0,beta:0.0,gamma:0.0,$
                    o1h:1,o1k:0,o1l:0,$
                    o2h:1,o2k:0,o2l:0,$
                    abc:dblarr(3),abg:dblarr(3),o1:intarr(3),o2:intarr(3),$
                    E:0.0,Efix:0.0,Ei:0.0,Ef:0.0,Eif:1}

end;spurion2_scanparms_values
pro spurion2_scanparms__define,class

    spurion2_scanparms_values_define,scanvals
;    scanvals = {spurion2_scanparms_values,$
;                    bColh1R:0.0,$
;                    bColh2R:0.0,$
;                    bColh3R:0.0,$
;                    bColh4R:0.0,$
;                    bColv1R:0.0,$
;                    bColv2R:0.0,$
;                    bColv3R:0.0,$
;                    bColv4R:0.0,$
;                    bEtash1R:0.0,$
;                    bEtasv2R:0.0,$
;                    bEtam3R:0.0,$
;                    bEtaa4R:0.0,$
;                    bDm1R:0.0,$
;                    bDa2R:0.0,$
;                    bEpm1R:0.0,$
;                    bEp2R:0.0,$
;                    bQh1R:0.0,$
;                    bQk2R:0.0,$
;                    bQl3R:0.0,$
;                    bEtran4R:0.0,$
;                    bEin5R:0.0,$
;                    bQh1RRange:0.0,$
;                    bQk2RRange:0.0,$
;                    bQl3RRange:0.0,$
;                    bEtran4RRange:0.0,$
;                    npts:0,$
;                    bSource1R:0,$
;                    bSourceHFocus:0,$
;                    horizontal:0,$
;                    collimatorh:dblarr(4),$
;                    collimatorv:dblarr(4),$
;                    mosaic:dblarr(4),$
;                    dspacing:dblarr(2),$
;                    instrument_orient:intarr(2),$
;                    qetrans:dblarr(5),$
;                    qerange:dblarr(5)}


    class = { spurion2_scanparms,$
                    parent:0L,$
                    tlb:0L,$
                    wTab:0L,$
                    tab:0L,$
                    tExperiment:0L,$        ;TAB
                    collimatorbase:0L,$  ; = widget_base(wTab, title = 'Horizontal Collimators', /column )
                    wColh:0L,$
                    bColh1R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALZ' $
                                                    ;tooltip = 'Horizontal Collimation After Source' $
                    bColh2R:0L,$
                    bColh3R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALA' $
                    bColh4R:0L,$    ; = cw_field( wColh, /return_events, title = 'AL3' $
                    tVerticalParams:0L,$    ; = widget_base(wTab, title = 'Vertical Collimators', /column )
                    wColv:0L,$    ; = widget_base( tVerticalParams, frame = 3, /base_align_right, /column, xpad = 3 )
                    bColv1R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4 $
                    bColv2R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET1', xsize=4 $
                    bColv3R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET2', xsize=4 $
                    bColv4R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET3', xsize=4 $

                    tMosaic:0L,$    ; = widget_base(wTab, title = 'Mosaics', /column )
                    wMosaic:0L,$    ; = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEtash1R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4 $

                    bEtasv2R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4 $

                    bEtam3R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4 $

                    bEtaa4R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4$

                    monobase:0L,$    ; = widget_base(wTab, title = 'Monochormator D spacings', /column )
                    wDspacings:0L,$    ; = widget_base( monobase, frame = 3, /base_align_right, /column, xpad = 3 )

                    monoCombo:0L,$      ;MONO
                    anaCombo:0L,$       ;ANALYZER
                    sourceCombo:0L,$    ;THERMAL/COLD

                    EFixedChoice:0L,$   ;i/f
                    geomchoice:0L,$     ;RLR/RLL
                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

                    bDm1R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'dm', xsize=4 $

                    bDa2R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'da', xsize=4 $

                    tInstrument_orientation:0L,$    ; = widget_base(wTab, title = 'Instrument Orientation', /column )
                    wInstrument_orientation:0L,$    ; = widget_base( tInstrument_orientation, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEpm1R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2 $

                    bEp2R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2 $


                    wQetransfer:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    ;CENTER
                    bQh1R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qh' $
                    bQk2R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qk' $
                    bQl3R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ql' $

                    bEtran4R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'etran' $
                    bEin5R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ein' $

                    ;STEP

                    ;INITIAL

                    ;FINAL

                    bQh1RRange:0L,$
                    bQk2RRange:0L,$
                    bQl3RRange:0L,$
                    bEtran4RRange:0L,$


                    ;cen    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
                    bQh1RCen:0L,$
                    bQk2RCen:0L,$
                    bQl3RCen:0L,$
                    bEtran4RCen:0L,$
                    ;step
                    bQh1RStep:0L,$
                    bQk2RStep:0L,$
                    bQl3RStep:0L,$
                    bEtran4RStep:0L,$
                    ;init
                    bQh1RInit:0L,$
                    bQk2RInit:0L,$
                    bQl3RInit:0L,$
                    bEtran4RInit:0L,$
                    ;final
                    bQh1RFinal:0L,$
                    bQk2RFinal:0L,$
                    bQl3RFinal:0L,$
                    bEtran4RFinal:0L,$

                    nptsfield:0L,$
                    scantypechooser:0L,$    ;exclusive cw_bgroup:   initial/final
                                            ;                       initial/step
                                            ;                       center/step
                                            ;npts specified in any of these three.


                    wSource_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSource1R:0L,$    ; = cw_field( wSource_value, /return_events, title = 'Source', xsize=2 $

                    wHorizontal_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSourceHFocus:0L,$    ; = cw_field( wHorizontal_value, /return_events, title = 'Horizontal focus', xsize=2 $


                    buttbase:0L,$    ;=widget_base(tlb, row=1)
                    buttcalculate1:0L, $    ;=widget_button(buttbase, value='Calculate RM' $

                    scanvals:scanvals,$
                    afield:0L,$
                    bfield:0L,$
                    cfield:0L,$
                    alphafield:0L,$
                    betafield:0L,$
                    gammafield:0L,$
                    o1hfield:0L,$
                    o1kfield:0L,$
                    o1lfield:0L,$
                    o2hfield:0L,$
                    o2kfield:0L,$
                    o2lfield:0L}


end;spurion2_scanparms__define

function spurion2_scanparms,parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        ressensitive=ressensitive,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _ref_extra=extra


    obj = obj_new('spurion2_scanparms',parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        ressensitive=ressensitive,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _extra=extra)

    obj->getproperty,tlb=tlb
    return,tlb

    ;print,'HEY!!!!!!'

end;spurion2_scanparms