; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_orientationvecs_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;   cwo_drawplot_data
;
;
;METHODS:
;    spurion2_orientationvecs_data::calculate
;    spurion2_orientationvecs_data::draw
;    spurion2_orientationvecs_data::xrange
;    spurion2_orientationvecs_data::yrange
;    spurion2_orientationvecs_data::getproperty
;    spurion2_orientationvecs_data::setproperty
;    spurion2_orientationvecs_data::cleanup
;    spurion2_orientationvecs_data::init
;    spurion2_orientationvecs_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu Jun 01 20:34:13 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################

;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data::calculate,rm,r0,Q,Q1,Q2,E,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy


end;calculate


;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data::draw,xscale=xscale,yscale=yscale,win,_ref_Extra=Extra;,rm,r0,Q,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
;print,xscale,yscale
        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0

        self->calculate,_Extra=extra;,rm,r0,Q,Q1,Q2,astar,bstar,cstar,alpha,beta,gamma,xw=xw,yw=yw,xy=xy
        wset,win

        device,get_decomposed=dc
        device,decomposed=1

        thick = 3

        black = 0L
        red = 255L
        green = 256L*red
        blue = 256L*green
        white = red + green + blue
        soothing = 120L + 120L*256L + 215L*256L*256L

        color = self.color

        if self.showdata eq 1 then begin
            if self.showo1 eq 1 then begin
                arrow,[0],[0],[self.o1x]*xscale,$
                              [self.o1y]*yscale,$
                              /data,color=color,thick=thick
            endif
            if self.showo2 eq 1 then begin
                arrow,[0],[0],[self.o2x]*xscale,$
                              [self.o2y]*yscale,$
                              /data,color=color,thick=thick
            endif

        endif;showdata

        device, decomposed = dc

end;spurion2_orientationvecs_data::draw

;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_orientationvecs_data::xrange


    x = [self.o1x,self.o2x]

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_orientationvecs_data::yrange

    y = [self.o1y,self.o2y]

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data::getproperty,$
                            showo1=showo1,$
                            showo2=showo2,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            xy=xy,$
                            xw=xw,$
                            yw=yw,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            id=id,$
                            ;_extra=extra
                            _ref_extra=extra



                self->cwo_drawplot_data::getproperty,id=id,_extra=extra

                if arg_present(showo1) eq 1 then showo1 = self.showo1
                if arg_present(showo2) eq 1 then showo2 = self.showo2

                if arg_present(showki) eq 1 then showki = self.showki
                if arg_present(showkf) eq 1 then showkf = self.showkf
                if arg_present(showQ) eq 1 then showQ = self.showQ
                if arg_present(showproj) eq 1 then showproj = self.showproj
                if arg_present(showcut) eq 1 then showcut = self.showcut
                if arg_present(showellipse) eq 1 then showellipse = self.showellipse
                if arg_present(showsymbol) eq 1 then showsymbol = self.showsymbol


                if arg_present(projcolor) gt 0 then projcolor = self.projcolor
                if arg_present(cutcolor) gt 0 then cutcolor = self.cutcolor

end;getproperty

;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_orientationvecs_data::setcheckboxproperties,vals
;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$
    self.showo1 = vals[0]
    self.showo2 = vals[1]

;    self.showQ  = vals[0]
;    self.showki = vals[1]
;    self.showkf = vals[2]
;    self.showcut = vals[3]
;    self.showproj = vals[4]
;    self.showellipse = vals[5]
;    self.showsymbol = vals[6]

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data::setproperty,$
                            xproj=xproj,$
                            yproj=yproj,$
                            xcut=xcut,$
                            ycut=ycut,$
                            showo1=showo1,$
                            showo2=showo2,$
                            xw=xw,$
                            yw=yw,$
                            xy=xy,$
                            rm=rm,$
                            r0=r0,$
                            Qx=Qx,$
                            Qy=Qy,$
                            kix=kix,$
                            kiy=kiy,$
                            kfx=kfx,$
                            kfy=kfy,$
                            E=E,$
                            o1x=o1x,$
                            o1y=o1y,$
                            o2x=o2x,$
                            o2y=o2y,$
;                            Q=Q,$
;                            orient1=orient1,$
;                            orient2=orient2,$
;                            astar=astar,$
;                            bstar=bstar,$
;                            cstar=cstar,$
;                            alphastar=alphastar,$
;                            betastar=betastar,$
;                            gammastar=gammastar,$
                            projcolor=projcolor,$
                            cutcolor=cutcolor,$
                            showki = showki,$
                            showkf = showkf,$
                            showQ = showQ,$
                            showproj = showproj,$
                            showcut = showcut,$
                            showellipse = showellipse,$
                            showsymbol = showsymbol,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,_extra=extra

                if n_elements(showo1) gt 0 then self.showo1 = showo1
                if n_elements(showo2) gt 0 then self.showo2 = showo2

                if n_elements(o1x) gt 0 then self.o1x = o1x
                if n_elements(o1y) gt 0 then self.o1y = o1y
                if n_elements(o2x) gt 0 then self.o2x = o2x
                if n_elements(o2y) gt 0 then self.o2y = o2y

                if n_elements(rm) gt 0 then self.rm = rm
                if n_elements(r0) gt 0 then self.r0 = r0
                if n_elements(projcolor) gt 0 then self.projcolor = projcolor
                if n_elements(cutcolor) gt 0 then self.cutcolor = cutcolor

                if n_elements(Qx) eq 1 then self.Qx = Qx
                if n_elements(Qy) eq 1 then self.Qy = Qy
                if n_elements(kix) eq 1 then self.kix = kix
                if n_elements(kiy) eq 1 then self.kiy = kiy
                if n_elements(kfx) eq 1 then self.kfx = kfx
                if n_elements(kfy) eq 1 then self.kfy = kfy


                if n_elements(E) eq 1 then self.E = E

;                if n_elements(q)  ge 3 then self.Q  = q[0:2]
;                if n_elements(orient1) eq 3 then self.orient1 = orient1[0:2]
;                if n_elements(orient2) eq 3 then self.orient2 = orient2[0:2]
;
;                if n_elements(astar) eq 1 then self.astar = astar
;                if n_elements(bstar) eq 1 then self.bstar = bstar
;                if n_elements(cstar) eq 1 then self.cstar = cstar
;
;                if n_elements(alphastar) eq 1 then self.alphastar = alphastar
;                if n_elements( betastar) eq 1 then self.betastar  = betastar
;                if n_elements(gammastar) eq 1 then self.gammastar = gammastar

                if n_elements(showki) eq 1 then self.showki = showki
                if n_elements(showkf) eq 1 then self.showkf = showkf
                if n_elements(showQ) eq 1 then self.showQ = showQ
                if n_elements(showproj) eq 1 then self.showproj = showproj
                if n_elements(showcut) eq 1 then self.showcut = showcut
                if n_elements(showellipse) eq 1 then self.showellipse = showellipse
                if n_elements(showsymbol) eq 1 then self.showsymbol = showsymbol

                self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw
end;setproperty


;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data::cleanup
    ;print,'spurion2_orientationvecs_data::cleanup'

    self->cwo_drawplot_data::cleanup

end;spurion2_orientationvecs_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_orientationvecs_data::init,$
                                    a,b,c,alpha,beta,gamma,o1,o2,$
                                    x,y,sy,legend=legend,showdata=showdata,$
                                    showlegend=showlegend,$
                                    Qx=Qx,$            ;Qx,Qy IN THE u,v COORDINATES, i.e. IN THE SCATTERING PLANE.
                                    Qy=Qy,$
                                    kix=kix,$
                                    kiy=kiy,$
                                    kfx=kfx,$
                                    kfy=kfy,$
                                    E=E,$
                                    rm=rm,$
                                    r0=r0,$
                                    projcolor=projcolor,$
                                    xy=xy,$
                                    xw=xw,$
                                    yw=yw,$
                                    id=id,$
                                    showq=showq,$
                                    showki = showki,$
                                    showkf = showkf,$
                                    showproj = showproj,$
                                    showcut = showcut,$
                                    showellipse = showellipse,$
                                    showsymbol = showsymbol,$
                                    _ref_extra=extra


    if n_elements(color) eq 0 then color = 0L

    o1xy = hkl_to_Qxy(o1[0],o1[1],o1[2],a,b,c,alpha,beta,gamma,o1,o2,/invang);/hklunits
    o2xy = hkl_to_Qxy(o2[0],o2[1],o2[2],a,b,c,alpha,beta,gamma,o1,o2,/invang);/hklunits

    self.o1x = o1xy[0]
    self.o1y = o1xy[1]
    self.o2x = o2xy[0]
    self.o2y = o2xy[1]
    self.showo1 = 1
    self.showo2 = 1

    ret = self->cwo_drawplot_data::init(x,y,sy,legend=legend,showdata=showdata,id=id,$
                                            showlegend=showlegend,_extra=extra)

    if ret eq 1 then begin


        self->calculate;,rm,r0,xy=xy,xw=xw,yw=yw

        return,1
    endif else begin
        return,ret
    endelse

end;spurion2_orientationvecs_data

;###############################################################################
;
;NAME:
;        spurion2_orientationvecs_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_orientationvecs_data__define,class

    class = {   spurion2_orientationvecs_data,$
                inherits cwo_drawplot_data,$
                o1x:0.0,$
                o1y:0.0,$
                o2x:0.0,$
                o2y:0.0,$
                showo1:0,$
                showo2:0}

end;spurion2_orientationvecs_data__define
