; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    spurion2_instrmax_data
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;
;METHODS:
;    spurion2_instrmax_data::calculate
;    spurion2_instrmax_data::draw
;    spurion2_instrmax_data::xrange
;    spurion2_instrmax_data::yrange
;    spurion2_instrmax_data::getproperty
;    spurion2_instrmax_data::setproperty
;    spurion2_instrmax_data::cleanup
;    spurion2_instrmax_data::init
;    spurion2_instrmax_data__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Thu May 18 15:20:57 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::calculate
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data::calculate,_ref_extra=extra

;NO CALCULATIONS SHOULD BE NECESSARY HERE.
;

end;calculate


;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data::draw,win,xscale=xscale,yscale=yscale,_ref_extra=extra

        if n_elements(xscale) eq 0 then xscale = 1.0
        if n_elements(yscale) eq 0 then yscale = 1.0

        self->calculate,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1

        self->getproperty,x=px,y=py,sy=psy,strf=pstrf,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize

        if showdata ne 0 then begin

            xrange = !x.crange
            yrange = !y.crange

            theta = !dtor*findgen(361)

            x = self.qmax*cos(theta)*xscale
            y = self.qmax*sin(theta)*yscale

            oplot,x,y,thick=4,color=0L


        endif;showdata

        device, decomposed = dc

end;spurion2_instrmax_data::draw
;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::xrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_instrmax_data::xrange

    x = [-self.qmax,self.qmax]

    return,[min(x),max(x)]

end;xrange
;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::yrange
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_instrmax_data::yrange

    y = [-self.qmax,self.qmax]

    return,[min(y),max(y)]

end;yrange

;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data::getproperty,$
                            qmax=qmax,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _ref_extra=extra



                if arg_present(qmax) gt 0 then qmax = self.qmax

                self->cwo_drawplot_data::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            _extra=extra


end;getproperty
;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::setcheckboxproperties
;
;PURPOSE:
;        SET PROPERTIES BASED ON CHECKBOX CONDITIONS IN ONE CALL.
;
;PARAMETERS:
;        vals   THE ARRAY OF CHECKBOX 1's AND 0's
;KEYWORDS:
;        none
;###############################################################################
pro spurion2_instrmax_data::setcheckboxproperties,vals

;['Q Vec','Ki','Kf','Cut','Proj','Ellipse',$
;'Symbol','Al Spheres','Recip. Lat.'],$

    self.showdata = vals[0]
    ;ALSO COLOR CODING, RADIUS CODING,

end;setcheckboxproperties


;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data::setproperty,$
                            qmax=qmax,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _ref_extra=extra

                self->cwo_drawplot_data::setproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            _extra=extra

                if n_elements(qmax) gt 0 then self.qmax = qmax

end;setproperty




;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data::cleanup
    ;print,'spurion2_instrmax_data::cleanup'
;    ptr_free,self.x
;    ptr_free,self.y
;    ptr_free,self.sy
    self->cwo_drawplot_data::cleanup
end;spurion2_instrmax_data::cleanup
;###############################################################################
;
;NAME:
;        spurion2_instrmax_data::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function spurion2_instrmax_data::init,ei,ef,A4,$;x,y,sy,strf,$
                                 o1,o2,a,b,c,alpha,beta,gamma,$
                                 qmax=qmax,legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,id=id,$
                                 hkl=hkl,invang=invang,hklunits=hklunits,$
                                 q180max=q180max,$
                                 _ref_extra=extra


    if n_elements(A4) eq 0 then A4 = 180

    ang = !dtor*A4
    ang180 = !dtor*180.0

    ki = calc_kmag_from_E(ei)
    kf = calc_kmag_from_E(ef)

    Qmax = sqrt(ki^2 + kf^2 - 2*ki*kf*cos(ang))
    Q180max = sqrt(ki^2 + kf^2 - 2*ki*kf*cos(ang180))


    self.qmax = Qmax
;print,'Qmax=',Qmax
    ret = self->cwo_drawplot_data::init(legend=legend,psym=psym,color=color,$
                                 linestyle=linestyle,showdata=showdata,$
                                 showlegend=showlegend,thesymsize=symsize,$
                                 id=id,_extra=extra)

    self.ebshow = 0

    return,1
end;spurion2_instrmax_data

;###############################################################################
;
;NAME:
;        spurion2_instrmax_data__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro spurion2_instrmax_data__define,class

    class = {   spurion2_instrmax_data,$
                inherits cwo_drawplot_data,$
                qmax:0.0}

end;spurion2_instrmax_data__define
