; $Id$

;####################################################################
function LK_determ,M
    dM   = M[0,0]*(M[1,1]*M[2,2]-M[2,1]*M[1,2]) + $
           M[1,0]*(M[2,1]*M[0,2]-M[0,1]*M[2,2]) + $
           M[2,0]*(M[0,1]*M[1,2]-M[1,1]*M[0,2])
    return,DM
end;LK_determ
;####################################################################
function LK_cramer,b1,b2,b3,yhat

;COEFFICIENTS
M = transpose([[b1],[b2],[b3]])
;M = [[b1],[b2],[b3]]

;SUB RESULTS (yhat) IN TO COLUMNS
;print,'A1,A2,A3:'
MA1 = M
MA1[0,*] = yhat;BA
;print,'MA1=',MA1
MA2 = M
MA2[1,*] = yhat;BA
;print,'MA2=',MA2
MA3 = M
MA3[2,*] = yhat
;print,'MA3=',MA3


;CALCULATE DETERMINANTS
dM   = LK_determ(M)
dMA1 = LK_determ(MA1)
dMA2 = LK_determ(MA2)
dMA3 = LK_determ(MA3)

;print,'dA1/dA=',dA1/dM
;print,'dA2/dA=',dA2/dM
;print,'dA3/dA=',dA3/dM

A1 = dMA1/dM
A2 = dMA2/dM
A3 = dMA3/dM

;print,'[A1,A2,A3]=',A1,A2,A3
;print,'yhat=',yhat
;print,'A1*b1+A2*b2+A3*b3=',A1*b1+A2*b2+A3*b3

return,[A1,A2,A3]


end;LK_cramer
