; $Id$




;THIS IS A STATELESS HOLDER OF THE VALUES NEEDED TO DEFINE A SCAN

;OBJECTS OF THIS CLASS ARE USED TO HOLD THE INFORMATION NEEDED TO RESTORE A SCAN IN 
;A SCAN MAPPER SESSION.


pro cwo_scanparms_test_event,event
    print,tag_names(event)
    print,event
end;cwo_scanparms_test_event
pro cwo_scanparms_test,obj=obj

    b=widget_base(xoffset=300,yoffset=300,title='RESOLUTION INPUTS')
    p = cwo_scanparms(b,$
                        horizontal=0,$
                        collimatorh=[60,60,60,60],$
                        collimatorv=[60,60,60,60],$
                        mosaic=[60,60,60,60],$
                        dspacing=[5,5],$
                        npts = 1,$
                        qerange =dblarr(5),$
                        qetrans = [2.0,3.0,0.0,14.7,6.0],$
                        orient = [1,1],$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj)

    widget_control,b,/realize
    xmanager,'cwo_scanparms_test',b,/no_block
end;test


function cwo_scanparms_event,event
;    print,'HEY!!!  cwo_scanparms_event'
    widget_control,widget_info(event.handler,/child),get_uvalue=self


    event = self->event(event)


    return,event
end;cwo_scanparms_event


function cwo_scanparms::event,event


;    print,'cwo_scanparms::event',event.id

    case event.id of
    self.monocombo:begin
        widget_control,self.monocombo,get_uvalue=info
        index = nse_comboindex(self.monocombo)
        widget_control,self.bDM1R,set_value=info.dspacing[index]
    end;monocombo
    self.anacombo:begin
        widget_control,self.anacombo,get_uvalue=info
        index = nse_comboindex(self.anacombo)
        widget_control,self.bDa2R,set_value=info.dspacing[index]
    end;anacombo
    self.bDm1R:begin
        ;SET MONO
        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.anacombo,set_combobox_select=index
    end;monofield
    self.bDa2R:begin
        ;mono_info = {mono:monoChoices,dspacing:dSpacingChoices}
        widget_control,self.bDa2R,get_uvalue=info
        index = n_elements(info.mono) - 1
        widget_control,self.anacombo,set_combobox_select=index
    end;anafield
    self.scantypechooser:begin

        ;EVENT.select = 1
        ;EVENT.value  = INDEX OF THE SELCTED ITEM
        self->setSensitivity,event.value
        self->set_scan_values
        self.scanvals = self->get_values()

        ;SWALLOW EVENT?
        return,-1

    end;scantypechooser
    ;NOW HANDLE THE INDIVIDUAL TEXT BOXES FOR DATA RANGES
    self.nptsfield:begin
        widget_control,self.nptsfield,get_value=npts
        ;print,'npts=',npts

        self->set_scan_values

    end;.nptsfield
    ;INIT
    self.bQh1RINIT:begin
        ;print,'self.bQh1RINIT'
        self->set_scan_values
        return,-1
    end;.bQh1RINIT
    self.bQk2RINIT:begin
        self->set_scan_values
        return,-1
    end;.bQk2RINIT
    self.bQl3RINIT:begin
        self->set_scan_values
        return,-1
    end;.bQl3RINIT
    self.bEtran4RINIT:begin
        self->set_scan_values
        return,-1
    end;.bQetran4RINIT
    ;FINAL
    self.bQh1RFINAL:begin
        self->set_scan_values
        return,-1
    end;.bQh1RFINAL
    self.bQk2RFINAL:begin
        self->set_scan_values
        return,-1
    end;.bQk2RFINAL
    self.bQl3RFINAL:begin
        self->set_scan_values
        return,-1
    end;.bQl3RFINAL
    self.bEtran4RFINAL:begin
        self->set_scan_values
        return,-1
    end;.bQEtrn4RFINAL
    ;STEP
    self.bQh1RSTEP:begin
        self->set_scan_values
        return,-1
    end;.bQh1RSTEP
    self.bQk2RSTEP:begin
        self->set_scan_values
        return,-1
    end;.bQk2RSTEP
    self.bQl3RSTEP:begin
        self->set_scan_values
        return,-1
    end;.bQl3RSTEP
    self.bEtran4RSTEP:begin
        self->set_scan_values
        return,-1
    end;.bQEtran4RSTEP
    ;CEN
    self.bQh1RCEN:begin
        self->set_scan_values
        return,-1
    end;.bQh1RCEN
    self.bQk2RCEN:begin
        self->set_scan_values
        return,-1
    end;.bQk2RCEN
    self.bQl3RCEN:begin
        self->set_scan_values
        return,-1
    end;.bQl3RCEN
    self.bEtran4RCEN:begin
        self->set_scan_values
        return,-1
    end;.bQEtran4RCEN
    self.buttcalculate1:begin
        print,'CALCULATING:'
        self->set_scan_values
    end;buttcalculate1
    else:self->set_scan_values
    endcase


    ;CHANGE EVENT.id TO THE cwo's TLB
    event.id = self.tlb
    event.handler = self.parent
    return,event

end;cwo_scanparms::event
pro cwo_scanparms::set_scan_values;,cen=cen,step=step,npts=npts


;    if n_elements()

    ;NOW ASSUME THAT OTHER VALUES MIGHT HAVE CHANGED WITHOUT THE
    ;USER HITTING RETURN, SO THE CURRENT VALUES IN THE self.scanvals
    ;MIGHT NOT BE UP TO DATE.
    ;UPDATE NOW!
    ret = self->get_values()
    npts = ret.npts

    ;RESET THESE RANGES IN TERMS OF CEN,STEP,INIT, FINAL

    ;NOW GET THE VALUES FROM scanvals
    qetrans = ret.qetrans
    qerange = ret.qerange

    cen = ret.cen
    step = ret.step
    init = ret.init
    final = ret.final
;print,cen,step





    ;NOW CALCULATE THE VALUES FOR EACH OF THE FIELDS BASED ON THE
    ;VALUES IN scanvals.

    ;NOW GET THE TYPE OF SCAN
    widget_control,self.scantypechooser,get_value=index


    case index of
    0:begin
        ;GET THE INIT AND FINAL VALUES

            init=init
            final=final

        ;CALCULATE THE CEN AND STEP VALUES
            cen = (final+init)/2.0
;            print,'cen=',cen
            if npts eq 1 then step = 0.0*cen else step = (final - init)/(npts-1)
;            print,'setp=',step

        ;UPDATE THE CEN AND STEP WIDGETS
            ;STEP
            widget_control,self.bQh1RSTEP,set_value=step[0]
            widget_control,self.bQk2RSTEP,set_value=step[1]
            widget_control,self.bQl3RSTEP,set_value=step[2]
            widget_control,self.bEtran4RSTEP,set_value=step[3]
            ;CEN
            widget_control,self.bQh1RCEN,set_value=cen[0]
            widget_control,self.bQk2RCEN,set_value=cen[1]
            widget_control,self.bQl3RCEN,set_value=cen[2]
            widget_control,self.bEtran4RCEN,set_value=cen[3]



    end;INIT/FINAL
    1:begin
        ;GET THE INIT AND STEP VALUES
        init = init
        step = step

        ;CALCULATE THE CEN AND FINAL VALUES
        final = init + (npts-1)*step
        cen = (final + init)/2.0

        ;UPDATE THE CEN AND FINAL WIDGETS
            ;CEN
            widget_control,self.bQh1Rcen,set_value=cen[0]
            widget_control,self.bQk2Rcen,set_value=cen[1]
            widget_control,self.bQl3Rcen,set_value=cen[2]
            widget_control,self.bEtran4Rcen,set_value=cen[3]
            ;final
            widget_control,self.bQh1Rfinal,set_value=final[0]
            widget_control,self.bQk2Rfinal,set_value=final[1]
            widget_control,self.bQl3Rfinal,set_value=final[2]
            widget_control,self.bEtran4Rfinal,set_value=final[3]

    end;INIT/STEP
    2:begin

        ;GET THE CEN AND STEP VALUES
        cen = cen
        step = step

        ;CALCULATE THE INIT AND FINAL VALUES
        range = (npts-1)*step
        init = cen - range/2.0
        final = cen + range/2.0


        ;UPDATE THE INIT AND FINAL WIDGETS
        ;UPDATE THE CEN AND FINAL WIDGETS
            ;init
            widget_control,self.bQh1Rinit,set_value=init[0]
            widget_control,self.bQk2Rinit,set_value=init[1]
            widget_control,self.bQl3Rinit,set_value=init[2]
            widget_control,self.bEtran4Rinit,set_value=init[3]
            ;final
            widget_control,self.bQh1Rfinal,set_value=final[0]
            widget_control,self.bQk2Rfinal,set_value=final[1]
            widget_control,self.bQl3Rfinal,set_value=final[2]
            widget_control,self.bEtran4Rfinal,set_value=final[3]

    end;CEN/STEP
    else:
    endcase


    ;FINALLY UPDATE THE ORIGINAL WIDGETS, WHICH ARE INVISIBLE HERE, BUT
    ;ARE USED FOR THE SCAN DEFINITION CURRENTLY.

    ;ORIG CEN WIDGETS
    widget_control,self.bQh1R,set_value=cen[0]
    widget_control,self.bQk2R,set_value=cen[1]
    widget_control,self.bQl3R,set_value=cen[2]
    widget_control,self.bEtran4R,set_value=cen[3]

    range = final - init
    ;ORIG RANGE WIDGETS
    widget_control,self.bQh1RRange,set_value=range[0]
    widget_control,self.bQk2RRange,set_value=range[1]
    widget_control,self.bQl3RRange,set_value=range[2]
    widget_control,self.bEtran4RRange,set_value=range[3]


    ;UPDATE THE scanvals STRUCTURE
    ret = self->get_values()

    ;NOW ASSUMING THIS WORKS, THE scanpoints CLASS WILL HAVE TO BE MODIFIED
    ;TO HANDLE THE NEW PARAMETERIZATION OF THE SCANS.

end;set_scan_values

pro cwo_scanparms::setSensitivity,position



        if n_elements(position) eq 0 then position = 1000
        case position of
        0:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=1
            widget_control,self.bQk2RINIT,sensitive=1
            widget_control,self.bQl3RINIT,sensitive=1
            widget_control,self.bEtran4RINIT,sensitive=1
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=1
            widget_control,self.bQk2RFINAL,sensitive=1
            widget_control,self.bQl3RFINAL,sensitive=1
            widget_control,self.bEtran4RFINAL,sensitive=1
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=0
            widget_control,self.bQk2RSTEP,sensitive=0
            widget_control,self.bQl3RSTEP,sensitive=0
            widget_control,self.bEtran4RSTEP,sensitive=0
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=0
            widget_control,self.bQk2RCEN,sensitive=0
            widget_control,self.bQl3RCEN,sensitive=0
            widget_control,self.bEtran4RCEN,sensitive=0

        end;init/final
        1:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=1
            widget_control,self.bQk2RINIT,sensitive=1
            widget_control,self.bQl3RINIT,sensitive=1
            widget_control,self.bEtran4RINIT,sensitive=1
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=0
            widget_control,self.bQk2RFINAL,sensitive=0
            widget_control,self.bQl3RFINAL,sensitive=0
            widget_control,self.bEtran4RFINAL,sensitive=0
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=1
            widget_control,self.bQk2RSTEP,sensitive=1
            widget_control,self.bQl3RSTEP,sensitive=1
            widget_control,self.bEtran4RSTEP,sensitive=1
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=0
            widget_control,self.bQk2RCEN,sensitive=0
            widget_control,self.bQl3RCEN,sensitive=0
            widget_control,self.bEtran4RCEN,sensitive=0
        end;init/step
        2:begin
            ;INIT
            widget_control,self.bQh1RINIT,sensitive=0
            widget_control,self.bQk2RINIT,sensitive=0
            widget_control,self.bQl3RINIT,sensitive=0
            widget_control,self.bEtran4RINIT,sensitive=0
            ;FINAL
            widget_control,self.bQh1RFINAL,sensitive=0
            widget_control,self.bQk2RFINAL,sensitive=0
            widget_control,self.bQl3RFINAL,sensitive=0
            widget_control,self.bEtran4RFINAL,sensitive=0
            ;STEP
            widget_control,self.bQh1RSTEP,sensitive=1
            widget_control,self.bQk2RSTEP,sensitive=1
            widget_control,self.bQl3RSTEP,sensitive=1
            widget_control,self.bEtran4RSTEP,sensitive=1
            ;CEN
            widget_control,self.bQh1RCEN,sensitive=1
            widget_control,self.bQk2RCEN,sensitive=1
            widget_control,self.bQl3RCEN,sensitive=1
            widget_control,self.bEtran4RCEN,sensitive=1
        end;cen/step
        else:
        endcase
end;cwo_scanparms::setSensitivity

pro cwo_scanparms::check_values

    changesMade = 0

    changesMade += self->checkEFixed()
    ;changesMade += self->checkQClosed()

    if changesMade ne 0 then void = dialog_message('Changed bad values in resolution parameters')

end;check_values


function cwo_scanparms::checkEFixed


    changesMade = 0
    ;CHECK Efixed
    widget_control,self.bEtran4R,get_value=Etrans
    widget_control,self.bEin5R,get_value=Efixed
    widget_control,self.EFixedChoice,get_value=choice,get_uvalue=sign
;print,'cwo_scanparms::checkEFixed'
;print,'Etrans=',Etrans
;print,'Efixed=',Efixed
;print,'sign=',sign
    if Efixed eq 0 then begin
        Efixed = 14.7
        changesMade += 1
    endif


    if Efixed lt 0 then begin
        Efixed = abs(Efixed)
        widget_control,self.bEin5R,set_value=Efixed
        changesMade = 1
    endif


    if choice eq 0 then begin
        Ei = Efixed    ;EA
        Ef = Ei - Etrans
        if Ef le 0 then begin
            Etrans = Ei - 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif

    endif else begin
        Ef = Efixed    ;EM
        Ei = Etrans + Ef
        if Ei le 0 then begin
            Etrans = Ef + 0.0001
            widget_control,self.bEtran4R,set_value=Etrans
            changesMade += 1
        endif
    endelse

    return,changesMade
end;checkEFixed

function cwo_scanparms::checkQClosed


    changesMade = 0

;;;;;;    ;************************************************
;;;;;;    ;* definition of constants         *
;;;;;;    ;* E = 2.072 k^2 (E:meV, k:AA^-1)     *
;;;;;;    ;************************************************
;;;;;;    f   = 1./2.072
;;;;;;
;;;;;;
;;;;;;    widget_control,self.bEtran4R,get_value=Etrans
;;;;;;    widget_control,self.bEin5R,get_value=Efixed
;;;;;;    widget_control,self.EFixedChoice,get_value=choice,get_uvalue=sign
;;;;;;
;;;;;;
;;;;;;    ;*************************
;;;;;;    ;* calculate ei,ef,ki,kf *
;;;;;;    ;* based on efix & feief *
;;;;;;    ;*************************
;;;;;;    aom =   f*etran     ; energy transfer in units AA^-2
;;;;;;
;;;;;;    if choice eq 0 then begin
;;;;;;        ;   *************************
;;;;;;        ;   * fixed incident energy *
;;;;;;        ;   *************************
;;;;;;        ei =   efix
;;;;;;        ef =   efix-etran
;;;;;;    endif   else  begin
;;;;;;        ;   **********************
;;;;;;        ;   * fixed final energy *
;;;;;;        ;   **********************
;;;;;;        ei =   efix+etran
;;;;;;        ef =   efix
;;;;;;    endelse
;;;;;;
;;;;;;    ki  =    sqrt(f*ei)
;;;;;;    kf  =    sqrt(f*ef)
;;;;;;    alam    =  ki/kf
;;;;;;
;;;;;;
;;;;;;    ;****************************************************************
;;;;;;    ;* various trigonometric expressions from        *
;;;;;;    ;* scattering triangle  :    ki=kf-Q              *
;;;;;;    ;* (34) be = cos(2theta_s)  ;   al = sin(2theta_s)    *
;;;;;;    ;*  sints = sin(theta_s)               *
;;;;;;    ;* (29) psi=angle between ki and -Q ;   aom=ki^2-kf^2     *
;;;;;;    ;*  sa = sin(psi)       ; sb = cos(psi)     *
;;;;;;    ;*      b  = cos(2theta_s+psi)  ;    aa = sin(2theta_s+psi)     *
;;;;;;    ;****************************************************************
;;;;;;    be  =    (ki^2+kf^2-q^2)/(2*ki*kf)  ; q^2=ki^2+kf^2-2ki*kf*be
;;;;;;
;;;;;;
;;;;;;    if be^2 gt 1 then begin
;;;;;;        ;------------------------------------
;;;;;;        ;| Scattering triangle cannot close |
;;;;;;        ;------------------------------------
;;;;;;
;;;;;;         closed = 0
;;;;;;         r0 =   0
;;;;;;         changesMade = 1
;;;;;;    endif
;;;;;;
;;;;;;

    return,changesMade
end;checkQClose





function cwo_scanparms::get_values

    self->check_values

    ;GET THE VALUES FROM ALL THE WIDGETS WITH VALUES AND
    ;RETURN THEM IN A STRUCTURE.
    widget_control,self.bColh1R,get_value=bColh1R
    widget_control,self.bColh2R,get_value=bColh2R
    widget_control,self.bColh3R,get_value=bColh3R
    widget_control,self.bColh4R,get_value=bColh4R

    widget_control,self.bColv1R,get_value=bColv1R
    widget_control,self.bColv2R,get_value=bColv2R
    widget_control,self.bColv3R,get_value=bColv3R
    widget_control,self.bColv4R,get_value=bColv4R

    widget_control,self.bEtash1R,get_value=bEtash1R
    widget_control,self.bEtasv2R,get_value=bEtasv2R
    widget_control,self.bEtam3R,get_value=bEtam3R
    widget_control,self.bEtaa4R,get_value=bEtaa4R


    widget_control,self.bDm1R,get_value=bDm1R
    widget_control,self.bDa2R,get_value=bDa2R


    widget_control,self.bEpm1R,get_value=bEpm1R
    widget_control,self.bEp2R,get_value=bEp2R


    ;THESE SHOULD BE SET ELSEWHERE.
    widget_control,self.bQh1R,get_value=bQh1R
    widget_control,self.bQk2R,get_value=bQk2R
    widget_control,self.bQl3R,get_value=bQl3R

    widget_control,self.bEtran4R,get_value=bEtran4R
    widget_control,self.bEin5R,get_value=bEin5R

    widget_control,self.bQh1RRange,get_value=bQh1RRange
    widget_control,self.bQk2RRange,get_value=bQk2RRange
    widget_control,self.bQl3RRange,get_value=bQl3RRange
    widget_control,self.bEtran4RRange,get_value=bEtran4RRange

    widget_control,self.nptsfield,get_value=npts

    ;CEN
    widget_control,self.bQh1RCEN,get_value=bQh1RCEN
    widget_control,self.bQk2RCEN,get_value=bQk2RCEN
    widget_control,self.bQl3RCEN,get_value=bQl3RCEN
    widget_control,self.bEtran4RCEN,get_value=bEtran4RCEN

    ;STEP
    widget_control,self.bQh1RSTEP,get_value=bQh1RSTEP
    widget_control,self.bQk2RSTEP,get_value=bQk2RSTEP
    widget_control,self.bQl3RSTEP,get_value=bQl3RSTEP
    widget_control,self.bEtran4RSTEP,get_value=bEtran4RSTEP

    ;INIT
    widget_control,self.bQh1RINIT,get_value=bQh1RINIT
    widget_control,self.bQk2RINIT,get_value=bQk2RINIT
    widget_control,self.bQl3RINIT,get_value=bQl3RINIT
    widget_control,self.bEtran4RINIT,get_value=bEtran4RINIT

    ;FINAL
    widget_control,self.bQh1RFINAL,get_value=bQh1RFINAL
    widget_control,self.bQk2RFINAL,get_value=bQk2RFINAL
    widget_control,self.bQl3RFINAL,get_value=bQl3RFINAL
    widget_control,self.bEtran4RFINAL,get_value=bEtran4RFINAL



;    print,'cwo_resparms::getvalues'
;    print,'bQh1RRange=',bQh1RRange
;    print,'bQk2RRange=',bQk2RRange
;    print,'bQl3RRange=',bQl3RRange
;    print,'bEtran4RRange=',bEtran4RRange
;    print,'npts=',npts



    widget_control,self.EFixedChoice,get_value=val,get_uvalue=uval
    sign = uval[val]

    ;SET ENERGY SIGN BASED ON CHECKBOX CHOICE.  reselps REQUIRES NEGATIVE ENERGY VALUE IF Ef Fixed, Pos for Ei
    bEin5R = sign*abs(bEin5R)





    widget_control,self.sourceCombo,get_value=val,get_uvalue=uval
    bSource1R = uval[nse_comboindex(self.SourceCombo)]
;    print,'bSourceR from combo=',bSource1R

;    widget_control,self.bSource1R,get_value=bSource1R
;    print,'bSourceR from field=',bSource1R


;                    geomchoice:0L,$     ;RLR/RLL
;                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

    widget_control,self.horizontalFocusCheckbox,get_value=bSourceHFocus
    ;print,'HorizontalFocus =',bSourceHFocus

;    widget_control,self.bSourceHFocus,get_value=bSourceHFocus
;    print,'HorizontalFocus =',bSourceHFocus



    ret = self.scanvals

    ret.bColh1R=bColh1R
    ret.bColh2R=bColh2R
    ret.bColh3R=bColh3R
    ret.bColh4R=bColh4R
    ret.bColv1R=bColv1R
    ret.bColv2R=bColv2R
    ret.bColv3R=bColv3R
    ret.bColv4R=bColv4R
    ret.bEtash1R=bEtash1R
    ret.bEtasv2R=bEtasv2R
    ret.bEtam3R=bEtam3R
    ret.bEtaa4R=bEtaa4R
    ret.bDm1R=bDm1R
    ret.bDa2R=bDa2R
    ret.bEpm1R=bEpm1R
    ret.bEp2R=bEp2R
    ret.bQh1R=bQh1R
    ret.bQk2R=bQk2R
    ret.bQl3R=bQl3R
    ret.bEtran4R=bEtran4R
    ret.bEin5R=bEin5R

    ret.bSource1R=bSource1R
    ret.bSourceHFocus=bSourceHFocus

    ret.bQh1RRange=bQh1RRange
    ret.bQk2RRange=bQk2RRange
    ret.bQl3RRange=bQl3RRange
    ret.bEtran4RRange=bEtran4RRange
    ret.npts=npts

    ;CEN
    ret.bQh1RCEN=bQh1RCEN
    ret.bQk2RCEN=bQk2RCEN
    ret.bQl3RCEN=bQl3RCEN
    ret.bEtran4RCEN=bEtran4RCEN

    ;STEP
    ret.bQh1RSTEP=bQh1RSTEP
    ret.bQk2RSTEP=bQk2RSTEP
    ret.bQl3RSTEP=bQl3RSTEP
    ret.bEtran4RSTEP=bEtran4RSTEP

    ;INIT
    ret.bQh1RINIT=bQh1RINIT
    ret.bQk2RINIT=bQk2RINIT
    ret.bQl3RINIT=bQl3RINIT
    ret.bEtran4RINIT=bEtran4RINIT

    ;FINAL
    ret.bQh1RFINAL=bQh1RFINAL
    ret.bQk2RFINAL=bQk2RFINAL
    ret.bQl3RFINAL=bQl3RFINAL
    ret.bEtran4RFINAL=bEtran4RFINAL



;    print,'cwo_resparms::getvalues'
;    print,'ret.bQh1RRange=',ret.bQh1RRange
;    print,'ret.bQk2RRange=',ret.bQk2RRange
;    print,'ret.bQl3RRange=',ret.bQl3RRange
;    print,'ret.bEtran4RRange=',ret.bEtran4RRange
;    print,'ret.npts=',ret.npts



    ;MORE FAMILIAR NAMES AND GROUPINGS:
    ret.horizontal=bSourceHFocus
    ret.collimatorh=[bColh1R,bColh2R,bColh3R,bColh4R]
    ret.collimatorv=[bColv1R,bColv2R,bColv3R,bColv4R]
    ret.mosaic=[bEtash1R,bEtasv2R,bEtam3R,bEtaa4R]
    ret.dspacing=[bDm1R,bDa2R]
    ret.instrument_orient=[bEpm1R,bEp2R]
    ret.qetrans=[bQh1R,bQk2R,bQl3R,bEtran4R,bEin5R]

    ;RESET THESE RANGES IN TERMS OF CEN,STEP,INIT, FINAL
    ret.qetrans=[bQh1RCEN,bQk2RCEN,bQl3RCEN,bEtran4RCEN,bEin5R]

    ret.qerange=[bQh1RRange,bQk2RRange,bQl3RRange,bEtran4RRange,0.0]
    ret.cen     = [bQh1RCEN,bQk2RCEN,bQl3RCEN,bEtran4RCEN,0.0]
    ret.step    = [bQh1RSTEP,bQk2RSTEP,bQl3RSTEP,bEtran4RSTEP,0.0]
    ret.init = [bQh1RINIT,bQk2RINIT,bQl3RINIT,bEtran4RINIT,0.0]
    ret.final   = [bQh1RFINAL,bQk2RFINAL,bQl3RFINAL,bEtran4RFINAL,0.0]


    self.scanvals = ret
    return,ret


end;get_values


pro cwo_scanparms_set_value,id,value
    print,'set_value'
end;cwo_scanparms_set_value
pro cwo_scanparms_get_value,id,val=val
    print,'get_value'
    stash = widget_info(id,/child)
    widget_control,stash,get_uvalue=obj

    val = obj->get_values()

end;cwo_scanparms_get_value
function cwo_scanparms::get_q

    return,self.scanvals.qetrans[0:2]
end;get_qe

pro cwo_scanparms::set_Q,q,qh=qh,qk=qk,ql=ql

    ;USE THIS METHOD WHEN Q IS CHANGED IN SOME OTHER FIELD, SUCH AS cwo_latparms OR OTHERS.

    if n_elements(Q) ge 3 then begin
        qh = q[0]
        qk = q[1]
        ql = q[2]
    endif

    if n_elements(qh) ne 0 then widget_control,self.bQh1R,set_value=qh
    if n_elements(qk) ne 0 then widget_control,self.bQk2R,set_value=qk
    if n_elements(ql) ne 0 then widget_control,self.bQl3R,set_value=ql

    self.scanvals = self->get_values()

end;




pro cwo_scanparms::getproperty,  parent =  parent,$
                                tlb =  tlb,$
                                bColh1R =  bColh1R,$
                                bColh2R =  bColh2R,$
                                bColh3R =  bColh3R,$
                                bColh4R =  bColh4R,$
                                bColv1R =  bColv1R,$
                                bColv2R =  bColv2R,$
                                bColv3R =  bColv3R,$
                                bColv4R =  bColv4R,$
                                bEtash1R =  bEtash1R,$
                                bEtasv2R =  bEtasv2R,$
                                bEtam3R =  bEtam3R,$
                                bEtaa4R =  bEtaa4R,$
                                bDm1R =  bDm1R,$
                                bDa2R =  bDa2R,$
                                bEpm1R =  bEpm1R,$
                                bEp2R =  bEp2R,$
                                bQh1R =  bQh1R,$
                                bQk2R =  bQk2R,$
                                bQl3R =  bQl3R,$
                                bEtran4R =  bEtran4R,$
                                bEin5R =  bEin5R,$
                                bSource1R =  bSource1R,$
                                bSourceHFocus =  bSourceHFocus,$
                                buttcalculate1 =  buttcalculate1,$
                                _ref_extra=extra


    if arg_present(parent) ne 0 then parent = self.parent
    if arg_present(tlb) gt 0 then tlb = self.tlb

    if arg_present(bColh1R) ne 0 then bColh1R = self.bColh1R
    if arg_present(bColh2R) ne 0 then bColh2R = self.bColh2R
    if arg_present(bColh3R) ne 0 then bColh3R = self.bColh3R
    if arg_present(bColh4R) ne 0 then bColh4R = self.bColh4R

    if arg_present(bColv1R) ne 0 then bColv1R = self.bColv1R
    if arg_present(bColv2R) ne 0 then bColv2R = self.bColv2R
    if arg_present(bColv3R) ne 0 then bColv3R = self.bColv3R
    if arg_present(bColv4R) ne 0 then bColv4R = self.bColv4R

    if arg_present(bEtash1R) ne 0 then bEtash1R = self.bEtash1R
    if arg_present(bEtasv2R) ne 0 then bEtasv2R = self.bEtasv2R
    if arg_present(bEtam3R) ne 0 then bEtam3R = self.bEtam3R
    if arg_present(bEtaa4R) ne 0 then bEtaa4R = self.bEtaa4R


    if arg_present(bDm1R) ne 0 then bDm1R = self.bDm1R
    if arg_present(bDa2R) ne 0 then bDa2R = self.bDa2R


    if arg_present(bEpm1R) ne 0 then bEpm1R = self.bEpm1R
    if arg_present(bEp2R) ne 0 then bEp2R = self.bEp2R


    if arg_present(bQh1R) ne 0 then bQh1R = self.bQh1R
    if arg_present(bQk2R) ne 0 then bQk2R = self.bQk2R
    if arg_present(bQl3R) ne 0 then bQl3R = self.bQl3R

    if arg_present(bEtran4R) ne 0 then bEtran4R = self.bEtran4R
    if arg_present(bEin5R) ne 0 then bEin5R = self.bEin5R


    if arg_present(bSource1R) ne 0 then bSource1R = self.bSource1R

    if arg_present(bSourceHFocus) ne 0 then bSourceHFocus = self.bSourceHFocus
    if arg_present(buttcalculate1) ne 0 then begin
        buttcalculate1 = self.buttcalculate1
    endif



end;cwo_scanparms

pro cwo_scanparms::setproperty,parent=parent,_ref_extra=extra

    if n_elements(parent) ne 0 then self.parent=parent
    if n_elements(tlb) ne 0 then self.tlb = tlb

    if n_elements(bColh1R) ne 0 then self.bColh1R = bColh1R
    if n_elements(bColh2R) ne 0 then self.bColh2R = bColh2R
    if n_elements(bColh3R) ne 0 then self.bColh3R = bColh3R
    if n_elements(bColh4R) ne 0 then self.bColh4R = bColh4R

    if n_elements(bColv1R) ne 0 then self.bColv1R = bColv1R
    if n_elements(bColv2R) ne 0 then self.bColv2R = bColv2R
    if n_elements(bColv3R) ne 0 then self.bColv3R = bColv3R
    if n_elements(bColv4R) ne 0 then self.bColv4R = bColv4R

    if n_elements(bEtash1R) ne 0 then self.bEtash1R = bEtash1R
    if n_elements(bEtasv2R) ne 0 then self.bEtasv2R = bEtasv2R
    if n_elements(bEtam3R) ne 0 then self.bEtam3R = bEtam3R
    if n_elements(bEtaa4R) ne 0 then self.bEtaa4R = bEtaa4R


    if n_elements(bDm1R) ne 0 then self.bDm1R = bDm1R
    if n_elements(bDa2R) ne 0 then self.bDa2R = bDa2R


    if n_elements(bEpm1R) ne 0 then self.bEpm1R = bEpm1R
    if n_elements(bEp2R) ne 0 then self.bEp2R = bEp2R


    if n_elements(bQh1R) ne 0 then self.bQh1R = bQh1R
    if n_elements(bQk2R) ne 0 then self.bQk2R = bQk2R
    if n_elements(bQl3R) ne 0 then self.bQl3R = bQl3R

    if n_elements(bEtran4R) ne 0 then self.bEtran4R = bEtran4R
    if n_elements(bEin5R) ne 0 then self.bEin5R = bEin5R


    if n_elements(bSource1R) ne 0 then self.bSource1R = bSource1R

    if n_elements(bSourceHFocus) ne 0 then self.bSourceHFocus = bSourceHFocus

    if n_elements(buttcalculate1) ne 0 then self.buttcalculate1 = buttcalculate1

end;setproperty


pro cwo_scanparms_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_scanparms_cleanup

pro cwo_scanparms::cleanup
    print,'cwo_scanparms::cleanup'
end;cleanup



pro cwo_scanparms::createScanWidgets,fronttab,qetrans,qerange,npts


    if n_elements(npts) eq 0 then npts = 1

    if n_elements(qerange) eq 4 then qerange = [qerange,0.0]
    if n_elements(qerange) lt 4 then qerange = dblarr(5)

    if n_elements(qetrans) ne 5 then qetrans = [1.0,2.0,0.0,0.0,14.7]


    tExperiment = widget_base( fronttab, title = 'Experiment', /column ,$
                                uvalue=self)

    label = widget_label(tExperiment,value='Experiment')

    ;Q/E VALUES
    wQetransfer = widget_base( tExperiment, frame = 3, /base_align_right, /row);/column, xpad = 3 )

    wQetransfercol = widget_base(wQetransfer,/col)
    row1 = widget_base(wQetransfercol,/row)
    row2 = widget_base(wQetransfercol,/row)
    row3 = widget_base(wQetransfercol,/row)
    self.scantypechooser = cw_bgroup(row1,['Initial/Final','Initial/Step','Center/Step'],$
                                       set_value=0,/exclusive,/row,frame=1)

    col0 = widget_base(row2,/col)
    col3 = widget_base(row2,/col)
    col4 = widget_base(row2,/col)
    col1 = widget_base(row2,/col)
    col2 = widget_base(row2,/col)

    ;Invisiblebase
    invisible = widget_base()   ;DON'T REALIZE THIS ONE.  IT JUST ALLOWS THE WIDGETS TO BE
                                ;ACCESSIBLE BY PROGRAM FOR NOW WITHOUT BEING SEEN UNTIL
                                ;THEIR FUNCTIONALITY CAN BE REMOVED.
    col5 = widget_base(invisible,/col,sensitive=0 )
    col6 = widget_base(invisible,/col,sensitive=0 )

    texperimentBottom = widget_base(tExperiment,/row)
    qefixbase = widget_base(tExperimentBottom,/col)

    label = widget_label(col0,value='Options')
    label = widget_label(col0,value='qh',yoffset=50)
    label = widget_label(col0,value='qk',yoffset=100)
    label = widget_label(col0,value='ql',yoffset=150)
    label = widget_label(col0,value='etrans',yoffset=200)


    ;CEN    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
        cenlabel = widget_label(col1,value='CEN')
        self.bQh1RCen = cw_field( col1, /return_events, title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qhcen',xsize=7 )
        self.bQk2RCen = cw_field( col1, /return_events, title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qkcen',xsize=7)

        self.bQl3RCen = cw_field( col1, /return_events, title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_qlcen',xsize=7 )

        self.bEtran4RCen = cw_field( col1, /return_events, title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_qhcen', $
                                uvalue = 'qetransfer_etrancen',xsize=7 )

    ;STEP
        steplabel = widget_label(col2,value='STEP')
        self.bQh1RStep = cw_field( col2, /return_events, title = 'qh',$
                                value = 0.0, /floating, uname = 'Qetransfer_qhstep', $
                                uvalue = 'qetransfer_qhstep',xsize=7 )
        self.bQk2RStep = cw_field( col2, /return_events, title = 'qk',$
                                value = 0.0, /floating, uname = 'Qetransfer_qkstep', $
                                uvalue = 'qetransfer_qkstep',xsize=7 )
        self.bQl3RStep = cw_field( col2, /return_events, title = 'ql',$
                                value = 0.0, /floating, uname = 'Qetransfer_qlstep', $
                                uvalue = 'qetransfer_qlstep',xsize=7 )
        self.bEtran4RStep = cw_field( col2, /return_events, title = 'et',$
                                value = 0.0, /floating, uname = 'Qetransfer_etranstep', $
                                uvalue = 'qetransfer_etranstep',xsize=7 )
    ;INIT
        initlabel = widget_label(col3,value='INIT')
        self.bQh1RInit = cw_field( col3, /return_events, title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qhInit', $
                                uvalue = 'qetransfer_qhInit',xsize=7 )
        self.bQk2RInit = cw_field( col3, /return_events, title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qkInit', $
                                uvalue = 'qetransfer_qkInit',xsize=7 )
        self.bQl3RInit = cw_field( col3, /return_events, title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qlInit', $
                                uvalue = 'qetransfer_qlInit',xsize=7 )
        self.bEtran4RInit = cw_field( col3, /return_events, title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etranInit', $
                                uvalue = 'qetransfer_etranInit',xsize=7 )
    ;FINAL
        finallabel = widget_label(col4,value='FINAL')
        self.bQh1RFinal = cw_field( col4, /return_events, title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qhFinal', $
                                uvalue = 'qetransfer_qhFinal',xsize=7 )
        self.bQk2RFinal = cw_field( col4, /return_events, title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qkFinal', $
                                uvalue = 'qetransfer_qkFinal',xsize=7 )
        self.bQl3RFinal = cw_field( col4, /return_events, title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_qlFinal', $
                                uvalue = 'qetransfer_qlFinal',xsize=7 )
        self.bEtran4RFinal = cw_field( col4, /return_events, title = 'et',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etranFinal', $
                                uvalue = 'qetransfer_etranFinal',xsize=7 )



    ;ORIGINAL, SAME AS CEN (ON HIDDEN BASE)
        origlabel = widget_label(col5,value='ORIG')
        self.bQh1R = cw_field( col5, /return_events, title = 'qh',$
                                value = qetrans[0], /floating, uname = 'Qetransfer_qh', $
                                uvalue = 'qetransfer_qh',xsize=7 )
        self.bQk2R = cw_field( col5, /return_events, title = 'qk',$
                                value = qetrans[1], /floating, uname = 'Qetransfer_qk', $
                                uvalue = 'qetransfer_qk',xsize=7 )
        self.bQl3R = cw_field( col5, /return_events, title = 'ql',$
                                value = qetrans[2], /floating, uname = 'Qetransfer_ql', $
                                uvalue = 'qetransfer_ql',xsize=7 )

        self.bEtran4R = cw_field( col5, /return_events, title = 'etran',$
                                value = qetrans[3], /floating, uname = 'Qetransfer_etran',$
                                uvalue = 'qetransfer_etran',xsize=7 )


    ;FIXED ENERGY AND NPTS
        self.bEin5R = cw_field( row3, /return_events, title = 'Efixed',$
                                value = qetrans[4], /floating, uname = 'Qetransfer_ein', $
                                uvalue = 'qetransfer_ein',xsize=7 )

        self.EFixedChoice = cw_bgroup(row3,['Ei','Ef'],/exclusive,$
                                        set_value=0,label_left='Fix',$
                                        /row,uvalue=[1.0,-1.0],$
                                        frame = 1)
                                        ;GT 0 => Ei fixed
                                        ;LT 0 => Ef fixed

        self.nptsfield = cw_field(row3,/return_events,title='npts',$
                                value = npts, /floating, uname = 'SCAN_NPTS',$
                                uvalue = 'SCAN_NPTS',xsize=4)



    ;RANGES    (ON HIDDEN BASE)
        rangelabel = widget_label(col6,value='RANGE')
        self.bQh1RRange = cw_field( col6, /return_events, title = 'qh',$;Range',$
                                value = float(qerange[0]), /floating, uname = 'Qetransfer_qhRange', $
                                uvalue = 'qetransfer_qhRange',xsize=7 )
        self.bQk2RRange = cw_field( col6, /return_events, title = 'qk',$;Range',$
                                value = float(qerange[1]), /floating, uname = 'Qetransfer_qkRange', $
                                uvalue = 'qetransfer_qkRange',xsize=7 )
        self.bQl3RRange = cw_field( col6, /return_events, title = 'ql',$;Range',$
                                value = float(qerange[2]), /floating, uname = 'Qetransfer_qlRange', $
                                uvalue = 'qetransfer_qlRange',xsize=7 )

        self.bEtran4RRange = cw_field( col6, /return_events, title = 'et',$;_Range',$
                                value = float(qerange[3]), /floating, uname = 'Qetransfer_etranRange',$
                                uvalue = 'qetransfer_etranRange',xsize=8 )


    widget_control,self.scantypechooser,get_value=val
    print,'val=',val
    self->setSensitivity,val

end;createScanWidgets
pro cwo_scanparms::createSetupWidgets,backtab,$
                                      horizontal=horizontal,$
                                      collimatorh=collimatorh,$
                                      collimatorv=collimatorv,$
                                      mosaic=mosaic,$
                                      instrument_orient=instrument_orient,$
                                      dspacing=dspacing

    ;RENAME THE BASE FOR THE BACK TAB
    rightcolumn = backtab

    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)',$
                       'Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,  3.26627,  2.00013,  1.70576 ,$
                       1.79160,  1.14280,  3.35420]
    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}

    if n_elements(horizontal) ne 1 then horizontal=0
    if n_elements(collimatorh) ne 4 then collimatorh = [60,60,60,60]
    if n_elements(collimatorv) ne 4 then collimatorv = [120,120,120,120]
    if n_elements(mosaic) ne 4 then mosaic = [10,10,30,30]
    if n_elements(instrument_orient) ne 2 then orient=[1,1]
    if n_elements(dspacing) ne 2 then dspacing = [3.35416,3.35416]

    ;SET UP LAYOUT FOR MONO/ANA AND COLLIMATORS
    collimatorbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )
    monocol = widget_base(collimatorbase, title = 'Mono/Ana D spacings', /col)
    horcol = widget_base(collimatorbase, title = 'Horizontal Collimators',/col)
    vercol = widget_base(collimatorbase, title = 'Vertical Collimators',/col)

    ;MONO AND ANA
        monobase = monocol
        label = widget_label(monobase,value='Mono/Ana')
        label = widget_label(monobase,value='D spacings')
        wDspacings = widget_base(monobase, frame = 3, /base_align_right, /column, xpad = 3 )
        self.monoCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
        self.bDm1R = cw_field(   wDspacings, /return_events, title = 'dm', xsize=4,$
                            value = dspacingchoices[0], /floating, uname = 'Dspacings_dm', $
                            uvalue = mono_info);'Dspacings_dm')
        self.anaCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
        self.bDa2R = cw_field(   wDspacings, /return_events, title = 'da', xsize=4, $
                            value = dspacingchoices[0], /floating, uname = 'Dspacings_da', $
                            uvalue = mono_info);'dspacings_da' )

    ;HORIZONTAL COLLIMATORS
        label = widget_label(horcol,value='Horizontal')
        label = widget_label(horcol,value='Collimators')
        wColh = widget_base( horcol, frame = 3, /base_align_right, /column, xpad = 3 )
        self.bColh1R = cw_field( wColh, /return_events, title = 'ALZ',$;tooltip = 'Horizontal Collimation After Source' $
                                value = collimatorh[0], /integer, uname='Colh_alz', $
                                uvalue = 'colh_alz', xsize=4)
        self.bColh2R = cw_field( wColh, /return_events, title = 'ALM',$
                                value = collimatorh[1], /integer, uname='Colh_alm', $
                                uvalue = 'colh_alm', xsize=4 )
        self.bColh3R = cw_field( wColh, /return_events, title = 'ALA',$
                                value = collimatorh[2], /integer, uname='Colh_ala', $
                                uvalue = 'colh_ala', xsize=4 )
        self.bColh4R = cw_field( wColh, /return_events, title = 'AL3',$
                                value = collimatorh[3], /integer, uname='Colh_al3', $
                                uvalue = 'colh_al3', xsize=4 )

    ;VERTICAL COLLIMATORS
        label = widget_label(vercol,value='Vertical')
        label = widget_label(vercol,value='Collimators')
        wColv = widget_base( vercol, frame = 3, /base_align_right, /column, xpad = 3 )
        self.bColv1R = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4,$
                                value = collimatorv[0], /integer, uname = 'Colv_vbetz', $
                                uvalue = 'colv_vbetz' )

        self.bColv2R = cw_field( wColv, /return_events, title = 'VBET1', xsize=4,$
                                value = collimatorv[1], /integer, uname = 'Colv_vbet1', $
                                uvalue = 'colv_vbet1' )

        self.bColv3R = cw_field( wColv, /return_events, title = 'VBET2', xsize=4,$
                                value = collimatorv[2], /integer, uname = 'Colv_vbet2', $
                                uvalue = 'colv_vbet2' )

        self.bColv4R = cw_field( wColv, /return_events, title = 'VBET3', xsize=4,$
                                value = collimatorv[3], /integer, uname = 'Colv_vbet3', $
                                uvalue = 'colv_vbet3' )

    monoandmosaicbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )

    ;SAMPLE AND MONO MOSAICS

    tMosaic = widget_base(monoandmosaicbase, title = 'Mosaics', /column )
    label = widget_label(tMosaic,value='Mosaics')
    wMosaic = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )

    ;SAMPLE MOSAICS
    self.bEtash1R = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4,$
                            value = mosaic[0], /integer, uname = 'Mosaic_etash', $
                            uvalue = 'mosaic_etash' )
    self.bEtasv2R = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4,$
                            value = mosaic[1], /integer, uname = 'Mosaic_etasv', $
                            uvalue = 'mosaic_etasv' )
    ;MONO MOSAIC
    self.bEtam3R = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4,$
                            value = mosaic[2], /integer, uname = 'Mosaic_etam', $
                            uvalue = 'mosaic_etam' )
    ;ANALYZER MOSAIC
    self.bEtaa4R = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4,$
                            value = mosaic[3], /integer, uname = 'Mosaic_etaa', $
                            uvalue = 'mosaic_etaa' )




    ;THE NEXT ITEM SHOULD BE A COMBOBOX


;    wSource_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;    void = widget_label( wSource_value, value = 'Source (Thermal(0)/Cold(1))', /align_center )
    wSource_value = widget_base(monoandmosaicbase, frame = 3, /base_align_right, /column, xpad = 3 )



    subbase = widget_base(wsource_value,/row)
    void = widget_label(subbase, value = 'Source', /align_center )
    self.sourceCombo = widget_combobox(subbase,value=['Thermal','Cold'],uvalue=[0,1]);,title='Source')

    source = 0

    horizontal = 0

    self.horizontalFocusCheckbox = cw_bgroup(wsource_value,['Horizontal Focus'],set_value=0,$
                                                /nonexclusive,frame=3)


    ;instrumentorientationbase = widget_base(backtab,/col)
    instrumentorientationbase = widget_base(monoandmosaicbase,/col)
    label = widget_label(instrumentorientationbase,value='Instrument')
    label = widget_label(instrumentorientationbase,value='Orientation')
    wInstrument_orientation = widget_base(InstrumentOrientationBase, frame = 3,$
                                                /base_align_right,$
                                                /col,$
                                                 xpad = 3 )


    self.geomchoice = widget_combobox(wInstrument_orientation,value=['RLR','RLL'],editable=0)

    self.bEpm1R = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2,$
                            value = orient[0], /integer, uname = 'Instrument_orientation_epm',$
                            uvalue = 'Instrument_orientation_epm' )

    self.bEp2R = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2,$
                            value = orient[1], /integer, uname = 'Instrument_orientation_ep',$
                            uvalue = 'Instrument_orientation_ep' )

end;createSetupWidgets



function cwo_scanparms::init,parent,$
                                    horizontal=horizontal,$
                                    collimatorh=collimatorh,$
                                    collimatorv=collimatorv,$
                                    mosaic=mosaic,$
                                    npts = npts,$
                                    qerange = qerange,$
                                    dspacing=dspacing,$
                                    qetrans = qetrans,$
                                    orient = orient,$
                                    ;
                                    tlb=tlb,$
                                    xsize=xsize,$
                                    ysize=ysize,$
                                    uvalue=uvalue,$
                                    uname=uname,$
                                    title=title,$
                                    xtitle=xtitle,$
                                    ytitle=ytitle,$
                                    kill_notify=kill_notify,$
                                    _ref_extra=extra



    if n_elements(horizontal) ne 1 then horizontal=0

    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)','Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,   3.26627,  2.00013,  1.70576 , 1.79160,  1.14280,  3.35420]


    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}


    if n_elements(collimatorh) ne 4 then collimatorh = [60,60,60,60]

    if n_elements(collimatorv) ne 4 then collimatorv = [120,120,120,120]

    if n_elements(mosaic) ne 4 then mosaic = [10,10,30,30]


    if n_elements(instrument_orient) ne 2 then orient=[1,1]

    if n_elements(dspacing) ne 2 then dspacing = [3.35416,3.35416]
    monoChoices     = ['PG(002)','PG(004)','Ge(111)','Ge(220)','Ge(331)','Be(002)','Be(110)','User'  ]
    dspacingchoices = [3.35420,  1.67708,   3.26627,  2.00013,  1.70576 , 1.79160,  1.14280,  3.35420]


    mono_info = {mono:monoChoices,dspacing:dSpacingChoices}


    if n_elements(npts) eq 0 then npts = 1

    if n_elements(qerange) eq 4 then qerange = [qerange,0.0]
    if n_elements(qerange) lt 4 then qerange = dblarr(5)

    if n_elements(qetrans) ne 5 then qetrans = [1.0,2.0,0.0,0.0,14.7]





    self.parent = parent
    self.tlb = widget_base(parent,/col,$;/row,$
                                title='Resolution/Instrument',$
                                event_func='cwo_scanparms_event',$
                                pro_set_value='cwo_scanparms_set_value',$
                                func_get_value='cwo_scanparms_get_value',$
                                uvalue=uvalue,uname=uname,kill_notify=kill_notify)
    tlb = self.tlb



    ;SET UP THE FRONT AND BACK SCAN TABS
    tab = widget_tab(tlb,$
                     kill_notify='cwo_scanparms_cleanup',$
                     uvalue=self)

    fronttab = widget_base(tab,title='Scan Definition',/col,uvalue=self)
    backtab = widget_base(tab,title='Setup Info',/col,uvalue=self)


    wTab=widget_base(tlb,/row,uvalue=self)
    wtab2 = widget_base(tlb,/row,uvalue=self)
    buttsize =70

    self.buttcalculate1=widget_button(wtab2, value='Calculate',$
                                           uvalue=self,$
                                           uname='CALCULATE')

;    self.buttcalculate1=cwo_lk_multibutton(wtab2, value='Calculate',$
;                                           color=256L*255L,uvalue=self,$
;                                           uname='CALCULATE')


    self->createScanWidgets,fronttab,qetrans,qerange

;;;;;    ;IS THIS THE STASH?????  IT LOOKS LIKE EVERYTHING IS THE STASH WITH SELF.
;;;;;    ;tExperiment = widget_base( wTab, title = 'Experiment', /column ,$
;;;;;    tExperiment = widget_base( fronttab, title = 'Experiment', /column ,$
;;;;;                                uvalue=self)
;;;;;
;;;;;    label = widget_label(tExperiment,value='Experiment')
;;;;;
;;;;;    ;Q/E VALUES
;;;;;    wQetransfer = widget_base( tExperiment, frame = 3, /base_align_right, /row);/column, xpad = 3 )
;;;;;
;;;;;;;;;;;    void = widget_label( wQetransfer, value = 'Qetransfer', /align_center )
;;;;;;;;;;    void = widget_label( fronttab, value = 'Qetransfer', /align_center,uvalue=self)
;;;;;
;;;;;    wQetransfercol = widget_base(wQetransfer,/col)
;;;;;    row1 = widget_base(wQetransfercol,/row)
;;;;;    row2 = widget_base(wQetransfercol,/row)
;;;;;    row3 = widget_base(wQetransfercol,/row)
;;;;;    self.scantypechooser = cw_bgroup(row1,['Initial/Final','Initial/Step','Center/Step'],$
;;;;;                                       set_value=2,/exclusive,/row,frame=1)
;;;;;
;;;;;    col1 = widget_base(row2,/col)
;;;;;    col2 = widget_base(row2,/col)
;;;;;    col3 = widget_base(row2,/col)
;;;;;    col4 = widget_base(row2,/col)
;;;;;
;;;;;    ;Invisiblebase
;;;;;    invisible = widget_base()   ;DON'T REALIZE THIS ONE.  IT JUST ALLOWS THE WIDGETS TO BE
;;;;;                                ;ACCESSIBLE BY PROGRAM FOR NOW WITHOUT BEING SEEN UNTIL
;;;;;                                ;THEIR FUNCTIONALITY CAN BE REMOVED.
;;;;;    col5 = widget_base(invisible,/col);wQetransfer,/col)
;;;;;    col6 = widget_base(invisible,/col);wQetransfer,/col)
;;;;;
;;;;;    texperimentBottom = widget_base(tExperiment,/row)
;;;;;    qefixbase = widget_base(tExperimentBottom,/col)
;;;;;
;;;;;
;;;;;
;;;;;    ;CEN    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
;;;;;        cenlabel = widget_label(col1,value='CEN')
;;;;;        self.bQh1RCen = cw_field( col1, /return_events, title = 'qh',$
;;;;;                                value = qetrans[0], /floating, uname = 'Qetransfer_qhcen', $
;;;;;                                uvalue = 'qetransfer_qhcen',xsize=7 )
;;;;;        self.bQk2RCen = cw_field( col1, /return_events, title = 'qk',$
;;;;;                                value = qetrans[1], /floating, uname = 'Qetransfer_qhcen', $
;;;;;                                uvalue = 'qetransfer_qkcen',xsize=7)
;;;;;
;;;;;        self.bQl3RCen = cw_field( col1, /return_events, title = 'ql',$
;;;;;                                value = qetrans[2], /floating, uname = 'Qetransfer_qhcen', $
;;;;;                                uvalue = 'qetransfer_qlcen',xsize=7 )
;;;;;
;;;;;        self.bEtran4RCen = cw_field( col1, /return_events, title = 'etran',$
;;;;;                                value = qetrans[3], /floating, uname = 'Qetransfer_qhcen', $
;;;;;                                uvalue = 'qetransfer_etrancen',xsize=7 )
;;;;;
;;;;;    ;STEP
;;;;;        steplabel = widget_label(col2,value='STEP')
;;;;;        self.bQh1RStep = cw_field( col2, /return_events, title = 'qh',$
;;;;;                                value = 0.0, /floating, uname = 'Qetransfer_qhstep', $
;;;;;                                uvalue = 'qetransfer_qhstep',xsize=7 )
;;;;;        self.bQk2RStep = cw_field( col2, /return_events, title = 'qk',$
;;;;;                                value = 0.0, /floating, uname = 'Qetransfer_qkstep', $
;;;;;                                uvalue = 'qetransfer_qkstep',xsize=7 )
;;;;;        self.bQl3RStep = cw_field( col2, /return_events, title = 'ql',$
;;;;;                                value = 0.0, /floating, uname = 'Qetransfer_qlstep', $
;;;;;                                uvalue = 'qetransfer_qlstep',xsize=7 )
;;;;;        self.bEtran4RStep = cw_field( col2, /return_events, title = 'et',$
;;;;;                                value = 0.0, /floating, uname = 'Qetransfer_etranstep', $
;;;;;                                uvalue = 'qetransfer_etranstep',xsize=7 )
;;;;;    ;INIT
;;;;;        initlabel = widget_label(col3,value='INIT')
;;;;;        self.bQh1RInit = cw_field( col3, /return_events, title = 'qh',$
;;;;;                                value = qetrans[0], /floating, uname = 'Qetransfer_qhInit', $
;;;;;                                uvalue = 'qetransfer_qhInit',xsize=7 )
;;;;;        self.bQk2RInit = cw_field( col3, /return_events, title = 'qk',$
;;;;;                                value = qetrans[1], /floating, uname = 'Qetransfer_qkInit', $
;;;;;                                uvalue = 'qetransfer_qkInit',xsize=7 )
;;;;;        self.bQl3RInit = cw_field( col3, /return_events, title = 'ql',$
;;;;;                                value = qetrans[2], /floating, uname = 'Qetransfer_qlInit', $
;;;;;                                uvalue = 'qetransfer_qlInit',xsize=7 )
;;;;;        self.bEtran4RInit = cw_field( col3, /return_events, title = 'et',$
;;;;;                                value = qetrans[3], /floating, uname = 'Qetransfer_etranInit', $
;;;;;                                uvalue = 'qetransfer_etranInit',xsize=7 )
;;;;;    ;FINAL
;;;;;        finallabel = widget_label(col4,value='FINAL')
;;;;;        self.bQh1RFinal = cw_field( col4, /return_events, title = 'qh',$
;;;;;                                value = qetrans[0], /floating, uname = 'Qetransfer_qhFinal', $
;;;;;                                uvalue = 'qetransfer_qhFinal',xsize=7 )
;;;;;        self.bQk2RFinal = cw_field( col4, /return_events, title = 'qk',$
;;;;;                                value = qetrans[1], /floating, uname = 'Qetransfer_qkFinal', $
;;;;;                                uvalue = 'qetransfer_qkFinal',xsize=7 )
;;;;;        self.bQl3RFinal = cw_field( col4, /return_events, title = 'ql',$
;;;;;                                value = qetrans[2], /floating, uname = 'Qetransfer_qlFinal', $
;;;;;                                uvalue = 'qetransfer_qlFinal',xsize=7 )
;;;;;        self.bEtran4RFinal = cw_field( col4, /return_events, title = 'et',$
;;;;;                                value = qetrans[3], /floating, uname = 'Qetransfer_etranFinal', $
;;;;;                                uvalue = 'qetransfer_etranFinal',xsize=7 )
;;;;;
;;;;;
;;;;;
;;;;;    ;ORIGINAL, SAME AS CEN (ON HIDDEN BASE)
;;;;;        origlabel = widget_label(col5,value='ORIG')
;;;;;    ;    self.bQh1R = cw_field( qhbase, /return_events, title = 'qh',$
;;;;;        self.bQh1R = cw_field( col5, /return_events, title = 'qh',$
;;;;;                                value = qetrans[0], /floating, uname = 'Qetransfer_qh', $
;;;;;                                uvalue = 'qetransfer_qh',xsize=7 )
;;;;;    ;    self.bQk2R = cw_field( qkbase, /return_events, title = 'qk',$
;;;;;        self.bQk2R = cw_field( col5, /return_events, title = 'qk',$
;;;;;                                value = qetrans[1], /floating, uname = 'Qetransfer_qk', $
;;;;;                                uvalue = 'qetransfer_qk',xsize=7 )
;;;;;    ;    self.bQl3R = cw_field( qlbase, /return_events, title = 'ql',$
;;;;;        self.bQl3R = cw_field( col5, /return_events, title = 'ql',$
;;;;;                                value = qetrans[2], /floating, uname = 'Qetransfer_ql', $
;;;;;                                uvalue = 'qetransfer_ql',xsize=7 )
;;;;;
;;;;;    ;    self.bEtran4R = cw_field( qebase, /return_events, title = 'etran',$
;;;;;        self.bEtran4R = cw_field( col5, /return_events, title = 'etran',$
;;;;;                                value = qetrans[3], /floating, uname = 'Qetransfer_etran',$
;;;;;                                uvalue = 'qetransfer_etran',xsize=7 )
;;;;;    ;    self.bEin5R = cw_field( qefixbase, /return_events, title = 'Efixed',$
;;;;;
;;;;;
;;;;;    ;FIXED ENERGY AND NPTS
;;;;;        self.bEin5R = cw_field( row3, /return_events, title = 'Efixed',$
;;;;;                                value = qetrans[4], /floating, uname = 'Qetransfer_ein', $
;;;;;                                uvalue = 'qetransfer_ein',xsize=7 )
;;;;;
;;;;;    ;    self.EFixedChoice = cw_bgroup(col1,['Ei','Ef'],/exclusive,$
;;;;;    ;    self.EFixedChoice = cw_bgroup(qefixbase,['Ei','Ef'],/exclusive,$
;;;;;        self.EFixedChoice = cw_bgroup(row3,['Ei','Ef'],/exclusive,$
;;;;;                                        set_value=0,label_left='Fix',$
;;;;;                                        /row,uvalue=[1.0,-1.0],$
;;;;;                                        frame = 1)
;;;;;                                        ;GT 0 => Ei fixed
;;;;;                                        ;LT 0 => Ef fixed
;;;;;
;;;;;    ;    self.nptsfield = cw_field(qefixbase,/return_events,title='npts',$
;;;;;        self.nptsfield = cw_field(row3,/return_events,title='npts',$
;;;;;                                value = npts, /floating, uname = 'SCAN_NPTS',$
;;;;;                                uvalue = 'SCAN_NPTS',xsize=4)
;;;;;
;;;;;
;;;;;
;;;;;    ;RANGES    (ON HIDDEN BASE)
;;;;;    ;    self.bQh1RRange = cw_field( qhbase, /return_events, title = 'qhRange',$
;;;;;        rangelabel = widget_label(col6,value='RANGE')
;;;;;        self.bQh1RRange = cw_field( col6, /return_events, title = 'qh',$;Range',$
;;;;;                                value = float(qerange[0]), /floating, uname = 'Qetransfer_qhRange', $
;;;;;                                uvalue = 'qetransfer_qhRange',xsize=7 )
;;;;;    ;    self.bQk2RRange = cw_field( qkbase, /return_events, title = 'qkRange',$
;;;;;        self.bQk2RRange = cw_field( col6, /return_events, title = 'qk',$;Range',$
;;;;;                                value = float(qerange[1]), /floating, uname = 'Qetransfer_qkRange', $
;;;;;                                uvalue = 'qetransfer_qkRange',xsize=7 )
;;;;;    ;    self.bQl3RRange = cw_field( qlbase, /return_events, title = 'qlRange',$
;;;;;        self.bQl3RRange = cw_field( col6, /return_events, title = 'ql',$;Range',$
;;;;;                                value = float(qerange[2]), /floating, uname = 'Qetransfer_qlRange', $
;;;;;                                uvalue = 'qetransfer_qlRange',xsize=7 )
;;;;;
;;;;;    ;    self.bEtran4RRange = cw_field( qebase, /return_events, title = 'e_Range',$
;;;;;        self.bEtran4RRange = cw_field( col6, /return_events, title = 'et',$;_Range',$
;;;;;                                value = float(qerange[3]), /floating, uname = 'Qetransfer_etranRange',$
;;;;;                                uvalue = 'qetransfer_etranRange',xsize=8 )
;;;;;
;;;;;

    self->createSetupWidgets,backtab,$
                          horizontal=horizontal,$
                          collimatorh=collimatorh,$
                          collimatorv=collimatorv,$
                          mosaic=mosaic,$
                          instrument_orient=instrument_orient,$
                          dspacing=dspacing


;;;;;    ;RENAME THE BASE FOR THE BACK TAB
;;;;;    rightcolumn = backtab
;;;;;
;;;;;    ;SET UP LAYOUT FOR MONO/ANA AND COLLIMATORS
;;;;;    collimatorbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )
;;;;;    monocol = widget_base(collimatorbase, title = 'Mono/Ana D spacings', /col)
;;;;;    horcol = widget_base(collimatorbase, title = 'Horizontal Collimators',/col)
;;;;;    vercol = widget_base(collimatorbase, title = 'Vertical Collimators',/col)
;;;;;
;;;;;    ;MONO AND ANA
;;;;;        monobase = monocol
;;;;;        label = widget_label(monobase,value='Mono/Ana')
;;;;;        label = widget_label(monobase,value='D spacings')
;;;;;        wDspacings = widget_base(monobase, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;        self.monoCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
;;;;;        self.bDm1R = cw_field(   wDspacings, /return_events, title = 'dm', xsize=4,$
;;;;;                            value = dspacingchoices[0], /floating, uname = 'Dspacings_dm', $
;;;;;                            uvalue = mono_info);'Dspacings_dm')
;;;;;        self.anaCombo = widget_combobox(wDspacings,value=monoChoices,editable=0,uvalue=mono_info)
;;;;;        self.bDa2R = cw_field(   wDspacings, /return_events, title = 'da', xsize=4, $
;;;;;                            value = dspacingchoices[0], /floating, uname = 'Dspacings_da', $
;;;;;                            uvalue = mono_info);'dspacings_da' )
;;;;;
;;;;;
;;;;;
;;;;;    ;HORIZONTAL COLLIMATORS
;;;;;        label = widget_label(horcol,value='Horizontal')
;;;;;        label = widget_label(horcol,value='Collimators')
;;;;;        wColh = widget_base( horcol, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;        self.bColh1R = cw_field( wColh, /return_events, title = 'ALZ',$;tooltip = 'Horizontal Collimation After Source' $
;;;;;                                value = collimatorh[0], /integer, uname='Colh_alz', $
;;;;;                                uvalue = 'colh_alz', xsize=4)
;;;;;        self.bColh2R = cw_field( wColh, /return_events, title = 'ALM',$
;;;;;                                value = collimatorh[1], /integer, uname='Colh_alm', $
;;;;;                                uvalue = 'colh_alm', xsize=4 )
;;;;;        self.bColh3R = cw_field( wColh, /return_events, title = 'ALA',$
;;;;;                                value = collimatorh[2], /integer, uname='Colh_ala', $
;;;;;                                uvalue = 'colh_ala', xsize=4 )
;;;;;        self.bColh4R = cw_field( wColh, /return_events, title = 'AL3',$
;;;;;                                value = collimatorh[3], /integer, uname='Colh_al3', $
;;;;;                                uvalue = 'colh_al3', xsize=4 )
;;;;;
;;;;;    ;VERTICAL COLLIMATORS
;;;;;        label = widget_label(vercol,value='Vertical')
;;;;;        label = widget_label(vercol,value='Collimators')
;;;;;        wColv = widget_base( vercol, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;        self.bColv1R = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4,$
;;;;;                                value = collimatorv[0], /integer, uname = 'Colv_vbetz', $
;;;;;                                uvalue = 'colv_vbetz' )
;;;;;
;;;;;        self.bColv2R = cw_field( wColv, /return_events, title = 'VBET1', xsize=4,$
;;;;;                                value = collimatorv[1], /integer, uname = 'Colv_vbet1', $
;;;;;                                uvalue = 'colv_vbet1' )
;;;;;
;;;;;        self.bColv3R = cw_field( wColv, /return_events, title = 'VBET2', xsize=4,$
;;;;;                                value = collimatorv[2], /integer, uname = 'Colv_vbet2', $
;;;;;                                uvalue = 'colv_vbet2' )
;;;;;
;;;;;        self.bColv4R = cw_field( wColv, /return_events, title = 'VBET3', xsize=4,$
;;;;;                                value = collimatorv[3], /integer, uname = 'Colv_vbet3', $
;;;;;                                uvalue = 'colv_vbet3' )
;;;;;
;;;;;    monoandmosaicbase = widget_base(rightcolumn, title = 'Horizontal Collimators', /row);column )
;;;;;
;;;;;    ;SAMPLE AND MONO MOSAICS
;;;;;
;;;;;    tMosaic = widget_base(monoandmosaicbase, title = 'Mosaics', /column )
;;;;;    label = widget_label(tMosaic,value='Mosaics')
;;;;;    wMosaic = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;
;;;;;    ;SAMPLE MOSAICS
;;;;;    self.bEtash1R = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4,$
;;;;;                            value = mosaic[0], /integer, uname = 'Mosaic_etash', $
;;;;;                            uvalue = 'mosaic_etash' )
;;;;;    self.bEtasv2R = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4,$
;;;;;                            value = mosaic[1], /integer, uname = 'Mosaic_etasv', $
;;;;;                            uvalue = 'mosaic_etasv' )
;;;;;    ;MONO MOSAIC
;;;;;    self.bEtam3R = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4,$
;;;;;                            value = mosaic[2], /integer, uname = 'Mosaic_etam', $
;;;;;                            uvalue = 'mosaic_etam' )
;;;;;    ;ANALYZER MOSAIC
;;;;;    self.bEtaa4R = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4,$
;;;;;                            value = mosaic[3], /integer, uname = 'Mosaic_etaa', $
;;;;;                            uvalue = 'mosaic_etaa' )
;;;;;
;;;;;
;;;;;
;;;;;
;;;;;    ;THE NEXT ITEM SHOULD BE A COMBOBOX
;;;;;
;;;;;
;;;;;;    wSource_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;;    void = widget_label( wSource_value, value = 'Source (Thermal(0)/Cold(1))', /align_center )
;;;;;    wSource_value = widget_base(monoandmosaicbase, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;
;;;;;
;;;;;
;;;;;    subbase = widget_base(wsource_value,/row)
;;;;;    void = widget_label(subbase, value = 'Source', /align_center )
;;;;;    self.sourceCombo = widget_combobox(subbase,value=['Thermal','Cold'],uvalue=[0,1]);,title='Source')
;;;;;
;;;;;    source = 0
;;;;;;    self.bSource1R = cw_field( wSource_value, /return_events, title = 'Source', xsize=2,$
;;;;;;                                value = source, /integer, uname = 'Source', uvalue = 'source' )
;;;;;
;;;;;;    wHorizontal_value = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;    ;wHorizontal_value = widget_base(subbase, frame = 3, /base_align_right, /column, xpad = 3 )
;;;;;;    void = widget_label( wHorizontal_value, value = 'Horizontal focusing', /align_center )
;;;;;
;;;;;    horizontal = 0
;;;;;;    self.bSourceHFocus = cw_field( wHorizontal_value, /return_events, title = 'Horizontal focus', xsize=2,$
;;;;;;                    value = horizontal, /integer, uname = 'Horizontal_focusing', uvalue = 'horizontal_focusing' )
;;;;;
;;;;;;    self.horizontalFocusCheckbox = cw_bgroup(wHorizontal_value,['Horizontal Focus'],set_value=0,$
;;;;;;                                                /nonexclusive)
;;;;;    self.horizontalFocusCheckbox = cw_bgroup(wsource_value,['Horizontal Focus'],set_value=0,$
;;;;;                                                /nonexclusive,frame=3)
;;;;;
;;;;;
;;;;;
;;;;;    ;tInstrument_orientation = widget_base(wtab2, title = 'Instrument Orientation', /column )
;;;;;;    label = widget_label(tMosaic,value='Instrument')
;;;;;;    label = widget_label(tMosaic,value='Orientation')
;;;;;
;;;;;;    instrumentorientationbase = widget_base(wtab2,/col)
;;;;;    instrumentorientationbase = widget_base(backtab,/col)
;;;;;    label = widget_label(instrumentorientationbase,value='Instrument Orientation')
;;;;;    wInstrument_orientation = widget_base(InstrumentOrientationBase, frame = 3,$
;;;;;                                                /base_align_right,$
;;;;;                                                /row,$;/column,$
;;;;;                                                 xpad = 3 )
;;;;;
;;;;;
;;;;;    self.geomchoice = widget_combobox(wInstrument_orientation,value=['RLR','RLL'],editable=0)
;;;;;
;;;;;    self.bEpm1R = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2,$
;;;;;                            value = orient[0], /integer, uname = 'Instrument_orientation_epm',$
;;;;;                            uvalue = 'Instrument_orientation_epm' )
;;;;;
;;;;;    self.bEp2R = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2,$
;;;;;                            value = orient[1], /integer, uname = 'Instrument_orientation_ep',$
;;;;;                            uvalue = 'Instrument_orientation_ep' )


    return,1
end;init
pro cwo_scanparms_values_define,struct

        struct = {cwo_scanparms_values,$
                    bColh1R:0.0,$
                    bColh2R:0.0,$
                    bColh3R:0.0,$
                    bColh4R:0.0,$
                    bColv1R:0.0,$
                    bColv2R:0.0,$
                    bColv3R:0.0,$
                    bColv4R:0.0,$
                    bEtash1R:0.0,$
                    bEtasv2R:0.0,$
                    bEtam3R:0.0,$
                    bEtaa4R:0.0,$
                    bDm1R:0.0,$
                    bDa2R:0.0,$
                    bEpm1R:0.0,$
                    bEp2R:0.0,$
                    ;cen
                    bQh1R:0.0,$
                    bQk2R:0.0,$
                    bQl3R:0.0,$
                    bEtran4R:0.0,$
                    bEin5R:0.0,$
                    ;range
                    bQh1RRange:0.0,$
                    bQk2RRange:0.0,$
                    bQl3RRange:0.0,$
                    bEtran4RRange:0.0,$
                    ;cen    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
                    bQh1RCen:0.0,$
                    bQk2RCen:0.0,$
                    bQl3RCen:0.0,$
                    bEtran4RCen:0.0,$
                    ;step
                    bQh1RStep:0.0,$
                    bQk2RStep:0.0,$
                    bQl3RStep:0.0,$
                    bEtran4RStep:0.0,$
                    ;init
                    bQh1RInit:0.0,$
                    bQk2RInit:0.0,$
                    bQl3RInit:0.0,$
                    bEtran4RInit:0.0,$
                    ;final
                    bQh1RFinal:0.0,$
                    bQk2RFinal:0.0,$
                    bQl3RFinal:0.0,$
                    bEtran4RFinal:0.0,$
                    ;
                    npts:0,$
                    bSource1R:0,$
                    bSourceHFocus:0,$
                    horizontal:0,$
                    collimatorh:dblarr(4),$
                    collimatorv:dblarr(4),$
                    mosaic:dblarr(4),$
                    dspacing:dblarr(2),$
                    instrument_orient:intarr(2),$
                    qetrans:dblarr(5),$
                    qerange:dblarr(5),$
                    cen:dblarr(5),$
                    step:dblarr(5),$
                    init:dblarr(5),$
                    final:dblarr(5)}

end;cwo_scanparms_values
pro cwo_scanparms__define,class

    cwo_scanparms_values_define,scanvals
;    scanvals = {cwo_scanparms_values,$
;                    bColh1R:0.0,$
;                    bColh2R:0.0,$
;                    bColh3R:0.0,$
;                    bColh4R:0.0,$
;                    bColv1R:0.0,$
;                    bColv2R:0.0,$
;                    bColv3R:0.0,$
;                    bColv4R:0.0,$
;                    bEtash1R:0.0,$
;                    bEtasv2R:0.0,$
;                    bEtam3R:0.0,$
;                    bEtaa4R:0.0,$
;                    bDm1R:0.0,$
;                    bDa2R:0.0,$
;                    bEpm1R:0.0,$
;                    bEp2R:0.0,$
;                    bQh1R:0.0,$
;                    bQk2R:0.0,$
;                    bQl3R:0.0,$
;                    bEtran4R:0.0,$
;                    bEin5R:0.0,$
;                    bQh1RRange:0.0,$
;                    bQk2RRange:0.0,$
;                    bQl3RRange:0.0,$
;                    bEtran4RRange:0.0,$
;                    npts:0,$
;                    bSource1R:0,$
;                    bSourceHFocus:0,$
;                    horizontal:0,$
;                    collimatorh:dblarr(4),$
;                    collimatorv:dblarr(4),$
;                    mosaic:dblarr(4),$
;                    dspacing:dblarr(2),$
;                    instrument_orient:intarr(2),$
;                    qetrans:dblarr(5),$
;                    qerange:dblarr(5)}


    class = { cwo_scanparms,$
                    parent:0L,$
                    tlb:0L,$
                    wTab:0L,$
                    tExperiment:0L,$        ;TAB
                    collimatorbase:0L,$  ; = widget_base(wTab, title = 'Horizontal Collimators', /column )
                    wColh:0L,$
                    bColh1R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALZ' $
                                                    ;tooltip = 'Horizontal Collimation After Source' $
                    bColh2R:0L,$
                    bColh3R:0L,$    ; = cw_field( wColh, /return_events, title = 'ALA' $
                    bColh4R:0L,$    ; = cw_field( wColh, /return_events, title = 'AL3' $
                    tVerticalParams:0L,$    ; = widget_base(wTab, title = 'Vertical Collimators', /column )
                    wColv:0L,$    ; = widget_base( tVerticalParams, frame = 3, /base_align_right, /column, xpad = 3 )
                    bColv1R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBETZ', xsize=4 $
                    bColv2R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET1', xsize=4 $
                    bColv3R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET2', xsize=4 $
                    bColv4R:0L,$    ; = cw_field( wColv, /return_events, title = 'VBET3', xsize=4 $

                    tMosaic:0L,$    ; = widget_base(wTab, title = 'Mosaics', /column )
                    wMosaic:0L,$    ; = widget_base(tMosaic, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEtash1R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASH', xsize=4 $

                    bEtasv2R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETASV', xsize=4 $

                    bEtam3R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAM', xsize=4 $

                    bEtaa4R:0L,$    ; = cw_field( wMosaic, /return_events, title = 'ETAA' , xsize=4$

                    monobase:0L,$    ; = widget_base(wTab, title = 'Monochormator D spacings', /column )
                    wDspacings:0L,$    ; = widget_base( monobase, frame = 3, /base_align_right, /column, xpad = 3 )

                    monoCombo:0L,$      ;MONO
                    anaCombo:0L,$       ;ANALYZER
                    sourceCombo:0L,$    ;THERMAL/COLD

                    EFixedChoice:0L,$   ;i/f
                    geomchoice:0L,$     ;RLR/RLL
                    horizontalFocusCheckbox:0L,$    HORIZONTAL FOCUS

                    bDm1R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'dm', xsize=4 $

                    bDa2R:0L,$    ; = cw_field( wDspacings, /return_events, title = 'da', xsize=4 $

                    tInstrument_orientation:0L,$    ; = widget_base(wTab, title = 'Instrument Orientation', /column )
                    wInstrument_orientation:0L,$    ; = widget_base( tInstrument_orientation, frame = 3, /base_align_right, /column, xpad = 3 )

                    bEpm1R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'epm', xsize=2 $

                    bEp2R:0L,$    ; = cw_field( wInstrument_orientation, /return_events, title = 'ep', xsize=2 $


                    wQetransfer:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    ;CENTER
                    bQh1R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qh' $
                    bQk2R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'qk' $
                    bQl3R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ql' $

                    bEtran4R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'etran' $
                    bEin5R:0L,$    ; = cw_field( wQetransfer, /return_events, title = 'ein' $

                    ;STEP

                    ;INITIAL

                    ;FINAL

                    bQh1RRange:0L,$
                    bQk2RRange:0L,$
                    bQl3RRange:0L,$
                    bEtran4RRange:0L,$


                    ;cen    (SAME AS bQh1R, bQk2R, bQl3R, bEtran4R)
                    bQh1RCen:0L,$
                    bQk2RCen:0L,$
                    bQl3RCen:0L,$
                    bEtran4RCen:0L,$
                    ;step
                    bQh1RStep:0L,$
                    bQk2RStep:0L,$
                    bQl3RStep:0L,$
                    bEtran4RStep:0L,$
                    ;init
                    bQh1RInit:0L,$
                    bQk2RInit:0L,$
                    bQl3RInit:0L,$
                    bEtran4RInit:0L,$
                    ;final
                    bQh1RFinal:0L,$
                    bQk2RFinal:0L,$
                    bQl3RFinal:0L,$
                    bEtran4RFinal:0L,$

                    nptsfield:0L,$
                    scantypechooser:0L,$    ;exclusive cw_bgroup:   initial/final
                                            ;                       initial/step
                                            ;                       center/step
                                            ;npts specified in any of these three.


                    wSource_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSource1R:0L,$    ; = cw_field( wSource_value, /return_events, title = 'Source', xsize=2 $

                    wHorizontal_value:0L,$    ; = widget_base( tExperiment, frame = 3, /base_align_right, /column, xpad = 3 )

                    bSourceHFocus:0L,$    ; = cw_field( wHorizontal_value, /return_events, title = 'Horizontal focus', xsize=2 $


                    buttbase:0L,$    ;=widget_base(tlb, row=1)
                    buttcalculate1:0L, $    ;=widget_button(buttbase, value='Calculate RM' $

                    scanvals:scanvals}


end;cwo_scanparms__define

function cwo_scanparms,parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _ref_extra=extra


    obj = obj_new('cwo_scanparms',parent,$
                        horizontal=horizontal,$
                        collimatorh=collimatorh,$
                        collimatorv=collimatorv,$
                        mosaic=mosaic,$
                        dspacing=dspacing,$
                        qetrans = qetrans,$
                        orient = orient,$
                        ;
                        tlb=tlb,$
                        xsize=xsize,$
                        ysize=ysize,$
                        uvalue=uvalue,$
                        uname=uname,$
                        title=title,$
                        xtitle=xtitle,$
                        ytitle=ytitle,$
                        kill_notify=kill_notify,$
                        obj=obj,$
                        _extra=extra)

    obj->getproperty,tlb=tlb
    return,tlb

    ;print,'HEY!!!!!!'

end;cwo_scanparms