; $Id$
;###############################################################################
; LICENSE:
;  The software in this file is written by an employee of 
;  National Institute of Standards and Technology 
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used or if the code in this file is
;  included in another product.
;
;###############################################################################
pro qxwellipse, rm

th = findgen(1001) * (0.001 *2.0 *!pi)
p1=rm[2,2]-rm[2,1]^2/rm[1,1]
p2=rm[0,0]-rm[0,1]^2/rm[1,1]
p3=2*(rm[2,0]-rm[2,1]*rm[0,1]/rm[1,1])
rt=sqrt(2*alog(2)/(p1*cos(th)^2+p2*sin(th)^2+p3*sin(th)*cos(th)))
y=rt*cos(th)
x=rt*sin(th)
title=textoidl("q_x - \omega")
xtitle=textoidl("q_x")
ytitle=textoidl("\omega")
plot,x,y, title=title, xtitle=xtitle, ytitle=ytitle
polyfill,x,y,color=150
rc=sqrt(2*alog(2)/(rm[2,2]*cos(th)^2+rm[0,0]*sin(th)^2 $
+2*rm[2,0]*sin(th)*cos(th)))
y1=rc*cos(th)
x1=rc*sin(th)
oplot, x1, y1

end