; $Id$
;###############################################################################
;
; NAME:
;  OSIRISSIMDETGROUPWIDGET
;
; PURPOSE:
;  Dialog widget that returns an array of detector numbers.
;
; CATEGORY:
;  DAVE, OSIRISSIM, utility
;
; AUTHOR:
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;Based on the Program  HFBSDETGROUPWIDGET.pro by:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
; OSIRISSIMDetGroupWidget.pro
;
; Function widget that allows user to select grouping of detectors
; for OSIRISSIM.
;
; HFBSDETGROUPWIDGET.pro Written by R.M.Dimeo (11/19/01)
;
; Modification history
; -----------------------
; 11/30/01 (RMD): Fixed an annoying bug that zeroed all detector
; groups out.
;
; 01/17/02 (RMD): Fixed another annoying quirk that caused the
; widget NOT to display the saved grouping values until an event
; was generated.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupQuit,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet
case event.id of
(*pState).accept:     begin
                      end
(*pState).cancel:     begin
                    detArray = intarr(ndet,ndet)
                    for i = 0,ndet-1 do begin
                        detArray[i,i] = 1
                        *(*pState).selDetPtr = detArray
                    endfor
               end
else:
endcase
widget_control,event.top,/destroy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupOnes,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet
thisArray = intarr(ndet,ndet)
  for i = 0,ndet-1 do begin
    thisArray[i,i] = 1
  ;  *selDetPtr = detArray
  endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = (*pState).ndet

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupTwos,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (2*i+1) le ndet-1 then begin
  thisArray[i,2*i:2*i+1] = 1
  num+=1
  endif
  if (2*i) le ndet-1 and (2*i+1) gt ndet-1 then begin
  thisArray[i,2*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupFives,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (5*i+4) le ndet-1 then begin
  thisArray[i,5*i:5*i+4] = 1
  num+=1
  endif
  if (5*i) le ndet-1 and (5*i+4) gt ndet-1 then begin
  thisArray[i,5*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num


widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupTens,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (10*i+9) le ndet-1 then begin
  thisArray[i,10*i:10*i+9] = 1
  num+=1
  endif
  if (10*i) le ndet-1 and (10*i+9) gt ndet-1 then begin
  thisArray[i,10*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupTwentys,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (20*i+19) le ndet-1 then begin
  thisArray[i,20*i:20*i+19] = 1
  num+=1
  endif
  if (20*i) le ndet-1 and (20*i+19) gt ndet-1 then begin
  thisArray[i,20*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupThirtys,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (30*i+29) le ndet-1 then begin
  thisArray[i,30*i:30*i+29] = 1
  num+=1
  endif
  if (30*i) le ndet-1 and (30*i+29) gt ndet-1 then begin
  thisArray[i,30*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupFourtys,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (40*i+39) le ndet-1 then begin
  thisArray[i,40*i:40*i+39] = 1
  num+=1
  endif
  if (40*i) le ndet-1 and (40*i+39) gt ndet-1 then begin
  thisArray[i,40*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupFiftys,event
widget_control,event.top,get_uvalue = pState
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (50*i+49) le ndet-1 then begin
  thisArray[i,50*i:50*i+49] = 1
  num+=1
  endif
  if (50*i) le ndet-1 and (50*i+49) gt ndet-1 then begin
  thisArray[i,50*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRIS_Group_every_Pro,event
widget_control,event.top,get_uvalue = pState
    widget_control,(*pState).group_every,get_value = group_every
    group_every=fix(group_every[0])
ndet = (*pState).ndet
num=0
thisArray = intarr(ndet,ndet)
for i = 0,ndet-1 do begin
  if (group_every*i+(group_every-1)) le ndet-1 then begin
  thisArray[i,group_every*i:group_every*i+(group_every-1)] = 1
  num+=1
  endif
  if (group_every*i) le ndet-1 and (group_every*i+(group_every-1)) gt ndet-1 then begin
  thisArray[i,group_every*i:ndet-1] = 1
  num+=1
  endif
endfor
*(*pState).selDetPtr = thisArray
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupAll,event
widget_control,event.top,get_uvalue = pState,/no_copy
ndet = (*pState).ndet

thisArray = intarr(ndet,ndet)
thisArray[0,0:ndet-1] = 1
*(*pState).selDetPtr = thisArray
num=1
widget_control,(*pState).num,set_value = num

widget_control,(*pState).grpSlider,get_value = grpValue
grpValue = fix(grpValue[0]-1)
widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]

widget_control,event.top,set_uvalue = pState,/no_copy
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRIS_ThetaVal,event
widget_control,event.top,get_uvalue = pState
    widget_control,(*pState).detnum,get_value = detnum
    if detnum eq '' then return
    detnum=fix(detnum[0])
    if detnum lt 0 then return
    if detnum gt (*pState).ndet then begin
    detnum = (*pState).ndet
    widget_control,(*pState).detnum,set_value = detnum
    endif
    ;print,detnum
    ;print,y
    theta=((*pState).y)[detnum-1]
    widget_control,(*pState).theta_value,set_value = theta
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRIS_SpecifiedValue,event
widget_control,event.top,get_uvalue = pState
  widget_control,(*pState).specific,get_value = specific
ndet=(*pState).ndet
;print,specific
(*(*pState).selDetPtr)=opan_OSIRISSIM_selectgroups(specific,ndet)
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]
;print,total(dets,2)
;print,'outputdets =',dets
void=where(total((*(*pState).selDetPtr),2) gt 0,num)
widget_control,(*pState).num,set_value = num
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro OSIRISSIMDetGroupWidget_event,event
widget_control,event.top,get_uvalue = pState
; Update the check-boxes after changing the slider bar position
if event.id eq (*pState).grpSlider then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,set_value = (*(*pState).selDetPtr)[grpValue,*]
endif
if event.id eq (*pState).group then begin
  widget_control,(*pState).grpSlider,get_value = grpValue
  grpValue = fix(grpValue[0]-1)
  widget_control,(*pState).group,get_value = thisArray
  (*(*pState).selDetPtr)[grpValue,*] = thisArray
sumcol=total((*(*pState).selDetPtr),2)
wherezero=where(sumcol eq 0,count)
num=(*pState).ndet-count
  widget_control,(*pState).num,set_value = num
endif
widget_control,event.top,set_uvalue = pState


if event.id eq (*pState).detnum then begin
OSIRIS_ThetaVal,event
endif
;
if event.id eq (*pState).group_every then begin
OSIRIS_Group_every_Pro,event
endif
;
if event.id eq (*pState).specific then begin
OSIRIS_SpecifiedValue,event
endif
;
;
return
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function OSIRISSIMDetGroupWidget,group_leader = group_leader,selDetPtr,y
; Widget definition module


if n_elements(*selDetPtr) eq 0 then begin
  ndet = 266
  selDetPtr = ptr_new(/allocate_heap)
  detArray = intarr(ndet,ndet)
  for i = 0,ndet-1 do begin
    detArray[i,i] = 1
  ;  *selDetPtr = detArray
  endfor

  *selDetPtr = detArray
endif else begin
  ptrSize = size(*selDetPtr)
  ndet = ptrSize[1]
  detArray = *selDetPtr
endelse
void=where(total(detArray,2) gt 0,numb)


if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,tlb_frame_attr = 1,title = 'Group Detectors',/base_align_right)
endif else begin
  tlb = widget_base(/modal,/col,tlb_frame_attr = 1,title = 'Group Detectors',group_leader = group_leader)
endelse
;base1 = widget_base(tlb,/row,/base_align_right)
base1 = widget_base(tlb,/row)
group_every=cw_field(base1,xsize=4,title = 'Group Every:',value=1,/return_events)
specific=cw_field(base1,xsize=25,title = 'Specify Grouping:',value='1-10,11-18,19-78',/return_events)
void = widget_button(base1,value = 'Group all',event_pro = 'OSIRISSIMDetGroupAll')
;void = widget_button(base1,value = 'One per group',event_pro = 'OSIRISSIMDetGroupOnes')
;void = widget_button(base1,value = 'Group every two',event_pro = 'OSIRISSIMDetGroupTwos')
;void = widget_button(base1,value = 'Group every five',event_pro = 'OSIRISSIMDetGroupFives')
;void = widget_button(base1,value = 'Group every ten',event_pro = 'OSIRISSIMDetGroupTens')
;void = widget_button(base1,value = 'Group every twenty',event_pro = 'OSIRISSIMDetGroupTwentys')
;void = widget_button(base1,value = 'Group every thirty',event_pro = 'OSIRISSIMDetGroupThirtys')
;void = widget_button(base1,value = 'Group every fourty',event_pro = 'OSIRISSIMDetGroupFourtys')
;void = widget_button(base1,value = 'Group every fifty',event_pro = 'OSIRISSIMDetGroupFiftys')
;base1a=widget_base(tlb,/row,/base_align_right)
base1a=widget_base(tlb,/row)
num=cw_field(base1a,xsize=4,title = 'Number of Groups:',value=numb,/noedit)
base1b=widget_base(tlb,/row)
;base1b=widget_base(tlb,/row,/base_align_right)
detnum=cw_field(base1b,xsize=4,title = 'Detector Number:',value=1,/all_events)
theta_value=cw_field(base1b,xsize=8,title = ': Theta Value:',value=string(y[0]),/noedit)
;void = widget_button(base1a,value = 'Enter Specified Value',event_pro = 'OSIRIS_SpecifiedValue')
base2 = widget_base(tlb,/row)
base3 = widget_base(tlb,/row)
groupType = string(1+indgen(ndet))
group = cw_bgroup(base2,groupType,row=20,/nonexclusive,label_top = 'Detector',$
            frame = 1,set_value = detArray[0,*])
grpSlider = widget_slider(base3,value = 1,minimum = 1,maximum = ndet,title = 'Group')
accept = widget_button(base3,value = 'Accept',event_pro = 'OSIRISSIMDetGroupQuit')
cancel = widget_button(base3,value = 'Cancel',event_pro = 'OSIRISSIMDetGroupQuit')
centertlb,tlb
widget_control,tlb,/realize

state = {accept:accept,$
            cancel:cancel,$
            group:group,$
            ndet:ndet,$
            grpSlider:grpSlider,$
            selDetPtr:selDetPtr,$
            detnum:detnum, $
             group_every:group_every, $
           theta_value:theta_value, $
            y:y, $
            num:num, $
            specific:specific}

pState = ptr_new(state)
widget_control,tlb,set_uvalue = pState
xmanager,'OSIRISSIMDetGroupWidget',tlb
selDetPtr = (*pState).selDetPtr
ptr_free,pState
thisSize = size(*selDetPtr)
nx = thisSize[1] & ny = thisSize[2]
yout = 0*intarr(nx,ny)
for i = 0,nx-1 do begin
  yout[i,0:ny-1] = (*selDetPtr)[i,0:ny-1]
endfor
return,yout
end

