; $Id$
pro test_nse_restore, filename
compile_opt idl2

if (n_elements(filename) eq 0) then begin
  filename = dialog_pickfile(/read,/must_exist,filter=['*.sav'])
endif

if (filename eq '') then return

restore, filename, /RELAXED_STRUCTURE_ASSIGNMENT
; should restore:
; xindex,yindex,qchoiceindex,data_dir,work_dir,nse_container

help, nse_container
help, xindex, yindex, qchoiceindex, data_dir, work_dir

if (~obj_valid(nse_container)) then return

n = nse_container->Count()
if (n le 0) then return

for i = 0,n-1 do begin
  obj = nse_container->get(position=i)
  if (~obj_valid(obj)) then continue

  ; retrieve fit params
  fitParmsPtr = obj->GetProperty(tag='fitparms')
  fitParms = (*fitParmsPtr)
  help,fitParms

  ; retrieve mask2d
  mask2d = obj->getMask2D(0)
  help,mask2d

  ; retrieve mask1d
  mask1d = obj->getMask1D(0)
  help,mask1d

endfor

end