; $Id$


pro ooDisplayEcho::sumMultipleEchoFiles,event

help,event
  



catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = ['An error or unusual condition was encountered at ',$
            'ooDisplayEcho::sumMultipleEchoFiles (in file ooDisplayEcho__sumMultipleEchoFiles)!']

    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]

    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)

    catch, /cancel
    return
endif


  fn = dialog_pickfile(path=self.data_dir,filter='*.echo',dialog_parent=self.atlb,/multiple)
  


        if fn[0] ne '' then begin

          ;PROGRESS BAR
          widget_control,self.facilityBGroup,get_value=facilityIndex
          ;ELIMINATE THE 'try file' OPTION.  NOW FACLILITY INDEX IS
          ;0 or 1.  ADD 1 to the index to make it consistent throughtout.
          facilityIndex = facilityIndex+1
          
          prog = nse_cwo_progress(labels=['File Number:'],$
                                 startvalues=[0L],$
                                 endvalues=[long(n_elements(fn))],$
                                 values=[0L],$
                                 steps=[1L],$
                                 obj=progobj,$
                                 title='Reading Echo Files:   ',$
                                 dialog_parent=self.atlb)

          goodcount = 0
          for n=0,n_elements(fn)-1 do begin
                                        ;/mark_directory)
            ;ADD NEW DATA OBJECT TO dataContainer
            ;
            ;WHAT HAPPENS IF FILE DOES NOT EXIST?????
            count = self.dataContainer->count()

            widget_control,self.atwnarcs,get_value = narcs

            ttemp = obj_new('ooEchoMagnetic',filename = fn[n],$
                                                narcs = fix(narcs),magnetic=0,facility=facilityIndex)

            ;REMOVING t=0.0 BEFORE ADDING TO DISPLAY.
            thetimes = *(ttemp->getproperty(tag='fouriertime'))
            if (where(thetimes eq 0.0))[0] ne -1 then begin
                temp = ttemp->removeT(0.0,/firstread)
                obj_destroy,ttemp
            endif else begin
                temp = ttemp
                ;self.dataContainer->add,ttemp,position = count
            endelse

      
      
            help,temp,output = tout
            if goodcount eq 0 then begin
              if not stregex(tout,'NULL',/fold_case,/boolean) then begin
                goodcount = 1
                self.data_dir = file_dirname(fn[n]);,$
                newobj = temp
                etemp = *(temp->getproperty(tag='eorig'))
                ptemp = (temp->getproperty(tag='preset'))
                ctemp = *(temp->getproperty(tag='counters'))
              endif
            endif else begin
              if not stregex(tout,'NULL',/fold_case,/boolean) then begin
                goodcount = 1
                etemp += *(temp->getproperty(tag='eorig'))
                ptemp += (temp->getproperty(tag='preset'))
                ctemp += *(temp->getproperty(tag='counters'))
                obj_destroy,temp
              endif
                
            endelse

            progobj->set,0,n
            stopped = progobj->checkStop()
            if stopped ne 0 then begin
              print,'File reader stopped by user.'
              widget_control,prog,/destroy
              break
            endif

          endfor;n


          count = self.dataContainer->count()
          self.dataContainer->add,newobj,position = count

          newobj->setproperty,'eorig',ptr_new(etemp)
          newobj->setproperty,'preset',ptemp
          newobj->setproperty,'counters',ptr_new(ctemp)


          widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,set_value= 0

          newobj->bin,factor=2

          ;UPDATE THE GAUSSIAN WIDTH WITH THE CURRENT
          ;VALUE FOR EACH NEW FILE READ IN.
          widget_control,self.atwwidth,get_value=swidth
          newobj->setWidth,double(swidth)
          newobj->setproperty,'workdir',self.work_dir
          newobj->setproperty,'datadir',self.data_dir
          
          oldfn = newobj->getProperty(tag='filename')
          newobj->setproperty,'filename',oldfn+'_sum'

          self.gaussianwidth = double(swidth)


          ;SET BEAM CENTER VALUES HERE BASED ON
          ;MATCHING LAMBDA

          lambda = (self.dataContainer->get(position= $
                  count))->getProperty(tag='lambda')
          lambdaTol = 0.03*lambda   ; set tol to 3% of lambda
          for i=0,count-1 do begin
              lambdao = (self.dataContainer->get(position=$
                      i))->getProperty(tag='lambda')
              if (abs(lambda - lambdao) le lambdaTol) then begin
                  self->setBeamCenter,i,count
              endif
          endfor;i


          if not stregex(tout,'NULL',/fold_case,/boolean) then begin

              self->setDataParameters,$
                self.dataContainer->get(position=count),$
                    n = count
          endif;not stregex


          
          the_count = self.datacontainer->count()
          if the_count gt 0 then begin
                self->reDefineWidgets,count,/newsize
                self->redefineTree
                self->draw
          endif;the_count
            ;widget_control,readerBase,/destroy
          if widget_info(prog,/valid_id) gt 0 then widget_control,prog,/destroy


        endif else begin
          print,'NO VALID FILES SELECTED.'

        endelse


end;ooDisplayEcho::sumMultipleEchoFiles


