; $Id$




function Oodisplayecho::handleTreeContextMultipleSelectREMOVEMULTIPLEOBJ,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectREMOVEMULTIPLEOBJ'
  ;print,uval.id ;SORT AND THEN REMOVE HIGHEST POSITION FIRST.  NO NEED TO STORE REFID'S SINCE THESE ITEMS REMOVED.
  Print,selected,refids
  ssort = Reverse(Sort(selected))
  sselected = selected[ssort]
  for i=0,N_elements(sselected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ;ref = self.datacontainer->get(position=selected[i])
    ref = self.datacontainer->Get(position=sselected[i])
    self.datacontainer->Remove,position=sselected[i]
    Obj_destroy,ref

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate



    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i



  Return,1
end;function ooDisplayEcho::handleTreeContextMultipleSelectREMOVEMULTIPLEOBJ




pro Oodisplayecho::MultiselectPhaseImportDialogEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::MultiselectPhaseImportDialogEvents
  ;
  ;PURPOSE:
  ;           Handle various "list" events.  These events may come from
  ;           phase import, IQT, and set selection dialogs.
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;


  ;    print,'ListEvent'

  Widget_control,Event.id,get_uvalue=obj

  case obj.id of
    'OKBUTTON':begin

      ;print,'OKBUTTON????'
      Widget_control,self.phaseimportlist,get_uvalue=pil
      objIndexList = pil.list

      index=Widget_info(self.phaseimportlist,$
        /droplist_select)


      m=self.qchoiceindex
      n=objIndexList[index]

      ;NEED TO DETERMINE HERE IF THE DIMENSIONS
      ;OF THE CARBOPACK AND SAMPLE ARE THE
      ;SAME.  IF SO, IMPORT PHASES DIRECTLY.
      ;IF NOT, INTERPOLATE.
      ;
      ;HOLD ON. . .
      ;WHY NOT JUST ALWAYS INTERPOLATE EXCEPT WHEN
      ;DETECTOR BINNING IS NOT IDENTICAL????
      ;
      objTo = ((self.datacontainer)->Get(position=m))
      objFrom = ((self.datacontainer)->Get(position=n))

      self.fixed = self->Getfixed()

      savefixed = self.fixed


      ;GET THE FIX/VARY PHASE VALUE FROM THE WIDGET
      fixvaryphasedl = Widget_info(self.phaseimportbase,$
        find_by_uname='PHASEIMPORTFIXVARYPHASE')

      if Widget_info(fixvaryphasedl,/droplist_select) eq 2 then begin
        ;FIT PHASE OFFSET
        self.fixed[2] = 1
        fitphaseoffset = 1
      endif else begin
        self.fixed[2] = Widget_info(fixvaryphasedl,/droplist_select)
        fitphaseoffset = 0
      endelse


      ;GET THE FIX/VARY PERIOD VALUE FROM THE WIDGET
      fixvaryperioddl = Widget_info(self.phaseimportbase,$
        find_by_uname='PHASEIMPORTFIXVARYPERIOD')

      self.fixed[4] = Widget_info(fixvaryperioddl,/droplist_select)

      allownegamp = Widget_info(self.phaseimportbase,$
        find_by_uname='ALLOWNEGATIVEAMPLITUDECHECKBOX')
      Widget_control,allownegamp,get_value=negamp

      forcenegamp = Widget_info(self.phaseimportbase,$
        find_by_uname='FORCENEGATIVEAMPLITUDECHECKBOX')
      Widget_control,forcenegamp,get_value=forcenegamp

      Widget_control,self.phaseimportbase,/destroy

      Widget_control,self.atwphase,get_value=sphaseoffset
      phaseoffset = Double(sphaseoffset)  ;ALWAYS 0.0 SINCE THIS TEXT BOX IS NOT SHOWN.
      Widget_control,self.atwomega,get_value=somega

      ;120904
      ;CONVERT PERIOD TO OMEGA.
      ;print,omega
      omega = 1.0/Double(somega)

      ;print,omega
      ;1) GET fixed VALUES FROM GUI AND PASS TO
      ;   DATA OBJECT HERE.
      ;
      ;2) PASS VALUE IN PHASE OFFSET BOX IF NON-ZERO.


      ;LRK - 11/12/09
      ;UPDATE THE NEXT SECTION TO GET THE INFORMATION AND RETURN IT SO
      ;THAT THE CALLING ROUTINE CAN COLLECT IT AND PROCESS ALL THE DATA OBJECTS
      ;IN ONE LOOP.
      ;
      ;---------------------------------------------------------------------------------
      ;                        (self.dataContainer->get(position=$
      ;                                m))->fitAllFixedPhase,$
      ;                                objFrom,$
      ;                                fixed=self.fixed,$
      ;                                startparms=startparms,$
      ;                                obj=self,$
      ;                                phaseoffset = phaseoffset,$
      ;                                fitphaseoffset=fitphaseoffset,$
      ;                                omega=omega,$
      ;                                allownegamp=negamp,$
      ;                                forcenegamp=forcenegamp
      ;
      ;                        self.fixed = savefixed  ;THIS IS IRRELEVANT NOW THAT
      ;                                                ;"fixed"
      ;                        self->redefineTree
      ;                        self->redefineWidgets,self.QChoiceIndex
      ;                        self->draw
      ;---------------------------------------------------------------------------------


    end
    'CANCELBUTTON':begin
      Widget_control,self.phaseimportbase,/destroy
    end
    else:begin
    end
  endcase


end;MultiselectPhaseImportDialogEvents
pro Multiselectphaseimportbasecleanup,base
  ;
  ;NAME:
  ;        MultiselectPhaseImportBaseCleanup
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'pib Cleanup'
  Widget_control,base,get_uvalue=pib
  ;    print,base,self.atlb
  Call_method,pib.method,pib.object,pib.event

end;MultiselectPhaseImportBaseCleanup

pro Oodisplayecho::Multiselectdefinephaseimportdialog
  ;
  ;NAME:
  ;        ooDisplayEcho::MultiselectDefinePhaseImportDialog
  ;
  ;PURPOSE:
  ;           Create a dialog to select the data object to import phases from
  ;           for fitting.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;
  ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
  ;
  ;;;

  refo = self.datacontainer->Get(position=self.qchoiceindex)
  theList = ['']
  objIndexList = [0]
  for i = 0,self.datacontainer->Count()-1 do begin
    refi = self.datacontainer->Get(position=i)
    if (refo)->Matches(refi) $
      and (i ne self.qchoiceindex) $
      and (refi->Getproperty(tag='type') ne 3) $ ;ONLY SELECT FROM NON-CELL DATA
      then begin
      ;                            print,$
      ;                            (self.dataContainer->get(position=$
      ;                                i))->getProperty(tag='filename')

      ;ADD SUCCESSFUL ITEMS TO THE LIST, BUT ADD RESOLUTION FILES TO BEGINNING.
      if (refi->Getproperty(tag='type') eq 1) and $
        (N_elements(theList) gt 1) then begin
        theList[0] =File_basename(refi->Getproperty(tag='filename'))
        objIndexList[0] = i
        theList = $
          ['',theList]
        objIndexList = [0,objIndexList]
      endif else begin
        theList = $
          [theList,File_basename(refi->Getproperty(tag='filename'))]
        objIndexList = [objIndexList,i]
      endelse

    endif
  endfor
  if N_elements(theList) gt 1 then begin
    theList = theList[1:*]
    objIndexList = objIndexList[1:*]

    self.phaseimportbase = Widget_base(group_leader = self.atlb,$
      $;xsize=156,ysize=140,$
      /modal,/col,$;/grid_layout,$
      title='SELECT PHASE SET')

    subBase = Widget_base(self.phaseimportbase,/column)
    self.phaseimportlist = Widget_droplist(subBase,$
      value=theList,$
      ysize=25,xsize = 250,$
      uvalue = {object:self,$
      method:'MultiselectPhaseImportDialogEvents',$
      id:'PHASEIMPORTLIST',$
      list:objIndexList})

    fixvaryphaselist = Widget_droplist(subBase,$
      title='phase',$
      value=['vary','fix','fit phase offset (constant phase)'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPHASE',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPHASE',$
      list:objIndexList})

    ;111405
    ;SET FIX/VARY BASED ON OBJ TYPE:
    ;0
    ;
    refotype = refo->Getproperty(tag='type')
    ;print,'refotype=',refotype
    Widget_control,fixvaryphaselist, SET_DROPLIST_SELECT=0

    fixvaryperiodlist = Widget_droplist(subBase,$
      title='period',$
      value=['vary','fix'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPERIOD',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPERIOD',$
      list:objIndexList})
    Widget_control,fixvaryperiodlist, SET_DROPLIST_SELECT=1



    allowNegAmpCheckbox = Cw_bgroup(subBase,$
      'Allow Small Opposite-Sign Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    forceNegAmpCheckbox = Cw_bgroup(subBase,$
      'Force Negative Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'FORCENEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'FORCENEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    Widget_control,allownegampcheckbox,set_value=1

    okButton = Widget_button(subBase,value = 'OK',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'MultiselectPhaseImportDialogEvents',$
      id:'OKBUTTON',$
      list:objIndexList})
    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'MultiselectPhaseImportDialogEvents',$
      id:'CANCELBUTTON',$
      list:objIndexList})


    Widget_control,self.phaseimportbase,/realize


    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.phaseimportbase,$
      top:self.phaseimportbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.phaseimportbase,set_uvalue=$
      {object:self,$
      method:'MultiselectPhaseImportDialogEvents',$
      id:'CANCELBUTTON',$
      list:objIndexList,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.phaseimportbase,/no_block,$
      cleanup='MultiselectPhaseImportBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Data Objects.')
  endelse

end;MultiselectDefinePhaseImportDialog

pro Multiselectphaseimportdialog_getoneinfo_event,Event
  Widget_control,Event.handler,get_uvalue=pstate

  case Event.id of
    (*pstate).tlb:
    (*pstate).ok:Widget_control,(*pstate).tlb,/destroy
    (*pstate).cancel:Widget_control,(*pstate).tlb,/destroy
    else:
  endcase

end;MultiselectPhaseImportDialog_getOneInfo_event
function Multiselectphaseimportdialog_getoneinfo,thisfile,dialog_parent,thelist,objindexlist
  tlb = Widget_base(title='Phase input for '+thisFile,group_leader=dialog_parent)
  ok = Widget_button(tlb,value='OK',xsize=300)
  cancel = Widget_button(tlb,value='Cancel',xsize=300)
  Centertlb,tlb
  Widget_control,tlb,/realize

  ;NOW SET UP THE DROPLISTS AND CHECKBOXES AND THIS IS READY TO GO!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


  state = {tlb:tlb,ok:ok,cancel:cancel}
  pstate = Ptr_new(state)
  Widget_control,tlb,set_uvalue=pstate
  buttonId = 0L
  x = 0
  Xmanager,'MultiselectPhaseImportDialog_getOneInfo',tlb
  state = *pstate  ;EXTRACT DATA FROM POINTER
  Ptr_free,pstate  ;CLEAN UP POINTER
  Return,State
end;MultiselectPhaseImportDialog_getOneInfo

function Multiselectdefinephaseimportdialog,n,datacontainer,dialog_parent

  Print,'selection indices=',n
  dc = datacontainer
  nobj = N_elements(n)

  ;STORE INDICES FOR EVERYTHING IN ARRAYS AND PASS TO CALLING FUNCTION AS A STRUCTURE
  resChoices = Intarr(nobj)
  phasefixvary  = Intarr(nobj)
  periodfixvary = Intarr(nobj)
  allowsmallnegamp = Intarr(nobj)
  forcenegamp = Intarr(nobj)
  thisfile = Strarr(nobj) ;CURRENT FILE TO FIT
  resfile = Strarr(nobj)  ;RES FILE NAME SELECTED FOR PHASE INPUTS (SHOULD CORRESPOND EXACTLY TO resChoices INDICES)
  ;NEEDED FOR TABLE DISPLAY


  ;GET THE INFO FOR EACH ONE
  for j = 0,N_elements(n)-1  do begin
    refo = dc->Get(position=n[j])
    thisFile[j] = File_basename(refo->Getproperty(tag='filename'))

    theList = ['']
    objIndexList = [0]
    for i = 0,dc->Count()-1 do begin
      refi = dc->Get(position=i)
      if (refo)->Matches(refi) $
        and (i ne n[j]) $
        and (refi->Getproperty(tag='type') ne 3) $ ;ONLY SELECT FROM NON-CELL DATA
        then begin

        ;ADD SUCCESSFUL ITEMS TO THE LIST, BUT ADD RESOLUTION FILES TO BEGINNING.
        if (refi->Getproperty(tag='type') eq 1) and $
          (N_elements(theList) gt 1) then begin
          theList[0] =File_basename(refi->Getproperty(tag='filename'))
          objIndexList[0] = i
          theList = $
            ['',theList]
          objIndexList = [0,objIndexList]
        endif else begin
          theList = $
            [theList,File_basename(refi->Getproperty(tag='filename'))]
          objIndexList = [objIndexList,i]
        endelse

      endif
    endfor
    if N_elements(theList) gt 1 then begin
      theList = theList[1:*]
      objIndexList = objIndexList[1:*]
      Print,'theList=',thelist
      Print,'objIndexList=',objIndexList
    endif

    ;NOW INFORMATION IS AVAILABLE TO PRODUCE INPUT DIALOG:
    duh = Multiselectphaseimportdialog_getoneinfo(thisfile[j],dialog_parent,thelist,objindexlist)
    Help,duh
  endfor;j



  ;PRESENT A TABLE

  ;WAIT FOR GO/REDO SIGNAL

  ;RETURN THE NECESSARY INFO
  info = {reschoices:resChoices,phasefixvary:phasefixvary,periodfixvary:periodfixvary,$
    allowsmallnegamp:allowsmallnegamp,forcenegamp:forcenegamp}

  Return,info
end;MultiselectDefinePhaseImportDialog

;
;pro ooDisplayEcho::definePhaseImportDialog2
;;
;;NAME:
;;        ooDisplayEcho::definePhaseImportDialog
;;
;;PURPOSE:
;;           Create a dialog to select the data object to import phases from
;;           for fitting.
;;PARAMETERS:
;;           none
;;KEYWORDS:
;;           none
;
;
;    ;;
;    ;
;    ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
;    ;
;    ;;;
;
;    refo = self.dataContainer->get(position=self.QChoiceIndex)
;    theList = ['']
;    objIndexList = [0]
;    for i = 0,self.dataContainer->count()-1 do begin
;        refi = self.dataContainer->get(position=i)
;        if (refo)->matches(refi) $
;                    and (i ne self.QChoiceIndex) $
;                        and (refi->getproperty(tag='type') ne 3) $ ;ONLY SELECT FROM NON-CELL DATA
;                            then begin
;;                            print,$
;;                            (self.dataContainer->get(position=$
;;                                i))->getProperty(tag='filename')
;
;                            ;ADD SUCCESSFUL ITEMS TO THE LIST, BUT ADD RESOLUTION FILES TO BEGINNING.
;                            if (refi->getproperty(tag='type') eq 1) and $
;                                (n_elements(theList) gt 1) then begin
;                                theList[0] =file_basename(refi->getProperty(tag='filename'))
;                                objIndexList[0] = i
;                                theList = $
;                                    ['',theList]
;                                objIndexList = [0,objIndexList]
;                            endif else begin
;                                theList = $
;                                    [theList,file_basename(refi->getProperty(tag='filename'))]
;                                objIndexList = [objIndexList,i]
;                            endelse
;
;        endif
;    endfor
;    if n_elements(theList) gt 1 then begin
;        theList = theList[1:*]
;        objIndexList = objIndexList[1:*]
;
;        self.phaseImportBase = widget_base(group_leader = self.atlb,$
;                                            $;xsize=156,ysize=140,$
;                                            /modal,/col,$;/grid_layout,$
;                                            title='SELECT PHASE SET')
;
;        subBase = widget_base(self.phaseImportBase,/column)
;        self.phaseImportList = widget_droplist(subBase,$
;                                            value=theList,$
;                                            ysize=25,xsize = 250,$
;                                            uvalue = {object:self,$
;                                                      method:'listEvents',$
;                                                      id:'PHASEIMPORTLIST',$
;                                                      list:objIndexList})
;
;        fixvaryphaselist = widget_droplist(subBase,$
;                                            title='phase',$
;                                            value=['vary','fix','fit phase offset (constant phase)'],$
;                                            ysize=25,xsize = 250,$
;                                            uname = 'PHASEIMPORTFIXVARYPHASE',$
;                                            uvalue = {object:self,$
;                                                      method:'doNothing',$
;                                                      id:'PHASEIMPORTFIXVARYPHASE',$
;                                                      list:objIndexList})
;
;;111405
;;SET FIX/VARY BASED ON OBJ TYPE:
;;0
;;
;refotype = refo->getproperty(tag='type')
;;print,'refotype=',refotype
;        widget_control,fixvaryphaselist, SET_DROPLIST_SELECT=1
;
;        fixvaryperiodlist = widget_droplist(subBase,$
;                                            title='period',$
;                                            value=['vary','fix'],$
;                                            ysize=25,xsize = 250,$
;                                            uname = 'PHASEIMPORTFIXVARYPERIOD',$
;                                            uvalue = {object:self,$
;                                                      method:'doNothing',$
;                                                      id:'PHASEIMPORTFIXVARYPERIOD',$
;                                                      list:objIndexList})
;        widget_control,fixvaryperiodlist, SET_DROPLIST_SELECT=1
;
;
;
;        allowNegAmpCheckbox = cw_bgroup(subBase,$
;                                        'Allow Small Opposite-Sign Amplitudes',$
;                                        /nonexclusive,$
;                                        /no_release,$
;                                        uname = 'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
;                                        uvalue = {object:self,$
;                                                  method:'doNothing',$
;                                                  id:'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
;                                                  list:objIndexList})
;        forceNegAmpCheckbox = cw_bgroup(subBase,$
;                                        'Force Negative Amplitudes',$
;                                        /nonexclusive,$
;                                        /no_release,$
;                                        uname = 'FORCENEGATIVEAMPLITUDECHECKBOX',$
;                                        uvalue = {object:self,$
;                                                  method:'doNothing',$
;                                                  id:'FORCENEGATIVEAMPLITUDECHECKBOX',$
;                                                  list:objIndexList})
;        widget_control,allownegampcheckbox,set_value=1
;
;        okButton = widget_button(subBase,value = 'OK',$
;                                         xsize=150,ysize=50,$
;                                         uvalue = {object:self,$
;                                                   method:'listEvents',$
;                                                   id:'OKBUTTON',$
;                                                   list:objIndexList})
;        cancelButton = widget_button(subBase,value = 'Cancel',$
;                                             xsize=150,ysize=50,$
;                                             uvalue = {object:self,$
;                                                       method:'listEvents',$
;                                                       id:'CANCELBUTTON',$
;                                                       list:objIndexList})
;
;
;        widget_control,self.phaseImportBase,/realize
;
;
;        ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
;        dumEvent = { WIDGET_DROPLIST,$
;                         ID:self.phaseImportBase,$
;                         TOP:self.phaseImportBase,$
;                         HANDLER:0L, INDEX:0L }
;
;        ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
;        widget_control,self.phaseImportBase,set_uvalue=$
;                                            {object:self,$
;                                             method:'listEvents',$
;                                             id:'CANCELBUTTON',$
;                                             list:objIndexList,$
;                                             event:dumEvent}
;
;
;        xmanager,"ooDisplayEcho",self.phaseImportBase,/no_block,$
;                    cleanup='phaseImportBaseCleanup'
;
;    endif else begin
;
;        void = widget_message('No Suitable Data Objects.')
;    endelse
;
;end;definePhaseImportDialog2
;pro ooDisplayEcho::definePhaseImportDialogEventsNew,event
;;
;;NAME:
;;        ooDisplayEcho::definePhaseImportDialogEventsNew
;;
;;PURPOSE:
;;           Handle various "list" events.  These events may come from
;;           phase import, IQT, and set selection dialogs.
;;PARAMETERS:
;;
;;KEYWORDS:
;;
;
;
;;    print,'ListEvent'
;
;    widget_control,event.id,get_uvalue=obj
;
;    case obj.id of
;        'OKBUTTON':begin
;
;                        widget_control,self.phaseImportList,get_uvalue=pil
;                        objIndexList = pil.list
;
;                        index=widget_info(self.phaseImportList,$
;                                            /droplist_select)
;
;
;                        m=self.QChoiceIndex
;                        n=objIndexList[index]
;
;                        objTo = ((self.dataContainer)->get(position=m))
;                        objFrom = ((self.dataContainer)->get(position=n))
;
;                        ;SUPPLY CHECKBOX ON THE PHASE IMPORT WIDGET TO DECIDE IF
;                        ;PHASES WILL BE FIXED.
;
;                        ;NEED TO ASSUME PHASES WILL BE FIXED HERE, UNLESS, SEE ABOVE
;
;                        ;THIS MUST GET THE CURRENT VALUE OF fixed, WHICH TYPICALLY
;                        ;HAS THE PHASE VALUE SET TO VARY.
;                        self.fixed = self->getFixed()
;
;                        savefixed = self.fixed
;
;
;                        ;GET THE FIX/VARY PHASE VALUE FROM THE WIDGET
;                        fixvaryphasedl = widget_info(self.phaseImportBase,$
;                                        find_by_uname='PHASEIMPORTFIXVARYPHASE')
;        ;070505
;        ;NEED THIRD OPTION HERE TO CHOOSE TO FIT THE PHASE OFFSET.
;                        ;self.fixed[2] = widget_info(fixvaryphasedl,/droplist_select)
;                        if widget_info(fixvaryphasedl,/droplist_select) eq 2 then begin
;                            ;FIT PHASE OFFSET
;                            self.fixed[2] = 1
;                            fitphaseoffset = 1
;                        endif else begin
;                            self.fixed[2] = widget_info(fixvaryphasedl,/droplist_select)
;                            fitphaseoffset = 0
;                        endelse
;
;
;                        ;GET THE FIX/VARY PERIOD VALUE FROM THE WIDGET
;                        fixvaryperioddl = widget_info(self.phaseImportBase,$
;                                        find_by_uname='PHASEIMPORTFIXVARYPERIOD')
;
;                        self.fixed[4] = widget_info(fixvaryperioddl,/droplist_select)
;
;                        allownegamp = widget_info(self.phaseImportBase,$
;                                        find_by_uname='ALLOWNEGATIVEAMPLITUDECHECKBOX')
;                        widget_control,allownegamp,get_value=negamp
;
;                        forcenegamp = widget_info(self.phaseImportBase,$
;                                        find_by_uname='FORCENEGATIVEAMPLITUDECHECKBOX')
;                        widget_control,forcenegamp,get_value=forcenegamp
;
;;print,'NEGAMP=',negamp
;
;                        widget_control,self.phaseImportBase,/destroy
;
;                        widget_control,self.atwphase,get_value=sphaseoffset
;                        ;print,sphaseoffset
;                        phaseoffset = double(sphaseoffset)  ;ALWAYS 0.0 SINCE THIS TEXT BOX IS NOT SHOWN.
;                        widget_control,self.atwomega,get_value=somega
;                        ;print,somega
;
;;120904
;;CONVERT PERIOD TO OMEGA.
;;print,omega
;                        omega = 1.0/double(somega)
;
;;print,omega
;                        ;1) GET fixed VALUES FROM GUI AND PASS TO
;                        ;   DATA OBJECT HERE.
;                        ;
;                        ;2) PASS VALUE IN PHASE OFFSET BOX IF NON-ZERO.
;
;                        (self.dataContainer->get(position=$
;                                m))->fitAllFixedPhase,$
;                                objFrom,$
;                                fixed=self.fixed,$
;                                startparms=startparms,$
;                                obj=self,$
;                                phaseoffset = phaseoffset,$
;                                fitphaseoffset=fitphaseoffset,$
;                                omega=omega,$
;                                allownegamp=negamp,$
;                                forcenegamp=forcenegamp
;
;;021406
;;BY POLLING THE DATA OBJECT FOR THE fixed STATE, THERE IS NO NEED TO
;;DO ANYTHING HERE TO HANDLE THE EXTRA fix/vary OPTIONS.
;
;
;                        ;print,self.fixed
;                        ;UPDATE ALL DISPLAYS
;                        self.fixed = savefixed  ;THIS IS IRRELEVANT NOW THAT
;                                                ;"fixed"
;                        self->redefineTree
;                        self->redefineWidgets,self.QChoiceIndex
;                        self->draw
;
;
;                    end
;        'CANCELBUTTON':begin
;                        widget_control,self.phaseImportBase,/destroy
;                    end
;        else:begin
;        endelse
;        endcase
;end;ooDisplayEcho::definePhaseImportDialogEventsNew

pro Phaseimportbasecleanupnew_event,Event

  Print,'phaseImportBaseCleanupNew_event'
  Help,Event,/struct

  Widget_control,Event.handler,get_uvalue=pstate

  case Event.id of
    (*pstate).ok:begin
      Print,'ok'
      Widget_control,(*pstate).allownegampcheckbox,get_value=AllowNegAmp
      Widget_control,(*pstate).forcenegampcheckbox,get_value=ForceNegAmp

      FixVaryPhase = Widget_info((*pstate).fixvaryphaselist,/droplist_select)
      FixVaryPeriod = Widget_info((*pstate).fixvaryperiodlist,/droplist_select)

      objIndexList = (*pstate).objindexlist
      Widget_control,(*pstate).phaseimportlist,get_value=pilVal

      pilvalselect = Widget_info((*pstate).phaseimportlist,/droplist_select)

      ;print,'pilVal=',pilVal[pilvalselect]

      ;print,'objIndexList[pilVal]=',objIndexList[pilValSelect]

      ;help,(*pstate).RESULTS,/struct
      (*pstate).results.doit = 1
      (*pstate).results.resindex  = objindexlist(pilValSelect);pilValselect
      (*pstate).results.phaseoption = fixVaryPhase
      (*pstate).results.periodoption = fixVaryPeriod
      (*pstate).results.smalloppositeampoption = AllowNegAmp
      (*pstate).results.forcenegativeamp = ForceNegAmp
      (*pstate).results.doit = 1

      Widget_control,(*pstate).tlb,/destroy

      ;help,*pstate,/struct
    end;ok
    (*pstate).cancel:begin
      Print,'cancel'
      (*pstate).results.doit = 0
      Widget_control,(*pstate).tlb,/destroy
    end;cancel
    else:
  endcase
end;phaseImportBaseCleanupNew_event
pro Phaseimportbasecleanupnew,base
  ;
  ;NAME:
  ;        PhaseImportBaseCleanupNew
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'pib Cleanup'
  Widget_control,base,get_uvalue=pib
  ;    print,base,self.atlb
  Call_method,pib.method,pib.object,pib.event

end;PhaseImportBaseCleanupNew

function Oodisplayecho::definePhaseImportDialogNew,inputResults
  ;
  ;NAME:
  ;        ooDisplayEcho::definePhaseImportDialogNew
  ;
  ;PURPOSE:
  ;           Create a dialog to select the data object to import phases from
  ;           for fitting.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;
  ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
  ;
  ;;;
  currentIndex = inputResults.selectindex

  refo = self.datacontainer->Get(position=currentIndex);self.QChoiceIndex)
  thisFilename = File_basename(refo->Getproperty(tag='filename'))
  theList = ['']
  objIndexList = [0]
  for i = 0,self.datacontainer->Count()-1 do begin
    refi = self.datacontainer->Get(position=i)
    if (refo)->Matches(refi) $
      and (i ne currentIndex) $
      and (refi->Getproperty(tag='type') ne 3) $ ;ONLY SELECT FROM NON-CELL DATA
      then begin
      ;                            print,$
      ;                            (self.dataContainer->get(position=$
      ;                                i))->getProperty(tag='filename')

      ;ADD SUCCESSFUL ITEMS TO THE LIST, BUT ADD RESOLUTION FILES TO BEGINNING.
      if (refi->Getproperty(tag='type') eq 1) and $
        (N_elements(theList) gt 1) then begin
        theList[0] =File_basename(refi->Getproperty(tag='filename'))
        objIndexList[0] = i
        theList = $
          ['',theList]
        objIndexList = [0,objIndexList]
      endif else begin
        theList = $
          [theList,File_basename(refi->Getproperty(tag='filename'))]
        objIndexList = [objIndexList,i]
      endelse

    endif
  endfor
  if N_elements(theList) gt 1 then begin
    theList = theList[1:*]
    objIndexList = objIndexList[1:*]

    self.phaseimportbase = Widget_base(group_leader = self.atlb,$
      $;xsize=156,ysize=140,$
      /modal,/col,$;/grid_layout,$
      title='SELECT PHASE SET for '+thisFilename)

    subBase = Widget_base(self.phaseimportbase,/column)
    self.phaseimportlist = Widget_droplist(subBase,$
      value=theList,$
      ysize=25,xsize = 250,$
      uvalue = {object:self,$
      method:'definePhaseImportDialogEventsNew',$
      id:'PHASEIMPORTLIST',$
      list:objIndexList})

    fixvaryphaselist = Widget_droplist(subBase,$
      title='phase',$
      value=['vary','fix','fit phase offset (constant phase)'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPHASE',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPHASE',$
      list:objIndexList})

    ;111405
    ;SET FIX/VARY BASED ON OBJ TYPE:
    ;0
    ;
    refotype = refo->Getproperty(tag='type')
    ;print,'refotype=',refotype
    Widget_control,fixvaryphaselist, SET_DROPLIST_SELECT=1

    fixvaryperiodlist = Widget_droplist(subBase,$
      title='period',$
      value=['vary','fix'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPERIOD',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPERIOD',$
      list:objIndexList})
    Widget_control,fixvaryperiodlist, SET_DROPLIST_SELECT=1



    allowNegAmpCheckbox = Cw_bgroup(subBase,$
      'Allow Small Opposite-Sign Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    forceNegAmpCheckbox = Cw_bgroup(subBase,$
      'Force Negative Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'FORCENEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'FORCENEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    Widget_control,allownegampcheckbox,set_value=1

    okButton = Widget_button(subBase,value = 'OK',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'definePhaseImportDialogEventsNew',$
      id:'OKBUTTON',$
      list:objIndexList})
    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'definePhaseImportDialogEventsNew',$
      id:'CANCELBUTTON',$
      list:objIndexList})


    Widget_control,self.phaseimportbase,/realize



    state = { tlb:self.phaseimportbase,$
      ok:okbutton,$
      cancel:cancelButton,$
      objindexlist:objIndexList,$
      thelist:theList,$
      phaseimportlist:self.phaseimportlist,$
      allownegampcheckbox:allownegampcheckbox,$
      forcenegampcheckbox:forcenegampcheckbox,$
      fixvaryperiodlist:fixvaryperiodlist,$
      fixvaryphaselist:fixvaryphaselist,$
      results:inputResults $
    }

    pstate = Ptr_new(state)
    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.phaseimportbase,set_uvalue=pstate


    Xmanager,"ooDisplayEcho",self.phaseimportbase,$;/no_block,$
      $;cleanup='phaseImportBaseCleanupNew',
      event_handler='phaseImportBaseCleanupNew_event'

    ;widget_control,self.phaseimportbase,/destroy

    results = (*pstate).results
    inputResults=results
    Ptr_free,pstate
    Return,results
  endif else begin

    void = widget_message('No Suitable Data Objects.')
    results = inputResults
    results.doit = -1
    Return,results
  endelse

end;definePhaseImportDialogNew

function Oodisplayecho::getAtlbOffsets,xoffset=xoffset,yoffset=yoffset
  geom = Widget_info(self.atlb,/geometry)
  xoffset = geom.xoffset + geom.xsize/2 - 100
  yoffset = geom.yoffset + geom.ysize/2 - 100

  Return,[xoffset,yoffset]
end;ooDisplayEcho::getAtlbOffsets

function Oodisplayecho::handleTreeContextMultipleSelectFIT_ALL_SETS_WITH_SAME_RESOLUTION,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectFIT_ALL_SETS_WITH_SAME_RESOLUTION'
  Print,selected,refids

  ;  self->definePhaseImportDialog2
  ;  self->importPhases

  results = {selectindex:0,resindex:-1,phaseoption:1,periodoption:1,$
    smalloppositeampoption:1,forcenegativeamp:0,doit:0}
  results = Replicate(results,N_elements(selected))


  ;  info = MultiselectDefinePhaseImportDialog(selected,self.datacontainer,self.atlb)
  ;  help,info,/struct
  ;  print,info
  for i=0,N_elements(selected)-1 do begin

    results[i].selectindex = selected[i]
    input = results[i]
    duh = self->Definephaseimportdialognew(input)
    Print,input
    results[i] = input
    ;          help,duh
    ;          if duh eq -1 then begin
    ;            results[i].doIt = 0
    ;          endif else begin
    ;            results[i] = duh
    ;          endelse

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ;          ref = self.datacontainer->get(position=selected[i])

    ;  1) GET MATCHING OBJECTS
    ;
    ;    2) CREATE PHASE INPUT DIALOG
    ;    3) GET RESULTS FROM DIALOG
    ;    4) STORE RESULTS FOR BATCH PROCESSING
    ;
    ;  5) PROCESS ALL THE SELECTED ITEMS WITH THE INPUT PARAMETERS.


    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate



    ;         help,ref,output=refid
    ;         refseg = (strsplit(refid,'=',/extract))[1]
    ;         refids[i] = refseg
  endfor;i


  Print,'results=',results

  ;NOW START THE FITTING:
  offsets = self->Getatlboffsets()
  prog = Nse_cwo_progress(labels=['Data Set:'],$
    startvalues=[0L],$
    endvalues=[Long(N_elements(results))],$
    values=[0L],$
    steps=[1L],$
    obj=progobj,$
    title='Fit with Imported Phases:   ',$
    xoffset=offsets[0],yoffset=offsets[1]-150)

  for i=0,N_elements(results)-1 do begin
    Help,results[i],/struct
    self.fixed = self->Getfixed()
    savefixed = self.fixed
    progobj->Step,0
    stopped = progobj->Checkstop()
    if stopped ne 0 then begin
      Widget_control,prog,/destroy
      Return,0
    endif;stopped

    if results[i].doit eq 1 then begin
      Widget_control,self.atwphase,get_value=sphaseoffset
      phaseoffset = Double(sphaseoffset)  ;ALWAYS 0.0 SINCE THIS TEXT BOX IS NOT SHOWN.
      Widget_control,self.atwomega,get_value=somega
      omega = 1.0/Double(somega)
      fixed = self.fixed
      if results[i].phaseoption eq 2 then begin
        ;FIT PHASE OFFSET
        self.fixed[2] = 1
        fitphaseoffset = 1
      endif else begin
        self.fixed[2] = results[i].phaseoption
        fitphaseoffset = 0
      endelse


      self.fixed[4] = results[i].periodoption

      currentPosition = results[i].selectindex
      objfrom = self.datacontainer->Get(position=results[i].resindex)

      ;022210
      ;CHECK THE INPUTS
      Help,currentPosition,objfrom,self.fixed,startparms,self,phaseoffset,fitphaseoffset,omega,$
        results[i].smalloppositeampoption,results[i].forcenegativeamp
      (self.datacontainer->Get(position=$
        currentPosition))->Fitallfixedphase,$
        objFrom,$
        fixed=self.fixed,$
        startparms=startparms,$
        obj=self,$
        phaseoffset = phaseoffset,$
        fitphaseoffset=fitphaseoffset,$
        omega=omega,$
        allownegamp=results[i].smalloppositeampoption,$
        forcenegamp=results[i].forcenegativeamp
    endif;results[i]
    self.fixed = savefixed
  endfor;i
  if Widget_info(prog,/valid_id) then Widget_control,prog,/destroy
  Return,1
end;ooDisplayEcho::handleTreeContextMultipleSelectFIT_ALL_SETS_WITH_SAME_RESOLUTION
function Oodisplayecho::handleTreeContextMultipleSelectFIT_ALL_AS_RESOLUTION,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectFIT_ALL_AS_RESOLUTION'
  Print,selected,refids
  for i=0,N_elements(selected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ref = self.datacontainer->Get(position=selected[i])

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ref->Storefitparms
    ref_tavestate = ref->Report_timeaverage_state()
    Widget_control,self.atwwidth,get_value=myWidth
    Widget_control,self.atwperiod,get_value=myPeriod

    ref->Arcfit,tavestate=ref_tavestate,$
      sigma=myWidth,$
      period=myperiod



    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i
  Return,1
end





function Oodisplayecho::handleTreeContextMultipleSelectMERGE_SELECTED,selected,refids

  ;MERGE ALL SELECTED OBJECTS INTO A SINGLE NEW DATA OBJECT AND ADD IT TO THE DATA CONTAINER.
  if N_elements(selected) gt 1 then begin
    selected = selected[Sort(selected)]
    ref = (self.datacontainer->Get(position=selected[0]))

    Type = ref->Getproperty(tag='type')
    Q = ref->Getproperty(tag='q')
    X_dim = ref->Getproperty(tag='x_dim')
    Y_dim = ref->Getproperty(tag='y_dim')

    origobj = ref
    newobj = Obj_new()

    for i=1,N_elements(selected)-1 do begin

      thisref = (self.datacontainer->Get(position=selected[i]))

      myType = thisref->Getproperty(tag='type')
      myQ = thisref->Getproperty(tag='q')
      myX_dim = thisref->Getproperty(tag='x_dim')
      myY_dim = thisref->Getproperty(tag='y_dim')

      ;VALIDATE OBJECTS
      mergeable = 0
      if (myType eq Type) or (myType eq 0) then begin
        if (myQ eq Q) then begin
          if (myX_dim eq X_dim) and (myY_dim eq Y_dim) then begin
            mergeable = 1
          endif;dimension check
        endif;Q check
      endif;type check

      ;IF MERGEABLE THEN MERGE ELSE EXIT
      if mergeable eq 1 then begin
        newObj = origobj->Merge(thisref)
        if i gt 1 then Obj_destroy,origobj  ;DESTROY THE ORIGINAL OBJECT IF IT WAS CREATED IN THIS METHOD.
        origobj = newobj
      endif else begin
        void = Dialog_message('Unable to merge due to type, binning or q differences.',dialog_parent=self.atlb)
        if Obj_valid(newobj) gt 0 then Obj_destroy,newobj
        Return,0
      endelse
    endfor;i

  endif else begin
    void = Dialog_message('SELECT MULTIPLED OBJECTS FOR MERGING',dialog_parent=self.atlb)
    Return,0
  endelse


  if Obj_valid(newobj) gt 0 then begin
    self.datacontainer->Add,newobj
  endif
  Return,1
end;ooDisplayEcho::handleTreeContextMultipleSelectMERGE_SELECTED


function Oodisplayecho::handleTreeContextMultipleSelectSET_TYPE_TO_UNTYPED,selected,refids
  Print,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_TYPE_TO_UNTYPED'
  for i=0,N_elements(selected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ref = self.datacontainer->Get(position=selected[i])

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate
    ref->Setproperty,'type',0


    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_TYPE_TO_RESOLUTION,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_TYPE_TO_RESOLUTION'
  for i=0,N_elements(selected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ref = self.datacontainer->Get(position=selected[i])

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate
    ref->Setproperty,'type',1


    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_TYPE_TO_SAMPLE,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_TYPE_TO_SAMPLE'
  for i=0,N_elements(selected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ref = self.datacontainer->Get(position=selected[i])

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate
    ref->Setproperty,'type',2


    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i
  Print,selected,refids

  Print,selected,refids

  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_TYPE_TO_CELL,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_TYPE_TO_CELL'
  Print,selected,refids
  for i=0,N_elements(selected)-1 do begin

    ;LRK - 12/09/08
    ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

    ref = self.datacontainer->Get(position=selected[i])

    ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;help,event,/structure
    ;ref->storeFitparms
    ;ref_tavestate = ref->report_timeaverage_state()
    ;ref->arcFit,tavestate=ref_tavestate
    ref->Setproperty,'type',3


    Help,ref,output=refid,struct=0
    refseg = (Strsplit(refid,'=',/extract))[1]
    refids[i] = refseg
  endfor;i
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_IMPORTED_MASK_TO,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_IMPORTED_MASK_TO'
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_PARAMETER_VALUES_TO,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_PARAMETER_VALUES_TO'
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_RESOLUTION_FILE_TO,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_RESOLUTION_FILE_TO'
  Print,selected,refids
  Return,1
end
function Oodisplayecho::handleTreeContextMultipleSelectSET_CELL_FILE_TO,selected,refids
  Print,selected,refids
  Print,'ooDisplayEcho::handleTreeContextMultipleSelectSET_CELL_FILE_TO'
  Return,1
end

pro Oodisplayecho::handleTreeContextMultipleSelect,Event
  Print,'ooDisplayEcho::handleTreeContextMultipleSelect'
  Widget_control,Event.id,get_uvalue=uval
  Print,uval.id
  Help,uval,/struct
  sel_id = Widget_info(self.ftree,/tree_select)

  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=sel_uval
    ;ONLY USE FILES, NOT FOLDERS
    if sel_uval.id eq 'FTW' then begin
      selectindices = [selectindices,sel_uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))

    case Strupcase(uval.id) of
      ;'':self->,selected,refids
      'REMOVEMULTIPLEOBJ':begin
        Print,uval.id ;SORT AND THEN REMOVE HIGHEST POSITION FIRST.  NO NEED TO STORE REFID'S SINCE THESE ITEMS REMOVED.
        ;ACCOUNT FOR THIS BELOW.
        success = self->Handletreecontextmultipleselectremovemultipleobj(selected,refids)
      end
      'FIT_ALL_SETS_WITH_SAME_RESOLUTION':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectfit_all_sets_with_same_resolution(selected,refids)
      end
      'FIT_ALL_AS_RESOLUTION':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectfit_all_as_resolution(selected,refids)
      end
      'MERGE_SELECTED':begin
        success = self->Handletreecontextmultipleselectmerge_selected(selected,refids)
      end;MERGE_SELECTED
      'SET_TYPE_TO_UNTYPED':begin
        ;print,'HEY, SET_TYPE_TO_UNTYPED!'
        ;print,uval.id
        success = self->Handletreecontextmultipleselectset_type_to_untyped(selected,refids)
      end
      'SET_TYPE_TO_RESOLUTION':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_type_to_resolution(selected,refids)
      end
      'SET_TYPE_TO_SAMPLE':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_type_to_sample(selected,refids)
      end
      'SET_TYPE_TO_CELL':begin
        success = self->Handletreecontextmultipleselectset_type_to_cell(selected,refids)
        Print,uval.id
      end
      'SET_IMPORTED_MASK_TO':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_imported_mask_to(selected,refids)
      end
      'SET_PARAMETER_VALUES_TO':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_parameter_values_to(selected,refids)
      end
      'SET_RESOLUTION_FILE_TO':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_resolution_file_to(selected,refids)
      end
      'SET_CELL_FILE_TO':begin
        Print,uval.id
        success = self->Handletreecontextmultipleselectset_cell_file_to(selected,refids)
      end
      else:begin
        Print,uval.id
        success = 1
      endelse
    endcase

    Print,'success=',success

    ;START A COUNTER

    ;              for i=0,n_elements(selected)-1 do begin
    ;
    ;                  ;LRK - 12/09/08
    ;                  ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.
    ;
    ;                  ref = self.datacontainer->get(position=selected[i])
    ;
    ;                  ;print,i,selected[i],'ooDisplayEcho::handleMultipleTreeSelect  --- USED KEYWORDS OR EVENT OPTION TO CHOOSE HANDLING OPTION'
    ;                  ;help,event,/structure
    ;                  ;ref->storeFitparms
    ;                  ;ref_tavestate = ref->report_timeaverage_state()
    ;                  ;ref->arcFit,tavestate=ref_tavestate
    ;
    ;
    ;
    ;                  help,ref,output=refid
    ;                  refseg = (strsplit(refid,'=',/extract))[1]
    ;                  refids[i] = refseg
    ;              endfor;i
  endif
  self->Redefinetree


  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]

  if tids[0] gt 0 then begin
    for i=0,N_elements(tids)-1 do begin
      ctids = Widget_info(tids[i],/all_children)
      allids = [allids,ctids]
    endfor;i
    if N_elements(allids) gt 1 then allids = allids[1:*]
    for i=0,N_elements(allids)-1 do begin
      Widget_control,allids[i],get_uvalue=uval
      tags = Tag_names(uval)
      Help,uval.dataobject,output=nowout,struct=0
      nowsegs = Strsplit(nowout,'=',/extract)
      match = Where(nowsegs[1] eq refids)
      if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

    endfor;i
  endif



end;ooDisplayEcho::handleMultipleTreeSelect



pro Oodisplayecho::autoFitAllResolution,Event
  Print,'REMOVE THIS LATER, IT IS ONLY BECAUSE I HAD A TYPO DURING TESTING'
  self->Autofitallasresolution,Event
end;pro ooDisplayEcho::autoFitAllResolution
pro Oodisplayecho::autoFitAllAsResolution,Event
  Print,'ooDisplayEcho::autoFitAllAsResolution'
  Help,Event,/struct

  sel_id = Widget_info(self.ftree,/tree_select)

  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))
    ;START A COUNTER

    for i=0,N_elements(selected)-1 do begin

      ;LRK - 12/09/08
      ;NOW INSTEAD OF SETTING THE TYPE I CALL THE FITALL ROUTINE.

      ref = self.datacontainer->Get(position=selected[i])



      ref->Storefitparms
      ref_tavestate = ref->Report_timeaverage_state()
      ref->Arcfit,tavestate=ref_tavestate



      Help,ref,output=refid,struct=0
      refseg = (Strsplit(refid,'=',/extract))[1]
      refids[i] = refseg
    endfor;i
  endif
  self->Redefinetree


  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]
  for i=0,N_elements(tids)-1 do begin
    ctids = Widget_info(tids[i],/all_children)
    allids = [allids,ctids]
  endfor;i
  if N_elements(allids) gt 1 then allids = allids[1:*]
  for i=0,N_elements(allids)-1 do begin
    Widget_control,allids[i],get_uvalue=uval
    tags = Tag_names(uval)
    Help,uval.dataobject,output=nowout,struct=0
    nowsegs = Strsplit(nowout,'=',/extract)
    match = Where(nowsegs[1] eq refids)
    if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

  endfor;i



end;ooDisplayEcho::autoFitAllAsResolution
pro Oodisplayecho::setAllToUntyped,Event

  sel_id = Widget_info(self.ftree,/tree_select)

  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))
    for i=0,N_elements(selected)-1 do begin
      ref = self.datacontainer->Get(position=selected[i])
      ref->Setproperty,'type',0
      Help,ref,output=refid,struct=0
      refseg = (Strsplit(refid,'=',/extract))[1]
      refids[i] = refseg
    endfor;i
  endif
  self->Redefinetree


  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]
  for i=0,N_elements(tids)-1 do begin
    ctids = Widget_info(tids[i],/all_children)
    allids = [allids,ctids]
  endfor;i
  if N_elements(allids) gt 1 then allids = allids[1:*]
  for i=0,N_elements(allids)-1 do begin
    Widget_control,allids[i],get_uvalue=uval
    tags = Tag_names(uval)
    Help,uval.dataobject,output=nowout,struct=0
    nowsegs = Strsplit(nowout,'=',/extract)
    match = Where(nowsegs[1] eq refids)
    if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

  endfor;i


end;ooDisplayEcho::setAllToUnTyped
pro Oodisplayecho::setAllToResolution,Event
  Print,'ooDisplayEcho::setAllToResolution'
  sel_id = Widget_info(self.ftree,/tree_select)

  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))
    for i=0,N_elements(selected)-1 do begin
      ref = self.datacontainer->Get(position=selected[i])
      ref->Setproperty,'type',1
      Help,ref,output=refid,struct=0
      refseg = (Strsplit(refid,'=',/extract))[1]
      refids[i] = refseg
    endfor;i
  endif
  self->Redefinetree


  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]
  for i=0,N_elements(tids)-1 do begin
    ctids = Widget_info(tids[i],/all_children)
    allids = [allids,ctids]
  endfor;i
  if N_elements(allids) gt 1 then allids = allids[1:*]
  for i=0,N_elements(allids)-1 do begin
    Widget_control,allids[i],get_uvalue=uval
    tags = Tag_names(uval)
    Help,uval.dataobject,output=nowout,struct=0
    nowsegs = Strsplit(nowout,'=',/extract)
    match = Where(nowsegs[1] eq refids)
    if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

  endfor;i

end;ooDisplayEcho::setAllToResolution
pro Oodisplayecho::setAllToSample,Event
  Print,'ooDisplayEcho::setAllToSample'
  sel_id = Widget_info(self.ftree,/tree_select)


  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))
    for i=0,N_elements(selected)-1 do begin
      ref = self.datacontainer->Get(position=selected[i])
      ref->Setproperty,'type',2
      Help,ref,output=refid,struct=0
      refseg = (Strsplit(refid,'=',/extract))[1]
      refids[i] = refseg
    endfor;i
  endif
  self->Redefinetree


  Print,'self.ftree=',self.ftree
  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]
  for i=0,N_elements(tids)-1 do begin
    ;print,'i,tids children=',i,widget_info(tids[i],/all_children)
    ctids = Widget_info(tids[i],/all_children)
    allids = [allids,ctids]
  endfor;i
  ;print,'alltids=',allids
  if N_elements(allids) gt 1 then allids = allids[1:*]
  ;print,allids
  ;refs = self.datacontainer->get(/all)
  ;for i=0,n_elements(refs)-1 do begin
  ;
  ;  help,refs[i],output=out
  ;  outseg = (strsplit(out,'=',/extract))[1]
  ;  match = where(outseg eq refids)
  ;  if match ne -1 then widget_control,
  ;endfor;i

  for i=0,N_elements(allids)-1 do begin
    Widget_control,allids[i],get_uvalue=uval
    tags = Tag_names(uval)


    ;LRK 120508
    ;ADDED THE TAG dataObject TO EACH OF THE BOTTOM LEAF uvalues.
    ;NOW THE SEARCH FOR SELECTIONS WORKS WITHOUT CHANGING THE FUNCTIONALITY!!!!
    ;NOW APPLY THIS TO ALL OF THE OPERATIONS!!!!!!!
    Help,uval.dataobject,output=nowout,struct=0
    nowsegs = Strsplit(nowout,'=',/extract)
    match = Where(nowsegs[1] eq refids)
    Print,match,nowsegs[1],refids
    if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

  endfor;i

end;ooDisplayEcho::setAllToSample
pro Oodisplayecho::setAllToCell,Event
  Print,'____________________________________________________'
  Print,'ooDisplayEcho::setAllToCell'
  sel_id = Widget_info(self.ftree,/tree_select)

  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    refids = Strarr(N_elements(selected))
    for i=0,N_elements(selected)-1 do begin
      ref = self.datacontainer->Get(position=selected[i])
      ref->Setproperty,'type',3
      Help,ref,output=refid,struct=0
      refseg = (Strsplit(refid,'=',/extract))[1]
      refids[i] = refseg
    endfor;i
  endif
  self->Redefinetree


  tids = Widget_info(self.ftree,/all_children)
  allids = [-1]
  for i=0,N_elements(tids)-1 do begin
    ctids = Widget_info(tids[i],/all_children)
    allids = [allids,ctids]
  endfor;i
  if N_elements(allids) gt 1 then allids = allids[1:*]
  for i=0,N_elements(allids)-1 do begin
    Widget_control,allids[i],get_uvalue=uval
    tags = Tag_names(uval)
    Help,uval.dataobject,output=nowout,struct=0
    nowsegs = Strsplit(nowout,'=',/extract)
    match = Where(nowsegs[1] eq refids)
    if match[0] ne -1 then Widget_control,allids[i],set_tree_select=1

  endfor;i


end;ooDisplayEcho::setAllToCell
pro Oodisplayecho::setImportedMaskTo,Event
  Print,'ooDisplayEcho::setImportedMaskTo'
  Help,Event,/struct
end;ooDisplayEcho::setImportedMaskTo
pro Oodisplayecho::setParameterValuesTo,Event
  Print,'ooDisplayEcho::setParameterValuesTo'
  Help,Event,/struct
end;ooDisplayEcho::setParameterValuesTo
pro Oodisplayecho::setResolutionFileTo,Event
  Print,'ooDisplayEcho::setResolutionFileTo'
  Help,Event,/struct

end;ooDisplayEcho::setResolutionFileTo
pro Oodisplayecho::setCellFileTo,Event

  Print,'_______________________________________________________'
  Print,'*******************************************************'
  Print,'ooDisplayEcho::setCellFileTo'
  Help,Event,/struct

  sel_id = Widget_info(self.ftree,/tree_select)


  ;REMOVE FOLDER ID'S
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    ;ONLY USE FILES, NOT FOLDERS
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i

  ;NOW LOOK AT NON-FOLDER SELECTIONS:
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    for i=0,N_elements(selected)-1 do begin
      Print,'SELECT THE OBJECT AND DO THE ACTION!!!!'
      Print,selected[i]
      ref = self.datacontainer->Get(position=selected[i])
      comm = ref->Getproperty(tag='comment')
      Print,comm
      ;self->remove,dataObjIndex=selected[i]
    endfor;i
  endif


  Print,'_______________________________________________________'
  Print,'*******************************************************'


end;ooDisplayEcho::setCellFileTo



pro Oodisplayecho::defineContextMenus
  ;
  ;NAME:
  ;        ooDisplayEcho::defineContextMenus
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;
  ;
  ;UPDATE THIS TO DEAL WITH THE CONCEPT OF SETS.
  ;
  ;

  contextBaseS = Widget_base(self.atlb,/context_menu,uname='STW_MENU',/col)
  button1S = Widget_button(contextBaseS,value='CALCULATE I(Q,t)',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SETIQTCALC'})
  button2S = Widget_button(contextBaseS,value='Change Name',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SETCHANGENAME'})
  button3S = Widget_button(contextBaseS,value='Remove Set',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SETREMOVESET'})
  ;    button4S = widget_button(contextBaseS,value='Remove Object From Set',$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'SETREMOVEOBJECT'})
  ;    button5S = widget_button(contextBaseS,value='Change Q Value ',$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'SETSETQVALUE'})



  ;###########################################################################################
  ;022406
  ;
  contextBaseF_multi = Widget_base(self.atlb, /CONTEXT_MENU,uname='FTW_MULTI_MENU',$
    kill_notify='oodisplayecho_contextmenudestroy',/col)

  noInfoMulti = Widget_button(contextBaseF_multi,value='REMOVE SELECTED DATASETS',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'contextMenuEvents',$
    id:'REMOVEMULTIPLEOBJ'})

  noInfoMulti = Widget_button(contextBaseF_multi,value='FIT_ALL_SETS_WITH_IMPORTED_PHASES',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'contextMenuEvents',$
    id:'FIT_ALL_SETS_WITH_SAME_RESOLUTION'})

  noInfoMulti = Widget_button(contextBaseF_multi,value='FIT ALL AS RESOLUTION',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'autoFitAllAsResolution',$
    id:'FIT_ALL_AS_RESOLUTION'})


  typeMulti = Widget_button(contextBaseF_multi,value='SET TYPE TO:',/menu)

  noInfoMulti = Widget_button(typeMulti,value='UNTYPED',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'setAllToUntyped',$
    id:'SET_TYPE_TO_UNTYPED'})

  noInfoMulti = Widget_button(typeMulti,value='RESOLUTION',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'setAllToResolution',$
    id:'SET_TYPE_TO_RESOLUTION'})

  noInfoMulti = Widget_button(typeMulti,value='SAMPLE',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'setAllToSample',$
    id:'SET_TYPE_TO_SAMPLE'})

  noInfoMulti = Widget_button(typeMulti,value='CELL',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'setAllToCell',$
    id:'SET_TYPE_TO_CELL'})

  noInfoMulti = Widget_button(contextBaseF_multi,value='MERGE ALL SELECTED',$
    uvalue = {object:self,$
    method:'handleTreeContextMultipleSelect',$;'autoFitAllAsResolution',$
    id:'MERGE_SELECTED'})


  ;    noInfoMulti = widget_button(contextBaseF_multi,value='SET IMPORTED MASK TO',$
  ;                                            uvalue = {object:self,$
  ;                                                  method:'handleTreeContextMultipleSelect',$;'setImportedMaskTO',$
  ;                                                  id:'SET_IMPORTED_MASK_TO'})
  ;
  ;    noInfoMulti = widget_button(contextBaseF_multi,value='SET PARAMETER VALUES TO',$
  ;                                            uvalue = {object:self,$
  ;                                                  method:'handleTreeContextMultipleSelect',$;'setParameterValuesTo',$
  ;                                                  id:'SET_PARAMETER_VALUES_TO'})
  ;
  ;    noInfoMulti = widget_button(contextBaseF_multi,value='SET RESOLUTION FILE TO',$
  ;                                            uvalue = {object:self,$
  ;                                                  method:'handleTreeContextMultipleSelect',$;'setResolutionFileTo',$
  ;                                                  id:'SET_RESOLUTION_FILE_TO'})
  ;
  ;    noInfoMulti = widget_button(contextBaseF_multi,value='SET CELL FILE TO',$
  ;                                            uvalue = {object:self,$
  ;                                                  method:'handleTreeContextMultipleSelect',$;'setCellFileTo',$
  ;                                                  id:'SET_CELL_FILE_TO'})



  ;WANT TO ADD A MULTIPLE SELECTION CONTEXT MENU
  ;###########################################################################################


  contextBaseF = Widget_base(self.atlb, /CONTEXT_MENU,uname='FTW_MENU',kill_notify='oodisplayecho_contextmenudestroy',/col)
  setTypeButton = Widget_button(contextBaseF,$
    value='Select data set type',/menu)

  button1F = Widget_button(setTypeButton,$;contextBaseF, $
    VALUE='Untyped',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'UNTYPED'})
  button2F = Widget_button(setTypeButton,$;contextBaseF, $
    VALUE='Resolution',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'RESOLUTION'})
  button3F = Widget_button(setTypeButton,$;contextBaseF, $
    VALUE='Sample',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'RAWDATA'})
  button4F = Widget_button(setTypeButton,$;contextBaseF, $
    VALUE='Cell',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'BACKGROUND'})
  ;050704
  ;111704
  ;
  ;COMMENT OUT A FEW OF THE NEXT BUTTONS FOR NOW
  ;UNTIL SETS AND MERGING ARE AVAILABLE AND DEBUGGED.

  ;061505
  ;;;;
  ;;;;    setOperationsButton = widget_button(contextBaseF,value='Set Operations',/menu)
  ;;;;
  ;;;;    button5F = WIDGET_BUTTON(setOperationsButton,$;contextBaseF, $
  ;;;;                                        VALUE='Assign Object to a Set',$
  ;;;;                                        sensitive=0,$
  ;;;;                                        uvalue = {object:self,$
  ;;;;                                                  method:'contextMenuEvents',$
  ;;;;                                                  id:'ASSIGNOBJ'})
  ;;;;
  ;;;;    button7F = WIDGET_BUTTON(setOperationsButton,$;contextBaseF, $
  ;;;;                                        VALUE='Create New Set',$
  ;;;;                                        sensitive=0,$
  ;;;;                                        uvalue = {object:self,$
  ;;;;                                                  method:'contextMenuEvents',$
  ;;;;                                                  id:'OBJNEWSET'})

  objOperationsButton = Widget_button(contextBaseF,value='Dataset Operations',/menu)


  button6Fa = Widget_button(objOperationsButton,$;contextBaseF, $
    VALUE='Merge Datasets',$
    sensitive=1,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'MERGEOBJ'})

  button6F = Widget_button(objOperationsButton,$;contextBaseF, $
    VALUE='Remove Dataset',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'REMOVEOBJ'})

  button6F = Widget_button(objOperationsButton,$;contextBaseF, $
    VALUE='Duplicate Dataset',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'DUPLICATEOBJ'})

  ;LRK 110708
  ;MOVED THIS OPTION TO THE Dataset OPERATIONS MENU

  ;CHANGE THE NEXT BUTTON TO CALL A LIST WIDGET.
  button6Fb = Widget_button(objOperationsButton, VALUE='Remove Fourier Times',$
    sensitive=1,menu=0,$;menu=1,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'REMOVEFOURIERTIMEMENU'});,$
  ;kill_notify='oodisplayecho_contextmenudestroy')


  file_button1 = Widget_button(objOperationsButton,$;contextBaseF,$
    value='Save Dataset',$
    uname="SAVEOBJECT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SAVEOBJECT',$
    parent:'FILEOPTIONS'})

  file_button1 = Widget_button(objOperationsButton,$;contextBaseF,$
    value='Restore Dataset',$
    uname="RESTOREOBJECT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'RESTOREOBJECT',$
    parent:'FILEOPTIONS'})




  ;    ;CHANGE THE NEXT BUTTON TO CALL A LIST WIDGET.
  ;    button6Fb = WIDGET_BUTTON(contextBaseF, VALUE='Remove Fourier Times',$
  ;                                        sensitive=1,menu=0,$;menu=1,$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'REMOVEFOURIERTIMEMENU'});,$
  ;                                                  ;kill_notify='oodisplayecho_contextmenudestroy')


  self.removefouriertimemenu = button6Fb
  ;print,'oodisplayecho::defineContextMenus self.removeFourierTimeMenu='+string(self.removeFourierTimeMenu)


  ;ADD I(Q,t) CALCULATION BUTTONS TO THE CONTEXT MENUS
  ;    button8F = widget_button(contextBaseF,$
  ;                                value='Calculate Q Values',$
  ;                                uname='CALCULATEQS',$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'CALCULATEQS',$
  ;                                        parent:'CALCULATIONOPTIONS'})


  button8Fit = Widget_button(contextBaseF,$
    $;value = 'Import Phases AND FIT ALL TAU',$
    value = 'Fit Operations',/menu)
  button8F = Widget_button(button8Fit,$;contextBaseF,$
    $;value = 'Import Phases AND FIT ALL TAU',$
    value = 'IMPORT PHASES (Sample,Cell)',$
    $;tooltip = 'Fit all echoes using phases from another data set',$
    $;ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'PHASEIMPORTBUTTON'})
  button8F = Widget_button(button8Fit,$;contextBaseF,$
    $;value = 'Import Phases AND FIT ALL TAU',$
    value = 'Fit Echoes (Resolution)',$
    $;tooltip = 'Fit all echoes using phases from another data set',$
    $;ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTONALL'})

  button9F = Widget_button(contextBaseF,$
    value='Calculate I(Q,t)',$
    uname='CALCULATEI',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEI',$
    parent:'CALCULATIONOPTIONS'})

  button9F = Widget_button(contextBaseF,$
    value='Calculate I(Q,t) Express (New and lightly tested)',$
    uname='CALCULATEIEXPRESS',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEIEXPRESS',$
    parent:'CALCULATIONOPTIONS'})


  contextsaveutilities = Widget_button(contextBaseF, VALUE='Save Utilities',$
    sensitive=1,menu=1,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SAVEUTILITIES'});,$

  button6Fb = Widget_button(contextsaveutilities, VALUE='Save Fit Parameters',$
    sensitive=1,menu=0,$;menu=1,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SAVEFITPARAMETERS'})
  button6Fb = Widget_button(contextsaveutilities, VALUE='Save Data Items',$
    sensitive=1,menu=0,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'SAVEDATAITEMS'})








  contextBaseFS = Widget_base(self.atlb, /CONTEXT_MENU,uname='FTW_MENU_S',/col)
  ;    button1FS = WIDGET_BUTTON(contextBaseFS, VALUE='Untyped',$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'UNTYPED'})
  button2FS = Widget_button(contextBaseFS, VALUE='Resolution',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'RESOLUTION'})
  button3FS = Widget_button(contextBaseFS, VALUE='Sample',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'RAWDATA'})
  button4FS = Widget_button(contextBaseFS, VALUE='Background',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'BACKGROUND'})
  button5FS = Widget_button(contextBaseFS, VALUE='Assign Object to a Set',$
    sensitive=0,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'ASSIGNOBJ'})
  button6FS = Widget_button(contextBaseFS, VALUE='Remove Object',$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'REMOVEOBJ'})
  button6FSa = Widget_button(contextBaseFS, VALUE='Merge Objects',$
    sensitive=0,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'MERGEOBJ'})


  ;ADD I(Q,t) CALCULATION BUTTONS TO THE CONTEXT MENUS
  button7FS = Widget_button(contextBaseFS,$
    sensitive=0,$
    value='Calculate Q Values',$
    uname='CALCULATEQS',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEQS',$
    parent:'CALCULATIONOPTIONS'})
  button8FS = Widget_button(contextBaseFS,$
    value='Calculate I(Q,t)',$
    uname='CALCULATEI',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEI',$
    parent:'CALCULATIONOPTIONS'})


  contextBaseQ = Widget_base(self.atlb, /CONTEXT_MENU,uname='QTW_MENU')
  button1Q = Widget_button(contextBaseQ, VALUE='Create New Set',$
    sensitive=0,$
    uvalue = {object:self,$
    method:'contextMenuEvents',$
    id:'QNEWSET'})
  ;    button2Q = WIDGET_BUTTON(contextBaseQ, VALUE='Remove This Q',$
  ;                                        sensitive=0,$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'REMOVEQ'})
  ;    button3Q = WIDGET_BUTTON(contextBaseQ, VALUE='Keep This Q',$
  ;                                        sensitive=0,$
  ;                                        uvalue = {object:self,$
  ;                                                  method:'contextMenuEvents',$
  ;                                                  id:'KEEPQ'})

end;defineContextMenus
