; $Id$
;###############################################################################
;
;CLASS NAME:
;    pro ooDisplayEcho__define,class
;
;PURPOSE:
;               To manipulate and visualize a neutron spin echo data object (ooEcho).
;CATEGORY:
;               Data Visualization, Analysis and Manipulation.
;SUPERCLASSES:
;               myProperties
;
;METHODS:
;    ooDisplayEcho::draw
;    ooDisplayEcho::imageVirtual
;    ooDisplayEcho::imageEbVirtual
;    ooDisplayEcho::demarkQs
;    ooDisplayEcho::xout
;    ooDisplayEcho::imageSubtitle
;    ooDisplayEcho::imagetitle
;    oodisplayecho::checkforAllInfinities
;    ooDisplayEcho::plotVirtual
;    ooDisplayEcho::printWindow
;    ooDisplayEcho::setDisplayImage
;    ooDisplayEcho::updateFitvals
;    ooDisplayEcho::realify
;    ooDisplayEcho::updateIndices
;    ooDisplayEcho::keyboardUpdateIndices
;    ooDisplayEcho::keyboardEvents
;    ooDisplayEcho::mouseGuts
;    ooDisplayEcho::mouseHead
;    ooDisplayEcho::mouseEvents
;    ooDisplayEcho::boxPixel
;    ooDisplayEcho::getPositionOnImage
;    ooDisplayEcho::getPositionOnPlot
;    ooDisplayEcho::getFixed
;    ooDisplayEcho::fitButtonHandler
;    ooDisplayEcho::shiftFit
;    ooDisplayEcho::updateMaskmaker
;    ooDisplayEcho::maskEvents
;    ooDisplayEcho::makeMaskmaker
;    ooDisplayEcho::maskCleanup
;    maskBaseCleanup
;    ooDisplayEcho::maskButtonHandler
;    ooDisplayEcho::buttonEvents
;    ooDisplayEcho::CDButtonHandler
;    ooDisplayEcho::sliderEvents
;    ooDisplayEcho::drawEvents
;    ooDisplayEcho::proximityEvents
;    ooDisplayEcho::setPixelIndices
;    ooDisplayEcho::importPhases
;    ooDisplayEcho::importExportButtonHandler
;    ooDisplayEcho::listEvents
;    ooDisplayEcho::displayIQTEvents
;    displayIQTBaseCleanup
;    ooDisplayEcho::displayIQT
;    ooDisplayEcho::setBeamCenter
;    ooDisplayEcho::restoreSession
;    ooDisplayEcho::saveSession
;    ooDisplayEcho::menuEvents
;    ooDisplayEcho::resizeAuxWindow
;    ooDisplayEcho::raiseAuxWindow
;    ooDisplayEcho::lowerAuxWindow
;    ooDisplayEcho::droplistEvents
;    ooDisplayEcho::handleFixDroplist
;    ooDisplayEcho::updateFitparmWidget
;    ooDisplayEcho::handleBinning
;    ooDisplayEcho::add
;    ooDisplayEcho::textEvents
;    ooDisplayEcho::handleFitparmTextWidgetEvents
;    ooDisplayEcho::getParmsFromTextWidgets
;    ooDisplayEcho::treeEvents
;    ooDisplayEcho::do_nothing
;    ooDisplayEcho::contextMenuEvents
;    ooDisplayEcho::remove
;    ooDisplayEcho::contextEvents
;    ooDisplayEcho::createTContext
;    ooDisplayEcho::createRemoveTList
;    ooDisplayEcho::swapDataObject
;    ooDisplayEcho::resetDataParameters
;    ooDisplayEcho::atlbEvents
;    ooDisplayEcho::doNothing
;    doNothing
;    ooDisplayEcho_event
;    ooDisplayEcho::setDataParameters
;    ooDisplayEcho::reDefineWidgets
;    ooDisplayEcho::resizeWidgets
;    ooDisplayEcho::defineWidgets
;    ooDisplayEcho::setSelectDialog
;    setSelectBaseCleanup
;    ooDisplayEcho::removeSetDialog
;    removeSetBaseCleanup
;    ooDisplayEcho::setNameEvents
;    ooDisplayEcho::setNameDialog
;    setNameBaseCleanup
;    ooDisplayEcho::CalculateIQTDialog
;    ooDisplayEcho::IQTImportEvents
;    CalculateIQTBaseCleanup
;    ooDisplayEcho::mergeEvents
;    ooDisplayEcho::MergeDialog
;    MergeBaseCleanup
;    ooDisplayEcho::definePhaseImportDialog
;    PhaseImportBaseCleanup
;    ooDisplayEcho::defineImageErrorBase
;    ooDisplayEcho::resizeImageErrorBase
;    ooDisplayEcho::ImageErrorBaseCleanup;
;    ImageErrorBaseCleanup
;    ooDisplayEcho::defineDrawWidgets
;    ooDisplayEcho::defineMenus
;    ooDisplayEcho::defineTextWidgets
;    ooDisplayEcho::dropTimes
;    ooDisplayEcho::dropTimeEvents
;    ooDisplayEcho::defineCDControls
;    ooDisplayEcho::defineMaskButton
;    ooDisplayEcho::defineFitWidgets
;    ooDisplayEcho::icon
;    ooDisplayEcho::createFTWLeaf
;    ooDisplayEcho::fillSet
;    ooDisplayEcho::redefineTree
;    ooDisplayEcho::defineContextMenus
;    ooDisplayEcho::defineTree
;    ooDisplayEcho::sortDataByQ
;    ooDisplayEcho::getContainer
;    ooDisplayEcho::get_notify_ids
;    ooDisplayEcho::lastChanceToSaveSession
;    ooDisplayEchoCleanup
;    ooDisplayEcho::cleanup
;    get_font_name
;    ooDisplayEcho::readparametersfile
;    ooDisplayEcho::writeparametersfile
;    ooDisplayEcho::init
;    ooDisplayEcho__define
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;
;       Title:          ooDisplayEcho.pro
;
;       Author:         Larry Kneller
;
;       Description:    This object widget is used to interact with
;                       neutron spin echo (NSE) data sets.
;
;       Last Update:    Ongoing!!!!
;
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::draw,xindex=xindex, yindex=yindex, tauindex=tauindex, $
  textfitparms = textfitparms,$;Av = Av, Amp = Amp, PHASE = PHASE, W = W, PERIOD = PERIOD, PHO = PHO,$
  no_update = no_update,plotxrange=plotxrange, plotyrange=plotyrange,$
  plotzoombox = plotzoombox,writeplotdataflag=writeplotdataflag,writeplotdatafile=writeplotdatafile,$
  tavestate=tavestate,$
  _Extra=extra
  ;
  ;NAME:
  ;           ooDisplayEcho::draw
  ;
  ;PURPOSE:
  ;           draw method --- updates image and plot.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           xindex[in]      x-coordinate index of selected pixel
  ;           yindex[in]      y-coordinate index of selected pixel
  ;           tauindex[in]    Fourier time index
  ;           Av              Fit parameters to use ifor plotting
  ;           Amp             in place of those available in fitparms.
  ;           PHASE
  ;           W
  ;           PERIOD
  ;           PHO
  ;           plotzoombox     Flag to draw a zoombox in the plot
  ;           textfitparms
  ;           no_update
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;;
  ;DRAW IMAGE AND PLOT AND ASSIGN POINTERS TO CORRECT AXES
  ;;;
  if N_elements(tavestate) eq 0 then Widget_control,self.timeaverageupdowncheckbox,get_value= tavestate

  if N_elements(plotxrange) ne 2 then plotxrange = 0
  if N_elements(plotyrange) ne 2 then plotyrange = 0
  if N_elements(plotzoombox) eq 0 then plotzoombox = 0

  if N_elements(writeplotdatafile) eq 0 then writeplotdatafile = '' ;else print,'ooDisplayEcho::draw: '+writeplotdatafile
  if N_elements(writeplotdataflag) eq 0 then writeplotdataflag = 0
  if writeplotdataflag eq 1 then begin
    if writeplotdatafile eq '' then writeplotdataflag = 0
  endif

  ; store current device settings
  Device,get_decomposed = dc, get_current_font=existing_font_name
  existing_font_setting = !P.font

  ; use Courier TT fonts instead of the default device fonts for direct graphics plots
  !P.font = 1
  Device, set_font='Courier Bold', /TT_FONT, set_character_size=[11,16]


  ;NEED TO HANDLE CASE WHERE self.xindex IS ALREADY VALID
  if (N_elements(xindex) eq 0) then begin
    if self.xindex lt self.detxdim then begin
      xindex = self.xindex
    endif else begin
      xindex = self.detxdim/2
    endelse
  endif

  if (N_elements(yindex) eq 0) then begin
    if self.yindex lt self.detydim then begin
      yindex = self.yindex
    endif else begin
      yindex = self.detydim/2
    endelse
  endif
  if N_elements(tauindex)  eq 0 then tauindex = self.ftchoiceindex
  if N_elements(no_update) eq 0 then no_update = 0

  self.ftchoiceindex = tauindex



  ;IMAGE AND FIT PARAMETER ITEMS
  if self.plotzoombox eq 0 then begin

    ;RESET IMAGE TO BE DISPLAYED
    self->Setdisplayimage

    ;WHY ISN'T THE NEXT STEP AVAILABLE IN SETDISPLAYIMAGE, MAYBE AS A
    ;RETURN VALUE FOR A FUNCTION????

    ;UPDATE tauindex TO REFLECT POTENTIAL VALUE CHANGES IN setDisplayImage
    tauindex = self.ftchoiceindex

    ;BOX CURRENTLY SELECTED PIXEL
    self->Boxpixel,xindex,yindex
    ;self.mouseMotionBlock = 0

    ;COPY VIRTUAL IMAGE FROM VIRTUAL WINDOW TO REAL WINDOW
    self->Realify,self.dw1pix,self.dw1id

    if self.errorimagechoice eq 1 then begin
      self->Imageebvirtual
      self->Realify,self.dwebpix,self.dwebid
    endif

    if no_update ne 1 then begin
      ;UPDATES WHEN PIXEL CHOICE CHANGES.
      self->Updatefitvals,self.xindex,self.yindex,self.ftchoiceindex,tavestate=tavestate
    endif

  endif;plotzoom


  ;PLOT ITEMS
  ;DRAW PLOT TO ITS PIXMAP
  self->Plotvirtual,xindex,yindex,tauindex, textfitparms = textfitparms,$
    plotxrange = plotxrange, plotyrange=plotyrange,$
    plotzoombox = plotzoombox,writeplotdataflag=writeplotdataflag,$
    writeplotdatafile=writeplotdatafile,tavestate=tavestate ;$
  ;Av = Av, Amp = Amp, PHASE = PHASE, W = W, PERIOD = PERIOD, PHO = PHO


  ;COPY VIRTUAL PLOT FROM PIXMAP WINDOW TO REAL WINDOW
  self->Realify,self.dw2pix,self.dw2id

  if Widget_info(self.Dw2auxbase,/valid_id) gt 0 then begin
    self->Realify,self.dw2auxpix,self.dw2auxid
  endif


  ; retore previous device ettings
  Device,decomposed = dc, set_font=existing_font_name
  !P.font=existing_font_setting

end;draw
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::imageVirtual
  ;
  ;NAME:
  ;           ooDisplayEcho::imageVirtual
  ;
  ;PURPOSE:
  ;           Create the virtual detector image with titles
  ;           in the pixmap for copy to the display window.
  ;PARAMETERS:
  ;           none.
  ;KEYWORDS:
  ;           none.


  Wset,self.dw1pix


  ;    plotImage,bytscl(*self.im,min=0.0)
  ;    plotImage,bytscl(alog(bytscl(*self.im,min=0.0,max = max(*self.im))+1.0))

  ;plotImage,bytscl(bytscl(*self.im,min=min(*self.im),max = max(*self.im)))

  Device,get_decomposed = dc
  Device,decomposed=0
  Tvlct,r,g,b,/get
  Loadct,self.colortable,/silent


  if self.datacontainer->Count() gt 0 then begin
    ft = (*((self.datacontainer->Get(position=$
      self.qchoiceindex))->Getproperty(tag=$
      'fourierTime')))[self.ftchoiceindex]
  endif else begin
    ft = 0.0
  endelse




  imsize = Size(*self.im)
  imrange = [Min(*self.im),Max(*self.im)]
  if imrange[0] eq imrange[1] then imrange[1] = imrange[1]+1.0
  bottomcolor = 0;50
  ;    plotImage,bytscl(*self.im,min=min(*self.im),max = max(*self.im)),$
  ;                title = self->imageSubtitle(),$
  ;                subtitle = self->imagetitle(),$
  ;                yrange=[imsize[1],0];,$
  ;                ;position = [0.2, 0.2, 0.9, 0.9]

  impos = [0.24,0.20,0.9,0.9]
  cbpos = [0.20,0.13,0.9,0.16]

  ;040505
  ;WILL THE NEXT COLORS WORK WITH decomposed = 0???
  ;
  ;PLOT IMAGE SEEMS TO REQUIRE A BLACK BACKGROUND.  HOW CAN I CHANGE THIS?
  Tvlct,rnow,gnow,bnow,/get

  ;042205
  ;
  ;EXPERIMENTING WITH SETTING BACKGROUND WHITE, FOREGROUND BLACK
  rnownew = rnow
  gnownew = gnow
  bnownew = bnow

  rnownew[0] = 255L
  gnownew[0] = 255L
  bnownew[0] = 255L

  ;SET THE MAXIMUM COLOR TO BLACK
  rnownew[255] = 0L
  gnownew[255] = 0L
  bnownew[255] = 0L

  Tvlct,rnownew,gnownew,bnownew

  ;CHANGE XOUT COLOR TO WHITE AND WE'RE ALL SET IGOR STYLE.


  black = 0L
  white = 255L + 256L*(255L + 256L*255L)

  ;042205
  ;BYTSCL TO AVOID THE MAXIMIMUM AND MINIMUM COLORS,
  ;SO BLACK IS AT THE BOTTOM OF DATA RANGE AND WHITE IS AT TOP OF DATA RANGE (1-254)
  ;WHILE WHITE IS AT THE ZEROTH COLOR AND BLACK IS AT THE TOP FOR CONVENIENCE
  ;OF THE GRAPH.
  theim = Bytscl(*self.im,top=253)+1B
  ;    plotImage,*self.im,range=imrange,$;bottom=black,$;bottomcolor,$
  ;                title = self->imageSubtitle(),$
  ;                subtitle = self->imagetitle(),$
  ;                yrange=[imsize[1],0],charsize=1.0,$;1.25,$
  ;                position = impos

  Plotimage,theim,range=imrange,$;bottom=black,$;bottomcolor,$
    title = self->Imagesubtitle(),$
    subtitle = self->Imagetitle(),$
    yrange=[imsize[1],0],charsize=1.0,$;1.25,$
    $;background = 255L, color = 0L,$
    position = impos

  ;042505
  ;THE COLORS MUST BE RESET HERE SO THAT THE TOP OF THE COLOR BAR IS WHITE
  ;AND THE BOTTOM IS BLACK.  USE THE BACKGROUND AND COLOR KEYWORDS TO
  ;SET THE BACKGROUND TO WHITE AND THE AXES TO BLACK

  ;RESET THE COLORS
  Tvlct,rnow,gnow,bnow

  case self.displayindex of
    3: format = '(f10.4)'
    8: format = '(f10.2)'
    else:format = '(I7)'
  endcase

  ;print,imrange

  ;090705
  ;THE NEXT LINES ARE NECESSARY TO PROTECT FROM CRASHES IN COLORBAR
  ;WHEN THERE ARE infinities IN THE DATA.

  ;010905
  ;WHY ARE string values assigned to imrange?
  ;    if imrange[1] eq double('Infinity') then imrange[1] = 10000000.0;'10000000.0'
  ;    if imrange[0] eq double('Infinity') then imrange[0] = 0.0;'0.0'
  ;    if imrange[0] eq -1.0*double('Infinity') then imrange[0] = -10000000.0;'-10000000.0'

  if Finite(imrange[1]) eq 0 then imrange[1] = 10000000.0
  if Finite(imrange[0]) eq 0 then imrange[0] = -10000000.0

  Colorbar,range=imrange,$;bottom=bottomcolor,$
    /vertical,format=format,charsize=0.75,$
    background = 255L, color = 0L,$
    position = cbpos


  ;RESET THE COLORS BEFORE CALLING ANOTHER METHOD.
  Tvlct,rnow,gnow,bnow

  self->Xout,self.ftchoiceindex
  self->Demarkqs


  ;RELEASE AXIS POINTERS FOR WINDOW
  Ptr_free,self.w1xptr
  Ptr_free,self.w1yptr

  ;RESET AXIS POINTERS FOR drawImage
  self.w1xptr = Ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
  self.w1yptr = Ptr_new(!y)           ;POINTERS TO PROPER AXES!!!

  Tvlct,r,g,b
  Device,decomposed = dc
end;imageVirtual
pro Oodisplayecho::imageEbVirtual
  ;
  ;NAME:
  ;        ooDisplayEcho::imageEbVirtual
  ;
  ;PURPOSE:
  ;           Produce pixmap of error bar image with titles to copy to real window.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  Device,get_decomposed = dc
  Device,decomposed=0
  Tvlct,r,g,b,/get
  Loadct,self.colortable,/silent
  Wset,self.dwebpix

  ;NEED TO CONSIDER A BETTER SCALE FOR THE
  ;ERROR BAR IMAGE SO IT IS ALWAYS VISIBLE.

  ft = (*((self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag=$
    'fourierTime')))[self.ftchoiceindex]

  imebsize = Size(*self.imeb)


  ;0300805
  ;
  ;CONVERT IMAGE ERROR BARS TO RELATIVE IMAGE ERROR BARS (i.e. self.imeb/self.im)
  ;---- ACTUALLY, HOLD OFF ON THIS SINCE THE IMAGE COULD EASILY BE ALL ZEROS,
  ;     WHICH WILL CRASH COLORBAR.  THIS NEEDS TO BE DONE WITH THOUGHT.
  ;


  imebrange = [Min(*self.imeb),Max(*self.imeb)]
  if imebrange[0] eq imebrange[1] then imebrange[1] = imebrange[1]+1
  bottomcolor = 0;50



  ;    imeb = *self.imeb/*self.im
  ;    imebrange = [min(imeb),max(imeb)]
  ;    if imebrange[0] eq imebrange[1] then imebrange[1] = imebrange[1]+0.0001
  ;    bottomcolor = 0;50


  ;040505
  ;WILL THE NEXT COLORS WORK WITH decomposed = 0???
  ;
  ;PLOT IMAGE SEEMS TO REQUIRE A BLACK BACKGROUND.  HOW CAN I CHANGE THIS?
  Tvlct,rnow,gnow,bnow,/get

  ;042205
  ;
  ;EXPERIMENTING WITH SETTING BACKGROUND WHITE, FOREGROUND BLACK
  rnownew = rnow
  gnownew = gnow
  bnownew = bnow

  rnownew[0] = 255L
  gnownew[0] = 255L
  bnownew[0] = 255L

  ;SET THE MAXIMUM COLOR TO BLACK
  rnownew[255] = 0L
  gnownew[255] = 0L
  bnownew[255] = 0L

  Tvlct,rnownew,gnownew,bnownew

  ;CHANGE XOUT COLOR TO WHITE AND WE'RE ALL SET IGOR STYLE.

  ;BYTSCL TO AVOID THE MAXIMIMUM AND MINIMUM COLORS,
  ;SO BLACK IS AT THE BOTTOM OF DATA RANGE AND WHITE IS AT TOP OF DATA RANGE (1-254)
  ;WHILE WHITE IS AT THE ZEROTH COLOR AND BLACK IS AT THE TOP FOR CONVENIENCE
  ;OF THE GRAPH.
  theim = Bytscl(*self.imeb,top=253)+1B


  impos = [0.24,0.20,0.9,0.9]
  cbpos = [0.20,0.13,0.9,0.16]
  Plotimage,theim,range=imebrange,$;bottom=bottomcolor,$
    title = self->Imagesubtitle()+' Error Bars',$
    subtitle = self->Imagetitle(),$
    yrange=[imebsize[1],0],$
    position = impos
  ;    plotImage,imeb,range=imebrange,bottom=bottomcolor,$
  ;                title = self->imageSubtitle()+' Error Bars',$
  ;                subtitle = self->imagetitle(),$
  ;                yrange=[imebsize[1],0],$
  ;                position = impos



  if Finite(imebrange[1]) eq 0 then imebrange[1] = 10000000.0
  if Finite(imebrange[0]) eq 0 then imebrange[0] = -10000000.0




  case self.displayindex of
    3: format = '(f10.4)'
    8: format = '(f10.2)'
    else:format = '(I7)'
  endcase





  Colorbar,range=imebrange,$;bottom=bottomcolor,$
    /vertical,format=format,charsize=0.75,$
    position = cbpos
  ;    colorbar,range=imebrange,bottom=bottomcolor,$
  ;             /vertical,format='(f7.4)',charsize=0.75,$
  ;             position = cbpos

  ;print,*self.imeb

  ;    plotImage,bytscl(*self.imeb,min=min(*self.imeb),max = max(*self.imeb)),$
  ;                title=self->imageSubtitle()+' Error Bars',$
  ;                subtitle = self->imagetitle(),$
  ;                yrange=[imebsize[1],0];,$
  ;
  ;    if (min(*self.imeb) eq max(*self.imeb)) then begin
  ;        minrange = min(*self.imeb)
  ;        maxrange = min(*self.imeb) + 1
  ;    endif else begin
  ;        minrange = min(*self.imeb)
  ;        maxrange = max(*self.imeb)
  ;    endelse
  ;
  ;    colorbar,range=[minrange,maxrange],$
  ;             /vertical,format = '(I7)',$
  ;            position = [0.2, 0.1, 0.9, 0.13]

  ;042205
  ;RESET THE COLORS
  Tvlct,rnow,gnow,bnow


  self->Xout,self.ftchoiceindex


  ;RELEASE AXIS POINTERS FOR WINDOW
  Ptr_free,self.webxptr
  Ptr_free,self.webyptr

  ;RESET AXIS POINTERS FOR Image
  self.webxptr = Ptr_new(!x)           ;MUST SET THESE HERE TO ASSIGN
  self.webyptr = Ptr_new(!y)           ;POINTERS TO PROPER AXES!!!

  Tvlct,r,g,b
  Device,decomposed = dc
end;imageEbVirtual
pro Oodisplayecho::demarkQs
  ;
  ;NAME:
  ;        ooDisplayEcho::demarkQs
  ;
  ;PURPOSE:
  ;           Show the regions of the image belonging to each Q-range.
  ;           Useful for seeing which pixels contribute at each Q.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  ;PLACE LINES ON IMAGE TO DENOTE REGIONS OF
  ;CONSTANT Q.
  ;PERHAPS THIS CAN BE TURNED ON/OFF WITH A BUTTON
  Device,get_decomposed = dc
  Device,decomposed=0
  Tvlct,r,g,b,/get
  ;;;;;
  Loadct,3,/silent


  if self.datacontainer->Count() gt 0 then begin
    ref = (self.datacontainer)->Get(position=self.qchoiceindex)

    ;110404
    ;THE NEXT LINE NEEDS TO CREATE A MATRIX THAT INDICATES
    ;THE CONSTANT-Q ARCS ON THE BASED ON THE NUMBER OF ARCS FOR
    ;I(Q,t) _NOT_ BASED ON THE ARCFIT MATRIX!!!!
    ;ref->calculateIndexMatrix,mat=mat
    ref->Calculatearcsqmatrix,arcmat=mat

  endif else begin
    mat = Indgen(self.detxdim*self.detydim)/self.detxdim


  endelse

  ;NOW LOOP THROUGH AND FIND BOUNDARIES FOR THE Q REGIONS
  ;
  ;FOR EACH PIXEL, LOOK AT NEIGHBORING PIXELS AND DRAW A LINE
  ;IN BETWEEN IF THEY ARE NOT THE SAME.

  ;print,'mat=',mat

  mat = Reform(mat,self.detxdim,self.detydim)

  ;print,'mat=',mat

  n_colors = Max(mat) ;SET THIS NUMBER OF COLORS TO DELIMIT
  ;THE REGIONS OF CONSTANT Q

  Device,decomposed=1

  ;    qcolor = -10
  ;    qcolor = 0
  thick = 2.0
  qcolor = 256L*256L*255L ;BLUE
  for i=0,self.detxdim-1 do begin
    for j=0,self.detydim-1 do begin

      if (i lt self.detxdim-1) then begin; and (i gt 0) then begin
        if (mat[i+1,j] ne mat[i,j]) then begin
          ;thecolor = qcolor - mat[i+1,j]*10
          thecolor = qcolor;0
          Plots,[i+1,i+1],$
            [j,j+1],$
            color = thecolor,$
            thick = thick
        endif
      endif

      ;            if (i gt 0) then begin
      ;                if (mat[i-1,j] ne mat[i,j]) then begin
      ;                    ;thecolor = qcolor - mat[i-1,j]*10
      ;                    thecolor = 0
      ;                    plots,[i-1,i-1],$
      ;                            [j,j+1],$
      ;                            color = thecolor,$
      ;                            thick = 1.0
      ;                endif
      ;            endif
      if (j lt self.detydim-1) then begin;and (j gt 0) then begin
        if (mat[i,j+1] ne mat[i,j]) then begin
          ;thecolor = qcolor - mat[i,j+1]*10
          ;thecolor = 0
          Plots,[i,i+1],$
            [j+1,j+1],$
            color = thecolor,$
            thick = thick
        endif
      endif

      ;            if (j gt 0) then begin
      ;                if (mat[i,j-1] ne mat[i,j]) then begin
      ;                    ;thecolor = qcolor - mat[i,j-1]*10
      ;                    thecolor=0
      ;                    plots,[i,i+1],$
      ;                          [j,j],$
      ;                          color = thecolor,$
      ;                          thick = 1.0
      ;                endif
      ;            endif

    endfor;j
  endfor;i
  Device,decomposed=0

  Tvlct,r,g,b
  Device,decomposed = dc

end;demarkQs

pro Oodisplayecho::xout,k
  ;
  ;NAME:
  ;        ooDisplayEcho::xout
  ;
  ;PURPOSE:
  ;           Cover over masked pixels with a specified color.
  ;PARAMETERS:
  ;           k   The selected Fourier tiem index.
  ;KEYWORDS:
  ;           none

  ;PUT X's OVER ALL MASKED PIXELS ON THE CURRENT IMAGE

  ;;;;;    ;GET THE CURRENT r,g,b VALUES TO
  ;;;;;    ;PROTECT THE COLOR TABLE OUTSIDE
  ;;;;;    ;OF THIS METHOD
  ;;;;;

  Device,get_decomposed = dc
  Device,decomposed=1
  Tvlct,r,g,b,/get

  ;print,'ooDisplayEcho::xout r = ',r
  ;print,'ooDisplayEcho::xout g = ',g
  ;print,'ooDisplayEcho::xout b = ',b
  ;;;;;

  ;    rnew = 0*r
  ;    gnew = r
  ;    bnew = 0*r
  ;    tvlct,rnew,gnew,bnew

  ;;;;;
  ;;;;;    ;ASSIGN THE COLOR SPECIFIED BY THE 3 INDICES TO
  ;;;;;    ;THE VALUE IN THE 4th INDEX.
  ;;;;;    ;
  ;;;;;    ;WHEN THE RED TEMPERATURE COLOR TABLE IS SELECTED,
  ;;;;;    ;ALL COLORS ARE MAPPED ONTO THE 0-255 COLOR RANGE.
  ;;;;;
  ;;;;;    tvlct,255,0,0,0
  ;;;;;
  ;;;;;

  ;LOOP THROUGH THE MASK AND X OUT ALL OF THE
  ;MASKED PIXELS.
  ;
  ;
  ;FOR THE SELECTED PIXEL, PUT AN X OVER IT
  ;UNTIL FIGURING OUT HOW TO PUT UP A BOX.

  if self.datacontainer->Count() gt 0 then begin
    ref = self.datacontainer->Get(position=self.qchoiceindex)
    tempmask = *(ref->Getproperty(tag='mask2d'))
  endif else begin
    tempmask = Intarr(self.detxdim*self.detydim)
  endelse

  ;mask = (*pmask)[*,k]

  case self.detydim of
    32:begin
      thick = 6.0
    end
    16:begin
      thick = 6.0
    end
    8:begin
      thick = 10.0
    end
    4:begin
      thick = 12.0
    end
    2:begin
      thick = 14.0
    end
  endcase

  ;xcolor = 1000;200;-100   ;bluish white

  Device,decomposed=1
  cR = 0L & cG = 150L & cB = 0L
  ;040205
  ;CHANGED THE USER MASK COLOR TO A DARKER GREEN SO IT IS VISALLY
  ;MORE DISTINCT FROM THE DATA.
  cG2 = 200L & cB2 = 200L
  xcolor = cR + 256L * (cG + 256L * cB)
  xcolor2 = cR + 256L * (cG2 + 256L * cB)

  ;    ;042205
  ;    ;CHANGING XCOLORS TO WORK WITH WHITE BACKGROUNDS.
  ;    white = 255L + 256L*(255L + 256L*255L)
  ;    offwhite = 200L + 256L*(200L + 256L*200L)
  ;    xcolor = white
  ;    xcolor2 = offwhite
  for i=0,self.detxdim-1 do begin
    for j=0,self.detydim-1 do begin
      ;X OVER IF MASKED
      if (tempmask)[j*self.detxdim+i,k] eq 0 then begin
        xpix = i
        ypix = j

        x_xout = [xpix,xpix+1,xpix+1,xpix,xpix]
        y_xout = [ypix,ypix,ypix+1,ypix+1,ypix]
        Polyfill,x_xout,y_xout,color=xcolor,/data,linestyle=0

        ;OUTLINE THE PIXEL
        Plots,[xpix,xpix+1],  [ypix,ypix],    color = 0L,thick = 0.5
        Plots,[xpix+1,xpix+1],[ypix,ypix+1],  color = 0L,thick = 0.5
        Plots,[xpix+1,xpix],  [ypix+1,ypix+1],color = 0L,thick = 0.5
        Plots,[xpix,xpix],    [ypix+1,ypix],  color = 0L,thick = 0.5

        ;                plots,[xpix,xpix+1],[ypix,ypix+1],color = xcolor,thick = 2.0
        ;                plots,[xpix,xpix+1],[ypix+1,ypix],color = xcolor,thick = 2.0
        ;
        ;                plots,[xpix+.1,xpix+.9],[ypix+.2,ypix+.2],color = xcolor,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.4,ypix+.4],color = xcolor,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.6,ypix+.6],color = xcolor,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.8,ypix+.8],color = xcolor,thick = thick
        ;
        ;                plots,[xpix+.2,xpix+.2],[ypix+.1,ypix+.9],color = xcolor,thick = thick
        ;                plots,[xpix+.4,xpix+.4],[ypix+.1,ypix+.9],color = xcolor,thick = thick
        ;                plots,[xpix+.6,xpix+.6],[ypix+.1,ypix+.9],color = xcolor,thick = thick
        ;                plots,[xpix+.8,xpix+.8],[ypix+.1,ypix+.9],color = xcolor,thick = thick
        ;
      endif
      if (tempmask)[j*self.detxdim+i,k] eq -1 then begin
        xpix = i
        ypix = j

        x_xout = [xpix,xpix+1,xpix+1,xpix,xpix]
        y_xout = [ypix,ypix,ypix+1,ypix+1,ypix]
        Polyfill,x_xout,y_xout,color=xcolor2

        ;OUTLINE THE PIXEL
        Plots,[xpix,xpix+1],  [ypix,ypix],    color = 0L,thick = 0.5
        Plots,[xpix+1,xpix+1],[ypix,ypix+1],  color = 0L,thick = 0.5
        Plots,[xpix+1,xpix],  [ypix+1,ypix+1],color = 0L,thick = 0.5
        Plots,[xpix,xpix],    [ypix+1,ypix],  color = 0L,thick = 0.5


        ;
        ;                plots,[xpix,xpix+1],[ypix,ypix+1],color = xcolor2,thick = 2.0
        ;                plots,[xpix,xpix+1],[ypix+1,ypix],color = xcolor2,thick = 2.0
        ;
        ;                plots,[xpix+.1,xpix+.9],[ypix+.2,ypix+.2],color = xcolor2,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.4,ypix+.4],color = xcolor2,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.6,ypix+.6],color = xcolor2,thick = thick
        ;                plots,[xpix+.1,xpix+.9],[ypix+.8,ypix+.8],color = xcolor2,thick = thick
        ;
        ;                plots,[xpix+.2,xpix+.2],[ypix+.1,ypix+.9],color = xcolor2,thick = thick
        ;                plots,[xpix+.4,xpix+.4],[ypix+.1,ypix+.9],color = xcolor2,thick = thick
        ;                plots,[xpix+.6,xpix+.6],[ypix+.1,ypix+.9],color = xcolor2,thick = thick
        ;                plots,[xpix+.8,xpix+.8],[ypix+.1,ypix+.9],color = xcolor2,thick = thick

      endif
    endfor;j
  endfor;i



  ;;;;;    ;RESTORE THE COLOR TABLE TO ITS
  ;;;;;    ;SETTINGS BEFORE ENTERING THIS
  ;;;;;    ;APPLICATION.
  Device,decomposed=0
  Tvlct,r,g,b
  ;;;;;
  Device,decomposed = dc

end;xout


function Oodisplayecho::imageSubtitle
  ;
  ;NAME:
  ;        ooDisplayEcho::imageSubtitle
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;RETURN VALUE:
  ;


  if self.datacontainer->Count() gt 0 then begin
    ref = self.datacontainer->Get(position=self.qchoiceindex)
    ft = (*(ref->Getproperty(tag=$
      'fourierTime')))[self.ftchoiceindex]

    if ref->Getproperty(tag='QValsSwitch') ne 1 then begin
      ;ADD Q VALUE OF THE CURRENT ARC.
      ;            qarcs = *(ref->getProperty(tag='qarcs'))
      ;            print,qarcs
      ;            narcs=ref->getProperty(tag='narcs')
      ;            print,narcs
      ;
      ;            ref->calculateArcsQMatrix,narcs=narcs,arcmat=arcmat
      ;            help,arcmat
      ;            arcmat = reform(arcmat,self.detXdim,self.detYdim)
      ;            help,arcmat
      ;            q = qarcs[arcmat[self.xindex,self.yindex]]

      ;            help,(*(ref->getproperty(tag='QVals')))
      qvals = (*(ref->Getproperty(tag='QVals')))[*,0]
      ;            help,qvals
      format = '(f6.4)'


      ;;;;;
      ;            print,'June 17, 2005'
      ;            refxdim = ref->getproperty(tag='x_dim')
      ;            refydim = ref->getproperty(tag='y_dim')
      ;            if refxdim ne self.detxdim then begin
      ;                qvals = reform(qvals,refxdim,refydim)
      ;            endif else begin
      ;;;;;
      qvals = Reform(qvals,self.detxdim,self.detydim)
      ;            endelse



      q = qvals[self.xindex,self.yindex]
      qstring = ', q[' $
        +Strtrim(String(self.xindex),2) $
        +',' $
        +Strtrim(String(self.yindex),2)+'] =' $
        +Strtrim(String(q,format=format),2)
      ang = 'A';STRING("305B)
      qstring = qstring+ang+'!E-1!N'
    endif else begin
      qstring = ''
    endelse

  endif else begin
    ft = 0.0
    qstring=''
  endelse



  subtitle = File_basename(self.filename) $
    +': t = ' $;+': fourier time = '$
    +Strtrim(String(10.0^9*ft),2)+'ns' $
    +qstring
  Return,subtitle
end;imageSubtitle
function Oodisplayecho::imagetitle
  ;
  ;NAME:
  ;        ooDisplayEcho::imagetitle
  ;
  ;PURPOSE:
  ;           Create a title for the image to be displayed.
  ;PARAMETERS:
  ;           none.
  ;KEYWORDS:
  ;           none

  ;RETURN VALUE:
  ;           The title string.

  case self.displayindex of
    0:  begin
      title = 'Image = S(Q)'
    end
    1:  begin
      title = 'Image = Average Fit Values'
    end
    2:  begin
      title = 'Image = Amplitude Fit Values'
    end
    3:  begin
      title = 'Image = Phase Fit Values'
    end
    4:  begin
      title = 'Image = Gaussian Width Fit Values'
    end
    5:  begin
      title = 'Image = Period Fit Values';Omega Fit Values'
    end
    6:  begin
      title = 'Image = Phase Offset Fit Values'
    end
    7:  begin
      title = 'Image = Chi Squared Values'
    end
    8:  begin
      title = 'Image = Signal'
    end
    9:  begin
      title = 'Image = Magnetic'
    end
    10: begin
      title = 'Image = Spin Incoherent'
    end
    11: begin
      title = 'Image = Coherent and Isotope Incoherent'
    end
    12: begin
      title = 'Image = Sum of all contributions'
    end
    else: begin
      ;NO IMAGE SELECTED, SO JUST SHOW PHASE(0)
      title = 'Image = DEFAULT IMAGE TITLE'
    end
  endcase
  Return,title
end;imageTitle


function Oodisplayecho::checkforAllInfinities,y
  ;
  ;NAME:
  ;        ooDisplayEcho::checkforAllInfinities
  ;
  ;PURPOSE:
  ;       Protect plotting programs from case where all data
  ;       are infinite.  This is common with Signal plot.
  ;
  ;PARAMETERS:
  ;       y   The data to check
  ;KEYWORDS:
  ;           none.
  ;RETURNS:
  ;           The "fixed" data array.
  ;

  ;121905
  ;DO THE FOLLOWING TO AVOID CRASHING DUE TO ALL INFINITIES IN SIGNAL
  wh_inf = Where(y eq Double('Infinity'))
  wh_minf = Where(y eq -Double('Infinity'))
  n_inf = 0
  if wh_inf[0] ne -1 then n_inf = n_inf + N_elements(wh_inf)
  if wh_minf[0] ne -1 then n_minf = n_inf + N_elements(wh_minf)

  if n_inf eq N_elements(y) then y = Dblarr(n_inf)

  Return,y
end;checkforAllInfinities



pro Oodisplayecho::plotVirtual,xindex,yindex,tauindex,textfitparms=textfitparms,$
  plotxrange = plotxrange, plotyrange = plotyrange,$
  plotzoombox = plotzoombox,writeplotdataflag=writeplotdataflag,$
  writeplotdatafile=writeplotdatafile,tavestate=tavestate
  ;Av = Av, Amp = Amp, PHASE = PHASE, W = W, PERIOD = PERIOD, PHO = PHO

  ;
  ;NAME:
  ;        ooDisplayEcho::plotVirtual
  ;
  ;PURPOSE:
  ;           Produce the plot in a pixmap.  If there is a floating auxilliary plot window,
  ;           then produce a plot for that as well.
  ;           This procedure handles all the options for the plot.
  ;
  ;PARAMETERS:
  ;           xindex      The current pixel indices.
  ;           yindex
  ;           tauindex    The current Fourier time index.
  ;           Av          Fit parameters to use for plotting
  ;           Amp         in place of those available in fitparms.
  ;           PH
  ;           W
  ;           PERIOD
  ;           PHO
  ;KEYWORDS:
  ;           none.

  ;print,'ooDisplayEcho::plotvirtual'
  ;print,self.plotindex
  ;if n_elements(writeplotdataflag) gt 0 then print,writeplotdataflag

  Widget_control,self.timeaverageupdowncheckbox,get_value= timecheckboxval
  Widget_control,self.deepmaskingcheckbox,get_value= DEEPMASKINGCHECKBOXval
  if N_elements(tavestate) eq 0 then Widget_control,self.timeaverageupdowncheckbox,get_value= tavestate


  if N_elements(writeplotdatafile) eq 0 then writeplotdatafile = '' ;else print,'ooDisplayEcho::plotvirtual: '+writeplotdatafile

  if N_elements(writeplotdataflag) eq 0 then writeplotdataflag = 0
  if writeplotdataflag eq 1 then begin
    if writeplotdatafile eq '' then writeplotdataflag = 0
  endif
  if N_elements(plotxrange) ne 2 then plotxrange = 0
  if N_elements(plotyrange) ne 2 then plotyrange = 0
  if N_elements(plotzoombox) eq 0 then plotzoombox = 0

  if self.plotzoomswitch eq 1 then begin
    plotxrange = [self.plotxmin,self.plotxmax]
    plotyrange = [self.plotymin,self.plotymax]
  endif else begin
    plotxrange = 0
    plotyrange = 0
  endelse





  ;GET INFORMATION FROM DATA OBJECT AND ADD ALL OF
  ;RELEVANT INFORMATION TO THE PLOT WINDOW.
  Device,get_decomposed = dc, get_current_font=existing_font_name
  existing_font_setting = !P.font
  ;device,decomposed=0
  ;    tvlct,r,g,b,/get
  ;    loadct,self.colortable,/silent

  Device,decomposed=1
;  !P.font = 1
;  Device, set_font='Courier', /TT_FONT, set_character_size=[11,16]
  
  if self.datacontainer->Count() gt 0 then begin

    ref = (self.datacontainer->Get(position=self.qchoiceindex))

    if Obj_valid(ref) gt 0 then begin


      ;112805
      ;SET THE VALUE OF ref_magnetic TO TELL THE CASES BELOW TO SET IMAGE OPTIONS TO
      ;A GENERAL OPTION IF NECESSARY
      if Obj_isa(ref,'ooEchoMagnetic') gt 0 then begin
        if ref->Getproperty(tag='magnetic') eq 0 then begin
          ref_magnetic = 0
        endif else begin
          ref_magnetic = 1
        endelse
      endif else begin
        ref_magnetic = 0
      endelse
      if ref_magnetic eq 0 then begin
        if self.plotindex eq 9 then self.plotindex = 0
      endif






      ;GET THE EXTREMA FROM THE FLIPPER DOWN AND FLIPPER UP STATES
      theExtrema = ref->Chirpextremamasked(xindex, $
        yindex, $
        tauindex,tavestate=tavestate)

      siup = (*(ref->Getproperty(tag='sIup')))[xindex+yindex*self.detxdim,tauindex]
      sidown = (*(ref->Getproperty(tag='sIdown')))[xindex+yindex*self.detxdim,tauindex]
      ;print,'symax=',sidown
      ;print,'symin=',siup


      ;print,'____________________________________________'
      ;print,'ooDisplayEcho::plotVirtual'

      t0 = Systime(1,/seconds)
      term = ref->Term()
      ;print,'t1=',systime(1,/seconds)-t0

      ;091604
      ;
      ;GET FITPLOT SWITCH
      fitplotswitch = $
        (ref->Getfitdisplaymask(tauindex))[xindex,yindex]
      ;print,'t2=',systime(1,/seconds)-t0


      ;ESTIMATE THE OFFSET FROM THE FLIPPER DOWN AND FLIPPER
      ;UP STATES  (NOT YET USED, BUT SHOULD BE USED FOR FITS IN
      ;            DATA OBJECT)
      theOffset = ref->Chirpoffset(xindex,yindex,tauindex)
      ;print,'t2=',systime(1,/seconds)-t0

      ;ESTIMATE THE AMPLITUDE FROM THE FLIPPER DOWN AND FLIPPER
      ;UP STATES  (NOT YET USED, BUT SHOULD BE USED FOR FITS IN
      ;            DATA OBJECT)
      theAmplitude = ref->Chirpamplitude(xindex,yindex,tauindex)

      ;print,'t2=',systime(1,/seconds)-t0

      ;NEED BOTH FULL AND MASKED DATA SETS
      if self.plotupdown eq 0 then begin
        xarrOrig = ref->Chirpphases(tauindex)
        yarrOrig = ref->Chirp(xindex,yindex,tauindex)
        ;            dbx = ref->dbx(tauindex)
        ;            dby = ref->dby(tauindex)
        ;            dbz = ref->dbz(tauindex)

        ;help,xarrOrig
        ;help,yarrOrig
        ;GET PHASE ARRAY AS X-VALUES FOR PLOT

        ;113005
        ;            xarr = ref->chirpPhases(tauindex)  ;WHY WAS THIS USED INSTEAD OF THE NEXT LINE?????
        ;IT DIDN'T MAKE SENSE.
        xarr = ref->Chirpphasesmasked(tauindex)
        ;GET THE ECHO FOR THE SELECTED PIXEL,FOURIER TIME
        yarr = ref->Chirpmasked(xindex,yindex,tauindex)
        ;help,xarr
        ;help,yarr


      endif else begin
        xarrOrig = ref->Chirpphasesall(tauindex)
        ;print,'________________________________'
        ;print,'ooDisplayEcho:: A',systime(1,/seconds)-t0
        yarrOrig = ref->Chirpall(xindex,yindex,tauindex)
        ;            dbx = ref->dbxAll(tauindex)
        ;            dby = ref->dbyAll(tauindex)
        ;            dbz = ref->dbzAll(tauindex)

        ;        ;GET PHASE ARRAY AS X-VALUES FOR PLOT
        ;        xarr = (self.dataContainer->get(position=$
        ;                    self.QChoiceIndex))->chirpPhasesMaskedAll(tauindex)
        ;        ;GET THE ECHO FOR THE SELECTED PIXEL,FOURIER TIME
        ;        yarr = (self.dataContainer->get(position=$
        ;                    self.QChoiceIndex))->chirpMaskedAll(xindex,yindex,tauindex)
        ;GET PHASE ARRAY AS X-VALUES FOR PLOT
        xarr = ref->Chirpphasesmaskedall(tauindex)
        ;GET THE ECHO FOR THE SELECTED PIXEL,FOURIER TIME
        yarr = ref->Chirpmaskedall(xindex,yindex,tauindex)
        ;print,'t5=',systime(1,/seconds)-t0

      endelse

      ;042705
      ;SHOW ONLY ECHO RANGE OF B DATA, NOT THE Iup,down VALUES.
      dbx = ref->Dbx(tauindex)
      dby = ref->Dby(tauindex)
      dbz = ref->Dbz(tauindex)
      xarrb = ref->Chirpphases(tauindex)
      ;print,'________________________________'
      ;print,'ooDisplayEcho:: B',systime(1,/seconds)-t0

      ;print,'t5a=',systime(1,/seconds)-t0


      ;CALCULATE THE ERROR ASSUMING POISSON STATISTICS
      ;(NOTE: CONGRID SEEMS TO AVERAGE THE DATA FOR REBINNING,
      ;       SO A NORMALIZATION FACTOR SHOULD BE IN ORDER
      ;       TO ACCOUNT FOR THE APPARENTLY DEGRADED STATISTICS.
      ;       THIS SHOULD BE HANDLED IN THE bin METHOD OF THE
      ;       DATA OBJECT.)



      ;011408
      ;syarr and syarrOrig are the error bars in the echo data.
      ;The Idown and Iup values need to be handled differently depending on the
      ;choice of time averaging by the user. (See the checkbox labeled time average up/down and the method
      ;ooecho::report_timeaveage_state.)
      ;
      ;But even so, here we are just taking the sqrt of the data.  The eb for this display
      ;and for other calculations must be handled elsewhere.
      ;
      ;Look at ooEcho::chirpMaskedAll
      syarrOrig = Sqrt(yarrOrig)
      syarr = Sqrt(yarr)

      ;RETRIEVE THE FIT PARAMETERS FROM THE DATA OBJECT
      ;FOR THE SELECTED PIXEL
      fitvals = ref->Fitvals(xindex,yindex,tauindex)
      ;print,'t5b=',systime(1,/seconds)-t0

      ;print,'________________________________'
      ;print,'ooDisplayEcho:: C',systime(1,/seconds)-t0



      ;    ;CALCULATE THE FIT VALUES AT THE DATA POINTS
      ;        fit = ref->chirpfun(fitvals,tauindex)

      ;INTERPOLATE xarr TO A SUFFICIENT NUMBER OF POINTS TO SMOOTH THE
      ;PLOT OF THE FIT.
      xarrfit = ref->Chirpphases(tauindex)

      ;print,'t5b1=',systime(1,/seconds)-t0

      xfit = xarrfit[0] + $
        Findgen(5*N_elements(xarrfit))*((xarrOrig[N_elements(xarrfit)-1]-xarrfit[0])/Double(5*N_elements(xarrfit)))
      ;print,'t5b2=',systime(1,/seconds)-t0

      if N_elements(textfitparms) eq 6 then begin
        fitvals = textfitparms


        ;022406
        ;CHECK OMEGA v. PERIOD CONVERSION
        if fitvals[4] lt 0.0  then fitvals[4] = -1.0*fitvals[4]
        if fitvals[4] ge 10.0 then fitvals[4] = 360.0/fitvals[4]

        ;ORIGINAL LINE
        ;            fitvals[4] = 360.0/fitvals[4]
        ;print,'022406 oodisplayecho::plotvirtual'
      endif
      ;print,'________________________________'
      ;print,'ooDisplayEcho:: D',systime(1,/seconds)-t0

      ;        if n_elements(Av)     eq 1 then fitvals[0] = Av
      ;        if n_elements(Amp)    eq 1 then fitvals[1] = Amp
      ;        if n_elements(PHASE)  eq 1 then fitvals[2] = PHASE
      ;        if n_elements(W)      eq 1 then fitvals[3] = W
      ;        if n_elements(PERIOD) eq 1 then fitvals[4] = PERIOD/360.0d
      ;        if n_elements(PHO)    eq 1 then fitvals[5] = PHO

      yfit = Chirpfun(xfit,fitvals)

      taus = ref->Tau()
      fitphasevtau = ref->Fitphasevtau(xindex,yindex)
      ;print,'t5b3=',systime(1,/seconds)-t0

      currentPhasevTaux = [taus[tauindex]]
      currentPhasevTauy = [fitphasevTau[tauindex]]
      ;print,'t5b4=',systime(1,/seconds)-t0


      ;print,'________________________________'
      ;print,'ooDisplayEcho:: E',systime(1,/seconds)-t0



      fitAmpvtau = ref->Fitampvtau(xindex,yindex)
      ;print,'t5b4a=',systime(1,/seconds)-t0


      ;print,'t5b4b=',systime(1,/seconds)-t0
      currentSignalvTaux = [taus[tauindex]]
      ;print,'t5b4c=',systime(1,/seconds)-t0

      ;print,'________________________________'
      ;print,'ooDisplayEcho:: F',systime(1,/seconds)-t0


      ;112905
      if self.plotindex eq 8 then begin
        signalvtau = ref->Signalvtau(xindex,yindex,tavestate=timecheckboxval)
        signalvtau = self->Checkforallinfinities(signalvTau)
        currentSignalvTauy = [signalvTau[tauindex]]
      endif else begin
        ;print,'ONLY GET THE FIRST SIGNAL VALUE'
        signalvtau = ref->Signalvtauonetime(xindex,yindex,tauindex,tavestate=timecheckboxval)
        signalvtau = self->Checkforallinfinities(signalvTau)
        currentSignalvTauy = [signalvTau]
      endelse
      ;print,'________________________________'
      ;print,'ooDisplayEcho:: G',systime(1,/seconds)-t0

      ;print,'t5b5=',systime(1,/seconds)-t0


      currentAmpvTaux = [taus[tauindex]]
      currentAmpvTauy = [fitAmpvTau[tauindex]]
      ;print,'t5c=',systime(1,/seconds)-t0


    endif else begin;obj_valid(ref)

      ;IF I GET HERE THERE WAS A PROBLEM.
      ;SET THE CURRENT WINDOW TO THE PIXMAP FOR THE PLOT
      Wset,self.dw2pix
      Plot,[0,0],[1,1],title='Plot Window',color=0L,background=255L+256L*(255L + 255L*256L)
      Return

    endelse
    ;print,'t6=',systime(1,/seconds)-t0

  endif else begin


    ;WHEN THERE IS NOTHING TO DISPLAY, MAKE UP SOME VALUES TO SHOW IN THE PLOT.
    theExtrema = Indgen(27)
    siup = 1.0
    sidown = 1.0

    xarrOrig = Indgen(27)
    yarrOrig = Indgen(27)
    xarr = Indgen(27)
    yarr = Indgen(27)
    syarrOrig = Sqrt(yarrOrig)
    syarr = Sqrt(yarr)
    fit = Indgen(27)
    xfit = Indgen(27)
    yfit = Indgen(27)

    xarrb = xarr
    dbx = Indgen(27)
    dby = Indgen(27)
    dbz = Indgen(27)
    taus = Indgen(27)
    fitphasevtau = Indgen(27)
    signalvtau = Indgen(27)

    currentPhasevTaux =  Indgen(27)
    currentPhasevTauy =  Indgen(27)
    fitAmpvtau =  Indgen(27)

    currentAmpvTaux =  Indgen(27)
    currentAmpvTauy =  Indgen(27)
    parms = Dblarr(12)

  endelse


  ;CREATE ARRAYS OF THE EXTREMA FOR PLOTTING
  hivals = Dblarr(N_elements(xarr))+theExtrema[0]
  lovals = Dblarr(N_elements(xarr))+theExtrema[1]
  shivals = Dblarr(N_elements(xarr))+sidown
  slovals = Dblarr(N_elements(xarr))+siup


  ;SET THE CURRENT WINDOW TO THE PIXMAP FOR THE PLOT
  Wset,self.dw2pix

  ;PLOT ALL OF THE RELEVANT INFORMATION

  if N_elements(ref) eq 1 then begin
    subtitle = '"'+File_basename(ref->Getproperty(tag='filename'))+'" '+ $
      ref->Getproperty(tag='comment')
    title = 'Q='+Strtrim(String(ref->Getproperty(tag='qactual'),format='(F10.5)'),2)+ 'A-1 '+ $
      ' t='+Strtrim(String((*(ref->Getproperty(tag='fourierTime')))[self.ftchoiceindex]),2)+ ' s ' + $
      ' Element('+Strtrim(String(xindex),2)+','+ $
      Strtrim(String(yindex),2)+')'

    parms = (*(ref->Getproperty(tag='fitparms')))[*,self.xindex+self.detxdim*self.yindex,self.ftchoiceindex]

    chisq = (*(ref->Getproperty(tag='chisq')))[self.xindex+self.detxdim*self.yindex,self.ftchoiceindex]

    ;print,"obj_isa(ref,'ooEchoMagnetic')=",obj_isa(ref,'ooEchoMagnetic')
    ;print,'________________________________'
    ;print,'ooDisplayEcho:: G1',systime(1,/seconds)-t0
    if Obj_isa(ref,'ooEchoMagnetic') eq 1 then begin
      yoffset = ref->Threemplusnoversix(self.xindex,self.yindex,self.ftchoiceindex)
    endif else begin
      yoffset = 0.0
    endelse
    ;print,'________________________________'
    ;print,'ooDisplayEcho:: G2',systime(1,/seconds)-t0

    format = '(%"%s%8.2f%s%6.2f")'

    if parms[5] eq 0.0 then begin
      legend = [ $
        String('Av =',parms[0],' +/- ',parms[6],format=format),$
        String('A  =',parms[1],' +/- ',parms[7],format=format),$
        String('PH =',parms[2],' +/- ',parms[8],format=format),$
        String('W  =',parms[3],' +/- ',parms[9],format=format),$
        String('T  =',360.0/parms[4],' +/- ',360.0*parms[10]/((parms[4])^2.0),format=format),$
        String('chisq = ',chisq,format='(%"%s%10.2f")')]
    endif else begin
      legend = [ $
        String('Av = ',parms[0],' +/- ',parms[6],format=format),$
        String('A  = ',parms[1],' +/- ',parms[7],format=format),$
        String('PH = ',parms[2],' +/- ',parms[8],format=format),$
        String('W  = ',parms[3],' +/- ',parms[9],format=format),$
        String('T  = ',360.0/parms[4],' +/- ',360.0*parms[10]/((parms[4])^2.0),format=format),$
        String('PHoffset= ',parms[5],' +/- ',parms[11],format=format),$
        String('chisq = ',chisq,format='(%"%s%10.2f")')]
    endelse
;    if parms[5] eq 0.0 then begin
;      legend = [ $
;        String('Av =',parms[0],' ± ',parms[6],format=format),$
;        String('A  =',parms[1],' ± ',parms[7],format=format),$
;        String('PH =',parms[2],' ± ',parms[8],format=format),$
;        String('W  =',parms[3],' ± ',parms[9],format=format),$
;        String('T  =',360.0/parms[4],' ± ',360.0*parms[10]/((parms[4])^2.0),format=format),$
;        String('chisq= ',chisq,format='(%"%s%10.2f")')]
;    endif else begin
;      legend = [ $
;        String('Av = ',parms[0],' ± ',parms[6],format=format),$
;        String('A  = ',parms[1],' ± ',parms[7],format=format),$
;        String('PH = ',parms[2],' ± ',parms[8],format=format),$
;        String('W  = ',parms[3],' ± ',parms[9],format=format),$
;        String('T  = ',360.0/parms[4],' ± ',360.0*parms[10]/((parms[4])^2.0),format=format),$
;        String('PHoffset= ',parms[5],' ± ',parms[11],format=format),$
;        String('chisq= ',chisq,format='(%"%s%10.2f")')]
;    endelse

    ;    legend = ['Av='+strtrim(string(parms[0]),2)+'+/-'+strtrim(string(parms[6],2)),$
    ;              'A='+strtrim(string(parms[1]),2)+'+/-'+strtrim(string(parms[7],2)),$
    ;              'PH='+strtrim(string(parms[2]),2)+'+/-'+strtrim(string(parms[8],2)),$
    ;              'W='+strtrim(string(parms[3]),2)+'+/-'+strtrim(string(parms[9],2)),$
    ;              'T='+strtrim(string(360.0/parms[4]),2)+'+/-'+strtrim(string(parms[10],2)),$
    ;              'chisq='+strtrim(string(chisq),2)]
  endif;n_elements(ref) eq 1
  ;print,'________________________________'
  ;print,'ooDisplayEcho:: H',systime(1,/seconds)-t0


  black = 0L & red = 255L & green = 256L*red & blue = 256L*green & white = red+green+blue

  xlego = 0.75
  ylego = 0.6
  if parms[5] eq 0.0 then begin
    xleg = [xlego,xlego,xlego,xlego,xlego,xlego]
    yleg = [ylego,ylego-0.06,ylego-0.12,ylego-0.18,ylego-0.24,ylego-0.30]
  endif else begin
    xleg = [xlego,xlego,xlego,xlego,xlego,xlego,xlego]
    yleg = [ylego,ylego-0.06,ylego-0.12,ylego-0.18,ylego-0.24,ylego-0.30,ylego-0.36]
  endelse
  xsub = 0.15
  ysub = 1.15

  ydelta = 0.045
  ;print,'________________________________'
  ;print,'ooDisplayEcho:: I',systime(1,/seconds)-t0

  if self.plotzoombox eq 1 then begin
    zoomxrange = [self.plotpressx,self.plotreleasex]
    zoomyrange = [self.plotpressy,self.plotreleasey]
    ;        print,'plotVirtual'
    ;        print,zoomxrange
    ;        print,zoomyrange
  endif else begin
    ;        print,'plotVirtual, plotzoombox=',plotzoombox

    zoomxrange = 0
    zoomyrange = 0
  endelse

  ;print,'________________________________'
  ;print,'ooDisplayEcho:: J',systime(1,/seconds)-t0


  ;print,'ooDisplayEcho::plotvirtual'
  ;print,self.plotindex
  ;print,writeplotdataflag
  ;print,writeplotdatafile
  plotzoombox = self.plotzoombox
  case self.plotindex of
    0:begin
      ;            title = 'Plot = Counts v Phase:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)


      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun
        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)

        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals

        Free_lun,lun

      endif;writeplotdataflag

      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange

      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1

      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1

      endfor;i

    end;0
    1:begin         ;PLOT FIT PHASE v TAU
      ;            title = 'Plot = Fit Phase v. Tau:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)
      ;help,plotxrange
      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'times:'
        Printf,lun,taus*10.0^9
        Printf,lun,'phases'
        Printf,lun,fitphasevtau

        Free_lun,lun

      endif;writeplotdataflag



      if N_elements(plotxrange) eq 2 then begin
        Plot,taus*10.0^9,fitphasevtau,psym=-4,/xlog,$
          xrange = plotxrange,$
          yrange = plotyrange,$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'FitPhase',symsize=2,$
          xstyle=1,ystyle=1

      endif else begin
        Plot,taus*10.0^9,fitphasevtau,psym=-4,/xlog,$
          yrange = [Min(fitphasevtau),Max(fitphasevtau)],$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'FitPhase',symsize=2
      endelse
      Oplot,currentPhasevTaux*10.0^9,$
        currentPhasevTauy,$
        color=0L + 256L*(255L + 256L*0L),$
        psym=2,symsize=3

      if self.plotzoombox eq 1 then begin
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
        Plots,[self.plotreleasex,self.plotreleasex],[self.plotpressy,self.plotreleasey],color=0L
        Plots,[self.plotreleasex,self.plotpressx],[self.plotreleasey,self.plotreleasey],color=0L
        Plots,[self.plotpressx,self.plotpressx],[self.plotreleasey,self.plotpressy],color=0L
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
      endif

      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1
      Nse_legend,self.dw2pix,0.6,0.9,'Current Image Selection',$
        color = 0L + 256L*(255L + 256L*0L),$
        psym = 2,symsize=2
    end;1
    2:begin     ;PLOT EVERYTHING WITH Bx
      ;                title = 'Plot = Counts v Phase:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)

      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun
        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)

        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals
        Printf,lun,'Bx:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dbx
        Free_lun,lun

      endif;writeplotdataflag



      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        bx=dbx,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange


      ;                nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                            color = 0L,$
      ;                            psym = 0,symsize=1
      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1
      endfor;i

    end;2
    3:begin     ;PLOT EVERYTHING WITH By
      ;            title = 'Plot = Counts v Phase:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)


      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)
        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals
        Printf,lun,'By:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dby
        Free_lun,lun

      endif;writeplotdataflag


      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        by=dby,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$;'Plot = Counts v Phase:'+$
        $;strtrim(string(xindex),2)+','+$
        $;strtrim(string(yindex),2),$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange
      ;                nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                            color = 0L,$
      ;                            psym = 0,symsize=1
      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1
      endfor;i
    end;3
    4:begin     ;PLOT EVERYTHING WITH Bz
      ;            title = 'Plot = Counts v Phase:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)

      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)
        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals
        Printf,lun,'Bz:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dbz
        Free_lun,lun

      endif;writeplotdataflag


      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        bz=dbz,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$;'Plot = Counts v Phase:'+$
        $;strtrim(string(xindex),2)+','+$
        $;strtrim(string(yindex),2),$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange
      ;                nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                            color = 0L,$
      ;                            psym = 0,symsize=1
      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1
      endfor;i
    end;4
    5:begin     ;PLOT EVERYTHING

      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)

        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals
        Printf,lun,"B's:"
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Bx:'
        Printf,lun,dbx
        Printf,lun,'By:'
        Printf,lun,dby
        Printf,lun,'Bz:'
        Printf,lun,dbz
        Free_lun,lun

      endif;writeplotdataflag



      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        bx=dbx,$
        by=dby,$
        bz=dbz,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange
      ;                nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                            color = 0L,$
      ;                            psym = 0,symsize=1
      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1
      endfor;i
    end;5
    6:begin     ;PLOT FIT AMPLITUDE V TAU
      ;            title = 'Plot = Fit Amplitude v. Tau:'+$
      ;                                strtrim(string(xindex),2)+','+$
      ;                                strtrim(string(yindex),2)


      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'times:'
        Printf,lun,taus*10.0^9
        Printf,lun,'amplitudes'
        Printf,lun,fitampvtau

        Free_lun,lun

      endif;writeplotdataflag



      if N_elements(plotxrange) eq 2 then begin
        Plot,taus*10.0^9,fitampvtau,psym=-4,$
          yrange = plotyrange,$
          xrange = plotxrange,$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$;'Plot = Fit Amplitude v. Tau:'+$
          $;strtrim(string(xindex),2)+','+$
          $;strtrim(string(yindex),2),$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'Fit Apmlitude',$
          xstyle=1, ystyle=1

      endif else begin
        Plot,taus*10.0^9,fitampvtau,psym=-4,$
          yrange = [Min(fitampvtau),Max(fitampvtau)],$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$;'Plot = Fit Amplitude v. Tau:'+$
          $;strtrim(string(xindex),2)+','+$
          $;strtrim(string(yindex),2),$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'Fit Apmlitude'
      endelse
      Oplot,currentAmpvTaux*10.0^9,$
        currentAmpvTauy,$
        color=0L + 256L*(255L + 256L*0L),$
        psym=2,symsize=3

      if self.plotzoombox eq 1 then begin
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
        Plots,[self.plotreleasex,self.plotreleasex],[self.plotpressy,self.plotreleasey],color=0L
        Plots,[self.plotreleasex,self.plotpressx],[self.plotreleasey,self.plotreleasey],color=0L
        Plots,[self.plotpressx,self.plotpressx],[self.plotreleasey,self.plotpressy],color=0L
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
      endif



      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1
    end;6
    7:begin     ;COUTOURECHO

      if writeplotdataflag eq 1 then begin
        void = Dialog_message('Output to file not yet available for contourEcho')
      endif;writeplotdataflag


      ref->Contourecho,xindex,yindex,tauindex,winid=self.dw2pix,$
        title=title,subtitle=subtitle
      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1
    end;7
    8:begin         ;SIGNAL v TAU

      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'times:'
        Printf,lun,taus*10.0^9
        Printf,lun,'signal'
        Printf,lun,signalvtau

        Free_lun,lun

      endif;writeplotdataflag

      if N_elements(plotxrange) eq 2 then begin
        Plot,taus*10.0^9,signalvtau,psym=-4,/xlog,$
          yrange = plotyrange,$
          xrange = plotxrange,$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'FitPhase',symsize=2,$
          ystyle=1,xstyle=1
      endif else begin
        Plot,taus*10.0^9,signalvtau,psym=-4,/xlog,$
          yrange = [Min(signalvtau),Max(signalvtau)],$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title=title,$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'FitPhase',symsize=2
      endelse

      Oplot,currentSignalvTaux*10.0^9,$
        currentSignalvTauy,$
        color=0L + 256L*(255L + 256L*0L),$
        psym=2,symsize=3
      if self.plotzoombox eq 1 then begin
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
        Plots,[self.plotreleasex,self.plotreleasex],[self.plotpressy,self.plotreleasey],color=0L
        Plots,[self.plotreleasex,self.plotpressx],[self.plotreleasey,self.plotreleasey],color=0L
        Plots,[self.plotpressx,self.plotpressx],[self.plotreleasey,self.plotpressy],color=0L
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
      endif

      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1
      Nse_legend,self.dw2pix,0.6,0.9,'Current Image Selection',$
        color = 0L + 256L*(255L + 256L*0L),$
        psym = 2,symsize=2
    end;8
    9:begin ;MAGNETIC COMPONENTS


      dum = ref->F_polanalysisgeneral(0,image=image,eimage=eimage,plotdata=plotdata,eplotdata=eplotdata,/magq1d)
      plotcolor = [black,red,green,blue]
      plotnames = ['magnetic','spin incoh','coh & isotope incoh','total']
      legendpos = [0.0,-0.04,-0.08,-0.12]
      legendsym = [-2,-4,-5,-6]
      symsize=1


      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'times:'
        Printf,lun,taus*10.0^9
        Printf,lun,'magnetic'
        Printf,lun,plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Printf,lun,'EB magnetic'
        Printf,lun,eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Printf,lun,'spin incoh'
        Printf,lun,plotdata[1*N_elements(taus):2*N_elements(taus)-1]
        Printf,lun,'EB spin incoh'
        Printf,lun,eplotdata[1*N_elements(taus):2*N_elements(taus)-1]
        Printf,lun,'coh & isotope incoh'
        Printf,lun,plotdata[2*N_elements(taus):3*N_elements(taus)-1]
        Printf,lun,'EB coh & isotope incoh'
        Printf,lun,eplotdata[2*N_elements(taus):3*N_elements(taus)-1]
        Printf,lun,'Total'
        Printf,lun,plotdata[3*N_elements(taus):4*N_elements(taus)-1]
        Printf,lun,'EB Total'
        Printf,lun,eplotdata[3*N_elements(taus):4*N_elements(taus)-1]

        Free_lun,lun

      endif;writeplotdataflag

      if N_elements(plotxrange) eq 2 then begin
        ploty = plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        plotey = eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Plot,taus,plotdata[0*N_elements(taus):1*N_elements(taus)-1],$
          background = white,color=black,$
          xrange=plotxrange,$
          yrange=plotyrange,$
          title='Components: Area averaged',psym=-2,/xlog,$
          xtitle = 'Fourier Time',$
          xstyle=1,ystyle=1
        Errplot,taus,ploty-plotey,ploty+plotey,color=black
      endif else begin


        ploty = plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        plotey = eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Plot,taus,ploty,$
          background = white,color=black,$
          yrange=[Min(plotdata-eplotdata),Max(plotdata+eplotdata)],$
          title='Magnetic Components: Area averaged',psym=-2,/xlog,$
          xtitle = 'Fourier Time'
        Errplot,taus,ploty-plotey,ploty+plotey,color=black
      endelse


      for iii = 1,3 do begin
        ploty1 = plotdata[iii*N_elements(taus):(iii+1)*N_elements(taus)-1]
        plotey1 = eplotdata[iii*N_elements(taus):(iii+1)*N_elements(taus)-1]
        Oplot,taus,ploty1,$
          color=plotcolor[iii],$
          psym=legendsym[iii],symsize=symsize
        Errplot,taus,ploty1-plotey1,ploty1+plotey1,color=plotcolor[iii]
      endfor;iii


      if self.plotzoombox eq 1 then begin
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
        Plots,[self.plotreleasex,self.plotreleasex],[self.plotpressy,self.plotreleasey],color=0L
        Plots,[self.plotreleasex,self.plotpressx],[self.plotreleasey,self.plotreleasey],color=0L
        Plots,[self.plotpressx,self.plotpressx],[self.plotreleasey,self.plotpressy],color=0L
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
      endif

      xo=0.55 & yo = 0.5
      for iii=0,3 do begin
        Nse_legend, self.dw2pix,xo,yo+legendpos[iii],$
          plotnames[iii],color=plotcolor[iii],psym=legendsym[iii]
      endfor;iii

    end;9
    10:begin;Magnetic components, 1 pixel


      pixel = self.detxdim*self.yindex + self.xindex
      dum = ref->F_polanalysisgeneral(0,image=image,eimage=eimage,pixel=pixel,$
        plotdata=plotdata,eplotdata=eplotdata,sq1dtotal=sq1dtotal)
      plotcolor = [black,red,green,blue]
      plotnames = ['magnetic','spin incoh','coh & isotope incoh','total']
      legendpos = [0.0,-0.04,-0.08,-0.12]
      legendsym = [-2,-4,-5,-6]
      symsize=1

      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun

        Printf,lun,'times:'
        Printf,lun,taus*10.0^9
        Printf,lun,'magnetic'
        Printf,lun,plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Printf,lun,'EB magnetic'
        Printf,lun,eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Printf,lun,'spin incoh'
        Printf,lun,plotdata[1*N_elements(taus):2*N_elements(taus)-1]
        Printf,lun,'EB spin incoh'
        Printf,lun,eplotdata[1*N_elements(taus):2*N_elements(taus)-1]
        Printf,lun,'coh & isotope incoh'
        Printf,lun,plotdata[2*N_elements(taus):3*N_elements(taus)-1]
        Printf,lun,'EB coh & isotope incoh'
        Printf,lun,eplotdata[2*N_elements(taus):3*N_elements(taus)-1]
        Printf,lun,'Total'
        Printf,lun,plotdata[3*N_elements(taus):4*N_elements(taus)-1]
        Printf,lun,'EB Total'
        Printf,lun,eplotdata[3*N_elements(taus):4*N_elements(taus)-1]

        Free_lun,lun

      endif;writeplotdataflag
      if N_elements(plotxrange) eq 2 then begin
        ploty = plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        plotey = eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Plot,taus,ploty,$
          background = white,color=black,$
          xrange=plotxrange,$
          yrange=plotyrange,$
          title='Magnetic Components: Pixel'+ $
          Strtrim(String(xindex),2)+','+$
          Strtrim(String(yindex),2),$
          psym=-2,/xlog,$
          xtitle = 'Fourier Time',$
          xstyle=1,ystyle=1
        Errplot,taus,ploty-plotey,ploty+plotey,color=black
      endif else begin
        ploty = plotdata[0*N_elements(taus):1*N_elements(taus)-1]
        plotey = eplotdata[0*N_elements(taus):1*N_elements(taus)-1]
        Plot,taus,ploty,$
          background = white,color=black,$
          yrange=[Min(plotdata-eplotdata),Max(plotdata+eplotdata)],$
          title='Magnetic Components: Pixel ['+ $
          Strtrim(String(xindex),2)+','+$
          Strtrim(String(yindex),2)+']',$
          psym=-2,/xlog,$
          xtitle = 'Fourier Time'
        Errplot,taus,ploty-plotey,ploty+plotey,color=black
      endelse

      ;            for iii = 1,3 do begin
      ;;                print,'1880 ooDisplayeEcho::plotvirtual Problem seems to be in the EB calc in __fpolana...',iii
      ;;                print,'THE VALUES I AM TAKING TO BE EBs ARE PROBABLY NOT EBs!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!'
      ;                ploty1 = plotdata[iii*n_elements(taus):(iii+1)*n_elements(taus)-1]
      ;;                print,ploty1
      ;                plotey1 = eplotdata[iii*n_elements(taus):(iii+1)*n_elements(taus)-1]
      ;;                print,plotey1
      ;                oplot,ploty1,$
      ;                      color=plotcolor[iii],$
      ;                      psym=1,$;legendsym[iii],$
      ;                      symsize=3
      ;                errplot,taus,ploty1-plotey1,ploty1+plotey1,color=plotcolor[iii]
      ;            endfor;iii

      for iii = 1,3 do begin
        ploty1 = plotdata[iii*N_elements(taus):(iii+1)*N_elements(taus)-1]
        plotey1 = eplotdata[iii*N_elements(taus):(iii+1)*N_elements(taus)-1]
        Oplot,taus,ploty1,$
          color=plotcolor[iii],$
          psym=legendsym[iii],symsize=symsize
        Errplot,taus,ploty1-plotey1,ploty1+plotey1,color=plotcolor[iii]
      endfor;iii


      if self.plotzoombox eq 1 then begin
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
        Plots,[self.plotreleasex,self.plotreleasex],[self.plotpressy,self.plotreleasey],color=0L
        Plots,[self.plotreleasex,self.plotpressx],[self.plotreleasey,self.plotreleasey],color=0L
        Plots,[self.plotpressx,self.plotpressx],[self.plotreleasey,self.plotpressy],color=0L
        Plots,[self.plotpressx,self.plotreleasex],[self.plotpressy,self.plotpressy],color=0L
      endif
      xo=0.55 & yo = 0.5

      for iii=0,3 do begin
        Nse_legend, self.dw2pix,xo,yo+legendpos[iii],$
          plotnames[iii],color=plotcolor[iii],psym=legendsym[iii]
      endfor;iii


    end;10
    else:begin  ;PLOT EVERYTHING
      if writeplotdataflag eq 1 then begin
        Openw,lun,writeplotdatafile,/get_lun
        Printf,lun,'Fitparms:'
        Printf,lun,Transpose(legend)

        Printf,lun,'Data:'
        Printf,lun,'x:'
        Printf,lun,xarrOrig
        Printf,lun,'y:'
        Printf,lun,yarrOrig
        Printf,lun,'sy:'
        Printf,lun,syArrOrig
        Printf,lun,'Unmasked Data:'
        Printf,lun,'x:'
        Printf,lun,xarr
        Printf,lun,'y:'
        Printf,lun,yarr
        Printf,lun,'sy:'
        Printf,lun,syarr
        Printf,lun,'fitvalues:'
        Printf,lun,'x:'
        Printf,lun,xfit
        Printf,lun,'y:'
        Printf,lun,yfit
        Printf,lun,'FlipperOn/Off values:'
        Printf,lun,'Up:'
        Printf,lun,hivals
        Printf,lun,'sUp:'
        Printf,lun,shivals
        Printf,lun,'Down:'
        Printf,lun,lovals
        Printf,lun,'sDown:'
        Printf,lun,slovals
        Printf,lun,'Bx:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dbx
        Printf,lun,'Bx:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dby
        Printf,lun,'Bz:'
        Printf,lun,'X:'
        Printf,lun,xarrb
        Printf,lun,'Y:'
        Printf,lun,dbz
        Free_lun,lun

      endif;writeplotdataflag

      Larploterr,xarrOrig,yarrOrig,syarrOrig,$
        xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
        yoffset=yoffset,$
        fitplotswitch = fitplotswitch,$
        ymax = hivals, ymin = lovals,$
        symax = shivals, symin = slovals,$
        bx=dbx,$
        by=dby,$
        bz=dbz,$
        xarrb = xarrb,$
        winid = self.dw2pix,$
        title = title,$
        subtitle = subtitle,$
        ytitle = 'Intensity',$
        xtitle = 'phase',$
        plotxrange = plotxrange,$
        plotyrange = plotyrange,$
        plotzoombox = plotzoombox, $
        zoomxrange = zoomxrange, zoomyrange = zoomyrange
      ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
      ;                        color = 0L,$
      ;                        psym = 0,symsize=1
      for i=0,N_elements(legend)-1 do begin
        Nse_legend,self.dw2pix,xleg[i],yleg[i],legend[i],$
          color = 0L,$
          psym = 0,symsize=1
      endfor;i
    end
  endcase


  ;041305
  ;SET THE dw2 AXIS POINTERS HERE.
  ;RELEASE AXIS POINTERS FOR WINDOW
  Ptr_free,self.w2xptr
  Ptr_free,self.w2yptr

  ;RESET AXIS POINTERS
  self.w2xptr = Ptr_new(!x)   ;SET THESE VALUES AT THIS POINT TO
  self.w2yptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION

  ;device,decomposed=0
  ;    tvlct,r,g,b
  ;
  ;device,decomposed=1

  ;ADD OPTIONAL AuxilIARY PLOT
  if Widget_info(self.Dw2aux,/valid_id) gt 0 then begin
    Wset,self.dw2auxpix
    switch self.plotindex of
      0:
      2:
      3:
      4:
      5:begin
        Plot,taus*10.0^9,fitphasevtau,psym=-4,/xlog,$
          yrange = [Min(fitphasevtau),Max(fitphasevtau)],$
          color = 0L,$
          background = 255L + 256L*(255L + 256L*255L),$
          title='Plot = Fit Phase v. Tau:'+$
          Strtrim(String(xindex),2)+','+$
          Strtrim(String(yindex),2),$
          subtitle = subtitle,$
          xtitle = 'Fourier Time (ns)',$
          ytitle = 'FitPhase',symsize=2
        Oplot,currentPhasevTaux*10.0^9,$
          currentPhasevTauy,$
          color=0L + 256L*(255L + 256L*0L),$
          psym=2,symsize=3
        ;            nse_legend,self.dw2pix,xsub,ysub,subtitle,$
        ;                        color = 0L,$
        ;                        psym = 0,symsize=1
        Nse_legend,self.dw2auxpix,0.7,0.9,'Current Image Selection',$
          color = 0L + 256L*(255L + 256L*0L),$
          psym = 2,symsize=2
        break
      end;0,2,3,4,5
      1:
      6:
      8:
      9:
      10:
      11:begin
        Larploterr,xarrOrig,yarrOrig,syarrOrig,$
          xarr,yarr,syarr,xfit=xfit,yfit=yfit,$
          fitplotswitch = fitplotswitch,$
          yoffset=yoffset,$
          ymax = hivals, ymin = lovals,$
          symax = shivals, symin = slovals,$
          bx=dbx,$
          by=dby,$
          bz=dbz,$
          xarrb = xarrb,$
          winid = self.dw2auxpix,$
          title = title,$;'Plot = Counts v Phase:'+$
          $;strtrim(string(xindex),2)+','+$
          $;strtrim(string(yindex),2),$
          subtitle = subtitle,$
          ytitle = 'Intensity',$
          xtitle = 'phase'
        ;                nse_legend,self.dw2pix,xsub,ysub,subtitle,$
        ;                            color = 0L,$
        ;                            psym = 0,symsize=1
        for i=0,N_elements(legend)-1 do begin
          Nse_legend,self.dw2auxpix,xleg[i],yleg[i],legend[i],$
            color = 0L,$
            psym = 0,symsize=1
        endfor;i
      end;1,6
    endswitch


    ;041305
    ;SET THE dw2aux AXIS POINTERS HERE.

    ;RELEASE AXIS POINTERS FOR WINDOW
    Ptr_free,self.w2xauxptr
    Ptr_free,self.w2yauxptr
    ;RESET AXIS POINTERS
    self.w2xauxptr = Ptr_new(!x)   ;SET THESE VALUES AT THIS POINT TO
    self.w2yauxptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION

  endif;AUX PLOT.

  Device,decomposed = dc, set_font=existing_font_name
  !P.font=existing_font_setting

end;plotVirtual
pro Oodisplayecho::printWindow,plotw=plotw,imagew=imagew,auxw=auxw,$
  plotd=plotd,imaged=imaged,auxd=auxd
  ;
  ;NAME:
  ;        ooDisplayEcho::printWindow
  ;
  ;PURPOSE:
  ;           Print the selected window to a .ps file.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           plotw       print plot window
  ;           imagew      print image window
  ;           auxw        print Auxiliary window
  ;           plotd       print plot window to default printer
  ;           imaged      print image window to default printer
  ;           auxd        print Auxiliary window to default printer
  ;

  if N_elements(plotw) eq 0 then plotw = 0
  if N_elements(imagew) eq 0 then imagew = 0
  if N_elements(auxw) eq 0 then auxw = 0
  if N_elements(plotd) eq 0 then plotd = 0
  if N_elements(imaged) eq 0 then imaged = 0
  if N_elements(auxd) eq 0 then auxd = 0

  if plotw eq 1 then begin
    Wset,self.dw2id
    filename = 'nse_plotwin.ps'
  endif
  if imagew eq 1 then begin
    Wset,self.dw1id
    filename = 'nse_imagewin.ps'
  endif
  if auxw eq 1 then begin
    Wset,self.dw2auxid
    filename = 'nse_auxwin.ps'
  endif
  if plotd eq 1 then begin
    Lk_printdirectgraphicswindowtodefaultprinter, self.dw2id,true=3
  endif
  if imaged eq 1 then begin
    Lk_printdirectgraphicswindowtodefaultprinter, self.dw1id,true=3
  endif
  if auxd eq 1 then begin
    Lk_printdirectgraphicswindowtodefaultprinter, self.dw2auxid,true=3
  endif

  if ((plotw + imagew + auxw) eq 1) then begin
    result = Tvrd(true=3)
    ;print,filename
    ;help,result
    Nse_ps_plotter,result,filename=filename,directory=self.work_dir
  endif


end;printWindow
pro Oodisplayecho::setDisplayImage
  ;
  ;NAME:
  ;        ooDisplayEcho::setDisplayImage
  ;
  ;PURPOSE:
  ;           Determine which image to display and produce 2d image array.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;ooDisplayEcho::setDisplayImage
  ;
  ;THIS PROCEDURE DECIDES WHICH IMAGE TO DISPLAY IN THE
  ;drawImage DISPLAY.  CHOICES ARE THE INTENSITY OF THE
  ;ZEROTH PHASE FOR THE CURRENT FOURIER TIME OR ANY OF
  ;THE FIT PARAMETERS.
  ;
  ;NOTE:
  ;THIS PROCEDURE SHOULD BE CALLED ONLY BY THE draw METHOD
  ;;;

  ;FREE CURRENT PHASE(0) DATA POINTER FOR REDEFINITION
  if Ptr_valid(self.ie) gt 0 then Ptr_free,self.ie

  ;GET ARRAY OF PHASE DATA FOR POSSIBLE DISPLAY
  ;
  ;CHECK THAT ftChoiceIndex IS IN RANGE AND CHANGE AS NECESSARY
  theLastIndex = N_elements((*self.mye)[0,0,*])-1
  if (self.ftchoiceindex le theLastIndex) then begin
    self.ie = Ptr_new((*self.mye)[*,0,self.ftchoiceindex])
  endif else begin
    self.ie = Ptr_new((*self.mye)[*,0,theLastIndex])
    self.ftchoiceindex = theLastIndex
  endelse

  ref = self.datacontainer->Get(position=self.qchoiceindex)
  ;print,obj_valid(ref)

  ;113005
  ;FIX THIS BUG SO THAT THE PROGRAM WILL OPEN!!!
  if Obj_valid(ref) gt 0 then begin

    ;LRK - 11/23/09

    refxdim = ref->Getproperty(tag='x_dim')
    refydim = ref->Getproperty(tag='y_dim')
    if self.detxdim ne refxdim then begin
      self.detxdim = refxdim
      Print,'ooDisplayEcho::setDisplayImage SYNCED self.detXDim'
    endif
    if self.detydim ne refydim then begin
      self.detydim = refydim
      Print,'ooDisplayEcho::setDisplayImage SYNCED self.detYDim'
    endif


    ;
    ;112805
    ;SET THE VALUE OF ref_magnetic TO TELL THE CASES BELOW TO SET IMAGE OPTIONS TO
    ;A GENERAL OPTION IF NECESSARY
    if Obj_isa(ref,'ooEchoMagnetic') gt 0 then begin
      if ref->Getproperty(tag='magnetic') eq 0 then begin
        ref_magnetic = 0
      endif else begin
        ref_magnetic = 1
      endelse
    endif else begin
      ref_magnetic = 0
    endelse



    if ref_magnetic eq 0 then begin
      if self.displayindex eq 9  then self.displayindex = 0
      if self.displayindex eq 10 then self.displayindex = 0
      if self.displayindex eq 11 then self.displayindex = 0
      if self.displayindex eq 12 then self.displayindex = 0
    endif
  endif else begin
    self.displayindex = 0
  endelse

  thisMask = Dindgen(self.detxdim*self.detydim)

  ;self.ie IS SIMPLY THE ARRAY FROM WHICH THE
  ;DISPLAYED IMAGE IS DERIVED.  HOWEVER A
  ;NEW IMAGE VARIABLE SHOULD BE USED FOR EACH
  ;OF THE CASES BELOW.

  ;CREATE IMAGE BASED ON USER'S CHOICE OF IMAGE DISPLAY OPTION
  case self.displayindex of
    0:  begin
      ;STANDARD PHASE[0] IMAGE
      ;help,*self.ie
      ;                im = reform(*self.ie,self.detxDim,self.detyDim)
      ;                                ;REFORM 3-D ARRAY INTO
      ;                                            ;2-D ARRAY BASED ON DETECTOR
      ;                                            ;DIMENSIONS

      ;nphs = n_elements((*self.mye)[0,*,theLastIndex])



      thisIm = Dindgen(self.detxdim*self.detydim)

      ;WHY WAS THIS USING theLastIndex???????????
      ;                thisIm = total((*self.mye)[*,0:ref->term()-1,theLastIndex],2)

      ;TRY THIS:   total will return a 2d array here.



      if Obj_valid(ref) gt 0 then begin
        ;print,'obj_valid(ref)=',obj_valid(ref)
        if ref->Term() gt 1 then begin
          thisIm = Total(Double((*self.mye)[*,0:ref->Term()-1,self.ftchoiceindex]),2)
        endif else begin
          thisIm = Double((*self.mye)[*,0,self.ftchoiceindex])
        endelse


        ;help,thisim
      endif else begin

        ;111605
        ;CREATE A TEMPORARY OBJECT FOR DISPLAY AND DESTROY BELOW BEFORE EXITING THE ROUTINE.
        ;

        ;110305

        ;;;;;;;;;;;;;;;;;;
        ;print,'MEMORY LEAK HERE???'
        ;print,self.datacontainer->count()
        ;;;;;;;;;;;;;;;;;
        ref = Obj_new('ooecho',/blank)
        ;    help,ref
      endelse





      ;WHY WASN'T IT THIS ALL ALONG????????????????
      ;WAS THIS A MISTAKE????

      ;110205
      ;THE NEXT BLOCK WAS REPLACED WITH THE ONE LINE COMMAND ABOVE
      ;                thisIm = double((*self.mye)[*,0,theLastIndex])
      ;                for i=0,self.detxDim*self.detyDim-1 do begin
      ;                    ;090204
      ;                    ;WHAT IS THE SIGNIFICANCE OF THIS SUMMATION
      ;                    ;AND WHY IS IT S(Q,0)?????
      ;                    thisIm[i] = total((*self.mye)[i,*,theLastIndex])
      ;                endfor;i

      im = Reform(thisIm[*,*],self.detxdim,self.detydim)
      imeb = Sqrt(Reform(thisIm[*,*],self.detxdim,self.detydim))

    end
    1:  begin
      ;AVERAGE FIT PARAMETER IMAGE SELECTED
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[0,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[6,*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    2:  begin
      ;AMPLITUDE FIT PARAMETER IMAGE SELECTED
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[1,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[7,*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    3:  begin
      ;PHASE FIT PARAMETER IMAGE SELECTED
      ;(NOTE: DUE TO AN EARLIER MISUNDERSTANDING, THIS PARAMETER
      ;IS REFERRED TO AS 'PHASEO' ELSEWHERE IN THE CODE )
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[2,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[8,*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    4:  begin
      ;SIGMA OR GAUSSIAN WIDTH FIT PARAMETER IMAGE SELECTED
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[3,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[9,*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    5:  begin
      ;OMEGA OR COSINE FREQUENCY FIT PARAMETER IMAGE SELECTED
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[4,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[10,*,self.ftchoiceindex])

      ;CONVERT FROM OMEGA TO PERIOD.
      ;                im = reform(*im3d,self.detxDim,self.detyDim)
      ;                imeb = reform(*imeb3d,self.detxDim,self.detyDim)
      im = 360.0/Reform(*im3d,self.detxdim,self.detydim)
      imeb = (360.0/Reform(*im3d,self.detxdim,self.detydim))* $
        Reform(*imeb3d,self.detxdim,self.detydim)/ $
        Reform(*im3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    6:  begin
      ;PHASE OFFSET FIT PARAMETER IMAGE SELECTED
      ;(THIS IS REFERRED TO AS THE PHASE IN THE CODE,
      ;BUT IT IS REALLY THE PHASE OFFSET.)
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[5,*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'fitparms')))[11,*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d
    end
    7:  begin   ;CHISQ
      im3d = Ptr_new($
        (*((ref)->Getproperty(tag=$
        'chisq')))[*,self.ftchoiceindex])
      imeb3d = Ptr_new($
        (*((self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag=$
        'chisq')))[*,self.ftchoiceindex])
      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)
      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d

    end
    8:  begin   ;SIGNAL --- 060605
      ;AMPLITUDE/(Idown-Iup) IMAGE SELECTED

      amp = (*((ref)->Getproperty(tag='fitparms')))[1,*,self.ftchoiceindex]
      samp = (*((ref)->Getproperty(tag='fitparms')))[7,*,self.ftchoiceindex]
      iup = (*((ref)->Getproperty(tag='Iup')))[*,self.ftchoiceindex]
      siup = (*((ref)->Getproperty(tag='sIup')))[*,self.ftchoiceindex]
      idown = (*((ref)->Getproperty(tag='Idown')))[*,self.ftchoiceindex]
      sidown = (*((ref)->Getproperty(tag='sIdown')))[*,self.ftchoiceindex]

      sig = 2.0*amp/(Idown-Iup)

      dsig = 2.0*Sqrt((samp/(Idown-Iup))^(2.0d) + $
        (amp*sIdown/(Idown-Iup)^(2.0d))^(2.0d) + $
        (amp*sIup/(Idown-Iup)^(2.0d))^(2.0d))


      im3d = Ptr_new(sig)
      imeb3d = Ptr_new(dsig)

      im = Reform(*im3d,self.detxdim,self.detydim)
      imeb = Reform(*imeb3d,self.detxdim,self.detydim)

      if Ptr_valid(im3d) gt 0 then Ptr_free,im3d
      if Ptr_valid(imeb3d) gt 0 then Ptr_free,imeb3d

    end


    ;112205
    ;SET MAGNETIC IMAGES FROM A SUB-MENU OF IMAGE OPTIONS HERE
    9:  begin
      ;magnetic image
      dum=ref->F_polanalysisgeneral(0,image=image,eimage=eimage,$
        xvals=xvals,plotdata=plotdata,$
        theimageindex = 0)
      im = image
      imeb = eimage
    end;9
    10: begin
      ;magnetic image
      dum=ref->F_polanalysisgeneral(0,image=image,eimage=eimage,$
        xvals=xvals,plotdata=plotdata,$
        theimageindex = 1)
      im = image
      imeb = eimage
    end;10
    11: begin
      ;magnetic image
      dum=ref->F_polanalysisgeneral(0,image=image,eimage=eimage,$
        xvals=xvals,plotdata=plotdata,$
        theimageindex = 2)
      im = image
      imeb = eimage
    end;11
    12: begin
      ;magnetic image
      dum=ref->F_polanalysisgeneral(0,image=image,eimage=eimage,$
        xvals=xvals,plotdata=plotdata,$
        theimageindex = 3)
      im = image
      imeb = eimage
    end;12

    else: begin
      ;NO IMAGE SELECTED, SO JUST SHOW PHASE(0)
      im = Reform(*self.ie,self.detxdim,self.detydim)
      imeb = Sqrt(Reform(*self.ie,self.detxdim,self.detydim))
    end
  endcase



  ;I DO NOT UNDERSTAND HOW THIS ARRAY CAN BE A 1024
  ;ELEMENT 1D ARRAY!!!!!!
  ;
  ;HOWEVER, I HAVE TO WORK WITH IT AS IS AND WORK
  ;OUT THAT BUG LATER!!!!!!
  ;        theMask =reform((*((self.dataContainer->get(position=$
  ;                        self.QChoiceIndex))->getProperty(tag=$
  ;                            'mask2d')))[*,*,self.ftChoiceIndex],$
  ;                                self.detXdim,self.detYdim)

  if self.datacontainer->Count() gt 0 then begin
    thisref = (ref)

    ;;;;;
    ;            print,'June 17, 2005'
    ;            refxdim = ref->getproperty(tag='x_dim')
    ;            refydim = ref->getproperty(tag='y_dim')
    ;            if refxdim ne self.detxdim then begin
    ;                theMask =reform((*(thisref->getProperty(tag=$
    ;                                'mask2d')))[*,self.ftChoiceIndex],$
    ;                                        refXdim,refYdim)
    ;
    ;            endif else begin
    ;;;;;

    theTempMask =(*(thisref->Getproperty(tag='mask2d')))[*,self.ftchoiceindex]


    ;LRK - 112309
    ;NOW INSERT A CHECK HERE TO PREVENT THE PROGRAM FROM HANGING:
    ;BUT APPARENTLY THE mask2d IS NOT BEING REBINNED PROPERLY!!!!
    ;REMOVE CHECK AND UPDATE THIS AT THE APPROPRIATE MOMENT
    ;               theTempMaskSize = size(theTempMask)
    ;               if sqrt(theTempMaskSize[1]) ne self.detXDim then theTempMask = intarr(self.detXdim,self.detYdim)
    theMask =Reform(theTempMask,self.detxdim,self.detydim)
    ;            endelse

  endif else begin
    ;111605
    ;CLEANING UP MEMORY LEAK IN CASE OBJECT WAS CREATED SIMPLY FOR DISPLAY PURPOSES WHEN
    ;NO OBJECT IS AVAILABLE
    if Obj_valid(ref) gt 0 then Obj_destroy,ref
    theMask = Intarr(self.detxdim,self.detydim)
  endelse



  ;092305
  imask = Where(theMask lt 1)
  notmask = Where(theMask eq 1)
  selfmask = Where(theMask lt 0)

  if imask[0] eq -1 then begin
    ;011005
    ;SET MASKED POINTS TO IMAGE median VALUE SO THEIR
    ;VALUES DON'T AFFECT THE COLOR SCALE.
    medim = Median(im)
    ;minim = min(im)
    medimeb = Median(imeb)
    ;minimeb = min(imeb)

    im = im*theMask
    imeb = imeb*theMask
  endif else begin

    if notmask[0] ne -1 then begin
      medim = Median(im[notmask])
      ;minim = min(im)
      medimeb = Median(imeb[notmask])
    endif else begin
      medim = 1.0;median(im[notmask])
      ;minim = min(im)
      medimeb = 1.0;median(imeb[notmask])
    endelse

    ;092305
    if selfmask[0] eq -1 then begin
      im = im*theMask
      imeb = imeb*theMask
    endif else begin
      thetotalmask = theMask
      thetotalmask[selfmask] = 0
      im = im*thetotalMask
      imeb = imeb*thetotalMask
    endelse
  endelse
  ;        endelse

  isz = Size(im)

  ;092305
  if imask[0] ne -1 then begin
    im[imask] = medim
    imeb[imask] = medimeb

    ;print,max(im)

  endif else begin

    for i=0,isz[1]-1 do begin
      for j=0,isz[2]-1 do begin
        if (theMask[i,j] eq 0 or theMask[i,j] eq -1) then begin
          ;im[i,j] = minim;CHANGE THIS TO THE AVERAGE VALUE SO THAT
          ;IT DOESN'T AFFECT THE COLOR TABLE.
          im[i,j] = medim

          imeb[i,j] = medimeb ;THIS IS FOR VISUAL PURPOSES ONLY
          ;THE DATA RANGE FOR THE EB PLOTIMAGE
          ;MUST BE SET IN A PARAMETER SET
        endif

      endfor
    endfor
  endelse
  ;RESET OBJECT'S IMAGE POINTER
  if Ptr_valid(self.im) gt 0 then Ptr_free,self.im
  self.im = Ptr_new(Double(im))
  if Ptr_valid(self.imeb) gt 0 then Ptr_free,self.imeb
  self.imeb = Ptr_new(Double(imeb))

end;setDisplayImage
pro Oodisplayecho::updateFitvals,xindex,yindex,ftIndex,dontUpdateValues=dontUpdateValues,tavestate=tavestate
  ;
  ;NAME:
  ;        ooDisplayEcho::updateFitvals
  ;
  ;PURPOSE:
  ;           Update the values in the fit parameter widgets.
  ;PARAMETERS:
  ;           xindex      Current pixel location indices.
  ;           yindex
  ;           ftIndex     Current Fourier time index
  ;
  ;KEYWORDS:
  ;           dontUpdateValues    Flag to tell the method not to update the values in the text widgets.
  ;                               The purpose is to avoid the issue on the Mac of retrieving these
  ;                               values from the data object when a simple change of the fix state
  ;                               is made.

  ;;
  ;UPDATE TEXT WIDGETS WITH CURRENT FIT VALUES
  ;;;


  ;print,'ooDisplayEcho:::updateFitvals   TEST 1 2 3'
  ;print,*p
  if self.datacontainer->Count() gt 0 then begin

    if N_elements(tavestate) eq 0 then Widget_control,self.timeaverageupdowncheckbox,get_value= tavestate

    ;GET FIT VALUES FROM DATA OBJECT FOR THESE INDICES
    ref = (self.datacontainer->Get(position=self.qchoiceindex))
    fitvals = ref->Fitvals(xindex,yindex,ftindex)


    chisqtemp =(*(ref->Getproperty(tag='chisq')))$
      [((ref)->Getproperty(tag='x_dim')*yindex+xindex),self.ftchoiceindex]


    idown = ref->Chirpidown(xindex,yindex,ftindex,tavestate=tavestate)
    iup = ref->Chirpiup(xindex,yindex,ftindex,tavestate=tavestate)

    if (idown-iup) ne 0.0 then begin
      ratiotemp = fitvals[1]/((idown-iup)/2.0)
    endif else begin
      ratiotemp = Double('Nan')
    endelse


    ;INVERT THE OMEGA FITVALUES TO PERIOD FOR DISPLAY IN
    fitvals[10] = 360.0*fitvals[10]/fitvals[4]^2
    fitvals[4] = 360.0/fitvals[4]

    ;CREATE STRING ARRAY OF FIT VALUES
    sfitVals = Strtrim(String(fitvals),2)
  endif else begin
    fitvals = Dblarr(12)
    Widget_control,self.atwwidth,get_value = swidth
    fitvals[3] = Double(swidth);702.0
    Widget_control,self.atwperiod,get_value = speriod
    fitvals[4] = Double(speriod);360.0
    fitvals[6:11] = 0.0
    sfitVals = Strtrim(String(fitvals),2)
    chisqtemp = Double('Nan')
    ratiotemp = 1.0
  endelse

  ;PLACE FIT VALUE STRINGS INTO TEXT FIELDS

  ;033005
  ;REPLACE THE NEXT COMMAND
  ;    widget_control,self.tw1,set_value= strtrim(string(xindex),2)+$
  ;                                    ','+strtrim(string(yindex),2)
  Widget_control,self.tw1,set_value = '[xindex,yindex]= ['    $
    +Strtrim(String(xindex),2)+','  $
    +Strtrim(String(yindex),2)+']'  $
    +', Pixel value ='$
    +Strtrim(String((*self.im)[xindex,yindex]),2)$
    +',chi^2 = '+Strtrim(String(chisqtemp),2)
  Widget_control,self.atwconst,set_value = sfitVals[0]
  Widget_control,self.atwamp,set_value = sfitVals[1]
  Widget_control,self.atwphaseo,set_value = sfitVals[2]
  Widget_control,self.atwsigma,set_value = sfitVals[3]
  Widget_control,self.atwomega,set_value = sfitVals[4]
  Widget_control,self.atwphase,set_value = $
    Strtrim(String(fitVals[5]),2)
  Widget_control,self.atwchisq,set_value=Strtrim(String(chisqtemp),2)
  Widget_control,self.atwratio,set_value=Strtrim(String(ratiotemp),2)

  ;ERROR VALUES
  Widget_control,self.atweconst,set_value = sfitVals[0+6]
  Widget_control,self.atweamp,set_value = sfitVals[1+6]
  Widget_control,self.atwephaseo,set_value = sfitVals[2+6]
  Widget_control,self.atwesigma,set_value = sfitVals[3+6]
  Widget_control,self.atweomega,set_value = sfitVals[4+6]
  Widget_control,self.atwephase,set_value = $
    Strtrim(String(fitVals[5+6]),2)

  if (fitvals[0] eq 200.0) then begin
    ;WRITE MESSAGE TO USER IN CASE OF POOR STATISTICS
    ;        widget_control,self.tw1,set_value=  "PROBABLY NO FIT "$
    ;                                            +"DUE TO POOR STATISTICS!"
    Widget_control,self.tw1,set_value=  "NO FIT AVAILABLE."
  endif

end;updateFitVals
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::realify,winpix,winvis
  ;
  ;NAME:
  ;        ooDisplayEcho::realify
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;COPY VIRTUAL IMAGE FROM self.drawImage OBJECT INTO
  ;REAL IMAGE DISPLAY WINDOW

  ;SET CURRENT WINDOW TO VISIBLE WINDOW PASSED FROM USER
  Wset,winvis

  ;COPY IMAGE IN VIRTUAL WINDOW TO CURRENT WINDOW
  Device,copy = [0,0,!d.x_size,!d.y_size,0,0,winpix]

end;realify
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;EVENT HANDLERS
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

pro Oodisplayecho::updateIndices,x=x,y=y,t=t
  ;
  ;NAME:
  ;        ooDisplayEcho::updateIndices
  ;
  ;PURPOSE:
  ;       Update indices and unset self.plotzoombox if indices change
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;       x   Indices
  ;       y
  ;       t
  ;_EXTRA - is used to pass keywords meant for the superclass.


  if N_elements(x) eq 0 then x = self.xindex
  if N_elements(y) eq 0 then y = self.yindex
  if N_elements(t) eq 0 then t = self.ftchoiceindex


  if x ne self.xindex or $
    y ne self.yindex or $
    t ne self.ftchoiceindex then begin
    self.plotzoombox = 0
    self.plotzoomswitch = 0
  endif

  self.xindex = x
  self.yindex = y
  self.ftchoiceindex = t



end;updateIndices

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::keyboardUpdateIndices,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::keyboardUpdateIndices
  ;
  ;PURPOSE:
  ;           Update current pixel index selections based on keyboard events.
  ;PARAMETERS:
  ;           event   The keyboard event for selecting a pixel.
  ;KEYWORDS:
  ;           none

  ;SET INDICES PROPERLY ON KEYBOARD EVENTS


  ;L,R,U,D,pageup,pagedown,home,end
  ;5,6,7,8,9     ,10      ,11  ,12

  ;L: DECREMENT self.xindex by 1 --- CYCLICAL
  ;R: INCREMENT self.xindex by 1 --- CYCLICAL


  ;112304
  ;U,D MUST BE REVERSED IF THE IMAGE IS FLIPPED
  ;USING THE yrange OPTION TO PLOTIMAGE.
  ;U: DECREMENT self.yindex by 1 --- CYCLICAL
  ;D: INCREMENT self.yindex by 1 --- CYCLICAL
  ;pageup:    INCREMENT self.ftChoiceIndex
  ;pagedown:  DECREMENT self.ftChoiceIndex
  ;home:      SET self.ftChoiceIndex TO 0
  ;end:       SET self.ftChoiceIndex TO MAXIMUM VALUE





  ;GET CURRENT VALUES
  xindex = self.xindex
  yindex = self.yindex
  tindex = self.ftchoiceindex
  case Event.key of
    5:  begin   ;LEFT ARROW
      xindex = xindex - 1
      if xindex lt 0 then begin
        xindex = self.detxdim - 1
        yindex = yindex - 1
        if yindex lt 0 then begin
          yindex = self.detydim - 1
        endif
      endif
    end
    6:  begin   ;RIGHT ARROW
      xindex = xindex + 1
      if xindex ge self.detxdim then begin
        xindex = 0
        yindex = yindex + 1
        if yindex ge self.detydim then begin
          yindex = 0
        endif
      endif
    end
    7:  begin   ;UP ARROW
      yindex = yindex - 1
      ;NOTE THAT THE FOLLOWING CHECK WILL NEED REVERSAL IF IT THE IMAGE IS FLIPPED.
      if yindex lt 0 then begin
        yindex = self.detydim - 1
        xindex = xindex - 1
        if xindex lt 0 then begin
          xindex = self.detxdim - 1
        endif
      endif
    end
    8:  begin   ;DOWN ARROW
      yindex = yindex + 1
      ;NOTE THAT THE FOLLOWING CHECK WILL NEED REVERSAL IF IT THE IMAGE IS FLIPPED.
      if yindex ge self.detydim then begin
        yindex = 0
        xindex = xindex + 1
        if xindex ge self.detxdim then begin
          xindex = 0
        endif
      endif
    end
    9:  begin
      tindex = tindex + 1
      if tindex ge N_elements(*self.ftchoices) then begin
        tindex = N_elements(*self.ftchoices) - 1
      endif
    end
    10: begin
      tindex = tindex - 1
      if tindex lt 0 then begin
        tindex = 0
      endif
    end
    11: begin
      tindex = N_elements(*self.ftchoices) - 1
    end
    12: begin
      tindex = 0
    end
    else:begin
      self->Do_nothing
    end
  endcase

  ;SET THE INDICES TO THE NEW VALUES
  self->Updateindices,x=xindex,y=yindex,t=tindex


end;keyboardUpdateIndices
pro Oodisplayecho::keyboardEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::keyboardEvents
  ;
  ;PURPOSE:
  ;           Handle keyboard events from the plot and image windows.
  ;PARAMETERS:
  ;           event   The event structure to be handled.
  ;KEYWORDS:
  ;           none


  ;THIS METHOD IS MEANT TO HANDLE KEYBOARD EVENTS
  ;FROM THE IMAGE.  THIS WILL ALLOW THE USER TO
  ;ARROW OR PAGE THROUGH THE PIXELS OF THE DETECTOR.

  ;cursor,xcurs,ycurs,/nowait,/data
  ;print,xcurs,ycurs

  ;120105
  ;GET OBJ.ID TO DISTINGUISH WINDOWS.
  ;THIS DOES NOT SEEM TO BREAK ANYTHING BY ADDING THIS STATEMENT
  Widget_control,Event.id,get_uvalue=obj
  ;print,'ooDisplayEcho::keyboardEvents obj.id='+obj.id
  if Event.press eq 1 then begin ;ONLY RESPOND TO PRESS
    ;            print,tag_names(event)
    ;            print,event
    ;USE THE 'm' OR 'M' KEYS TO ALTER THE MASK.
    if Event.ch eq 109 or Event.ch eq 77 then begin
      ;print,'MASK THIS POINT'
      ix=self.xindex
      iy=self.yindex
      it=self.ftchoiceindex

      ref = self.datacontainer->Get(position=self.qchoiceindex)
      mcurr = (*(ref->Getproperty(tag='mask2d')))[ix+self.detxdim*iy,it]
      if mcurr eq 1 then begin
        ;033005
        ;CONVERT USER MASKED PIXELS TO -1
        mnew = -1;0
      endif else mnew = 1
      (*(ref->Getproperty(tag='mask2d')))[ix+self.detxdim*iy,it] = mnew
    endif else begin

      if Event.ch ne 0 then begin ;(event.ch eq 13 --> return key.)
        ;if self.displayindex eq 3 then begin
        ;refit with selected phase to start.

        ;DISPLAY CONTEXT MENU ON A KEYBOARD KEY PRESS.

        ;DISPLAY CONTEXT MENU
        maskContextBase = Widget_info(Event.id, FIND_BY_UNAME = 'MASKCONTEXTBASE')
        plotContextBase = Widget_info(Event.id, FIND_BY_UNAME = 'PLOTCONTEXTBASE')

        if Widget_info(maskContextBase,/valid_id) then begin
          Widget_displaycontextmenu, Event.id, Event.x, Event.y, maskContextBase
        endif else begin
          Widget_displaycontextmenu, Event.id, Event.x, Event.y, plotContextBase
        endelse

      endif else begin
        ;print,tag_names(event)
        ;print,event

        self->Keyboardupdateindices,Event

      endelse
    endelse;m or M pressed
    self->Mousehead,Event

  endif;press eq 1
end;keyboardEvents
pro Oodisplayecho::mouseGuts,myxindex = myxindex,myyindex = myyindex,$
  fitparms = fitparms
  ;
  ;NAME:
  ;        ooDisplayEcho::mouseGuts
  ;
  ;PURPOSE:
  ;           Routine to call each of the expected routines
  ;           following mouse events.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           myxindex    The current x,y indices
  ;           myyindex
  ;           fitparms    fitparms appears to be unused.


  ;    print,'ooDisplayEcho::mouseGuts'

  ;THIS METHOD IS MEANT TO ENCAPSULATE THE FUNCTIONALITY
  ;OF THE ooDisplayEcho::mouseEvents EVENT HANDLER.
  ;
  ;THE PURPOSE OF THIS IS THAT THIS FUNCTIONALITY
  ;IS DESIRED IN OTHER CLASS METHODS.
  ;

  ;COPY INDEX ARGUMENTS TO PREIOUSLY NAMED INDICES
  xindex = myxindex
  yindex = myyindex
  ;GET FOURIER TIME INDEX FROM THE CLASS
  ftindex = self.ftchoiceindex

  self->Draw,xindex=xindex,yindex=yindex,tauindex=ftindex

  self->Updatefitvals,xindex,yindex,ftindex

  ;050504
  self->Updatemaskmaker

end;mouseGuts
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::mouseHead,Event,t=t
  ;
  ;NAME:
  ;        ooDisplayEcho::mouseHead
  ;
  ;PURPOSE:
  ;           Produces functionality for mouse, widget_draw, widget_button
  ;           and widget_tree_sel events.  Called following file tree selection.
  ;
  ;PARAMETERS:
  ;           event   The event structure passed here.
  ;KEYWORDS:
  ;           t       The currently selected Fourier time.



  ;FUNCTIONALITY COMMON TO ALL MOUSE EVENTS

  ;102804
  ;IS IT NECESSARY TO CALCULATE THE MOUSE POSITION
  ;HERE OR WILL THAT HAVE ALWAYS BEEN DONE BY THE CALLING
  ;METHOD???

  ;TRY COMMENTING OUT THE NEXT TWO LINES AND ADD THE FOLLOWING TWO LINES
  ;        indTemp = self->getPositionOnImage(event)
  ;
  ;        xindex = indTemp[0] & yindex = indTemp[1]

  ;120504
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;TRY TO RUN THIS CODE BLOCK BEFOR THE REST OF THE METHOD.
  ;THE ORDER SHOULD NOT MATTER.
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;EVENT TYPES THAT GET HERE:
  ;widget_draw
  ;widget_button
  ;widget_tree_sel
  ;120504
  etype = Tag_names(event,/structure_name)

  ;print,'ooDisplayEcho::mouseHead'
  ;print,'etype=',etype

  if etype eq 'WIDGET_BUTTON' or etype eq 'WIDGET_DRAW' then begin
    if etype ne 'WIDGET_DRAW' then begin

      ;TIME AVERAGE CHECK SHOULD NOT BE NECESSARY ON DRAW EVENTS SINCE THE STATE
      ;SHOULD NOT BE CHANGEABLE THERE.
      checktime_aveflag = 1
      checkdeepmaskflag = 1

      ;CHECK OTHER WIDGETS, esp ftime widgets
      timestepbuttons = [self.rewbuttontau,self.revbuttontau,$
        self.Fwdbuttontau,self.ffwdbuttontau]

      wh_timebutton = Where(timestepbuttons eq Event.id,wh_count)

      if wh_count ne 0 then begin
        checktime_aveflag = 0
        checkdeepmaskflag = 0
      endif

    endif else begin
      checktime_aveflag=0
      checkdeepmaskflag = 0

    endelse



    self->Redefinewidgets,self.qchoiceindex,t=self.ftchoiceindex,checktime_aveflag=checktime_aveflag,$
      checkdeepmaskflag=checkdeepmaskflag
    ftindex = self.ftchoiceindex


  endif else begin

    checktime_aveflag = 1
    checkdeepmaskflag = 1
    if Event.id eq self.adwtau then checktime_aveflag = 0

    self->Redefinewidgets,self.qchoiceindex,/newsize,t=t,checktime_aveflag=checktime_aveflag,$
      checkdeepmaskflag=checkdeepmaskflag
    if N_elements(t) eq 0 then begin
      ftindex = 0
    endif else begin
      ftindex = t
    endelse

  endelse

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  xindex = self.xindex    ;SET IN ooDisplayEcho::redefinewidgets
  yindex = self.yindex    ;SET IN ooDisplayEcho::redefinewidgets

  ;PLOT DATA IN WINDOW
  self->Draw,xindex=xindex,yindex=yindex,tauindex=ftindex

  self->Updatefitvals,xindex,yindex,ftindex
  self->Updatemaskmaker

  ;SET TEXT WIDGET TO DISPLAY CURRENT POSITION IN PLOT
  chisqtemp =(*((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='chisq')))$
    [((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='x_dim')*yindex+xindex),$
    self.ftchoiceindex]
  Widget_control,self.tw1,set_value = '[xindex,yindex]= ['    $
    +Strtrim(String(xindex),2)+','  $
    +Strtrim(String(yindex),2)+']'  $
    +', Pixel value ='$
    +Strtrim(String((*self.im)[xindex,yindex]),2)$
    +',chi^2 = '+Strtrim(String(chisqtemp),2)




  ;040605
  ;SETS EDITABILITY ON SELCTION OF OBJECT
  thetype = (self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='type')
  ;print,'thetype=',thetype
  ;help,thetype
  transeditable = 0
  volfraceditable = 0
  case thetype of
    0:begin
      transeditable = 1
      volfraceditable = 1
    end
    1:begin;res
      transeditable = 0
      volfraceditable = 0
    end
    2:begin;dat
      transeditable = 1
      volfraceditable = 1
    end
    3:begin;cell
      transeditable = 1
      volfraceditable = 0
    end
    else:begin
      transeditable = 1
      volfraceditable = 1
    end
  endcase
  Widget_control,self.atwtrans,editable = transeditable
  Widget_control,self.atwvolfrac,editable = volfracseditable






  ;    ;EVENT TYPES THAT GET HERE:
  ;        ;widget_draw
  ;        ;widget_button
  ;        ;widget_tree_sel
  ;    etype = tag_names(event,/structure_name)
  ;    print,etype
  ;
  ;    if etype eq 'WIDGET_BUTTON' or etype eq 'WIDGET_DRAW' then begin
  ;        self->redefinewidgets,self.QChoiceIndex,t=self.ftChoiceIndex
  ;    endif else begin
  ;        self->redefinewidgets,self.QChoiceIndex,/newsize
  ;    endelse
end;mouseHead
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::mouseEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::mouseEvents
  ;
  ;PURPOSE:
  ;           Handle mouse events and dispatch to the proper function.
  ;PARAMETERS:
  ;           event   The event to handle.
  ;KEYWORDS:
  ;           none.

  ;print,'ooDisplayEcho::mouseEvents'
  ;t0 = systime(1,/seconds)
  ;print,'_____________________'
  ;print,systime(1,/seconds)-t0
  ;print,tag_names(event)
  ;print,'event.type=',event.type
  ;print,'event.clicks=',event.clicks
  ;print,'event.press=',event.press
  ;print,systime(1,/seconds)-t0
  ;;
  ;THIS METHOD IS DESIGNED TO HANDLE EVENTS FROM THE MOUSE.
  ;;;

  if (Event.type eq 0) then begin ;REACTION ON A PRESS

    ;        print,'NEW MOUSE PRESS EVENT'
    ;SET CLASS PIXEL INDEX VALUES BASED ON THE MOUSE EVENT
    ;THIS MUST BE DONE HERE.  01/30/04
    indTemp = self->Getpositiononimage(event)


    xindex = indTemp[0] & yindex = indTemp[1]

    ;102804
    ;ALWAYS SET IMAGE TO IGNORE MOUSE MOTIONS.
    self.mousemotionblock = 1


    ;021706
    ;        self.xindex = xindex
    ;        self.yindex = yindex
    self->Updateindices,x=xindex,y=yindex

    ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
    ;;
    ;GET I v. PHASE ARRAY AT SELECTED PIXEL
    ;;;

    ;GET THE FOURIER TIME INDEX
    ftindex = self.ftchoiceindex

    ;GET THE PHASES (xvals) FOR THAT FOURIER TIME
    xvals=(self.datacontainer->Get(position=self.qchoiceindex))->Chirpphases(ftIndex)

    ;;
    ;USE emask FOR DISPLAY
    ;;;

    self->Mousehead,Event

  endif;event.type eq 0
  if ((Event.type eq 2) and (self.mousemotionblock ne 1)) then begin
    ;HANDLE MOUSE _MOTION_ EVENTS
    ;THIS ALLOWS USER TO SEE EXACTLY WHERE MOUSE IS IN IMAGE
    ;BEFORE CLICKING.

    ;GET MOUSE POSITION IN IMAGE
    indTemp = self->Getpositiononimage(event)

    ;SET INDEX VALUES
    xindex = indTemp[0]
    yindex = indTemp[1]


    self->Boxpixel,xindex,yindex
    self->Mousehead,Event

  endif;event.type eq 2 ;I.E. MOUSE MOTION

end;mouseEvents
pro Oodisplayecho::boxPixel,xindex,yindex
  ;
  ;NAME:
  ;        ooDisplayEcho::boxPixel
  ;
  ;PURPOSE:
  ;           Draw a box around the currently selected pixel in the image.
  ;PARAMETERS:
  ;           xindex      The currently selected pixel indices.
  ;           yindex
  ;KEYWORDS:
  ;           none.

  ;DRAW A BOX AROUND THE PIXEL AT THE CURRENT MOUSE POSITION
  ;ON IMAGE.

  ;DRAW IMAGE TO ITS PIXMAP
  self->Imagevirtual


  Device,get_decomposed = dc
  Device,decomposed=1

  thisBox = [[xindex,yindex],$
    [xindex+1,yindex],$
    [xindex+1,yindex+1],$
    [xindex,yindex+1],$
    [xindex,yindex]]

  purple = 255L + 256L*(0L + 256L*255L)
  yellow = 0L + 256L*(255L + 256L*255L)

  ;SET WINDOW DATA AXIS POINTERS
  !x = *self.w1xptr
  !y = *self.w1yptr
  Plots,thisBox,thick=4,/data,color=yellow
  Device,decomposed=dc

  ;COPY VIRTUAL IMAGE FROM PIXMAP TO REAL WINDOW
  self->Realify,self.dw1pix,self.dw1id

end;boxPixel
function Oodisplayecho::getPositionOnImage,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::getPositionOnImage
  ;
  ;PURPOSE:
  ;           Determine the pixel on the image where a mouse event occurred.
  ;PARAMETERS:
  ;           event   The event structure.
  ;KEYWORDS:
  ;           none
  ;RETURN VALUE:
  ;           [xindex,yindex]     The 2 elements index array.
  ;
  Wset,self.dw1id

  ;SET WINDOW DATA AXIS POINTERS
  !x = *self.w1xptr
  !y = *self.w1yptr

  ;CONVERT MOUSE EVENT COORDINATES TO DATA COORDINATES
  dcoords = Convert_coord(Event.x,Event.y,/device,/to_data)

  ;SET IMAGE PIXEL INDICES FROM THE DATA COORDINATES
  xindex = Fix(dcoords[0]) & yindex = Fix(dcoords[1])

  ;ENSURE THAT THE IMAGE PIXEL INDICES ARE IN THE
  ;RANGE OF THE IMAGE DIMENSIONS
  if (xindex ge self.detxdim) then $
    xindex = self.detxdim-1
  if (xindex le 0) then xindex = 0
  if (yindex ge self.detydim) then $
    yindex = self.detydim-1
  if (yindex le 0) then yindex = 0

  ;021706
  ;self.xindex = xindex & self.yindex = yindex
  self->Updateindices,x=xindex,y=yindex


  Return,[xindex,yindex]

end;getPositionOnImage
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Oodisplayecho::getPositionOnPlot,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::getPositionOnPlot
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;RETURN VALUE:
  ;

  ;SET WINDOW DATA AXIS POINTERS
  !x = *self.w2xptr
  !y = *self.w2yptr

  ;CONVERT MOUSE EVENT COORDINATES TO DATA COORDINATES
  dcoords = Convert_coord(Event.x,Event.y,/device,/to_data)

  ;print,'mousex,mousey = ',dcoords
  Return,dcoords[0:1]

end;getPositionOnPlot
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Oodisplayecho::getFixed
  ;
  ;NAME:
  ;        ooDisplayEcho::getFixed
  ;
  ;PURPOSE:
  ;           Determine the current states of all of the droplist
  ;           widgets for fixing/varying of fit parameters.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none
  ;RETURN VALUE:
  ;           fixed   The 6 element array of 1/0 for each fit parameter.

  ;GET CURRENT VALUES OF THE FIXED/VARY DROPLIST WIDGETS
  fixed = Intarr(6)

  ;GET LIST OF STRINGS
  Widget_control,self.dropfixconst,get_value=vals
  ip = Intarr(6)

  ip[0] = Widget_info(self.dropfixconst,/droplist_select)
  ip[1] = Widget_info(self.dropfixamp,/droplist_select)
  ip[2] = Widget_info(self.dropfixphaseo,/droplist_select)
  ip[3] = Widget_info(self.dropfixsigma,/droplist_select)
  ip[4] = Widget_info(self.dropfixomega,/droplist_select)
  ip[5] = Widget_info(self.dropfixphase,/droplist_select)


  ;THIS APPEARS TO HANDLE PROPERLY ALL OF THE fixed CASES.
  for i=0,N_elements(ip)-1 do begin
    ;        if stregex(vals[ip[i]],'vary',/fold_case,/boolean) then begin
    if Stregex(vals[ip[i]],'v',/fold_case,/boolean) then begin
      fixed[i] = 0
    endif else begin

      ;021306
      ;THIS MUST BE EXPANDED TO HANDLE THE CASES OF FIXING
      ;FOR PIXEL (1), TIME (2), ALL T (3)

      fixed[i] = 1
    endelse
  endfor;i

  Return,fixed
end;getFixed



;+
;NAME:
;        ooDisplayEcho::fitButtonHandler
;
;PURPOSE:
;           Handle button events from fit buttons.
;PARAMETERS:
;           event   The button event structure.
;KEYWORDS:
;           none
;_
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::fitButtonHandler,Event

  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::fitButtonHandler!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    Catch, /cancel
    Return
  endif
  Widget_control,Event.id,get_uvalue=obj
  Widget_control,self.timeaverageupdowncheckbox,get_value=tavestate
  self->Setpixelindices

  ref = self.datacontainer->Get(position=self.qchoiceindex)
  ref->Storefitparms
  ref_tavestate = tavestate;ref->report_timeaverage_state()

  fitVals = (*((self.datacontainer->Get(position= $
    self.qchoiceindex))->Getproperty(tag='fitparms')))[*,$
    self.xindex+self.yindex*self.detxdim,$
    self.ftchoiceindex]

  ;print,'THESE VALUES COME FROM THE FITTING TAB!!!'
  Widget_control,self.atwconst,get_value=sconstStart
  constStart = Double(sconstStart)
  Widget_control,self.atwamp,get_value=sampStart
  ampStart = Double(sampStart)
  Widget_control,self.atwphaseo,get_value=sphaseoStart
  phaseoStart = Double(sphaseoStart)
  Widget_control,self.atwsigma,get_value=ssigmaStart
  sigmaStart = Double(ssigmaStart)

  ;120904
  ;CONVERT PERIOD VALUE TO OMEGA
  Widget_control,self.atwomega,get_value=somegaStart
  omegaStart = 360.0/Double(somegaStart)
  Widget_control,self.atwphase,get_value=sphaseStart
  phaseStart = Double(sphaseStart)

  startparms =   [constStart,ampStart,phaseoStart,$
    sigmaStart,omegaStart,phaseStart]

  ;10/19/04
  ;
  ;NOTE:  THE WRONG fitAll's HAVE BEEN CALLED HERE!!!!!
  ;       THIS MAY EXPLAIN ALL OF THE DIFFICULTY IN FITTING PROGRESS!!!!!
  ;
  ;   REPLACE fitAll's WITH arcFit.  IT SEEMS TO BE MORE ROBUST,
  ;   EVEN BEFORE MANY CHECKS HAVE BEEN IMPLEMENTED.
  ;
  case obj.id of
    'FITBUTTON1': begin
      Widget_control,self.tw1,$
        set_value="FITBUTTON1 EVENT OCCURRED"
      ref = (self.datacontainer->Get(position= $
        self.qchoiceindex))
      ;ref_tavestate = ref->report_timeaverage_state()

      ;SET THIS PIXEL'S FIXED VALUE
      fixed = self->Getfixed()
      ref->Setfixed,fixed,x=self.xindex,y=self.yindex,t=self.ftchoiceindex

      result = ref->Chirpfit( self.xindex,self.yindex,self.ftchoiceindex,fixed=fixed,$
        startparms=startparms,tavestate=ref_tavestate)
    end

    'FITBUTTON': begin
      ref = (self.datacontainer->Get(position= self.qchoiceindex))
      ref_tavestate = ref->Report_timeaverage_state()

      ;SET THIS PIXEL'S FIXED VALUE
      fixed = self->Getfixed()
      for i=0,self.detxdim-1 do begin
        for j=0,self.detydim-1 do begin
          ref->Setfixed,fixed,x=i,y=j,t=self.ftchoiceindex
        endfor;j
      endfor;i

      ref->Fitall,tauind = self.ftchoiceindex,fixed=fixed,$
        startparms=startparms,obj=self,tavestate=ref_tavestate
    end

    'FITBUTTONALL': begin


      ;NEED TO INCORPORATE THE OPTIONS PASSED BY cwo_pickmethod
      ;
      ;i.e    I NEED TO HAVE ALL METHODS, INCLUDING THE SPIRAL METHOD
      ;     AVAILABLE HERE AND CHOOSE BASED ON THE USER SELECTED METHOD.

      ;IF THE EVENT COMES FROM THE SELECTOR THEN ONLY FIT IF event.fit ne 0
      ;OTHERWISE ALWAYS FIT

      ;GET FIXED/VARY VALUES FROM GUI AND SET data.fixed TO
      ;THE APPROPRIATE VALUES.
      ref = (self.datacontainer->Get(position=self.qchoiceindex))
      ref_tavestate = ref->Report_timeaverage_state()

      fixed = self->Getfixed()
      self.fixed=fixed
      ;032906
      ;CHECK THE "FIXED" POSITION OF THE PHASE PARAMETER.
      ;IF THE FIXED POSITION IS "FIX ALL PIXEL ALL T" THEN
      ;USE THE noborrow OPTION SO THAT THE PHASES ARE NOT
      ;BORROWED, AND THUS CHANGED, FORM ONE TIME TO THE NEXT.
      ;
      phasefixindex = Widget_info(self.dropfixphaseo,/droplist_select);nse_comboindex(self.dropfixphaseo)
      if phasefixindex eq 7 then noborrow = 1
      if phasefixindex eq 8 then noborrow = 1

      ;110304
      ;
      ;THESE NEXT OPERATIONS SHOULD TAKE PLACE IN THE DATA OBJECT fitall ROUTINES!!!
      ;CHECK GAUSSIAN WIDTH
      if fixed[3] eq 1 then begin
        Widget_control,self.atwsigma,get_value=ssigma
        ;dum=dialog_message('oodisplayecho::fitbuttonhandler ssigma='+ssigma)
        sigma = Double(ssigma)
        ;                            (*(ref->getProperty(tag= $
        ;                                    'fitparms')))[3,*,*] = double(ssigma)
      endif

      if Tag_names(event,/structure_name) eq 'CWO_PICKMETHOD_EVENT' then begin
        ;NEED CASE STATEMENT HERE TO SELECT FITTING OPTION.
        if (Event.fit ne 0) then begin
          case Event.option of
            'arc':begin
              ref->Arcfit,fixed=fixed,sigma=sigma,noborrow=noborrow,tavestate=ref_tavestate
            end;arc

            'expand':begin
              ;dum=dialog_message('THIS IS SLOWER THAN AND TYPICALLY NOT AS GOOD AS "arc"')
              ref->Fitall3,1,fixed=self.fixed,sigma=sigma,startparms=startparms,$
                obj=self,noborrow=noborrow,tavestate=ref_tavestate
            end;expand

            'spiral':begin
              ref->Spiralfit,noborrow=noborrow,tavestate=ref_tavestate
            end;spiral

            else: begin
              Print,'ooDisplayEcho::fitButtonHandler   else: '
              ref->Arcfit,fixed=fixed,sigma=sigma,noborrow=noborrow,tavestate=ref_tavestate
            end;else
          endcase
        endif
      endif else begin
        Widget_control,self.atwwidth,get_value=myWidth
        Widget_control,self.atwperiod,get_value=myPeriod
        Print,'Probably single data object fit as resolution from Data Files tab'
        thisref=(self.datacontainer->Get(position=self.qchoiceindex))
        thisref_tavestate = thisref->Report_timeaverage_state()
        thisref->Arcfit,tavestate=thisref_tavestate,sigma=myWidth,period=myperiod
      endelse
      self->Redefinetree
    end

    'FITBUTTONALLPLUS360': begin
      ;121404
      ;NOW DO FIT BASED ON CHOSEN FIT METHOD
      self->Shiftfit,fixed = fixed, sigma = sigma,/plus360, obj=self,tavestate=ref_tavestate
      self->Redefinetree
    end

    'FITBUTTONALLMINUS360': begin
      ;;SHIFT ALL PHASES BY -360 AND REFIT
      ;(self.dataContainer->get(position=self.QChoiceIndex))->lower360

      ;121404
      ;NOW DO FIT BASED ON CHOSEN FIT METHOD
      self->Shiftfit,fixed = fixed, sigma = sigma,$
        /minus360, obj=self,tavestate=ref_tavestate
      self->Redefinetree
    end

    'FITBUTTONALLQ': begin
      currentQ = self.qchoiceindex
      nQ = self.datacontainer->Count()
      self->Swapdataobject,currentQ,0

      thisref = (self.datacontainer->Get(position=self.qchoiceindex))
      thisref_tavestate = thisref->Report_timeaverage_state()

      thisref->Fitall,fixed=self.fixed,startparms=startparms,obj=self,tavestate=thisref_tavestate

      for i=1,nQ-1 do begin
        self->Swapdataobject,i-1,i
        thisref=(self.datacontainer->Get(position=self.qchoiceindex))
        thisref->Fitall,fixed=self.fixed,startparms=startparms,obj=self,tavestate=thisref_tavestate
      endfor;i

      self->Swapdataobject,nQ-1,currentQ
      self->Setdataparameters,(self.datacontainer->Get(position=self.qchoiceindex)),n=self.qchoiceindex
      self->Redefinewidgets,self.qchoiceindex
      self->Redefinetree
    end

    else: begin
      Widget_control,self.tw1,set_value='UNKNOWN BUTTON: '+obj.id+':'+Tag_names(event)
    end
  endcase


  ;031506
  ;DRAW IS HANDLED IN self->mouseGuts CALLED BELOW.

  ;NEXT OVERLAY NEW PLOT AND SET VALUES IN
  ;FIT PARAMETERS MATRIX

  if (N_elements(result) le 1) then begin;result = fitVals
    fitVals = (*((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='fitparms')))[*,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
    result = fitVals
  endif

  self->Mouseguts,myxindex = self.xindex,myyindex = self.yindex,fitparms = result

end;fitButtonHandler



;+
;NAME:
;        ooDisplayEcho::shiftFit
;
;PURPOSE:
;               Select the approprite fit-all routine and shift phases before refit.
;PARAMETERS:
;           none
;KEYWORDS:
;           fixed       The 6 element array of 1/0 to fix/vary parameters during fit.
;           sigma       the Gaussian width to use.
;           minus360    flag to shift phases by -360 before refit.
;           plus360     flag to shift phases by +360 deg before refit.
;           obj         The display object to update if desired.
;-
pro Oodisplayecho::shiftFit,fixed=fixed, sigma = sigma,$
  minus360=minus360,$
  plus360=plus360,obj=obj,tavestate=tavestate,_Extra=extra

  ;121404
  ;NOW DO FIT BASED ON CHOSEN FIT METHOD

  ;041305
  ;UPDATING THIS NOW THAT fitselectorobj USES A BUTTON IN PLACE OF A COMBOBOX
  Widget_control,(self.fitselectorobj)->Getproperty(/combo),get_value=fval
  segs = Strsplit(fval,/extract)  ;TO REMOVE THE ' >'

  ref = (self.datacontainer->Get(position= self.qchoiceindex))
  if N_elements(tavestate) eq 0 then tavestate=ref->Report_timeaverage_state()


  case segs[0] of
    'expand':begin
      ;072805
      ;fitall2 WAS COMMENTED OUT OF THE FILE, SO PUT A MESSAGE
      ;TO PUT THIS FIX OFF.
      ;void = dialog_message('THE EXPAND METHOD IS NOT SUPPORTED FOR SHIFTED PHASES.')

      ;USE THE SAME METHOD AS FOR smoothT  (SEE 'FITBUTTON' EVENT HANDLER)
      ;OR USE fitbutton3a (WHICH EVER IS USED FOR INDIVIDUAL t FITTING FROM fitall4(???))

      ;SET THIS PIXEL'S FIXED VALUE
      fixed = self->Getfixed()
      ref->Fitall,tauind = self.ftchoiceindex,fixed=fixed,startparms=startparms,obj=self,$
        minus360 = minus360,plus360 = plus360,tavestate=tavestate
    end;expand

    'arc':begin
      ref->Arcfit,fixed=fixed,sigma=sigma,minus360=minus360,plus360=plus360,obj=obj,$
        tauind = self.ftchoiceindex,tavestate=tavestate
    end

    'spiral':begin
      ref->Spiralfit,fixed=fixed,sigma=sigma,minus360=minus360,$plus360=plus360,obj=obj,$
        tauind = self.ftchoiceindex,tavestate=tavestate
    end;spiral

    else:begin
      dum=Dialog_message('Unknown fit method')
    end;else
  endcase

end;shiftFit



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::updateMaskmaker
  ;
  ;NAME:
  ;        ooDisplayEcho::updateMaskmaker
  ;
  ;PURPOSE:
  ;           Update the maskmaker widget following an event.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;print,'updateMaskmaker'
  ;IF THERE IS AN EXISTING MASKMAKER, UPDATE IT,
  ;OTHERWISE DO NOTHING.
  if self.maskbase ne 0L then begin
    ;widget_control,self.maskBase,/destroy
    ;self->makeMaskmaker
    theref = self.datacontainer->Get(position=self.qchoiceindex)

    theMask = (*(theref->Getproperty(tag='mask2d')))[*,self.ftchoiceindex]

    Widget_control,self.maskmakercw,set_value=theMask

  endif

end;updateMaskmaker

pro Oodisplayecho::maskEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::maskEvents
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;031506
  ;THIS METHOD APPEARS TO BE UNUSED


  ;print,'maskEvent occurred'

  ;print,tag_names(event);,/structure_name)
  ;print,event

  ;print,tag_names(event)
  ;print,event
  ;print,event.mask

  ref=self.datacontainer->Get(position=self.qchoiceindex)

  Widget_control,Event.id,get_value=themask

  maskptr = ref->Getproperty(tag='mask2d')
  (*maskptr)[*,self.ftchoiceindex] = themask;event.mask

  ;print,'themask'

  self->Draw

end;maskEvents
pro Oodisplayecho::makeMaskmaker
  ;
  ;NAME:
  ;        ooDisplayEcho::makeMaskmaker
  ;
  ;PURPOSE:
  ;           Create a maskmaker widget for interacting with the data mask.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;GET MASK

  ;POINT TO MASK MEMORY SPACE AND PASS
  ;THE REFERENCE TO cw_maskmaker

  ;CREATE A BASE IN WHICH TO DISPLAY THE cw_maskmaker

  ;print,'makeMaskMaker'
  if self.maskbase eq 0L then begin
    self.maskbase = Widget_base(group_leader=self.atlb,floating=1)

    ref = self.datacontainer->Get(position=self.qchoiceindex)

    if Ptr_valid(self.maskmakermask) gt 0 then Ptr_free,self.maskmakermask
    self.maskmakermask = $
      Ptr_new((*(ref->Getproperty(tag='mask2d')))[*,self.ftchoiceindex])

    ;help,(*(ref->getProperty(tag='mask2d')))[*,self.ftChoiceIndex]
    self.maskmakercw = Cw_maskmaker(self.maskbase,$
      *self.maskmakermask,$
      $;notify_id = self.atlb,$
      xsize=self.plotxsize,$
      ysize=self.plotysize,$
      uname='MASKMAKER',$
      uvalue={object:self,$
      method:'maskEvents',$
      id:'MASKMAKER'})


    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.maskbase,set_uvalue=$
      {object:self,$
      method:'maskEvents',$
      cleanup:'maskCleanup',$
      id:'MASKMAKER'};,$
    ;event:dumEvent}
    Widget_control,self.maskbase,/realize



    ;050704
    ;SOMEHOW THIS CLEANUP HAS TO BE DONE IN TWO DIFFERENT
    ;CASES, ONE WHEN self.maskBase IS SEPARATELY DESTROYED
    ;AND THE OTHER WHEN OBJECT IS DESTROYED!!!!!
    Xmanager,'ooDisplayEcho',self.maskbase,/no_block,$
      cleanup='maskBaseCleanup'

  endif

end;makeMaskmaker
pro Oodisplayecho::maskCleanup,id
  ;
  ;NAME:
  ;        ooDisplayEcho::maskCleanup
  ;
  ;PURPOSE:
  ;           Cleanup variables associated with the maskmaker widget.
  ;PARAMETERS:
  ;           id  The widget id of the maskmaker base.
  ;KEYWORDS:
  ;           none


  Widget_control,id,get_uvalue=uval
  ;print,n_elements(tag_names)
  if Obj_valid(uval.object) gt 0 then begin
    Ptr_free,(uval.object).maskmakermask
    ;widget_control,self.maskmakercw,/destroy
    Widget_control,self.maskbase,/destroy
    self.maskbase = 0L
  endif

end;maskCleanup
pro Maskbasecleanup,id
  ;
  ;NAME:
  ;        maskBaseCleanup
  ;
  ;PURPOSE:
  ;           Clean up the maskmaker widget.
  ;PARAMETERS:
  ;           id
  ;KEYWORDS:
  ;           none

  ;print,'id=',id
  Widget_control,id,get_uvalue=uval
  Call_method,uval.cleanup,uval.object,id

  ;
  ;    print,tag_names(uval)
  ;    print,uval
  ;    ptr_free,(uval.object).maskmakermask
  ;    widget_control,self.maskBase,/destroy
end;maskBaseCleanup

pro Oodisplayecho::maskButtonHandler,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::maskButtonHandler
  ;
  ;PURPOSE:
  ;           Handle button events in ooDisplayEcho associated with mask control.
  ;PARAMETERS:
  ;           event
  ;KEYWORDS:
  ;           none

  ;050605
  ;NOTE THAT THE OPERATIONS IN THIS METHOD SHOULD HAVE BEEN ENCAPSULATED IN THE
  ;DATA OBJECT.
  ;
  ;THIS IS TRUE FOR MANY METHODS IN THIS SOFTWARE, AND IT SHOULD BE DONE
  ;AT SOME POINT.
  ;


  ;pmask = (self.dataContainer->get(position= $
  ;            self.QChoiceIndex))->getProperty(tag='mask2d')
  ;mb = obj_new('maskMaker',self.atlb,pmask)

  ;print,event.id

  Widget_control,Event.id,get_uvalue=uval
  ;print,uval.id


  case uval.id of
    'MASKBUTTON':self->Makemaskmaker
    'MASKBUTTONAPPLY':begin
      ;062204
      ;APPLY CURRENT MASK TO ALL FOURIER TIMES.

      ;GET THE OBJECT REFERENCE FOR THE CURRENTLY SELECTED
      ;Q-VALUE
      ref=self.datacontainer->Get(position=self.qchoiceindex)

      ;GET MASK ARRAY
      maskptr = ref->Getproperty(tag='mask2d')

      ;GET THE MASK FOR THE CURRENT IMAGE
      themask = (*maskptr)[*,self.ftchoiceindex]

      sz = Size(*maskptr)

      ;ASSIGN THE MASK TO ALL OF THE IMAGES
      for i=0,sz[2]-1 do begin
        (*maskptr)[*,i] = themask
      endfor
      ;print,'TEST'
      self->Draw
    end
    'MASKBUTTONPIXELAPPLY':begin
      ;040805
      ;APPLY CURRENT PIXEL MASKING TO ALL FOURIER TIMES.

      ;GET THE OBJECT REFERENCE FOR THE CURRENTLY SELECTED
      ;Q-VALUE
      ref=self.datacontainer->Get(position=self.qchoiceindex)

      ;GET MASK ARRAY
      maskptr = ref->Getproperty(tag='mask2d')

      index = self.xindex + self.yindex*self.detxdim

      ;GET THE MASK FOR THE CURRENT IMAGE
      themask = (*maskptr)[index,self.ftchoiceindex]

      sz = Size(*maskptr)

      ;ASSIGN THE PIXEL MASK TO ALL OF THE IMAGES
      ;            for i=0,sz[2]-1 do begin
      ;(*maskptr)[*,i] = themask
      (*maskptr)[index,*] = themask
      ;            endfor

      self->Draw
    end
    'MASKBUTTONSUBSEQUENTAPPLY':begin
      ;050604
      ;APPLY CURRENT MASK TO ALL SUBSEQUENT FOURIER TIMES.

      ;GET THE OBJECT REFERENCE FOR THE CURRENTLY SELECTED
      ;Q-VALUE
      ref=self.datacontainer->Get(position=self.qchoiceindex)

      ;GET MASK ARRAY
      maskptr = ref->Getproperty(tag='mask2d')

      ;GET THE MASK FOR THE CURRENT IMAGE
      themask = (*maskptr)[*,self.ftchoiceindex]

      sz = Size(*maskptr)

      ;ASSIGN THE MASK TO SUBSEQUENT IMAGES
      for i=self.ftchoiceindex,sz[2]-1 do begin
        (*maskptr)[*,i] = themask
      endfor

      self->Draw
    end
    'MASKBUTTONSUBSEQUENTPIXELAPPLY':begin
      ;050605
      ;APPLY CURRENT PIXEL MASKING TO SUBSEQUENT FOURIER TIMES.

      ;GET THE OBJECT REFERENCE FOR THE CURRENTLY SELECTED
      ;Q-VALUE
      ref=self.datacontainer->Get(position=self.qchoiceindex)

      ;GET MASK ARRAY
      maskptr = ref->Getproperty(tag='mask2d')

      index = self.xindex + self.yindex*self.detxdim

      ;GET THE MASK FOR THE CURRENT IMAGE
      themask = (*maskptr)[index,self.ftchoiceindex]

      sz = Size(*maskptr)

      ;ASSIGN THE PIXEL MASK TO ALL SUBSEQUENT IMAGES
      (*maskptr)[index,self.ftchoiceindex:*] = themask

      self->Draw
    end
    else:begin
    end
  endcase

end;maskButtonHandler
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::buttonEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::buttonEvents
  ;
  ;PURPOSE:
  ;           Dispatch button event to appropriate handlers.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none


  Widget_control,Event.id,get_uvalue=obj
  case obj.id of
    'FITBUTTON1':           self->Fitbuttonhandler,Event
    'FITBUTTON':            self->Fitbuttonhandler,Event
    'FITBUTTONALL':         self->Fitbuttonhandler,Event
    'FITBUTTONALLMINUS360': self->Fitbuttonhandler,Event
    'FITBUTTONALLPLUS360':  self->Fitbuttonhandler,Event
    'FITBUTTONALLQ':        self->Fitbuttonhandler,Event
    'REWBUTTONQ':           self->Cdbuttonhandler,Event
    'REVBUTTONQ':           self->Cdbuttonhandler,Event
    'FWDBUTTONQ':           self->Cdbuttonhandler,Event
    'FFWDBUTTONQ':          self->Cdbuttonhandler,Event
    'REWBUTTONTAU':         self->Cdbuttonhandler,Event
    'REVBUTTONTAU':         self->Cdbuttonhandler,Event
    'FWDBUTTONTAU':         self->Cdbuttonhandler,Event
    'FFWDBUTTONTAU':        self->Cdbuttonhandler,Event
    'MASKBUTTON':           self->Maskbuttonhandler,Event
    'MASKBUTTONAPPLY':      self->Maskbuttonhandler,Event
    'MASKBUTTONPIXELAPPLY':      self->Maskbuttonhandler,Event
    'MASKBUTTONSUBSEQUENTAPPLY':      self->Maskbuttonhandler,Event
    'MASKBUTTONSUBSEQUENTPIXELAPPLY':      self->Maskbuttonhandler,Event
    'PHASEIMPORTBUTTON':    self->Importexportbuttonhandler,Event
    'FITPARMRESTOREBUTTON': self->Importexportbuttonhandler,Event
    'PLOTMASKZOOMBUTTON': self->Plotmaskzoombuttonhandler,Event
    'PLOTUNZOOMBUTTON': self->Plotunzoombuttonhandler,Event ;120105
    else: begin
      Widget_control,self.tw1,$
        set_value='UNKNOWN BUTTON: '+obj.id+':'+Tag_names(event)
    end
  endcase

end;buttonEvents
pro Oodisplayecho::PLOTUNZOOMBUTTONHandler,Event
  ;120105
  ;print,'ooDisplayEcho::plotunzoombuttonhandler'
  self.plotzoomswitch = 0
  self->Draw
end;PLOTMASKZOOMBUTTONHandler


pro Oodisplayecho::PLOTMASKZOOMBUTTONHandler,Event

  Widget_control,Event.id,get_uvalue=obj
  ;print,obj.options
  Widget_control,Event.id,get_value=val
  wh = Where(val eq obj.options)

  if wh[0] eq 1 then self.plotmaskzoomflag = 0 else self.plotmaskzoomflag = 1
  Widget_control,Event.id,set_value=obj.options[self.plotmaskzoomflag]

end;PLOTMASKZOOMBUTTONHandler

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::CDButtonHandler,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::CDButtonHandler
  ;
  ;PURPOSE:
  ;           Handle button events from "cd" widgets, which consist of
  ;           foward/backward buttons and a droplist widget.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

  ;HANDLE EVENTS FOR THE BUTTONS ASSOCIATED WITH SELECTING
  ;PARTICULAR Q's, Tau's, Images, etc.


  Widget_control,Event.id,get_uvalue=obj

  case obj.id of
    $;Q SELECTIONS ---- NEED TO UPDATE THE CURRENT DATA OBJECT HERE
      $;                  WHEN THE Q-VALUE IS CHANGED -- USE
      $;                  USE self->reDefineWidgets AND self->setDataParameters,$
      $;                                                  self.dataSet,n=thisIndex
      $;
      $;
      $;NOW NEED TO KEEP TRACK OF PREVIOUS DATA OBJECT SO THAT
      $;IT CAN BE SAVED IN POSITION OF PREVIOUS OBJECT IN THE
      $;dataContainer --- THE IMPORTANT THING HERE IS TO SAVE
      $;ALL OF THE WORK THAT HAS ALREADY BEEN DONE ON EACH OF THE
      $;DATA OBJECTS.
      'REWBUTTONQ': begin
      oldQIndex = self.qchoiceindex
      Widget_control,self.adwq,get_value=tempQ
      self.qchoiceindex = 0
      Widget_control,self.adwq,$
        set_droplist_select = self.qchoiceindex
      self->Swapdataobject,oldQIndex,self.qchoiceindex
      ;                            self->setDataParameters,$
      ;                                self.ech,$;self.dataContainer->get(position = self.QChoiceIndex),$
      ;                                n=self.QChoiceIndex
      self->Setdataparameters,$
        (self.datacontainer->Get(position=self.qchoiceindex)),$
        n=self.qchoiceindex
      ;self->reDefineWidgets,self.QChoiceIndex
    end
    'REVBUTTONQ': begin
      oldQIndex = self.qchoiceindex
      self.qchoiceindex = self.qchoiceindex - 1
      Widget_control,self.adwq,get_value=tempQ
      if self.qchoiceindex le 0 then $
        self.qchoiceindex = 0
      Widget_control,self.adwq,$
        set_droplist_select = self.qchoiceindex
      self->Swapdataobject,oldQIndex,self.qchoiceindex
      ;                            self->setDataParameters,$
      ;                                self.ech,$;self.dataContainer->get(position = self.QChoiceIndex),$
      ;                                n=self.QChoiceIndex
      self->Setdataparameters,$
        (self.datacontainer->Get(position=self.qchoiceindex)),$
        n=self.qchoiceindex
      ;self->reDefineWidgets,self.QChoiceIndex
    end
    'FWDBUTTONQ': begin
      oldQIndex = self.qchoiceindex
      self.qchoiceindex = self.qchoiceindex + 1
      Widget_control,self.adwq,get_value=tempQ
      if self.qchoiceindex ge N_elements(tempQ) then $
        self.qchoiceindex = N_elements(tempQ) -1
      Widget_control,self.adwq,$
        set_droplist_select = self.qchoiceindex
      self->Swapdataobject,oldQIndex,self.qchoiceindex
      ;                            self->setDataParameters,$
      ;                                self.ech,$;self.dataContainer->get(position = self.QChoiceIndex),$
      ;                                n=self.QChoiceIndex
      self->Setdataparameters,$
        (self.datacontainer->Get(position=self.qchoiceindex)),$
        n=self.qchoiceindex
      ;self->reDefineWidgets,self.QChoiceIndex
    end
    'FFWDBUTTONQ': begin
      oldQIndex = self.qchoiceindex
      Widget_control,self.adwq,get_value=tempQ
      self.qchoiceindex = N_elements(tempQ) -1
      Widget_control,self.adwq,$
        set_droplist_select = self.qchoiceindex
      self->Swapdataobject,oldQIndex,self.qchoiceindex
      ;                            self->setDataParameters,$
      ;                                self.ech,$;self.dataContainer->get(position = self.QChoiceIndex),$
      ;                                n=self.QChoiceIndex
      self->Setdataparameters,$
        (self.datacontainer->Get(position=self.qchoiceindex)),$
        n=self.qchoiceindex

      ;self->reDefineWidgets,self.QChoiceIndex
    end
    $;TAU SELECTIONS
      'REWBUTTONTAU': begin
      Widget_control,self.adwtau,get_value=tempTau
      self->Setpixelindices
      self.ftchoiceindex = 0
      Widget_control,self.adwtau,$
        set_droplist_select = self.ftchoiceindex
    end
    'REVBUTTONTAU': begin
      self.ftchoiceindex = self.ftchoiceindex - 1
      Widget_control,self.adwtau,get_value=tempTau
      self->Setpixelindices
      if self.ftchoiceindex le 0 then $
        self.ftchoiceindex = 0
      Widget_control,self.adwtau,$
        set_droplist_select = self.ftchoiceindex
    end
    'FWDBUTTONTAU': begin
      self.ftchoiceindex = self.ftchoiceindex + 1
      Widget_control,self.adwtau,get_value=tempTau
      self->Setpixelindices
      if self.ftchoiceindex ge N_elements(tempTau) then $
        self.ftchoiceindex = N_elements(tempTau) -1
      Widget_control,self.adwtau,$
        set_droplist_select = self.ftchoiceindex
    end
    'FFWDBUTTONTAU': begin
      Widget_control,self.adwtau,get_value=tempTau
      self->Setpixelindices
      self.ftchoiceindex = N_elements(tempTau) -1
      Widget_control,self.adwtau,$
        set_droplist_select = self.ftchoiceindex
    end
    else: begin
      Widget_control,self.tw1,$
        set_value='UNKNOWN BUTTON: '+obj.id+':'+Tag_names(event)
    end
  endcase

  ;UPDATE THE MASKMAKER WINDOW AS APPROPRIATE
  ;self->updateMaskMaker

  ;UPDATE THE DISPLAY
  ;self->draw

  self->Mousehead,Event

  ;print,'CDButton'+'Event'+string([13B,10B])+obj.id


end;CDButtonHandler
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
pro Oodisplayecho::sliderEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::sliderEvents
  ;
  ;PURPOSE:
  ;           Handle events for the click-refit slider.
  ;PARAMETERS:
  ;           event   the event structure to handle.
  ;KEYWORDS:
  ;           none


  ;print,'ooDisplayEcho::sliderEvents'
  ;print,tag_names(event)
  ;print,event

  Widget_control,self.clickrefitslider,get_value=val
  self.clickrefitvalue = val
  Widget_control,self.clickrefitperiodslider,get_value=pval
  self.clickrefitperiodvalue = pval


end;sliderEvents
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::drawEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::drawEvents
  ;
  ;PURPOSE:
  ;           Handle events from the draw widgets.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

  ;HANDLES MOUSE BUTTON EVENTS ON THE DRAW WINDOWS.

  Widget_control,Event.id,get_uvalue=obj

  ;print,'ooDisplayEcho::drawEvents ',tag_names(event,/structure_name)
  etype = Strlowcase(Tag_names(event,/structure_name))

  case etype of
    'widget_draw':begin
      ;print,'event.press=',event.press
      if self.plotmousepressed eq 0 then begin
        if Event.press eq 1 then begin

          if (obj.id eq "DW1") then begin
            switch Event.type of
              0:
              1:
              2:begin
                self->Mouseevents,Event
                break
              end;0,1,2
              5:
              6:begin
                self->Keyboardevents,Event
                break
              end;5,6
              else:begin
                self->Do_nothing
              end;
            endswitch

          endif;obj.id
          if (obj.id eq "DW2") then begin; and event.type eq 0) then begin


            ;print,'self.plotmaskzoomflag=',self.plotmaskzoomflag
            ;print,'DW2 EVENT'
            ;print,tag_names(event)
            ;print,event

            case self.plotmaskzoomflag of
              0:begin
                switch Event.type of
                  0:
                  1:
                  2:begin
                    ;120105
                    ;UPDATING PLOT MASKING TO RESPOND TO DOUBLE-CLICK
                    if Event.press eq 1 and Event.clicks eq 2 then begin
                      self->Proximityevents,Event,self.xindex,self.yindex
                    endif
                    ;121604
                    ;                    print,tag_names(event)
                    ;                    print,event
                    ;                    print,'ooDisplayEcho::drawEvents self->proximityEvents,event'
                    break
                  end;0,1,2
                  5:
                  6:begin
                    ;print,'testbutton'
                    self->Keyboardevents,Event
                    break
                  end;5,6
                  else:begin
                    self->Do_nothing
                  end;
                endswitch


              end;plotmaskzoomflag of 0
              1:begin

                ;120105
                ;COMMENTED OUT
                ;                        coords = convert_coord(event.x,event.y,/device,/to_data)
                ;                        self.plotpressx = coords[0]
                ;                        self.plotpressy = coords[1]
                ;                        self.plotreleasex = coords[0]
                ;                        self.plotreleasey = coords[1]
                ;                        ;print,coords
                ;                        self.plotmousepressed = 1
                ;                        self.plotzoombox = 1
              end;plotmaskzoomflag of 1
              else:
            endcase
            ;    print,'ooDisplayEcho::drawEvents  test'
            ;    print,'event.clicks=',event.clicks

            ;120105
            ;NOW THAT MASKING IS HANDLED BY A DOUBLE CLICK,
            ;ALLOW ZOOM WITH ANY MOUSE DRAG, REGARDLESS OF MASK/ZOOM BUTTON STATE.

            ;011006
            ;FOR SOME REASON I HAVE TO PUT THIS wset COMMAND HERE IN
            ;CASE THE AUXILIARY WINDOW IS OPEN.
            ;CONVERT_COORDS SEEMS TO GET CONFUSED IF I DON'T.
            ;DUE TO SOME SORT OF log/lin PROBLEM.
            Wset,self.dw2pix
            !x = *self.w2xptr
            !y = *self.w2yptr
            coords = Convert_coord(Event.x,Event.y,/device,/to_data)
            self.plotpressx = coords[0]
            self.plotpressy = coords[1]
            self.plotreleasex = coords[0]
            self.plotreleasey = coords[1]

            ;                print,!x.type
            ;                print,self.plotpressx
            ;                print,self.plotpressy

            case self.plotindex of
              1:begin
              end;1
              6:begin
              end;6
              else:
            endcase



            ;print,coords
            self.plotmousepressed = 1
            self.plotzoombox = 1

          endif;obj.id


        endif;event.press eq 1
      endif;self.plotmousepressed eq 0


      if self.plotmousepressed eq 1 then begin
        ;110105
        ;HOPEFULLY I ONLY GET HERE IF THERE IS A DRAG EVENT

        if Event.clicks ne 2 then begin

          ;011006
          ;FOR SOME REASON I HAVE TO PUT THIS wset COMMAND HERE IN
          ;CASE THE AUXILIARY WINDOW IS OPEN.
          Wset,self.dw2pix
          !x = *self.w2xptr
          !y = *self.w2yptr
          coords = Convert_coord(Event.x,Event.y,/device,/to_data)
          self.plotreleasex = coords[0]
          self.plotreleasey = coords[1]




          if Event.release ne 0 then begin
            ;120105
            ;PLACE THESE OUTSIDE OF NEXT CONDITIONAL SO THEY WILL CATCH
            ;TWO CLICKS MAKING UP DOUBLE-CLICKS.
            self.plotmousepressed = 0
            self.plotzoombox = 0
            if self.plotpressx ne self.plotreleasex and self.plotpressy ne self.plotreleasey then begin
              self.plotxmin = Min([self.plotpressx,self.plotreleasex])
              self.plotxmax = Max([self.plotpressx,self.plotreleasex])
              self.plotymin = Min([self.plotpressy,self.plotreleasey])
              self.plotymax = Max([self.plotpressy,self.plotreleasey])

              ;                        print,'ooDisplayEcho::drawEvents  test event.clicks=',event.clicks
              ;                        print,'ooDisplayEcho::drawEvents  test event.press=',event.press
              ;                        print,'ooDisplayEcho::drawEvents  test event.release=',event.release
              ;                ;CHANGE PLOT MASKING BUTTON INTO UNZOOM
              ;                print,self.plotxmin
              ;                print,self.plotxmax
              ;                print,self.plotymin
              ;                print,self.plotymax

              self.plotzoomswitch = 1
            endif;self.plotpressx ne self.plotreleasex and self.plotpressy ne self.plotreleasey
            ;110905
            ;SET A FLAG TO TELL THE PLOTTING ROUTINE TO USE THE ZOOMED RANGE
          endif;event.release ne 0
          self->Draw;,/plotzoombox
        endif;event.clicks eq 2
      endif


      ;120105
      ;CHANGE TO DOUBLE-CLICK REFIT FROM RIGHT CLICK REFIT ON PHASE IMAGE.
      ;NEED TO CHANGE THE NEXT SECTION TO BE AVAILABLE FOR A LEFT DOUBLE CLICK AND NOT A RIGHT CLICK
      if Event.press eq 1 and Event.clicks eq 2 then begin
        ;            print,'test,doubleclick'
        ;print,'obj.id=',obj.id
        ;print,'event.type=',event.type
        ;if (obj.id eq 'DW1') then begin ;and (self.displayindex eq 3) then begin
        case obj.id of
          'DW1':begin
            if self.displayindex eq 3 and $
              Widget_info(self.Clickrefitperiodslider,/valid_id) gt 0 then begin

              ;DOUBLE-CLICK REFIT.

              refitTauInd = self.ftchoiceindex

              self->Setpixelindices


              ;030905 ADDING THE NEXT 3 COMMANDS
              ref = self.datacontainer->Get(position=self.qchoiceindex)
              ref->Storefitparms
              fitVals = $
                (*(ref->Getproperty(tag='fitparms')))[*,$
                self.xindex+self.yindex*self.detxdim,$
                self.ftchoiceindex]



              ;GET CURRENT PARAMETER VALUES FROM WIDGET TEXT FIELDS
              Widget_control,self.atwconst,get_value=sconstStart
              constStart = Double(sconstStart)
              Widget_control,self.atwamp,get_value=sampStart
              ampStart = Double(sampStart)
              ;120105
              ;THE NEXT LINE SEEMS TO BE THE MAIN DIFFERENCE BETWEEN
              ;THIS CLICK REFIT AND THE FITPHASE v. TAU plot REFIT.
              ;COMMENT IT OUT FOR NOW.
              ;                    if ampStart eq 0.1 then print,ampstart & ampStart = 10.0


              Widget_control,self.atwsigma,get_value=ssigmaStart
              sigmaStart = Double(ssigmaStart)

              ;                    ;NOTE THE OMEGA VS. PERIOD THING.


              DONOTREFIT = 0
              if Widget_info(self.Clickrefitperiodslider,/valid_id) gt 0 then begin
                ;GET NEW STARTING PHASE FROM CLICK ON PHASE v TAU PLOT
                Widget_control,self.clickrefitperiodslider,get_value=speriodstart
                omegaStart = 360.0d/Double(speriodstart)
              endif else begin
                omegaStart = 1.0d;360.0d/double(speriodstart)
                DONOTREFIT = 1
              endelse

              if Widget_info(self.Clickrefitperiodslider,/valid_id) gt 0 then begin
                ;GET NEW STARTING PHASE FROM CLICK ON PHASE v TAU PLOT
                Widget_control,self.clickrefitslider,get_value=sphaseostart
                phaseoStart = Double(sphaseostart)
              endif else begin
                Widget_control,self.atwphaseo,get_value=sphaseoStart
                phaseoStart = Double(sphaseostart)
                DONOTREFIT = 1
              endelse

              Widget_control,self.atwphase,get_value=sphaseStart
              phaseStart = Double(sphaseStart)

              startparms =   [constStart,ampStart,phaseoStart,$
                sigmaStart,omegaStart,phaseStart]


              ;GET FIXED/VARY VALUE
              fixed = self.fixed
              if DONOTREFIT eq 0 then begin

                result = ref->Chirpfit( self.xindex,$
                  self.Yindex,$
                  refitTauInd,$
                  fixed=self.fixed,$
                  startparms=startparms)

              endif;DONOTREFIT EQ 0

              ;THESE SHOULD BE COVERED ABOVE
              switch Event.type of
                0:begin
                  self->Mouseevents,Event
                  break
                end;0,1,2
                else:begin
                  self->Do_nothing
                end;
              endswitch
              ;            print,systime(1,/seconds)-t0

              ;END OF self.displayindex eq 3
            endif else begin
              ;(UN)MASK THIS PIXEL ON DOUBLE CLICK


              ;120705
              ix=self.xindex
              iy=self.yindex
              it=self.ftchoiceindex

              ref = self.datacontainer->Get(position=self.qchoiceindex)
              mcurr = (*(ref->Getproperty(tag='mask2d')))[ix+self.detxdim*iy,it]
              if mcurr eq 1 then begin
                mnew = -1;0
              endif else mnew = 1
              (*(ref->Getproperty(tag='mask2d')))[ix+self.detxdim*iy,it] = mnew

              switch Event.type of
                0:begin
                  self->Mouseevents,Event
                  break
                end;0,1,2
                else:begin
                  self->Do_nothing
                end;
              endswitch


            endelse ;ALL OTHER DISPLAY INDICES

            ;endif;OBJ.ID eq 'DW1' AND SELF.DISPLAYINDEX EQ 3
          end;case obj.id of 'DW1'
          'DW2':begin
            ;print,'ooDisplayEcho::drawEvents 4381 test,doubleclick DW2?'
          end;case 'obj.id' of 'DW2'
          else:
        endcase

      endif;LEFT DOUBLE_CLICK EVENT ON PHASE IMAGE

      if Event.press eq 4 then begin  ;right click
        if  (obj.id eq "DW1") then begin;and not (self.displayindex eq 3) then begin

          ;DISPLAY CONTEXT MENU
          maskContextBase = Widget_info(Event.id, FIND_BY_UNAME = 'MASKCONTEXTBASE')

          Widget_displaycontextmenu, Event.id, Event.x, Event.y, maskContextBase

        endif;RIGHT CLICK IN DW1 BUT NOT PHASE IMAGE.


        if  (obj.id eq "DW2") then begin

          ;DISPLAY CONTEXT MENU
          plotContextBase = Widget_info(Event.id, FIND_BY_UNAME = 'PLOTCONTEXTBASE')

          Widget_displaycontextmenu, Event.id, Event.x, Event.y, plotContextBase




        endif;RIGHT CLICK IN DW1 BUT NOT PHASE IMAGE.

        self->Draw
      endif;event.press eq 4
    end;widget_draw
    'widget_tracking':begin
      ;print,'ooDisplayEcho::drawEvents  TRACKING EVENT'
      ;SET THE IMAGE WINDOW AS THE FOCUS OF KEYBOARD EVENTS
      ;WHEN ENTERING EITHER DRAW WINDOW.
      case obj.id of
        'DW1':begin
          if Event.enter eq 1 then begin
            Widget_control,self.dw1,input_focus=1
            Widget_control,self.tw1,set_value='arw keys navigate, "m" masks, pgup/dn changes t, dbl-clk refits for phase image'
          endif else begin
            Widget_control,self.dw1,input_focus=0
          endelse
        end;'DW1'
        'DW2':begin
          if Event.enter eq 1 then begin
            Widget_control,self.dw2,input_focus=1
            Widget_control,self.tw1,set_value='dbl-clk masks, drag-mouse to zoom'
          endif else begin
            Widget_control,self.dw2,input_focus=0
          endelse
        end;'DW2'
        else:
      endcase
    end
    else:begin
    end
  endcase


end;drawEvents
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::proximityEvents,Event,xind,yind
  ;
  ;NAME:
  ;        ooDisplayEcho::proximityEvents
  ;
  ;PURPOSE:
  ;           Determine the position of the closest data point on the plot following a mouse click.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;           xind    The indices of the currently selected pixel.
  ;           yind
  ;KEYWORDS:
  ;           none

  ;HANDLE MOUSE EVENTS IN THE PLOT WINDOW

  ;
  ;052004
  ;NEED TO ADD CASE OF PROXIMITY GETTING A POINT
  ;IN THE Iup,Idown POINTS.
  ;
  ;NEED TO APPLY MASKING TO THESE AS WELL.
  ;PROBABLY NEED A SECOND MASK --- OR MAYBE
  ;JUST USE A FULL PHASE RANGE MASK.
  ;
  ;

  ;GET RANGES OF THE AXES ON THE CURRENT PLOT AND IGNORE
  ;MOUSE EVENTS OUTSIDE OF THE PLOT.
  Wset,self.dw2id
  ;x AXIS MAY HAVE A LOG SCALE SO IT MUST BE CONVERTED
  ;SOMETIMES FOR THE PURPOSES OF THIS METHOD


  ;011006
  ;SET WINDOW DATA AXIS POINTERS
  !x = *self.w2xptr
  !y = *self.w2yptr


  if self.plotindex eq 1 or self.plotindex eq 6 then begin
    xrange = 10.0^!x.crange
    yrange = !y.crange
  endif else begin
    xrange = !x.crange
    yrange = !y.crange
  endelse

  r = self->Getpositiononplot(event)
  ;print,'121604'
  ;print,'ooDisplayEcho::proximityEvents r=',r
  ;print,'ooDisplayEcho::proximityEvents xrange=',xrange
  ;print,'ooDisplayEcho::proximityEvents yrange=',yrange

  if  r[0] ge xrange[0] and $
    r[0] le xrange[1] and $
    r[1] ge yrange[0] and $
    r[1] le yrange[1] then begin

    switch self.plotindex of

      ;IN CASES WHERE THE FLIPPER ON/OFF POINTS ARE
      ;SHOWN, ALLOW FOR 1D MASKING OF THEM.

      ;NEED TO USE ooEcho::proximity1DAll FOR CASES
      ;WHERE FLIPPER ON/OFF POINTS ARE DISPLAYED

      ;NOTE:  ISN'T THERE JUST A TOGGLED VALUE THAT
      ;       DETERMINES WHETHER ALL THE POINTS ARE
      ;       PLOTTED.


      0:
      2:
      3:
      4:
      5:begin

        ;CHANGE ooEcho::proximity1D TO BE AWARE OF ALL
        ;DATA POINTS BUT RETURN INDEX BASED ON AN INPUT
        ;PARAMETER THAT IDENTIFIES WHETHER ALL THE POINTS
        ;OR JUST THE ECHO POINTS SHOULD BE INCLUDED.
        ;
        ;

        if self.plotupdown eq 1 then begin
          ;LOOK AT ALL PHASE VALUES
          phsInd =(self.datacontainer->Get(position=$
            self.qchoiceindex))->Proximity1dall(r[0],r[1],$
            self.Xindex,self.yindex,$
            self.Ftchoiceindex,$
            xrange,yrange)
        endif else begin
          ;LOOK ONLY AT ECHO PHASE VALUES
          phsInd =(self.datacontainer->Get(position=$
            self.qchoiceindex))->Proximity1d(r[0],r[1],$
            self.Xindex,self.yindex,$
            self.Ftchoiceindex,$
            xrange,yrange)
        endelse

        ;110905
        ;print,'ooDisplayEcho::proximityevents phsInd=',phsInd
        (self.datacontainer->Get(position=$
          self.qchoiceindex))->Setmask1d, $
          phsInd, $
          self.Ftchoiceindex


        (self.datacontainer->Get(position=$
          self.qchoiceindex))->Setproperty,'IupdownSwitch',0
        break
      end;5
      1:begin;ADJUSTING PHASE vs. TAU ON MOUSE CLICK
        r = self->Getpositiononplot(event)
        ;                print,'ooDisplayEcho::proximityEvents r=',r

        refitTauInd = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Closesttauindex(r[0]/10.0^9)

        self->Setpixelindices

        ;GET CURRENT PARAMETER VALUES FROM WIDGET TEXT FIELDS
        Widget_control,self.atwconst,get_value=sconstStart
        constStart = Double(sconstStart)
        Widget_control,self.atwamp,get_value=sampStart
        ampStart = Double(sampStart)
        Widget_control,self.atwsigma,get_value=ssigmaStart
        sigmaStart = Double(ssigmaStart)

        ;120904
        ;MAY WANT TO CONSTRAIN PERIOD VALUES FOR FIT HERE IF
        ;IT IS NOT A FIXED PARAMETER.
        Widget_control,self.atwomega,get_value=somegaStart
        ;omegaStart = 360.0d/double(somegaStart)
        ;040205
        ;
        ;UPDATED THE NEXT COMMAND TO EITHER SET omega = 1 OR GET THE PERIOD
        ;STARTING VALUE FROM THE SLIDER AND CALCULATE OMEGA FROM THAT.
        if Widget_info(self.Clickrefitperiodslider,/valid_id) ne 0 then begin
          Widget_control,self.clickrefitperiodslider,get_value=periodstart
          omegaStart = 360.0d/Double(periodstart)
        endif else begin
          omegaStart = 1.0d;0.95d;360.0d
        endelse

        Widget_control,self.atwphase,get_value=sphaseStart
        phaseStart = Double(sphaseStart)


        ;GET NEW STARTING PHASE FROM CLICK ON PHASE v TAU PLOT
        phaseoStart = r[1]

        startparms =   [constStart,ampStart,phaseoStart,$
          sigmaStart,omegaStart,phaseStart]


        ;GET FIXED/VARY VALUE
        fixed = self.fixed
        ;fixed = [0,0,0,1,1,1]

        result = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Chirpfit( self.xindex,$
          self.Yindex,$
          refitTauInd,$
          fixed=self.fixed,$
          startparms=startparms)

        break
      end
      6:  break
    endswitch

    self->Draw
  endif else begin;RANGES
    ;print,r,' IS OUTSIDE THE PLOT RANGE.'
  endelse

end;proximityEvents
pro Oodisplayecho::setPixelIndices
  ;
  ;NAME:
  ;        ooDisplayEcho::setPixelIndices
  ;
  ;PURPOSE:
  ;           Set the current pixel indices based on the current image
  ;           and the last selected pixel.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  ;SET PIXEL INDICES ON BUTTON EVENTS


  ;021706
  ;SHOULD I USE self->updateIndices HERE???

  xindex = self.xindex
  yindex = self.yindex
  if xindex ge self.detxdim then begin
    self.xindex = self.detxdim/2
  endif else begin
    self.xindex = xindex
  endelse
  if yindex ge self.detydim then begin
    self.yindex = self.detydim/2
  endif else begin
    self.yindex = yindex
  endelse


end;setPixelIndices
pro Oodisplayecho::importPhases
  ;
  ;NAME:
  ;        ooDisplayEcho::importPhases
  ;
  ;PURPOSE:
  ;           Call the dialog creation method for the phase import functionality,
  ;           where phases are imported from one ooEcho object to another before
  ;           fitting.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;060304


  ;NEED TO UPDATE THE PHASE IMPORT TO INCORPORATE
  ;THE INTERPOLATION OF THE RESOLUTION OBJECT PHASES
  self->Definephaseimportdialog

end;importPhases
pro Oodisplayecho::importPhases2
  ;
  ;NAME:
  ;        ooDisplayEcho::importPhases2
  ;
  ;PURPOSE:
  ;           Call the dialog creation method for the phase import functionality,
  ;           where phases are imported from one ooEcho object to another before
  ;           fitting.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;060304


  ;NEED TO UPDATE THE PHASE IMPORT TO INCORPORATE
  ;THE INTERPOLATION OF THE RESOLUTION OBJECT PHASES
  self->Definephaseimportdialog2

end;importPhases2
pro Oodisplayecho::importExportButtonHandler,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::importExportButtonHandler
  ;
  ;PURPOSE:
  ;           Handle events from the phase import widget.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none.


  Widget_control,Event.id,get_uvalue=obj
  case obj.id of
    'PHASEIMPORTBUTTON':begin
      ;print,'PHASEIMPORTBUTTON'
      self->Importphases
      self->Draw

    end
    'FITPARMRESTOREBUTTON':begin
      ;RESTORE PARMS FOR CURRENT DATA OBJECT
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      ref->Revertfitparms
      ;self->draw
      self->Redefinetree
      self->Mousehead,Event
    end

    else: begin
      Widget_control,self.tw1,$
        set_value='UNKNOWN BUTTON: '+obj.id+':'+Tag_names(event)
    end
  endcase
end;importExportButtonHandler
pro Oodisplayecho::listEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::listEvents
  ;
  ;PURPOSE:
  ;           Handle various "list" events.  These events may come from
  ;           phase import, IQT, and set selection dialogs.
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;


  ;    print,'ListEvent'

  Widget_control,Event.id,get_uvalue=obj

  case obj.id of
    'OKBUTTON':begin

      ;print,'OKBUTTON????'
      Widget_control,self.phaseimportlist,get_uvalue=pil
      objIndexList = pil.list

      index=Widget_info(self.phaseimportlist,$
        /droplist_select)


      m=self.qchoiceindex
      n=objIndexList[index]

      ;NEED TO DETERMINE HERE IF THE DIMENSIONS
      ;OF THE CARBOPACK AND SAMPLE ARE THE
      ;SAME.  IF SO, IMPORT PHASES DIRECTLY.
      ;IF NOT, INTERPOLATE.
      ;
      ;HOLD ON. . .
      ;WHY NOT JUST ALWAYS INTERPOLATE EXCEPT WHEN
      ;DETECTOR BINNING IS NOT IDENTICAL????
      ;
      objTo = ((self.datacontainer)->Get(position=m))
      objFrom = ((self.datacontainer)->Get(position=n))

      ;060304
      ;SUBSTITUTE THE NEXT LINE WITH THE ONE
      ;BELOW IT.
      ;objTo->grabPhasesFrom,objFrom

      ;THE NEXT LINE SHOULD BE EXECUTED IN THE DATA OBJECT
      ;objTo->getInterpPhasesFrom,objFrom

      ;#####################################################################
      ;
      ;021705
      ;CORRECT THIS NEXT SECTION TO PROPERLY HANDLE THE CHOICE OF PHASE
      ;FIX/VARY.

      ;GET VALUE FROM THE "FIXED" CHECKBOX VIA WIDGET_INFO:





      ;self.fixed = [0,0,1,1,1,1]


      ;SUPPLY CHECKBOX ON THE PHASE IMPORT WIDGET TO DECIDE IF
      ;PHASES WILL BE FIXED.

      ;NEED TO ASSUME PHASES WILL BE FIXED HERE, UNLESS, SEE ABOVE

      ;THIS MUST GET THE CURRENT VALUE OF fixed, WHICH TYPICALLY
      ;HAS THE PHASE VALUE SET TO VARY.
      self.fixed = self->Getfixed()


      savefixed = self.fixed


      ;GET THE FIX/VARY PHASE VALUE FROM THE WIDGET
      fixvaryphasedl = Widget_info(self.phaseimportbase,$
        find_by_uname='PHASEIMPORTFIXVARYPHASE')
      ;070505
      ;NEED THIRD OPTION HERE TO CHOOSE TO FIT THE PHASE OFFSET.
      ;self.fixed[2] = widget_info(fixvaryphasedl,/droplist_select)
      if Widget_info(fixvaryphasedl,/droplist_select) eq 2 then begin
        ;FIT PHASE OFFSET
        self.fixed[2] = 1
        fitphaseoffset = 1
      endif else begin
        self.fixed[2] = Widget_info(fixvaryphasedl,/droplist_select)
        fitphaseoffset = 0
      endelse


      ;GET THE FIX/VARY PERIOD VALUE FROM THE WIDGET
      fixvaryperioddl = Widget_info(self.phaseimportbase,$
        find_by_uname='PHASEIMPORTFIXVARYPERIOD')

      self.fixed[4] = Widget_info(fixvaryperioddl,/droplist_select)

      allownegamp = Widget_info(self.phaseimportbase,$
        find_by_uname='ALLOWNEGATIVEAMPLITUDECHECKBOX')
      Widget_control,allownegamp,get_value=negamp

      forcenegamp = Widget_info(self.phaseimportbase,$
        find_by_uname='FORCENEGATIVEAMPLITUDECHECKBOX')
      Widget_control,forcenegamp,get_value=forcenegamp

      ;print,'NEGAMP=',negamp

      Widget_control,self.phaseimportbase,/destroy

      Widget_control,self.atwphase,get_value=sphaseoffset
      ;print,sphaseoffset
      phaseoffset = Double(sphaseoffset)  ;ALWAYS 0.0 SINCE THIS TEXT BOX IS NOT SHOWN.
      Widget_control,self.atwomega,get_value=somega
      ;print,somega

      ;120904
      ;CONVERT PERIOD TO OMEGA.
      ;print,omega
      omega = 1.0/Double(somega)

      ;print,omega
      ;1) GET fixed VALUES FROM GUI AND PASS TO
      ;   DATA OBJECT HERE.
      ;
      ;2) PASS VALUE IN PHASE OFFSET BOX IF NON-ZERO.

      ;help,m,objfrom,self.fixed,startparms,self,phaseoffset,fitphaseoffset,omega,$
      ;     negamp,forcenegamp

      ;help,currentPosition,objfrom,self.fixed,startparms,self,phaseoffset,fitphaseoffset,omega,$
      ;     results[i].smalloppositeampoption,results[i].forcenegativeamp

      (self.datacontainer->Get(position=$
        m))->Fitallfixedphase,$
        objFrom,$
        fixed=self.fixed,$
        startparms=startparms,$
        obj=self,$
        phaseoffset = phaseoffset,$
        fitphaseoffset=fitphaseoffset,$
        omega=omega,$
        allownegamp=negamp,$
        forcenegamp=forcenegamp

      ;021406
      ;BY POLLING THE DATA OBJECT FOR THE fixed STATE, THERE IS NO NEED TO
      ;DO ANYTHING HERE TO HANDLE THE EXTRA fix/vary OPTIONS.


      ;print,self.fixed
      ;UPDATE ALL DISPLAYS
      self.fixed = savefixed  ;THIS IS IRRELEVANT NOW THAT
      ;"fixed"
      self->Redefinetree
      self->Redefinewidgets,self.qchoiceindex
      self->Draw


    end
    'CANCELBUTTON':begin
      Widget_control,self.phaseimportbase,/destroy
    end
    'PHASEIMPORTLIST':begin
      ;THIS METHOD SHOULD BE UNNECESSARY
      Widget_control,Event.id,get_value=list
    end
    'IQTOKBUTTON':begin

      ;GET OBJECTS FROM WIDGET SELECTIONS AND
      ;CALCULATE I(Q,t)
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      bkgIndexList = iqt.bkglist
      datIndexList = iqt.datlist
      resIndexList = iqt.reslist

      bkgIndex=Widget_info(self.bkgimportlist,$
        /droplist_select)
      datIndex=Widget_info(self.datimportlist,$
        /droplist_select)
      resIndex=Widget_info(self.resimportlist,$
        /droplist_select)




      m=self.qchoiceindex
      nbkg=bkgIndexList[bkgIndex]
      ndat=datIndexList[datIndex]
      nres=resIndexList[resIndex]
      ;print,nbkg, ndat,nres
      objDat = ((self.datacontainer)->Get(position=m))
      ;objDat = ((self.dataContainer)->get(position=ndat))
      if nbkg ne 9999 then begin
        objBkg = ((self.datacontainer)->Get(position=nbkg))
      endif else begin
        ;objBkg = 0L
      endelse
      if nres ne 9999 then begin
        objRes = ((self.datacontainer)->Get(position=nres))
      endif else begin
      endelse
      ;print,'Test1'
      ;print,'Test2'


      Widget_control,self.iqtimportbase,/destroy

      ;                        objDat->CalculateIQT,bkgObj = objBkg,$
      ;                                             resObj = objRes,$
      ;                                             datObj = objDat
      objDat->Calculateiqt2,bkgObj = objBkg,$
        resObj = objRes,$
        datObj = objDat, $
        fitParBuf=fitParBuf
      ;print,'Test3'

      ;
      ;032405
      ;MOVE THIS STATEMENT TO JUST BEFORE THE CALCULATION
      ;                        widget_control,self.IQTImportBase,/destroy

      ;080604
      ;WHY DOES THIS NEED ALL OF THE OBJECTS????
      ;DOES IT PUT THE RESULT INTO ALL OF THE
      ;INVOLVED OBJECTS? --- YES, THAT IS THE REASON.
      objDat->Sumqarcs,bkgObj = objBkg,$
        resObj = objRes,$
        datObj = objDat

      ;NOW SHOULD SIMPLY DISPLAY THE
      ;I(Q,t) CURVE WITH A CALL LIKE
      ;

      ;displayIQT,
      self->Displayiqt,self.qchoiceindex
    end;IQTOKBUTTON
    'IQTCANCELBUTTON':begin
      Widget_control,self.iqtimportbase,/destroy
    end
    'IQTIMPORTLIST':begin
      ;THIS METHOD SHOULD BE UNNECESSARY
      Widget_control,Event.id,get_value=list
    end
    'SETSELECTOKBUTTON':begin
      ;THIS METHOD DOES ALL THE WORK.
      ;                        widget_control,self.setSelectList,get_uvalue=ssl
      ;                        objIndexList = ssl.indexlist

      index=Widget_info(self.setselectlist,$
        /droplist_select)

      if index lt (self.setcontainer)->Count() then begin
        theSetRef = (self.setcontainer)->Get(position=index)
        theObjRef = (self.datacontainer)->Get(position= $
          self.qchoiceindex)

        ;PLACE CLONE INTO dataContainer
        ;help,/heap,/brief
        theClone = theObjRef->Clone()
        ;help,/heap,/brief
        count = (self.datacontainer)->Count()
        ;help,/heap,/brief
        (self.datacontainer)->Add,theClone,$
          position=count
        ;help,/heap,/brief

        ;PLACE ORIGINAL OBJECT INTO SET
        type = theClone->Getproperty(tag='type')
        ind = count
        fn = theClone->Getproperty(tag='filename')
        case type of
          0:begin
            ;print,'SELECTED OBJECT IS UNTYPED.'
          end
          1:begin
            theSetRef->Setproperty,resIndex=ind
            theSetRef->Setproperty,resFilename = fn
          end
          2:begin
            theSetRef->Setproperty,datIndex=ind
            theSetRef->Setproperty,datFilename = fn
          end
          3:begin
            theSetRef->Setproperty,bkgIndex=ind
            theSetRef->Setproperty,bkgFilename = fn
          end
          else:begin
            Print,'OBJECT TYPE IS INVALID.'
          end
        endcase
        ;theSetRef->setProperty,

      endif
      Widget_control,self.setselectbase,/destroy
    end;SETSELECTOKBUTTON
    'SETSELECTCANCELBUTTON':begin
      Widget_control,self.setselectbase,/destroy
    end
    'SETSELECTLIST':begin
      Widget_control,Event.id,get_value=list
    end
    'SETREMOVEOKBUTTON':begin
      index=Widget_info(self.setremovelist,$
        /droplist_select)

      if index lt (self.setcontainer)->Count() then $
        begin
        ref = (self.setcontainer)->Get(position=index)
        Obj_destroy,ref
        (self.setcontainer)->Remove,position=index

        Widget_control,self.removesetbase,/destroy
      endif

    end
    'SETREMOVECANCELBUTTON':begin
      Widget_control,self.removesetbase,/destroy
    end
    'SETREMOVELIST':begin
      Widget_control,Event.id,get_value=list
    end
    else:begin
    end
  endcase


end;listEvents
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::displayIQTEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::displayIQTEvents
  ;
  ;PURPOSE:
  ;           Handle events generated by the I(Q,t) display object compound widget.
  ;PARAMETERS:
  ;           event   The CWO_DISPLAYIQT_EVENT structure to handle.
  ;KEYWORDS:
  ;           none

  ;HANDLE EVENTS GENERATED BY IQT DISPLAY AND BY IT'S PARENT BASE.


  ;    print,tag_names(event)
  ;    print,event


  ;print,'ooDisplayEcho::displayIQTEvents'
  ;print,'IQT DISPLAY EVENT HANDLED IN ooDisplayEcho'

  etype = Tag_names(event,/structure_name)


  case etype of
    'CWO_DISPLAYIQT_EVENT':begin



      ref=(self.datacontainer->Get(position=$
        self.qchoiceindex))



      ;091504
      if Event.writeiqt eq 1 then begin
        ref->Writeiqtascii,self.data_dir;self.work_dir
        ;print,'ooDisplayEcho::displayIQTEvents WRITE IQT AT THIS POINT.'
      endif

      if Event.write3col eq 1 then begin
        ref->Writeiqt3colascii,self.data_dir;self.work_dir
        ;print,'ooDisplayEcho::displayIQTEvents WRITE IQT AT THIS POINT.'
      endif

      if Event.writedave eq 1 then begin
        work_dir = self.data_dir
        dumval = ref->Writedave(work_dir = work_dir);self.work_dir)
        self.data_dir = work_dir
      endif

      if Event.writeigor eq 1 then begin
        work_dir = self.data_dir
        dumval = ref->Writeiqtigor(work_dir = work_dir);self.work_dir)
        self.data_dir = work_dir
      endif

      if Event.closeiqt eq 1 then begin
        Widget_control,self.iqtdisplaybase,/destroy
        Obj_destroy,self.iqtdisplayobj
      endif;closeIQT

    end;'CWO_DISPLAYIQT_EVENT'
    'WIDGET_BASE':begin
      self.iqtdisplayobj->Resize,Event,xsize=Event.x,ysize=Event.y

    end
    'WIDGET_TRACKING':begin
    end
    else:begin
      Print,'ooDisplayEcho::displayIQTEvents'
      Print,'IQT DISPLAY EVENT HANDLED IN ooDisplayEcho'
      Print,etype
      Print,Tag_names(event)
      Print,Event
    end
  endcase


end;displayIQTEvents
pro Displayiqtbasecleanup,id
  ;
  ;NAME:
  ;        displayIQTBaseCleanup
  ;
  ;PURPOSE:
  ;           Destroy the IQTDisplayObj when the close or x button
  ;           is pressed on that cwo.
  ;PARAMETERS:
  ;           id  The tlb of the IQTDisplayObj widget.
  ;KEYWORDS:
  ;           none


  Widget_control,id,get_uvalue=uval
  self = uval.object
  Obj_destroy,self.iqtdisplayobj

end;displayIQTBaseCleanup

pro Oodisplayecho::displayIQT_NEW,n,_Extra=extra
  ;
  ;NAME:
  ;        ooDisplayEcho::displayIQT_NEW
  ;
  ;PURPOSE:
  ;               Pass the current data object to the I(Q,T) display object widget
  ;               and create the widget if it does not currently exist.
  ;PARAMETERS:
  ;               n   The position of the current object in the data container.
  ;KEYWORDS:
  ;               none.

  ;help,/traceback


  ;PLAN:
  ;
  ;   1) PUSH NEW OBJECT INTO cwo_displayiqt_improved OBJECT,
  ;      LET THE cwo_displayiqt_improved CLASS DO CHECKING AND PUSHING.

  datRef = (self.datacontainer->Get(position=n))

  self.iqtdisplaybase = Cwo_displayiqt_improved(parent,obj=obj,group_leader=self.atlb,$
    dataobject=datref,$
    workdir=self.work_dir,$
    datadir=self.data_dir,$
    DAVETool=Self.DAVETool, $
    _Extra=extra)
  self.iqtdisplayobj = obj

end;displayIQT_NEW




pro Oodisplayecho::displayIQT,n
  ;
  ;NAME:
  ;        ooDisplayEcho::displayIQT
  ;
  ;PURPOSE:
  ;               Pass the current data object to the I(Q,T) display object widget
  ;               and create the widget if it does not currently exist.
  ;PARAMETERS:
  ;               n   The position of the current object in the data container.
  ;KEYWORDS:
  ;               none.

  ;help,/traceback

  ;PLAN:
  ;
  ;   1) SEARCH FOR AN EXISTING --- OR JUST LET THE cwo_displayiqt_improved CLASS DO CHECKING AND PUSHING.
  ;
  ;   2) PUSH NEW OBJECT INTO cwo_displayiqt_improved OBJECT.
  ;
  ;   3)

  datRef = (self.datacontainer->Get(position=n))

  if !version.os ne 'Win32' then begin
    resizing = 1
  endif else begin
    resizing = 1
  endelse


  Device,get_screen_size=sz
  if Widget_info(self.Iqtdisplaybase,/valid_id) eq 0 then begin
    self.iqtdisplaybase = Widget_base(group_leader = self.atlb,/row,$
      floating=1,$
      xoffset = 50, yoffset=50,$
      tlb_size_events=resizing,$
      $;xsize=sz[0]/2,ysize=sz[1]/2,$
      title=datRef->Getproperty(tag='filename'),$
      uvalue={object:self,$
      method:'displayIQTEvents',$
      id:'IQTDISPLAYBASE'})

    ;CHECK WITH RICHARD THAT THIS IS AVAILABLE IN DAVE
    ;centertlb,self.IQTdisplaybase
  endif


  ;print,'ooDisplayEcho::displayIQT'
  ;help,datRef
  c=Cwo_displayiqt(self.iqtdisplaybase,datRef,obj_ref=cwoRef,$
    uvalue = {object:self,$
    method:'displayIQTEvents',$
    id:'DISPLAYIQT'},$
    cleanup='DisplayIQTBaseCleanup')



  ;;THIS IS WHERE THE DATA ARE INITIALLY PASSED INTO cwo_displayIQT_Improved
  ;    c=cwo_displayIQT_Improved(self.IQTDisplayBase,datRef,obj_ref=cwoRef,$
  ;                        uvalue = {object:self,$
  ;                                  method:'displayIQTEvents',$
  ;                                  id:'DISPLAYIQT'},$
  ;                                  cleanup='DisplayIQTBaseCleanup')
  ;help,/traceback


  if Widget_info(c,/valid_id) gt 0 then begin
    ;NEED TO PREVENT MULTIPLE INSTANCES OF THIS.
    ;SIMPLY SEND CURRENT DATA OBJ REF TO THE cwo
    ;AND CALL ITS draw METHOD IF THE cwo ALREADY EXISTS.
    ;
    ;OR, I CAN MAKE THE cwo A SINGLETON AND
    ;UPDATE THE DATA OBJECT EACH TIME IT IS CHANGED
    ;
    ;AND/OR I CAN HAVE A CONTAINER FOR MULTIPLE DATA OBJECTS.
    ;

    self.iqtdisplayobj = cwoRef

    Widget_control,self.iqtdisplaybase,/realize

    cwoRef->Draw;,datRef
    Xmanager,"ooDisplayEcho",self.iqtdisplaybase,/no_block;,$
    ;cleanup='DisplayIQTBaseCleanup'
  endif else begin
    ;print,'AN IQT Display OBJECT ALREADY EXISTS.'

    ;
    ;PROBLEM TO SOLVE:  THE NUMBER OF FOURIER TIMES AND Q VALUES ARE LIKELY
    ;TO BE DIFFERENT FOR EACH OF THE DATA OBJECTS.
    ;
    ;THIS IS A PROBLEM FOR THE cwo_displayiqt CLASS.


    ;FOR A SINGLETON, THE OBJECT SHOULD TAKE CARE OF ITSELF HERE.
    ;        self.IQTDisplayObj->addData,datRef


  endelse



end;displayIQT
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::setBeamCenter,ifrom,ito
  ;
  ;NAME:
  ;        ooDisplayEcho::setBeamCenter
  ;
  ;PURPOSE:
  ;           Set the 'ito' beam center to be the same as the 'ifrom' beam center.
  ;PARAMETERS:
  ;           ifrom   The datacontainer position of the object with the beam center value.
  ;           ito     The datacontainer position of the object to set the beam center value.
  ;KEYWORDS:
  ;           none

  ;SET ALL BEAM CENTERS TO SAME VALUE ASSUMING THAT
  ;ALL OF THE DATA WILL HAVE THE SAME BEAM POSITION

  ;050704
  ;
  ;DURING DEMO THEY SAID TO USE SAME BEAM CENTER
  ;FOR A GIVEN WAVELENGTH.  SET ALL BEAM CENTERS
  ;TO SAME VALUE FOR A GIVEN WAVELENGTH.
  ;DO THIS FOR ATWBCX AND ATWBCY.
  ;
  ;NEED TO CLARIFY WHICH VALUE OF THE BEAM CENTER
  ;WILL BE USED (32x32 or 16x16, etc.)  FOR NOW
  ;ASSUME THAT THE CENTERS WILL BE SPECIFIED IN
  ;PIXELS AT CURRENT BINNING.
  ;
  ;ALSO NEED TO DO THIS ON READING A NEW FILE!!!
  ;
  lambdao = (self.datacontainer->Get(position=$
    ifrom))->Getproperty(tag='lambda')
  lambdaTol = 0.03*lambdao  ; set tol to 3% of lambdao


  lambda = $
    (self.datacontainer->Get(position=$
    ito))->Getproperty(tag='lambda')
  ;print,lambda

  if (Abs(lambda-lambdao) le lambdaTol) then begin
    ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
    ;
    ;ASSUMES X,Y BINNINGS EQUAL.
    x_dim_orig = $
      (self.datacontainer->Get(position=$
      ito))->Getproperty(tag='x_dim_orig')
    x_dim = $
      (self.datacontainer->Get(position=$
      ito))->Getproperty(tag='x_dim')


    ;SET THE ORIGINAL BEAM CENTER (NO BINNING)
    (self.datacontainer->Get(position=$
      ito))->Setproperty,'x_cen_orig',$
      (self.datacontainer->Get(position=$
      ifrom))->Getproperty(tag='x_cen_orig')
    (self.datacontainer->Get(position=$
      ito))->Setproperty,'y_cen_orig',$
      (self.datacontainer->Get(position=$
      ifrom))->Getproperty(tag='y_cen_orig')
    ;SET THE BEAM CENTER FOR THE CURRENT BINNING
    (self.datacontainer->Get(position=$
      ito))->Setproperty,'x_cen',$
      (self.datacontainer->Get(position=$
      ifrom))->Getproperty(tag='x_cen_orig')*$
      (Double(x_dim)/Double(x_dim_orig))
    (self.datacontainer->Get(position=$
      ito))->Setproperty,'y_cen',$
      (self.datacontainer->Get(position=$
      ifrom))->Getproperty(tag='y_cen_orig')*$
      (Double(x_dim)/Double(x_dim_orig))
  endif;lambda eq lambdao

end;setBeamCenter
;function ooDisplayEcho::restoreSession
;MOVED TO SEPARATE FILE
;end;restoreSession
;function ooDisplayEcho::saveSession,xml=xml,sav=sav
;MOVED TO SEPARATE FILE
;end;saveSession

pro Oodisplayecho::fileOpen,filename=filename
  ;
  ;NAME:
  ;        ooDisplayEcho::fileOpen
  ;
  ;PURPOSE:
  ;           Do the work for fileOpen
  ;PARAMETERS:
  ;           event   The button event structure to handle.
  ;KEYWORDS:
  ;           filename    Name of files to open



  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::fileOpen!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    Catch, /cancel
    Return
  endif


  if N_elements(filename) ne 0 then begin
    tempFilename = filename
  endif else begin
    tempFilename = Dialog_pickfile(/read,$
      /must_exist,$
      filter=['*.nse','*.echo'],$
      path=self.data_dir,$
      /multiple_files,$
      title='Select echo files:',$
      dialog_parent=self.atlb)
  endelse


  if tempFilename[0] ne '' then begin

    ;PROGRESS BAR
    ;          readerBase = widget_base(xoffset=300,$
    ;                                   yoffset=300,/floating,group_leader=self.atlb)
    ;
    ;
    ;;          prog = cw_progress(readerBase,$
    ;;                                value=[n_elements(tempFilename)],$
    ;;                                title='File# ')
    ;          prog = nse_progress(readerBase,$
    ;                                value=[n_elements(tempFilename)],$
    ;                                title='File# ',dialog_parent=self.atlb)
    ;
    ;          widget_control,readerBase,/realize
    ;
    ;
    Widget_control,self.facilitybgroup,get_value=facilityIndex
    ;ELIMINATE THE 'try file' OPTION.  NOW FACLILITY INDEX IS
    ;0 or 1.  ADD 1 to the index to make it consistent throughtout.
    facilityIndex = facilityIndex+1

    prog = Nse_cwo_progress(labels=['File Number:'],$
      startvalues=[0L],$
      endvalues=[Long(N_elements(tempFilename))],$
      values=[0L],$
      steps=[1L],$
      obj=progobj,$
      title='Reading Echo Files:   ',$
      dialog_parent=self.atlb)


    for n=0,N_elements(tempFilename)-1 do begin
      self.data_dir = File_dirname(tempFilename[n]);,$
      ;/mark_directory)
      ;ADD NEW DATA OBJECT TO dataContainer
      ;
      ;WHAT HAPPENS IF FILE DOES NOT EXIST?????
      count = self.datacontainer->Count()

      Widget_control,self.atwnarcs,get_value = narcs

      temp = Obj_new('ooEchoMagnetic',filename = tempFilename[n],$
        narcs = Fix(narcs),magnetic=0,facility=facilityIndex)



      Help,temp,output = tout

      if not Stregex(tout,'NULL',/fold_case,/boolean) then begin

        ;NOW THAT A VALID DATA OBJECT HAS BEEN CREATED, SET THE time average
        ;state to 0 (i.e. NOT TIME AVERAGED.)
        Widget_control,self.timeaverageupdowncheckbox,set_value= 0


        temp->Bin,factor=2


        ;092404
        ;UPDATE THE GAUSSIAN WIDTH WITH THE CURRENT
        ;VALUE FOR EACH NEW FILE READ IN.
        Widget_control,self.atwwidth,get_value=swidth
        temp->Setwidth,Double(swidth)
        temp->Setproperty,'workdir',self.work_dir
        temp->Setproperty,'datadir',self.data_dir

        self.gaussianwidth = Double(swidth)


        ;121905
        ;REMOVING t=0.0 BEFORE ADDING TO DISPLAY.
        thetimes = *(temp->Getproperty(tag='fouriertime'))
        if (Where(thetimes eq 0.0))[0] ne -1 then begin
          newtemp = temp->Removet(0.0,/firstread)
          self.datacontainer->Add,newtemp,position = count
          Obj_destroy,temp
        endif else begin
          self.datacontainer->Add,temp,position = count
        endelse


        ;SET BEAM CENTER VALUES HERE BASED ON
        ;MATCHING LAMBDA

        lambda = (self.datacontainer->Get(position= $
          count))->Getproperty(tag='lambda')
        lambdaTol = 0.03*lambda   ; 3% of lambda
        for i=0,count-1 do begin
          lambdao = (self.datacontainer->Get(position=$
            i))->Getproperty(tag='lambda')
          if (Abs(lambda-lambdao) le lambdaTol) then begin
            self->Setbeamcenter,i,count
          endif
        endfor;i
      endif else begin;not stregex
        ;dum = dialog_message('INSUFFICIENT DATA IN FILE '+tempfilename[n])
        Print,'INSUFFICIENT DATA IN FILE '+tempfilename[n]
        omsg = ['Incomplete dataset or error reading file','Filename: '+tempfilename[n]]
        void = dialog_message(omsg,dialog_parent=self.atlb)
      endelse
      progobj->Set,0,n
      stopped = progobj->Checkstop()
      if stopped ne 0 then begin
        Print,'File reader stopped by user.'
        Widget_control,prog,/destroy
        break
        ;goto, jump1
        ;return
      endif
      ;widget_control,prog,set_value=[n]
    endfor;n (MULTIPLE FILES)
    if not Stregex(tout,'NULL',/fold_case,/boolean) then begin

      self->Setdataparameters,$
        self.datacontainer->Get(position=count),$
        n = count
    endif;not stregex

    ;jump1:
    the_count = self.datacontainer->Count()
    ;                        print,the_count
    if the_count gt 0 then begin
      ;113005
      ;add the newsize flag
      self->Redefinewidgets,count,/newsize
      self->Redefinetree
      self->Draw
    endif;the_count
    ;widget_control,readerBase,/destroy
    if Widget_info(prog,/valid_id) gt 0 then Widget_control,prog,/destroy
  endif else begin
  endelse


end;ooDisplayEcho::fileOpen


pro Oodisplayecho::menuEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::menuEvents
  ;
  ;PURPOSE:
  ;           Handle events from the file menu.  Several of the context menus also send events here.
  ;PARAMETERS:
  ;           event   The button event structure to handle.
  ;KEYWORDS:
  ;           none
  ;

  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::menuEvents!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    Catch, /cancel
    Return
  endif


  Widget_control,Event.id,get_uvalue=obj

  case (obj.parent) of
    'FILEOPTIONS': begin
      case (obj.id) of
        'FILEOPEN': begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
          self->Fileopen


        end;FILEOPEN
        'FILEOPENMAGNETIC': begin

          ;print,'USING "FILEOPENMAGNETIC" HANDLER FOR THIS BUTTON.'
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)


          ;063004
          ;SET UP TO READ MULTIPLE FILES.

          tempFilename = Dialog_pickfile(/read,$
            /must_exist,$
            filter='*.echo',$
            path=self.data_dir,$
            /multiple_files)

          ;NEED TO USE THE CLONE METHOD HERE.
          ;SIMPLY REASSIGNING THE OBJECT REFERENCES WON'T
          ;WORK HERE.
          ;
          ;ALTERNATIVELY, THIS IS A GOOD TIME TO LEARN
          ;ABOUT o = obj_new('IDL_container')
          ;

          if tempFilename[0] ne '' then begin

            ;PROGRESS BAR
            ;                          readerBase = widget_base(xoffset=300,$
            ;                                                   yoffset=300,/floating,group_leader=self.atlb)
            ;
            ;
            ;;                          prog = cw_progress(readerBase,$
            ;;                                                value=[n_elements(tempFilename)],$
            ;;                                                title='File# ')
            ;                          prog = nse_progress(readerBase,$
            ;                                                value=[n_elements(tempFilename)],$
            ;                                                title='File# ',dialog_parent=self.atlb)
            ;
            ;                          widget_control,readerBase,/realize

            prog = Nse_cwo_progress(labels=['File Number:'],$
              startvalues=[0L],$
              endvalues=[Long(N_elements(tempFilename))],$
              values=[0L],$
              steps=[1L],$
              obj=progobj,$
              title='Reading Echo Files:   ',$
              dialog_parent=self.atlb)


            for n=0,N_elements(tempFilename)-1 do begin
              self.data_dir = File_dirname(tempFilename[n]);,$
              ;/mark_directory)
              ;ADD NEW DATA OBJECT TO dataContainer
              ;
              ;WHAT HAPPENS IF FILE DOES NOT EXIST?????
              count = self.datacontainer->Count()

              Widget_control,self.atwnarcs,get_value = narcs

              temp = Obj_new('ooEchoMagnetic',filename = tempFilename[n],$
                narcs = Fix(narcs),$
                magnetic=1)


              Help,temp,output = tout
              ;print,obj_valid(temp)

              if not Stregex(tout,'NULL',/fold_case,/boolean) then begin
                temp->Bin,factor=2
                ;DO NOT APPLY TIME AVERAGING AT THIS STAGE UNLESS IT IS LATER REQUESTED.

                ;UPDATE THE GAUSSIAN WIDTH WITH THE CURRENT
                ;VALUE FOR EACH NEW FILE READ IN.
                Widget_control,self.atwwidth,get_value=swidth
                temp->Setwidth,Double(swidth)
                temp->Setproperty,'workdir',self.work_dir
                temp->Setproperty,'datadir',self.data_dir


                self.gaussianwidth = Double(swidth)

                ;121905
                ;print,'IN ooDisplayEcho::menuEvents FILEOPENMAGNETIC'
                ;REMOVING t=0.0 BEFORE ADDING TO DISPLAY.
                newtemp = temp->Removet(0.0,/read)
                self.datacontainer->Add,newtemp,position = count
                Obj_destroy,temp
                ;                                self.dataContainer->add,temp,position = count

                ;SET BEAM CENTER VALUES HERE BASED ON
                ;MATCHING LAMBDA
                lambda = (self.datacontainer->Get(position= $
                  count))->Getproperty(tag='lambda')
                lambdaTol = 0.03 * lambda   ; tolerance is 3% of lambda
                for i=0,count-1 do begin
                  lambdao = (self.datacontainer->Get(position=$
                    i))->Getproperty(tag='lambda')
                  if (Abs(lambda-lambdao) le lambdaTol) then begin
                    self->Setbeamcenter,i,count
                  endif
                endfor;i
              endif else begin;not stregex
                ;dum = dialog_message('INSUFFICIENT DATA IN FILE '+tempfilename[n])
                Print,'INSUFFICIENT DATA IN FILE '+tempfilename[n]
              endelse
              obj->Step,0
              stopped = progobj->Checkstop()
              if stopped ne 0 then begin
                Print,'File read stopped by user.'
                Widget_control,prog,/destroy
                Return
              endif
              ;widget_control,prog,set_value=[n]
            endfor;n (MULTIPLE FILES)
            ;                          widget_control,prog,/destroy
            if not Stregex(tout,'NULL',/fold_case,/boolean) then begin

              self->Setdataparameters,$
                self.datacontainer->Get(position=count),$
                n = count
            endif;not stregex

            the_count = self.datacontainer->Count()
            if the_count gt 0 then begin

              ;112805
              ;ADD THE NEXT LINE SO THAT THE MAGNETIC AND OTHER WIDGETS ARE UPDATED
              ;WHEN A SESSION FILE IS READ.
              self->Setdataparameters,ref,n=the_count-1;self.QChoiceIndex
              ;113005
              ;add the newsize flag
              self->Redefinewidgets,count,/newsize
              self->Redefinetree
              self->Draw
            endif;the_count
            Widget_control,prog,/destroy
            ;widget_control,readerBase,/destroy

          endif else begin
          endelse

        end;FILEOPENMAGNETIC
        'FILESAVE': begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
        end;FILESAVE
        'SAVESESSION':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          ;AS OF 072505 ONLY ALLOW .sav FILES FOR SESSION SAVE
          self.state_saved = self->Savesession(/sav)


        end;SAVESESSION
        'RESTORESESSION':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          if self.datacontainer->Count() ne 0 then begin
            rslt1 = self->Savesession(/prerestore)
          endif
          rslt2 = self->Restoresession()

          ;;031805
          ;;NEED TO ADD ERROR CHECKING HERE FOR THE DATA IN THE FILE.
          ;;
          ;;NO TIME TODAY...
          ;
          ;;MAYBE point_lun CAN MAKE THIS BACKWARD COMPATIBLE.
          ;;TO CREATE BACKWARD COMPATIBILITY, ADD FUTURE NEW VALUES
          ;;TO THE END OF THE FILE ON SAVE COMMANDS.
          ;;THEN OLDER VERSIONS OF THE READER WILL NOT SEE THESE.
          ;;ONCE IDL 6.1 IS USED FOR DAVE, THESE VALUES WILL BE
          ;;RETRIEVED USING THE IDLffXMLDOM CLASSES.
          ;
          if rslt2 gt 0 then begin
            ;112805
            ;ADD THE NEXT LINE SO THAT THE MAGNETIC AND OTHER WIDGETS ARE UPDATED
            ;WHEN A SESSION FILE IS READ.
            ref = self.datacontainer->Get(position=0)
            self->Setdataparameters,ref,n=0;self.QChoiceIndex
            self->Redefinewidgets,count,t=0,/newsize
            self->Redefinetree
            self->Draw
          endif



        end;RESTORESESSION
        'LOADTESTDATA':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          if self.datacontainer->Count() ne 0 then begin
            rslt1 = self->Savesession(/prerestore)
          endif
          rslt2 = self->Restoresession(/testdata)

          if rslt2 gt 0 then begin
            ref = self.datacontainer->Get(position=0)
            self->Setdataparameters,ref,n=0;self.QChoiceIndex
            self->Redefinewidgets,count,t=0,/newsize
            self->Redefinetree
            self->Draw
          endif



        end;LOADTESTDATA
        'SAVEOBJECT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          ref=(self.datacontainer->Get(position=$
            self.qchoiceindex))
          if Obj_valid(ref) then begin
            Print,self->Savesession(/sav,index=self.qchoiceindex)
          endif else begin
            void = Dialog_message('ooDisplayEcho::menuevents INVALID DATA OBJECT')
          endelse
        end;SAVEOBJECT
        'RESTOREOBJECT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          ;072505
          ;HERE I NEED TO CHANGE THE RESTORE TO CALL self->restoreSession(/OBJECT)
          ;WHERE THE OBJECT OPTION ELIMINATES THE DESTRUCTION OF THE OBJECTS IN THE
          ;CONTAINER, THE SINGLE OBJECT IS REMOVED FROM THE RESTORED CONTAINER AND PLACED
          ;IN THIS ONE, AND NONE OF THE OTHER VALUES ARE RESTORED INTO THE OBJECT DATA MEMBERS
          result = self->Restoresession(/object)


          if result gt 0 then begin
            self->Redefinewidgets,count,t=0,/newsize
            self->Redefinetree
            self->Draw
          endif else begin
            void = Dialog_message('This is not a valid NSE saved object.')
          endelse

          ;endelse

        end;RESTOREOBJECT


        'FILEPHASEEXPORT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
          tempfn = Dialog_pickfile(/write,$
            title='Phase export file',$
            path=self.work_dir,$
            /overwrite_prompt)

          if tempfn ne '' then begin
            self.work_dir = File_dirname(tempfn,/mark_directory)
            Openw,lun,tempfn,/get_lun

            ref=(self.datacontainer->Get(position=$
              self.qchoiceindex))
            pparms = ref->Getproperty(tag='fitparms')

            Printf,lun,(*pparms)[2,*,*]

            Free_lun,lun,/force
          endif else begin
            void = Dialog_message('No output file selected!')
          endelse
        end;FILEPHASEEXPORT
        'FILEPHASEIMPORT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)

          tempfn = Dialog_pickfile(/read,$
            title='Phase import file:',$
            path=self.work_dir,$
            /must_exist)

          if tempfn ne '' then begin
            self.work_dir = File_dirname(tempfn,/mark_directory)
            Openr,lun,tempfn,/get_lun

            ref=(self.datacontainer->Get(position=$
              self.qchoiceindex))
            pparms = ref->Getproperty(tag='fitparms')

            tmp = (*(ref->Getproperty(tag='fitparms')))[2,*,*]
            Readf,lun,tmp

            ;print,tmp
            (*(ref->Getproperty(tag='fitparms')))[2,*,*] = tmp
            ;print,(*(ref->getProperty(tag='fitparms')))[2,*,*]
            Free_lun,lun,/force
          endif else begin
            void = Dialog_message('No file selected.')
          endelse


        end;FILEPHASEIMPORT
        'FILEFITPARMEXPORT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
          tempfn = Dialog_pickfile(/write,$
            title='Parameter export file:',$
            path=self.work_dir,$
            /overwrite_prompt)

          if tempfn ne '' then begin
            self.work_dir = File_dirname(tempfn,/mark_directory)
            Openw,lun,tempfn,/get_lun

            ref=(self.datacontainer->Get(position=$
              self.qchoiceindex))
            pparms = ref->Getproperty(tag='fitparms')

            Printf,lun,(*pparms)[*,*,*]

            Free_lun,lun,/force
          endif else begin
            void = Dialog_message('No file selected.')
          endelse

        end;FILEFITPARMEXPORT
        'FILEFITPARMIMPORT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
          tempfn = Dialog_pickfile(/read,$
            title='Parameter import file:',$
            path=self.work_dir,$
            /must_exist)
          if tempfn ne '' then begin
            self.work_dir = File_dirname(tempfn,/mark_directory)
            Openr,lun,tempfn,/get_lun

            ref=(self.datacontainer->Get(position=$
              self.qchoiceindex))
            ;                            pparms = ref->getProperty(tag='fitparms')

            tmp = (*(ref->Getproperty(tag='fitparms')))[*,*,*]
            Readf,lun,tmp

            ;print,tmp
            (*(ref->Getproperty(tag='fitparms')))[*,*,*] = tmp
            ;print,(*(ref->getProperty(tag='fitparms')))[*,*,*]
            Free_lun,lun,/force
          endif else begin
            void = Dialog_message('No file selected.')
          endelse
        end;FILEFITPARMEXPORT
        'FILEIQTEXPORT':begin

          ;091504
          ;
          ;UPDATING WRITE ASCII TO INCLUDE MORE
          ;INFORMATION IN THE EXPORTED FILE.

          ref=(self.datacontainer->Get(position=$
            self.qchoiceindex))
          ref->Writeiqtascii,self.work_dir


        end;FILEIQTEXPORT
        'FILEIQTDAVEEXPORT':begin
          Widget_control,self.tw1,$
            set_value=obj.id+':'+Tag_names(event)
          tempfn = Dialog_pickfile(/write,$
            title='I(Q,t) DAVE file:',$
            path=self.work_dir,$
            /overwrite_prompt)
          self.work_dir = File_dirname(tempfn,/mark_directory)
          ref=(self.datacontainer->Get(position=$
            self.qchoiceindex))

          ;120704
          ;HANDLE THE NEXT LINE IN ooEcho::writeDave
          ;                        if tempfn eq '' then begin
          ;                            fn = ref->getProperty(tag='filename')
          ;                            tempfn = fn+'IQT_DAVE_format.dave'
          ;                        endif
          result = ref->Writedave(tempfn)

        end;FILEIQTDAVEEXPORT

        'FILEPARAMETERSIMPORT':begin
          self->Readparametersfile
        end;FILEPARAMETERSIMPORT
        'FILEPARAMETERSEXPORT':begin
          self->Writeparametersfile
        end;FILEPARAMETERSEXPORT
        'FILEQUIT': begin
          Print,obj.id+':',Tag_names(event)
          Print,obj.id+':',Event

          Widget_control,self.atlb,/destroy
          ;ooDisplayEchoCleanup,self.atlb
        end;FILEQUIT
        else:   begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF FILEMENU CHOICE"
        end
      endcase;obj.parent eq 'FILEOPTIONS'
    end;FILEOPTIONS
    'PLOTOPTIONS':begin
      plotzoomswitch = self.plotzoomswitch
      self.plotzoomswitch = 0
      case (obj.id) of
        'IVPHASE':begin
          self.plotindex = 0
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;IVPHASE
        'FITPHASEVTAU':begin
          self.plotindex = 1
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;FITPHASEVTAU
        'BXVPHASE':begin
          self.plotindex = 2
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;BXVPHASE
        'BYVPHASE':begin
          self.plotindex = 3
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;BYVPHASE
        'BZVPHASE':begin
          self.plotindex = 4
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;BZVPHASE
        'ALLVPHASE':begin
          self.plotindex = 5
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;ALLVPHASE
        'FITAMPVTAU':begin
          self.plotindex=6
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;FITAMPVTAU
        'CONTOURECHO':begin
          self.plotindex=7
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;CONTOURECHO
        'SIGNALVTAU':begin
          self.plotindex=8
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;SIGNALVTAU
        'MAGNETICPLOT':begin
          ;112805
          ;MAGNETICPLOT_MENU
          self.plotindex=9
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;MAGNETICPLOT
        'MAGNETICPLOTPIXEL':begin
          ;020606
          ;MAGNETICPLOT_MENU
          self.plotindex=10
          Widget_control,self.tw1,set_value=$
            obj.id+Strtrim(String(self.plotindex),2)
          self->Draw
        end;MAGNETICPLOTPIXEL

        'TOGGLEUPDOWN':begin
          if self.plotupdown eq 1 then begin
            self.plotupdown = 0
          endif else begin
            self.plotupdown = 1
          endelse
          self->Draw
        end;TOGGLEUPDOWN
        'TOGGLEAUXPLOT':begin
          self.plotzoomswitch = plotzoomswitch
          if Widget_info(self.Dw2auxbase,/valid_id) gt 0 then begin
            self->Lowerauxwindow
          endif else begin
            self->Raiseauxwindow
            self->Draw
          endelse

        end;TOGGLEAUXPLOT
        'WRITEPLOTDATA':begin
          fn = Dialog_pickfile(title='Plot data output file:',$
            path = self.work_dir,$
            /overwrite_prompt)
          if fn ne '' then begin
            Print,fn
            self->Draw,/writeplotdataflag,writeplotdatafile=fn
          endif

        end;WRITEPLOTDATA
        'EXPANDPLOTRANGES':begin

          ;print,self.plotxmin,self.plotxmax,self.plotymin,self.plotymax
          if self.plotzoomswitch eq 0 then begin


            !x = *self.w2xptr
            !y = *self.w2yptr

            if !x.type eq 0 then begin
              xrange = !x.crange
            endif else begin
              xrange = (10.0d)^(!x.crange)
            endelse
            if !y.type eq 0 then begin
              yrange = !y.crange
            endif else begin
              yrange = (10.0d)^(!y.crange)
            endelse

            self.plotxmin = xrange[0]
            self.plotxmax = xrange[1]
            self.plotymin = yrange[0]
            self.plotymax = yrange[1]
          endif

          self.plotzoomswitch = 1

          xmin = self.plotxmin;:10000.0,$
          xmax = self.plotxmax;:-10000.0,$     ;SAVE THE PLOT RANGES IN CASE OF ZOOM.
          ymin = self.plotymin;:10000.0,$
          ymax = self.plotymax;:-10000.0,$


          dxrange = xmax - xmin
          dyrange = ymax - ymin


          self.plotxmin = xmin; - 0.1*dxrange
          self.plotxmax = xmax; + 0.1*dxrange
          self.plotymin = ymin - 0.1*dyrange
          self.plotymax = ymax + 0.1*dyrange

          ;print,self.plotxmin,self.plotxmax,self.plotymin,self.plotymax
          self->Draw

        end;EXPANDPLOTRANGES
        'UNZOOMPLOT':begin
          self.plotzoomswitch = 0
          self->Draw
        end;UNZOOMPLOT
        else:   begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF PLOTMENU CHOICE"
        end
      endcase;obj.parent eq 'PLOTOPTIONS'
    end;PLOTOPTIONS
    'IMAGEOPTIONS': begin
      case (obj.id) of
        'SOF0':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 0
          self->Draw
          self->Lowerslider

        end;SOF0
        'SIGNALIMAGE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 8
          self->Draw
          self->Lowerslider
        end;'SIGNALIMAGE'
        'FITCONSTANT':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 1
          self->Draw
          self->Lowerslider
        end;FITCONSTANT
        'FITAMPLITUDE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 2
          self->Draw
          self->Lowerslider
        end;FITAMPLITUDE
        'FITPHASE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          if Widget_info(self.Clickrefitslider,/valid_id) ne 0 then begin
            ;widget_control,self.clickrefitslider,/destroy
          endif else begin
            self->Raiseslider
          endelse


          self.displayindex = 3
          self->Draw
        end;FITPHASE
        'FITWIDTH':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 4
          self->Lowerslider
          self->Draw
        end;FITWIDTH
        'FITOMEGA':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          self.displayindex = 5
          self->Draw
          self->Lowerslider
        end;FITOMEGA
        'FITPHASEOFFSET':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 6
          self->Draw
          self->Lowerslider
        end;FITPHASEOFFSET
        'FITCHISQ':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 7
          self->Draw
          self->Lowerslider
        end
        'MAGNETIC_CASE_0':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 9
          self->Draw
          self->Lowerslider
        end
        'MAGNETIC_CASE_1':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 10
          self->Draw
          self->Lowerslider
        end
        'MAGNETIC_CASE_2':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 11
          self->Draw
          self->Lowerslider
        end
        'MAGNETIC_CASE_3':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
          self.displayindex = 12
          self->Draw
          self->Lowerslider
        end
        'IMAGEERRORBARS':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id

          ;SWITCH IMAGE OPTIONS MENUS
          idmenu = Widget_info(self.atlb,find_by_uname="IMAGEERRORBARSMENU")

          idcontext = Widget_info(self.dw1,find_by_uname="IMAGEERRORBARSCONTEXT")



          ;RESYNC THE STATE OF THE ERROR IMAGE IN CASE IT WAS X'ed OUT.
          if Widget_info(self.Imageerrorbase,/valid_id) eq 0 then begin
            if self.errorimagechoice eq 1 then begin
              self.errorimagechoice = 0
              Widget_control,idmenu,set_value='Display Image Error Bars'
              Widget_control,idcontext,set_value='Display Image Error Bars'
            endif
          endif else begin
            if self.errorimagechoice eq 0 then begin
              self.errorimagechoice = 1
              Widget_control,idmenu,set_value='Turn Off Image Error Display'
              Widget_control,idcontext,set_value='Turn Off Image Error Display'
            endif
          endelse

          if self.errorimagechoice eq 0 then begin
            Widget_control,idmenu,$
              set_value='Turn Off Image Error Display'
            Widget_control,idcontext,$
              set_value='Turn Off Image Error Display'

            ;NOW DEFINE DRAW WIDGETS FOR IMAGE ERROR DISPLAY
            self->Defineimageerrorbase
          endif else begin
            Widget_control,idmenu,set_value='Display Image Error Bars'
            Widget_control,idcontext,set_value='Display Image Error Bars'
            Widget_control,self.imageerrorbase,/destroy
          endelse

          self->Draw
          if Widget_info(self.Clickrefitslider,/valid_id) ne 0 $
            and self.displayindex ne 3 then begin
            Widget_control,self.clickrefitslider,$
              get_value=crsval


            Widget_control,self.clickrefitslider,/destroy
          endif
        end;IMAGEERRORBARS
        else:   begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF IMAGEMENU CHOICE"
        end
      endcase;obj.parent eq 'IMAGEOPTIONS'
    end;IMAGEOPTIONS
    'DETECTOROPTIONS':begin
      case obj.id of
        '32SQUARE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
        end
        '64SQUARE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
        end
        '128RECT':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
        end
        '128SQUARE':begin
          Widget_control,self.tw1,$
            set_value=obj.parent+':'+obj.id
        end
        else:   begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF DETECTORMENU CHOICE"
        end
      endcase;obj.parent eq 'DETECTOROPTIONS'
    end;DETECTOROPTIONS
    'CALCULATIONOPTIONS':begin
      case obj.id of
        'CALCULATEQS':begin
          (self.datacontainer->Get(position=$
            self.qchoiceindex))->Calculateqvals
        end;CALCULATEQS
        'CALCULATEIEXPRESS':begin
          self->Calculateiqtdialog3
        end;'CALCULATEIEXPRESS'
        'CALCULATEI':begin
          ;040904


          ;self->CalculateIQTDialog
          self->Calculateiqtdialog2
          ;self->CalculateIQTDialog3
          ;VALUE PASSING AND CALCULATION HANDLED
          ;IN DIALOG EVENT HANDLER, WHICH IS
          ;listEvents


          ;CALCULATE I(Q,t)
          ;HANDLE CALCULATION IN listEvents
          ;                                (self.dataContainer->get(position=$
          ;                                    self.QChoiceIndex))->calculateIQT


          ;ONCE THIS CALCULATION IS DONE,
          ;SUM ARCS OF Q FOR FINAL RESULT

          ;                                (self.dataContainer->get(position=$
          ;                                    self.QChoiceIndex))->sumQArcs


          ;THEN. . .



          ;POP UP PLOT OF I(Q,t)
          ;
          ;PLOT MUST ALLOW OVERLAY OF OTHER I(Q,t)
          ;
          ;THIS GIVES narcs DATA SETS PLOTTED VS
          ;LOG(t)



        end;CALCULATEI
        'CALCULATEAVERAGEWIDTH':begin
          width = (self.datacontainer->Get(position=$
            self.qchoiceindex))->Chisqweightedavewidth()
          void = Dialog_message('Chi-squared averaged width = '+Strtrim(String(width),2),/information)
        end;'CALCULATEAVERAGEWIDTH'
        'AUTOGRAPHNSE':begin
          self->Autographnsedialog
          Widget_control,self.tw1,$
            set_value="OPENED AUTOGRAPHNSE"
        end;'AUTOGRAPHNSE'
        'AUTOMASKSOMETHING':begin
          self->Automasksomething
          Widget_control,self.tw1,$
            set_value="OPENED AUTOMASKSOMETHING"
        end;'AUTOGRAPHNSE'
        'NSEDIFFRACTIONVIEWER':begin
          Nsediffractionviewer,group_leader=self.atlb
          Widget_control,self.tw1,$
            set_value='OPENED NSEDIFFRACTIONVIEWER'
        end;'AUTOGRAPHNSE'
        'CALCULATESQ1D':begin
          Cw_nse_sqplot,group_leader=self.atlb,work_dir=self.work_dir

        end;'CALCULATESQ1D'
        'MERGEMULTIPLEIQT':begin
          dum = Cwo_mergeiqttodave(group_leader=self.atlb,workdir=self.work_dir)
        end;'MERGEMULTIPLEIQT'
        else:   begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF CALCULATIONSMENU CHOICE"
        end;else
      endcase
    end;CALCULATIONS
    'PRINTOPTIONS':begin
      case obj.id of

        'PRINTIMAGEDEFAULT':begin
          self->Printwindow,/imaged
        end;PRINTIMAGEDEFAULT
        'PRINTPLOTDEFAULT':begin
          self->Printwindow,/plotd
        end;PRINTPLOTDEFAULT
        'PRINTAUXPLOTDEFAULT':begin
          if self.dw2auxid ne 0L then begin
            self->Printwindow,/auxd
          endif else begin
            void = Dialog_message('Auxiliary window not available.')
          endelse
        end;PRINTAUXPLOTDEFAULT
        'PRINTALLDEFAULT':begin
          if self.dw2auxid ne 0L then begin
            self->Printwindow,/auxd,/imaged,/plotd
          endif else begin
            self->Printwindow,/imaged,/plotd
          endelse
        end;PRINTALLDEFAULT
        'PRINTIMAGE':begin
          self->Printwindow,/imagew
        end;PRINTIMAGE
        'PRINTPLOT':begin
          self->Printwindow,/plotw
        end;PRINTPLOT
        'PRINTAUXPLOT':begin
          if self.dw2auxid ne 0L then begin
            self->Printwindow,/auxw
          endif else begin
            void = Dialog_message('Auxiliary window not available.')
          endelse
        end;PRINTAUXPLOT
        else:begin
          Widget_control,self.tw1,$
            set_value="UNSURE OF PRINTMENU CHOICE"
        end
      endcase
    end;PRINT
    'HELPOPTIONS':begin
      case obj.id of
        'NSEHELP':begin
          newevent = {id:Event.id,top:self.dave_id,handler:Event.handler}
          if Widget_info(self.Dave_id,/valid_id) gt 0 then begin
            Nse_help,newevent
          endif else begin
            void = Dialog_message('Help available when called from DAVE! (oodisplayecho_define ln 5932)',/info)
          endelse
        end;NSEHELP
        else:
      endcase
    end
    else:   begin
      Widget_control,self.tw1,$
        set_value="UNSURE OF MENU CHOICE"

    end
  endcase;obj.parent

end;menuEvents

pro Oodisplayecho::autographNSEDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::autographNSEDialog
  ;
  ;PURPOSE:
  ;           Creates autographNSE dialog.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  ;    self.autographNSEbutton = widget_button(llb1,value='Plot and Fit D(Q)',$
  ;                                                tooltip='AutographNSE')

  ;    self->getproperty(/autographNSEbutton):begin
  a = Checkforobjinstance('cwo_autographnse',ref=ref)
  ;print,a
  if a eq 0 then begin
    ;                        base = widget_base(group_leader=self.atlb,title='AutographNSE',/floating)
    ;                        w = cwo_autographnse(base)
    w = Cwo_autographnse(self.atlb,workdir=self.work_dir)
    ;widget_control,base,/realize
    ;                        xmanager,'autograph',w,event_handler='cwo_autographnse_event_pro',/no_block
    ;                                                    ;base,event_handler='cwo_autographnse_event_pro',/no_block
  endif



end;autographNSEDialog


pro Oodisplayecho::resizeAuxWindow,Event,xsize=xsize,ysize=ysize
  ;
  ;NAME:
  ;        ooDisplayEcho::raiseAuxWindow
  ;
  ;PURPOSE:
  ;           Resizes the Auxiliary window.
  ;PARAMETERS:
  ;           event   resize event
  ;KEYWORDS:
  ;           none

  ;SEE ALSO LINE ~10630 FOR MAIN RESIZE OF THIS WIDGET.
  ;THERE IS A PROBLEM WITH KEEPING TRACK OF THE DRAW WINDOW.

  ;IT AFFECTS POSITION SELECTION ON IMAGE AND PLOT WINDOWS!!!!

  ;---WHY???????????????????????      -AXIS CONFUSION
  ;                               SAVE THE AXES JUST BEFORE AND JUST AFTER THE DRAW TO AUX PLOT.
  ;                                   FIX THIS TOMORROW!!!!

  ;print,'ooDisplayEcho::resizeAuxWindow'

  if N_elements(xsize) eq 0 then myxsize = Event.x
  if N_elements(ysize) eq 0 then myysize = Event.y


  winxsize = myxsize-6
  winysize = myysize-6

  if Widget_info(self.Dw2aux,/valid_id) gt 0 then begin
    Widget_control,self.dw2aux,xsize = winxsize, ysize = winysize
  endif

  if Widget_info(self.Dw2auxbase,/valid_id) gt 0 then begin
    Widget_control,self.dw2auxbase,xsize=myxsize,ysize=myysize
  endif
  Wdelete,self.dw2auxpix
  Window,/free,/pixmap,xsize=winxsize,ysize=winysize
  self.dw2auxpix = !d.window

  if N_elements(xsize) eq 0 then $
    self->Draw

end;resizeAuxWindow
pro Oodisplayecho::raiseAuxWindow
  ;
  ;NAME:
  ;        ooDisplayEcho::raiseAuxWindow
  ;
  ;PURPOSE:
  ;           Opens the Auxiliary window if not open.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  self.dw2auxbase = Widget_base(group_leader=self.atlb,$
    title='Auxiliary Plot (no user events)',$
    tlb_size_events = 1,$
    uvalue = self,$
    /floating)
  self.dw2aux = Widget_draw(self.dw2auxbase,xsize=self.plotxsize,ysize=self.plotysize)
  Centertlb,self.dw2auxbase
  Widget_control,self.dw2auxbase,/realize



  Widget_control,self.dw2aux,get_value=auxid
  self.dw2auxid = auxid
  Window,/free,/pixmap,xsize=self.plotxsize,ysize=self.plotysize
  self.dw2auxpix = !d.window
  Xmanager,'ooDisplayEcho',self.dw2auxbase,event_handler='oodisplayecho_event',/no_block


end;raiseAuxWindow
pro Oodisplayecho::lowerAuxWindow
  ;
  ;NAME:
  ;        ooDisplayEcho::lowerAuxWindow
  ;
  ;PURPOSE:
  ;           Closes the Auxiliary window if open.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;print,'lowerAuxWindow'

  if Widget_info(self.Dw2auxbase,/valid_id) gt 0 then begin
    Widget_control,self.dw2auxbase,/destroy
    Wdelete,self.dw2auxpix
  endif
end;lowerAuxWindow


pro Oodisplayecho::lowerSlider
  ;
  ;NAME:
  ;        ooDisplayEcho::lowerSlider
  ;
  ;PURPOSE:
  ;           Closes the click-refit slider dialog.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none
  if Widget_info(self.Clickrefitslider,/valid_id) ne 0 then begin
    sliderparent = Widget_info(self.clickrefitslider,/parent)
    ;widget_control,self.clickrefitslider,/destroy
    Widget_control,sliderparent,/destroy
    ;            widget_control,sliderparent,show=0
  endif

end;lowerSlider
pro Oodisplayecho::raiseSlider
  ;
  ;NAME:
  ;        ooDisplayEcho::raiseSlider
  ;
  ;PURPOSE:
  ;           Closes the click-refit slider dialog.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none
  ;        clickrefitbase = widget_base(self.tlb2,/row)

  clickrefitbase = Widget_base(group_leader=self.atlb,/row,/floating,$
    title='DOUBLE-Click-Refit Start Values')
  self.clickrefitslider = Cw_fslider(clickrefitbase,$;self.tlb2,$
    minimum=-800.0,$
    maximum=800.0,$
    edit=1,$
    drag=1,$
    scroll=15.0,$
    value=self.clickrefitvalue,$
    title='starting phase',$
    uvalue={object:self,$
    method:'sliderEvents',$
    id:'CLICKREFITSLIDER'})

  if self.clickrefitperiodvalue eq 0 then self.clickrefitperiodvalue = 360.0
  self.clickrefitperiodslider = Cw_fslider(clickrefitbase,$;self.tlb2,$
    minimum=300.0,$
    maximum=420.0,$
    edit=1,$
    drag=1,$
    scroll=5.0,$
    value=self.clickrefitperiodvalue,$
    title='starting period',$
    uvalue={object:self,$
    method:'sliderEvents',$
    id:'CLICKREFITPERIODSLIDER'})


  Widget_control,clickrefitbase,/realize

  Xmanager,'ooDisplayEcho',clickrefitbase,/no_block



end;raiseSlider



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::droplistEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::droplistEvents
  ;
  ;PURPOSE:
  ;           Handle events from teh droplist widgets in ooDisplayEcho
  ;PARAMETERS:
  ;           event   The droplist event structure to handle.
  ;KEYWORDS:
  ;           none

  Widget_control,Event.id,get_uvalue=obj

  case (obj.id) of
    'DROPDISPLAY': begin
      Widget_control,self.tw1,$
        set_value='DROPDISPLAY'+Strtrim(String(Event.index),2)

      self.displayindex = Event.index
      self->Draw

    end
    'DROPDET': begin
      Widget_control,self.tw1,$
        set_value="DROPDET:"+Strtrim(String(Event.index),2)
      self.detchoiceindex = Event.index
    end
    'DROPFT': begin


      ;print,tag_names(event)
      ;print,event

      Widget_control,self.tw1,$
        set_value="DROPFT:"+Strtrim(String(Event.index),2)
      self.ftchoiceindex = Event.index
      self->Mousehead,Event,t=Event.index
      ;self->draw
    end
    'DROPQ': begin
      Widget_control,self.tw1,$
        set_value="DROPQ:"+Strtrim(String(Event.index),2)

      oldQIndex = self.qchoiceindex
      self.qchoiceindex = Event.index
      ;                print,oldQIndex,self.QChoiceIndex
      ;pro ooDisplayEcho::swapDataObject,n_old,n_new
      self->Swapdataobject,oldQIndex,self.qchoiceindex
      ;                self->setDataParameters,$
      ;                    self.ech,$;self.dataContainer->get(position = self.QChoiceIndex),$
      ;                    n=self.QChoiceIndex
      self->Setdataparameters,$
        (self.datacontainer->Get(position=self.qchoiceindex)),$
        n=self.qchoiceindex

      self->Redefinewidgets,Event.index
      self->Draw
    end
    'DROPFIXCONST': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXCONST:"+Strtrim(String(Event.index),2)
      self->Handlefixdroplist,0,Event.index
      self->Redefinetree
    end
    'DROPFIXAMP': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXAMP:"+Strtrim(String(Event.index),2)
      self->Handlefixdroplist,1,Event.index
      self->Redefinetree
    end
    'DROPFIXPHASEO': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXPHASEO:"+ $
        Strtrim(String(Event.index),2)
      self->Handlefixdroplist,2,Event.index
      self->Redefinetree
    end
    'DROPFIXSIGMA': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXSIGMA:"+Strtrim(String(Event.index),2)
      self->Handlefixdroplist,3,Event.index
      self->Redefinetree
    end
    'DROPFIXOMEGA': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXOMEGA:"+Strtrim(String(Event.index),2)
      self->Handlefixdroplist,4,Event.index
      self->Redefinetree
    end
    'DROPFIXPHASE': begin
      Widget_control,self.tw1,$
        set_value="DROPFIXPHASE:"+Strtrim(String(Event.index),2)
      self->Handlefixdroplist,5,Event.index
      self->Redefinetree
    end

    else:   begin
      Widget_control,self.tw1,$
        set_value="UNSURE OF DROPWIDGET CHOICE"
    end

  endcase



  ;LIMIT OPTIONS WERE HARD CODED AND HIDDEN FROM THE USER LONG AGO.
  ;        'DROPLIMITCONST': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITCONST:"+strtrim(string(event.index),2)
  ;                self.limited[0] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimconst,editable=event.index
  ;                widget_control,self.atwmaxlimconst,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimconst,editable=1
  ;                ;    widget_control,self.atwmaxlimconst,editable=1
  ;                ;endelse
  ;            end
  ;        'DROPLIMITAMP': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITAMP:"+strtrim(string(event.index),2)
  ;                self.limited[1] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimamp,editable=event.index
  ;                widget_control,self.atwmaxlimamp,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimamp,editable=1
  ;                ;    widget_control,self.atwmaxlimamp,editable=1
  ;                ;endelse
  ;            end
  ;        'DROPLIMITPHASEO': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITPHASEO:"+strtrim(string(event.index),2)
  ;                self.limited[2] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimphaseo,editable=event.index
  ;                widget_control,self.atwmaxlimphaseo,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimphaseo,editable=1
  ;                ;    widget_control,self.atwmaxlimphaseo,editable=1
  ;                ;endelse
  ;            end
  ;        'DROPLIMITSIGMA': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITSIGMA:"+strtrim(string(event.index),2)
  ;                self.limited[3] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimsigma,editable=event.index
  ;                widget_control,self.atwmaxlimsigma,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimsigma,editable=1
  ;                ;    widget_control,self.atwmaxlimsigma,editable=1
  ;                ;endelse
  ;            end
  ;        'DROPLIMITOMEGA': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITOMEGA:"+strtrim(string(event.index),2)
  ;                self.limited[4] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimomega,editable=event.index
  ;                widget_control,self.atwmaxlimomega,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimomega,editable=1
  ;                ;    widget_control,self.atwmaxlimomega,editable=1
  ;                ;endelse
  ;            end
  ;        'DROPLIMITPHASE': begin
  ;                widget_control,self.tw1,$
  ;                        set_value="DROPLIMITPHASE:"+strtrim(string(event.index),2)
  ;                self.limited[5] = event.index ;0 for unlimited, 1 for limited
  ;                ;if event.index eq 1 then begin
  ;                widget_control,self.atwminlimphase,editable=event.index
  ;                widget_control,self.atwmaxlimphase,editable=event.index
  ;                ;endif else begin
  ;                ;    widget_control,self.atwminlimphase,editable=1
  ;                ;    widget_control,self.atwmaxlimphase,editable=1
  ;                ;endelse
  ;            end
  ;
  ;        else:   begin
  ;                    widget_control,self.tw1,$
  ;                        set_value="UNSURE OF DROPWIDGET CHOICE"
  ;                end
  ;
  ;    endcase
  ;self->draw

end;droplistEvents

pro Oodisplayecho::handleFixDroplist,parm,index
  ;
  ;NAME:
  ;        ooDisplayEcho::handleFixDroplist
  ;
  ;PURPOSE:
  ;               Handle events from the fix/vary droplists.
  ;PARAMETERS:
  ;               parm        The fit parameter index
  ;               index       The fix/vary state of the parameter, i.e. the index of the droplist state.
  ;KEYWORDS:
  ;
  ;021306
  ;AT THIS POINT I WILL NOT ADD THE STORAGE OF FIT PARMS TO THE
  ;EVENT HANDLING.  THIS MAY BE AN ISSUE, BUT IT SHOULD BE SOMETHING THE
  ;USERS RAISE, SINCE THEY REQUESTED THIS FEATURE AND THEY MAY NOT WANT
  ;A RESTORE CAPABILITY.
  ref = self.datacontainer->Get(position=self.qchoiceindex)

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;
  ;;  AT THIS POINT IT IS ALMOST CERTAIN THAT THE FIT STATE OF ref SHOULD BE CHANGED TO "not fit"
  ;;
  ;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;print,'ooDisplayEcho::handleFixDroplist:  AT THIS POINT IT IS ALMOST CERTAIN THAT THE FIT STATE OF ref SHOULD BE CHANGED TO "not fit"'
  ;print,'Perhaps send as a flag to ref->fixparm'

  ;HANDLE THIS ISSUE IN THE DATA OBJECT

  ;print,'ooDisplayecho::handlefixdroplist'

  ;022306
  ;WHY MIGHT I GET HERE?
  ;
  ;1) PEOPLE ARE UPDATING THE VALUES IN THE TEXT BOXES TO MANUALLY CHANGE THE
  ;CURVE PARAMETERS TO BETTER VALUES.
  ;
  ;2) PEOPLE ARE VARYING THE FIX/VARY VALUES.
  ;
  ;IT SEEMS THAT IN EITHER CASE, THEY WANT TO SAVE THE VALUES AS STARTING POINTS FOR
  ;THE FITS.
  ;
  ;SO MOVE THE BOTTOM STATEMENTS TO HERE.

  ;                ;GET THE VALUE IN THE RELEVANT TEXT FIELD
  ;                parmField = [self.atwconst,self.atwamp,self.atwphaseo,$
  ;                             self.atwsigma,self.atwomega,self.atwphase]
  ;                widget_control,parmfield[parm],get_value=value
  ;
  ;
  ;                ;TAKE CARE OF omega/T ISSUE
  ;                ;
  ;                ;DUE TO EARLY DECISION, I FIT WITH omega INSTEAD OF period.
  ;                ;THAT IS MANIFESTED HERE.
  ;                if parm eq 4 then value = 360.0/value
  ;
  ;                ref->fixParm,parm,index,x=self.xindex,y=self.yindex,t=self.ftChoiceIndex,value=value

  ;WHY DOES UPDATING HAPPEN BEFORE THE VALUES IS FIXED?  DO I LOSE THE VALUE????
  self->Updatefitparmwidget,parm,index;,/dontUpdateValues



  ;GET THE VALUE IN THE RELEVANT TEXT FIELD
  parmField = [self.atwconst,self.atwamp,self.atwphaseo,$
    self.Atwsigma,self.atwomega,self.atwphase]
  Widget_control,parmfield[parm],get_value=value


  ;TAKE CARE OF omega/T ISSUE
  ;
  ;DUE TO EARLY DECISION, I FIT WITH omega INSTEAD OF period.
  ;THAT IS MANIFESTED HERE.
  if parm eq 4 then value = 360.0/value

  ref->Fixparm,parm,index,x=self.xindex,y=self.yindex,t=self.ftchoiceindex,value=value

  ;help,/traceback

end;handleFixDroplist


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::updateFitparmWidget,n,State
  ;
  ;NAME:
  ;        ooDisplayEcho::updateFitparmWidget
  ;
  ;PURPOSE:
  ;               Update the fit parameter display widgets following and event.
  ;PARAMETERS:
  ;               n       The fit parameter index
  ;               state   The fix/vary state of the parameter.
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;print,'ooDisplayEcho::updateFitparmWidget',n,state

  ;021406
  ;CHANGE THE NEXT LINE TO REFLECT THE 8 OPTIONS
  ;self.fixed[n] = state ;0 for vary, 1 for fixed

  if State lt 8 then begin
    self.fixed[n] = state/4 ;NOT THAT self.fixed ONLY STORES THE vary/fix OPTION, NOT THE STATE
    ;OF THE FIT PARM DROPLIST WIDGETS.
  endif else begin
    if State eq 8 then begin
      ;FIXING WITHOUT CHANGING ALL VALUES.
      self.fixed[n] = 1;state/4

    endif else begin
      void = Dialog_message('THE POSSIBLE Fix/Vary STATES HAVE CHANGED')
    endelse
  endelse


  ;SET VALUE IN SELECTED DATA OBJECT AT SELECTED PIXEL
  t=self.ftchoiceindex
  q=self.qchoiceindex


  ;THE NEXT TWO LINES SHOULD ONLY BE CALLED WHEN THERE IS AN EVENT FROM THE
  ;DROPLIST WIDGETS, SINCE THOSE ARE UPDATED BASED ON THE VALUES IN THE
  ;DATA CLASS.
  ;                ref = self.dataContainer->get(position=q)
  ;                ref->fixParm,n,state,x=self.xindex,y=self.yindex,t=self.ftChoiceIndex

  ;THE NEXT TWO LINES BELONG IN THE DATA CLASS.
  ;THE ONLY WAY THESE SHOULD BE NEEDED IS ON A DROPLIST EVENT, WHICH IS HANDLED ABOVE
  ;AND SENT HERE.
  ;                pfixed = ref->getProperty(tag='fixed')
  ;                (*pfixed)[n,self.xindex+self.yindex*self.detxdim,t] = $
  ;                                                            self.fixed[n]

  case n of
    0:begin
      id = self.atwconst
      dwid = self.dropfixconst
    end
    1:begin
      id = self.atwamp
      dwid = self.dropfixamp
    end
    2:begin
      id = self.atwphaseo
      dwid = self.dropfixphaseo
      ;print,state

    end
    3:begin
      id = self.atwsigma
      dwid = self.dropfixsigma
    end
    4:begin
      id = self.atwomega
      dwid = self.dropfixomega
    end
    5:begin
      id = self.atwphase
      dwid = self.dropfixphase
    end
    else:begin
    end
  endcase


  ;021305
  ;print,'7384 in ooDisplayEcho::updateFitparmWidget'

  ;WHERE CAN I ARRIVE HERE FROM????
  ;WILL THE FOLLOWING CONDITIONAL WORK PROPERLY FOR ALL SITUATIONS
  ;ARRIVING HERE????
  ;print,*p
  if State lt 4 then begin    ;eq 0 then begin
    Widget_control,id,editable = 1
  endif else begin
    Widget_control,id,editable = 0
  endelse

  ;                widget_control,dwid,get_va



  ;CHANGE THE NEXT LINE TO USE THE state AND NOT self.fixed
  Widget_control,dwid,set_droplist_select=state;self.fixed[n]


end;updateFitparmWidget
pro Oodisplayecho::handleBinning,factor=factor,index=index,$
  xfactor=xfactor,yfactor=yfactor,$
  donotrebin=donotrebin,filename=filename,$
  default=default,newfile=newfile
  ;
  ;NAME:
  ;        ooDisplayEcho::handleBinning
  ;
  ;PURPOSE:
  ;           Handle events whenever bin is called.
  ;PARAMETERS:
  ;           none.
  ;KEYWORDS:
  ;           factor  The binning factor to return.
  ;           index   The index of the object to bin.


  Catch, catchError
  if (catchError ne 0) then begin

    Print,'TESTING'
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::handleBinning!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    Catch, /cancel
    Return
  endif



  binvals = [1,2,4,8,16]
  selectindex = Nse_comboindex(self.atw1)
  factor = binvals[selectindex]
  nobj = self.datacontainer->Count()

  ;MUST BE CAREFUL IN USE OF THIS SINCE IT APPLIES TO ALL DATA AND EACH OBJECT
  ;DOES NOT REVEAL ITS STATE.  PERHAPS THERE IS A WAY TO MAKE CHECK THE STATE.
  Widget_control,self.timeaverageupdowncheckbox,get_value= timecheckboxval
  Widget_control,self.deepmaskingcheckbox,get_value= DEEPMASKINGCHECKBOXval
  Widget_control,self.atwwidth,get_value= sigmatext
  sigmaval = Float(sigmatext)

  tlbgeom = Widget_info(self.atlb,/geom)

  if N_elements(index) eq 0 then begin
    if nobj eq 1 then nostop = 1 else nostop = 0
    prog = Nse_cwo_progress(labels=['Data Set:'],$
      startvalues=[0L],$
      endvalues=[Long(nobj)],$
      values=[0L],$
      steps=[1L],$
      obj=progobj,$
      nostop=nostop,$
      title='Rebinning:   ',$
      dialog_parent=self.atlb,$
      xoffset=tlbgeom.xoffset+tlbgeom.xsize/2-100,$
      yoffset=tlbgeom.yoffset+tlbgeom.ysize/2-20)


    for i = 0,nobj-1 do begin
      progobj->Set,0,i
      stopped = progobj->Checkstop()
      if stopped ne 0 then begin
        Widget_control,prog,/destroy
        Return
      endif


      ref = self.datacontainer->Get(position=i)
      ref->Bin,factor=factor,timeaverage=timecheckboxval,deepmasking=DEEPMASKINGCHECKBOXval,$
        xfactor=xfactor,yfactor=yfactor,$
        donotrebin=donotrebin,filename=filename,$
        default=default,newfile=newfile,sigma=sigmaval
    endfor;i
    Widget_control,prog,/destroy

  endif else begin
    ref = self.datacontainer->Get(position=index)
    ref->Bin,factor=factor,timeaverage=timecheckboxval,deepmasking=DEEPMASKINGCHECKBOXval,$
      xfactor=xfactor,yfactor=yfactor,$
      donotrebin=donotrebin,filename=filename,$
      default=default,newfile=newfile,sigma=sigmaval

  endelse

end;handleBinning

pro Oodisplayecho::add,obj,position=position
  ;
  ;NAME:
  ;        ooDisplayEcho::add
  ;
  ;PURPOSE:
  ;           Add objects to the data container
  ;PARAMETERS:
  ;           obj         The object to add
  ;KEYWORDS:
  ;           position    The optional position to add it at.
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  void = Dialog_message('ooDisplayEcho::add is not yet implemented.')
  ;    if n_elements(obj) eq 1 then begin
  ;        if obj_isa(obj,'ooEcho') gt 0 then begin
  ;            self.datacontainer->add,obj,position=position
  ;        endif
  ;    endif else void = dialog_message('No valid object to add.')


end;add
pro Oodisplayecho::textEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::textEvents
  ;
  ;PURPOSE:
  ;           Handle events from the ooDisplayEcho text widgets.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

  Widget_control,Event.id,get_uvalue=obj,get_value=text

  ;;CHANGE THE NEXT LINE IN CASE text IS NOT A STRING.
  Widget_control,self.tw1,$
    set_value='textEvent: ID = '+Strtrim(String(obj.id),2)+', value = '  $
    +Strtrim(String(text),2)

  ;if (obj.id eq 'ATW1') then begin
  case obj.id of
    'ATW1':begin
      ;REBINNING
      ;            widget_control,self.atw1,get_value = s  ;NEED TO CHECK TYPE FOR s

      ;FIXING THIS TO DEAL WITH THE PLATFORM INDEPENDENT BUTTONS.

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        factor=1
        Catch, /cancel
      endif
      ;            factor = fix(s)
      ;            print,'event.index=',event.index
      ;            print,'event.str=',event.str

      ;print,tag_names(event,/structure_name)
      ;print,tag_names(event)
      ;print,event

      binvals = [1,2,4,8,16]
      selectindex = Nse_comboindex(Event.id)

      factor = binvals[selectindex]
      ;            ;SIMPLY GET THE VALUE OF WHICHEVER BUTTON IS SELECTED.
      ;            widget_control,event.id,get_value=atw1val
      ;            print,'atw1val=',atw1val
      ;
      ;            self.atw1value = fix(atw1val)
      ;
      ;            ;THIS WILL BE SET IN self->reDefineWidgets
      ;;            widget_control,self.atw1,set_value=atw1val+' >'
      ;
      ;            ;factor = fix(event.str)
      ;
      ;            factor = fix(atw1val)
      self->Resetdataparameters,factor
      ;120804 CHANGE NEXT LINE SO ftChoiceIndex IS PRESERVED
      ;ON A REBIN.
      self->Redefinewidgets,self.qchoiceindex,t=self.ftchoiceindex,/resetdataparameters
      self->Redefinetree
      self->Updatemaskmaker
      self->Draw
    end;ATW1
    'BINALLBUTTON':begin

      self->Handlebinning,factor=factor
      ;            binvals = [1,2,4,8,16]
      ;            selectindex = nse_comboindex(self.atw1)
      ;            factor = binvals(selectindex)
      ;            nobj = self.datacontainer->count()
      ;
      ;            ;MUST BE CAREFUL IN USE OF THIS SINCE IT APPLIES TO ALL DATA AND EACH OBJECT
      ;            ;DOES NOT REVEAL ITS STATE.  PERHAPS THERE IS A WAY TO MAKE CHECK THE STATE.
      ;            widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,get_value= timecheckboxval
      ;            widget_control,self.DEEPMASKINGCHECKBOX,get_value= DEEPMASKINGCHECKBOXval
      ;
      ;
      ;
      ;            for i = 0,nobj-1 do begin
      ;                ref = self.datacontainer->get(position=i)
      ;                ref->bin,factor=factor,timeaverage=timecheckboxval,deepmasking=DEEPMASKINGCHECKBOXval
      ;;DO NOT APPLY TIME AVERAGING AT THIS STAGE UNLESS IT IS LATER REQUESTED.
      ;
      ;            endfor


      self->Resetdataparameters,factor
      ;120804 CHANGE NEXT LINE SO ftChoiceIndex IS PRESERVED
      ;ON A REBIN.
      self->Redefinewidgets,self.qchoiceindex,t=self.ftchoiceindex,/resetdataparameters
      self->Redefinetree
      self->Updatemaskmaker
      self->Draw
    end;BINALLBUTTON
    'CHANGEMASKFILEBUTTON':begin

      ;        widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,get_value= timecheckboxval
      ;        widget_control,self.DEEPMASKINGCHECKBOX,get_value= DEEPMASKINGcheckboxval
      ;
      ;        ref = self.datacontainer->get(position=self.QChoiceIndex)
      ;
      ;        ref->bin,factor=factor,timeaverage=timecheckboxval,$
      ;                    DEEPMASKING=DEEPMASKINGcheckboxval,/newfile,filename=fn
      ;

      self->Handlebinning,factor=factor,index=self.qchoiceindex,$
        filename=fn,/newfile


      Print,fn

    end;'CHANGEMASKFILEBUTTON'
    'SAVEMASKBUTTON':begin
      ;031305



      ref = self.datacontainer->Get(position=self.qchoiceindex)

      dir = self.work_dir
      ref->Savemask,dir=dir
      self.work_dir = dir

    end;'SAVEMASKBUTTON'
    'DEEPMASKINGCHECKBOX':begin
      ;        print,'ooDisplayEcho::textEvents    DEEPMASKINGCHECKBOX'


      ;FOR NOW THE DEEPMASKING OPTION WILL CALL ALL THE SAME ITEMS THE BINALLBUTTON DOES.

      ;MUST BE CAREFUL IN USE OF THIS SINCE IT APPLIES TO ALL DATA AND EACH OBJECT
      ;DOES NOT REVEAL ITS STATE.  PERHAPS THERE IS A WAY TO MAKE CHECK THE STATE.
      ;            widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,get_value= timecheckboxval
      ;            widget_control,self.DEEPMASKINGCHECKBOX,get_value= DEEPMASKINGcheckboxval
      ;
      ;
      ;            ;GET FILENAME AT THE OBJECT LEVEL IF NECESSARY
      ;;            if DEEPMASKINGcheckboxval eq 1 then begin
      ;;                fn = dialog_pickfile(title='SELECT SAVED DEEP MASK FILE')
      ;;            endif else begin
      ;;                fn = ''
      ;;            endelse
      ;
      ;
      ;            binvals = [1,2,4,8,16]
      ;            selectindex = nse_comboindex(self.atw1)
      ;            factor = binvals(selectindex)
      ;            nobj = self.datacontainer->count()
      ;
      ;
      ;
      ;            print,'ooDisplayEcho::textEvents    timecheckboxval=',timecheckboxval
      ;
      ;
      ;;FOR NOW JUST APPLY TO CURRENT OBJECT.
      ;            ref = self.datacontainer->get(position=self.QChoiceIndex)
      ;            ref->bin,factor=factor,timeaverage=timecheckboxval,DEEPMASKING=DEEPMASKINGcheckboxval;,filename = fn

      self->Handlebinning,factor=factor,index=self.qchoiceindex

      ;            for i = 0,nobj-1 do begin
      ;                ref = self.datacontainer->get(position=i)
      ;                ref->bin,factor=factor,timeaverage=timecheckboxval,DEEPMASKING=DEEPMASKINGcheckboxval,filename = fn
      ;;DO NOT APPLY TIME AVERAGING AT THIS STAGE UNLESS IT IS LATER REQUESTED.
      ;            endfor

      self->Resetdataparameters,factor,/nobin;timeaverage=timecheckboxval,DEEPMASKING=DEEPMASKINGcheckboxval,filename = fn
      ;120804 CHANGE NEXT LINE SO ftChoiceIndex IS PRESERVED
      ;ON A REBIN.
      self->Redefinewidgets,self.qchoiceindex,t=self.ftchoiceindex,/resetdataparameters
      self->Redefinetree
      self->Updatemaskmaker
      self->Draw





    end;DEEPMASKINGCHECKBOX
    'TRANSVOLALLBUTTON':begin

      ;            for i = 0,nobj-1 do begin
      ;                ref = self.datacontainer->get(position=i)
      ;                ;ref->bin,factor=factor
      ;            endfor

      ;GET VOLUME FRACTION VALUE AND APPLY TO ALL SPECIFIED DATA
      Widget_control,self.atwvolfrac,get_value=s

      thistype = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='type')

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='volfrac')
        Catch, /cancel
      endif


      volfrac = Double(s)
      if volfrac le 0.0d then begin
        volfrac = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='volfrac')
        Widget_control,self.atwvolfrac,set_value=Strtrim(String(volfrac),1)
      endif

      Widget_control,self.atwtrans,get_value=s

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='transmission')
        Catch, /cancel
      endif


      trans = Double(s)
      if trans le 0.0d then begin
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='transmission')
        Widget_control,self.atwtrans,set_value=Strtrim(String(trans),1)
      endif


      for ii = 0,(self.datacontainer->Count())-1 do begin
        refi = (self.datacontainer->Get(position=ii))
        if refi->Getproperty(tag='type') eq thistype then begin
          refi->Setproperty,'volfrac',volfrac
          refi->Setproperty,'transmission',trans
        endif
      endfor;ii
    end;TRANSVOLALLBUTTON


    ;102605
    ;
    ;THE NEXT EVENT HANDLING BLOCKS SHOULD ONLY BE ACCESSED IF THE CURRENT
    ;DATA OBJECT IS A MAGNETIC OBJECT!!!!! US obj


    'MAGNETICCHECKBOX':begin


      ;THIS IS NOT CONTROLLABLE BY THE USER!!!!
      ;;112805
      ;;THIS WILL NOT BE EDITABLE BY THE USER IN THE FUTURE.
      ;
      ;
      ;        ;print,'#### MagneticCheckBox ####'
      ;        widget_control,self.magneticcheckbox,get_value = value
      ;        print,obj.id+': ',value
      ;        print,tag_names(event,/structure_name)
      ;        print,tag_names(event)
      ;        print,event
      ;
      ;
      ;
      ;        ref = self.datacontainer->get(position=self.qchoiceindex)
      ;        if obj_isa(ref,'ooechomagnetic') eq 1 then begin
      ;
      ;            ref->setproperty,'magnetic',event.value
      ;            widget_control,self.atwflippingratio,sensitive=event.value
      ;            widget_control,self.atwpolarization,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_up_x,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_up_y,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_up_z,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_down_x,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_down_y,sensitive=event.value
      ;;            widget_control,self.atwpoint_to_down_z,sensitive=event.value
      ;            widget_control,self.magplotcontextsubmenu,sensitive=event.value
      ;            widget_control,self.magplotmenusubmenu,sensitive=event.value
      ;
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS')
      ;            widget_control,magimageid,sensitive=event.value
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1')
      ;            widget_control,magimageid,sensitive=event.value
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2')
      ;            widget_control,magimageid,sensitive=event.value
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3')
      ;            widget_control,magimageid,sensitive=event.value
      ;
      ;
      ;        endif else begin
      ;            widget_control,self.magneticcheckbox,set_value=0
      ;            widget_control,self.atwflippingratio,sensitive=0
      ;            widget_control,self.atwpolarization,sensitive=0
      ;;            widget_control,self.atwpoint_to_up_x,sensitive=0
      ;;            widget_control,self.atwpoint_to_up_y,sensitive=0
      ;;            widget_control,self.atwpoint_to_up_z,sensitive=0
      ;;            widget_control,self.atwpoint_to_down_x,sensitive=0
      ;;            widget_control,self.atwpoint_to_down_y,sensitive=0
      ;;            widget_control,self.atwpoint_to_down_z,sensitive=0
      ;
      ;            widget_control,self.magplotcontextsubmenu,sensitive=0
      ;            widget_control,self.magplotmenusubmenu,sensitive=0
      ;
      ;
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS')
      ;            widget_control,magimageid,sensitive=0
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1')
      ;            widget_control,magimageid,sensitive=0
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2')
      ;            widget_control,magimageid,sensitive=0
      ;            magimageid = widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3')
      ;            widget_control,magimageid,sensitive=0
      ;        endelse
      ;        ;IF BOX IS CHECKED THEN THE POINT_TO_UP/DOWN_X/Y/Z
      ;        ;FIELDS WILL BE SENSITIVE.

    end;MAGNETICCHECKBOX
    'TIMEAVERAGEUPDOWNCHECKBOX':begin
      ;void = dialog_message('In the process of allowing time averaging of up/down.')


      ;        ref = self.dataContainer->get(position=self.QChoiceIndex)
      ;
      ;;        widget_control,event.id,get_value=val
      ;;
      ;;        print,'TIMEAVERAGEUPDOWNCHECKBOX    value=',val,event.select
      ;
      ;
      ;
      ;        index = nse_comboindex(self.atw1)
      ;
      ;        ;GET BIN FACTOR FROM THE DROPLIST.
      ;        widget_control,self.atw1,get_value=val
      ;        factor = fix(val[index])
      ;
      ;;        print,tag_names(event)
      ;;        print,event
      ;
      ;        widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,get_value= checkboxval
      ;        widget_control,self.DEEPMASKINGCHECKBOX,get_value= DEEPMASKINGcheckboxval
      ;        ;print,'checkboxval=',checkboxval
      ;
      ;;TWO OTHER CASES NEED TO BE CONSIDERED HERE.
      ;;   1) INITIAL READ OF DATA SHOULD LOOK AT checkboxval AND RESPOND APPROPRIATELY
      ;;   2) FILES READ IN FROM SAVED STATES SHOULD RESPOND IN SOME APPROPRIATE FASHION.
      ;;
      ;;THE SECOND CASE SUGGESTS THAT THIS SHOULD BE APPLIED THROUGH A BUTTON.
      ;
      ;        ref->bin,factor=factor,timeaverage=checkboxval,DEEPMASKING=DEEPMASKINGcheckboxval;,filename = fn

      self->Handlebinning,factor=factor,index=Self.qchoiceindex



      self->Draw
      ;WHEN THIS IS CHECKED, THE XYZ UP/DOWN SHOULD BE TIME AVERAGED.
      ;WHEN IT IS UNCHECKED, XYZ UP/DOWN SHOULD BE unTIMEAVERAGED.
      ;
      ;THIS SHOULD BE HANDLED THROUGH THE ooEcho::bin METHOD, SINCE THAT USES THE
      ;ORIGINAL DATA TO CREATE THE BINNED VERSION.  THIS WAY, THE NON-TIMEAVERAGED DATA
      ;IS ALWAYS AVAILABLE.

      ;THE BIN METHOD SHOULD BE OVERRIDDEN IN ooEchoMagnetic.
      ;THE NEW VERSION SHOULD HAVE A timeAveraged FLAG, AND THE ORIGINAL VERSION
      ;SHOULD HAVE AN _extra=extra KEYWORD ADDED IN CASE IT IS INADVERTANTLY CALLED.
      ;THE NEW VERSION SHOULD ALSO SAVE A CURRENT STATE OF THE MASK SO THAT IS UNCHANGED
      ;FROM PRIOR TO TIME AVERAGING.





    end;TIMEAVERAGEUPDOWNCHECKBOX
    'TIMEAVERAGEUPDOWNAPPLYALLBUTTON':begin

      ;THIS IS A BUTTON BECAUSE THERE IS AN AMBIGUITY ABOUT WHAT FILES SHOULD
      ;BE TIME AVERAGED WHEN READ IN.  SEE NOTE IN CHECKBOX CASE ABOVE THIS.
      ;print,'TEST1'
      ;        index = nse_comboindex(self.atw1)
      ;
      ;        widget_control,self.TIMEAVERAGEUPDOWNCHECKBOX,get_value= checkboxval
      ;        ;print,checkboxval
      ;
      ;        count = self.datacontainer->count()
      ;        if count gt 0 then begin
      ;            for i=0,count-1 do begin
      ;                ;print,'TEST ',i
      ;                ref = self.dataContainer->get(position=i)
      ;                ;ref->bin,timeaverage=checkboxval,donotrebin=1
      ;                ref->bin,timeaverage=checkboxval,DEEPMASKING=DEEPMASKINGcheckboxval;,filename = fn
      ;            endfor;i
      ;        endif
      ;
      ;

      self->Handlebinning,factor=factor;,index=index


      self->Draw
    end;TIMEAVERAGEUPDOWNAPPLYALLBUTTON


    'ATWFLIPPINGRATIO':begin
      ;THIS WILL ACT ON ALL MAGNETIC OBJECTS

      Widget_control,self.atwflippingratio,get_value = value
      ;print,obj.id,+': ',value

      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: f = ',ref->getproperty(tag='f')
        ref->Setproperty,'f',Event.value
        ref->Setproperty,'IupdownSwitch',0
        ;print,'After: f = ',ref->getproperty(tag='f')
        self->Draw
      endif else begin
      endelse

    end;ATWFLIPPINGRATIO
    'ATWPOLARIZATION':begin
      Widget_control,self.atwpolarization,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: p = ',ref->getproperty(tag='p')
        ref->Setproperty,'p',Event.value
        ref->Setproperty,'IupdownSwitch',0
        ;print,'After: p = ',ref->getproperty(tag='p')
        self->Draw
      endif else begin
      endelse



    end;ATWPOLARIZATION
    'ATWEFF_BPW':begin
      Widget_control,self.atwpolarization,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: eff_bpw = ',ref->getproperty(tag='eff_bpw')
        ref->Setproperty,'eff_bpw',Event.value
        ref->Setproperty,'IupdownSwitch',0
        ;print,'After: eff_bpw = ',ref->getproperty(tag='eff_bpw')
        self->Draw
      endif else begin
      endelse
    end;ATWEFF_BPW
    ;    'ATWEFF_BPW_X':begin
    ;            widget_control,self.atwpolarization,get_value = value
    ;            ;print,obj.id,+': ',value
    ;            ref = self.datacontainer->get(position=self.qchoiceindex)
    ;        if obj_isa(ref,'ooechomagnetic') eq 1 then begin
    ;            ;print,'Before: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            ref->setproperty,'eff_bpw_x',event.value
    ;            ref->setproperty,'IupdownSwitch',0
    ;            ;print,'After: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            self->draw
    ;        endif else begin
    ;        endelse
    ;    end;ATWEFF_BPW_X
    ;    'ATWEFF_BPW_Y':begin
    ;            widget_control,self.atwpolarization,get_value = value
    ;            ;print,obj.id,+': ',value
    ;            ref = self.datacontainer->get(position=self.qchoiceindex)
    ;        if obj_isa(ref,'ooechomagnetic') eq 1 then begin
    ;            ;print,'Before: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            ref->setproperty,'eff_bpw_y',event.value
    ;            ref->setproperty,'IupdownSwitch',0
    ;            ;print,'After: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            self->draw
    ;        endif else begin
    ;        endelse
    ;    end;ATWEFF_BPW_Y
    ;    'ATWEFF_BPW_Z':begin
    ;            widget_control,self.atwpolarization,get_value = value
    ;            ;print,obj.id,+': ',value
    ;            ref = self.datacontainer->get(position=self.qchoiceindex)
    ;        if obj_isa(ref,'ooechomagnetic') eq 1 then begin
    ;            ;print,'Before: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            ref->setproperty,'eff_bpw_z',event.value
    ;            ref->setproperty,'IupdownSwitch',0
    ;            ;print,'After: eff_bpw = ',ref->getproperty(tag='eff_bpw')
    ;            self->draw
    ;        endif else begin
    ;        endelse
    ;    end;ATWEFF_BPW_Z

    'ATWXYZUPDOWNSCALE':begin

      Widget_control,self.atwxyzupdownscale,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_up_x = ',ref->getproperty(tag='point_to_up_x')
        ;print,'Before: xyzupdownscale = ',ref->getproperty(tag='xyzupdownscale')
        ref->Setproperty,'xyzupdownscale',value;event.value
        ref->Setproperty,'IupdownSwitch',0
        ;print,'After: xyzupdownscale = ',ref->getproperty(tag='xyzupdownscale')
        ;print,'After: point_to_up_x = ',ref->getproperty(tag='point_to_up_x')
        self->Draw
      endif else begin
      endelse


    end;ATWXYZUPDOWNSCALE
    'ATWPOINT_TO_UP_X':begin
      ;THESE WILL ACT ONLY ON THE CURRENTLY SELECTED OBJECT.

      Widget_control,self.atwpoint_to_up_x,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_up_x = ',ref->getproperty(tag='point_to_up_x')
        ref->Setproperty,'point_to_up_x',Event.value
        ;print,'After: point_to_up_x = ',ref->getproperty(tag='point_to_up_x')
      endif else begin
      endelse

    end;ATWPOINT_TO_UP_X
    'ATWPOINT_TO_DOWN_X':begin
      Widget_control,self.atwpoint_to_down_x,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_down_x = ',ref->getproperty(tag='point_to_down_x')
        ref->Setproperty,'point_to_down_x',Event.value
        ;print,'After: point_to_down_x = ',ref->getproperty(tag='point_to_down_x')
      endif else begin
      endelse

    end;ATWPOINT_TO_DOWN_X
    'ATWPOINT_TO_UP_Y':begin
      Widget_control,self.atwpoint_to_up_y,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)

      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_up_y = ',ref->getproperty(tag='point_to_up_y')
        ref->Setproperty,'point_to_up_y',Event.value
        ;print,'After: point_to_up_y = ',ref->getproperty(tag='point_to_up_y')
      endif else begin
      endelse

    end;ATWPOINT_TO_UP_Y
    'ATWPOINT_TO_DOWN_Y':begin
      Widget_control,self.atwpoint_to_down_y,get_value = value
      ;print,obj.id,+': ',value

      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_down_y = ',ref->getproperty(tag='point_to_down_y')
        ref->Setproperty,'point_to_down_y',Event.value
        ;print,'After: point_to_down_y = ',ref->getproperty(tag='point_to_down_y')
      endif else begin
      endelse


    end;ATWPOINT_TO_DOWN_Y
    'ATWPOINT_TO_UP_Z':begin
      Widget_control,self.atwpoint_to_up_z,get_value = value
      ;print,obj.id,+': ',value

      ref = self.datacontainer->Get(position=self.qchoiceindex)

      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_up_z = ',ref->getproperty(tag='point_to_up_z')
        ref->Setproperty,'point_to_up_z',Event.value
        ;print,'After: point_to_up_z = ',ref->getproperty(tag='point_to_up_z')
      endif else begin
      endelse

    end;ATWPOINT_TO_UP_Z
    'ATWPOINT_TO_DOWN_Z':begin
      Widget_control,self.atwpoint_to_down_z,get_value = value
      ;print,obj.id,+': ',value
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      if Obj_isa(ref,'ooechomagnetic') eq 1 then begin
        ;print,'Before: point_to_down_z = ',ref->getproperty(tag='point_to_down_z')
        ref->Setproperty,'point_to_down_z',Event.value
        ;print,'After: point_to_down_z = ',ref->getproperty(tag='point_to_down_z')
      endif else begin
      endelse
    end;ATWPOINT_TO_DOWN_Z


    'ATWBCX':begin
      binarr = ['1','2','4','8','16']
      s = binarr[Nse_comboindex(self.atw1)]
      ;widget_control,self.atw1,get_value = s  ;NEED TO CHECK TYPE FOR s
      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        x_cen_orig = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='x_cen_orig')
        Catch, /cancel
      endif


      ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
      x_dim_orig = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='x_dim_orig')
      x_dim = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='x_dim')


      Widget_control,self.atwbcx,get_value = x_cen_orig
      x_cen_orig = Double(x_cen_orig)
      if x_cen_orig le 0.0d then begin
        x_cen_orig = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='x_cen_orig')
        Widget_control,self.atwbcx,set_value=Strtrim(String(x_cen_orig),1)
      endif


      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,$
        'x_cen_orig',x_cen_orig

      self.beamcenxorig = x_cen_orig


      ;widget_control,self.atw1,get_value = s
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'x_cen',$
        x_cen_orig/Double(s)

      ;            widget_control,self.atwbcx,get_value = x_cen
      ;            (self.dataContainer->get(position=$
      ;                        self.QChoiceIndex))->setProperty,'x_cen',x_cen
      ;



      ;SET ALL BEAM CENTERS TO SAME VALUE ASSUMING THAT
      ;ALL OF THE DATA WILL HAVE THE SAME BEAM POSITION

      ;051904
      ;
      ;SETTING DETECTOR CENTER VALUES TO BE
      ;BASED ON THE FULL DETECTOR SIZE ALWAYS.

      ;050704
      ;
      ;DURING DEMO THEY SAID TO USE SAME BEAM CENTER
      ;FOR A GIVEN WAVELENGTH.  SET ALL BEAM CENTERS
      ;TO SAME VALUE FOR A GIVEN WAVELENGTH.
      ;DO THIS FOR ATWBCX AND ATWBCY.
      ;
      ;NEED TO CLARIFY WHICH VALUE OF THE BEAM CENTER
      ;WILL BE USED (32x32 or 16x16, etc.)  FOR NOW
      ;ASSUME THAT THE CENTERS WILL BE SPECIFIED IN
      ;PIXELS AT CURRENT BINNING.
      ;
      ;ALSO NEED TO DO THIS ON READING A NEW FILE!!!
      ;
      lambdao = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='lambda')

      lambdaTol = 0.03*lambdao  ; set tol to 3% of lambdao

      for i=0,self.datacontainer->Count()-1 do begin

        lambda = $
          (self.datacontainer->Get(position=$
          i))->Getproperty(tag='lambda')
        ;print,lambda

        if (Abs(lambda-lambdao) le lambdaTol) then begin

          self->Setbeamcenter,self.qchoiceindex,i
          ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
          x_dim_orig = $
            (self.datacontainer->Get(position=$
            i))->Getproperty(tag='x_dim_orig')
          x_dim = $
            (self.datacontainer->Get(position=$
            i))->Getproperty(tag='x_dim')


          ;SET THE ORIGINAL BEAM CENTER
          (self.datacontainer->Get(position=$
            i))->Setproperty,'x_cen_orig',$
            (self.datacontainer->Get(position=$
            self.qchoiceindex))->Getproperty(tag='x_cen_orig')
          ;SET THE BEAM CENTER FOR THE CURRENT BINNING
          (self.datacontainer->Get(position=$
            i))->Setproperty,'x_cen',$
            (self.datacontainer->Get(position=$
            self.qchoiceindex))->Getproperty(tag='x_cen_orig')*$
            (Double(x_dim)/Double(x_dim_orig))
        endif;lambda eq lambdao
      endfor;i
      self->Draw
    end
    'ATWBCY':begin
      binarr = ['1','2','4','8','16']
      s = binarr[Nse_comboindex(self.atw1)]

      ;widget_control,self.atw1,get_value = s  ;NEED TO CHECK TYPE FOR s
      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        y_cen_orig = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='y_cen_orig')
        Catch, /cancel
      endif

      ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
      y_dim_orig = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='y_dim_orig')
      y_dim = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='y_dim')

      Widget_control,self.atwbcy,get_value = y_cen_orig


      y_cen_orig = Double(y_cen_orig)
      if y_cen_orig le 0.0d then begin
        y_cen_orig = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='y_cen_orig')
        Widget_control,self.atwbcy,set_value=Strtrim(String(y_cen_orig),1)
      endif


      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'y_cen_orig',y_cen_orig


      ;widget_control,self.atw1,get_value = s
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'y_cen',$
        y_cen_orig/Double(s)

      self.beamcenyorig = y_cen_orig



      ;SET ALL BEAM CENTERS TO SAME VALUE ASSUMING THAT
      ;ALL OF THE DATA WILL HAVE THE SAME BEAM POSITION

      lambdao = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='lambda')
      lambdaTol = 0.03*lambdao  ; set tol to 3% of lambdao

      for i=0,self.datacontainer->Count()-1 do begin
        lambda = $
          (self.datacontainer->Get(position=$
          i))->Getproperty(tag='lambda')
        ;print,lambda

        if (Abs(lambda-lambdao) le lambdaTol) then begin

          ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
          y_dim_orig = $
            (self.datacontainer->Get(position=$
            i))->Getproperty(tag='y_dim_orig')
          y_dim = $
            (self.datacontainer->Get(position=$
            i))->Getproperty(tag='y_dim')


          ;SET THE ORIGINAL BEAM CENTER
          (self.datacontainer->Get(position=$
            i))->Setproperty,'y_cen_orig',$
            (self.datacontainer->Get(position=$
            self.qchoiceindex))->Getproperty(tag='y_cen_orig')
          ;SET THE BEAM CENTER FOR THE CURRENT BINNING
          (self.datacontainer->Get(position=$
            i))->Setproperty,'y_cen',$
            (self.datacontainer->Get(position=$
            self.qchoiceindex))->Getproperty(tag='y_cen_orig')*$
            (Double(y_dim)/Double(y_dim_orig))
        endif;lambda eq lambdao
      endfor;i
      self->Draw


    end;ATWBCY
    'ATWTRANS':begin
      Widget_control,self.atwtrans,get_value=s

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='transmission')
        Catch, /cancel
      endif


      trans = Double(s)
      if trans le 0.0d then begin
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='transmission')
        Widget_control,self.atwtrans,set_value=Strtrim(String(trans),1)
      endif



      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'transmission',trans

    end;ATWTRANS
    'ATWVOLFRAC':begin
      Widget_control,self.atwvolfrac,get_value=s

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        trans = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='volfrac')
        Catch, /cancel
      endif


      volfrac = Double(s)
      if volfrac le 0.0d then begin
        volfrac = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='volfrac')
        Widget_control,self.atwvolfrac,set_value=Strtrim(String(volfrac),1)
      endif

      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'volfrac',volfrac

    end;ATWVOLFRAC
    'ATWNARCS':begin
      Widget_control,self.atwnarcs,get_value=s

      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg
        narcs = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='narcs')
        Catch, /cancel
      endif


      ;SET THE NUMBER OF ARCS THE SAME FOR ALL DATA SETS.
      ;THIS WILL REQUIRE THE USER TO RESET THE NUMBER OF ARCS
      ;ON CHANGING THE NUMBER OF ARCS
      ;narcs = double(s)

      narcs = Fix(Double(s))
      ;print,narcs

      ;DON'T ALLOW 1 ARC UNTIL ooEcho IS READY, AND NEVER ALLOW 0 ARCS

      ;072005
      ;            if narcs le 1 then begin
      if narcs lt 1 then begin
        narcs = 7
        Widget_control,self.atwnarcs,set_value=Strtrim(String(narcs),2)
      endif

      for n=0,self.datacontainer->Count()-1 do begin
        (self.datacontainer->Get(position=$
          n))->Setproperty,'narcs',narcs
      endfor
      ;                (self.dataContainer->get(position=$
      ;                        self.QChoiceIndex))->setProperty,'narcs',narcs

      self->Draw      ;UPDATE DISPLAY SO Q LINES ARE DRAWN
    end;ATWNARCS
    'ATWWIDTH':begin

      ;062204
      ;
      ;SET GAUSSIAN WIDTH TO BE THE SAME FOR ALL
      ;DATA OBJECTS WITH THE CURRENT WAVELENGTH.
      ;
      ;UPDATE THE FIXED FIT PARAMETER FOR ALL DATA
      ;AND IN THE FIT PARAMETERS WIDGETS.

      ;            widget_control,self.atw1,get_value = s  ;NEED TO CHECK TYPE FOR s
      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg


        ;NEED TO ADD A DATA MEMBER TO ooEcho FOR THE WIDTH.
        ;SET A DEFAULT VALUE FOR THE WIDTH HERE.
        width = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='width')
        Catch, /cancel
      endif

      ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
      ;SET VALUES FOR WIDTH PARAMETER IN fitparms
      ;AND ALL OTHER DATA OBJECTS WITH THE SAME
      ;WAVELENGTH.

      width_orig = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='width')

      ;GET USER-ENTERED WITH FROM THE TEXT FIELD
      Widget_control,self.atwwidth,get_value = swidth
      width = Double(swidth)
      if width le 0.0d then begin
        width = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='width')
        Widget_control,self.atwwidth,set_value=Strtrim(String(width),1)
      endif


      self.gaussianwidth = width

      refq = (self.datacontainer->Get(position=$
        self.qchoiceindex))

      widthq_orig = refq->Getproperty(tag='width')
      ;PLACE USER-ENTERED VALUE INTO THE CURRENT DATA OBJECT
      if widthq_orig ne width then begin
        refq->Storefitparms
        refq->Setproperty,'reduced',0
        refq->Setwidth,width
        refq->Setproperty,'width',width
      endif


      ;NOW UPDATE ALL OF THE RELEVANT DATA OBJECTS WITH THIS WIDTH
      lambda0 = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='lambda')
      lambdaTol = 0.03*lambda0  ; set tol to 3% of lambda0

      for i=0,self.datacontainer->Count()-1 do begin
        refi = (self.datacontainer->Get(position=i))
        Help,refi,output=outrefi,struct=0
        Help,refq,output=outrefq,struct=0
        if outrefi ne outrefq then begin
          lambda = refi->Getproperty(tag='lambda')
          refi->Storefitparms

          if (Abs(lambda-lambda0) le lambdaTol) then begin
            ;SET THE WIDTH OF THE SELECTED OBJECT TO THAT
            ;OF THE CURRENT OBJECT
            ;AND UPDATE THE "REDUCED" STATE IF THE VALUE CHANGED
            ;                        dum = dialog_message('oodisplayecho::textevents'+ $
            ;                                            string(refi->getProperty(tag='reduced')))
            widthi_orig = refi->Getproperty(tag='width')
            if widthi_orig ne refq->Getproperty(tag='width') then begin
              refi->Setproperty,'reduced',0
            endif
            refi->Setproperty,'width',$
              refq->Getproperty(tag='width')
            refi->Setwidth,width;refq->getProperty(tag='width')
          endif;lambda eq lambda0
        endif;outrefi
      endfor;i

      self->Redefinetree
      self->Mousehead,Event
      ;            self->draw
      ;            self->redefineWidgets,self.QChoiceIndex

    end;ATWWIDTH
    'ATWPERIOD':begin

      ;062204
      ;
      ;SET GAUSSIAN WIDTH TO BE THE SAME FOR ALL
      ;DATA OBJECTS WITH THE CURRENT WAVELENGTH.
      ;
      ;UPDATE THE FIXED FIT PARAMETER FOR ALL DATA
      ;AND IN THE FIT PARAMETERS WIDGETS.

      ;            widget_control,self.atw1,get_value = s  ;NEED TO CHECK TYPE FOR s
      Catch, Error_status
      ;Error handler in case of type conversion error in text field
      if (Error_status ne 0) then begin
        Print, 'Error index: ', Error_status
        Print, 'Error message: ', !ERROR_STATE.msg


        ;NEED TO ADD A DATA MEMBER TO ooEcho FOR THE WIDTH.
        ;SET A DEFAULT VALUE FOR THE WIDTH HERE.
        width = self.periodvalue
        ;                        (self.dataContainer->get(position=$
        ;                        self.QChoiceIndex))->getProperty(tag='width')
        Catch, /cancel
      endif

      ;GET ORIGINAL AND CURRENT IMAGE BINNINGS
      ;SET VALUES FOR WIDTH PARAMETER IN fitparms
      ;AND ALL OTHER DATA OBJECTS WITH THE SAME
      ;WAVELENGTH.

      period_orig = $
        (self.datacontainer->Get(position=$
        i))->Getproperty(tag='period')

      ;GET USER-ENTERED WITH FROM THE TEXT FIELD
      Widget_control,self.atwperiod,get_value = speriod
      period = Double(speriod)
      if period le 0.0d then begin
        period = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='period')
        Widget_control,self.atwperiod,set_value=Strtrim(String(period),1)
      endif
      self.periodvalue = period

      refq = (self.datacontainer->Get(position=$
        self.qchoiceindex))

      periodq_orig = refq->Getproperty(tag='period')
      ;PLACE USER-ENTERED VALUE INTO THE CURRENT DATA OBJECT
      if periodq_orig ne period then begin
        refq->Storefitparms
        refq->Setproperty,'reduced',0
        refq->Setperiod,period
        refq->Setproperty,'period',period
      endif


      ;NOW UPDATE ALL OF THE RELEVANT DATA OBJECTS WITH THIS WIDTH
      lambdao = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='lambda')
      lambdaTol = 0.03*lambdao  ; set tol to 3% of lambdao

      for i=0,self.datacontainer->Count()-1 do begin
        refi = (self.datacontainer->Get(position=i))
        Help,refi,output=outrefi,struct=0
        Help,refq,output=outrefq,struct=0
        if outrefi ne outrefq then begin
          lambda = refi->Getproperty(tag='lambda')
          refi->Storefitparms

          if (Abs(lambda-lambdao) le lambdaTol) then begin
            ;SET THE PERIOD OF THE SELECTED OBJECT TO THAT
            ;OF THE CURRENT OBJECT
            ;AND UPDATE THE "REDUCED" STATE IF THE VALUE CHANGED
            periodi_orig = refi->Getproperty(tag='period')
            if periodi_orig ne refq->Getproperty(tag='period') then begin
              refi->Setproperty,'reduced',0
            endif
            refi->Setproperty,'period',$
              refq->Getproperty(tag='period')
            refi->Setperiod,refq->Getproperty(tag='period')
          endif;lambda eq lambdao
        endif;outrefi
      endfor;i

      self->Redefinetree
      self->Mousehead,Event

    end;ATWPERIOD
    'ATWLAMBDA':begin
      Widget_control,self.atwlambda,get_value=sval
      ;val = strtrim(val,2)
      val = Double(sval)
      if val le 0.0d then begin
        val = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='lambda')
        Widget_control,self.atwlambda,set_value=Strtrim(String(val),2)
      endif


      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'lambda',val*((10.0d^(-10.0d)))
    end;ATWLAMBDA
    'ATWLAMBDADIST':begin
      Widget_control,self.atwlambdadist,get_value=sval
      ;val = strtrim(sval,2)
      ;print,sval
      val = Double(sval)
      ;print,val
      if val le 0.0d then begin
        val = (self.datacontainer->Get(position=$
          self.qchoiceindex))->Getproperty(tag='dlambda')
        Widget_control,self.atwlambdadist,set_value=Strtrim(String(val),2)
      endif


      lambda = (self.datacontainer->Get(position=$
        self.qchoiceindex))->Getproperty(tag='lambda')

      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'dlambda',$
        (val/100.0)*lambda
    end;ATWLAMBDADIST
    'ATWCONST':begin
      self->Handlefitparmtextwidgetevents
    end;ATWCONST
    'ATWAMP':begin
      self->Handlefitparmtextwidgetevents
    end;ATWAMP
    'ATWPHASEO':begin
      self->Handlefitparmtextwidgetevents
    end;ATWPHASEO
    'ATWSIGMA':begin
      self->Handlefitparmtextwidgetevents
    end;ATWSIGMA
    'ATWOMEGA':begin
      ;print,'ooDisplayEcho::textEvents'
      self->Handlefitparmtextwidgetevents
    end;ATWOMEGA
    'ATWPHASE':begin
      self->Handlefitparmtextwidgetevents
    end;ATWPHASE
    else:begin
      Widget_control,self.tw1,set_value=obj.id+': unsure of widget choice.'
    end
  endcase

end;textEvents
pro Oodisplayecho::handleFitparmTextWidgetEvents
  ;
  ;NAME:
  ;        ooDisplayEcho::handleFitparmTextWidgetEvents
  ;
  ;PURPOSE:
  ;               Get the current values in the fit parameters text widgets
  ;               and apply them to the current data object
  ;PARAMETERS:
  ;               none
  ;KEYWORDS:
  ;               none

  ;022406
  parms = self->Getparmsfromtextwidgets()

  ;HANDLE omega v. period ISSUE
  ;print,parms[4]
  if parms[4] lt 0.0 then parms[4] = -1.0*parms[4]
  ;print,parms[4]
  if parms[4] lt 10.0 then begin
    parms[4] = 360.0/parms[4]
    Widget_control,self.atwomega,set_value=Strtrim(String(parms[4]),2)
  endif

  ref = self.datacontainer->Get(position=self.qchoiceindex)
  ref->Setparms,parms,self.xindex,self.yindex,self.ftchoiceindex;,parmindex=0
  ;print,(*(ref->getproperty(tag='fitparms')))[0:5,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
  self->Draw,textfitparms = parms,/no_update

end;handleFitparmTextWidgetEvents

function Oodisplayecho::getParmsFromTextWidgets
  ;
  ;NAME:
  ;        ooDisplayEcho::getParmsFromTextWidgets
  ;
  ;PURPOSE:
  ;               Get the current values in the fit parameters text widgets
  ;PARAMETERS:
  ;               event   The file tree event structure.
  ;KEYWORDS:
  ;               none


  parms = Dblarr(6)
  parms[4] = 360.0
  ref = (self.datacontainer->Get(position=self.qchoiceindex))

  ;AVERAGE
  Widget_control,self.atwconst,get_value=savval
  avval = Double(savval)
  if avval le 0.0 then begin
    avval = (*(ref->Getproperty(tag='fitparms')))[0,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
  endif


  ;AMPLITUDE
  Widget_control,self.atwamp,get_value=sampval
  ampval = Double(sampval)


  if ampval le 0.0 then begin
    ;CHECK IF THE OBJECT REFERENCE IS A HYDROGENATED SAMPLE AND ALLOW NEGATIVE AMPLITUDES IF IT IS.
    hydrogenated = ref->Checkhydrogenated(self.xindex,self.yindex,self.ftchoiceindex)
    if hydrogenated eq 0 then $
      ampval = (*(ref->Getproperty(tag='fitparms')))[1,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
  endif


  ;PHASE
  Widget_control,self.atwphaseo,get_value=sval
  phase = Double(sval)

  ;if phase eq 0.0d then begin
  ;    phase = (*(ref->getProperty(tag='fitparms')))[2,self.xindex+self.yindex*self.detxdim,self.ftChoiceIndex]
  ;endif


  ;WIDTH
  Widget_control,self.atwsigma,get_value=sval
  width = Double(sval)
  if width le 0.0 then begin
    width = (*(ref->Getproperty(tag='fitparms')))[3,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
  endif


  ;PERIOD
  Widget_control,self.atwomega,get_value=sval
  period = Double(sval)
  if period le 0.0 then begin

    ;022306
    period = -1.0*period
    ;if period
    ;period = 360.0/(*(ref->getProperty(tag='fitparms')))[4,self.xindex+self.yindex*self.detxdim,self.ftChoiceIndex]
  endif

  ;PHASE OFFSET
  Widget_control,self.atwphase,get_value=sval
  phaseoffset = Double(sval)
  if phaseoffset le 0.0 then begin
    phaseoffset = (*(ref->Getproperty(tag='fitparms')))[5,self.xindex+self.yindex*self.detxdim,self.ftchoiceindex]
  endif


  parms = [avval,ampval,phase,width,period,phaseoffset]

  Return,parms
end;getParmsFromTextWidgets
pro Oodisplayecho::treeEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::treeEvents
  ;
  ;PURPOSE:
  ;               Handle events from the file tree.
  ;PARAMETERS:
  ;               event   The file tree event structure.
  ;KEYWORDS:
  ;               none

  Widget_control,Event.id,get_uvalue = obj
  ;    print,'treeEvent occurred. '+obj.id+string(obj.element)
  Widget_control,self.tw1,set_value=obj.id;+string(obj.index)
  ;print,'022406 ooDisplayEcho::treeEvents'
  ;print,tag_names(event,/structure_name)
  ;print,tag_names(event)
  ;print,event

  if (Tag_names(event, /STRUCTURE_NAME) eq 'WIDGET_TREE_SEL') then begin

    if (obj.id eq 'FTW') then begin
      ;ONLY MAKE CHANGES IF THE SELECTED TREE LEAF CHANGES.
      refnew = self.datacontainer->Get(position=obj.index)

      ntnew = refnew->Getproperty(tag = 'no_of_fourier_times')
      refold = self.datacontainer->Get(position=self.qchoiceindex)
      ntold = refold->Getproperty(tag = 'no_of_fourier_times')
      if obj.index ne self.qchoiceindex $
        or ntnew ne ntold $
        or self.datacontainer->Count() eq 0 then begin


        self.qchoiceindexold = self.qchoiceindex
        self.ftchoiceindexold = self.ftchoiceindex

        oldQIndex = self.qchoiceindex
        ;120804

        self->Swapdataobject,oldQIndex,obj.index

        ;DOES swapDataObject CHANGE SELECTED FOURIER TIME?
        ;AND DOES IT CALL mouseHead OR SIMILAR?

        ;            self->reDefineWidgets,obj.index
        ;            self->updateMaskmaker

        self->Mousehead,Event
        ;UPDATE THE DISPLAY
        ;            self->draw
      endif else begin
        self->Mousehead,Event,t=self.ftchoiceindex
      endelse


    endif;FTW
  endif

  IF (Tag_names(event, /STRUCTURE_NAME) EQ 'WIDGET_CONTEXT') THEN begin
    self->Contextevents,Event
  ENDIF

end;treeEvents
pro Oodisplayecho::do_nothing,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::do_nothing
  ;
  ;PURPOSE:
  ;           A "do nothing" method for events that should have no effects.
  ;PARAMETERS:
  ;           event   The event passed to this method.  Only necessary for
  ;                   the syntax of event handlers.
  ;KEYWORDS:
  ;           none

  ;EVENT HANDLING METHOD WHEN NOTHING IS TO BE DONE.
  Print,'Doing nothing.'
end;do_nothing




;021505
;#####################################################
;THREE NEW PROCEDURES TO ADD TO THE HEADER.
;#####################################################
pro Oodisplayecho_removetevents,Event
  Widget_control,Event.handler,get_uvalue=uval
  ;print,event.id

  ;print,uval.id

  self=uval.object
  self->Removetevents,Event
end;
pro Oodisplayecho::removeTEvents,Event
  ;
  ;NAME:
  ;           ooDisplayEcho::removeTEvents
  ;
  ;PURPOSE:
  ;           Create a list widget to remove Fourier Times
  ;           Events will be handled by ooDisplayEcho::removeTEvents
  ;PARAMETERS:
  ;           event   Event to handle.
  ;KEYWORDS:
  ;           none
  ;

  ;print,'ooDisplayEcho::removeTEvents REMOVING FOURIER TIME EVENTS'
  ;print,tag_names(event)
  ;print,event


  if Event.close eq 1 then begin
    ;print,'ooDisplayEcho::removeTEvents event.top=',event.top
    Widget_control,Event.top,/destroy


  endif else begin
    ;print,'ooDisplayEcho::removeTEvents'
    ;print,event.t

    ;REINSTATE THIS NEXT BLOCK WHEN THE REMOVE T STUFF IS READY
    if (Event.t)[0] ne '-1' then begin
      oldIndex = self.qchoiceindex

      tremove = (((10.0d)^(-9.0d))*Float(Event.t))
      origdataobj = self.datacontainer->Get(position=self.qchoiceindex)
      ;print,'obj_isa(origdataobj,"ooechomagnetic") = ',obj_isa(origdataobj,"ooechomagnetic")

      ;SHOULD CONVERT ooEcho::getProperty TO BE CASE INSENSITIVE
      ;print,origdataobj->getproperty(tag='fourierTime')

      ;print,'ooDisplayEcho::removeTEvents: orig ',origdataobj->getproperty(tag='point_to_down_z')



      ;            new_dataobj = origdataobj->removeT(tremove)
      ;LRK 110708
      ;UPDATE FOR MULTIPLE FOURIER TIMES.
      new_dataobj = origdataobj->Removet(tremove[0])
      if N_elements(tremove) gt 1 then begin
        for i = 1,N_elements(tremove)-1 do begin
          temp = new_dataobj->Removet(tremove[i])
          Obj_destroy,new_dataobj  ;DESTROY NEW OBJECT SO THERE IS ONLY ONE FINAL OBJECT ADDED AT THE END
          new_dataObj = temp
        endfor
      endif


      ;print,'ooDisplayEcho::removeTEvents: orig ',origdataobj->getproperty(tag='point_to_down_z')
      ;print,'ooDisplayEcho::removeTEvents: new  ',new_dataobj->getproperty(tag='point_to_down_z')


      if Obj_valid(new_dataobj) then begin
        ;                print,'ooDisplayEcho::removeTEvents new_dataobj is VALID'
        newIndex = self.datacontainer->Count()
        self.datacontainer->Add,new_dataobj,position=newIndex
        self.qchoiceindex = newIndex


        ;                self->swapDataObject,oldIndex,newIndex
        ;                self->mouseHead,event
        self->Redefinewidgets,count
        self->Redefinetree
        self->Draw



      endif
    endif;event.t
  endelse

end;removeTEvents
function Oodisplayecho::createRemoveTList
  ;
  ;NAME:
  ;        ooDisplayEcho::createRemoveTList
  ;
  ;PURPOSE:
  ;           Create a list widget to remove Fourier Times
  ;           Events will be handled by ooDisplayEcho::removeTEvents
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none
  ;RETURN VALUE:
  ;           1 success, 0 for failure
  ;

  ;CHECK FOR EXISTING removet DIALOG.
  n=Checkforobjinstance('cwo_removetlist',ref=dref)
  ;print,'ooDisplayEcho::contextEvents # of existing dialogs ='+string(n)

  ;            ;IF ONE EXISTS GET ITS BASE AND DESTROY IT.
  ;            if n eq 1 then begin
  ;                removetbase=dref[0]->getproperty(/tlb)
  ;                obj_destroy,dref[0]
  ;            endif else begin
  ;                removetbase=widget_base(xsize=100,ysize=100,group_leader=self.atlb,$
  ;                                        title='SELECT FOURIER TIMES FOR REMOVAL',/modal)
  ;            endelse
  ;
  removetbase=Widget_base(group_leader=self.atlb,xsize=300,$
    title='SELECT FOURIER TIMES FOR REMOVAL',/modal)

  ;print,'removetbase=',removetbase
  Widget_control,removetbase,/realize

  ref = self.datacontainer->Get(position=self.qchoiceindex)
  taus = ((10.0)^(9.0))*(*(ref->Getproperty(tag='fourierTime')))

  vals = Strtrim(String(taus),2)

  ;DEFINE THE NEW DIALOG
  wid = Cwo_removetlist(removetbase,$
    obj_ref=obj_ref,$
    value=vals)
  ;            print,wid
  ;            print,obj_ref->getproperty(/tlb)
  ;            help,obj_ref


  if Widget_info(wid,/valid_id) ne 0 then begin
    uval = {object:self,method:'removeTEvents',id:'REMOVETDIALOG',obj_ref:obj_ref}
    Widget_control,wid,set_uvalue=uval
    Widget_control,removetbase,set_uvalue=uval

    Xmanager,'createRemoveTList',wid,event_handler='ooDisplayEcho_removeTEvents',/no_block

    Return,1
  endif else Return,0

end;createRemoveTList


;#############################################################################################


pro Oodisplayecho::autoFitAllResolutions,Event

  Print,'ooDisplayEcho::autoFitAllResolutions'
  Help,Event,/structure
  ;FIGURE OUT WHICH LEAVES ARE SELECTED
  sel_id = Widget_info(self.ftree,/tree_select)

  ;GET THE POSITIONS IN self.dataContainer OF THE FILES THAT ARE SELECTED
  selectindices = [-1]
  for i=0,N_elements(sel_id)-1 do begin
    Widget_control,sel_id[i],get_uvalue=uval
    if uval.id eq 'FTW' then begin
      selectindices = [selectindices,uval.index]
    endif
  end;i
  if N_elements(selectindices) gt 1 then begin
    selectindices = selectindices[1:*]

    selected = Reverse(selectindices[Sort(selectindices)])

    ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
    for i=0,N_elements(selected)-1 do begin
      ;self->remove,dataObjIndex=selected[i]
      ref = self.datacontainer->Get(pos=selected[i])
      tags = ref->Getproperty(tag='tags')
      name = ref->Getproperty(tag='filename')
      comment = ref->Getproperty(tag='comment')
      if Stregex(comment,'Carbo',/boolean,/fold_case) ne 0 then begin
        Print,'Carbo'
        ref->Setproperty,'type',1
      endif
      type = ref->Getproperty(tag='type')
      Print,type
      case type of
        0:stype='Untyped'
        1:stype='Resolution'
        2:stype='Sample'
        3:stype='Cell/Background'
        else:stype = 'Unknown Type'
      endcase
      Print,name,' ',type,'='+stype
      if type eq 1 then begin
        ;'arc':begin
        ref_tavestate = ref->Report_timeaverage_state()

        Print,'NEXT UNCOMMENT THE ACTUAL FITTING!!!!'
        ;              ref->arcFit,tavestate=ref_tavestate
        ref->Setproperty,'reduced',1
        self->Redefinetree
        ;ref->arcFit,fixed=fixed,sigma=sigma,noborrow=noborrow,tavestate=ref_tavestate
        ;'expand':begin
        ;               ref->fitall3,$
        ;                    1,$ ;chiswitch
        ;                    fixed=self.fixed,$
        ;                    sigma=sigma,$
        ;                    startparms=startparms,$
        ;                    obj=self,$
        ;                    noborrow=noborrow,tavestate=ref_tavestate
        ;'spiral':begin
        ;ref->spiralfit,noborrow=noborrow,tavestate=ref_tavestate

      endif
    endfor;i
  endif





  ;    noInfoMulti = widget_button(contextBaseF_multi,value='AUTO FIT ALL RESOLUTIONS',$
  ;                                            uvalue = {object:self,$
  ;                                                  method:'autoFitAllResolutions',$
  ;                                                  id:'AUTO_FIT_ALL_RESOLUTIONS'})


end;ooDisplayEcho::autoFitAllResolutions

pro Oodisplayecho::contextMenuEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::contextMenuEvents
  ;
  ;PURPOSE:
  ;               Handle events generated by context menu event buttons.
  ;               Note: Some context menus are copies of file menus (e.g. image options),
  ;                     so their events for to ooDisplayEcho::menuEvents
  ;PARAMETERS:
  ;               event   The event structure to handle.
  ;KEYWORDS:
  ;               none

  ;HANDLE EVENTS GENERATED BY CONTEXT MENU BUTTONS.


  ;    print,tag_names(event)
  ;    print,event
  ;    sel_id = widget_info(event.handler,/tree_select)
  ;    print,self.atlb
  ;    print,'sel_id = ',sel_id


  Widget_control,Event.id,get_uvalue = obj
  Widget_control,self.tw1,set_value=obj.id

  case obj.id of
    'UNTYPED':begin
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'type',0

      Widget_control,self.atwtrans,editable = 1
      Widget_control,self.atwvolfrac,editable = 1
      self->Redefinetree
    end
    'RESOLUTION':begin
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'type',1
      Widget_control,self.atwtrans,editable = 0
      Widget_control,self.atwvolfrac,editable = 0
      self->Redefinetree
    end
    'RAWDATA':begin
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'type',2
      Widget_control,self.atwtrans,editable = 1
      Widget_control,self.atwvolfrac,editable = 1
      self->Redefinetree
    end
    'BACKGROUND':begin
      (self.datacontainer->Get(position=$
        self.qchoiceindex))->Setproperty,'type',3
      Widget_control,self.atwtrans,editable = 1
      Widget_control,self.atwvolfrac,editable = 0
      self->Redefinetree
    end
    'QNEWSET':begin
      Widget_control,self.treeselectid,get_value=text
      segs = Strsplit(text,'=',/extract)
      theQ = Double(segs[1])
      pos = (self.setcontainer)->Count()
      theName = 'Set'+Strtrim(pos,2)

      otemp = Obj_new('ooDisplayEchoTreeSet',q=theQ,$
        name=theName)

      (self.setcontainer)->Add,otemp,position=pos
      self->Redefinetree
    end;QNEWSET

    'SETIQTCALC': begin
      Print,'SET UP TO CALCULATE I(Q,T) FOR THIS SET'
    end
    'SETCHANGENAME': begin
      Widget_control,self.treeselectid,get_uvalue=uval
      index=uval.index
      self->Setnamedialog,index
      self->Redefinetree
    end;SETCHANGENAME
    'SETREMOVESET': begin
      ;print,'SET UP SET REMOVAL DIALOG'
      ;self->removeSetDialog
      Widget_control,self.treeselectid,get_uvalue=uval
      index=uval.index
      ref = (self.setcontainer)->Get(position=index)
      Obj_destroy,ref
      (self.setcontainer)->Remove,position=index
      self->Redefinetree
    end;SETREMOVESET
    'SETSETQVALUE': begin
      Print,'SET UP Q-VALUE CHANGE DIALOG'
    end;SETSETQVALUE
    'SETREMOVEOBJECT': begin
      Print,'SET UP DIALOG TO REMOVE AN INDIVIDUAL' $
        +'OBJECT FROM THE SELECTED SET.'
    end;SETREMOVEOBJECT

    'ASSIGNOBJ': begin
      ;self.treeSelectID = sel_id
      ;self.treeSelectVal = val
      self->Setselectdialog
      self->Redefinetree

    end;ASSIGNOBJ
    'REMOVEOBJ': begin
      self->Remove
    end;REMOVEOBJ
    'DUPLICATEOBJ':begin
      self->Duplicatecurrentobject
    end;DUPLICATEOBJ
    'REMOVEMULTIPLEOBJ':begin

      ;FIGURE OUT WHICH LEAVES ARE SELECTED
      sel_id = Widget_info(self.ftree,/tree_select)

      ;GET THE POSITIONS IN self.dataContainer OF THE FILES THAT ARE SELECTED
      selectindices = [-1]
      for i=0,N_elements(sel_id)-1 do begin
        Widget_control,sel_id[i],get_uvalue=uval
        if uval.id eq 'FTW' then begin
          selectindices = [selectindices,uval.index]
        endif
      end;i
      if N_elements(selectindices) gt 1 then begin
        selectindices = selectindices[1:*]

        selected = Reverse(selectindices[Sort(selectindices)])

        ;NOW REMOVE THE OBJECTS FROM THE END TO THE BEGINNING.
        for i=0,N_elements(selected)-1 do begin
          self->Remove,dataObjIndex=selected[i]
        endfor;i
      endif

    end;REMOVEMULTIPLEOBJ
    'MERGEOBJ': begin
      self->Mergedialog
      self->Redefinetree

    end;MERGEOBJ
    'REMOVEFOURIERTIMEMENU':begin
      duh = self->Createremovetlist()
      ;print,'ooDisplayEcho::contextEvents ',duh;self->createRemoveTList()

    end;REMOVEFOURIERTIMEMENU
    'SAVEFITPARAMETERS':begin
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      ref->Writefitparmstofile,/nomasked
    end;SAVEFITPARAMETERS
    'SAVEDATAITEMS':begin
      ref = self.datacontainer->Get(position=self.qchoiceindex)
      ref->Outputechodataitems

    end;SAVEDATAITEMS

    'REMOVEFOURIERTIME':begin
      ;                print,tag_names(event)
      ;                print,event
      ;                print,event.id

      duh = self->Createremovetlist()
      ;print,'ooDisplayEcho::contextEvents ',duh;self->createTContext()

      Widget_control,Event.id,get_uvalue=uval
      ;print,'uval.time = ',uval.time



      ref = self.datacontainer->Get(position=self.qchoiceindex)




      ;ref->removeFourierTime,uval.time
      self.datacontainer->Add,ref->Removet(uval.time),position=self.datacontainer->Count()
      ;                print,string(13b)+string(13b)
      ;                print,'ONCE YOU REMOVE A FOURIER TIME YOU MUST '
      ;                print,'UPDATE THE DISPLAY TO REFLECT THE NEW STATUS'
      ;                print,'OF THE CURRENT DATA OBJECT.'
      ;                print,'IS THIS UPDATE CONTAINED IN ooDisplayEcho::redefineTree?'
      ;                print,'IS THERE A CALL TO draw???'
      ;                print,string(13b)+string(13b)




      self->Redefinetree
      self->Redefinewidgets;,n,t=t,newsize=newsize


    end;REMOVEFOURIERTIME

    'KEEPQ': self->Do_nothing,Event     ;CREATING GROUPS AND ASSIGNING
    'OBJNEWSET': begin
      ;PRINT Q VALUE OF SELECTED LEAF
      ;self.treeSelectID = sel_id
      ;self.treeSelectVal = val
      Widget_control,self.treeselectid,get_uvalue=uval
      dataObjIndex = uval.index

      ;GET WIDGET ID OF Q LEAF
      parent = Widget_info(self.treeselectid,/parent)

      ;GET Q VALUE FROM THE Q LEAF
      Widget_control,parent,get_value=text
      ;print,'OBJNEWSET'
      ;print,text
      segs = Strsplit(text,'=',/extract)
      ;print,segs
      theQ = Double(segs[1])
      setpos = (self.setcontainer)->Count()
      theName = 'Set'+Strtrim(setpos,2)
      otemp = Obj_new('ooDisplayEchoTreeSet',q=theQ,$
        name=theName,$
        container=self.datacontainer,$
        index=dataObjIndex $
        )

      ;ASSIGN THE SELECTED OBJECT TO THE TREE BASED ON TYPE
      ;IF NO TYPE THEN NO ASSIGNMENT --- HANDLED IN SET INIT
      ;


      (self.setcontainer)->Add,otemp,position=setpos
      self->Redefinetree

      ;
      ;
      ;
      ;HANDLE THIS EVENT WITH THE FOLLOWING:
      ; - CREATE NEW FOLDER WITH THIS Q
      ; - MOVE SELECTED LEAF INTO NEW FOLDER
      ;
      ;
      ;

      self->Do_nothing,Event
      ;CREATE NEW SET OBJECT.
      ;UPDATE TREE.
    end
    'SEND_IQTS_TO_PAN':begin

      ;022406
      Print,'___________________________________________________________'
      Print,'ooDisplayEcho::contextMenuEvents'
      Print,'___________________________________________________________'
      Print,'SEND THE I(Q,t) DATA TO PAN FOR SELECTED OBJECTS.'
      Widget_control,Event.id,get_uvalue = obj
      Widget_control,self.tw1,set_value=obj.id
      ;print,'obj.id=',obj.id

      ;FIGURE OUT WHICH LEAVES ARE SELECTED
      sel_id = Widget_info(self.ftree,/tree_select);event.id,/tree_select)
      ;print,'sel_id=',sel_id

      ;NOW GET THE RELEVANT DATA OBJECTS
      for i=0,N_elements(sel_id)-1 do begin

        Widget_control,sel_id[i],get_uvalue = obj,get_value=val

        ;ONLY SELECT THE TREE LEAVES THAT ARE DATA OBJECTS (NOT FOLDERS)
        if obj.id eq 'FTW' then begin
          Print,obj.index
          ref = self.datacontainer->Get(position=obj.index)
          Print,File_basename(ref->Getproperty(tag='filename'))
          Print,val

          ;NOW CREATE THE DAVE POINTER(S) TO SEND TO PAN


        endif
      endfor;i

    end;SEND_IQTS_TO_PAN
    'FIT_ALL_SETS_WITH_SAME_RESOLUTION':begin

      Print,'SEND THE I(Q,t) DATA TO PAN FOR SELECTED OBJECTS.'
      Widget_control,Event.id,get_uvalue = obj
      Widget_control,self.tw1,set_value=obj.id
      ;print,'obj.id=',obj.id

      ;FIGURE OUT WHICH LEAVES ARE SELECTED
      sel_id = Widget_info(self.ftree,/tree_select);event.id,/tree_select)
      ;print,'sel_id=',sel_id

      ;NOW GET THE RELEVANT DATA OBJECTS
      for i=0,N_elements(sel_id)-1 do begin

        Widget_control,sel_id[i],get_uvalue = obj,get_value=val

        ;ONLY SELECT THE TREE LEAVES THAT ARE DATA OBJECTS (NOT FOLDERS)
        if obj.id eq 'FTW' then begin
          Print,obj.index
          ref = self.datacontainer->Get(position=obj.index)
          Print,File_basename(ref->Getproperty(tag='filename'))
          Print,val
        endif


      endfor;i

    end;FIT_ALL_SETS_WITH_SAME_RESOLUTION
    else: begin                         ;TO GROUPS.
      self->Do_nothing,Event      ;050704
      Print,'ooDisplayEcho::contextMenuEvents do nothing'
    end
  endcase;obj.id

  ;print,'Context Menu Events'
end;contextMenuEvents

pro Oodisplayecho::remove,dataObjIndex=dataObjIndex
  ;
  ;NAME:
  ;        ooDisplayEcho::remove
  ;
  ;PURPOSE:
  ;           Handle both single and multiple removes.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           dataObjIndex    Index of the data object to remove from the self.dataContainer


  ;CHECK IF OBJECT IN SET.  IF IT IS
  ;THEN REMOVE THE INDEX FROM THAT SET AND DESTROY THE
  ;OBJECT


  if N_elements(dataObjIndex) eq 0 then begin
    Widget_control,self.treeselectid,get_uvalue=uval
    dataObjIndex = uval.index
  endif

  ;REMOVE DATA OBJECT POSITION FROM ALL SETS
  ;_AND_ DECREMENT ALL HIGHER INDICES
  ;FILENAMES SHOULD BE OK.
  for i=0,(self.setcontainer)->Count()-1 do begin
    ref = (self.setcontainer)->Get(position=i)
    if ref->Getproperty(/resIndex) ge dataObjIndex $
      then begin
      if ref->Getproperty(/resIndex) eq dataObjIndex then begin
        ref->Setproperty,resIndex = -1
      endif
      if ref->Getproperty(/resIndex) eq dataObjIndex then begin
        ref->Setproperty,resIndex = ref->Getproperty(/resIndex)-1
      endif
    endif

    if ref->Getproperty(/datIndex) eq dataObjIndex $
      then begin
      if ref->Getproperty(/datIndex) eq dataObjIndex then begin
        ref->Setproperty,datIndex =-1
      endif
      if ref->Getproperty(/datIndex) eq dataObjIndex then begin
        ref->Setproperty,datIndex = ref->Getproperty(/datIndex)-1
      endif
    endif
    if ref->Getproperty(/bkgIndex) eq dataObjIndex $
      then begin
      if ref->Getproperty(/bkgIndex) eq dataObjIndex  then begin
        ref->Setproperty,bkgIndex =-1
      endif
      if ref->Getproperty(/bkgIndex) eq dataObjIndex then begin
        ref->Setproperty,bkgIndex = ref->Getproperty(/bkgIndex)-1
      endif
    endif
  endfor;i
  ;UPDATE LIST OF SET MEMBERS
  if Ptr_valid(self.setmembers) gt 0 then begin
    temp = [-1]
    Ptr_free,self.setmembers
  endif else begin
    temp = [-1]
  endelse
  for i=0,(self.setcontainer)->Count()-1 do begin
    ref = (self.setcontainer)->Get(position=i)
    temp = [temp,ref->Getproperty(/resIndex),$
      ref->Getproperty(/datIndex),$
      ref->Getproperty(/bkgIndex)]
  endfor;i
  self.setmembers = Ptr_new(temp)

  ;DELETE OBJECT
  objRef = (self.datacontainer)->Get(position=dataObjIndex)
  (self.datacontainer)->Remove,position=dataObjIndex
  Obj_destroy,objRef

  self->Redefinetree
  if (self.datacontainer)->Count() gt 0 then begin
    self->Redefinewidgets,newsize=1,t=0;,n,t=t
  endif


end;ooDisplayEcho::remove

pro Oodisplayecho::duplicateCurrentObject
  ;
  ;NAME:
  ;        ooDisplayEcho::duplicateCurrentObject
  ;
  ;PURPOSE:
  ;           Duplicate the current data object and place copy in tree.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  if self.datacontainer->Count() gt 0 then begin
    ref  = self.datacontainer->Get(position=self.qchoiceindex)
    temp = ref->Clone()
    self.datacontainer->Add,temp
    self->Redefinetree
    self->Redefinewidgets
  endif


end;


pro Oodisplayecho::contextEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::contextEvents
  ;
  ;PURPOSE:
  ;           Decide which context menu to display and display it
  ;           when a context event occurs.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

  ;    print,TAG_NAMES(event, /STRUCTURE_NAME)
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;GET INDEX NUMBER OF SELECTED TREE WIDGET

  ;FIGURE OUT WHICH LEAF WAS SELECTED
  sel_id = Widget_info(Event.id,/tree_select)

  ;print,'sel_id=',sel_id

  if (N_elements(sel_id) eq 1)then begin

    if (sel_id[0] gt 0) then begin
      Widget_control,sel_id,get_value=val

      ;print,'ooDisplayEcho::contextEvents  '

      ;print,sel_id,' ',val
      self.treeselectid = sel_id
      self.treeselectval = val
      ;GET UVALUE OF SELECTED LEAF AND DISPLAY APPROPRIATE MENU
      Widget_control,sel_id,get_uvalue=uval
      case uval.id of
        'FTW':   $
          begin
          ;GET CONTEXT MENU AND DISPLAY.
          par = Widget_info(sel_id,/parent)
          Widget_control,par,get_uvalue=puval
          if puval.id eq 'QTW' then begin
            context_base = Widget_info(Event.top, $
              find_by_uname = 'FTW_MENU')
          endif else begin
            context_base = Widget_info(Event.top, $
              find_by_uname = 'FTW_MENU_S')
          endelse


          ;MOVE THE createTContext CALL TO contextMenuEvents
          ;                ;NOW DESTROY THE PREVIOUS FOURIER TIME REMOVAL CONTEXT MENU
          ;                ;AND CREATE A NEW ONE TO ADD TO THE MENU TO BE DISPLAYED HERE.
          ;                print,'ooDisplayEcho::contextEvents ',self->createTContext()

          Widget_displaycontextmenu,  Event.id, $
            Event.X, Event.y, $
            context_base
        end
        'STW':   $
          begin
          ;GET CONTEXT MENU AND DISPLAY.
          context_base = Widget_info(Event.top, $
            find_by_uname = 'STW_MENU')
          Widget_displaycontextmenu,  Event.id, $
            Event.X, Event.y, $
            context_base
        end
        'QTW':   $
          begin
          ;GET CONTEXT MENU AND DISPLAY.
          context_base = Widget_info(Event.top, $
            find_by_uname = 'QTW_MENU')
          Widget_displaycontextmenu, Event.id, $
            Event.X, Event.y, $
            context_base
        end
        else: begin
          Widget_control,sel_id,get_uvalue=uval
          Print,'TREE WIDGET UNKNOWN'
          ;print,uval
        end
      endcase
    endif;sel_id gt 0
  endif else begin
    ;MULTIPLE SELECTION

    context_base = Widget_info(Event.top, $
      find_by_uname = 'FTW_MULTI_MENU')
    Widget_displaycontextmenu, Event.id, $
      Event.X, Event.y, $
      context_base


    ;        print,'022406   ooDisplayEcho::contextEvents'
    ;        print,'Multiple selections:
    ;        print,'_______________________________'
    ;        for i=0,n_elements(sel_id)-1 do begin
    ;            print,'sel_id[',i,']=',sel_id[i]
    ;            widget_control,sel_id[i],get_value=val
    ;            print,'val=',val
    ;
    ;        endfor;i
  endelse
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;        widget_control,self.ftree,/destroy
  ;        self->treeDefine
end;contextEvents




function Oodisplayecho::createTContext;,parent,vals
  ;
  ;NAME:
  ;        ooDisplayEcho::createTContext;
  ;
  ;PURPOSE:
  ;           Create a context submenu to list the Fourier times available
  ;           for removal from the selected data object.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none
  ;RETURN VALUE:
  ;           The parent of this menu.



  ;011105
  ;
  ;THIS WILL BE USED FOR FOURIER TIME SELECTION FOR REMOVAL.
  ;
  ;
  ;THIS FUNCTION WILL CREATE THE CONTEXT MENU ON THE FLY, AND
  ;EVENTS FROM THE BUTTONS WILL HAVE TO SELECT THE CHOSEN BUTTON
  ;FROM THE LIST OF FOURIER TIMES EITHER BY STRING COMPARISON OR
  ;BY NUMERICAL VALUE.
  ;
  ;
  ;TYPE OF PARENT SHOULD BE EXAMINED AT RUN TIME.
  ;IF THE PARENT IS A CONTEXT MENU THEN DON'T CREATE A CONTEXT BASE,
  ;OTHERWISE CREATE A CONTEXT BASE.
  ;
  ;
  ;

  ;IN PRINCIPAL THE parent CAN BE SUBMITTED VIA THE ARGUMENT FOR
  ;MORE FLEXIBILITY FOR CONTEXT-MENU LOCATIONS LATER ON.
  parent = self.removefouriertimemenu
  ;print,widget_info(parent,/valid_id)

  ;DESTROY OLD MENU IF IT STILL EXISTS
  oldcb = Widget_info(self.removefouriertimemenu,/child)
  ;print,widget_info(oldcb,/valid_id)
  if Widget_info(oldcb,/valid_id) gt 0 then Widget_control,oldcb,/destroy

  ;print,widget_info(self.removeFourierTimeMenu,/valid_id)



  ;GET THE FOURIER TIMES AND CREATE A STRING ARRAY FOR MENU LABELS
  fourierTime = *((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='fourierTime'))
  vals = Strtrim(String(fourierTime*(10.0)^9),2)


  ;THE NEXT STEP CRASHES IN X11 DISPLAYS.
  ;CREATE THE MENU
  cb = Widget_button(parent,value='Choose Time (ns) to Remove',/menu)
  for i=0,N_elements(vals)-1 do begin
    button = Widget_button(cb)
    theval = vals[i];+' butID='+strtrim(string(button),2)
    theuval = {object:self,method:'contextMenuEvents',id:'REMOVEFOURIERTIME',time:fourierTime[i]}
    Widget_control,button,set_value = theval
    Widget_control,button,set_uvalue=theuval
    ;set_uvalue FOR ooDisplayEcho
  endfor


  Return,parent
end;createTContext



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::swapDataObject,n_old,n_new
  ;
  ;NAME:
  ;        ooDisplayEcho::swapDataObject
  ;
  ;PURPOSE:
  ;           To swap the current data object selection with a new one and
  ;           update all of the widgets in ooDisplayEcho
  ;PARAMETERS:
  ;           n_old       not used
  ;           n_new       Ths position of the new data object in the container.
  ;KEYWORDS:
  ;           none.

  ;THE PURPOSE OF THIS METHOD IS TO PUT THE CURRENT DATA OBJECT
  ;INTO THE dataContainer AND PULL OUT THE NEXT OBJECT.
  ;    print,self.dataContainer->count(),'test'

  ;    print,'step1'
  ;    help,/heap,/brief
  ;    dummy = self.datacontainer->get(position=n_old)
  ;    self.dataContainer->remove,position=n_old
  ;    obj_destroy,dummy



  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;THIS METHOD PRODUCES A MASSIVE MEMORY LEAK EACH TIME
  ;IT IS RUN --- ~6 obj & 85 ptr on each pass!!!!
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


  ;    print,'step2'
  ;    help,/heap,/brief

  ;    self.dataContainer->add,self.ech->clone(),position=n_old


  ;    if obj_valid(self.ech) gt 1 then obj_destroy,self.ech
  ;    self.ech = (self.dataContainer->get(position=n_new))->clone()
  ;    self->setDataParameters,self.ech,n=n_new

  ;    print,'step3'
  ;    help,/heap,/brief



  ;THERE SEEMS TO BE A PROBLEM WITH THE CD CONTROLS
  ;THAT TAKES THE FILE INDEX OUT OF RANGE AND CAUSES
  ;A CRASH HERE.
  ;
  ;PROTECT AGAINST THIS FOR NOW BY VERIFYING THAT THE GIVEN INDEX IS
  ;WITHIN THE TOTAL COUNT.

  count = self.datacontainer->Count()
  if n_new le count-1 then begin
    ;120804
    ;WHAT HAPPENS HERE IF THE SELECTED N_NEW IS SAME
    ;AS OLD QCHOICEINDEX???   WHY IS setDataParameters CALLED
    ;INSTEAD OF resetDataParameters???
    self->Setdataparameters, $
      (self.datacontainer->Get(position=n_new)),n=n_new
  endif else begin
    void = Dialog_message('ATTEMPT TO ACCESS INVALID DATA OBJECT.')
    self->Setdataparameters,(self.datacontainer->Get(position=$
      count-1)),n=count-1
  endelse

  ;self->updateMaskmaker
  ;    print,'step4'
  ;    help,/heap,/brief

  self.plotzoomswitch = 0

end;swapDataObject
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::resetDataParameters,factor,nobin=nobin;timeaverage=timecheckboxval,DEEPMASKING=DEEPMASKINGcheckboxval,filename = fn
  ;
  ;NAME:
  ;        ooDisplayEcho::resetDataParameters
  ;
  ;PURPOSE:
  ;               Bin the data object and update various parameters
  ;               for the display object.
  ;PARAMETERS:
  ;               factor      THE NEW BIN FACTOR
  ;KEYWORDS:
  ;               none
  ;

  detDim=32   ;MAKE THIS DEPEND ON DETECTOR LATER
  ;WILL HAVE TO CHOOSE DETECTOR FIRST,
  ;SO PERHAPS displayEcho WILL HAVE TO CALL
  ;READ ECHO THEN DISPLAY TEMPORARY GUI
  ;TO GET INITIAL PARAMETERS FROM USER
  ;SUCH AS DETECTOR CENTER AND DETECTOR CHOICE

  if N_elements(nobin) eq 0 then nobin = 0

  if ((detDim mod factor) eq 0) then begin


    ;NEED TO ALTER THE NEXT FEW LINES TO TAKE
    ;ADVANTAGE OF THE FACT THAT EACH ECHO
    ;OBJECT KEEPS TRACK OF ITS OWN ORIGINAL
    ;SIZE AND INFORMATION (AS THEY SHOULD!!!)
    ref = (self.datacontainer->Get(position=self.qchoiceindex))

    ;        print,'Before bin:',ref->getproperty(tag='point_to_down_z')

    if nobin eq 0 then begin    ;DON'T REBIN IF A BINNING OCCURRED JUST BEFORE COMING HERE.
      ;            (self.dataContainer->get(position=self.QChoiceIndex))->bin,$
      ;                                                            factor=factor


      self->Handlebinning,factor=factor,index=self.qchoiceindex

    endif

    ;        print,'After bin:',ref->getproperty(tag='point_to_down_z')

    self.detxdim = ref->Getproperty(tag='x_dim')
    self.detydim = ref->Getproperty(tag='y_dim')

    ;RESET INDICES TO PREVENT HITTING OUTSIDE DATA MATRIX
    ;self.xindex = self.detxDim/2 & self.yindex = self.detyDim/2
    self->Updateindices,x=self.detxdim/2,y=self.detydim/2

    ;;
    ;USE emask FOR DISPLAY
    if Ptr_valid(self.mye) gt 0 then Ptr_free,self.mye
    ;        self.mye = ptr_new(*(self.ech->getProperty(tag='emask')))
    self.mye = Ptr_new(*( ref->Getproperty(tag='emask')))
    if Ptr_valid(self.ie) gt 0 then Ptr_free,self.ie
    self.ie = Ptr_new((*(self.mye))[*,0,self.ftchoiceindex])
    im = Reform(*self.ie,self.detxdim,self.detydim)
    ;REFORM 3-D ARRAY INTO
    ;2-D ARRAY BASED ON DETECTOR
    ;DIMENSIONS

    if Ptr_valid(self.im) gt 0 then Ptr_free,self.im
    self.im = Ptr_new(Double(im))
    if Ptr_valid(self.phase) gt 0 then Ptr_free,self.phase
    ;        self.phase = ptr_new(self.ech->getProperty(tag='phase'))
    ;        self.no_of_phases = self.ech->getProperty(tag='no_of_phases')
    ;        self.no_of_fourier_times = self.ech->getProperty(tag='no_of_fourier_times')

    self.phase = Ptr_new(ref->Getproperty(tag='phase'))
    self.no_of_phases = ref->Getproperty(tag='no_of_phases')
    self.no_of_fourier_times = ref->Getproperty(tag='no_of_fourier_times')


    ;        widget_control,self.atwbcx, set_value = strtrim(string(self.beamCenxOrig/factor),2)
    ;        widget_control,self.atwbcy, set_value = strtrim(string(self.beamCenyOrig/factor),2)

    ;print,'SETTING self.atwbcx & y'
    Widget_control,self.atwbcx, set_value = Strtrim(String(self.beamcenxorig),2)
    Widget_control,self.atwbcy, set_value = Strtrim(String(self.beamcenyorig),2)



  endif else begin
    Widget_control,self.atw1,get_value=atwarr
    if N_elements(atwarr) ne 5 then begin
      Widget_control,self.atw1,set_value=['1','2','4','8','16']
    endif
    ;widget_control,self.atw1,set_value='Enter a power of 2 le 16!'
    void = Dialog_message('Enter a power of 2 le 16!')
  endelse

end;resetDataParameters


pro Oodisplayecho::atlbEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::atlbEvents
  ;
  ;PURPOSE:
  ;           Handle events from the top level base of the display object.
  ;           This is mainly intended to handle resize events.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

  ;           INTERCEPT TLB RESIZE EVENTS AND RETAIN FIXED TLB SIZE.
  ;102804
  ;            widget_control,event.top,get_uvalue=uval
  ename = Tag_names(event,/structure_name)

  ;if ename ne 'WIDGET_KBRD_FOCUS' then $
  ;        print,'ooDisplayEcho::atlbEvents,eventname = ', ename

  if ename eq 'WIDGET_BASE' then begin



    case Event.id of
      self.atlb:begin
        self->Resizewidgets,Event


        Widget_control,Event.top,$
          xsize=self.atlbxsize,$
          ysize=self.atlbysize



      end;self.atlb
      self.iqtdisplaybase:begin

        ;THESE EVENTS SHOULD NEVER ARRIVE HERE.
        ;print,self.IQTDisplayBase
        ;print,event.id
        Widget_control,Event.top,$
          xsize=Event.x,$;self.atlbxsize,$
          ysize=Event.y ;self.atlbysize
        self.iqtdisplayobj->Resize,Event,xsize=Event.x,ysize=Event.y
      end
      else:begin
        Print,'ooDisplayEcho::atlbEvents event type=',Tag_names(event,/structure_name)
      end
    endcase

  endif;WIDGET_BASE

  ;021505
  ;COMMENT OUT THE NEXT CODE FOR NOW.
  ;
  ;DOES THIS METHOD AFFECT ANYTHING BUT oodisplayecho<-atlb  AND cwo_displayiqt?
  ;        widget_control,event.top,$
  ;                            xsize=self.atlbxsize,$
  ;                            ysize=self.atlbysize

  ;WHY DOES IT WORK ON PC BUT NOT ON MAC FOR cwo_displayiqt???

  ;            widget_control,event.top,xsize=800,ysize=600


  ;NEED TO HANDLE KEYBOARD EVENTS HERE SO ALL ARROW EVENTS AFFECT
  ;THE POSITION ON THE IMAGE.

  self->Draw



end;atlbEvents
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::Donothing,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::doNothing
  ;
  ;PURPOSE:
  ;               A "do nothing"  event handler.
  ;PARAMETERS:
  ;               event   The event structure.
  ;KEYWORDS:
  ;               none

end;doNothing
pro Donothing,Event
  ;
  ;NAME:
  ;        doNothing
  ;
  ;PURPOSE:
  ;           A "do nothing" method outside of the class.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none

end;doNothing
pro Oodisplayecho_event,Event
  ;
  ;NAME:
  ;        ooDisplayEcho_event
  ;
  ;PURPOSE:
  ;           Catch all events produced by the ooDisplayEcho object
  ;           and dispatch them to proper event handlers.
  ;           This is also a gate-keeper in that it catches and
  ;           blocks many events when the program has no data objects.
  ;PARAMETERS:
  ;           event   The event structure which will allow access to the
  ;                   uvalue and the object/method to call.
  ;KEYWORDS:
  ;           none


  ;THIS IS THE MAIN EVENT HANDLER FOR THE OBJECT WIDGET.
  ;WHILE THIS IS NOT A CLASS METHOD, THE FOLLOWING
  ;CODE ALLOWS ME TO CONCISELY USE CLASS METHODS TO
  ;HANDLE EVENTS FOR INDIVIDUAL WIDGETS IN THE OBJECT WIDGET.

  ;SEE ROB'S BOOK "APPLICATION DEVELOPMENT IN IDL II", p.35


  Catch, catchError
  if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho_event!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    if Widget_info(Event.Top,/valid_id) eq 0 then begin
      void = Dialog_message(/error,eMsg,title=eTitle)
    endif else begin
      void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=Event.top)
    endelse
    Catch, /cancel
    Return
  endif

  Widget_control,Event.id,get_uvalue=cmd
  Help,cmd,output=out,struct=0


  ;    print,'ooDisplayEcho_event event ='
  ;    print,tag_names(event,/structure_name)
  ;    print,tag_names(event)
  ;    print,event


  if Total(Stregex(out,'UNDEFINED',/boolean)) gt 0 then begin
    Donothing,Event
  endif else begin
    eventname = Tag_names(event,/structure_name)

    if eventname eq 'CW_PROGRESS_EVENT' then begin
      ;print,tag_names(event)
      ;print,event
    endif

    ;        if stregex(eventname,'WIDGET_BASE',/boolean) then begin

    ;print,'out=',out
    ;print,obj_valid(cmd)
    if Total(Stregex(out,'OODISPLAYECHO',/fold_case,/boolean)) gt 0 $
      and Obj_valid(cmd) gt 0 then begin
      ;           INTERCEPT TLB RESIZE EVENTS AND RETAIN FIXED TLB SIZE.
      ;102804
      ;print,out
      ;print,eventname
      case Event.id of
        cmd->Getproperty(/dw2auxbase):cmd->Resizeauxwindow,Event
        cmd->Getproperty(/imageerrorbase):cmd->Resizeimageerrorbase,Event
        cmd->Getproperty(/atlb):cmd->Atlbevents,Event
        else:
      endcase


    endif else begin
      ;            if eventname eq 'CWO_REMOVETLIST_EVENT' then begin
      ;                widget_control,event.id,get_uvalue=cmd
      ;                call_method,cmd.method,cmd.object,event
      ;
      ;            endif else begin

      ;                print,'oodisplayecho_event out = ',out
      ;                print,'oodisplayecho_event eventname = ',eventname
      container = Obj_new()
      (cmd.object)->Getcontainer,container
      count = container->Count()

      ;(cmd.object)->setproperty,state_saved = 0

      if count gt 0 then begin
        if cmd.id eq 'FILEQUIT' then begin

          ;THIS IS REDUNDANT BECAUSE OF THE SAME CALL IN ooDisplayEchoCleanup
          ;030905
          ;(cmd.object)->lastChanceToSaveSession
          Print,'QUITTING'

        endif
        Call_method,cmd.method,cmd.object,Event;cmd.id
      endif else begin
        ;IF NO DATA OBJECTS, FIGURE OUT WHAT TO DO WHEN
        ;AN EVENT SHOULD BE HANDLED.
        case cmd.id of
          'FILEOPEN':begin
            Call_method,cmd.method,cmd.object,Event
          end
          ;102605
          'FILEOPENMAGNETIC':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'FILEQUIT':begin
            ;NO SAVE PROMPT SINCE NO DATA IN THIS CASE.
            Call_method,cmd.method,cmd.object,Event
          end
          'RESTORESESSION':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'RESTOREOBJECT':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'LOADTESTDATA':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'AUTOGRAPHNSE':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'NSEDIFFRACTIONVIEWER':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'FILEPARAMETERSIMPORT':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'NSEHELP':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'MERGEMULTIPLEIQT':begin
            Call_method,cmd.method,cmd.object,Event
          end
          'SUMMULTIPLEECHOFILES':begin
            Call_method,cmd.method,cmd.object,Event
          end
          else:begin
            Donothing,Event
            ;msg = dialog_message('NO DATA AVAILABLE. OPEN A FILE OR QUIT.')
          end
        endcase;cmd.id
      endelse;OBJECT
      ;            endelse;CWO_REMOVETLIST_EVENT
    endelse;count gt 0
  endelse;stregex(out,'UNDEFINED',/boolean)

end;ooDisplayEcho_event
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;CLASS INITIALIZATION METHODS
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::setDataParameters,ech,n=n
  ;
  ;NAME:
  ;        ooDisplayEcho::setDataParameters
  ;
  ;PURPOSE:
  ;               This method sets data parameters for the ooDisplayEcho data object
  ;               during object initialization.
  ;
  ;               CALLED BY ooDisplayEcho::swapDataObjects
  ;PARAMETERS:
  ;               ech     Confusing.  This seems to be only used once below, and
  ;                       It is inconsistently used.
  ;                       Perhaps this method is never used.
  ;                       Add a message dialog below to see if it comes up during
  ;                       normal use.
  ;
  ;                       Used by swapDataObject, reDefineWidgets, CDButtonHandler
  ;
  ;KEYWORDS:
  ;               n       The data object position in the data container.

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;
  ;THIS SECTION OF init DEALS WITH THE ooEcho DATA OBJECT SPECIFICALLY.
  ;PERHAPS THIS CAN BE REDONE AS A PROCEDURE SO THAT IF I DEFINE
  ;A REBIN METHOD WITHIN displayEcho IT CAN CALL THAT TO CALL
  ;THE bin METHOD OF THE ooEcho OBJECT AND SET THE NEW PARAMETERS
  ;BOTH IN THE ooEcho OBJECT AND IN self.
  ;
  ;
  ;ALSO, THIS METHOD PROBABLY SHOULD HANDLE SWITCH
  ;FROM ONE Q VALUE TO ANOTHER.
  ;
  ;
  ;TO DO THIS, AN ECHO OBJECT CAN BE SIMPLY PASSED TO THIS
  ;PROCEDURE.  FOR EXAMPLE, IF I HAVE AN ARRAY OF ECHO
  ;OBJECTS, I CAN SIMPLE PASS THE CURRENT ELEMENT (BASED
  ;ON THE Q-SELECTION) TO THIS
  ;
  ;   (SEE resetDataParameters above)
  ;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

  ;    help,ech
  ;    help,ech[2]


  ;THE DIALOG ON THE NEXT LINE IS DISPLAYED FREQUENTLY IN RUNNING
  ;ooDisplayEcho, SO THIS METHOD IS USED.
  ;dum = dialog_message("ooDisplayEcho::setDataParameters     I don't think this is used.  LRK 01/25/05")


  ;print,'ooDisplayEcho::setDataParameters 102705'

  if (N_elements(n) eq 1) then begin
    if (self.datacontainer->Count() lt n) then begin
      Print,'NOT ENOUGH ELEMENTS IN THE DATA CONTAINER'
      n = 0
    endif else begin
      n = n
    endelse

  endif else begin
    n = 0
  endelse

  ;    if (obj_valid(self.ech) ne 0) then obj_destroy,self.ech
  ;    self.ech = (self.dataContainer->get(position = n))->clone()

  ;SET CURRENT DATA OBJECT TO THE nTH OBJECT
  if Obj_valid(self.ech) gt 1 then Obj_destroy,self.ech
  ;    self.ech = ech->clone()
  if Obj_valid(self.echorig) gt 1 then Obj_destroy,self.echorig
  ;    self.echorig = ech->clone()

  if Ptr_valid(self.detchoices) gt 0 then Ptr_free,self.detchoices
  self.detchoices = Ptr_new(['32x32','64x64','128x64','128x128'])

  if Ptr_valid(self.displaychoices) gt 0 then Ptr_free,self.displaychoices
  self.displaychoices = Ptr_new([ 'Sum(I(phase))',$
    'fit average',$
    'fit amplitude',$
    'fit phase',$
    'fit width',$
    'fit omega',$
    'fit offset'])

  ;070104
  ;CHANGE NEXT STATEMENT TO PRESERVE PREVIOUSLY CHOSE
  ;PLOTTING STATE
  ;    if self.plotIndex eq 0 or self.plotIndex eq 5 then begin
  ;        self.plotIndex = 5
  ;    endif

  self.plotupdown = 1
  self.detchoiceindex = 0
  self.ftchoiceindex = 0
  self.qchoiceindex = n

  ;WHEN SWITCHING TO MULTIPLE DATA OBJECTS THE DATA OBJECT
  ;REFERENCES ARE DYING SOMEWHERE. -- FIND THIS
  if Ptr_valid(self.ftchoices) gt 0 then Ptr_free,self.ftchoices
  self.ftchoices = Ptr_new(Indgen(ech->Getproperty(tag='no_of_fourier_times')))

  ;print,file_basename(ech->getproperty(tag='filename'))

  detDim=32   ;MAKE THIS DEPEND ON DETECTOR LATER
  ;WILL HAVE TO CHOOSE DETECTOR FIRST,
  ;SO PERHAPS displayEcho WILL HAVE TO CALL
  ;READ ECHO THEN DISPLAY TEMPORARY GUI
  ;TO GET INITIAL PARAMETERS FROM USER
  ;SUCH AS DETECTOR CENTER AND DETECTOR CHOICE

  ;    self.detxDim = self.ech->getProperty(tag='x_dim')
  ;    self.detyDim = self.ech->getProperty(tag='y_dim')

  ref = (self.datacontainer->Get(position=self.qchoiceindex))


  ;help,ref

  ;print,file_basename(ref->getproperty(tag='filename'))
  if Obj_isa(ref,'ooEchoMagnetic') gt 0 then begin
    case ref->Getproperty(tag='magnetic') of
      0:begin
        if Widget_info(self.Magneticcheckbox,/valid_id) gt 0 then begin
          Widget_control,self.magneticcheckbox,set_value=[0],sensitive=0
          ;120205
          ;                widget_control,self.magneticcheckbox,set_value=0,sensitive=0

          Widget_control,self.atwxyzupdownscale,sensitive=0
          ;                widget_control,self.atwpoint_to_up_x,sensitive=0
          ;                widget_control,self.atwpoint_to_up_y,sensitive=0
          ;                widget_control,self.atwpoint_to_up_z,sensitive=0
          ;                widget_control,self.atwpoint_to_down_x,sensitive=0
          ;                widget_control,self.atwpoint_to_down_y,sensitive=0
          ;                widget_control,self.atwpoint_to_down_z,sensitive=0
          Widget_control,self.atwpolarization,sensitive=0
          Widget_control,self.atwflippingratio,sensitive=0

          if Widget_info(self.Atweff_bpw,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw,sensitive=0
          if Widget_info(self.Atweff_bpw_x,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_x,sensitive=0
          if Widget_info(self.Atweff_bpw_y,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_y,sensitive=0
          if Widget_info(self.Atweff_bpw_z,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_z,sensitive=0

          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS_MENU')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_0_MENU')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1_MENU')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2_MENU')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3_MENU')
          Widget_control,magimageid,sensitive=0

          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_0_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICPLOT_CONTEXT')
          Widget_control,magimageid,sensitive=0
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICPLOT_MENU')
          Widget_control,magimageid,sensitive=0

        endif
      end;0
      1:begin
        if Widget_info(self.Magneticcheckbox,/valid_id) gt 0 then begin
          Widget_control,self.magneticcheckbox,set_value=[1],sensitive=0
          ;120205
          ;widget_control,self.magneticcheckbox,set_value=1,sensitive=0

          ;                widget_control,self.atwpoint_to_up_x,sensitive=0,set_value=ref->getproperty(tag='point_to_up_x')
          ;                widget_control,self.atwpoint_to_up_y,sensitive=0,set_value=ref->getproperty(tag='point_to_up_y')
          ;                widget_control,self.atwpoint_to_up_z,sensitive=0,set_value=ref->getproperty(tag='point_to_up_z')
          ;                widget_control,self.atwpoint_to_down_x,sensitive=0,set_value=ref->getproperty(tag='point_to_down_x')
          ;                widget_control,self.atwpoint_to_down_y,sensitive=0,set_value=ref->getproperty(tag='point_to_down_y')
          ;                widget_control,self.atwpoint_to_down_z,sensitive=0,set_value=ref->getproperty(tag='point_to_down_z')

          Widget_control,self.atwxyzupdownscale,sensitive=1,$
            set_value=ref->Getproperty(tag='xyzupdownscale')
          Widget_control,self.atwpolarization,sensitive=1,set_value=ref->Getproperty(tag='p')
          Widget_control,self.atwflippingratio,sensitive=1,set_value=ref->Getproperty(tag='f')

          if Widget_info(self.Atweff_bpw,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw,sensitive=1,set_value=ref->Getproperty(tag='eff_bpw')
          if Widget_info(self.Atweff_bpw_x,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_x,sensitive=1,set_value=ref->Getproperty(tag='eff_bpw_x')
          if Widget_info(self.Atweff_bpw_y,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_y,sensitive=1,set_value=ref->Getproperty(tag='eff_bpw_y')
          if Widget_info(self.Atweff_bpw_z,/valid_id) gt 0 then $
            Widget_control,self.atweff_bpw_z,sensitive=1,set_value=ref->Getproperty(tag='eff_bpw_z')




          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS_MENU')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_0_MENU')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1_MENU')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2_MENU')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3_MENU')
          Widget_control,magimageid,sensitive=1

          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICIMAGEOPTIONS_CONTEXT')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_0_CONTEXT')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_1_CONTEXT')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_2_CONTEXT')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETIC_CASE_3_CONTEXT')
          Widget_control,magimageid,sensitive=1

          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICPLOT_CONTEXT')
          Widget_control,magimageid,sensitive=1
          magimageid = Widget_info(self.atlb,find_by_uname='MAGNETICPLOT_MENU')
          Widget_control,magimageid,sensitive=1

        endif
      end;1
      else:
    endcase
  endif;obj_isa(ref,'ooEchoMagnetic')


  self.detxdim = ref->Getproperty(tag='x_dim');$
  self.detydim = ref->Getproperty(tag='y_dim');$

  if self.xindex ge self.detxdim then self.xindex = self.detxdim/2
  if self.yindex ge self.detydim then self.yindex = self.detydim/2

  self.ndataobj = self.datacontainer->Count()

  ;;
  ;USE emask FOR DISPLAY
  ;;;
  if (Ptr_valid(self.mye) gt 0) then Ptr_free,self.mye
  myemask = *(ref->Getproperty(tag='emask'))

  self.mye = Ptr_new(myemask);$

  if (Ptr_valid(self.ie) gt 0) then Ptr_free,self.ie
  self.ie = Ptr_new((*(self.mye))[*,0,self.ftchoiceindex])
  im = Reform(*self.ie,self.detxdim,self.detydim)
  ;REFORM 3-D ARRAY INTO
  ;2-D ARRAY BASED ON DETECTOR
  ;DIMENSIONS


  self.filename = ref->Getproperty(tag='filename');((self.dataContainer->get(position=self.QChoiceIndex))->getProperty(tag='filename'))
  self.comment = ref->Getproperty(tag='comment');((self.dataContainer->get(position=self.QChoiceIndex))->getProperty(tag='comment'))






  if Ptr_valid(self.im) gt 0 then Ptr_free,self.im
  self.im = Ptr_new(Double(im))

  if Ptr_valid(self.phase) gt 0 then Ptr_free,self.phase
  self.phase = Ptr_new((*((ref)->Getproperty(tag='phase'))))
  self.no_of_phases = ((ref)->Getproperty(tag='no_of_phases'))
  self.no_of_fourier_times = ((ref)->Getproperty(tag='no_of_fourier_times'))
  self.startparms = (*((ref)->Getproperty(tag='fitparms')))[0:5,$
    (self.detydim/2)*self.detxdim+self.detxdim/2,0]

  self.lambda  = ref->Getproperty(tag='lambda')
  self.dlambda = ref->Getproperty(tag='dlambda')



  ;I THINK WE WILL NEED TO GET BEAM CENTER FROM USER
  ;FOR NOW JUST SET INITIAL VALUES
  ;    self.beamCenxOrig = $
  ;        (ref)->getProperty(tag='x_cen')
  ;    self.beamCenyOrig = $
  ;        (ref)->getProperty(tag='y_cen')

  ;021005
  ;
  ;I THINK THE LINES ABOVE WERE A MISTAKE BASED ON CURRENT IMPLEMENTATION AND I AM
  ;REPLACING THEM WITH THE LINES BELOW.
  self.beamcenxorig = ref->Getproperty(tag='x_cen_orig')
  self.beamcenyorig = ref->Getproperty(tag='y_cen_orig')
end;setDataParameters

pro Oodisplayecho::setSelectDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::setSelectDialog
  ;
  ;PURPOSE:
  ;           Intended to be used to set up a dialog for adding objects to an existing set.
  ;           The set feature was not fully or correctly implemented as of today (01/25/05).
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  ;;
  ;THIS DIALOG WILL SELECT WHICH SET TO PUT THE
  ;CALLING DATA OBJECT INTO.
  ;;;

  if (self.setcontainer)->Count() gt 0 then begin

    ;WILL NEED TO SET THIS TO USE ONLY SELECT Q-VALUES LATER
    names = Sindgen(self.setcontainer->Count())
    for i=0,self.setcontainer->Count()-1 do begin
      names[i] = (self.setcontainer->Get(position=i))->Getproperty(/name)
    endfor;i
    setIndices = Indgen(self.setcontainer->Count())

    names = [names,'NO SET']


    self.setselectbase = Widget_base(group_leader = self.atlb,$
      xsize=200,ysize=400,$
      /modal,/grid_layout,$
      title='SELECT SET FOR ASSIGNMENT',$
      /base_align_right)

    subBase = Widget_base(self.setselectbase,/column)
    self.setselectlist = Widget_droplist(subBase,$
      value=names,$
      ysize=25,xsize = 190,$
      title = 'Set Choices',$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETSELECTLIST',$
      setlist:setIndices})
    okbutton = Widget_button(subbase,value='OK',$
      xsize=190,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETSELECTOKBUTTON',$
      setlist:setIndices})

    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=190,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETSELECTCANCELBUTTON',$
      setlist:setIndices})


    Widget_control,self.setselectbase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.setselectbase,$
      top:self.setselectbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.setselectbase,set_uvalue=$
      {object:self,$
      method:'listEvents',$
      id:'SSACANCELBUTTON',$
      setlist:setIndices,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.setselectbase,/no_block,$
      cleanup='setSelectBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Sets Available.')
  endelse


end;setSelectDialog
pro Setselectbasecleanup,base
  ;
  ;NAME:
  ;        setSelectBaseCleanup
  ;
  ;PURPOSE:
  ;           Clean up the data in a set selection dialog.
  ;           I expect this method is not currently used/implemented (01/25/05).
  ;
  ;PARAMETERS:
  ;           base    id of base which is being destroyed.
  ;KEYWORDS:
  ;           none

  ;CALLED WHEN [X] EVENT OCCURS.
  ;print,'selectSetDialog Cleanup'
  Widget_control,base,get_uvalue=ssa
  Call_method,ssa.method,ssa.object,ssa.event
end;setSelectBaseCleanup
pro Oodisplayecho::removeSetDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::removeSetDialog
  ;
  ;PURPOSE:
  ;           Produce dialog for removal of a set of data objects.
  ;           The "set" features are not currently used/implemented (01/25/05).
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none

  ;;
  ;THIS DIALOG WILL SELECT WHICH SET TO REMOVE
  ;
  ;
  ;IF CLONES ARE PUT INTO SETS THEN THERE IS NO
  ;REASON TO HAVE THIS METHOD.  SIMPLY DESTROY THE CLONE!!!
  ;;;

  if (self.setcontainer)->Count() gt 0 then begin

    ;WILL NEED TO SET THIS TO USE ONLY SELECT Q-VALUES LATER
    names = Sindgen(self.setcontainer->Count())
    for i=0,self.setcontainer->Count()-1 do begin
      names[i] = (self.setcontainer->Get(position=i))->Getproperty(/name)
    endfor;i
    setIndices = Indgen(self.setcontainer->Count())


    self.removesetbase = Widget_base(group_leader = self.atlb,$
      xsize=200,ysize=400,$
      /modal,/grid_layout,$
      title='SELECT SET FOR REMOVAL',$
      /base_align_right)

    subBase = Widget_base(self.removesetbase,/column)
    self.removesetlist = Widget_droplist(subBase,$
      value=names,$
      ysize=25,xsize = 190,$
      title = 'Set Choices',$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETREMOVELIST',$
      setlist:setIndices})
    okbutton = Widget_button(subbase,value='OK',$
      xsize=190,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETREMOVEOKBUTTON',$
      setlist:setIndices})

    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=190,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'SETREMOVECANCELBUTTON',$
      setlist:setIndices})


    Widget_control,self.removesetbase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.setselectbase,$
      top:self.setselectbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.setselectbase,set_uvalue=$
      {object:self,$
      method:'listEvents',$
      id:'SSACANCELBUTTON',$
      setlist:setIndices,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.setselectbase,/no_block,$
      cleanup='setSelectBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Sets Available.')
  endelse


end;removeSetDialog
pro Removesetbasecleanup,base
  ;
  ;NAME:
  ;        removeSetBaseCleanup
  ;
  ;PURPOSE:
  ;           Clean up a remove set dialog.
  ;           Not currently used/implemented (01/25/05)
  ;PARAMETERS:
  ;           base    Widget id of the base for cleanup.
  ;KEYWORDS:
  ;           none

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'removeSetDialog Cleanup'
  Widget_control,base,get_uvalue=ssa
  Call_method,ssa.method,ssa.object,ssa.event
end;removeSetBaseCleanup
pro Oodisplayecho::setNameEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::setNameEvents
  ;
  ;PURPOSE:
  ;           Apply a name to a "set" of data objects.
  ;PARAMETERS:
  ;           event   The event structure being handled.
  ;KEYWORDS:
  ;           none

  ;HANDLE EVENT FOR THE setNameDialog
  Widget_control,Event.id,get_uvalue=obj
  Print,"Set Name Event Occurred."
  ;print,obj.id
  ;print,obj.index
  case obj.id of
    'SETNAMEFIELD':begin
      ;print,'THIS EVENT OCCURRED!!!'
      ;SET NEW NAME OF A SET
      Widget_control,self.setnamefield,$
        get_value=newName,$
        get_uvalue=uval
      ;print,newName
      ;print,uval.index
      index = uval.index
      if index lt (self.setcontainer)->Count() then $
        begin
        theSetRef = $
          (self.setcontainer)->Get(position=index)
        theSetRef->Setproperty,name=newName
        self->Redefinetree
      endif

    end
    'SETNAMEOKBUTTON':begin
      ;SET NEW NAME OF A SET
      Widget_control,self.setnamefield,$
        get_value=newName,$
        get_uvalue=uval
      ;widget_control,self.setNameField,get_uvalue=uval
      index = uval.index

      if index lt (self.setcontainer)->Count() then begin
        theSetRef = $
          (self.setcontainer)->Get(position=index)
        theSetRef->Setproperty,name=newName
      endif
      Widget_control,self.setnamebase,/destroy
      self->Redefinetree
    end;SETNAMEOKBUTTON
    'SETNAMECANCELBUTTON':begin
      Widget_control,self.setnamebase,/destroy
    end;SETNAMECANCELBUTTON
    else:begin
      Widget_control,self.tw1,set_value=obj.id+': unsure of widget choice.'
    end
  endcase
end;setNameEvents


pro Oodisplayecho::setNameDialog,index
  ;
  ;NAME:
  ;        ooDisplayEcho::setNameDialog
  ;
  ;PURPOSE:
  ;           A dialog for setting the name of a "set" of data objects.
  ;PARAMETERS:
  ;           index   Index of the "set" object in the setContainer.
  ;KEYWORDS:
  ;           none

  ;;
  ;THIS DIALOG WILL ALLOW THE USER TO CHANGE THE
  ;NAME OF A SELECTED SET TO SOMETHING MEANINGFUL.
  ;;;


  ;DO I GET INDEX HERE OR IN CONTEXT EVENT HANDLER????

  if (self.setcontainer)->Count() gt index then begin

    setRef = self.setcontainer->Get(position=index)

    nameOrig = setRef->Getproperty(/name)

    self.setnamebase = Widget_base(group_leader = self.atlb,$
      xsize=350,ysize=200,$
      /modal,/grid_layout,$
      title='CHANGE NAME OF SET',$
      /base_align_right)

    subBase = Widget_base(self.setnamebase,/column)
    self.setnamefield = Cw_field(subBase,$
      /return_events,$
      value=nameOrig,$
      xsize = 40,$
      ysize = 1,$
      title = 'Set name = ',$
      uvalue = {object:self,$
      method:'setNameEvents',$
      id:'SETNAMEFIELD',$
      index:index})

    okbutton = Widget_button(subbase,value='OK',$
      xsize=20,ysize=40,$
      uvalue = {object:self,$
      method:'setNameEvents',$
      id:'SETNAMEOKBUTTON',$
      index:index})

    cancelButton = Widget_button(subBase,$
      value = 'Cancel',$
      xsize=20,ysize=40,$
      uvalue = {object:self,$
      method:'setNameEvents',$
      id:'SETNAMECANCELBUTTON',$
      index:index})


    Widget_control,self.setnamebase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_name,$
      id:self.setnamebase,$
      top:self.setnamebase,$
      handler:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.setnamebase,set_uvalue=$
      {object:self,$
      method:'setNameEvents',$
      id:'SETNAMECANCELBUTTON',$
      index:index,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.setnamebase,/no_block,$
      cleanup='setNameBaseCleanup'

  endif else begin
    void = widget_message('Selcted Set Not Available.')
  endelse


end;setNameDialog
pro Setnamebasecleanup,base
  ;
  ;NAME:
  ;        setNameBaseCleanup
  ;
  ;PURPOSE:
  ;           Cleanup routine for the dialog for naming a "set" of data objects.
  ;PARAMETERS:
  ;           base    The widget id of the base to clean up.
  ;KEYWORDS:
  ;           none

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'setNameDialog Cleanup'
  Widget_control,base,get_uvalue=sn
  Call_method,sn.method,sn.object,sn.event
end;setNameBaseCleanup




pro Oodisplayecho::CalculateIQTDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::CalculateIQTDialog
  ;
  ;PURPOSE:
  ;           Provide a dialog for beginning the calculation of I(Q,t).
  ;           This allows the user to select the sample, cell and resolution data
  ;           objects to use in the calculation.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;THIS DIALOG WILL BE USED TO SELECT THE DATA
  ;OBJECTS USED TO CALCULATE I(Q,t) FOR THE
  ;SELECTED SET OF OBJECTS.
  ;
  ;THIS DIALOG IS CALLED BY THE menuEvents METHOD
  ;
  ;THE RESULTING DATA WILL BE STORED IN THE
  ;S VARIABLE IN THE 'data' TYPE OBJECT
  ;;;

  ;;
  ;
  ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
  ;
  ;;;

  theBkgList = ['']
  theDatList = ['']
  theResList = ['']
  bkgIndexList = [0]
  datIndexList = [0]
  resIndexList = [0]
  refo = (self.datacontainer->Get(position=self.qchoiceindex))
  for i = 0,self.datacontainer->Count()-1 do begin
    ;GET LIST OF DATA FILES WITH THE CORRECT SIZE
    refi = self.datacontainer->Get(position=i)
    if (refo->Matches(refi) $
      ) $;and (i ne self.QChoiceIndex))$
      then begin
      type = refi->Getproperty(tag='type')
      ;self.QChoiceIndex))->getProperty(tag='type')

      ;print,type
      case type of
        0:begin;untyped
          if (i eq self.qchoiceindex) then begin
            theBkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            bkgIndexList[0] = i
            theBkgList = ['',theBkgList]
            bkgIndexList = [0,bkgIndexList]
            theDatList[0] = File_basename(refi->Getproperty(tag='filename'))
            datIndexList[0] = i
            theDatList = ['',theDatList]
            datIndexList = [0,datIndexList]
            theResList[0] = File_basename(refi->Getproperty(tag='filename'))
            resIndexList[0] = i
            theResList = ['',theResList]
            resIndexList = [0,resIndexList]
          endif else begin
            theBkgList = $
              [theBkgList,File_basename(refi->Getproperty(tag='filename'))]
            bkgIndexList = [bkgIndexList,i]
            theDatList = $
              [theDatList,File_basename(refi->Getproperty(tag='filename'))]
            datIndexList = [datIndexList,i]
            theResList = $
              [theResList,File_basename(refi->Getproperty(tag='filename'))]
            resIndexList = [resIndexList,i]
          endelse
        end;0
        1:begin;resolution
          if i eq self.qchoiceindex then begin
            theResList[0] = File_basename(refi->Getproperty(tag='filename'))
            resIndexList[0] = i
            theResList = ['',theResList]
            resIndexList = [0,resIndexList]
          endif else begin
            theResList = $
              [theResList,File_basename(refi->Getproperty(tag='filename'))]
            resIndexList = [resIndexList,i]
          endelse
        end;1
        2:begin;data
          if i eq self.qchoiceindex then begin
            theDatList[0] = File_basename(refi->Getproperty(tag='filename'))
            datIndexList[0] = i
            theDatList = ['',theDatList]
            datIndexList = [0,datIndexList]
          endif else begin
            theDatList = $
              [theDatList,File_basename(refi->Getproperty(tag='filename'))]
            datIndexList = [datIndexList,i]
          endelse
        end;2
        3:begin;background
          if i eq self.qchoiceindex then begin
            theBkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            bkgIndexList[0] = i
            theBkgList = ['',theBkgList]
            bkgIndexList = [0,bkgIndexList]
          endif else begin
            theBkgList = $
              [theBkgList,File_basename(refi->Getproperty(tag='filename'))]
            bkgIndexList = [bkgIndexList,i]
          endelse
        end;3
      endcase;type
    endif;match
  endfor;i

  ;ADD OPTIONS FOR NO FILE IN EACH OF THESE
  theResList = [theResList,'None']
  resIndexList = [resIndexList,9999]
  theBkgList = [theBkgList,'None']
  bkgIndexList = [bkgIndexList,9999]
  ;theDatList = [theDatList,'None']


  ;CREATE DIALOG
  if N_elements(theDatList) gt 1 then begin
    theDatList = theDatList[1:*]
    datIndexList = datIndexList[1:*]

    if !version.os eq 'Win32' then begin
      basexsize = 230
      baseysize = 320
    endif else begin
      basexsize=330
      baseysize=400
    endelse

    ;021406
    ;ELIMINATE THE SIZE RESTRICTION HERE.
    self.iqtimportbase = Widget_base(group_leader = self.atlb,/row,$
      $;xsize=basexsize,ysize=baseysize,$
      /modal,$;/grid_layout,$
      title='SELECT DATA FOR I(Q,t) Calculation',$
      /base_align_right)

    subBase = Widget_base(self.iqtimportbase,/column)
    self.datimportlist = Widget_droplist(subBase,$
      value=theDatList,$
      ysize=25,xsize = 220,$
      title = 'Sample Choices',$;'Data Set Choices',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      $;method:'listEvents',$
      id:'DATIMPORTLIST',$
      list:datIndexList})

    ;IF THESE HAVE ZERO ELEMENTS THEN
    ;self.resImportList WILL BE A MESSAGE, NOT A LIST
    if N_elements(theResList) gt 0 then begin
      theResList = theResList[1:*]
      ResIndexList = resIndexList[1:*]
      self.resimportlist = Widget_droplist(subBase,$
        value=theResList,$
        ysize=25,xsize = 220,$
        title = 'Resolution Choices',$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'RESIMPORTLIST',$
        list:resIndexList})
    endif else begin
      self.resimportlist = Widget_label(subBase,$
        value='No Resolution Set Available!')
    endelse
    ;IF THESE HAVE ZERO ELEMENTS THEN
    ;self.bkgImportList WILL BE A MESSAGE, NOT A LIST
    if N_elements(theBkgList) gt 0 then begin
      theBkgList = theBkgList[1:*]
      bkgIndexList = bkgIndexList[1:*]


      self.bkgimportlist = Widget_droplist(subBase,$
        value=theBkgList,$
        ysize=25,xsize = 220,$
        title = 'Cell Choices',$;'Background Choices',$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'BKGIMPORTLIST',$
        list:bkgIndexList})
    endif else begin
      self.bkgimportlist = Widget_label(subBase,$
        value='No Background Set Available!')
    endelse


    narcs = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='narcs')
    sampletransmission = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='transmission')
    samplevolumefraction = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='volfrac')
    if bkgIndexList[0] ne 9999 then begin
      celltransmission = (self.datacontainer->Get(position=bkgIndexList[0]))->Getproperty(tag='transmission')
    endif else begin
      celltransmission = 1.0
    endelse

    arcsfield = Cw_field(subbase,value=narcs,xsize=8,/return_events,$
      /integer,title='Number of Q Arcs',/row,$
      uname='IQTARCSFIELD',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'IQTARCSFIELD',$
      list:datIndexList})



    samtrans = Cw_field(subbase,value=sampletransmission,xsize=8,$
      /floating,title='Sample Trans',/row,$
      uname='SAMPLETRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'SAMPLETRANSMISSION',$
      list:datIndexList})

    samvolfrac = Cw_field(subbase,value=samplevolumefraction,xsize=8,$
      /floating,title='Sample Volfrac',/row,$
      uname='SAMPLEVOLUMEFRACTION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'SAMPLEVOLUMEFRACTION',$
      list:datIndexList})

    celltrans = Cw_field(subbase,value=celltransmission,xsize=8,$
      /floating,title='Cell Trans',/row,$
      uname='CELLTRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'CELLTRANSMISSION',$
      list:bkgIndexList})

    ECHOAVERAGENORMLABEL     = Widget_label(subbase,$
      value='Next option for G. Ehlers. NOTE: EB Calculated using usual normalization.')
    ECHOAVERAGENORMALIZATION = Cw_bgroup(subbase,$
      'Use Echo Average for Normalization',$
      /row, /nonexclusive,$
      set_value=0,$
      uname='ECHOAVERAGENORMALIZATION',$
      uvalue={object:self,$
      method:'IQTDialogEvents',$
      id:'ECHOAVERAGENORMALIZATION'})
    ECHOWRITETESTOUTPUTFILE = Cw_bgroup(subbase,$
      'WRITE TEST OUTPUT FILE',$
      /row, /nonexclusive,$
      set_value=0,$
      uname='ECHOWRITETESTOUTPUTFILE',$
      uvalue={object:self,$
      method:'IQTDialogEvents',$
      id:'ECHOWRITETESTOUTPUTFILE'})



    if (N_elements(theResList) gt 0) and $
      (N_elements(theBkgList) gt 0) then begin
      okButton = Widget_button(subBase,value = 'OK',$
        xsize=230,ysize=50,$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'IQTOKBUTTON',$
        bkglist:bkgIndexList,$
        datlist:datIndexList,$
        reslist:resIndexList})
    endif else begin
      okButton = Widget_button(subBase,value = 'NOT OK',$
        xsize=230,ysize=50,$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'IQTCANCELBUTTON',$
        list:bkgIndexList})
    endelse

    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=230,ysize=50,$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      $;method:'listEvents',$
      id:'IQTCANCELBUTTON',$
      list:bkgIndexList})

    Widget_control,self.iqtimportbase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.iqtimportbase,$
      top:self.iqtimportbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.iqtimportbase,set_uvalue=$
      {object:self,$
      method:'listEvents',$
      id:'IQTCANCELBUTTON',$
      bkglist:bkgIndexList,$
      datlist:datIndexList,$
      reslist:resIndexList,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.iqtimportbase,/no_block,$
      cleanup='CalculateIQTBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Data Objects.')
  endelse

  ;041504

end;CalculateIQTDialog
pro Oodisplayecho::IQTDialogEvents,Event
  ;
  ;NAME:
  ;        IQTDialogEvents
  ;
  ;PURPOSE:
  ;           Handle events for the CalculateIQT dialog.
  ;           This will take over events handled in listEvents.
  ;
  ;PARAMETERS:
  ;           event    The event to handle
  ;KEYWORDS:
  ;           none
  ;


  Widget_control,Event.id,get_uvalue=obj

  case obj.id of
    'IQTOKBUTTON':begin

      ;GET OBJECTS FROM WIDGET SELECTIONS AND
      ;CALCULATE I(Q,t)
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      bkgIndexList = iqt.bkglist
      datIndexList = iqt.datlist
      resIndexList = iqt.reslist
      resbkgIndexList = iqt.resbkglist

      bkgIndex=Widget_info(self.bkgimportlist,$
        /droplist_select)
      datIndex=Widget_info(self.datimportlist,$
        /droplist_select)
      resIndex=Widget_info(self.resimportlist,$
        /droplist_select)
      resbkgIndex=Widget_info(self.resbkgimportlist,$
        /droplist_select)



      ;GET NUMERICAL VALUES FROM FIELDS
      arcsf = Widget_info(self.iqtimportbase,find_by_uname='IQTARCSFIELD')
      samtrans = Widget_info(self.iqtimportbase,find_by_uname='SAMPLETRANSMISSION')
      samvolfrac = Widget_info(self.iqtimportbase,find_by_uname='SAMPLEVOLUMEFRACTION')
      celtrans = Widget_info(self.iqtimportbase,find_by_uname='CELLTRANSMISSION')

      restrans = Widget_info(self.iqtimportbase,find_by_uname='RESTRANSMISSION')
      resvolfrac = Widget_info(self.iqtimportbase,find_by_uname='RESVOLUMEFRACTION')
      resbkgtrans = Widget_info(self.iqtimportbase,find_by_uname='RESBKGTRANSMISSION')
      echoAverageOption = Widget_info(self.iqtimportbase,find_by_uname='ECHOAVERAGENORMALIZATION')
      echoTestOutputFileOption = Widget_info(self.iqtimportbase,find_by_uname='ECHOWRITETESTOUTPUTFILE')


      Widget_control,arcsf,get_value=narcs
      Widget_control,samtrans,get_value=sampletrans
      Widget_control,samvolfrac,get_value=samplevolfrac
      Widget_control,celtrans,get_value=celltrans
      Widget_control,restrans,get_value=restrans
      Widget_control,resvolfrac,get_value=resvolfrac
      Widget_control,resbkgtrans,get_value=resbkgtrans
      if echoAverageOption ne 0L then begin
        Widget_control,echoAverageOption,get_value=echoAverageOpt
      endif else begin
        echoAverageOpt = 0
      endelse
      if echoTestOutputFileOption ne 0L then begin
        Widget_control,echoTestOutputFileOption,get_value=echoTestOutputFileOpt
      endif else begin
        echoTestOutputFileOpt = 0
      endelse

      ;print,sampletrans

      ;072005
      ;                        if narcs le 1 then begin
      ;                            void = dialog_message('narcs too small, setting to 2.')
      ;                            narcs = 2
      ;                        endif
      if narcs lt 1 then begin
        void = Dialog_message('narcs too small, setting to 1.')
        narcs = 1
      endif
      if narcs gt 16 then begin
        void = Dialog_message('narcs too big, setting to 16.')
        narcs = 16
      endif



      ;GET OBJECTS AND APPLY THE TRANSMISSION AND VOLFRAC VALUES
      nbkg=bkgIndexList[bkgIndex]
      ndat=datIndexList[datIndex]
      nres=resIndexList[resIndex]
      nresbkg=resbkgIndexList[resbkgIndex]

      ;042105
      ;
      self.qchoiceindex = ndat
      m=self.qchoiceindex


      ;print,nbkg, ndat,nres
      objDat = ((self.datacontainer)->Get(position=m))
      objDat->Setproperty,'transmission',sampletrans
      objDat->Setproperty,'volfrac',samplevolfrac
      objDat->Setproperty,'narcs',narcs
      ;objDat = ((self.dataContainer)->get(position=ndat))
      if nbkg ne 9999 then begin
        objBkg = ((self.datacontainer)->Get(position=nbkg))
        objBkg->Setproperty,'transmission',celltrans
        objBkg->Setproperty,'narcs',narcs
      endif else begin
        ;objBkg = 0L
      endelse
      if nres ne 9999 then begin
        objRes = ((self.datacontainer)->Get(position=nres))
        objRes->Setproperty,'narcs',narcs
        objRes->Setproperty,'transmission',restrans
        objRes->Setproperty,'volfrac',resvolfrac
      endif else begin
      endelse
      if nresbkg ne 9999 then begin
        objresBkg = ((self.datacontainer)->Get(position=nresbkg))
        objresBkg->Setproperty,'transmission',resbkgtrans
        objresBkg->Setproperty,'narcs',narcs
      endif else begin
        ;objBkg = 0L
      endelse


      ;                            sampletransmission = ref->getProperty(tag='transmission')
      ;                            samplevolumefraction = ref->getProperty(tag='volfrac')

      Widget_control,self.iqtimportbase,/destroy

      ;                        objDat->CalculateIQT,bkgObj = objBkg,$
      ;                                             resObj = objRes,$
      ;                                             datObj = objDat
      daveTool = Self.davetool
      daveTool->Getproperty,DAVE_MAJOR_VERSION=MajVer,DAVE_MINOR_VERSION=MinVer
      daveVer = strtrim(string(MajVer),2)+'.'+strtrim(string(MinVer),2)
      objDat->Calculateiqt2,bkgObj = objBkg,$
        daveVer=daveVer, $
        resObj = objRes,$
        datObj = objDat,$
        resbkgobj=objresbkg,$
        fitParBuf=fitParBuf, $
        echoAverageOpt = echoAverageOpt

      ;
      ;032405
      ;MOVE THIS STATEMENT TO JUST BEFORE THE CALCULATION
      ;                        widget_control,self.IQTImportBase,/destroy

      ;080604
      ;WHY DOES THIS NEED ALL OF THE OBJECTS????
      ;DOES IT PUT THE RESULT INTO ALL OF THE
      ;INVOLVED OBJECTS? --- YES, THAT IS THE REASON.
      ;                        objDat->sumQArcs,bkgObj = objBkg,$
      ;                                         resObj = objRes,$
      ;                                         datObj = objDat
      ;
      ;LRK - 08/12/09
      ;
      ;ADD OPTION TO WRITE DATA TO FILE FOR USER TESTING.
      objDat->Sumqarcs,bkgObj = objBkg,$
        resObj = objRes,$
        datObj = objDat,$
        fitParBuf=fitParBuf, $
        writefile=echoTestOutputFileOpt




      iqtresult = *(objdat->Getproperty(tag='IQT'))
      siqtresult = *(objdat->Getproperty(tag='sIQT'))
      ;print,'ooDisplayEcho::IQTDialogEvents   iqtresult[0]=',iqtresult[0]

      ;NOW SHOULD SIMPLY DISPLAY THE
      ;I(Q,t) CURVE WITH A CALL LIKE
      ;

      ;displayIQT,

      ;110906 CHANGE THE NEXT LINE BELOW
      ;                        self->displayIQT,self.QChoiceIndex

      self->Displayiqt_new,self.qchoiceindex

    end;IQTOKBUTTON
    'IQTCANCELBUTTON':begin
      Widget_control,self.iqtimportbase,/destroy
    end
    'IQTIMPORTLIST':begin
      ;THIS METHOD SHOULD BE UNNECESSARY
      Widget_control,Event.id,get_value=list
    end
    'DATIMPORTLIST':begin
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      trans = Widget_info(self.iqtimportbase,find_by_uname='SAMPLETRANSMISSION')
      volfrac = Widget_info(self.iqtimportbase,find_by_uname='SAMPLEVOLUMEFRACTION')
      datIndex=Widget_info(self.datimportlist,$
        /droplist_select)


      datIndexList = iqt.datlist

      datIndex=Widget_info(self.datimportlist,$
        /droplist_select)
      ndat=datIndexList[datIndex]
      ref = (self.datacontainer->Get(position=ndat))
      sampletransmission = ref->Getproperty(tag='transmission')
      samplevolumefraction = ref->Getproperty(tag='volfrac')

      Widget_control,trans,set_value=sampletransmission
      Widget_control,volfrac,set_value=samplevolumefraction
    end
    'RESIMPORTLIST':begin
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      trans = Widget_info(self.iqtimportbase,find_by_uname='RESTRANSMISSION')
      volfrac = Widget_info(self.iqtimportbase,find_by_uname='RESVOLUMEFRACTION')


      resIndex=Widget_info(self.resimportlist,$
        /droplist_select)


      resIndexList = iqt.reslist

      resIndex=Widget_info(self.resimportlist,$
        /droplist_select)
      nres=resIndexList[resIndex]
      if nres ne 9999 then begin
        ref = (self.datacontainer->Get(position=nres))
        restransmission = ref->Getproperty(tag='transmission')
        resvolumefraction = ref->Getproperty(tag='volfrac')
        Widget_control,trans,set_value=restransmission
        Widget_control,volfrac,set_value=resvolumefraction

      endif else begin
        Widget_control,trans,set_value=Double('Nan')
      endelse
    end
    'BKGIMPORTLIST':begin
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      trans = Widget_info(self.iqtimportbase,find_by_uname='CELLTRANSMISSION')
      bkgIndex=Widget_info(self.bkgimportlist,$
        /droplist_select)


      bkgIndexList = iqt.bkglist

      bkgIndex=Widget_info(self.bkgimportlist,$
        /droplist_select)
      nbkg=bkgIndexList[bkgIndex]
      if nbkg ne 9999 then begin
        ref = (self.datacontainer->Get(position=nbkg))
        celltransmission = ref->Getproperty(tag='transmission')
        Widget_control,trans,set_value=celltransmission
      endif else begin
        Widget_control,trans,set_value=Double('Nan')
      endelse
    end
    'RESBKGIMPORTLIST':begin
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      trans = Widget_info(self.iqtimportbase,find_by_uname='RESBKGTRANSMISSION')
      resbkgIndex=Widget_info(self.resbkgimportlist,$
        /droplist_select)


      resbkgIndexList = iqt.resbkglist

      resbkgIndex=Widget_info(self.resbkgimportlist,$
        /droplist_select)
      nresbkg=resbkgIndexList[resbkgIndex]
      if nresbkg ne 9999 then begin
        ref = (self.datacontainer->Get(position=nresbkg))
        resbkgtransmission = ref->Getproperty(tag='transmission')
        Widget_control,trans,set_value=resbkgtransmission
      endif else begin
        Widget_control,trans,set_value=Double('Nan')
      endelse
    end

    'IQTARCSFIELD':begin
      Widget_control,self.iqtimportbase,$
        get_uvalue=iqt

      arcsf = Widget_info(self.iqtimportbase,find_by_uname='IQTARCSFIELD')
      Widget_control,arcsf,get_value=narcs
      if narcs lt 1 then narcs = 1
      if narcs gt 16 then narcs = 16
      Widget_control,arcsf,set_value=narcs
    end
    'ECHOAVERAGENORMALIZATION':begin
    end
    else:begin
      Print,'UNKNOWN EVENT AT IQTImportEvents'
    end
  endcase


end;IQTImportEvents

pro Oodisplayecho::CalculateIQTDialog2
  ;
  ;NAME:
  ;        ooDisplayEcho::CalculateIQTDialog2
  ;
  ;PURPOSE:
  ;           Provide a dialog for beginning the calculation of I(Q,t).
  ;           This allows the user to select the sample, cell and resolution data
  ;           objects to use in the calculation.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;THIS DIALOG WILL BE USED TO SELECT THE DATA
  ;OBJECTS USED TO CALCULATE I(Q,t) FOR THE
  ;SELECTED SET OF OBJECTS.
  ;
  ;THIS DIALOG IS CALLED BY THE menuEvents METHOD
  ;
  ;THE RESULTING DATA WILL BE STORED IN THE
  ;S VARIABLE IN THE 'data' TYPE OBJECT
  ;;;

  ;;
  ;
  ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
  ;
  ;;;

  theBkgList = ['']
  theDatList = ['']
  theResList = ['']
  theResBkgList = ['']
  bkgIndexList = [0]
  datIndexList = [0]
  resIndexList = [0]
  resbkgIndexList = [0]
  refo = (self.datacontainer->Get(position=self.qchoiceindex))
  for i = 0,self.datacontainer->Count()-1 do begin
    ;GET LIST OF DATA FILES WITH THE CORRECT SIZE
    refi = self.datacontainer->Get(position=i)
    if (refo->Matches(refi) $
      ) $;and (i ne self.QChoiceIndex))$
      then begin
      type = refi->Getproperty(tag='type')
      ;self.QChoiceIndex))->getProperty(tag='type')

      ;print,type
      case type of
        0:begin;untyped
          if (i eq self.qchoiceindex) then begin
            theBkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            bkgIndexList[0] = i
            theBkgList = ['',theBkgList]
            bkgIndexList = [0,bkgIndexList]
            theDatList[0] = File_basename(refi->Getproperty(tag='filename'))
            datIndexList[0] = i
            theDatList = ['',theDatList]
            datIndexList = [0,datIndexList]
            theResList[0] = File_basename(refi->Getproperty(tag='filename'))
            resIndexList[0] = i
            theResList = ['',theResList]
            resIndexList = [0,resIndexList]

            theResbkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            resbkgIndexList[0] = i
            theResbkgList = ['',theResbkgList]
            resbkgIndexList = [0,resbkgIndexList]
          endif else begin
            theBkgList = $
              [theBkgList,File_basename(refi->Getproperty(tag='filename'))]
            bkgIndexList = [bkgIndexList,i]
            theDatList = $
              [theDatList,File_basename(refi->Getproperty(tag='filename'))]
            datIndexList = [datIndexList,i]
            theResList = $
              [theResList,File_basename(refi->Getproperty(tag='filename'))]
            resIndexList = [resIndexList,i]

            theResBkgList = $
              [theResBkgList,File_basename(refi->Getproperty(tag='filename'))]
            resBkgIndexList = [resBkgIndexList,i]
          endelse
        end;0
        1:begin;resolution
          if i eq self.qchoiceindex then begin
            theResList[0] = File_basename(refi->Getproperty(tag='filename'))
            resIndexList[0] = i
            theResList = ['',theResList]
            resIndexList = [0,resIndexList]
          endif else begin
            theResList = $
              [theResList,File_basename(refi->Getproperty(tag='filename'))]
            resIndexList = [resIndexList,i]
          endelse
        end;1
        2:begin;data
          if i eq self.qchoiceindex then begin
            theDatList[0] = File_basename(refi->Getproperty(tag='filename'))
            datIndexList[0] = i
            theDatList = ['',theDatList]
            datIndexList = [0,datIndexList]
          endif else begin
            theDatList = $
              [theDatList,File_basename(refi->Getproperty(tag='filename'))]
            datIndexList = [datIndexList,i]
          endelse
        end;2
        3:begin;background
          if i eq self.qchoiceindex then begin
            theBkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            bkgIndexList[0] = i
            theBkgList = ['',theBkgList]
            bkgIndexList = [0,bkgIndexList]

            theResBkgList[0] = File_basename(refi->Getproperty(tag='filename'))
            resbkgIndexList[0] = i
            theResBkgList = ['',theResBkgList]
            resbkgIndexList = [0,resbkgIndexList]

          endif else begin
            theBkgList = $
              [theBkgList,File_basename(refi->Getproperty(tag='filename'))]
            bkgIndexList = [bkgIndexList,i]
            theResBkgList = $
              [theResBkgList,File_basename(refi->Getproperty(tag='filename'))]
            resbkgIndexList = [resbkgIndexList,i]
          endelse
        end;3
      endcase;type
    endif;match
  endfor;i

  ;ADD OPTIONS FOR NO FILE IN EACH OF THESE
  theResList = [theResList,'None']
  resIndexList = [resIndexList,9999]
  theBkgList = [theBkgList,'None']
  bkgIndexList = [bkgIndexList,9999]
  theResBkgList = [theResBkgList,'None']
  resbkgIndexList = [resbkgIndexList,9999]
  ;theDatList = [theDatList,'None']


  ;CREATE DIALOG
  if N_elements(theDatList) gt 1 then begin
    theDatList = theDatList[1:*]
    datIndexList = datIndexList[1:*]

    if !version.os eq 'Win32' then begin
      basexsize = 230
      baseysize = 320
    endif else begin
      basexsize=330
      baseysize=400
    endelse

    ;021406
    ;ELIMINATE THE SIZE RESTRICTION HERE.
    self.iqtimportbase = Widget_base(group_leader = self.atlb,/col,$
      $;xsize=basexsize,ysize=baseysize,$
      /modal,$;/grid_layout,$
      title='SELECT DATA FOR I(Q,t) Calculation',$
      /base_align_left)

    subBase0 = Widget_base(self.iqtimportbase,/column,/frame)
    subBase1 = Widget_base(self.iqtimportbase,/column,/frame)
    subBase2 = Widget_base(self.iqtimportbase,/column,/frame,/base_align_left)
    subBase3 = Widget_base(self.iqtimportbase,/column,/frame)
    
    t1 = 'Sample Choices    '
    t2 = 'Resolution Choices'
    t3 = 'Cell Choices      '
    t4 = 'ResCell Choices   '
    self.datimportlist = Widget_droplist(subBase0,$
      value=theDatList,$
;      ysize=25,xsize = 220,$
      title = t1,$;'Data Set Choices',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      $;method:'listEvents',$
      id:'DATIMPORTLIST',$
      list:datIndexList})

    ;IF THESE HAVE ZERO ELEMENTS THEN
    ;self.resImportList WILL BE A MESSAGE, NOT A LIST
    if N_elements(theResList) gt 0 then begin
      theResList = theResList[1:*]
      ResIndexList = resIndexList[1:*]
      self.resimportlist = Widget_droplist(subBase0,$
        value=theResList,$
;        ysize=25,xsize = 220,$
        title = t2,$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'RESIMPORTLIST',$
        list:resIndexList})
    endif else begin
      self.resimportlist = Widget_label(subBase0,$
        value='No Resolution Set Available!')
    endelse
    ;IF THESE HAVE ZERO ELEMENTS THEN
    ;self.bkgImportList WILL BE A MESSAGE, NOT A LIST
    if N_elements(theBkgList) gt 0 then begin
      theBkgList = theBkgList[1:*]
      bkgIndexList = bkgIndexList[1:*]


      self.bkgimportlist = Widget_droplist(subBase0,$
        value=theBkgList,$
;        ysize=25,xsize = 220,$
        title = t3,$;'Background Choices',$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'BKGIMPORTLIST',$
        list:bkgIndexList})
    endif else begin
      self.bkgimportlist = Widget_label(subBase0,$
        value='No Background Set Available!')
    endelse

    if N_elements(theresBkgList) gt 0 then begin
      theresBkgList = theresBkgList[1:*]
      resbkgIndexList = resbkgIndexList[1:*]


      self.resbkgimportlist = Widget_droplist(subBase0,$
        value=theresBkgList,$
;        ysize=25,xsize = 220,$
        title = t4,$;'Background Choices',$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'RESBKGIMPORTLIST',$
        list:resbkgIndexList})
      Widget_control,self.resbkgimportlist,set_droplist_select=N_elements(theresBkglist)-1

    endif else begin
      self.resbkgimportlist = Widget_label(subBase0,$
        value='No Background Set Available!')
    endelse


    narcs = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='narcs')
    sampletransmission = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='transmission')
    samplevolumefraction = (self.datacontainer->Get(position=datIndexList[0]))->Getproperty(tag='volfrac')
    if bkgIndexList[0] ne 9999 then begin
      celltransmission = (self.datacontainer->Get(position=bkgIndexList[0]))->Getproperty(tag='transmission')
    endif else begin
      celltransmission = 1.0
    endelse

    restransmission = (self.datacontainer->Get(position=resIndexList[0]))->Getproperty(tag='transmission')
    resvolumefraction = (self.datacontainer->Get(position=resIndexList[0]))->Getproperty(tag='volfrac')
    if resbkgIndexList[0] ne 9999 then begin
      resbkgtransmission = (self.datacontainer->Get(position=resbkgIndexList[0]))->Getproperty(tag='transmission')
    endif else begin
      resbkgtransmission = 1.0
    endelse

    arcsfield = Cw_field(subBase1,value=narcs,/return_events,$  ;,xsize=8
      /integer,title='Number of Q Arcs  ',/row,$
      uname='IQTARCSFIELD',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'IQTARCSFIELD',$
      list:datIndexList})

    samtrans = Cw_field(subBase1,value=sampletransmission,$
      /floating,title='Sample Trans      ',/row,$
      uname='SAMPLETRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'SAMPLETRANSMISSION',$
      list:datIndexList})

    samvolfrac = Cw_field(subBase1,value=samplevolumefraction,$
      /floating,title='Sample Volfrac    ',/row,$
      uname='SAMPLEVOLUMEFRACTION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'SAMPLEVOLUMEFRACTION',$
      list:datIndexList})

    celltrans = Cw_field(subBase1,value=celltransmission,$
      /floating,title='Cell Trans        ',/row,$
      uname='CELLTRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'CELLTRANSMISSION',$
      list:bkgIndexList})

    restrans = Cw_field(subBase1,value=sampletransmission,$
      /floating,title='Res Trans         ',/row,$
      uname='RESTRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'RESTRANSMISSION',$
      list:datIndexList})

    resvolfrac = Cw_field(subBase1,value=resvolumefraction,$
      /floating,title='Res Volfrac       ',/row,$
      uname='RESVOLUMEFRACTION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'RESVOLUMEFRACTION',$
      list:resIndexList})

    resbkgtrans = Cw_field(subBase1,value=resbkgtransmission,$
      /floating,title='Res Bkg Trans     ',/row,$
      uname='RESBKGTRANSMISSION',$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      id:'resTRANSMISSION',$
      list:resbkgIndexList})



;    ECHOAVERAGENORMLABEL     = Widget_label(subBase2,$
;      value='Next option for G. Ehlers. NOTE: EB Calculated using usual normalization.')
    ECHOAVERAGENORMLABEL     = Widget_label(subBase2,$
      value='Special miscelleneous options. NOTE: EB Calculated using usual normalization.')
    ECHOAVERAGENORMALIZATION = Cw_bgroup(subBase2,$
      'Use Echo Average for Normalization',$
      /row, /nonexclusive,$
      set_value=0,$
      uname='ECHOAVERAGENORMALIZATION',$
      uvalue={object:self,$
      method:'IQTDialogEvents',$
      id:'ECHOAVERAGENORMALIZATION'})
    ECHOWRITETESTOUTPUTFILE = Cw_bgroup(subBase2,$
      'WRITE TEST OUTPUT FILE',$
      /row, /nonexclusive,$
      set_value=0,$
      uname='ECHOWRITETESTOUTPUTFILE',$
      uvalue={object:self,$
      method:'IQTDialogEvents',$
      id:'ECHOWRITETESTOUTPUTFILE'})



    if (N_elements(theResList) gt 0) and $
      (N_elements(theBkgList) gt 0) then begin
      okButton = Widget_button(subBase3,value = 'OK',$
        xsize=230,ysize=50,$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'IQTOKBUTTON',$
        bkglist:bkgIndexList,$
        datlist:datIndexList,$
        reslist:resIndexList,$
        resbkglist:resbkgIndexList})
    endif else begin
      okButton = Widget_button(subBase3,value = 'NOT OK',$
        xsize=230,ysize=50,$
        uvalue = {object:self,$
        method:'IQTDialogEvents',$
        $;method:'listEvents',$
        id:'IQTCANCELBUTTON',$
        list:bkgIndexList})
    endelse

    cancelButton = Widget_button(subBase3,value = 'Cancel',$
      xsize=230,ysize=50,$
      uvalue = {object:self,$
      method:'IQTDialogEvents',$
      $;method:'listEvents',$
      id:'IQTCANCELBUTTON',$
      list:bkgIndexList})
      
    geom = widget_info(subBase2,/geom)
    Widget_control, subBase0, scr_xsize=(geom.scr_xsize - 2*geom.xpad)
    widget_control, subBase1, scr_xsize=(geom.scr_xsize - 2*geom.xpad)
    widget_control, subBase3, scr_xsize=(geom.scr_xsize - 2*geom.xpad)

    Widget_control,self.iqtimportbase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.iqtimportbase,$
      top:self.iqtimportbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.iqtimportbase,set_uvalue=$
      {object:self,$
      method:'listEvents',$
      id:'IQTCANCELBUTTON',$
      bkglist:bkgIndexList,$
      datlist:datIndexList,$
      reslist:resIndexList,$
      resbkglist:resbkgIndexList,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.iqtimportbase,/no_block,$
      cleanup='CalculateIQTBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Data Objects.')
  endelse

  ;041504

end;CalculateIQTDialog2


;BROKEN INTO SEPARATE FOLDER
;pro ooDisplayEcho::CalculateIQTDialog3



pro Calculateiqtbasecleanup,base
  ;
  ;NAME:
  ;        CalculateIQTBaseCleanup
  ;
  ;PURPOSE:
  ;           Clean up the dialog for selecting data objects for I(Q,t) calculation.
  ;PARAMETERS:
  ;           base    The id of the base to clean up.
  ;KEYWORDS:
  ;           none

  ;CALLED WHEN [X] EVENT OCCURS.
  ;print,'IQT Cleanup'

  ;THIS IS ALSO CALLED WHEN A cwo_displayiqt OBJECT IS DESTROYED.

  Widget_control,base,get_uvalue=iqt
  Call_method,iqt.method,iqt.object,iqt.event
end;CalculateIQTBaseCleanup

pro Oodisplayecho::mergeEvents,Event
  ;
  ;NAME:
  ;        ooDisplayEcho::mergeEvents
  ;
  ;PURPOSE:
  ;           Handle the events from the mergeSet dialog.
  ;           Here set refers to a single data object.
  ;PARAMETERS:
  ;           event   The event structure to handle.
  ;KEYWORDS:
  ;           none


  Widget_control,Event.id,get_uvalue=uval

  case uval.id of
    'MERGEOKBUTTON':begin
      ;GET OBJECT FROM WIDGET SELECTION AND
      ;MERGE WITH CURRENTLY SELECTED DATA
      ;OBJECT IF IT IS VALID.
      ;
      ;IF THE RESULTING OBJECT IS VALID THEN
      ;ADD IT TO THE DATA CONTAINER AND
      ;REFRESH THE DATA TREE.

      Widget_control,self.mergebase,$
        get_uvalue=merge
      objIndexList = merge.objlist

      objIndex=Widget_info(self.mergelist,$
        /droplist_select)

      m=self.qchoiceindex
      nobj=objIndexList[objIndex]
      ;print,objIndexList
      ;print,'NOBJ = ',nobj

      ;print,nbkg, ndat,nres
      current = ((self.datacontainer)->Get(position= $
        m))

      if nobj ne 9999 then begin
        ;print,'NOT 9999'
        newObj = $
          current->Merge(((self.datacontainer)->Get(position=nobj)))
      endif else begin
        ;print,'9999'
        newObj = 0L
      endelse

      if Obj_valid(newObj) gt 0 then begin
        ;print,'VALID'
        (self.datacontainer)->Add,newObj
        self->Redefinetree
      endif else begin
        Print,'NEW OBJECT NOT CREATED!'
      endelse


      Widget_control,self.mergebase,/destroy
    end
    'MERGECANCELBUTTON':begin
      Widget_control,self.mergebase,/destroy
    end
    'OBJMERGELIST':begin
      ;THIS METHOD SHOULD BE UNNECESSARY
      Widget_control,Event.id,get_value=list
    end
  endcase
end;mergeEvents
pro Oodisplayecho::MergeDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::MergeDialog
  ;
  ;PURPOSE:
  ;           Produce a dialog for selecting data objects to merge.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;THIS DIALOG WILL BE USED TO SELECT THE DATA
  ;OBJECT TO MERGE WITH THE CURRENT DATA OBJECT
  ;
  ;THIS DIALOG IS CALLED BY THE contextMenuEvents METHOD
  ;
  ;;;

  theObjList = ['']
  objIndexList = [0]

  myType = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag= $
    'type')
  myQ = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag= $
    'q')

  myX_dim = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag= $
    'x_dim')
  myY_dim = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag= $
    'y_dim')

  myIndex = self.qchoiceindex

  myname = File_basename((self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag= $
    'filename'))

  for i = 0,self.datacontainer->Count()-1 do begin
    if i ne myIndex then begin
      ;GET LIST OF DATA WITH THE CORRECT TYPE
      objType = (self.datacontainer->Get(position= $
        i))->Getproperty(tag='type')
      objQ = (self.datacontainer->Get(position= $
        i))->Getproperty(tag='q')
      objX_dim = (self.datacontainer->Get(position= $
        i))->Getproperty(tag='x_dim')
      objY_dim = (self.datacontainer->Get(position= $
        i))->Getproperty(tag='y_dim')
      if (myType eq objType) or (objType eq 0) then begin
        if (myQ eq objQ) then begin
          if (myX_dim eq objX_dim) and (myY_dim eq objY_dim) then begin
            theObjList = [theObjList, $
              File_basename((self.datacontainer->Get(position= $
              i))->Getproperty(tag='filename'))]
            objIndexList = [objIndexList,i]
          endif;dimension check
        endif;Q check
      endif;type check
    endif;index check
  endfor;i

  ;ADD OPTIONS FOR NO FILE IN EACH OF THESE
  theObjList = [theObjList,'None']
  objIndexList = [objIndexList,9999]


  ;CREATE DIALOG
  if N_elements(theObjList) gt 1 then begin
    theObjList = theObjList[1:*]
    objIndexList = objIndexList[1:*]

    self.mergebase = Widget_base(group_leader = self.atlb,$
      xsize=200,ysize=400,$
      /modal,/grid_layout,$
      title='MERGE '+myname+' WITH:',$;title='SELECT DATA FOR MERGE',$
      /base_align_right)

    subBase = Widget_base(self.mergebase,/column)
    self.mergelist = Widget_droplist(subBase,$
      value=theObjList,$
      ysize=25,xsize = 190,$
      title = 'Data Set Choices',$
      uvalue = {object:self,$
      method:'mergeEvents',$
      id:'OBJMERGELIST',$
      list:objIndexList})

    ;IF THESE HAVE ZERO ELEMENTS THEN
    ;self.objImportList WILL BE A MESSAGE, NOT A LIST
    if (N_elements(theObjList) gt 0) then begin
      okButton = Widget_button(subBase,value = 'OK',$
        xsize=190,ysize=50,$
        uvalue = {object:self,$
        method:'mergeEvents',$
        id:'MERGEOKBUTTON',$
        objlist:objIndexList})
    endif else begin
      okButton = Widget_button(subBase,value = 'NOT OK',$
        xsize=190,ysize=50,$
        uvalue = {object:self,$
        method:'mergeEvents',$
        id:'MERGECANCELBUTTON',$
        list:objIndexList})
    endelse

    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=190,ysize=50,$
      uvalue = {object:self,$
      method:'mergeEvents',$
      id:'MERGECANCELBUTTON',$
      list:objIndexList})


    Widget_control,self.mergebase,/realize

    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.mergebase,$
      top:self.mergebase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.mergebase,set_uvalue=$
      {object:self,$
      method:'mergeEvents',$
      id:'MERGECANCELBUTTON',$
      objlist:objIndexList,$
      event:dumEvent}

    Xmanager,"ooDisplayEcho",self.mergebase,/no_block,$
      cleanup='MergeBaseCleanup'

  endif else begin
    void = widget_message('No Suitable Data Objects.')
  endelse

  ;051904

end;MergeDialog
pro Mergebasecleanup,base
  ;
  ;NAME:
  ;        MergeBaseCleanup
  ;
  ;PURPOSE:
  ;           Cleanup method for the merge dialog.
  ;PARAMETERS:
  ;           base    The id of the top level base of the merge dialog.
  ;KEYWORDS:
  ;           none

  Print,'Merge Cleanup'
  Widget_control,base,get_uvalue=merge
  Call_method,merge.method,merge.object,merge.event
end;MergeBaseCleanup



pro Oodisplayecho::definePhaseImportDialog
  ;
  ;NAME:
  ;        ooDisplayEcho::definePhaseImportDialog
  ;
  ;PURPOSE:
  ;           Create a dialog to select the data object to import phases from
  ;           for fitting.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           none


  ;;
  ;
  ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
  ;
  ;;;

  refo = self.datacontainer->Get(position=self.qchoiceindex)
  theList = ['']
  objIndexList = [0]
  for i = 0,self.datacontainer->Count()-1 do begin
    refi = self.datacontainer->Get(position=i)
    if (refo)->Matches(refi) $
      and (i ne self.qchoiceindex) $
      and (refi->Getproperty(tag='type') ne 3) $ ;ONLY SELECT FROM NON-CELL DATA
      then begin
      ;                            print,$
      ;                            (self.dataContainer->get(position=$
      ;                                i))->getProperty(tag='filename')

      ;ADD SUCCESSFUL ITEMS TO THE LIST, BUT ADD RESOLUTION FILES TO BEGINNING.
      if (refi->Getproperty(tag='type') eq 1) and $
        (N_elements(theList) gt 1) then begin
        theList[0] =File_basename(refi->Getproperty(tag='filename'))
        objIndexList[0] = i
        theList = $
          ['',theList]
        objIndexList = [0,objIndexList]
      endif else begin
        theList = $
          [theList,File_basename(refi->Getproperty(tag='filename'))]
        objIndexList = [objIndexList,i]
      endelse

    endif
  endfor
  if N_elements(theList) gt 1 then begin
    theList = theList[1:*]
    objIndexList = objIndexList[1:*]

    self.phaseimportbase = Widget_base(group_leader = self.atlb,$
      $;xsize=156,ysize=140,$
      /modal,/col,$;/grid_layout,$
      title='SELECT PHASE SET')

    subBase = Widget_base(self.phaseimportbase,/column)
    self.phaseimportlist = Widget_droplist(subBase,$
      value=theList,$
      ysize=25,xsize = 250,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'PHASEIMPORTLIST',$
      list:objIndexList})

    fixvaryphaselist = Widget_droplist(subBase,$
      title='phase',$
      value=['vary','fix','fit phase offset (constant phase)'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPHASE',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPHASE',$
      list:objIndexList})

    ;111405
    ;SET FIX/VARY BASED ON OBJ TYPE:
    ;0
    ;
    refotype = refo->Getproperty(tag='type')
    ;print,'refotype=',refotype
    Widget_control,fixvaryphaselist, SET_DROPLIST_SELECT=1

    fixvaryperiodlist = Widget_droplist(subBase,$
      title='period',$
      value=['vary','fix'],$
      ysize=25,xsize = 250,$
      uname = 'PHASEIMPORTFIXVARYPERIOD',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'PHASEIMPORTFIXVARYPERIOD',$
      list:objIndexList})
    Widget_control,fixvaryperiodlist, SET_DROPLIST_SELECT=1



    allowNegAmpCheckbox = Cw_bgroup(subBase,$
      'Allow Small Opposite-Sign Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'ALLOWNEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    forceNegAmpCheckbox = Cw_bgroup(subBase,$
      'Force Negative Amplitudes',$
      /nonexclusive,$
      /no_release,$
      uname = 'FORCENEGATIVEAMPLITUDECHECKBOX',$
      uvalue = {object:self,$
      method:'doNothing',$
      id:'FORCENEGATIVEAMPLITUDECHECKBOX',$
      list:objIndexList})
    Widget_control,allownegampcheckbox,set_value=1

    okButton = Widget_button(subBase,value = 'OK',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'OKBUTTON',$
      list:objIndexList})
    cancelButton = Widget_button(subBase,value = 'Cancel',$
      xsize=150,ysize=50,$
      uvalue = {object:self,$
      method:'listEvents',$
      id:'CANCELBUTTON',$
      list:objIndexList})


    Widget_control,self.phaseimportbase,/realize


    ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
    dumEvent = { Widget_droplist,$
      id:self.phaseimportbase,$
      top:self.phaseimportbase,$
      handler:0L, index:0L }

    ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
    Widget_control,self.phaseimportbase,set_uvalue=$
      {object:self,$
      method:'listEvents',$
      id:'CANCELBUTTON',$
      list:objIndexList,$
      event:dumEvent}


    Xmanager,"ooDisplayEcho",self.phaseimportbase,/no_block,$
      cleanup='phaseImportBaseCleanup'

  endif else begin

    void = widget_message('No Suitable Data Objects.')
  endelse

end;definePhaseImportDialog


pro Phaseimportbasecleanup,base
  ;
  ;NAME:
  ;        PhaseImportBaseCleanup
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'pib Cleanup'
  Widget_control,base,get_uvalue=pib
  ;    print,base,self.atlb
  Call_method,pib.method,pib.object,pib.event

end;PhaseImportBaseCleanup




pro Oodisplayecho::defineImageErrorBase
  ;
  ;NAME:
  ;        ooDisplayEcho::defineImageErrorBase
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;DEFINES THE BASE AND DRAW WIDGETS AND REALIZES IT

  ;NOW DEFINE DRAW WIDGETS FOR IMAGE ERROR DISPLAY
  self.imageerrorbase = Widget_base(group_leader = self.atlb,$
    title='Image Error Bars',$
    tlb_size_events=1,$
    floating=1,$
    xsize=self.plotxsize,$
    ysize=self.plotysize,$
    uvalue=self)
  ;                                        uvalue={object:self,$
  ;                                                method:'ImageErrorBaseCleanup'})
  self.imageerrordw = Widget_draw(self.imageerrorbase,$
    xsize=self.plotxsize,$
    ysize=self.plotysize)
  Window,/free,/pixmap,xsize=(*self.geomplot).xsize,$
    ysize=(*self.geomplot).ysize
  self.dwebpix = !d.window

  Widget_control,self.imageerrorbase,/realize

  Widget_control,self.imageerrordw,get_value=dummy
  self.dwebid = dummy
  self->Realify,self.dwebpix,self.dwebid

  Xmanager,"ooDisplayEcho",self.imageerrorbase,event_handler='oodisplayecho_event',$
    cleanup="ImageErrorBaseCleanup",/no_block


  self.errorimagechoice = 1

end;defineImageErrorBase
pro Oodisplayecho::resizeImageErrorBase,Event,xsize=xsize,ysize=ysize
  ;
  ;NAME:
  ;        ooDisplayEcho::resizeImageErrorBase
  ;
  ;PURPOSE:
  ;       Resize the image error bars display.
  ;
  ;PARAMETERS:
  ;       event   Event that caused resize
  ;KEYWORDS:
  ;       xsize
  ;       ysize

  ;print,'ooDisplayEcho::resizeImageErrorBase'

  if N_elements(xsize) eq 0 then myxsize = Event.x
  if N_elements(ysize) eq 0 then myysize = Event.y


  winxsize = myxsize-6
  winysize = myysize-6

  if Widget_info(self.Imageerrordw,/valid_id) gt 0 then begin
    Widget_control,self.imageerrordw,xsize = winxsize, ysize = winysize
  endif

  if Widget_info(self.Imageerrorbase,/valid_id) gt 0 then begin
    Widget_control,self.imageerrorbase,xsize=myxsize,ysize=myysize
  endif
  Wdelete,self.dwebpix
  Window,/free,/pixmap,xsize=winxsize,ysize=winysize
  self.dwebpix = !d.window

  if N_elements(xsize) eq 0 then $
    self->Draw


end;resizeImageErrorBase
pro Oodisplayecho::Imageerrorbasecleanup;,event
  ;
  ;NAME:
  ;        ooDisplayEcho::ImageErrorBaseCleanup;
  ;
  ;PURPOSE:
  ;           TO DESTROY THE IMAGE ERROR BAR WIDGET AND TO UPDATE THE
  ;           self.errorImageChoice FLAG AND THE WIDGETS WHICH USE IT.
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;


  ;DESTROY BASE
  Widget_control,self.imageerrorbase,/destroy

  ;SET ERROR BAR FLAG TO OFF.
  self.errorimagechoice = 0

  ;SWITCH IMAGE OPTIONS MENUS
  id1 = Widget_info(self.atlb,find_by_uname="IMAGEERRORBARSMENU")

  id2 = Widget_info(self.dw1,find_by_uname="IMAGEERRORBARSCONTEXT")


  Widget_control,id1,set_value='Display Image Error Bars'
  Widget_control,id2,set_value='Display Image Error Bars'


end;ImageErrorBaseCleanup
pro Imageerrorbasecleanup,base
  ;
  ;NAME:
  ;        ImageErrorBaseCleanup
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.



  ;011305
  ;
  ;THIS CRASHES WHEN THE PARENT APP IS DESTROYED FIRST.
  ;
  ;Group leader appears correct, and it's xmanager appears
  ;to assign the proper cleanup to it.

  ;CALLED WHEN [X] EVENT OCCURS.
  Print,'ieb Cleanup'
  Widget_control,base,get_uvalue=ieb
  if Obj_valid(ieb) gt 0 then begin
    Call_method,'ImageErrorBaseCleanup',ieb;ieb.method,ieb.object
  endif else begin
    Widget_control,base,/destroy
  endelse

end;ImageErrorBaseCleanup

pro Oodisplayecho::defineDrawWidgets
  ;
  ;NAME:
  ;        ooDisplayEcho::defineDrawWidgets
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;;
  ;DRAWING AND PLOTTING WIDGETS (self.tlb2)
  ;;;
  ;self.tlb2 = widget_base(self.atlb,/col)


  ;THIS SLIDER WILL ONLY BE DISPLAYED IF THE PHASE IMAGE IS SHOWN.

  ;    self.clickrefitslider = cw_fslider(self.tlb2,$
  ;                                        minimum=-800.0,$
  ;                                        maximum=800.0,$
  ;                                        scroll=45.0,$
  ;                                        value=0.0,$
  ;                                        title='alt-click starting phase',$
  ;                                        uvalue={object:self,$
  ;                                            method:'sliderEvents',$
  ;                                            id:'CLICKREFITSLIDER'})



  ;011005
  ;SET UP A BASE FOR THE DRAW WIDGET SO THAT I CAN GET CONTEXT EVENTS
  ;FOR MASK ADJUSTMENTS.
  ;    dw1Base = widget_base(self.tlb2,/context_events,xsize = self.plotxsize, ysize=self.plotysize)
  ;    contextBase = WIDGET_BASE(dw1Base, /CONTEXT_MENU)
  ;
  ;    ;SET UP THE NEXT TWO BUTTONS TO BE IDENTICAL TO THE 'Alter Mask' AND 'Apply Mask. . .' BUTTONS.
  ;    button1 = WIDGET_BUTTON(contextBase, VALUE='Alter Mask',$
  ;                                                uvalue={object:self,$
  ;                                                        method:'buttonEvents',$
  ;                                                        id:'MASKBUTTON'})
  ;    button2 = WIDGET_BUTTON(contextBase, VALUE='Apply Mask to All Fourier Times',$
  ;                                    uvalue={object:self,$
  ;                                            method:'buttonEvents',$
  ;                                            id:'MASKBUTTONAPPLY'})



  self.dw1 = Widget_draw(self.tlb2,xsize=self.plotxsize,$
    ;    self.dw1 = widget_draw(dw1Base,xsize=self.plotxsize,$
    ysize=self.plotysize,$
    /button_events,$
    $;/motion_events,$
    keyboard_events=1,$
    tracking_events=1,$
    uname="DW1",$
    $;tooltip='arrow keys navigate, "m" masks, pgup/down changes t, rightclick refits for phase image',$
    uvalue={object:self,$
    method:'drawEvents',$
    id:'DW1'})


  maskContextBase = Widget_base(self.dw1, /CONTEXT_MENU,/col,$
    uname = 'MASKCONTEXTBASE',$
    uvalue={object:self,$
    method:'drawEvents',$
    id:'MASKCONTEXTBASE'})

  image_bttn0 = Widget_button(maskContextBase,value='Image Options',/menu)
  ;SET UP THE NEXT BUTTONS TO BE IDENTICAL TO THE 'Alter Mask' AND 'Apply Mask. . .' BUTTONS.
  ;image_bttn1 = widget_button(maskContextBase, value='S(detx,dety)',$
  image_bttn1 = Widget_button(image_bttn0, value='S(Q(x,y),t=0)',$
    uname="SOF0",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SOF0',$
    parent:'IMAGEOPTIONS'})
  image_bttn2 = Widget_button(image_bttn0, value='Signal',$
    uname="SIGNALIMAGE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SIGNALIMAGE',$
    parent:'IMAGEOPTIONS'})
  ;image_bttn2 = widget_button(maskContextBase, value='P0 - AVERAGE',$
  image_bttn2 = Widget_button(image_bttn0, value='Av - AVERAGE',$;'P0 - AVERAGE',$
    uname="FITCONSTANT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITCONSTANT',$
    parent:'IMAGEOPTIONS'})
  image_bttn3 = Widget_button(image_bttn0, value='A - AMPLITUDE',$;'P1 - AMPLITUDE',$
    uname="FITAMPLITUDE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITAMPLITUDE',$
    parent:'IMAGEOPTIONS'})
  image_bttn4 = Widget_button(image_bttn0, value='PH - PHASE',$;'P2 - PHASE',$
    uname="FITPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITPHASE',$
    parent:'IMAGEOPTIONS'})
  image_bttn5 = Widget_button(image_bttn0, value='W - ECHO GAUSSIAN WIDTH',$;'P3 - ECHO GAUSSIAN WIDTH',$
    uname="FITWIDTH",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITWIDTH',$
    parent:'IMAGEOPTIONS'})
  image_bttn6 = Widget_button(image_bttn0, value='T - PERIOD',$;'P4 - PERIOD',$;OMEGA = 360/(ECHO PERIOD)',$
    uname="FITOMEGA",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITOMEGA',$
    parent:'IMAGEOPTIONS'})
  ;    image_bttn6 = widget_button(image_bttn0, value='P5 - PHASE OFFSET',$
  ;                                uname="FITPHASEOFFSET",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FITPHASEOFFSET',$
  ;                                        parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn0, value='CHISQ',$
    uname="FITCHISQ",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITCHISQ',$
    parent:'IMAGEOPTIONS'})

  image_bttn6m = Widget_button(image_bttn0, value='MAGNETIC IMAGE OPTIONS',$
    uname="MAGNETICIMAGEOPTIONS_CONTEXT",$
    /menu,sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'"MAGNETICIMAGEOPTIONS"',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Magnetic',$
    uname='MAGNETIC_CASE_0_CONTEXT',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_0',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Spin Incoherent',$
    uname='MAGNETIC_CASE_1_CONTEXT',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_1',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Coherent and Isotope Incoherent',$
    uname='MAGNETIC_CASE_2_CONTEXT',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_2',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Total',$
    uname='MAGNETIC_CASE_3_CONTEXT',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_3',$
    parent:'IMAGEOPTIONS'})




  image_bttn6 = Widget_button(maskContextBase, value='DISPLAY IMAGE ERROR BARS',$
    uname="IMAGEERRORBARSCONTEXT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'IMAGEERRORBARS',$
    parent:'IMAGEOPTIONS'})


  ;033005
  ;REMOVE NEXT BUTTON
  ;
  ;    button1 = WIDGET_BUTTON(maskContextBase, VALUE='Alter Mask',$
  ;                                                uvalue={object:self,$
  ;                                                        method:'buttonEvents',$
  ;                                                        id:'MASKBUTTON'})
  button2 = Widget_button(maskContextBase, VALUE='Apply Mask to All Fourier Times',$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTONAPPLY'})

  button2 = Widget_button(maskContextBase, VALUE='Apply masking of this pixel at All Fourier Times',$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTONPIXELAPPLY'})

  button2 = Widget_button(maskContextBase, VALUE='Apply Mask to SUBSEQUENT Fourier Times',$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTONSUBSEQUENTAPPLY'})

  button2 = Widget_button(maskContextBase, VALUE='Apply masking of this pixel at SUBSEQUENT Fourier Times',$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTONSUBSEQUENTPIXELAPPLY'})


  button2 = Widget_button(maskContextBase, VALUE='Save Mask to File',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'SAVEMASKBUTTON'})



  self.tw1 = Widget_text(self.tlb2,value="8,8",uvalue="TW1",uname="TW1")


  self->Definecdcontrols,base=self.tlb2


  self.dw2 = Widget_draw(self.tlb2,xsize=self.plotxsize,$
    ysize=self.plotysize,$
    /button_events,$
    keyboard_event=1,$
    tracking_events=1,$
    /motion_events,$
    uname="DW2",$
    uvalue={object:self,$
    method:'drawEvents',$
    id:'DW2'})


  ;011005 SET UP PLOT OPTIONS FROM CONTEXT MENU.
  plotContextBase = Widget_base(self.dw2, /CONTEXT_MENU,/col,$
    uname = 'PLOTCONTEXTBASE',$
    uvalue={object:self,$
    method:'drawEvents',$
    id:'PLOTCONTEXTBASE'})

  plotcontextmenu = Widget_button(plotContextBase, value='Plot Choices',/menu,$;value='Plot Options',/menu,$
    xsize=50,$
    uname="PLOTCONTEXTMENU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PLOTCONTEXTMENU',$
    parent:'PLOTOPTIONS'})

  plot_bttn1 = Widget_button(plotContextMenu, value='I v. Phase',$
    uname="IVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'IVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotContextMenu, value='Fit Phase v. Fourier Time',$
    uname="FITPHASEVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITPHASEVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotContextMenu, value='Fit Amplitude v. Fourier Time',$
    uname="FITAMPVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITAMPVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotContextMenu, value='Signal v. Fourier Time',$
    uname="SIGNALVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SIGNALVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn3 = Widget_button(plotContextMenu, value='B_x v. Phase',$
    uname="BXVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BXVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn4 = Widget_button(plotContextMenu, value='B_y v. Phase',$
    uname="BYVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BYVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn5 = Widget_button(plotContextMenu, value='B_z v. Phase',$
    uname="BZVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BZVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn6 = Widget_button(plotContextMenu, value='All v. Phase',$
    uname="ALLVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'ALLVPHASE',$
    parent:'PLOTOPTIONS'})

  ;020606
  ;ADD THE FOLLOWING PLOT FOR MAGNETIC PARAMETERS
  self.magplotcontextsubmenu = Widget_button(plotContextMenu, value='Magnetic Parameters',$
    uname="MAGNETICPLOT_CONTEXT",$
    /menu,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOTPARAMETERSMENU',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(self.magplotcontextsubmenu, value='Area Averaged',$
    uname="MAGNETICPLOT_CONTEXT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOT',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(self.magplotcontextsubmenu, value='Pixel',$
    uname="MAGNETICPLOT_CONTEXT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOTPIXEL',$
    parent:'PLOTOPTIONS'})

  plot_bttn2 = Widget_button(plotContextMenu, value='Contour Echo',$
    uname="CONTOURECHO",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CONTOURECHO',$
    parent:'PLOTOPTIONS'})

  plot_bttn7 = Widget_button(plotContextBase, value='Toggle DISPLAY OF f_on/f_off',$
    uname="TOGGLEUPDOWN",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'TOGGLEUPDOWN',$
    parent:'PLOTOPTIONS'})

  plot_bttn8 = Widget_button(plotContextBase, value='Toggle Auxiliary Plot',$
    uname="TOGGLEAUXPLOT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'TOGGLEAUXPLOT',$
    parent:'PLOTOPTIONS'})


  plot_bttn8 = Widget_button(plotContextBase, value='Write plot data to file',$
    uname="WRITEPLOTDATA",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'WRITEPLOTDATA',$
    parent:'PLOTOPTIONS'})


  plot_bttn8 = Widget_button(plotContextBase, value='Expand Range 20%',$
    uname='EXPANDPLOTRANGES',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'EXPANDPLOTRANGES',$
    parent:'PLOTOPTIONS'})


  plot_bttn8 = Widget_button(plotContextBase, value='Unzoom Plot',$
    uname='UNZOOMPLOT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'UNZOOMPLOT',$
    parent:'PLOTOPTIONS'})




  ;SET THIS FOR INITIAL SIZE AND REDO THIS
  ;IN A RESIZE EVENT HANDLER
  if Ptr_valid(self.geombase) gt 0 then Ptr_free,self.geombase
  self.geombase = Ptr_new(Widget_info(self.atlb,/geometry))
  if Ptr_valid(self.geomimage) gt 0 then Ptr_free,self.geomimage
  self.geomimage = Ptr_new(Widget_info(self.dw1,/geometry))
  if Ptr_valid(self.geomplot) gt 0 then Ptr_free,self.geomplot
  self.geomplot = Ptr_new(Widget_info(self.dw2,/geometry))


  ;CREATE PIXMAP WINDOW FOR DOUBLE BUFFERING OF IMAGE WINDOW
  Window,/free,/pixmap,xsize=(*self.geomimage).xsize,$
    ysize=(*self.geomimage).ysize
  self.dw1pix = !d.window

  ;CREATE PIXMAP WINDOW FOR DOUBLE BUFFERING OF PLOT WINDOW
  Window,/free,/pixmap,xsize=(*self.geomplot).xsize,$
    ysize=(*self.geomplot).ysize
  self.dw2pix = !d.window
  ;widget_control,self.dw1pix,get_value=self.dw1pixid


  ;    self.tw1 = widget_text(self.tlb2,value="8,8",uvalue="TW1",uname="TW1")
  ;



  ;021005
  ;MOVE THIS TO self->defineWidgets
  ;widget_control,self.atlb,/realize


  Widget_control,self.dw1,get_value=dummy
  self.dw1id = dummy
  Widget_control,self.dw2,get_value=dummy
  self.dw2id = dummy
  Widget_control,self.tw1,get_value=dummy
  self.tw1id = dummy

  ;widget_control,self.atw1,get_value=dummy2
  ;NOW THAT THIS IS A COMBOBOX
  dummy2 = Widget_info(self.atw1,/combobox_gettext)

  self.atw1id = dummy2
  Widget_control,self.atwbcx,get_value=dummy3
  self.atwbcxid = dummy3
  Widget_control,self.atwbcy,get_value=dummy4
  self.atwbcyid = dummy4
  Widget_control,self.atwlambda,get_value=dummy5
  self.atwlambdaid = dummy5
  if Widget_info(self.Atwlambdadist,/valid_id) gt 0 then begin
    Widget_control,self.atwlambdadist,get_value=dummy6
    self.atwlambddistaid = dummy6
  endif else begin
    self.atwlambddistaid = 0
  endelse

  ;DEFINE IMAGE AND PLOT AXIS STRUCTURES
  Wset,self.dw1id
  if Ptr_valid(self.w1xptr) gt 0 then Ptr_free,self.w1xptr
  if Ptr_valid(self.w1yptr) gt 0 then Ptr_free,self.w1yptr
  self.w1xptr = Ptr_new(!x)   ;SET THESE VALUES AT POINT OF EVENT TO
  self.w1yptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION

  Wset,self.dw2id
  if Ptr_valid(self.w2xptr) gt 0 then Ptr_free,self.w2xptr
  if Ptr_valid(self.w2yptr) gt 0 then Ptr_free,self.w2yptr
  self.w2xptr = Ptr_new(!x)   ;SET THESE VALUES AT POINT OF EVENT TO
  self.w2yptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION

  ;    ;NOW DEFINE DRAW WIDGETS FOR IMAGE ERROR DISPLAY
  ;    self.imageerrorbase = widget_base(group_leader = self.atlb,$
  ;                                        xsize=400,ysize=400)
  ;    self.imageerrordw = widget_draw(self.imageerrorbase,$
  ;                                    xsize=400,ysize=400)
  ;    window,/free,/pixmap,xsize=(*self.geomPlot).xsize,$
  ;                        ysize=(*self.geomPlot).ysize
  ;    self.dwebpix = !d.window
  ;    widget_control,self.imageerrordw,get_value=dummy
  ;    self.dwebid = dummy



end;defineDrawWidgets
pro Oodisplayecho::defineMenus,bar
  ;
  ;NAME:
  ;        ooDisplayEcho::defineMenus
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  file_menu = Widget_button(bar, value='File', /menu)
  openfile_bttn1 = Widget_button(file_menu, value='Open echo File(s)',$
    uname="FILEOPEN",$
    $;/menu,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FILEOPEN',$
    parent:'FILEOPTIONS'})

  ;110705
  ;THE OBJECT TYPE IS NOW DETERMINED AUTOMATICALLY, SO ELIMINATE THE
  ;NEXT TWO BUTTONS AND REINSTATE THE ABOVE TO Button AND NOT MENU STATUE.


  ;    file_bttn1 = widget_button(openfile_bttn1, value='Open .echo File(s)',$
  ;                                uname="FILEOPEN",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEOPEN',$
  ;                                        parent:'FILEOPTIONS'})
  ;    file_bttn1 = widget_button(openfile_bttn1, value='Open magnetic .echo File(s)',$
  ;                                uname="FILEOPENMAGNETIC",$
  ;                                sensitive=1,$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEOPENMAGNETIC',$
  ;                                        parent:'FILEOPTIONS'})





  ;    file_bttn1 = widget_button(file_menu, value='Save',$
  ;                                uname="FILESAVE",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILESAVE',$
  ;                                        parent:'FILEOPTIONS'})


  file_button1 = Widget_button(file_menu,value='Save Session',$
    uname="SAVESESSION",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SAVESESSION',$
    parent:'FILEOPTIONS'})

  file_button1 = Widget_button(file_menu,value='Restore Session',$
    uname="RESTORESESSION",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'RESTORESESSION',$
    parent:'FILEOPTIONS'})

  file_button1 = Widget_button(file_menu,value='Save Dataset',$
    uname="SAVEOBJECT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SAVEOBJECT',$
    parent:'FILEOPTIONS'})

  file_button1 = Widget_button(file_menu,value='Restore Dataset',$
    uname="RESTOREOBJECT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'RESTOREOBJECT',$
    parent:'FILEOPTIONS'})

  file_button1 = Widget_button(file_menu,value='Load Test Data',$
    uname="LOADTESTDATA",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'LOADTESTDATA',$
    parent:'FILEOPTIONS'})




  ;111704
  ;NOW THAT OBJECT AND SESSION SAVE/RESTORE ARE
  ;AVAILABLE, THE NEXT FOUR ITEMS ARE OBSOLETE.

  ;    file_button1 = widget_button(file_menu,value='Export Phases',$
  ;                                uname="FILEPHASEEXPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEPHASEEXPORT',$
  ;                                        parent:'FILEOPTIONS'})
  ;
  ;    file_button1 = widget_button(file_menu,value='Import Phases from File',$
  ;                                uname="FILEPHASEIMPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEPHASEIMPORT',$
  ;                                        parent:'FILEOPTIONS'})
  ;
  ;    file_button1 = widget_button(file_menu,value='Export FIT PARAMETERS',$
  ;                                uname="FILEFITPARMEXPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEFITPARMEXPORT',$
  ;                                        parent:'FILEOPTIONS'})
  ;
  ;    file_button1 = widget_button(file_menu,value='Import FIT PARAMETERS',$
  ;                                uname="FILEFITPARMIMPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEFITPARMIMPORT',$
  ;                                        parent:'FILEOPTIONS'})


  ;072605
  ;COMMENT OUT THE NEXT TWO WIDGETS SINCE THEY GENERALLY WOULD NOT BE USED.
  ;    file_button1 = widget_button(file_menu,value='Export I(Q,t) (ASCII)',$
  ;                                uname="FILEIQTEXPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEIQTEXPORT',$
  ;                                        parent:'FILEOPTIONS'})
  ;
  ;    file_button1 = widget_button(file_menu,value='Export I(Q,t) (DAVE)',$
  ;                                uname="FILEIQTDAVEEXPORT",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FILEIQTDAVEEXPORT',$
  ;                                        parent:'FILEOPTIONS'})




  file_button1 = Widget_button(file_menu,value='Import Parameters File',$
    uname="FILEPARAMETERSIMPORT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FILEPARAMETERSIMPORT',$
    parent:'FILEOPTIONS'})


  file_button1 = Widget_button(file_menu,value='Export Parameters File',$
    uname="FILEPARAMETERSEXPORT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FILEPARAMETERSEXPORT',$
    parent:'FILEOPTIONS'})



  file_bttn1 = Widget_button(file_menu, value='Quit',$
    uname="FILEQUIT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FILEQUIT',$
    parent:'FILEOPTIONS'})


  plotoptions_menu = Widget_button(bar, value='Plot Options', /menu)
  plot_bttn1 = Widget_button(plotoptions_menu, value='I v. Phase',$
    uname="IVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'IVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotoptions_menu, value='Fit Phase v. Fourier Time',$
    uname="FITPHASEVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITPHASEVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotoptions_menu, value='Fit Amplitude v. Fourier Time',$
    uname="FITAMPVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITAMPVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(plotoptions_menu, value='Signal v. Fourier Time',$
    uname="SIGNALVTAU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SIGNALVTAU',$
    parent:'PLOTOPTIONS'})
  plot_bttn3 = Widget_button(plotoptions_menu, value='B_x v. Phase',$
    uname="BXVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BXVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn4 = Widget_button(plotoptions_menu, value='B_y v. Phase',$
    uname="BYVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BYVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn5 = Widget_button(plotoptions_menu, value='B_z v. Phase',$
    uname="BZVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'BZVPHASE',$
    parent:'PLOTOPTIONS'})
  plot_bttn6 = Widget_button(plotoptions_menu, value='All v. Phase',$
    uname="ALLVPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'ALLVPHASE',$
    parent:'PLOTOPTIONS'})


  ;;112805
  ;;ADD THE FOLLOWING PLOT FOR MAGNETIC PARAMETERS
  ;    plot_bttn2 = widget_button(plotoptions_menu, value='Magnetic Parameters',$
  ;                                uname="MAGNETICPLOT_MENU",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'MAGNETICPLOT',$
  ;                                        parent:'PLOTOPTIONS'})
  ;


  ;020606
  ;ADD THE FOLLOWING PLOT FOR MAGNETIC PARAMETERS
  self.magplotmenusubmenu = Widget_button(plotoptions_Menu, value='Magnetic Parameters',$
    uname="MAGNETICPLOT_CONTEXT",$
    /menu,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOTPARAMETERSMENU',$
    parent:'PLOTOPTIONS'})


  plot_bttn2 = Widget_button(self.magplotmenusubmenu, value='Area Averaged',$
    uname="MAGNETICPLOT_MENU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOT',$
    parent:'PLOTOPTIONS'})
  plot_bttn2 = Widget_button(self.magplotmenusubmenu, value='Pixel',$
    uname="MAGNETICPLOT_MENU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETICPLOTPIXEL',$
    parent:'PLOTOPTIONS'})






  ;    plot_bttn2 = widget_button(plotoptions_menu, value='Contour Echo',$
  ;                                uname="CONTOURECHO",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'CONTOURECHO',$
  ;                                        parent:'PLOTOPTIONS'})


  plot_bttn7 = Widget_button(plotoptions_menu, value='Toggle Up/Down Display',$
    uname="TOGGLEUPDOWN",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'TOGGLEUPDOWN',$
    parent:'PLOTOPTIONS'})

  plot_bttn8 = Widget_button(plotoptions_menu, value='Toggle Auxiliary Plot',$
    uname="TOGGLEAUXPLOT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'TOGGLEAUXPLOT',$
    parent:'PLOTOPTIONS'})



  imageoptions_menu = Widget_button(bar, value='Image Options', /menu)
  image_bttn1 = Widget_button(imageoptions_menu, value='S(Q(x,y),t=0)',$
    uname="SOF0",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SOF0',$
    parent:'IMAGEOPTIONS'})

  image_bttn2 = Widget_button(imageoptions_menu, value='Signal',$
    uname="SIGNALIMAGE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'SIGNALIMAGE',$
    parent:'IMAGEOPTIONS'})

  image_bttn2 = Widget_button(imageoptions_menu, value='Av - AVERAGE',$;'P0 - AVERAGE',$
    uname="FITCONSTANT",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITCONSTANT',$
    parent:'IMAGEOPTIONS'})
  image_bttn3 = Widget_button(imageoptions_menu, value='A - AMPLITUDE',$;'P1 - AMPLITUDE',$
    uname="FITAMPLITUDE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITAMPLITUDE',$
    parent:'IMAGEOPTIONS'})
  image_bttn4 = Widget_button(imageoptions_menu, value='PH - PHASE',$;'P2 - PHASE',$
    uname="FITPHASE",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITPHASE',$
    parent:'IMAGEOPTIONS'})
  image_bttn5 = Widget_button(imageoptions_menu, value='W - ECHO GAUSSIAN WIDTH',$;'P3 - ECHO GAUSSIAN WIDTH',$
    uname="FITWIDTH",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITWIDTH',$
    parent:'IMAGEOPTIONS'})
  image_bttn6 = Widget_button(imageoptions_menu, value='T - PERIOD',$;'P4 - PERIOD',$;OMEGA = 360/(ECHO PERIOD)',$
    uname="FITOMEGA",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITOMEGA',$
    parent:'IMAGEOPTIONS'})
  ;    image_bttn6 = widget_button(imageoptions_menu, value='P5 - PHASE OFFSET',$
  ;                                uname="FITPHASEOFFSET",$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'FITPHASEOFFSET',$
  ;                                        parent:'IMAGEOPTIONS'})
  image_bttn6 = Widget_button(imageoptions_menu, value='CHISQ',$
    uname="FITCHISQ",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'FITCHISQ',$
    parent:'IMAGEOPTIONS'})

  image_bttn6m = Widget_button(imageoptions_menu, value='MAGNETIC IMAGE OPTIONS',$
    uname="MAGNETICIMAGEOPTIONS_MENU",$
    /menu,sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'"MAGNETICIMAGEOPTIONS"',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Magnetic',$
    uname='MAGNETIC_CASE_0_MENU',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_0',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Spin Incoherent',$
    uname='MAGNETIC_CASE_1_MENU',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_1',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Coherent and Isotope Incoherent',$
    uname='MAGNETIC_CASE_2_MENU',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_2',$
    parent:'IMAGEOPTIONS'})

  image_bttn6 = Widget_button(image_bttn6m, value='Total',$
    uname='MAGNETIC_CASE_3_MENU',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MAGNETIC_CASE_3',$
    parent:'IMAGEOPTIONS'})



  image_bttn6 = Widget_button(imageoptions_menu, value='DISPLAY IMAGE ERROR BARS',$
    uname="IMAGEERRORBARSMENU",$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'IMAGEERRORBARS',$
    parent:'IMAGEOPTIONS'})
  self.errorimagechoice = 0



  detectoroptions_menu = Widget_button(bar, value='Detector Options', /menu)
  detector_bttn1 = Widget_button(detectoroptions_menu, value='32x32',$
    uname='32SQUARE',$
    sensitive=1,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'32SQUARE',$
    parent:'DETECTOROPTIONS'})
  detector_bttn2 = Widget_button(detectoroptions_menu, value='64x64',$
    uname='64SQUARE',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'64SQUARE',$
    parent:'DETECTOROPTIONS'})
  detector_bttn3 = Widget_button(detectoroptions_menu, value='128x64',$
    uname='128RECT',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'128RECT',$
    parent:'DETECTOROPTIONS'})
  detector_bttn4 = Widget_button(detectoroptions_menu, value='128x128',$
    uname='128SQUARE',$
    sensitive=0,$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'128SQUARE',$
    parent:'DETECTOROPTIONS'})

  calculations_menu = Widget_button(bar, value='Calculations', /menu)
  ;    calculations_bttn2 = widget_button(calculations_menu,$
  ;                                value='Calculate Q Values',$
  ;                                uname='CALCULATEQS',$
  ;                                uvalue={object:self,$
  ;                                        method:'menuEvents',$
  ;                                        id:'CALCULATEQS',$
  ;                                        parent:'CALCULATIONOPTIONS'})
  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Calculate I(Q,t)',$
    uname='CALCULATEI',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEI',$
    parent:'CALCULATIONOPTIONS'})

  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Calculate I(Q,t) Express (NEW and Lightly Tested)',$
    uname='CALCULATEIEXPRESS',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEIEXPRESS',$
    parent:'CALCULATIONOPTIONS'})


  calculations_bttn1 = Widget_button(calculations_menu,$
    value='AutomaskSomething - Alter global mask based on selected criteria',$
    uname='AUTOMASKSOMETHING',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'AUTOMASKSOMETHING',$
    parent:'CALCULATIONOPTIONS'})

  calculations_bttn1 = Widget_button(calculations_menu,$
    value='NSE Diffraction Viewer',$
    uname='NSEDIFFRACTIONVIEWER',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'NSEDIFFRACTIONVIEWER',$
    parent:'CALCULATIONOPTIONS'})


  calculations_bttn1 = Widget_button(calculations_menu,$
    value='AutographNSE - Plot and Fit D(Q) from I(Q,t) Files',$
    uname='AUTOGRAPHNSE',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'AUTOGRAPHNSE',$
    parent:'CALCULATIONOPTIONS'})

  ;    self.autographNSEbutton = widget_button(llb1,value='Plot and Fit D(Q)',$
  ;                                                tooltip='AutographNSE')



  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Calculate Average Width',$
    uname='CALCULATEAVERAGEWIDTH',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATEAVERAGEWIDTH',$
    parent:'CALCULATIONOPTIONS'})

  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Calculate Unscaled 1d S(Q,t=0)',$
    uname='CALCULATESQ1D',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'CALCULATESQ1D',$
    parent:'CALCULATIONOPTIONS'})


  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Merge Multiple I(Q,t) into DAVE',$
    uname='MERGEMULTIPLEIQT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'MERGEMULTIPLEIQT',$
    parent:'CALCULATIONOPTIONS'})

  calculations_bttn1 = Widget_button(calculations_menu,$
    value='Sum Multiple Echo Files DAVE',$
    uname='SUMMULTIPLEECHOFILES',$
    uvalue={object:self,$
    method:'sumMultipleEchoFiles',$
    id:'SUMMULTIPLEECHOFILES',$
    parent:'CALCULATIONOPTIONS'})




  print_menu = Widget_button(bar, value='Printing', /menu)
  print_bttn1 = Widget_button(print_menu,$
    value='Print Image to Default Printer',$
    uname='PRINTIMAGEDEFAULT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTIMAGEDEFAULT',$
    parent:'PRINTOPTIONS'})

  print_bttn1 = Widget_button(print_menu,$
    value='Print Plot to Default Printer',$
    uname='PRINTPLOTDEFAULT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTPLOTDEFAULT',$
    parent:'PRINTOPTIONS'})

  print_bttn1 = Widget_button(print_menu,$
    value='Print Auxiliary Plot to Default Printer',$
    uname='PRINTAUXPLOTDEFAULT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTAUXPLOTDEFAULT',$
    parent:'PRINTOPTIONS'})

  print_bttn1 = Widget_button(print_menu,$
    value='Print All to Default Printer',$
    uname='PRINTALLDEFAULT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTALLDEFAULT',$
    parent:'PRINTOPTIONS'})



  print_bttn1 = Widget_button(print_menu,$
    value='Print Image',$
    uname='PRINTIMAGE',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTIMAGE',$
    parent:'PRINTOPTIONS'})

  print_bttn1 = Widget_button(print_menu,$
    value='Print Plot',$
    uname='PRINTPLOT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTPLOT',$
    parent:'PRINTOPTIONS'})

  print_bttn1 = Widget_button(print_menu,$
    value='Print Auxiliary Plot',$
    uname='PRINTAUXPLOT',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'PRINTAUXPLOT',$
    parent:'PRINTOPTIONS'})

  help_menu = Widget_button(bar, value='Help', /menu)
  help_bttn1 = Widget_button(help_menu,$
    value='Help on NSE',$
    uname='NSEHELP',$
    uvalue={object:self,$
    method:'menuEvents',$
    id:'NSEHELP',$
    parent:'HELPOPTIONS'})



end;defineMenus



;
;NAME:
;        ooDisplayEcho::defineTextWidgets
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
pro Oodisplayecho::defineTextWidgets

  self.atwfile = Cw_field(self.tlb1a3,/column,/noedit,$   ;
    value=File_basename(self.filename)+': '+$
    self.Comment,$
    uname='ATWFILE',$
    $;font = 'TIMES',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWFILE'},$
    title='Current Filename', xsize=55)

  self.atwbcx = Cw_field(self.tlb1a2,/return_events,$   ;,/column
    value=Strtrim(String(16.0),2),$;value=strtrim(string(self.beamCenxOrig),2),$
    uname='ATWBCX',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWBCX'},$
    title='Full Scale Beam Center X')

  ;
  ;092204
  ;
  ;SUGGESTION:
  ;
  ;MOVE TO DROPDOWN MENU CONTROLLED TEXT BOX WITH OTHER
  ;ITEMS IN THIS SECTION AND HAVE AN "APPLY TO ALL" BUTTON
  ;THIS MIGHT BE LABELED "GENERAL PARAMETERS"
  self.atwbcy = Cw_field(self.tlb1a2,/return_events,$   ; ,/column
    value=Strtrim(String(16.0),2),$;value=strtrim(string(self.beamCenyOrig),2),$
    uname='ATWBCY',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWBCY'},$
    title='Full Scale Beam Center Y')

  void = Widget_label(self.tlb1a3,value='Binning/blocking Factor')


  ;THE COMBOBOX WIDGET SEEMS TO HAVE A PROBLEM ON THE MAC!!!
  ;TRY TO REPLACE IT WITH THE cw_pdmenu WIDGET.


  ;RICHARD SUGGESTS THAT THE PROBLEM IS THAT THERE IS A "FROM" AND A "TO"
  ;EVENT THAT OCCUR IN X11, AND I NEED TO HANDLE BOTH OF THESE.

  ;040605
  binningsubbase = Widget_base(self.tlb1a3,/row)
  self.atw1 = Widget_combobox(binningsubbase, $;/EDITABLE, $
    /NO_COPY, $
    /SENSITIVE, $
    UVALUE={object:self,$
    method:'textEvents',$
    id:'ATW1'},$
    VALUE=['1','2','4','8','16'])

  Widget_control,self.atw1,combobox_index = 2
  buttonysize = 20
  self.binallbutton = Widget_button(binningsubbase,value = 'Apply Binning to all data',$
    tooltip='Apply binning to all current data.',$
    ysize = buttonysize,$
    UVALUE={object:self,$
    method:'textEvents',$
    id:'BINALLBUTTON'})

  DEEPMASKINGsubbase = Widget_base(self.tlb1a3,/row)

  self.deepmaskingcheckbox = Cw_bgroup(DEEPMASKINGsubbase,$
    'Apply Deep Masking',$;,'apply to all data'], $
    $;ysize = buttonysize,$
    /row, /nonexclusive,$
    $;/no_release,$
    $;frame=1,$
    set_value=0,$
    uname='DEEPMASKINGCHECKBOX',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'DEEPMASKINGCHECKBOX'})

  CHANGEMASKFILEBUTTON = Widget_button(DEEPMASKINGSUBBASE,$
    value='New deep mask file',$
    uname='CHANGEMASKFILEBUTTON',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'CHANGEMASKFILEBUTTON'})


  ;void = Widget_label(self.tlb1a3,value='Transmission')
  ;self.atwtrans = Widget_text(self.tlb1a3,editable=1,$
  ;  value=Strtrim(String(1.0),2),$
  ;  uname='ATWTRANS',$
  ;  uvalue={object:self,$
  ;  method:'textEvents',$
  ;  id:'ATWTRANS'})
  self.atwtrans = Cw_field(self.tlb1a3,/return_events,$     ;,/column
    value=Strtrim(String(1.0),2),$
    uname='ATWTRANS',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWTRANS'},$
    title='Transmission    ')

  ;void = Widget_label(self.tlb1a3,value='Volume Fraction')
  ;self.atwvolfrac = Widget_text(self.tlb1a3,editable=1,$
  ;  value=Strtrim(String(1.0),2),$
  ;  uname='ATWVOLFRAC',$
  ;  uvalue={object:self,$
  ;  method:'textEvents',$
  ;  id:'ATWVOLFRAC'})
  self.atwvolfrac = Cw_field(self.tlb1a3,/return_events,$     ;,/column
    value=Strtrim(String(1.0),2),$
    uname='ATWVOLFRAC',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWVOLFRAC'},$
    title='Volume Fraction ')

  self.transvolallbutton = Widget_button(self.tlb1a3,value = 'Apply Trans and volfrac',$
    ysize = buttonysize,$
    tooltip = 'Apply trans and volfrac to all current data with same type.',$
    UVALUE={object:self,$
    method:'textEvents',$
    id:'TRANSVOLALLBUTTON'})

  self.atwnarcs = Cw_field(self.tlb1a2,/return_events,$     ;,/column
    value=Strtrim(String(5),2),$
    uname='ATWNARCS',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWNARCS'},$
    title='Number of Q Arcs        ')

  self.atwwidth = Cw_field(self.tlb1a2,/return_events,$     ; ,/column
    value=Strtrim(String(702.0),2),$
    uname='ATWWIDTH',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWWIDTH'},$
    title='GAUSSIAN WIDTH OF ECHOES')

  self.atwperiod = Cw_field(self.tlb1a2,/return_events,$      ; ,/column
    value=Strtrim(String(360.0),2),$
    uname='ATWPERIOD',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWPERIOD'},$
    title='PERIOD OF ECHOES        ')

  ;092504
  ;NEED TO MAKE THIS EDITABLE
  self.atwlambda = Cw_field(self.tlb1a2,/return_events,$      ; ,/column  ;/noedit,$
    value=Strtrim(String(self.lambda*(10.0^10)),2),$
    uname='ATWLAMBDA',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWLAMBDA'},$
    title = 'Lambda (Angstrom)       ')

  magneticlabel = ['nonmagnetic','magnetic'];['No','Yes']

  timeaveragesubbase = Widget_base(self.tlb1a3,/row)

  self.timeaverageupdowncheckbox = Cw_bgroup(timeaveragesubbase,$
    'time average up/down',$;,'apply to all data'], $
    $;ysize = buttonysize,$
    /row, /nonexclusive,$
    $;/no_release,$
    $;frame=1,$
    set_value=0,$
    uname='TIMEAVERAGEUPDOWNCHECKBOX',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'TIMEAVERAGEUPDOWNCHECKBOX'})

  self.timeaverageupdownapplyallbutton = Widget_button(timeaveragesubbase,$
    value='Apply t_ave to all data',$
    tooltip='Apply Time Averaging State to all current data.',$
    ysize = buttonysize,$
    uname='TIMEAVERAGEUPDOWNAPPLYALLBUTTON',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'TIMEAVERAGEUPDOWNAPPLYALLBUTTON'})



  magneticbase = Widget_base(self.tlb1a3,frame=1,/col)
  ;magneticSubBase = widget_base(magneticbase,/row)
  self.magneticcheckbox = Cw_bgroup(magneticbase, 'magnetic', $
    /row, /nonexclusive,$
    /no_release,$
    $;frame=1,$
    set_value=0,$
    uname='MAGNETICCHECKBOX',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'MAGNETICCHECKBOX'})


  self.atwflippingratio = Cw_field(magneticbase,/return_events,/row,$;/noedit,$
    value=0.97,$
    uname='ATWFLIPPINGRATIO',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWFLIPPINGRATIO'},$
    title = 'f (Flipping Ratio) ',/floating,xsize=10,ysize=1)

  self.atwpolarization = Cw_field(magneticbase,/return_events,/row,$;/noedit,$
    value=0.8,$
    uname='ATWPOLARIZATION',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWPOLARIZATION'},$
    title = 'P (Polarization)   ',/floating,xsize=10,ysize=1)


  eff_bpwbase = Widget_base(magneticbase,/row)
  self.atweff_bpw = Cw_field(magneticbase,/return_events,/row,$;/noedit,$
    value=0.81,$
    uname='ATWEFF_BPW',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWEFF_BPW'},$
    title = 'Eff_BPW            ',/floating,xsize=10,ysize=1)

  self.atwxyzupdownscale = Cw_field(magneticbase,/return_events,/row,$;/noedit,$
    value=1.0,$
    uname='ATWXYZUPDOWNSCALE',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'ATWXYZUPDOWNSCALE'},$
    title = 'X,Y,Z Up/Down Scale',/floating,xsize=10,ysize=1)

end;defineTextWidgets


;
;NAME:
;        ooDisplayEcho::dropTimes
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
pro Oodisplayecho::dropTimes,Event

  ;THIS PROCEDURE WILL RECEIVE EVENTS FROM THE NEWLY CREATED dropTimes CONTEXT MENU AND
  ;DROP THE SPECIFIED FOURIER TIME FROM THE CURRENTLY SELECTED DATA OBJECT.

  Widget_control,Event.id,get_uvalue = uval

  ;print,'ooDisplayEcho::dropTimes uval.id=',uval.id
  st = Strtrim(String(*((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='fourierTime'))),2)
  ;print,st
  ;print,where(st eq uval.id)


  ;FOR BETTER CONTROL, THE PARENT OF THIS MENU SHOULD BE A CLASS MEMBER VARIABLE!!!!!!!
  parent = Widget_info(Event.id,/parent)
  ;print,'parent=',parent

  for i=0,N_elements(st)-1 do begin
    id = Widget_info(parent,find_by_uname='DROPTIMEBUTTON'+st[i])
    ;print,id
    Widget_control,id,/destroy
  endfor

end;dropTimes


;
;NAME:
;        ooDisplayEcho::dropTimeEvents
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
pro Oodisplayecho::dropTimeEvents,Event


  ;AS SOON AS THIS EVENT HAPPENS, CREATE THE SUBWIDGETS OF THE
  ;DROPTIMEBASE.
  st = Strtrim(String(*((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='fourierTime'))),2)

end;dropTimeEvents


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;NAME:
;        ooDisplayEcho::reDefineWidgets
;
;PURPOSE:
;               Update all widgets in ooDisplayEcho after some event.
;PARAMETERS:
;               n   Presumably a data object index, but appears to be unused below.
;
;KEYWORDS:
;           t           Selected Fourier time.
;           newsize     Flag for possible dimension change from previous selected data set to current one.
;           resetdataparameters
;           checktime_aveflag   Flag to check for time averaging to set checkbox
;           checkdeepmaskflag   Flag to check object for deepmasking.
;;
;RESET WIDGETS AS NECESSARY ON OPENING OF A
;NEW DATA SET
pro Oodisplayecho::reDefineWidgets,n,t=t,newsize=newsize,resetdataparameters=resetdataparameters,$
  checktime_aveflag=checktime_aveflag,checkdeepmaskflag=checkdeepmaskflag

  if N_elements(checktime_aveflag) eq 0 then checktime_aveflag = 0
  if N_elements(checkdeepmaskflag) eq 0 then checkdeepmaskflag = 0

  ;IN CASE THE SIZE OF THE DATA SET IS DIFFERENT FROM
  ;THE PREVIOUS SET THE newsize CODE BLOCK SHOULD BE RUN.
  if N_elements(newsize) ne 0 then begin

    ;120504
    ;THE NEXT STEP ACCOUNTS FOR CASES
    ;WHERE THE NEWLY READ OBJECT HAS
    ;A DIFFERENT SIZE FROM THE CURRENTLY
    ;SELECTED OBJECT
    ;        self.QChoiceIndex = 0

    if self.qchoiceindex ge self.datacontainer->Count() then self.qchoiceindex = 0
    zeroref = self.datacontainer->Get(position=self.qchoiceindex)
    self.detxdim = zeroref->Getproperty(tag='x_dim')
    self.detydim = zeroref->Getproperty(tag='y_dim')
    self->Updateindices,x=self.detxdim/2,y=self.detydim/2

    if Ptr_valid(self.mye) then Ptr_free,self.mye
    tempe = *(zeroref->Getproperty(tag='e'))
    self.mye = Ptr_new(tempe)

  endif;newsize
 
  if N_elements(resetdataparameters) eq 0 then resetdataparameters = 0

  if self.qchoiceindex ge self.datacontainer->Count() then $
    self.qchoiceindex = self.datacontainer->Count()-1

  if self.qchoiceindex lt 0 then self.qchoiceindex = 0

  ref = self.datacontainer->Get(position=self.qchoiceindex)

  self.filename = ref->Getproperty(tag='filename')
  thisTitle = 'NSE Data Reduction';   Current Data File = '$
  ;+self.filename

  ;NEED TO DISPLAY THE FILE NAMES SOMEWHERE OTHER THEN THE
  ;TLB TITLE.

  Widget_control,self.atwfile,set_value=File_basename(self.filename) $
    +': '+self.comment


  ;UPDATE TLB TITLE TO REFLECT --- THIS DOES NOT WORK!!!
  ;THERE IS NO set_title OPTION IN widget_control.

  ;widget_control,self.atlb,set_title = thisTitle

  ;THE NEXT PART MAY BE BETTER HANDLED BY ASSOCIATING
  ;A Q-VALUE AND FILE NAME WITH EACH DATA FILE READ
  ;AND USING THE Q-INDEX DROPLIST TO ACCESS THEM.
  ;
  ;THIS NEEDS TO BE VARIABLE AND PASSABLE TO THE FITTING ROUTINE

  ;SET DROPLIST INDEX WIDGETS
  tempTauInd = Widget_info(self.adwtau,/droplist_select)

  ;UPDATE 040704
  tauVals = *(ref->Getproperty(tag='fourierTime'))
  ;print,tauVals

  if N_elements(t) gt 0 then begin
    self.ftchoiceindex = t[0]
  endif
  if self.ftchoiceindex ge N_elements(tauVals)-1 then begin
    self.ftchoiceindex = N_elements(tauVals)-1
  endif
  if self.ftchoiceindex le 0 then begin
    self.ftchoiceindex = 0
  endif

  ;110204
  ;
  ;SHOULD SET UP NEXT LINE TO SET SELECT=0 ONLY WHEN SELF.QCHOICEINDEX CHANGES.
  if N_elements(t) eq 0 then begin
    if self.qchoiceindex ne self.qchoiceindexold then begin
      Widget_control,self.adwtau,set_droplist_select=0
    endif else begin
      Widget_control,self.adwtau,set_droplist_select=self.ftchoiceindexold
    endelse
    Widget_control,self.adwtau,set_value=Strtrim(String(10.0^9*tauVals),2)
  endif else begin
    Widget_control,self.adwtau,set_value=Strtrim(String(10.0^9*tauVals),2)
    Widget_control,self.adwtau,set_droplist_select=t
  endelse

  ;SET VALUES IN CONSTANTS SECTION
  num = ref->Getproperty(tag = 'x_dim_orig')
  denom = ref->Getproperty(tag = 'x_dim')
  binFactor = num/denom

  ;THE NEXT LINES DEALT WITH self.atw1 WHEN IT WAS A combobox.
  ;THIS IS NO LONGER THE CASE DUE TO AN INCOMPATIBILTY WITH X11.
  ;NOW IT IS SET UP AS A SERIES OF BUTTONS.

  ;021005
  ;RETURN TO COMBOBOX AND SEE WHAT WENT WRONG.

  Widget_control,self.atw1,get_value=atw1arr

  if N_elements(atw1arr) ne 5 then begin
    atw1arr = ['1','2','4','8','16']
    Widget_control,self.atw1,set_value=Strtrim(String(atw1arr),2)
  endif

  atw1index = Where(atw1arr eq Strtrim(String(binFactor),2))


  ;;;;;widget_control,self.atw1,set_value=strtrim(string(binFactor),2)+' >'
  Widget_control,self.atw1,set_combobox_select = atw1index[0]
  ;    help,atw1index
  ;    print,'SET self.atw1,set_combobox_select = ',atw1index[0]


  if resetdataparameters ne 1 then begin
    Widget_control,self.atwbcx,set_value=Strtrim(String(ref->Getproperty(tag='x_cen_orig')),2)
    Widget_control,self.atwbcy,set_value=Strtrim(String(ref->Getproperty(tag='y_cen_orig')),2)
  endif


  Widget_control,self.atwtrans,$
    set_value=Strtrim(String(ref->Getproperty(tag='transmission')),2)
  Widget_control,self.atwvolfrac,$
    set_value=Strtrim(String(ref->Getproperty(tag='volfrac')),2)


  ;121505
  narcs = (self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='narcs')
  if narcs lt 1 or narcs gt 16 then begin
    narcs = 7
    Widget_control,self.atwnarcs,set_value=Strtrim(String(narcs),2)
  endif

  Widget_control,self.atwnarcs,$
    set_value=Strtrim(String(narcs),2)

  ;040605
  ;SETS EDITABILITY ON SELECTION OF OBJECT
  thetype = (self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='type')
  transeditable = 0
  volfraceditable = 0
  case thetype of
    0:begin
      transeditable = 1
      volfraceditable = 1
    end
    1:begin;res
      transeditable = 0
      volfraceditable = 0
    end
    2:begin;dat
      transeditable = 1
      volfraceditable = 1
    end
    3:begin;cell
      transeditable = 1
      volfraceditable = 0
    end
    else:begin
      transeditable = 1
      volfraceditable = 1
    end
  endcase
  Widget_control,self.atwtrans,editable = transeditable
  Widget_control,self.atwvolfrac,editable = volfraceditable
  ;    help,/traceback

  ;WILL THERE BE A DEEPMASKINGCHECK HERE?????

  if checktime_aveflag eq 1 then begin
    reftavestate = ref->Report_timeaverage_state()
    Widget_control,self.timeaverageupdowncheckbox,set_value=reftavestate
  endif

  if checkdeepmaskflag eq 1 then begin
    reftavestate = ref->Report_deepmask_state()
    Widget_control,self.deepmaskingcheckbox,set_value=reftavestate
  endif

  self.lambda = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag='lambda')
  self.dlambda = (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag='dlambda')

  Widget_control,self.atwlambda,set_value=Strtrim(String(self.lambda*10.0^10),2)
  ;102605
  if Widget_info(self.Atwlambdadist,/valid_id) gt 0 then begin
    Widget_control,self.atwlambdadist,set_value=Strtrim(String(100.0*self.dlambda/self.lambda),2)
  endif

  ;SET VALUES IN FIT PARAMETER WIDGETS
  ;self.fixed = [0,0,0,1,1,1]

  t = self.ftchoiceindex
  ref = self.datacontainer->Get(position=self.qchoiceindex)
  pfixed = (ref->Getproperty(tag='fixed'))

  ;021306
  ;THE NEXT ITEM MUST BE CORRECTED SOMEHOW TO REFLECT 8 CHOICES!!!!
  self.fixed = (*pfixed)[*,self.xindex+self.yindex*self.detxdim,t]
  ;I THINK IT WAS CORRECTED ELSEWHERE AND WORKS FINE HERE NOW.

  fixedstate = ref->Getfixvarystate(self.xindex,self.yindex,self.ftchoiceindex)

  ;TEMPORARY FIX, MULTIPLY self.fixed BY 4
  for iii=0,N_elements(self.fixed)-1 do begin
    self->Updatefitparmwidget,iii,fixedstate[iii];4*self.fixed[iii]
  endfor;iii

  thenewbasetitle = 'NSE Data Reduction     ' + $
    File_basename(ref->Getproperty(tag='filename')) + $
    ': ' + $
    ref->Getproperty(tag='comment')

  Widget_control,self.atlb,base_set_title=thenewbasetitle

end;reDefineWidgets


;
;NAME:
;        ooDisplayEcho::resizeWidgets
;
;PURPOSE:
;           Handle resizing aspect of atlbevents.
;PARAMETERS:
;           event   The event structure to handle.
;KEYWORDS:
;           lastresize  On Mac and Linux, the resize events don't seem
;                       to be triggered the same way as on Windows,
;                       so this keyword will be used on a second resizing
;                       called for non-Win32 systems.
pro Oodisplayecho::resizeWidgets,Event,lastresize=lastresize

  if N_elements(lastresize) eq 0 then lastresize = 0

  ;GETTING SCREEN SIZE TO TRY TO LIMIT GROWTH ON A MAC
  r = Get_screen_size()

  if !version.os eq 'Win32' then begin
    xresizemagic = 0
    yresizemagic = 0
  endif else begin
    xresizemagic = 10
    yresizemagic = 40
  endelse

  ;013105
  if Event.x lt 770 then begin    ;DROP SIZES FROM 800x600 TO 770x500 FOR MAC X11
    self.atlbxsize=770
  endif else begin
    if Event.x ge (r[0]-50) then begin
      self.atlbxsize=r[0]-50
    endif else begin
      self.atlbxsize=Event.x-xresizemagic
    endelse
  endelse
  if Event.y lt 550 then begin
    self.atlbysize=550
  endif else begin
    if Event.y ge (r[1]-50) then begin
      self.atlbysize=r[1]-50
    endif else begin
      self.atlbysize=Event.y-yresizemagic
    endelse
  endelse


  ;LRK - 07/10/09
  ;DON'T RESIZE THE FILETREE - IT HIDES THE SCROLLBARS!!!
  ;
  ;self.filetreeysize = min([550,self.atlbysize - self.ypadding])
  self.tabsysize = Min([550,self.atlbysize - self.ypadding])

  if N_elements(plotxsize) gt 0 then begin
    self.plotxsize = plotxsize
  endif else begin
    self.plotxsize = Fix(self.atlbxsize - $;self.filetreexsize - $
      self.filetreexpadding - self.tabsxsize - self.tabsxpadding - self.xpadding-self.magicxpadding)
  endelse

  ;033005
  ;MOVE CLICK REFIT SLIDERS TO A SEPARATE FLOATING DIALOG
  if N_elements(plotysize) gt 0 then begin
    self.plotysize = plotysize
  endif else begin
    ;        self.plotysize = fix((self.atlbysize - self.ypadding - $
    ;                            self.clickphaseysize - self.taucdysize - self.tw1ysize-self.magicypadding)/2)
    self.plotysize = Fix((self.atlbysize - self.ypadding - $
      self.taucdysize - self.tw1ysize-self.magicypadding)/2)
  endelse

  self.drawbasexsize = self.plotxsize
  self.drawbaseysize = 2*self.plotysize + self.taucdysize + self.tw1ysize;+ self.clickphaseysize + self.tw1ysize

  ;021105
  ;NOW ADJUST THE WINDOW SIZES
  Widget_control,self.dw1,xsize= self.plotxsize,ysize=self.plotysize
  Widget_control,self.dw2,xsize= self.plotxsize,ysize=self.plotysize
  ;060605
  if Ptr_valid(self.geomimage) gt 0 then Ptr_free,self.geomimage
  self.geomimage = Ptr_new(Widget_info(self.dw1,/geometry))
  if Ptr_valid(self.geomplot) gt 0 then Ptr_free,self.geomplot
  self.geomplot = Ptr_new(Widget_info(self.dw2,/geometry))

  ;RUN THIS WIDGET A SECOND TIME ON Mac AND UNIX.
  if !Version.os ne 'Win32' and lastresize eq 0 then begin
    self->Resizewidgets,Event,lastresize=1
  endif else begin
    ;            wdelete,self.dw1pix & wdelete,self.dw2pix
    Wdelete,self.dw1pix
    Wdelete,self.dw2pix

    ;CREATE PIXMAP WINDOW FOR DOUBLE BUFFERING OF IMAGE WINDOW
    Window,/free,/pixmap,xsize=self.plotxsize,$
      ysize=self.plotysize
    self.dw1pix = !d.window
    ;RELEASE AXIS POINTERS FOR WINDOW
    Ptr_free,self.w1xptr
    Ptr_free,self.w1yptr

    ;RESET AXIS POINTERS
    self.w1xptr = Ptr_new(!x)   ;SET THESE VALUES AT THIS POINT TO
    self.w1yptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION


    ;CREATE PIXMAP WINDOW FOR DOUBLE BUFFERING OF PLOT WINDOW
    Window,/free,/pixmap,xsize=self.plotxsize,$
      ysize=self.plotysize
    self.dw2pix = !d.window

    ;RELEASE AXIS POINTERS FOR WINDOW
    Ptr_free,self.w2xptr
    Ptr_free,self.w2yptr

    ;RESET AXIS POINTERS
    self.w2xptr = Ptr_new(!x)   ;SET THESE VALUES AT THIS POINT TO
    self.w2yptr = Ptr_new(!y)   ;PREVENT AXIS CONFUSION
  endelse
end;resizeWidgets


;
;NAME:
;        ooDisplayEcho::defineCDControls
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
pro Oodisplayecho::defineCDControls,base=base

  ;CREATE CD CONTROLS FOR SELECTING FILE,TAU INDICES


  ;092204
  ;
  ;OBVIOUSLY THIS SHOULD BE A COMPOUND WIDGET!!!
  ;
  buttonysize = 20
  ;    tauTempBase = widget_base(self.tlb1a2,/row)
  ;    tauTempBase = widget_base(self.tlb1b,/row)
  ;    self.atl6 = widget_label(tauTempBase,value='Fourier Time (ns)');,xsize=95)

  if N_elements(base) eq 0 then base=self.tlb1b

  ;self.atl6 = widget_label(base,value='Fourier Time (ns)',/align_left);,xsize=95)
  tauTempBase = Widget_base(base,/row,/KBRD_FOCUS_EVENTS,$;/context_events,$  ;CONTEXT EVENTS HERE RUIN X11 VERSION!!!
    uname='DROPTIMEBASE',$
    uvalue={object:self,$
    method:'dropTimeEvents',$
    id:'DROPTIMEBASE'})

  ;020105
  ;
  ;THIS CONTEXT BASE DOES NOT WORK PROPERLY.  FOR SOME REASON SUB-BUTTONS
  ;ARE NOT DESTROYED WITH A CALL TO widget_control,id,/destroy, SO I
  ;END UP WITH A HUGE NUMBER OF BUTTONS FLOATING AROUND AFTER A COUPLE CALLS.
  ;
  ;;;    ;011005
  ;;;    ;SET UP BASE FOR CONTEXT MENU HERE AND POPULATE WITH BUTTONS WHEN CALLED.
  ;;;    ;i.e. IN THE METHOD dropTimeEvents
  ;;;    ;
  ;;;
  ;;;    contextBase = widget_base(tauTempBase,/context_menu,$
  ;;;                                    uname='DROPTIMEBASE',$
  ;;;                                    uvalue={object:self,$
  ;;;                                            method:'dropTimeEvents',$
  ;;;                                            id:'DROPTIMEBASE'})
  ;;;


  self.atl6 = Widget_label(tauTempBase,$
    value='Fourier Time (ns)',$
    /align_left)

  self.rewbuttontau = Widget_button(tauTempBase,$
    value = '|<',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'REWBUTTONTAU'})
  self.revbuttontau = Widget_button(tauTempBase,$
    value = '<',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'REVBUTTONTAU'})

  ;UPDATE 040704
  tauVals = *((self.datacontainer->Get(position=self.qchoiceindex))->Getproperty(tag='fourierTime'))

  self.adwtau = Widget_droplist(tauTempBase,$
    $;value=string(*self.ftChoices),$
    value=Strtrim(String(10.0^9*tauVals),2),$
    $;title="Select Fourier Time Index",$
    $;event_pro="displayEcho_droplistevent",$
    xsize = 100,$
    uname="DROPFT",$
    uvalue={object:self,method:'droplistEvents',id:'DROPFT'});uvalue='DROPFT',$

  self.fwdbuttontau = Widget_button(tauTempBase,$
    value = '>',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FWDBUTTONTAU'})
  self.ffwdbuttontau = Widget_button(tauTempBase,$
    value = '>|',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FFWDBUTTONTAU'})

end;defineCDControls


;
;NAME:
;        ooDisplayEcho::defineMaskButton
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
pro Oodisplayecho::defineMaskButton

  buttonysize=20

  ;self.tlb1a2 IS THE GENERAL PROPERTIES TAB.
  ;self.tlb1a3 IS THE SAMPLE PROPERTIES TAB.


  self.maskbutton = Widget_button(self.tlb1a3,$
    value = 'Alter Mask',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTON'})

  maskButtonApply = Widget_button(self.tlb1a3,$
    value = 'Apply Mask to All Fourier Times',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'MASKBUTTONAPPLY'})

end;defineMaskButton
pro Oodisplayecho::defineFitWidgets,plotxsize=plotxsize,plotysize=plotysize
  ;
  ;NAME:
  ;        ooDisplayEcho::defineFitWidgets
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.



  ;092104
  ;
  ;NEED TO ALTER LAYOUT TO FIT EVERYTHING FOR MAC X11 WINDOW!!!


  ;092404
  ;ADD subbase TO THE UPCOMING self.thetabs

  ;CREATE NEW BASE LAYOUT TO ACCOMODATE THE BUTTONS AND FIELDS.
  subbase = Widget_base(self.tlb1b,/col)
  leftbase = Widget_base(subbase,/col) ;PUT ALL ACTION BUTTONS HERE.
  rightbase = Widget_base(subbase,/col);PUT FIT PARAMETERS HERE.





  ;;
  ;TEXT AND BUTTON WIDGETS FOR FIT PARAMETERS AND LIMITS
  ;;;


  buttonysize = 20

  ;    self.phaseImportButton = widget_button(self.tlb1b,$
  ;                                            $;value = 'Import Phases AND FIT ALL TAU',$

  ;    self.phaseImportButton = widget_button(leftbase,$
  ;                                            $;value = 'Import Phases AND FIT ALL TAU',$
  ;                                            value = 'IMPORT PHASES and FIT',$
  ;                                            ysize=buttonysize,$
  ;                                            uvalue={object:self,$
  ;                                                    method:'buttonEvents',$
  ;                                                    id:'PHASEIMPORTBUTTON'})



  ;THE EVENT HANDLER FOR THIS BUTTON SHOULD
  ;   1) POP UP A WINDOW WITH AVAILABLE FILES WITH THE SAME
  ;      Q, no_of_fourier_times, x_dim, y_dim  (use info = dataObj->matchInfo())
  ;   2) IF A PHASE ARRAY IS SELECTED:
  ;        SET self.fixed = [0,0,1,1,1,1] (CHECK FORM OF self.chirpFun)
  ;        AND UPDATE THE FIT WIDGETS
  ;   3) WHEN THE PHASE ARRAY IS SELECTED, THE PHASE VALUES
  ;      ARE SIMPLY REPLACED IN A STATEMENT LIKE
  ;      (*self.fitparms)[2,*,*] = dataObj->phaseArray()
  ;   4) THERE WILL BE A FITTING ROUTINE THAT FITS THE OFFSET
  ;      (P[5]) FOR THE CENTRAL PIXEL AND THEN FIXES THE VALUE
  ;      FOR THE ENTIRE ARRAY: (*self.fitparms)[2,*,*] = newOffset
  ;      THIS FIT SHOULD OCCUR AFTER THE OTHER PARAMETERS
  ;      ARE SET BY EARLIER FITS.  PERHAPS THERE SHOULD BE A
  ;      SEPARATE fitall ROUTINE IN THE DATA CLASS THAT GOES THROUGH
  ;      THE RIGHT STEPS.
  ;
  ;
  ;
  ;
  ;   AFTER THIS THERE MUST BE A CONVERT TO Q OPTION
  ;
  ;   AN EXPORT OPTION FOR FIT PARAMETERS (TO SAVE REDUCTION STATES)
  ;
  ;   AN EXPORT OPTION FOR S(Q,t)
  ;
  ;   A CALCULATE S(Q,t) OPTION THAT CHECKS ON LAMBDA, XCEN, YCEN,
  ;   AND KNOWS DETECTOR SIZE AND SAMPLE-TO-DETECTOR DISTANCE
  ;   (CHECK NICK'S CODE FOR THIS)
  ;
  ;




  options = ['arc','spiral','expand']
  fieldnames = ['t1','t2']
  self.fitselector = Cwo_pickmethod(leftbase,Options,fieldnames,$
    ysize=30,$
    obj_ref=the_pickmethod_obj_ref,frame=2,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTONALL'})

  self.fitselectorobj = the_pickmethod_obj_ref

  ;    tempButtonBase = widget_base(self.tlb1b,/row)
  tempButtonBase = Widget_base(leftbase,/row)
  ;void = widget_label(tempButtonBase,value='Fit opts:')
  self.fitbutton1 = Widget_button(tempButtonBase,$
    value = 'fit pixel',$;value = 'fit single pixel',$
    tooltip = 'Fit the echo at the selected pixel',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTON1'})
  self.fitbutton = Widget_button(tempButtonBase,$
    $;value = 'Fit All Echoes (This Tau)',$
    value = 'smooth t',$;value = 'smooth phases (this t)',$
    tooltip = 'Fit all echoes at this Fourier time and "smooth" phases.',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTON'})


  ;110304
  ;
  ;REMOVING THE NEXT BUTTON SINCE IT IS NOW REDUNDANT
  ;DUE TO THE cwo_pickmethod WIDGET.
  ;
  ;
  ;    self.fitbuttonall = widget_button(tempButtonBase,$
  ;                                    $;value = 'Fit All Echoes (This Data File)',$
  ;                                    value = 'All',$
  ;                                    tooltip = 'Fit all echoes in this file)',$
  ;                                    ysize=buttonysize,$
  ;                                    uvalue={object:self,$
  ;                                            method:'buttonEvents',$
  ;                                            id:'FITBUTTONALL'})
  ;    self.fitbuttonallQ = widget_button(tempButtonBase,$
  ;                                    value = 'Fit All Data',$
  ;                                    uvalue={object:self,$
  ;                                            method:'buttonEvents',$
  ;                                            id:'FITBUTTONALLQ'})

  ;    tempButtonBase2 = widget_base(self.tlb1b,/row)

  tempButtonBase2 = Widget_base(leftbase,/row)



  ;120604
  ;
  ;REMOVE NEXT TWO BUTTONS FOR NOW.
  ;121404 Dobrin wants these.
  ;    self.fitbuttonallminus360 = widget_button(tempButtonBase2,$
  self.fitbuttonallminus360 = Widget_button(tempButtonBase,$
    value = '-360 refit',$
    tooltip = 'Shift all phases -360deg and refit',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTONALLMINUS360'})
  ;    self.fitbuttonallplus360 = widget_button(tempButtonBase2,$
  self.fitbuttonallplus360 = Widget_button(tempButtonBase,$
    value = '+360 refit',$
    tooltip = 'Shift all phases +360deg and refit',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTONALLPLUS360'})

  self.phaseimportbutton = Widget_button(leftbase,$
    $;value = 'Import Phases AND FIT ALL TAU',$
    value = 'IMPORT PHASES',$
    tooltip = 'Fit all echoes using phases from another data set',$
    ysize=buttonysize,$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'PHASEIMPORTBUTTON'})

  ;    options = ['arc','spiral','expand']
  ;    fieldnames = ['t1','t2']
  ;    self.fitselector = cwo_pickmethod(leftbase,options,fieldnames,$
  ;                            obj_ref=the_pickmethod_obj_ref,frame=2,$
  ;                            uvalue={object:self,$
  ;                                    method:'buttonEvents',$
  ;                                    id:'FITBUTTONALL'})
  restoreBut = Widget_button(leftbase,value='Restore Previous Fitparms',$
    tooltip = 'Restore fit parameters to the values just before the most recent action.',$
    uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITPARMRESTOREBUTTON'})

  Widget_control,self.fitselector,set_uvalue={object:self,$
    method:'buttonEvents',$
    id:'FITBUTTONALL'}




  ;THIS NEEDS TO BE VARIABLE AND PASSABLE TO THE FITTING ROUTINE

  ;021306
  ;    fixvary = ['vary','fix']

  self.fixed = [0,0,0,1,1,1]

  if !version.os ne 'Win32' then begin
    fixvary = ['v this pix this t','v this pix all t',$
      'v all pix this t','v all pix all t',$
      'f this pix this t','f this pix all t',$
      'f all pix this t','f all pix all t',$
      'f all to C Vals']
    atl1atext ='Fit/Start Parameters: f=fix, v=vary, C = current'
  endif else begin
    fixvary = ['vary this pixel this t','vary this pixel all t',$
      'vary all pixel this t','vary all pixel all t',$
      'fix this pixel this t','fix this pixel all t',$
      'fix all pixel this t','fix all pixel all t',$
      'fix all to Current Vals']
    atl1atext ='Fit/Start Parameters: '
  endelse




  tempBase = Widget_base(rightbase,/row)
  self.atl1a = Widget_label(tempBase,value=atl1atext)
  ;self.atl1a = widget_label(tempBase,value='Parameter Limits')
  ;CONSTANT FIT PARAMETER
  ;    self.constbase = widget_base(self.tlb1b,/row)
  self.constbase = Widget_base(rightbase,/row)
  self.dropfixconst = Widget_droplist(self.constbase,$
    value=fixvary,$
    uname="DROPFIXCONST",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXCONST'})
  Widget_control,self.dropfixconst,set_droplist_select=0;self.fixed[0]

  twxsize = 8

  ;    void = widget_label(self.constbase,value='AVERAGE',xsize = 70)
  void = Widget_button(self.constbase,value='Av',$;'P0',$
    xsize = 20,$
    tooltip='AVERAGE')
  self.atwconst = Widget_text(self.constbase,/editable,$
    value=Strtrim(String((self.startparms)[0]),2),$
    uname='ATWCONST',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWCONST'})
  void = Widget_label(self.constbase,value='+/-')
  self.atweconst = Widget_text(self.constbase,$
    value='0.0',$
    uname='ATWECONST',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWECONST'})


  ;AMPLITUDE FIT PARAMETER
  ;    self.ampbase = widget_base(self.tlb1b,/row)
  self.ampbase = Widget_base(rightbase,/row)
  ;    self.dropfixAmpPcheck = cw_bgroup(self.ampbase)
  self.dropfixamp = Widget_droplist(self.ampbase,$
    value=fixvary,$
    uname="DROPFIXAMP",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXAMP'})
  Widget_control,self.dropfixamp,set_droplist_select=0;self.fixed[1]

  ;    void = widget_label(self.ampbase,value='AMPLITUDE',xsize = 70)
  void = Widget_button(self.ampbase,value='A',$;'P1',$
    xsize = 20,$
    tooltip='AMPLITUDE')
  self.atwamp = Widget_text(self.ampbase,/editable,$
    value=Strtrim(String((self.startparms)[1]),2),$
    uname='ATWAMP',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWAMP'})
  void = Widget_label(self.ampbase,value='+/-')
  self.atweamp = Widget_text(self.ampbase,$
    value='0.0',$
    uname='ATWEAMP',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWEAMP'})

  ;PHASEo FIT PARAMETER
  ;    self.phaseobase = widget_base(self.tlb1b,/row)
  self.phaseobase = Widget_base(rightbase,/row)
  self.dropfixphaseo = Widget_droplist(self.phaseobase,$
    value=fixvary,$
    uname="DROPFIXPHASEO",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXPHASEO'})
  Widget_control,self.dropfixphaseo,set_droplist_select=0;self.fixed[2]

  ;    void = widget_label(self.phaseobase,value='PHASEo',xsize = 70)
  void = Widget_button(self.phaseobase,value='PH',$;'P2',$
    xsize = 20,$
    tooltip='PHASE')
  self.atwphaseo = Widget_text(self.phaseobase,/editable,$
    value=Strtrim(String((self.startparms)[2]),2),$
    uname='ATWPHASEO',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWPHASEO'})
  void = Widget_label(self.phaseobase,value='+/-')
  self.atwephaseo = Widget_text(self.phaseobase,$
    value='0.0',$
    uname='ATWEPHASEO',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWEPHASEO'})


  ;
  ;092204
  ;
  ;THESE NEXT THREE SHOULD BE PLACED BENEATH THE PLOTS FOR NOW.
  ;
  ;IS THIS METHOD RUN BEFORE OR AFTER THE DRAW WIDGETS ARE
  ;CREATED???  IT MUST BE RUN AFTER FOR THIS TO WORK.
  ;
  ;SET THEM UNDER self.tlb2

  ;092404
  ;
  ;IMPLEMENTING TAB WIDGETS.  PLACE ALL FIT WIDGETS ON THE
  ;rightbase SO THAT THEY SHOW UP ON THE TABS.
  ;

  ;SIGMA FIT PARAMETER
  ;    self.sigmabase = widget_base(self.tlb1b,/row)


  self.sigmabase = Widget_base(rightbase,/row)
  ;    self.sigmabase = widget_base(self.tlb2,/row)
  self.dropfixsigma = Widget_droplist(self.sigmabase,$
    value=fixvary,$
    uname="DROPFIXSIGMA",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXSIGMA'})

  Widget_control,self.dropfixsigma,set_droplist_select=4;self.fixed[3]
  ;    void = widget_label(self.sigmabase,value='SIGMA',xsize = 70)
  ;    void = widget_label(self.sigmabase,value='WIDTH',xsize = 70)
  void = Widget_button(self.sigmabase,value='W',$;'P3',$
    xsize = 20,$
    tooltip='GAUSSIAN WIDTH')
  self.atwsigma = Widget_text(self.sigmabase,$
    value=Strtrim(String((self.startparms)[3]),2),$
    uname='ATWSIGMA',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWSIGMA'})
  void = Widget_label(self.sigmabase,value='+/-')
  self.atwesigma = Widget_text(self.sigmabase,$
    value='0.0',$
    uname='ATWESIGMA',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWESIGMA'})

  ;OMEGA FIT PARAMETER
  ;    self.omegabase = widget_base(self.tlb1b,/row)
  self.omegabase = Widget_base(rightbase,/row)
  ;    self.omegabase = widget_base(self.tlb2,/row)
  self.dropfixomega = Widget_droplist(self.omegabase,$
    value=fixvary,$
    uname="DROPFIXOMEGA",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXOMEGA'})
  Widget_control,self.dropfixomega,set_droplist_select=0;self.fixed[4]

  ;    void = widget_label(self.omegabase,value='OMEGA',xsize = 70)
  ;    void = widget_label(self.omegabase,value='360/period',xsize = 70)
  ;    void = widget_label(self.omegabase,value='P4',xsize = 15,tooltip = 'omega = 360deg/period')


  ;120904
  ;
  ;SO NOT TO BREAK ANY OF THE ooEcho CODE, I WILL CONVERT THIS
  ;TO DISPLAY THE PERIOD VALUE HERE, BUT I WILL REVERSE-ENGINEER
  ;ALL THE OTHER PLACES IN ooDisplayEcho TO AGREE WITH THIS.
  ;
  ;    void = widget_button(self.omegabase,value='P4',xsize = 20,$
  ;                    tooltip = 'OMEGA = 360deg/(ECHO PERIOD)')
  ;    self.atwomega = widget_text(self.omegabase,$
  ;                                value=strtrim(string((self.startparms)[4]),2),$
  ;                                uname='ATWOMEGA',xsize = 12,$
  ;                                uvalue={object: self,$
  ;                                                method:'textEvents',$
  ;                                                id:'ATWOMEGA'})
  void = Widget_button(self.omegabase,value='T',$;'P4',$
    xsize = 20,$
    tooltip = 'ECHO PERIOD')
  self.atwomega = Widget_text(self.omegabase,$
    value=Strtrim(String((360.0/self.startparms)[4]),2),$
    uname='ATWOMEGA',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWOMEGA'})
  void = Widget_label(self.omegabase,value='+/-')
  self.atweomega = Widget_text(self.omegabase,$
    value='0.0',$
    uname='ATWEOMEGA',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWEOMEGA'})

  ;PHASE FIT PARAMETER
  ;    self.phasebase = widget_base(self.tlb1b,/row)
  ;    self.phasebase = widget_base(rightbase,/row)


  ;033005
  ;MAKE THIS STILL EXIST TO KEEP METHODS DEPENDENT ON IT FROM
  ;CRASHING, BUT MAKE IT DISAPPEAR
  self.phasebase = Widget_base(group_leader = self.atlb,/row)


  ;    self.phasebase = widget_base(self.tlb2,/row)
  self.dropfixphase = Widget_droplist(self.phasebase,$
    value=fixvary,$
    uname="DROPFIXPHASE",$
    uvalue={object:self,$
    method:'droplistEvents',$
    id:'DROPFIXPHASE'})
  Widget_control,self.dropfixphase,set_droplist_select=4;self.fixed[5]

  ;    void = widget_label(self.phasebase,value='PHASE',xsize = 70)
  ;    void = widget_label(self.phasebase,value='PHASE OFFSET',xsize = 70)
  void = Widget_button(self.phasebase,value='OS',$;'P5',$
    xsize = 20,$
    tooltip = 'PHASE OFFSET')
  self.atwphase = Widget_text(self.phasebase,$
    value=Strtrim(String((self.startparms)[5]),2),$
    uname='ATWPHASE',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWPHASE'})
  void = Widget_label(self.phasebase,value='+/-')          ; '±'
  self.atwephase = Widget_text(self.phasebase,$
    value='0.0',$
    uname='ATWEPHASE',xsize = twxsize,$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWEPHASE'})


  self.atwchisq = Cw_field(rightbase,title='chi squared     ',$
    xsize=twxsize,/row,$
    /noedit,value='Nan',$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWCHISQ'})


  self.atwratio = Cw_field(rightbase,title='A/(fon-foff)    ',$
    xsize=twxsize,/row,$
    /noedit,value='1.0',$
    uvalue={object: self,$
    method:'textEvents',$
    id:'ATWRATIO'})


  ;092104
  ;    void = widget_label(self.tlb1b,$
  ;    void = widget_label(rightbase,$
  ;            value='I = B ')

  ;    void = widget_label(rightbase,$
  ;            value='I = B - A*exp(-1.0*((phase - phaseo+offset)/(2.0*sigma))^2)')


;  eqn1 = 'I=Av-Aexp(-(((phase-PH)/W)^2)/2)*'
;  eqn2 = 'cos((360/T)*(phase-PH))'
  eqn1 = 'I=Av-Aexp(-(((phase-PH)/W)^2)/2)*'+'cos((360/T)*(phase-PH))'


  ;033005
  ;REMOVE MENTION OF P5
  void = Widget_label(rightbase,value=eqn1)
  ;void = Widget_label(rightbase,value=eqn2)

  ;    void = widget_label(rightbase,$
  ;            value='I = P0 ')
  ;
  ;    void = widget_label(rightbase,$
  ;            value=' - P1*exp(-1.0*((phase - P2)/(2.0*P3))^2)')
  ;
  ;    void = widget_label(rightbase,$
  ;            value='*cos((360/P4)*(phase-P2))')

  ;;    void = widget_label(rightbase,$
  ;;            value=' - P1*exp(-1.0*((phase - P2+P5)/(2.0*P3))^2)')
  ;;
  ;;    void = widget_label(rightbase,$
  ;;            value='*cos((360/P4)*(phase-P2+P5))')
  ;;;            value='y = const - amp*exp(-1.0*((X - phaseo)/(2.0*sigma))^2)'$
  ;;;                    +'*cos(omega*(X+phaseo+phase))')

  ;;
  ;LIMITS WIDGETS
  ;;;
  ;;;;;    void = widget_label(self.tlb1b,value='PARAMETER LIMITS')
  ;;;;;    limorno = ['unlimited','limited']
  self.limited = [0,0,0,0,0,0]
  self.maskbase = 0L

  ;;;;;    ;CONSTANT FIT PARAMETER LIMITS
  ;;;;;    self.limconstbase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitconst = widget_droplist(self.limconstbase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITCONST",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITCONST'})
  ;;;;;    widget_control,self.droplimitconst,set_droplist_select=self.limited[0]
  ;;;;;    void = widget_label(self.limconstbase,value='CONST LIMS',xsize = 90)
  ;;;;;    ;void = widget_label(self.constbase,value='CONST LIMS',xsize = 90)
  ;;;;;    self.atwminlimconst = widget_text(self.limconstbase,$
  ;;;;;    $;self.atwminlimconst = widget_text(self.constbase,$
  ;;;;;                                editable = self.limited[0],$
  ;;;;;                                value='1.0',$
  ;;;;;                                uname='ATWMINLIMCONST',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMCONST'})
  ;;;;;    void = widget_label(self.limconstbase,value='->')
  ;;;;;    ;void = widget_label(self.constbase,value='->')
  ;;;;;    self.atwmaxlimconst = widget_text(self.limconstbase,$
  ;;;;;    $;self.atwmaxlimconst = widget_text(self.constbase,$
  ;;;;;                                editable = self.limited[0],$
  ;;;;;                                value='5000.0',$
  ;;;;;                                uname='ATWMAXLIMCONST',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMCONST'})
  ;;;;;
  ;;;;;    ;AMPLITUDE FIT PARAMETER LIMITS
  ;;;;;    self.limampbase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitamp = widget_droplist(self.limampbase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITAMP",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITAMP'})
  ;;;;;    widget_control,self.droplimitamp,set_droplist_select=self.limited[1]
  ;;;;;    void = widget_label(self.limampbase,value='AMPLITUDE LIMS',xsize = 90)
  ;;;;;    self.atwminlimamp = widget_text(self.limampbase,$
  ;;;;;                                editable = self.limited[1],$
  ;;;;;                                value='10.0',$
  ;;;;;                                uname='ATWMINLIMAMP',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMAMP'})
  ;;;;;    void = widget_label(self.limampbase,value='->')
  ;;;;;    self.atwmaxlimamp = widget_text(self.limampbase,$
  ;;;;;                                editable = self.limited[1],$
  ;;;;;                                value='20000.0',$
  ;;;;;                                uname='ATWMAXLIMAMP',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMAMP'})
  ;;;;;
  ;;;;;    ;PHASEO FIT PARAMETER LIMITS
  ;;;;;    self.limphaseobase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitphaseo = widget_droplist(self.limphaseobase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITPHASEO",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITPHASEO'})
  ;;;;;    widget_control,self.droplimitphaseo,set_droplist_select=self.limited[2]
  ;;;;;    void = widget_label(self.limphaseobase,value='PHASEO LIMS',xsize = 90)
  ;;;;;    self.atwminlimphaseo = widget_text(self.limphaseobase,$
  ;;;;;                                editable = self.limited[2],$
  ;;;;;                                value='-1999.0',$
  ;;;;;                                uname='ATWMINLIMPHASEO',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMPHASEO'})
  ;;;;;    void = widget_label(self.limphaseobase,value='->')
  ;;;;;    self.atwmaxlimphaseo = widget_text(self.limphaseobase,$
  ;;;;;                                editable = self.limited[2],$
  ;;;;;                                value='2000.0',$
  ;;;;;                                uname='ATWMAXLIMPHASEO',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMPHASEO'})
  ;;;;;
  ;;;;;    ;SIGMA FIT PARAMETER LIMITS
  ;;;;;    self.limsigmabase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitsigma = widget_droplist(self.limsigmabase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITASIGMA",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITSIGMA'})
  ;;;;;    widget_control,self.droplimitsigma,set_droplist_select=self.limited[3]
  ;;;;;    void = widget_label(self.limsigmabase,value='SIGMA LIMS',xsize = 90)
  ;;;;;    self.atwminlimsigma = widget_text(self.limsigmabase,$
  ;;;;;                                editable = self.limited[3],$
  ;;;;;                                value='10.0',$
  ;;;;;                                uname='ATWMINLIMSIGMA',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMSIGMA'})
  ;;;;;    void = widget_label(self.limsigmabase,value='->')
  ;;;;;    self.atwmaxlimsigma = widget_text(self.limsigmabase,$
  ;;;;;                                editable = self.limited[3],$
  ;;;;;                                value='20000.0',$
  ;;;;;                                uname='ATWMAXLIMSIGMA',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMSIGMA'})
  ;;;;;
  ;;;;;    ;OMEGA FIT PARAMETER LIMITS
  ;;;;;    self.limomegabase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitomega = widget_droplist(self.limomegabase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITOMEGA",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITOMEGA'})
  ;;;;;    widget_control,self.droplimitomega,set_droplist_select=self.limited[4]
  ;;;;;    void = widget_label(self.limomegabase,value='OMEGA LIMS',xsize = 90)
  ;;;;;    self.atwminlimomega = widget_text(self.limomegabase,$
  ;;;;;                                editable = self.limited[4],$
  ;;;;;                                value='0.5',$
  ;;;;;                                uname='ATWMINLIMOMEGA',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMOMEGA'})
  ;;;;;    void = widget_label(self.limomegabase,value='->')
  ;;;;;    self.atwmaxlimomega = widget_text(self.limomegabase,$
  ;;;;;                                editable = self.limited[4],$
  ;;;;;                                value='10.0',$
  ;;;;;                                uname='ATWMAXLIMOMEGA',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMOMEGA'})
  ;;;;;
  ;;;;;    ;PHASE FIT PARAMETER LIMITS
  ;;;;;    self.limphasebase = widget_base(self.tlb1b,/row)
  ;;;;;    self.droplimitphase = widget_droplist(self.limphasebase,$
  ;;;;;                                value=limorno,$
  ;;;;;                                uname="DROPLIMITPHASE",$
  ;;;;;                                uvalue={object:self,$
  ;;;;;                                        method:'droplistEvents',$
  ;;;;;                                        id:'DROPLIMITPHASE'})
  ;;;;;    widget_control,self.droplimitphase,set_droplist_select=self.limited[5]
  ;;;;;    void = widget_label(self.limphasebase,value='PHASE LIMS',xsize = 90)
  ;;;;;    self.atwminlimphase = widget_text(self.limphasebase,$
  ;;;;;                                editable = self.limited[5],$
  ;;;;;                                value='-1999.0',$
  ;;;;;                                uname='ATWMINLIMPHASE',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMINLIMPHASE'})
  ;;;;;    void = widget_label(self.limphasebase,value='->')
  ;;;;;    self.atwmaxlimphase = widget_text(self.limphasebase,$
  ;;;;;                                editable = self.limited[5],$
  ;;;;;                                value='2000.0',$
  ;;;;;                                uname='ATWMAXLIMPHASE',xsize = 7,$
  ;;;;;                                uvalue={object: self,$
  ;;;;;                                                method:'textEvents',$
  ;;;;;                                                id:'ATWMAXLIMPHASE'})

end;defineFitWidgets
function Oodisplayecho::icon,reduced,type
  ;
  ;NAME:
  ;        ooDisplayEcho::icon
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;RETURN VALUE:
  ;

  i = Intarr(16,16,3)

  if reduced ne 0 then begin
    i[*,*,0] = 0
    i[*,*,1] = 255
    i[*,*,2] = 0
  endif else begin
    i[*,*,0] = 255
    i[*,*,1] = 0
    i[*,*,2] = 0
  endelse

  case type of
    0:  begin       ;UNTYPED
      i[4:11,4:11,0] = 0
      i[4:11,4:11,1] = 0
      i[4:11,4:11,2] = 0
    end
    1:  begin       ;RESOLUTION
      i[4:11,4:11,0] = 255
      i[4:11,4:11,1] = 0
      i[4:11,4:11,2] = 0
    end
    2:  begin       ;DATA
      i[4:11,4:11,0] = 0
      i[4:11,4:11,1] = 255
      i[4:11,4:11,2] = 0
    end
    3:  begin       ;BACKGROUND
      i[4:11,4:11,0] = 0
      i[4:11,4:11,1] = 0
      i[4:11,4:11,2] = 255
    end
  endcase

  Return,i
end;icon
pro Oodisplayecho::createFTWLeaf,wid_id,parent,pos,element
  ;
  ;NAME:
  ;        ooDisplayEcho::createFTWLeaf
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;CREATE THE BOTTOM-MOST LEAVES ON THE DATA TREE

  ;print,'COUNT=',(self.dataContainer)->count()
  ;print,'POS  =',pos
  if pos lt (self.datacontainer)->Count() then begin
    theRef = self.datacontainer->Get(position=pos)
    comment = theRef->Getproperty(tag='comment')
    filename =  File_basename(theRef->Getproperty(tag='filename'))
    type =  theRef->Getproperty(tag='type')
    reduced =  theRef->Getproperty(tag='reduced')
    wid_id = Widget_tree(parent,value=filename+': '+comment,$
      group_leader=parent,$
      bitmap = self->Icon(reduced,type),$
      uvalue={object:self,$
      dataobject:theRef,$  ;LRK - ADDED 12/05/08
      method:'treeEvents',$
      id:'FTW',$
      element:element,$
      index:pos})

  endif;pos
  ;ARE group_leader OR element USED FOR ANYTHING?
  ;IN DESTROYING SETS, HAVING A GROUP LEADER AS THE
  ;PARENT INSTEAD OF THE TOP Q VALUE COULD CAUSE
  ;A DATA OBJECT TO BE ACCIDENTALLY DESTROYED IF A
  ;SET IS DELETED.

end;createFTWLeaf
pro Oodisplayecho::fillSet,theRef,parent,wid_id,pos
  ;
  ;NAME:
  ;        ooDisplayEcho::fillSet
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;FILL THE SET OBJECT INDICATED BY theRef WHICH HAS
  ;A LEAF WITH ID=parent.  pos AND wid_id CORRESPOND TO
  ;THE POSITION IN THE dataContainer AND THE ID OF
  ;THE RESULTING LEAF.

  ;    if ptr_valid(self.setMembers) gt 0 then begin


  ;
  ;
  ;WHY DOES THIS PROCEDURE CAUSE AN INFINITE LOOP ONCE A
  ;SET LEAF IS ALREADY CREATED????????????????
  ;
  ;IT WAS AN ISSUE WITH THE pos PARAMETER

  if N_elements(*self.setmembers) gt 0 then begin
    temp = *self.setmembers
    ;print,temp
    ;d=dialog_message('wait')
    Ptr_free,self.setmembers
  endif else begin
    temp = [-1]
  endelse
  if (theRef->Getproperty(/resIndex) ne -1) then begin
    objpos = theRef->Getproperty(/resIndex)
    temp = [temp,objpos]
    self->Createftwleaf,wid_id,parent,objpos,objpos
  endif;resIndex
  if (theRef->Getproperty(/datIndex) ne -1) then begin
    objpos = theRef->Getproperty(/datIndex)
    temp = [temp,objpos]
    self->Createftwleaf,wid_id,parent,objpos,objpos
  endif;datIndex
  if (theRef->Getproperty(/bkgIndex) ne -1) then begin
    objpos = theRef->Getproperty(/bkgIndex)
    temp = [temp,objpos]
    self->Createftwleaf,wid_id,parent,objpos,objpos
  endif;bkgIndex
  ;print,temp
  self.setmembers = Ptr_new(temp)
  ;print,*self.setMembers

end;fillSet

pro Oodisplayecho::sortTheData,qArr,qarrSort,qarruniq,qArrayOrdered,nobj
  ;  print,'ooDisplayEcho::sortTheData'

  ;THE NEXT LINE SETS THE DATA CONTAINER TO A LOCAL VARIABLE WHICH IS DESTROYED ON EXIT FROM THIS CODE BLOCK?
  ;  dc = self.datacontainer
  nobj = self.datacontainer->Count()
  if nobj gt 0 then begin

    ;LRK - 11/23/09
    ;WE NEED TO DETERMINE THE CURRENT AND NEW self.QChoiceIndex FOR THE SELECTED DATA BEFORE AND AFTER SORTING.
    ;NOTE: THIS TRACKING SORTING PROBABLY COULD BE DONE MORE EASILY BY USING IDL_CONTAINER::move
    qChoiceIndexOrig = self.qchoiceindex
    refSelected = self.datacontainer->Get(position=qChoiceIndexOrig)

    names = Strarr(nobj)
    ;    q = fltarr(nobj)
    qArr = Fltarr(nobj)
    qNameArr = Strarr(nobj)

    for i=0,nObj-1 do begin
      qNameArr[i] = File_basename((self.datacontainer->Get(position=i))->Getproperty(tag='filename'))
      qArr[i] = (self.datacontainer->Get(position=i))->Getproperty(tag='q')
    endfor;i

    ;GET SORTED INDICES FOR Q VALUES
    qArrSort = Sort(qArr)


    ;CREATE SORTED Q ARRAY
    qArrOrdered = qarr[qarrsort]
    qNameArrOrdered = qNameArr[qarrsort]

    ;GET UNIQ INDICES FOR SORTED Q ARRAY
    ;uniq PRODUCES AN ARRAY OF THE _LAST_ INDEX OF EACH
    ;UNIQUE SECTION
    qArrUniq = Uniq(qArrOrdered)


    ;THE NEXT STEP ORDERS THE OBJECTS BY q VALUE IN THE ctemp CONTAINER
    ctemp = Obj_new('idl_container')
    for i=0,nobj-1 do begin
      ctemp->Add,self.datacontainer->Get(position=qarrsort[i]),position=i
    endfor;i
    self.datacontainer->Remove,/all

    ;PUT THE OBJECTS IN INDIVIDUAL CONTAINERS BASED ON Q VALUE
    ouniq = Objarr(N_elements(qArrUniq))
    for j=0,N_elements(qArrUniq)-1 do begin
      ouniq[j] = Obj_new('idl_container')
      if j eq 0 then i0 = 0 else i0 = qArrUniq[j-1]+1
      i1 = qArrUniq[j]
      for i=i0,i1 do begin
        ouniq[j]->Add,ctemp->Get(position = i)
      endfor;i
    endfor;j
    ctemp->Remove,/all
    Obj_destroy,ctemp

    ;NOW SORT EACH ouniq BY FILENAME
    for j=0,N_elements(ouniq)-1 do begin
      nf = ouniq[j]->Count()
      names = Strarr(nf)
      for i=0,nf-1 do begin
        refi = ouniq[j]->Get(position=i)
        namei = refi->Getproperty(tag='filename')
        names[i] = File_basename(namei)
      endfor;i

      nsort = Sort(names)
      ctemp = Obj_new('idl_container')
      for i=0,nf-1 do begin
        refi = ouniq[j]->Get(position=nsort[i])
        ctemp->Add,refi,position=i
      endfor;i
      ouniq[j]->Remove,/all
      for i=0,nf-1 do begin
        refi = ctemp->Get(position=i)
        ouniq[j]->Add,refi,position=i
        ;        help,refi
      endfor;i
      ctemp->Remove,/all
      Obj_destroy,ctemp
    endfor;j

    ;FINALLY PUT ALL THE SORTED DATA BACK INTO THE DATA CONTAINER IN THE RIGHT ORDER.
    ;self.dataContainer->remove,/all

    qArrayOrdered = Fltarr(nobj)
    qNameArrayOrdered = Strarr(nobj)
    pos = 0
    for j=0,N_elements(oUniq)-1 do begin
      for i=0,oUniq[j]->Count()-1 do begin
        uref = oUniq[j]->Get(position=i)
        qArrayOrdered[pos] = uref->Getproperty(tag='q')
        qNameArrayOrdered[pos] = File_basename(uref->Getproperty(tag='filename'))
        self.datacontainer->Add,uref,position=pos
        pos++
      endfor;i
      oUniq[j]->Remove,/all
      Obj_destroy,oUniq[j]
    endfor;j

    ;LRK - 11/23/09
    ;NOW RESET THE self.QChoiceIndex!!!
    duh = self.datacontainer->Iscontained(refSelected,position=newQChoiceIndex)
    if duh eq 1 then begin
      self.qchoiceindex = newQChoiceIndex
      Print,'ooDisplayEcho::sortTheData  Synced self.QChoiceIndex'
    endif

  endif;nobj ne 0
end;sortTheData

pro Oodisplayecho::redefineTree
  ;
  ;NAME:
  ;        ooDisplayEcho::redefineTree
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;CREATE TREE OF DATA FILES IN TREE UNDER
  ;ASSOCIATED Q VALUES

  ;DETERMINE WHICH Q FOLDERS ARE EXPANDED AND
  ;SAVE THEIR STATES FOR REINSTATEMENT ON
  ;REPRODUCTION OF THE TREE.

  ;
  ;ALSO NEED TO LOOK INTO SETS.  PERHAPS THE SETS
  ;SHOULD SIMPLY REFER TO THE POSITION NUMBERS IN THE
  ;self.dataContainer RATHER THAN CONTAINING THEIR OWN
  ;SEPARATE COPIES.  self.dataContainer COULD CONTAIN
  ;ALL OF THE DATA OBJECTS AND
  ;
  ;THE set OBJECTS WILL REFER TO THE POSITIONS OF THE
  ;DATA OBJECTS.
  ;

  compile_opt IDL2
  Catch, catchError
  if (catchError ne 0) then begin
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::redefineTree!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = Dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    Catch, /cancel
    Return
  endif


  if self.qchoiceindex ge self.datacontainer->Count() then $
    self.qchoiceindex = self.datacontainer->Count()-1
  if self.qchoiceindex lt 0 then self.qchoiceindex = 0

  self.state_saved = 0


  children = Widget_info(self.ftree,/all_children)
  ;print,'children=',children

  qinfo = {expandedval:1,qval:0.0D}
  expVals = Intarr(N_elements(*self.qtw))+1

  ;GET THE VALUES FROM THE uvalue STRUCTURE
  values = Dblarr(N_elements(*self.qtw))

  ;DETERMINE THE EXPANSION STATES OF THE Q FOLDERS
  for i=0,N_elements(*self.qtw)-1 do begin
    if (*self.qtw)[0] ne -1 then begin
      expvals[i] = Widget_info((*self.qtw)[i],/tree_expanded)
      Widget_control,(*self.qtw)[i],get_uvalue=uval
      values[i] = Float(uval.qvalue)
    endif
  endfor;i

  ;LRK - 07/13/09
  ;IT SEEMS LIKE A BAD IDEA TO DESTROY THE TREE IMMEDIATELY, BUT THIS IS WHAT I DID.
  ;DOES IT MAKE SENSE TO LEAVE IT LIKE THIS?
  ;
  ;DESTROY CURRENT TREE
  ;    widget_control,self.ftree,/destroy

  if children[0] ne 0L then begin
    for i=0,N_elements(children)-1 do begin
      if Widget_info(children[i],/valid_id) then Widget_control,children[i],/destroy
    endfor;i
  endif
  ;LRK 07/10/09
  ;
  ;RESET THE FILE TREE SIZES SO THE SCROLL BARS ARE NOT HIDDEN
  if self.filetreexsize gt 286 then self.filetreexsize = 286

  ;LRK - 091010
  ;UPDATE THIS LIMIT BECAUSE OF THE ADDITION OF THE FACILITY OPTION IN THIS BASE.
  ;if self.filetreeysize gt 516 then self.filetreeysize = 516
  if self.filetreeysize gt 475 then self.filetreeysize = 475
  Widget_control,self.ftree,xsize = self.filetreexsize-10,$
    ysize = self.filetreeysize-30


  ;
  ;    ;CREATE NEW TREE
  ;    self.ftree = widget_tree(self.tlb1a1,/align_left,/sensitive,$;tab_mode=1,$
  ;                            /context_events,$
  ;                            multiple=1,$
  ;                            uname='FTREE',$
  ;                            xsize = self.filetreexsize-10,$
  ;                            ysize = self.filetreeysize-30,$
  ;                            $;ysize = (self.plotysize),$
  ;                            $;              xsize=fix((3*self.plotxsize)/8),$
  ;                            uvalue={object:self,$
  ;                                    method:'treeEvents',$
  ;                                    id:'FTREE',$
  ;                                    element:0})
  ;
  ;;I DON'T RECALL WHY THIS IS NOT SET IN THE CALL IMMEDIATELY ABOVE THIS.
  ;    widget_control,self.ftree,set_uvalue={object:self,$
  ;                                    method:'treeEvents',$
  ;                                    id:'FTREE',$
  ;                                    element:0,$
  ;                                    ContextBase_ID:0}


  ;GET NUMBER OF Obj'S FROM THE DATA CONTAINER
  nObj = self.datacontainer->Count()

  ;GET THE Q VALUES FROM THE OBJECTS
  if nobj gt 0 then begin
    ;print,'______________________'
    ;print,'ooDisplayEcho::redefineTree'
    ;print,0,(self.dataContainer->get(position=0))->getProperty(tag='filename')

    ;LRK 11/23/09:
    ;DOES THE DATA SORT UPDATE THE QChoiceIndex????????
    self->Sortthedata,qArr,qarrSort,qarruniq,qArrOrdered,nobj

    qtw = Lindgen(N_elements(qArrUniq))
    ftw = Lindgen(nobj)


    ;CREATE ZEROTH Q WIDGET WITH SUBWIDGETS

    if Where(values eq qArrOrdered[qArrUniq[0]]) ge 0 then begin
      expanded = expVals[Where(values eq qArrOrdered[qArrUniq[0]])]
    endif else begin
      if (self.datacontainer)->Count() gt 1 then begin
        expanded = 1
      endif else begin
        expanded = 1
      endelse
    endelse
    qtw[0] = Widget_tree(self.ftree,/folder,expanded=expanded,$
      value='Q = '+$
      Strtrim(String(qArrOrdered[qArrUniq[0]]),2),$
      uvalue={object:self,$
      method:'treeEvents',$
      id:'QTW',$
      element:0,$
      qvalue:qArrOrdered[qArrUniq[0]]})

    ;
    ;SINCE THE datacontainer IS FULLY SORTED, ADD A RUNNING COUNT VARIABLE TO KEEP TRACK OF WHICH
    ;POSITION WE ARE AT --- THIS WILL REPLACE qArrSort IN THE CALLS BELOW
    dcount = 0
    for j=0,qArrUniq[0] do begin


      ;CREATE A LEAF FOR THIS OBJECT IF IT IS NOT IN A SET
      self->Createftwleaf,ftw[j],qtw[0],dcount,j
      dcount++

    endfor;j

    ;CREATE OTHER Q WIDGETS WITH SUBWIDGETS
    for i = 1,N_elements(qArrUniq)-1 do begin
      ;GET PREVIOUS EXPANSION STATE OF Q FOLDERS

      if Where(values eq qArrOrdered[qArrUniq[i]]) ge 0 then begin
        expanded = expVals[Where(values eq qArrOrdered[qArrUniq[i]])]
      endif else begin
        expanded = 1
      endelse
      qtw[i] = Widget_tree(self.ftree,$
        value='Q = '+$
        Strtrim(String(qArrOrdered[qArrUniq[i]]),2),$
        /folder,expanded = expanded,$
        uvalue={object:self,$
        method:'treeEvents',$
        id:'QTW',$
        element:i,$
        qvalue:qArrOrdered[qArrUniq[i]]})


      ;CREATE THE FILE TREE LEAVES
      for j=qArrUniq[i-1]+1,qArrUniq[i] do begin

        self->Createftwleaf,ftw[j],qtw[i],dcount,j
        dcount++
      endfor;j
    endfor;i

    ;SET POINTERS TO THE WIDGET ID ARRAYS
    ;
    ; --- ARE THESE VALUES NECESSARY?????  --- COULD I GET THIS INFORMATION VIA widget_info BEFORE REDEFINING THE ftree?
    if Ptr_valid(self.qtw) gt 0 then Ptr_free,self.qtw
    self.qtw=Ptr_new(qtw)
    if Ptr_valid(self.ftw) gt 0 then Ptr_free,self.ftw
    self.ftw=Ptr_new(ftw)

  endif else begin    ;nObj gt 0
    ;DEFINE NECESSARY VALUES WITH NO ELEMENTS.
    qtw = [-1]
    if Ptr_valid(self.qtw) gt 0 then Ptr_free,self.qtw
    self.qtw=Ptr_new(qtw)
    ftw = [-1]
    if Ptr_valid(self.ftw) gt 0 then Ptr_free,self.ftw
    self.ftw=Ptr_new(ftw)

  endelse

end;redefineTree


pro Oodisplayecho_contextmenudestroy,id
  ;
  ;NAME:
  ;        ooDisplayEcho_ontextmenudestroy
  ;
  ;PURPOSE:
  ;           Announce when a context menu is destroyed and provide a traceback
  ;           by crashing on print of a null pointer.
  ;
  ;           THIS IS USED FOR TESTING ONLY.
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;

  ;ANNOUNCE WHEN A CONTEXT MENU DIES.

  ;    print,id
  ;    print,*p

end;oodisplayecho_contextmenudestroy

;LRK 11/14/08
;
;SPLIT THE CONTEXT MENUS INTO A SEPARATE FILE
;pro ooDisplayEcho::defineContextMenus
;end;defineContextMenus
pro Oodisplayecho::defineTree
  ;
  ;NAME:
  ;        ooDisplayEcho::defineTree
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;CREATE TREE OF DATA FILES IN TREE UNDER
  ;ASSOCIATED Q VALUES

  ;NOTE: FOR FILE TREE SIZING, DOUBLE CHECK FOR
  ;      SETTING IN ::reDefineTree BECAUSE OF THE
  ;      UPDATES THERE.
  self.ftree = Widget_tree(self.tlb1a1,/align_left,/sensitive,$;tab_mode=1,$
    /context_events,$
    uname='FTREE',$
    multiple=1,$
    ;ysize = 350,xsize=150,$
    ysize = self.filetreeysize-30,$
    xsize = self.filetreexsize-10,$
    uvalue={object:self,$
    method:'treeEvents',$
    id:'FTREE',$
    element:0,$
    contextbase_id:0})

  self->Definecontextmenus

  ;GET NUMBER OF Obj'S FROM THE DATA CONTAINER
  nObj = self.datacontainer->Count()
  qArr = (self.datacontainer->Get(position=0))->Getproperty(tag='q')
  for i=1,nObj-1 do begin
    newQ =(self.datacontainer->Get(position=i))->Getproperty(tag='q')
    qArr = [qArr,newQ]
  endfor;i


  ;GET SORTED INDICES FOR Q VALUES
  qArrSort = Sort(qArr)

  ;CREATE SORTED Q ARRAY
  qArrOrdered = $
    (self.datacontainer->Get(position=qArrSort[0]))->Getproperty(tag='q')
  for i = 1,N_elements(qArr)-1 do begin
    qArrOrdered = [qArrOrdered,$
      (self.datacontainer->Get(position=qArrSort[i]))->Getproperty(tag='q')]
  endfor


  ;GET UNIQ INDICES FOR SORTED Q ARRAY
  ;uniq PRODUCES AN ARRAY OF THE _LAST_ INDEX OF EACH
  ;UNIQUE SECTION
  qArrUniq = Uniq(qArrOrdered)

  ;PRINT UNIQUE ORDERED Q VALUES
  qtw = Lindgen(N_elements(qArrUniq))
  ftw = Lindgen(N_elements(qArrOrdered))

  ;CREATE ZEROTH Q WIDGET WITH SUBWIDGETS
  qtw[0] = Widget_tree(self.ftree,/folder,$
    /expanded,$
    value='Q = '+Strtrim(String(qArrOrdered[qArrUniq[0]]),2),$
    uvalue={object:self,$
    method:'treeEvents',$
    id:'QTW',$
    element:0,$
    qvalue:qArrOrdered[qArrUniq[0]]})

  for j=0,qArrUniq[0] do begin
    comment = (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='comment')
    filename =  File_basename((self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='filename'))
    type =  (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='type')
    reduced =  (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='reduced')
    ftw[j] = Widget_tree(qtw[0],value=filename+': '+comment,$
      group_leader=qtw[0],$
      bitmap = self->Icon(reduced,type),$
      uvalue={object:self,$
      method:'treeEvents',$
      id:'FTW',$
      element:j,$
      index:qArrSort[j]})

  endfor;j

  ;CREATE OTHER Q WIDGETS WITH SUBWIDGETS
  for i = 1,N_elements(qArrUniq)-1 do begin
    qtw[i] = Widget_tree(self.ftree,$
      value='Q = '+Strtrim(String(qArrOrdered[qArrUniq[i]]),2),$
      /folder,/expanded,$
      uvalue={object:self,$
      method:'treeEvents',$
      id:'QTW',$
      element:i,$
      qvalue:qArrOrdered[qArrUniq[i]]})

    for j=qArrUniq[i-1]+1,qArrUniq[i] do begin
      comment = (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='comment')
      filename =File_basename((self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='filename'))

      self.data_dir = File_dirname((self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='filename'))

      type =  (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='type')
      reduced =  (self.datacontainer->Get(position=qArrSort[j]))->Getproperty(tag='reduced')

      ftw[j] = Widget_tree(qtw[i],value=filename+': '+comment,$
        group_leader=qtw[0],$
        bitmap = self->Icon(reduced,type),$
        uvalue={object:self,$
        method:'treeEvents',$
        id:'FTW',$
        element:j,$
        index:qArrSort[j]})
    endfor;j
  endfor;i

  ;SET POINTERS TO THE WIDGET ID ARRAYS
  if Ptr_valid(self.qtw) gt 0 then Ptr_free,self.qtw
  self.qtw=Ptr_new(qtw)
  if Ptr_valid(self.ftw) gt 0 then Ptr_free,self.ftw
  self.ftw=Ptr_new(ftw)

end;defineTree
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::sortDataByQ
  ;
  ;NAME:
  ;        ooDisplayEcho::sortDataByQ
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  ;print,'ooDisplayEcho::sortDataByQ CALLED'


  ;051104
  ;
  ;NEED TO SORT WITH SET INFORMATION TOO.  ADD FIELD TO
  ;ooEcho DATA OBJECTS TO IDENTIFY THEIR SETS.  OR IDENTIFY
  ;THE FILENAMES IN THE SET OBJECTS.
  ;

  ;THIS DOES NOT YET WORK!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


  ;ORDER DATA OBJECTS IN self.dataContainer BY Q

  ;GET NUMBER OF Obj'S FROM THE DATA CONTAINER
  nObj = self.datacontainer->Count()
  ;    qArr = (self.dataContainer->get(position=0))->getProperty(tag='q')
  ;    for i=1,nObj-1 do begin
  ;        newQ =(self.dataContainer->get(position=i))->getProperty(tag='q')
  ;        qArr = [qArr,newQ]
  ;    endfor;i
  ;
  ;    ;GET SORTED INDICES FOR Q VALUES
  ;    qArrSort = sort(qArr)
  ;
  ;    print,qArrSort




  ;    ;MOVE OBJECTS AWAY FROM CURRENT POSITIONS
  ;    tmp = obj_new()
  ;    self.dataContainer->add,tmp,position=nObj
  ;
  for i=0,nObj-1 do begin


    ;THIS DOES NOT YET WORK!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


    ;GET Q VALUES
    qArr = (self.datacontainer->Get(position=0))->Getproperty(tag='q')
    for j=0,nObj-1 do begin
      newQ =(self.datacontainer->Get(position=j))->Getproperty(tag='q')
      qArr = [qArr,newQ]
    endfor;j
    minVal = Min(qArr[i:*],minIndex)

    self.datacontainer->Move,minIndex,i
  endfor;i


  ;THIS DOES NOT YET WORK!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
end;sortDataByQ
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::getContainer,dataContainer
  ;
  ;NAME:
  ;        ooDisplayEcho::getContainer
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;print,'TEST'
  ;help,self.dataContainer

  ;RETURN THE DATA CONTAINER
  dataContainer = self.datacontainer

end;getContainer




;#######################################################
pro Oodisplayecho::defineWidgets,plotxsize=plotxsize,$
  plotysize=plotysize
  ;
  ;NAME:
  ;        ooDisplayEcho::defineWidgets
  ;
  ;PURPOSE:
  ;           Define the widgets in an ooDisplayEcho object on initialization.
  ;           May be called by event handlers as necessary.
  ;PARAMETERS:
  ;           none
  ;KEYWORDS:
  ;           plotxsize   xsize of plot window
  ;           plotysize   ysize of plot window
  ;


  ;;
  ;DEFINE WIDGETS WHEN CALLED BY INIT
  ;
  ;   MAY BE CALLABLE BY EVENT HANDLERS AS NECESSARY
  ;;;


  ;090104 --- THIS SECTION WILL NEED FIXING FOR MAC X11
  ;WHY DID I CHOOSE 2.7? FOR ROB'S LAPTOP?
  Device,get_screen_size=sz

  ;print,'device,get_screen_size=',sz


  ;092204
  ;THESE NUMBERS MUST COME FROM THE ABOVE COMMAND.
  ;COMMENT OUT THE NEXT TWO LINES SOON!!!!!!!!!!!!

  ;FOR TESTING PURPOSES
  sz[0] = Fix(0.5*sz[0]);800
  sz[1] = Fix(0.5*sz[1]);600



  ;    if !Version.OS eq 'Win32' then begin
  ;        if sz[0] gt 930 then sz[0] = 900
  ;        if sz[1] gt 720 then sz[1] = 700
  ;    endif else begin
  ;        sz[0] = 700
  ;        sz[1] = 500
  ;    endelse

  self.atlbxsize = sz[0]
  self.atlbysize = sz[1]



  ;print,'plotxsize,plotysize=',self.plotxsize,self.plotysize



  ;    self.filename = self.ech->getProperty(tag='filename')
  self.filename = $
    (self.datacontainer->Get(position=$
    self.qchoiceindex))->Getproperty(tag='filename')

  ;THE NEXT PART MAY BE BETTER HANDLED BY ASSOCIATING
  ;A Q-VALUE AND FILE NAME WITH EACH DATA FILE READ
  ;AND USING THE Q-INDEX DROPLIST TO ACCESS THEM.
  ;
  ;BUT FOR NOW . . .
  thisTitle = 'NSE Data Reduction';   Current Data File = '$
  ;+self.filename



  if !Version.os eq 'Win32' then begin
    self.taucdysize = 28
    self.clickphaseysize = 0;67
    self.tw1ysize = 22
    self.filetreexpadding = 4
    self.filetreeypadding = 26
    self.tabsxpadding = 8
    self.tabsypadding = 30
    self.magicxpadding = 25
    self.magicypadding = 0
    tlb_size_events = 1
    standardsize = 320;300
  endif else begin
    self.taucdysize = 41
    self.clickphaseysize = 0;81
    self.tw1ysize = 31
    self.tabsxpadding = 4
    self.tabsypadding = 24
    self.filetreexpadding = 0
    self.filetreeypadding = 0
    self.magicxpadding = 25
    self.magicypadding = 30
    tlb_size_events = 1
    standardsize = 360;340
  endelse


  self.atlb = Widget_base(/row,title=thisTitle,TLB_SIZE_EVENTS=tlb_size_events,$
    group_leader = self.group_leader,   $
    $;xsize=800, ysize=600,$;/TLB_KILL_REQUEST_EVENTS,$
    xsize=self.atlbxsize,$
    ysize=self.atlbysize,$
    mbar = bar,$
    KBRD_FOCUS_EVENTS = 1, $
    uvalue=self);{obj:self,$
  ;method:'atlbEvents',$
  ;id:'ATLB'})   ;TOP LEVEL BASE

  geom = Widget_info(self.atlb,/geometry)
  ;    print,tag_names(geom)
  ;    print,geom

  self.xpadding = geom.scr_xsize-geom.xsize
  self.ypadding = geom.scr_ysize-geom.ysize



  ;    self.filetreexsize = 150
  self.filetreexsize = standardsize - self.ypadding
  ;    self.filetreeysize = min([500,self.atlbysize - self.ypadding])
  self.tabsxsize = standardsize
  self.tabsysize = Min([550,self.atlbysize - self.ypadding])
  self.filetreeysize = self.tabsysize - self.ypadding
  ;padding = 30


  if N_elements(plotxsize) gt 0 then begin
    self.plotxsize = plotxsize
  endif else begin
    ;self.plotxsize = fix(self.atlbxsize/2.7)
    self.plotxsize = Fix(self.atlbxsize - $;self.filetreexsize - $
      self.filetreexpadding - self.tabsxsize - self.tabsxpadding - self.xpadding-self.magicxpadding)
  endelse

  if N_elements(plotysize) gt 0 then begin
    self.plotysize = plotysize
  endif else begin
    ;self.plotysize = fix(self.atlbysize/2.4)
    ;self.plotysize = fix(self.atlbysize/2.2 - ypadding - clickphasesize)
    self.plotysize = Fix((self.atlbysize - self.ypadding - $
      self.clickphaseysize - self.taucdysize - self.tw1ysize-self.magicypadding)/2)
  endelse

  self.drawbasexsize = self.plotxsize
  self.drawbaseysize = 2*self.plotysize + self.taucdysize + self.tw1ysize;self.clickphaseysize + self.tw1ysize



  ;    print,'self.atlbxsize=',self.atlbxsize
  ;    print,'self.atlbysize=',self.atlbysize
  ;    print,'self.plotysize=',self.plotysize





  ;MAKE DUMMY BUTTONS TO SET WIDGET SIZES
  dumbutton = Lonarr(5)
  self.tlb1 = Widget_base(self.atlb,/col)     ;
  self.tlb1a = Widget_base(self.tlb1,/row,frame=2)


  ;092404 ADDING TAB WIDGET TO SAVE REAL ESTATE
  self.thetabs = Widget_tab(self.tlb1a,$
    xsize=self.tabsxsize-self.tabsxpadding,$
    ysize=self.tabsysize-self.tabsypadding,$
    $;xsize=self.standardsize+self.tabsxpadding,$
    $;ysize=self.tabsysize+self.tabsypadding,$
    uvalue = {object:self,$
    method:'doNothing',$
    id:'THETABS'})



  ;    self.tlb1a1 = widget_base(self.tlb1a,/col,frame=2,$
  Print,'TAB1'
  self.tlb1a1 = Widget_base(self.thetabs,/col,frame=2,$
    xsize=self.filetreexsize-self.filetreexpadding,$
    ysize=self.filetreeysize-self.filetreeypadding,$;-30,$
    ;/scroll,$
    ;x_scroll_size=self.filetreexsize-self.filetreexpadding,$
    ;y_scroll_size=self.filetreeysize-self.filetreeypadding,$
    title='DATA FILES')   ;fileTree

  ;    dumbutton[0] = widget_button(self.tlb1a1,value='tree width = ~150',$
  dumbutton[0] = Widget_button(self.tlb1a1,value='tree width = ~'+Strtrim(String(standardsize),2),$
    xsize=standardsize-self.filetreexpadding,$;self.filetreexsize,$
    ysize=self.filetreeysize-self.filetreeypadding); -self.filetreexpadding)
  ;    self.facilityBGroup = cw_bgroup(self.tlb1a1,['Try File','NCNR','FRM-II'],/exclusive,/row,$
  self.facilitybgroup = Cw_bgroup(self.tlb1a1,['NCNR','FRM-II'],/exclusive,/row,$
    label_left='Facility',set_value=0,$
    uname='FACILITYBGROUP',$
    uvalue={object:self,$
    method:'textEvents',$
    id:'FACILITYBGROUP'})
  Print,'TAB2'
  self.tlb1a2 = Widget_base(self.thetabs,/col,frame=2,$
    xsize=self.tabsxsize-self.tabsxpadding,$
    ysize=self.tabsysize-self.tabsypadding,$
    $;/base_align_right,$
    title='GENERAL') ;textWidgets
  dumbutton[1] = Widget_button(self.tlb1a2,value='tree width = ~330',$
    xsize=standardsize);self.tabsxsize-self.tabsxpadding)

  Print,'TAB3'
  self.tlb1a3 = Widget_base(self.thetabs,/col,frame=2,$
    xsize=self.tabsxsize-self.tabsxpadding,$
    ysize=self.tabsysize-self.tabsypadding,$
    /base_align_left,$
    title='DATA SET');SAMPLE') ;textWidgets
  dumbutton[2] = Widget_button(self.tlb1a3,value='tree width = ~'+Strtrim(String(standardsize),2),$
    xsize=standardsize-self.tabsxpadding,$;self.filetreexsize,$
    ysize=self.filetreeysize-self.tabsypadding); -self.filetreexpadding)

  ;020105
  ;X11 DOES NOT ALLOW SCROLL BARS ON THESE BASES!!!!
  Print,'TAB4'
  self.tlb1b = Widget_base(self.thetabs,/col,frame=2,$
    $;ysize=self.tabsysize-self.tabsypadding,$
    $;xsize=self.tabsxsize-self.tabsxpadding,$
    $;ysize=self.tabsysize-self.tabsypadding,$
    $;xsize=self.tabsxsize-self.tabsxpadding,$
    title='FITTING');,/base_align_left);,x_scroll_size=250)    ;fitWidgets

  dumbutton[3] = Widget_button(self.tlb1b,value='tree width = ~'+Strtrim(String(standardsize),2),$
    xsize=standardsize-self.tabsxpadding,$;self.filetreexsize,$
    ysize=self.filetreeysize-self.tabsypadding); -self.filetreexpadding)

  ;020905
  ;DEFINE AN xsize FOR self.tlb2
  Print,'DRAW BASE'
  self.tlb2 = Widget_base(self.atlb,/col);,ysize=self.drawbaseysize,xsize=self.drawbasexsize)
  dumbutton[4] = Widget_button(self.tlb2,value='draw width = ~250',$
    xsize=self.drawbasexsize)

  ;NOTIFY THE USER OF GUI BUILDING PROGRESS
  ;progb = widget_base(/floating,group_leader = self.atlb,title='BUILDING GUI')
  ;;progw = cw_progress(progb,value=[7],title='STEP ')
  ;progw = nse_progress(progb,value=[7],title='STEP ',dialog_parent=self.atlb)
  ;widget_control,progb,/realize

  prog = Nse_cwo_progress(labels=['STEP:'],$
    startvalues=[0L],$
    endvalues=[7L],$
    values=[0L],$
    steps=[1L],$
    obj=progobj,$
    title='BUILDING GUI:   ',$
    dialog_parent=self.atlb)


  self->Definetree
  progobj->Step,0
  ;widget_control,progw,set_value=[1]

  self->Definemenus,bar
  progobj->Step,0
  ;widget_control,progw,set_value=[2]

  self->Definetextwidgets
  progobj->Step,0
  ;widget_control,progw,set_value=[3]

  ;033005
  ;ELIMINATE THE MASK BUTTONS HERE.
  ;self->defineMaskButton
  progobj->Step,0
  ;widget_control,progw,set_value=[4]

  ;self->defineCDControls


  ;;092204 THE NEXT TWO CALLS HAVE BEEN SWAPPED TODAY TO
  ;;       TRY TO MAKE SPACE FOR ALL OF THE FIT WIDGETS.
  ;    self->defineDrawWidgets
  ;widget_control,progw,set_value=[5]

  self->Definefitwidgets
  progobj->Step,0
  ;widget_control,progw,set_value=[5]


  ;021105
  ;THE MOVE TO REALIZE THE BASE HERE SEEMS TO MAKE OPENING THE
  ;PROGRAM FASTER ON THE MAC.
  ;
  ;;REALIZE THE ATLB HERE
  Widget_control,self.atlb,/realize

  ;
  ;DEFINE THE DRAW WIDGETS HERE.
  self->Definedrawwidgets
  ;widget_control,progw,set_value=[6]
  progobj->Step,0



  ;LATER:
  ;DISPLAY FOURIER TIME VS Q FOR POSSIBLE SCAN SELECTION

  self->Draw

  Widget_control,self.atlb,set_uvalue=self

  ;START EVENT MANAGER/PREPARE EVENT LOOP
  Xmanager,"ooDisplayEcho",self.atlb,$
    cleanup="ooDisplayEchoCleanup",/no_block


  ;DESTROY dumbutton
  for i = 0,N_elements(dumbutton)-1 do begin
    if Widget_info(dumbutton[i],/valid) gt 0 then begin
      Widget_control,dumbutton[i],/destroy
    endif
  endfor;i


  ;DESTROY PROGRESS WIDGET.
  ;widget_control,progw,set_value=[7]
  ;widget_control,progb,/destroy
  progobj->Step,0
  Widget_control,prog,/destroy
end;defineWidgets




;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Oodisplayecho::get_notify_ids
  ;
  ;NAME:
  ;        ooDisplayEcho::get_notify_ids
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;RETURN VALUE:
  ;
  Return,self.notify_ids
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::lastChanceToSaveSession,xout=xout
  ;
  ;NAME:
  ;        ooDisplayEcho::lastChanceToSaveSession
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;print,'8308 ooDisplayEcho::lastChanceToSaveSession'
  if N_elements(xout) eq 0 then xout = 0
  Print,'Save session on exit = ',self->Savesession(/exitflag)

end;lastChanceToSaveSession

pro Oodisplayechocleanup,tlb
  ;
  ;NAME:
  ;        ooDisplayEchoCleanup
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;print,'8308 ooDisplayEchoCleanup'
  ;CALLED WHEN [X] EVENT OCCURS, BUT AFTER THE
  ;ATLB IS DESTROYED ALREADY.  IT IS TOO LATE TO SAVE AT THIS POINT.
  ;THIS CLEANUP METHOD CANNOT BE A CLASS METHOD, SO IT
  ;MUST CALL THE OBJECT'S CLEANUP METHOD.

  ;dum = dialog_message('Destruction is now inevitable.')

  Print,'tlb Cleanup'
  Widget_control,tlb,get_uvalue=self

  if Obj_valid(self) then begin
    ;PROMPT FOR SAVE BEFORE QUITTING
    ;container = obj_new()
    ;ref = self->getproperty(/datacontainer)
    ;count = ref->count()
    self->Lastchancetosavesession,/xout
    s = Size(self->Get_notify_ids())
    if s[0] ne 0L then begin
      n = self->Get_notify_ids()
      nse_info = {Nse_event,  $
        id:(self->Get_notify_ids())[0],     $
        top:(self->Get_notify_ids())[1],    $
        handler:0L                          }
    endif
    if Widget_info(n[0],/valid_id) then begin
      Widget_control,n[0],send_event = nse_info
    endif
  endif
  Obj_destroy,self
  Return
end;ooDisplayEchoCleanup
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro Oodisplayecho::Cleanup
  ;
  ;NAME:
  ;        ooDisplayEcho::cleanup
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;print,'ooDisplayEcho Cleanup'

  ;self->maskCleanup,self.maskBase
  if Ptr_valid(self.maskmakermask) gt 0 then Ptr_free,self.maskmakermask
  Ptr_free,self.displaychoices
  Ptr_free,self.detchoices
  Ptr_free,self.ftchoices
  Ptr_free,self.mye
  Ptr_free,self.ie
  Ptr_free,self.im
  Ptr_free,self.imeb
  Ptr_free,self.geombase
  Ptr_free,self.geomimage
  Ptr_free,self.geomplot
  Ptr_free,self.w1xptr
  Ptr_free,self.w1yptr
  Ptr_free,self.w2xptr
  Ptr_free,self.w2yptr
  Ptr_free,self.phase
  Ptr_free,self.qtw
  Ptr_free,self.ftw
  Obj_destroy,self.drawimage
  Obj_destroy,self.drawplot
  Ptr_free,self.setmembers

  if (Ptr_valid(self.dataset) gt 0) then begin
    for i=0,N_elements(*self.dataset) do begin
      if (Obj_valid((*self.dataset)[i]) gt 0) then $
        Obj_destroy,(*self.dataset)[i]
    endfor
    Ptr_free,self.dataset
  endif
  if (Obj_valid(self.iqtdisplayobj)) then Obj_destroy,self.iqtdisplayobj


  ;111605
  ;    ref = self.datacontainer->get(/all)
  ;    if n_elements(ref) gt 0 and total(obj_valid(ref)) eq n_elements(ref) then obj_destroy,ref
  while self.datacontainer->Count() gt 0 do begin
    ref = self.datacontainer->Get(position=0)
    self.datacontainer->Remove,position=0
    if Obj_valid(ref) gt 0 then Obj_destroy,ref
  endwhile
  if (Obj_valid(self.datacontainer) gt 0) then Obj_destroy,self.datacontainer
  if (Obj_valid(self.setcontainer) gt 0) then Obj_destroy,self.setcontainer
  if (Obj_valid(self.ech) gt 0) then Obj_destroy,self.ech
  if (Obj_valid(self.echorig) gt 0) then Obj_destroy,self.echorig
  if (Obj_valid(self.fitselectorobj) gt 0) then $
    Obj_destroy,self.fitselectorobj

end;cleanup


pro Oodisplayecho::readParametersFile,fn
  ;
  ;NAME:
  ;        ooDisplayEcho::readParametersFile
  ;
  ;PURPOSE:
  ;       Enter a set of parameters from an ASCII file for the program.
  ;PARAMETERS:
  ;       fn  Filename
  ;KEYWORDS:
  ;

  if N_elements(fn) ne 1 then begin
    fn = Dialog_pickfile(title='Choose Parameters File',path=self.work_dir,filter = '*.nse')
  endif
  if fn ne '' then begin

    lines = File_lines(fn)
    line = ''
    Openr,lun,fn,/get_lun
    Help,lun,/file,output=out,struct=0


    Catch, Error_status
    ;Error handler in case of type conversion error in text field
    if (Error_status ne 0) then begin
      Print, 'Error index: ', Error_status
      Print, 'Error message: ', !ERROR_STATE.msg
      void = Dialog_message('There was a problem reading the .nse file.')
      Catch, /cancel
    endif

    if Stregex(out[0],'Closed',/fold_case) eq -1 then begin

      ;READ COMMENT LINES
      Readf,lun,line
      Readf,lun,line


      ;Gaussian_Width	702.00
      ;Beam_Center_X	15.36
      ;Beam_Center_Y	14.66
      ;Echo_Period	360.0
      ;Work_Directory	.
      ;Data_Directory	.

      ;GAUSSIAN WIDTH
      Readf,lun,line
      segs = Strsplit(line,/extract)
      Widget_control,self.atwwidth,set_value=segs[1]
      self.gaussianwidth = Double(segs[1])



      ;print,segs[1]


      ;BEAM CENTER X
      Readf,lun,line
      segs = Strsplit(line,/extract)
      Widget_control,self.atwbcx,set_value=segs[1]
      self.beamcenxorig = Double(segs[1])
      ;print,segs[1]

      ;BEAM CENTER Y
      Readf,lun,line
      segs = Strsplit(line,/extract)
      Widget_control,self.atwbcy,set_value=segs[1]
      self.beamcenyorig = Double(segs[1])
      ;print,segs[1]

      ;PERIOD VALUE
      Readf,lun,line
      segs = Strsplit(line,/extract)
      Widget_control,self.atwperiod,set_value=segs[1]
      self.periodvalue = Double(segs[1])
      ;print,segs[1]

      ;WORKING DIRECTORY
      Readf,lun,line
      segs = Strsplit(line,/extract)
      self.work_dir = segs[1]
      ;print,segs[1]

      ;DATA DIRECTORY
      Readf,lun,line
      segs = Strsplit(line,/extract)
      self.data_dir = segs[1]
      ;print,segs[1]

      if self.datacontainer->Count() gt 0 then begin
        for i=0,self.datacontainer->Count()-1 do begin
          ref = self.datacontainer->Get(position=i)
          ref->Setwidth,self.gaussianwidth
          ref->Setperiod,self.periodvalue
          ref->Setproperty,'beam_cen_x',self.beamcenxorig
          ref->Setproperty,'x_cen',self.beamcenxorig
          ref->Setproperty,'x_cen_orig',self.beamcenxorig
          ref->Setproperty,'beam_cen_y',self.beamcenyorig
          ref->Setproperty,'y_cen',self.beamcenyorig
          ref->Setproperty,'y_cen_orig',self.beamcenyorig
          ref->Setproperty,'datadir',self.data_dir
          ref->Setproperty,'workdir',self.work_dir
        endfor;i
      endif

    endif
    Free_lun,lun
  endif else begin
    void = Dialog_message('Please enter a valid parameters file.')
  endelse

end;readParametersFile
pro Oodisplayecho::writeParametersFile,fn
  ;
  ;NAME:
  ;        ooDisplayEcho::writeParametersFile
  ;
  ;PURPOSE:
  ;       Write a set of parameters to an ASCII file.
  ;PARAMETERS:
  ;       fn  Filename
  ;KEYWORDS:
  ;

  if N_elements(fn) ne 1 then begin
    fn = Dialog_pickfile(title='Choose Parameters File',path=self.work_dir, $
      filter = '*.nse',/overwrite_prompt)
  endif


  ;APPEND .nse EXTENSION IF NECESSARY
  fnlen = Strlen(fn)
  if fnlen ge 4 then begin
    fn_ext = Strmid(fn,fnlen-4,4)
    Print,'fn_ext',fn_ext
    if Strupcase(fn_ext) ne '.NSE' then begin
      fn = fn+'.nse'
    endif
  endif else begin
    if fn ne '' then begin
      fn = fn+'.nse'
    endif else begin
      void = Dialog_message('NO OUTPUT FILE OR INVALID OUTPUT FILE SELECTED.')
      Return
    endelse
  endelse

  if fn ne '' then begin

    ;        lines = file_lines(fn)
    ;        line = ''
    Openw,lun,fn,/get_lun
    Help,lun,/file,output=out,struct=0

    Printf,lun,'#SPIN ECHO PARAMETERS FILE'
    Printf,lun,'#Edit as necessary to keep the values current for yourself.'
    Printf,lun,'Gaussian_Width     ',self.gaussianwidth
    Printf,lun,'Beam_Center_X      ',self.beamcenxorig
    Printf,lun,'Beam_Center_Y      ',self.beamcenyorig
    Printf,lun,'Echo_Period        ',self.periodvalue
    Printf,lun,'Work_Directory     ',self.work_dir
    Printf,lun,'Data_Directory     ',self.data_dir

    Free_lun,lun
  endif else begin
    void = Dialog_message('Please enter a valid parameters file.')
  endelse

end;writeParametersFile


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;
;ooDisplayEcho::init
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function Oodisplayecho::init,ech,plotxsize=plotxsize,plotysize=plotysize, $
  group_leader = group_leader,    $
  notify_ids = notify_ids,        $
  data_dir = data_dir,            $
  work_dir = work_dir,            $
  parametersfile = parametersfile,$
  dave_id = dave_id,              $
  DAVETool=DAVETool
  ;
  ;NAME:
  ;        ooDisplayEcho::init
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.

  ;RETURN VALUE:
  ;

  ;092204
  ;
  ;THESE FONT ADJUSTMENTS AFFECTED ALL OF DAVE ONCE THEY
  ;WERE USED!!!
  ;
  ;092104
  ;SET FONT SIZES FOR THE WIDGET.
  ;;;;    default_font = get_font_name(/TINY, /TIMES)
  ;;;;    button_font = get_font_name(/MEDIUM, /TIMES, /BOLD)
  ;;;;    label_font = get_font_name(/SMALL, /TIMES)
  ;;;;;    default_font = get_font_name(/SMALL, /HELVETICA)
  ;;;;;    button_font = get_font_name(/LARGE, /HELVETICA, /BOLD)
  ;;;;;    label_font = get_font_name(/MEDIUM, /HELVETICA)
  ;;;;
  ;;;;    !P.charsize = 0.75
  ;;;;    ;!P.font = label_font
  ;;;;
  ;;;;
  ;;;;    widget_control, default_font=default_font


  ;101304
  ;
  ;UPDATING TO OPEN THE GUI WITH A BLANK DATA OBJECT AND
  ;THEN DELETE THE OBJECT.

  ; Initialize the members related to instantiation of this
  ; widget object class from the DAVE environment.


  Device,get_decomposed = dc
  ;ALLOW USE OF COLOR TABLE
  Device,decomposed = 0
  if N_elements(group_leader) eq 0 then group_leader = 0L
  if N_elements(notify_ids) eq 0 then notify_ids = [0L,0L]
  if N_elements(work_dir) eq 0 then work_dir = ''
  if N_elements(data_dir) eq 0 then data_dir = ''
  if N_elements(parametersfile) eq 0 then parametersfile = ''
  if N_elements(dave_id) eq 0 then dave_id = 0L
  if N_elements(DAVETool) eq 0 then DAVETool = Obj_new()
  self.dave_id = dave_id
  self.davetool = DAVETool

  Device,get_screen_size=sz

  if N_elements(plotxsize) gt 0 then plotxsize = sz[0]/3
  if N_elements(plotysize) gt 0 then plotysize = sz[1]/3
  self.work_dir = work_dir
  self.data_dir = data_dir
  self.notify_ids = notify_ids
  self.group_leader = group_leader

  self.colortable = 3     ;RED TEMPERATURE

  self.datacontainer = Obj_new('IDL_container')
  self.setcontainer = Obj_new('IDL_container')
  Loadct,self.colortable


  o = Obj_new('ooEcho',/blank)
  o->Bin,factor=4       ;092404 --- SET DEFAULT BINNING TO 4
  self.datacontainer->Add,o,position=0

  self->Setdataparameters,o,n=0

  self->Definewidgets,plotxsize=plotxsize,plotysize=plotysize

  ref=self.datacontainer->Get(position=0)
  self.datacontainer->Remove,position=0


  if parametersfile ne '' then begin
    self->Readparametersfile,parametersfile
  endif

  self->Redefinetree

  Obj_destroy,ref

  Device,decomposed=dc
  Return,1
end;init
pro Oodisplayecho__define,class
  ;
  ;NAME:
  ;        ooDisplayEcho__define
  ;
  ;PURPOSE:
  ;
  ;PARAMETERS:
  ;
  ;KEYWORDS:
  ;
  ;_EXTRA - is used to pass keywords meant for the superclass.


  class = {Oodisplayecho,$
    inherits Myproperties,$
    dave_id:0L,$                ;WIDGET ID OF DAVE'S TLB
    davetool:Obj_new(),$        ;DAVE2 OBJECT REFERENCE WHEN CALLED FROM DAVE2
    filename : '',$             ;FILE NAME OF CURRENT DATA OBJECT
    data_dir:'',            $
    work_dir:'',            $
    state_saved:0,$             ;INDICATOR OF SAVED STATE OR NOT.
    comment : '',$
    dataset : Ptr_new(),$       ;POINTER TO AN ARRAY OF DATA OBJECTS
    facilitybgroup:0L,$         ;BGroup TO SELECT FACILITY
    datacontainer : Obj_new(),$ ;THE DATA CONTAINER FOR THE SET
    $;                          ;OF DATA OBJECTS
    ndataobj : 0,$              ;NUMBER OF DATA OBJECTS
    setcontainer : Obj_new(),$  ;CONTAINER FOR THE SETS IN THE
    $;                          ;DATA TREE
    setmembers : Ptr_new([-1]),$;POSITIONS OF MEMBERS OF SETS
    $;                          ;IN THE dataContainer
    ech : Obj_new(),$           ;ECHO OBJECT FOR OPERATIONS
    echorig : Obj_new(),$       ;SAVED ECHO OBJECT FOR RESTORE
    detchoices : Ptr_new(),$    ;DETECTOR OPTIONS ARRAY
    ftchoices : Ptr_new(),$     ;FOURIER TIMES
    displaychoices : Ptr_new(),$;IMAGE DISPLAY OPTIONS
    displayindex : 0,$          ;INDEX OF WHAT IMAGE TO DISPLAY
    imagetitle : 'Title',$      ;TITLE OF THE DISPLAYED IMAGE
    errorimagechoice:0,$        ;FLAG FOR DISPLAYING IMAGE ERROR
    plotxsize : 330,$           ;SIZE OF PLOT AND IMAGE WINDOWS
    plotysize : 330,$
    plotindex : 5,$             ;PLOT DISPLAY CHOICES
    plotupdown : 1,$            ;TOGGLE SWITCH FOR UP/DOWN PLOTTING
    detchoiceindex: 0,$         ;SELECTED DETECTOR INDEX
    ftchoiceindex: 0,$          ;SELECTED FOURIER TIME INDEX
    ftchoiceindexold:0,$        ;PREVIOUSLY SELECTED TIME INDEX
    qchoiceindex: 0,$           ;CURRENT Q INDEX
    qchoiceindexold: 100,$      ;PREVIOUS Q INDEX
    treeselectid: 0L,$          ;LAST TREE LEAF SELECTED
    treeselectval: '',$         ;VALUE OF LAST TREE LEAF SELECTED
    xindex:0,$                  ;X AND Y INDICES OF CURRENT
    yindex:0,$                  ;PIXEL
    detxdim : 0,$               ;X DIMENSION OF DETECTOR
    detydim : 0,$               ;Y DIMENSION OF DETECTOR
    beamcenxorig : 13.0,$       ;BEAM CENTER IN X DIMENSION
    beamcenyorig : 13.0,$       ;BEAM CENTER IN Y DIMENSION
    lambda : 6.0,$              ;WAVELENGTH FROM DATA OBJECT
    dlambda : 3.0,$             ;WAVELENGTH DISTRIBUTION
    mye : Ptr_new(),$           ;4-D ECHO ARRAY
    ie : Ptr_new(),$            ;3-D ARRAY AT SELECTED FOURIER TIME
    im : Ptr_new(),$            ;2-D ARRAY FOR IMAGE DISPLAY
    imeb : Ptr_new(),$          ;2-D ARRAY ERROR BAR VALUES
    geombase : Ptr_new(),$      ;GEOMETRY OF TL BASE WIDGET
    geomimage : Ptr_new(),$     ;GEOMETRY OF IMAGE DRAW WIDGET
    geomplot : Ptr_new(),$      ;GEOMETRY OF PLOT DRAW WIDGET
    atlb : 0L,$                 ;TOP LEVEL BASE
    atlbxsize : 800,$
    atlbysize : 600,$
    $;THE NEXT ITEMS ARE USED TO ADJUST THE GUI GEOMETRY.
    xpadding : 4.0,$
    ypadding : 4.0,$
    filetreexsize : 150,$
    filetreeysize : 500,$
    tabsxsize : 330,$
    tabsysize : 500,$
    taucdysize : 28,$
    clickphaseysize : 67,$
    tw1ysize : 22,$
    filetreexpadding : 4,$
    filetreeypadding : 26,$
    tabsxpadding : 8,$
    tabsypadding : 30 ,$
    magicxpadding : 50,$
    magicypadding : 50,$
    drawbasexsize : 330,$
    drawbaseysize : 330,$
    $;
    $;
    colortable:4,$
    mousemotionblock:0,$
    thetabs : 0L,$              ;TAB WIDGET TO ORGANIZE SPACE
    $;DETECTOR PARAMETERS WIDGETS
    tlb1 : 0L,$                 ;BUTTON AND TEXT FIELD BASE
    tlb1a : 0L,$
    tlb1a1 : 0L,$               ;FILE TREE WIDGET BASE
    ftree : 0L,$
    qtw : Ptr_new(),$           ;ARRAY OF TREE WIDGETS FOR UNIQUE Q VALS
    ftw : Ptr_new(),$           ;ARRAY OF TREE WIDGETS FOR FILE NAMES
    tlb1a2 : 0L,$               ;GENERAL PROPERTIES BASE
    tlb1a3 : 0L,$               ;SAMPLE PROPERTIES BASE
    atl0 : 0L,$
    atwfile : 0L,$              ;TEXT WIDGET FOR FILENAME DISPLAY
    adw0 : 0L,$                 ;DROPLIST WIDGET FOR IMAGE DISPLAY CHOICE
    adw1 : 0L,$                 ;DROPLIST WIDGET FOR DETECTOR CHOICES
    adwtau : 0L,$               ;DROPLIST WIDGET FOR FOURIER TIME CHOICES
    adwq : 0L,$                 ;DROPLIST WIDGET FOR Q VALUES
    rewbuttonq : 0L,$           ;BUTTONS FOR RUNNING THROUGH
    revbuttonq : 0L,$           ;Q AND TAU VALUES
    fwdbuttonq : 0L,$
    ffwdbuttonq : 0L,$
    rewbuttontau : 0L,$
    revbuttontau : 0L,$
    fwdbuttontau : 0L,$
    ffwdbuttontau : 0L,$
    plotmaskzoombutton : 0L,$
    plotmaskzoomflag : 0,$
    ;
    plotzoomswitch:0,$
    plotunzoombutton:0L,$
    ;
    plotpressx:0.0,$        ;POSITIONS OF PRESS AND RELEASE
    plotpressy:0.0,$        ;ON PLOT --- USE NORMALIZED COORDINATES!!!
    plotreleasex:0.0,$
    plotreleasey:0.0,$
    plotmousepressed:0,$    ;FLAG TO TELL WHETHER MOUSE IS PRESSED FOR DRAGGING
    plotxmin:10000.0,$
    plotxmax:-10000.0,$     ;SAVE THE PLOT RANGES IN CASE OF ZOOM.
    plotymin:10000.0,$
    plotymax:-10000.0,$
    plotzoombox:0,$
    plotzoomed:0,$
    atwscaleupdownxyz:0L,$
    scaleupdownxyz:1.0,$
    maskbutton : 0L,$
    maskbase : 0L,$
    maskmakercw : 0L,$
    maskmakermask : Ptr_new(),$
    atl1 : 0L,$
    atw1 : 0L,$
    atw1value : 0,$
    binallbutton : 0L,$
    transvolallbutton : 0L,$
    atl2 : 0L,$
    atwbcx : 0L,$
    atl3 : 0L,$
    atwbcy : 0L,$
    atwwidth : 0L,$
    gaussianwidth : 702.0,$
    atwperiod : 0L,$        ;SET PERIOD VALUE FOR ALL DATA
    periodvalue : 360.0,$
    atwphaseoffset : 0L,$   ;SET PHASE OFFSET FOR ALL DATA
    atwtrans : 0L,$
    atwvolfrac : 0L,$
    atl4 : 0L,$
    atwnarcs : 0L,$
    atwlambda : 0L,$
    atl5 : 0L,$
    atwlambdadist : 0L,$
    atl6 : 0L,$
    tlb2 : 0L,$                 ;DATA DISPLAY BASE
    magplotcontextsubmenu:0L,$  ;MAGNETIC WIDGETS
    magplotmenusubmenu:0L,$
    magneticcheckbox:0L,$
    deepmaskingcheckbox:0L,$
    timeaverageupdowncheckbox:0L,$
    timeaverageupdownapplyallbutton:0L,$
    atwflippingratio:0L,$
    atwpolarization:0L,$
    atweff_bpw:0L,$
    atweff_bpw_x:0L,$
    atweff_bpw_y:0L,$
    atweff_bpw_z:0L,$
    atwpoint_to_up_x:0L,$
    atwpoint_to_down_x:0L,$
    atwpoint_to_up_y:0L,$
    atwpoint_to_down_y:0L,$
    atwpoint_to_up_z:0L,$
    atwpoint_to_down_z:0L,$
    atwxyzupdownscale:0L,$
    dw1 : 0L,$                  ;DRAW WIDGET FOR IMAGE
    dw2 : 0L,$                  ;DRAW WIDGET FOR PLOT
    dw1pix : 0L,$               ;VIRTUAL WINDOW FOR IMAGE
    dw2pix : 0L,$               ;VIRTUAL WINDOW FOR PLOT
    dw2auxpix:0L,$              ;
    dw2aux : 0L,$               ;AuxilIARY WINDOWS, DRAW WIDGET AND BASE FOR FLOATING PLOT.
    dw2auxid : 0L,$             ;
    dw2auxbase : 0L,$           ;
    imageerrorbase : 0L,$       ;BASE FOR IMAGE ERROR
    imageerrordw : 0L,$         ;DRAW WIDGET FOR IMAGE EB
    dwebpix : 0L,$
    dwebid : 0L,$
    $;FIT PARAMETERS WIDGETS
    phaseimportbutton : 0L,$    ;BUTTON TO IMPORT PHASES FROM ANOTHER DATA OBJECT
    phaseimportbase : 0L,$      ;MODAL DIALOG FOR SELECTING PHASES TO
    phaseimportlist : 0L,$      ;IMPORT
    $
    removesetbase : 0L,$
    removesetlist : 0L,$
    setselectbase : 0L,$
    setselectlist : 0L,$
    setnamebase : 0L,$
    setnamefield : 0L,$
    mergebase : 0L,$
    mergelist : 0L,$
    removefouriertimemenu : 0L,$
    iqtdisplayobj : Obj_new(),$
    iqtdisplaybase : 0L,$
    iqtimportbase : 0L,$
    datimportlist : 0L,$
    resimportlist : 0L,$
    bkgimportlist : 0L,$
    resbkgimportlist:0L,$
    tlb1b : 0L,$
    fitbuttonallq : 0L,$        ;BUTTON TO FIT EVERYTHING
    fitbuttonallminus360 : 0L,$ ;BUTTON TO FIT EVERYTHING FOR CURRENT FILE AFTER SHIFTING PHASES BY -360
    fitbuttonallplus360 : 0L,$  ;BUTTON TO FIT EVERYTHING FOR CURRENT FILE AFTER SHIFTING PHASES BY -360
    fitselector:0L,$    ;CWO TO SELECT TYPE OF FIT
    fitselectorobj:Obj_new(),$
    fitbuttonall : 0L,$         ;BUTTON TO FIT EVERYTHING FOR CURRENT FILE
    fitbutton:0L,$              ;BUTTON TO FIT ALL ECHOES FOR CURRENT TAU
    fitbutton1:0L,$             ;BUTTON TO FIT THIS ECHO ONLY
    clickrefitbase:0L,$
    clickrefitslider:0L,$       ;VALUE SLIDER FOR CLICK REFIT.
    clickrefitvalue:0L,$
    clickrefitperiodslider:0L,$ ;VALUE SLIDER FOR PERIOD ON CLICK REFIT.
    clickrefitperiodvalue:0L,$
    atl1a : 0L,$
    $;
    fixed:Intarr(6),$           ;ARRAY TO PASS TO FIT FUNCTION
    $;                          ;TO SELECT WHETHER TO VARY PARMS
    startparms : Dblarr(6),$
    $;
    $;CONST FIT PARAMETER
    constbase : 0L,$
    dropfixconst : 0L,$
    atwconst : 0L,$
    atweconst : 0L,$
    $;AMPLITUDE FIT PARAMETER
    ampbase : 0L,$
    dropfixamp : 0L,$
    atwamp : 0L,$
    atweamp : 0L,$
    $;PHASEo FIT PARAMETER
    phaseobase : 0L,$
    dropfixphaseo : 0L,$
    atwphaseo : 0L,$
    atwephaseo : 0L,$
    $;SIGMA FIT PARAMETER
    sigmabase : 0L,$
    dropfixsigma : 0L,$
    atwsigma : 0L,$
    atwesigma : 0L,$
    $;OMEGA FIT PARAMETER
    omegabase : 0L,$
    dropfixomega : 0L,$
    atwomega  : 0L,$
    atweomega  : 0L,$
    $;PHASE FIT PARAMETER
    phasebase  : 0L,$
    dropfixphase : 0L,$
    atwphase  : 0L,$
    atwephase : 0L,$
    $;ADDITIONAL RESULTS FIELDS
    atwchisq : 0L,$
    atwratio : 0L,$
    $;FIT PARAMETER LIMITS
    limited:Intarr(6),$         ;ARRAY TO PASS TO FIT FUNCTION
    $;                          ;TO SELECT WHETHER TO LIMIT PARMS
    $;CONSTANT LIMITS
    limconstbase : 0L,$
    droplimitconst : 0L,$
    atwminlimconst  : 0L,$
    atwmaxlimconst : 0L,$
    $;AMPLITUDE LIMITS
    limampbase : 0L,$
    droplimitamp : 0L,$
    atwminlimamp  : 0L,$
    atwmaxlimamp : 0L,$
    $;PHASEO LIMITS
    limphaseobase : 0L,$
    droplimitphaseo : 0L,$
    atwminlimphaseo  : 0L,$
    atwmaxlimphaseo : 0L,$
    $;SIGMA LIMITS
    limsigmabase : 0L,$
    droplimitsigma : 0L,$
    atwminlimsigma  : 0L,$
    atwmaxlimsigma : 0L,$
    $;OMEGA LIMITS
    limomegabase : 0L,$
    droplimitomega : 0L,$
    atwminlimomega  : 0L,$
    atwmaxlimomega : 0L,$
    $;PHASE LIMITS
    limphasebase : 0L,$
    droplimitphase : 0L,$
    atwminlimphase  : 0L,$
    atwmaxlimphase : 0L,$
    $;DRAW WIDGETS
    tw1 : 0L,$
    dw1id:0L,$                  ;DRAW WIDGET IDs
    dw2id:0L,$
    tw1id:0L,$
    atw1id:0L,$
    atwbcxid:0L,$
    atwbcyid:0L,$
    atwlambdaid:0L,$
    atwlambddistaid:0L,$
    w1xptr : Ptr_new(),$   ;SET THESE VALUES AT POINT OF EVENT TO
    w1yptr : Ptr_new(),$   ;PREVENT AXIS CONFUSION
    webxptr : Ptr_new(),$  ;SET THESE VALUES AT POINT OF EVENT TO
    webyptr : Ptr_new(),$  ;PREVENT AXIS CONFUSION
    w2xptr : Ptr_new(),$   ;SET THESE VALUES AT POINT OF EVENT TO
    w2yptr : Ptr_new(),$   ;PREVENT AXIS CONFUSION
    w2xauxptr : Ptr_new(),$   ;SET THESE VALUES AT THIS POINT TO
    w2yauxptr : Ptr_new(),$   ;PREVENT AXIS CONFUSION
    phase : Ptr_new(),$;ech->getProperty(tag='phase')
    no_of_phases : 0,$
    no_of_fourier_times : 0,$
    drawimage : Obj_new(),$
    notify_ids:Lonarr(2),   $
    group_leader:0L,        $
    drawplot : Obj_new()};, $
  ;inherits myproperties $
  ;}


end;define


