; $Id$



pro ooDisplayEcho::CalculateIQT3_doFits,obj=o,res=res,cell=cell,_Extra=extra


    if n_elements(cell) eq 0 then cell = 0
    
    ;DO FITTING IF NECESSARY
    alreadyFit = o->getProperty(tag='reduced')
    if alreadyFit eq 0 then begin
        useResToFit = 0
        if res->count() gt 0 then begin
          o_res = res->get(position=0)
          resAlreadyFit = o_res->getProperty(tag='reduced')
          if resAlreadyFit eq 0 then begin
            o_res->arcFit
            self->redefineTree
          endif
          useResToFit = 1          
        endif
  
        ;GET NEEDED INFO
        ref_tavestate = o->report_timeaverage_state()
        fixed = self->getFixed()
        phasefixindex = widget_info(self.dropfixphaseo,/droplist_select);nse_comboindex(self.dropfixphaseo)
        if phasefixindex eq 7 then noborrow = 1
        if phasefixindex eq 8 then noborrow = 1
        if fixed[3] eq 1 then begin
            widget_control,self.atwsigma,get_value=ssigma
            sigma = double(ssigma)
        endif
  
  
        if useResToFit eq 0 then begin
            ;DO THE FIT
            o->arcFit,fixed=fixed,sigma=sigma,noborrow=noborrow,tavestate=ref_tavestate        
        endif else begin
  
    
    
    
          
                fixed[2] = cell eq 0 ? 1 : 0 ;FIX PHASE FOR CELL BUT NOT FOR SAMPLE
                fixed[4] = 1 ;FIX PERIOD FOR BOTH CELL AND SAMPLE
          
                ;CONVERT PERIOD TO OMEGA
                widget_control,self.atwomega,get_value=somega
                omega = 1.0/double(somega)
          
                o->fitAllFixedPhase,$
                        o_res,$
                        fixed=fixed,$
                        ;startparms=startparms,$
                        obj=self,$
                        ;phaseoffset = phaseoffset,$
                        ;fitphaseoffset=0,$
                        omega=omega,$
                        allownegamp=1,$
                        forcenegamp=0
              
        
        endelse
        o->setProperty,'reduced',1
        self->redefineTree
        
    endif;DO FITS

end;ooDisplayEcho::CalculateIQT3_doFits


pro ooDisplayEcho::CalculateIQT3,datObj=dat,resObj=res,bkgObj=cell,resBkgObj=resCell,$
                                            echoAverageOpt = echoAverageOpt,$
                                            datIndex=datIndex,$
                                            narcs=narcs,_Extra=extra

catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::CalculateIQT3!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    ;if widget_info(self.IQTImportBase,/valid_id) eq 0 then begin
    if widget_info(self.IQTImportBase,/valid_id) eq 0 then begin
      void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    endif else begin
      void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.IQTImportBase)
    endelse
    catch, /cancel
    return
endif
  if dat->count() le 0 then begin
    print,'No Data Selected!'
    return
  endif
  
  print,'ooDisplayEcho::CalculateIQT3'

;  help,dat,res,cell,resCell
;  help,extra

;  print,dat->count()
;  print,res->count()
;  print,cell->count()
;  print,resCell->count()

  if n_elements(echoAverageOpt) eq 0 then echoAverageOpt = 0

if res->count() gt 0 then begin
  
endif


;SAMPLE  
  for i=0,dat->count()-1 do begin
    ;print,'i=',i
    o = dat->get(position=i)

    ;CALCULATE Q values AND up/down IF NECESSARY
    if o->getProperty(tag='QValsSwitch') eq 0 then begin
        o->calculateQVals
    endif
    if o->getProperty(tag='IupdownSwitch') eq 0 then begin
        o->calculateIup_downVals
    endif
    
    ;DO FITTING IF NECESSARY
    self->CalculateIQT3_doFits,obj=o,res=res
        if i eq 0 then begin
          ofirst = o
          o->calculateArcsQMatrix,narcs=narcs,arcmat=arcmat
          t = o->tau()
          ;help,fitmask
;help,arcmat          
;print,'GET THE MOST RESTRICTIVE MASKING AND CALCULATE Q AVERAGE FROM THE Q MATRIX'
qvals = *(o->getproperty(tag='qvals'))
;print,'qvals[*,0]=',qvals[*,0]
qmin = min(qVals)
qmax = max(qvals)
qstep = (qmax-qmin)
;help,qvals          
          num = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sNum = dblarr(n_elements(arcmat),n_elements(t))
          upperNum = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sUpperNum = dblarr(n_elements(arcmat),n_elements(t))
          upperDenom = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sUpperDenom = dblarr(n_elements(arcmat),n_elements(t))

          denom = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sDenom = dblarr(n_elements(arcmat),n_elements(t))
          lowerNum = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sLowerNum = dblarr(n_elements(arcmat),n_elements(t))
          lowerDenom = dblarr(n_elements(arcmat),n_elements(t)) ;DO EVERYTHING 1D
          sLowerDenom = dblarr(n_elements(arcmat),n_elements(t))

          ;fitmask = intarr(n_elements(arcmat),n_elements(t))
          
;          for ii=0,n_elements(t)-1 do begin
;;;            help,*(o->getproperty(tag='mask2d'))
;;;            fitmask = reform(*(o->getproperty(tag='mask2d')),64,n_elements(t))
;          endfor;ii
;          window,1
;          plotimage,reform(fitmask[*,0],8,8)
;;;          print,reform(fitmask[*,0],8,8)
          
          mask = 1+intarr(n_elements(arcmat),n_elements(t))
          mondat0 = ((o->getProperty(tag='preset')))
          Tdat0 = o->getProperty(tag='transmission')
          fitmask0 = *(o->getProperty(tag='mask2d'))
          fitmask = fitmask0
          volfracdat0 = 1.0  - o->getProperty(tag='volfrac')

        endif;i eq 0
          

        
;        imatch = ofirst->resIndex(t[0],o)
;        print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
;        print,'i,imatch=',i,imatch
;        print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;'

        ;edat = *(o->getProperty(tag='e'))
        datTau = o->tau()
        Tdat = o->getProperty(tag='transmission')
        tempfn = file_basename(o->getProperty(tag='filename'))
        
;print,tempfn+' -Tdat=  ',tDat        
        Adat = reform((*(o->getProperty(tag='fitparms')))[1,*,*],n_elements(arcmat),n_elements(datTau))
        sAdat = reform((*(o->getProperty(tag='fitparms')))[7,*,*],n_elements(arcmat),n_elements(datTau))
        Iupdat = (*(o->getProperty(tag='Iup')))
        sIupdat = (*(o->getProperty(tag='sIup')))
        Idowndat = (*(o->getProperty(tag='Idown')))
        sIdowndat = (*(o->getProperty(tag='sIdown')))
        mondat = ((o->getProperty(tag='preset')))
        fitmaskdat = *(o->getProperty(tag='mask2d'))

        volfracdat = 1.0  - o->getProperty(tag='volfrac')
        for j=0,n_elements(t)-1 do begin        
          jmatch = ofirst->resIndex(t[j],o)
          ;print,'dat: j,jmatch=',j,jmatch
          if jmatch ne -1 then begin
            f = 1.0
            whfitmask = where(fitmaskdat[*,jmatch] lt 1,whfitmaskcount)
            if whfitmaskcount ne 0 then begin
              fitmask[whfitmask,j] = 0 
            endif

;            
;            RnumSteve = (double(monDat0)/double(monDat))*TDat0/TDat
;            R = volfracdat*RnumSteve    
;            f = R
 
;A DIFFERENT APPROACH FROM ANTONIO, WHICH WILL BE EQUIVALENT AND
;SEEMS A BIT CLEANER
;
            f = 1.0/(volfracdat*mondat*Tdat)

;print,'monDat0,monDat=',monDat0,monDat,mondat0/monDat
;print,'tDat0,tDat=',tdat0,tDat,tdat0/tDat
RNum = (monDat0*TDat0)
;print,'RNum=',RNum
RDenom = volfracDat0*RNum
;print,'RDenom=',RDenom

            ;num = num + f*(Adat/(IDownDat-IUpDat))
            uppernum[*,j] = uppernum[*,j] + RDenom*2.0*f*Adat[*,jmatch]
            supperNum[*,j] = sqrt(supperNum[*,j]^2 + (RDenom*2.0*f*sAdat[*,jmatch])^2)
            upperdenom[*,j] = upperdenom[*,j] + RDenom*f*(IDownDat[*,jmatch]-IUpDat[*,jmatch])
            sUpperDenom[*,j] = sqrt(sUpperDenom[*,j]^2 + (RDenom*f*sIDownDat[*,jmatch])^2 + (RDenom*f*sIUpDat[*,jmatch])^2)
          endif
          ;help,tdat,adat,sadat,iupdat,siupdat,idowndat,sidowndat,mondat,volfracdat,arcmat,narcs
      endfor;j
  endfor;i

;print,'GOT SAMPLE'
;CELL
  for i=0,cell->count()-1 do begin
    ;print,'i=',i
    o = cell->get(position=i)
              
        if o->getProperty(tag='QValsSwitch') eq 0 then begin
            o->calculateQVals
        endif
        if o->getProperty(tag='IupdownSwitch') eq 0 then begin
            o->calculateIup_downVals
        endif
        
    self->CalculateIQT3_doFits,obj=o,res=res

        ;edat = *(o->getProperty(tag='e'))
        tauCell = o->tau()
        Tcell = o->getProperty(tag='transmission')
        Acell = reform((*(o->getProperty(tag='fitparms')))[1,*,*],n_elements(arcmat),n_elements(tauCell))
        sAcell = reform((*(o->getProperty(tag='fitparms')))[7,*,*],n_elements(arcmat),n_elements(tauCell))
        IupCell = (*(o->getProperty(tag='Iup')))
        sIupCell = (*(o->getProperty(tag='sIup')))
        IdownCell = (*(o->getProperty(tag='Idown')))
        sIdownCell = (*(o->getProperty(tag='sIdown')))
        monCell = ((o->getProperty(tag='preset')))
        fitmaskcell = *(o->getProperty(tag='mask2d'))
        tempfn = file_basename(o->getProperty(tag='filename'))
;print,'CELL:  tempfn,tCell = ',tempfn,tCell
        
        volfracCell = 1.0   ;---- LRK - 101211 - THIS NEEDS TO BE UPDATED SO THAT THE colFracCell CAN BE ENTERED AND USED
                            ;                    IN THE CASE OF SIGNIFICANT AMOUNTS OF INCOHERENT SCATTERING FROM THE SOLVENT        
        volfracCell = 1.0  - o->getProperty(tag='volfrac')
        
        numCell = ACell
        snumCell = sACell 
               
        upperDenomCell = IDownCell-IUpCell
        supperDenomCell = sqrt(sIDownCell^2 + sIUpCell^2)

;          f = 1.0
;          RnumSteve = (double(monDat0)/double(monCell))*Tdat0/TCell
;          R = volfracdat0*RnumSteve
;          f = R

; LRK - 10/12/11
;SO IT LOOKS LIKE I DID THIS STEP FOR COMPLETENESS AND CONSISTANCY
;THAT MEANS THAT I JUST NEED TO PROVIDE A MEANS TO ENTER THE VALUE. --- PROBABLY IT IS HERE BUT COMMENTED OUT
          f = 1.0/(volfraccell*moncell*Tcell)

;print,''
;print,''
;print,''
;print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
;print,'CELL'
;print,'__________________________________________'


        for j=0,n_elements(t)-1 do begin
          to = o->tau()
          jmatch = ofirst->resIndex(t[j],o)

          if jmatch ne -1 then begin
            whfitmask = where(fitmaskcell[*,jmatch] lt 1,whfitmaskcount)
            if whfitmaskcount ne 0 then begin
              fitmask[whfitmask,j] = 0 
            endif

            ;INITIALLY IGNORE THE RELATIVE AMPLITUDES, VOLFRACS, AND TRANSMISSIONS
;              print,'test1',j
;              help,num

;print,'monDat0,monCell=',monDat0,monCell,mondat0/moncell
;print,'tdat0,tcell=',tdat0,tcell,tdat0/tcell
;RNum = (monDat0*TDat0);/(MonCell*TCell)
;print,'RNum=',RNum
;RDenom = volfracDat0*RNum
;print,'RDenom=',RDenom

              uppernum[*,j] = uppernum[*,j] - RNum*2.0*f*ACell[*,jmatch];f*numcell[*,jmatch]
              suppernum[*,j] = sqrt(suppernum[*,j]^2 + (RNum*2.0*f*sACell[*,jmatch])^2);sNumCell[*,jmatch])^2)
              upperDenom[*,j] = upperDenom[*,j] - RDenom*f*(IDownCell[*,jmatch]-IUpCell[*,jmatch]);upperDenomCell[*,jmatch]
              sUpperDenom[*,j] = sqrt(sUpperDenom[*,j]^2 + ((RDenom*f)^2)*(sIDownCell[*,jmatch]^2 + sIUpCell[*,jmatch]^2));upperDenomCell[*,jmatch])^2)
          endif  $
          else begin
            print,'Interpolating background, getting zeroth values for Iup,down Iteration '+strtrim(string(j),2)
            ACellNew = transpose(ofirst->getInterpBkg(t[j],o))
            sACellNew = transpose(ofirst->getInterpsBkg(t[j],o))
            IdownCellNew = IdownCell[*,0]
            IupCellNew = IupCell[*,0]
            sIdownCellNew = sIdownCell[*,0]
            sIupCellNew = sIupCell[*,0]

            uppernum[*,j] = uppernum[*,j] - RNum*2.0*f*ACellNew;[*,jmatch];f*numcell[*,jmatch]
            suppernum[*,j] = sqrt(suppernum[*,j]^2 + (RNum*2.0*f*sACellNew)^2);sNumCell[*,jmatch])^2)
            upperDenom[*,j] = upperDenom[*,j] - RDenom*f*(IDownCellNew-IUpCellNew);upperDenomCell[*,jmatch]
            sUpperDenom[*,j] = sqrt(sUpperDenom[*,j]^2 + ((RDenom*f)^2)*(sIDownCellNew^2 + sIUpCellNew^2));upperDenomCell[*,jmatch])^2)
        endelse


        endfor;j
  
  endfor;i
;print,'GOT CELL'


;RES
  for i=0,res->count()-1 do begin
;    print,'i=',i
    o = res->get(position=i)

      ;IN THE UNLIKELY (AND POSSIBLY INCORRECT) CASE OF MULTIPLE RES (PERHAPS FOR MISSING FT's?) 
        if i eq 0 then begin
          ofirstRes = o
          monRes0 = ((o->getProperty(tag='preset')))
          TRes0 = o->getProperty(tag='transmission')
          volfracRes0 = 1.0  - o->getProperty(tag='volfrac')

          ;PREFERENTIALLY USE qVals FROM RES WHEN AVAILABLE
          qvals = *(o->getproperty(tag='qvals'))
          ;print,'qvals[*,0]=',qvals[*,0]

        endif;i eq 0


        if o->getProperty(tag='QValsSwitch') eq 0 then begin
            o->calculateQVals
        endif
        if o->getProperty(tag='IupdownSwitch') eq 0 then begin
            o->calculateIup_downVals
        endif

        tauRes = o->tau()
        Tres = o->getProperty(tag='transmission')
        Ares = reform((*(o->getProperty(tag='fitparms')))[1,*,*],n_elements(arcmat),n_elements(tauRes))
        sAres = reform((*(o->getProperty(tag='fitparms')))[7,*,*],n_elements(arcmat),n_elements(tauRes))
        Iupres = (*(o->getProperty(tag='Iup')))
        sIupres = (*(o->getProperty(tag='sIup')))
        Idownres = (*(o->getProperty(tag='Idown')))
        sIdownres = (*(o->getProperty(tag='sIdown')))
        monres = ((o->getProperty(tag='preset')))
        fitmaskres = *(o->getProperty(tag='mask2d'))
  
        volfracres = 1.0  - o->getProperty(tag='volfrac')
        f = 1.0/(volfracRes*monRes*TRes)

;print,'monRes0,monRes=',monRes0,monRes,monRes0/monRes
;print,'tRes0,tRes=',tRes0,tRes,tRes0/tRes
RNumRes = (monRes0*TRes0)
;print,'RNumRes=',RNumRes
RDenomRes = volfracRes0*RNumRes
;print,'RDenomRes=',RDenomRes



        denomRes = (f*ARes/(f*(IDownRes-IUpRes)))
        sDenomRes = sARes/(IDownRes-IUpRes)
   
   
        
        for j=0,n_elements(t)-1 do begin
        ;loop over the j Fourier Times andd calculate the matching ones.
              jmatch = ofirst->resIndex(t[j],o)
;              print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
;              print,'RES:    j,jmatch=',j,jmatch
;              print,';;;;;;;;;;;;;;;;;;;;;;;;;;;;;'
;          print,'res: j,jmatch=',j,jmatch
          
          if jmatch ne -1 then begin
            whfitmask = where(fitmaskres[*,jmatch] lt 1,whfitmaskcount)
            if whfitmaskcount ne 0 then begin
              fitmask[whfitmask,j] = 0 
            endif
          ;INITIALLY IGNORE THE RELATIVE AMPLITUDES, VOLFRACS, AND TRANSMISSIONS
              ;f = 1.0   ;IS THERE REALLY NO SCALE FACTOR HERE ---- NO, IT SHOULD BE HANDLED THE SAME WAY AS THE NUMERATOR
              lowerNum[*,j] = lowerNum[*,j] + RDenomRes*2.0*f*Ares[*,jmatch]
              sLowerNum[*,j] = sqrt(sLowerNum[*,j]^2 + (RDenomRes*2.0*f*sAres[*,jmatch])^2)
              
              lowerDenom[*,j] = lowerDenom[*,j] + RDenomRes*f*(IDownRes[*,jmatch]-IUpRes[*,jmatch])
              sLowerDenom[*,j] = sqrt(sLowerDenom[*,j]^2 + ((RDenomRes*f)^2)*(sIDownRes[*,jmatch]^2+sIUpRes[*,jmatch]^2))

          endif
      ;help,tRes,aRes,saRes,iupRes,siupRes,idownRes,sidownRes,monRes,volfracRes,arcmat,narcs
        endfor;j
  endfor;i
;print,'GOT RES'


;RESCELL  
  for i=0,resCell->count()-1 do begin
 ;   print,'i=',i
    o = resCell->get(position=i)
              
        if o->getProperty(tag='QValsSwitch') eq 0 then begin
            o->calculateQVals
        endif
        if o->getProperty(tag='IupdownSwitch') eq 0 then begin
            o->calculateIup_downVals
        endif
    self->CalculateIQT3_doFits,obj=o,res=res

        

        tauResCell = o->tau()
        TresCell = o->getProperty(tag='transmission')
        AresCell = reform((*(o->getProperty(tag='fitparms')))[1,*,*],n_elements(arcmat),n_elements(tauResCell))
        sAresCell = reform((*(o->getProperty(tag='fitparms')))[7,*,*],n_elements(arcmat),n_elements(tauResCell))
        IupresCell = (*(o->getProperty(tag='Iup')))
        sIupresCell = (*(o->getProperty(tag='sIup')))
        IdownresCell = (*(o->getProperty(tag='Idown')))
        sIdownresCell = (*(o->getProperty(tag='sIdown')))
        monresCell = ((o->getProperty(tag='preset')))
        fitmaskresCell = *(o->getProperty(tag='mask2d'))

        volfracresCell = 1.0
        volfracresCell = 1.0  - o->getProperty(tag='volfrac')
        
;        denomResCell = (AresCell/(IDownresCell-IUpresCell))
;        RnumSteveResCell = (double(monres)/double(monresCell))*Tres/TresCell
;        RResCell = volfracres*RnumSteveResCell
;        f = RResCell
        f = 1.0/(volfracResCell*monResCell*TResCell)



        for j=0,n_elements(t)-1 do begin
          jmatch = ofirst->resIndex(t[j],o)          
 ;         print,'RESCELL: j,jmatch=',j,jmatch
          if jmatch ne -1 then begin
            whfitmask = where(fitmaskrescell[*,jmatch] lt 1,whfitmaskcount)
            if whfitmaskcount ne 0 then begin
              fitmask[whfitmask,j] = 0 
            endif
;            print,'RESCELL: j,jmatch=',j,jmatch

              lowerNum[*,j] = lowerNum[*,j] - RNumRes*2.0*f*AResCell[*,jmatch]
              sLowerNum[*,j] = sqrt(sLowerNum[*,j]^2 + (RNumRes*2.0*f*sAResCell[*,jmatch])^2)
              
              lowerDenom[*,j] = lowerDenom[*,j] - RDenomRes*f*(IDownResCell[*,jmatch]-IUpResCell[*,jmatch])
              sLowerDenom[*,j] = sqrt(sLowerDenom[*,j]^2 + ((RDenomRes*f)^2)*(sIDownResCell[*,jmatch]^2+sIUpResCell[*,jmatch]^2))

            endif $
            else begin
              print,'Interpolating background, getting zeroth values for Iup,down Iteration '+strtrim(string(j),2)
              AResCellNew = transpose(ofirst->getInterpBkg(t[j],o))
              sAResCellNew = transpose(ofirst->getInterpsBkg(t[j],o))
              IdownResCellNew = IdownResCell[*,0]
              IupResCellNew = IupResCell[*,0]
              sIdownResCellNew = sIdownResCell[*,0]
              sIupResCellNew = sIupResCell[*,0]
              
              lowerNum[*,j] = lowerNum[*,j] - 2.0*f*AResCellNew
              sLowerNum[*,j] = sqrt(sLowerNum[*,j]^2 + (2.0*f*sAResCellNew)^2)
              
              lowerDenom[*,j] = lowerDenom[*,j] - f*(IDownResCellNew-IUpResCellNew)
              sLowerDenom[*,j] = sqrt(sLowerDenom[*,j]^2 + (f^2)*(sIDownResCellNew^2+sIUpResCellNew^2))
            endelse
            
        endfor;j
  
  endfor;i
;print,'GOT RESCELL'

;help,num,denom
;help,finite(num),finite(denom)
;help,finite(num,/nan),finite(denom,/nan)
if res->count() gt 0 then begin
  num = upperNum*lowerDenom
;  print,'CALCULATED NUM'
  denom = lowerNum*upperDenom
;  print,'CALCULATED DENOM'
  IQT = num/denom
;  print,'CALCULATED IQT'
  
  sIQT = IQT*sqrt((sUpperNum/UpperNum)^2 + (sLowerDenom/LowerDenom)^2 + $
                  (sLowerNum/lowerNum)^2 + (sUpperDenom/upperDenom)^2) 
endif else begin
  ;IF NO RES THEN ELIMINATE THE DENOMINATOR CALCULATION 
  num = upperNum
  denom = upperDenom
  IQT = num/denom
;  print,'CALCULATED IQT'
  
  sIQT = IQT*sqrt((sUpperNum/UpperNum)^2 + (sUpperDenom/upperDenom)^2) 
endelse


;sIQT = IQT*(sUpperNum/UpperNum) + (sLowerDenom/LowerDenom) + $
;           (sLowerNum/lowerNum) + (sUpperDenom/upperDenom) 
;print,'CALCULATED SIQT'

weights = 1.0/sIQT^2
;print,'CALCULATED WEIGHTS'


whnotfinite = where(finite(IQT) eq 0 or $
                    finite(IQT,/nan) ne 0 or $
                    finite(weights) eq 0 or $
                    finite(weights,/nan) ne 0,whnotcount)
if whnotcount ne 0 then begin
  mask[whnotfinite] = 0
endif
;print,'MASKED NON-FINITE VALUES'

whnotfit = where(fitmask eq 0,whnotfitcount)
if whnotfitcount ne 0 then begin
  mask[whnotfit] = 0
endif

;help,IQT,arcmat,narcs
result = dblarr(narcs > 2,n_elements(t))
altresult = dblarr(narcs > 2,n_elements(t))
totalWeights = dblarr(narcs > 2,n_elements(t))
totalQWeights = dblarr(narcs > 2);,n_elements(t))
Qarray = dblarr(narcs > 2);,n_elements(t))

totalQWeightsOld = dblarr(narcs > 2);,n_elements(t))
QarrayOld = dblarr(narcs > 2);,n_elements(t))


;print,'CREATED RESULTS ARRAYS'



for i=0,n_elements(t)-1 do begin
  for j=0,narcs-1 do begin
    whiqt = where(mask[*,i] ne 0 and arcmat eq j,count)
    ;print,'count=',count
    result[j,i] = total(IQT[whiqt,i]*weights[whiqt,i]);/(1.0*count)

    ;NOTE:  I AM USING A WEIGHTED AVERAGE FOR Q CALCULATIONS, WHEREAS THE ORIGINAL NSE CODE
    ;       USED A SIMPLE AVERAGE FOR Q CALCULATIONS 
    
    Qarray[j] = Qarray[j] + total(Qvals[whiqt,i]*weights[whiqt,i]);/(1.0*count)
    totalQWeights[j] = totalQWeights[j]+total(weights[whiqt,i])

    QarrayOld[j] = QarrayOld[j] + total(Qvals[whiqt,i]);/(1.0*count)
    totalQWeightsOld[j] = totalQWeightsOld[j]+count

    altresult[j,i] = total(IQT[whiqt,i])/(1.0*count)
    totalWeights[j,i] = total(weights[whiqt,i])
    ;print,'count,totalWeights[j,i],result[j,i]/weights[j,i]=',count,totalWeights[j,i],result[j,i]/totalweights[j,i]
  endfor;j
endfor;i

;print,'COMPUTED RESULTS'
result      = result/totalWeights
Qarray      = Qarray/totalQWeights
uncertainty = 1.0/sqrt(totalWeights) 

;Print,'QArrayOld=',QArrayOld
;print,'totalQWeightsOld=',totalQWeightsOld
QarrayOld      = QarrayOld/totalQWeightsOld
;Print,'QArrayOld=',QArrayOld
;print,'UPDATED FOR WEIGHTS'


;print,'t=',t
;for j=0,narcs-1 do begin
;  print,'result['+strtrim(string(j),2)+',*]=',transpose(result[j,*])
;  print,'uncertainty['+strtrim(string(j),2)+',*]=',transpose(uncertainty[j,*])  
;endfor;j
;;;help,result,uncertainty
;print,'PRINTED RESULTS'


;NO, THIS IS THE WORNG PLACE TO STORE THIS INFO.  
;THIS IS THE SUMMED I(Q,t) DATA SO IT NEEDS TO GO
;INTO

;help,result

sz = size(result)
;print,'size(result)=',size(result)
if sz[0] eq 2 and sz[1] eq 1 then begin
  print,'RESIZING THE RESULTS ARRAYS'
  newresult = dblarr(2,sz[2])
  newuncertainty = newresult
  newresult[0,*] = result[0,*]
  newuncertainty[0,*] = uncertainty[0,*]
  result = newresult
  uncertainty=newuncertainty
  
endif
sz = size(uncertainty)
;print,'size(uncertainty)=',size(uncertainty)


pqarcs = ofirst->getProperty(tag='qArcs')
if ptr_valid(pqarcs) then ptr_free,pqarcs
ofirst->setProperty,'qArcs',ptr_new(QArrayOld);ptr_new(Qarray)
;print,'min(qvals),max(qvals)=',min(qvals),max(qvals)
;print,'Qarray=',Qarray

ps = ofirst->getProperty(tag='IQT')
if ptr_valid(pS) then ptr_free,pS
ofirst->setProperty,'IQT',ptr_new(result)

pss = ofirst->getProperty(tag='sIQT')
if ptr_valid(pss) then ptr_free,pss
ofirst->setProperty,'sIQT',ptr_new(uncertainty)
;help,arcmat

self->displayIQT_new,datIndex[0]

outputFilename = file_basename(ofirst->getProperty(tag='filename'))
outputfilename = self.work_dir+path_sep()+outputfilename+'.IQT'
duh = ofirst->writeDave(outputFilename,work_dir=self.work_dir)

;;;temp = total(result,1)

;window,0
;bpm = !p.multi
;!d.multi = 0
;device,get_decomposed=dc
;device,decomposed=1
;plot,t,result[0,*],/xlog,color=0L,background=(2L)^24-1
;errplot,t,result[0,*]+uncertainty[0,*],result[0,*]-uncertainty[0,*],/data,color=0L
;print,'MADE TEST PLOT'
;device,decomposed=dc


;help,ofirst
;ofn = dialog_pickfile(filter = ['*.dat','*.txt'],path=self.work_dir)
;if ofn ne '' then begin
;  MACSRunner_v1_addDotExt,ofn,'txt'
;  print,'ofn=',ofn
;  
;  format = '(g15.7)'
;  openw,lun,ofn,/get_lun
;  printf,lun,'#   t   I(Q,t)   sI(Q,t)'
;  for i=0,n_elements(t)-1 do begin
;    sout = strtrim(string(t[i],format=format),2)+' '
;    for j=0,narcs-1 do begin
;      sout = sout+strtrim(string(result[j,i],format=format),2)+' '+strtrim(string(uncertainty[j,i],format=format),2)      
;    endfor;j
;    printf,lun,sout
;  endfor;i
;  free_lun,lun
;endif


end;ooDisplayEcho::CalculateIQT3


pro ooDisplayEcho::calculateIQTDialog3_updateTable

catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::calculateIQTDialog3_updateTable!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return
endif



          self->calculateIQTDialog3_getFileLists,theDatList,datIndexList,$
                                                 theResList,resIndexList,$
                                                 theBkgList,bkgIndexList,$
                                                 theResBkgList,resBkgIndexList,$
                                                 _Extra=extra

          elements = self->calculateIQTDialog3_setUpTable(theDatList,theResList,theBkgList,theResBkgList,$
                                                    datIndexList,resIndexList,bkgIndexList,resBkgIndexList,$
                                                    _Extra=extra)
                                                    
          table = widget_info(self.IQTImportBase,find_by_uname='IQTOUTPUTTABLE')
          widget_control,table,set_value=elements

end;ooDisplayEcho::calculateIQTDialog3_updateTable
pro ooDisplayEcho::calculateIQTDialog3_updateImportLists,updateIndex,newvolfrac
  
  ;GO THROUGH ALL THE LISTS, FIGURE OUT WHETHER THE UPDATE FROM THE TABLE IS A SELECTION,
  ;AND UPDATE THE volfrac FIELD
  
  
print,'updateindex,newVolFrac=',updateindex,newVolFrac  
  widget_control,self.IQTImportBase,get_uvalue=iqt
  
  
  
  ;sample
        volfrac = widget_info(self.IQTImportBase,find_by_uname='SAMPLEVOLUMEFRACTION')
        index=widget_info(self.datImportList,/list_select)
        if index[0] ne -1 then begin
          indexList = iqt.datList
          sel = indexList[index]
          for i=0,n_elements(sel)-1 do begin
            if sel[i] eq updateIndex then begin
              print,'volfrac,sel[0],updateindex,newVolFrac=',volfrac,sel[0],updateindex,newVolFrac
              widget_control,volfrac,set_value=newVolFrac
            endif
          endfor;i
        endif;index[0]
  
  
  ;res
        volfrac = widget_info(self.IQTImportBase,find_by_uname='RESVOLUMEFRACTION')
        index=widget_info(self.resImportList,/list_select)
        if index[0] ne -1 then begin
          indexList = iqt.resList
          sel = indexList[index]
          for i=0,n_elements(sel)-1 do begin
            if sel[i] eq updateIndex then begin
              print,'volfrac,sel[0],updateindex,newVolFrac=',volfrac,sel[0],updateindex,newVolFrac
              widget_control,volfrac,set_value=newVolFrac
            endif
          endfor;i
        endif;index[0]
  ;cell
        volfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')
        index=widget_info(self.bkgImportList,/list_select)
        if index[0] ne -1 then begin
          indexList = iqt.bkgList
          sel = indexList[index]
          for i=0,n_elements(sel)-1 do begin
            if sel[i] eq updateIndex then begin
              print,'volfrac,sel[0],updateindex,newVolFrac=',volfrac,sel[0],updateindex,newVolFrac
              widget_control,volfrac,set_value=newVolFrac
            endif
          endfor;i
        endif;index[0]
  
  ;rescell
        volfrac = widget_info(self.IQTImportBase,find_by_uname='RESCELLVOLUMEFRACTION')
        index=widget_info(self.resBkgImportList,/list_select)
        if index[0] ne -1 then begin
          indexList = iqt.resbkgList
          sel = indexList[index]
          for i=0,n_elements(sel)-1 do begin
            if sel[i] eq updateIndex then begin
              print,'volfrac,sel[0],updateindex,newVolFrac=',volfrac,sel[0],updateindex,newVolFrac
              widget_control,volfrac,set_value=newVolFrac
            endif
          endfor;i
        endif;index[0]
end;ooDisplayEcho::calculateIQTDialog3_updateImportLists
pro ooDisplayEcho::calculateIQTDialog3_syncCellResCell,fromResCell=fromResCell,fromCell=fromCell,$
                                                       toResCell=toResCell,toCell=toCell,$
                                                       _Extra=Extra


catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::calculateIQTDialog3_syncCellResCell!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return
endif



  ;THIS METHOD IS USED TO SYNCH ANY ACTIVITY BETWEEN THE REC CELL AND CELL WIDGETS.  THIS IS 
  ;IMPORTANCE BECAUSE A CELL FILE COULD BE IN BOTH OF THESE, AND THE USER COULD TRY TO UPDATE THE
  ;TRANISMISSION OR VOLUME FRACTOIN FOR EITHER OF THESE.
  
  if n_elements(fromResCell) eq 0 then fromResCell = 0
  if n_elements(fromCell) eq 0 then fromCell = 0
  if n_elements(toResCell) eq 0 then toResCell = 0
  if n_elements(toCell) eq 0 then toCell = 0


  update = 1
  widget_control,self.IQTImportBase,get_uvalue=iqt
  cellIndexList = iqt.bkgList
  resCellIndexList = iqt.resbkgList

  
;GET THE CURRENT SELECTION AND VALUE
  if fromResCell eq 1 then begin
        volfrac = widget_info(self.IQTImportBase,find_by_uname='RESCELLVOLUMEFRACTION')
        index=widget_info(self.resBkgImportList,/list_select)
        
        if index[0] ne -1 then begin
          sel = resCellIndexList[index];index[resCellIndexList]
          for i=0,n_elements(index)-1 do begin
            duh = self.dataContainer->get(position=sel[i])
            print,'=',duh->getProperty(tag='volfrac')
          endfor;i
          widget_control,volfrac,get_value=newVolFrac
          print,'newVolFrac=',newVolFrac
        endif else update = 0
        

  
  endif;fromResCell


  if fromCell eq 1  then begin
        volfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')
        index=widget_info(self.bkgImportList,/list_select)
        if index[0] ne -1 then begin
          sel = cellIndexList[index]
          for i=0,n_elements(index)-1 do begin
            duh = self.dataContainer->get(position=sel[i])
            print,'=',duh->getProperty(tag='volfrac')
          endfor;i
          widget_control,volfrac,get_value=newVolFrac
          print,'newVolFrac=',newVolFrac
        endif else update = 0
  
  endif;fromCell


  ;APPLY THE VALUE TO THE SELECTION IN THE OTHER LIST
  if update eq 1 then begin
    if toCell eq 1 then begin
print,'toCell'    
          print,'newVolFrac=',newVolFrac
        tovolfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')
        index=widget_info(self.bkgImportList,/list_select)
        if index[0] ne -1 then begin
          to_sel = cellIndexList[index]
          for j=0,n_elements(sel)-1 do begin
              for i=0,n_elements(index)-1 do begin
                if to_sel[i] eq sel[j] then begin
                  print,'MATCH'
                  duh = self.dataContainer->get(position=to_sel[i])
                  duh->setProperty,'volfrac',newVolFrac
                  widget_control,tovolfrac,set_value=newVolFrac
                endif;
              endfor;i
          endfor;j
        endif;index[0]
    endif;toCell
  
    if toResCell eq 1 then begin
print,'toResCell'    
          print,'newVolFrac=',newVolFrac
        tovolfrac = widget_info(self.IQTImportBase,find_by_uname='RESCELLVOLUMEFRACTION')
        index=widget_info(self.resBkgImportList,/list_select)
        if index[0] ne -1 then begin
          to_sel = resCellIndexList[index]
          for j=0,n_elements(sel)-1 do begin
              for i=0,n_elements(index)-1 do begin
                if to_sel[i] eq sel[j] then begin
                  print,'MATCH'
                  duh = self.dataContainer->get(position=to_sel[i])
                  duh->setProperty,'volfrac',newVolFrac
                  widget_control,tovolfrac,set_value=newVolFrac
                endif
              endfor;i
          endfor;j
        endif;index[0]

    endif;toResCell

  endif;update

end;ooDisplayEcho::calculateIQTDialog3_syncCellResCell


pro ooDisplayEcho::calculateIQTDialog3_handleImportList,event,sample=sample,cell=cell,$
                                                              resolution=resolution,resCell=resCell,$
                                                              setSample=setSample,$
                                                              setResolution=setResolution,$
                                                              setCell=setCell,$
                                                              setResCell=setResCell,$
                                                              _Extra=extra

catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::calculateIQTDialog3_handleImportList!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return
endif


print,'ooDisplayEcho::calculateIQTDialog3_handleImportList'
  if n_elements(sample) eq 0 then sample = 0
  if n_elements(cell) eq 0 then cell = 0
  if n_elements(resolution) eq 0 then resolution = 0
  if n_elements(resCell) eq 0 then resCell = 0

  if n_elements(setsample) eq 0 then setsample = 0
  if n_elements(setcell) eq 0 then setcell = 0
  if n_elements(setresolution) eq 0 then setresolution = 0
  if n_elements(setresCell) eq 0 then setresCell = 0

  if sample eq 0 and cell eq 0 and resolution eq 0 and resCell eq 0 then return
  if sample + cell + resolution + resCell gt 1 then return
  
;                            print,'DATIMPORTLIST'
                            ;return
                            widget_control,self.IQTImportBase,$
                                                get_uvalue=iqt
  if sample eq 1 then begin
        ;trans = widget_info(self.IQTImportBase,find_by_uname='SAMPLETRANSMISSION')
        volfrac = widget_info(self.IQTImportBase,find_by_uname='SAMPLEVOLUMEFRACTION')
        Index=widget_info(self.datImportList,$
                                    /list_select)


        IndexList = iqt.datList
;        applyall = widget_info(self.IQTImportBase,find_by_uname='DATAPPLYALL')
;        widget_control,applyall,get_value=applyallval
;print,'applyall=',applyallVal


  endif;sample
  if resolution eq 1 then begin
        ;trans = widget_info(self.IQTImportBase,find_by_uname='RESTRANSMISSION')
        ;widget_control,trans,get_value=Transmission
        volfrac = widget_info(self.IQTImportBase,find_by_uname='RESVOLUMEFRACTION')
        Index=widget_info(self.resImportList,$
                                    /list_select)

        IndexList = iqt.resList
;        applyall = widget_info(self.IQTImportBase,find_by_uname='RESAPPLYALL')
;        widget_control,applyall,get_value=applyallval
;        widget_control,datsumorseparate,get_value=datsumorseparateval
;        print,'datapplyallval,datsumorseparateval=',datapplyallval,datsumorseparateval
  endif;sample
  if cell eq 1  then begin
        ;trans = widget_info(self.IQTImportBase,find_by_uname='CELLTRANSMISSION')
        ;widget_control,trans,get_value=Transmission
        volfrac = 0L;
        volfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')
         Index=widget_info(self.bkgImportList,/list_select)

         IndexList = iqt.bkgList
;         applyall = widget_info(self.IQTImportBase,find_by_uname='BKGAPPLYALL')
;        widget_control, applyall,get_value= applyallval

        self->calculateIQTDialog3_syncCellResCell,/fromCell,/toResCell
        self->calculateIQTDialog3_updateTable

  endif;cell
  if rescell eq 1  then begin

        ;trans = widget_info(self.IQTImportBase,find_by_uname='RESCELLTRANSMISSION')
        ;widget_control,trans,get_value= Transmission
        volfrac = 0L;1.0
        volfrac = widget_info(self.IQTImportBase,find_by_uname='RESCELLVOLUMEFRACTION')
         Index=widget_info(self.resBkgImportList,/list_select)

         IndexList = iqt.resbkgList
;         applyall = widget_info(self.IQTImportBase,find_by_uname='RESBKGAPPLYALL')
;        datsumorseparate = widget_info(self.IQTImportBase,find_by_uname='RESCELLSUMORSEPARATE')
;        widget_control,applyall,get_value=applyallval
         self->calculateIQTDialog3_syncCellResCell,/fromResCell,/toCell
        self->calculateIQTDialog3_updateTable

  endif;resCell


if  Index[0] eq -1 then return

;
;if datapplyallval eq 1 then begin
;  ;set all volfrac and trans values to be the same for data sets
;   ;help,iqt.datList
;   widget_control,trans,get_value=datTransmission
;   widget_control,volfrac,get_value=datVolFrac
;   print,datTransmission,datVolFrac
;
;endif
;;return



  ndat= IndexList[ Index]
;print,'ndat=',ndat

  refo = (self.dataContainer->get(position=ndat[0]))
  
  
  
  for i=0,n_elements(ndat)-1 do begin

        ref = (self.dataContainer->get(position=ndat[i]))
;LRK 10/14/11 - REMOVE THE NEXT if STATEMENTS SINCE ALL TYPES CAN BE AFFECTED NOW

        ;if setResolution eq 1 or setSample eq 1 then begin 
;            widget_control,trans,get_value=sampletransmission
            widget_control,volfrac,get_value=samplevolumefraction
;            ref->setProperty,'transmission',sampletransmission
            ref->setProperty,'volfrac',samplevolumefraction
;            print,'sampletransmission,samplevolumefraction=',sampletransmission,samplevolumefraction
        ;endif

;THE NEXT BLOCK IS NOT USED BECAUSE THE TEANSMISSION WIDGETS WERE REMOVED.
;        if setCell eq 1 or setResCell eq 1 then begin 
;          widget_control,trans,get_value=sampletransmission
;          ref->setProperty,'transmission',sampletransmission
;;print,'sampletransmission=',sampletransmission
;        endif
  endfor;i
  sampletransmission = refo->getProperty(tag='transmission')
;LRK 10/14/11 REMOVE THE NEXT if STATEMENT BECAUSE ALL ELEMENTS SHOULD USE VOLFRAC NOW 
  ;if sample eq 1 or resolution eq 1 then $ 
      samplevolumefraction = refo->getProperty(tag='volfrac')

;  widget_control,trans,set_value=sampletransmission
;LRK 10/14/11 REMOVE THE NEXT if STATEMENT BECAUSE ALL ELEMENTS SHOULD USE VOLFRAC NOW 
;  if sample eq 1 or resolution eq 1 then $
      widget_control,volfrac,set_value=samplevolumefraction


end;ooDisplayEcho::calculateIQTDialog3_handleImportList





pro ooDisplayEcho::IQTDialogEvents3,event
;
;NAME:
;        IQTDialogEvents3
;
;PURPOSE:
;           Handle events for the CalculateIQT3 dialog.
;
;PARAMETERS:
;           event    The event to handle
;KEYWORDS:
;           none
;


catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::IQTDialogEvents3!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return
endif

    widget_control,event.id,get_uvalue=obj

;print,obj.id


    case obj.id of
        'SAMPLETRANSMISSION':begin
          self->calculateIQTDialog3_handleImportList,event,/sample,/setSample
          self->calculateIQTDialog3_updateTable
        end;'SAMPLETRANSMISSION'
        'SAMPLEVOLUMEFRACTION':begin
          print,'SAMPLEVOLUMEFRACTION'
          self->calculateIQTDialog3_handleImportList,event,/sample,/setSample
          self->calculateIQTDialog3_updateTable
        end;SAMPLEVOLUMEFRACTION
        'RESTRANSMISSION':begin
          self->calculateIQTDialog3_handleImportList,event,/resolution,/setResolution
          self->calculateIQTDialog3_updateTable
        end;'RESTRANSMISSION'
        'RESVOLUMEFRACTION':begin
          print,'RESVOLUMEFRACTION'
          self->calculateIQTDialog3_handleImportList,event,/resolution,/setResolution
          self->calculateIQTDialog3_updateTable
        end;RESVOLUMEFRACTION
        'CELLTRANSMISSION':begin
          self->calculateIQTDialog3_handleImportList,event,/cell,/setCell
          self->calculateIQTDialog3_updateTable
        end;'CELLTRANSMISSION'
        'CELLVOLUMEFRACTION':begin
          print,'CELLVOLUMEFRACTION'
          self->calculateIQTDialog3_handleImportList,event,/cell,/setCell
          self->calculateIQTDialog3_updateTable
        end;RESVOLUMEFRACTION
        'RESCELLTRANSMISSION':begin
          self->calculateIQTDialog3_handleImportList,event,/resCell,/setResCell
          self->calculateIQTDialog3_updateTable
        end;'RESCELLTRANSMISSION'
        'RESCELLVOLUMEFRACTION':begin
          print,'RESCELLVOLUMEFRACTION'
          self->calculateIQTDialog3_handleImportList,event,/resCell,/setResCell
          self->calculateIQTDialog3_updateTable
        end;RESVOLUMEFRACTION
        'IQTOUTPUTTABLE':begin
          ;print,'IQTOUTPUTTABLE'
          widget_control,event.id,get_value=tableval
          nsel = n_elements(tableval)
          types = ['Untyped','Resolution','Sample','Cell']

          ;FIRST UPDATE COMMON ELEMENTS IN TABLE (E.G. cell FILE USED AS BOTH A cell AND A resCell)
help,event,/struct  

          if nsel gt 0 then begin
              newTransmission = tableval[event.y].transmission
              newvolfrac = tableval[event.y].volume_fraction
              for i=0,nsel-1 do begin
                if tableval[i].position eq tableval[event.y].position then begin
                  tableval[i].transmission = newTransmission
                  tableval[i].volume_fraction = newvolfrac
                endif
              endfor;i
              for i=0,nsel-1 do begin
                 refi = self.datacontainer->get(position=tableval[i].position)
    ;            help,thisval[i],/struct
                print,tableval[i].name,tableval[i].position
                tableval[i].name = file_basename(refi->getProperty(tag='filename'))
                tableval[i].type = types[refi->getProperty(tag='type')]            
                tableval[i].comment = refi->getProperty(tag='comment')
                refi->setProperty,'transmission',tableval[i].transmission
                tableval[i].transmission = refi->getProperty(tag='transmission')
                
                ;ORIGINALLY DID NOT NOT MAKE VOLFRAC EDITABLE HERE
                refi->setProperty,'volfrac',tableval[i].volume_fraction
                tableval[i].volume_fraction = refi->getProperty(tag='volfrac')
                ;listElement = {name:'',type:'',transmission:0.0,volume_fraction:0.0,comment:'',position:0,included:''}
                
                ;UPDATE THE TABLE GLOBALLY
                widget_control,event.id,set_value=tableval
    
                self->calculateIQTDialog3_updateImportLists,tableval[i].position,tableval[i].volume_fraction
                
              endfor;i
          endif;nsel
        end;'IQTOUTPUTTABLE'
        'IQTCANCELBUTTON':begin
                        print,'IQTCANCELBUTTON'
                        widget_control,self.IQTImportBase,/destroy
                    end
        'IQTIMPORTLIST':begin
                        ;THIS METHOD SHOULD BE UNNECESSARY
                        widget_control,event.id,get_value=list
                        print,'IQTIMPORTLIST'
                        help,list
                        return
                        end
        'DATIMPORTLIST':begin
          self->calculateIQTDialog3_HandleImportList,event,/sample;,/setSample
          self->calculateIQTDialog3_updateTable
          
                        end
        'RESIMPORTLIST':begin
          self->calculateIQTDialog3_HandleImportList,event,/resolution;,/setResolution
          self->calculateIQTDialog3_updateTable
                        end
        'BKGIMPORTLIST':begin
          self->calculateIQTDialog3_HandleImportList,event,/cell;,/setCell
          self->calculateIQTDialog3_updateTable
                        end
        'RESBKGIMPORTLIST':begin
          self->calculateIQTDialog3_HandleImportList,event,/ResCell;,/setResCell
          self->calculateIQTDialog3_updateTable

                        end

        'IQTARCSFIELD':begin
                            widget_control,self.IQTImportBase,$
                                                get_uvalue=iqt
                                                  

                            arcsf = widget_info(self.IQTImportBase,find_by_uname='IQTARCSFIELD')
                            widget_control,arcsf,get_value=narcs
                            if narcs lt 1 then narcs = 1
                            if narcs gt 16 then narcs = 16
                            widget_control,arcsf,set_value=narcs

;                            print,'IQTARCSFIELD'
;                            help,iqt
                            return

                        end
        'ECHOAVERAGENORMALIZATION':begin
              print,'ECHOAVERAGENORMALIZATION'
              return
        end;ECHOAVERAGENORMALIZATION
        'IQTOKBUTTON':begin

                        ;GET OBJECTS FROM WIDGET SELECTIONS AND
                        ;CALCULATE I(Q,t)
                        widget_control,self.IQTImportBase,$
                                            get_uvalue=iqt

                        bkgIndexList = iqt.bkgList
                        datIndexList = iqt.datList
                        resIndexList = iqt.resList
                        resbkgIndexList = iqt.resbkgList

                        bkgIndex=widget_info(self.bkgImportList,$
                                            /list_select)
                        datIndex=widget_info(self.datImportList,$
                                            /list_select)

                        resIndex=widget_info(self.resImportList,$
                                            /list_select)
                        resbkgIndex=widget_info(self.resbkgImportList,$
                                            /list_select)



                        ;GET NUMERICAL VALUES FROM FIELDS
                        arcsf = widget_info(self.IQTImportBase,find_by_uname='IQTARCSFIELD')
                        samtrans = widget_info(self.IQTImportBase,find_by_uname='SAMPLETRANSMISSION')
                        samvolfrac = widget_info(self.IQTImportBase,find_by_uname='SAMPLEVOLUMEFRACTION')
                        celtrans = widget_info(self.IQTImportBase,find_by_uname='CELLTRANSMISSION')
                        cellvolfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')
                        samvolfrac = widget_info(self.IQTImportBase,find_by_uname='CELLVOLUMEFRACTION')

                        restrans = widget_info(self.IQTImportBase,find_by_uname='RESTRANSMISSION')
                        resvolfrac = widget_info(self.IQTImportBase,find_by_uname='RESVOLUMEFRACTION')
                        rescellvolfrac = widget_info(self.IQTImportBase,find_by_uname='RESCELLVOLUMEFRACTION')
                        resbkgtrans = widget_info(self.IQTImportBase,find_by_uname='RESCELLTRANSMISSION')
                        echoAverageOption = widget_info(self.IQTImportBase,find_by_uname='ECHOAVERAGENORMALIZATION')
                        echoTestOutputFileOption = widget_info(self.IQTImportBase,find_by_uname='ECHOWRITETESTOUTPUTFILE')

;datapplyall = widget_info(self.IQTImportBase,find_by_uname='DATAPPLYALL')
;datsumorseparate = widget_info(self.IQTImportBase,find_by_uname='DATSUMORSEPARATE')
;widget_control,datapplyall,get_value=datapplyallval
;widget_control,datsumorseparate,get_value=datsumorseparateval

datapplyallval = 0
datsumorseparateval = 1

                        widget_control,arcsf,get_value=narcs
                        ;widget_control,samtrans,get_value=sampletrans
                        widget_control,samvolfrac,get_value=samplevolfrac
                        widget_control,cellvolfrac,get_value=cellvolfrac
                        ;widget_control,celtrans,get_value=celltrans
                        ;widget_control,restrans,get_value=restrans
                        widget_control,resvolfrac,get_value=resvolfrac
                        widget_control,rescellvolfrac,get_value=rescellvolfrac
                        ;widget_control,resbkgtrans,get_value=resbkgtrans
                        if echoAverageOption ne 0L then begin
                            widget_control,echoAverageOption,get_value=echoAverageOpt
                        endif else begin
                            echoAverageOpt = 0
                        endelse
                        if echoTestOutputFileOption ne 0L then begin
                            widget_control,echoTestOutputFileOption,get_value=echoTestOutputFileOpt
                        endif else begin
                            echoTestOutputFileOpt = 0
                        endelse


                        if narcs lt 1 then begin
                            void = dialog_message('narcs too small, setting to 1.')
                            narcs = 1
                        endif
                        if narcs gt 16 then begin
                            void = dialog_message('narcs too big, setting to 16.')
                            narcs = 16
                        endif



                        ;GET OBJECTS AND APPLY THE TRANSMISSION AND VOLFRAC VALUES
                        if datIndex[0] eq -1 then begin 
                          void = dialog_message('No data files selected.',dialog_parent=self.IQTImportBase,title='I(Q,t) Dialog:')
                          return
                        endif
                        ndat=datIndexList[datIndex]


                        if bkgindex[0] eq -1 then nbkg = 9999 else nbkg=bkgIndexList[bkgIndex]                        
                        if resIndex[0] eq -1 then nres = 9999 else nres=resIndexList[resIndex]
                        if resbkgIndex[0] eq -1 then nresbkg=9999  else nresBkg=resbkgIndexList[resbkgIndex]


                        self.QChoiceIndex = ndat[0];ndat
                        m=self.QChoiceIndex


       print,'THIS IS THE NEW ALL-PURPOSE SINGLE/MULTI-FILE OPTION'

                        widget_control,self.IQTImportBase,/destroy
                        objDat = self.dataContainer->get(position=ndat[0])
                        datObj = obj_new('idl_container')
                        for j=0,n_elements(ndat)-1 do begin
                          datobj->add,self.dataContainer->get(position=ndat[j])
                        endfor;j
                        bkgObj = obj_new('idl_container')
                        if nbkg[0] ne 9999 then begin
                          for j=0,n_elements(nbkg)-1 do begin
                            bkgobj->add,self.dataContainer->get(position=nbkg[j])
                          endfor;j
                        endif
                        resObj = obj_new('idl_container')
                        if nres[0] ne 9999 then begin
                          for j=0,n_elements(nres)-1 do begin
                            resobj->add,self.dataContainer->get(position=nres[j])
                          endfor;j
                        endif
                        resbkgObj = obj_new('idl_container')
                        if nresbkg[0] ne 9999 then begin
                          for j=0,n_elements(nresbkg)-1 do begin
                            resBkgobj->add,self.dataContainer->get(position=nresbkg[j])
                          endfor;j
                        endif
                        self->CalculateIQT3,datObj=datObj,$
                                            bkgObj = bkgObj,$
                                            resObj = resObj,$
                                            resbkgobj=resbkgObj,$
                                            datIndex = ndat[0],$
                                            echoAverageOpt = echoAverageOpt,$
                                            narcs=narcs
;print,'THE NEXT STEP REMOVES THE OBJECTS FROM THE CONTAINER datObj'

                        datObj->remove,/all
                        resObj->remove,/all
                        bkgObj->remove,/all
                        resBkgObj->remove,/all
                        obj_destroy,datobj
                        obj_destroy,resobj
                        obj_destroy,bkgobj
                        obj_destroy,resbkgobj

        end;IQTOKBUTTON
        else:begin
                print,'ooDisplayEcho::IQTDialogEvents3'
        endelse
    endcase
end;ooDisplayEcho::IQTDialogEvents3

function ooDisplayEcho::CalculateIQTDialog3_setUpTable,$
                                  theDatList,theResList,theBkgList,theResBkgList,$
                                  datIndexList,resIndexList,bkgIndexList,resBkgIndexList,$
                                  _Extra=extra

        ;SET UP INFORMATION FOR TABLE
        ;CREATE STRUCTURES FOR THE DATA TABLE
        listElement = {name:'',type:'',transmission:0.0,volume_fraction:0.0,comment:'',position:0,included:''}
        whDat = where(DatIndexList eq 9999, noDatCount)
        whRes = where(ResIndexList eq 9999, noResCount)
        whBkg = where(BkgIndexList eq 9999, noBkgCount)
        whResBkg = where(ResBkgIndexList eq 9999, noResBkgCount)
print,-noDatCount - noResCount - noBkgCount - noResBkgCount
        
        elements = replicate(listElement,n_elements(theDatList) + $
                                         n_elements(theResList) + $
                                         n_elements(theBkgList) + $
                                         n_elements(theResBkgList) - $
                                         noDatCount - $
                                         noResCount - $
                                         noBkgCount - $
                                         noResBkgCount)

        dataTypes = ['Sample','Resolution','Cell','ResCell']
        typeStarts = [0,$
                      n_elements(theDatList),$
                      n_elements(theDatList)+n_elements(theResList),$
                      n_elements(theDatList)+n_elements(theResList)+n_elements(theBkgList)]
        
        thisNameList = ptrarr(4)
        thisNameList[0] = ptr_new(thedatList)
        thisNameList[1] = ptr_new(theresList)
        thisNameList[2] = ptr_new(thebkgList)
        thisNameList[3] = ptr_new(theresBkgList)
        
        thisIndexList = ptrarr(4)
        thisIndexList[0] = ptr_new(datIndexList)
        thisIndexList[1] = ptr_new(resIndexList)
        thisIndexList[2] = ptr_new(bkgIndexList)
        thisIndexList[3] = ptr_new(resBkgIndexList)

;IDENTIFY THE SELECTED ITEMS
selected = intarr(n_elements(elements));[-1]
datIndex=widget_info(self.datImportList,/list_select)
;print,'datIndex=',datIndex
if datindex[0] ne -1 then begin 
  selected[datindex] = 1
;  ndat=datIndexList[datIndex]
;  selected = [selected,ndat]
endif
resIndex=widget_info(self.resImportList,/list_select)
;print,'resindex=',resindex
if resindex[0] ne -1 then begin 
  selected[resindex+n_elements(datIndexList)] = 1
;  nres=resIndexList[resIndex]
;  selected = [selected,nres]
endif

bkgIndex=widget_info(self.bkgImportList,/list_select)
;print,'bkgindex=',bkgindex
if bkgindex[0] ne -1 then begin
  selected[bkgindex+n_elements(datIndexList)+n_elements(resindexlist)] = 1
;  nbkg=bkgIndexList[bkgIndex]
;  selected = [selected,nbkg]
endif
resbkgIndex=widget_info(self.resbkgImportList,/list_select)
;print,'resbkgindex=',resbkgindex
if resbkgindex[0] ne -1 then begin 
  selected[resbkgindex+n_elements(datIndexList)+n_elements(resindexList)+n_elements(bkgindexList)] = 1
;  nresbkg=resbkgIndexList[resbkgIndex]
;  selected = [selected,nresbkg]
endif
;if n_elements(selected) gt 1 then selected = selected[1:*]


        
        for k=0,n_elements(dataTypes)-1 do begin
          ;print,'(*(thisIndexList[k]))=',(*(thisIndexList[k]))
          for j = 0,n_elements(*(thisIndexList[k]))-1 do begin
            i = j+typeStarts[k]
            if (*(thisIndexList[k]))[j] ne 9999 then begin
              ;wh = where((*(thisIndexList[k]))[j] eq selected,count)
;print,'(*(thisIndexList[k]))[j],selected=',(*(thisIndexList[k]))[j],selected              
              elements[i].type = dataTypes[k];'Sample'
              elements[i].name = (*(thisNameList[k]))[j];theDatList[i]
              elements[i].included = 'No'
              elements[i].position = (*(thisIndexList[k]))[j] ;DATA CONTAINER POSITION
        
              thisRef = self.dataContainer->get(position=(*(thisIndexList[k]))[j])
              elements[i].transmission = thisRef->getProperty(tag='transmission')
              elements[i].volume_fraction = thisRef->getProperty(tag='volfrac')
              elements[i].comment = thisRef->getProperty(tag='comment')
              ;if j eq 0 then elements[i].included = 'Yes' 
              ;if count eq 1 then elements[i].included = 'Yes'
              if selected[i] eq 1 then elements[i].included = 'Yes'
              ;print,elements[i]
            endif
            
          endfor;j
        endfor;k
        
        for i = 0,n_elements(thisIndexList)-1 do begin
          if ptr_valid(thisIndexList[i]) then ptr_free,thisIndexList[i]
        endfor;i
        for i = 0,n_elements(thisNameList)-1 do begin
          if ptr_valid(thisNameList[i]) then ptr_free,thisNameList[i]
        endfor;i


  tempelements = elements
  ;NOW JUST GET THE SELECTED ELEMENTS IF THERE ARE SELECTIONS
  selections = elements[*].included
  
  whselected = where(strupcase(selections) eq 'YES',whcount)
  if whcount gt 0 then begin
    tempelements = replicate(listElement,whCount)
    
    for i=0,whcount-1 do begin
      tempelements[i] = elements[whSelected[i]] 
    endfor;i
  endif

  
  ;return,elements
  return,tempElements
  
end;ooDisplayEcho::CalculateIQTDialog3_setUpTable




pro ooDisplayEcho::calculateIQTDialog3_getFileLists,theDatList,datIndexList,$
                                                    theResList,resIndexList,$
                                                    theBkgList,bkgIndexList,$
                                                    theResBkgList,resBkgIndexList,$
                                                    startup=startup,$
                                                    _Extra=extra

    if n_elements(startup) eq 0 then startup = 0

    theBkgList = ['']
    theDatList = ['']
    theResList = ['']
    theResBkgList = ['']
    bkgIndexList = [9999]
    datIndexList = [9999]
    resIndexList = [9999]
    resbkgIndexList = [9999]
;    bkgIndexList = [0]
;    datIndexList = [0]
;    resIndexList = [0]
;    resbkgIndexList = [0]
    refo = (self.dataContainer->get(position=self.QChoiceIndex))
    for i = 0,self.dataContainer->count()-1 do begin
        ;GET LIST OF DATA FILES WITH THE CORRECT SIZE
;print,i
        refi = self.dataContainer->get(position=i)
        if (refo->matches(refi) $
                    ) $;and (i ne self.QChoiceIndex))$
                        then begin
                            type = refi->getProperty(tag='type')
                                    ;self.QChoiceIndex))->getProperty(tag='type')

                            ;print,type
                            case type of
                            0:begin;untyped
                                if (i eq self.QChoiceIndex) then begin
;                                    theBkgList[0] = file_basename(refi->getProperty(tag='filename'))
;                                    bkgIndexList[0] = i
;                                    theBkgList = ['',theBkgList]
;                                    bkgIndexList = [0,bkgIndexList]
                                    theDatList[0] = file_basename(refi->getProperty(tag='filename'))
                                    datIndexList[0] = i
                                    theDatList = ['',theDatList]
                                    datIndexList = [0,datIndexList]
 ;                                   theResList[0] = file_basename(refi->getProperty(tag='filename'))
 ;                                   resIndexList[0] = i
 ;                                   theResList = ['',theResList]
 ;                                   resIndexList = [0,resIndexList]

 ;                                   theResbkgList[0] = file_basename(refi->getProperty(tag='filename'))
 ;                                   resbkgIndexList[0] = i
 ;                                   theResbkgList = ['',theResbkgList]
 ;                                   resbkgIndexList = [0,resbkgIndexList]
                                endif else begin
  ;                                  theBkgList = $
  ;                                      [theBkgList,file_basename(refi->getProperty(tag='filename'))]
  ;                                  bkgIndexList = [bkgIndexList,i]
                                    theDatList = $
                                        [theDatList,file_basename(refi->getProperty(tag='filename'))]
                                    datIndexList = [datIndexList,i]
  ;                                  theResList = $
  ;                                      [theResList,file_basename(refi->getProperty(tag='filename'))]
  ;                                  resIndexList = [resIndexList,i]

;                                    theResBkgList = $
;                                        [theResBkgList,file_basename(refi->getProperty(tag='filename'))]
 ;                                   resBkgIndexList = [resBkgIndexList,i]
                                endelse
                            end;0
                            1:begin;resolution
                                if i eq self.QChoiceIndex then begin
                                    theResList[0] = file_basename(refi->getProperty(tag='filename'))
                                    resIndexList[0] = i
                                    theResList = ['',theResList]
                                    resIndexList = [0,resIndexList]
                                endif else begin
                                    theResList = $
                                        [theResList,file_basename(refi->getProperty(tag='filename'))]
                                    resIndexList = [resIndexList,i]
                                endelse
                            end;1
                            2:begin;data
                                if i eq self.QChoiceIndex then begin
                                    theDatList[0] = file_basename(refi->getProperty(tag='filename'))
                                    datIndexList[0] = i
                                    theDatList = ['',theDatList]
                                    datIndexList = [0,datIndexList]
                                endif else begin
                                    theDatList = $
                                        [theDatList,file_basename(refi->getProperty(tag='filename'))]
                                    datIndexList = [datIndexList,i]
                                endelse
                            end;2
                            3:begin;background
                                if i eq self.QChoiceIndex then begin
                                    theBkgList[0] = file_basename(refi->getProperty(tag='filename'))
                                    bkgIndexList[0] = i
                                    theBkgList = ['',theBkgList]
                                    bkgIndexList = [0,bkgIndexList]

                                    theResBkgList[0] = file_basename(refi->getProperty(tag='filename'))
                                    resbkgIndexList[0] = i
                                    theResBkgList = ['',theResBkgList]
                                    resbkgIndexList = [0,resbkgIndexList]

                                endif else begin
                                    theBkgList = $
                                        [theBkgList,file_basename(refi->getProperty(tag='filename'))]
                                    bkgIndexList = [bkgIndexList,i]
                                    theResBkgList = $
                                        [theResBkgList,file_basename(refi->getProperty(tag='filename'))]
                                    resbkgIndexList = [resbkgIndexList,i]
                                endelse
                            end;3
                            endcase;type
        endif;match
    endfor;i

    ;03/04/11
    ;THERE IS NO NEED FOR THE 'None' OPTION IN THIS DIALOG SINCE
    ;I AM CHECKING TO SEE WHAT ITEMS ARE SELECTED IN THE DIALOG
    theResList = [theResList];,'None']
    resIndexList = [resIndexList];,9999]
    theBkgList = [theBkgList];,'None']
    bkgIndexList = [bkgIndexList];,9999]
    theResBkgList = [theResBkgList];,'None']
    resbkgIndexList = [resbkgIndexList];,9999]
    ;theDatList = [theDatList,'None']

    if startup ne 1 then begin
      if n_elements(theDatList) gt 1 then begin
          theDatList = theDatList[1:*]
          datIndexList = datIndexList[1:*]
      endif
  
      if n_elements(theResList) gt 1 then begin
          theResList = theResList[1:*]
          resIndexList = resIndexList[1:*]
      endif
  
      if n_elements(theBkgList) gt 1 then begin
          theBkgList = theBkgList[1:*]
          bkgIndexList = bkgIndexList[1:*]
      endif
  
      if n_elements(theresBkgList) gt 1 then begin
          theresBkgList = theresBkgList[1:*]
          resbkgIndexList = resbkgIndexList[1:*]
      endif
    endif;not startup


end;ooDisplayEcho::calculateIQTDialog3_getFileLists



pro ooDisplayEcho::CalculateIQTDialog3
;
;NAME:
;        ooDisplayEcho::CalculateIQTDialog3
;
;PURPOSE:
;           Provide a dialog for beginning the calculation of I(Q,t).
;           This allows the user to select the sample, cell and resolution data
;           objects to use in the calculation.
;PARAMETERS:
;           none
;KEYWORDS:
;           none


    ;;
    ;THIS DIALOG WILL BE USED TO SELECT THE DATA
    ;OBJECTS USED TO CALCULATE I(Q,t) FOR THE
    ;SELECTED SET OF OBJECTS.
    ;
    ;THIS DIALOG IS CALLED BY THE menuEvents METHOD
    ;
    ;THE RESULTING DATA WILL BE STORED IN THE
    ;S VARIABLE IN THE 'data' TYPE OBJECT
    ;;;

    ;;
    ;
    ;NEED AN EVENT HANDLER TO SET THE SELECTED PHASES
    ;
    ;;;

catch, catchError
if (catchError ne 0) then begin
    ;;print, 'Error handled!'
    eTitle = 'NSE Reduction: Error encountered'
    eMsg = 'An error or unusual condition was encountered at ooDisplayEcho::CalcIQTDialog3!'
    eMsg = [eMsg,'Please, report the following to the DAVE team:']
    eMsg = [eMsg,!error_state.msg]
    void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=self.atlb)
    catch, /cancel
    return
endif


    self->calculateIQTDialog3_getFileLists,theDatList,datIndexList,$
                                           theResList,resIndexList,$
                                           theBkgList,bkgIndexList,$
                                           theResBkgList,resBkgIndexList,$
                                           /startup,$
                                           _Extra=extra


    ;CREATE DIALOG
    if n_elements(theDatList) gt 1 then begin
        theDatList = theDatList[1:*]
        datIndexList = datIndexList[1:*]

;        if !version.os eq 'Win32' then begin
;            basexsize = 230
;            baseysize = 320
;        endif else begin
;            basexsize=330
;            baseysize=400
;        endelse

        ;021406
        ;ELIMINATE THE SIZE RESTRICTION HERE.
        self.IQTImportBase = widget_base(group_leader = self.atlb,/row,$
                                            $;xsize=basexsize,ysize=baseysize,$
                                            /modal,$;/grid_layout,$
                                            title='SELECT DATA FOR I(Q,t) Calculation',$
                                            /base_align_right,$
                                            yoffset=0)
                                              
        IQT3TLB = self.IQTImportBase

        dummybase = widget_base(group_leader = IQT3TLB)
        subBase = widget_base(self.IQTImportBase,/column)

        datsubbase = widget_base(subbase,/row,frame=1)
        lab = widget_label(datsubbase,value='Sample Choices')
        self.datImportList = widget_list(datsubBase,$
                                            value=theDatList,$
                                            ysize=3,xsize = 40,$
                                            /multiple,$
                                            ;title = 'Sample Choices',$;'Data Set Choices',$
                                            uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       $;method:'listEvents',$
                                                      id:'DATIMPORTLIST',$
                                                      list:datIndexList})
        Widget_control,self.datImportList,set_list_select=0
        datsubbase1 = widget_base(datsubbase,/col)
        sampletransmission = (self.dataContainer->get(position=datIndexList[0]))->getProperty(tag='transmission')
        samplevolumefraction = (self.dataContainer->get(position=datIndexList[0]))->getProperty(tag='volfrac')
        ;samtrans = cw_field(datsubbase1,value=sampletransmission,xsize=8,$
        samtrans = cw_field(dummybase,value=sampletransmission,xsize=8,$
                                            /return_events,$
                                            /floating,title='Sample Trans',/row,$
                                             uname='SAMPLETRANSMISSION',$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'SAMPLETRANSMISSION',$
                                                       list:datIndexList})

        ;DATAPPLYALL = cw_bgroup(datsubbase1,$
        DATAPPLYALL = cw_bgroup(dummybase,$
                                        'Apply to all selected (transmission & volfrac)',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='DATAPPLYALL',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'DATAPPLYALL'})


        ;DATSUMORSEPARATE = cw_bgroup(datsubbase1,$
        DATSUMORSEPARATE = cw_bgroup(dummybase,$
                                        ['Treat Samples Separately','Sum Sample Files'],$
                                        /row, /exclusive,$
                                        set_value=0,$
                                        frame=1,$
                                        uname='DATSUMORSEPARATE',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'DATSUMORSEPARATE'})




        samvolfrac = cw_field(datsubbase,value=samplevolumefraction,xsize=8,$
                                            /floating,title='Sample Volfrac',/row,$
                                            /return_events,$
                                             uname='SAMPLEVOLUMEFRACTION',$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'SAMPLEVOLUMEFRACTION',$
                                                       list:datIndexList})


;-----------------
;RES
;-----------------
        ;IF THESE HAVE ZERO ELEMENTS THEN
        ;self.resImportList WILL BE A MESSAGE, NOT A LIST
        ressubbase = widget_base(subbase,/row,frame=1)
        lab = widget_label(ressubbase,value='Resolution Choices')
        self.resImportList = widget_list(ressubBase,$
                                            value=theResList,$
                                            ysize=3,xsize = 40,$
                                            /multiple)

        if n_elements(theResList) gt 1 then begin
            theResList = theResList[1:*]
            ResIndexList = resIndexList[1:*]

            widget_control,self.resImportList,set_value=theResList,set_uvalue={object:self,$
                                                            method:'IQTDialogEvents3',$
                                                            id:'RESIMPORTLIST',$
                                                            list:resIndexList}

            Widget_control,self.resImportList,set_list_select=0                                                        

            restransmission = (self.dataContainer->get(position=resIndexList[0]))->getProperty(tag='transmission')
    
            resvolumefraction = (self.dataContainer->get(position=resIndexList[0]))->getProperty(tag='volfrac')

        endif else begin
;            self.resImportList = widget_label(subBase,$
;                                value='No Resolution Set Available!')

            widget_control,set_value=theResList,set_uvalue={object:self,$
                                                            method:'IQTDialogEvents3',$
                                                            id:'RESIMPORTLIST',$
                                                            list:resIndexList}
            restransmission = 1.0;(self.dataContainer->get(position=resIndexList[0]))->getProperty(tag='transmission')
    
            resvolumefraction = 1.0;(self.dataContainer->get(position=resIndexList[0]))->getProperty(tag='volfrac')

        endelse

        ressubbase1 = widget_base(ressubbase,/col)
        ;restrans = cw_field(ressubbase1,value=sampletransmission,xsize=8,$
        restrans = cw_field(dummybase,value=sampletransmission,xsize=8,$
                                            /floating,title='Res Trans',/row,$
                                            /return_events,$
                                             uname='RESTRANSMISSION',$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'RESTRANSMISSION',$
                                                       list:datIndexList})
        ;RESAPPLYALL = cw_bgroup(ressubbase1,$
        RESAPPLYALL = cw_bgroup(dummybase,$
                                        'Apply to all selected (transmission & volfrac)',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='RESAPPLYALL',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'RESAPPLYALL'})



        resvolfrac = cw_field(ressubbase,value=resvolumefraction,xsize=8,$
                                            /floating,title='Res Volfrac',/row,$
                                            /return_events,$
                                            uname='RESVOLUMEFRACTION',$
                                            uvalue = {object:self,$
                                                      method:'IQTDialogEvents3',$
                                                      id:'RESVOLUMEFRACTION',$
                                                      list:resIndexList})







;------------------
;Cell/Background
;------------------
        ;
        ;
        ;
        ;IF THESE HAVE ZERO ELEMENTS THEN
        ;self.bkgImportList WILL BE A MESSAGE, NOT A LIST
        bkgsubbase = widget_base(subbase,/row,frame=1)
        lab = widget_label(bkgsubbase,value='Cell Choices')
        self.bkgImportList = widget_list(bkgsubBase,$
                                            value=theBkgList,$
                                            ysize=3,xsize = 40,$
                                            /multiple)

        if n_elements(theBkgList) gt 1 then begin
            theBkgList = theBkgList[1:*]
            bkgIndexList = bkgIndexList[1:*]


;            self.bkgImportList = widget_droplist(subBase,$
;                                                value=theBkgList,$
;                                                ysize=25,xsize = 220,$
;                                                title = 'Cell Choices',$;'Background Choices',$
;                                                uvalue = {object:self,$
;                                                           method:'IQTDialogEvents3',$
;                                                           $;method:'listEvents',$
;                                                          id:'BKGIMPORTLIST',$
;                                                          list:bkgIndexList})




            widget_control,self.bkgImportList,set_value=theBkgList,set_uvalue={object:self,$
                                                            method:'IQTDialogEvents3',$
                                                            id:'BKGIMPORTLIST',$
                                                            list:bkgIndexList}

            Widget_control,self.bkgImportList,set_list_select=0                                                        

            celltransmission = (self.dataContainer->get(position=bkgIndexList[0]))->getProperty(tag='transmission')

            cellvolumefraction = (self.dataContainer->get(position=bkgIndexList[0]))->getProperty(tag='volfrac')



        endif else begin
;            self.bkgImportList = widget_label(subBase,$
;                                value='No Background Set Available!')

            widget_control,self.bkgImportList,set_value=theBkgList,set_uvalue={object:self,$
                                                            method:'IQTDialogEvents3',$
                                                            id:'BKGIMPORTLIST',$
                                                            list:bkgIndexList}
            celltransmission = 1.0;(self.dataContainer->get(position=bkgIndexList[0]))->getProperty(tag='transmission')
    
            cellvolumefraction = 1.0;(self.dataContainer->get(position=bkgIndexList[0]))->getProperty(tag='volfrac')


        endelse
        bkgsubbase1 = widget_base(bkgsubbase,/col)

        ;celltrans = cw_field(bkgsubbase1,value=celltransmission,xsize=8,$
        celltrans = cw_field(dummybase,value=celltransmission,xsize=8,$
                                            /floating,title='Cell Trans',/row,$
                                             uname='CELLTRANSMISSION',$
                                            /return_events,$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'CELLTRANSMISSION',$
                                                       list:bkgIndexList})
        ;BKGAPPLYALL = cw_bgroup(BKGsubbase1,$
        BKGAPPLYALL = cw_bgroup(dummybase,$
                                        'Apply to all selected (transmission)',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='BKGAPPLYALL',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'BKGAPPLYALL'})

        ;cellvolumefraction = 1.0
        bkgvolfrac = cw_field(bkgsubbase,value=cellvolumefraction,xsize=8,$
                                            /floating,title='Cell Volfrac',/row,$
                                            /return_events,$
                                            uname='CELLVOLUMEFRACTION',$
                                            uvalue = {object:self,$
                                                      method:'IQTDialogEvents3',$
                                                      id:'CELLVOLUMEFRACTION',$
                                                      list:bkgIndexList})


;--------------
;ResBkg
;--------------




        resbkgsubbase = widget_base(subbase,/row,frame=1)
        lab = widget_label(resbkgsubbase,value='Res Cell Choices')
        self.resbkgImportList = widget_list(resbkgsubBase,$
                                            value=theresBkgList,$
                                            ysize=3,xsize = 40,$
                                            /multiple)
        if n_elements(theresBkgList) gt 1 then begin
            theresBkgList = theresBkgList[1:*]
            resbkgIndexList = resbkgIndexList[1:*]

            widget_control,self.resbkgImportList,set_value=theresBkgList,set_uvalue={object:self,$
                                                            method:'IQTDialogEvents3',$
                                                            id:'RESBKGIMPORTLIST',$
                                                            list:resbkgIndexList}

            ;Widget_control,self.resbkgImportList,set_list_select=0                                                        

            resbkgtransmission = (self.dataContainer->get(position=resbkgIndexList[0]))->getProperty(tag='transmission')
            resbkgvolumefraction = (self.dataContainer->get(position=resbkgIndexList[0]))->getProperty(tag='volfrac')


           ;Widget_control,self.resbkgImportList,set_list_select=n_elements(theresBkglist)-1

                                                                     
        endif else begin
            self.resbkgImportList = widget_label(subBase,$
                                value='No Res Background Set Available!')
            resbkgtransmission = 1.0
            resbkgvolumefraction = 1.0;(self.dataContainer->get(position=resbkgIndexList[0]))->getProperty(tag='volfrac')
        endelse
        resbkgsubbase1 = widget_base(resbkgsubbase,/col)
        ;resbkgtrans = cw_field(resbkgsubbase1,value=resbkgtransmission,xsize=8,$
        resbkgtrans = cw_field(dummybase,value=resbkgtransmission,xsize=8,$
                                            /floating,title='Res Bkg Trans',/row,$
                                            /return_events,$
                                             uname='RESCELLTRANSMISSION',$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'RESCELLTRANSMISSION',$
                                                       list:resbkgIndexList})

        ;RESBKGAPPLYALL = cw_bgroup(resbkgsubbase1,$
        RESBKGAPPLYALL = cw_bgroup(dummybase,$
                                        'Apply to all selected (transmission)',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='RESBKGAPPLYALL',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'RESBKGAPPLYALL'})

        ;rescellvolumefraction = 1.0
        resbkgvolfrac = cw_field(resbkgsubbase,value=resbkgvolumefraction,xsize=8,$
                                            /floating,title='Res Cell Volfrac',/row,$
                                            /return_events,$
                                            uname='RESCELLVOLUMEFRACTION',$
                                            uvalue = {object:self,$
                                                      method:'IQTDialogEvents3',$
                                                      id:'RESCELLVOLUMEFRACTION',$
                                                      list:resBkgIndexList})



        narcs = (self.dataContainer->get(position=datIndexList[0]))->getProperty(tag='narcs')


        arcsfield = cw_field(subbase,value=narcs,xsize=8,/return_events,$
                                            /integer,title='Number of Q Arcs',/row,$
                                             uname='IQTARCSFIELD',$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       id:'IQTARCSFIELD',$
                                                       list:datIndexList})


        ECHOAVERAGENORMALIZATION = cw_bgroup(subbase,$
                                        'Use Echo Average for Normalization (NOTE: EB Calculated using usual normalization)',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='ECHOAVERAGENORMALIZATION',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'ECHOAVERAGENORMALIZATION'})
        ECHOWRITETESTOUTPUTFILE = cw_bgroup(subbase,$
                                        'WRITE TEST OUTPUT FILE',$
                                        /row, /nonexclusive,$
                                        set_value=0,$
                                        uname='ECHOWRITETESTOUTPUTFILE',$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'ECHOWRITETESTOUTPUTFILE'})





elements = self->calculateIQTDialog3_setUpTable(theDatList,theResList,theBkgList,theResBkgList,$
                                          datIndexList,resIndexList,bkgIndexList,resBkgIndexList,$
                                          _Extra=extra)


        IQTOUTPUTTABLE = Widget_table(subbase,$
                                        column_labels = ['File','Type','Transmission','Volume Fraction','Comment','Included','Position'],$
                                        column_widths = [100,100,100,100,100,500],$
                                        editable=1,$;0,$
                                        y_scroll_size=10,$
                                        ysize=15,$
                                        x_scroll_size=5,$
                                        /resizeable_columns,$                                        
                                        uname='IQTOUTPUTTABLE',$
                                        value=elements,$
                                        uvalue={object:self,$
                                                method:'IQTDialogEvents3',$
                                                id:'IQTOUTPUTTABLE'});ECHOWRITETESTOUTPUTFILE'})



        if (n_elements(theResList) gt 0) and $
           (n_elements(theBkgList) gt 0) then begin
            okButton = widget_button(subBase,value = 'OK',$
                                         xsize=230,ysize=30,$
                                         uvalue = {object:self,$
                                                   method:'IQTDialogEvents3',$
                                                   $;method:'listEvents',$
                                                   id:'IQTOKBUTTON',$
                                                   bkglist:bkgIndexList,$
                                                   datlist:datIndexList,$
                                                   reslist:resIndexList,$
                                                   resbkglist:resbkgIndexList})
        endif else begin
            okButton = widget_button(subBase,value = 'NOT OK',$
                                         xsize=230,ysize=30,$
                                         uvalue = {object:self,$
                                                   method:'IQTDialogEvents3',$
                                                   $;method:'listEvents',$
                                                   id:'IQTOKBUTTON',$
                                                   list:bkgIndexList})
        endelse

        cancelButton = widget_button(subBase,value = 'Cancel',$
                                             xsize=230,ysize=30,$
                                             uvalue = {object:self,$
                                                       method:'IQTDialogEvents3',$
                                                       $;method:'listEvents',$
                                                       id:'IQTCANCELBUTTON',$
                                                       list:bkgIndexList})

        widget_control,self.IQTImportBase,/realize

        ;CREATE DUMMY EVENT STRUCTURE FOR EVENT HANDLING
        dumEvent = { WIDGET_DROPLIST,$
                         ID:self.IQTImportBase,$
                         TOP:self.IQTImportBase,$
                         HANDLER:0L, INDEX:0L }

        ;STICK EVENT AND OTHER INFORMATION INTO BASE UVALUE
        widget_control,self.IQTImportBase,set_uvalue=$
                                            {object:self,$
                                             method:'IQTDialogEvents3',$;'listEvents',$
                                             id:'IQTIMPORTBASE',$;'IQTCANCELBUTTON',$
                                             bkglist:bkgIndexList,$
                                             datlist:datIndexList,$
                                             reslist:resIndexList,$
                                             resbkglist:resbkgIndexList,$
                                             event:dumEvent}
print,tag_names(widget_info(self.IQTImportBase,/geom))
print,widget_info(self.IQTImportBase,/geom)
help,widget_info(self.IQTImportBase,/geom),/struct
;        xmanager,"ooDisplayEcho",self.IQTImportBase,/no_block,$
;                    cleanup='CalculateIQTBaseCleanup'
        lk_xmanager,"ooDisplayEcho",self.IQTImportBase,/no_block,$
                    cleanup='CalculateIQTBaseCleanup';,event_handler=''

    endif else begin
        void = widget_message('No Suitable Data Objects.')
    endelse

    ;041504

end;CalculateIQTDialog3


