; $Id$
;###############################################################################
;
;NAME:
;        NSE_PS_Plotter
;
;PURPOSE:   PROVIDE A BASIC PRINT FUNCTION FOR THE NSE REDUCTION SOFTWARE.
;           THIS IS BORROWED FROM ROB'S ps_plotter WITH SMALL MODIFICATIONS TO
;           USE TRUE COLOR PRINTING AND ONLY ONE WINDOW.
;PARAMETERS:
;
;KEYWORDS:
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Apr 15 15:05:12 2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################
PRO NSE_PS_Plotter, image1, $
   European=european, $   ; Set this keyword if you want European measurements.
   Font=font, $           ; Set this keyword if you want font information.
   Object=object, $       ; Output variable to return FSC_PSConfig object.
   filename=filename, $
   directory=directory

   ; Get an image if one is not passed in.

IF N_Elements(image1) EQ 0 THEN BEGIN
    image1 = BytArr(360, 360,3)

ENDIF

   ; Create the PostScript configuration object.

if n_elements(filename) eq 0 then filename = 'nse_data.ps'
if n_elements(directory) eq 0 then directory = ''

;THIS GETS POSTSCRIPT CONFIGURATIONS
;object = Obj_New('FSC_PSConfig', European=Keyword_Set(european),$
;                        filename=filename,directory=directory)


fn = dialog_pickfile(file=filename,path=directory)

if fn ne '' then begin

    ;100705
    ;REPLACE THE OBJECT CREATION ABOVE WITH THE NEXT LINE.
    options = psconfig(fonttype=fonttype,filename=filename,directory=directory,cancel=cancelled)
       ; We want hardware fonts.

    if not cancelled then begin
        thisFontType = !P.Font
        !P.Font = 1

           ; Get user input to PostScript configuration.
        ;100705 COMMENT NEXT LINE
        ;IF Keyword_Set(font) THEN object->GUI, /Font ELSE object->GUI


        ;GET THE CURRENT DEVICE
        thisDevice = !D.Name

        ;SET THE DEVICE TO A PS FILE
        Set_Plot, 'PS'
        ;100705 COMMENT NEXT LINE
        ;keywords = object->GetKeywords(FontType=fonttype)
        Device, _Extra=options;keywords
        TVImage, image1, true=3

        ;CLOSE THE PS FILE
        Device, /Close_File

        ;RETURN TO THE ORIGINAL DEVICE
        Set_Plot, thisDevice
        !P.Font = thisfontType
    endif;filename ne ''

endif;not cancelled

END ;NSE_ps_plotter------------------------------------------------------------------







