; $Id$
;###############################################################################
;
;FILENAME:
;nse_normalizecoord.pro
;
;PURPOSE:
;           Create normalized coordinates given data coordinates.
;
;           Actually, in looking at it, this produces the "data"
;           coordinates, given then normalized coordinates!!!
;
;CATEGORY:
;           Data visualzation.
;
;METHODS IN FILE:
;
;    nse_normalizecoord
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Jan 24,2005
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
;
;TITLE      nse_normalizecoord.pro
;
;AUTHOR     Larry Kneller
;
;
;PURPOSE    THIS PROCEDURE GIVES THE NORMALIZED COORDINATE IN THE
;           CHOSEN WINDOW.
;


function nse_normalizecoord,x,y,xrange,yrange,xlog,ylog
;
;NAME:
;        nse_normalizecoord
;
;PURPOSE:
;           Create normalized coordinates given data coordinates.
;
;PARAMETERS:
;           x       The data value of the x coordinate.
;           y       The data value of the y coordinate.
;           xrange  The x range of the data.
;           yrange  The y range of the data.
;           xlog    x axis log (1) or lin (0).
;           ylog    y axis log (1) or lin (0).
;
;KEYWORDS:
;           none
;RETURN VALUE:
;           [xnorm,ynorm]   The 2d normalized coordinate.

    ;PRODUCE A NORMALIZED COORDINATE BASED ON THE x,y
    ;POSITIONS AND xrange,yrange.
    ;
    ;THE PURPOSE OF THIS IS TO GIVE THE COORDINATE OF THE
    ;NORMALIZED POSITINO ON THE PLOT.
    ;
    ;e.g. x = 0.5, y=0.5
    ;

    ;xlog = self.xlog & ylog = self.ylog

;    if xlog eq 1 then xrange = 10.0^xrange
;    if ylog eq 1 then yrange = 10.0^yrange

;    print,'nse_normalizecoord xrange=',xrange
;    print,'nse_normalizecoord yrange=',yrange


    x1 = xrange[1] & x0 = xrange[0]
    y1 = yrange[1] & y0 = yrange[0]

    xnorm = x*(x1-x0) + x0
    ynorm = y*(y1-y0) + y0

    if xlog eq 1 then xnorm = 10.0^xnorm
    if ylog eq 1 then ynorm = 10.0^ynorm

    return,[xnorm,ynorm]
end;nse_normalizecoord
