; $Id$
;###############################################################################
;
;
;CLASS NAME:
;    cwo_mergedavefiles_class
;
;PURPOSE:
;
;CATEGORY:
;
;
;SUPERCLASSES:
;    inherits idl_container
;
;
;METHODS:
;    cwo_mergedavefiles_event
;    cwo_mergedavefiles_class::event
;    cwo_mergedavefiles_class::displayHelp
;    cwo_mergedavefiles_class::quit
;    cwo_mergedavefiles_class::selectFiles
;    cwo_mergedavefiles_class::mergeFiles
;    cwo_mergedavefiles_class::mergeData
;    cwo_mergedavefiles_class::getExt
;    cwo_mergedavefiles_class::writeDave
;    cwo_mergedavefiles_class::sortIQT
;    cwo_mergedavefiles_class::fillIn_Ts
;    cwo_mergedavefiles_class::readIQTFile
;    cwo_mergedavefiles_class::readDaveFile
;    cwo_mergedavefiles_class::readDatFile
;    cwo_mergedavefiles_class::draw
;    cwo_mergedavefiles_class::setproperty
;    cwo_mergedavefiles_class::getproperty
;    cwo_mergedavefiles_cleanup
;    cwo_mergedavefiles_class::cleanup
;    cwo_mergedavefiles_class::init
;    cwo_mergedavefiles_class__define
;    cwo_mergedavefiles
;
;
; AUTHOR:
; Larry Kneller
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; kneller@nist.gov  301-975-8839
; Fri Oct 27 20:53:03 2006
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used or if the code in this file is
; included in another product.
;
;###############################################################################



;
;WHY CAN I NOT GET AN EVENT _FUNCTION_ TO WORK??????????????????????
;
;THE REASON WAS THAT XMANAGER FORCES EVENT HANDLER TO BE PROCEDURE.
;A CALL TO WIDGET_CONTROL,WID,EVENT_FUNC='EVENT_FUNC_NAME' OVERRIDES THIS.
;
;
;function cwo_mergedavefiles_event,event
;    widget_control,event.handler,get_uvalue=obj
;    return,obj->event(event)
;end;cwo_mergedavefiles_event
;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_event,event
    widget_control,event.handler,get_uvalue=obj

    ret = obj->event(event)

    ;DO I HAVE TO PASS THIS EVENT DIRECTLY TO THE PARENT SOMEHOW??????
end;cwo_mergedavefiles_event
;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::event
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::event,event

    case event.id of
    self.quitbutton:begin
        self->quit
    end;quitbutton
    self.filebutton:begin
        self->selectFiles
    end;filebutton
    self.mergebutton:begin
        self->mergeFiles
    end;mergebutton
    self.helpbutton:begin
        self->displayHelp
    end;helpbutton
    else:
    endcase

    return,-1
end;cwo_mergedavefiles_class::event

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::displayHelp
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::displayHelp

    b = widget_base(group_leader=self.tlb,title='Help on Merge I(Q,t)',/floating,/col)
    s = ['Merge I(Q,t): Written by Larry Kneller',$
         'Use this to merge multiple different DAVE files into a single',$
         'DAVE file to facilitate analysis using PAN.  This program can merge files',$
         'with assorted and non-overlapping x-values.  You can select a fill value to',$
         'apply for the data values in groups where the some data points are not present.',$      
         '',$
         'To operate:,',$
         '1) Press "Find DAVE Files", ',$
         '2) Highlight files in the list that you wish to merge,',$
         '3) Set the value to use to fill in for missing data,',$  
         '4) Press "Merge Files" ',$
         '5) If all is successful you will be prompted for the output file name.',$
         '',$
         'Good Luck!' $         
         ]
    text = widget_text(b,xsize=max(strlen(s)),ysize = n_elements(s))

    widget_control,text,set_value=s
    widget_control,b,/realize


end;cwo_mergedavefiles_class::displayHelp


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::quit
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::quit
    widget_control,self.tlb,/destroy
end;cwo_mergedavefiles_class::quit

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::selectFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::selectFiles

    fn = dialog_pickfile(title='Select I(Q,t) Files:',$
                         /multi,$
                         dialog_parent=self.tlb, $
                         path=self.workdir,$
                         filter = '*.dave');['*.dave','*.dat','*.iqt'])

    if fn[0] ne '' then begin
        widget_control,self.filelist,set_value=file_basename(fn),set_uvalue=fn

        ;self.datadir = file_dirname(fn[0])
        self.workdir = file_dirname(fn[0])
    endif

end;cwo_mergedavefiles_class::selectFiles
pro cwo_mergedavefiles_fixQValues_event,event
  widget_control,event.handler,get_uvalue=pstate
  case event.id of
  (*pstate).ok:begin
    yn = dialog_message('Did you hit enter after adding the last value?',/question,title='Hit the Return Key?')
    if strupcase(yn) eq 'YES' then widget_control,(*pstate).tlb,/destroy
  end;ok
  else:begin
;    print,'cwo_mergedavefiles_fixQValues_event'
    widget_control,(*pstate).table,get_value=vals
;    print,vals
    (*pstate).q = vals[*].q
;    print,vals[*].q
  endelse
  endcase
end;cwo_mergedavefiles_fixQValues_event
pro cwo_mergedavefiles_fixQValues_cleanup,id
  widget_control,id,get_uvalue=pstate
;  ptr_free,pstate
end;cwo_mergedavefiles_fixQValues_cleanup

function cwo_mergedavefiles_fixQValues,q,fn,group_leader=group_leader

   v0 = {q:0.0d,fn:''}
   v = replicate(v0,n_elements(q))
   v[*].q = q
   v[*].fn = file_basename(fn)
   widths =[200,20*max(strlen(v[*].fn))]
   
   tempbase = widget_base(group_leader = group_leader,/col)
   table = widget_table(tempbase,column_labels=['Filename','Q'],value=v,/editable,/all_events,column_widths=widths)
   ok = widget_button(tempbase,value='OK')
   
   pstate = ptr_new({tlb:tempbase,table:table,ok:ok,q:q})
   
   widget_control,tempbase,/realize
   widget_control,tempbase,set_uvalue=pstate
   widget_control,table,get_value=vnew
;   xmanager,'cwo_mergedavefiles_fixQValues',tempbase,event_handler='cwo_mergedavefiles_class_fixQValues_event';,cleanup='cwo_mergedavefiles_fixQValues_cleanup'
   xmanager,'cwo_mergedavefiles_fixQValues',tempbase,event_handler='cwo_mergedavefiles_fixQValues_event';,cleanup='cwo_mergedavefiles_fixQValues_cleanup'

;   widget_control,tempbase,get_uvalue=pstate   
;   q = (*pstate).q
;   ptr_free,pstate
;   widget_control,tempbase,/destroy

;   help,*pstate,/struct
   q = (*pstate).q
   ptr_free,pstate
   return,q
end;cwo_mergedavefiles_fixQValues


pro cwo_mergedavefiles_class::fixQValues,pdata
if n_elements(pdata) gt 0 then begin
  ;GET THE q VALUES
  q = dblarr(n_elements(pdata))
  fn = strarr(n_elements(pdata))
  for i=0,n_elements(pdata)-1 do begin        
    q[i] = (*(pdata[i])).q
    fn[i] = (*(pdata[i])).fn        
  endfor;i
  
  ;POP OPEN A TABLE AND LET USER UPDATE THE q VALUES
  qmin = min(q,max=qmax)
  if qmin eq qmax then begin
    q = cwo_mergedavefiles_fixQValues(q,fn,group_leader= self.tlb)
    for i=0,n_elements(pdata)-1 do begin        
      (*(pdata[i])).q = q[i]
    endfor;i
  endif
endif
end;cwo_mergedavefiles_class::fixQValues



pro cwo_mergedavefiles_class::interpolateData,pdata

    if n_elements(pdata) gt 0 then begin
      tmin = min((*(pdata[0])).t,max=tmax)
      dt_temp = tmax-tmin
      t = (*(pdata[0])).t
      nt = n_elements(t)
      dt = t[1:nt-1] - t[0:nt-2]
      dtmin = min(dt)
      imin = min((*(pdata[0])).i)
      imax = max((*(pdata[0])).i)
      q = (*(pdata[0])).q

      allt = t
      
      for i=0,n_elements(pdata)-1 do begin
        ;help,(*(pdata[i])),/struct
        ;help,(*(pdata[i])).t

        t = (*(pdata[i])).t
        nt = n_elements(t)
        dt = t[1:nt-1] - t[0:nt-2]
        dtmin = min([dtmin,dt])

        imin = min([imin,(*(pdata[i])).i])
        imax = max([imax,(*(pdata[i])).i])
        
        q = [q,(*(pdata[i])).q]
        allt = [allt,t]
        
      endfor;i
      qmin = min(q,max=qmax)
      tmin = min(allt,max=tmax)

      ;print,'qmin,qmax,tmin,tmax,dtmin=',qmin,qmax,tmin,tmax,dtmin

      ntnew = ceil((tmax-tmin)/dtmin)
      tnew = tmin + (tmax-tmin)*(dindgen(ntnew)/double(ntnew-1))
      ;help,tnew

      ;NOW MAKE A NEW ARRAY OF pdata WITH THE DATA ON THE NEW t GRID
      pdatanew = ptrarr(n_elements(pdata))
      ;window,0
      ;plot,[tmin,tmax],[imin,imax]
      for i=0,n_elements(pdata)-1 do begin
        snew = {t:tnew,q:(*(pdata[i])).q,i:0.0*tnew,si:0.0*tnew+1.0} 
        ;help,*pdata[i],/struct

        ;NOW FIGURE OUT WHERE TO INTERPOLATE THE VALUES AND FILL THE REST
        mint = min((*(pdata[i])).t,max=maxt)
        ;print,i,min(abs(tnew-mint),mintindex),mintindex
        ;print,i,min(abs(tnew-maxt),maxtindex),maxtindex
        ;print,mint,tnew[mintindex]
        ;result = interpol((*(pdata[i])).i
        x_in = (*(pdata[i])).t
        z_in = (*(pdata[i])).i
        dz_in  = (*(pdata[i])).si

        x_out = tnew

        drebin,x_in,z_in,dz_in,x_out,z_out,dz_out,emsg=emsg,/points,/to_points,err=err
        ;print,emsg
        ;help,err

        snew.i = z_out
        snew.si = dz_out
        ;pdatanew[i] = ptr_new(snew)
        ptr_free,pdata[i]

        pdata[i] = ptr_new(snew)

        ;oplot,x_out,z_out

      endfor;i
      ;help,pdata,*(pdata[0]),*(pdatanew[0])
      ;help,pdatanew
;      pdatatemp = pdata
;      pdata = pdatanew
      ;ptr_free,pdata
    endif
;    return,pdatanew

end;cwo_mergedavefiles_class::interpolateData

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::mergeFiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::mergeFiles

    widget_control,self.filelist,get_uvalue=uval


    selection = widget_info(self.filelist,/list_select)

    ;help,uval
    ;print,selection

    if selection[0] ne -1 then begin
        sel = uval[selection]
        self->mergeData,sel
    endif else begin
        void = dialog_message('Please select files from the list.')
    endelse
end;cwo_mergedavefiles_class::mergeFiles


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::mergeData
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro Cwo_mergedavefiles_class::mergeData,fn

Catch,es
if es ne 0 then begin
  Print,'Error occurred!'
  Print,Tag_names(!error_state)
  Print,'!error_state=',!error_state
  Print,'!error_state.msg=',!error_state.msg
  void = Dialog_message('Error occurred below cwo_mergedavefiles_class::mergeData',dialog_parent=self.tlb)
  Catch,/cancel
  Return
endif

;Widget_control,self.fillfield,get_value=fillVal
;Widget_control,self.fillfield,set_value=fillVal ;In case file is blank user will see the zero value.

widget_control,self.fillField,get_value=fillOption

; clear the buffer for reading data to be merged into
nfn = N_elements(fn)
if Ptr_valid(self.pdata) then begin
  if N_elements(*self.pdata) ne 0 then begin
    if Ptr_valid((*self.pdata)[0]) then Ptr_free,(*self.pdata)
  endif
  Ptr_free,self.pdata
endif

pdata = []

; Read the data from the files
for i=0,nfn-1 do begin

  ;AT THIS STAGE THERE IS NO NEED FOR SORTING SINCE THERE ARE SORTIQT AND REMOVENAN PROCEDURES
  ;BELOW.  SORTIQT SEEMS LIKE A NATURAL PLACE TO PUT THE FUNCTIONALITY TO FILL IN THE MISSING
  ;T'S AND Q'S.

  ext = self->Getext(fn[i])
  if Strcmp(ext,'dave',/fold_case) gt 0 then begin
    str = self->Readdavefile(fn[i])
    for j=0,N_elements(str)-1 do begin
      pdata = [pdata,Ptr_new(str[j])]
    endfor;j
  endif;dave

  if Strcmp(ext,'iqt',/fold_case) gt 0 and $
    Strcmp(ext,'dave',/fold_case) eq 0 and $
    Strcmp(ext,'dat',/fold_case) eq 0 then begin
    str = self->Readiqtfile(fn[i])

    sz = Size(str,/type)
    if Size(str,/type) eq 8 then begin;stregex(out,'struct',/fold,/bool) ne 0 then begin
      pdata = [pdata,Ptr_new(str)]
    endif
  endif;iqt

endfor;i

nD = N_elements(pdata)
if nD gt 1 then begin
  self->Sortiqt,pdata
  self->Fixqvalues,pdata
  self->Sortiqt,pdata  ;SORT AGAIN IN CASE Q'S CHANGED
  self->Removenans,pdata
  
  ; Determine an agregate time range that overlaps all datasets
  for i = 0,nD-1 do begin
    str = (*(pData[i]))
    xv = str.t
    xv =  xv[Sort(xv)]  ; ensure x is in ascending order
    if (i eq 0) then begin
      nv = n_elements(xv)
      tol1 = 0.001*Abs(xv[1] - xv[0])       ;0.001 of the diff between first two times
      tol2 = 0.001*Abs(xv[nv-1] - xv[nv-2]) ;0.001 of the diff between last two times
      time = xv
    endif
    nt = n_elements(time)
    index1 = Where(xv-time[0] lt -1*tol1,cnt1)        ; find values less than current smallest time
    index2 = Where(xv-time[nt-1] gt tol2,cnt2)        ; find values greater than current largest time
    if (cnt1 gt 0) then time = [xv[index1],time]      ; if found, append the lower values to current time
    if (cnt2 gt 0) then time = [time,xv[index2]]      ; if found, append the upper values to current time
  endfor

  nt = n_elements(time)
  q = dblarr(nD)
  z = Dblarr(nt,nD)
  dz = Dblarr(nt,nD)
  sf = Fltarr(nt,nD) + 1.0   ;<-- records where data consists of overlapping data points
  
  for i = 0,nD-1 do begin
    str = (*(pData[i]))
    tnew = str.t
    znew = str.i
    dznew = str.si
    
    xSortIndex = Sort(tnew) ; ensure tnew is in ascending order
    tnew =  tnew[xSortIndex]
    ntnew = N_elements(tnew)
    znew = znew[xSortIndex]
    dznew = dznew[xSortIndex]
    sfnew = znew*0.0 + 1.0
    q[i] = str.q

    void = Where(Abs(tnew-time) gt tol1,notTheSame)
    if (notTheSame eq 0) then notTheSame = nt ne ntnew 
    if (notTheSame gt 0) then begin ; interpolate
      t0_le_tnew0 = ((time[0] - tnew[0]) lt -1*tol1) || (time[0] eq tnew[0])
      tn_ge_tnewn = ((time[nt-1] - tnew[ntnew-1]) gt tol2) || (time[nt - 1] eq tnew[ntnew - 1])
      if (t0_le_tnew0 or tn_ge_tnewn) then begin
        ;; avoid any extrapolation by running interpol() only for
        ;; values of x that lie within tnew
        t_ge_tnew0 = ((time - tnew[0]) gt tol1) or ((time - tnew[0]) eq 0.0)
        t_le_tnewn = ((time - tnew[ntnew-1]) lt tol2) or ((time - tnew[ntnew-1]) eq 0.0)
        inIndex = Where(t_ge_tnew0 and t_le_tnewn, inCnt $
          ,complement=outIndex,ncomplement=outCnt)
        if (inCnt gt 0) then begin
          tValid = time[inIndex]
          zinterp = Interpol(znew,tnew,tValid)
          dzinterp = Interpol(dznew,tnew,tValid)
          z[inIndex,i] = zinterp
          dz[inIndex,i] = dzinterp
        endif
        if (outCnt gt 0) then begin
          ; value is undefined so use a NaN
          z[outIndex,i] = (fillOption eq 0)? !values.d_nan : -9999.0
          dz[outIndex,i] = (fillOption eq 0)? !values.d_nan : -9999.0
          sf[outIndex,i] = 0.0
        endif
      endif
    endif else begin
      z[*,i] = znew
      dz[*,i] = dznew
      ;mon[*,i] = mnew
    endelse
  endfor

;  Widget_control,self.fillfield,get_value=fillVal
;  Widget_control,self.fillfield,set_value=fillVal ;In case file is blank user will see the zero value.

;  if combineOption eq 1 then begin
;    ;pdata = self->interpolateData(pdata)
;    self->Interpolatedata,pdata
;  endif
;  ;help,/heap,/brief
;
;  if combineOption ne 1 then self->Fillin_ts,pdata,fillVal=fillVal
;  ;help,/heap,/brief
;
;  self.pdata = Ptr_new(pdata)
;
;  q = Dblarr(N_elements(pdata))
;
;  for j=0,N_elements(pdata)-1 do begin
;    q[j] = (*(pdata[j])).q
;  endfor;j
;
;  t = (*(pdata[0])).t
;
;  I  = Dblarr(N_elements(t),N_elements(pdata))
;  sI = Dblarr(N_elements(t),N_elements(pdata))
;
;
;  for j=0,N_elements(q)-1 do begin
;    I[*,j] = (*(pdata[j])).i
;    sI[*,j] = (*(pdata[j])).si
;  endfor;j
;  Help,/heap,/brief
;  Ptr_free,pdata

  index = where(finite(dz) eq 0, cnt)
  if (cnt gt 0) then dz[index] = mean(dz,/nan)
  self->Writedave,q,time,z,dz

;  Help,/heap,/brief

endif else begin
  void = Dialog_message('No I(Q,t) data found.')
endelse

end;cwo_mergedavefiles_class::mergeFiles



;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::mergeData_LKneller
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::mergeData_LKneller,fn


    catch,es
    if es ne 0 then begin
        print,'Error occurred!'
        print,tag_names(!error_state)
        print,'!error_state=',!error_state
        print,'!error_state.msg=',!error_state.msg
        void = dialog_message('Error occurred below cwo_mergedavefiles_class::mergeData',dialog_parent=self.tlb)
        catch,/cancel
        return
    endif

    ;NOW OPEN FILES AND READ EACH I(Q,t) INTO A STRUCTURE:
    ;   s = {Q:Q,t:t,I:I,sI:sI}
    ;
    ;THEN CREATE A 2d DATA SET WITH
    ;
    ;   I[nQ,nt],sI[nQ,nT]
    ;   IF nt VARIES, THEN FILL IN I AT UNIQUE t'S WITH NaN'S --- WHAT ABOUT ROUNDING FOR Q,t????
    ;                                                             SEE WHAT WAS DONE IN ooEcho.
    ;
    ; THEN WRITE A DAVE FILE.

;#####################################
;
;   CHECK FOR MEMORY LEAK IN THIS PROCEDURE!!!!!!!!!!!!
;
;#####################################

    widget_control,self.combineChoice,get_value=combineOption
    if combineOption eq 1 then begin
      
      ;void = dialog_message('Interpolate Option not yet implemented.',/info)
      ;return
    endif

;help,/heap,/brief
    nfn = n_elements(fn)
    if ptr_valid(self.pdata) then begin
        if n_elements(*self.pdata) ne 0 then begin
            if ptr_valid((*self.pdata)[0]) then ptr_free,(*self.pdata)
        endif
        ptr_free,self.pdata
    endif
;help,/heap,/brief

    pdata = ptrarr(1)

    for i=0,nfn-1 do begin


;NOW NEED TO ADD TWO THINGS:

;READER FOR OTHER ASCII FILE
;SORT BY Q AND WRITE DAVE




;012307
;NEED TO IMPROVE THIS SO THAT IT SORTS OUT THE TIMES AND Q's
;
;THE ISSUE WITH TIMES MEANS THAT I HAVE TO FIGURE OUT WHICH TIMES
;ARE IN THE FILES, SORT THEM, AND FILL IN THE MISSING TIMES.
;
;THERE IS PROBABLY AN ISSUE WITH THE TIMES IN THAT THEY ARE
;VERY SIMILAR FOR MANY SETS BUT NOT IDENTICAL.
;
;FIRST TRY TO GET t's AND Q's

;AT THIS STAGE THERE IS NO NEED FOR SORTING SINCE THERE ARE SORTIQT AND REMOVENAN PROCEDURES
;BELOW.  SORTIQT SEEMS LIKE A NATURAL PLACE TO PUT THE FUNCTIONALITY TO FILL IN THE MISSING
;T'S AND Q'S.

        ext = self->getExt(fn[i])
        if strcmp(ext,'dave',/fold_case) gt 0 then begin
            str = self->readDaveFile(fn[i])
            ;print,n_elements(str)
            for j=0,n_elements(str)-1 do begin
                pdata = [pdata,ptr_new(str[j])]
            endfor;j
        endif;dave
        if strcmp(ext,'iqt',/fold_case) eq 0 and $
            strcmp(ext,'dave',/fold_case) eq 0 and $
             strcmp(ext,'dat',/fold_case) eq 0 then begin
            str = self->readIQTFile(fn[i])

            sz = size(str,/type)
            if size(str,/type) eq 8 then begin;stregex(out,'struct',/fold,/bool) ne 0 then begin
                pdata = [pdata,ptr_new(str)]
            endif

        endif;iqt
    endfor;i
;help,/heap,/brief


    p = pdata[0]
    ptr_free,p
;help,/heap,/brief

    if n_elements(pdata) gt 1 then begin
        pdata = pdata[1:*]

;help,/heap,/brief
        self->sortIQT,pdata
;help,/heap,/brief
        self->fixQValues,pdata
;help,/heap,/brief
        self->sortIQT,pdata  ;SORT AGAIN IN CASE Q'S CHANGED
;help,/heap,/brief
        self->removeNaNs,pdata
;help,/heap,/brief

        widget_control,self.fillField,get_value=fillVal
        widget_control,self.fillField,set_value=fillVal ;In case file is blank user will see the zero value.

        if combineOption eq 1 then begin
           ;pdata = self->interpolateData(pdata)
           self->interpolateData,pdata
        endif 
;help,/heap,/brief

        if combineOption ne 1 then self->fillIn_Ts,pdata,fillVal=fillVal
;help,/heap,/brief

        self.pdata = ptr_new(pdata)

        q = dblarr(n_elements(pdata))

        for j=0,n_elements(pdata)-1 do begin
            q[j] = (*(pdata[j])).q
        endfor;j

        t = (*(pdata[0])).t

        I  = dblarr(n_elements(t),n_elements(pdata))
        sI = dblarr(n_elements(t),n_elements(pdata))


        for j=0,n_elements(q)-1 do begin
            I[*,j] = (*(pdata[j])).I
            sI[*,j] = (*(pdata[j])).sI
        endfor;j
help,/heap,/brief
        ptr_free,pdata

        self->writedave,q,t,i,si
        
help,/heap,/brief

    endif else begin
        void = dialog_message('No I(Q,t) data found.')
    endelse

end;cwo_mergedavefiles_class::mergedata

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::getExt
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::getExt,s
        iext = strpos(s,'.',/reverse_search)

        if iext ne -1 then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
        endif else begin
            ext = ''
        endelse
        return,ext

end;cwo_mergedavefiles_class::getExt


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::writeDave
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::writeDave,q,t,i,si


    filename = dialog_pickfile(/write,$
                    title='Merged DAVE export file:',$
                    path=self.workdir,$
                    dialog_parent=self.tlb, $
                    /overwrite_prompt,$
                    filter = '*.dave')


    if filename eq '' then begin
        void = dialog_message('NO FILE SELECTED.')
        filename = 'CombinedDaveFile.dave'
    endif else begin

        ext = self->getExt(filename)
        if strcmp(ext,'dave',/fold_case) le 0 then begin
            filename = filename + '.dave'
        endif

        instrument = 'MERGED_DAVE_FILES'
        qty = i
        dqty = si
        x = t
        y = q

        ;CREATE PAN_MASK
        pan_mask = long(0*i)

;        ;CHECK FOR NON FINITE VALUES AND IF PRESENT REPLACE WITH FILLER
;        whnefinite = where(finite(qty) eq 0,nefinitecount)
;        if nefinitecount ne 0 then begin
;            ;print,'NON FINITE VALUES PRESENT'
;            ;pan_mask[whnefinite] = 0   ;DEFAULT VALUES ARE ZERO, SO THIS STEP IS NOT NECESSARY.
;            qty[whnefinite] = -9999
;            dqty[whnefinite] = 9999
;        endif
;
;        ;DEFINE MASK IN TERMS OF POSITIONS OF FILLER VALUES IN QTY.
;        whnefiller = where(qty ne -9999,nefillercount)
;        if nefillercount ne 0 then begin
;            pan_mask[whnefiller] = 1
;        endif

        ;print,where(finite(qty) eq 0)

        xlabel = 'time';'time (s)'
        ylabel = 'Q';'Q '
        xunits = 's';'time:s'
        yunits = '$\AA^{-1}$';'wavevector:A-1'
        histlabel = 'I (arbitrary units)'
        histunits = ''

        ;print,'cwo_mergedavefiles_class::writeDave:   bits2bytes(pan_mask)=',bits2bytes(pan_mask)
        specificstr = {NSE_FILLER:-9999,PAN_MASK:ptr_new(bits2bytes(pan_mask))}
        treatment = 'MERGED_DAVE_FILES';'NSE data reduced'
        ret = create_dave_pointer( $
                    daveptr,              $
                    instrument = instrument,    $
                    qty = qty,            $
                    qtunits = histunits,       $
                    qtlabel = histlabel,       $
                    err = dqty,            $
                    xvals = x,          $
                    xtype = 'point',          $
                    xunits = xunits,         $
                    xlabel = xlabel,         $
                    yvals = y,          $
                    ytype = 'point',          $
                    yunits = yunits,         $
                    ylabel = ylabel,         $
                    specificstr = specificstr,  $
                    treatment = treatment)

        save,filename=filename,daveptr
    endelse

end;writeDave



;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::removeNaNs
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::removeNaNs,p
; remove dtasets that is filled with NANs only.
goodarr = intarr(n_elements(p))

for j=0,n_elements(p)-1 do begin
    arr = (*(p[j])).I
    npts = n_elements(arr)
    if total(finite(arr,/nan)) lt npts then goodarr[j] = 1
endfor;j

if total(goodarr) lt n_elements(p) then begin
  if total(goodarr) gt 0 then begin
    ;050207
    ;AT THIS POINT IT LOOKS LIKE THE ALL-NAN GROUPS SHOULD BE REMOVED AUTOMATICALLY.
    ;IS THIS THE CASE?????
    pnew = ptrarr(fix(total(goodarr)))
    inew = 0
    for j=0,n_elements(p)-1 do begin
        if goodarr[j] eq 1 then begin
            pnew[inew] = ptr_new(*(p[j]))
            inew++
        endif
    endfor;j
    for k=0,n_elements(p)-1 do begin
        ptr_free,p[k]
    endfor;k
    p = pnew
  endif else begin
      void = dialog_message('All data NaN!!!')
  endelse
endif
end;cwo_mergedavefiles_class::removeNaNs


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::sortIQT
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::sortIQT,p

q = dblarr(n_elements(p))
for j=0,n_elements(p)-1 do begin
  q[j] = (*(p[j])).q
endfor;j

sortq = sort(q)
p = p[sortq]

end;cwo_mergedavefiles_class::sortIQT


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::fillIn_Ts
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::fillIn_Ts,p,fillVal = fillVal
    on_error,2
    ;print,"FILL IN T's HERE.  Update 4% Tolerance here if updated in ooEcho."


;THERE ARE A FEW PROBLEMS AT THIS POINT.
;
;1) THE T's ARE REPORTED IN ns AND s DEPENDING ON FILETYPE  --- SO CHANGE ALL TO ns.
;2) SIMILAR T's COULD BE EFFECTIVELY THE SAME VALUE.
;       WHAT IS THE TOLERANCE?              ---- LOOK AT CODE FOR CHOOSING RES POINTS.  --- Currently 4%.
;       HOW DO I CHOOSE THE "RIGHT" ONE?
;
;3) WHAT VALUES SHOULD I PLACE IN THE FIELDS? 0.0, Inf?
;



;FIRST COPY THE INPUT DATA SETS
pnew = ptrarr(n_elements(p))
for i = 0,n_elements(p)-1 do begin
    d = (*p[i])
    order = sort(d.t)
    d.t = d.t[order]
    d.i = d.i[order]
    d.si = d.si[order]

    pnew[i] = ptr_new(d)
endfor;i




;SECOND GET ALL THE UNIQUE TIMES (WITHIN THE 4% MARGIN USED ELSEWHERE IN NSE REDUCTION)
    allT = [-1.0]
    for i=0,n_elements(p)-1 do begin
        ti = (*p[i]).t
        ;LRK - 011409  UPDATE FOR MERGING GENERAL DAVE FILES
        ;if min(ti) gt 1.0e-5 then ti = (1.0e-9)*ti
        if i eq 0 then begin
            allT = [ti]
        endif else begin

            for j=0,n_elements(ti)-1 do begin
                wh = where(abs((ti[j] - allT)/ti[j]) lt 0.0001,count)
                if count eq 0 then allT = [allT,ti[j]]
            endfor;j
        endelse
    endfor;i


    format = '(' + strtrim(string(n_elements(allT)),2) + 'g15.7)'
    ;print,'allT = '
    ;print,allT,format = format

;THIRD FILL IN ALL THE NEW DATA SETS WITH THE EXTRA T'S

    if n_elements(fillVal) eq 0 then begin
      fillVal = -9999
      iqtReplacement = fillVal;-9999;abs(!values.d_nan);double('NaN');0.0
      siqtReplacement = -fillVal;9999;abs(!values.d_nan);double('NaN');double('Infinity')
    endif else begin
      iqtReplacement = fillVal;-9999;abs(!values.d_nan);double('NaN');0.0
      sFillVal = ((fillVal eq 0.0) ?  1.0 : -fillVal)  
      siqtReplacement = sFillVal;9999;abs(!values.d_nan);double('NaN');double('Infinity')      
    endelse

    for i=0,n_elements(pnew)-1 do begin
        t = (*pnew[i]).t
        iqt = (*pnew[i]).i
        siqt = (*pnew[i]).si

;THE ALGORITHM IN THIS SECTION SHOULD BE USEFUL ELSEWHERE AS WELL.

        for j=0,n_elements(allT)-1 do begin
            wh = where(abs((allT[j] - t)/allT[j]) lt 0.0001,count)  ;LRK 011409 REMOVE SCALING
            ;WHAT IF allT[j] eq 0.0???? THEN (allT[j] - t)/allT[j]) eq NaN!!!!!!!!
            if allT[j] eq 0.0 then begin 
              wh = where(abs(allT[j] - t) lt 0.0001,count)  ;LRK 011409 REMOVE SCALING
            endif
            
            if count eq 0 then begin
            
                
                ;INSERT A TIME
                if allT[j] lt t[0] then begin

                    ;INSERT AT BEGINNING OF ARRAY
                    t = [allT[j],t]
                    iqt = [iqtReplacement,iqt]
                    siqt = [siqtReplacement,siqt]
                endif else begin
                    if allT[j] gt t[0] and allt[j] lt t[n_elements(t)-1] then begin

                        ;FIGURE OUT WHERE THE NEW TIME BELONGS AND PLACE IT
                        whless = where(t lt allT[j],count)
;;;;;print,'whless=',whless
;;;;;print,'n_elements(t)=',n_elements(t)
;;;;;print,'allt[j]=',allt[j]
;;;;;print,'t=',t
                        if count gt 0 then begin
                            t = [t[0:max(whless)],allT[j],t[max(whless)+1:*]]
                            iqt = [iqt[0:max(whless)],iqtReplacement,iqt[max(whless)+1:*]]
                            siqt = [siqt[0:max(whless)],siqtReplacement,siqt[max(whless)+1:*]]

                        endif
                    endif else begin
                        ;APPEND TO END OF ARRAY
                        t = [t,allT[j]]
                        iqt = [iqt,iqtReplacement]
                        siqt = [siqt,siqtReplacement]
                    endelse
                endelse
            endif;count ne 0
        endfor;j
;;;;;print,'First i=',i
        ;CONVERT ALL TIMES TO UNITS OF ns.

;LRK 011409 REMOVE SCALING
;        for it=0,n_elements(t)-1 do begin
;            if t[it] gt 1.0e-5 then t[it] = t[it]*1.0e-9
;        endfor;i
        dnew = {Q:(*pnew[i]).q,t:t,i:iqt,si:siqt}
;;;;;        help,(*pnew[i]).q,t,iqt,siqt
        if ptr_valid(pnew[i]) gt 0 then ptr_free,pnew[i]
        pnew[i] = ptr_new(dnew)
;;;;;print,'Second i=',i
    endfor;i

    for i=0,n_elements(p)-1 do begin
        if ptr_valid(p[i]) then ptr_free,p[i]
    endfor;i

    p = pnew

;;;;;    print,(*pnew[0])
    ;help,/traceback

end;cwo_mergedavefiles_class::fillIn_Ts



;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::readIQTFile
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::readIQTFile,fn


    catch,es
    if es ne 0 then begin
        s = -1
        catch,/cancel
        return,s
    endif

    nlines = file_lines(fn)
    s = strarr(nlines)
    openr,lun,fn,/get_lun
    readf,lun,s
    free_lun,lun

    segs = strsplit(s[2],/extract)
    nq = (n_elements(segs)-1)/2
    nt = nlines - 2
    Q  = dblarr(nq)
    t  = dblarr(nt)
    I  = dblarr(nt,nq)
    sI = dblarr(nt,nq)

    segs = strsplit(s[0],/extract)

    for j=2,nlines-1 do begin

        segs = strsplit(s[j],/extract)

        t[j-2] = double(segs[0])
        for k=0,nq-1 do begin
            I[j-2,k]  = double(segs[k+1])
            sI[j-2,k] = double(segs[k+2])
        endfor;k
    endfor;j


;WHY IS THE NEXT BLOCK REPEATED?????
    s = {t:t,q:q[0],I:I[*,0],sI:sI[*,0],fn:fn}
    str = replicate(s,n_elements(q))

    for j=0,n_elements(q)-1 do begin
        
        str[j].t  = t
        str[j].q  = q[j]
        str[j].I  = I[*,j]
        str[j].sI = sI[*,j]
        str[j].fn  = fn
    endfor;j

    s = {t:t,q:q[0],I:I[*,0],sI:sI[*,0],fn:fn}
    str = replicate(s,n_elements(q))

    for j=0,n_elements(q)-1 do begin
        str[j].t  = t
        str[j].q  = q[j]
        str[j].I  = I[*,j]
        str[j].sI = sI[*,j]
        str[j].fn  = fn
    endfor;j

    return,s

end;cwo_mergedavefiles_class::readIQTFile



;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::readDaveFile
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::readDaveFile,fn

	restore, fn, restored_objects=someObjects
	heap_free,someObjects


    t  = (*((*(*davePtr).datastrptr).commonstr).histptr).x
    q  = (*((*(*davePtr).datastrptr).commonstr).histptr).y
    I  = (*((*(*davePtr).datastrptr).commonstr).histptr).qty
    sI = (*((*(*davePtr).datastrptr).commonstr).histptr).err


	heap_free, davePtr ;free_all_ptrs,davePtr

    s = {t:t,q:q[0],I:I[*,0],sI:sI[*,0],fn:fn}
    str = replicate(s,n_elements(q))

    for j=0,n_elements(q)-1 do begin
        str[j].t  = t
        str[j].q  = q[j]
        str[j].I  = I[*,j]
        str[j].sI = sI[*,j]
    endfor;j

    return,str
end;cwo_mergedavefiles_class::readDaveFile
;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::readDatFile
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::readDatFile,fn

    s = 0
    catch,es
    if es ne 0 then begin
        s = -1
        catch,/cancel
        return,s
    endif

    nlines = file_lines(fn)

    in = strarr(nlines)
    openr,lun,fn,/get_lun
    readf,lun,in
    free_lun,lun

    Q  = 0.0
    t  = dblarr(nlines-1)
    I  = dblarr(nlines-1)
    sI = dblarr(nlines-1)
    for j=1,nlines-1 do begin
        ;print,in[j]
        segs = strsplit(in[j],/extract)
        ;print,j,nlines,n_elements(segs),in[j]
        Q     = double(segs[0])
        t[j-1]  = double(segs[1])
        I[j-1]  = double(segs[2])
        sI[j-1] = double(segs[3])
    endfor;j

    s = {Q:Q,t:t,I:I,sI:sI,fn:fn}

    return,s
end;cwo_mergedavefiles_class::readDatFile

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::draw
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::draw
end;cwo_mergedavefiles_class::draw

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::setproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::setproperty,_Extra=extra
    if n_elements(tlb) ne 0 then self.tlb =tlb
end;cwo_mergedavefiles_class::setproperty


;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::getproperty
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::getproperty,tlb=tlb,_Extra=extra

    if arg_present(tlb) ne 0 then tlb = self.tlb
end;cwo_mergedavefiles_class::getproperty

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_cleanup,id
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;cwo_mergedavefiles_cleanup

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::cleanup
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class::cleanup
    print,'cwo_mergedavefiles_class::cleanup'
    if ptr_valid(self.pdata) then begin
        if ptr_valid((*self.pdata)[0]) then ptr_free,(*self.pdata)
        ptr_free,self.pdata
    endif
end;cwo_mergedavefiles_class::cleanup

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class::init
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles_class::init,parent,xsize=xsize,ysize=ysize,tlb=tlb,group_leader=group_leader,$
                                  datadir=datadir,workdir=workdir,_Extra=extra

    nobj = checkforobjinstance('cwo_mergedavefiles_class',ref=ref)
    if nobj gt 1 then begin
        help,ref[0],output=out0,struct=0
        help,self,output=outself,struct=0

        if strcmp(out0,outself,/fold_case) eq 0 then begin
            ref[0]->getproperty,tlb=tlb
        endif else begin
            ref[1]->getproperty,tlb=tlb
        endelse

        widget_control,tlb,/show
        return,0
    endif else begin

        if n_elements(parent) eq 0 then parent = -1L

        if n_elements(datadir) eq 0 then self.datadir = '.' else self.datadir = datadir
        if n_elements(workdir) eq 0 then self.workdir = '.' else self.workdir = workdir

        if parent ne -1L then begin
            tlb = widget_base(parent,title='Merge DAVE Files',group_leader=parent,/row,uvalue=self,$
                                kill_notify='cwo_mergedavefiles_cleanup')
        endif else begin
            tlb = widget_base(title='Merge DAVE Files',group_leader=group_leader,mbar=bar,/row,uvalue=self,$
                                kill_notify='cwo_mergedavefiles_cleanup')
        endelse

        llb1 = widget_base(tlb,/col)
        llb2 = widget_base(tlb,/col)

        value=['No Files Selected']
        self.filelist = widget_list(llb1,xsize=60,ysize = 15,$
                                    value=value,$
                                    uvalue=value,$
                                    /multiple)

        if n_elements(bar) ne 0 then begin
            filemenu = widget_button(bar,value='File',/menu)
            self.quitbutton = widget_button(filemenu,value='Quit')
        endif else begin
            self.quitbutton = widget_button(llb2,value='Quit')
        endelse


        self.fileButton  = Widget_button(llb2,value='Find DAVE Files',$
                                              tooltip='Choose files for possible merge')


;        self.combineChoice = cw_bgroup(llb2,['Remesh','Interpolate'],/col,frame=1,/exclusive,label_top='Combine Option',set_value=0)  
;        self.fillfield = cw_field(llb2,value=-9999,title='Data Fill Value:',/float,/row)
self.fillfield = Cw_bgroup(llb2,['NaN','-9999'],/col,frame=1,/exclusive,label_top='Data Fill Value',set_value=0)


        self.mergeButton = Widget_button(llb2,value='Merge Selected Files',$
                                              tooltip='Merge selected files into single DAVE file')


        self.helpButton  = widget_button(llb2,value='Help',$
                                              tooltip='Help on Merge I(Q,t)')


        widget_control,tlb,/realize
        ;xmanager,'cwo_mergedavefiles',tlb,/no_block;,event_handler='cwo_mergedavefiles_event'
        xmanager,'cwo_mergedavefiles',tlb,/no_block,event_handler='cwo_mergedavefiles_event'
        centertlb,tlb

        self.tlb = tlb

        return,1
    endelse
end;init

;###############################################################################
;
;NAME:
;        cwo_mergedavefiles_class__define
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;###############################################################################
pro cwo_mergedavefiles_class__define,class

    class = {cwo_mergedavefiles_class,$
                inherits idl_container,$
                pdata:ptr_new(),$
                datadir:'',$
                workdir:'',$
                tlb:0L,$
                filelist:0L,$
                quitbutton:0L,$
                filebutton:0L,$
                mergebutton:0L,$
                helpbutton:0L,$
                fillField:0L,$
                combinechoice:0L}

end;cwo_mergedavefiles_class__define



;###############################################################################
;
;NAME:
;        cwo_mergedavefiles
;
;PURPOSE:
;
;PARAMETERS:
;
;KEYWORDS:
;
;_EXTRA - is used to pass keywords meant for the superclass.
;
;RETURN VALUE:
;
;###############################################################################
function cwo_mergedavefiles,parent,obj=obj,xsize=xsize,ysize=ysize,group_leader=group_leader,_Extra=extra

;    message = ['There have been updates to this program, including an interpolation option (using DREBIN),',$
;               'and the option to enter new Q values.  Please check your results carefully!']
;    
;    void = dialog_message(message,title='WARNING:')
    
    if n_elements(parent) eq 0 then parent = -1L
    obj = obj_new('cwo_mergedavefiles_class',parent,xsize=ysize,ysize=ysize,tlb=tlb,group_leader=group_leader,$
                                      _Extra=extra)

    return,tlb

end;cwo_mergedavefiles
