; $Id$




pro NSEScanPreview::getproperty,$
                            x=x,$
                            y=y,$
                            sy=sy,$
                            legend=legend,$
                            color=color,$
                            psym=psym,$
                            linestyle=linestyle,$
                            thesymsize=thesymsize,$
                            showdata=showdata,$
                            showlegend=showlegend,$
                            ebshow=ebshow,$
                            id=id,$
                            workdir=workdir,$
                            pointNumber=pointNumber,$
                            ScanQArcs=scanQArcs,$
                            ScanQMin=scanQMin,$
                            ScanQMax=ScanQMax,$                            
                            _ref_extra=extra


      scanQMin = self.scanQMin
      scanQMax = self.scanQMax
      scanQArcs = self.scanQArcs

      self->cwo_drawplot_data::getproperty,$
                                      x=x,$
                                      y=y,$
                                      sy=sy,$
                                      legend=legend,$
                                      color=color,$
                                      psym=psym,$
                                      linestyle=linestyle,$
                                      thesymsize=thesymsize,$
                                      showdata=showdata,$
                                      showlegend=showlegend,$
                                      ebshow=ebshow,$
                                      id=id,$
                                      workdir=workdir,$
                                      _extra=extra

  



end;NSEScanPreview::getproperty
pro NSEScanPreview::calculate,qarcs=qarcs,qmin=qmin,qmax=qmax,_Extra=extra
;
;NAME:
;        NSEScanPreview::calculate
;
;PURPOSE:
;           Create an index showing the arc index at each pixel.
;           This is useful for displaying the arcs on the image
;           in ooDisplayEcho.
;PARAMETERS:
;           narcs   The number of Q arcs.
;           arcmat  The matrix is passed back to the calling program via arcmat
;KEYWORDS:
;

                ;GET THE CURRENT VALUES
                self->update

                lambda = self.ScanLambdaValue;7.0
                Qo = self.ScanQCenValue;0.0
                narcs = self.ScanNArcsValue;7


;CALCULATE Q VALUES
            ;CURRENT SETTINGS IN METERS
                xpixsz = 0.01
                ypixsz = 0.01
                sd = 4.35

                xcen = float(self.ScanXCenValue);16.0
                ycen = float(self.ScanYCenValue);16.0

                x32 = findgen(32)#(fltarr(32) + 1.0)

                y32 = (fltarr(32) + 1.0)#findgen(32)

                dm = sqrt((xpixsz*(x32-xcen))^2.0 + (ypixsz*(y32-ycen))^2.0)

                dx = xpixsz*(x32-xcen)
                dy = ypixsz*(y32-ycen)


            ;FACTOR OF 2????
                theta0 = asin(lambda*Qo/(4.0*!dpi))   ;THIS IS THE ACTUAL THETA VALUE
                thetax1 = atan(dx/sd)/2.0
                thetay1 = atan(dy/sd)/2.0

                QxPixel = (4.0*!dpi/lambda)*sin(theta0 + thetax1)
                QyPixel = (4.0*!dpi/lambda)*sin(thetay1)

;print,(theta0+min(thetax1)/2.0)*180.0/!PI,(theta0+max(thetax1)/2.0)*180.0/!PI


                Q = sqrt(QxPixel^2 + QyPixel^2)
;help,Q
;                window,0
;                plotimage,bytscl(Q)
                qmin = min(Q)
                qmax = max(Q)
;print,qmin,qmax

                qarcs = dblarr(narcs)
                if narcs le 1 then begin
                    arcsmat = byte(0*Q)+1b
                    whq = where(arcsmat eq 1,count)
                    qarcs[0] = total(Q[whq])/count
                endif else begin
                    qstep = (qmax - qmin)/(narcs-1)
                    arcsmat = round(Q/qstep)
;print,qstep,qmax,qmin,narcs
;					window,0
;                    plotimage,bytscl(arcsmat)
;print,'min/max(arcsmat)=',min(arcsmat),max(arcsmat)
                    arc0 = min(arcsmat)
                    for i=0,narcs-1 do begin

						;082307
						;COPYING FROM ooEcho::calculateArcsQMatrix
						;qarcs[i] = qmin + qstep*double(i)

						;BUT
						newqstep = (qmax - qmin)/double(narcs)
						qarcs[i] = qmin + (float(i) + 0.5)*newqstep

						;082307
						;THIS WHERE STATEMENT IS OFF SOMEHOW.
;;;;;                        ;whq = where(arcsmat eq i+min(arcsmat),count)
;;;;;
;;;;;                        ;print,i,' count=',count
;;;;;                        ;if count ne 0 then qarcs[i] = total(Q[whq])/double(count)
                    endfor;i
                endelse
                if ptr_valid(self.ScanQArcs) gt 0 then ptr_free,self.ScanQArcs
                self.ScanQArcs = ptr_new(qarcs)

	;print,'###########################'
	;help,self,/traceback
	;print,qarcs

end;NSEScanPreview::calculate

pro NSEScanPreview::draw,win,_ref_extra=extra


        self->calculate,qmax=qmax,qmin=qmin,_extra=extra
        wset,win

        device,get_decomposed=dc
        device,decomposed=1


        index = self.pointnumber
        x = *self.ScanQArcs
        y = index + 0.0*x


        self->getproperty,color=color,psym=psym,$
                linestyle=linestyle,legend=legend,showdata=showdata,$
                showlegend=showlegend,ebshow=ebshow,thesymsize=symsize
;print,'cwo_drawplot_data::draw',showlegend
        ;if showdata ne 0 then begin
            ;print,'x=',x
            ;print,'y=',y
            oplot,x,y,color = color,$
                  psym =  2,$;psym,$
                  ;linestyle=linestyle,$
                  symsize=symsize
            oplot,[qmin,qmax],[y[0],y[0]],color = color
        ;endif;show

        device, decomposed = dc


end;NSEScanPreview::draw

function NSEScanPreview::xrange

    self->calculate,qmax=qmax,qmin=qmin
;    if ptr_valid(self.ScanQArcs) gt 0 then begin
;        return,[min(*self.ScanQArcs),max(*self.ScanQArcs)]
;    endif else begin
;        return,[0.0,1.0]
;    endelse

    return,[qmin,qmax]
end;xrange
function NSEScanPreview::yrange

    index = self.pointnumber
    ;print,'yrange, index = ',index
    return,[index,index]

end;yrange




function NSEScanPreview_event,event

    widget_control,event.handler,get_uvalue=obj
    newevent = obj->event(event)

    return,newevent
end;NSEScanPreview_event

function NSEScanPreview::event,event


print,self.scanqcenvalue
    id = self.tlb
    top = self.tlb
    handler = self.tlb
    index = self.pointNumber


    rangeupdate = 0
    if event.id eq self.ScanQCenField then rangeupdate = 1


    newevent = {NSEScanPreviewEvent,id:id,top:self.parenttlb,handler:self.parenttlb,index:index,rangeupdate:rangeupdate}
    self->update


    index = nse_comboindex(self.ScanColorDrop)
    black = 0L
    red = 255L
    green = 256L*255L
    blue = 256L*256L*255L
    purple = red+green
    color = [black,red,green,blue,purple]
    self.color = color[index]; ['black','red','green','blue','purple']


    return,newevent

end;NSEScanPreview::event
function NSEScanPreview::getColorValue,index,colors=colors

    if n_elements(index) eq 0 then index = 0

    black = 0L
    red = 255L
    green = 256L*255L
    blue = 256L*256L*255L
    purple = red+blue
    colors = [black,red,green,blue,purple]

    return,colors[index mod n_elements(colors)]

end;NSEScanPreview::getColorValue
function NSEScanPreview::getColorName,index,colors=colors

    if n_elements(index) eq 0 then index = 0

    colors = ['black','red','green','blue','purple']

    return,colors[index mod n_elements(colors)]

end;NSEScanPreview::getColorName


pro NSEScanPreview::update

;UPDATE VALUES IN OBJECT
    widget_control,self.scanLambdaField,get_value=val
    self.ScanLambdaValue = val
    widget_control,self.ScanNarcsField,get_value=val
    self.ScanNarcsValue = val
    if ptr_valid(self.scanQArcs) ne 0 then ptr_free,self.scanQArcs
    self.scanQArcs = ptr_new(dindgen(val))

    widget_control,self.ScanQcenField,get_value=val
    self.ScanQCenValue = val
    widget_control,self.ScanXcenField,get_value=val
    self.ScanXCenValue = val
    widget_control,self.ScanYcenField,get_value=val
    self.ScanYCenValue = val
    widget_control,self.ScanVar1Field,get_value=val
    self.ScanVar1Value = val
    widget_control,self.ScanVar2Field,get_value=val
    self.ScanVar2Value = val
    widget_control,self.ScanVar3Field,get_value=val
    self.ScanVar3Value = val


end;NSEScanPreview::update
pro NSEScanPreview_cleanup,id
    ;print,'NSEScanPreview_cleanup'
    widget_control,id,get_uvalue=obj
    obj_destroy,obj
end;NSEScanPreview_cleanup

pro NSEScanPreview::cleanup
    ;print,'NSEScanPreview::cleanup'
    if ptr_valid(self.scanQArcs) ne 0 then ptr_free,self.scanQArcs
end;NSEScanPreview::cleanup
function NSEScanPreview::init,parent,pointNumber,tlb=tlb,lambda=lambda,qcen=qcen,$
                                              xcen=xcen,ycen=ycen,parenttlb=parenttlb

    spn = '0'
    spn = strtrim(string(pointNumber),2)
    if n_elements(qcen) eq 0 then qcen = 0.4
    self.pointnumber = pointnumber
    colorindex = pointnumber mod 5
    color = self->getColorValue(pointnumber,colors=colorvalues)
    self.color = color

    colorname = self->getColorName(pointnumber,colors=colornames)
    ;print,colornames
    self.parenttlb = parenttlb
    tlb = widget_base(parent,/col,uvalue=self,kill_notify='NSEScanPreview_cleanup')
    self.tlb = tlb
    llb = widget_base(parent,/col,frame=2)
    hidebase = widget_base()
    label = widget_label(llb,value='Scan #'+spn)
    self.scanLambdaField = cw_field(llb,title='Lambda_'+spn,value=10.0,/floating,$
                                                                    /return_events)
    self.ScanNarcsField = cw_field(llb,title='Narcs'+spn,value=5,/integer,/return_events)
    self.ScanQcenField = cw_field(llb,title='QCen_'+spn,value=qcen,/floating,/return_events)
    self.ScanXcenField = cw_field(llb,title='XCen_'+spn,value=16.0,/floating,/return_events)
    self.ScanYcenField = cw_field(llb,title='YCen_'+spn,value=16.0,/floating,/return_events)
    self.ScanVar1Field = cw_field(hidebase,title='Var1_'+spn,value=10.0,/floating,$
                                                                    /return_events)
    self.ScanVar2Field = cw_field(hidebase,title='Var2_'+spn,value=10.0,/floating,$
                                                                    /return_events)
    self.ScanVar3Field = cw_field(hidebase,title='Var3_'+spn,value=10.0,/floating,$
                                                                    /return_events)

    colorbase = widget_base(llb,/row)
    colorlabel = widget_label(colorbase,value='Color '+spn)
    self.ScanColorDrop = widget_combobox(colorbase,value=colornames)
    widget_control,self.ScanColorDrop,$
                   set_combobox_select=(pointnumber mod n_elements(colornames))


    ;EACH OBJECT WILL RETURN EVENTS TO THE CALLING PROGRAM WHICH WILL
    ;GET AN INDEX FROM THE OBJECT EVENT AND DECIDE WHICH OBJECT TO TELL ITSELF
    ;TO UPDATE.
    widget_control,llb,set_uvalue=self
    xmanager,'NSEScanPreview',llb,/no_block
    widget_control,llb,event_func = 'NSEScanPreview_event'

    ;xmanager,'NSEScanPreview',llb,
    return,1
end;NSEScanPreview:init


pro NSEScanPreview__define,class

    class = {NSEScanPreview,$
                inherits cwo_drawplot_data,$
                parent:0L,$
                parenttlb:0L,$
                PointNumber:0L,$
                tlb:0L,$
                ;FIELDS
                ScanlambdaField:0L,$
                ScanNarcsField:0L,$
                ScanQcenField:0L,$
                ScanXcenField:0L,$
                ScanYcenField:0L,$
                ScanVar1Field:0L,$  ;PLACEHOLDERS
                ScanVar2Field:0L,$
                ScanVar3Field:0L,$
                ScanColorDrop:0L,$
                ;VALUES
                ScanlambdaValue:0d,$
                ScanNarcsValue:0d,$
                ScanQcenValue:0d,$
                ScanXcenValue:0d,$
                ScanYcenValue:0d,$
                ScanVar1Value:0d,$  ;PLACEHOLDERS
                ScanVar2Value:0d,$
                ScanVar3Value:0d,$
                ;CALCULATED VALUES
                ScanQMin:0.0,$
                ScanQMax:0.0,$
                ScanQArcs:ptr_new()}


end;NSEScanPreview__define


pro NSEScanPreview_event,event

    ;print,'event.handler=',event.handler

    widget_control,event.handler,get_uvalue=pstate

    eventname = tag_names(event,/structure_name)
    
    NSEScanPreviewer_syncalldat,(*pstate).plotobj
    if strupcase(eventname) eq 'NSESCANPREVIEWEVENT' then begin

        
        if event.rangeupdate eq 1 then begin
            (*pstate).plotobj->defaultdraw
        endif else begin
            (*pstate).plotobj->draw
        endelse
    endif else begin
        (*pstate).plotobj->draw
    endelse

end;NSEScanPreview_event
pro NSEScanPreviewer_cleanup,id
    ;print,'NSEScanPreviewer_cleanup'
    widget_control,id,get_uvalue=pstate

    obj_destroy,(*pstate).plotobj

    ptr_free,pstate

end;NSEScanPreview_cleanup
pro NSEScanPreviewer_syncalldat,plotobj
  
  n = plotobj->count()
;  print,'n=',n
  
  ;UPDATE THE INDIVIDUAL CALCULATIONS BEFORE UPDATING THE COMPLETE SET.
  for i=0,n-2 do begin
    (plotobj->get(position=i))->calculate
  endfor;i

  (plotobj->get(position=0))->getProperty,ScanQArcs=scanQArcs

  if ptr_valid(scanQArcs) gt 0 then begin

  
    newx = *scanQArcs
;    print,'---'
;    print,0,newx
    allx = newx
    
    for i=1,n-2 do begin
      (plotobj->get(position=i))->getProperty,ScanQArcs=scanQArcs
      newx = *scanQArcs
      allx = [allx,newx]
    endfor;i
    d = plotobj->get(position=n-1)
    d->getproperty,x=x,y=y
    if ptr_valid(x) gt 0 then ptr_free,x
    if ptr_valid(y) gt 0 then ptr_free,y
    allx = allx[sort(allx)]
    ally = 0.0*allx
    d->setproperty,x=ptr_new(allx),y=ptr_new(ally)
    d->getproperty,x=x,y=y
   
  endif;ptr_valid


end;NSEScanPreviewer_syncalldat


pro NSEScanPreview,group_leader=group_leader,$
                   workdir=workdir,$
                   datadir=datadir,$
                   DAVETool=DAVETool,$
                   _Extra=extra

    if n_elements(group_leader) ne 0 then begin
        tb = widget_base(/col,title='NSE Scan Previewer',$
                              group_leader=group_leader)
    endif else begin
        tb = widget_base(/col,title='NSE Scan Previewer')
    endelse

    if n_elements(dataDir) eq 0 then dataDir = ''
    if n_elements(workDir) eq 0 then workDir = ''
    if n_elements(DAVETool) eq 0 then DAVETool = obj_new()

  

    ;print,'tb=',tb
    lb1 = widget_base(tb,/row)
    lb2 = widget_base(tb,/row)
;    container = obj_new('idl_container')

    maxscans = 5
    baselist = lonarr(maxscans)
    ;print,lb2
    plotid = cwo_drawplot(lb2,xsize=600,ysize=300,obj=obj,xtitle='Q',ytitle='Scan Number')
    ;print,plotid
    plotobj = obj

    for i = 0,maxscans-1 do begin
        o = obj_new('NSEScanPreview',lb1,i+1,tlb=tlb,parenttlb = tb,qcen = (i+1)*0.04)
        baselist[i] = tlb
        plotobj->add,o,position=i
    endfor;i

    ;CREATE A DATA OBJECT WITH ALL THE DATA POINTS INCLUDED
    alldat = obj_new('cwo_drawplot_data',color=0L,psym=2,showlegend=0)



    plotobj->add,alldat, position=maxscans

    NSEScanPreviewer_syncalldat,plotobj


    state = {plotid:plotid,plotobj:plotobj,baselist:baselist,$
             dataDir:dataDir,workDir:workDir,DAVETool:DAVETool}

    pstate = ptr_new(state)
    centertlb,tb
    widget_control,tb,/realize,set_uvalue=pstate
    xmanager,'NSEScanPreview',tb,event_handler='NSEScanPreview_event',$
             /no_block,cleanup='NSEScanPreviewer_cleanup'

end;NSEScanPreview


