; NAME:
; MSICS
; DATE of WORKING VERSION: 4 May 2006
;PD Dr. Philip Tregenna-Piggott,
;Laboratory for Neutron Scattering,
;ETHZ and Paul-Scherrer Institute,
;CH-5232 Villigen PSI,
;Switzerland.
;
;Tel. :+41 56 310 54 05
;Fax. :+41 56 310 29 39
;Email:philip.tregenna@psi.ch
;
;
; CATEGORY:
;
;       MARS Tools
;
; CALLING SEQUENCE:
;
;      msics
;
;
; INPUT FIELDS:
;
;
; EXAMPLES FOR POTENTIALS (must use IDL syntax as shown below):
;
;
; DISCLAIMER
;
;     This software is provided as is without any warranty whatsoever.
;     Permission to use, copy, modify, and distribute modified or
;     unmodified copies is granted, provided this disclaimer
;     is included unchanged.
;
; MODIFICATION HISTORY:
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;get sics functions and procedures
@idlsics
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msics_cleanup,tlb
widget_control,tlb,get_uvalue = pstate_msics
if (*pstate_msics).msicsstatus eq 1 then sicsclose,(*pstate_msics).unit
heap_free,pstate_msics
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msics_exit,event
widget_control,event.top,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msics_password_widget_event,event
widget_control,event.top,get_uvalue = pstate_msics1
uname=widget_info(event.id,/uname)
case uname of
'pass':    $
begin
        case event.type of
            0: begin            ; Insert Single Character
                (*pstate_msics1).password += string(event.ch)
            end
            1: begin            ; Insert Multiple Characters
                (*pstate_msics1).password += event.str
            end
            2: begin            ; Delete Text
                (*pstate_msics1).password = strmid((*pstate_msics1).password,0,event.offset)
            end
            3:                  ; Text Selection
        endcase
        len = strlen((*pstate_msics1).password)
        if ((len gt 0) && (event.type ne 3)) then $
          widget_control, event.id, set_value=strjoin(replicate('*',len)), set_text_select=[len,0]
    end
'ok':    $
begin
if (*pstate_msics1).password eq 'MARSLNS' then begin
widget_control,event.top,/destroy
endif else begin
widget_control, (*pstate_msics1).password_field,set_value=''
(*pstate_msics1).password=''
endelse
return
end
'cancel':    $
begin
(*pstate_msics1).password=''
widget_control,event.top,/destroy
return
end
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function msics_password_widget,group_leader = group_leader
if n_elements(group_leader) eq 0 then begin
  tlb = widget_base(/col,title = 'Password Protected',/tlb_frame_attr)
endif else begin
    tlb = widget_base(group_leader = group_leader, /col,/modal, $
        title = 'Password Protected',/tlb_frame_attr)
endelse
base = widget_base(tlb,/col,XSIZE=170)
password=''
;password_field= cw_field(base,/row,value = password,title = 'Enter Password',/all_events,uname='pass')
password_field = widget_text(base,uname='pass',value='',/editable,/all_events)

CancelButton = widget_button(base,value = 'Cancel',uname='cancel')
OKButton = widget_button(base,value = 'OK',uname='ok')
centertlb,tlb
widget_control,tlb,/realize

state1 = {CancelButton:CancelButton, $
       password_field:password_field, $
       password:password }
pstate_msics1 = ptr_new(state1,/no_copy)
widget_control,tlb,set_uvalue = pstate_msics1
xmanager,'msics_password_widget',tlb,event_handler = 'msics_password_widget_event'
password=(*pstate_msics1).password
ptr_free,pstate_msics1
return,password
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msics_issue,event
widget_control,event.top,get_uvalue = pstate_msics
if (*pstate_msics).msicsstatus eq 0 then return
unit=(*pstate_msics).unit
widget_control,(*pstate_msics).command,get_value = command
if command  eq '' then return
widget_control,(*pstate_msics).IssueButton,sensitive = 0
if command eq 'INT1712 3' then begin
response=sicsinterrupt(event,unit,Command)
endif else begin
response=sicsexecute(event,unit,Command)
widget_control,(*pstate_msics).response,set_value = response
print,'response = ',response
endelse
widget_control,(*pstate_msics).IssueButton,sensitive = 1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msics_Connect,event
widget_control,event.top,get_uvalue = pstate_msics
widget_control,(*pstate_msics).connectbutton,sensitive = 0
delim=path_sep()
;
;filename='C:\Documents and Settings\tregenna\My Documents\NIST\DAVE\cvs_nist\dave\programs\auxiliary\PSI\MARS\MarsSICSInfo.txt'
filename=!DAVE_AUXILIARY_DIR+'PSI'+delim+'MARS'+delim+'MarsSICSInfo_Manager.txt'
hoststring=''
portstring=''
userstring=''
passwordstring=''
openr,lun,filename,/get_lun
readf,lun,hoststring
readf,lun,portstring
readf,lun,userstring
readf,lun,passwordstring
free_lun,lun,/force
;
equalsign=strpos(hoststring,'=')
host=strmid(hoststring,equalsign+1)
equalsign=strpos(portstring,'=')
port=strmid(portstring,equalsign+1)
port=long(port)
equalsign=strpos(userstring,'=')
user=strmid(userstring,equalsign+1)
equalsign=strpos(passwordstring,'=')
password=strmid(passwordstring,equalsign+1)
;
get_lun,unit
(*pstate_msics).unit=unit
;
response=sicsconnect(unit,host,port,error=error)
    IF response eq 0 then begin
; the program is not running in demonstration mode
print,'Connection Successful'
(*pstate_msics).msicsstatus=1
logon=sicslogon(unit,user,password)
if logon eq 0 then begin
void = dialog_message(dialog_parent = event.top, $
'SICS Manager login is incorrect. Please inspect and edit the file ' +  $
'in the Dave auxillary directory.  The program will now exit.')
msics_exit,event
return
endif
    ENDIF ELSE BEGIN
    void = dialog_message(dialog_parent = event.top,/error, $
    'Connection to SICS not available.')
(*pstate_msics).msicsstatus=0
    ENDELSE

widget_control,(*pstate_msics).connectbutton,sensitive = 1

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro msicsEvents,event
widget_control,event.top,get_uvalue = pstate_msics
uname=widget_info(event.id,/uname)
case uname of
'Connect':   $
begin
msics_Connect,event
end
'Issue':   $
begin
msics_issue,event
end
'command':   $
begin
msics_issue,event
end
'Exit':   $
begin
msics_exit,event
end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro marssics, group_leader=group_leader, workDir=workDir, dataDir=dataDir, $
              DAVETool=oDAVETool, _EXTRA=extra

;print,'Register Name =',register_name
if n_elements(group_leader) eq 0 then group_leader = 0L
if n_elements(register_name) eq 0 then register_name = 'MarsSics'
if xregistered(register_name) then return

tlb = widget_base(/row,group_leader = group_leader,title = 'Issue SICS Command for MARS Instrument')

BaseLeft=widget_base(tlb,/col)
BaseRight=widget_base(tlb,/col)
;

ConnectButton = widget_button(BaseLeft,value = 'Connect', uname='Connect')
IssueButton = widget_button(BaseLeft,value = 'Issue Command', uname='Issue')
ExitButton = widget_button(BaseLeft,value = 'Exit', uname='Exit')

command=cw_field(BaseRight,xsize=50,/col,title='Command',value='', uname='command',/return_events)
response=cw_field(BaseRight,xsize=50,/col,title='Response',value='',/noedit)

centertlb,tlb
widget_control,tlb,/realize
;
;
state = { ConnectButton:ConnectButton, $
       IssueButton:IssueButton, $
       command:command, $
       response:response, $
       msicsstatus:0, $
       unit:1}


pstate_msics = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate_msics

daveDeSensitizeButtons,{id:0,top:tlb,handler:1,select:1}
password=msics_password_widget(group_leader = tlb)
if password ne 'MARSLNS' then begin
msics_cleanup,tlb
msics_exit,{id:0,top:tlb,handler:1,select:1}
return
endif else begin
daveSensitizeButtons,{id:0,top:tlb,handler:1,select:1}
endelse


xmanager,register_name,tlb,event_handler = 'msicsEvents',cleanup= 'msics_cleanup'

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;