 ; $Id$



function MACSRunner_v1_getExt,s,iext=iext,len=len,base=base
        if n_elements(s) eq 0 then return,''
        iext = strpos(s,'.',/reverse_search)
;print,iext
        if (iext ne -1) and (iext-strlen(s) lt 10) then begin
            len  = strlen(s)
            ext  = strmid(s,iext+1,len-iext)
            base  = strmid(s,0,iext)
            ;print,ext
            ;print,base
        endif else begin
            ext = ''
            base=s
        endelse
        return,ext

end;MACSRunner_v1_getExt
pro MACSRunner_v1_addDotEXT,ofn,newext
        ext = MACSRunner_v1_getExt(ofn,iext=iext,len=len,base=base)
        ofn = base+'.'+newext
end;MACSRunner_v1_addDotEXT

;SPECIAL SUMMER SCHOOL PLOTTING PROGRAM
pro MACSRunner_v1_plotpcupzn,event,file_in


srcDir = !DAVE_DIR
auxdir = srcDir+path_sep()+'auxiliary'+path_sep()
file_in = auxdir + 'CuPzN_1p6K_BGsub.dat'
if file_test(file_in) eq 0 then begin
  void = dialog_message('Cannot locate the data file, please help me: ')
  file_in = dialog_pickfile(title='Locate file CuPzN_1p6K_BGsub.dat :')
endif

if file_in eq '' then begin
endif else begin

    total_lines=file_lines(file_in)
    
    print,total_lines
    all_data=fltarr(5,total_lines-29)
    
    openr,lun,file_in,/get_lun
    readf,lun,all_data
    free_lun,lun
    ;print,all_data
    xdata=transpose(all_data[0,*])
    ydata=transpose(all_data[1,*])
    zdata=transpose(all_data[2,*])
    zerr=transpose(sqrt(all_data[2,*]))
    
          data=[[zdata],[zerr],[xdata],[ydata]]
    
          label  = ['I','dI','q/(2*PI)','hw (meV)']
             unit   = ['','','','']
              instrument = 'MACS-1'
              dataPtr = ptr_new({data:data,label:label,unit:unit,instrument:instrument})

              widget_control,event.top,get_uvalue=pstate
              workdir = (*pstate).workDir
              dataDir = (*pstate).dataDir
              group_leader = (*pstate).tlb
              daveTool = (*pstate).daveTool
              
              obj_mslice = obj_new('dcs_mslice', dataPtr=dataPtr, $
                            group_leader=group_leader,$
                            workDir=workDir,dataDir=dataDir,DAVETool=DAVETool)


  endelse
end;MACSRunner_v1_plotpcupzn
;SPECIAL SUMMER SCHOOL PLOTTING PROGRAM
pro MACSRunner_v1_plotpcupzn2,event,file_in


srcDir = !DAVE_DIR
auxdir = srcDir+path_sep()+'auxiliary'+path_sep()
file_in = auxdir + 'CuPzN_1p6K_fold_summer school.dat'
if file_test(file_in) eq 0 then begin
  void = dialog_message('Cannot locate the data file, please help me: ')
  file_in = dialog_pickfile(title='Locate file CuPzN_1p6K_BGsub.dat :')
endif

if file_in eq '' then begin
endif else begin

    total_lines=file_lines(file_in)
    
    print,total_lines
    all_data=fltarr(5,total_lines-29)
    
    openr,lun,file_in,/get_lun
    readf,lun,all_data
    free_lun,lun
    ;print,all_data
    xdata=transpose(all_data[0,*])
    ydata=transpose(all_data[1,*])
    zdata=transpose(all_data[2,*])
    zerr=transpose(sqrt(all_data[2,*]))
    
          data=[[zdata],[zerr],[xdata],[ydata]]
    
          label  = ['I','dI','q/(2*PI)','hw (meV)']
             unit   = ['','','','']
              instrument = 'MACS-1'
              dataPtr = ptr_new({data:data,label:label,unit:unit,instrument:instrument})

              widget_control,event.top,get_uvalue=pstate
              workdir = (*pstate).workDir
              dataDir = (*pstate).dataDir
              group_leader = (*pstate).tlb
              daveTool = (*pstate).daveTool
              
              obj_mslice = obj_new('dcs_mslice', dataPtr=dataPtr, $
                            group_leader=group_leader,$
                            workDir=workDir,dataDir=dataDir,DAVETool=DAVETool)


  endelse
end;MACSRunner_v1_plotpcupzn2


pro reformJeff

;  fn = ['C:\Documents and Settings\kneller\Desktop\Data\Jeff\T4K_3column_E_Q_Int.txt',$
;        'C:\Documents and Settings\kneller\Desktop\Data\Jeff\T300K_3column_E_Q_Int.txt']
;
;  davefn = ['C:\Documents and Settings\kneller\Desktop\Data\Jeff\T4K_3column_E_Q_Int.dave',$
;        'C:\Documents and Settings\kneller\Desktop\Data\Jeff\T300K_3column_E_Q_Int.dave']
;
;;  fn = dialog_pickfile(filter='*.txt',/multi,path = file_dirname(fn1))
;;  print,fn
;  
;  for i=0,n_elements(fn)-1 do begin
;    nlines = file_lines(fn[i])
;    s = strarr(nlines)
;    a = fltarr(3,nlines-1)
;    
;    openr,lun,fn[i],/get_lun
;    readf,lun,s
;    free_lun,lun
;    help,s
;    
;    for j=1,nlines-1 do begin
;      segs = strsplit(s[j],/extract)
;      duh = float(segs)
;      ;help,duh,file_basename(fn[i])      
;      ;if n_elements(segs) ne 3 then help,segs
;      ;help,float(segs)
;      a[*,j-1] = float(segs)      
;    endfor;j
;    u = [-1,uniq(reform(a[0,*],nlines-1))];,nlines-2]
;;    print,s[0]
;;    print,u,a[0,0],a[0,u[0]+1]
;    y = reform(a[0,u[1:n_elements(u)-1]],n_elements(a[0,u[1:n_elements(u)-1]]))
;    x = reform(a[1,0:u[1]],n_elements(a[1,0:u[1]]))
;    dat = fltarr(n_elements(x),n_elements(y))
;    for k=0,n_elements(u)-2 do begin
;      ;print,a[0,u[k]+1],a[0,u[k+1]-1]; < nlines-2]
;      dat[*,k] = a[2,u[k]+1:u[k+1]]
;    endfor;k
;    print,transpose(y)
;    print,x[0],x[n_elements(x)-1]
;    err = dat
;    help,dat,err,x,y
;    segs = strsplit(s[0],/extract)
;    ylabel = segs[0]
;
;    xlabel = segs[1]
;    qtylabel = segs[2] 
;    wh = where(dat eq -1e+20,count)
;    if count ne 0 then begin
;      dat[wh] = 1.0e-20
;      err[wh] = 1.0
;    endif 
;   
;
;ret_val = CREATE_DAVE_POINTER(  $
;               DAVEPTR ,         $
;               INSTRUMENT = 'ARCS',  $
;               QTY = dat,          $
;               QTLABEL = qtylabel,      $
;               ERR = err,          $
;               XVALS = x,        $
;               XLABEL = xlabel,      $
;               YVALS = y,        $
;               YLABEL = ylabel)
;
;  save,davePtr,filename=davefn[i]
;  ptr_free,davePtr
;
;    ;print,u
;  endfor;i

end;reformJeff
;###############################################################################
function MACSRunner_v1_Qxy_to_hkl,Qxy,a,b,c,alpha,beta,gamma,o1,o2,qmag=qmag

    ;FOR MOUSE INTERACTIONS IN THE SCATTERING PLANE:

    ;GIVEN Qxy THIS GIVES THE hkl VALUES FOR A POINT IN THE SCATTERING
    ;PLANE.  THIS WILL BE EXTREMELY USEFUL WHEN THE USER WANTS TO
    ;SELECT A POINT IN THE SCATTERING PLANE WITH THE MOUSE AND
    ;HAVE THE PROGRAM PRODUCE Q,ki,kf, AND OTHER ITEMS.


    ;ADD A zero IN THE Z COMPONENT IF ONLY x,y, COMPONENTS SPECIFIED.
    ;if n_elements(Qxy) eq 2 then Q = [Qxy,0.0] else Q = Qxy

    sz = size(Qxy)
    if sz[0] eq 1 then begin
      tempQxy = dblarr(3,1)
    endif else begin
      tempQxy = dblarr(3,sz[2])
    endelse 
    if sz[1] eq 2 then tempQxy[0:1,*] = Qxy
    if sz[1] eq 3 then tempQxy[*,*] = Qxy



;1) ;GET RECIPROCAL LATTICE VECTORS
    val = recip_lattice(a,b,c,alpha,beta,gamma)
    b1    = val.b123.b1
    b2    = val.b123.b2
    b3    = val.b123.b3


;2) ;GET o1vec,o2vec IN 1/ang
;THE FOLLOWING SETS THE AXES ALONG o1,o2
    o1vec = (o1[0]*b1 + o1[1]*b2 + o1[2]*b3)
    o2vec = (o2[0]*b1 + o2[1]*b2 + o2[2]*b3)
    mago1vec = sqrt(dotp(o1vec,o1vec))
    mago2vec = sqrt(dotp(o2vec,o2vec))

;3) ; GET UNIT VECTORS ALONG o1,o2
    ;CREATE UNIT VECTORS ALONG THE o1,o2 DIRECTIONS ---  THIS SHOULD NOT BE USED IN
    xhat_o1 = o1vec/mago1vec                            ;GENERAL SINCE THEY ARE ALONG
    yhat_o2 = o2vec/mago2vec                            ;THE ORIENTATION VECTOR DIRECTIONS
                                                        ;AND MAY NOT BE ORTHOGONAL.

;4) DEFINE  xhat,yhat, UNIT VECTORS IN THE SCATTERING PLANE
;           zhat       PERPENDICULAR TO THE SCATTERING PLANE
    xhat = xhat_o1
    xhat = xhat/sqrt(dotp(xhat,xhat))
    zhat = crossp(xhat_o1,yhat_o2)
    zhat = zhat/sqrt(dotp(zhat,zhat))
    yhat = crossp(zhat,xhat)
    yhat = yhat/sqrt(dotp(yhat,yhat))

    ;NOW GET xhat,yhat IN hkl
;5) GET THE hkl VALUES FOR xhat,yhat SO INDICES DESCRIBE THE UNIT VECTORS
    xhat_hkl = LK_cramer(b1,b2,b3,xhat)
    yhat_hkl = LK_cramer(b1,b2,b3,yhat)
    zhat_hkl = LK_cramer(b1,b2,b3,zhat)

    Qhkl = tempQxy
    tempH = tempQxy[0,*]*xhat_hkl[0] + tempQxy[1,*] * yhat_hkl[0] + tempQxy[2,*]*zhat_hkl[0]
    tempK = tempQxy[0,*]*xhat_hkl[1] + tempQxy[1,*] * yhat_hkl[1] + tempQxy[2,*]*zhat_hkl[1]
    tempL = tempQxy[0,*]*xhat_hkl[2] + tempQxy[1,*] * yhat_hkl[2] + tempQxy[2,*]*zhat_hkl[2]

    Qhkl[0,*] = tempH 
    Qhkl[1,*] = tempK 
    Qhkl[2,*] = tempL 

    qmag = 0.0*reform(qhkl[0,*],n_elements(qhkl[0,*]))
    ;for i=0,n_elements(qmag)-1 do begin
      ;q = h*b1+k*b2+l*b3
      q0 = temph*b1[0] + tempk*b2[0] + templ*b3[0]
      q1 = temph*b1[1] + tempk*b2[1] + templ*b3[1]
      q2 = temph*b1[2] + tempk*b2[2] + templ*b3[2]
      qmag = sqrt(q0^2 + q1^2 + q2^2)
      ;help,q0,q1,q2,qmag,qhkl
    ;endfor;i
    
;LRK - 11/24/10    
;SEE THE PRO ABOVE CALLED reformJeff FOR AN APPROACH TO SORTING AND AVERAGING
;THE POWDER DATA


    return,Qhkl
end;MACSRunner_v1_Qxy_to_hkl
;###############################################################################
function MACSRunner_v1_calc_Q,ki,kf,A4
;print,'RUNNING calc_Q'
    A4deg = A4
;print,'test'


    dum = clearjunk(1)
    dum = clearjunk([1,1])
    dum = clearjunk([1,1,1])

    i = calc_kpara(ki)
    f = calc_kf(kf,A4)

    A4 = !dtor*A4deg

    return, i - f
end;calc_Q



function MACSRunner_v1_ConvertToHKL,Qxy,pstate,qmag=qmag
 
  ;widget_control,event.handler,get_uvalue=pstate
 
 
  catch,es
  if es ne 0 then begin
    errormsg = ['The following problem occurred in MACSRunner_v1_convertToHKL:',!error_state.msg]
    void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)  
    catch,/cancel
    return,-1
  endif;catch   

       (*pstate).projObject->getProperty,$
                                        ;lattice=lattice,$
                                        abc=abc,abg=abg,$
                                        orientation=orientation,$
                                        ;xscale=xscale,$ ;IGNORE  ---- THESE SCALES SHOULD BE FIXED BEFORE COMING HERE
                                        ;yscale=yscale,$ ;IGNORE
                                        qrotationAngle=qRotationAngle,$ ;IGNORE   --THIS SHOULD NOT BE IMPLEMENTED BEFORE COMING HERE
                                        sendHKLtoMslice=sendHKLtoMSlice,$ ;IGNORE   --THIS IS THE FLAG TO BRING EXECUTION TO HERE.
                                        point_by_point=point_by_point
;03/16/11
;I COULD DO THE ROTATION HERE.  IT MUST BE DONE BEFORE COMPUTING Qhkl FOR THE ROTATION
;TO BE APPLIED TO THE HKL DATA.
;
;
;BUT I HAVE TO MAKE SURE I DON'T APPLY IT TWICE!!!

qxynew = qxy

                  thetaRot = !dtor*qRotationAngle
                  qxRot = cos(thetaRot)*qxy[0,*] + sin(thetaRot)*qxy[1,*]
                  qyRot = -sin(thetaRot)*qxy[0,*] + cos(thetaRot)*qxy[1,*]
qxynew[0,*] = qxrot
qxynew[1,*] = qyrot


  a = abc[0]
  b = abc[1]
  c = abc[2]
  alpha = abg[0]
  beta  = abg[1]
  gamma = abg[2]
  o1 = orientation[0:2]
  o2 = orientation[3:5]

  Qhkl = MACSRunner_v1_Qxy_to_hkl(Qxynew,a,b,c,alpha,beta,gamma,o1,o2,qmag=qmag)  

  return,Qhkl

end;MACSRunner_v1_ConvertToHKL


pro MACSRunner_v1_sortContainer,c

  ;GET SORTING PARAMETER
  if c->count() eq 0 then begin
    return
  endif else begin

    list = strarr(c->count())
    for i=0L,c->count()-1L do begin
      list[i] = file_basename((c->get(position=i))->filename())
    endfor;i
                
      
    ;CREATE SORT ORDER ARRAY
    order = sort(list)
    sortedlist = list[order]
      
    ;COPY ALL INDICES TO AN obj_array
    oarr = objarr(c->count())
    for i=0L,c->count()-1L do begin
      oarr[i] = c->get(position=i)
    endfor;i

        
    ;REMOVE ALL OBJECTS FROM CONTAINER
    c->remove,/all
        
        
    ;PLACE OBJECTS INTO CONTAINER IN CORRECT ORDER 
    for i=0L,n_elements(oarr)-1L do begin
      c->add,oarr[order[i]],position=i
    endfor;i
      
      
  endelse

end;MACSRunner_v1_sortContainer


pro MACSRunner_v1_updateList,c,l

      if c->count() gt 0 then begin
        list = strarr(c->count())
        for i=0,c->count()-1 do begin
          list[i] = file_basename((c->get(position=i))->filename())
        endfor;i
        widget_control,l,set_value=list
        widget_control,l,set_uvalue=n_elements(list)
      endif else begin
        widget_control,l,set_value=['']
        widget_control,l,set_uvalue=-1
      endelse

end;MACSRunner_v1_updateList

pro MACSRunner_v1_updateProjList,c,l

    nproj = c->count()

    if nproj gt 0 then begin
    
      flist = ''
      for i=0,nproj-1 do begin
        tmp = c->get(position=i)
        tmp->getProperty,name=name
        ;print,name
        flist = [flist,name]
      endfor;i
      if n_elements(flist) gt 1 then flist = flist[1:*]
      widget_control,l,set_value=flist
    endif

end;MACSRunner_v1_updateProjList

pro MACSRunner_v1_handleProjectList,pstate

      if (*pstate).projcontainer->count() gt 0 then begin
          ;GET NEW SELECTION
          sel = widget_info((*pstate).projlist,/list_select)
          if sel[0] eq -1 then sel = 0
          
          p = (*pstate).projcontainer->get(position=sel[0])
    
          ;UPDATE PROPERTY SHEET
          widget_control,(*pstate).propertysheet,set_value=p
    
          ;UPDATE CONTAINERS
          (*pstate).projObject = p
          dc = p->get(position=0)
          bc = p->get(position=1)
          ec = p->get(position=2)
          bec = p->get(position=3)
          (*pstate).datacontainer = dc
          (*pstate).bkgcontainer = bc
          (*pstate).emptycontainer = ec
          (*pstate).bgemptycontainer = bec
    
          ;UPDATE LISTS
          MACSRunner_v1_sortContainer,(*pstate).datacontainer
          MACSRunner_v1_updateList,(*pstate).datacontainer,(*pstate).datalist
    
          MACSRunner_v1_sortContainer,(*pstate).bkgcontainer
          MACSRunner_v1_updateList,(*pstate).bkgcontainer,(*pstate).bkglist
    
          MACSRunner_v1_sortContainer,(*pstate).emptycontainer      
          MACSRunner_v1_updateList,(*pstate).emptycontainer,(*pstate).emptylist      
    
          MACSRunner_v1_sortContainer,(*pstate).bgemptycontainer      
          MACSRunner_v1_updateList,(*pstate).bgemptycontainer,(*pstate).bgemptylist      

          MACSRunner_v1_updateProjList,(*pstate).ProjContainer,(*pstate).projList

          macsrunner_v1_setUpProjectPropertySheet,{handler:(*pstate).tlb}

          
          widget_control,(*pstate).projList,set_list_select=sel[0]

      endif $;count gt 0
      else begin
          
      endelse
end;MACSRunner_v1_handleProjectList

pro MACSRunner_v1_restoreSession,pstate

    fn = dialog_pickfile(title='Select Save File:',dialog_parent=(*pstate).tlb,$
                         path=(*pstate).workDir,/read,filter='*.sav')    
    if fn[0] ne '' then begin
      (*pstate).workdir = file_basename(fn[0])
      restore,fn,/relaxed_structure_assignment,restored_objects = o
      for i=0,n_elements(o)-1 do begin
         help,o[i]
         if obj_isa(o[i],'MACSRunner_v1_data') or $
            obj_isa(o[i],'MACSRunner_v1_project') or $
            obj_isa(o[i],'IDLitComponent') then begin
              o[i]->restore
          endif
      endfor;i
      if obj_valid(projcontainer) ne 0 then begin    
        (*pstate).projContainer=projcontainer
        MACSRunner_v1_handleProjectList,pstate        
      endif else begin
        void = dialog_message('Invalid session file.',dialog_parent=(*pstate).tlb)
      endelse
    endif

end;MACSRunner_v1_restoreSession

pro MACSRunner_v1_saveSession,pstate

    fn = dialog_pickfile(title='Session Save File:',dialog_parent=(*pstate).tlb,$
                         path=(*pstate).workDir,/write,/overwrite_prompt)
    if fn[0] ne '' then begin
     (*pstate).workdir = file_dirname(fn[0])    
      MACSRunner_v1_addDotExt,fn,'sav'
      projcontainer = (*pstate).projContainer
      save,projcontainer,filename=fn
      (*pstate).workdir = file_dirname(fn)
    endif

end;MACSRunner_v1_saveSession


pro MACSRunner_v1_viewContents,pstate,data=data,bkg=bkg,empty=empty,bgempty=bgempty

  if n_elements(data) eq 0 then data = 0
  if n_elements(bkg) eq 0 then bkg = 0
  if n_elements(empty) eq 0 then empty = 0
  if n_elements(bgempty) eq 0 then bgempty = 0

  if data eq 1 then begin
    c = (*pstate).dataContainer
    l = (*pstate).datalist
  endif  
  if bkg eq 1 then begin
    c = (*pstate).bkgContainer
    l = (*pstate).bkglist
  endif  
  if empty eq 1 then begin
    c = (*pstate).emptyContainer
    l = (*pstate).emptylist
  endif  
  if bgempty eq 1 then begin
    c = (*pstate).bgemptyContainer
    l = (*pstate).bgemptylist
  endif  

  sel = widget_info(l,/list_select)
  if sel[0] eq -1 then begin
    widget_control,(*pstate).text,set_value=['No file selected.']
    return
  endif
  if n_elements(sel) gt 1 then begin
    widget_control,(*pstate).text,set_value=['Select only one file to display.']
    return
  endif
  if n_elements(sel) eq 1 then begin
    o = c->get(position=sel[0])
    s = ['*****  IN FILE = '+o->filename()+'   *******',o->contents()]
    widget_control,(*pstate).text,set_value=s
    xdisplayfile,text=o->contents(),$
                 title='MACSRunner_v1: '+file_basename(o->filename()),$
                 /block,$
                 group=(*pstate).tlb

  endif

end;MACSRunner_v1_viewContents
pro MACSRunner_v1_sliceDiff,pstate,mlice=mslice,$
                              quickslice=quickslice,$
                              writeMslice=writeMslice,$
                              statusString=statusString,$
                              msliceChoice=msliceChoice,$
                              MslicePowder=MslicePowder,$
                              msliceKeep=msliceKeep,$                              
                              no_plot=no_plot,$
                              summerSchool=summerSchool

 
    ;widget_control,event.handler,get_uvalue=pstate
    catch,es
    if es ne 0 then begin
      errormsg = ['The following problem occurred in MACSRunner_v1_SliceDiff:',!error_state.msg]
      void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)                
      catch,/cancel
      nse_cleanupProgressWindows
      return
    endif;catch        

    if n_elements(mslicekeep) eq 0 then mslicekeep = 0
    if n_elements(SummerSchool) eq 0 then SummerSchool = 0
;print,'summerSchool=',summerSchool

    if (*pstate).dataContainer->count() gt 0 then begin ;1
;print,'DIFF______________________________________________________'
      
      
      (*pstate).projObject->getProperty,zmindiff=zmindiff,zmaxdiff=zmaxdiff,$
                                        zminspec=zminspec,zmaxspec=zmaxspec,$
                                        PTAIBinSize=PTAIBinSize,$
                                        A2BinSize=A2BinSize,$
                                        A3Binsize=A3Binsize,$
                                        kidneybinsize=kidneybinsize,$
                                        A5Binsize=A5Binsize,$
                                        $
                                       sE_PTAIbinsize=sE_PTAIbinsize,$
                                       sE_A5binsize=sE_A5binsize, $
                                       sE_A2binsize=sE_A2binsize, $
                                       sE_A3binsize=sE_A3binsize, $
                                       sE_Kidneybinsize=sE_Kidneybinsize,$
                                       $
                                       BE_PTAIbinsize=BE_PTAIbinsize,$
                                       BE_A5binsize=BE_A5binsize, $
                                       BE_A2binsize=BE_A2binsize, $
                                       BE_A3binsize=BE_A3binsize, $
                                       BE_Kidneybinsize=BE_Kidneybinsize,$
                                        $
                                        xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                        ColorTable=ColorTable,$
                                        xTitle=xTitle,$
                                        yTitle=yTitle,$
                                        charsize=charsize,$
                                        grain=grain,$
                                        diffweights=diffweights,specweights=specweights,$
                                        diffMask=diffMask,specMask=specMask,$
                                        lattice=lattice,orientation=orientation,$
                                        xscale=xscale,$
                                        yscale=yscale,$
                                        datascalefactor=datascalefactor,$
                                        bkgscalefactor=bkgscalefactor,$
                                        emptyscalefactor=emptyscalefactor,$
                                        bg_emptyscalefactor=bg_emptyscalefactor,$
                                        white=white,$
                                        no_norm=no_norm,$
                                        invert=invert,$
                                        xabs=xabs,$
                                        yabs=yabs,$
                                        n_fold=n_fold,$
                                        a3ran=a3ran,$
                                        a4ran=a4ran,$
                                        a3_mask=a3_mask,$
                                        a4_mask=a4_mask,$
                                        a3shift=a3shift,$
                                        qrotationAngle=qRotationAngle,$
                                        point_by_point=point_by_point,$
                                        ei=eidiff,ef=efdiff,$  ;LRK - 11/12/10
                                        sendHKLtoMslice=sendHKLtoMSlice,$
                                        name=projectName
                                        





      
      ;GET THE DETECTORS TO EXCLUDE FROM DIFF AND SPEC
      lattice = [xscale,yscale]
      
      diffExclude = where(diffMask eq 0,diffcount)                                          
      ;if diffcount gt 0 then $ 
      diffExclude = diffExclude + 1 ;SHIFT BY 1 FOR 1-BASED LABELING of DETS; IF NOTHING MATCHES, diffExclude=0

      specExclude = where(specMask eq 0,speccount)                                          
      ;if speccount gt 0 then $
      specExclude = specExclude + 1 ;SHIFT BY 1 FOR 1-BASED LABELING of DETS; IF NOTHING MATCHES, specExclude=0


;LRK 10/28/2010
;CHANGE THIS TO USE ALL ITEMS IN THE CONTAINERS
;SELECTION WILL ONLY BE USER FOR REMOVAL AND VIEWING
;      sel = widget_info((*pstate).datalist,/list_select)
;      
;      if sel[0] eq -1 then begin
;        void = dialog_message('No data selected!',dialog_parent=(*pstate).tlb)
;      endif else begin

        ;fn1 = strarr(n_elements(sel))
        fn1 = strarr((*pstate).dataContainer->count())
        for i=0,n_elements(fn1)-1 do begin
;          ((*pstate).dataContainer->get(position=sel[i]))->getProperty,filename=filename
          ((*pstate).dataContainer->get(position=i))->getProperty,filename=filename
          fn1[i] = filename
        endfor;i


;        bsel = widget_info((*pstate).bkglist,/list_select)
;        esel = widget_info((*pstate).emptylist,/list_select)
;        besel = widget_info((*pstate).bgemptylist,/list_select)

;        if bsel[0] ne -1 then begin
;          bfn = strarr(n_elements(bsel))
          bcount = (*pstate).bkgContainer->count()
          if bcount gt 0 then begin
            bfn = strarr(bcount)
            for i=0,n_elements(bfn)-1 do begin
  ;            ((*pstate).bkgContainer->get(position=bsel[i]))->getProperty,filename=filename
              ((*pstate).bkgContainer->get(position=i))->getProperty,filename=filename
              bfn[i] = filename
            endfor;i
  ;        endif;bsel
         endif;bcount
         
         
;        if esel[0] ne -1 then begin
;          efn = strarr(n_elements(esel))
          ecount = (*pstate).emptyContainer->count()
          if ecount gt 0 then begin
            efn = strarr(ecount)
            for i=0,n_elements(efn)-1 do begin
  ;            ((*pstate).emptyContainer->get(position=esel[i]))->getProperty,filename=filename
              ((*pstate).emptyContainer->get(position=i))->getProperty,filename=filename
              efn[i] = filename
            endfor;i
  ;        endif
          endif;ecount
        
;        if besel[0] ne -1 then begin
;          befn = strarr(n_elements(besel))
        bgecount = (*pstate).bgemptyContainer->count()
        if bgecount gt 0 then begin
          befn = strarr(bgecount)
          for i=0,n_elements(befn)-1 do begin
;            ((*pstate).bgemptyContainer->get(position=besel[i]))->getProperty,filename=filename
            ((*pstate).bgemptyContainer->get(position=i))->getProperty,filename=filename
            befn[i] = filename
          endfor;i
;        endif
        endif;bgecount


        device,get_decomposed=dc
        device,decomposed=0
        tvlct,rsave,gsave,bsave,/get
        loadct,ColorTable



        if (msliceChoice eq 1) or $ ;DIFFRACTION
           (msliceChoice eq 2) or $ ;POWDER
           (msliceChoice eq -1)  then begin ;QUICKSLICE

    
            if no_plot eq 0 then begin                       
              wset,(*pstate).winpixDiff
            endif
            bgbinsize = [PTAIBinSize,A2BinSize,A3Binsize,kidneybinsize,A5Binsize]
            fg_mtbinsize = [SE_PTAIBinSize,SE_A2BinSize,SE_A3Binsize,SE_kidneybinsize,SE_A5Binsize]
            bg_mtbinsize = [BE_PTAIBinSize,BE_A2BinSize,BE_A3Binsize,BE_kidneybinsize,BE_A5Binsize]
            ;print,'bgbinsize=',bgbinsize

            devs=['PTAI', 'A2', 'A3', 'Kidney', 'A5']
            usedevs = devs
            usebgbinsize = bgbinsize


;LRK - 040411
;
;IT SEEMS LIKE THIS WILL BE PROBLEMATIC IF THE USERS CHOOSE
;TO HAVE MORE DEVICES SELECTED FOR ONE CASE VS ANOTHER.
;
;I"M NOT SURE HOW TO HANDLE THIS SINCE THEY WANT THE FLEXIBILITY TO USE
;DIFFERENT TOLERANCES (BINSIZES) FOR EMPTY AND BG SUBTRACTIONS.
;
;AT THIS POINT I WILL RELY ON GOOD DECISION MAKING BY THE USERS.
;
;
            ;devsSelect = where(bgbinsize lt 1000.0 and bgbinsize gt 0,devsSelectCount)
            devsSelect = where(bgbinsize gt 0,devsSelectCount)
            if devsSelectCount gt 0 then begin
              usedevs = devs[devsSelect]
              usebinsize = bgbinsize[devsselect]
              usebgbinsize = bgbinsize[devsselect]
              usefg_mtbinsize = fg_mtbinsize[devsselect]
              usebg_mtbinsize = bg_mtbinsize[devsselect]
            endif
            fgmtdevsSelect = where(fg_mtbinsize gt 0,fgmtdevsSelectCount)
            if fgmtdevsSelectCount gt 0 then begin
              ;usedevs = devs[devsSelect]
              usefg_mtbinsize = fg_mtbinsize[fgmtdevsselect]
            endif
            bgmtdevsSelect = where(bg_mtbinsize gt 0,bgmtdevsSelectCount)
            if devsSelectCount gt 0 then begin
              ;usedevs = devs[devsSelect]
              usebg_mtbinsize = bg_mtbinsize[bgmtdevsselect]
            endif
;help,usebinsize,usebgbinsize,usefg_mtbinsize,usebg_mtbinsize
;            print,'**************************************'
;            print,'usedevs=',usedevs
;            print,'**************************************'

qfold=0
            
            ;DIFF DETECTORS
            vmacs_qmap,fn1,bgfil=bfn,$
                           qfold=qfold,$
                             ki_kf_cos_tt=ki_kf_cos_tt,$ ;SUMMER SCHOOL 
                             summerSchool=summerSchool,$
                           devs=useDevs,$;['PTAI', 'A2', 'A3', 'Kidney', 'A5'],$
                           binsz=usebinsize,$;usebgbinsize,$       
                           bgbinsz=usebgbinsize,$
                           fg_mtbinsz=usefg_mtbinsize,$;fg_mtbinsize,$;usebgbinsize, $
                           bg_mtbinsz=usebg_mtbinsize,$;bg_mtbinsize,$;usebgbinsize, $
                           fgsc=datascalefactor,$ 
                           bgsc=bkgscalefactor,$ 
                           fg_mtsc=emptyscalefactor,$ 
                           bg_mtsc=bg_emptyscalefactor,$
                           weights=diffweights,$;specweights=specweights,$
                           Mask=diffExclude,$;diffMask,$
                           lattice=lattice,$
                           orientation=orientation,$
                           fg_mtfil=efn, bg_mtfil=befn,$
                           qx=qx, qy=qy, rint=rint, drint=drint, avhw=avhw, hw=hw,$
                           ei=eidiff,ef=efdiff,$  ;LRK - 10/07/10
                           xr = [xmin,xmax], yr = [ymin,ymax],zran=[zmindiff,zmaxdiff],$
                           xTit=xTitle,$
                           yTit=yTitle,$
                           chars=charsize,$
                           grain=grain,$
                           white=white,$
                           no_plot=no_plot,$
                           subtitle='DIFF',$
                           no_norm=no_norm,$
                           invert=invert,$
                           xabs=xabs,$
                           yabs=yabs,$
                           n_fold=n_fold,$                             
                           dataRange=DiffDataRange,$
                           a3ran=a3ran,$
                           a4ran=a4ran,$
                           a3_mask=a3_mask,$
                           a4_mask=a4_mask,$
                           a3shift=a3shift,$
                           pbpsub=point_by_point,$                         
                           /difdet,$
                           /no_concat

            
print,'POINT_BY_POINT=',point_by_point

            statusString = [statusString,'diffMin='+string(DiffDataRange[0]),'diffMax='+string(DiffDataRange[1])]
            statusString = [statusString,'diff EiMin='+string(min(EiDiff)),'diff EiMax='+string(max(EiDiff))]
            statusString = [statusString,'diff EfMin='+string(min(EfDiff)),'diff EfMax='+string(max(EfDiff))]
            statusString = [statusString,'diff hwMin='+string(min(hw)),'diff hwMax='+string(max(hw))]
    
            if no_plot eq 0 then begin
              if ptr_valid((*pstate).diffx) gt 0 then ptr_free,(*pstate).diffx 
              (*pstate).diffx = ptr_new(!x)
              if ptr_valid((*pstate).diffy) gt 0 then ptr_free,(*pstate).diffy 
              (*pstate).diffy = ptr_new(!y)

              colorbar,maxrange=zmaxdiff,minrange=zmindiff,color=0L,position=[0.20, 0.85, 0.90, 0.90],$
                       divisions = 3,format='(I12)'
              wset,(*pstate).winvisDiff
              device,copy=[0,0,(*pstate).xsize,(*pstate).ysize,0,0,(*pstate).winpixDiff]
            endif

            ;if (mslice ne 0) and (writeMslice eq 0) then begin ;3
            if (mslice ge 0) or (writeMslice ge 0) then begin ;3  ;SHOULD ALWAYS ENTER THIS BLOCK


;if msliceChoice eq 2 then begin
if mslicePowder eq 1 then begin
;POWDER
                label = ['I','dI','|q|','ei']
                tempvar = dblarr(2,n_elements(qy))
                tempvar[0,*] = qx
                tempvar[1,*] = qy
                qhkl = MACSRunner_v1_ConvertToHKL(tempvar,pstate,qmag=qmag)

				;I DON'T KNOW IF THE NEXT LINE IS CORRECT AND/OR NECESSARY
				;THIS LINE CAME FROM Jose.
				;qmag=sqrt(qx^2+qy^2)
               
                qSummerSchool = (ki_kf_cos_tt) ;SUMMER SCHOOL
                help,ki_kf_cos_tt                 
                if summerSchool eq 1 then begin
                  qmag = qSummerSchool
                  label[2] = 'q/2*PI'
                endif
                
                qpowderSort = sort(qmag)
                qPowder = qmag[qpowderSort]
                rint = rint[qpowdersort]
                drint = drint[qpowdersort]
                eidiff = eidiff[qpowdersort]
;help,rint,drint,qpowder,eidiff,qx,qy
                title = projectName+ ' DIFF - Powder'
                ;if mslice ne 0 then vMACS_mslicePowder, rint, drint,qPowder, eidiff, label=label, unit=unit,title=title                
                if mslice ne 0 then begin
                  if msliceKeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
                  vMACS_mslicePowder, rint, drint,qPowder, eidiff, label=label, unit=unit,title=title, $
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                    
                endif;mslice
                
                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: ASCII DIFF POWDER OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 4)          
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = qPowder
                      mslicedata[*,3] = eidiff  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,4A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(4g15.7)'
                      endfor;i 
                      free_lun,lun   
                      
                    endif;fn
                endif;writeMslice  

endif else begin     

  
              if sendHKLToMSlice eq 0 then begin
                label = ['I','dI','qx','qy','ei']

                qxRot = qx
                qyRot = qy
                if qRotationAngle ne 0 then begin

                  print,'QRotationAngle=',qRotationAngle
                  label = ['I','dI','qx_Rotated','qy_Rotated','ei']
                  thetaRot = !dtor*qRotationAngle
                  qxRot = cos(thetaRot)*qx + sin(thetaRot)*qy
                  qyRot = -sin(thetaRot)*qx + cos(thetaRot)*qy
                endif;qRotationAngle
                ;if mslice ne 0 then vMACS_mslice, rint, drint, qxRot, qyRot, z=eidiff, label=label, unit=unit
                if mslice ne 0 then begin
                  if mslicekeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
                  vMACS_mslice, rint, drint, qxRot, qyRot, z=eidiff, label=label, unit=unit,$
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                    
                endif;mslice

                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: ASCII OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 5)          
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = qxrot
                      mslicedata[*,3] = qyrot
                      mslicedata[*,4] = eidiff  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,5A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(5g15.7)'
                      endfor;i 
                      free_lun,lun   
                      
                    endif;fn
                endif;writeMslice  

              endif else begin

                label = ['I','dI','h','k','l','ei']
                unit = ['counts','counts','r.l.u.','r.l.u.','r.l.u.','meV']
                tempvar = dblarr(2,n_elements(qy))
                tempvar[0,*] = qx
                tempvar[1,*] = qy
                qhkl = MACSRunner_v1_ConvertToHKL(tempvar,pstate,qmag=qmag)
                ;help,unit
                ;vMACS_msliceHKL, rint, drint, h,k,l, E, label=label, unit=unit
                print,'Q-E Ranges:'
                print,'h ',min(qhkl[0,*]),max(qhkl[0,*])
                print,'k ',min(qhkl[1,*]),max(qhkl[1,*])
                print,'l ',min(qhkl[2,*]),max(qhkl[2,*])
                print,'E ',min(eidiff),max(eidiff)
;                if mslice ne 0 then begin
;                  
;                  vMACS_msliceHKL, rint, drint, qhkl[0,*], qhkl[1,*],qhkl[2,*], eidiff, label=label, unit=unit,title='Diff'
;                endif
                if mslice ne 0 then begin
                  if mslicekeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
                  vMACS_msliceHKL, rint, drint, qhkl[0,*], qhkl[1,*],qhkl[2,*], eidiff, label=label, unit=unit,title='Diff',$
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                      
                endif;mslice


                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: ASCII OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 6)
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = reform(qhkl[0,*],n_elements(qhkl[0,*]))
                      mslicedata[*,3] = reform(qhkl[1,*],n_elements(qhkl[1,*]))
                      mslicedata[*,4] = reform(qhkl[2,*],n_elements(qhkl[2,*]))
                      mslicedata[*,5] = eidiff  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,6A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(6g15.7)'
                      endfor;i 
                      free_lun,lun   
                    endif;fn
                endif;writeMslice  
                
              endelse


endelse;msliceChoice NOT POWDER

            endif;3

        endif;msliceChoice  ;2
        tvlct,rsave,gsave,bsave
        device,decomposed=dc


    endif;dataContainer->count();1






end;MACSRunner_v1_sliceDiff


pro MACSRunner_v1_sliceSpec,pstate,mlice=mslice,$
                              quickslice=quickslice,$
                              writeMslice=writeMslice,$
                              statusString=statusString,$
                              msliceChoice=msliceChoice,$
                              mslicePowder=mslicePowder,$
                              msliceKeep=msliceKeep,$
                              no_plot=no_plot,$
                              summerSchool=summerSchool


    ;widget_control,event.handler,get_uvalue=pstate
    catch,es
    if es ne 0 then begin
      errormsg = ['The following problem occurred in MACSRunner_v1_SliceSpec:',!error_state.msg]
      void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)                
      catch,/cancel
      nse_cleanupProgressWindows
      return
    endif;catch        

    ;widget_control,event.handler,get_uvalue=pstate
    if n_elements(mslicekeep) eq 0 then msliceKeep = 0
    if n_elements(summerSchool) eq 0 then summerSchool = 0
;print,'summerSchool=',summerSchool
    if (*pstate).dataContainer->count() gt 0 then begin ;1
  ;print,'SPEC______________________________________________________'
      
      
      (*pstate).projObject->getProperty,zmindiff=zmindiff,zmaxdiff=zmaxdiff,$
                                        zminspec=zminspec,zmaxspec=zmaxspec,$
                                        PTAIBinSize=PTAIBinSize,$
                                        A2BinSize=A2BinSize,$
                                        A3Binsize=A3Binsize,$
                                        kidneybinsize=kidneybinsize,$
                                        A5Binsize=A5Binsize,$
                                        $
                                       sE_PTAIbinsize=sE_PTAIbinsize,$
                                       sE_A5binsize=sE_A5binsize, $
                                       sE_A2binsize=sE_A2binsize, $
                                       sE_A3binsize=sE_A3binsize, $
                                       sE_Kidneybinsize=sE_Kidneybinsize,$
                                       $
                                       BE_PTAIbinsize=BE_PTAIbinsize,$
                                       BE_A5binsize=BE_A5binsize, $
                                       BE_A2binsize=BE_A2binsize, $
                                       BE_A3binsize=BE_A3binsize, $
                                       BE_Kidneybinsize=BE_Kidneybinsize,$
                                        $
                                        xmin=xmin,xmax=xmax,ymin=ymin,ymax=ymax,$
                                        ColorTable=ColorTable,$
                                        xTitle=xTitle,$
                                        yTitle=yTitle,$
                                        charsize=charsize,$
                                        grain=grain,$
                                        diffweights=diffweights,specweights=specweights,$
                                        diffMask=diffMask,specMask=specMask,$
                                        lattice=lattice,orientation=orientation,$
                                        xscale=xscale,$
                                        yscale=yscale,$
                                        datascalefactor=datascalefactor,$
                                        bkgscalefactor=bkgscalefactor,$
                                        emptyscalefactor=emptyscalefactor,$
                                        bg_emptyscalefactor=bg_emptyscalefactor,$
                                        white=white,$
                                        no_norm=no_norm,$
                                        invert=invert,$
                                        xabs=xabs,$
                                        yabs=yabs,$
                                        n_fold=n_fold,$
                                        a3ran=a3ran,$
                                        a4ran=a4ran,$
                                        a3_mask=a3_mask,$
                                        a4_mask=a4_mask,$
                                        a3shift=a3shift,$
                                        qrotationAngle=qRotationAngle,$
                                        point_by_point=point_by_point,$
                                        sendHKLtoMslice=sendHKLtoMSlice,$
                                        name=projectName
                                        
                                        
      ;GET THE DETECTORS TO EXCLUDE FROM DIFF AND SPEC
      lattice = [xscale,yscale]
      
      diffExclude = where(diffMask eq 0,diffcount)                                          
      ;if diffcount gt 0 then $ 
      diffExclude = diffExclude + 1 ;SHIFT BY 1 FOR 1-BASED LABELING of DETS; IF NOTHING MATCHES, diffExclude=0

      specExclude = where(specMask eq 0,speccount)                                          
      ;if speccount gt 0 then $
      specExclude = specExclude + 1 ;SHIFT BY 1 FOR 1-BASED LABELING of DETS; IF NOTHING MATCHES, specExclude=0


;LRK 10/28/2010
;CHANGE THIS TO USE ALL ITEMS IN THE CONTAINERS
;SELECTION WILL ONLY BE USER FOR REMOVAL AND VIEWING
;      sel = widget_info((*pstate).datalist,/list_select)
;      
;      if sel[0] eq -1 then begin
;        void = dialog_message('No data selected!',dialog_parent=(*pstate).tlb)
;      endif else begin

        ;fn1 = strarr(n_elements(sel))
        fn1 = strarr((*pstate).dataContainer->count())
        for i=0,n_elements(fn1)-1 do begin
;          ((*pstate).dataContainer->get(position=sel[i]))->getProperty,filename=filename
          ((*pstate).dataContainer->get(position=i))->getProperty,filename=filename
          fn1[i] = filename
        endfor;i


;        bsel = widget_info((*pstate).bkglist,/list_select)
;        esel = widget_info((*pstate).emptylist,/list_select)
;        besel = widget_info((*pstate).bgemptylist,/list_select)

;        if bsel[0] ne -1 then begin
;          bfn = strarr(n_elements(bsel))
          bcount = (*pstate).bkgContainer->count()
          if bcount gt 0 then begin
            bfn = strarr(bcount)
            for i=0,n_elements(bfn)-1 do begin
  ;            ((*pstate).bkgContainer->get(position=bsel[i]))->getProperty,filename=filename
              ((*pstate).bkgContainer->get(position=i))->getProperty,filename=filename
              bfn[i] = filename
            endfor;i
  ;        endif;bsel
         endif;bcount
         
         
;        if esel[0] ne -1 then begin
;          efn = strarr(n_elements(esel))
          ecount = (*pstate).emptyContainer->count()
          if ecount gt 0 then begin
            efn = strarr(ecount)
            for i=0,n_elements(efn)-1 do begin
  ;            ((*pstate).emptyContainer->get(position=esel[i]))->getProperty,filename=filename
              ((*pstate).emptyContainer->get(position=i))->getProperty,filename=filename
              efn[i] = filename
            endfor;i
  ;        endif
          endif;ecount
        
;        if besel[0] ne -1 then begin
;          befn = strarr(n_elements(besel))
        bgecount = (*pstate).bgemptyContainer->count()
        if bgecount gt 0 then begin
          befn = strarr(bgecount)
          for i=0,n_elements(befn)-1 do begin
;            ((*pstate).bgemptyContainer->get(position=besel[i]))->getProperty,filename=filename
            ((*pstate).bgemptyContainer->get(position=i))->getProperty,filename=filename
            befn[i] = filename
          endfor;i
;        endif
        endif;bgecount


        device,get_decomposed=dc
        device,decomposed=0
        tvlct,rsave,gsave,bsave,/get
        loadct,ColorTable

        if (msliceChoice eq 0) or (msliceChoice eq -1) then begin ;2
              if no_plot eq 0 then begin                       
                wset,(*pstate).winpixSpec
              endif
              ;SPEC DETECTORS    
              ;vmacs_qmap,fn1,bgfil=backfil,devs=['kidney','A3'],bgbinsz=[3,1.0],zran=[-500,2000.0]
              bgbinsize = [PTAIBinSize,A2BinSize,A3Binsize,kidneybinsize,A5Binsize]
              fg_mtbinsize = [SE_PTAIBinSize,SE_A2BinSize,SE_A3Binsize,SE_kidneybinsize,SE_A5Binsize]
              bg_mtbinsize = [BE_PTAIBinSize,BE_A2BinSize,BE_A3Binsize,BE_kidneybinsize,BE_A5Binsize]

              ;print,'bgbinsize=',bgbinsize
              devs=['PTAI', 'A2', 'A3', 'Kidney', 'A5']
              usedevs = devs
              usebgbinsize = bgbinsize


;              devsSelect = where(bgbinsize lt 1000.0 and bgbinsize gt 0,devsSelectCount)
;              if devsSelectCount gt 0 then begin
;                usedevs = devs[devsSelect]
;                usebgbinsize = bgbinsize[devsselect]
;              endif

            ;devsSelect = where(bgbinsize lt 1000.0 and bgbinsize gt 0,devsSelectCount)
            devsSelect = where(bgbinsize gt 0,devsSelectCount)
;print,'devsSelectCount=',devsSelectCount            
            if devsSelectCount gt 0 then begin
              usedevs = devs[devsSelect]
              usebinsize = bgbinsize[devsselect]
              usebgbinsize = bgbinsize[devsselect]
              usefg_mtbinsize = fg_mtbinsize[devsselect]
              usebg_mtbinsize = bg_mtbinsize[devsselect]
            endif
            fgmtdevsSelect = where(fg_mtbinsize gt 0,fgmtdevsSelectCount)
;print,'fgmtdevsSelectCount=',fgmtdevsSelectCount
            if fgmtdevsSelectCount gt 0 then begin
              ;usedevs = devs[devsSelect]
              usefg_mtbinsize = fg_mtbinsize[fgmtdevsselect]
            endif
            bgmtdevsSelect = where(bg_mtbinsize gt 0,bgmtdevsSelectCount)
;print,'bgmtdevsSelectCount=',bgmtdevsSelectCount            
            if devsSelectCount gt 0 then begin
              ;usedevs = devs[devsSelect]
              usebg_mtbinsize = bg_mtbinsize[bgmtdevsselect]
            endif

;            print,'**************************************'
;            print,'usedevs=',usedevs
;            print,'**************************************'
;print,'sliceDiff +++++++++++++++++++++++++++++++++++++++++++++++++++++++++'     
;help,fg_mtbinsize,usefg_mtbinsize,usebgbinsize,usebinsize



  ;
  ;print,'specExclude=',specExclude
  ;print,'diffExclude=',diffExclude
;print,'SPEC TEST 1a ______________________________________________________'
;print,'slice spec'

;qfold ADDITION COMES FROM Jose
;CHECK THAT THIS ADDITION IS NOT HAVING ANY UNEXPECTED 
;EFFECTS
qfold=0
;a4_mask=[-5.,5.]
              vmacs_qmap,fn1,bgfil=bfn,$
                              qfold=qfold,$ ;SUMMER SCHOOL 
                             ki_kf_cos_tt=ki_kf_cos_tt,$ ;SUMMER SCHOOL 
                             summerSchool=summerSchool,$
                           devs=useDevs,$;['PTAI', 'A2', 'A3', 'Kidney', 'A5'],$
                           binsz=usebinsize,$;usebgbinsize,$       
                           bgbinsz=usebgbinsize,$
                           fg_mtbinsz=usefg_mtbinsize,$;fg_mtbinsize,$;usebgbinsize, $
                           bg_mtbinsz=usebg_mtbinsize,$;bg_mtbinsize,$;usebgbinsize, $
;                             devs=usedevs,$;['PTAI', 'A2', 'A3', 'Kidney', 'A5'],$
;                             binsz=usebgbinsize,$       
;                             bgbinsz=usebgbinsize,$
;                             fg_mtbinsz=fg_mtbinsize,$;usebgbinsize, $
;                             bg_mtbinsz=bg_mtbinsize,$;usebgbinsize, $
                             fgsc=datascalefactor,$ 
                             bgsc=bkgscalefactor,$ 
                             fg_mtsc=emptyscalefactor,$ 
                             bg_mtsc=bg_emptyscalefactor,$
                             weights=specweights,$ 
;                             diffweights=diffweights,specweights=specweights,$
                             Mask=specExclude,$;specMask,$
                             lattice=lattice,$
                             orientation=orientation,$
                             zran=[zminspec,zmaxspec],$
                             fg_mtfil=efn, bg_mtfil=befn,$
                             qx=qx, qy=qy, rint=rint, drint=drint, avhw=avhw, hw=hw,$
                             ei=eispec,ef=efspec,$  ;LRK - 10/07/10
                             xr = [xmin,xmax], yr = [ymin,ymax],$ 
                             xTit=xTitle,$
                             yTit=yTitle,$
                             chars=charsize,$
                             grain=grain,$
                             white=white,$
                             subtitle='SPEC',$
                             dataRange=SpecDataRange,$
                             no_norm=no_norm,$
                             invert=invert,$
                             xabs=xabs,$
                             yabs=yabs,$
                             n_fold=n_fold,$                             
                             a3ran=a3ran,$
                             a4ran=a4ran,$
                             a3shift=a3shift,$
                             a3_mask=a3_mask,$
                             a4_mask=a4_mask,$
                             no_plot=no_plot,$
                             pbpsub=point_by_point,$
                             /no_concat

print,'check qx,qy'                              
;help,qx,qy

                        statusString = [statusString,'specMin='+string(SpecDataRange[0]),$
                                                     'specMax='+string(SpecDataRange[1])]
                              ;                       
                              ;;pro vMACS_qmap, fgfil, bgfil=bgfil, fg_mtfil=fg_mtfil, bg_mtfil=bg_mtfil, $
                              ;;               fgbinsz=fgbinsz, bgbinsz=bgbinsz, fg_mtbinsz=fg_mtbinsz, bg_mtbinsz=bg_mtbinsz, $
                              ;;               fgsc=fgsc, bgsc=bgsc, fg_mtsc=fg_mtsc, bg_mtsc=bg_mtsc, $ 
                              ;;               fga3sh=fga3sh, bga3sh=bga3sh, fg_mta3sh=fg_mta3sh, bg_mta3sh=bg_mta3sh, $
                              ;;               qx=qx, qy=qy, rint=rint, drint=drint, avhw=avhw, hw=hw, $
                              ;;               binqx=binqx, binqy=binqy, binrint=binrint, bindrint=bindrint, $
                              ;;               binxr=binxr, binyr=binyr, xr=xr, yr=yr, binsub=binsub, $
                              ;;               data=data, columns=columns, xpar=xpar, dat_xpar=dat_xpar, $
                              ;;               white=white, grain=grain, chars=chars, no_plot=no_plot, _extra=_extra  
                              ;
                              ;

            if no_plot eq 0 then begin
              if ptr_valid((*pstate).specx) gt 0 then ptr_free,(*pstate).specx 
              (*pstate).specx = ptr_new(!x)
              if ptr_valid((*pstate).specy) gt 0 then ptr_free,(*pstate).specy 
              (*pstate).specy = ptr_new(!y)
              colorbar,maxrange=zmaxspec,minrange=zminspec,color=0L,position=[0.20, 0.85, 0.90, 0.90],$
                       divisions = 3,format='(I12)'
              wset,(*pstate).winvisSpec
              device,copy=[0,0,(*pstate).xsize,(*pstate).ysize,0,0,(*pstate).winpixSpec]
            endif
           
           
            ;if (mslice ne 0) and (writeMslice eq 0) then begin ;3
            if (mslice ge 0) or (writeMslice ge 0) then begin ;3  ;SHOULD ALWAYS ENTER THIS BLOCK


;if msliceChoice eq 2 then begin
if mslicePowder eq 1 then begin
;POWDER FOR SPEC
                label = ['I','dI','|q|','hw']
                tempvar = dblarr(2,n_elements(qy))
                tempvar[0,*] = qx
                tempvar[1,*] = qy
                
                qhkl = MACSRunner_v1_ConvertToHKL(tempvar,pstate,qmag=qmag)

;;;;;;;;;;;;;;;;;;;;;;;;;;;
;I THINK JOSE INTRODUCED A PROBLEM HERE
;;;;;;;;;;;;;;;;;;;;;;;;;;;
;IT LOOKS TO ME LIKE Jose OMITTED A COUPLE NEEDED ADDITIONS HERE
;I DON'T SEE RIGHT AWAY WHERE ki_kf_cos_tt IS CALCULATED HERE
help,ki_kf_cos_tt,qmag,qx,qy
               
print,'summerSchool=',summerSchool           

                qSummerSchool = ki_kf_cos_tt ;SUMMER SCHOOL 

                qpowderSort = sort(qmag)
                qPowder = qmag[qpowderSort]
;I KEPT THE NEXT BLOCK AS I HAD IT
                if summerSchool eq 1 then begin
                  qpowderSort = sort(qSummerSchool)  
                  qPowder = qSummerSchool[qpowderSort]
                  label[2] = 'q/2*PI'
                endif


                rint = rint[qpowdersort]
                drint = drint[qpowdersort]
                hw = hw[qpowdersort]
;help,rint,drint,qpowder,eidiff,qx,qy
                title = projectName+ ' SPEC - Powder'
                ;if mslice ne 0 then vMACS_mslicePowder, rint, drint,qPowder, eidiff, label=label, unit=unit,title=title                
                if mslice ne 0 then begin
                  if mslicekeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
;help,obj_mslice
                  vMACS_mslicePowder, rint, drint,qPowder, hw, label=label, unit=unit,title=title, $
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                    
                endif;mslice
                
                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: SPEC ASCII POWDER OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 4)          
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = qPowder
                      mslicedata[*,3] = hw  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,4A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(4g15.7)'
                      endfor;i 
                      free_lun,lun   
                      
                    endif;fn
                endif;writeMslice  

endif else begin     

              if sendHKLToMSlice eq 0 then begin
                label = ['I','dI','qx','qy','hw']

                qxRot = qx
                qyRot = qy
                if qRotationAngle ne 0 then begin

                  print,'QRotationAngle=',qRotationAngle
                  label = ['I','dI','qx_Rotated','qy_Rotated','hw']
                  thetaRot = !dtor*qRotationAngle
                  qxRot = cos(thetaRot)*qx + sin(thetaRot)*qy
                  qyRot = -sin(thetaRot)*qx + cos(thetaRot)*qy
                endif;qRotationAngle
                ;if mslice ne 0 then vMACS_mslice, rint, drint, qxRot, qyRot, z=hw, label=label, unit=unit,title='Spec'
                if mslice ne 0 then begin
                  if mslicekeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
                  vMACS_mslice, rint, drint, qxRot, qyRot, z=hw, label=label, unit=unit,title='Spec',$
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                                      
                endif;mslice

                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: SPEC ASCII OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 5)          
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = qxrot
                      mslicedata[*,3] = qyrot
                      mslicedata[*,4] = hw  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,5A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(5g15.7)'
                      endfor;i 
                      free_lun,lun   
                      
                    endif;fn
                endif;writeMslice  

              endif else begin

                label = ['I','dI','h','k','l','hw']
                unit = ['counts','counts','r.l.u.','r.l.u.','r.l.u.','meV']
                tempvar = dblarr(2,n_elements(qy))
                tempvar[0,*] = qx
                tempvar[1,*] = qy
                qhkl = MACSRunner_v1_ConvertToHKL(tempvar,pstate,qmag=qmag)
                ;help,unit
                ;vMACS_msliceHKL, rint, drint, h,k,l, E, label=label, unit=unit
                print,'Q-E Ranges:'
                print,'h ',min(qhkl[0,*]),max(qhkl[0,*])
                print,'k ',min(qhkl[1,*]),max(qhkl[1,*])
                print,'l ',min(qhkl[2,*]),max(qhkl[2,*])
                print,'E ',min(hw),max(hw)
                ;if mslice ne 0 then vMACS_msliceHKL, rint, drint, qhkl[0,*], qhkl[1,*],qhkl[2,*], hw, label=label, unit=unit,title='Spec'
                if mslice ne 0 then begin
                  if mslicekeep ne 0 then begin
                    if obj_valid((*pstate).obj_mslice) gt 0 then obj_mslice = (*pstate).obj_mslice
                  endif
                  vMACS_msliceHKL, rint, drint, qhkl[0,*], qhkl[1,*],qhkl[2,*], hw, label=label, unit=unit,title='Spec',$
                                      group_leader=(*pstate).tlb,$
                                      workDir=(*pstate).workDir,dataDir=(*pstate).dataDir,DAVETool=(*pstate).DAVETool,$
                                      obj_mslice=obj_mslice
                  (*pstate).obj_mslice = obj_mslice                                      
                endif;mslice
                
                if writeMslice ne 0 then begin
                    fn = dialog_pickfile(title='MACSRunner_v1: ASCII OUTPUT File:',$
                                         filter=['*.txt','*.dat'],path=(*pstate).workdir,$
                                         /overwrite_prompt)
                    if fn[0] ne '' then begin
                      MACSRunner_v1_addDotExt,fn,'txt'
                      mslicedata = findgen(n_elements(rint), 6)
                      mslicedata[*,0] = rint
                      mslicedata[*,1] = drint
                      mslicedata[*,2] = reform(qhkl[0,*],n_elements(qhkl[0,*]))
                      mslicedata[*,3] = reform(qhkl[1,*],n_elements(qhkl[1,*]))
                      mslicedata[*,4] = reform(qhkl[2,*],n_elements(qhkl[2,*]))
                      mslicedata[*,5] = hw  
                      openw,lun,fn,/get_lun
                      printf,lun,'#',label[*],format='(A,6A15)' 
                      for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
                        printf,lun,mslicedata[i,*],format='(6g15.7)'
                      endfor;i 
                      free_lun,lun   
                    endif;fn
                endif;writeMslice  
                
              endelse
endelse;mslicechoice NOT POWDER
            endif;3
;            
;            if (mslice ne 0) and (writeMslice eq 0) then begin;3
;
;              catch,es
;              if es ne 0 then begin
;                errormsg = ['The following problem occurred in MACSRunner_v1_SliceSpec:',!error_state.msg]
;                void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)                
;                catch,/cancel
;                return
;              endif;catch        
;
;
;              if sendHKLToMSlice eq 0 then begin
;                label = ['I','dI','qx','qy','hw']
;  
;                qxRot = qx
;                qyRot = qy
;                if qRotationAngle ne 0 then begin
;                  
;                  print,'QRotationAngle=',qRotationAngle
;                  label = ['I','dI','qx_Rotated','qy_Rotated','hw']
;                  thetaRot = !dtor*qRotationAngle
;                  qxRot = cos(thetaRot)*qx + sin(thetaRot)*qy
;                  qyRot = -sin(thetaRot)*qx + cos(thetaRot)*qy
;                endif;qRotationAngle
;                vMACS_mslice, rint, drint, qxRot, qyRot, z=hw, label=label, unit=unit
;              endif else begin
;                label = ['I','dI','h','k','l','hw']
;                unit = ['counts','counts','r.l.u.','r.l.u.','r.l.u.','meV']
;                tempvar = dblarr(2,n_elements(qy))
;                tempvar[0,*] = qx
;                tempvar[1,*] = qy
;                qhkl = MACSRunner_v1_ConvertToHKL(tempvar,pstate)
;                ;help,unit
;                ;vMACS_msliceHKL, rint, drint, h,k,l, E, label=label, unit=unit
;                print,'Q-E Ranges:'
;                print,'h ',min(qhkl[0,*]),max(qhkl[0,*])
;                print,'k ',min(qhkl[1,*]),max(qhkl[1,*])
;                print,'l ',min(qhkl[2,*]),max(qhkl[2,*])
;                print,'E ',min(hw),max(hw)
;                vMACS_msliceHKL, rint, drint, qhkl[0,*], qhkl[1,*],qhkl[2,*], hw, label=label, unit=unit, title='Spec'
;              endelse
;
;
;            endif;3


        endif;msliceChoice;2




        tvlct,rsave,gsave,bsave
        device,decomposed=dc


;        
;        if writeMslice eq 1 then begin
;
;              catch,es
;              if es ne 0 then begin
;                errormsg = ['The following problem occurred in MACSRunner_v1_Slice:',!error_state.msg]
;                void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)                
;                catch,/cancel
;                return
;              endif;catch        
;
;            
;              fn = dialog_pickfile(title='MACSRunner_v1: ASCII OUTPUT File:',$
;                                   filter=['*.txt','*.dat'],path=(*pstate).workdir,$
;                                   /overwrite_prompt)
;              if fn[0] ne '' then begin
;                MACSRunner_v1_addDotExt,fn,'txt'
;
;
;                mslicedata = findgen(n_elements(rint), 5)          
;                mslicedata[*,0] = rint
;                mslicedata[*,1] = drint
;                mslicedata[*,2] = qx
;                mslicedata[*,3] = qy
;                if msliceChoice eq 0 then begin
;                  ;SPECTROSCOPIC DETECTORS
;                  mslicedata[*,4] = hw
;                  label = ['I','dI','qx','qy','hw']
;                endif else begin
;                  ;DIFFRACTION DETECTORS
;                  mslicedata[*,4] = eidiff  
;                  label = ['I','dI','qx','qy','ei']
;                endelse
;
;
;                qxRot = qx
;                qyRot = qy
;                if qRotationAngle ne 0 then begin
;  
;                  print,'QRotationAngle=',qRotationAngle
;                  label[2] = 'qx_Rotated'
;                  label[3] = 'qy_Rotated'
;                  thetaRot = !dtor*qRotationAngle
;                  qxRot = cos(thetaRot)*qx + sin(thetaRot)*qy
;                  qyRot = -sin(thetaRot)*qx + cos(thetaRot)*qy
;                  mslicedata[*,3] = qxRot  
;                  mslicedata[*,4] = qyRot  
;                endif;qRotationAngle
;
;                
;                openw,lun,fn,/get_lun
;                printf,lun,'#',label[*],format='(A,5A15)' 
;                for i=long64(0),n_elements(mslicedata[*,0])-1L do begin
;                  printf,lun,mslicedata[i,*],format='(5g15.7)'
;                endfor;i 
;                free_lun,lun   
;                       
;              endif;fn[0] ne ''
;        endif;writeMslice
            
        
        
        
        
  endif;dataContainer->count();1

end;MACSRunner_v1_sliceSpec


pro MACSRunner_v1_slice,pstate,mslice=mslice,quickslice=quickslice,writeMslice=writeMslice

    ;GET THE IMAGES PRODUCED BY EACH OF THESE IN THE DRAW WINDOW AND THEN COPY TO THE 
    ;DISPLAY WINDOW
    if n_elements(mslice) eq 0 then mslice = 0
    if n_elements(quickslice) eq 0 then quickslice = 0
    if n_elements(writeMslice) eq 0 then writeMslice = 0
    msliceChoiceArray = lonarr(2)
    statusString = ['Data Z Ranges:']
    endvalues = lonarr(1)
    mslicePowder = 0
    msliceKeep = 0
  
    if (mslice eq 1) or (writeMslice eq 1) then begin
      ;widget_control,(*pstate).msliceChoice,get_value=msliceChoice      
      progressLabel = 'MSlice'
      widget_control,(*pstate).msliceChoice,get_value=msliceChoiceArray      
      widget_control,(*pstate).msliceChoicePowder,get_value=mslicePowder
      widget_control,(*pstate).msliceKeep,get_value=msliceKeep      
      widget_control,(*pstate).summerSchool,get_value=summerSchool
print,'summerSchool=',summerSchool
      ;012111 TEMPORARILY DO ONLY 1 OF THESE.
      msliceChoice = -1
      if msliceChoiceArray[0] eq 1 then begin
        msliceChoice = 0
        endvalues[0] += 1
        
      endif 
      if msliceChoiceArray[1] eq 1 then begin
        msliceChoice = 1
        endvalues[0] += 1
      endif  
      ;if msliceChoiceArray[2] eq 1 then msliceChoice = 2
      if msliceChoice eq -1 then return 
    endif else begin
      msliceChoice = -1
      endvalues[0] = 2
      progressLabel = 'QuickSlice'
    endelse


print,'MslicePowder=',mslicepowder
    prog = nse_cwo_progress(labels=progressLabel,$;[mslice eq 0 ? 'QuickSlice' : 'Mslice'],$
                           startvalues=[0L],$
                           endvalues=endvalues,$;[mslice eq 0 ? 2L : 1L],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)


    no_plot = 0
    if quickslice eq 0  then no_plot = 1

  ;THIS CASE IS FOR MSLICE OR QUICKSLICE  --- CURRENTLY POWDER IS NOT USED HERE.
    ;if msliceChoice eq 0 or msliceChoice eq -1 then begin
    if msliceChoiceArray[0] eq 1 or msliceChoice eq -1 then begin
      
      MACSRunner_v1_sliceSpec,pstate,mlice=mslice,$
                                    quickslice=quickslice,$
                                    writeMslice=writeMslice,$
                                    statusString=statusString,$
                                    msliceChoice=0,$;msliceChoice,$
                                    mslicePowder=mslicepowder,$
                                    msliceKeep=msliceKeep,$
                                    no_plot=no_plot,$
                                    summerSchool=summerSchool

          ;UPDATE COUNTER AND PROGRESS WIDGET
          if obj_valid(progobj) gt 0 then begin
            progobj->step,0
          endif

    endif;SPEC


    if msliceChoiceArray[1] eq 1 or msliceChoice eq -1 then begin
      ;THIS CASE IS FOR DIFF ND POWDER OPTIONS.  
        MACSRunner_v1_sliceDiff,pstate,mlice=mslice,$
                                  quickslice=quickslice,$
                                  writeMslice=writeMslice,$
                                  statusString=statusString,$
                                  msliceChoice=1,$;msliceChoice,$
                                  mslicepowder=mslicepowder,$
                                  msliceKeep=msliceKeep,$
                                  no_plot=no_plot,$
                                  summerSchool=summerSchool




        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->step,0
        endif
    endif;DIFF

    if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy


    widget_control,(*pstate).text,set_value=statusString

end;MACSRunner_v1_slice


function macsrunner_v1_multiCheckDialog,vals,labels=labels,title=title,$
                                             dialog_parent=dialog_parent,$
                                             string=string,$
                                             format=format,$
                                             nodialog=nodialog,$
                                             _Extra=extra

                                   
  if n_elements(nodialog) eq 0 then nodialog = 0                                  
  newvals = vals

  if nodialog eq 0 then begin
          if n_elements(dialog_parent) eq 1 then begin
            geom = widget_info(dialog_parent,/geometry)
          endif
          if n_elements(title) eq 0 then title = 'Dialog:'
          if n_elements(labels) ne n_elements(vals) then begin
            if n_elements(labels) eq 0 or n_elements(labels) gt 1 then begin 
              labels = 'val '+strtrim(string(indgen(n_elements(vals))+1,format='(I3)'),2)
            endif else begin
              labels = labels+' '+strtrim(string(indgen(n_elements(vals))+1,format='(I3)'),2)
            endelse
          endif
        
          tlb = widget_base(title='Input',$
                            xoffset=geom.xoffset+geom.xsize/2,$
                            yoffset=geom.yoffset+geom.yoffset/2,$
                            /col,group_leader=dialog_parent)
                            
          lab = widget_label(tlb,value=title)
        
          ;CREATE THE Checkboxes
          checks = cw_bgroup(tlb,labels,set_value=vals,/nonexclusive,/column)
          
          ;ADD THE BUTTONS
          accept = widget_button(tlb,value='Accept')
          cancel = widget_button(tlb,value='Cancel')
          
          widget_control,tlb,/realize
        
        
          ;HANDLE THE EVENTS
          event = {id:0L,top:0L,handler:0L}  
          while (event.id ne accept) and $
                (event.id ne cancel) and $
                (event.id ne tlb)    do begin

            ;LRK - 11/15/10
            ;WHAT ABOUT THE CASE WHERE JOSE x's OUT OF THE DIALOG???
            if widget_info(tlb,/valid_id) gt 0 then begin
              event = widget_event(tlb,/nowait)
            endif else begin
              break
            endelse    
          endwhile
        
          
          if event.id eq cancel then begin
            newvals = vals
            widget_control,tlb,/destroy
          endif else begin
            if (widget_info(tlb,/valid) gt 0) then begin      
              widget_control,checks,get_value=val
              newvals = val
              widget_control,tlb,/destroy
            endif
          endelse
  endif;nodialog
  
  if n_elements(format) eq 0 then format = '(i1)'
  string = '['
  for i=0,n_elements(newvals)-1 do begin
    string = string+strtrim(string(newvals[i],format=format),2)
    if i lt n_elements(newvals)-1 then string = string + ','
  endfor;i
  string = string + ']'

  return,newvals
end;macsrunner_v1_multiCheckDialog


function macsrunner_v1_multitextDialog,vals,labels=labels,title=title,$
                                            dialog_parent=dialog_parent,$
                                            string=string,$
                                            format=format,$
                                            nodialog=nodialog,$
                                            _Extra=extra
                                   
                                   
                                   
  if n_elements(nodialog) eq 0 then nodialog = 0                                  
  newvals = vals

  
  if nodialog eq 0 then begin
          if n_elements(dialog_parent) eq 1 then begin
            geom = widget_info(dialog_parent,/geometry)
          endif
          if n_elements(title) eq 0 then title = 'Dialog:'
          if n_elements(labels) ne n_elements(vals) then labels = 'val '+strtrim(string(indgen(n_elements(vals))+1,format='(i3)'),2)
        
          tlb = widget_base(title='Input',$
                            xoffset=geom.xoffset+geom.xsize/2,$
                            yoffset=geom.yoffset+geom.yoffset/2,$
                            /col,group_leader=dialog_parent)
                            
          lab = widget_label(tlb,value=title)
        
          ;CREATE THE ENTRY FIELDS
          fields = lonarr(n_elements(vals))
          for i=0,n_elements(vals)-1 do begin
            fields[i] = cw_field(tlb,title=labels[i],value=vals[i],tab_mode=1,/floating)    
          endfor;i
          
          ;ADD THE BUTTONS
          accept = widget_button(tlb,value='Accept')
          cancel = widget_button(tlb,value='Cancel')
          
          widget_control,tlb,/realize
        
        
          ;HANDLE THE EVENTS
          event = {id:0L,top:0L,handler:0L}  
          while (event.id ne accept) and $
                (event.id ne cancel) and $
                (event.id ne tlb)    do begin
            if widget_info(tlb,/valid_id) gt 0 then begin
              event = widget_event(tlb,/nowait)
            endif else begin
              break
            endelse    
          endwhile
        
          
          if event.id eq cancel then begin
            newvals = vals
            widget_control,tlb,/destroy
          endif else begin
            if (widget_info(tlb,/valid) gt 0) then begin      
              for i=0,n_elements(fields)-1 do begin
                widget_control,fields[i],get_value=val
                newvals[i] = val
              endfor;i
              widget_control,tlb,/destroy
            endif ;else begin
        ;      newvals = vals
        ;    endelse  
          endelse
  endif;nodialog
  
  if n_elements(format) eq 0 then format = '(g10.5)'
  string = '['
  for i=0,n_elements(newvals)-1 do begin
    string = string+strtrim(string(newvals[i],format=format),2)
    if i lt n_elements(newvals)-1 then string = string + ','
  endfor;i
  string = string + ']'

  return,newvals
end;macsrunner_v1_multitextDialog

pro macsrunner_v1_modifyITEM,event,string=string,nodialog=noDialog


    widget_control,event.handler,get_uvalue=pstate

    ;GET ALL THE CURRENT STATES OF THE PROPERTIES
    (*pstate).projObject->getProperty,abc=abc,$
                                      abg=abg,$
                                      specweights=specweights,$
                                      diffweights=diffweights,$
                                      specmask=specmask,$
                                      diffmask=diffmask,$
                                      orientation=orientation,$
                                      a3ran=a3ran,a4ran=a4ran,$
                                      a3_mask=a3_mask,$
                                      a4_mask=a4_mask
                                      
                                      
                                      
    ;help,abc,abg,specweights,specmask,diffweights,diffmask,orientation

    checks = 0
    
    ;ADD AN OPTION TO SUPPRESS THE DIALOG SIMPLY TO GET THE DATA STRING FOR DISPLAY
    if n_elements(nodialog) eq 0 then nodialog = 0

    case strupcase(event.identifier) of
    'A3RAN':begin
        title='Enter new A3Ran values (in deg)'
        labels=['A3Min','A3Max']
        vals = a3ran
        format = '(g10.5)'
    end;A3RAN
    'A4RAN':begin
        title='Enter new A4Ran values (in deg)'
        labels=['A4Min','A4Max']
        vals = a4ran
        format = '(g10.5)'
    end;A4RAN
    'A3_MASK':begin
        title='Enter new A3 masking range values (in deg)'
        labels=['A3_mask_Min','A3_mask_Max']
        vals = a3_mask
        format = '(g10.5)'
    end;A3_mask
    'A4_MASK':begin
        title='Enter new A4 masking range values (in deg)'
        labels=['A4_mask_Min','A4_mask_Max']
        vals = a4_mask
        format = '(g10.5)'
    end;A4_mask
    
    'ABC':begin
        title='Enter new a,b,c values (in ang)'
        labels=['a','b','c']
        vals = abc
        format = '(g10.5)'
    end;ABC
    'ABG':begin
        title='Enter new alpha,beta,gamma values (in deg)'
        labels=['alpha','beta','gamma']
        vals = abg
        format = '(g10.5)'
    end;ABG
    'SPECWEIGHTS':begin
        title='Enter new weights for spectroscopic detectors'
        vals = specweights
        labels = 'SpecDet#'
        format = '(g8.5)'
    end;SPECWEIGHTS
    'SPECMASK':begin
        title='Select SPECTROSCOPIC detectors TO USE'
        format = '(i1)' 
        vals=specmask
        labels = 'SpecDet#'
        checks = 1
    end;SPECMASK
    'DIFFWEIGHTS':begin
        title='Enter new weights for diffraction detectors'
        vals = diffweights
        labels = 'DiffDet#'
        format = '(g8.5)'        
    end;DIFFWEIGHTS
    'DIFFMASK':begin
        title='Select DIFFRACTION detectors TO USE'
        format = '(i1)'
        vals = diffmask
        labels = 'DiffDet#'
        checks = 1 
    end;DIFFMASK
    'ORIENTATION':begin
        title='Enter new orientation vector components:'
        labels=['h1','k1','l1','h2','k2','l2']
        vals = orientation
        format = '(g5.1)'
    end;ORIENTATION
    else:return
    endcase

    if checks eq 0 then begin
      vals = macsrunner_v1_multitextDialog( vals,$
                                            title=title,$
                                            labels=labels,$
                                            dialog_parent=(*pstate).tlb,$
                                            format=format,$
                                            string=string,$
                                            nodialog=nodialog)
    endif else begin
      vals = macsrunner_v1_multiCheckDialog( vals,$
                                            title=title,$
                                            labels=labels,$
                                            dialog_parent=(*pstate).tlb,$
                                            format=format,$
                                            string=string,$
                                            nodialog=noDialog)
      
    endelse


  ;UPDATE THE VALUES IN THE PROJECT OBJECT
   case strupcase(event.identifier) of
    'A3RAN':(*pstate).projObject->setProperty,a3ran=vals
    'A4RAN':(*pstate).projObject->setProperty,a4ran=vals
    'A3_MASK':(*pstate).projObject->setProperty,a3_mask=vals
    'A4_MASK':(*pstate).projObject->setProperty,a4_mask=vals
    'ABC':(*pstate).projObject->setProperty,abc=vals
    'ABG':(*pstate).projObject->setProperty,abg=vals
    'SPECWEIGHTS':(*pstate).projObject->setProperty,specweights=vals
    'SPECMASK':(*pstate).projObject->setProperty,specmask=vals
    'DIFFWEIGHTS':(*pstate).projObject->setProperty,diffweights=vals
    'DIFFMASK':(*pstate).projObject->setProperty,diffmask=vals
    'ORIENTATION':(*pstate).projObject->setProperty,orientation=vals
    else:return
    endcase
    event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
    ;print,'SPECWEIGHTS string=',string
    widget_control, (*pstate).propertySheet, refresh_property = event.identifier

end;macsrunner_v1_modifyItem


pro MACSRunner_v1_HandlePropertySheet,event

  widget_control,event.handler,get_uvalue=pstate

    ;print,'(*pstate).propertySheet'
    ;help,event,/struct
    ename = tag_names(event,/structure_name)
    case ename of
    'WIDGET_PROPSHEET_CHANGE':begin
      widget_control,(*pstate).propertysheet,get_value=o
      ;help,o
      sel = widget_info((*pstate).projlist,/list_select)      
      print,'WIDGET_PROPSHEET_CHANGE',sel[0],event.identifier
      if sel[0] ge 0 then begin
        print,'SEL[0] ne -1   '+event.identifier
        case strupcase(event.identifier) of
        'TEST':begin
          print,event.identifier
        end;TEST
        'A3RAN':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
        end;A3RAN
        'A4RAN':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
        end;A4RAN
        'A3_MASK':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
        end;A3_MASK
        'A4_MASK':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
        end;A4_MASK        
        
        'SPECWEIGHTS':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'SPECWEIGHTS string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;SPECWEIGHTS
        'SPECMASK':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'SPECMASK string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier

        end;SPECMASK
        'DIFFWEIGHTS':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'SPECWEIGHTS string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;DIFFWEIGHTS
        'DIFFMASK':begin
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'DIFFMASK string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;DIFFMASK
        'ABC':begin
          print,'ABC'
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'ABC string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;ABC
        'ABG':begin  
          print,event.identifier
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'ABG string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;ABG
        'ORIENTATION':begin
          print,'ORIENTATION'
          macsrunner_v1_modifyITEM,event,string=string
;          event.component->SetPropertyAttribute,event.identifier, USERDEF =  string
;          print,'ORIENTATION string=',string
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;ORIENTATION

        else:begin
            value = widget_info( event.id, component = event.component,property_value = event.identifier )
            event.component->SetPropertyByIdentifier, event.identifier, value
    ;        MACSRunner_v1_updateProjList,(*pstate).projContainer,(*pstate).projList
    ;        if sel[0] ne -1 then begin
    ;          widget_control,(*pstate).projlist,set_list_select=sel[0]
    ;        endif   
            ;MACSRunner_v1_handleProjectList,pstate
            MACSRunner_v1_updateProjList,(*pstate).ProjContainer,(*pstate).projList
            widget_control,(*pstate).projlist,set_list_select=sel[0]
        endelse
        endcase
      endif else begin
        case strupcase(event.identifier) of
        'SPECWEIGHTS':begin
          print,event.identifier
;          (event.component)->getProperty,specWeights=specWeights
;          fmt = '(g6.4)'
;          newString = '['
;          for i=0,n_elements(specweights)-2 do begin
;            newString = newstring + strtrim(string(self.specweights[i],format=fmt),2)+','
;          endfor;i
;          newString = newstring + strtrim(string(self.specweights[n_elements(specweights)-1],format=fmt),2)+']'
;          event.component->SetPropertyAttribute,event.identifier, USERDEF = "Hey, is this working?"
;          widget_control, (*pstate).propertySheet, refresh_property = event.identifier
        end;SPECWEIGHTS
        'SPECMASK':begin
          print,event.identifier
        end;SPECMASK
        'DIFFWEIGHTS':begin
          print,event.identifier
        end;DIFFWEIGHTS
        'DIFFMASK':begin
          print,event.identifier
        end;DIFFMASK
        'ABC':begin
          print,'ABC'
         
        end;ABC
        'ABG':begin  
          print,'ABG'
        end;ABG
        'ORIENTATION':begin
          print,'ORIENTATION'
        end;ORIENTATION
        else:begin
            print,'SEL[0] lt 0   '+event.identifier
            value = widget_info( event.id, component = event.component,property_value = event.identifier )
            event.component->SetPropertyByIdentifier, event.identifier, value
            ;MACSRunner_v1_handleProjectList,pstate
            MACSRunner_v1_updateProjList,(*pstate).ProjContainer,(*pstate).projList
        endelse
        endcase


      endelse
      
    end;WIDGET_PROPSHEET_CHANGE
    'WIDGET_PROPSHEET_SELECT':begin
      print,'WIDGET_PROPSHEET_SELECT'
    end;WIDGET_PROPSHEET_SELECT
    else:
    endcase


end;MACSRunner_v1_HandlePropertySheet

pro MACSRunner_v1_addBGEmpty,event
    widget_control,event.handler,get_uvalue=pstate
    ;fn1 = MACSRunner_v1_files()
    fn1 = dialog_pickfile(filter='*.ng0',/multi,path = (*pstate).datadir,dialog_parent=(*pstate).tlb)
    if fn1[0] ne '' then begin
      (*pstate).datadir = file_dirname(fn1[0])
      (*pstate).workdir = file_dirname(fn1[0])
      (*pstate).projObject->setproperty,datadir=file_dirname(fn1[0]),workdir=file_dirname(fn1[0])
      widget_control,(*pstate).propertySheet,/refresh_property
    prog = nse_cwo_progress(labels=['Background Empty File:'],$
                           startvalues=[0L],$
                           endvalues=[n_elements(fn1)],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)
      
      for i=0,n_elements(fn1)-1 do begin
        d = obj_new('MACSRunner_v1_data',fn1[i])
        (*pstate).bgemptycontainer->add,d
        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,i
        endif
      endfor;i
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy
    
      MACSRunner_v1_sortContainer,(*pstate).bgemptycontainer
      MACSRunner_v1_updateList,(*pstate).bgemptycontainer,(*pstate).bgemptylist
      
    endif
end;MACSRunner_v1_addBGEmpty       
pro MACSRunner_V1_removeData,event
    widget_control,event.handler,get_uvalue=pstate
    sel = widget_info((*pstate).datalist,/list_select)
    if sel[0] ne -1 then begin
      sel = reverse(sel[sort(sel)])      
      dc = (*pstate).datacontainer
      for i=0,n_elements(sel)-1 do begin
        duh = dc->get(position=sel[i])
        dc->remove,position=sel[i]
        obj_destroy,duh
      endfor;i
      MACSRunner_v1_updateList,(*pstate).datacontainer,(*pstate).datalist    
    endif
end;MACSRunner_V1_removeData
pro MACSRunner_V1_addData,event
    widget_control,event.handler,get_uvalue=pstate
    fn1 = dialog_pickfile(filter='*.ng0',/multi,path = (*pstate).datadir,dialog_parent=(*pstate).tlb)
    if fn1[0] ne '' then begin
      (*pstate).datadir = file_dirname(fn1[0])
      (*pstate).workdir = file_dirname(fn1[0])
      (*pstate).projObject->setproperty,datadir=file_dirname(fn1[0]),workdir=file_dirname(fn1[0])
      widget_control,(*pstate).propertySheet,/refresh_property      
      prog = nse_cwo_progress(labels=['Data File:'],$
                             startvalues=[0L],$
                             endvalues=[n_elements(fn1)],$
                             values=[0L],$
                             steps=[1L],$
                             obj=progobj,$
                             title='MACSRunner_v1 Progress:   ',$
                             /nostop,$
                             dialog_parent=(*pstate).tlb)
      
      for i=0,n_elements(fn1)-1 do begin
        d = obj_new('MACSRunner_v1_data',fn1[i],abc=abc,abg=abg,o1=o1,o2=o2,weights=weights)
        ;print,abc
        ;print,abg
        ;print,o1
        ;print,o2
        if obj_valid(d) gt 0 then begin
          (*pstate).datacontainer->add,d
          (*pstate).projObject->setproperty,abc=abc,abg=abg,orientation = [o1,o2],$
                                            specWeights=weights.specWeights,diffWeights=weights.diffWeights
          widget_control,(*pstate).propertySheet,/refresh_property      
        endif;obj_valid(d)

        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,i
        endif

      endfor;i
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy

      MACSRunner_v1_handleProjectList,pstate
      MACSRunner_v1_sortContainer,(*pstate).datacontainer
      MACSRunner_v1_updateList,(*pstate).datacontainer,(*pstate).datalist

    endif
end;MACSRunner_V1_addData

pro MACSRunner_v1_addEmpty,event
    widget_control,event.handler,get_uvalue=pstate
    ;fn1 = MACSRunner_v1_files()
    fn1 = dialog_pickfile(filter='*.ng0',/multi,path = (*pstate).datadir,dialog_parent=(*pstate).tlb)
    prog = nse_cwo_progress(labels=['Empty File:'],$
                           startvalues=[0L],$
                           endvalues=[n_elements(fn1)],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)
    if fn1[0] ne '' then begin
      (*pstate).datadir = file_dirname(fn1[0])
      ;(*pstate).workdir = file_dirname(fn1[0])
      (*pstate).projObject->setproperty,datadir=file_dirname(fn1[0]);,workdir=file_dirname(fn1[0])
      widget_control,(*pstate).propertySheet,/refresh_property
      for i=0,n_elements(fn1)-1 do begin
        d = obj_new('MACSRunner_v1_data',fn1[i])
;        help,d
        if obj_valid(d) gt 0 then begin 
;          print,'Adding Object'
          (*pstate).emptycontainer->add,d
        endif else begin
          print,'Bad data in '+file_basename(fn1[i])
        endelse
        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,i
        endif
      endfor;i
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy
    
      MACSRunner_v1_sortContainer,(*pstate).emptycontainer
      MACSRunner_v1_updateList,(*pstate).emptycontainer,(*pstate).emptylist
      
    endif
end;


pro MACSRunner_V1_addBackground,event
    widget_control,event.handler,get_uvalue=pstate
    print,'(*pstate).addBKG'
    ;fn1 = MACSRunner_v1_files()
    fn1 = dialog_pickfile(filter='*.ng0',/multi,path = (*pstate).datadir,dialog_parent=(*pstate).tlb)
    if fn1[0] ne '' then begin
      (*pstate).datadir = file_dirname(fn1[0])
      (*pstate).workdir = file_dirname(fn1[0])
      (*pstate).projObject->setproperty,datadir=file_dirname(fn1[0]),workdir=file_dirname(fn1[0])
      widget_control,(*pstate).propertySheet,/refresh_property      
    prog = nse_cwo_progress(labels=['Background File:'],$
                           startvalues=[0L],$
                           endvalues=[n_elements(fn1)],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)
      for i=0,n_elements(fn1)-1 do begin
        d = obj_new('MACSRunner_v1_data',fn1[i])
        (*pstate).bkgcontainer->add,d

        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,i
        endif

      endfor;i
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy
      MACSRunner_v1_sortContainer,(*pstate).bkgcontainer
      MACSRunner_v1_updateList,(*pstate).bkgcontainer,(*pstate).bkglist
    endif
end;


pro MACSRunner_v1_removeBackground,event
    widget_control,event.handler,get_uvalue=pstate
    sel = widget_info((*pstate).bkglist,/list_select)
    if sel[0] ne -1 then begin
      sel = reverse(sel[sort(sel)])      
      bc = (*pstate).bkgcontainer
      for i=0,n_elements(sel)-1 do begin
        duh = bc->get(position=sel[i])
        bc->remove,position=sel[i]
        obj_destroy,duh
      endfor;i
      MACSRunner_v1_updateList,(*pstate).bkgcontainer,(*pstate).bkglist    
    endif
end;


pro MACSRunner_v1_removeEmpty,event
    widget_control,event.handler,get_uvalue=pstate
    sel = widget_info((*pstate).emptylist,/list_select)
    if sel[0] ne -1 then begin
      sel = reverse(sel[sort(sel)])      
      dc = (*pstate).emptycontainer
      for i=0,n_elements(sel)-1 do begin
        duh = dc->get(position=sel[i])
        dc->remove,position=sel[i]
        obj_destroy,duh
      endfor;i
      MACSRunner_v1_updateList,(*pstate).emptycontainer,(*pstate).emptylist    
    endif
end;MACSRunner_v1_removeEmpty

pro MACSRunner_v1_removeBGEmpty,event
    widget_control,event.handler,get_uvalue=pstate
    sel = widget_info((*pstate).bgemptylist,/list_select)
    if sel[0] ne -1 then begin
      sel = reverse(sel[sort(sel)])      
      dc = (*pstate).bgemptycontainer
      for i=0,n_elements(sel)-1 do begin
        duh = dc->get(position=sel[i])
        dc->remove,position=sel[i]
        obj_destroy,duh
      endfor;i
      MACSRunner_v1_updateList,(*pstate).bgemptycontainer,(*pstate).bgemptylist    
    endif
end;MACSRunner_v1_removeBGEmpty

pro MACSRunner_v1_event,event
 
  catch,es
  if es ne 0 then begin
    errormsg = ['The following problem occurred in MACSRunner_v1:',!error_state.msg]
    void = dialog_message(ERRORmsg,DIALOG_PARENT=(*PSTATE).TLB)  
    nse_cleanUpProgressWindows
    catch,/cancel
    return
  endif;catch   
 
  widget_control,event.handler,get_uvalue=pstate

  case event.id of
  (*pstate).retrieve:begin
    macs_grabFTPFiles,group_leader=(*pstate).tlb
  end;retrieve
  (*pstate).specdraw:begin
    etype = strupcase(tag_names(event,/structure_name))
    ;print,etype
    ;help,*pstate,/struct
    case etype of
    'WIDGET_DRAW':begin

      ;print,'SpecDraw: x,y=',event.x,event.y;,convert_coord
      ;help,(*pstate).specX,(*pstate).specY
      if (*pstate).specActive gt 0 then begin
        if ptr_valid((*pstate).specx) gt 0 and ptr_valid((*pstate).specx) gt 0 then begin
        endif;AXIS POINTERS DEFINED
      endif;specActive
    end;WIDGET_DRAW
    'WIDGET_TRACKING':begin
      (*pstate).specActive  = event.enter
      wset,(*pstate).winvisSpec      
    end;WIDGET_TRACKING
    else:
    endcase
  end;specdraw
  (*pstate).diffdraw:begin
    etype = strupcase(tag_names(event,/structure_name))
    ;print,etype
    case etype of
    'WIDGET_DRAW':begin
      ;print,'DiffDraw: x,y=',event.x,event.y;,convert_coord
      ;help,(*pstate).diffX,(*pstate).diffY
      if (*pstate).diffActive gt 0 then begin
        if ptr_valid((*pstate).diffx) gt 0 and ptr_valid((*pstate).diffx) gt 0 then begin
;          !x = *((*pstate).diffx)
;          !y = *((*pstate).diffy)
;          pos = round(1000.0*convert_coord(event.x,event.y,/device,/to_data))/1000.0
;          ;print,'pos=',pos[0:1]
;          fmt = '(g15.3)'
;          str = '['+strtrim(string(pos[0],format=fmt),2)+',   '+strtrim(string(pos[1],format=fmt),2)+']'
;          wset,(*pstate).winvisdiff      
;          device,copy=[0,0,(*pstate).xsize,(*pstate).ysize,0,0,(*pstate).winpixdiff]
;          device,get_decomposed=dc
;          device,decomposed=1
;          xyouts,0.1,0.1,str,/device,color=0L
;          
;          
;  q = sqrt(pos[0]^2 + pos[1]^2)
;  efixed = 14.7
;  etransfer = 1.0
;  s = myreselps(q,etransfer,efixed,closed=closed);,$
;                 ;collimatorh,collimatorv,mosaic,dspacing,instrument_orient,$
;                 ;source=source,horifoc=horifoc,closed=closed)
;  if n_elements(closed) ne 0 then title = 'closed='+string(closed) else title = ''
;  theta = 2*!dpi*findgen(1001)/1000.0
;  phi   = 2*!dpi*findgen(1001)/1000.0;2*!pi*findgen(10001)/10000.0
;
;  ;PERP-E
;  r = r_of_theta_phi(s.m,!Pi/2.0,phi)
;  arrow,0.0,0.0,pos[0],pos[1],/data
;  oplot,pos[0]+r*cos(phi),pos[1]+r*sin(phi)
;          
;          
          
          
          device,decomposed=dc         
        endif;AXIS POINTERS DEFINED
      endif;diffActive
    end;WIDGET_DRAW
    'WIDGET_TRACKING':begin
;      help,event,/struct
      (*pstate).diffActive  = event.enter
    end;WIDGET_TRACKING
    else:
    endcase
  end;diffdraw
  (*pstate).propertySheet:begin
    MACSRunner_v1_HandlePropertySheet,event
  end;(*pstate).propertySheet
  (*pstate).quickslice:begin
    MACSRunner_v1_slice,pstate,/quickslice
  end;quickslice
  (*pstate).Mslice:begin
    prog = nse_cwo_progress(labels=['MSlice:'],$
                           startvalues=[0L],$
                           endvalues=[1L],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)
      


    ;GET THE IMAGES PRODUCED BY EACH OF THESE IN THE DRAW WINDOW AND THEN COPY TO THE 
    ;DISPLAY WINDOW    
    MACSRunner_v1_slice,pstate,/mslice    


        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,1
        endif
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy


  end;Mslice
  (*pstate).writeMslice:begin


    prog = nse_cwo_progress(labels=['Write MSlice Data:'],$
                           startvalues=[0L],$
                           endvalues=[1L],$
                           values=[0L],$
                           steps=[1L],$
                           obj=progobj,$
                           title='MACSRunner_v1 Progress:   ',$
                           /nostop,$
                           dialog_parent=(*pstate).tlb)
      


    ;GET THE IMAGES PRODUCED BY EACH OF THESE IN THE DRAW WINDOW AND THEN COPY TO THE 
    ;DISPLAY WINDOW    
    MACSRunner_v1_slice,pstate,/mslice,/writeMslice    


        ;UPDATE COUNTER AND PROGRESS WIDGET
        if obj_valid(progobj) gt 0 then begin
          progobj->set,0,1
        endif
      if widget_info(prog,/valid) gt 0 then widget_control,prog,/destroy


  end;writeMslice
  (*pstate).open:begin
    MACSRunner_v1_restoreSession,pstate  
    MACSRunner_v1_updateProjList,(*pstate).projContainer,(*pstate).projList    
    MACSRunner_v1_updateList,(*pstate).dataContainer,(*pstate).dataList    
    MACSRunner_v1_updateList,(*pstate).bkgContainer,(*pstate).bkgList    
    MACSRunner_v1_updateList,(*pstate).emptyContainer,(*pstate).emptyList    
    MACSRunner_v1_updateList,(*pstate).bgemptyContainer,(*pstate).bgemptyList    
  end;open
  (*pstate).save:begin
    MACSRunner_v1_saveSession,pstate
  end;save
  (*pstate).print:begin
     print,'PRINT'
  end;printImages
  (*pstate).quit:begin
    yn = dialog_message('Save Session?',/question)
    if strupcase(yn) eq 'YES' then MACSRunner_v1_saveSession,pstate
    widget_control,(*pstate).tlb,/destroy
  end;quit
  (*pstate).dataList:begin
    ;print,'(*pstate).dataList'
    ;help,event,/struct
    case tag_names(event,/structure_name) of
    'WIDGET_CONTEXT':begin
      widget_DISPLAYCONTEXTMENU,(*pstate).dataList,event.x,event.y,(*pstate).dataContext
    end;WIDGET_CONTEXT
    'WIDGET_LIST':begin
      
    end;WIDGET_LIST
    else:begin
    endelse
    endcase
  end;dataList
  (*pstate).bkgList:begin
    ;print,'(*pstate).bkgList'
    ;help,event,/struct
    case tag_names(event,/structure_name) of
    'WIDGET_CONTEXT':begin
      widget_DISPLAYCONTEXTMENU,(*pstate).bkgList,event.x,event.y,(*pstate).bkgContext
    end;WIDGET_CONTEXT
    'WIDGET_LIST':begin
      
    end;WIDGET_LIST
    else:begin
    endelse
    endcase
  end;bkgList
  (*pstate).emptyList:begin
   ; print,'(*pstate).emptyList'
    ;help,event,/struct
    case tag_names(event,/structure_name) of
    'WIDGET_CONTEXT':begin
      widget_DISPLAYCONTEXTMENU,(*pstate).emptyList,event.x,event.y,(*pstate).emptyContext
    end;WIDGET_CONTEXT
    'WIDGET_LIST':begin
      
    end;WIDGET_LIST
    else:begin
    endelse
    endcase
  end;emptyList
  (*pstate).bgemptyList:begin
    ;print,'(*pstate).bgemptyList'
    ;help,event,/struct
    case tag_names(event,/structure_name) of
    'WIDGET_CONTEXT':begin
      widget_DISPLAYCONTEXTMENU,(*pstate).bgemptyList,event.x,event.y,(*pstate).bgemptyContext
    end;WIDGET_CONTEXT
    'WIDGET_LIST':begin
      
    end;WIDGET_LIST
    else:begin
    endelse
    endcase
  end;bgemptyList
  (*pstate).projList:begin
    ;GET THE SELECTED PROJECT
    ;UPDATE THE DATA, BKG, EMPTY CONTAINERS
    ;UPDATE THE LISTS
    case tag_names(event,/structure_name) of
    'WIDGET_CONTEXT':begin
      widget_DISPLAYCONTEXTMENU,(*pstate).projList,event.x,event.y,(*pstate).projContext
    end;WIDGET_CONTEXT
    'WIDGET_LIST':begin
      
      MACSRunner_v1_handleProjectList,pstate

      
    end;WIDGET_LIST
    else:begin
    endelse
    endcase
    
  end;projList
  (*pstate).DataMenuAdd:begin
    MACSRunner_V1_addData,event
  end;DataMenuAdd
  (*pstate).addData:begin
    MACSRunner_V1_addData,event
  end;addData
  (*pstate).DataMenuRemove:begin
    MACSRunner_V1_removeData,event
  end;DataMenuRemove
  (*pstate).removeData:begin
    MACSRunner_V1_removeData,event
  end;removeData
  (*pstate).DataMenuView:begin
    widget_control,(*pstate).text,set_value='viewDataContents'
    MACSRunner_v1_viewContents,pstate,/data
  end;DataMenuView
  (*pstate).viewDataContents:begin
    widget_control,(*pstate).text,set_value='viewDataContents'
    MACSRunner_v1_viewContents,pstate,/data
  end;viewDataContents


  (*pstate).BackgroundMenuAdd:begin
    MACSRunner_V1_addBackground,event
  end;BackgroundMenuAdd
  (*pstate).addBKG:begin
    MACSRunner_V1_addBackground,event
  end;addBKG
  (*pstate).BackgroundMenuRemove:begin
    MACSRunner_v1_removeBackground,event
  end;BackgroundMenuRemove
  (*pstate).removeBKG:begin
    MACSRunner_v1_removeBackground,event
  end;removeBkg
  (*pstate).BackgroundMenuView:begin
    widget_control,(*pstate).text,set_value='viewBkgContents'
    MACSRunner_v1_viewContents,pstate,/bkg
  end;BackgroundMenuView
  (*pstate).viewbkgContents:begin
    widget_control,(*pstate).text,set_value='viewBkgContents'
    MACSRunner_v1_viewContents,pstate,/bkg
  end;viewBkgContents

  (*pstate).EmptyMenuAdd:begin
    MACSRunner_v1_addEmpty,event
  end;EmptyMenuAdd
  (*pstate).addEmpty:begin
    MACSRunner_v1_addEmpty,event
  end;addEmpty
  (*pstate).EmptyMenuRemove:begin
    MACSRunner_v1_removeEmpty,event
  end;EmptyMenuRemove
  (*pstate).removeEmpty:begin
    MACSRunner_v1_removeEmpty,event
  end;removeEmpty

  (*pstate).EmptyMenuView:begin
    widget_control,(*pstate).text,set_value='viewEmptyContents'
    MACSRunner_v1_viewContents,pstate,/empty
  end;EmptyMenuView
  (*pstate).viewEmptyContents:begin
    widget_control,(*pstate).text,set_value='viewEmptyContents'
    MACSRunner_v1_viewContents,pstate,/empty
  end;viewEmptyContents

  (*pstate).addbgEmpty:begin
    MACSRunner_v1_addBGEmpty,event       
  end;addBGEmpty
  (*pstate).BackgroundEmptyMenuAdd:begin
    MACSRunner_v1_addBGEmpty,event
  end;BackgroundEmptyMenuAdd

  (*pstate).BackgroundEmptyMenuRemove:begin
    MACSRunner_v1_removeBGEmpty,event
  end;BackgroundEmptyMenuRemove
  (*pstate).removeBGEmpty:begin
    MACSRunner_v1_removeBGEmpty,event
  end;removeBGEmpty

  (*pstate).BackgroundEmptyMenuView:begin
    widget_control,(*pstate).text,set_value='viewBGEmptyContents'
    MACSRunner_v1_viewContents,pstate,/bgempty
  end;BackgroundEmptyMenuView
  (*pstate).viewbgEmptyContents:begin
    widget_control,(*pstate).text,set_value='viewBGEmptyContents'
    MACSRunner_v1_viewContents,pstate,/bgempty
  end;viewbgEmptyContents

  (*pstate).addProject:begin
    nproj = (*pstate).projContainer->count()
    newname = 'Project '+strtrim(string(nproj),2)

    o = obj_new('macsrunner_v1_project',myname=newname,name=newname,description='MACS Data Project',$
                 zminspec = -200,zmaxspec = 1000,zmindiff=-200,zmaxdiff=10000,dcontainer=dcontainer,$
                 bcontainer=bcontainer,econtainer=econtainer,becontainer=becontainer)
;    dcontainer = obj_new('idl_container')
;    bcontainer = obj_new('idl_container')
;    econtainer = obj_new('idl_container')
;    becontainer = obj_new('idl_container')
    (*pstate).datacontainer = dcontainer
    (*pstate).bkgcontainer = bcontainer
    (*pstate).emptycontainer = econtainer
    (*pstate).bgemptycontainer = becontainer


;    o->add,dcontainer,position=0
;    o->add,bcontainer,position=1
;    o->add,econtainer,position=2
;    o->add,becontainer,position=3

    (*pstate).projObject = o
    
    (*pstate).projContainer->add,o
    widget_control,(*pstate).propertySheet,set_value=o
    

    MACSRunner_v1_updateProjList,(*pstate).projContainer,(*pstate).projList   

    
  end;addProject
  (*pstate).copyProject:begin


      if (*pstate).projcontainer->count() gt 0 then begin
          ;GET NEW SELECTION
          sel = widget_info((*pstate).projlist,/list_select)
          if sel[0] eq -1 then sel = 0
          
          p = (*pstate).projcontainer->get(position=sel[0])
          o = p->clone(dcontainer=dcontainer,$
                        bcontainer=bcontainer,$
                        econtainer=econtainer,$
                        becontainer=becontainer)

          (*pstate).datacontainer = dcontainer
          (*pstate).bkgcontainer = bcontainer
          (*pstate).emptycontainer = econtainer
          (*pstate).bgemptycontainer = becontainer

          (*pstate).projObject = o

          (*pstate).projContainer->add,o
          widget_control,(*pstate).propertySheet,set_value=o

          MACSRunner_v1_updateProjList,(*pstate).projContainer,(*pstate).projList   

      endif;projects available
  end;copyProject
  (*pstate).removeProject:begin

print,'NEED TO DEAL WITH THE DELETION OF THE FINAL PROJECT'

    nproj = (*pstate).projContainer->count()
        
      if (*pstate).projcontainer->count() gt 0 then begin
          ;GET NEW SELECTION
          sel = widget_info((*pstate).projlist,/list_select)
          if sel[0] eq -1 then sel = 0
          
          p = (*pstate).projcontainer->get(position=sel[0])
          (*pstate).projcontainer->remove,position=sel[0]


          if (*pstate).projcontainer->count() gt 0 then begin

                  newp = (*pstate).projcontainer->get(position=0)
                  ;UPDATE PROPERTY SHEET
                  widget_control,(*pstate).propertysheet,set_value=newp
            
                  ;UPDATE CONTAINERS
                  (*pstate).projObject = newp
                  dc = newp->get(position=0)
                  bc = newp->get(position=1)
                  ec = newp->get(position=2)
                  bec = newp->get(position=3)
                  (*pstate).datacontainer = dc
                  (*pstate).bkgcontainer = bc
                  (*pstate).emptycontainer = ec
                  (*pstate).bgemptycontainer = bec
            
                  ;UPDATE LISTS
                  MACSRunner_v1_sortContainer,(*pstate).datacontainer
                  MACSRunner_v1_updateList,(*pstate).datacontainer,(*pstate).datalist
            
                  MACSRunner_v1_sortContainer,(*pstate).bkgcontainer
                  MACSRunner_v1_updateList,(*pstate).bkgcontainer,(*pstate).bkglist
            
                  MACSRunner_v1_sortContainer,(*pstate).emptycontainer      
                  MACSRunner_v1_updateList,(*pstate).emptycontainer,(*pstate).emptylist      
            
                  MACSRunner_v1_sortContainer,(*pstate).bgemptycontainer      
                  MACSRunner_v1_updateList,(*pstate).bgemptycontainer,(*pstate).bgemptylist      
        
                  MACSRunner_v1_updateProjList,(*pstate).ProjContainer,(*pstate).projList
        
                  macsrunner_v1_setUpProjectPropertySheet,{handler:(*pstate).tlb}
                  widget_control,(*pstate).projList,set_list_select=0
        
          endif
                  
          obj_destroy,p
        
        
      endif $;count gt 0
      else begin
                  
      endelse
    
    
    
    
    
  end;removeProject
;  (*pstate).renameProject:begin
;    print,'(*pstate).renameProject'
;  end;renameProject
  else:
  endcase

end;MACSRunner_v1_event


pro macsrunner_v1_setUpProjectPropertySheet,event


    widget_control,event.handler,get_uvalue=pstate

    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'A3RAN'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'A4RAN'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'A3_MASK'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'A4_MASK'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'ABC'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'ABG'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'SPECWEIGHTS'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'DIFFWEIGHTS'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'SPECMASK'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'DIFFMASK'},/nodialog
    macsrunner_v1_modifyITEM,{handler:event.handler,component:(*pstate).ProjObject,identifier:'ORIENTATION'},/nodialog



end;macsrunner_v1_setUpProjectPropertySheet
pro MACSRunner_v1_cleanup,id

  widget_control,id,get_uvalue=pstate
  if ptr_valid((*pstate).specx) then ptr_free,(*pstate).specx
  if ptr_valid((*pstate).specy) then ptr_free,(*pstate).specy

  if ptr_valid((*pstate).diffx) then ptr_free,(*pstate).diffx
  if ptr_valid((*pstate).diffy) then ptr_free,(*pstate).diffy

  if ptr_valid(pstate) then ptr_free,pstate

  ;ARE ALL THE OBJECTS CLEANED UP???????
  ;WHAT ABOUT THE CONTAINERS?????



end;MACSRunner_v1_cleanup

pro launch_MACSRunner_v1,event,$
                 group_leader=group_leader,$
                 workDir=workDir,$
                 dataDir=dataDir,$
                 DAVETool=DAVETool,$
                 _Extra=extra
;
;NAME:
;        launch_MACSRunner_v1
;
;PURPOSE:
;           Launch MACSRunner_v1 application from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.

  if n_elements(event) eq 0 then begin
        MACSRunner_v1,group_leader=group_leader,$
                      datadir=datadir,workdir=workdir,$
                      davetool=davetool,_extra=extra
  endif else begin
        this_event = tag_names(event,/structure_name)
        MACSRunner_v1,group_leader=event.top,$
                        workDir=workDir,$
                        dataDir=dataDir,$
                        DAVETool=DAVETool,$
                        _Extra=extra
  endelse
end;launch_MACSRunner_v1




pro MACSRunner_v1,group_leader=group_leader,datadir=datadir,workdir=workdir,davetool=davetool,_extra=extra

  if n_elements(datadir) eq 0 then datadir = '.'
  if n_elements(workdir) eq 0 then workdir = '.'
  if n_elements(davetool) eq 0 then daveTool = obj_new()
  
  device,get_screen_size=scrsz
  
  
  tlb = widget_base(title='MACSRunner_v1',mbar=bar,/row,group_leader=group_leader,xoff=200,yoff=200)

  ;centertlb,tlb

  file = widget_button(bar,/menu,value='File')
  open = widget_button(file,value='Open Session')
  save = widget_button(file,value='Save Session')
  retrieve = widget_button(file,value='Retrieve Public FTP Data')
  print = widget_button(file,value='Print Images')
  MacsSummerSchoolButton1 = widget_button(file,value='AutoPlot CuPzN_1p6K_BGsub.dat',event_pro='MACSRunner_v1_plotpcupzn')
  MacsSummerSchoolButton2 = widget_button(file,value='AutoPlot CuPzN_1p6K_fold_summer school.dat',event_pro='MACSRunner_v1_plotpcupzn2')

  quit = widget_button(file,value='Quit')

  DataMenu = widget_button(bar,/menu,value='Data')
  DataMenuAdd = widget_button(dataMenu,value='Add Data File(s)')
  DataMenuRemove = widget_button(dataMenu,value='Remove Selected Data File(s)')
  DataMenuView = widget_button(dataMenu,value='View Selected File Contents')
  
  BackgroundMenu = widget_button(bar,/menu,value='Background')
  BackgroundMenuAdd = widget_button(BackgroundMenu,value='Add Background File(s)')
  BackgroundMenuRemove = widget_button(BackgroundMenu,value='Remove Selected Background File(s)')
  BackgroundMenuView = widget_button(BackgroundMenu,value='View Selected File Contents')

  EmptyMenu = widget_button(bar,/menu,value='Empty')
  EmptyMenuAdd = widget_button(EmptyMenu,value='Add Emtpy File(s)')
  EmptyMenuRemove = widget_button(EmptyMenu,value='Remove Selected Empty File(s)')
  EmptyMenuView = widget_button(EmptyMenu,value='View Selected File Contents')

  BackgroundEmptyMenu = widget_button(bar,/menu,value='BackgroundEmpty')
  BackgroundEmptyMenuAdd = widget_button(BackgroundEmptyMenu,value='Add Background Emtpy File(s)')
  BackgroundEmptyMenuRemove = widget_button(BackgroundEmptyMenu,value='Remove Selected Bg Empty File(s)')
  BackgroundEmptyMenuView = widget_button(BackgroundEmptyMenu,value='View Selected File Contents')


  if strupcase(!version.os_family) eq 'WINDOWS' then begin 
    projysize = 5
    textysize = 8
    dataysize = 12
    bkgysize = 4
    emptyysize = 4
    bgemptyysize = 4
    propSheetysize = 22
    xsize = 500
    ysize = 400    
  endif else begin
    ;MAC/LINUX
    projysize = 4
    textysize = 6
    dataysize = 8
    bkgysize = 3
    emptyysize = 3
    bgemptyysize = 3   
    propsheetysize = 20
    xsize = 500
    ysize = 400     
  endelse

  ;GET THE PROJECT CONTAINER SYSTEM FROM THE OTHER APP.  
  lb1 = widget_base(tlb,/col)
  rb1 = widget_base(lb1,/row)
  rb2 = widget_base(lb1,/row)
  ;llb1 = widget_base(tlb,/col)
  llb1 = widget_base(rb1,/col)
  col0 = widget_base(llb1,/col,frame=2)
  ;llb2 = widget_base(tlb,/col,tab_mode=1)
  llb2 = widget_base(rb1,/col,tab_mode=1)
  col1 = widget_base(llb2,/col,frame=2)
  col2 = widget_base(llb2,/col,frame=2)
  col3 = widget_base(llb2,/col,frame=2)

  text = widget_text(rb2,xsize=80,ysize=textysize,/scroll)

;SET UP THE DATA MANAGER
  projlabel = widget_text(col0,value='PROJECTS (Right-Click list for options)')
  projlist = widget_list(col0,xsize=40,ysize=projysize,/context_events)

  datalabel = widget_text(col1,value='DATA (Right-Click lists to load)')
  datalist = widget_list(col1,xsize=40,ysize=dataysize,/multiple,/context_events)

  bkglabel = widget_text(col2,value='BACKGROUND')
  bkglist = widget_list(col2,xsize=40,ysize=bkgysize,/multiple,/context_events)

  emptylabel = widget_text(col3,value='EMPTY')
  emptylist = widget_list(col3,xsize=40,ysize=emptyysize,/multiple,/context_events)

  bgemptylabel = widget_text(col3,value='BG EMPTY')
  bgemptylist = widget_list(col3,xsize=40,ysize=bgemptyysize,/multiple,/context_events)

  projcontext = widget_base(projlist,/context_menu)
  addproject = widget_button(projcontext,value='New Project')
  copyProject = widget_button(projcontext,value='Copy Project')
  removeproject = widget_button(projcontext,value='Remove Project')
  renameproject = widget_button(projcontext,value='Rename Project')


  datacontext = widget_base(datalist,/context_menu)
  adddata = widget_button(datacontext,value='Add Data')
  removedata = widget_button(datacontext,value='Remove Data')
  viewdataContents = widget_button(datacontext,value='View Data Selection Contents')

  bkgcontext = widget_base(bkglist,/context_menu)
  addbkg = widget_button(bkgcontext,value='Add Background')
  removebkg = widget_button(bkgcontext,value='Remove Background')
  viewbkgContents = widget_button(bkgcontext,value='View Background Selection Contents')


  emptycontext = widget_base(emptylist,/context_menu)
  addempty = widget_button(emptycontext,value='Add Empty')
  removeempty = widget_button(emptycontext,value='Remove Empty')
  viewEmptyContents = widget_button(emptycontext,value='View Empty Selection Contents')  

  bgemptycontext = widget_base(bgemptylist,/context_menu)
  addbgempty = widget_button(bgemptycontext,value='Add BG Empty')
  removebgempty = widget_button(bgemptycontext,value='Remove BG Empty')
  viewbgEmptyContents = widget_button(bgemptycontext,value='View BG Empty Selection Contents')  

;ALSO NEED TO SET UP TO MANAGE THESE!!!
  projcontainer = obj_new('idl_container')

  ;proj1 = obj_new('macsScanProject',name='TEST PROJECT');idl_container')
  proj1 = obj_new('macsRunner_v1_Project',name='TEST PROJECT',myname='TEST PROJECT',$
                   zminspec=-200,zmaxspec=2000.0,$
                   zmindiff=-200,zmaxdiff=20000.0,$
                   datascalefactor=1.0,$
                   bkgscalefactor=1.0,$
                   emptyscalefactor=1.0,$
                   bg_emptyscalefactor=1.0,$
                  description='MACS DATA PROJECT',workdir=workdir,datadir=datadir)  


    o = obj_new('macsrunner_v1_project',myname=newname,name=newname,description='MACS Data Project',$
                 zminspec = -200,zmaxspec = 1000,zmindiff=-200,zmaxdiff=10000,dcontainer=datacontainer,$
                 bcontainer=bkgcontainer,econtainer=emptycontainer,becontainer=bgemptycontainer)

;  datacontainer = obj_new('idl_container')
;  bkgcontainer = obj_new('idl_container')
;  emptycontainer = obj_new('idl_container')   
;  bgemptycontainer = obj_new('idl_container')   

  projobject = proj1

;  proj1->add,datacontainer,position=0
;  proj1->add,bkgcontainer,position=11450
;  proj1->add,emptycontainer,position=2
;  proj1->add,bgemptycontainer,position=3
  

  projcontainer->add,proj1,position=projContainer->count()



;  quickslice = widget_button(tlb,value='QuickSlice')
;  mslice = widget_button(tlb,value='MSlice')
;  llb2 = widget_base(tlb,/row)
;  llb2 = widget_base(tlb,/col,tab_mode=1)

  kidneybinsize = 0L;cw_field(col0,value=3.0,/floating,title='KidneyBinsize')
  a3binsize = 0L;cw_field(col0,value=1.0,/floating,title='A3Binsize')
  zmin = 0L;cw_field(col0,value=-500.0,/floating,title='zmin')
  zmax = 0L;cw_field(col0,value=2000.0,/floating,title='zmax')
  quickslice = widget_button(llb2,value='QuickSlice')
  macsbuttonbase = widget_base(llb2,frame=2,/col)
  ChoiceRow = widget_base(macsButtonBase,/row)
  msliceChoice = cw_bgroup(choiceRow,['Spec','Diff'],/nonexclusive,$;/exclusive,$
                                          label_left='MSlice Choice',/row,frame=1)
  msliceChoicePowder = cw_bgroup(ChoiceRow,['Powder'],/nonexclusive,/row)

  msliceKeep = cw_bgroup(macsbuttonbase,['Keep Current Mslice Window'],/nonexclusive,/row)
  summerSchool = cw_bgroup(macsbuttonbase,['Only for powder: Plot (ki-kf*cos(a4)) vs. hw'],/nonexclusive,/row)
  mslice = widget_button(macsbuttonbase,value='MSlice')
  writeMslice = widget_button(macsbuttonbase,value='Write MSlice to ASCII')
  
  msliceContainer = obj_new('idl_container')
  

  propertySheet = widget_propertysheet(col0,value=proj1,ysize=propSheetysize,/sunken_frame)

  projlisting = strarr(projcontainer->count())
  for i=0,projcontainer->count()-1 do begin
    temp = projcontainer->get(position=i)
    temp->getProperty,name=name
    projlisting[i] = name
  endfor;i
  widget_control,projlist,set_value=projlisting,set_list_select=0


  
  llb3 = widget_base(tlb,/col)
  window,/free,/pixmap,xsize=xsize,ysize=ysize
  winpixSpec = !d.window
  window,/free,/pixmap,xsize=xsize,ysize=ysize
  winpixDiff = !d.window
  specdraw = widget_draw(llb3,xsize=xsize,ysize=ysize,/motion_events,/button_events,/tracking_events)
  diffdraw = widget_draw(llb3,xsize=xsize,ysize=ysize,/motion_events,/button_events,/tracking_events)  

  widget_control,tlb,/realize
  widget_control,specdraw,get_value=winvisSpec
  widget_control,diffdraw,get_value=winvisDiff
  widget_control,msliceChoice,set_value=0
  
  state = {tlb:tlb,davetool:davetool,$
           obj_mslice:obj_new(),$
           quickslice:quickslice,mslice:mslice,msliceChoice:msliceChoice,writeMslice:writeMslice,$
           msliceChoicePowder:msliceChoicePowder,$
           summerSchool:summerSchool,$
           msliceKeep:msliceKeep,MsliceContainer:msliceContainer,$
           winpixSpec:winpixSpec,winPixDiff:winPixDiff,winvisSpec:winvisSpec,winvisDiff:winvisDiff,$
           specdraw:specDraw,diffDraw:diffDraw,$
           specActive:0,diffActive:0,$  ;KEEPS TRACK OF WHETHER WE ARE TRACKING MOTIONS IN THE DRAW WINDOWS
           specx:ptr_new(),$
           specy:ptr_new(),$
           diffx:ptr_new(),$
           diffy:ptr_new(),$           
           dataContainer:dataContainer,bkgContainer:bkgContainer,$
           emptyContainer:emptyContainer,bgemptyContainer:bgemptyContainer,$
           projContainer:projContainer,$
           dataList:dataList,bkgList:bkgList,emptyList:emptyList,bgemptyList:bgemptyList,$
           projList:projList,$
           DataContext:DataContext,BKGContext:BkgContext,EmptyContext:EmptyContext,bgEmptyContext:bgEmptyContext,$
           projContext:projContext,$
           addData:addData,addBKG:AddBkg,addEmpty:addEmpty,addBGEmpty:addBGEmpty,$
           removeData:removeData,removeBKG:removeBkg,removeEmpty:removeEmpty,removeBGEmpty:removeBGEmpty,$
           viewDataContents:viewDataContents,viewbkgContents:viewBkgContents,viewEmptyContents:viewEmptyContents,$
           viewBGEmptyContents:viewBGEmptyContents,$
           DataMenuAdd:DataMenuAdd,$
           DataMenuRemove:DataMenuRemove,$
           DataMenuView:DataMenuView,$
           BackgroundMenuAdd:BackgroundMenuAdd,$
           BackgroundMenuRemove:BackgroundMenuRemove,$
           BackgroundMenuView:BackgroundMenuView,$
           EmptyMenuAdd:EmptyMenuAdd,$
           EmptyMenuRemove:EmptyMenuRemove,$
           EmptyMenuView:EmptyMenuView,$
           BackgroundEmptyMenuAdd:BackgroundEmptyMenuAdd,$
           BackgroundEmptyMenuRemove:BackgroundEmptyMenuRemove,$
           BackgroundEmptyMenuView:BackgroundEmptyMenuView,$
           addProject:addProject,removeProject:removeProject,renameProject:renameProject,$
           copyProject:copyProject,$
           projObject:projObject,$
           kidneybinsize:kidneybinsize, a3binsize:a3binsize, zmin:zmin, zmax:zmax,$
           datadir:datadir,workdir:workdir,propertysheet:propertysheet,$
           xsize:xsize,ysize:ysize,$
           open:open,save:save,quit:quit,print:print,text:text,retrieve:retrieve}

  pstate = ptr_new(state)
  widget_control,tlb,set_uvalue=pstate

  xmanager,'MACSRunner_v1',tlb,event_handler='MACSRunner_v1_event',cleanup='MACSRunner_v1_cleanup',/no_block
  widget_control,projlist,set_list_select = 0
  MACSRunner_v1_handleProjectList,pstate
  macsrunner_v1_setUpProjectPropertySheet,{handler:tlb}

end;MACSRunner_v1


