; $Id$


pro macs_plotslice,xi,yi,zi,avhw,ncg=ncg,ps=ps,spec=spec,diff=diff,jpeg=jpeg,_extra=_extra
;-----------------------------------------------------------------------------------
;   ncg: pixel side length of averaging area
;   file: Name of output normalization file
;   ps: set to 1 for post script output
;   _extra: transfer additional keywords to plotsq routine
;------------------------------------------------------------------------------------


title = '!6!s!8h!r!e!u!3_!n !7x!6='+string(avhw,form='(f5.2)')+' meV'

if n_elements(spec) eq 0 then spec = 0
if n_elements(diff) eq 0 then diff = 0

if spec eq 1 then title = 'Spec: '+ title
if diff eq 1 then title = 'Diff; '+ title



if n_elements(ncg) eq 1 then zo = macs_cgrain(zi,ncg,ncg,white=white) else zo=zi


;--------------------
; actual plotting
;--------------------
if keyword_set(ps) then begin
  mydevice = !D.NAME 
  set_plot,'ps'
  device,/color,ysize=20,xsize=22,file=file,yoff=5
  loadct,4
  macs_plotsq,zo,xi,yi,white=white,xtit='!6Q!dx!n (!sA!r!e!u!9%!6-1!n)',ytit='!6Q!dy!n (!sA!r!e!u!9%!6-1!n)' $
    ,tit=title,pos=[.15,.15,.85,.9],_extra=_extra
  device,/close
  SET_PLOT, mydevice
end else $
  macs_plotsq,zo,xi,yi,white=white,xtit='!6Q!dx!n (!sA!r!e!u!9%!6-1!n)',ytit='!6Q!dy!n (!sA!r!e!u!9%!6-1!n)'   $
          ,tit=title,_extra=_extra;,pos=[.15,.15,.85,.9],_extra=_extra

end;macs_plotslice
