; $Id$
;###############################################################################
;
; NAME:
;  SPLIT_SCAN_DIALOG
;
; PURPOSE:
;  Dialog for "split-scan" functionality.
;
; CATEGORY:
;  DAVE, HFBS, data reduction
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro ss_event,event
widget_control,event.top,get_uvalue = pstate
uname = widget_info(event.id,/uname)
case uname of
'ACCEPT':	$
	begin
		(*pstate).cancel = 0
		id = widget_info(event.top,find_by_uname = 'SPLIT_VALUES')
		widget_control,id,get_value = val
		exec_output = 'x=['+val[0]+']'
		r = execute(exec_output,1)
		if r eq 0 then begin
			strout = 'syntax error'
			void = dialog_message(dialog_parent = event.top,strout)
			return
		endif
		*(*pstate).tarray_ptr = x
		widget_control,event.top,/destroy
	end
'CANCEL':	$
	begin
		(*pstate).cancel = 1
		widget_control,event.top,/destroy
	end
else:
endcase
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function split_scan_dialog,group_leader = group_leader
tlb = widget_base(/col,group_leader = group_leader,/modal,/tlb_frame_attr)
void = cw_field(tlb,value = '', $
	title = 'Enter comma-delimited split points, e.g. 56.0,129.2', $
	uname = 'SPLIT_VALUES')
rowbase = widget_base(tlb,/row)
void = widget_button(rowbase,value = 'ACCEPT',uname = 'ACCEPT')
void = widget_button(rowbase,value = 'CANCEL',uname = 'CANCEL')
widget_control,tlb,/realize
state = {	tarray_ptr:ptr_new(/allocate_heap),	$
			cancel:1	}
*state.tarray_ptr = -999
pstate = ptr_new(state,/no_copy)
widget_control,tlb,set_uvalue = pstate
xmanager,'split_scan',tlb,event_handler = 'ss_event'

out = {tarray:*(*pstate).tarray_ptr,cancel:(*pstate).cancel}
heap_free,pstate
return,out
end