; $Id$
;###############################################################################
;
;FILENAME:
;launch_directory_hfbs_summary.pro
;
;PURPOSE:
;           Launch directory_hfbs_summary from DAVE.
;CATEGORY:
;
;
;METHODS IN FILE:
;
;    launch_directory_hfbs_summary
;
;
; AUTHOR:
; Antonio L. Faraone
; NIST Center for Neutron Research
; 100 Bureau Drive, Gaithersburg, MD 20899
; United States
; afaraone@nist.gov  301-975-5254
; Jul 19,2007
;
; LICENSE:
; The software in this file is written by an employee of
; National Institute of Standards and Technology
; as part of the DAVE software project.
;
; The DAVE software package is not subject to copyright protection
; and is in the public domain. It should be considered as an
; experimental neutron scattering data reduction, visualization, and
; analysis system. As such, the authors assume no responsibility
; whatsoever for its use, and make no guarantees, expressed or
; implied, about its quality, reliability, or any other
; characteristic. The use of certain trade names or commercial
; products does not imply any endorsement of a particular product,
; nor does it imply that the named product is necessarily the best
; product for the stated purpose. We would appreciate acknowledgment
; if the DAVE software is used of if the code in this file is
; included in another product.
;
;###############################################################################
;
pro launch_directory_hfbs_summary,event,group_leader=group_leader, workDir=workDir, dataDir=dataDir, _EXTRA=etc
;
;NAME:
;        launch_directory_hfbs_summary
;
;PURPOSE:
;           Launch directory_hfbs_summary from DAVE.
;PARAMETERS:
;           event   Event to launch the module.
;KEYWORDS:
;           None.

    catch, catchError
    if (catchError ne 0) then begin
        ;;print, 'Error handled!'
        eTitle = 'launch_directory_hfbs_summary: Error encountered'
        eMsg = 'An error or unusual condition was encountered!'
        eMsg = [eMsg,'Please, report the following to the DAVE team:']
        eMsg = [eMsg,!error_state.msg]
        void = dialog_message(/error,eMsg,title=eTitle,dialog_parent=event.top)
        catch, /cancel
        return
    endif

    if n_elements(event) eq 0 then begin
         directory_hfbs_summary,group_leader=group_leader,datadir = dataDir,workdir=workDir    
    endif else begin

        ; Launching program for the directory_hfbs_summary module.
        this_event = tag_names(event,/structure_name)
        ;print,this_event
        
        case this_event of
        'WIDGET_BUTTON': $
            begin
                work_dir = (*!dave_defaults).workDir
                data_dir = (*!dave_defaults).datDir
                directory_hfbs_summary,group_leader=event.top,datadir = data_dir,workdir=work_dir
            end
        'WIDGET_TREE_SEL': $
            begin
                device,decomposed = 0
                work_dir = (*!dave_defaults).workDir
                data_dir = (*!dave_defaults).datDir
                directory_hfbs_summary,group_leader=event.top,datadir = data_dir,workdir=work_dir
            end
        else:
        endcase
    endelse
end
