; $Id $
;###############################################################################
;
; NAME:
;  COMBINE_DATA
;
; PURPOSE:
;  Combines data sets.
;
; CATEGORY:
;  DAVE, HFBS, general data utility
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro combine_data,x1,qty1,sig1,x2,qty2,sig2,x,qty,sig
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; Inputs:	x1:		independent var for array 1
;			qty1:	input array 1
;			sig1:	error for qty1
;			x2:		independent var for array 2
;			qty2:	input array 2
;			sig2:	error for qty2
;			x:		independent var for output array
;			qty:	output array
;			sig:	output error
;
; Uses: 	CMSET_OP.PRO by Craig Markwardt
;			DAVE_REBIN.PRO by John Copley
;
; Written by R.M.Dimeo (01/22/02)
;
; Modification History:
; ---------------------
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;nparms = n_params()
nx1 = n_elements(x1) & nx2 = n_elements(x2)
; First create the appended set for future manipulation
xp = [x1,x2] & qtyp = [qty1,qty2] & sigp = [sig1,sig2]
xsort = sort(xp)
;xp = xp[xsort] & qtyp = qtyp[xsort] & sigp = sigp[xsort]
xhi = max(xp) & xlo = min(xp)
npts = n_elements(xp)
;x = hfbs_makepoints(xlo = xlo,xhi = xhi,npts = npts)

; Do the domains overlap?
; overlap = 1 (0) yes (no)
x1min = min(x1,max = x1max)
x2min = min(x2,max = x2max)
overlap = 0
if (((x2max ge x1min) and (x2max le x1max)) or $
   ((x2min le x1max) and (x2min ge x1min))) then overlap = 1
; If they do NOT overlap then return the appended output
if overlap eq 0 then begin
  x = xp[xsort] & qty = qtyp[xsort] & sig = sigp[xsort]
  return
endif

; Ok, we've come this far so some elements must have overlapped.
; For these overlapping elements, sort and append them.  But first,
; find any duplicate elements in xp using Craig Markwardt's routine
; CMSET_OP.PRO
isame = cmset_op(x1,'AND',x2,/index)	; index of same elements
idiff = cmset_op(x1,'XOR',x2,/index)	; index of different elements
same = cmset_op(x1,'AND',x2)			; value of same elements
diff = cmset_op(x1,'XOR',x2)			; value of different elements
duplicate = 1
if same[0] eq -1 then begin
  duplicate = 0
endif

if duplicate eq 1 then begin	; handle duplicate elements here
								; using the least-squares estimate
								; for the errors
  ;print,'Overlap: ',same
  nsame = n_elements(same)
  ndiff = n_elements(diff)
  newx = fltarr(nsame) & newy = fltarr(nsame) & newsig = fltarr(nsame)
  for i = 0,nsame-1 do begin
    sameVal = same[i]
    whereSame = where(xp eq sameVal)

    yin = qtyp[whereSame] & sigin = sigp[whereSame]
    xin = xp[whereSame]
    combine_values,yin,sigin,ycomb,sigcomb
    newy[i] = ycomb & newsig[i] = sigcomb
    newx[i] = sameVal
  endfor
  xout = [xp[idiff],newx]
  yout = [qtyp[idiff],newy]
  sigout = [sigp[idiff],newsig]
  xsort = sort(xout)
  xout = xout[xsort] & yout = yout[xsort] & sigout = sigout[xsort]
  x = xout & qty = yout & sig = sigout
endif

return
end