; $Id$
;###############################################################################
;
; NAME:
;  FWSLEGEND__DEFINE
;
; PURPOSE:
;  Class definition for the legend object in the fixed window scan
;  data analysis module.
;
; CATEGORY:
;  DAVE, HFBS, Fixed Window Scans, Analysis
;
; AUTHOR:
;   Robert M. Dimeo, Ph.D.
;   NIST Center for Neutron Research
;   100 Bureau Drive
;   Gaithersburg, MD 20899
;   Phone: (301) 975-8135
;   E-mail: robert.dimeo@nist.gov
;   http://www.ncnr.nist.gov/staff/dimeo
;
; LICENSE:
;  The software in this file is written by an employee of
;  National Institute of Standards and Technology
;  as part of the DAVE software project.
;
;  The DAVE software package is not subject to copyright protection
;  and is in the public domain. It should be considered as an
;  experimental neutron scattering data reduction, visualization, and
;  analysis system. As such, the authors assume no responsibility
;  whatsoever for its use, and make no guarantees, expressed or
;  implied, about its quality, reliability, or any other
;  characteristic. The use of certain trade names or commercial
;  products does not imply any endorsement of a particular product,
;  nor does it imply that the named product is necessarily the best
;  product for the stated purpose. We would appreciate acknowledgment
;  if the DAVE software is used of if the code in this file is
;  included in another product.
;
;###############################################################################
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegendCleanup,tlb
widget_control,tlb,get_uvalue = self
obj_destroy,self
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend::cleanup
compile_opt idl2,hidden
; This cleanup is executed after fws_analysisCleanup
self.object->emptyLegend
wdelete,self.winPix
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend::dismiss,event = event
widget_control,self.tlb,/destroy
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend::bringToFront,event = event
widget_control,self.tlb,iconify = 0
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend::displayLegend,event = event
wset,self.winPix
self.object->getProperty, nbuffers = nbuffers, filenames = filenames
xpos = 0.05+0.0*findgen(nbuffers)
yhi = 0.95
ylo = 0.05
if nbuffers gt 1 then begin
  dy = (yhi-ylo)/(nbuffers-1.0)
  ypos = yhi-dy*findgen(nbuffers)
endif else begin
  dy = 0.0
  ypos = yhi
endelse
for i = 0,nbuffers-1 do begin
  strout = filenames[i]+':'
  if i eq 0 then begin
    plot,[0.9],[ypos[i]],/normal,psym = fws_myPlotSym(i), $
      xrange = [0.0,1.0],yrange = [0.0,1.0],xstyle = 5,ystyle = 5
  endif else begin
    if i eq 4 then $
      sym = dave_plotSym(/line,scale = 1.5) $
    else $
      sym = fws_myPlotSym(i,scale = 1.5)
    oplot,[0.9],[ypos[i]],psym = sym
  endelse
  xyouts,xpos[i],ypos[i],strout,/normal
endfor
wset,self.winVis
device,copy = [0,0,!d.x_size,!d.y_size,0,0,self.winPix]
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
PRO fwsEventHandler, event
compile_opt idl2,hidden
; Handle the methods
Widget_Control, event.id, Get_UValue=cmd
call_method, cmd.method,cmd.object,event = event
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend::createWidgets
thisTitle = 'Legend for Fixed Window Scan Display'
tlb = widget_base(group_leader = self.group_leader,/col,title = thisTitle)
self.tlb = tlb
xsize = 200 & ysize = 300
self.win = widget_draw(tlb,xsize = xsize, ysize = ysize)
void = widget_button(tlb,value = 'DISMISS', $
	uvalue = {object:self,method:'dismiss'})

widget_control,tlb,/realize
widget_control,self.win,get_value = winVis
self.winVis = winVis
window,/free,/pixmap,xsize = xsize,ysize = ysize
self.winPix = !d.window
widget_control,tlb,set_uvalue = self
xmanager,'fwsLegend::createWidgets',tlb,/no_block, $
		cleanup = 'fwsLegendCleanup', event_handler = 'fwsEventHandler'

end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
function fwsLegend::init,object, group_leader = group_leader
self.object = object
self.group_leader = group_leader
self->createWidgets
self->displayLegend,event = event
return,1
end
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
pro fwsLegend__define
define = {	fwsLegend,				$
			tlb:0L,					$
			win:0L,					$
			winVis:0L,				$
			winPix:0L,				$
			group_leader:0L,		$
			object:obj_new()		$
		 }

end