; $Id$
;
;
; NAME:
;	DenProUnitCellOutline
;
; PURPOSE:
;	This object serves as a graphical representation of an bond,
;	(or sphere), which subclasses from the IDLgrModel class.
;
; CATEGORY:
;	Object graphics.
;
; CALLING SEQUENCE:
;	To initially create:
;	       	oBond = OBJ_NEW('DenProUnitCellOutline') 
;
;	To retrieve a property value:
;		oBond->GetProperty
;
;	To set a property value:
;		oBond->SetProperty
;
;	To print to the standard output stream the current properties of 
;	the bond:
;		oBond->Print
;
;	To destroy:
;		OBJ_DESTROY, oBond
;
; KEYWORD PARAMETERS:
;   DenProUnitCellOutline::INIT:
;	<Note that keywords accepted by IDLgrModel::Init and/or
;	 IDLgrPolygon::Init are also accepted here.>
;	POS:	A three-element vector, [x,y,z], specifying the position
;               of the center of the orb, measured in data units . 
;		Defaults to [0,0,0].

; bondBegin:  A three-element vector, [x,y,z], specifying the position
;               of the beginning of the bond, measured in data units . 
;   Defaults to [0,0,0].
; bondEnd:  A three-element vector, [x,y,z], specifying the position
;               of the end of the bond, measured in data units . 
;   Defaults to [0,0,0].


;	RADIUS: A floating point number representing the radius of the
;               bond (measured in data units).  The default is 1.0.
;	DENSITY: A floating point number representing the density at which
;               the vertices should be generated along the surface of the
;               bond.  The default is 1.0.
;	TEX_COORDS: Set this keyword to a nonzero value if texture map
;               coordinates are to be generated for the bond.
;
;   DenProUnitCellOutline::GETPROPERTY:
; BondBegin:  Set this keyword to a named variable that upon return will
;   contain a three-element vector, [x,y,z], specifying the 
;   position of the beginning of the bond, measured in data units . 
; BondEnd:  Set this keyword to a named variable that upon return will
;   contain a three-element vector, [x,y,z], specifying the 
;   position of the end of the bond, measured in data units . 


;	RADIUS: Set this keyword to a named variable that upon return will
;		contain a floating point number representing the radius of the
;               bond (measured in data units).
;	DENSITY: Set this keyword to a named variable that upon return will
;		contain a floating point number representing the density at 
;		which the vertices are generated along the surface of the
;               bond.
;
;   DenProUnitCellOutline::SETPROPERTY:
;	<Note that keywords accepted by IDLgrModel::SetProperty and/or
;	 IDLgrPolygon::SetProperty are also accepted here.>
;	POS:	A three-element vector, [x,y,z], specifying the position
;               of the center of the orb. Defaults to [0,0,0].
;	RADIUS: A floating point number representing the radius of the
;               orb (measured in data units).  The default is 1.0.
;	DENSITY: A floating point number representing the density at which
;               the vertices should be generated along the surface of the
;               orb.  The default is 1.0.
;
; EXAMPLE:
;	Create an bond centered at the origin with a radius of 0.5:
;		oBond = OBJ_NEW('DenProUnitCellOutline', bondBegin=[0,0,0],bondEnd=[0,0,0],POS=[0,0,0], RADIUS=0.5) 
;

pro DenProUnitCellOutline::calculateVertices,xvals,yvals,zvals

      oABC = self->getByName('ABC')
      oABG = self->getByName('ABG')
      result = oABC->getData(abc)
      result = oABG->getData(abg)

      duh = ThreeDenPro_createVolVertices(abc,abg,corners=corners)
      xvals = corners[0,*]
      yvals = corners[1,*]
      zvals = corners[2,*]
      print,'xvals=',transpose(xvals)
      print,'yvals=',transpose(yvals)
      print,'zvals=',transpose(zvals)
end;DenProUnitCellOutline::calculateVertices


;----------------------------------------------------------------------------
; DenProUnitCellOutline::INIT
;
; Purpose:
;  Initializes an DenProUnitCellOutline object.
;
;  This function returns a 1 if initialization is successful, or 0 otherwise.
;
FUNCTION DenProUnitCellOutline::Init, abc=abc,abg=abg,description=desc,_extra=etc

;void = dialog_message('DenProUnitCellOutline::init')

print,'DenProUnitCellOutline::Init'

;                      duh = ThreeDenPro_createVolVertices(abc,abg,corners=corners)
;                      xvals = corners[0,*]
;                      yvals = corners[1,*]
;                      zvals = corners[2,*]
;print,'xvals=',transpose(xvals)
;print,'yvals=',transpose(yvals)
;print,'zvals=',transpose(zvals)

;
;self->RegisterParameter, 'abc', DESCRIPTION='ABC Values', name='ABC',$
;        /INPUT, TYPES='IDLARRAY', /OPTIONAL, /OPTARGET
;self->RegisterParameter, 'abg', DESCRIPTION='ABG Values', name='ABG',$
;        /INPUT, TYPES='IDLARRAY', /OPTIONAL, /OPTARGET


;POS=pos, bondbegin=bondbegin,bondend=bondend,$
;                           RADIUS=radius, DENSITY=density, $
;                           color=color,$
;                           TEX_COORDS=tex_coords, _EXTRA=e

    ;IF (self->IDLitVisualization::Init(_EXTRA=extra) NE 1) THEN RETURN, 0
    if (not self->IDLitVisualization::Init(name=name $
                                           ,type='DENPROUCOUTLINE' $
                                           ,icon='demo' $
                                           ,description=desc $
                                           ,/MANIPULATOR_TARGET $
                                           ,_EXTRA=etc)) $
      then begin
      
    ;  print,'In IDLitvisbond::init: '
      return, 0
    
    endif

    self.color=[0b,255b,0b]
    self.pos = [0.0,0.0,0.0]
    self.bondbegin = [0.0,0.0,0.0]
    self.bondend =   [1.0,1.0,1.0]
    self.radius = 1.0
    self.density = 1.0
    self.abc = 1.0/(2*!PI)*(fltarr(3)+1)
    self.abg = [90.0,90.0,90.0]


    IF (N_ELEMENTS(pos) EQ 3) THEN $
        self.pos = pos

    IF (N_ELEMENTS(color) EQ 3) THEN begin
    
        ;print,'DenProUnitCellOutline::Init color=',color
        self.color = color

    endif


    IF (N_ELEMENTS(bondbegin) EQ 3) THEN $
        self.bondbegin = bondbegin
    IF (N_ELEMENTS(bondend) EQ 3) THEN $
        self.bondend = bondend


    IF (N_ELEMENTS(radius) EQ 1) THEN $
        self.radius = radius

    IF (N_ELEMENTS(density) EQ 1) THEN $
        self.density = density

    IF (N_ELEMENTS(tex_coords) EQ 1) THEN $
        self.texture = tex_coords

    ; Initialize the polygon object that will be used to represent
    ; the DenProUnitCellOutline.
    self.oPoly = OBJ_NEW('IDLgrPolygon', SHADING=1, /REJECT, _EXTRA=e)
    self.oLine = OBJ_NEW('IDLgrPolyline',_EXTRA=e)


    self->Add,self.oPoly
    self->Add,self.oLine

    ; Build the polygon vertices and connectivity based on property settings.
    self->BuildPoly

    RETURN, 1
END

;----------------------------------------------------------------------------
; DenProUnitCellOutline::CLEANUP
;
; Purpose:
;  Cleans up all memory associated with the DenProUnitCellOutline.
;
PRO DenProUnitCellOutline::Cleanup

    ; Cleanup the polygon object used to represent the DenProUnitCellOutline.
    OBJ_DESTROY, self.oPoly
    OBJ_DESTROY, self.oLine

    ; Cleanup the superclass.
    self->IDLgrModel::Cleanup
END;DenProUnitCellOutline::Cleanup

;----------------------------------------------------------------------------
; DenProUnitCellOutline::SETPROPERTY
;
; Purpose:
;  Sets the value of properties associated with the DenProUnitCellOutline object.
;
PRO DenProUnitCellOutline::SetProperty, $
    DENSITY=density, $
    PARENT=parent, $ ; Pass along to IDLgrModel only.
    bondbegin=bondbegin,$
    bondend=bondend,$
    POS=pos, $
    RADIUS=radius, $
    color=color,$
    abc=abc,$
    abg=abg,$
    _EXTRA=e

    ; Pass along extraneous keywords to the superclass and/or to the
    ; polygon used to represent the orb.
    self->IDLgrModel::SetProperty, _EXTRA=e
    self.oPoly->SetProperty, _EXTRA=e
    self.oLine->SetProperty, _EXTRA=e


    IF (N_ELEMENTS(abc) EQ 3) THEN $
        self.abc = abc
    IF (N_ELEMENTS(abg) EQ 3) THEN $
        self.abg = abg

    if n_elements(color) eq 3 then begin
      self.color=color
    endif

    IF (N_ELEMENTS(pos) EQ 3) THEN $
        self.pos = pos

    IF (N_ELEMENTS(BondBegin) EQ 3) THEN $
        self.bondBegin = BondBegin
    IF (N_ELEMENTS(bondEnd) EQ 3) THEN $
        self.bondEnd = bondEnd


    IF (N_ELEMENTS(radius) EQ 1) THEN $
        self.radius = radius

    IF (N_ELEMENTS(density) EQ 1) THEN $
        self.density = density

    ; Rebuild the polygon according to keyword settings.
    self->BuildPoly
END;DenProUnitCellOutline::SetProperty

;----------------------------------------------------------------------------
; DenProUnitCellOutline::GETPROPERTY
;
; Purpose:
;  Retrieves the value of properties associated with the DenProUnitCellOutline object.
;
PRO DenProUnitCellOutline::GetProperty, POS=pos, RADIUS=radius, DENSITY=density,$
                         bondbegin=bondbegin, bondend=bondend,$
                         POBJ=pobj, lobj=lobj,color=color,abc=abc,abg=abg,_REF_EXTRA=re
;print,'DenProUnitCellOutline::GetProperty,arg_present(color) =',arg_present(color)
    ; Retrieve extra properties from polygon first, then model
    ; so that the model settings (for common keywords) will prevail.
    self.oPoly->GetProperty, _EXTRA=re
    self->IDLgrModel::GetProperty, _EXTRA=re


    color=self.color
    pos = self.pos
    bondend = self.bondend
    bondbegin = self.bondbegin
    radius = self.radius 
    density = self.density 
    pobj = self.oPoly
    lobj = self.oLine
    abc=self.abc
    abg=self.abg
END;DenProUnitCellOutline::GetProperty

PRO DenProUnitCellOutline::Print
    PRINT, 'self.pos=',self.pos
    PRINT, 'self.bondbegin=',self.bondbegin
    PRINT, 'self.bondend=',self.bondend
    PRINT, 'self.redius=',self.radius
    PRINT, 'self.density=',self.density
    PRINT, 'self.abc=',self.abc
    PRINT, 'self.abg=',self.abg

END;DenProUnitCellOutline::Print

;BORROWED FROM g3dview:
;CREATES AN IDLgrPolygon AND AN IDLgrPolyline TO CREATE A CYLINDER TO REPRESENT A BOND.
function DenProUnitCellOutline::g3dviewmakeTube, v0, v1, tubedia, tubecolor, p1, _extra=e

;print,'DenProUnitCellOutline::g3dviewmakeTube'
;help,v0,v1,tubedia,tubecolor,p1,e


    ;  MESH_OBJ params
    p2 = v0
    p3 = v1 - v0

    ;  Calculate the x-product
    ;  You'll have to handle special case where p3==[0,0,1]
    if p3[0] eq 0 and p3[1] eq 0 then begin
    cp = CROSSP(p3,[0.,1.,0.])
    endif else begin
    cp = CROSSP(p3,[0.,0.,1.])
    endelse
    ;  Normalize x-product
    s = SQRT(TOTAL(cp^2))
    cp = cp / s
    ;  Create the line to rotate
    array1 = [[v0],[v1]] - REBIN(tubedia * cp, 3, 2)
    ;  Create the mesh
    MESH_OBJ, 6, verts, polys, array1, P1=p1, P2=p2, P3=p3
    ;MESH_OBJ, 3, verts, polys, array1, P1=p1, P2=p2, P3=p3

    ;  Create a polygon and a line representing the original vector
    if n_elements(tubecolor) ne 3 then tubecolor=[255b,0b,0b]
    ;print,'DenProUnitCellOutline::g3dviewmakeTube, tubecolor=',tubecolor
;help,/traceback
    oTube = OBJ_NEW('IDLgrPolygon', verts, POLYGONS=polys, $
        COLOR=tubecolor, STYLE=2, _extra=e)
    oVec = OBJ_NEW('IDLgrPolyline', [[v0],[v1]], COLOR=tubecolor)

    RETURN, [oTube, oVec]
end;DenProUnitCellOutline::g3dviewmakeTube


;----------------------------------------------------------------------------
; DenProUnitCellOutline::BUILDPOLY
;
; Purpose:
;  Sets the vertex and connectivity arrays for the polygon used to
;  represent the DenProUnitCellOutline.
;
PRO DenProUnitCellOutline::BuildPoly
    ; Build the DenProUnitCellOutline.

    p1=20
    objs = self->g3dviewmakeTube( self.bondbegin,self.bondend, self.radius,self.color, p1);, _extra=e)
;    objs = self->g3dviewmakeTube( [0.0,0.0,0.0], [5.0,5.0,5.0], 1.0, [255,0,0])

;011808
    ;FOR NOW, DESTROY THE OLD OBJECTS AND REPLACE THEM WITH THE NEW ONES.
    ;I DON'T THINK THIS WILL WORK BECAUSE OF THE Z-BUFFER ISSUE, 
    ;BUT USE IT FOR NOW TO GET THINGS ROLLING.
    self->remove,/all
    obj_destroy,self.oPoly
    obj_destroy,self.oLine
    
    self.oPoly = objs[0]
    self.oLine = objs[1]
    self->add,self.oPoly
    self->add,self.oLine
   
END;DenProUnitCellOutline::BuildPoly

;----------------------------------------------------------------------------
; DenProUnitCellOutline__DEFINE
;
; Purpose:
;  Defines the object structure for an DenProUnitCellOutline object.
;
PRO DenProUnitCellOutline__define
    struct = { DenProUnitCellOutline, $
               ;INHERITS IDLgrModel, $
               INHERITS IDLitVisualization, $
               pos: [0.0,0.0,0.0], $
               bondbegin: [0.0,0.0,0.0], $
               bondend: [0.0,0.0,0.0], $
               radius: 1.0, $
               density: 1.0, $
               texture: 0, $
               color:[0b,0b,0b],$
               oPoly: OBJ_NEW(),$
               oLine: OBJ_NEW(),$
               abc:findgen(3),$
               abg:findgen(3) $
             }
END;DenProUnitCellOutline__define







