
;===============================================================================
function Op_AddMolecule::DoAction, oTool,filename=filename,nodata=nodata,oData=oData,oVis=oVis,oParmSet=oParmSet,_extra=extra
compile_opt idl2

if n_elements(oData) ne 0 then begin
        print,'op_AddMolecule::doAction WITH oData:'
        if n_elements(oTool) eq 0 then oTool = getDenProTool() 
        help,oTool,oData

              help,oTool

              oTool->disableUpdates

              ;THIS ADDS ALL THE MOLECULE ITEMS
              createCIF,oTool,oData=oData,oVis=oVis,oParmset=oParmset  ;SEE create3DenProMoleculeHierarchy.pro
              
              
              help,oTool
              print,'Try to refresh'
              ;oTool->enableUpdates
              oTool->refreshCurrentWindow
              print,'Did it refresh???'


endif else begin
              ;help,/traceback
              ;void = dialog_message('Op_AddMolecule::DoAction     Continue:',/question)
              help,oTool

              oTool->disableUpdates

              ;THIS ADDS ALL THE MOLECULE ITEMS
              createCIF,oTool,oParmSet=oParmSet
              
              
              help,oTool
              print,'Try to refresh'
              oTool->enableUpdates
              oTool->refreshCurrentWindow
              print,'Did it refresh???'
              
              
              ;
              ;; Run UI if switched on
              ;self->GetProperty, show_execution_ui=doUI
              ;if (doUI) then begin
              ;    ;; Record initial value for the offset property of this operation.
              ;    ;if (~self->RecordInitialValues(oCmdSet,self,'')) then begin
              ;    ;    obj_destroy, oCmdSet
              ;    ;    return, obj_new()
              ;    ;endif
              ;
              ;    ;; Use the build-in 'PropertySheet' UI service to let the user
              ;    ;; customize the operation's property.
              ;    result =  oTool->DoUIService('PropertySheet',self)
              ;    if (~result) then begin
              ;        ;obj_destroy, oCmdSet
              ;        return, obj_new()
              ;    endif
              ;
              ;    ;; Record final value for the offset property of this operation.
              ;    ;if (~self->RecordFinalValues(oCmdSet,self,'')) then begin
              ;    ;    obj_destroy, oCmdSet
              ;    ;    return, obj_new()
              ;    ;endif
              ;endif
              ;
              ;; Grap current Molecule parameters
              ;pos = [self._xpos,self._ypos,self._zpos]
              ;radius = self._radius
              ;label = self._label
              ;color = self._color
              ;style=self._style
              ;;print,label
              ;
              ;;get the create viz operation:
              ;oCreateVis = oTool->GetService("CREATE_VISUALIZATION")
              ;if (~obj_valid(oCreateVis)) then return, obj_new()
              ;
              ;; create an object descriptor for an Molecule
              ;MoleculeDesc = oTool->getVisualization('MOLECULE')
              ;if (~obj_valid(MoleculeDesc)) then begin
              ;	void = dialog_message('Molecule Visualization not Created!')
              ;	return, obj_new()
              ;endif
              ;
              ;
              ;
              ;; Generate the Molecule:
              ;oCommand = oCreateVis->_Create(MoleculeDesc,name=label,color=color,style=style,radius=radius,pos=pos)
              ;obj_destroy, oCommand           ; no undo/redo for this implementation
              ;
              ;
              ;
              
              print,'Op_AddMolecule::DoAction'
endelse

return, obj_new()               ; don't bother with undo/redo
end;Op_AddMolecule::DoAction




;===============================================================================
pro Op_AddMolecule::GetProperty, xpos=xpos, ypos=ypos, zpos=zpos, radius=radius, label=label, color=color, style=style, $
						         filename=filename, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(filename)) then $
   filename =  self._filename

if (arg_present(label)) then $
   label =  self._label

if (arg_present(color)) then $
   color =  self._color

if (arg_present(style)) then $
   style =  self._style

if (arg_present(xpos)) then $
   xpos =  self._xpos

if (arg_present(ypos)) then $
   ypos =  self._ypos

if (arg_present(zpos)) then $
   zpos =  self._zpos

if (arg_present(radius)) then $
   radius =  self._radius

; call base class accessor
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::GetProperty, _EXTRA=etc



end


;===============================================================================
pro Op_AddMolecule::SetProperty, xpos=xpos, ypos=ypos, zpos=zpos, radius=radius,label=label, color=color, style=style, $
						         filename=filename, _EXTRA=etc


if (n_elements(filename) gt 0) then $
  self._filename = filename

if (n_elements(label) gt 0) then $
  self._label = label

if (n_elements(color) gt 0) then $
  self._color = color

if (n_elements(radius) gt 0) then $
  self._radius = radius

if (n_elements(style) gt 0) then $
  self._style = style

if (n_elements(xpos) gt 0) then $
  self._xpos = xpos

if (n_elements(ypos) gt 0) then $
  self._ypos = ypos

if (n_elements(zpos) gt 0) then $
  self._zpos = zpos

; Call base class mutator
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::SetProperty, _EXTRA=etc

end


;===============================================================================
function Op_AddMolecule::Init, _REF_EXTRA=etc
compile_opt idl2

print,'Op_AddMolecule::Init'
;help,/traceback
;void = dialog_message('Op_AddMolecule::Init      Continue:',/question)



; call superclass init
if (~self->IDLitOperation::Init(NAME='Add Molecule' $
                                ,_EXTRA=etc)) then return, 0

; Unhide the SHOW_EXECUTION_UI property
self->SetPropertyAttribute, 'SHOW_EXECUTION_UI', hide=0

; This operation is reversible
; This operation is not expensive
;self->SetProperty, reversible_operation=1, expensive_operation=0

; Register an operation properties for this operation

self->RegisterProperty, 'filename', /string, description='Molecule Filename' $
  ,name='Filename',sensitive=1
self->RegisterProperty, 'label', /string, description='Molecule Label' $
  ,name='Label',sensitive=1

;self->RegisterProperty, 'radius', /float, description='Radius of Orb' $
;  ,name='Radius',sensitive=1

self->RegisterProperty, 'color', /color, description='Molecule Color' $
  ,name='Color',sensitive=1
self->RegisterProperty, 'style', description='Molecule Style',enumlist=['0','1','2'] $
  ,name='Style',sensitive=1



;FOR THE COMPLETE MOLECULE, THIS COULD BE USED FOR THE REPLICATION OF THE
;PARTS OF THE UNIT CELL.  ONCE CENTERED AT 0,0,0 AND THE NEXT CENTERED AT
;0.5,0.5,0.5
;
;THERE WOULD STILL BE THE ISSUE OF ORIENTATION
;
;
self->RegisterProperty, 'xpos', /float, description='X Location of Molecule' $
  ,name='X Position',sensitive=1
self->RegisterProperty, 'ypos', /float, description='Y Location of Molecule' $
  ,name='Y Position',sensitive=1
self->RegisterProperty, 'zpos', /float, description='Z Location of Molecule' $
  ,name='Z Position',sensitive=1

self._label = ''
self._color=[0b,0b,0b]
self._style=2
; init location to origin
self._xpos = 0.0
self._ypos = 0.0
self._zpos = 0.0

;init radius to 5
;self._radius = 5

; return success
return, 1

end;Op_AddMolecule::Init


;===============================================================================
pro Op_AddMolecule__define
compile_opt idl2

struc = {Op_AddMolecule $
         ,inherits IDLitOperation $
         ,_radius:0.0 $         ;
         ,_xpos:0.0 $           ;
         ,_ypos:0.0 $           ;
         ,_zpos:0.0 $           ;
         ,_label:'' $
         ,_filename:'' $
         ,_style:0 $
         ,_color:[0b,0b,0b] $
        }

end;Op_AddMolecule__define
