
;===============================================================================
function Op_AddClouds::DoAction, oTool
compile_opt idl2

; Run UI if switched on
self->GetProperty, show_execution_ui=doUI
if (doUI) then begin    
    ;; Record initial value for the offset property of this operation.
    ;if (~self->RecordInitialValues(oCmdSet,self,'')) then begin
    ;    obj_destroy, oCmdSet
    ;    return, obj_new()
    ;endif

    ;; Use the build-in 'PropertySheet' UI service to let the user
    ;; customize the operation's property.
    ;result =  oTool->DoUIService('PropertySheet',self)
    filename = self._filename
    filename = DIALOG_PICKFILE(TITLE='Select clouds data file',file=filename)
    if (filename eq '') then begin
        ;obj_destroy, oCmdSet
        return, obj_new()
    endif
    self._filename = filename

    ;; Record final value for the offset property of this operation.
    ;if (~self->RecordFinalValues(oCmdSet,self,'')) then begin
    ;    obj_destroy, oCmdSet
    ;    return, obj_new()
    ;endif
endif

; Grap current orb parameters
filename = self._filename

; Read the data and create a data object
restore, filename               ; contains the variable 'clouds'
;oData = OBJ_NEW('IDLitDataIDLArray3D', clouds, /NO_COPY, NAME=file)
;if (~OBJ_VALID(oData)) then return, obj_new()

; vol dim vector data
;oVolDim = OBJ_NEW('IDLitDataIDLVector', [40.0,40.0,30.0],NAME='volume dimensions')

;add the new data to the Data Manager folder
;oTool->AddByIdentifier, "/Data Manager", [oData,oVolDim]


oParmSet = OBJ_NEW('IDLitParameterSet',NAME='Volume Data Container',ICON='volume', $
        DESCRIPTION='Volume Data Container created by iVolume')
oParmSet->SetAutoDeleteMode, 1b ;; set to autodelete

oData = OBJ_NEW('IDLitDataIDLArray3D', clouds, /NO_COPY, NAME=file)
oParmSet->add, oData, PARAMETER_NAME="Volume0"

oParm = OBJ_NEW('IDLitDataIDLVector', [1,1,0.6],NAME='VOLUME_DIMENSIONS', TYPE='IDLVector')
oParmSet->add, oParm, PARAMETER_NAME="VOLUME_DIMENSIONS"

oParm = OBJ_NEW('IDLitDataIDLVector', [-0.5,0-0.5,-0.3],NAME='VOLUME_LOCATION', TYPE='IDLVector')
oParmSet->add, oParm, PARAMETER_NAME="VOLUME_LOCATION"

oTool->AddByIdentifier, "/Data Manager", oParmSet

;get the create viz operation:
oCreateVis = oTool->GetService("CREATE_VISUALIZATION")
if (~obj_valid(oCreateVis)) then return, obj_new()

; Greate the volume viz
oCommand = oCreateVis->CreateVisualization(oParmSet, 'Volume',id_visualization=idVol,isotropic=1)
obj_destroy, oCommand           ; no undo/redo for this implementation

oVol = oTool->getByIdentifier(idVol)
help,oTool
if (obj_valid(oVol)) then begin
    ; Add color to volume using predefined color table 33 (rainbow)
    oPal = obj_new("IDLgrPalette")
    oPal->loadct,(33)
    oPal->getProperty, blue=blue,green=green,red=red,gamma=gamma
    obj_destroy, oPal
    rgbg = bindgen(4,256)
    rgbg[0,*] = red
    rgbg[1,*] = green
    rgbg[2,*] = blue
    rgbg[3,*] = gamma
    oVol->setProperty, visualization_palette=rgbg
endif

; Add isosurface viz
opID = 'Operations/Operations/Volume/Isosurface'
opDesc = oTool->getByIdentifier(opID)
if (obj_valid(opDesc)) then begin
    op = opDesc->getObjectInstance()
    if (obj_valid(op)) then begin
        op->setProperty, show_execution_ui=0, _isovalue0=0.25
        void = op->doaction(oTool)
        op->setProperty, show_execution_ui=1
    endif
endif 


return, obj_new()               ; don't bother with undo/redo
end


;===============================================================================
pro Op_AddClouds::GetProperty, filename=filename, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(filename)) then $
   filename =  self._filename

; call base class accessor
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::GetProperty, _EXTRA=etc



end


;===============================================================================
pro Op_AddClouds::SetProperty, filename=filename,  _EXTRA=etc

if (n_elements(filename) gt 0) then $
  self._filename = filename

; Call base class mutator
if(n_elements(etc) gt 0) then $
  self->IDLitOperation::SetProperty, _EXTRA=etc 

end


;===============================================================================
function Op_AddClouds::Init, _REF_EXTRA=etc
compile_opt idl2


print,'Beginning          Op_AddClouds::Init'


; call superclass init
if (~self->IDLitOperation::Init(NAME='Add Clouds' $
                                ,_EXTRA=etc)) then return, 0

; Unhide the SHOW_EXECUTION_UI property
self->SetPropertyAttribute, 'SHOW_EXECUTION_UI', hide=1

self->RegisterProperty, 'filename', /string, description='Clouds data filename' $
  ,name='Filename',sensitive=1

self._filename = FILEPATH('clouds3d.dat', SUBDIR=['examples','data'])


print,'Ending          Op_AddClouds::Init'

; return success
return, 1

end


;===============================================================================
pro Op_AddClouds__define
compile_opt idl2

struc = {Op_AddClouds $
         ,inherits IDLitOperation $
         ,_filename:'' $
        }

end
