; $Id$
;
;Following Richard's manual p. 31ff.
;
;

function DAVEReadECHO::IsA,strFilename
compile_opt idl2


  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif
PRINT,'THIS VERSION IS CURRENT AS OF 5/30/08'
  print,'DAVEReadECHO::IsA   -   Checking '+strFilename

  ;CALL THE BASE CLASS READER TO DETERMINE IF THE EXTENSION IS RIGHT.
  if (~self->IDLitReader::IsA(strFilename)) then return,0

  print,'DAVEReadECHO::IsA    -    There is a ECHO or echo EXTENSION.'
  ;FOR THE REAL CHECK I MAY NEED TO SIMPLY READ THE FILE AND SEE WHAT HAPPENS.


  return,1
end;DAVEReadECHO::IsA


;DAVEreadECHO::getData  IS SUPPOSED TO DO ALL OF THE WORK OF READING THE DATA. 
function DAVEreadECHO::getData,oData
compile_opt idl2

print,'DAVEreadECHO::getData'

  catch,err
  if err ne 0 then begin
    catch,/cancel
    return,0
  endif

  oTool = self->getTool()
  if (not obj_valid(oTool)) then return,0
  
  filename = self->getFilename()
  ;NOW I NEED TO CALL threeDenPro_readECHO
  obj = obj_new('ooEchoMagnetic',filename=filename)
  obj->bin,factor=2

  if ~obj_valid(obj) then return,0 else ret = 1

  ;help,obj
  tags = obj->getproperty(tag='tags')
  tagsdata = obj_new('idlitDataIDLVector',tags,name='tags',type='IDLVECTOR')
  magtags = obj->getproperty(tag='magtags')
  magtagsdata = obj_new('idlitDataIDLVector',magtags,name='magtags',type='IDLVECTOR')
  alltags = [tags,magtags]
  alltagsdata = obj_new('idlitDataIDLVector',alltags,name='alltags',type='IDLVECTOR')
  
  types = [ $
          'UNDEFINED',$ 
          'BYTE',$
          'INT',$
          'LONG',$
          'FLOAT',$
          'DOUBLE',$
          'COMPLEX',$
          'STRING',$
          'STRUCT',$
          'DCOMPLEX',$ 
          'POINTER' ,$
          'OBJREF' ,$
          'UINT',$
          'ULONG',$
          'LONG64',$
          'ULONG64']
  
  oData = obj_new('IDLitParameterSet',name=file_basename(filename),identifier='id_'+filename,type='DAVEECHODATASET')

  
  for i=0,n_elements(alltags)-1 do begin
    val = obj->getproperty(tag=alltags[i])
    
    type = size(val,/type)
    print,i,types[type],alltags[i]
    if types[type] eq 'POINTER' then begin
      if ptr_valid(val) gt 0 then begin
        type = size(*val,/type)
        sz = size(*val)
        case sz[0] of
        0:temptype = types[type]
        1:temptype = 'IDLVECTOR'   ;SOME OF THESE WILL BECOME 2D DATA SETS!
        2:temptype = 'IDLARRAY2D'  ;MANY OF THESE WILL NEED TO BE REFORMED IN TO 3D DATA SETS.
        3:temptype = 'IDLARRAY3D'  ;NOW THESE WILL NEED TO BE REFORMED INTO 4D DATA SETS
        else:temptype = types[type]
        endcase 
;        if i eq 8 then val = ptr_new(reform(*val,32,32,31,21))
        tempdata = obj_new('idlitdata',*val,name=alltags[i],type=temptype)
      endif else begin
        val = ptr_new(/allocate_heap)
        tempdata = obj_new('idlitdata',*val,name=alltags[i])
        sz = size(*val)
      endelse
    endif else begin      
        type = size(val,/type)
        sz = size(val)
        case sz[0] of
        0:temptype = types[type]
        1:temptype = 'IDLVECTOR'
        2:temptype = 'IDLARRAY2D'
        3:temptype = 'IDLARRAY3D'
        else:temptype = types[type]
        endcase 
        tempdata = obj_new('idlitdata',val,name=alltags[i],type=types[type])
    endelse
    print,sz
    oData->add,tempdata,parameter_name=alltags[i]

;    print,alltags[i]+" = obj->getproperty(tag=alltags[i])"
;    print,alltags[i]+"data = obj_new('idlitdata'),"+alltags[i]+"name='"+alltags[i]+"',type='"+types[type]+"')"
;    print,"oData->add,"+alltags[i]+"data,parameter_name='"+alltags[i]+"'"
    
    
  endfor;i
  
;  myfilename = obj->getproperty(tag='filename')
;  filenamedata = obj_new('idlitdata',myfilename,name='filename',type='STRING')
;
;
;
;
;  ;NOW I NEED TO CONVERT THIS TO AN OBJECT 
;  ;THE DATA WILL BE PUT INTO oData.
;  oData->add,filenamedata,parameter_name='filename'
;  oData->add,tagsdata,parameter_name='tags'
;  oData->add,magtagsdata,parameter_name='magtags'
;  oData->add,alltagsdata,parameter_name='alltags'


  return,ret

end;DAVEreadECHO::getData


;----------------------------------------------------------------------------
; Purpose:
;   This reader reads ECHO data.
;
function DAVEReadECHO::Init, _Ref_Extra=etc
    compile_opt idl2, hidden

  print,'DAVEReadECHO::Init'
    ; Init superclass
    if (self->IDLitReader::Init(['echo','ECHO'], $
        NAME='NSE Data File', $
        DESCRIPTION="NSE Data File (echo)", $
        _EXTRA=_extra) eq 0) then $
        return, 0

    if n_elements(etc) gt 0 then self->setProperty,_Extra=etc

    return, 1
end;DAVEReadECHO::Init


;---------------------------------------------------------------------------
; Definition
;---------------------------------------------------------------------------
; DAVEReadECHO__Define
;
; Purpose:
; Class definition for the DAVEReadECHO class
;

pro DAVEReadECHO__Define
  ; Pragmas
  compile_opt idl2, hidden
print,'DAVEReadECHO__Define'

  void = {DAVEReadECHO, $
          inherits IDLitReader}
end;DAVEReadECHO__Define


