; $Id$
;###############################################################################
;+
; CLASS_NAME:
;   DenProOPFileOpen
;
; PURPOSE:
;   A general-purpose operations class for initiating a file open
;   action for DenPro. A menu button which opens a file would normally be
;   associated with this operation.
;
; CATEGORY:
;   DAVE Main Tool
;
; SUPERCLASSES:
;   IDLitOpFileOpen
;
; METHODS:
;   DoAction
;   GetfilterList
;   GetProperty
;   SetProperty
;
;-
;###############################################################################


;===============================================================================
; DenProOPFileOpen::GetProperty
; 
; PURPOSE:
;   Accessor method
;
; PARAMETERS:
;
; KEYWORDS:
;   readerNames [out] - The names of readers that should be opened by
;                       an operation created from this class
;
; RETURN VALUE:
;
pro DenProOPFileOpen::GetProperty, readerNames=readerNames, _REF_EXTRA=etc
compile_opt idl2

if (arg_present(readerNames)) then begin
    readerNames =  (ptr_valid(self.readerNames))? (*self.readerNames) : ''
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileOpen::GetProperty, _EXTRA=etc

end;DenProOPFileOpen::GetProperty


;===============================================================================
; DenProOPFileOpen::SetProperty
; 
; PURPOSE:
;   Accessor method
;
; PARAMETERS:
;
; KEYWORDS:
;   readerNames [in] - The names of readers that should be opened by
;                       an operation created from this class
;
; RETURN VALUE:
;
pro DenProOPFileOpen::SetProperty, readerNames=readerNames, _EXTRA=etc
compile_opt idl2

if (n_elements(readerNames) gt 0) then begin
    if (ptr_valid(self.readerNames)) then $
      (*self.readerNames) = readerNames $
    else $
      self.readerNames = ptr_new(readerNames)
endif

if(n_elements(etc) gt 0) then $
  self->IDLitopFileOpen::SetProperty, _EXTRA=etc 

end;DenProOPFileOpen::SetProperty


;===============================================================================
; DenProOPFileOpen::GetFilterList
; 
; PURPOSE:
;   Provide a list of file filters (extensions) that should be handled
;   by the current operation. Method is intended to be called by the
;   UI Service which launches the file selection dialog.
;
; PARAMETERS:
;
; KEYWORDS:
;   count [out] - The number of filter groups (one group per reader
;                 which may actually contain more than one filter)
;
; RETURN VALUE:
;    If successful, an array of reader name/filter(s) pairs
;    If unsuccessful, an empty string.
;
function DenProOPFileOpen::GetFilterList, COUNT=count
compile_opt idl2

oTool = self->GetTool()
oReadFile = oTool->GetService("READ_FILE")
if(not obj_valid(oReadFile))then begin
    count = 0
    return,''
endif

self->GetProperty,readerNames=readerNames

return, oReadFile->GetFilterListByReaderName(readerNames,COUNT=count)

end;DenProOPFileOpen::GetFilterList


;===============================================================================
; DenProOPFileOpen::DoAction
; 
; PURPOSE:
;   Implements the main function for this operation. The main task is
;   to read data from a file (using the appropriate file reader) and
;   place the result in DAVE's public data folder.
;
; PARAMETERS:
;   oTool [in] - the object reference of the tool from which the
;                operation was launched.
;
; KEYWORDS:
;
; RETURN VALUE:
;    If successful, an array of reader name/filter(s) pairs
;    If unsuccessful, an empty string.
;
function DenProOPFileOpen::DoAction, oTool

compile_opt idl2

print,'__________________________________________________________________________________'
print,'__________________________________________________________________________________'
print,'DenProOPFileOpen::DoAction'
print,'__________________________________________________________________________________'
print,'__________________________________________________________________________________'

; Get the File Reader service - provides various useful functionality
;                               for reading data from a file.
oReadFile = oTool->GetService('READ_FILE')
if(not obj_valid(oReadFile))then begin
    errorMsg = 'Unable to access data reading service.'
    errorTitle = 'Internal Error'
    self->ErrorMessage, errorMsg,title=errorTitle, severity=2
    return, obj_new()
endif


; Present a file selection dialog to the user to choose the file to
; be read.
success = oTool->DoUIService('FileOpen', self)
if (success eq 0) then $
  return, obj_new()

; Check to make sure at least one file was indeed selected from the
; preceeding step.
nFiles = N_ELEMENTS(*self._fileNames)
if(nFiles eq 0)then $
  return, obj_new()


;LRK 053008
;FOR NOW STICK EVERYTHING IN THE DAVE DATA MANAGER. 
;THIS IS STILL FOR DEVELOPMENT PHASE.  THE NEXT STEP WILL BE TO PLACE THE DATA INTO denpro.
;
;
; Loop through each selected file, read its contents are place them in
; the DAVE's data folder.
nData =0
for i=0, nFiles-1 do begin
    help,oReadFile

    filename = (*self._fileNames)[i]
print,'___________________________'

print,'*_________________________*'
;help,filename
    status = oReadFile->ReadFile(filename, oData)

    if (status lt 0) then continue ; user hit cancel

    if (status eq 1) then begin


;WHERE IS oVis CREATED?   I HAVE oData, FROM THAT I SHOULD BE ABLE TO CREATE oVis.  BUT, HOW WAS THIS DONE BEFORE??????????    
       oTool->addToDataTree,oData,filename,oVis ;NEED TO DETERMINE DATA TYPE

       ;LRK  061208
       ;THE NEXT SECTION, ADDING TO DAVE DATA MANAGER IS JUST FOR TESTING.
        ;; Add data to the data folder
       DAVETool = getDaveTool()
       if obj_valid(DAVETool) ne 0 then begin
           DAVETool->AddByIdentifier, "DAVE Data Manager", oData
           nData += n_elements(oData)
           DAVETool->_SetDirty, 1     ; indicate tool has been modified
       endif else begin
           print,'No DAVETool Available.'
       endelse
    endif else begin
        self->ErrorMessage, /USE_LAST_ERROR, $
                            title="File Error", severity=2, $
                            ["Error Reading from file:", $
                             (*self._fileNames)[i]]
    endelse
endfor

; We never received any data. Either all of the files were bad,
; or the user hit cancel on some dialog, or we were restoring
; a save state file.
if (nData eq 0) then $
  return, obj_new()

; Usually, the doAction() method will also create a commandset object
; that will contain undo/redo data. The initial state of the (a
; selected) object is saved, the object is modified as requested and
; the final state saved again. Finally the commandset object is
; returned. 
; For now, no commandset object is constructed implying that this
; operation is not subject to the undo/redo functionality.
;
; **** Try adding undo/redo!!!!!!!!!!!!!!!!
return, obj_new()

end;DenProOPFileOpen::DoAction


;===============================================================================
; DenProOPFileOpen::Cleanup
; 
; PURPOSE:
;   DenProOPFileOpen class cleanup
;
pro DenProOPFileOpen::Cleanup

compile_opt idl2

ptr_free, self.readerNames

; call base class cleanup
self->IDLitopFileOpen::Cleanup

end;DenProOPFileOpen::Cleanup

function DenProOpFileOpen::init,_extra=extra
  print,'DenProOpFileOpen::init'
  ret = self->IDLitopFileOpen::init(_extra=extra)  
  return,ret
end;denproopfileopen::init


;===============================================================================
; DenProOPFileOpen__define
; 
; PURPOSE:
;   DenProOPFileOpen class structure definition
;
pro DenProOPFileOpen__define

compile_opt idl2

struc = {DenProOPFileOpen, $
         readerNames:ptr_new(''), $ ; names of readers that should be opened
         inherits IDLitopFileOpen }

end;DenProOPFileOpen__define
